/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/ui/commons/library","sap/ui/core/Configuration"],function(e,t,a){"use strict";var i=t.layout.Separation;var l=t.layout.Padding;var r=t.layout.BackgroundDesign;var n=t.layout.VAlign;var s=t.layout.HAlign;var d={};d.render=function(e,t){var i=a.getRTL();var l=0;var r=0;var n=0;var s=0;var g;var o;var u;var f;var p;var c;var h;e.write('<table role="presentation"');e.writeControlData(t);e.write(' cellpadding="0" cellspacing="0"');e.addStyle("border-collapse","collapse");var w=t.getWidth();if(w){e.addStyle("width",w)}var S=t.getHeight();if(S&&S!="auto"){e.addStyle("height",S);f=d.getValueUnit(S)}if(t.getLayoutFixed()){e.addStyle("table-layout","fixed");if(!w){e.addStyle("width","100%")}}e.addClass("sapUiMlt");e.writeStyles();e.writeClasses();if(t.getTooltip_AsString()){e.writeAttributeEscaped("title",t.getTooltip_AsString())}e.write(">");var v=t.getRows();var y=t.getColumns();if(y<1){for(l=0;l<v.length;l++){g=v[l];o=g.getCells();if(y<o.length){y=o.length}}}if(y>0){var C=t.getWidths();e.write("<colgroup>");for(r=0;r<y;r++){e.write("<col");if(C&&C[r]&&C[r]!="auto"){e.addStyle("width",C[r]);e.writeStyles()}e.write(">")}e.write("</colgroup>")}e.write('<tbody style="width: 100%; height: 100%">');for(l=0;l<v.length;l++){g=v[l];var U=g.getHeight();if(U=="auto"){U=""}if(U&&f){p=d.getValueUnit(U);if(p.Unit=="%"&&f.Unit!="%"){U=f.Value*p.Value/100+f.Unit}}e.write("<tr");e.writeElementData(g);e.writeClasses(g);if(g.getTooltip_AsString()){e.writeAttributeEscaped("title",g.getTooltip_AsString())}e.write(">");o=g.getCells();var M=y;if(y<1){M=o.length}var m=0;if(!g.RowSpanCells){g.RowSpanCells=0}for(r=0;r<M;r++){if(r>=M-m-g.RowSpanCells){break}var R=o[r];e.write("<td");if(U&&(!R||R.getRowSpan()==1)){e.addStyle("height",U)}if(R){e.writeElementData(R);if(R.getTooltip_AsString()){e.writeAttributeEscaped("title",R.getTooltip_AsString())}if(t.getLayoutFixed()&&R.getContent().length>0){e.addStyle("overflow","hidden")}var V=d.getHAlignClass(R.getHAlign(),i);if(V){e.addClass(V)}h=d.getVAlign(R.getVAlign());if(h){e.addStyle("vertical-align",h)}if(R.getColSpan()>1){e.writeAttribute("colspan",R.getColSpan());m=m+R.getColSpan()-1}if(R.getRowSpan()>1){e.writeAttribute("rowspan",R.getRowSpan());var L=0;var b="";for(var A=0;A<R.getRowSpan();A++){var F=v[l+A];if(!F){b=false;break}if(!F.RowSpanCells){F.RowSpanCells=0}if(A>0){F.RowSpanCells=F.RowSpanCells+R.getColSpan()}var x=F.getHeight();if(!x||x=="auto"){b=false}else{var B=d.getValueUnit(x);if(B.Unit=="%"&&f.Unit!="%"){B.Value=f.Value*p.Value/100;B.Unit=f.Unit}if(b==""){b=B.Unit}else if(b!=B.Unit){b=false}L=L+B.Value}}if(b!=false){c=L+b;e.addStyle("height",c)}}e.addClass(d.getBackgroundClass(R.getBackgroundDesign()));e.addClass(d.getSeparationClass(R.getSeparation()));if(!t.getLayoutFixed()||!U){e.addClass(d.getPaddingClass(R.getPadding()));e.addClass("sapUiMltCell")}else{e.addStyle("white-space","nowrap")}e.writeClasses(R)}e.writeStyles();e.write(">");if(R){if(t.getLayoutFixed()&&U){e.write("<div");if(R.getRowSpan()!=1&&c&&c.search("%")==-1){e.addStyle("height",c)}else if(U.search("%")!=-1||R.getRowSpan()!=1&&!c){e.addStyle("height","100%")}else{e.addStyle("height",U)}e.addStyle("display","inline-block");if(h){e.addStyle("vertical-align",h)}e.writeStyles();e.writeClasses(false);e.write("></div>");e.write("<div");e.addStyle("display","inline-block");if(h){e.addStyle("vertical-align",h)}if(R.getRowSpan()!=1&&c&&c.search("%")==-1){e.addStyle("max-height",c)}else if(U.search("%")!=-1||R.getRowSpan()!=1&&!c){e.addStyle("max-height","100%")}else{e.addStyle("max-height",U)}var k="0";var H="";var P="0";u=R.getContent();for(n=0,s=u.length;n<s;n++){if(u[n].getHeight&&u[n].getHeight()!=""){var T=d.getValueUnit(u[n].getHeight());if(T){if(H==""){H=T.Unit}if(H!=T.Unit){H="%";k="100";break}if(T.Unit=="%"){if(parseFloat(k)<parseFloat(T.Value)){k=T.Value;if(k!="100"){P=1e4/parseFloat(k)}}}}}}if(k!="0"){e.addStyle("height",k+H)}e.addStyle("white-space","normal");e.addStyle("width","100%");e.writeStyles();e.writeClasses(false);e.write("><div");e.addStyle("overflow","hidden");e.addStyle("text-overflow","inherit");if(k!="0"){if(P!="0"){e.addStyle("height",P+"%")}else{e.addStyle("height","100%")}}e.addClass("sapUiMltCell");e.addClass(d.getPaddingClass(R.getPadding()));e.writeStyles();e.writeClasses(false);e.write(">")}u=R.getContent();for(n=0,s=u.length;n<s;n++){e.renderControl(u[n])}if(t.getLayoutFixed()&&U){e.write("</div></div>")}}e.write("</td>")}e.write("</tr>");g.RowSpanCells=undefined}e.write("</tbody></table>")};d.getHAlignClass=function(t,a){var i="sapUiMltCellHAlign";switch(t){case s.Begin:return null;case s.Center:return i+"Center";case s.End:return i+(a?"Left":"Right");case s.Left:return a?i+"Left":null;case s.Right:return a?null:i+"Right";default:e(false,"MatrixLayoutRenderer.getHAlign: oHAlign must be a known value");return null}};d.getVAlign=function(t){switch(t){case n.Bottom:return"bottom";case n.Middle:return"middle";case n.Top:return"top";default:e(false,"MatrixLayoutRenderer.getVAlign: oVAlign must be a known value");return null}};d.getBackgroundClass=function(t){switch(t){case r.Border:return"sapUiMltBgBorder";case r.Fill1:return"sapUiMltBgFill1";case r.Fill2:return"sapUiMltBgFill2";case r.Fill3:return"sapUiMltBgFill3";case r.Header:return"sapUiMltBgHeader";case r.Plain:return"sapUiMltBgPlain";case r.Transparent:return null;default:e(false,"MatrixLayoutRenderer.getBackgroundClass: oBackgroundDesign must be a known value");return null}};d.getPaddingClass=function(t){switch(t){case l.None:return"sapUiMltPadNone";case l.Begin:return"sapUiMltPadLeft";case l.End:return"sapUiMltPadRight";case l.Both:return"sapUiMltPadBoth";case l.Neither:return"sapUiMltPadNeither";default:e(false,"MatrixLayoutRenderer.getPaddingClass: oPadding must be a known value");return null}};d.getSeparationClass=function(t){switch(t){case i.None:return null;case i.Small:return"sapUiMltSepS";case i.SmallWithLine:return"sapUiMltSepSWL";case i.Medium:return"sapUiMltSepM";case i.MediumWithLine:return"sapUiMltSepMWL";case i.Large:return"sapUiMltSepL";case i.LargeWithLine:return"sapUiMltSepLWL";default:e(false,"MatrixLayoutRenderer.getSeparationClass: oSeparation must be a known value");return null}};d.getValueUnit=function(e){var t=0;var a="";var i=e.search("px");if(i>-1){a="px";t=parseInt(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("pt");if(i>-1){a="pt";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("in");if(i>-1){a="in";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("mm");if(i>-1){a="mm";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("cm");if(i>-1){a="cm";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("em");if(i>-1){a="em";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("ex");if(i>-1){a="ex";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("%");if(i>-1){a="%";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}};return d},true);
//# sourceMappingURL=MatrixLayoutRenderer.js.map