/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/DataType","sap/ui/base/BindingInfo","sap/ui/core/CustomData","sap/ui/core/Component","./mvc/View","./mvc/ViewType","./mvc/XMLProcessingMode","./mvc/EventHandlerResolver","./ExtensionPoint","./StashedControlSupport","sap/ui/base/SyncPromise","sap/base/Log","sap/base/util/ObjectPath","sap/base/assert","sap/base/util/LoaderExtensions","sap/base/util/JSTokenizer","sap/base/util/each","sap/base/util/isEmptyObject","sap/ui/base/DesignTime","sap/ui/core/Lib"],function(e,t,n,r,i,a,o,s,u,l,c,f,d,p,g,m,v,h,w,b){"use strict";function y(n,r,i,a,o,s){var u=!!s;var l;var c=t.parse(r,a,true,false,false,false,o,u);if(u&&c){s.push(c.resolved);l=c.bindingInfo}else{l=c}if(l&&typeof l==="object"){return l}var d=r=typeof l==="string"?l:r;var p=e.getType(n);if(p){if(p instanceof e){d=p.parseValue(r,{context:a,locals:o});if(!p.isValid(d)){f.error("[FUTURE FATAL] Value '"+r+"' is not valid for type '"+p.getName()+"'.")}}}else{throw new Error("Property "+i+" has unknown type "+n)}return typeof d==="string"?t.escape(d):d}function A(e){return e.localName||e.nodeName}var C="http://www.w3.org/1999/xhtml";var N="http://www.w3.org/2000/xmlns/";var _="http://www.w3.org/2000/svg";var x="sap.ui.core";var M="sap.ui.core.mvc";var E="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var T="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1";var V="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1";var I="http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1";var L="http://schemas.sap.com/sapui5/preprocessorextension/";var P=["controllerName","resourceBundleName","resourceBundleUrl","resourceBundleLocale","resourceBundleAlias"];var R=/^(?:area|base|br|col|embed|hr|img|input|link|meta|param|source|track|wbr)$/;function S(e,t){function n(e,n){var r,i=[];for(var a=0;a<e.childNodes.length;a++){r=t(e,e.childNodes[a],n);if(r){i.push(r.unwrap())}}return c.resolve(i)}function r(e,n){var r=Promise.resolve(),i=[n.chain];for(var a=0;a<e.childNodes.length;a++){r=r.then(t.bind(null,e,e.childNodes[a],n));i.push(r)}return Promise.all(i)}return e?r:n}var U={};U.loadTemplate=function(e,t){var n=e.replace(/\./g,"/")+("."+(t||"view")+".xml");return g.loadResource(n).documentElement};U.loadTemplatePromise=function(e,t){var n=e.replace(/\./g,"/")+("."+(t||"view")+".xml");return g.loadResource(n,{async:true}).then(function(e){return e.documentElement})};U.parseViewAttributes=function(e,t){var n,r;for(n=0;n<e.attributes.length;n++){r=e.attributes[n];if(P.includes(r.name)){t["_"+r.name]=r.value}}};U.enrichTemplateIds=function(e,t){U.enrichTemplateIdsPromise(e,t,false);return e};U.enrichTemplateIdsPromise=function(e,t,n){return j(e,t,true,n).then(function(){return e})};U.parseTemplate=function(e,t,n){return U.parseTemplatePromise(e,t,false,{settings:n}).unwrap()};U.parseTemplatePromise=function(e,t,n,r){return j(e,t,false,n,r).then(function(e){if(t.isA("sap.ui.core.mvc.View")){var n,r;for(r=e.length-1;r>=0;r--){n=e[r];if(n&&n._isExtensionPoint){var i=[r,1].concat(n._aControls);Array.prototype.splice.apply(e,i)}}}return e})};function F(e){var t,n=/^[a-zA-Z_$][a-zA-Z0-9_$]*$/;if(!e||typeof e!=="object"){t="core:require in XMLView can't be parsed to a valid object"}else{Object.keys(e).some(function(r){if(!n.test(r)){t="core:require in XMLView contains invalid identifier: '"+r+"'";return true}if(!e[r]||typeof e[r]!=="string"){t="core:require in XMLView contains invalid value '"+e[r]+"'under key '"+r+"'";return true}return false})}return t}function q(e,t){var n=e.getAttributeNS(x,"require"),r,i,a;if(n){try{r=m.parseJS(n)}catch(t){f.error("Require attribute can't be parsed on Node: ",e.nodeName);throw t}a=F(r);if(a){throw new Error(a+" on Node: "+e.nodeName)}if(!h(r)){i={};if(t){return new Promise(function(e,t){var n=Object.keys(r).reduce(function(e,t){i[t]=sap.ui.require(r[t]);return e&&i[t]!==undefined},true);if(n){e(i);return}sap.ui.require(Object.values(r),function(){var t=arguments;Object.keys(r).forEach(function(e,n){i[e]=t[n]});e(i)},t)})}else{Object.keys(r).forEach(function(e){i[e]=sap.ui.requireSync(r[e])});return c.resolve(i)}}}}function B(e,t,n){var r=c.resolve();if(!h(n)){var i=[];var a;if(e){r=new Promise(function(e){a=e})}Object.keys(n).forEach(function(e){var r=n[e];r.forEach(function(e){e.targetControl=t;var n=sap.ui.require(e.providerClass);if(n){i.push(n.applyExtensionPoint(e))}else{var r=new Promise(function(t,n){sap.ui.require([e.providerClass],function(e){t(e)},n)}).then(function(t){return t.applyExtensionPoint(e)});i.push(r)}})});if(e){Promise.all(i).then(a)}}return r}function X(e,t,n){var r=n;for(var i=0;i<100;i++){var a=e.lookupNamespaceURI(r);if(a==null||a===t){return r}r=n+i}throw new Error("Could not find an unused namespace prefix after 100 tries, giving up")}function j(e,g,m,F,j){var k=[],O=X(e,I,"__ui5"),D=q(e,F)||c.resolve(),H={openStart:function(e,t){k.push(["openStart",[e,t]])},voidStart:function(e,t){k.push(["voidStart",[e,t]])},style:function(e,t){k.push(["style",[e,t]])},class:function(e){k.push(["class",[e]])},attr:function(e,t){k.push(["attr",[e,t]])},openEnd:function(){k.push(["openEnd"])},voidEnd:function(){k.push(["voidEnd"])},text:function(e){k.push(["text",[e]])},unsafeHtml:function(e){k.push(["unsafeHtml",[e]])},close:function(e){k.push(["close",[e]])},renderControl:function(e){k.push(e)}};if(j?.settings?.requireContext){D=D.then(e=>Object.assign({},j.settings.requireContext,e))}F=F&&!!g._sProcessingMode;f.debug("XML processing mode is "+(g._sProcessingMode||"default")+".","","XMLTemplateProcessor");f.debug("XML will be processed "+(F?"asynchronously":"synchronously")+".","","XMLTemplateProcessor");var K=w.isDesignModeEnabled();if(K){g._sapui_declarativeSourceInfo={xmlNode:e,xmlRootNode:g._oContainingView===g?e:g._oContainingView._sapui_declarativeSourceInfo.xmlRootNode}}if(!g.isSubView()){e.setAttributeNS(N,"xmlns:"+O,I)}var W=ee(e,D);var $=0;function z(){for(;$<k.length;$++){var e=k[$];if(e&&typeof e.then==="function"){return e.then(J).then(z)}}return k}function J(e){var t=[$,1].concat(e);Array.prototype.splice.apply(k,t)}return D.then(z).then(function(t){if(W){var n=e.parentNode;n.removeChild(e);if(n.parentNode){n.parentNode.replaceChild(e,n)}}return t});function Z(e){return e}function G(e){return g._oContainingView.createId(e)}function Q(e,t){var n=g.getMetadata().isA("sap.ui.core.mvc.View")?"View":"Fragment";var r=e.outerHTML?e.cloneNode(false).outerHTML:e.textContent;return"Error found in "+n+" (id: '"+g.getId()+"').\nXML node: '"+r+"':\n"+t}function Y(e){var t=A(e),n;if(g.isA("sap.ui.core.mvc.XMLView")&&(e.namespaceURI===C||e.namespaceURI===_)){n=e.ownerDocument.createElementNS(M,"View")}else if(g.isA("sap.ui.core.Fragment")&&(t!=="FragmentDefinition"||e.namespaceURI!==x)){n=e.ownerDocument.createElementNS(x,"FragmentDefinition")}if(n){var r=e.parentNode;if(r){r.replaceChild(n,e)}n.appendChild(e)}return n}function ee(e,t){var n=false,r=g.sViewName||g._sFragmentName,i,a;if(!r){var o=g;var s=0;while(++s<1e3&&o&&o!==o._oContainingView){o=o._oContainingView}r=o.sViewName}i=Y(e);if(i){e=i;n=true}a=A(e);if(g.isA("sap.ui.core.mvc.XMLView")){if(a!=="View"&&a!=="XMLView"||e.namespaceURI!==M){f.error("[FUTURE FATAL] XMLView's root node must be 'View' or 'XMLView' and have the namespace 'sap.ui.core.mvc'"+(r?" (View name: "+r+")":""))}D=t.then(function(){return ae(e,g.getMetadata().getClass(),t,null,{rootArea:true,rootNode:true})})}else{var u=S(F,function(e,t,n){if(t.nodeType===1){return re(t,n.chain,null,undefined,{rootArea:true})}});D=t.then(function(){return u(e,{chain:t})})}return n}function te(e){if(g.fnScopedRunWithOwner){return g.fnScopedRunWithOwner(e)}else{return e()}}function ne(e,t){var n;var r=b.all();v(r,function(r,i){if(e===i.namespace||e===i.name){n=i.name+"."+(i.tagNames&&i.tagNames[t]||t)}});n=n||e+"."+t;function i(e){if(!e){let t=`[FUTURE FATAL] Control '${n}' did not return a class definition from sap.ui.define.`;(()=>{e=d.get(n);if(e){t+=" The control class was instead retrieved via a deprecated access to the global namespace. This fallback behavior will be removed in the next major version (2.0)."}})();f.error(t,"","XMLTemplateProcessor")}return e}var a=n.replace(/\./g,"/");var o=sap.ui.require(a);if(!o){if(!F){o=sap.ui.requireSync(a);o=i(o);return o}return new Promise(function(e,t){sap.ui.require([a],function(t){t=i(t);e(t)},t)})}return o}function re(e,t,n,r,i){var a=i&&i.rootArea,o=i&&i.rootNode&&g.isSubView(),s=A(e),u=a&&(g.isA("sap.ui.core.Fragment")||r&&r.name==="content"),l,d;if(e.nodeType===1){if(e.namespaceURI===C||e.namespaceURI===_){if(a){if(r&&r.name!=="content"){f.error(Q(e,"XHTML nodes can only be added to the 'content' aggregation and not to the '"+r.name+"' aggregation."));return c.resolve([])}if(i&&i.contentBound){throw new Error(Q(e,"No XHTML or SVG node is allowed because the 'content' aggregation is bound."))}var p=e.namespaceURI===C;var v=e.getAttribute("id");if(v!=null){v=se(g,e)}else{v=o?g.getId():undefined}if(s==="style"){var h=e.attributes;var w=e.textContent;e=document.createElement(s);e.textContent=w;for(d=0;d<h.length;d++){var b=h[d];if(!b.prefix){e.setAttribute(b.name,b.value)}}if(v!=null){e.setAttribute("id",v)}if(o){e.setAttribute("data-sap-ui-preserve",g.getId())}H.unsafeHtml(e.outerHTML);return c.resolve([])}var y=R.test(s);if(y){H.voidStart(s,v)}else{H.openStart(s,v)}for(d=0;d<e.attributes.length;d++){var N=e.attributes[d];if(N.name!=="id"&&(N.localName!=="require"||N.namespaceURI!==x)){H.attr(p?N.name.toLowerCase():N.name,N.value)}}if(o){H.attr("data-sap-ui-preserve",g.getId())}if(y){H.voidEnd();if(e.firstChild){f.error("Content of void HTML element '"+s+"' will be ignored")}}else{H.openEnd();var M=q(e,F);if(M){t=c.all([t,M]).then(function(e){return Object.assign({},...e)})}var E=e instanceof HTMLTemplateElement?e.content:e;var T=S(F,function(e,t,n){return re(t,n.chain,n.closestBinding,n.aggregation,n.config)});l=T(E,{chain:t,closestBinding:n,aggregation:r,config:{rootArea:a}});return l.then(function(e){H.close(s);return e.reduce(function(e,t){if(Array.isArray(t)){t.forEach(function(t){e.push(t)})}return e},[])})}}else{var V=e.attributes["id"]?e.attributes["id"].textContent||e.attributes["id"].text:null;if(m){return U.enrichTemplateIdsPromise(e,g,F).then(function(){return[]})}else{var I=function(t,n){var r={id:V?se(g,e,V):undefined,xmlNode:e,requireContext:n,containingView:g._oContainingView,processingMode:g._sProcessingMode};return te(function(){return new t(r)})};return t.then(function(e){if(F){return new Promise(function(t,n){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(n){t([I(n,e)])},n)})}else{var t=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return[I(t,e)]}})}}}else{l=ie(e,t,n);if(u){H.renderControl(l)}return l}}else if(e.nodeType===3&&u){if(!i||!i.contentBound){H.text(e.textContent)}else if(e.textContent.trim()){throw new Error(Q(e,"Text node isn't allowed because the 'content' aggregation is bound."))}}return c.resolve([])}function ie(e,t,n){if(A(e)==="ExtensionPoint"&&e.namespaceURI===x){if(m){return c.resolve([])}else{var r=g instanceof i?g._oContainingView:g;var a=u._factory.bind(null,r,e.getAttribute("name"),function(){var r=c.resolve();var i=[];var a=e.childNodes;for(var o=0;o<a.length;o++){var s=a[o];if(s.nodeType===1){r=r.then(re.bind(null,s,t,n));i.push(r)}}return c.all(i).then(function(e){var t=[];e.forEach(function(e){t=t.concat(e)});return t})},undefined,undefined,F);return c.resolve(te(a))}}else{var o=A(e);var s=o;var l=o.lastIndexOf(".");if(l>=0){s=o.substring(l+1,o.length)}if(/^[a-z].*/.test(s)){var d=g.sViewName||g._sFragmentName||g.getId();f.warning("View or Fragment '"+d+"' contains a Control tag that starts with lower case '"+s+"'",g.getId(),"sap.ui.core.XMLTemplateProcessor#lowerCase")}var p=ne(e.namespaceURI,o);if(p&&typeof p.then==="function"){return p.then(function(r){return ae(e,r,t,n)})}else{return ae(e,p,t,n)}}}function ae(e,u,d,v,w){var b=e.namespaceURI,C={},N={},_="",M=[],R=null,X=null,k=e.getAttribute("stashed")==="true",O=w&&w.rootArea,D=w&&w.rootNode,H;if(!m){e.removeAttribute("stashed")}if(!u){return c.resolve([])}if(D){C.id=g.getId()}var W=u.getMetadata();var $=W.getAllSettings();var z=!O?q(e,F):undefined;if(z){d=c.all([d,z]).then(function(e){return Object.assign({},e[0],e[1])})}d=d.then(function(r){if(h(r)){r=null}H=r;var i=F?[]:undefined;if(!m){for(var a=0;a<e.attributes.length;a++){var o=e.attributes[a],l=o.name,c=o.namespaceURI,d=$[l],v=o.value;if(D&&P.includes(l)){continue}if(l==="id"&&!D){C[l]=se(g,e,v)}else if(l==="class"){_+=v}else if(l==="viewName"){C[l]=v}else if(l==="fragmentName"){C[l]=v;C["containingView"]=g._oContainingView}else if(l==="binding"&&!d||l==="objectBindings"){if(!k){var w=t.parse(v,g._oContainingView.oController);if(w){C.objectBindings=C.objectBindings||{};C.objectBindings[w.model||undefined]=w}}}else if(l==="metadataContexts"){if(!k){var b=null;try{b=U._calculatedModelMapping(v,g._oContainingView.oController,true)}catch(e){f.error("[FUTURE FATAL] "+g+":"+e.message)}if(b){C.metadataContexts=b;if(U._preprocessMetadataContexts){U._preprocessMetadataContexts(u.getMetadata().getName(),C,g._oContainingView.oController)}}}}else if(l.indexOf(":")>-1){c=o.namespaceURI;if(c===E){var N=A(o);M.push(new n({key:N,value:y("any",v,N,g._oContainingView.oController,r,i)}))}else if(c===T){X=v}else if(c&&c.startsWith(L)){f.debug(g+": XMLView parser ignored preprocessor attribute '"+l+"' (value: '"+v+"')")}else if(c===I&&A(o)==="invisible"){d=$.visible;if(d&&d._iKind===0&&d.type==="boolean"){C.visible=false}}else if(c===x||c===I||l.startsWith("xmlns:")){}else{if(!R){R={}}if(!R.hasOwnProperty(o.namespaceURI)){R[o.namespaceURI]={}}R[o.namespaceURI][A(o)]=o.nodeValue;f.debug(g+": XMLView parser encountered unknown attribute '"+l+"' (value: '"+v+"') with unknown namespace, stored as sap-ui-custom-settings of customData")}}else if(d&&d._iKind===0){C[l]=y(d.type,v,l,g._oContainingView.oController,r,i)}else if(d&&d._iKind===1&&d.altTypes){if(!k){C[l]=y(d.altTypes[0],v,l,g._oContainingView.oController,r)}}else if(d&&d._iKind===2){if(!k){var w=t.parse(v,g._oContainingView.oController,false,false,false,false,r);if(w){C[l]=w}else{f.error("[FUTURE FATAL] "+g+": aggregations with cardinality 0..n specifies a non valid BindingInfo (wrong value: "+l+"='"+v+"')")}}}else if(d&&d._iKind===3){if(!k){C[l]=G(v)}}else if(d&&d._iKind===4){if(!k){C[l]=v.split(/[\s,]+/g).filter(Z).map(G)}}else if(d&&d._iKind===5){if(!k){var V=[];s.parse(v).forEach(function(e){var t=s.resolveEventHandler(e,g._oContainingView.oController,r);if(t){V.push(t)}else{f.warning("[FUTURE FATAL] "+g+': event handler function "'+e+'" is not a function or does not exist in the controller.')}});if(V.length){C[l]=V}}}else if(d&&d._iKind===-1){if(W.isA("sap.ui.core.mvc.View")&&l=="async"){C[l]=y(d.type,v,l,g._oContainingView.oController,r)}else{f.warning("[FUTURE FATAL] "+g+": setting '"+l+"' for class "+W.getName()+" (value:'"+v+"') is not supported")}}else{p(l==="xmlns","[FUTURE FATAL] "+g+": encountered unknown setting '"+l+"' for class "+W.getName()+" (value:'"+v+"')");if(U._supportInfo){U._supportInfo({context:e,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+l+"' for class "+W.getName()}})}}}if(R){M.push(new n({key:"sap-ui-custom-settings",value:R}))}if(M.length>0){C.customData=M}}if(Array.isArray(i)){return Promise.all(i).then(function(){return r})}return r}).catch(function(t){if(!t.isEnriched){t=new Error(Q(e,t));t.isEnriched=true;f.error(t)}if(F&&g._sProcessingMode!==o.SequentialLegacy){throw t}});var J=S(F,Y);function Y(e,t,n){var r=n.aggregation,i=n.allAggregations,a=n.chain,o=n.closestBinding,s=n.config,u,f;if(t.nodeType===1){if(t.namespaceURI===V){C[A(t)]=t.querySelector("*");return undefined}u=t.namespaceURI===b&&i&&i[A(t)];if(u){return J(t,{aggregation:u,allAggregations:null,chain:a,closestBinding:o,config:s})}else if(r){if(t.getAttribute("stashed")==="true"&&!m){var d=t;t=t.cloneNode();d.removeAttribute("stashed");f=function(){var n=se(g,t);l.createStashedControl({wrapperId:n,fnCreate:function(){var t=F;F=false;try{return Y(e,d,{aggregation:r,allAggregations:i,chain:c.resolve(H),closestBinding:o}).unwrap()}finally{F=t}}})};te(f);t.removeAttribute("visible");oe(t,"invisible")}if(C[r.name]&&typeof C[r.name].path==="string"){o={aggregation:r.name,id:C.id};if(D&&r.name==="content"){s=s||{};s.contentBound=true}}return re(t,a,o,r,s).then(function(e){for(var t=0;t<e.length;t++){var n=e[t];var i=r.name;if(n._isExtensionPoint){if(!C[i]){C[i]=[]}var a=N[i];if(!a){a=N[i]=[]}n.index=C[i].length;n.aggregationName=i;n.closestAggregationBindingCarrier=o&&o.id;n.closestAggregationBinding=o&&o.aggregation;var s=a[a.length-1];if(s){s._nextSibling=n}a.push(n)}else if(r.multiple){if(!C[i]){C[i]=[]}if(typeof C[i].path==="string"){p(!C[i].template,"list bindings support only a single template object");C[i].template=n}else{C[i].push(n)}}else{p(!C[i],"multiple aggregates defined for aggregation with cardinality 0..1");C[i]=n}}return e})}else{throw new Error(Q(t,"Cannot add direct child without default aggregation defined for control "+W.getElementName()))}}else if(t.nodeType===3){if(s&&s.rootArea){re(t,a,o,r,s)}else{var v=t.textContent||t.text;if(v&&v.trim()){throw new Error(Q(t,"Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed."))}}}}var ee=W.getDefaultAggregation();var ne=W.getAllAggregations();return J(e,{aggregation:ee,allAggregations:ne,chain:d,closestBinding:v,config:w}).then(function(){var t;var n=c.resolve();var o=c.resolve();var s=e.getAttribute("type");var l=r.getOwnerComponentFor(g);var f=l&&l.isA("sap.ui.core.IAsyncContentCreation");if(m){if(!O&&e.hasAttribute("id")){ue(g,e)}}else if(!D&&u.getMetadata().isA("sap.ui.core.mvc.View")){if(!u._sType&&!C.viewName){C.viewName="module:"+u.getMetadata().getName().replace(/\./g,"/")}C.type=u._sType||s;if(f&&F){if(C.async===false){throw new Error("A nested view contained in a Component implementing 'sap.ui.core.IAsyncContentCreation' is processed asynchronously by default and cannot be processed synchronously.\n"+"Affected Component '"+l.getMetadata().getComponentName()+"' and View '"+C.viewName+"'.")}o=te(function(){return i.create(C)})}else{if(u.getMetadata().isA("sap.ui.core.mvc.XMLView")&&g._sProcessingMode){C.processingMode=g._sProcessingMode}var d=i._getViewClassName(C,true);if(F&&d){o=new Promise(function(e,t){sap.ui.require([d],e,t)}).then(function(){return te(function(){return i._create(C)})})}else{t=te(function(){return i._create(C)})}}}else if(u.getMetadata().isA("sap.ui.core.Fragment")&&F){if(s!==a.JS){C.processingMode=g._sProcessingMode}var p="sap/ui/core/Fragment";var v=sap.ui.require(p);C.name=C.name||C.fragmentName;if(v){o=v.load(C)}else{o=new Promise(function(e,t){sap.ui.require([p],function(t){t.load(C).then(function(t){e(t)})},t)})}}else{var h=function(){var e;if(D){e=g;if(!F){if(j&&j.settings){Object.keys(C).forEach(function(e){if(j.settings.hasOwnProperty(e)){j.settings[e]=C[e];delete C[e]}})}}g.applySettings(C)}else{e=te(function(){var e=new u(C);return e})}n=B(F,e,N);return e};if(j&&j.fnRunWithPreprocessor){t=j.fnRunWithPreprocessor(h)}else{t=h()}}return o.then(function(e){return e||t}).then(function(t){if(_&&t.addStyleClass){t.addStyleClass(_)}if(!t){t=[]}else if(!Array.isArray(t)){t=[t]}if(U._supportInfo&&t){for(var r=0,i=t.length;r<i;r++){var a=t[r];if(a&&a.getId()){var o=U._supportInfo({context:e,env:{caller:"createRegularControls",nodeid:e.getAttribute("id"),controlid:a.getId()}}),s=X?X+",":"";s+=o;U._supportInfo.addSupportInfo(a.getId(),s)}}}if(K){t.forEach(function(t){if(W.getCompositeAggregationName){var n=e.getElementsByTagName(t.getMetadata().getCompositeAggregationName());for(var r=0;r<n.length;r++){e.removeChild(n[0])}}t._sapui_declarativeSourceInfo={xmlNode:e,xmlRootNode:g._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:W.getName()==="sap.ui.core.Fragment"?C["fragmentName"]:null}})}return n.then(function(){return t})})})}function oe(e,t){var n=X(e,I,O);e.setAttributeNS(I,n+":"+t,"true")}function se(e,t,n){if(t.getAttributeNS(I,"id")){return t.getAttribute("id")}else{return G(n?n:t.getAttribute("id"))}}function ue(e,t){t.setAttribute("id",G(t.getAttribute("id")));oe(t,"id")}}U._preprocessMetadataContexts=null;U._calculatedModelMapping=function(e,n,r){var i,a={},o=t.parse(e,n);function s(e){if(e.length%2===0){throw new Error("The last entry is no binding")}for(var t=1;t<=e.length;t=t+2){if(typeof e[t-1]=="string"){throw new Error("Binding expected not a string")}if(e[t]){if(typeof e[t]!="string"||e[t]!=","){throw new Error("Missing delimiter ','")}}}}if(o){if(!o.formatter){i=o;o={parts:[i]}}else{s(o.formatter.textFragments)}for(var u=0;u<o.parts.length;u++){i=o.parts[u];a[i.model]=a[i.model]||(r?[]:null);if(Array.isArray(a[i.model])){a[i.model].push(i)}else{a[i.model]=i}}}return a};return U},true);
//# sourceMappingURL=XMLTemplateProcessor.js.map