/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/base/EventProvider","sap/base/assert","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/core/Element","sap/ui/dom/jquery/Selectors"],function(e,t,s,i,o,jQuery,a){"use strict";var n=t.extend("sap.ui.core.delegate.ItemNavigation",{constructor:function(e,s,i){t.apply(this);this.oDomRef=null;if(e){this.setRootDomRef(e)}this.aItemDomRefs=[];if(s){this.setItemDomRefs(s)}this.iTabIndex=-1;this.iActiveTabIndex=i?-1:0;this.iFocusedIndex=-1;this.iSelectedIndex=-1;this.bCycling=true;this.bTableMode=false;this.iPageSize=-1;this._bMouseDownHappened=false;this.oDisabledModifiers={sapend:["alt","shift"],saphome:["alt","shift"]}}});n.Events={BeforeFocus:"BeforeFocus",AfterFocus:"AfterFocus",BorderReached:"BorderReached",FocusAgain:"FocusAgain",FocusLeave:"FocusLeave"};n.prototype.setDisabledModifiers=function(e){this.oDisabledModifiers=e;return this};n.prototype.getDisabledModifiers=function(e){return this.oDisabledModifiers};n.prototype.hasDisabledModifier=function(e){var t=this.oDisabledModifiers[e.type.replace("modifiers","")];if(Array.isArray(t)){for(var s=0;s<t.length;s++){if(e[t[s]+"Key"]){return true}}}return false};n.prototype.setRootDomRef=function(e){this.oDomRef=e;if(!jQuery(this.oDomRef).data("sap.INItem")){if(this.iFocusedIndex>=0){jQuery(this.oDomRef).attr("tabindex",this.iTabIndex)}else{jQuery(this.oDomRef).attr("tabindex",this.iActiveTabIndex)}}jQuery(this.oDomRef).data("sap.INRoot",this);return this};n.prototype.getRootDomRef=function(){return this.oDomRef};n.prototype.getItemDomRefs=function(){return this.aItemDomRefs};n.prototype.setItemDomRefs=function(e){s(typeof e==="object"&&typeof e.length==="number","aItemDomRefs must be an array of DOM elements");this.aItemDomRefs=e;if(this.iFocusedIndex>-1){var t=e.length;if(this.iFocusedIndex>t-1){this.iFocusedIndex=t-1}var i=document.activeElement;if(i&&i!=this.aItemDomRefs[this.iFocusedIndex]){for(var o=0;o<t;o++){if(i==this.aItemDomRefs[o]){this.iFocusedIndex=o;break}}}}for(var o=0;o<this.aItemDomRefs.length;o++){if(this.aItemDomRefs[o]){var a=jQuery(this.aItemDomRefs[o]);if(o==this.iFocusedIndex&&!a.data("sap.INRoot")){a.attr("tabindex",this.iActiveTabIndex)}else if(a.attr("tabindex")=="0"){a.attr("tabindex",-1)}a.data("sap.INItem",true);a.data("sap.InNavArea",true);if(a.data("sap.INRoot")&&o!=this.iFocusedIndex){a.data("sap.INRoot").setNestedItemsTabindex()}}}return this};n.prototype.setItemsTabindex=function(){for(var e=0;e<this.aItemDomRefs.length;e++){if(this.aItemDomRefs[e]){var t=jQuery(this.aItemDomRefs[e]);if(t.is(":sapFocusable")){if(e==this.iFocusedIndex&&!t.data("sap.INRoot")){t.attr("tabindex",this.iActiveTabIndex)}else{t.attr("tabindex",-1)}}}}return this};n.prototype.setNestedItemsTabindex=function(){if(jQuery(this.oDomRef).data("sap.INItem")){for(var e=0;e<this.aItemDomRefs.length;e++){if(this.aItemDomRefs[e]&&jQuery(this.aItemDomRefs[e]).attr("tabindex")=="0"){jQuery(this.aItemDomRefs[e]).attr("tabindex",-1)}}}return this};n.prototype.destroy=function(){if(this.oDomRef){jQuery(this.oDomRef).removeData("sap.INRoot");this.oDomRef=null}if(this.aItemDomRefs){for(var e=0;e<this.aItemDomRefs.length;e++){if(this.aItemDomRefs[e]){jQuery(this.aItemDomRefs[e]).removeData("sap.INItem");jQuery(this.aItemDomRefs[e]).removeData("sap.InNavArea")}}this.aItemDomRefs=null}this._bItemTabIndex=undefined;this.iFocusedIndex=-1};n.prototype.setCycling=function(e){this.bCycling=e;return this};n.prototype.setTableMode=function(e,t){this.bTableMode=e;this.bTableList=e?t:false;return this};n.prototype.setPageSize=function(e){this.iPageSize=e;return this};n.prototype.setSelectedIndex=function(e){this.iSelectedIndex=e;return this};n.prototype.setColumns=function(e,t){this.iColumns=e;this.bNoColumnChange=t;return this};n.prototype.setHomeEndColumnMode=function(e,t){this._bStayInRow=e;this._bCtrlEnabled=t;return this};n.prototype.focusItem=function(t,s,a){i.info("FocusItem: "+t+" iFocusedIndex: "+this.iFocusedIndex,"focusItem","ItemNavigation");if(t==this.iFocusedIndex&&this.aItemDomRefs[this.iFocusedIndex]==document.activeElement){this.fireEvent(n.Events.FocusAgain,{index:t,event:s});return}if(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){if(this.bTableMode){var h=t%this.iColumns;var f=t;if(s&&s.keyCode==o.ARROW_RIGHT){if(h<this.iColumns-1){t+=e.getRTL()?-1:1}}else if(s&&s.keyCode==o.ARROW_LEFT){if(h>1){t-=e.getRTL()?-1:1}}else{if(h>1){t-=1}}if(t!=f){this.focusItem(t,s)}}return}if(!this.fireEvent(n.Events.BeforeFocus,{index:t,event:s},true)){i.info("Focus prevented on ID: "+this.aItemDomRefs[this.iFocusedIndex].id,"focusItem","ItemNavigation");return}this.setFocusedIndex(t);this.bISetFocus=true;if(s&&jQuery(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot")){var r=jQuery(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot");r._sFocusEvent=s.type}i.info("Set Focus on ID: "+this.aItemDomRefs[this.iFocusedIndex].id,"focusItem","ItemNavigation");this.aItemDomRefs[this.iFocusedIndex].focus({preventScroll:a});this.fireEvent(n.Events.AfterFocus,{index:t,event:s})};n.prototype.setFocusedIndex=function(e){var t;if(this.aItemDomRefs.length<0){this.iFocusedIndex=-1;return this}if(e<0){e=0}if(e>this.aItemDomRefs.length-1){e=this.aItemDomRefs.length-1}jQuery(this.oDomRef).attr("tabindex",this.iTabIndex);if(this.iFocusedIndex!==-1&&this.aItemDomRefs.length>this.iFocusedIndex){jQuery(this.aItemDomRefs[this.iFocusedIndex]).attr("tabindex",-1);t=jQuery(this.aItemDomRefs[this.iFocusedIndex]);if(t.data("sap.INRoot")&&e!=this.iFocusedIndex){jQuery(t.data("sap.INRoot").aItemDomRefs[t.data("sap.INRoot").iFocusedIndex]).attr("tabindex",-1)}}this.iFocusedIndex=e;var s=this.aItemDomRefs[this.iFocusedIndex];t=jQuery(this.aItemDomRefs[this.iFocusedIndex]);if(!t.data("sap.INRoot")){jQuery(s).attr("tabindex",this.iActiveTabIndex)}return this};n.prototype.getFocusedDomRef=function(){return this.aItemDomRefs[this.iFocusedIndex]};n.prototype.getFocusedIndex=function(){return this.iFocusedIndex};n.prototype.onfocusin=function(e){var t=e.target;var s=0;if(t==this.oDomRef){if(!this._bItemTabIndex){this.setItemsTabindex();this._bItemTabIndex=true}if(this._bMouseDownHappened){return}var i;if(jQuery(this.oDomRef).data("sap.INItem")&&this._sFocusEvent&&!jQuery(this.oDomRef).data("sap.InNavArea")){switch(this._sFocusEvent){case"sapnext":i=0;break;case"sapprevious":i=this.aItemDomRefs.length-1;break;default:if(this.iSelectedIndex!=-1){i=this.iSelectedIndex}else if(this.iFocusedIndex!=-1){i=this.iFocusedIndex}else{i=0}break}this._sFocusEvent=undefined}else{if(this.iSelectedIndex!=-1){i=this.iSelectedIndex}else if(this.iFocusedIndex!=-1){i=this.iFocusedIndex}else{i=0}}this.focusItem(i,e);if(this.iFocusedIndex==-1){for(s=i+1;s<this.aItemDomRefs.length;s++){this.focusItem(s,e);if(this.iFocusedIndex==s){break}}if(this.iFocusedIndex==-1&&i>0){for(s=i-1;s>=0;s--){this.focusItem(s,e);if(this.iFocusedIndex==s){break}}}}e.preventDefault();e.stopPropagation()}else if(!this.bISetFocus){if(this.aItemDomRefs&&e.target!=this.aItemDomRefs[this.iFocusedIndex]){for(s=0;s<this.aItemDomRefs.length;s++){if(e.target==this.aItemDomRefs[s]){this.focusItem(s,e);break}}}else{this.fireEvent(n.Events.AfterFocus,{index:this.iFocusedIndex,event:e})}}this.bISetFocus=false};n.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!this.oDomRef||!this.oDomRef.contains(a.getElementById(e.relatedControlId).getFocusDomRef())){var t;if(this.iSelectedIndex!=-1){t=this.iSelectedIndex}else if(this.iFocusedIndex!=-1){t=this.iFocusedIndex}else{t=0}this.setFocusedIndex(t);var s;if(jQuery(this.oDomRef).data("sap.INItem")){var i;s=jQuery(this.oDomRef);while(!i){s=s.parent();if(s.data("sap.INRoot")){i=s.get(0)}}if(!e.relatedControlId||i.contains(a.getElementById(e.relatedControlId).getFocusDomRef())){jQuery(this.aItemDomRefs[this.iFocusedIndex]).attr("tabindex",-1)}}s=jQuery(this.oDomRef);if(s.data("sap.InNavArea")===false){s.data("sap.InNavArea",true)}this.fireEvent(n.Events.FocusLeave,{index:t,event:e})}};n.prototype.onmousedown=function(e){var t=e.target;var s=function(e,t){var s=false;var i=jQuery(e);while(!i.is(":sapFocusable")&&i.get(0)!=t){i=i.parent()}if(i.get(0)!=t){s=true}return s};if(this.oDomRef&&this.oDomRef.contains(t)){for(var i=0;i<this.aItemDomRefs.length;i++){var o=this.aItemDomRefs[i];if(o&&o.contains(t)){if(!this.bTableMode){this.focusItem(i,e,true)}else{if(o===t||!s(t,o)){this.focusItem(i,e,true)}}return}}if(t==this.oDomRef){this._bMouseDownHappened=true;var a=this;window.setTimeout(function(){a._bMouseDownHappened=false},20)}}};n.prototype.onsapnext=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(jQuery(this.oDomRef).data("sap.InNavArea")){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=this.iFocusedIndex,s=true,i=false;if(t>-1){if(this.bTableMode){var a=this.aItemDomRefs.length/this.iColumns,h=Math.floor(t/this.iColumns),f=t%this.iColumns;if(e.keyCode==o.ARROW_DOWN){if(h<a-1){t+=this.iColumns}}else{if(f<this.iColumns-1){t+=1}}}else{do{if(this.iColumns>1&&e.keyCode==o.ARROW_DOWN){if(t+this.iColumns>=this.aItemDomRefs.length){if(!this.bNoColumnChange){if(t%this.iColumns<this.iColumns-1){t=t%this.iColumns+1}else if(this.bCycling){t=0}}else{t=this.iFocusedIndex;i=true}}else{t=t+this.iColumns}}else{if(t==this.aItemDomRefs.length-1){if(jQuery(this.oDomRef).data("sap.INItem")){return}else if(this.bCycling){t=0}else{t=this.iFocusedIndex;i=true}}else{t++}}if(t===this.iFocusedIndex){if(s){s=false}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the next one")}}}while(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable"))}this.focusItem(t,e);if(i){this.fireEvent(n.Events.BorderReached,{index:t,event:e})}e.preventDefault();e.stopPropagation()}};n.prototype.onsapnextmodifiers=function(e){if(this.hasDisabledModifier(e)){return}this.onsapnext(e)};n.prototype.onsapprevious=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(jQuery(this.oDomRef).data("sap.InNavArea")){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=this.iFocusedIndex,s=true,i=false;var a=0;if(t>-1){if(this.bTableMode){var h=Math.floor(t/this.iColumns);a=t%this.iColumns;if(e.keyCode==o.ARROW_UP){if(h>0){t-=this.iColumns}}else{if(a>0){t-=1}}}else{do{if(this.iColumns>1&&e.keyCode==o.ARROW_UP){if(t-this.iColumns<0){if(!this.bNoColumnChange){a=0;if(t%this.iColumns>0){a=t%this.iColumns-1}else if(this.bCycling){a=Math.min(this.iColumns-1,this.aItemDomRefs.length-1)}if(t===0&&a===0){t=0}else{var f=Math.ceil(this.aItemDomRefs.length/this.iColumns);t=a+(f-1)*this.iColumns;if(t>=this.aItemDomRefs.length){t=t-this.iColumns}}}else{t=this.iFocusedIndex;i=true}}else{t=t-this.iColumns}}else{if(t==0){if(jQuery(this.oDomRef).data("sap.INItem")){return}else if(this.bCycling){t=this.aItemDomRefs.length-1}else{t=this.iFocusedIndex;i=true}}else{t--}}if(t==this.iFocusedIndex){if(s){s=false}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the previous one")}}}while(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable"))}this.focusItem(t,e);if(i){this.fireEvent(n.Events.BorderReached,{index:t,event:e})}e.preventDefault();e.stopPropagation()}};n.prototype.onsappreviousmodifiers=function(e){if(this.hasDisabledModifier(e)){return}this.onsapprevious(e)};n.prototype.onsappageup=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=0;var s=false;if(this.iPageSize>0){t=this.iFocusedIndex;if(t>-1){t=t-this.iPageSize;while(t>0&&!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){t--}if(t<0){if(!this.bNoColumnChange){t=0}else{t=this.iFocusedIndex;s=true}}this.focusItem(t,e)}}else if(this.bTableMode){t=this.iFocusedIndex%this.iColumns;this.focusItem(t,e)}if(s){this.fireEvent(n.Events.BorderReached,{index:t,event:e})}e.preventDefault();e.stopPropagation()};n.prototype.onsappagedown=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=0;var s=false;if(this.iPageSize>0){t=this.iFocusedIndex;if(t>-1){t=t+this.iPageSize;while(t<this.aItemDomRefs.length-1&&!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){t++}if(t>this.aItemDomRefs.length-1){if(!this.bNoColumnChange){t=this.aItemDomRefs.length-1}else{t=this.iFocusedIndex;s=true}}this.focusItem(t,e)}}else if(this.bTableMode){var i=this.aItemDomRefs.length/this.iColumns,o=this.iFocusedIndex%this.iColumns;t=(i-1)*this.iColumns+o;this.focusItem(t,e)}if(s){this.fireEvent(n.Events.BorderReached,{index:t,event:e})}e.preventDefault();e.stopPropagation()};n.prototype.onsaphome=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=0;var s=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){s=Math.floor(this.iFocusedIndex/this.iColumns);t=s*this.iColumns}}else{if((e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){s=Math.floor(this.iFocusedIndex/this.iColumns);t=s*this.iColumns}else{while(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){t++;if(t==this.aItemDomRefs.length){return}}}}this.focusItem(t,e);e.preventDefault();e.stopPropagation()};n.prototype.onsaphomemodifiers=function(e){if(this.hasDisabledModifier(e)){return}this.onsaphome(e)};n.prototype.onsapend=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=this.aItemDomRefs.length-1;var s=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){s=Math.floor(this.iFocusedIndex/this.iColumns);t=s*this.iColumns+this.iColumns-1}}else{if((e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){s=Math.floor(this.iFocusedIndex/this.iColumns);t=(s+1)*this.iColumns-1;if(t>=this.aItemDomRefs.length){t=this.aItemDomRefs.length-1}}else{while(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){t--;if(t<0){return}}}}this.focusItem(t,e);e.preventDefault();e.stopPropagation()};n.prototype.onsapendmodifiers=function(e){if(this.hasDisabledModifier(e)){return}this.onsapend(e)};n.prototype.setTabIndex0=function(){this.iTabIndex=0;this.iActiveTabIndex=0};n.prototype.onkeyup=function(e){if(e.keyCode==o.F2){var t=jQuery(this.oDomRef);if(t.data("sap.InNavArea")){t.data("sap.InNavArea",false)}else if(t.data("sap.InNavArea")===false){t.data("sap.InNavArea",true)}e.preventDefault();e.stopPropagation()}};return n});
//# sourceMappingURL=ItemNavigation.js.map