//@ui5-bundle sap/ui/core/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.act", ["sap/ui/util/ActivityDetection","jquery.sap.global"],function(t,jQuery){"use strict";jQuery.sap.act=t;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.dom", ["jquery.sap.global","sap/ui/dom/containsOrEquals","sap/ui/core/syncStyleClass","sap/ui/dom/getOwnerWindow","sap/ui/dom/getScrollbarSize","sap/ui/dom/denormalizeScrollLeftRTL","sap/ui/dom/denormalizeScrollBeginRTL","sap/ui/dom/units/Rem","sap/ui/dom/jquery/Aria","sap/ui/dom/jquery/Selection","sap/ui/dom/jquery/zIndex","sap/ui/dom/jquery/parentByAttribute","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/selectText","sap/ui/dom/jquery/getSelectedText","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/rectContains","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/hasTabIndex","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/Selectors"],function(jQuery,e,r,o,u,s,t,a){"use strict";jQuery.sap.domById=function e(r,o){return r?(o||window).document.getElementById(r):null};jQuery.sap.byId=function e(r,o){var u="";if(r){u="#"+r.replace(/(:|\.)/g,"\\$1")}return jQuery(u,o)};jQuery.sap.focus=function e(r){if(!r){return}r.focus();return true};jQuery.sap.pxToRem=a.fromPx;jQuery.sap.remToPx=a.toPx;jQuery.fn.outerHTML=function(){var e=this.get(0);if(e&&e.outerHTML){return e.outerHTML.trim()}else{var r=this[0]?this[0].ownerDocument:document;var o=r.createElement("div");o.appendChild(e.cloneNode(true));return o.innerHTML}};jQuery.sap.containsOrEquals=e;jQuery.sap.denormalizeScrollLeftRTL=s;jQuery.sap.denormalizeScrollBeginRTL=t;
/*
	 * The following implementation of jQuery.support.selectstart is taken from jQuery UI core but modified.
	 *
	 * jQuery UI Core
	 * http://jqueryui.com
	 *
	 * Copyright 2014 jQuery Foundation and other contributors
	 * Released under the MIT license.
	 * http://jquery.org/license
	 *
	 * http://api.jqueryui.com/category/ui-core/
	 */jQuery.support.selectstart="onselectstart"in document.createElement("div");jQuery.sap.ownerWindow=o;jQuery.sap.scrollbarSize=u;jQuery.sap.syncStyleClass=r;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.encoder", ["jquery.sap.global","sap/base/security/encodeXML","sap/base/security/encodeJS","sap/base/security/encodeURL","sap/base/security/encodeURLParameters","sap/base/security/encodeCSS","sap/base/security/URLListValidator","sap/base/security/URLWhitelist","sap/base/security/sanitizeHTML"],function(jQuery,e,s,a,t,i,r,c,p){"use strict";jQuery.sap.encodeHTML=e;jQuery.sap.encodeXML=e;jQuery.sap.escapeHTML=e;jQuery.sap.encodeJS=s;jQuery.sap.escapeJS=s;jQuery.sap.encodeURL=a;jQuery.sap.encodeURLParameters=t;jQuery.sap.encodeCSS=i;jQuery.sap.clearUrlWhitelist=r.clear;jQuery.sap.addUrlWhitelist=r.add.bind(c);jQuery.sap.removeUrlWhitelist=function(e){r._delete(r.entries()[e])};jQuery.sap.getUrlWhitelist=r.entries;jQuery.sap.validateUrl=r.validate;jQuery.sap._sanitizeHTML=p;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.events", ["jquery.sap.global","sap/ui/events/ControlEvents","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave","sap/ui/events/isSpecialKey","sap/ui/events/isMouseEventDelayed","sap/ui/events/F6Navigation","sap/ui/events/jquery/EventSimulation","sap/ui/events/KeyCodes","sap/base/util/defineCoupledProperty","sap/ui/events/jquery/EventExtension"],function(jQuery,e,n,s,a,t,u,i,o,r){"use strict";jQuery.sap.PseudoEvents=n.events;jQuery.sap.ControlEvents=e.events;jQuery.sap.disableTouchToMouseHandling=i.disableTouchToMouseHandling;r(jQuery.sap,"touchEventMode",i,"touchEventMode");jQuery.sap.bindAnyEvent=e.bindAnyEvent;jQuery.sap.unbindAnyEvent=e.unbindAnyEvent;jQuery.sap.checkMouseEnterOrLeave=s;jQuery.sap.isSpecialKey=function(e){if(e.key){return a(e)}function n(e){var n=e.which;return n===o.SHIFT||n===o.CONTROL||n===o.ALT||n===o.CAPS_LOCK||n===o.NUM_LOCK}function s(e){var n=e.which,s=n>=37&&n<=40;switch(e.type){case"keydown":case"keyup":return s;case"keypress":return n===0;default:return false}}var t=e.which,u=n(e)||s(e)||t>=33&&t<=36||t>=44&&t<=46||t>=112&&t<=123||t===o.BREAK||t===o.BACKSPACE||t===o.TAB||t===o.ENTER||t===o.ESCAPE||t===o.SCROLL_LOCK;switch(e.type){case"keydown":case"keyup":return u;case"keypress":return t===0||t===o.BACKSPACE||t===o.ESCAPE||t===o.ENTER||false;default:return false}};jQuery.sap.handleF6GroupNavigation=function(e,n){if(!e.key&&e.keyCode===o.F6){e.key="F6"}return u.handleF6GroupNavigation(e,n)};jQuery.sap._FASTNAVIGATIONKEY=u.fastNavigationKey;jQuery.sap._refreshMouseEventDelayedFlag=function(e){jQuery.sap.isMouseEventDelayed=t.apply(this,arguments)};jQuery.sap._refreshMouseEventDelayedFlag(navigator);return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.history", ["jquery.sap.global","sap/base/Log","sap/base/util/uid","sap/base/strings/escapeRegExp"],function(jQuery,e,t,r){"use strict";(function(i){var n="_skip",a=/\|id-[0-9]+-[0-9]+/,o=new RegExp(n+"[0-9]*$"),s=[],f=[],u={},h=0,l,c="|",p=[],y=false,d,g=false;jQuery.sap.history=function(e){if(!jQuery.isPlainObject(e)){return}if(!g){var t=jQuery(i),r=i.location.href.split("#")[1]||"";t.on("hashchange",k);if(Array.isArray(e.routes)){var n,a;for(n=0;n<e.routes.length;n++){a=e.routes[n];if(a.path&&a.handler){jQuery.sap.history.addRoute(a.path,a.handler)}}}if(typeof e.defaultHandler==="function"){d=e.defaultHandler}f.push(r);if(r.length>1){t.trigger("hashchange",[true])}else{l=r}g=true}};jQuery.sap.history.addHistory=function(e,t,r,n){var a,o;if(r===undefined){r=true}if(!n){o=O(e,t);a=T(o);if(a){o+=c+a}o+=c+(r?"1":"0")}else{o=x(l)}p.push(o);u[o]=true;i.location.hash=o;return o};jQuery.sap.history.addVirtualHistory=function(){jQuery.sap.history.addHistory("",undefined,false,true)};jQuery.sap.history.addRoute=function(e,t,r){if(r){t=jQuery.proxy(t,r)}var i={};i.sIdentifier=e;i["action"]=t;s.push(i);return this};jQuery.sap.history.setDefaultHandler=function(e){d=e};jQuery.sap.history.getDefaultHandler=function(){return d};jQuery.sap.history.backToHash=function(t){t=t||"";var r;if(f.length===1){if(typeof d==="function"){d()}}else{r=v(l,t);if(r<0){i.history.go(r)}else{e.error("jQuery.sap.history.backToHash: "+t+"is not in the history stack or it's after the current hash")}}};jQuery.sap.history.backThroughPath=function(t){t=t||"";t=i.encodeURIComponent(t);var r;if(f.length===1){if(typeof d==="function"){d()}}else{r=v(l,t,true);if(r<0){i.history.go(r)}else{e.error("jQuery.sap.history.backThroughPath: there's no history state which has the "+t+" identifier in the history stack before the current hash")}}};jQuery.sap.history.back=function(e){if(f.length===1){if(typeof d==="function"){d(jQuery.sap.history.NavType.Back)}}else{if(!e){e=1}i.history.go(-1*e)}};jQuery.sap.history.NavType={Back:"_back",Forward:"_forward",Bookmark:"_bookmark",Unknown:"_unknown"};function v(e,t,r){var i=f.indexOf(e),n,a,o;if(i>0){if(r){for(a=i-1;a>=0;a--){o=f[a];if(o.indexOf(t)===0&&!I(o)){return a-i}}}else{n=f.indexOf(t);if(n===-1&&t.length===0){return-1*i}if(n>-1&&n<i){return n-i}}}return 0}function k(e,t){var r=i.location.href.split("#")[1]||"";r=b(r);if(t||!u[r]){p.push(r)}if(!y){y=true;if(p.length>0){var n=p.shift();if(u[n]){m(n);delete u[n]}else{H(n)}l=n}y=false}}function b(e,t){var r=e,i=e?e.indexOf("#"):-1;if(i===0){r=r.slice(i+1)}if(t){r=r.replace(a,"")}return r}function x(e){var t=e?e:"";if(I(t)){var r=t.lastIndexOf(n);t=t.slice(0,r)}return t+n+h++}function O(e,t){var r=encodeURIComponent(e);var i=encodeURIComponent(JSON.stringify(t));return r+c+i}function T(e){var r=f.indexOf(l),i,n;if(r>-1){for(i=0;i<r+1;i++){n=f[i];if(n.slice(0,n.length-2)===e){return t()}}}return""}function m(e){var t=f.indexOf(l);if(!(t===-1||t===f.length-1)){f.splice(t+1,f.length-1-t)}f.push(e)}function I(e){return o.test(e)}function B(e,t){var r=f.indexOf(e),i;if(r!==-1){if(t){for(i=r;i<f.length;i++){if(!I(f[i])){return i-r}}}else{for(i=r;i>=0;i--){if(!I(f[i])){return i-r}}return-1*(r+1)}}}function H(t){var a,o,s,u,h;if(l===undefined){s=R(t);if(!s||!s.bBookmarkable){if(typeof d==="function"){d(jQuery.sap.history.NavType.Bookmark)}return}}if(t.length===0){if(typeof d==="function"){d(jQuery.sap.history.NavType.Back)}}else{u=f.indexOf(t);if(u===0){s=R(t);if(!s||!s.bBookmarkable){if(typeof d==="function"){d(jQuery.sap.history.NavType.Back)}return}}if(I(t)){if(I(l)){o=B(t,false);i.history.go(o)}else{var c=new RegExp(r(l+n)+"[0-9]*$");if(c.test(t)){o=B(t,true);if(o){i.history.go(o)}else{i.history.back()}}else{o=B(t,false);i.history.go(o)}}}else{if(u===-1){h=jQuery.sap.history.NavType.Unknown;f.push(t)}else{if(f.indexOf(l,u+1)===-1){h=jQuery.sap.history.NavType.Forward}else{h=jQuery.sap.history.NavType.Back}}s=R(t);if(s){a=N(s.sIdentifier);if(a){a.action.apply(null,[s.oStateData,h])}}else{e.error("hash format error! The current Hash: "+t)}}}}function N(e){var t;for(t=0;t<s.length;t++){if(s[t].sIdentifier===e){return s[t]}}}function R(e){if(I(e)){var t=e.lastIndexOf(n);e=e.slice(0,t)}var r=e.split(c),a={};if(r.length===4||r.length===3){a.sIdentifier=i.decodeURIComponent(r[0]);a.oStateData=JSON.parse(i.decodeURIComponent(r[1]));if(r.length===4){a.uid=r[2]}a.bBookmarkable=r[r.length-1]==="0"?false:true;return a}else{return null}}})(this);return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.keycodes", ["jquery.sap.global","sap/ui/events/KeyCodes"],function(jQuery,e){"use strict";jQuery.sap.KeyCodes=e;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.mobile", ["jquery.sap.global","sap/ui/util/Mobile","sap/ui/Device"],function(jQuery,e,s){"use strict";function t(e,s){var t=Object.getOwnPropertyDescriptor(e,s);return t&&t.value}(function(){jQuery.os=jQuery.extend({os:s.os.name,version:s.os.versionStr,fVersion:s.os.version},t(jQuery,"os"));jQuery.os[s.os.name]=true;jQuery.device=jQuery.extend({},t(jQuery,"device"));jQuery.device.is=jQuery.extend({standalone:window.navigator.standalone,landscape:s.orientation.landscape,portrait:s.orientation.portrait,iphone:s.os.ios&&s.system.phone,ipad:s.os.ios&&s.system.tablet,android_phone:s.system.phone&&s.os.android,android_tablet:s.system.tablet&&s.os.android,tablet:s.system.tablet,phone:s.system.phone,desktop:s.system.desktop},jQuery.device.is)})();jQuery.sap.initMobile=e.init;jQuery.sap.setIcons=e.setIcons;jQuery.sap.setMobileWebAppCapable=e.setWebAppCapable;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.promise", [],function(){"use strict"});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.properties", ["jquery.sap.global","sap/base/util/Properties"],function(jQuery,e){"use strict";jQuery.sap.properties=e.create;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.resources", ["sap/base/i18n/ResourceBundle","jquery.sap.global"],function(e,jQuery){"use strict";jQuery.sap.resources=function(){return e.create.apply(e,arguments)};jQuery.sap.resources.isBundle=function(s){return s instanceof e};jQuery.sap.resources._getFallbackLocales=e._getFallbackLocales;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.script", ["jquery.sap.global","sap/base/util/uid","sap/base/strings/hash","sap/base/util/array/uniqueSort","sap/base/util/deepEqual","sap/base/util/each","sap/base/util/array/diff","sap/base/util/JSTokenizer","sap/base/util/merge","sap/base/util/UriParameters"],function(jQuery,e,r,a,t,n,o,i,s,l){"use strict";jQuery.sap.uid=e;jQuery.sap.hashCode=r;jQuery.sap.unique=a;jQuery.sap.equal=t;jQuery.sap.each=n;jQuery.sap.arraySymbolDiff=o;jQuery.sap._createJSTokenizer=function(){return new i};jQuery.sap.parseJS=i.parseJS;jQuery.sap.extend=function(){var e=arguments,r=false;if(typeof arguments[0]==="boolean"){r=arguments[0];e=Array.prototype.slice.call(arguments,1)}if(r){return s.apply(this,e)}else{
/*
			 * The code in this function is taken from jQuery 3.6.0 "jQuery.extend" and got modified.
			 *
			 * jQuery JavaScript Library v3.6.0
			 * https://jquery.com/
			 *
			 * Copyright OpenJS Foundation and other contributors
			 * Released under the MIT license
			 * https://jquery.org/license
			 */
var a,t,n,o=arguments[0]||{},i=1,l=arguments.length;if(typeof o!=="object"&&typeof o!=="function"){o={}}for(;i<l;i++){n=arguments[i];for(t in n){a=n[t];if(t==="__proto__"||o===a){continue}o[t]=a}}return o}};jQuery.sap.getUriParameters=function e(r){return l.fromURL(r||window.location.href)};jQuery.sap.delayedCall=function e(r,a,t,n){return setTimeout(function(){if(typeof t==="string"){t=a[t]}t.apply(a,n||[])},r)};jQuery.sap.clearDelayedCall=function e(r){clearTimeout(r);return this};jQuery.sap.intervalCall=function e(r,a,t,n){return setInterval(function(){if(typeof t==="string"){t=a[t]}t.apply(a,n||[])},r)};jQuery.sap.clearIntervalCall=function e(r){clearInterval(r);return this};jQuery.sap.forIn=n;jQuery.sap.arrayDiff=function(e,r,a,n){a=a||function(e,r){return t(e,r)};var o=[];var i=[];var s=[];for(var l=0;l<r.length;l++){var f=r[l];var p=0;var u;if(n&&a(e[l],f)){p=1;u=l}else{for(var d=0;d<e.length;d++){if(a(e[d],f)){p++;u=d;if(n||p>1){break}}}}if(p==1){var w={oldIndex:u,newIndex:l};if(s[u]){delete o[u];delete i[s[u].newIndex]}else{i[l]={data:r[l],row:u};o[u]={data:e[u],row:l};s[u]=w}}}for(var l=0;l<r.length-1;l++){if(i[l]&&!i[l+1]&&i[l].row+1<e.length&&!o[i[l].row+1]&&a(e[i[l].row+1],r[l+1])){i[l+1]={data:r[l+1],row:i[l].row+1};o[i[l].row+1]={data:o[i[l].row+1],row:l+1}}}for(var l=r.length-1;l>0;l--){if(i[l]&&!i[l-1]&&i[l].row>0&&!o[i[l].row-1]&&a(e[i[l].row-1],r[l-1])){i[l-1]={data:r[l-1],row:i[l].row-1};o[i[l].row-1]={data:o[i[l].row-1],row:l-1}}}var c=[];if(r.length==0){for(var l=0;l<e.length;l++){c.push({index:0,type:"delete"})}}else{var h=0;if(!o[0]){for(var l=0;l<e.length&&!o[l];l++){c.push({index:0,type:"delete"});h=l+1}}for(var l=0;l<r.length;l++){if(!i[l]||i[l].row>h){c.push({index:l,type:"insert"})}else{h=i[l].row+1;for(var d=i[l].row+1;d<e.length&&(!o[d]||o[d].row<l);d++){c.push({index:l+1,type:"delete"});h=d+1}}}}return c};return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.sjax", ["jquery.sap.global"],function(jQuery){"use strict";jQuery.sap.sjaxSettings={complexResult:true,fallback:undefined};jQuery.sap.sjax=function t(s){var a;var e=jQuery.extend(true,{},jQuery.sap.sjaxSettings,s,{async:false,success:function(t,s,e){a={success:true,data:t,status:s,statusCode:e&&e.status}},error:function(t,s,e){a={success:false,data:undefined,status:s,error:e,statusCode:t.status,errorResponse:t.responseText}}});jQuery.ajax(e);if(!e.complexResult){return a.success?a.data:e.fallback}return a};jQuery.sap.syncHead=function(t){return jQuery.sap.sjax({type:"HEAD",url:t}).success};jQuery.sap.syncGet=function t(s,a,e){return jQuery.sap.sjax({url:s,data:a,type:"GET",dataType:e||"text"})};jQuery.sap.syncPost=function t(s,a,e){return jQuery.sap.sjax({url:s,data:a,type:"POST",dataType:e||"text"})};jQuery.sap.syncGetText=function t(s,a,e){return jQuery.sap.sjax({url:s,data:a,type:"GET",dataType:"text",fallback:e,complexResult:arguments.length<3})};jQuery.sap.syncGetJSON=function t(s,a,e){return jQuery.sap.sjax({url:s,data:a||null,type:"GET",dataType:"json",fallback:e,complexResult:arguments.length<3})};return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.storage", ["jquery.sap.global","sap/base/assert","sap/ui/util/Storage"],function(jQuery,e,t){"use strict";var s={};jQuery.sap.storage=function(a,r){if(!a){a=t.Type.session}if(typeof a==="string"&&t.Type[a]){var i=a;if(r&&r!="state.key_"){i=a+"_"+r}if(!s[i]){s[i]=new t(a,r)}return s[i]}e(a instanceof Object&&a.clear&&a.setItem&&a.getItem&&a.removeItem,"storage: duck typing the storage");return new t(a,r)};jQuery.sap.storage.Storage=t;jQuery.sap.storage.Type=t.Type;Object.assign(jQuery.sap.storage,t);return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.strings", ["jquery.sap.global","sap/base/strings/capitalize","sap/base/strings/camelize","sap/base/strings/hyphenate","sap/base/strings/escapeRegExp","sap/base/strings/formatMessage"],function(jQuery,t,s,e,r,a){"use strict";jQuery.sap.endsWith=function(t,s){if(typeof s!="string"||s==""){return false}return t.endsWith(s)};jQuery.sap.endsWithIgnoreCase=function(t,s){if(typeof s!="string"||s==""){return false}t=t.toUpperCase();s=s.toUpperCase();return t.endsWith(s)};jQuery.sap.startsWith=function(t,s){if(typeof s!="string"||s==""){return false}return t.startsWith(s)};jQuery.sap.startsWithIgnoreCase=function(t,s){if(typeof s!="string"||s==""){return false}t=t.toUpperCase();s=s.toUpperCase();return t.startsWith(s)};jQuery.sap.charToUpperCase=function(s,e){if(!s){return s}if(!e||isNaN(e)||e<=0||e>=s.length){return t(s)}var r=s.charAt(e).toUpperCase();if(e>0){return s.substring(0,e)+r+s.substring(e+1)}return r+s.substring(e+1)};jQuery.sap.padLeft=function(t,s,e){jQuery.sap.assert(typeof s==="string"&&s,"padLeft: sPadChar must be a non-empty string");if(!t){t=""}if(s&&s.length===1){return t.padStart(e,s)}while(t.length<e){t=s+t}return t};jQuery.sap.padRight=function(t,s,e){jQuery.sap.assert(typeof s==="string"&&s,"padRight: sPadChar must be a non-empty string");if(!t){t=""}if(s&&s.length===1){return t.padEnd(e,s)}while(t.length<e){t=t+s}return t};jQuery.sap.camelCase=s;jQuery.sap.hyphen=e;jQuery.sap.escapeRegExp=r;jQuery.sap.formatMessage=a;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.trace", ["jquery.sap.global","sap/ui/performance/trace/Passport","sap/ui/performance/trace/Interaction","sap/ui/performance/trace/FESR","sap/base/Log","sap/base/config","sap/ui/Global"],function(jQuery,t,e,n,a,i){"use strict";function r(){if(!(window.performance&&window.performance.getEntries)){a.warning("Interaction tracking is not supported on browsers with insufficient performance API")}}jQuery.sap.interaction={};jQuery.sap.interaction.setActive=function(){r();e.setActive.apply(this,arguments)};jQuery.sap.interaction.getActive=e.getActive;jQuery.sap.interaction.notifyStepStart=e.notifyStepStart;jQuery.sap.interaction.notifyStepEnd=e.notifyStepEnd;jQuery.sap.interaction.notifyEventStart=e.notifyEventStart;jQuery.sap.interaction.notifyScrollEvent=e.notifyScrollEvent;jQuery.sap.interaction.notifyEventEnd=e.notifyEventEnd;jQuery.sap.interaction.setStepComponent=e.setStepComponent;jQuery.sap.fesr={};jQuery.sap.fesr.setActive=function(){r();n.setActive.apply(this,arguments)};jQuery.sap.fesr.getActive=n.getActive;jQuery.sap.fesr.getCurrentTransactionId=t.getTransactionId;jQuery.sap.fesr.getRootId=t.getRootId;jQuery.sap.fesr.addBusyDuration=e.addBusyDuration;jQuery.sap.passport={};jQuery.sap.passport.setActive=t.setActive;jQuery.sap.passport.traceFlags=t.traceFlags;jQuery.sap.interaction.notifyStepStart(null,true);n.setActive(i.get({name:"sapUiFesr",type:i.Type.Boolean,external:true,freeze:true}));if(i.get({name:"sapUiXxE2eTrace",type:i.Type.Boolean,external:true,freeze:true})){sap.ui.requireSync("sap/ui/core/support/trace/E2eTraceLib")}return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.ui", ["jquery.sap.global","sap/base/util/ObjectPath","sap/ui/core/UIArea","sap/ui/dom/jquery/control"],function(jQuery,t,e){"use strict";function i(t){return t.getUIArea().getInterface()}function r(){return e.registry.get(this.id)!=null}function n(){return e.registry.get(this.id).getInterface()}jQuery.fn.root=function(t){if(t){sap.ui.getCore().setRoot(this.get(0),t);return this}var r=this.control();if(r.length>0){return r.map(i)}var n=this.uiarea();if(n.length>0){return n}this.each(function(){e.create(this)});return this};jQuery.fn.uiarea=function(t){var e=this.slice("[id]").filter(r).map(n).get();return typeof t==="number"?e[t]:e};jQuery.fn.sapui=function(e,i,r){return this.each(function(){var n=null;if(this){if(e.indexOf(".")==-1){e="sap.ui.commons."+e}var s=t.get(e);if(s){if(typeof r=="object"&&typeof r.press=="function"){r.press=jQuery.proxy(r.press,this)}n=new s(i,r);n.placeAt(this)}}})};return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("jquery.sap.xml", ["jquery.sap.global","sap/ui/util/XMLHelper"],function(jQuery,e){"use strict";jQuery.sap.parseXML=e.parse;jQuery.sap.serializeXML=function(r){var a="";if(window.ActiveXObject){a=r.xml;if(a){return a}}if(window.XMLSerializer){return e.serialize(r)}return a};jQuery.sap.isEqualNode=function(e,r){if(e===r){return true}if(!e||!r){return false}if(e.isEqualNode){return e.isEqualNode(r)}if(e.nodeType!=r.nodeType){return false}if(e.nodeValue!=r.nodeValue){return false}if(e.baseName!=r.baseName){return false}if(e.nodeName!=r.nodeName){return false}if(e.nameSpaceURI!=r.nameSpaceURI){return false}if(e.prefix!=r.prefix){return false}if(e.nodeType!=1){return true}if(e.attributes.length!=r.attributes.length){return false}for(var a=0;a<e.attributes.length;a++){if(!jQuery.sap.isEqualNode(e.attributes[a],r.attributes[a])){return false}}if(e.childNodes.length!=r.childNodes.length){return false}for(var a=0;a<e.childNodes.length;a++){if(!jQuery.sap.isEqualNode(e.childNodes[a],r.childNodes[a])){return false}}return true};jQuery.sap.getParseError=e.getParseError;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/URLListValidator", [],function(){"use strict";var e=/^(?:([^:\/?#]+):)?((?:[\/\\]{2,}((?:\[[^\]]+\]|[^\/?#:]+))(?::([0-9]+))?)?([^?#]*))(?:\?([^#]*))?(?:#(.*))?$/;var t=/^([a-z0-9-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*$/i;var a=/^([a-z0-9-._~!$&'()*+,;=:@\/?]|%[0-9a-f]{2})*$/i;var r=a;var f=/^([a-z0-9!$'*+:^_`{|}~-]|%[0-9a-f]{2})+(?:\.([a-z0-9!$'*+:^_`{|}~-]|%[0-9a-f]{2})+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i;var s=/^([0-9]{1,3}\.){3}[0-9]{1,3}$/;var i=/^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$/;var n=/^\[[^\]]+\]$/;var u=/^\[(((([0-9a-f]{1,4}:){6}|(::([0-9a-f]{1,4}:){5})|(([0-9a-f]{1,4})?::([0-9a-f]{1,4}:){4})|((([0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::([0-9a-f]{1,4}:){3})|((([0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::([0-9a-f]{1,4}:){2})|((([0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:)|((([0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::))(([0-9a-f]{1,4}:[0-9a-f]{1,4})|(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])))|((([0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4})|((([0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::))\]$/i;var l=/^([a-z0-9]([a-z0-9\-]*[a-z0-9])?\.)*[a-z0-9]([a-z0-9\-]*[a-z0-9])?$/i;var p=/^((?:ftp|https?|wss?):)([\s\S]+)$/;var o=/[\u0009\u000A\u000D]/;var v={};v._createEntry=function(e,t,a,r){return new h(e,t,a,r)};function h(e,t,a,r){Object.defineProperties(this,{protocol:{value:e&&e.toUpperCase(),enumerable:true},host:{value:t&&t.toUpperCase(),enumerable:true},port:{value:a,enumerable:true},path:{value:r,enumerable:true}})}var c=[];v.clear=function(){c=[]};v.add=function(e,t,a,r){var f=this._createEntry(e,t,a,r);c.push(f)};v._delete=function(e){c.splice(c.indexOf(e),1)};v.entries=function(){return c.slice()};v.validate=function(v){if(typeof v==="string"){if(o.test(v)){return false}}var h=p.exec(v);if(h&&!/^[\/\\]{2}/.test(h[2])){v=h[1]+"//"+h[2]}h=e.exec(v);if(!h){return false}var $=h[1],g=h[2],z=h[3],_=h[4],x=h[5],R=h[6],d=h[7];if($){$=$.toUpperCase();if(c.length<=0){if(!/^(https?|ftp)/i.test($)){return false}}}if(z){if(s.test(z)){if(!i.test(z)){return false}}else if(n.test(z)){if(!u.test(z)){return false}}else if(!l.test(z)){return false}z=z.toUpperCase()}if(x){if($==="MAILTO"){var b=g.split(",");for(var m=0;m<b.length;m++){if(!f.test(b[m])){return false}}}else{var C=x.split("/");for(var m=0;m<C.length;m++){if(!t.test(C[m])){return false}}}}if(R){if(!a.test(R)){return false}}if(d){if(!r.test(d)){return false}}if(c.length>0){var E=false;for(var m=0;m<c.length;m++){if(!$||!c[m].protocol||$==c[m].protocol){var U=false;if(z&&c[m].host&&/^\*/.test(c[m].host)){if(!c[m]._hostRegexp){var y=c[m].host.slice(1).replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");c[m]._hostRegexp=RegExp(y+"$")}var O=c[m]._hostRegexp;if(O.test(z)){U=true}}else if(!z||!c[m].host||z==c[m].host){U=true}if(U){if(!z&&!_||!c[m].port||_==c[m].port){if(c[m].path&&/\*$/.test(c[m].path)){if(!c[m]._pathRegexp){var w=c[m].path.slice(0,-1).replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");c[m]._pathRegexp=RegExp("^"+w)}var O=c[m]._pathRegexp;if(O.test(x)){E=true}}else if(!c[m].path||x==c[m].path){E=true}}}}if(E){break}}if(!E){return false}}return true};return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/URLWhitelist", ["sap/base/security/URLListValidator"],function(e){"use strict";return{add:e.add,delete:e._delete,clear:e.clear,entries:e.entries,validate:e.validate,_createEntry:function(e,t,a,r){return{protocol:e&&e.toUpperCase(),host:t&&t.toUpperCase(),port:a,path:r}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/encodeJS", ["sap/base/strings/toHex"],function(r){"use strict";var e=/[\x00-\x2b\x2d\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\xff\u2028\u2029]/g,x={};var a=function(e){var a=x[e];if(!a){var n=e.charCodeAt(0);if(n<256){a="\\x"+r(n,2)}else{a="\\u"+r(n,4)}x[e]=a}return a};var n=function(r){return r.replace(e,a)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/encodeURL", ["sap/base/strings/toHex"],function(e){"use strict";var f=/[\ud800-\udbff][\udc00-\udfff]|[\x00-\x2c\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\uffff]/g,r={};var u=function(f){var u=r[f];if(!u){var i=f.codePointAt(0);if(i<128){u="%"+e(i,2)}else if(i<2048){u="%"+e(i>>6|192,2)+"%"+e(i&63|128,2)}else if(i<65536){u="%"+e(i>>12|224,2)+"%"+e(i>>6&63|128,2)+"%"+e(i&63|128,2)}else{u="%"+e(i>>18|240,2)+"%"+e(i>>12&63|128,2)+"%"+e(i>>6&63|128,2)+"%"+e(i&63|128,2)}r[f]=u}return u};var i=function(e){return e.replace(f,u)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/encodeURLParameters", ["./encodeURL"],function(n){"use strict";var r=function(r){if(!r){return""}var t=[];Object.keys(r).forEach(function(e){var i=r[e];if(i instanceof String||typeof i==="string"){i=n(i)}t.push(n(e)+"="+i)});return t.join("&")};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/sanitizeHTML", ["sap/base/assert","sap/base/security/URLListValidator","sap/ui/thirdparty/caja-html-sanitizer"],function(i,t){"use strict";var a=function(a,e){i(window.html&&window.html.sanitize,"Sanitizer should have been loaded");e=e||{uriRewriter:function(i){if(t.validate(i)){return i}}};var r=e.tagPolicy||window.html.makeTagPolicy(e.uriRewriter,e.tokenPolicy);return window.html.sanitizeWithPolicy(a,r)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/hyphenate", [],function(){"use strict";var r=/([A-Z])/g;var e=function(e){return e.replace(r,function(r,e){return"-"+e.toLowerCase()})};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/whitespaceReplacer", [],function(){"use strict";var r=function(r){var e=" ",t=" ";if(typeof r!=="string"){return r}return r.replaceAll("\t",e+e).replaceAll(e+e,e+t)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/UriParameters", ["sap/base/Log"],function(e){"use strict";function t(e){var t=e.indexOf("#");if(t>=0){e=e.slice(0,t)}var n=e.indexOf("?");if(n>=0){return e.slice(n+1)}return""}function n(e){return decodeURIComponent(e.replace(/\+/g," "))}function r(e,t){function r(t,n){if(t in e){e[t].push(n)}else{e[t]=[n]}}t.split("&").forEach(function(e){var t=e.indexOf("=");if(t>=0){r(n(e.slice(0,t)),n(e.slice(t+1)))}else if(e.length){r(n(e),"")}})}var i=function(n){var i=Object.create(null);if(n!=null){if(typeof n!=="string"){throw new TypeError("query parameter must be a string")}r(i,t(n))}this.has=function(e){return e in i};this._get=function(e){return e in i?i[e][0]:null};this.getAll=function(e){return e in i?i[e].slice():[]};this.keys=function(){return Object.keys(i).values()};var u=false;Object.defineProperty(this,"mParams",{get:function(){if(!u){e.warning("[Deprecated] UriParameters.mParams must not be accessed.");u=true}return Object.assign({},i)},configurable:false})};i.prototype.get=function(t,n){if(n){e.warning("[Deprecated] UriParameters.get(..., true) must not be used, use getAll() instead.");return this.getAll(t)}return this._get(t)};i.fromURL=function(e){return new i(e)};i.fromQuery=function(e){if(typeof e==="string"){if(e[0]!=="?"){e="?"+e}e=e.replace(/#/g,"%23")}return new i(e)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/defineCoupledProperty", [],function(){"use strict";var e=function(e,t,n,r){var i=n[r];var u={configurable:true,get:function(){return i},set:function(e){i=e}};Object.defineProperty(e,t,u);Object.defineProperty(n,r,u)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/includes", ["sap/base/util/values"],function(e){"use strict";var r=function(n,t,i){if(typeof i!=="number"){i=0}if(Array.isArray(n)||typeof n==="string"){if(i<0){i=n.length+i<0?0:n.length+i}return n.includes(t,i)}else{return r(e(n),t,i)}};return r});
/**
 * @license
 * Lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash strict include="omit,uniq,uniqBy,uniqWith,intersection,intersectionBy,intersectionWith,pick,pickBy,debounce,throttle,max,min,castArray,curry,merge,mergeWith,toArray,xor,xorBy,xorWith,isNil,difference,differenceBy,differenceWith,flatMap,flatMapDeep,flatMapDepth,isEqual,isEqualWith,without,flatten,flattenDeep,flattenDepth,compact,zipObject,zipObjectDeep,union,unionBy,unionWith"`
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 * Modifications SAP SE or an SAP affiliate company and OpenUI5 contributors. All rights reserved.
 */
sap.ui.predefine("sap/base/util/restricted/_/lodash.custom", function(){"use strict";var r;var t="4.17.21";var n=200;var e="Expected a function";var u="__lodash_hash_undefined__";var i=500;var a="__lodash_placeholder__";var f=1,o=2,c=4;var l=1,s=2;var v=1,h=2,p=4,g=8,y=16,_=32,w=64,b=128,d=256,j=512;var m=800,O=16;var A=1/0,x=9007199254740991,z=17976931348623157e292,k=0/0;var S=4294967295;var E=[["ary",b],["bind",v],["bindKey",h],["curry",g],["curryRight",y],["flip",j],["partial",_],["partialRight",w],["rearg",d]];var T="[object Arguments]",$="[object Array]",I="[object AsyncFunction]",B="[object Boolean]",W="[object Date]",L="[object Error]",M="[object Function]",P="[object GeneratorFunction]",D="[object Map]",F="[object Number]",q="[object Null]",R="[object Object]",C="[object Promise]",U="[object Proxy]",N="[object RegExp]",V="[object Set]",G="[object String]",K="[object Symbol]",H="[object Undefined]",J="[object WeakMap]";var Q="[object ArrayBuffer]",X="[object DataView]",Y="[object Float32Array]",Z="[object Float64Array]",rr="[object Int8Array]",tr="[object Int16Array]",nr="[object Int32Array]",er="[object Uint8Array]",ur="[object Uint8ClampedArray]",ir="[object Uint16Array]",ar="[object Uint32Array]";var fr=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,or=/^\w*$/,cr=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;var lr=/[\\^$.*+?()[\]{}|]/g;var sr=/^\s+/;var vr=/\s/;var hr=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,pr=/\{\n\/\* \[wrapped with (.+)\] \*/,gr=/,? & /;var yr=/\\(\\)?/g;var _r=/\w*$/;var wr=/^[-+]0x[0-9a-f]+$/i;var br=/^0b[01]+$/i;var dr=/^\[object .+?Constructor\]$/;var jr=/^0o[0-7]+$/i;var mr=/^(?:0|[1-9]\d*)$/;var Or="\\ud800-\\udfff",Ar="\\u0300-\\u036f",xr="\\ufe20-\\ufe2f",zr="\\u20d0-\\u20ff",kr=Ar+xr+zr,Sr="\\ufe0e\\ufe0f";var Er="["+Or+"]",Tr="["+kr+"]",$r="\\ud83c[\\udffb-\\udfff]",Ir="(?:"+Tr+"|"+$r+")",Br="[^"+Or+"]",Wr="(?:\\ud83c[\\udde6-\\uddff]){2}",Lr="[\\ud800-\\udbff][\\udc00-\\udfff]",Mr="\\u200d";var Pr=Ir+"?",Dr="["+Sr+"]?",Fr="(?:"+Mr+"(?:"+[Br,Wr,Lr].join("|")+")"+Dr+Pr+")*",qr=Dr+Pr+Fr,Rr="(?:"+[Br+Tr+"?",Tr,Wr,Lr,Er].join("|")+")";var Cr=RegExp($r+"(?="+$r+")|"+Rr+qr,"g");var Ur=RegExp("["+Mr+Or+kr+Sr+"]");var Nr={};Nr[Y]=Nr[Z]=Nr[rr]=Nr[tr]=Nr[nr]=Nr[er]=Nr[ur]=Nr[ir]=Nr[ar]=true;Nr[T]=Nr[$]=Nr[Q]=Nr[B]=Nr[X]=Nr[W]=Nr[L]=Nr[M]=Nr[D]=Nr[F]=Nr[R]=Nr[N]=Nr[V]=Nr[G]=Nr[J]=false;var Vr={};Vr[T]=Vr[$]=Vr[Q]=Vr[X]=Vr[B]=Vr[W]=Vr[Y]=Vr[Z]=Vr[rr]=Vr[tr]=Vr[nr]=Vr[D]=Vr[F]=Vr[R]=Vr[N]=Vr[V]=Vr[G]=Vr[K]=Vr[er]=Vr[ur]=Vr[ir]=Vr[ar]=true;Vr[L]=Vr[M]=Vr[J]=false;var Gr=parseInt;var Kr=typeof global=="object"&&global&&global.Object===Object&&global;var Hr=typeof self=="object"&&self&&self.Object===Object&&self;var Jr=Kr||Hr||Function("return this")();var Qr=typeof exports=="object"&&exports&&!exports.nodeType&&exports;var Xr=Qr&&typeof module=="object"&&module&&!module.nodeType&&module;var Yr=Xr&&Xr.exports===Qr;var Zr=Yr&&Kr.process;var rt=function(){try{var r=Xr&&Xr.require&&Xr.require("util").types;if(r){return r}return Zr&&Zr.binding&&Zr.binding("util")}catch(r){}}();var tt=rt&&rt.isMap,nt=rt&&rt.isSet,et=rt&&rt.isTypedArray;function ut(r,t,n){switch(n.length){case 0:return r.call(t);case 1:return r.call(t,n[0]);case 2:return r.call(t,n[0],n[1]);case 3:return r.call(t,n[0],n[1],n[2])}return r.apply(t,n)}function it(r,t){var n=-1,e=r==null?0:r.length;while(++n<e){if(t(r[n],n,r)===false){break}}return r}function at(r,t){var n=-1,e=r==null?0:r.length,u=0,i=[];while(++n<e){var a=r[n];if(t(a,n,r)){i[u++]=a}}return i}function ft(r,t){var n=r==null?0:r.length;return!!n&&pt(r,t,0)>-1}function ot(r,t,n){var e=-1,u=r==null?0:r.length;while(++e<u){if(n(t,r[e])){return true}}return false}function ct(r,t){var n=-1,e=r==null?0:r.length,u=Array(e);while(++n<e){u[n]=t(r[n],n,r)}return u}function lt(r,t){var n=-1,e=t.length,u=r.length;while(++n<e){r[u+n]=t[n]}return r}function st(r,t){var n=-1,e=r==null?0:r.length;while(++n<e){if(t(r[n],n,r)){return true}}return false}function vt(r){return r.split("")}function ht(r,t,n,e){var u=r.length,i=n+(e?1:-1);while(e?i--:++i<u){if(t(r[i],i,r)){return i}}return-1}function pt(r,t,n){return t===t?Tt(r,t,n):ht(r,gt,n)}function gt(r){return r!==r}function yt(t){return function(n){return n==null?r:n[t]}}function _t(r,t){var n=-1,e=Array(r);while(++n<r){e[n]=t(n)}return e}function wt(r){return r?r.slice(0,It(r)+1).replace(sr,""):r}function bt(r){return function(t){return r(t)}}function dt(r,t){return ct(t,function(t){return r[t]})}function jt(r,t){return r.has(t)}function mt(r,t){var n=r.length,e=0;while(n--){if(r[n]===t){++e}}return e}function Ot(t,n){return t==null?r:t[n]}function At(r){return Ur.test(r)}function xt(r){var t,n=[];while(!(t=r.next()).done){n.push(t.value)}return n}function zt(r){var t=-1,n=Array(r.size);r.forEach(function(r,e){n[++t]=[e,r]});return n}function kt(r,t){return function(n){return r(t(n))}}function St(r,t){var n=-1,e=r.length,u=0,i=[];while(++n<e){var f=r[n];if(f===t||f===a){r[n]=a;i[u++]=n}}return i}function Et(r){var t=-1,n=Array(r.size);r.forEach(function(r){n[++t]=r});return n}function Tt(r,t,n){var e=n-1,u=r.length;while(++e<u){if(r[e]===t){return e}}return-1}function $t(r){return At(r)?Bt(r):vt(r)}function It(r){var t=r.length;while(t--&&vr.test(r.charAt(t))){}return t}function Bt(r){return r.match(Cr)||[]}var Wt=Array.prototype,Lt=Function.prototype,Mt=Object.prototype;var Pt=Jr["__core-js_shared__"];var Dt=Lt.toString;var Ft=Mt.hasOwnProperty;var qt=function(){var r=/[^.]+$/.exec(Pt&&Pt.keys&&Pt.keys.IE_PROTO||"");return r?"Symbol(src)_1."+r:""}();var Rt=Mt.toString;var Ct=Dt.call(Object);var Ut=RegExp("^"+Dt.call(Ft).replace(lr,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");var Nt=Yr?Jr.Buffer:r,Vt=Jr.Symbol,Gt=Jr.Uint8Array,Kt=Nt?Nt.allocUnsafe:r,Ht=kt(Object.getPrototypeOf,Object),Jt=Object.create,Qt=Mt.propertyIsEnumerable,Xt=Wt.splice,Yt=Vt?Vt.isConcatSpreadable:r,Zt=Vt?Vt.iterator:r,rn=Vt?Vt.toStringTag:r;var tn=function(){try{var r=Mu(Object,"defineProperty");r({},"",{});return r}catch(r){}}();var nn=Object.getOwnPropertySymbols,en=Nt?Nt.isBuffer:r,un=kt(Object.keys,Object),an=Math.max,fn=Math.min,on=Date.now;var cn=Mu(Jr,"DataView"),ln=Mu(Jr,"Map"),sn=Mu(Jr,"Promise"),vn=Mu(Jr,"Set"),hn=Mu(Jr,"WeakMap"),pn=Mu(Object,"create");var gn=hn&&new hn;var yn={};var _n=_i(cn),wn=_i(ln),bn=_i(sn),dn=_i(vn),jn=_i(hn);var mn=Vt?Vt.prototype:r,On=mn?mn.valueOf:r,An=mn?mn.toString:r;function xn(){}var zn=function(){function t(){}return function(n){if(!oa(n)){return{}}if(Jt){return Jt(n)}t.prototype=n;var e=new t;t.prototype=r;return e}}();function kn(){}function Sn(r){this.__wrapped__=r;this.__actions__=[];this.__dir__=1;this.__filtered__=false;this.__iteratees__=[];this.__takeCount__=S;this.__views__=[]}Sn.prototype=zn(kn.prototype);Sn.prototype.constructor=Sn;function En(r){var t=-1,n=r==null?0:r.length;this.clear();while(++t<n){var e=r[t];this.set(e[0],e[1])}}function Tn(){this.__data__=pn?pn(null):{};this.size=0}function $n(r){var t=this.has(r)&&delete this.__data__[r];this.size-=t?1:0;return t}function In(t){var n=this.__data__;if(pn){var e=n[t];return e===u?r:e}return Ft.call(n,t)?n[t]:r}function Bn(t){var n=this.__data__;return pn?n[t]!==r:Ft.call(n,t)}function Wn(t,n){var e=this.__data__;this.size+=this.has(t)?0:1;e[t]=pn&&n===r?u:n;return this}En.prototype.clear=Tn;En.prototype["delete"]=$n;En.prototype.get=In;En.prototype.has=Bn;En.prototype.set=Wn;function Ln(r){var t=-1,n=r==null?0:r.length;this.clear();while(++t<n){var e=r[t];this.set(e[0],e[1])}}function Mn(){this.__data__=[];this.size=0}function Pn(r){var t=this.__data__,n=ie(t,r);if(n<0){return false}var e=t.length-1;if(n==e){t.pop()}else{Xt.call(t,n,1)}--this.size;return true}function Dn(t){var n=this.__data__,e=ie(n,t);return e<0?r:n[e][1]}function Fn(r){return ie(this.__data__,r)>-1}function qn(r,t){var n=this.__data__,e=ie(n,r);if(e<0){++this.size;n.push([r,t])}else{n[e][1]=t}return this}Ln.prototype.clear=Mn;Ln.prototype["delete"]=Pn;Ln.prototype.get=Dn;Ln.prototype.has=Fn;Ln.prototype.set=qn;function Rn(r){var t=-1,n=r==null?0:r.length;this.clear();while(++t<n){var e=r[t];this.set(e[0],e[1])}}function Cn(){this.size=0;this.__data__={hash:new En,map:new(ln||Ln),string:new En}}function Un(r){var t=Wu(this,r)["delete"](r);this.size-=t?1:0;return t}function Nn(r){return Wu(this,r).get(r)}function Vn(r){return Wu(this,r).has(r)}function Gn(r,t){var n=Wu(this,r),e=n.size;n.set(r,t);this.size+=n.size==e?0:1;return this}Rn.prototype.clear=Cn;Rn.prototype["delete"]=Un;Rn.prototype.get=Nn;Rn.prototype.has=Vn;Rn.prototype.set=Gn;function Kn(r){var t=-1,n=r==null?0:r.length;this.__data__=new Rn;while(++t<n){this.add(r[t])}}function Hn(r){this.__data__.set(r,u);return this}function Jn(r){return this.__data__.has(r)}Kn.prototype.add=Kn.prototype.push=Hn;Kn.prototype.has=Jn;function Qn(r){var t=this.__data__=new Ln(r);this.size=t.size}function Xn(){this.__data__=new Ln;this.size=0}function Yn(r){var t=this.__data__,n=t["delete"](r);this.size=t.size;return n}function Zn(r){return this.__data__.get(r)}function re(r){return this.__data__.has(r)}function te(r,t){var e=this.__data__;if(e instanceof Ln){var u=e.__data__;if(!ln||u.length<n-1){u.push([r,t]);this.size=++e.size;return this}e=this.__data__=new Rn(u)}e.set(r,t);this.size=e.size;return this}Qn.prototype.clear=Xn;Qn.prototype["delete"]=Yn;Qn.prototype.get=Zn;Qn.prototype.has=re;Qn.prototype.set=te;function ne(r,t){var n=ra(r),e=!n&&Zi(r),u=!n&&!e&&ea(r),i=!n&&!e&&!u&&ya(r),a=n||e||u||i,f=a?_t(r.length,String):[],o=f.length;for(var c in r){if((t||Ft.call(r,c))&&!(a&&(c=="length"||u&&(c=="offset"||c=="parent")||i&&(c=="buffer"||c=="byteLength"||c=="byteOffset")||Hu(c,o)))){f.push(c)}}return f}function ee(t,n,e){if(e!==r&&!Yi(t[n],e)||e===r&&!(n in t)){oe(t,n,e)}}function ue(t,n,e){var u=t[n];if(!(Ft.call(t,n)&&Yi(u,e))||e===r&&!(n in t)){oe(t,n,e)}}function ie(r,t){var n=r.length;while(n--){if(Yi(r[n][0],t)){return n}}return-1}function ae(r,t){return r&&cu(t,xa(t),r)}function fe(r,t){return r&&cu(t,za(t),r)}function oe(r,t,n){if(t=="__proto__"&&tn){tn(r,t,{configurable:true,enumerable:true,value:n,writable:true})}else{r[t]=n}}function ce(t,n,e,u,i,a){var l,s=n&f,v=n&o,h=n&c;if(e){l=i?e(t,u,i,a):e(t)}if(l!==r){return l}if(!oa(t)){return t}var p=ra(t);if(p){l=Uu(t);if(!s){return ou(t,l)}}else{var g=qu(t),y=g==M||g==P;if(ea(t)){return ru(t,s)}if(g==R||g==T||y&&!i){l=v||y?{}:Nu(t);if(!s){return v?su(t,fe(l,t)):lu(t,ae(l,t))}}else{if(!Vr[g]){return i?t:{}}l=Vu(t,g,s)}}a||(a=new Qn);var _=a.get(t);if(_){return _}a.set(t,l);if(ha(t)){t.forEach(function(r){l.add(ce(r,n,e,r,t,a))})}else if(la(t)){t.forEach(function(r,u){l.set(u,ce(r,n,e,u,t,a))})}var w=h?v?Eu:Su:v?za:xa;var b=p?r:w(t);it(b||t,function(r,u){if(b){u=r;r=t[u]}ue(l,u,ce(r,n,e,u,t,a))});return l}function le(r,t,e,u){var i=-1,a=ft,f=true,o=r.length,c=[],l=t.length;if(!o){return c}if(e){t=ct(t,bt(e))}if(u){a=ot;f=false}else if(t.length>=n){a=jt;f=false;t=new Kn(t)}r:while(++i<o){var s=r[i],v=e==null?s:e(s);s=u||s!==0?s:0;if(f&&v===v){var h=l;while(h--){if(t[h]===v){continue r}}c.push(s)}else if(!a(t,v,u)){c.push(s)}}return c}var se=hu(ge);function ve(t,n,e){var u=-1,i=t.length;while(++u<i){var a=t[u],f=n(a);if(f!=null&&(o===r?f===f&&!ga(f):e(f,o))){var o=f,c=a}}return c}function he(r,t,n,e,u){var i=-1,a=r.length;n||(n=Ku);u||(u=[]);while(++i<a){var f=r[i];if(t>0&&n(f)){if(t>1){he(f,t-1,n,e,u)}else{lt(u,f)}}else if(!e){u[u.length]=f}}return u}var pe=pu();function ge(r,t){return r&&pe(r,t,xa)}function ye(t,n){n=Ze(n,t);var e=0,u=n.length;while(t!=null&&e<u){t=t[yi(n[e++])]}return e&&e==u?t:r}function _e(r,t,n){var e=t(r);return ra(r)?e:lt(e,n(r))}function we(t){if(t==null){return t===r?H:q}return rn&&rn in Object(t)?Pu(t):ai(t)}function be(r,t){return r>t}function de(r,t){return r!=null&&t in Object(r)}function je(t,n,e){var u=e?ot:ft,i=t[0].length,a=t.length,f=a,o=Array(a),c=Infinity,l=[];while(f--){var s=t[f];if(f&&n){s=ct(s,bt(n))}c=fn(s.length,c);o[f]=!e&&(n||i>=120&&s.length>=120)?new Kn(f&&s):r}s=t[0];var v=-1,h=o[0];r:while(++v<i&&l.length<c){var p=s[v],g=n?n(p):p;p=e||p!==0?p:0;if(!(h?jt(h,g):u(l,g,e))){f=a;while(--f){var y=o[f];if(!(y?jt(y,g):u(t[f],g,e))){continue r}}if(h){h.push(g)}l.push(p)}}return l}function me(r){return ca(r)&&we(r)==T}function Oe(r,t,n,e,u){if(r===t){return true}if(r==null||t==null||!ca(r)&&!ca(t)){return r!==r&&t!==t}return Ae(r,t,n,e,Oe,u)}function Ae(r,t,n,e,u,i){var a=ra(r),f=ra(t),o=a?$:qu(r),c=f?$:qu(t);o=o==T?R:o;c=c==T?R:c;var s=o==R,v=c==R,h=o==c;if(h&&ea(r)){if(!ea(t)){return false}a=true;s=false}if(h&&!s){i||(i=new Qn);return a||ya(r)?Au(r,t,n,e,u,i):xu(r,t,o,n,e,u,i)}if(!(n&l)){var p=s&&Ft.call(r,"__wrapped__"),g=v&&Ft.call(t,"__wrapped__");if(p||g){var y=p?r.value():r,_=g?t.value():t;i||(i=new Qn);return u(y,_,n,e,i)}}if(!h){return false}i||(i=new Qn);return zu(r,t,n,e,u,i)}function xe(r){return ca(r)&&qu(r)==D}function ze(t,n,e,u){var i=e.length,a=i,f=!u;if(t==null){return!a}t=Object(t);while(i--){var o=e[i];if(f&&o[2]?o[1]!==t[o[0]]:!(o[0]in t)){return false}}while(++i<a){o=e[i];var c=o[0],v=t[c],h=o[1];if(f&&o[2]){if(v===r&&!(c in t)){return false}}else{var p=new Qn;if(u){var g=u(v,h,c,t,n,p)}if(!(g===r?Oe(h,v,l|s,u,p):g)){return false}}}return true}function ke(r){if(!oa(r)||Zu(r)){return false}var t=aa(r)?Ut:dr;return t.test(_i(r))}function Se(r){return ca(r)&&qu(r)==V}function Ee(r){return ca(r)&&fa(r.length)&&!!Nr[we(r)]}function Te(r){if(typeof r=="function"){return r}if(r==null){return Wa}if(typeof r=="object"){return ra(r)?Me(r[0],r[1]):Le(r)}return Pa(r)}function $e(r){if(!ri(r)){return un(r)}var t=[];for(var n in Object(r)){if(Ft.call(r,n)&&n!="constructor"){t.push(n)}}return t}function Ie(r){if(!oa(r)){return ii(r)}var t=ri(r),n=[];for(var e in r){if(!(e=="constructor"&&(t||!Ft.call(r,e)))){n.push(e)}}return n}function Be(r,t){return r<t}function We(r,t){var n=-1,e=ta(r)?Array(r.length):[];se(r,function(r,u,i){e[++n]=t(r,u,i)});return e}function Le(r){var t=Lu(r);if(t.length==1&&t[0][2]){return ni(t[0][0],t[0][1])}return function(n){return n===r||ze(n,r,t)}}function Me(t,n){if(Qu(t)&&ti(n)){return ni(yi(t),n)}return function(e){var u=Oa(e,t);return u===r&&u===n?Aa(e,t):Oe(n,u,l|s)}}function Pe(t,n,e,u,i){if(t===n){return}pe(n,function(a,f){i||(i=new Qn);if(oa(a)){De(t,n,f,e,Pe,u,i)}else{var o=u?u(li(t,f),a,f+"",t,n,i):r;if(o===r){o=a}ee(t,f,o)}},za)}function De(t,n,e,u,i,a,f){var o=li(t,e),c=li(n,e),l=f.get(c);if(l){ee(t,e,l);return}var s=a?a(o,c,e+"",t,n,f):r;var v=s===r;if(v){var h=ra(c),p=!h&&ea(c),g=!h&&!p&&ya(c);s=c;if(h||p||g){if(ra(o)){s=o}else if(na(o)){s=ou(o)}else if(p){v=false;s=ru(c,true)}else if(g){v=false;s=iu(c,true)}else{s=[]}}else if(va(c)||Zi(c)){s=o;if(Zi(o)){s=ja(o)}else if(!oa(o)||aa(o)){s=Nu(c)}}else{v=false}}if(v){f.set(c,s);i(s,c,u,a,f);f["delete"](c)}ee(t,e,s)}function Fe(r,t){return qe(r,t,function(t,n){return Aa(r,n)})}function qe(r,t,n){var e=-1,u=t.length,i={};while(++e<u){var a=t[e],f=ye(r,a);if(n(f,a)){Ue(i,Ze(a,r),f)}}return i}function Re(r){return function(t){return ye(t,r)}}function Ce(r,t){return vi(fi(r,t,Wa),r+"")}function Ue(t,n,e,u){if(!oa(t)){return t}n=Ze(n,t);var i=-1,a=n.length,f=a-1,o=t;while(o!=null&&++i<a){var c=yi(n[i]),l=e;if(c==="__proto__"||c==="constructor"||c==="prototype"){return t}if(i!=f){var s=o[c];l=u?u(s,c,o):r;if(l===r){l=oa(s)?s:Hu(n[i+1])?[]:{}}}ue(o,c,l);o=o[c]}return t}var Ne=!gn?Wa:function(r,t){gn.set(r,t);return r};var Ve=!tn?Wa:function(r,t){return tn(r,"toString",{configurable:true,enumerable:false,value:Ba(t),writable:true})};function Ge(r,t,n){var e=-1,u=r.length;if(t<0){t=-t>u?0:u+t}n=n>u?u:n;if(n<0){n+=u}u=t>n?0:n-t>>>0;t>>>=0;var i=Array(u);while(++e<u){i[e]=r[e+t]}return i}function Ke(r){if(typeof r=="string"){return r}if(ra(r)){return ct(r,Ke)+""}if(ga(r)){return An?An.call(r):""}var t=r+"";return t=="0"&&1/r==-A?"-0":t}function He(r,t,e){var u=-1,i=ft,a=r.length,f=true,o=[],c=o;if(e){f=false;i=ot}else if(a>=n){var l=t?null:ju(r);if(l){return Et(l)}f=false;i=jt;c=new Kn}else{c=t?[]:o}r:while(++u<a){var s=r[u],v=t?t(s):s;s=e||s!==0?s:0;if(f&&v===v){var h=c.length;while(h--){if(c[h]===v){continue r}}if(t){c.push(v)}o.push(s)}else if(!i(c,v,e)){if(c!==o){c.push(v)}o.push(s)}}return o}function Je(r,t){t=Ze(t,r);r=oi(r,t);return r==null||delete r[yi(Ei(t))]}function Qe(r,t,n){var e=r.length;if(e<2){return e?He(r[0]):[]}var u=-1,i=Array(e);while(++u<e){var a=r[u],f=-1;while(++f<e){if(f!=u){i[u]=le(i[u]||a,r[f],t,n)}}}return He(he(i,1),t,n)}function Xe(t,n,e){var u=-1,i=t.length,a=n.length,f={};while(++u<i){var o=u<a?n[u]:r;e(f,t[u],o)}return f}function Ye(r){return na(r)?r:[]}function Ze(r,t){if(ra(r)){return r}return Qu(r,t)?[r]:gi(ma(r))}function ru(r,t){if(t){return r.slice()}var n=r.length,e=Kt?Kt(n):new r.constructor(n);r.copy(e);return e}function tu(r){var t=new r.constructor(r.byteLength);new Gt(t).set(new Gt(r));return t}function nu(r,t){var n=t?tu(r.buffer):r.buffer;return new r.constructor(n,r.byteOffset,r.byteLength)}function eu(r){var t=new r.constructor(r.source,_r.exec(r));t.lastIndex=r.lastIndex;return t}function uu(r){return On?Object(On.call(r)):{}}function iu(r,t){var n=t?tu(r.buffer):r.buffer;return new r.constructor(n,r.byteOffset,r.length)}function au(r,t,n,e){var u=-1,i=r.length,a=n.length,f=-1,o=t.length,c=an(i-a,0),l=Array(o+c),s=!e;while(++f<o){l[f]=t[f]}while(++u<a){if(s||u<i){l[n[u]]=r[u]}}while(c--){l[f++]=r[u++]}return l}function fu(r,t,n,e){var u=-1,i=r.length,a=-1,f=n.length,o=-1,c=t.length,l=an(i-f,0),s=Array(l+c),v=!e;while(++u<l){s[u]=r[u]}var h=u;while(++o<c){s[h+o]=t[o]}while(++a<f){if(v||u<i){s[h+n[a]]=r[u++]}}return s}function ou(r,t){var n=-1,e=r.length;t||(t=Array(e));while(++n<e){t[n]=r[n]}return t}function cu(t,n,e,u){var i=!e;e||(e={});var a=-1,f=n.length;while(++a<f){var o=n[a];var c=u?u(e[o],t[o],o,e,t):r;if(c===r){c=t[o]}if(i){oe(e,o,c)}else{ue(e,o,c)}}return e}function lu(r,t){return cu(r,Du(r),t)}function su(r,t){return cu(r,Fu(r),t)}function vu(t){return Ce(function(n,e){var u=-1,i=e.length,a=i>1?e[i-1]:r,f=i>2?e[2]:r;a=t.length>3&&typeof a=="function"?(i--,a):r;if(f&&Ju(e[0],e[1],f)){a=i<3?r:a;i=1}n=Object(n);while(++u<i){var o=e[u];if(o){t(n,o,u,a)}}return n})}function hu(r,t){return function(n,e){if(n==null){return n}if(!ta(n)){return r(n,e)}var u=n.length,i=t?u:-1,a=Object(n);while(t?i--:++i<u){if(e(a[i],i,a)===false){break}}return n}}function pu(r){return function(t,n,e){var u=-1,i=Object(t),a=e(t),f=a.length;while(f--){var o=a[r?f:++u];if(n(i[o],o,i)===false){break}}return t}}function gu(r,t,n){var e=t&v,u=yu(r);function i(){var t=this&&this!==Jr&&this instanceof i?u:r;return t.apply(e?n:this,arguments)}return i}function yu(r){return function(){var t=arguments;switch(t.length){case 0:return new r;case 1:return new r(t[0]);case 2:return new r(t[0],t[1]);case 3:return new r(t[0],t[1],t[2]);case 4:return new r(t[0],t[1],t[2],t[3]);case 5:return new r(t[0],t[1],t[2],t[3],t[4]);case 6:return new r(t[0],t[1],t[2],t[3],t[4],t[5]);case 7:return new r(t[0],t[1],t[2],t[3],t[4],t[5],t[6])}var n=zn(r.prototype),e=r.apply(n,t);return oa(e)?e:n}}function _u(t,n,e){var u=yu(t);function i(){var a=arguments.length,f=Array(a),o=a,c=Iu(i);while(o--){f[o]=arguments[o]}var l=a<3&&f[0]!==c&&f[a-1]!==c?[]:St(f,c);a-=l.length;if(a<e){return du(t,n,wu,i.placeholder,r,f,l,r,r,e-a)}var s=this&&this!==Jr&&this instanceof i?u:t;return ut(s,this,f)}return i}function wu(t,n,e,u,i,a,f,o,c,l){var s=n&b,p=n&v,_=n&h,w=n&(g|y),d=n&j,m=_?r:yu(t);function O(){var r=arguments.length,v=Array(r),h=r;while(h--){v[h]=arguments[h]}if(w){var g=Iu(O),y=mt(v,g)}if(u){v=au(v,u,i,w)}if(a){v=fu(v,a,f,w)}r-=y;if(w&&r<l){var b=St(v,g);return du(t,n,wu,O.placeholder,e,v,b,o,c,l-r)}var j=p?e:this,A=_?j[t]:t;r=v.length;if(o){v=ci(v,o)}else if(d&&r>1){v.reverse()}if(s&&c<r){v.length=c}if(this&&this!==Jr&&this instanceof O){A=m||yu(A)}return A.apply(j,v)}return O}function bu(r,t,n,e){var u=t&v,i=yu(r);function a(){var t=-1,f=arguments.length,o=-1,c=e.length,l=Array(c+f),s=this&&this!==Jr&&this instanceof a?i:r;while(++o<c){l[o]=e[o]}while(f--){l[o++]=arguments[++t]}return ut(s,u?n:this,l)}return a}function du(t,n,e,u,i,a,f,o,c,l){var s=n&g,y=s?f:r,b=s?r:f,d=s?a:r,j=s?r:a;n|=s?_:w;n&=~(s?w:_);if(!(n&p)){n&=~(v|h)}var m=[t,n,i,d,y,j,b,o,c,l];var O=e.apply(r,m);if(Yu(t)){si(O,m)}O.placeholder=u;return hi(O,t,n)}var ju=!(vn&&1/Et(new vn([,-0]))[1]==A)?Ma:function(r){return new vn(r)};function mu(t,n,u,i,a,f,o,c){var l=n&h;if(!l&&typeof t!="function"){throw new TypeError(e)}var s=i?i.length:0;if(!s){n&=~(_|w);i=a=r}o=o===r?o:an(ba(o),0);c=c===r?c:ba(c);s-=a?a.length:0;if(n&w){var p=i,b=a;i=a=r}var d=l?r:Tu(t);var j=[t,n,u,i,a,p,b,f,o,c];if(d){ui(j,d)}t=j[0];n=j[1];u=j[2];i=j[3];a=j[4];c=j[9]=j[9]===r?l?0:t.length:an(j[9]-s,0);if(!c&&n&(g|y)){n&=~(g|y)}if(!n||n==v){var m=gu(t,n,u)}else if(n==g||n==y){m=_u(t,n,c)}else if((n==_||n==(v|_))&&!a.length){m=bu(t,n,u,i)}else{m=wu.apply(r,j)}var O=d?Ne:si;return hi(O(m,j),t,n)}function Ou(t){return va(t)?r:t}function Au(t,n,e,u,i,a){var f=e&l,o=t.length,c=n.length;if(o!=c&&!(f&&c>o)){return false}var v=a.get(t);var h=a.get(n);if(v&&h){return v==n&&h==t}var p=-1,g=true,y=e&s?new Kn:r;a.set(t,n);a.set(n,t);while(++p<o){var _=t[p],w=n[p];if(u){var b=f?u(w,_,p,n,t,a):u(_,w,p,t,n,a)}if(b!==r){if(b){continue}g=false;break}if(y){if(!st(n,function(r,t){if(!jt(y,t)&&(_===r||i(_,r,e,u,a))){return y.push(t)}})){g=false;break}}else if(!(_===w||i(_,w,e,u,a))){g=false;break}}a["delete"](t);a["delete"](n);return g}function xu(r,t,n,e,u,i,a){switch(n){case X:if(r.byteLength!=t.byteLength||r.byteOffset!=t.byteOffset){return false}r=r.buffer;t=t.buffer;case Q:if(r.byteLength!=t.byteLength||!i(new Gt(r),new Gt(t))){return false}return true;case B:case W:case F:return Yi(+r,+t);case L:return r.name==t.name&&r.message==t.message;case N:case G:return r==t+"";case D:var f=zt;case V:var o=e&l;f||(f=Et);if(r.size!=t.size&&!o){return false}var c=a.get(r);if(c){return c==t}e|=s;a.set(r,t);var v=Au(f(r),f(t),e,u,i,a);a["delete"](r);return v;case K:if(On){return On.call(r)==On.call(t)}}return false}function zu(t,n,e,u,i,a){var f=e&l,o=Su(t),c=o.length,s=Su(n),v=s.length;if(c!=v&&!f){return false}var h=c;while(h--){var p=o[h];if(!(f?p in n:Ft.call(n,p))){return false}}var g=a.get(t);var y=a.get(n);if(g&&y){return g==n&&y==t}var _=true;a.set(t,n);a.set(n,t);var w=f;while(++h<c){p=o[h];var b=t[p],d=n[p];if(u){var j=f?u(d,b,p,n,t,a):u(b,d,p,t,n,a)}if(!(j===r?b===d||i(b,d,e,u,a):j)){_=false;break}w||(w=p=="constructor")}if(_&&!w){var m=t.constructor,O=n.constructor;if(m!=O&&("constructor"in t&&"constructor"in n)&&!(typeof m=="function"&&m instanceof m&&typeof O=="function"&&O instanceof O)){_=false}}a["delete"](t);a["delete"](n);return _}function ku(t){return vi(fi(t,r,Oi),t+"")}function Su(r){return _e(r,xa,Du)}function Eu(r){return _e(r,za,Fu)}var Tu=!gn?Ma:function(r){return gn.get(r)};function $u(r){var t=r.name+"",n=yn[t],e=Ft.call(yn,t)?n.length:0;while(e--){var u=n[e],i=u.func;if(i==null||i==r){return u.name}}return t}function Iu(r){var t=Ft.call(xn,"placeholder")?xn:r;return t.placeholder}function Bu(){var r=xn.iteratee||La;r=r===La?Te:r;return arguments.length?r(arguments[0],arguments[1]):r}function Wu(r,t){var n=r.__data__;return Xu(t)?n[typeof t=="string"?"string":"hash"]:n.map}function Lu(r){var t=xa(r),n=t.length;while(n--){var e=t[n],u=r[e];t[n]=[e,u,ti(u)]}return t}function Mu(t,n){var e=Ot(t,n);return ke(e)?e:r}function Pu(t){var n=Ft.call(t,rn),e=t[rn];try{t[rn]=r;var u=true}catch(r){}var i=Rt.call(t);if(u){if(n){t[rn]=e}else{delete t[rn]}}return i}var Du=!nn?Da:function(r){if(r==null){return[]}r=Object(r);return at(nn(r),function(t){return Qt.call(r,t)})};var Fu=!nn?Da:function(r){var t=[];while(r){lt(t,Du(r));r=Ht(r)}return t};var qu=we;if(cn&&qu(new cn(new ArrayBuffer(1)))!=X||ln&&qu(new ln)!=D||sn&&qu(sn.resolve())!=C||vn&&qu(new vn)!=V||hn&&qu(new hn)!=J){qu=function(t){var n=we(t),e=n==R?t.constructor:r,u=e?_i(e):"";if(u){switch(u){case _n:return X;case wn:return D;case bn:return C;case dn:return V;case jn:return J}}return n}}function Ru(r){var t=r.match(pr);return t?t[1].split(gr):[]}function Cu(r,t,n){t=Ze(t,r);var e=-1,u=t.length,i=false;while(++e<u){var a=yi(t[e]);if(!(i=r!=null&&n(r,a))){break}r=r[a]}if(i||++e!=u){return i}u=r==null?0:r.length;return!!u&&fa(u)&&Hu(a,u)&&(ra(r)||Zi(r))}function Uu(r){var t=r.length,n=new r.constructor(t);if(t&&typeof r[0]=="string"&&Ft.call(r,"index")){n.index=r.index;n.input=r.input}return n}function Nu(r){return typeof r.constructor=="function"&&!ri(r)?zn(Ht(r)):{}}function Vu(r,t,n){var e=r.constructor;switch(t){case Q:return tu(r);case B:case W:return new e(+r);case X:return nu(r,n);case Y:case Z:case rr:case tr:case nr:case er:case ur:case ir:case ar:return iu(r,n);case D:return new e;case F:case G:return new e(r);case N:return eu(r);case V:return new e;case K:return uu(r)}}function Gu(r,t){var n=t.length;if(!n){return r}var e=n-1;t[e]=(n>1?"& ":"")+t[e];t=t.join(n>2?", ":" ");return r.replace(hr,"{\n/* [wrapped with "+t+"] */\n")}function Ku(r){return ra(r)||Zi(r)||!!(Yt&&r&&r[Yt])}function Hu(r,t){var n=typeof r;t=t==null?x:t;return!!t&&(n=="number"||n!="symbol"&&mr.test(r))&&(r>-1&&r%1==0&&r<t)}function Ju(r,t,n){if(!oa(n)){return false}var e=typeof t;if(e=="number"?ta(n)&&Hu(t,n.length):e=="string"&&t in n){return Yi(n[t],r)}return false}function Qu(r,t){if(ra(r)){return false}var n=typeof r;if(n=="number"||n=="symbol"||n=="boolean"||r==null||ga(r)){return true}return or.test(r)||!fr.test(r)||t!=null&&r in Object(t)}function Xu(r){var t=typeof r;return t=="string"||t=="number"||t=="symbol"||t=="boolean"?r!=="__proto__":r===null}function Yu(r){var t=$u(r),n=xn[t];if(typeof n!="function"||!(t in Sn.prototype)){return false}if(r===n){return true}var e=Tu(n);return!!e&&r===e[0]}function Zu(r){return!!qt&&qt in r}function ri(r){var t=r&&r.constructor,n=typeof t=="function"&&t.prototype||Mt;return r===n}function ti(r){return r===r&&!oa(r)}function ni(t,n){return function(e){if(e==null){return false}return e[t]===n&&(n!==r||t in Object(e))}}function ei(r){var t=Ji(r,function(r){if(n.size===i){n.clear()}return r});var n=t.cache;return t}function ui(r,t){var n=r[1],e=t[1],u=n|e,i=u<(v|h|b);var f=e==b&&n==g||e==b&&n==d&&r[7].length<=t[8]||e==(b|d)&&t[7].length<=t[8]&&n==g;if(!(i||f)){return r}if(e&v){r[2]=t[2];u|=n&v?0:p}var o=t[3];if(o){var c=r[3];r[3]=c?au(c,o,t[4]):o;r[4]=c?St(r[3],a):t[4]}o=t[5];if(o){c=r[5];r[5]=c?fu(c,o,t[6]):o;r[6]=c?St(r[5],a):t[6]}o=t[7];if(o){r[7]=o}if(e&b){r[8]=r[8]==null?t[8]:fn(r[8],t[8])}if(r[9]==null){r[9]=t[9]}r[0]=t[0];r[1]=u;return r}function ii(r){var t=[];if(r!=null){for(var n in Object(r)){t.push(n)}}return t}function ai(r){return Rt.call(r)}function fi(t,n,e){n=an(n===r?t.length-1:n,0);return function(){var r=arguments,u=-1,i=an(r.length-n,0),a=Array(i);while(++u<i){a[u]=r[n+u]}u=-1;var f=Array(n+1);while(++u<n){f[u]=r[u]}f[n]=e(a);return ut(t,this,f)}}function oi(r,t){return t.length<2?r:ye(r,Ge(t,0,-1))}function ci(t,n){var e=t.length,u=fn(n.length,e),i=ou(t);while(u--){var a=n[u];t[u]=Hu(a,e)?i[a]:r}return t}function li(r,t){if(t==="constructor"&&typeof r[t]==="function"){return}if(t=="__proto__"){return}return r[t]}var si=pi(Ne);var vi=pi(Ve);function hi(r,t,n){var e=t+"";return vi(r,Gu(e,wi(Ru(e),n)))}function pi(t){var n=0,e=0;return function(){var u=on(),i=O-(u-e);e=u;if(i>0){if(++n>=m){return arguments[0]}}else{n=0}return t.apply(r,arguments)}}var gi=ei(function(r){var t=[];if(r.charCodeAt(0)===46){t.push("")}r.replace(cr,function(r,n,e,u){t.push(e?u.replace(yr,"$1"):n||r)});return t});function yi(r){if(typeof r=="string"||ga(r)){return r}var t=r+"";return t=="0"&&1/r==-A?"-0":t}function _i(r){if(r!=null){try{return Dt.call(r)}catch(r){}try{return r+""}catch(r){}}return""}function wi(r,t){it(E,function(n){var e="_."+n[0];if(t&n[1]&&!ft(r,e)){r.push(e)}});return r.sort()}function bi(r){var t=-1,n=r==null?0:r.length,e=0,u=[];while(++t<n){var i=r[t];if(i){u[e++]=i}}return u}var di=Ce(function(r,t){return na(r)?le(r,he(t,1,na,true)):[]});var ji=Ce(function(t,n){var e=Ei(n);if(na(e)){e=r}return na(t)?le(t,he(n,1,na,true),Bu(e,2)):[]});var mi=Ce(function(t,n){var e=Ei(n);if(na(e)){e=r}return na(t)?le(t,he(n,1,na,true),r,e):[]});function Oi(r){var t=r==null?0:r.length;return t?he(r,1):[]}function Ai(r){var t=r==null?0:r.length;return t?he(r,A):[]}function xi(t,n){var e=t==null?0:t.length;if(!e){return[]}n=n===r?1:ba(n);return he(t,n)}var zi=Ce(function(r){var t=ct(r,Ye);return t.length&&t[0]===r[0]?je(t):[]});var ki=Ce(function(t){var n=Ei(t),e=ct(t,Ye);if(n===Ei(e)){n=r}else{e.pop()}return e.length&&e[0]===t[0]?je(e,Bu(n,2)):[]});var Si=Ce(function(t){var n=Ei(t),e=ct(t,Ye);n=typeof n=="function"?n:r;if(n){e.pop()}return e.length&&e[0]===t[0]?je(e,r,n):[]});function Ei(t){var n=t==null?0:t.length;return n?t[n-1]:r}var Ti=Ce(function(r){return He(he(r,1,na,true))});var $i=Ce(function(t){var n=Ei(t);if(na(n)){n=r}return He(he(t,1,na,true),Bu(n,2))});var Ii=Ce(function(t){var n=Ei(t);n=typeof n=="function"?n:r;return He(he(t,1,na,true),r,n)});function Bi(r){return r&&r.length?He(r):[]}function Wi(r,t){return r&&r.length?He(r,Bu(t,2)):[]}function Li(t,n){n=typeof n=="function"?n:r;return t&&t.length?He(t,r,n):[]}var Mi=Ce(function(r,t){return na(r)?le(r,t):[]});var Pi=Ce(function(r){return Qe(at(r,na))});var Di=Ce(function(t){var n=Ei(t);if(na(n)){n=r}return Qe(at(t,na),Bu(n,2))});var Fi=Ce(function(t){var n=Ei(t);n=typeof n=="function"?n:r;return Qe(at(t,na),r,n)});function qi(r,t){return Xe(r||[],t||[],ue)}function Ri(r,t){return Xe(r||[],t||[],Ue)}function Ci(r,t){return he(Vi(r,t),1)}function Ui(r,t){return he(Vi(r,t),A)}function Ni(t,n,e){e=e===r?1:ba(e);return he(Vi(t,n),e)}function Vi(r,t){var n=ra(r)?ct:We;return n(r,Bu(t,3))}var Gi=function(){return Jr.Date.now()};function Ki(t,n,e){n=e?r:n;var u=mu(t,g,r,r,r,r,r,n);u.placeholder=Ki.placeholder;return u}function Hi(t,n,u){var i,a,f,o,c,l,s=0,v=false,h=false,p=true;if(typeof t!="function"){throw new TypeError(e)}n=da(n)||0;if(oa(u)){v=!!u.leading;h="maxWait"in u;f=h?an(da(u.maxWait)||0,n):f;p="trailing"in u?!!u.trailing:p}function g(n){var e=i,u=a;i=a=r;s=n;o=t.apply(u,e);return o}function y(r){s=r;c=setTimeout(b,n);return v?g(r):o}function _(r){var t=r-l,e=r-s,u=n-t;return h?fn(u,f-e):u}function w(t){var e=t-l,u=t-s;return l===r||e>=n||e<0||h&&u>=f}function b(){var r=Gi();if(w(r)){return d(r)}c=setTimeout(b,_(r))}function d(t){c=r;if(p&&i){return g(t)}i=a=r;return o}function j(){if(c!==r){clearTimeout(c)}s=0;i=l=a=c=r}function m(){return c===r?o:d(Gi())}function O(){var t=Gi(),e=w(t);i=arguments;a=this;l=t;if(e){if(c===r){return y(l)}if(h){clearTimeout(c);c=setTimeout(b,n);return g(l)}}if(c===r){c=setTimeout(b,n)}return o}O.cancel=j;O.flush=m;return O}function Ji(r,t){if(typeof r!="function"||t!=null&&typeof t!="function"){throw new TypeError(e)}var n=function(){var e=arguments,u=t?t.apply(this,e):e[0],i=n.cache;if(i.has(u)){return i.get(u)}var a=r.apply(this,e);n.cache=i.set(u,a)||i;return a};n.cache=new(Ji.Cache||Rn);return n}Ji.Cache=Rn;function Qi(r,t,n){var u=true,i=true;if(typeof r!="function"){throw new TypeError(e)}if(oa(n)){u="leading"in n?!!n.leading:u;i="trailing"in n?!!n.trailing:i}return Hi(r,t,{leading:u,maxWait:t,trailing:i})}function Xi(){if(!arguments.length){return[]}var r=arguments[0];return ra(r)?r:[r]}function Yi(r,t){return r===t||r!==r&&t!==t}var Zi=me(function(){return arguments}())?me:function(r){return ca(r)&&Ft.call(r,"callee")&&!Qt.call(r,"callee")};var ra=Array.isArray;function ta(r){return r!=null&&fa(r.length)&&!aa(r)}function na(r){return ca(r)&&ta(r)}var ea=en||Fa;function ua(r,t){return Oe(r,t)}function ia(t,n,e){e=typeof e=="function"?e:r;var u=e?e(t,n):r;return u===r?Oe(t,n,r,e):!!u}function aa(r){if(!oa(r)){return false}var t=we(r);return t==M||t==P||t==I||t==U}function fa(r){return typeof r=="number"&&r>-1&&r%1==0&&r<=x}function oa(r){var t=typeof r;return r!=null&&(t=="object"||t=="function")}function ca(r){return r!=null&&typeof r=="object"}var la=tt?bt(tt):xe;function sa(r){return r==null}function va(r){if(!ca(r)||we(r)!=R){return false}var t=Ht(r);if(t===null){return true}var n=Ft.call(t,"constructor")&&t.constructor;return typeof n=="function"&&n instanceof n&&Dt.call(n)==Ct}var ha=nt?bt(nt):Se;function pa(r){return typeof r=="string"||!ra(r)&&ca(r)&&we(r)==G}function ga(r){return typeof r=="symbol"||ca(r)&&we(r)==K}var ya=et?bt(et):Ee;function _a(r){if(!r){return[]}if(ta(r)){return pa(r)?$t(r):ou(r)}if(Zt&&r[Zt]){return xt(r[Zt]())}var t=qu(r),n=t==D?zt:t==V?Et:Ia;return n(r)}function wa(r){if(!r){return r===0?r:0}r=da(r);if(r===A||r===-A){var t=r<0?-1:1;return t*z}return r===r?r:0}function ba(r){var t=wa(r),n=t%1;return t===t?n?t-n:t:0}function da(r){if(typeof r=="number"){return r}if(ga(r)){return k}if(oa(r)){var t=typeof r.valueOf=="function"?r.valueOf():r;r=oa(t)?t+"":t}if(typeof r!="string"){return r===0?r:+r}r=wt(r);var n=br.test(r);return n||jr.test(r)?Gr(r.slice(2),n?2:8):wr.test(r)?k:+r}function ja(r){return cu(r,za(r))}function ma(r){return r==null?"":Ke(r)}function Oa(t,n,e){var u=t==null?r:ye(t,n);return u===r?e:u}function Aa(r,t){return r!=null&&Cu(r,t,de)}function xa(r){return ta(r)?ne(r):$e(r)}function za(r){return ta(r)?ne(r,true):Ie(r)}var ka=vu(function(r,t,n){Pe(r,t,n)});var Sa=vu(function(r,t,n,e){Pe(r,t,n,e)});var Ea=ku(function(r,t){var n={};if(r==null){return n}var e=false;t=ct(t,function(t){t=Ze(t,r);e||(e=t.length>1);return t});cu(r,Eu(r),n);if(e){n=ce(n,f|o|c,Ou)}var u=t.length;while(u--){Je(n,t[u])}return n});var Ta=ku(function(r,t){return r==null?{}:Fe(r,t)});function $a(r,t){if(r==null){return{}}var n=ct(Eu(r),function(r){return[r]});t=Bu(t);return qe(r,n,function(r,n){return t(r,n[0])})}function Ia(r){return r==null?[]:dt(r,xa(r))}function Ba(r){return function(){return r}}function Wa(r){return r}function La(r){return Te(typeof r=="function"?r:ce(r,f))}function Ma(){}function Pa(r){return Qu(r)?yt(yi(r)):Re(r)}function Da(){return[]}function Fa(){return false}function qa(t){return t&&t.length?ve(t,Wa,be):r}function Ra(t){return t&&t.length?ve(t,Wa,Be):r}xn.castArray=Xi;xn.compact=bi;xn.constant=Ba;xn.curry=Ki;xn.debounce=Hi;xn.difference=di;xn.differenceBy=ji;xn.differenceWith=mi;xn.flatMap=Ci;xn.flatMapDeep=Ui;xn.flatMapDepth=Ni;xn.flatten=Oi;xn.flattenDeep=Ai;xn.flattenDepth=xi;xn.intersection=zi;xn.intersectionBy=ki;xn.intersectionWith=Si;xn.iteratee=La;xn.keys=xa;xn.keysIn=za;xn.map=Vi;xn.memoize=Ji;xn.merge=ka;xn.mergeWith=Sa;xn.omit=Ea;xn.pick=Ta;xn.pickBy=$a;xn.property=Pa;xn.throttle=Qi;xn.toArray=_a;xn.toPlainObject=ja;xn.union=Ti;xn.unionBy=$i;xn.unionWith=Ii;xn.uniq=Bi;xn.uniqBy=Wi;xn.uniqWith=Li;xn.values=Ia;xn.without=Mi;xn.xor=Pi;xn.xorBy=Di;xn.xorWith=Fi;xn.zipObject=qi;xn.zipObjectDeep=Ri;xn.eq=Yi;xn.get=Oa;xn.hasIn=Aa;xn.identity=Wa;xn.isArguments=Zi;xn.isArray=ra;xn.isArrayLike=ta;xn.isArrayLikeObject=na;xn.isBuffer=ea;xn.isEqual=ua;xn.isEqualWith=ia;xn.isFunction=aa;xn.isLength=fa;xn.isMap=la;xn.isNil=sa;xn.isObject=oa;xn.isObjectLike=ca;xn.isPlainObject=va;xn.isSet=ha;xn.isString=pa;xn.isSymbol=ga;xn.isTypedArray=ya;xn.last=Ei;xn.max=qa;xn.min=Ra;xn.stubArray=Da;xn.stubFalse=Fa;xn.noop=Ma;xn.now=Gi;xn.toFinite=wa;xn.toInteger=ba;xn.toNumber=da;xn.toString=ma;xn.VERSION=t;Ki.placeholder=xn;return xn});
/*!
 * Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)
 * Version 2.0.0, see https://github.com/sindresorhus/p-cancelable/tree/v2.0.0
 */
sap.ui.predefine("sap/base/util/restricted/_CancelablePromise", function(){"use strict";function e(e,n){var r;if(typeof Symbol==="undefined"||e[Symbol.iterator]==null){if(Array.isArray(e)||(r=t(e))||n&&e&&typeof e.length==="number"){if(r)e=r;var o=0;var i=function e(){};return{s:i,n:function t(){if(o>=e.length)return{done:true};return{done:false,value:e[o++]}},e:function e(t){throw t},f:i}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var u=true,c=false,f;return{s:function t(){r=e[Symbol.iterator]()},n:function e(){var t=r.next();u=t.done;return t},e:function e(t){c=true;f=t},f:function e(){try{if(!u&&r.return!=null)r.return()}finally{if(c)throw f}}}}function t(e,t){if(!e)return;if(typeof e==="string")return n(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);if(r==="Object"&&e.constructor)r=e.constructor.name;if(r==="Map"||r==="Set")return Array.from(e);if(r==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return n(e,t)}function n(e,t){if(t==null||t>e.length)t=e.length;for(var n=0,r=new Array(t);n<t;n++){r[n]=e[n]}return r}function r(e){"@babel/helpers - typeof";if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){r=function e(t){return typeof t}}else{r=function e(t){return t&&typeof Symbol==="function"&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t}}return r(e)}function o(e,t){if(!(e instanceof t)){throw new TypeError("Cannot call a class as a function")}}function i(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||false;r.configurable=true;if("value"in r)r.writable=true;Object.defineProperty(e,r.key,r)}}function u(e,t,n){if(t)i(e.prototype,t);if(n)i(e,n);return e}function c(e,t){if(typeof t!=="function"&&t!==null){throw new TypeError("Super expression must either be null or a function")}e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:true,configurable:true}});if(t)d(e,t)}function f(e){var t=y();return function n(){var r=b(e),o;if(t){var i=b(this).constructor;o=Reflect.construct(r,arguments,i)}else{o=r.apply(this,arguments)}return a(this,o)}}function a(e,t){if(t&&(r(t)==="object"||typeof t==="function")){return t}return l(e)}function l(e){if(e===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return e}function s(e){var t=typeof Map==="function"?new Map:undefined;s=function e(n){if(n===null||!h(n))return n;if(typeof n!=="function"){throw new TypeError("Super expression must either be null or a function")}if(typeof t!=="undefined"){if(t.has(n))return t.get(n);t.set(n,r)}function r(){return p(n,arguments,b(this).constructor)}r.prototype=Object.create(n.prototype,{constructor:{value:r,enumerable:false,writable:true,configurable:true}});return d(r,n)};return s(e)}function p(e,t,n){if(y()){p=Reflect.construct}else{p=function e(t,n,r){var o=[null];o.push.apply(o,n);var i=Function.bind.apply(t,o);var u=new i;if(r)d(u,r.prototype);return u}}return p.apply(null,arguments)}function y(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Date.prototype.toString.call(Reflect.construct(Date,[],function(){}));return true}catch(e){return false}}function h(e){return Function.toString.call(e).indexOf("[native code]")!==-1}function d(e,t){d=Object.setPrototypeOf||function e(t,n){t.__proto__=n;return t};return d(e,t)}function b(e){b=Object.setPrototypeOf?Object.getPrototypeOf:function e(t){return t.__proto__||Object.getPrototypeOf(t)};return b(e)}var v=function(e){c(n,e);var t=f(n);function n(e){var r;o(this,n);r=t.call(this,e||"Promise was canceled");r.name="CancelError";return r}u(n,[{key:"isCanceled",get:function e(){return true}}]);return n}(s(Error));var m=function(){u(t,null,[{key:"fn",value:function e(n){return function(){for(var e=arguments.length,r=new Array(e),o=0;o<e;o++){r[o]=arguments[o]}return new t(function(e,t,o){r.push(o);n.apply(void 0,r).then(e,t)})}}}]);function t(e){var n=this;o(this,t);this._cancelHandlers=[];this._isPending=true;this._isCanceled=false;this._rejectOnCancel=true;this._promise=new Promise(function(t,r){n._reject=r;var o=function e(r){n._isPending=false;t(r)};var i=function e(t){n._isPending=false;r(t)};var u=function e(t){if(!n._isPending){throw new Error("The `onCancel` handler was attached after the promise settled.")}n._cancelHandlers.push(t)};Object.defineProperties(u,{shouldReject:{get:function e(){return n._rejectOnCancel},set:function e(t){n._rejectOnCancel=t}}});return e(o,i,u)})}u(t,[{key:"then",value:function e(t,n){return this._promise.then(t,n)}},{key:"catch",value:function e(t){return this._promise.catch(t)}},{key:"finally",value:function e(t){return this._promise.finally(t)}},{key:"cancel",value:function t(n){if(!this._isPending||this._isCanceled){return}if(this._cancelHandlers.length>0){try{var r=e(this._cancelHandlers),o;try{for(r.s();!(o=r.n()).done;){var i=o.value;i()}}catch(e){r.e(e)}finally{r.f()}}catch(e){this._reject(e)}}this._isCanceled=true;if(this._rejectOnCancel){this._reject(new v(n))}}},{key:"isCanceled",get:function e(){return this._isCanceled}}]);return t}();Object.setPrototypeOf(m.prototype,Promise.prototype);m.CancelError=v;return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_castArray", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.castArray});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_compact", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.compact});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_curry", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.curry});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_debounce", ["sap/base/util/restricted/_/lodash.custom"],function(e){"use strict";return e.debounce});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_difference", ["sap/base/util/restricted/_/lodash.custom"],function(e){"use strict";return e.difference});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_differenceBy", ["sap/base/util/restricted/_/lodash.custom"],function(e){"use strict";return e.differenceBy});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_differenceWith", ["sap/base/util/restricted/_/lodash.custom"],function(e){"use strict";return e.differenceWith});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_flatMap", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.flatMap});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_flatMapDeep", ["sap/base/util/restricted/_/lodash.custom"],function(e){"use strict";return e.flatMapDeep});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_flatMapDepth", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.flatMapDepth});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_flatten", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.flatten});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_flattenDeep", ["sap/base/util/restricted/_/lodash.custom"],function(e){"use strict";return e.flattenDeep});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_flattenDepth", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.flattenDepth});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_intersection", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.intersection});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_intersectionBy", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.intersectionBy});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_intersectionWith", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.intersectionWith});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_isEqual", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.isEqual});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_isEqualWith", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.isEqualWith});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_isNil", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.isNil});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_max", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.max});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_merge", ["sap/base/util/restricted/_/lodash.custom"],function(e){"use strict";return e.merge});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_mergeWith", ["sap/base/util/restricted/_/lodash.custom"],function(e){"use strict";return e.mergeWith});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_min", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.min});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_omit", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.omit});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_pick", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.pick});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_pickBy", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.pickBy});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_throttle", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.throttle});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_toArray", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.toArray});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_union", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.union});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_unionBy", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.unionBy});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_unionWith", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.unionWith});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_uniq", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.uniq});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_uniqBy", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.uniqBy});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_uniqWith", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.uniqWith});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_without", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.without});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_xor", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.xor});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_xorBy", ["sap/base/util/restricted/_/lodash.custom"],function(s){"use strict";return s.xorBy});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_xorWith", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.xorWith});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_zipObject", ["sap/base/util/restricted/_/lodash.custom"],function(t){"use strict";return t.zipObject});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/restricted/_zipObjectDeep", ["sap/base/util/restricted/_/lodash.custom"],function(e){"use strict";return e.zipObjectDeep});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/syncFetch", ["./fetch","sap/ui/base/SyncPromise"],function(n,t){"use strict";function e(){var n=this.text;var t=this.json;this.text=function(){return n().unwrap()};this.json=function(){return t().unwrap()}}function i(i,r){return n(i,r,{promiseImpl:t,responseMixin:e}).unwrap()}i.ContentTypes=n.ContentTypes;return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/values", function(){"use strict";var e=function e(n){if(typeof n==="undefined"||n===null||n!==n){return[]}return Object.values(n)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ManagedObjectObserver", ["sap/ui/base/Object","sap/ui/base/ManagedObject","sap/ui/base/EventProvider","sap/base/util/array/uniqueSort","sap/base/util/deepExtend"],function(e,n,t,r,i){"use strict";var a=e.extend("sap.ui.base.ManagedObjectObserver",{constructor:function(n){if(!n&&typeof n!=="function"){throw new Error("Missing callback function in ManagedObjectObserver constructor")}e.call(this);this._fnCallback=n}});a.prototype.observe=function(e,t){if(!(e instanceof n)){if(e==null){return}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but observe was called for "+e)}A(e,t);l(e,this,t)};a.prototype.unobserve=function(e,t){if(!(e instanceof n)){if(e==null){return}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but unobserve was called for "+e)}if(t){A(e,t)}p(e,this,t)};a.prototype.isObserved=function(e,t){if(!(e instanceof n)){if(e==null){return false}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but isObserved was called for "+e)}return v(e,this,t)};a.prototype.disconnect=function(){b(this)};a.prototype.getConfiguration=function(e){return d(e,this)};var s={},o=Object.create(null),u=new WeakMap;s.propertyChange=function(e,n,t,r){c("properties",e,n,function(){return{type:"property",old:t,current:r}})};s.aggregationChange=function(e,n,t,r){c("aggregations",e,n,function(){return{type:"aggregation",mutation:t,children:Array.isArray(r)?r:null,child:!Array.isArray(r)?r:null}})};s.parentChange=function(e,n,t,r){c("parent",e,n,function(){return{type:"parent",mutation:t,parent:r}});var i=t==="unset"?"remove":"insert";s.aggregationChange(r,n,i,e)};s.associationChange=function(e,n,t,r){c("associations",e,n,function(){return{type:"association",mutation:t,ids:r}})};s.eventChange=function(e,n,t,r,i,a){c("events",e,n,function(){return{type:"event",mutation:t,listener:r,func:i,data:a}})};s.bindingChange=function(e,n,t,r,i){c("bindings",e,n,function(){return{type:"binding",mutation:t,bindingInfo:r,memberType:i}})};s.objectDestroyed=function(e){c("destroy",e,null,function(){return{type:"destroy"}});f(e)};function f(e){var n=e.getId();if(o[n]){e.detachEvent("EventHandlerChange",O);for(var t=0;t<o[n].listeners.length;t++){var r=u.get(o[n].listeners[t]);if(r){r.delete(n)}}delete o[n]}delete e._observer}function c(e,n,t,r){var i=n.getId(),a=o[i];if(a){var s;for(var u=0;u<a.listeners.length;u++){if(g(a.configurations[u],e,t)){if(!s){s=r();s.name=t;s.object=n}var f=a.listeners[u];f._fnCallback(s)}}}}function g(e,n,t){if(e==null||!n){return false}if(n!="destroy"&&n!="parent"&&!t){return false}return e[n]===true||Array.isArray(e[n])&&e[n].indexOf(t)>-1}function l(e,n,t){h(e,n,t,false)}function d(e,n){var t=e.getId();var r=o[t];if(r&&r.listeners){var a=r.listeners.indexOf(n);if(a>=0){var s=i({},r.configurations[a]);return s}}return null}function p(e,n,t){t=t||d(e,n);h(e,n,t,true)}function v(e,n,t){var r=e.getId(),i=o[r];t=t||d(e,n);if(!i){return false}var a=i.listeners.indexOf(n);if(a===-1){return false}else{return j(i.configurations[a].properties,t.properties)&&j(i.configurations[a].aggregations,t.aggregations)&&j(i.configurations[a].associations,t.associations)&&j(i.configurations[a].bindings,t.bindings)&&j(i.configurations[a].events,t.events)&&E(i.configurations[a].destroy,t.destroy)&&E(i.configurations[a].parent,t.parent)}}function b(e){var n=u.get(e);if(!n){return}n.forEach(function(n){var t=o[n];for(var r=0;r<t.listeners.length;r++){if(t.listeners[r]===e){t.listeners.splice(r,1);t.configurations.splice(r,1)}}if(t.listeners.length===0){delete o[n];t.object._observer=undefined}});u.delete(e)}function h(e,n,r,i){var a=e.getId(),c=o[a],g=u.get(n)||new Set,l,d;if(i){if(!c){return}d=c.listeners.indexOf(n);if(d>=0){l=c.configurations[d]}}else{if(!c){c=o[a]={listeners:[],configurations:[],object:e}}if(g.size===0){u.set(n,g)}g.add(a);d=c.listeners.indexOf(n);if(d===-1){c.listeners.push(n);c.configurations.push(r)}else{l=c.configurations[d]}}if(l){l.properties=l.properties||[];m(l.properties,r.properties,i);l.aggregations=l.aggregations||[];m(l.aggregations,r.aggregations,i);l.associations=l.associations||[];m(l.associations,r.associations,i);l.bindings=l.bindings||[];m(l.bindings,r.bindings,i);l.events=l.events||[];m(l.events,r.events,i);if(r.destroy!=null){if(i){delete l.destroy}else{l.destroy=r.destroy}}if(r.parent!=null){if(i){delete l.parent}else{l.parent=r.parent}}}var p=y(e,"events");if(e._observer&&i){if(!p&&t.hasListener(e,"EventHandlerChange",O)){e.detachEvent("EventHandlerChange",O)}if(!p&&!y(e,"properties")&&!y(e,"aggregations")&&!y(e,"associations")&&!y(e,"destroy")&&!y(e,"parent")&&!y(e,"bindings")){f(e)}}else if(!e._observer&&!i){if(p&&!t.hasListener(e,"EventHandlerChange",O)){e.attachEvent("EventHandlerChange",O)}e._observer=s}}function y(e,n){var t=e.getId(),r=o[t];if(r){var i=r.configurations.filter(function(e){return e.hasOwnProperty(n)&&e[n]&&(e[n]===true||e[n].length>0)});return i.length>0}return false}function O(e){var n=e.getSource(),t=e.mParameters.EventId;if(n.getMetadata().hasEvent(t)){if(e.mParameters.type==="listenerAttached"){s.eventChange(n,t,"insert",e.mParameters.listener,e.mParameters.func,e.mParameters.data)}else if(e.mParameters.type==="listenerDetached"){s.eventChange(n,t,"remove",e.mParameters.listener,e.mParameters.func,e.mParameters.data)}}}function m(e,n,t){if(!n){return}for(var r=0;r<n.length;r++){var i=e.indexOf(n[r]);if(i>-1&&t){e.splice(i,1)}else if(i===-1&&!t){e.push(n[r])}}}function j(e,n){if(!Array.isArray(n)||n.length==0){return true}if(!Array.isArray(e)||e.length==0){return false}var t=r(e.concat(n));return e.length===t.length}function E(e,n){if(n==null){return true}return e===n}function A(e,n){var t=e.getMetadata(),i=Object.keys(t.getAllProperties()),a=Object.keys(t.getAllAggregations()),s=Object.keys(t.getAllAssociations()),o=r(i.concat(a)),u=Object.keys(t.getAllEvents());n.properties=n.properties===true?i:n.properties;n.aggregations=n.aggregations===true?a:n.aggregations;n.associations=n.associations===true?s:n.associations;n.bindings=n.bindings===true?o:n.bindings;n.events=n.events===true?u:n.events;n.destroy=n.destroy==null?false:n.destroy;n.parent=n.parent==null?false:n.parent}return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ObjectPool", ["./Object"],function(t){"use strict";var e=t.extend("sap.ui.base.ObjectPool",{constructor:function(e){t.call(this);this.oObjectClass=e;this.aFreeObjects=[]}});e.prototype.borrowObject=function(){var t=this.aFreeObjects.length==0?new this.oObjectClass:this.aFreeObjects.pop();t.init.apply(t,arguments);return t};e.prototype.returnObject=function(t){t.reset();this.aFreeObjects.push(t)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/AccessKeysEnablement", ["sap/base/config","sap/ui/base/Object","sap/ui/core/Element","sap/ui/Device"],function(e,t,n,i){"use strict";var s=t.extend("sap.ui.core.AccessKeysEnablement",{});s.controlRegistry=new Set;s.CSS_CLASS="sapUiAccKeysHighlighDom";s.bListenersAttached=false;var r=function(){var e=function(e){var t=e.getEnabled&&!e.getEnabled();if(t){return}if(e){e.setProperty("highlightAccKeysRef",true);e.onAccKeysHighlightStart&&e.onAccKeysHighlightStart()}};s.controlRegistry.forEach(function(t){e(t)})};var a=function(){var e=function(e){if(e){e.setProperty("highlightAccKeysRef",false);e.onAccKeysHighlightStart&&e.onAccKeysHighlightEnd()}};s.controlRegistry.forEach(function(t){e(t)})};s.attachKeydownListeners=function(){document.addEventListener("keydown",function(e){if(this.hasHighlightedElements()){e.preventDefault()}this.handleHighlightStart(e);document.addEventListener("keydown",function(e){if(this.hasHighlightedElements()){e.preventDefault()}}.bind(this),{once:true})}.bind(this));document.addEventListener("keyup",function(e){this.handleHighlightEnd(e)}.bind(this));window.addEventListener("blur",function(){this.handleHighlightEnd(true)}.bind(this))};s.handleHighlightStart=function(e){var t=e.altKey;var n=e.key;if(t){r();if(this.hasHighlightedElements()){var i=this.getElementToBeFocused(n);if(!i.length){return}var s=document.activeElement;var a=e.shiftKey;var c=i.indexOf(s);if(a){var o=i[c-1];if(o){o.focus()}else if(c===0){i[i.length-1].focus()}}else{var l=i[c+1];if(l){l.focus()}else if(c===i.length-1){i[0].focus()}}}}};s.hasHighlightedElements=function(){return document.getElementsByClassName(s.CSS_CLASS).length};s.handleHighlightEnd=function(e,t){if(!e.altKey||t){a()}};s.getElementToBeFocused=function(e){return[].filter.call(document.querySelectorAll("[data-ui5-accesskey='"+e.toLowerCase()+"']"),function(e){var t=n.getElementById(e.getAttribute("id"));var i=t.getEnabled?t.getEnabled():true;var s=t.getVisible();return i&&s}).map(function(e){e=n.getElementById(e.getAttribute("id"));return e.getAccessKeysFocusTarget?e.getAccessKeysFocusTarget():e.getFocusDomRef()})};s.registerControl=function(t){var n=e.get({name:"sapUiXxAccKeys",type:e.Type.Boolean,external:true});if(i.os.macintosh){return}this.controlRegistry.add(t);if(n&&!this.bListenersAttached){this.attachKeydownListeners();s.bListenersAttached=true}var r=t.exit;t.exit=function(){s.controlRegistry.delete(t);r&&r.call(t)}};s.deregisterControl=function(e){s.registerControl.delete()};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/AppCacheBuster", ["sap/ui/base/ManagedObject","sap/ui/thirdparty/URI","sap/base/config","sap/base/Log","sap/base/i18n/Localization","sap/base/util/extend","sap/base/util/fetch","sap/base/util/mixedFetch","sap/base/strings/escapeRegExp","sap/ui/core/_IconRegistry"],function(e,t,r,n,o,i,a,s,p,c){"use strict";const u=o.getLanguage();const f=r.get({name:"sapUiXxAppCacheBusterMode",type:r.Type.String,defaultValue:"sync",external:true,freeze:true});const l=f==="sync";const d=f==="batch";var h={index:{},active:false};var y,g,v,b,L;var m=document.baseURI.replace(/\?.*|#.*/g,"");var x=t(sap.ui.require.toUrl("")+"/../");var R=x.toString();if(x.is("relative")){x=x.absoluteTo(m)}var U=x.normalize().toString();var A=t("resources").absoluteTo(U).toString();var C=new RegExp("^"+p(A));var T=function(e){if(e.length>0&&e.slice(-1)!=="/"){e+="/"}return e};var O=function(e,t){var r=h.index;var o;var p;var c;var f,y;if(Array.isArray(e)&&!d){e.forEach(function(e){O(e,t)})}else if(Array.isArray(e)&&d){var g=T(e[0]);var v=[];n.debug('sap.ui.core.AppCacheBuster.register("'+g+'"); // BATCH MODE!');var b=z.normalizeURL(g);n.debug('  --\x3e normalized to: "'+b+'"');e.forEach(function(e){p=T(e);var t=z.normalizeURL(p);if(!r[c]){v.push(t)}});if(v.length>0){p=b+"sap-ui-cachebuster-info.json?sap-ui-language="+u;o={body:v.join("\n"),headers:{Accept:a.ContentTypes.JSON,"Content-Type":"text/plain"},mode:"POST"};f=function(e){z.onIndexLoaded(p,e);i(r,e)};y=function(e){n.error('Failed to batch load AppCacheBuster index file from: "'+e+'".')}}}else{e=T(e);n.debug('sap.ui.core.AppCacheBuster.register("'+e+'");');c=z.normalizeURL(e);n.debug('  --\x3e normalized to: "'+c+'"');if(!r[c]){p=c+"sap-ui-cachebuster-info.json?sap-ui-language="+u;o={headers:{Accept:a.ContentTypes.JSON},mode:"POST"};f=function(e){z.onIndexLoaded(p,e);r[c]=e};y=function(e){n.error('Failed to load AppCacheBuster index file from: "'+e+'".')}}}if(o){var L=z.onIndexLoad(p);if(L!=null){n.info('AppCacheBuster index file injected for: "'+p+'".');f(L)}else{var m=!l&&!!t;if(m){var x=t.startTask("load "+p);var R=f,U=y;f=function(e){R.apply(this,arguments);t.finishTask(x)};y=function(){U.apply(this,arguments);t.finishTask(x,false)}}n.info('Loading AppCacheBuster index file from: "'+p+'".');a=s?s:a;a(p,o,!m).then(function(e){if(e.ok){return e.json()}else{throw new Error("Status code: "+e.status)}}).then(f).catch(function(){y(p)})}}};var z={boot:function(e,r){if(r&&r.length>0){var n=true;var o=String(r[0]).toLowerCase();if(r.length===1){if(o==="true"||o==="x"){var i=t(R);r=i.is("relative")?[i.toString()]:[]}else if(o==="false"){n=false}}if(n){z.init();O(r,e)}}},init:function(){h.active=true;y=e.prototype.validateProperty;g=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src");v=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href");var t=z.convertURL;var r=z.normalizeURL;var o=function(e){if(this.active===true&&e&&typeof e==="string"){e=r(e);return!e.match(C)}return false}.bind(h);b=XMLHttpRequest.prototype.open;XMLHttpRequest.prototype.open=function(e,r){if(r&&o(r)){arguments[1]=t(r)}b.apply(this,arguments)};L=XMLHttpRequest.prototype.open;e.prototype.validateProperty=function(e,r){var n=this.getMetadata(),i=n.getProperty(e),a;if(i&&i.type==="sap.ui.core.URI"){a=Array.prototype.slice.apply(arguments);try{if(o(a[1])){a[1]=t(a[1])}}catch(e){}}return y.apply(this,a||arguments)};c._convertUrl=function(e){return t(e)};var i=function(e){var r={get:e.get,set:function(r){if(o(r)){r=t(r)}e.set.call(this,r)},enumerable:e.enumerable,configurable:e.configurable};r.set._sapUiCoreACB=true;return r};var a=false;try{Object.defineProperty(HTMLScriptElement.prototype,"src",i(g))}catch(e){n.error("Your browser doesn't support redefining the src property of the script tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+e);a=true}try{Object.defineProperty(HTMLLinkElement.prototype,"href",i(v))}catch(e){n.error("Your browser doesn't support redefining the href property of the link tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+e);a=true}if(a){this.exit()}},exit:function(){e.prototype.validateProperty=y;delete c._convertUrl;if(XMLHttpRequest.prototype.open===L){XMLHttpRequest.prototype.open=b}var t;if((t=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src"))&&t.set&&t.set._sapUiCoreACB===true){Object.defineProperty(HTMLScriptElement.prototype,"src",g)}if((t=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href"))&&t.set&&t.set._sapUiCoreACB===true){Object.defineProperty(HTMLLinkElement.prototype,"href",v)}h.index={};h.active=false;h={index:{},active:false}},register:function(e){O(e)},convertURL:function(e){n.debug('sap.ui.core.AppCacheBuster.convertURL("'+e+'");');var t=h.index;if(t&&e&&!/^#/.test(e)){var r=z.normalizeURL(e);n.debug('  --\x3e normalized to: "'+r+'"');if(r&&z.handleURL(r)){for(var o in t){var i=t[o],a,s;if(o&&r.length>=o.length&&r.slice(0,o.length)===o){a=r.slice(o.length);s=a.match(/([^?#]*)/)[1];if(i[s]){e=o+"~"+i[s]+"~/"+a;n.debug('  ==> rewritten to "'+e+'";');break}}}}}return e},normalizeURL:function(e){var r=t(e||"./");if(r.is("relative")){r=r.absoluteTo(m)}return r.normalizeProtocol().normalizeHostname().normalizePort().normalizePath().toString()},handleURL:function(e){return true},onIndexLoad:function(e){return null},onIndexLoaded:function(e,t){}};const E=r.get({name:"sapUiXxAppCacheBusterHooks",type:r.Type.Object,defaultValue:undefined,freeze:true});if(E){["handleURL","onIndexLoad","onIndexLoaded"].forEach(function(e){if(typeof E[e]==="function"){z[e]=E[e]}})}return z},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/BlockLayerUtils", ["sap/ui/events/jquery/EventTriggerHook","sap/base/Log","sap/ui/core/Lib","sap/ui/thirdparty/jquery"],function(e,t,i,jQuery){"use strict";var a={},r=["focusin","focusout","keydown","keypress","keyup","mousedown","touchstart","touchmove","mouseup","touchend","click"],n=/^(?:area|base|br|col|embed|hr|img|input|keygen|link|menuitem|meta|param|source|track|wbr|tr)$/i;a.block=function(e,i,a){var r,l,u,c;if(e){r=e.getDomRef(a);if(!r){r=e.getDomRef()}if(!r){t.warning("BlockLayer could not be rendered. The outer Control instance is not valid anymore or was not rendered yet.");return}l=r.tagName;if(n.test(l)){t.warning("BusyIndicator cannot be placed in elements with tag '"+l+"'.");return}c=o(r,i);u={$parent:jQuery(r),$blockLayer:jQuery(c),control:e};if(u.$parent.css("position")=="static"){if(r.style&&r.style.position==="static"){u.originalPosition="static"}u.$parent.css("position","relative");u.positionChanged=true}s.call(u,true)}else{t.warning("BlockLayer couldn't be created. No Control instance given.")}return u};a.unblock=function(e){if(e){if(e.originalPosition){e.$parent.css("position",e.originalPosition)}else if(e.positionChanged){e.$parent.css("position","")}s.call(e,false);if(e.control&&e.$blockLayer[0]&&e.$blockLayer[0].contains(document.activeElement)){e.control.focus()}e.$blockLayer.remove()}};a.addAriaAttributes=function(e){var t=i.getResourceBundleFor("sap.ui.core");e.setAttribute("role","progressbar");e.setAttribute("aria-valuemin","0");e.setAttribute("aria-valuemax","100");e.setAttribute("aria-valuetext",t.getText("BUSY_VALUE_TEXT"));e.setAttribute("alt","");e.setAttribute("tabindex","0");e.setAttribute("title",t.getText("BUSY_TEXT"))};a.toggleAnimationStyle=function(e,t){var i=jQuery(e.$blockLayer.get(0));if(t){i.removeClass("sapUiHiddenBusyIndicatorAnimation");i.removeClass("sapUiBlockLayerOnly")}else{i.addClass("sapUiBlockLayerOnly");i.addClass("sapUiHiddenBusyIndicatorAnimation")}};function o(e,t){var i=document.createElement("div");i.id=t;i.className="sapUiBlockLayer ";a.addAriaAttributes(i);e.appendChild(i);return i}function s(i){if(i){var a=this.$parent.get(0);if(a){this.fnRedirectFocus=o.bind(this);this.oTabbableBefore=s(this.fnRedirectFocus);this.oTabbableAfter=s(this.fnRedirectFocus);a.parentNode.insertBefore(this.oTabbableBefore,a);a.parentNode.insertBefore(this.oTabbableAfter,a.nextSibling);this._fnSuppressDefaultAndStopPropagationHandler=n.bind(this);this._aSuppressHandler=u.call(this,this._fnSuppressDefaultAndStopPropagationHandler)}else{t.warning("fnHandleInteraction called with bEnabled true, but no DOMRef exists!")}}else{if(this.oTabbableBefore){l(this.oTabbableBefore,this.fnRedirectFocus);delete this.oTabbableBefore}if(this.oTabbableAfter){l(this.oTabbableAfter,this.fnRedirectFocus);delete this.oTabbableAfter}delete this.fnRedirectFocus;c.call(this,this._fnSuppressDefaultAndStopPropagationHandler)}function n(e){var i=e.target===this.$blockLayer.get(0),a;if(i&&e.type==="keydown"&&e.keyCode===9){t.debug("Local Busy Indicator Event keydown handled: "+e.type);a=e.shiftKey?this.oTabbableBefore:this.oTabbableAfter;a.setAttribute("tabindex",-1);this.bIgnoreFocus=true;a.focus();this.bIgnoreFocus=false;a.setAttribute("tabindex",0);e.stopImmediatePropagation()}else if(i&&(e.type==="mousedown"||e.type==="touchstart")){t.debug("Local Busy Indicator click handled on busy area: "+e.target.id);e.stopImmediatePropagation()}else{t.debug("Local Busy Indicator Event Suppressed: "+e.type);e.preventDefault();e.stopImmediatePropagation()}}function o(){if(!this.bIgnoreFocus){this.$blockLayer.get(0).focus()}}function s(e){var t=document.createElement("span");t.setAttribute("tabindex",0);t.classList.add("sapUiBlockLayerTabbable");t.addEventListener("focusin",e);return t}function l(e,t){if(e.parentNode){e.parentNode.removeChild(e)}e.removeEventListener("focusin",t)}function u(t){var i=[],a=this.$parent.get(0),n=this.$blockLayer.get(0);for(var o=0;o<r.length;o++){a.addEventListener(r[o],t,{capture:true,passive:false});i.push(e.suppress(r[o],a,n))}this.$blockLayer.on("keydown",t);return i}function c(t){var i,a=this.$parent.get(0),n=this.$blockLayer.get(0);if(a){for(i=0;i<r.length;i++){a.removeEventListener(r[i],t,{capture:true,passive:false})}}if(this._aSuppressHandler){for(i=0;i<this._aSuppressHandler.length;i++){e.release(this._aSuppressHandler[i])}}if(n){this.$blockLayer.off("keydown",t)}}}return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/BusyIndicator", ["sap/ui/thirdparty/jquery","../base/EventProvider","./Popup","./BusyIndicatorUtils","sap/ui/core/Core","sap/ui/core/library","sap/ui/core/Lib","sap/ui/performance/trace/FESR","sap/ui/performance/trace/Interaction","sap/base/Log","sap/base/assert","sap/base/util/now"],function(jQuery,e,t,s,i,o,n,a,u,r,d,p){"use strict";var l=o.BusyIndicatorSize;var c=Object.assign(new e,{oPopup:null,oDomRef:null,bOpenRequested:false,iDEFAULT_DELAY_MS:1e3,sDOM_ID:"sapUiBusyIndicator"});c.M_EVENTS={Open:"Open",Close:"Close"};c._bShowIsDelayed=undefined;c._init=function(){var e=document.createElement("div");e.id=this.sDOM_ID;var i=document.createElement("div");this._oResBundle=n.getResourceBundleFor("sap.ui.core");var o=this._oResBundle.getText("BUSY_TEXT");delete this._oResBundle;i.className="sapUiBusy";i.setAttribute("tabindex","0");i.setAttribute("role","progressbar");i.setAttribute("alt","");i.setAttribute("title",o);e.appendChild(i);var a=s.getElement(l.Large);a.setAttribute("title",o);e.appendChild(a);this.oDomRef=e;this.oPopup=new t(e);this.oPopup.setModal(true,"sapUiBlyBusy");this.oPopup.setShadow(false);this.oPopup.attachOpened(function(e){this._onOpen(e)},this)};c._onOpen=function(e){var t=document.getElementById(c.sDOM_ID);t.style.height="100%";t.style.width="100%";var s=t.querySelector(".sapUiLocalBusyIndicator");s.className+=" sapUiLocalBusyIndicatorFade";if(t){t.focus()}this.fireOpen({$Busy:this.oPopup._$()})};c.show=function(e){r.debug("sap.ui.core.BusyIndicator.show (delay: "+e+") at "+Date.now());d(e===undefined||typeof e=="number"&&e%1==0,"iDelay must be empty or an integer");if(c._bShowIsDelayed===undefined){c._bShowIsDelayed=true;i.ready(function(){c._bShowIsDelayed=undefined;if(e===undefined||e!=0&&parseInt(e)==0||parseInt(e)<0){e=this.iDEFAULT_DELAY_MS}if(a.getActive()){this._fDelayedStartTime=p()+e}if(!this.oDomRef){this._init()}this.bOpenRequested=true;if(e===0){this._showNowIfRequested()}else{setTimeout(this["_showNowIfRequested"].bind(this),e)}}.bind(this))}};c._showNowIfRequested=function(){r.debug("sap.ui.core.BusyIndicator._showNowIfRequested (bOpenRequested: "+this.bOpenRequested+") at "+Date.now());if(!this.bOpenRequested){return}var e=window.scrollX===undefined?window.pageXOffset:window.scrollX;var s=window.scrollY===undefined?window.pageYOffset:window.scrollY;var i=e+" "+s;this.bOpenRequested=false;this.oPopup.open(0,t.Dock.LeftTop,t.Dock.LeftTop,document,i)};c.hide=function(){r.debug("sap.ui.core.BusyIndicator.hide at "+Date.now());if(this._fDelayedStartTime){var e=p()-this._fDelayedStartTime;u.addBusyDuration(e>0?e:0);delete this._fDelayedStartTime}var t=c;if(c._bShowIsDelayed===true){c._bShowIsDelayed=false}t.bOpenRequested=false;if(t.oDomRef){var s=t.oDomRef.querySelector(".sapUiLocalBusyIndicator");jQuery(s).removeClass("sapUiLocalBusyIndicatorFade");this.fireClose({$Busy:this.oPopup._$()});t.oPopup.close(0)}};c.attachOpen=function(e,t){this.attachEvent(c.M_EVENTS.Open,e,t);return this};c.detachOpen=function(e,t){this.detachEvent(c.M_EVENTS.Open,e,t);return this};c.attachClose=function(e,t){this.attachEvent(c.M_EVENTS.Close,e,t);return this};c.detachClose=function(e,t){this.detachEvent(c.M_EVENTS.Close,e,t);return this};c.fireOpen=function(e){this.fireEvent(c.M_EVENTS.Open,e)};c.fireClose=function(e){this.fireEvent(c.M_EVENTS.Close,e)};return c},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/BusyIndicatorUtils", ["./BlockLayerUtils","sap/ui/core/library"],function(a,i){"use strict";var e=function(){};var c=i.BusyIndicatorSize;e.getElement=function(i){var e;switch(i){case c.Large:e="sapUiLocalBusyIndicatorSizeBig sapUiLocalBusyIndicatorShowContainer";break;case c.Medium:e="sapUiLocalBusyIndicatorSizeMedium";break;case c.Section:e="sapUiLocalBusyIndicatorSizeSection sapUiLocalBusyIndicatorShowContainer";break;default:e="sapUiLocalBusyIndicatorSizeMedium";break}var n=document.createElement("div");n.className="sapUiLocalBusyIndicator "+e+" sapUiLocalBusyIndicatorFade";a.addAriaAttributes(n);t(n);return n};function t(a,i){i=i||"sapUiLocalBusyIndicatorAnimStandard";var e=document.createElement("div");e.className="sapUiLocalBusyIndicatorAnimation "+i;e.appendChild(document.createElement("div"));e.appendChild(document.createElement("div"));e.appendChild(document.createElement("div"));a.appendChild(e)}function n(a,i){var e=a.$parent.get(0),c=a.$blockLayer.get(0);var t=c.children[0],n=t.offsetWidth;if(e.offsetWidth<n){t.className="sapUiLocalBusyIndicatorAnimation sapUiLocalBusyIndicatorAnimSmall"}}e.addHTML=function(a,i){var e,o;switch(i){case c.Small:e="sapUiLocalBusyIndicatorSizeMedium";o="sapUiLocalBusyIndicatorAnimSmall";break;case c.Section:e="sapUiLocalBusyIndicatorSizeSection sapUiLocalBusyIndicatorShowContainer";o="sapUiLocalBusyIndicatorAnimStandard ";break;case c.Large:e="sapUiLocalBusyIndicatorSizeBig sapUiLocalBusyIndicatorShowContainer";o="sapUiLocalBusyIndicatorAnimStandard";break;case c.Auto:e="sapUiLocalBusyIndicatorSizeMedium";o="sapUiLocalBusyIndicatorAnimStandard";break;default:e="sapUiLocalBusyIndicatorSizeMedium";o="sapUiLocalBusyIndicatorAnimStandard";break}if(!a){return}var s=a.$parent.get(0),r=a.$blockLayer.get(0);s.className+=" sapUiLocalBusy";r.className+=" sapUiLocalBusyIndicator "+e+" sapUiLocalBusyIndicatorFade";t(r,o);if(i===c.Auto){n(a)}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/CalendarType", ["sap/ui/base/DataType","sap/base/i18n/date/CalendarType"],function(e,a){"use strict";e.registerEnum("sap.ui.core.CalendarType",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/CommandExecution", ["sap/base/Log","sap/base/util/isEmptyObject","sap/ui/core/Component","sap/ui/core/Element","sap/ui/core/Shortcut"],function(t,e,i,n,r){"use strict";var a=n.extend("sap.ui.core.CommandExecution",{metadata:{library:"sap.ui.core",properties:{command:{type:"string"},enabled:{type:"boolean",defaultValue:true},visible:{type:"boolean",defaultValue:true}},events:{execute:{}}},bSkipUpdate:false,trigger:function(){if(this.getVisible()&&this.getEnabled()){this.fireExecute({})}},setCommand:function(e){if(!this.getCommand()){this.setProperty("command",e,true)}else{t.error("The 'command' property can only be applied initially!")}return this},_getCommandInfo:function(){if(!this.oCommand){var t,e=this.getParent(),n=i.getOwnerComponentFor(this);while(!n&&e&&e.getParent()){n=i.getOwnerComponentFor(e);e=e.getParent()}if(n){t=n.getCommand(this.getCommand())}this.oCommand=t?Object.assign({},t):null}return this.oCommand},_updateContextData:function(t){var e=this.getParent();t[this.getCommand()]={};t[this.getCommand()].enabled=this.getEnabled();t[this.getCommand()].id=this.getId();t[this.getCommand()].visible=this.getVisible();this.getModel("$cmd").setProperty("/"+e.getId(),t)},_createCommandData:function(t){if(!this.bSkipUpdate){this.bSkipUpdate=true;var e=this.getParent(),i=e.getModel("$cmd"),n=i.getData(),r=n[e.getId()];if(!r){r=Object.create(t)}else if(t!==Object.getPrototypeOf(r)){r=Object.create(t)}this._updateContextData(r);if(!e.getObjectBinding("$cmd")){e.bindElement("$cmd>/"+e.getId())}this.bSkipUpdate=false}},setParent:function(t){var e=this,i,a=this.getParent(),o,s,g;function d(){var e=t.oPropagatedProperties.oBindingContexts["$cmd"];return e?e.getObject():null}function p(){if(t.getModel("$cmd")){var i=d();e.getParent().detachModelContextChange(p);e._createCommandData(i)}}n.prototype.setParent.apply(this,arguments);i=this._getCommandInfo();if(i&&this.getVisible()){if(t&&t!==a){s=i.shortcut;g=r.isRegistered(this.getParent(),s);if(!g){r.register(t,s,this.trigger.bind(this))}if(t.getModel("$cmd")){o=d();this._createCommandData(o)}else{t.attachModelContextChange(p)}if(!t._propagateProperties._sapui_fnOrig){var m=t._propagateProperties;t._propagateProperties=function(i,n,r,a,s,g){m.apply(t,arguments);var p=t.getBindingContext("$cmd");var c=arguments[1];if(p&&c.isA("sap.ui.core.CommandExecution")){var h=p.getObject();var u=Object.getPrototypeOf(h);o=d();if(u!==o){e._createCommandData.apply(c,[o])}}};t._propagateProperties._sapui_fnOrig=m}}if(a&&a!=t){s=i.shortcut;g=r.isRegistered(a,s);if(g){r.unregister(a,i.shortcut)}this._cleanupContext(a)}}return this},_cleanupContext:function(t){if(t.getBindingContext("$cmd")){var i=t.getBindingContext("$cmd").getObject();if(i){delete i[this.getCommand()];if(e(Object.assign({},i))){if(t._propagateProperties._sapui_fnOrig){t._propagateProperties=t._propagateProperties._sapui_fnOrig}if(!t._bIsBeingDestroyed){t.unbindElement("$cmd")}}}}},setVisible:function(t){var e=this.getParent(),i=this.getModel("$cmd");this.setProperty("visible",t,true);t=this.getProperty("visible");if(e){var n=this._getCommandInfo(),a=n.shortcut,o=r.isRegistered(e,a);if(t&&!o){r.register(e,a,this.trigger.bind(this))}else if(!t&&o){r.unregister(e,a)}}if(i){var s=this.getBindingContext("$cmd");i.setProperty(this.getCommand()+"/visible",t,s)}return this},setEnabled:function(t){var e=this.getModel("$cmd");this.setProperty("enabled",t,true);if(e){var i=this.getBindingContext("$cmd");e.setProperty(this.getCommand()+"/enabled",this.getProperty("enabled"),i)}return this},destroy:function(){var t=this.getParent();if(t){var e=this._getCommandInfo();r.unregister(this.getParent(),e.shortcut);this._cleanupContext(t)}n.prototype.destroy.apply(this,arguments)}});a.find=function(t,e){var i,n,r;r=t.getDependents();for(i=0;i<r.length;i++){if(r[i].isA("sap.ui.core.CommandExecution")&&r[i].getCommand()===e){n=r[i]}}if(!n&&t.getParent()){n=a.find(t.getParent(),e)}return n};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ComponentContainer", ["sap/ui/base/ManagedObject","./Control","./Component","./library","./ComponentContainerRenderer","sap/base/Log","sap/ui/core/Configuration"],function(e,t,n,o,i,a,r){"use strict";var s=o.ComponentLifecycle;var p=t.extend("sap.ui.core.ComponentContainer",{metadata:{interfaces:["sap.ui.core.IPlaceholderSupport"],library:"sap.ui.core",properties:{name:{type:"string",defaultValue:null},url:{type:"sap.ui.core.URI",defaultValue:null},async:{type:"boolean",defaultValue:false},handleValidation:{type:"boolean",defaultValue:false},settings:{type:"object",defaultValue:null},propagateModel:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},lifecycle:{type:"sap.ui.core.ComponentLifecycle",defaultValue:s.Legacy},autoPrefixId:{type:"boolean",defaultValue:false},usage:{type:"string",defaultValue:null},manifest:{type:"any",defaultValue:null}},associations:{component:{type:"sap.ui.core.UIComponent",multiple:false}},events:{componentCreated:{parameters:{component:{type:"sap.ui.core.UIComponent"}}},componentFailed:{allowPreventDefault:true,parameters:{reason:{type:"object"}}}},designtime:"sap/ui/core/designtime/ComponentContainer.designtime"},renderer:i});function l(t,o,i,a){var r=typeof o==="string"?n.getComponentById(o):o;var s=t.getComponentInstance();if(s!==r){if(s){s.setContainer(undefined);if(a){s.destroy()}else{t._propagateProperties(true,s,e._oEmptyPropagatedProperties,true)}}t.setAssociation("component",r,i);r=t.getComponentInstance();if(r){r.setContainer(t);t.propagateProperties(true)}}}p.prototype.getComponentInstance=function(){var e=this.getComponent();return e&&n.getComponentById(e)};var f={onAfterRendering:function(){if(this._placeholder){this._placeholder.show(this)}}};p.prototype.showPlaceholder=function(e){var t,n=sap.ui.require("sap/ui/core/Placeholder");if(!n||!n.isEnabled()){return}if(this._placeholder){this.hidePlaceholder()}if(e.placeholder){this._placeholder=e.placeholder;t=this._placeholder._load()}else{t=Promise.resolve()}if(this.getDomRef()&&this._placeholder){this._placeholder.show(this)}this.addEventDelegate(f,this);return t};p.prototype.hidePlaceholder=function(){if(this._placeholder){this._placeholder.hide();this.removeEventDelegate(f);this._placeholder=undefined}};p.prototype.setComponent=function(e,t){l(this,e,t,this.getLifecycle()===s.Container||typeof this.getUsage()==="string"&&this.getUsage()&&this.getLifecycle()===s.Legacy);return this};p.prototype.applySettings=function(e,n){if(e){if(e.manifest==="true"||e.manifest==="false"){e.manifest=e.manifest==="true"}if(e.manifest&&e.async===undefined){e.async=true}}t.prototype.applySettings.apply(this,arguments)};function u(e){var t=e.getName();var n=e.getManifest();var o=e.getUrl();var i=e.getSettings();var a={name:t?t:undefined,manifest:n!==null?n:false,async:e.getAsync(),url:o?o:undefined,handleValidation:e.getHandleValidation(),settings:i!==null?i:undefined};return a}p.prototype._createComponent=function(){var e=n.getOwnerComponentFor(this),t=this.getUsage(),o=u(this);if(t){if(e){o=e._enhanceWithUsageConfig(t,o)}else{a.error('[FUTURE FATAL] ComponentContainer "'+this.getId()+'" does have a "usage", but no owner component!')}}if(this.getAutoPrefixId()){if(o.id){o.id=this.getId()+"-"+o.id}if(o.settings&&o.settings.id){o.settings.id=this.getId()+"-"+o.settings.id}}return n._createComponent(o,e)};p.prototype.onBeforeRendering=function(){var e=this.getComponentInstance(),t=this.getUsage(),n=this.getName(),o=this.getManifest();if(!this._oComponentPromise&&!e&&(t||n||o)){e=this._createComponent();if(e instanceof Promise){this._oComponentPromise=e;e.then(function(e){delete this._oComponentPromise;this.setComponent(e);this.fireComponentCreated({component:e})}.bind(this),function(e){delete this._oComponentPromise;if(this.fireComponentFailed({reason:e})){a.error("[FUTURE FATAL] Failed to load component for container "+this.getId(),e)}}.bind(this))}else if(e){this.setComponent(e,true);this.fireComponentCreated({component:e})}else{this.fireComponentFailed({reason:new Error("The component could not be created.")})}}if(e&&e.onBeforeRendering){e.onBeforeRendering()}};p.prototype.onAfterRendering=function(){var e=this.getComponentInstance();if(e&&e.onAfterRendering){e.onAfterRendering()}};p.prototype.exit=function(){l(this,undefined,true,this.getLifecycle()!==s.Application)};p.prototype.propagateProperties=function(e){var n=this.getComponentInstance();if(n&&this.getPropagateModel()){this._propagateProperties(e,n)}t.prototype.propagateProperties.apply(this,arguments)};p.prototype._propagateContextualSettings=function(){var e=this.getComponentInstance();if(e){e._applyContextualSettings(this._getContextualSettings())}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ComponentContainerRenderer", function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var i=t.getComponentInstance();var n=t.getWidth();var r=t.getHeight();e.openStart("div",t);e.style("width",n);e.style("height",r);e.class("sapUiComponentContainer");e.openEnd();e.openStart("div",t.getId()+"-uiarea");if(n&&n!=="auto"){e.style("width","100%")}if(r&&r!=="auto"){e.style("height","100%")}e.openEnd();if(i){i.render(e)}e.close("div");e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ComponentSupport", ["sap/ui/base/DataType","sap/ui/core/ComponentContainer","sap/ui/core/library","sap/base/Log","sap/base/util/ObjectPath","sap/base/strings/camelize"],function(e,t,n,r,a,o){"use strict";var i=n.ComponentLifecycle;var u=t.getMetadata();var p=function(){};p.run=function(){var e=p._find();for(var n=0,a=e.length;n<a;n++){var o=e[n];r.debug("Parsing element "+o.outerHTML,"","sap/ui/core/ComponentSupport");var i=p._parse(o);p._applyDefaultSettings(i);r.debug("Creating ComponentContainer with the following settings",JSON.stringify(i,0,2),"sap/ui/core/ComponentSupport");new t(i).placeAt(o);o.removeAttribute("data-sap-ui-component")}};p._find=function(){return document.querySelectorAll("[data-sap-ui-component]")};p._parse=function(t){var n={};for(var i=0,p=t.attributes.length;i<p;i++){var s=t.attributes[i];var f=/^data-((?!sap-ui-component).+)/g.exec(s.name);if(f){var c=o(f[1]);var l=s.value;if(c!=="id"){var m=u.getProperty(c);var d=!m&&u.getEvent(c);if(!m&&!d){r.warning('[FUTURE FATAL] Property or event "'+c+'" will be ignored as it does not exist in sap.ui.core.ComponentContainer');continue}if(m){var g=e.getType(m.type);if(!g){throw new Error('Property "'+m.name+'" has no known type')}l=g.parseValue(l)}else if(d){var v=a.get(l);if(typeof v!=="function"){throw new Error('Callback handler for event "'+d.name+'" not found')}l=v}}n[c]=l}}return n};p._applyDefaultSettings=function(e){e.async=true;if(e.manifest===undefined||e.manifest==="true"){e.manifest=true}else if(e.manifest==="false"){r.error('[FUTURE FATAL] Ignoring "manifest=false" for ComponentContainer of component "'+e.name+'" as it is not supported by ComponentSupport. '+'Forcing "manifest=true"',"","sap/ui/core/ComponentSupport");e.manifest=true}e.lifecycle=e.lifecycle===undefined?i.Container:e.lifecycle;e.autoPrefixId=e.autoPrefixId===undefined?true:e.autoPrefixId};p.run();return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ContextMenuSupport", ["./Control"],function(t){"use strict";var e=function(){var e;if(!(this instanceof t)){return}function n(t){t.stopPropagation();if(t.srcControl!==this){return}t.preventDefault();this._oContextMenu.openAsContextMenu(t,this)}e={oncontextmenu:n};this.setContextMenu=function(t){if(t==null&&this.getContextMenu()){this._oContextMenu=null;this.removeEventDelegate(e,this);return}else if(!t||!t.getMetadata||!t.getMetadata().isInstanceOf("sap.ui.core.IContextMenu")){return}if(!this._oContextMenu){this.addEventDelegate(e,this)}this._oContextMenu=t};this.getContextMenu=function(){return this._oContextMenu}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Control", ["./CustomStyleClassSupport","./Core","./Element","./ElementRegistry","./UIArea","./StaticArea","./RenderManager","./BusyIndicatorUtils","./BlockLayerUtils","sap/base/Log","sap/ui/performance/trace/Interaction","sap/ui/thirdparty/jquery"],function(t,e,i,s,o,r,n,a,l,c,u,jQuery){"use strict";var d;var h=i.extend("sap.ui.core.Control",{metadata:{stereotype:"control",abstract:true,publicMethods:["placeAt","attachBrowserEvent","detachBrowserEvent","getControlsByFieldGroup","triggerValidateFieldGroup","checkFieldGroupIds"],library:"sap.ui.core",properties:{blocked:{type:"boolean",defaultValue:false},busy:{type:"boolean",defaultValue:false},busyIndicatorDelay:{type:"int",defaultValue:1e3},busyIndicatorSize:{type:"sap.ui.core.BusyIndicatorSize",defaultValue:"Medium"},visible:{type:"boolean",group:"Appearance",defaultValue:true},fieldGroupIds:{type:"string[]",defaultValue:[]}},events:{validateFieldGroup:{enableEventBubbling:true,parameters:{fieldGroupIds:{type:"string[]"}}}}},constructor:function(t,e){this.bAllowTextSelection=true;i.apply(this,arguments);this.bOutput=this.getDomRef()!=null;this._bOnBeforeRenderingPhase=false},renderer:null});h.prototype.clone=function(){var t=i.prototype.clone.apply(this,arguments);if(this.aBindParameters){for(var e=0,s=this.aBindParameters.length;e<s;e++){var o=this.aBindParameters[e];t.attachBrowserEvent(o.sEventType,o.fnHandler,o.oListener!==this?o.oListener:undefined)}}t.bAllowTextSelection=this.bAllowTextSelection;return t};t.apply(h.prototype);h.prototype.isActive=function(){return document.getElementById(this.sId)!=null};function y(t){if(!t||!t.isA){return false}if(t.isA("sap.ui.core.Control")){return t._bRenderingPhase}return y(t.getParent())}h.prototype.invalidate=function(t){var e;if(this._bOnBeforeRenderingPhase){return}this._bNeedsRendering=true;var i=this.getParent();if((this.bOutput||y(i))&&(e=this.getUIArea())){if(!this._bIsBeingDestroyed){e.addInvalidatedControl(this)}}else{if(i&&!i.isInvalidateSuppressed()&&(this.bOutput||!(this.getVisible&&this.getVisible()===false))){i.invalidate(this)}}};h.prototype.rerender=function(){this._bNeedsRendering=true;o.rerenderControl(this)};h.prototype.getDomRef=function(t){if(this.bOutput===false&&!this.oParent){return null}return i.prototype.getDomRef.call(this,t)};h.prototype.allowTextSelection=function(t){this.bAllowTextSelection=t;return this};h.prototype.attachBrowserEvent=function(t,e,i){if(t&&typeof t==="string"){if(typeof e==="function"){if(!this.aBindParameters){this.aBindParameters=[]}i=i||this;var s=e.bind(i);this.aBindParameters.push({sEventType:t,fnHandler:e,oListener:i,fnProxy:s});if(!this._sapui_bInAfterRenderingPhase){this.$().on(t,s)}}}return this};h.prototype.detachBrowserEvent=function(t,e,i){if(t&&typeof t==="string"){if(typeof e==="function"){var s=this.$(),o,r;i=i||this;if(this.aBindParameters){for(o=this.aBindParameters.length-1;o>=0;o--){r=this.aBindParameters[o];if(r.sEventType===t&&r.fnHandler===e&&r.oListener===i){this.aBindParameters.splice(o,1);s.off(t,r.fnProxy)}}}}}return this};h.prototype.getRenderer=function(){return n.getRenderer(this)};h.prototype.placeAt=function(t,s){e.ready(function(){var e=t;if(typeof t==="string"){e=i.getElementById(t)}if(e instanceof i){if(!f(e)){c.warning("[FUTURE FATAL] placeAt cannot be processed because container "+e+" does not have an aggregation 'content'.");return this}}else{if(t===r.STATIC_UIAREA_ID||t&&t.id===r.STATIC_UIAREA_ID){e=r.getUIArea()}else{e=o.create(t)}}if(typeof s==="number"){e.insertContent(this,s)}else{s=s||"last";switch(s){case"last":e.addContent(this);break;case"first":e.insertContent(this,0);break;case"only":e.removeAllContent();e.addContent(this);break;default:c.warning("[FUTURE FATAL] Position "+s+" is not supported for function placeAt.")}}}.bind(this));return this};function f(t){var e=t.getMetadata().getAggregation("content");if(e){return e.multiple&&e.type==="sap.ui.core.Control"}return typeof t.addContent==="function"&&typeof t.insertContent==="function"&&typeof t.removeAllContent==="function"}h.prototype.onselectstart=function(t){if(!this.bAllowTextSelection){t.preventDefault();t.stopPropagation()}};h.prototype.onBeforeRendering=function(t){};h.prototype.onAfterRendering=function(t){};h.prototype.getIdForLabel=function(){return this.getId()};h.prototype.destroy=function(t){if(this.bIsDestroyed){return}this._bIsBeingDestroyed=true;this._cleanupBusyIndicator();d=d||sap.ui.require("sap/ui/core/ResizeHandler");if(d){d.deregisterAllForControl(this.getId())}if(!this.getVisible()){var e=document.getElementById(n.createInvisiblePlaceholderId(this));if(e&&e.parentNode){e.parentNode.removeChild(e)}}i.prototype.destroy.call(this,t)};var p={onBeforeRendering:function(){I.call(this)},onAfterRendering:function(){if(this.getBlocked()&&this.getDomRef()&&!this.getDomRef("blockedLayer")){this._oBlockState=l.block(this,this.getId()+"-blockedLayer",this._sBlockSection);jQuery(this._oBlockState.$blockLayer.get(0)).addClass("sapUiBlockLayerOnly")}if(this.getBusy()&&this.getDomRef()&&!this._busyIndicatorDelayedCallId&&!this.getDomRef("busyIndicator")){var t=this.getBusyIndicatorDelay();if(t){this._busyIndicatorDelayedCallId=setTimeout(B.bind(this),t)}else{B.call(this)}}}};function B(){if(!this.getBusy()){return}var t=this.$(this._sBusySection);if(this._busyIndicatorDelayedCallId){clearTimeout(this._busyIndicatorDelayedCallId);delete this._busyIndicatorDelayedCallId}if(!t||t.length===0){c.warning("BusyIndicator could not be rendered. The outer control instance is not valid anymore.");return}if(this._sBlockSection===this._sBusySection){if(this._oBlockState){a.addHTML(this._oBlockState,this.getBusyIndicatorSize());l.toggleAnimationStyle(this._oBlockState,true);this._oBusyBlockState=this._oBlockState}else{b.call(this)}}else{b.call(this)}}function g(){this._oBlockState=l.block(this,this.getId()+"-blockedLayer",this._sBlockSection);jQuery(this._oBlockState.$blockLayer.get(0)).addClass("sapUiBlockLayerOnly")}function b(){if(this._oBusyBlockState){l.unblock(this._oBusyBlockState)}this._oBusyBlockState=l.block(this,this.getId()+"-busyIndicator",this._sBusySection);a.addHTML(this._oBusyBlockState,this.getBusyIndicatorSize())}function I(){l.unblock(this._oBlockState);l.unblock(this._oBusyBlockState);delete this._oBlockState;delete this._oBusyBlockState}function _(t){if(t){I.call(this);return}var e=this.$(this._sBusySection);e.removeClass("sapUiLocalBusy");if(this._sBlockSection===this._sBusySection){if(!this.getBlocked()&&!this.getBusy()){I.call(this)}else if(this.getBlocked()){l.toggleAnimationStyle(this._oBlockState||this._oBusyBlockState,false);this._oBlockState=this._oBusyBlockState}else if(this._oBusyBlockState){l.unblock(this._oBusyBlockState);delete this._oBusyBlockState}}else if(this._oBusyBlockState){l.unblock(this._oBusyBlockState);delete this._oBusyBlockState}}h.prototype.setBlocked=function(t,e){if(!!t==this.getProperty("blocked")){return this}this._sBlockSection=e||this._sBlockSection;this.setProperty("blocked",t,true);if(t){this.addDelegate(p,false,this)}else if(!this.getBusy()){this.removeDelegate(p)}if(!this.getDomRef()){return this}if(t){if(this._sBlockSection===this._sBusySection){if(!this._oBusyBlockState&&!this._oBlockState){g.call(this)}else{c.info("The control is already busy. Hence, no new block-layer was created for the shared section.")}}else{g.call(this)}}else{if(this._sBlockSection===this._sBusySection){if(!this.getBlocked()&&!this.getBusy()){I.call(this)}else if(this.getBusy()){c.info("The control is already busy. Hence, no new block-layer was created for the shared section.")}}else if(this._oBlockState){l.unblock(this._oBlockState);delete this._oBlockState}}return this};h.prototype.setBusy=function(t,e){if(!!t==this.getProperty("busy")){return this}this._sBusySection=e||this._sBusySection;this.setProperty("busy",t,true);if(t){u.notifyShowBusyIndicator(this);this.addDelegate(p,false,this)}else{if(!this.getProperty("blocked")){this.removeDelegate(p)}if(this._busyIndicatorDelayedCallId){clearTimeout(this._busyIndicatorDelayedCallId);delete this._busyIndicatorDelayedCallId}}if(!this.getDomRef()){return this}if(t){if(this.getBusyIndicatorDelay()<=0){B.call(this)}else{this._busyIndicatorDelayedCallId=setTimeout(B.bind(this),this.getBusyIndicatorDelay())}}else{_.call(this);u.notifyHideBusyIndicator(this)}return this};h.prototype.isBusy=h.prototype.getBusy;h.prototype.setBusyIndicatorDelay=function(t){this.setProperty("busyIndicatorDelay",t,true);return this};h.prototype._cleanupBusyIndicator=function(){if(this._busyIndicatorDelayedCallId){clearTimeout(this._busyIndicatorDelayedCallId);delete this._busyIndicatorDelayedCallId}_.call(this,true)};h.prototype.getControlsByFieldGroupId=function(t){return this.findAggregatedObjects(true,function(e){if(e instanceof h){return e.checkFieldGroupIds(t)}return false})};h.prototype.checkFieldGroupIds=function(t){if(typeof t==="string"){t=t?t.split(","):[]}var e=this._getFieldGroupIds();if(Array.isArray(t)){return t.every(function(t){return e.indexOf(t)>=0})}else if(!t){return e.length>0}return false};h.prototype.triggerValidateFieldGroup=function(t){this.fireValidateFieldGroup({fieldGroupIds:t})};h.getControlsByFieldGroupId=function(t){return s.filter(e=>e.isA("sap.ui.core.Control")&&e.checkFieldGroupIds(t))};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/CustomData", ["./Element"],function(t){"use strict";var e=t._CustomData;return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/CustomStyleClassSupport", ["./Element","sap/ui/core/Theming","sap/base/assert","sap/base/Log"],function(s,t,e,i){"use strict";var a=/\s/;var l=/\S+/g;var n=function(){if(!(this instanceof s)){return}var t=this.clone;this.clone=function(){var s=t.apply(this,arguments);if(this.aCustomStyleClasses){s.aCustomStyleClasses=this.aCustomStyleClasses.slice()}if(this.mCustomStyleClassMap){s.mCustomStyleClassMap=Object.assign(Object.create(null),this.mCustomStyleClassMap)}return s};this.addStyleClass=function(s,t){e(typeof s==="string","sStyleClass must be a string");if(!s||typeof s!=="string"||s.indexOf('"')>-1||s.indexOf("'")>-1){return this}var i=this.aCustomStyleClasses||(this.aCustomStyleClasses=[]),n=this.mCustomStyleClassMap||(this.mCustomStyleClassMap=Object.create(null)),r,o=false,h=[],C=f();function m(s){if(!n[s]){n[s]=true;i.push(s);if(C&&C.indexOf(s)>-1){h.push(s)}o=true}}if(a.test(s)){r=s.match(l);r&&r.forEach(m)}else{m(s)}if(!o){return this}var y=this.getDomRef();if(y){if(r){y.classList.add.apply(y.classList,r)}else{y.classList.add(s)}}else if(t===false){this.invalidate()}if(h.length>0){u(this,h,true)}return this};this.removeStyleClass=function(s,t){e(typeof s==="string","sStyleClass must be a string");if(!s||typeof s!=="string"||!this.aCustomStyleClasses||!this.mCustomStyleClassMap){return this}var i=this.aCustomStyleClasses,n=this.mCustomStyleClassMap,r,o=false,h=[],C=f(),m;function y(s){if(n[s]){o=true;m=i.indexOf(s);if(m!==-1){i.splice(m,1);delete n[s];if(C&&C.indexOf(s)>-1){h.push(s)}}}}if(a.test(s)){r=s.match(l);r&&r.forEach(y)}else{y(s)}if(o){var c=this.getDomRef();if(c){if(r){c.classList.remove.apply(c.classList,r)}else{c.classList.remove(s)}}else if(t===false){this.invalidate()}if(h.length>0){u(this,h,false)}}return this};this.toggleStyleClass=function(s,t){e(typeof s==="string","sStyleClass must be a string");if(s&&typeof s==="string"){if(t===true){this.addStyleClass(s)}else if(t===false){this.removeStyleClass(s)}else if(t===undefined){this.hasStyleClass(s)?this.removeStyleClass(s):this.addStyleClass(s)}else{i.warning(this.toString()+"- toggleStyleClass(): bAdd should be a boolean or undefined, but is '"+t+"'")}}return this};this.hasStyleClass=function(s){e(typeof s==="string","sStyleClass must be a string");if(s&&typeof s==="string"&&this.mCustomStyleClassMap){if(a.test(s)){var t=s.match(l);return t!=null&&t.every(function(s){return this.mCustomStyleClassMap[s]},this)}else{return!!this.mCustomStyleClassMap[s]}}return false};this.getMetadata().addPublicMethods(["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass"])};var r;function f(){if(!r){r=sap.ui.require("sap/ui/core/theming/Parameters")}if(r){return r._getScopes(true)}}function u(s,e,i){t.fireThemeScopingChanged({scopes:e,added:i,element:s})}return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/DeclarativeSupport", ["sap/ui/thirdparty/jquery","sap/ui/base/DataType","sap/ui/base/ManagedObject","./Control","./CustomData","./HTML","./mvc/View","./mvc/EventHandlerResolver","sap/base/Log","sap/base/util/ObjectPath","sap/base/assert","sap/base/strings/camelize"],function(jQuery,t,e,a,r,i,n,o,s,u,g,l){"use strict";var p={};p.attributes={"data-sap-ui-type":true,"data-sap-ui-id":true,"data-sap-ui-aggregation":true,"data-sap-ui-default-aggregation":true,"data-sap-ui-binding":function(t,a){var r=e.bindingParser(t);a.objectBindings=a.objectBindings||{};a.objectBindings[r.model||undefined]=r},"data-tooltip":function(t,e){e["tooltip"]=t},tooltip:function(t,e,a){e["tooltip"]=t;s.warning('[Deprecated] Control "'+e.id+'": The attribute "tooltip" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.')},class:true,style:true,id:true};p.compile=function(t,e,a){var r=this;jQuery(t).find("[data-sap-ui-type]").filter(function(){return jQuery(this).parents("[data-sap-ui-type]").length===0}).each(function(){r._compile(this,e,a)})};p._compile=function(t,e,r){var i=jQuery(t);var n=i.attr("data-sap-ui-type");var o=[];var s=n==="sap.ui.core.UIArea";var u=t.getAttributeNames();if(s){var g=this;i.children().each(function(){var t=g._createControl(this,e);if(t){o.push(t)}})}else{var l=this._createControl(t,e);if(l){o.push(l)}}i.empty();var p=[];for(var d=0;d<u.length;d++){var f=u[d];if(!s||s&&/^data-/g.test(f.toLowerCase())){p.push(f)}}if(p.length>0){i.removeAttr(p.join(" "))}o.forEach(function(i){if(i instanceof a){if(e&&!r){e.addContent(i)}else{i.placeAt(t);if(e){e.connectControl(i)}}}})};p._createControl=function(t,e){var a=jQuery(t);var r=null;var i=a.attr("data-sap-ui-type");if(i){var o=sap.ui.requireSync(i.replace(/\./g,"/"));o=o||u.get(i);g(typeof o!=="undefined","Class not found: "+i);var s={};s.id=this._getId(a,e);if(e&&e._sProcessingMode!=null&&o.getMetadata().hasSpecialSetting("processingMode")){s.processingMode=e._sProcessingMode}this._addSettingsForAttributes(s,o,t,e);this._addSettingsForAggregations(s,o,t,e);var r;if(n.prototype.isPrototypeOf(o.prototype)&&typeof o._sType==="string"){r=n._create(s,undefined,o._sType)}else{r=new o(s)}if(t.className){r.addStyleClass(t.className)}a.removeAttr("data-sap-ui-type")}else{r=this._createHtmlControl(t,e)}return r};p._createHtmlControl=function(t,e){var a=new i;a.setDOMContent(t);this.compile(t,e,true);return a};p._addSettingsForAttributes=function(t,a,i,n){var s=this;var u=p.attributes;var d=e.bindingParser;var f=[];var c=/^data-custom-data:(.+)/i;var v=i.getAttributeNames();for(var h=0;h<v.length;h++){var y=v[h];var b=i.getAttribute(y);if(!c.test(y)){if(typeof u[y]==="undefined"){y=s.convertAttributeToSettingName(y,t.id);var m=s._getProperty(a,y);if(m){var _=d(b,n&&n.getController(),true);if(_&&typeof _==="object"){t[y]=_}else{t[y]=s.convertValueToType(s.getPropertyDataType(m),_||b)}}else if(s._getAssociation(a,y)){var A=s._getAssociation(a,y);if(A.multiple){b=b.replace(/\s*,\s*|\s+/g,",");t[y]=b.split(",").map(function(t){return n?n.createId(t):t})}else{t[y]=n?n.createId(b):b}}else if(s._getAggregation(a,y)){var w=s._getAggregation(a,y);if(w.multiple){var _=d(b,n&&n.getController());if(_){t[y]=_}else{throw new Error("Aggregation "+y+" with cardinality 0..n only allows binding paths as attribute value")}}else if(w.altTypes){var _=d(b,n&&n.getController(),true);if(_&&typeof _==="object"){t[y]=_}else{t[y]=s.convertValueToType(w.altTypes[0],_||b)}}else{throw new Error("Aggregation "+y+" not supported")}}else if(s._getEvent(a,y)){var C=n&&(n._oContainingView||n).getController();var T=o.resolveEventHandler(b,C);if(T){t[y]=T}else{throw new Error('Control "'+t.id+'": The function "'+b+'" for the event "'+y+'" is not defined')}}else{g(y==="id","DeclarativeSupport encountered unknown setting '"+y+"' for class '"+a.getMetadata().getName()+"' (value:'"+b+"')")}}else if(typeof u[y]==="function"){u[y](b,t,a)}}else{y=l(c.exec(y)[1]);var _=d(b,n&&n.getController());f.push(new r({key:y,value:_||b}))}}if(f.length>0){t.customData=f}return t};p._addSettingsForAggregations=function(t,e,a,r){var i=jQuery(a);var n=this._getDefaultAggregation(e,a);var o=this;var s=e.getMetadata().getAllAggregations();i.children().each(function(){var e=jQuery(this);var a=e.attr("data-sap-ui-aggregation");var i=e.attr("data-sap-ui-type");var u=false;if(!a){u=true;a=n}if(a&&s[a]){var l=s[a].multiple;var p=function(e){var i=o._createControl(e,r);if(i){if(l){if(!t[a]){t[a]=[]}if(typeof t[a].path==="string"){g(!t[a].template,"list bindings support only a single template object");t[a].template=i}else{t[a].push(i)}}else{t[a]=i}}};if(u||i&&!u){p(this)}else{e.children().each(function(){p(this)})}}e.removeAttr("data-sap-ui-aggregation");e.removeAttr("data-sap-ui-type")});return t};p._getId=function(t,e){var a=jQuery(t);var r=a.attr("id");if(r){if(e){r=e.createId(r);a.attr("data-sap-ui-id",r)}a.attr("id","")}return r};p._getProperty=function(t,e){return t.getMetadata().getProperty(e)};p.convertValueToType=function(a,r){if(a instanceof t){r=a.parseValue(r)}return typeof r==="string"?e.bindingParser.escape(r):r};p.getPropertyDataType=function(e){var a=t.getType(e.type);if(!a){throw new Error("Property "+e.name+" has no known type")}return a};p.convertAttributeToSettingName=function(t,e,a){if(t.indexOf("data-")===0){t=t.substr(5)}else if(a){s.warning('[Deprecated] Control "'+e+'": The attribute "'+t+'" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.')}else{throw new Error('Control "'+e+'": The attribute "'+t+'" is not prefixed with "data-*".')}return l(t)};p._getAssociation=function(t,e){return t.getMetadata().getAssociation(e)};p._getAggregation=function(t,e){return t.getMetadata().getAggregation(e)};p._getEvent=function(t,e){return t.getMetadata().getEvent(e)};p._getDefaultAggregation=function(t,e){var a=jQuery(e);var r=a.attr("data-sap-ui-default-aggregation")||t.getMetadata().getDefaultAggregationName();a.removeAttr("data-sap-ui-default-aggregation");return r};return p},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ExtensionPoint", ["sap/base/Log","sap/ui/core/mvc/View","sap/ui/core/Component"],function(e,n,i){"use strict";sap.ui.extensionpoint=function(n,i,o,a,r){e.warning("Do not use deprecated factory function 'sap.ui.extensionpoint'. Use 'sap.ui.core.ExtensionPoint.load' instead","sap.ui.extensionpoint",null,function(){return{type:"sap.ui.extensionpoint",name:i}});return t._factory(n,i,o,a,r)};var t=sap.ui.extensionpoint||{};t._factory=function(o,a,r,s,u,f){var c,l,g,d;if(o){if(o.isA("sap.ui.core.mvc.View")){d=o.sViewName;l=o}else if(o.isA("sap.ui.core.Fragment")){d=o.getFragmentName();l=o._oContainingView}c=i.getCustomizing(o,{type:"sap.ui.viewExtensions",name:d,extensionName:a})}if(c){if(c.className){e.info("Customizing: View extension found for extension point '"+a+"' in View '"+l.sViewName+"': "+c.className+": "+(c.viewName||c.fragmentName));var m=l&&c.id?l.createId(c.id):c.id;var p={async:f,id:m,type:c.type};if(f&&l._sProcessingMode){p.processingMode=l._sProcessingMode}if(c.className==="sap.ui.core.Fragment"){var v=sap.ui.require("sap/ui/core/Fragment");p.fragmentName=c.fragmentName;p.containingView=l;if(f){if(v){g=v.load(p)}else{g=new Promise(function(e,n){sap.ui.require(["sap/ui/core/Fragment"],function(n){e(n.load(p))},n)})}}else{v=v||sap.ui.requireSync("sap/ui/core/Fragment");var w=new v(p);g=Array.isArray(w)?w:[w]}}else if(c.className==="sap.ui.core.mvc.View"){p.viewName=c.viewName;var x=n._create(p);if(f){g=x.loaded()}else{g=[x]}}else{e.warning("[FUTURE FATAL] Customizing: Unknown extension className configured (and ignored) in Component.js for extension point '"+a+"' in View '"+l.sViewName+"': "+c.className)}}else{e.warning("[FUTURE FATAL] Customizing: no extension className configured in Component.js for extension point '"+a+"' in View '"+l.sViewName+"': "+c.className)}}else if(t._fnExtensionProvider){var N=t._fnExtensionProvider(l);var y;if(l.isA("sap.ui.core.Fragment")){y=l._sExplicitId;var A=l.getController();l=A&&typeof A.isA==="function"&&A.isA("sap.ui.core.mvc.Controller")&&A.getView();if(l){y=l.getLocalId(y)||y}}if(N){if(!l){e.warning("[FUTURE FATAL] View instance could not be passed to ExtensionPoint Provider for extension point '"+a+"' "+"in fragment '"+y+"'.")}return[{providerClass:N,view:l,fragmentId:y,name:a,createDefault:r,targetControl:undefined,aggregationName:undefined,index:undefined,ready:function(e){var n=this._nextSibling;while(n!=null){n.index+=e.length;n=n._nextSibling}this._aControls=e},_aControls:[],_isExtensionPoint:true,_nextSibling:null}]}}if(!g&&typeof r==="function"){g=r()}var _=function(n){if(n&&!Array.isArray(n)){n=[n]}if(n&&s){var i=s.getMetadata().getAggregation(u);if(i){for(var t=0,o=n.length;t<o;t++){s[i._sMutator](n[t])}}else{e.error("[FUTURE FATAL] Creating extension point failed - Tried to add extension point with name "+a+" to an aggregation of "+s.getId()+" in view "+l.sViewName+", but sAggregationName was not provided correctly and I could not find a default aggregation")}}return n||[]};if(g&&typeof g.then==="function"){return g.then(_)}else{return _(g)}};t.registerExtensionProvider=function(n){if(n==null){delete t._fnExtensionProvider}else if(typeof n=="function"){t._fnExtensionProvider=n}else{e.error("[FUTURE FATAL] ExtensionPoint provider must be a function!")}};t.load=function(e){return Promise.resolve(t._factory(e.container,e.name,e.createDefaultContent,null,null,!!e.async))};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Fragment", ["../base/ManagedObject","./Element","./DeclarativeSupport","./XMLTemplateProcessor","sap/base/Log","sap/base/util/LoaderExtensions","sap/base/util/merge","sap/ui/util/XMLHelper","sap/ui/core/Component","sap/ui/core/mvc/XMLProcessingMode"],function(e,t,n,i,r,o,a,s,f,g){"use strict";var u={},p={};var m=e.extend("sap.ui.core.Fragment",{metadata:{properties:{type:"string"},specialSettings:{async:{type:"boolean",visibility:"hidden"},fragmentName:"string",fragmentContent:"any",containingView:{type:"sap.ui.core.mvc.View",visibility:"hidden"},oController:{type:"sap.ui.core.mvc.Controller",visibility:"hidden"},sId:{type:"sap.ui.core.ID",visibility:"hidden"},sOwnerId:{type:"sap.ui.core.ID",visibility:"hidden"},processingMode:{type:"sap.ui.core.mvc.XMLProcessingMode",visibility:"hidden"}}},constructor:function(t,n){e.apply(this,arguments);if(!this._bAsync){if(this._aContent&&this._aContent.length==1){return this._aContent[0]}else{return this._aContent}}}});m.registerType=function(e,t){if(typeof e!=="string"){r.error("[FUTURE FATAL] Ignoring non-string Fragment type: "+e);return}if(p[e]){r.warning("sap.ui.core.Fragment.registerType(): Fragment type '"+e+"' is already defined. Overriding this type now!")}p[e]=t};m.prototype._initCompositeSupport=function(e){if(!e){throw new Error("Settings must be set")}if(!(e.fragmentName||e.fragmentContent)){throw new Error("Please provide a fragment name")}if(e.oController){this.oController=e.oController}this._bAsync=e.async||false;this._sExplicitId=e.sId||e.id;this._sFragmentName=e.fragmentName;this.fnScopedRunWithOwner=e.containingView&&e.containingView.fnScopedRunWithOwner;if(!this.fnScopedRunWithOwner&&this._sOwnerId){var t=f.getComponentById(this._sOwnerId);this.fnScopedRunWithOwner=function(e){return t.runAsOwner(e)}}var n=m.getType(e.type);if(n){this._pContentPromise=n.init.apply(this,[e]);if(!this._pContentPromise){this._pContentPromise=Promise.resolve(this._aContent)}}else{throw new Error("No type for the fragment has been specified: "+e.type)}};m.prototype.getFragmentName=function(){return this._sFragmentName};m.prototype.getController=function(){return this.oController};m.byId=function(e,n){if(!(typeof e==="string"&&typeof n==="string")){r.error("[FUTURE FATAL] sap.ui.core.Fragment.byId: two strings must be given as parameters, but are: "+e+" and "+n);return undefined}return t.getElementById(e+"--"+n)};m.createId=function(e,t){if(!(typeof e==="string"&&typeof t==="string")){r.error("[FUTURE FATAL] sap.ui.core.Fragment.createId: two strings must be given as parameters, but are: "+e+" and "+t);return undefined}return e+"--"+t};m.prototype.createId=function(e){var t=this._sExplicitId?this._sExplicitId+"--"+e:e;if(this._oContainingView&&this._oContainingView!=this){t=this._oContainingView.createId(t)}return t};m.prototype.isSubView=function(){return true};sap.ui.fragment=function(e,t,n){var i;if(typeof t==="string"){i=t.toLowerCase()}else if(typeof t==="object"&&typeof t.fragmentName==="string"){i=t.fragmentName.toLowerCase()}else{i=""}r.info("Do not use deprecated factory function 'sap.ui."+i+"fragment'. Require 'sap/ui/core/Fragment' and use 'load()' instead","sap.ui."+i+"fragment",null,function(){return{type:"sap.ui."+i+"fragment",name:i?e+".fragment."+i:e}});return c(e,t,n)};function c(e,t,n){var i={};if(typeof e==="string"){i.fragmentName=e;i.oController=n;i.type=t}else if(typeof e==="object"){i=e;i.async=i.async===true?i.async:false;if(t){i.oController=t}if(i.async){var o=function(){var e=i.sOwnerId||i.containingView&&i.containingView._sOwnerId;var t=f.getComponentById(e);if(t){return t.runAsOwner(function(){return new m(i)})}return new m(i)};var a=m.getType(i.type);if(i.fragmentName&&i.fragmentContent){delete i.fragmentName}if(i.fragmentName&&typeof a.load=="function"){return new Promise(function(e,t){a.load(i).then(function(t){i.fragmentContent=t;e(o())}).catch(function(e){t(e)})})}else{return Promise.resolve(o())}}}else{r.error("sap.ui.fragment() must be called with Fragment name or config object as first parameter, but is: "+e)}return new m(i)}m.load=function(t){var n=Object.assign({},t);if(n.name&&n.definition){r.error("The properties 'name' and 'definition' shouldn't be provided at the same time. The fragment definition will be used instead of the name. Fragment name was: "+n.name);delete n.name}n.type=n.type||"XML";n.async=true;n.processingMode=n.processingMode||g.Sequential;n.fragmentName=n.fragmentName||n.name;n.fragmentContent=n.fragmentContent||n.definition;n.oController=n.controller;n.sOwnerId=e._sOwnerId;delete n.name;delete n.definition;delete n.controller;var i=c(n);return i.then(function(e){return e._pContentPromise})};m.getType=function(e){return p[e]};sap.ui.xmlfragment=function(e,t,n){if(typeof e==="string"){if(typeof t==="string"){return sap.ui.fragment({fragmentName:t,sId:e,type:"XML"},n)}else{return sap.ui.fragment(e,"XML",t)}}else{e.type="XML";return sap.ui.fragment(e,t)}};sap.ui.jsfragment=function(e,t,n){if(typeof e==="string"&&typeof t==="object"){if(t.createContent){u[e]=t;sap.ui.loader._.declareModule(e.replace(/\./g,"/")+".fragment.js")}else{return sap.ui.fragment(e,"JS",t)}}else if(typeof e==="string"&&t===undefined){return sap.ui.fragment(e,"JS")}else if(typeof e==="object"){e.type="JS";return sap.ui.fragment(e,t)}else if(arguments.length>=3){return sap.ui.fragment({id:e,fragmentName:t,type:"JS"},n)}else{r.error("sap.ui.jsfragment() was called with wrong parameter set: "+e+" + "+t)}};sap.ui.htmlfragment=function(e,t,n){if(typeof e==="string"){if(typeof t==="string"){return sap.ui.fragment({fragmentName:t,sId:e,type:"HTML"},n)}else{return sap.ui.fragment(e,"HTML",t)}}else{e.type="HTML";return sap.ui.fragment(e,t)}};m.registerType("XML",{load:function(e){return i.loadTemplatePromise(e.fragmentName,"fragment").then(function(e){return e})},init:function(n){this._aContent=[];if(n.fragmentContent){if(typeof n.fragmentContent==="string"){this._xContent=s.parse(n.fragmentContent).documentElement}else{this._xContent=n.fragmentContent}}else{r.warning("Synchronous loading of fragment, due to Fragment.init() call for '"+n.fragmentName+"'. Use 'sap/ui/core/Fragment' module with Fragment.load() instead.","SyncXHR",null,function(){return{type:"SyncXHR",name:"Fragment"}});this._xContent=i.loadTemplate(n.fragmentName,"fragment")}this._oContainingView=this._sExplicitId?this:n.containingView||this;if(this._oContainingView===this){this._oContainingView.oController=n.containingView&&n.containingView.oController||n.oController}this._sProcessingMode=n.processingMode;var o=this._oContainingView._fnSettingsPreprocessor;var a={fnRunWithPreprocessor:function(t){return e.runWithPreprocessors(t,{settings:o})}};var f=i.parseTemplatePromise(this._xContent,this,this._bAsync,a).then(function(e){this._aContent=e;if(this._aContent&&this._aContent.length&&n.objectBindings){this._aContent.forEach(function(e,i){if(e instanceof t){for(var r in n.objectBindings){e.bindObject(n.objectBindings[r])}}})}return this._aContent.length>1?this._aContent:this._aContent[0]}.bind(this));if(!this._bAsync){try{f.unwrap()}catch(e){r.error("[FUTURE FATAL] An Error occured during XML processing of '"+this.getMetadata().getName()+"' with id '"+this.getId()+"':\n"+e.stack)}}return f}});m.registerType("JS",{load:function(e){var t=e.fragmentName.replace(/\./g,"/")+".fragment";return new Promise(function(e,n){sap.ui.require([t],function(t){e(t)},n)})},init:function(t){this._aContent=[];if(t.fragmentContent){a(this,t.fragmentContent)}else{if(!u[t.fragmentName]){sap.ui.requireSync(t.fragmentName.replace(/\./g,"/")+".fragment")}a(this,u[t.fragmentName])}this._oContainingView=t.containingView||this;return e.runWithPreprocessors(function(){var e;if(this.fnScopedRunWithOwner){this.fnScopedRunWithOwner(function(){e=this.createContent(t.oController||this._oContainingView.oController)}.bind(this))}else{e=this.createContent(t.oController||this._oContainingView.oController)}if(e instanceof Promise){return e.then(function(e){this._aContent=this._aContent.concat(e);return this._aContent.length>1?this._aContent:this._aContent[0]}.bind(this))}else{return new Promise(function(t,n){this._aContent=this._aContent.concat(e);t(this._aContent.length>1?this._aContent:this._aContent[0])}.bind(this))}}.bind(this),{settings:this._oContainingView._fnSettingsPreprocessor})}});(function(){var t={};var i=function(e){var n=sap.ui.require.toUrl(e.replace(/\./g,"/"))+".fragment.html";var i=t[n];var r;if(!i){r=e.replace(/\./g,"/")+".fragment.html";i=o.loadResource(r);t[n]=i}return i};m.registerType("HTML",{load:function(e){var t=e.fragmentName.replace(/\./g,"/")+".fragment";return o.loadResource(t+".html",{async:true}).then(function(e){return e})},init:function(t){this._aContent=[];this.getContent=function(){return this._aContent};this.addContent=function(e){this._aContent.push(e)};this._oContainingView=t.containingView||this;this._sProcessingMode=t.processingMode;var r=t.fragmentContent||i(t.fragmentName);this._oTemplate=document.createElement("div");if(typeof r==="string"){this._oTemplate.innerHTML=r}else{var o=r;var a=document.createDocumentFragment();for(var s=0;s<o.length;s++){a.appendChild(o.item(s))}this._oTemplate.appendChild(a)}var f=this._oTemplate.getElementsByTagName("template")[0];var g=this.getMetadata().getAllProperties();if(f){var u=this;var p=f.getAttributeNames();for(var s=0;s<p.length-1;s++){var m=p[s];var c=n.convertAttributeToSettingName(m,u.getId());var l=f.getAttribute(m);var h=g[c];if(!t[c]){if(h){t[c]=n.convertValueToType(n.getPropertyDataType(h),l)}else if(sap.ui.core.mvc.HTMLView._mAllowedSettings[c]){t[c]=l}}}this._oTemplate=f}if(this._oTemplate.content){var d=this._oTemplate.content;this._oTemplate=document.createElement("div");this._oTemplate.appendChild(d)}return e.runWithPreprocessors(function(){if(this.fnScopedRunWithOwner){this.fnScopedRunWithOwner(function(){n.compile(this._oTemplate,this)}.bind(this))}else{n.compile(this._oTemplate,this)}var e=this.getContent();if(e&&e.length===1){this._aContent=[e[0]];return new Promise(function(e,t){e(this._aContent[0])}.bind(this))}}.bind(this),{settings:this._oContainingView._fnSettingsPreprocessor})}})})();return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/HTML", ["sap/ui/thirdparty/jquery","sap/base/Log","./Control","./RenderManager","./HTMLRenderer","sap/base/security/sanitizeHTML"],function(jQuery,e,t,n,r,i){"use strict";var s=n.RenderPrefixes;var o=t.extend("sap.ui.core.HTML",{metadata:{library:"sap.ui.core",properties:{content:{type:"string",group:"Misc",defaultValue:null},preferDOM:{type:"boolean",group:"Misc",defaultValue:true},sanitizeContent:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{afterRendering:{parameters:{isPreservedDOM:{type:"boolean"}}}}},renderer:r});o.prototype.getDomRef=function(e){var t=e?this.getId()+"-"+e:this.getId();return document.getElementById(s.Dummy+t)||document.getElementById(t)};o.prototype.setContent=function(t){function n(e){if(jQuery.parseHTML){var t=jQuery.parseHTML(e);if(t){var n=0,r=t.length;while(n<r&&t[n].nodeType!=1){n++}while(n<r&&t[r-1].nodeType!=1){r--}if(n>0||r<t.length){t=t.slice(n,r)}return jQuery(t)}}return jQuery(e)}if(this.getSanitizeContent()){e.trace("sanitizing HTML content for "+this);t=i(t)}this.setProperty("content",t,true);if(this.getDomRef()){var r=n(this.getContent());jQuery(this.getDomRef()).replaceWith(r);this._postprocessNewContent(r)}else{this.invalidate()}return this};o.prototype.setSanitizeContent=function(e){this.setProperty("sanitizeContent",e,true);if(e){this.setContent(this.getContent())}return this};o.prototype.onBeforeRendering=function(){if(!this.getPreferDOM()){return}var e=this.getDomRef();if(e&&!n.isPreservedContent(e)){for(var t=e.id,r;e&&e.getAttribute("data-sap-ui-preserve")==t;e=r){r=e.nextElementSibling;n.preserveContent(e,true,false)}}};o.prototype.onAfterRendering=function(){if(!this.getVisible()){return}var e=jQuery(document.getElementById(s.Dummy+this.getId()));var t=n.findPreservedContent(this.getId());var r;var i=false;if(!this.getPreferDOM()||t.length==0){t.remove();r=new jQuery(this.getContent());e.replaceWith(r)}else if(t.length>0){e.replaceWith(t);r=t;i=true}else{e.remove()}this._postprocessNewContent(r);this.fireAfterRendering({isPreservedDOM:i})};o.prototype._postprocessNewContent=function(t){if(t&&t.length>0){if(t.length>1){e.warning("[Unsupported Feature]: "+this+" has rendered "+t.length+" root nodes!")}else{var r=t.attr("id");if(r&&r!=this.getId()){e.warning("[Unsupported Feature]: Id of HTML Control '"+this.getId()+"' does not match with content id '"+r+"'!")}}if(this.getPreferDOM()){n.markPreservableContent(t,this.getId())}if(t.find("#"+this.getId().replace(/(:|\.)/g,"\\$1")).length===0){t.filter(":not([id])").first().attr("id",this.getId())}}else{e.debug(""+this+" is empty after rendering, setting bOutput to false");this.bOutput=false}};o.prototype.setDOMContent=function(e){var t=jQuery(e);if(this.getDomRef()){jQuery(this.getDomRef()).replaceWith(t);this._postprocessNewContent(t)}else{t.appendTo(n.getPreserveAreaRef());if(this.getUIArea()){this.getUIArea().invalidate()}this._postprocessNewContent(t)}return this};o.prototype.setTooltip=function(){e.warning("The sap.ui.core.HTML control doesn't support tooltips. Add the tooltip to the HTML content instead.");return t.prototype.setTooltip.apply(this,arguments)};"hasStyleClass addStyleClass removeStyleClass toggleStyleClass".split(" ").forEach(function(n){o.prototype[n]=function(){e.warning("The sap.ui.core.HTML control doesn't support custom style classes. Manage custom CSS classes in the HTML content instead.");return t.prototype[n].apply(this,arguments)}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/HTMLRenderer", ["./RenderManager"],function(e){"use strict";var n=e.RenderPrefixes;var r={apiVersion:2,render:function(e,r){e.openStart("div",n.Dummy+r.getId());e.style("display","none");e.openEnd();e.close("div")}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/History", ["sap/ui/base/Object","sap/ui/util/Storage"],function(t,i){"use strict";var s=t.extend("sap.ui.core.History",{constructor:function(s,r){t.apply(this);if(!r){r={}}var e=r.prefix?r.prefix:document.location.pathname;this._iMaxHistory=r.max?r.max:100;this._sHistoryId=e+s;this._oStorage=new i(i.Type.local);this._fFilter=r.filter?r.filter:function(t,i){return t&&(!i||i&&(typeof i=="string"?t.toLowerCase().startsWith(i.toLowerCase()):false))};this._fCheckHistory=r.checkHistory?r.checkHistory:function(t){return t}},_initHistory:function(){if(!this._aHistory){var t=this._oStorage.get(this._sHistoryId);if(typeof t==="string"){t=t.split(",")}else if(!t){t=[]}this._aHistory=this._fCheckHistory(t)}return this._aHistory},get:function(t){var i=this._initHistory();var s=[];for(var r=0;r<i.length;r++){if(this._fFilter(i[r],t)){s.push(i[r])}}return s},remove:function(t){var i=this._initHistory();for(var s=0;s<i.length;s++){if(i[s]==t){i.splice(s,1);break}}},add:function(t){var i=this._initHistory();for(var s=0;s<i.length;s++){if(i[s]===t){i.splice(s,1);break}}i.unshift(t);if(i.length>this._iMaxHistory){i.splice(this._iMaxHistory)}this._oStorage.put(this._sHistoryId,i)},clear:function(){this._oStorage.remove(this._sHistoryId);this._aHistory=null}});return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Icon", ["sap/base/assert","../Device","./Control","./_IconRegistry","./InvisibleText","./library","./IconRenderer","./Lib","sap/ui/events/KeyCodes","sap/base/Log","sap/base/util/each"],function(e,t,o,r,s,i,n,a,l,u,p){"use strict";var c=i.IconColor;var h=i.CSSColor;var d=function(e){if(e!=null&&e!==""&&!h.isValid(e)&&!(e in c)){u.error('"'+e+'" is not of type sap.ui.core.CSSColor nor of type sap.ui.core.IconColor.');return false}else{return true}};var g=o.extend("sap.ui.core.Icon",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.core",designtime:"sap/ui/core/designtime/Icon.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},color:{type:"string",group:"Appearance",defaultValue:null},hoverColor:{type:"string",group:"Appearance",defaultValue:null},activeColor:{type:"string",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},hoverBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},activeBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},useIconTooltip:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},noTabStop:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{_invisibleText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}},renderer:n});g.prototype[t.support.touch?"ontouchstart":"onmousedown"]=function(e){if(this.hasListeners("press")){e.setMarked()}var t=this.getActiveColor(),o=this.getActiveBackgroundColor(),r;if(t||o){if(!e.targetTouches||e.targetTouches&&e.targetTouches.length===1){r=this.$();r.addClass("sapUiIconActive");if(t){this._addColorClass(t,"color")}if(o){this._addColorClass(o,"background-color")}}}};g.prototype[t.support.touch?"ontouchend":"onmouseup"]=function(e){if(!e.targetTouches||e.targetTouches&&e.targetTouches.length===0){this.$().removeClass("sapUiIconActive");this._restoreColors(t.system.desktop?"hover":undefined)}};g.prototype.onmouseover=function(){var e=this.getHoverColor(),t=this.getHoverBackgroundColor();if(e){this._addColorClass(e,"color")}if(t){this._addColorClass(t,"background-color")}};g.prototype.onmouseout=function(){this._restoreColors()};g.prototype[t.support.touch&&!t.system.desktop?"ontap":"onclick"]=function(e){if(this.hasListeners("press")){e.setMarked()}this.firePress({})};g.prototype.onkeydown=function(e){if(e.which===l.SPACE||e.which===l.ENTER){e.preventDefault();var t=this.$(),o=this.getActiveColor(),r=this.getActiveBackgroundColor();t.addClass("sapUiIconActive");if(o){this._addColorClass(o,"color")}if(r){this._addColorClass(r,"background-color")}}};g.prototype.onkeyup=function(e){if(e.which===l.SPACE||e.which===l.ENTER){this.$().removeClass("sapUiIconActive");this._restoreColors()}};g.prototype.onsapenter=g.prototype.onsapspace=function(e){if(this.hasListeners("press")){e.setMarked()}this.firePress({})};g.prototype._restoreColors=function(e){var t,o;if(e==="hover"){t=this.getHoverColor();o=this.getHoverBackgroundColor()}t=t||this.getColor();o=o||this.getBackgroundColor();this._addColorClass(t||"","color");this._addColorClass(o||"","background-color")};g.prototype._addColorClass=function(e,t){var o=this.$(),r=this;var s="";if(t==="color"){s="sapUiIconColor"}else if(t==="background-color"){s="sapUiIconBGColor"}else{return}p(c,function(e,t){r.removeStyleClass(s+t)});if(e in c){o.css(t,"");this.addStyleClass(s+e)}else{o.css(t,e)}};g.prototype.setSrc=function(t){e(t==null||r.isIconURI(t),this+": Property 'src' (value: '"+t+"') should be a valid Icon URI (sap-icon://...)");return this.setProperty("src",t)};g.prototype.setColor=function(e){if(d(e)){this.setProperty("color",e,true);this._addColorClass(e,"color")}return this};g.prototype.setActiveColor=function(e){if(d(e)){this.setProperty("activeColor",e,true)}return this};g.prototype.setHoverColor=function(e){if(d(e)){this.setProperty("hoverColor",e,true)}return this};g.prototype.setBackgroundColor=function(e){if(d(e)){this.setProperty("backgroundColor",e,true);this._addColorClass(e,"background-color")}return this};g.prototype.setActiveBackgroundColor=function(e){if(d(e)){this.setProperty("activeBackgroundColor",e,true)}return this};g.prototype.setHoverBackgroundColor=function(e){if(d(e)){this.setProperty("hoverBackgroundColor",e,true)}return this};g.prototype.attachEvent=function(e){o.prototype.attachEvent.apply(this,arguments);if(e=="press"&&this.hasListeners("press")){this.invalidate()}return this};g.prototype.detachEvent=function(e){o.prototype.detachEvent.apply(this,arguments);if(e=="press"&&!this.hasListeners("press")){this.invalidate()}return this};g.prototype._getOutputTitle=function(e){var t=this.getTooltip_AsString(),o=this.getUseIconTooltip();if(t||o&&e&&e.text){return t||e.text}};g.prototype._getIconLabel=function(e){var t=this.getAlt(),o=this.getTooltip_AsString(),r=this.getUseIconTooltip(),s=t||o||r&&e&&(e.text||e.name);if(s){return s}};g.prototype._createInvisibleText=function(e){var t=this.getAggregation("_invisibleText");if(!t){t=new s(this.getId()+"-label",{text:e});this.setAggregation("_invisibleText",t,true)}else{t.setText(e)}return t};g.prototype._getAccessibilityAttributes=function(e){var t=this.getAriaLabelledBy(),o={},r=this._getIconLabel(e),s;if(this.getDecorative()){o.role="presentation";o.hidden="true"}else if(this.hasListeners("press")){o.role="button"}else{o.role="img"}if(t.length>0){if(r){s=this._createInvisibleText(r);t.push(s.getId())}o.labelledby=t.join(" ")}else if(r){o.label=r}return o};g.prototype.getAccessibilityInfo=function(){if(this.getDecorative()){return null}var e=this.hasListeners("press");var t=r.getIconInfo(this.getSrc(),undefined,"sync");return{role:e?"button":"img",type:a.getResourceBundleFor("sap.ui.core").getText(e?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||(t?t.text||t.name:""),focusable:e}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/IconPool", ["sap/ui/core/Icon","sap/ui/core/_IconRegistry","sap/base/Log","./Core"],function(t,a,e){"use strict";var o={};o.createControlByURI=function(a,e){if(typeof a==="string"){a={src:a}}if(a&&a.src){var n=a.src,i=e;if(o.isIconURI(n)){i=t;if(a.tap){a.press=a.tap;delete a.tap}}if(typeof i==="function"){a=i.getMetadata().removeUnknownSettings(a);return new i(a)}}};o.addIcon=a.addIcon;o.getIconURI=a.getIconURI;o.getIconInfo=a.getIconInfo;o.fontLoaded=function(t){var e=a.getFontRegistry();if(e[t]){if(e[t].metadataLoaded instanceof Promise){return e[t].metadataLoaded}else if(e[t].metadataLoaded===true){return Promise.resolve()}}};o.isIconURI=a.isIconURI;o.getIconCollectionNames=a.getIconCollectionNames;o.getIconNames=a.getIconNames;o.insertFontFaceStyle=a.insertFontFaceStyle;o.registerFont=function(t){t.collectionName=t.collectionName||t.fontFamily;if(!t.fontURI){e.error("The configuration parameter fontURI is missing, cannot register the font '"+t.collectionName+"'!");return}if(t.fontFamily===a.sapIconFontFamily){e.error("The font family"+a.sapIconFontFamily+" is already registered");return}if(t.fontURI.substr(t.fontURI.length-1)!=="/"){t.fontURI+="/"}var o=a.getFontRegistry();if(!o[t.collectionName]||o[t.collectionName].metadataLoaded===false){o[t.collectionName]={config:t}}else{e.warning("The font '"+t.collectionName+"' is already registered")}if(!t.lazy){a._loadFontMetadata(t.collectionName,true)}};var n={"application/msword":"sap-icon://doc-attachment","application/vnd.google-apps.document":"sap-icon://doc-attachment","application/vnd.openxmlformats-officedocument.wordprocessingml.document":"sap-icon://doc-attachment","application/rtf":"sap-icon://doc-attachment","application/pdf":"sap-icon://pdf-attachment","application/vnd.google-apps.spreadsheet":"sap-icon://excel-attachment","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":"sap-icon://excel-attachment","application/vnd.ms-excel":"sap-icon://excel-attachment","application/msexcel":"sap-icon://excel-attachment","application/vnd.ms-powerpoint":"sap-icon://ppt-attachment","application/vnd.google-apps.presentation":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.presentation":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.slideshow":"sap-icon://ppt-attachment","application/mspowerpoint":"sap-icon://ppt-attachment","application/xml":"sap-icon://attachment-html","application/xhtml+xml":"sap-icon://attachment-html","application/x-httpd-php":"sap-icon://attachment-html","application/x-javascript":"sap-icon://attachment-html","application/gzip":"sap-icon://attachment-zip-file","application/x-rar-compressed":"sap-icon://attachment-zip-file","application/x-tar":"sap-icon://attachment-zip-file","application/zip":"sap-icon://attachment-zip-file","audio/mpeg":"sap-icon://attachment-audio","audio/voxware":"sap-icon://attachment-audio","audio/x-aiff":"sap-icon://attachment-audio","audio/x-midi":"sap-icon://attachment-audio","audio/x-mpeg":"sap-icon://attachment-audio","audio/x-m4a":"sap-icon://attachment-audio","audio/x-pn-realaudio":"sap-icon://attachment-audio","audio/x-pn-realaudio-plugin":"sap-icon://attachment-audio","audio/x-qt-stream":"sap-icon://attachment-audio","audio/x-wav":"sap-icon://attachment-audio","image/png":"sap-icon://attachment-photo","image/tiff":"sap-icon://attachment-photo","image/bmp":"sap-icon://attachment-photo","image/jpeg":"sap-icon://attachment-photo","image/gif":"sap-icon://attachment-photo","text/plain":"sap-icon://attachment-text-file","text/comma-separated-values":"sap-icon://attachment-text-file","text/css":"sap-icon://attachment-text-file","text/javascript":"sap-icon://attachment-text-file","text/richtext":"sap-icon://attachment-text-file","text/rtf":"sap-icon://attachment-text-file","text/tab-separated-values":"sap-icon://attachment-text-file","text/xml":"sap-icon://attachment-text-file","text/html":"sap-icon://attachment-html","video/mpeg":"sap-icon://attachment-video","video/mp4":"sap-icon://attachment-video","video/quicktime":"sap-icon://attachment-video","video/x-msvideo":"sap-icon://attachment-video","application/x-shockwave-flash":"sap-icon://attachment-video"};o.getIconForMimeType=function(t){return n[t]||"sap-icon://document"};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/IconRenderer", ["./_IconRegistry","./library","sap/base/security/encodeCSS"],function(e,t,i){"use strict";var n=t.IconColor;var s={apiVersion:2};s.render=function(t,s){var r=e.getIconInfo(s.getSrc(),undefined,"mixed"),a=s.getWidth(),o=s.getHeight(),l=s.getColor(),c=s.getBackgroundColor(),g=s.getSize(),f=s._getOutputTitle(r),p,d,u,y=false;if(r instanceof Promise){r.then(s.invalidate.bind(s))}else if(r){y=true;p=s.getAriaLabelledBy();u=s._getAccessibilityAttributes(r);d=s.getAggregation("_invisibleText")}t.openStart("span",s);t.class("sapUiIcon");if(y){t.accessibilityState(s,u);t.attr("data-sap-ui-icon-content",r.content);t.style("font-family","'"+i(r.fontFamily)+"'");if(!r.suppressMirroring){t.class("sapUiIconMirrorInRTL")}}if(s.hasListeners("press")){t.class("sapUiIconPointer");if(!s.getNoTabStop()){t.attr("tabindex","0")}}t.style("width",a);t.style("height",o);t.style("line-height",o);t.style("font-size",g);if(l&&!(l in n)){t.style("color",l)}if(c&&!(c in n)){t.style("background-color",c)}t.openEnd();if(f){t.openStart("span").class("sapUiIconTitle").attr("title",f).attr("aria-hidden",true).openEnd().close("span")}if(p&&p.length&&d){t.renderControl(d)}t.close("span")};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/IndicationColorSupport", ["./library","sap/ui/core/Lib"],function(I,T){"use strict";var N=I.IndicationColor;var t={};var e=null;var A=function(){if(!e){e={};var I=T.getResourceBundleFor("sap.ui.core");e[N.Indication01]=I.getText("INDICATION_STATE_INDICATION01");e[N.Indication02]=I.getText("INDICATION_STATE_INDICATION02");e[N.Indication03]=I.getText("INDICATION_STATE_INDICATION03");e[N.Indication04]=I.getText("INDICATION_STATE_INDICATION04");e[N.Indication05]=I.getText("INDICATION_STATE_INDICATION05");e[N.Indication06]=I.getText("INDICATION_STATE_INDICATION06");e[N.Indication07]=I.getText("INDICATION_STATE_INDICATION07");e[N.Indication08]=I.getText("INDICATION_STATE_INDICATION08");e[N.Indication09]=I.getText("INDICATION_STATE_INDICATION09");e[N.Indication10]=I.getText("INDICATION_STATE_INDICATION10");e[N.Indication11]=I.getText("INDICATION_STATE_INDICATION11");e[N.Indication12]=I.getText("INDICATION_STATE_INDICATION12");e[N.Indication13]=I.getText("INDICATION_STATE_INDICATION13");e[N.Indication14]=I.getText("INDICATION_STATE_INDICATION14");e[N.Indication15]=I.getText("INDICATION_STATE_INDICATION15");e[N.Indication16]=I.getText("INDICATION_STATE_INDICATION16");e[N.Indication17]=I.getText("INDICATION_STATE_INDICATION17");e[N.Indication18]=I.getText("INDICATION_STATE_INDICATION18");e[N.Indication19]=I.getText("INDICATION_STATE_INDICATION19");e[N.Indication20]=I.getText("INDICATION_STATE_INDICATION20")}};t.getAdditionalText=function(I){var T=null;if(I&&I.getValueState){T=I.getIndicationColor()}else if(N[I]){T=I}if(T){A();return e[T]}return null};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/InvisibleMessage", ["./library","sap/ui/base/ManagedObject","sap/base/Log","sap/ui/core/StaticArea"],function(e,t,s,i){"use strict";var a;var n=e.InvisibleMessageMode;var r=t.extend("sap.ui.core.InvisibleMessage",{constructor:function(){t.apply(this,arguments);if(a){s.warning("This is a singleton, therefore you are not able to create another instance of this class.");return a}a=this}});r.getInstance=function(){if(!a){a=new r("__invisiblemessage",{})}return a};r.prototype.init=function(){var e=i.getDomRef();e.insertAdjacentHTML("beforeend",this.getPoliteInstance());e.insertAdjacentHTML("beforeend",this.getAssertiveInstance())};r.prototype.announce=function(e,t){var a=i.getDomRef(),r=a.querySelector(".sapUiInvisibleMessagePolite"),o=a.querySelector(".sapUiInvisibleMessageAssertive");if(!r||!o){return}var l=t===n.Assertive?o:r;l.textContent="";l.textContent=e;if(t!==n.Assertive&&t!==n.Polite){s.info("You have entered an invalid mode. Valid values are: "+'"Polite" '+'and "Assertive".'+' The framework will automatically set the mode to "Polite".')}setTimeout(function(){if(l.textContent===e){l.textContent=""}},3e3)};r.prototype.getPoliteInstance=function(){var e=this.getId();return'<span id="'+e+"-polite"+'" data-sap-ui="'+e+"-polite"+'" class="sapUiInvisibleMessagePolite" role="status" aria-live="polite">'+"</span>"};r.prototype.getAssertiveInstance=function(){var e=this.getId();return'<span id="'+e+"-assertive"+'" data-sap-ui="'+e+"-assertive"+'" class="sapUiInvisibleMessageAssertive" role="status" aria-live="assertive">'+"</span>"};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/InvisibleText", ["sap/base/Log","sap/base/i18n/Localization","sap/base/security/encodeXML","./Control","./ControlBehavior","./Element","./Lib","./StaticArea","./library"],function(t,e,r,i,n,s,o,a){"use strict";var p=i.extend("sap.ui.core.InvisibleText",{metadata:{library:"sap.ui.core",publicMethods:["toStatic"],properties:{text:{type:"string",defaultValue:""}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("span",e);t.class("sapUiInvisibleText");t.attr("aria-hidden","true");t.openEnd();t.text(e.getText()||"");t.close("span")}}});function u(e){return function(){t.warning(e+" is not supported by control sap.ui.core.InvisibleText.");return this}}p.prototype.setBusy=u("Property busy");p.prototype.setBusyIndicatorDelay=u("Property busy");p.prototype.setBusyIndicatorSize=u("Property busy");p.prototype.setVisible=u("Property visible");p.prototype.setTooltip=u("Aggregation tooltip");p.prototype.setText=function(t){this.setProperty("text",t,true);this.$().html(r(this.getText()||""));return this};p.prototype.getRendererMarkup=function(){var t=this.getId();return'<span id="'+t+'" data-sap-ui="'+t+'" class="sapUiInvisibleText" aria-hidden="true">'+r(this.getText())+"</span>"};p.prototype.toStatic=function(){try{var t=a.getDomRef();t.insertAdjacentHTML("beforeend",this.getRendererMarkup());this.bOutput=true}catch(t){this.placeAt("sap-ui-static")}return this};p.prototype.exit=function(){var t=this.getDomRef();if(t&&a.contains(t)){t.remove()}};var c=Object.create(null);p.getStaticId=function(t,e){var r="",i,s,a;if(n.isAccessibilityEnabled()&&e){i=t+"|"+e;r=c[i];if(r==null){s=o.getResourceBundleFor(t);a=(new p).setText(s?s.getText(e):e);a.toStatic();r=c[i]=a.getId();delete a._sOwnerId}}return r};e.attachChange(function(t){var e,r,i,n;for(e in c){r=e.indexOf("|");i=o.getResourceBundleFor(e.slice(0,r));n=s.getElementById(c[e]);n&&n.setText(i.getText(e.slice(r+1)))}});return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Item", ["./Element","./library"],function(e,t){"use strict";var r=t.TextDirection;var a=e.extend("sap.ui.core.Item",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Misc",defaultValue:r.Inherit},key:{type:"string",group:"Data",defaultValue:null}}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/LayoutData", ["./Element","sap/ui/thirdparty/jquery","./library"],function(t,jQuery){"use strict";var a=t.extend("sap.ui.core.LayoutData",{metadata:{abstract:true,library:"sap.ui.core"}});a.prototype.invalidate=function(){var t=this.getParent();if(t&&t.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){t=t.getParent()}if(t){var a=t.getParent();if(a){var e=jQuery.Event("LayoutDataChange");e.srcControl=t;a._handleEvent(e)}}};a.prototype.setLayoutData=function(t){return this};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ListItem", ["./Item","./library"],function(e){"use strict";var t=e.extend("sap.ui.core.ListItem",{metadata:{library:"sap.ui.core",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},additionalText:{type:"string",group:"Data",defaultValue:null}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/LocalBusyIndicator", ["./Control","./theming/Parameters","./LocalBusyIndicatorRenderer","./library"],function(t,e,i){"use strict";var o=t.extend("sap.ui.core.LocalBusyIndicator",{metadata:{deprecated:true,library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100px"},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100px"}}},renderer:i});o.prototype.init=function(){var t="sap.ui.core.LocalBusyIndicator:";var i="sapUiLocalBusyIndicatorBoxSize";i=e.get(t+i);this._iBoxSize=8;i="sapUiLocalBusyIndicatorBoxColor";this._sBoxColor=e.get(t+i);i="sapUiLocalBusyIndicatorBoxColorActive";this._sBoxColorActive=e.get(t+i);this._animateProxy=r.bind(this)};o.prototype.exit=function(){clearTimeout(this._delayedCallId);delete this._delayedCallId};o.prototype.onThemeChanged=function(t){if(this.getDomRef()){this.invalidate()}};o.prototype.onAfterRendering=function(){var t=parseInt(this.getWidth());var e=parseInt(this.getHeight());var i=this.$();i.css("width",t+"px");i.css("height",e+"px");var o=this.$("animation");var r=Math.floor(t/2);r-=Math.floor(5*this._iBoxSize/2);var s=Math.floor(e/2)-Math.floor(this._iBoxSize/2);o.css("left",r+"px");o.css("top",s+"px");if(!this._$left){this._$left=this.$("leftBox")}if(!this._$middle){this._$middle=this.$("middleBox")}if(!this._$right){this._$right=this.$("rightBox")}this._delayedCallId=setTimeout(this._animateProxy,0)};var r=function(){if(this.getDomRef()){var t=this;var e,i,o;var r="",s="";if(t._$left){e=t._$left}else{return}if(t._$middle){i=t._$middle}else{return}if(t._$right){o=t._$right}else{return}if(t._sBoxColor){r=t._sBoxColor}else{return}if(t._sBoxColorActive){s=t._sBoxColorActive}else{return}e.css("background-color",s);setTimeout(function(){e.css("background-color",r);i.css("background-color",s);setTimeout(function(){i.css("background-color",r);o.css("background-color",s);setTimeout(function(){o.css("background-color",r)},150)},150)},150);this._delayedCallId=setTimeout(this._animateProxy,1200)}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/LocalBusyIndicatorRenderer", function(){"use strict";var n=function(n,a){var i=a.getId();var o=i+"-animation";var t=["-leftBox","-middleBox","-rightBox"];n.openStart("div",o);n.class("sapUiLocalBusyIndicatorAnimation");n.openEnd();for(var e=0;e<t.length;e++){n.openStart("div",i+t[e]);n.class("sapUiLocalBusyIndicatorBox");n.openEnd();n.close("div")}n.close("div")};var a={apiVersion:2};a.render=function(a,i){a.openStart("div",i);a.class("sapUiLocalBusyIndicator");a.openEnd();n(a,i);a.close("div")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/LocalBusyIndicatorSupport", ["./Control","sap/base/Log"],function(t,e){"use strict";var s=function(){if(this===t.prototype){this.setDelay=this.setBusyIndicatorDelay}else{e.error("Only controls can use the LocalBusyIndicator",this)}};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/LocaleData", ["./CalendarType","./Locale","sap/base/assert","sap/base/i18n/LanguageTag","sap/base/i18n/Localization","sap/base/util/extend","sap/base/util/LoaderExtensions","sap/ui/base/Object","sap/ui/core/Configuration","sap/ui/core/date/CalendarWeekNumbering"],function(e,t,r,n,i,a,o,s,u,l){"use strict";var c=/c/i,f=/e/i,g={"acceleration-meter-per-second-squared":"acceleration-meter-per-square-second","concentr-milligram-per-deciliter":"concentr-milligram-ofglucose-per-deciliter","concentr-part-per-million":"concentr-permillion","consumption-liter-per-100kilometers":"consumption-liter-per-100-kilometer","mass-metric-ton":"mass-tonne","pressure-millimeter-of-mercury":"pressure-millimeter-ofhg","pressure-pound-per-square-inch":"pressure-pound-force-per-square-inch","pressure-inch-hg":"pressure-inch-ofhg","torque-pound-foot":"torque-pound-force-foot"},m=/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/,h=/0+$/;const d=/(.*)?\{[0|1]}(.*)?\{[0|1]}(.*)?/;const p=["narrow","abbreviated","wide"];var _=s.extend("sap.ui.core.LocaleData",{constructor:function(e){s.apply(this);this.oLocale=t._getCoreLocale(e);var r=T(this.oLocale);this.mData=r.mData;this.sCLDRLocaleId=r.sCLDRLocaleId},_get:function(){return this._getDeep(this.mData,arguments)},_getMerged:function(){return this._get.apply(this,arguments)},_getMonthsWithAlternatives:function(e,t){return this._get(P(t),"months","format",e)},_getMonthsStandAloneWithAlternatives:function(e,t){return this._get(P(t),"months","stand-alone",e)},_getDeep:function(e,t){var r=e;for(var n=0;n<t.length;n++){r=r[t[n]];if(r===undefined){break}}return r},getOrientation:function(){return this._get("orientation")},getCurrentLanguageName:function(){return this.getLanguageName(this.oLocale.toString())},getLanguageName:function(e){const t=new n(e);let r=i.getModernLanguage(t.language);let a=t.script;if(r==="sr"&&a==="Latn"){r="sh";a=null}const o=t.region;const s=this._get("languages");const u=s[r];if(!a&&!o||!u){return u}const l=s[r+"_"+o]||s[r+"_"+a];if(l){return l}if(a){const e=this._get("scripts")[a];if(e){return u+" ("+e+")"}}if(o){const e=this._get("territories")[o];if(e){return u+" ("+e+")"}}return u},getLanguages:function(){const e=this._get("languages");["ar_001","de_AT","de_CH","en_AU","en_CA","en_GB","en_US","es_419","es_ES","es_MX","fa_AF","fr_CA","fr_CH","nds_NL","nl_BE","pt_BR","pt_PT","ro_MD","sw_CD","zh_Hans","zh_Hant"].forEach(t=>{if(!e[t]){e[t]=this.getLanguageName(t)}});return e},getScripts:function(){return this._get("scripts")},getTerritories:function(){return this._get("territories")},getMonths:function(e,t){r(p.includes(e),"sWidth must be narrow, abbreviated or wide");return this._get(P(t),"months","format",e).map(e=>Array.isArray(e)?e[0]:e)},getMonthsStandAlone:function(e,t){r(p.includes(e),"sWidth must be narrow, abbreviated or wide");return this._get(P(t),"months","stand-alone",e).map(e=>Array.isArray(e)?e[0]:e)},getDays:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide"||e=="short","sWidth must be narrow, abbreviate, wide or short");return this._get(P(t),"days","format",e)},getDaysStandAlone:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide"||e=="short","sWidth must be narrow, abbreviated, wide or short");return this._get(P(t),"days","stand-alone",e)},getQuarters:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(P(t),"quarters","format",e)},getQuartersStandAlone:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(P(t),"quarters","stand-alone",e)},getDayPeriods:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(P(t),"dayPeriods","format",e)},getDayPeriodsStandAlone:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(P(t),"dayPeriods","stand-alone",e)},getDatePattern:function(e,t){r(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(P(t),"dateFormats",e)},getFlexibleDayPeriods:function(e,t){return this._get(P(t),"flexibleDayPeriods","format",e)},getFlexibleDayPeriodsStandAlone:function(e,t){return this._get(P(t),"flexibleDayPeriods","stand-alone",e)},getFlexibleDayPeriodOfTime:function(e,t){var r,n,i;r=(e*60+t)%1440;n=this._get("dayPeriodRules");function a(e){var t=e.split(":"),r=t[0],n=t[1];return parseInt(r)*60+parseInt(n)}i=Object.keys(n).find(function(e){var t=n[e];return t["_at"]&&a(t["_at"])===r});if(i){return i}return Object.keys(n).find(function(e){var t,i,o,s=n[e];if(s["_at"]){return false}o=a(s["_from"]);t=a(s["_before"]);if(o>t){i=[{start:o,end:1440},{start:0,end:t}]}else{i=[{start:o,end:t}]}return i.some(function(e){return e.start<=r&&e.end>r})})},getTimePattern:function(e,t){r(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(P(t),"timeFormats",e)},getDateTimePattern:function(e,t){r(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(P(t),"dateTimeFormats",e)},getCombinedDateTimePattern:function(e,t,n){r(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");r(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");var i=this.getDateTimePattern(e,n),a=this.getDatePattern(e,n),o=this.getTimePattern(t,n);return i.replace("{0}",o).replace("{1}",a)},getCombinedDateTimeWithTimezonePattern:function(e,t,r){return this.applyTimezonePattern(this.getCombinedDateTimePattern(e,t,r))},applyTimezonePattern:function(e){var t=[e];var r=[{group:"Timezone",length:2,field:"zone",symbol:"V"}];this._appendItems(t,r);return t[0]},getTimezoneTranslations:function(){var e=this.oLocale.toString();var t=_._mTimezoneTranslations[e];if(!t){_._mTimezoneTranslations[e]=t=k(this._get("timezoneNames"))}return Object.assign({},t)},getCustomDateTimePattern:function(e,t){var r=this._get(P(t),"dateTimeFormats","availableFormats");return this._getFormatPattern(e,r,t)},getIntervalPattern:function(e,t){var r=this._get(P(t),"dateTimeFormats","intervalFormats"),n,i,a,o,s;if(e){n=e.split("-");i=n[0];a=n[1];o=r[i];if(o){s=o[a];if(s){return s}}}return r.intervalFormatFallback},getCombinedIntervalPattern:function(e,t){const r=this._get(P(t),"dateTimeFormats","intervalFormats");const[,n,i,a]=d.exec(r.intervalFormatFallback);return _._escapeIfNeeded(n)+e+_._escapeIfNeeded(i)+e+_._escapeIfNeeded(a)},getCustomIntervalPattern:function(e,t,r){var n=this._get(P(r),"dateTimeFormats","intervalFormats");return this._getFormatPattern(e,n,r,t)},_getFormatPattern:function(e,t,r,n){var i,a,o;if(!n){i=t[e]}else if(typeof n==="string"){if(n=="j"||n=="J"){n=this.getPreferredHourSymbol()}o=t[e];i=o&&o[n]}if(i){if(typeof i==="object"){a=Object.keys(i).map(function(e){return i[e]})}else{return i}}if(!a){a=this._createFormatPattern(e,t,r,n)}if(a&&a.length===1){return a[0]}return a},_createFormatPattern:function(e,t,r,n){var i=this._parseSkeletonFormat(e),a,o=this._findBestMatch(i,e,t),s,u,l,c,f,g,m,h,d=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,p,_;if(n){if(typeof n==="string"){h=v[n]?v[n].group:"";if(h){p=y[h].index>i[i.length-1].index}m=n}else{p=true;if(i[0].symbol==="y"&&o&&o.pattern.G){l=v["G"];c=y[l.group];i.splice(0,0,{symbol:"G",group:l.group,match:l.match,index:c.index,field:c.field,length:1})}for(_=i.length-1;_>=0;_--){s=i[_];if(n[s.group]){p=false;break}}for(_=0;_<i.length;_++){s=i[_];if(n[s.group]){m=s.symbol;break}}if((m=="h"||m=="K")&&n.DayPeriod){m="a"}}if(p){return[this.getCustomDateTimePattern(e,r)]}if(o&&o.missingTokens.length===0){f=o.pattern[m];if(f&&o.distance>0){f=this._expandFields(f,o.patternTokens,i)}}if(!f){u=this._get(P(r),"dateTimeFormats","availableFormats");if(d.test(e)&&"ahHkKjJms".indexOf(m)>=0){f=this._getMixedFormatPattern(e,u,r,n)}else{g=this._getFormatPattern(e,u,r);f=this.getCombinedIntervalPattern(g,r)}}a=[f]}else if(!o){f=e;a=[f]}else{if(typeof o.pattern==="string"){a=[o.pattern]}else if(typeof o.pattern==="object"){a=[];for(var b in o.pattern){f=o.pattern[b];a.push(f)}}if(o.distance>0){if(o.missingTokens.length>0){if(d.test(e)){a=[this._getMixedFormatPattern(e,t,r)]}else{a=this._expandFields(a,o.patternTokens,i);a=this._appendItems(a,o.missingTokens,r)}}else{a=this._expandFields(a,o.patternTokens,i)}}}if(e.indexOf("J")>=0){a.forEach(function(e,t){a[t]=e.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"")})}return a},_parseSkeletonFormat:function(e){var t=[],r={index:-1},n,i,a;for(var o=0;o<e.length;o++){n=e.charAt(o);if(n=="j"||n=="J"){n=this.getPreferredHourSymbol()}if(n==r.symbol){r.length++;continue}i=v[n];a=y[i.group];if(i.group=="Other"||a.diffOnly){throw new Error("Symbol '"+n+"' is not allowed in skeleton format '"+e+"'")}if(a.index<=r.index){throw new Error("Symbol '"+n+"' at wrong position or duplicate in skeleton format '"+e+"'")}r={symbol:n,group:i.group,match:i.match,index:a.index,field:a.field,length:1};t.push(r)}return t},_findBestMatch:function(e,t,r){var n,i,a,o,s,u,l,c,f,g,m={distance:1e4,firstDiffPos:-1};for(var h in r){if(h==="intervalFormatFallback"||h.indexOf("B")>-1){continue}n=this._parseSkeletonFormat(h);u=0;i=[];l=true;if(e.length<n.length){continue}s=0;c=e.length;for(var d=0;d<e.length;d++){a=e[d];o=n[s];if(c===e.length){c=d}if(o){f=v[a.symbol];g=v[o.symbol];if(a.symbol===o.symbol){if(a.length===o.length){if(c===d){c=e.length}}else{if(a.length<f.numericCeiling?o.length<g.numericCeiling:o.length>=g.numericCeiling){u+=Math.abs(a.length-o.length)}else{u+=5}}s++;continue}else{if(a.match==o.match){u+=Math.abs(a.length-o.length)+10;s++;continue}}}i.push(a);u+=50-d}if(s<n.length){l=false}if(l&&(u<m.distance||u===m.distance&&c>m.firstDiffPos)){m.distance=u;m.firstDiffPos=c;m.missingTokens=i;m.pattern=r[h];m.patternTokens=n}}if(m.pattern){return m}},_expandFields:function(e,t,r){var n=typeof e==="string";var i;if(n){i=[e]}else{i=e}var a=i.map(function(e){var n={},i={},a="",o=false,s=0,u,l,c,f,g,m,h,d;r.forEach(function(e){n[e.group]=e});t.forEach(function(e){i[e.group]=e});while(s<e.length){d=e.charAt(s);if(o){a+=d;if(d=="'"){o=false}}else{h=v[d];if(h&&n[h.group]&&i[h.group]){g=n[h.group];m=i[h.group];u=g.length;c=m.length;l=1;while(e.charAt(s+1)==d){s++;l++}if(u===c||(u<h.numericCeiling?l>=h.numericCeiling:l<h.numericCeiling)){f=l}else{f=Math.max(l,u)}for(var p=0;p<f;p++){a+=d}}else{a+=d;if(d=="'"){o=true}}}s++}return a});return n?a[0]:a},_appendItems:function(e,t,r){var n=this._get(P(r),"dateTimeFormats","appendItems");e.forEach(function(r,i){var a,o,s;t.forEach(function(t){o=n[t.group];a="'"+this.getDisplayName(t.field)+"'";s="";for(var u=0;u<t.length;u++){s+=t.symbol}e[i]=o.replace(/\{0\}/,r).replace(/\{1\}/,s).replace(/\{2\}/,a)}.bind(this))}.bind(this));return e},_getMixedFormatPattern:function(e,t,r,n){var i=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,a=/MMMM|LLLL/,o=/MMM|LLL/,s=/E|e|c/,u,l,c,f,g,m,h,d;u=i.exec(e);l=u[1];c=u[2];g=this._getFormatPattern(l,t,r);if(n){m=this.getCustomIntervalPattern(c,n,r)}else{m=this._getFormatPattern(c,t,r)}if(a.test(l)){f=s.test(l)?"full":"long"}else if(o.test(l)){f="medium"}else{f="short"}h=this.getDateTimePattern(f,r);d=h.replace(/\{1\}/,g).replace(/\{0\}/,m);return d},getNumberSymbol:function(e){r(e=="decimal"||e=="group"||e=="plusSign"||e=="minusSign"||e=="percentSign","sType must be decimal, group, plusSign, minusSign or percentSign");return this._get("symbols-latn-"+e)},getLenientNumberSymbols:function(e){r(e=="plusSign"||e=="minusSign","sType must be plusSign or minusSign");return this._get("lenient-scope-number")[e]},getDecimalPattern:function(){return this._get("decimalFormat").standard},getCurrencyPattern:function(e){return this._get("currencyFormat")[e]||this._get("currencyFormat").standard},getCurrencySpacing:function(e){return this._get("currencyFormat","currencySpacing",e==="after"?"afterCurrency":"beforeCurrency")},getPercentPattern:function(){return this._get("percentFormat").standard},getMiscPattern:function(e){r(e=="approximately"||e=="atLeast"||e=="atMost"||e=="range","sName must be approximately, atLeast, atMost or range");return this._get("miscPattern")[e]},getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays")},getFirstDayOfWeek:function(){return this._get("weekData-firstDay")},getWeekendStart:function(){return this._get("weekData-weekendStart")},getWeekendEnd:function(){return this._get("weekData-weekendEnd")},getCustomCurrencyCodes:function(){var e=this._get("currency")||{},t={};Object.keys(e).forEach(function(e){t[e]=e});return t},getCurrencyDigits:function(e){var t=this._get("currency");if(t){if(t[e]&&t[e].hasOwnProperty("digits")){return t[e].digits}else if(t["DEFAULT"]&&t["DEFAULT"].hasOwnProperty("digits")){return t["DEFAULT"].digits}}var r=this._get("currencyDigits",e);if(r==null){r=this._get("currencyDigits","DEFAULT");if(r==null){r=2}}return r},getCurrencySymbol:function(e){var t=this.getCurrencySymbols();return t&&t[e]||e},getCurrencyCodeBySymbol:function(e){var t=this._get("currencySymbols"),r;for(r in t){if(t[r]===e){return r}}return e},getCurrencySymbols:function(){var e=this._get("currency"),t={},r;for(var n in e){r=e[n].isoCode;if(e[n].symbol){t[n]=e[n].symbol}else if(r){t[n]=this._get("currencySymbols")[r]}}return Object.assign({},this._get("currencySymbols"),t)},getUnitDisplayName:function(e){var t=this.getUnitFormat(e);return t&&t["displayName"]||""},getRelativePatterns:function(e,t){if(t===undefined){t="wide"}r(t==="wide"||t==="short"||t==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var n=[],i=this.getPluralCategories(),a,o,s,u;if(!e){e=["year","month","week","day","hour","minute","second"]}e.forEach(function(e){a=this._get("dateFields",e+"-"+t);for(var r in a){if(r.indexOf("relative-type-")===0){s=parseInt(r.substr(14));n.push({scale:e,value:s,pattern:a[r]})}else if(r.indexOf("relativeTime-type-")==0){o=a[r];u=r.substr(18)==="past"?-1:1;i.forEach(function(t){var r=o["relativeTimePattern-count-"+t];if(r){n.push({scale:e,sign:u,pattern:r})}})}}}.bind(this));return n},getRelativePattern:function(e,t,n,i){var a,o,s,u;if(typeof n==="string"){i=n;n=undefined}if(n===undefined){n=t>0}if(i===undefined){i="wide"}r(i==="wide"||i==="short"||i==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");s=e+"-"+i;if(t===0||t===-2||t===2){a=this._get("dateFields",s,"relative-type-"+t)}if(!a){o=this._get("dateFields",s,"relativeTime-type-"+(n?"future":"past"));u=this.getPluralCategory(Math.abs(t).toString());a=o["relativeTimePattern-count-"+u]}return a},getRelativeSecond:function(e,t){return this.getRelativePattern("second",e,t)},getRelativeMinute:function(e,t){if(e==0){return null}return this.getRelativePattern("minute",e,t)},getRelativeHour:function(e,t){if(e==0){return null}return this.getRelativePattern("hour",e,t)},getRelativeDay:function(e,t){return this.getRelativePattern("day",e,t)},getRelativeWeek:function(e,t){return this.getRelativePattern("week",e,t)},getRelativeMonth:function(e,t){return this.getRelativePattern("month",e,t)},getDisplayName:function(e,t){r(e=="second"||e=="minute"||e=="hour"||e=="zone"||e=="day"||e=="weekday"||e=="week"||e=="month"||e=="quarter"||e=="year"||e=="era","sType must be second, minute, hour, zone, day, weekday, week, month, quarter, year, era");if(t===undefined){t="wide"}r(t==="wide"||t==="short"||t==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var n=["era","weekday","zone"],i=n.indexOf(e)===-1?e+"-"+t:e;return this._get("dateFields",i,"displayName")},getRelativeYear:function(e,t){return this.getRelativePattern("year",e,t)},getDecimalFormat:function(e,t,r){var n;var i;switch(e){case"long":i=this._get("decimalFormat-long");break;default:i=this._get("decimalFormat-short");break}if(i){var a=t+"-"+r;n=i[a];if(!n){a=t+"-other";n=i[a]}}return n},getCurrencyFormat:function(e,t,r){var n;var i=this._get("currencyFormat-"+e);if(!i){if(e==="sap-short"){throw new Error('Failed to get CLDR data for property "currencyFormat-sap-short"')}i=this._get("currencyFormat-short")}if(i){var a=t+"-"+r;n=i[a];if(!n){a=t+"-other";n=i[a]}}return n},getListFormat:function(e,t){var r=this._get("listPattern-"+(e||"standard")+"-"+(t||"wide"));if(r){return r}return{}},getResolvedUnitFormat:function(e){e=this.getUnitFromMapping(e)||e;return this.getUnitFormat(e)},getUnitFormat:function(e){var t=this._get("units","short",e);if(!t&&g[e]){t=this._get("units","short",g[e])}return t},getUnitFormats:function(){return this._getMerged("units","short")},getUnitFromMapping:function(e){return this._get("unitMappings",e)},getEras:function(e,t){r(e=="wide"||e=="abbreviated"||e=="narrow","sWidth must be wide, abbreviate or narrow");var n=this._get(P(t),"era-"+e),i=[];for(var a in n){i[parseInt(a)]=n[a]}return i},getEraDates:function(e){var t=this._get("eras-"+e.toLowerCase()),r=[];for(var n in t){r[parseInt(n)]=t[n]}return r},getCalendarWeek:function(e,t){r(e=="wide"||e=="narrow","sStyle must be wide or narrow");var n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",this.oLocale.toString()),i="date.week.calendarweek."+e;return n.getText(i,t?[t]:undefined)},firstDayStartsFirstWeek:function(){return this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="US"},getPreferredCalendarType:function(){var t,r,n,i=this._get("calendarPreference")||[];for(n=0;n<i.length;n++){t=i[n].split("-")[0];for(r in e){if(t===r.toLowerCase()){return r}}}return e.Gregorian},getPreferredHourSymbol:function(){return this._get("timeData","_preferred")},getPluralCategories:function(){var e=this._get("plurals"),t=Object.keys(e);t.push("other");return t},getPluralCategory:function(e){var t=typeof e==="number"?e.toString():e,r=this._get("plurals");if(!this._pluralTest){this._pluralTest={}}for(var n in r){var i=this._pluralTest[n];if(!i){i=this._parsePluralRule(r[n]);this._pluralTest[n]=i}if(i(t).bMatch){return n}}return"other"},_parsePluralRule:function(e){var t="or",r="and",n="%",i="=",a="!=",o="n",s="i",u="f",l="t",g="v",m="w",d="c",p="e",y="..",v=",";var b=0,w;w=e.split(" ");function C(e){if(w[b]===e){b++;return true}return false}function D(){var e=w[b];b++;return e}function k(){var e,r;e=P();if(C(t)){r=k();return function(t){return e(t)||r(t)}}return e}function P(){var e,t;e=T();if(C(r)){t=P();return function(r){return e(r)&&t(r)}}return e}function T(){var e,t,r;e=F();if(C(i)){r=true}else if(C(a)){r=false}else{throw new Error("Expected '=' or '!='")}t=L();if(r){return function(r){return t(r).indexOf(e(r))>=0}}else{return function(r){return t(r).indexOf(e(r))===-1}}}function F(){var e;e=S();if(C(n)){var t=parseInt(D());return function(r){return e(r)%t}}return e}function S(){if(C(o)){return function(e){return e.n}}else if(C(s)){return function(e){return e.i}}else if(C(u)){return function(e){return e.f}}else if(C(l)){return function(e){return e.t}}else if(C(g)){return function(e){return e.v}}else if(C(m)){return function(e){return e.w}}else if(C(d)){return function(e){return e.c}}else if(C(p)){return function(e){return e.c}}else{throw new Error("Unknown operand: "+D())}}function L(){var e=[],t=D(),r=t.split(v),n,i,a;r.forEach(function(t){n=t.split(y);if(n.length===1){e.push(parseInt(t))}else{i=parseInt(n[0]);a=parseInt(n[1]);for(var r=i;r<=a;r++){e.push(r)}}});return function(t){return e}}var x=k();if(b!=w.length){throw new Error("Not completely parsed")}return function(e){var t,r,n,i,a,o,s;e=e.replace(c,"e");n=e.search(f);r=n<0?0:parseInt(e.slice(n+1));e=_.convertToDecimal(e);t=e.indexOf(".");if(t===-1){o=e;i="";a=""}else{o=e.slice(0,t);i=e.slice(t+1);a=i.replace(h,"")}s={n:parseFloat(e),i:parseInt(o),v:i.length,w:a.length,f:i===""?0:parseInt(i),t:a===""?0:parseInt(a),c:r};return{bMatch:x(s),oOperands:s}}}});_.convertToDecimal=function(e){var t,r,n,i,a,o,s=String(e);if(!s.includes("e")&&!s.includes("E")){return s}o=s.match(m);i=o[1]==="-";s=o[2].replace(".","");t=o[3]?o[3].length:0;n=o[4]?o[4].length:0;r=parseInt(o[5]);a=t+r;if(r>0){s=r<n?s.slice(0,a)+"."+s.slice(a):s=s.padEnd(a,"0")}else{s=-r<t?s=s.slice(0,a)+"."+s.slice(a):s="0."+s.padStart(n-r,"0")}if(i){s="-"+s}return s};var y={Era:{field:"era",index:0},Year:{field:"year",index:1},Quarter:{field:"quarter",index:2},Month:{field:"month",index:3},Week:{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},Day:{field:"day",index:6},DayPeriod:{field:"hour",index:7,diffOnly:true},Hour:{field:"hour",index:8},Minute:{field:"minute",index:9},Second:{field:"second",index:10},Timezone:{field:"zone",index:11}};var v={G:{group:"Era",match:"Era",numericCeiling:1},y:{group:"Year",match:"Year",numericCeiling:100},Y:{group:"Year",match:"Year",numericCeiling:100},Q:{group:"Quarter",match:"Quarter",numericCeiling:3},q:{group:"Quarter",match:"Quarter",numericCeiling:3},M:{group:"Month",match:"Month",numericCeiling:3},L:{group:"Month",match:"Month",numericCeiling:3},w:{group:"Week",match:"Week",numericCeiling:100},W:{group:"Week",match:"Week",numericCeiling:100},d:{group:"Day",match:"Day",numericCeiling:100},D:{group:"Day",match:"Day",numericCeiling:100},E:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},e:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},c:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},h:{group:"Hour",match:"Hour12",numericCeiling:100},H:{group:"Hour",match:"Hour24",numericCeiling:100},k:{group:"Hour",match:"Hour24",numericCeiling:100},K:{group:"Hour",match:"Hour12",numericCeiling:100},m:{group:"Minute",match:"Minute",numericCeiling:100},s:{group:"Second",match:"Second",numericCeiling:100},z:{group:"Timezone",match:"Timezone",numericCeiling:1},Z:{group:"Timezone",match:"Timezone",numericCeiling:1},O:{group:"Timezone",match:"Timezone",numericCeiling:1},v:{group:"Timezone",match:"Timezone",numericCeiling:1},V:{group:"Timezone",match:"Timezone",numericCeiling:1},X:{group:"Timezone",match:"Timezone",numericCeiling:1},x:{group:"Timezone",match:"Timezone",numericCeiling:1},S:{group:"Other",numericCeiling:100},u:{group:"Other",numericCeiling:100},U:{group:"Other",numericCeiling:1},r:{group:"Other",numericCeiling:100},F:{group:"Other",numericCeiling:100},g:{group:"Other",numericCeiling:100},a:{group:"DayPeriod",numericCeiling:1},b:{group:"Other",numericCeiling:1},B:{group:"Other",numericCeiling:1},A:{group:"Other",numericCeiling:100}};function b(e){var t=/\$([-a-z0-9A-Z._]+)(?::([^$]*))?\$/.exec(e);return t&&t[2]?t[2].split(/,/):null}var w=b("$cldr-locales:ar,ar_EG,ar_SA,bg,ca,cnr,cy,cs,da,de,de_AT,de_CH,el,el_CY,en,en_AU,en_GB,en_HK,en_IE,en_IN,en_NZ,en_PG,en_SG,en_ZA,es,es_AR,es_BO,es_CL,es_CO,es_MX,es_PE,es_UY,es_VE,et,fa,fi,fr,fr_BE,fr_CA,fr_CH,fr_LU,he,hi,hr,hu,id,it,it_CH,ja,kk,ko,lt,lv,mk,ms,nb,nl,nl_BE,pl,pt,pt_PT,ro,ru,ru_UA,sk,sl,sr,sr_Latn,sv,th,tr,uk,vi,zh_CN,zh_HK,zh_SG,zh_TW$");var C=function(){var e=w,t={},r;if(e){for(r=0;r<e.length;r++){t[e[r]]=true}}return t}();var D={};function k(e,t,r,n){n=n?n.slice():[];r=r||{};t=t||"";Object.keys(e).forEach(function(i){var a=e[i];if(typeof a==="object"){var o=n.slice();var s=a["_parent"];if(s){o.push(s)}k(a,t+i+"/",r,o)}else if(typeof a==="string"&&i!=="_parent"){var u=n.length?n.join(", ")+", ":"";r[t+i]=u+a}});return r}function P(e){if(!e){e=u.getCalendarType()}return"ca-"+e.toLowerCase()}function T(e){var t=e.getLanguage()||"",r=e.getScript()||"",n=e.getRegion()||"",a;function s(e,t){var r,n,i;if(!t){return}for(r in t){if(t.hasOwnProperty(r)){n=e[r];i=t[r];if(n===undefined){e[r]=i}else if(n===null){delete e[r]}else if(typeof n==="object"&&typeof i==="object"&&!Array.isArray(n)){s(n,i)}}}}function u(e){if(!D[e]&&(!C||C[e]===true)){var t=D[e]=o.loadResource("sap/ui/core/cldr/"+e+".json",{dataType:"json",failOnError:false});if(t&&t.__fallbackLocale){s(t,u(t.__fallbackLocale));delete t.__fallbackLocale}}return D[e]}t=t&&i.getModernLanguage(t)||t;if(t==="no"){t="nb"}if(t==="zh"&&!n){if(r==="Hans"){n="CN"}else if(r==="Hant"){n="TW"}}if(t==="sh"||t==="sr"&&r==="Latn"){t="sr_Latn"}var l=t+"_"+n;var c=l;if(t&&n){a=u(l)}if(!a&&t){a=u(t);c=t}if(!a){a=u("en");c="en"}D[l]=a;c=c.replace(/_/g,"-");return{mData:a,sCLDRLocaleId:c}}var F=_.extend("sap.ui.core.CustomLocaleData",{constructor:function(e){_.apply(this,arguments);this.mCustomData=u.getFormatSettings().getCustomLocaleData()},_get:function(){var e=Array.prototype.slice.call(arguments),t,r;if(e[0].indexOf("ca-")==0){t=e[0];if(t==P()){e=e.slice(1)}}r=e.join("-");var n=this.mCustomData[r];if(n==null){n=this._getDeep(this.mCustomData,arguments);if(n==null){n=this._getDeep(this.mData,arguments)}}return n},_getMerged:function(){var e=this._getDeep(this.mData,arguments);var t=this._getDeep(this.mCustomData,arguments);return a({},e,t)},getFirstDayOfWeek:function(){var e=u.getCalendarWeekNumbering();if(e===l.Default){return _.prototype.getFirstDayOfWeek.call(this)}return l.getWeekConfigurationValues(e).firstDayOfWeek},getMinimalDaysInFirstWeek:function(){var e=u.getCalendarWeekNumbering();if(e===l.Default){return _.prototype.getMinimalDaysInFirstWeek.call(this)}return l.getWeekConfigurationValues(e).minimalDaysInFirstWeek}});_.getInstance=function(e){e=t._getCoreLocale(e);return e.hasPrivateUseSubtag("sapufmt")?new F(e):new _(e)};_._cldrLocales=w;_._mTimezoneTranslations={};const S=new RegExp("["+Object.keys(v).join("")+"]");const L=/^(\s)?(.*?)(\s)?$/;_._escapeIfNeeded=function(e){if(e===undefined){return""}if(S.test(e)){return e.replace(L,"$1'$2'$3")}return e};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Message", ["./Element","./library","./Theming","sap/base/Log"],function(e,r,a,t){"use strict";var n=r.MessageType;var s=e.extend("sap.ui.core.Message",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:null},timestamp:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},level:{type:"sap.ui.core.MessageType",group:"Misc",defaultValue:n.None},readOnly:{type:"boolean",group:"Misc",defaultValue:false}}}});s.prototype.getDefaultIcon=function(e){var r=sap.ui.require.toUrl("sap/ui/core/themes/"+a.getTheme());var t=r+"/img/message/";if(e&&e=="32x32"){t+="32x32/"}else{t+="16x16/"}var s="";switch(this.getProperty("level")){case n.Error:s=t+"Message_Icon_Error.png";break;case n.Information:s=t+"Message_Icon_Information.png";break;case n.Warning:s=t+"Message_Icon_Warning.png";break;case n.Success:s=t+"Message_Icon_Success.png";break;case n.None:default:s=this.getProperty("icon");break}return s};s.prototype.compareByType=function(e){return s.compareByType(this,e)};s.compareByType=function(e,r){if(!e&&!r){return 0}if(e&&!r){return 1}if(!e&&r){return-1}var a=e.getLevel();var s=r.getLevel();if(a===s){return 0}switch(a){case n.Error:return 1;case n.Warning:return s===n.Error?-1:1;case n.Success:return s===n.Error||s===n.Warning?-1:1;case n.Information:return s===n.None?1:-1;case n.None:return-1;default:t.error("Comparison error",this);return 0}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Placeholder", ["sap/ui/base/Object","sap/base/config","sap/base/util/Deferred","sap/base/util/LoaderExtensions","sap/ui/core/BlockLayerUtils"],function(e,t,i,o,s){"use strict";var a=[];var n=e.extend("sap.ui.core.Placeholder",{constructor:function(t){e.call(this);if(!t.html){throw new Error("An HTML page defining the placeholder's content must be given!")}this.bShow=false;this.placeholderHTML=t.html},show:function(e,t){this.bShow=true;return this._load().then(function(i){if(i&&this.bShow&&!e.getDomRef().contains(this.placeholder)){if(this.blockState){s.unblock(this.blockState)}this.blockState=s.block(e,e.getId()+"--placeholder",t);var o=this.blockState.$blockLayer[0];o.className+=" sapUiPlaceholder";o.insertAdjacentHTML("beforeend",i);this.placeholder=o}return i}.bind(this))},hide:function(){this.bShow=false;if(this.placeholder&&this.blockState){s.unblock(this.blockState);this.placeholder=undefined;this.blockState=undefined}if(this.pLoaded){this.pLoaded.resolve()}},_load:function(){if(!this.pLoaded){this.pLoaded=new i;if(this.placeholderHTML){o.loadResource(this.placeholderHTML,{async:true,dataType:"html"}).then(function(e){this.placeholderContent=e;this.pLoaded.resolve(e)}.bind(this))}else{this.pLoaded.reject()}}return this.pLoaded.promise}});n.registerProvider=function(e){a.push(e)};n.hasProviders=function(){return a.length>0};n.getPlaceholderFromProviders=function(e){var t;if(e){a.some(function(i){t=i(e);return!!t})}return t};n.isEnabled=function(){return t.get({name:"sapUiXxPlaceholder",type:t.Type.Boolean,external:true,defaultValue:true})};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Popup", ["sap/ui/Device","sap/ui/base/DataType","sap/ui/base/Event","sap/ui/base/ManagedObject","sap/ui/base/Object","sap/ui/base/ObjectPool","./Control","./Element","./EventBus","./FocusHandler","./IntervalTrigger","./RenderManager","./ResizeHandler","./library","./StaticArea","sap/base/assert","sap/base/Log","sap/base/i18n/Localization","sap/base/util/Version","sap/base/util/uid","sap/base/util/extend","sap/base/util/each","sap/base/util/deepExtend","sap/ui/events/F6Navigation","sap/ui/events/isMouseEventDelayed","sap/ui/base/EventProvider","sap/ui/thirdparty/jquery","sap/ui/thirdparty/jqueryui/jquery-ui-position","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect"],function(t,e,i,o,s,n,r,a,l,u,f,h,p,c,d,_,m,b,g,v,y,C,E,S,P,O,jQuery){"use strict";var I=c.CSSSize;var L=c.OpenState;var w=c.Collision;var x;var F;var k;var A="sapUiPopupResize";var R=new l;if(window.ResizeObserver){k=new window.ResizeObserver(function(t){N(jQuery("#sap-ui-blocklayer-popup"),t[0].target)})}else{k={observe:function(t){var e=t.dataset[A];if(!e){e=p.register(t,function(t){N(jQuery("#sap-ui-blocklayer-popup"),t.target)});t.dataset[A]=e}},unobserve:function(t){var e=t.dataset[A];if(e){p.deregister(e);delete t.dataset[A]}}}}function D(){if(x){return x}var t;try{x=d.getUIArea()}catch(t){m.error(t);throw new Error("Popup cannot be opened because static UIArea cannot be determined.")}t=new r;x.addDependent(t);x=t.getUIArea();t.destroy();return x}function T(t){var e;if(typeof t==="string"){e=document.querySelector(t)}else if(t instanceof a){e=t.getDomRef()}else{e=t}return e||window}function B(t){var e=["left","top","width","height"];if(t[0]){t[0].classList.remove("sapUiBLyWithin");e.forEach(function(e){t[0].style.removeProperty(e)})}}function N(t,e){var i=e.getBoundingClientRect();t.css({width:i.width,height:i.height}).addClass("sapUiBLyWithin").position({my:"left top",at:"left top",of:e})}var U=o.extend("sap.ui.core.Popup",{constructor:function(t,e,i,s){_(arguments.length==0||t&&typeof t==="object","oContent must be an object or there may be no arguments at all");_(e===undefined||e===true||e===false,"bModal must be true, false, or undefined");_(i===undefined||i===true||i===false,"bShadow must be true, false, or undefined");_(s===undefined||s===true||s===false,"bAutoClose must be true, false, or undefined");o.apply(this);this._popupUID=v();this.bOpen=false;this.eOpenState=L.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;this._mEvents["sap.ui.core.Popup.extendFocusInfo-"+this._popupUID]=this._extendFocusInfoEventBusWrapper;if(t){this.setContent(t)}this._oDefaultPosition={my:U.Dock.CenterCenter,at:U.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=Object.assign({},this._oDefaultPosition);this._bModal=!!e;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof i==="boolean"?i:true;this._bAutoClose=!!s;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(t){if(t.isMarked("delayedMouseEvent")||t.isMarked("cancelAutoClose")){return}if(this.eOpenState===L.CLOSING||this.eOpenState===L.CLOSED){return}if(!this._contains(t.target)){this.close()}}.bind(this)}this._F6NavigationHandler=function(t){var e={},i=this._sF6NavMode,o;if(i=="DOCK"){if(this._bModal){i="NONE"}else if(this._oLastPosition&&this._oLastPosition.of){o=this._getOfDom(this._oLastPosition.of);if(!o||o===document){o=null;i="NONE"}}}switch(i){case"SCOPE":e.scope=this._$()[0];break;case"DOCK":e.target=o;var s=jQuery(o).parents("[data-sap-ui-popup]");e.scope=s.length?s[0]:null;break;default:e.skip=true}S.handleF6GroupNavigation(t,e)}.bind(this)},metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","setExtraContent","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{childPopups:{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{opened:{},closed:{}}}});U.prototype.getChildPopups=function(){return this.getAssociation("childPopups",[])};U.prototype.addChildPopup=function(t){return this.addAssociation("childPopups",t)};U.prototype.removeChildPopup=function(t){return this.removeAssociation("childPopups",t)};U.blStack=[];U.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};e.registerEnum("sap.ui.core.Popup.Dock",U.Dock);U.prototype.touchEnabled=t.support.touch&&(t.browser.safari||!t.system.combi);U.prototype.preventBrowserFocus=t.support.touch&&!t.system.combi;var M=s.extend("sap.ui.core.Popup.Layer",{constructor:function(){s.call(this);var t=this.getDomString();this._$Ref=jQuery(t).appendTo(d.getDomRef())}});M.prototype.init=function(t,e){this._$Ref.css({visibility:"visible","z-index":e});this.update(t,e);this._$Ref.insertAfter(t).show()};M.prototype.update=function(t,e){if(t.length){var i=t.rect();this._$Ref.css({left:i.left,top:i.top});if(t.css("right")!="auto"&&t.css("right")!="inherit"){this._$Ref.css({right:t.css("right"),width:"auto"})}else{this._$Ref.css({width:i.width,right:"auto"})}if(t.css("bottom")!="auto"&&t.css("bottom")!="inherit"){this._$Ref.css({bottom:t.css("bottom"),height:"auto"})}else{this._$Ref.css({height:i.height,bottom:"auto"})}if(typeof e==="number"){this._$Ref.css("z-index",e)}}};M.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(d.getDomRef())}};M.prototype.getDomString=function(){m.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return""};var $=M.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){M.apply(this)}});$.prototype.getDomString=function(){return'<div class="sapUiPopupShield" id="sap-ui-shieldlayer-'+v()+'"></div>'};U.prototype.oShieldLayerPool=new n($);(function(){var t=0;var e=Math.pow(2,32)-1;U.setInitialZIndex=function(i){if(i>=e){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER")}t=Math.max(i,this.getLastZIndex())};U.getLastZIndex=function(){return t};U.prototype.getLastZIndex=function(){return U.getLastZIndex()};U.getNextZIndex=function(){t+=10;if(t>=e){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER")}return t};U.prototype.getNextZIndex=function(){return U.getNextZIndex()}})();var H=function(t,e){if(!t&&e||t&&!e){return false}if(!t&&!e){return true}var i=3;var o=Math.abs(t.left-e.left);var s=Math.abs(t.top-e.top);var n=Math.abs(t.width-e.width);var r=Math.abs(t.height-e.height);if(o>i||s>i||n>i||r>i){return false}return true};U.prototype.open=function(t,e,i,o,s,n,l,u){_(this.oContent,"Popup content must have been set by now");if(this.eOpenState!=L.CLOSED){return}if(typeof t=="string"){u=l;l=n;n=s;s=o;o=i;i=e;e=t;t=-1}if(typeof l==="boolean"||typeof l==="function"||l===U.CLOSE_ON_SCROLL){u=l;l=undefined}if(t===undefined){t=-1}_(t===-1||typeof t==="number"&&t%1==0,"iDuration must be an integer (or omitted)");_(e===undefined||typeof e==="string","my must be a string or empty");_(i===undefined||typeof i==="string","at must be a string or empty");_(!o||typeof o==="object"||typeof o==="function","of must be empty or an object");_(!s||typeof s==="string","offset must be empty or a string");_(!n||w.isValid(n),"collision must be empty or of type sap.ui.core.Collision");_(!l||l===window||typeof l==="string"||l instanceof a||l instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");_(!u||typeof u==="boolean"||typeof u==="function"||u===U.CLOSE_ON_SCROLL,"followOf must be either empty or a boolean");this.eOpenState=L.OPENING;var f=D(),h;this._bContentAddedToStatic=false;this._bUIAreaPatched=false;if(this.oContent instanceof r){if(!this.oContent.getParent()){f.addContent(this.oContent,true);this._bContentAddedToStatic=true}else if(!this.oContent.getUIArea()){this.oContent.getUIArea=function(){return f};this._bUIAreaPatched=true}h=this.oContent.getUIArea();if(U._bEnableUIAreaCheck&&h.getRootNode().id!==f.getRootNode().id){m.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!")}}this._oPreviousFocus=U.getCurrentFocusInfo();if(this.isInPopup(o)||this.isInPopup(this._oPosition.of)){var p=this.getParentPopupId(o)||this.getParentPopupId(this._oPosition.of);var c="";var b=this.getContent();if(b instanceof a){c=b.getId()}else if(typeof b==="object"){c=b.id}this.addChildToPopup(p,c);this.addChildToPopup(p,this._popupUID)}var g=this._$(true);var v="fast";if(t===0||t>0){v=t}else if(this._durations.open===0||this._durations.open>0){v=this._durations.open}var y;if(e||i||o||s||n||l){y=this._createPosition(e,i,o,s,n,l);this._oPosition=y}else{y=this._oPosition;if(!this._bOwnWithin&&F){this._oPosition.within=F}}if(!y.of){y.of=this._oPosition.of||document}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var C=d.getDomRef();g.css({position:"absolute",visibility:"hidden"});if(!(g[0].parentNode==C)){g.appendTo(C)}g.css("z-index",this._iZIndex);m.debug("position popup content "+g.attr("id")+" at "+JSON.stringify(y.at));this._applyPosition(y);if(u!==undefined){this.setFollowOf(u)}g.toggleClass("sapUiShd",this._bShadow);var E=g[0];if(E){E.style.display="none";E.style.visibility="visible"}var S=v==0;this._duringOpen(!S);if(S){this._opened()}else if(this._animations.open){this._animations.open.call(null,g,v,this._opened.bind(this))}else{g.fadeIn(v,this._opened.bind(this))}};U.prototype._getDomRefToFocus=function(){var t=this._$(false,true),e,i;if(this._shouldGetFocusAfterOpen()){if(this._sInitialFocusId){i=a.getElementById(this._sInitialFocusId);if(i){e=i.getFocusDomRef()}e=e||window.document.getElementById(this._sInitialFocusId)}e=e||t.firstFocusableDomRef()}return e};U.prototype._opened=function(){if(this.eOpenState!==L.OPENING){return}this.bOpen=true;var t=this._$(false,true);if(t[0]&&t[0].style){t[0].style.display="block"}if(this._shouldGetFocusAfterOpen()){var e=this._getDomRefToFocus();if(e){e.focus()}var i=this._getOfDom(this._oLastPosition.of);var o=jQuery(i).rect();if(this._oLastOfRect&&o&&!H(this._oLastOfRect,o)){this._applyPosition(this._oLastPosition)}}this.eOpenState=L.OPEN;if(this.getFollowOf()){U.DockTrigger.addListener(U.checkDocking,this)}this.fireOpened()};U.prototype._duringOpen=function(t){var e=this._$(false,true),i=d.getDomRef(),o=document.getElementById(i.id+"-firstfe");U._clearSelection();this._setupUserSelection();if(P()){if(this._oTopShieldLayer){clearTimeout(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject(e,this._iZIndex+1)}this._iTopShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null}.bind(this),500)}if(this._bModal){this._showBlockLayer()}if(!this.touchEnabled&&t&&o&&this._shouldGetFocusAfterOpen()&&!this.isInPopup(document.activeElement)&&this._getDomRefToFocus()!==document.activeElement){o.focus({preventScroll:true})}if(this.oContent instanceof a){this.oContent.addDelegate(this)}this.bOpen=true;this._activateFocusHandle();this._$(false,true).on("keydown",this._F6NavigationHandler)};U.prototype._shouldGetFocusAfterOpen=function(){return this._bModal||this._bAutoClose||this._sInitialFocusId};U.prototype._contains=function(t){var e=this._$().get(0);if(!e){return false}var i=e.contains(t);var o;if(!i){o=this.getChildPopups();i=o.some(function(e){var i=e?window.document.getElementById(e):null;var o=i&&i.contains(t);if(!o){var s="sap.ui.core.Popup.contains-"+e;var n={domRef:t};R.publish("sap.ui",s,n);o=n.contains}return o})}if(!i){G.forEach(function(e){i=i||jQuery(t).closest(e).length>0})}return i};U.prototype._containsEventBusWrapper=function(t,e,i){i.contains=this._contains(i.domRef)};U.prototype.onFocusEvent=function(e){var i=jQuery.event.fix(e);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){i=jQuery.event.fix(arguments[2])}var o=i.type=="focus"||i.type=="activate"?"focus":"blur";var s=false;if(o=="focus"){var n=this._$().get(0);if(n){s=this._contains(i.target);m.debug("focus event on "+i.target.id+", contains: "+s);if(this._bModal&&!s){var r=U.blStack.length>0&&U.blStack[U.blStack.length-1].popup===this;if(r){if(t.system.desktop||jQuery(i.target).is(":input")){if(this.oLastBlurredElement){setTimeout(function(){if(this.oLastBlurredElement){this.oLastBlurredElement.focus()}}.bind(this),0)}else{n.focus()}}}}else if(this._bAutoClose&&s&&this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null}}}else if(o=="blur"){m.debug("blur event on "+i.target.id);if(this._bModal){this.oLastBlurredElement=i.target}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(i.target===document.activeElement){return}var a=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=setTimeout(function(){this.close(a,"autocloseBlur");var t=this._oLastPosition&&this._oLastPosition.of;if(t){var e=this.getParentPopupId(t);if(e){var o="sap.ui.core.Popup.onFocusEvent-"+e;R.publish("sap.ui",o,i)}}}.bind(this),a)}}}};U.prototype.setInitialFocusId=function(t){_(!t||typeof t==="string","sId must be a string or empty");this._sInitialFocusId=t};U.prototype.close=function(t){if(U._autoCloseDebug){return}if(this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null}_(t===undefined||typeof t==="number"&&t%1==0,"iDuration must be empty or an integer");if(this.eOpenState==L.CLOSED||this.eOpenState==L.CLOSING){return}var e="fast";if(t===0||t>0){e=t}else if(this._durations.close===0||this._durations.close>0){e=this._durations.close}this.eOpenState=L.CLOSING;if(this.getFollowOf()){U.DockTrigger.removeListener(U.checkDocking,this)}if(this.oContent){if(this._bContentAddedToStatic){R.publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var i=d.getUIArea();i.removeContent(i.indexOfContent(this.oContent),true)}else if(this._bUIAreaPatched){delete this.oContent.getUIArea}}this._bContentAddedToStatic=false;this._bUIAreaPatched=false;this._sTimeoutId=null;this._deactivateFocusHandle();this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.oContent instanceof a){this.oContent.removeDelegate(this)}var o=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents()}if(P()){if(this._oBottomShieldLayer){clearTimeout(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject(o,this._iZIndex-3)}this._iBottomShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null}.bind(this),500)}if(this.isInPopup(this._oLastPosition.of)){var s=this.getParentPopupId(this._oLastPosition.of);var n="";var r=this.getContent();if(r instanceof a){n=r.getId()}else if(typeof r==="object"){n=r.id}this.removeChildFromPopup(s,n);this.removeChildFromPopup(s,this._popupUID)}if(this._bModal&&this.preventBrowserFocus){o.one("mousedown",function(t){t.preventDefault()})}this._duringClose();if(e==0){this._closed()}else if(this._animations.close){this._animations.close.call(null,o,e,this._closed.bind(this))}else{o.fadeOut(e,this._closed.bind(this))}};U.prototype._closed=function(){var t=this._$(false,true);if(this._bModal){this._hideBlockLayer()}U._clearSelection();this._restoreUserSelection();if(t.length){var e=t.get(0);if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right=""}t=this._$(false,true);e=t.length?t[0]:null;if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right=""}}if(this._bModal){U.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null}this.bOpen=false;this.eOpenState=L.CLOSED;var i=this.getChildPopups();for(var o=0,s=i.length;o<s;o++){this.closePopup(i[o])}this.fireClosed()};U.prototype._duringClose=function(){if(this._resizeListenerId){p.deregister(this._resizeListenerId);this._resizeListenerId=null}};U.getCurrentFocusInfo=function(){var t=null;var e=a.closestTo(document.activeElement);if(e){t={sFocusId:e.getId(),oFocusInfo:e.getFocusInfo()}}else{t={sFocusId:document.activeElement.id,oFocusedElement:document.activeElement,oFocusInfo:{}}}if(t){t.popup=this}return t};U.applyFocusInfo=function(t){var e={preventScroll:true};if(t){var i=a.getElementById(t.sFocusId);if(i){i.applyFocusInfo(Object.assign(e,t.oFocusInfo))}else{var o=(t.sFocusId?window.document.getElementById(t.sFocusId):null)||t.oFocusedElement;if(o){o.focus(e)}}}};U.prototype.setContent=function(t){_(typeof t==="object","oContent must be an object");this.oContent=t;return this};U.prototype.getContent=function(){return this.oContent};U.prototype.setPosition=function(t,e,i,o,s,n){_(typeof t==="string","my must be a string");_(typeof e==="string"||typeof e==="object"&&typeof e.left==="number"&&typeof e.top==="number","my must be a string or an object with 'left' and 'top' properties");_(!i||typeof i==="object"||typeof i==="function","of must be empty or an object");_(!o||typeof o==="string","offset must be empty or a string");_(!s||w.isValid(s),"collision must be empty or of type sap.ui.core.Collision");_(!n||n===window||typeof n==="string"||n instanceof a||n instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");this._oPosition=this._createPosition(t,e,i,o,s,n);if(this.eOpenState!=L.CLOSED){this._applyPosition(this._oPosition)}return this};U.prototype._createPosition=function(t,e,i,o,s,n){var r=false;if(t&&(t.indexOf("+")>=0||t.indexOf("-")>=0)){r=true;if(o&&o!="0 0"){m.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition")}o=null}var a=y({},this._oDefaultPosition,{my:t||this._oDefaultPosition.my,at:e||this._oDefaultPosition.at,of:i,offset:o,collision:s});if(n||F){a.within=n||F}this._bOwnWithin=!!n;if(!jQuery.ui.version){if(U._bNewOffset==null){U._bNewOffset=true;var l=jQuery(document.createElement("div"));l.position({of:window,using:function(t,e){U._bNewOffset=e!==undefined}})}}var u=[];var f=[];if(U._bNewOffset||g(jQuery.ui.version).compareTo("1.8.23")>0){if(o&&o!="0 0"){u=a.my.split(" ");f=o.split(" ");var h=[parseInt(f[0])<0?"":"+",parseInt(f[1])<0?"":"+"];a.my=u[0]+h[0]+f[0]+" "+u[1]+h[1]+f[1];a.offset=null}}else if(r){u=a.my.split(" ");f=["",""];var p=u[0].indexOf("+");if(p<0){p=u[0].indexOf("-")}if(p>=0){f[0]=u[0].slice(p);u[0]=u[0].slice(0,p)}p=u[1].indexOf("+");if(p<0){p=u[1].indexOf("-")}if(p>=0){f[1]=u[1].slice(p);u[1]=u[1].slice(0,p)}a.my=u[0]+" "+u[1];a.offset=f[0]+" "+f[1]}return a};U.prototype._getPositionOffset=function(){var t=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var e=this._oPosition.my.split(" ");var i=e[0].indexOf("+");if(i<0){i=e[0].indexOf("-")}if(i>=0){t[0]=e[0].slice(i)}i=e[1].indexOf("+");if(i<0){i=e[1].indexOf("-")}if(i>=0){t[1]=e[1].slice(i)}}else if(this._oPosition.offset){t=this._oPosition.offset.split(" ")}return t};U.prototype._applyPosition=function(t){var e=b.getRTL();var i=this._$();if(i.length){var o=t.at;var s=i.get(0);if(typeof o==="string"){s.style.display="block";s.style.left="";s.style.right="";i.position(this._resolveReference(this._convertPositionRTL(t,e)));this._fixPositioning(t,e)}else if(I.isValid(o.left)&&I.isValid(o.top)){i.css({left:o.left,top:o.top})}else if(I.isValid(o.right)&&I.isValid(o.top)){i.css({right:o.right,top:o.top})}else if(typeof o.left==="number"&&typeof o.top==="number"){var n=i[0];if(n&&n.style.right){var r=i[0].getBoundingClientRect().width;i.css({right:document.documentElement.clientWidth-(o.left+r)+"px",top:o.top+"px"})}else{i.css({left:o.left+"px",top:o.top+"px"})}}this._oLastPosition=t;this._oLastOfRect=this._calcOfRect(t.of)}};U.prototype._calcOfRect=function(t){var e=this._getOfDom(t);if(e){return jQuery(e).rect()}return null};U.prototype._getOfDom=function(t){if(t instanceof jQuery.Event){return null}var e;if(typeof t==="string"){e=jQuery(document.getElementById(t))}else if(t instanceof jQuery){e=t}else{e=jQuery(t instanceof a?t.getDomRef():t)}return e[0]};U.prototype._convertPositionRTL=function(t,e){var i=Object.assign({},t);if(e){var o=false;if(i.my&&(i.my.indexOf("+")>=0||i.my.indexOf("-")>=0)){o=true}if((i.offset||o)&&(i.my.indexOf("begin")>-1||i.my.indexOf("end")>-1)&&(i.at.indexOf("begin")>-1||i.at.indexOf("end")>-1)){if(o){var s=i.my.split(" ");if(s.length==2){i.my="";if(s[0]){if(s[0].indexOf("begin")>-1||s[0].indexOf("end")>-1){if(s[0].indexOf("+")>-1){s[0]=s[0].replace("+","-")}else if(s[0].indexOf("-")>-1){s[0]=s[0].replace("-","+")}}i.my=s[0]}if(s[1]){if(s[1].indexOf("begin")>-1||s[1].indexOf("end")>-1){if(s[1].indexOf("+")>-1){s[1]=s[1].replace("+","-")}else if(s[1].indexOf("-")>-1){s[1]=s[1].replace("-","+")}}if(s[0]){i.my=i.my+" "}i.my=i.my+s[1]}}}else{i.offset=this._mirrorOffset(i.offset)}}i.my=i.my.replace("begin","right").replace("end","left");i.at=i.at.replace("begin","right").replace("end","left")}else{i.my=i.my.replace("end","right").replace("begin","left");i.at=i.at.replace("end","right").replace("begin","left")}return i};U.prototype._mirrorOffset=function(t){var e=String(t).trim().split(/\s/);var i=parseInt(e[0]);return-i+" "+e[e.length-1]};U.prototype._fixPositioning=function(t,e){var i=t.my;if(typeof i==="string"){if(U._isPositionFixingNeeded(i,e)){var o=this._$();var s=jQuery(window).width()-o[0].getBoundingClientRect().width-o.offset().left;o.css({right:s+"px",left:""})}}};U._isPositionFixingNeeded=function(t,e){return e&&(t.indexOf("right")>-1||t.indexOf("begin")>-1||t.indexOf("center")>-1)||!e&&(t.indexOf("right")>-1||t.indexOf("end")>-1)};U.prototype._resolveReference=function(t){var e,i=["of","within"];i.forEach(function(i){if(t[i]instanceof a){e=e||{};e[i]=t[i].getDomRef()}});return e?Object.assign({},t,e):t};U.prototype.setShadow=function(t){_(typeof t==="boolean","bShowShadow must be boolean");this._bShadow=t;if(this.eOpenState!=L.CLOSED){this._$().toggleClass("sapUiShd",t)}return this};U.prototype.setModal=function(t,e){_(typeof t==="boolean","bModal must be boolean");_(!e||typeof e==="string","sModalCSSClass must be empty or a string");var i=this._bModal;this._bModal=t;this._sModalCSSClass=e;if(this.isOpen()){if(i!==t){U._clearSelection();if(t){this._setupUserSelection();this._showBlockLayer()}else{this._hideBlockLayer();this._restoreUserSelection()}if(this.touchEnabled&&this._bAutoClose){if(!t){jQuery(document).on("touchstart mousedown",this._fAutoCloseHandler)}else{jQuery(document).off("touchstart mousedown",this._fAutoCloseHandler)}}}}return this};U.prototype.getModal=function(){return this._bModal};U.prototype.setNavigationMode=function(t){if(t!="NONE"&&t!="DOCK"&&t!="SCOPE"){this._sF6NavMode="NONE"}this._sF6NavMode=t};U.prototype.setAutoClose=function(t){_(typeof t==="boolean","bAutoClose must be boolean");if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==t){if(!this._bModal){if(t){jQuery(document).on("touchstart mousedown",this._fAutoCloseHandler)}else{jQuery(document).off("touchstart mousedown",this._fAutoCloseHandler)}}}this._bAutoClose=t;return this};U.prototype.setExtraContent=function(t){_(Array.isArray(t),"Extra popup content must be an array which contains either sap.ui.core.Element, DOM Element or an ID");if(!this._aExtraContent){this._aExtraContent=[]}var e=function(t){return{onBeforeRendering:function(){var e=t.getDomRef();if(e&&this.isOpen()){e.removeEventListener("blur",this.fnEventHandler,true)}},onAfterRendering:function(){var e=t.getDomRef();if(e&&this.isOpen()){e.addEventListener("blur",this.fnEventHandler,true)}}}};var i,o,s,n;for(var r=0,l=t.length;r<l;r++){o=t[r];if(o instanceof a){i=o.getId()}else if(typeof o==="object"){i=o.id}else if(typeof o==="string"){i=o}if(this.getChildPopups().indexOf(i)===-1){this.addChildPopup(i);n={id:i};if(o instanceof a){s=e(o);o.addEventDelegate(s,this);n.delegate=s}this._aExtraContent.push(n)}}return this};U.prototype.setAutoCloseAreas=U.prototype.setExtraContent;U.prototype.setAnimations=function(t,e){_(t===null||typeof t==="function","fnOpen must be a function");_(e===null||typeof e==="function","fnClose must be a function");if(t&&typeof t=="function"){this._animations.open=t}if(e&&typeof e=="function"){this._animations.close=e}return this};U.prototype.setDurations=function(t,e){_(t===null||typeof t==="number"&&t%1==0,"iOpenDuration must be null or an integer");_(!e||typeof e==="number"&&e%1==0,"iOpenDuration must be undefined or an integer");if(t>0||t===0){this._durations.open=t}if(e>0||e===0){this._durations.close=e}return this};U.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";U.prototype._fnCloseOnScroll=function(t){this.close()};U.prototype.setFollowOf=function(t){U.DockTrigger.removeListener(U.checkDocking,this);var e=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof t==="function"){this._followOfHandler=t;e=true}else if(typeof t==="boolean"){e=t}else if(t===U.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;e=true}else{this._bFollowOf=false;if(t!==null){m.error("Trying to set an invalid type to 'followOf: "+t)}}if(e&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of)}if(this._bFollowOf&&this.getOpenState()===L.OPEN){U.DockTrigger.addListener(U.checkDocking,this)}};U.prototype.getAutoClose=function(){return this._bAutoClose};U.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof this._followOfHandler==="function"?this._followOfHandler:true}return false};U.prototype.isOpen=function(){return this.bOpen};U.prototype.getOpenState=function(){return this.eOpenState};U.prototype.destroy=function(){if(this._resizeListenerId){p.deregister(this._resizeListenerId);this._resizeListenerId=null}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null)}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents()}if(this._iTopShieldRemoveTimer){clearTimeout(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null}if(this._iBottomShieldRemoveTimer){clearTimeout(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null}if(this._aExtraContent){var t;this._aExtraContent.forEach(function(e){if(e.delegate){t=a.closestTo(document.getElementById(e.id));if(t){t.removeEventDelegate(e.delegate)}}})}o.prototype.destroy.apply(this,arguments)};U.prototype.exit=function(){delete this._mEvents};U.prototype._addFocusEventListeners=function(){if(!this.fnEventHandler){this.fnEventHandler=this.onFocusEvent.bind(this)}var t=this._$();var e=this.getChildPopups();var i={};var o=0,s=0;if(t.length){document.addEventListener("focus",this.fnEventHandler,true);t.get(0).addEventListener("blur",this.fnEventHandler,true);for(o=0,s=e.length;o<s;o++){i=e[o]?window.document.getElementById(e[o]):null;if(i){i.addEventListener("blur",this.fnEventHandler,true)}}}};U.prototype._removeFocusEventListeners=function(){var t=this._$(false,true);if(!t.length){return}var e=this.getChildPopups();var i={};var o=0,s=0;document.removeEventListener("focus",this.fnEventHandler,true);t.get(0).removeEventListener("blur",this.fnEventHandler,true);for(o=0,s=e.length;o<s;o++){i=e[o]?window.document.getElementById(e[o]):null;if(i){i.removeEventListener("blur",this.fnEventHandler,true)}this.closePopup(e[o])}this.fnEventHandler=null};U.prototype._activateFocusHandle=function(){if(this._bModal||this._bAutoClose){this._addFocusEventListeners()}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){jQuery(document).on("touchstart mousedown",this._fAutoCloseHandler)}};U.prototype._deactivateFocusHandle=function(){if(this.fnEventHandler){this._removeFocusEventListeners()}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){jQuery(document).off("touchstart mousedown",this._fAutoCloseHandler)}};U.prototype._registerEventBusEvents=function(){var t=this;C(t._mEvents,function(e,i){R.subscribe("sap.ui",e,i,t)});this._bEventBusEventsRegistered=true};U.prototype._unregisterEventBusEvents=function(){var t=this;C(t._mEvents,function(e,i){R.unsubscribe("sap.ui",e,i,t)});delete this._bEventBusEventsRegistered};U.prototype._addFocusableArea=function(t,e,i){if(this.getChildPopups().indexOf(i.id)===-1){this.addChildPopup(i.id)}};U.prototype._removeFocusableArea=function(t,e,i){this.removeChildPopup(i.id)};U.prototype._closePopup=function(t,e,i){this.close(typeof this._durations.close==="string"?0:this._durations.close)};U.prototype._setIdentity=function(t){if(typeof t==="object"){t.attr("data-sap-ui-popup",this._popupUID)}else{m.warning("Incorrect DomRef-type for 'setIdentity': "+t,this);return}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents()}};U.prototype._$=function(t,e){var i;if(this.oContent instanceof r){i=this.oContent.$();if(t||i.length===0&&!e){m.info("Rendering of popup content: "+this.oContent.getId());if(i.length>0){h.preserveContent(i[0],true,false)}(new h).render(this.oContent,d.getDomRef());i=this.oContent.$()}}else if(this.oContent instanceof a){i=this.oContent.$()}else{i=jQuery(this.oContent)}this._setIdentity(i);return i};function j(t){if(U._blockLayerStateProvider){U._blockLayerStateProvider.fireEvent("blockLayerStateChange",t)}}U.attachBlockLayerStateChange=function(t,e,i){if(!U._blockLayerStateProvider){U._blockLayerStateProvider=new O}U._blockLayerStateProvider.attachEvent("blockLayerStateChange",t,e,i)};U.detachBlockLayerStateChange=function(t,e){if(U._blockLayerStateProvider){U._blockLayerStateProvider.detachEvent("blockLayerStateChange",t,e)}};function Z(t,e){if(e===window){B(t);document.documentElement.classList.add("sapUiBLyBack")}else{N(t,e);e.classList.add("sapUiBLyBack");k.observe(e)}}function z(t){if(t===window){document.documentElement.classList.remove("sapUiBLyBack")}else{t.classList.remove("sapUiBLyBack");k.unobserve(t)}}U.prototype._extendFocusInfo=function(t,e){var o=false,s="sap.ui.core.Popup.extendFocusInfo-",n;if(t instanceof i){n={info:e.info,element:t.getParameter("domRef")}}else{n=t}var r=this.getContent();var l=r instanceof a?r.getDomRef():r;if(l&&l.contains(n.element)){n.info.preventScroll=true;o=true}else{var u=this.getChildPopups();o=u.some(function(t){var e=s+t;R.publish("sap.ui",e,n);return n.extended})}return o};U.prototype._extendFocusInfoEventBusWrapper=function(t,e,i){i.contains=this._extendFocusInfo(i)};U.prototype._showBlockLayer=function(){var t=jQuery("#sap-ui-blocklayer-popup"),e="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:""),i;if(t.length===0){t=jQuery('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+e+'"></div>');t.appendTo(d.getDomRef())}else{t.removeClass().addClass(e)}var o=U.blStack[U.blStack.length-1];if(o){i=T(o.popup._oLastPosition.within);z(i)}i=T(this._oLastPosition.within);Z(t,i);U.blStack.push({zIndex:this._iZIndex-2,popup:this});t.css({"z-index":this._iZIndex-2,visibility:"visible"}).show();if(!this.isInPopup(this._oLastPosition.of)){this._bFocusExtenderAdded=true;u.addFocusInfoExtender(this._extendFocusInfo,this)}if(U.blStack.length===1){j({visible:true,zIndex:U.blStack[0].zIndex})}};U.prototype._hideBlockLayer=function(){var t=jQuery("#sap-ui-blocklayer-popup"),e=t[0],i=this,o,s;s=T(this._oLastPosition.within);z(s);if(t.length){if(this._bFocusExtenderAdded){this._bFocusExtenderAdded=false;u.removeFocusInfoExtender(this._extendFocusInfo,this)}if(U.blStack.length>1){U.blStack=U.blStack.filter(function(t){return t.popup!==i});o=U.blStack[U.blStack.length-1];e.style.zIndex=o.zIndex;e.style.visibility="visible";e.style.display="block";s=T(o.popup._oLastPosition.within);Z(t,s)}else{o=U.blStack.pop();e.style.visibility="hidden";e.style.display="none";j({visible:false,zIndex:o.zIndex})}}};U.prototype._isFocusInsidePopup=function(){var t=this._$(false).get(0);if(t&&t.contains(document.activeElement)){return true}return false};U.DockTrigger=f;U.checkDocking=function(){if(this.getOpenState()===L.OPEN){var t=this._getOfDom(this._oLastPosition.of),e;if(t){if(t===window||t===window.document||document.documentElement.contains(t)){e=jQuery(t).rect()}else if(t.id){var i=window.document.getElementById(t.id);var o=jQuery(i).rect();if(o&&!H(e,o)){e=o;this._oLastPosition.of=i}}}if(!e){this.close();return}else if(e.left===0&&e.top===0&&e.height===0&&e.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=window.document.getElementById(this._oLastPosition.of.id);t=this._getOfDom(this._oLastPosition.of);e=jQuery(t).rect();if(!e){this.close();return}}if(this._oLastOfRect){if(!H(this._oLastOfRect,e)){if(this._followOfHandler){var s=E({},this._oLastPosition),n=E({},this._oLastOfRect);this._followOfHandler({lastPosition:s,lastOfRect:n,currentOfRect:e})}else{this._applyPosition(this._oLastPosition)}}}}};U.prototype.ontouchstart=function(t){this.onmousedown(t,true);this._bMousedownCalled=true};U.prototype.onmousedown=function(t,e){if(this._bMousedownCalled&&!e){this._bMousedownCalled=false;return}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return}this._increaseMyZIndex("","mousedown",t)};U.prototype._increaseMyZIndex=function(t,e,i){var o=this.getParentPopup(this._oLastPosition.of);if(i&&i.type==="mousedown"||i&&i.isFromParentPopup||o.length===0){this._iZIndex=this.getNextZIndex();var s=this._$(false,true);s.css("z-index",this._iZIndex);if(i&&!i.type||i&&i.type!="mousedown"||e==="mousedown"){var n=this.getChildPopups();for(var r=0,a=n.length;r<a;r++){this.increaseZIndex(n[r],true)}}}else if(o.length>0){var l=jQuery(o.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(l,false)}};U.prototype.onAfterRendering=function(){var t=this.getContent();var e=t instanceof a?t.$():jQuery(t);e.toggleClass("sapUiShd",this._bShadow);U._clearSelection();this._setupUserSelection();e.css("position","absolute");this._setIdentity(e);var i=e[0];var o=i.style.left;var s=i.style.right;var n=i.style.top;var r=i.style.bottom;if(!(o&&o!="auto"||s&&s!="auto"||n&&n!="auto"||r&&r!="auto")){m.debug("reposition popup content "+e.attr("id")+" at "+JSON.stringify(this._oLastPosition.at));this._applyPosition(this._oLastPosition)}e.show().css({visibility:"visible","z-index":this._iZIndex});if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners()}this._$(false,true).on("keydown",this._F6NavigationHandler)};U.prototype.onBeforeRendering=function(){if(this._resizeListenerId){p.deregister(this._resizeListenerId);this._resizeListenerId=null}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners()}this._$(false,true).off("keydown",this._F6NavigationHandler)};U.prototype.isInPopup=function(t){var e=this.getParentPopup(t);return e&&e.length>0};U.prototype.getParentPopup=function(t){var e=t?t:this;var i=jQuery(e instanceof a?e.getDomRef():e);return i.closest("[data-sap-ui-popup]")};U.prototype.getParentPopupId=function(t){var e=this.getParentPopup(t);return e.attr("data-sap-ui-popup")};U.prototype.addChildToPopup=function(t,e){var i="sap.ui.core.Popup.addFocusableContent-"+t;R.publish("sap.ui",i,{id:e})};U.prototype.removeChildFromPopup=function(t,e){var i="sap.ui.core.Popup.removeFocusableContent-"+t;R.publish("sap.ui",i,{id:e})};U.prototype.closePopup=function(t){var e="sap.ui.core.Popup.closePopup-"+t;R.publish("sap.ui",e)};U.prototype.increaseZIndex=function(t,e){var i="sap.ui.core.Popup.increaseZIndex-"+t;R.publish("sap.ui",i,{isFromParentPopup:e?e:false})};U.prototype.focusTabChain=function(t){var e=t.event.target,i=t.that.getMetadata().getName(),o;if(!t.$FocusablesContent||!t.$FocusablesFooter||!t.$FocusablesContent.length&&!t.$FocusablesFooter.length){return}if(e.id===t.firstFocusable){m.debug("First dummy focus element was focused","",i);if(t.$FocusablesFooter.length>0){m.debug("Last footer element will be focused","",i);o=t.$FocusablesFooter[t.$FocusablesFooter.length-1]}else{m.debug("Last content element will be focused","",i);o=t.$FocusablesContent[t.$FocusablesContent.length-1]}}else if(e.id===t.lastFocusable){m.debug("Last dummy focus element was focues","",i);if(t.$FocusablesContent.length>0){m.debug("First content element will be focused","",i);o=t.$FocusablesContent[0]}else{m.debug("First footer element will be focused","",i);o=t.$FocusablesFooter[0]}}if(o){setTimeout(function(){var t=a.getElementById(o.id);if(t instanceof r){m.debug("Focus will be handled by "+t.getMetadata().getName(),"",i)}else{m.debug("oFocusDomRef will be focused","",i)}if(t){t.focus()}else if(o){o.focus()}return t?t.getId():o.id},0)}};U.prototype._setupUserSelection=function(){var t=this._$(false,true);U._markAsUserSelectable(t,this._bModal||U.blStack.length>0);if(this._bModal){if(U.blStack.length>0){var e=U.blStack[U.blStack.length-1];var i=function(t){return t.popup.getId()};if(U.blStack.map(i).indexOf(this.getId())===-1){U._markAsNotUserSelectable(e.popup._$(false,true),true)}else if(e.popup.getId()!==this.getId()){U._markAsNotUserSelectable(t,true)}}else{U._markAsNotUserSelectable(jQuery("html"),true);U._markExternalContentAsUserSelectable(true)}}};U.prototype._restoreUserSelection=function(){var t=this._$(false,true);U._markAsNotUserSelectable(t,false);if(U.blStack.length>0){U._markAsUserSelectable(U.blStack[U.blStack.length-1].popup._$(false,true),true)}else{U._markAsUserSelectable(jQuery("html"),false);U._markExternalContentAsNotUserSelectable(false)}};U._clearSelection=function(){var t=document.getSelection();if(!t.isCollapsed){t.removeAllRanges()}};U._markAsUserSelectable=function(t,e){t.removeClass("sapUiNotUserSelectable");if(e){t.addClass("sapUiUserSelectable")}};U._markAsNotUserSelectable=function(t,e){t.removeClass("sapUiUserSelectable");if(e){t.addClass("sapUiNotUserSelectable")}};var G=new Set,W="[data-sap-ui-integration-popup-content]";G.add(W);U.addExternalContent=function(t,e){if(!Array.isArray(t)){t=[t]}t.forEach(Set.prototype.add.bind(G));if(e){U.markExternalContentAsSelectable()}};U.removeExternalContent=function(t,e){if(!Array.isArray(t)){t=[t]}if(e){U.markExternalContentAsNotSelectable()}t.forEach(function(t){if(t!==W){G.delete(t)}})};U.markExternalContentAsSelectable=function(){U._clearSelection();if(U.blStack.length>0){U._markExternalContentAsUserSelectable(true)}};U.markExternalContentAsNotSelectable=function(){U._clearSelection();if(U.blStack.length>0){U._markExternalContentAsNotUserSelectable(false)}};U._getExternalContent=function(){var t=[];if(G.size>0){G.forEach(function(e){var i=jQuery(e);if(i.length>0){t.push(i)}})}return t};U._markExternalContentAsUserSelectable=function(t){var e=U._getExternalContent();e.forEach(function(e){U._markAsUserSelectable(e,t)})};U._markExternalContentAsNotUserSelectable=function(t){var e=U._getExternalContent();e.forEach(function(e){U._markAsNotUserSelectable(e,t)})};U.setWithinArea=function(t){F=t};U.getWithinArea=function(){return F};U.getWithinAreaDomRef=function(){return T(F)};return U});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ScrollBar", ["sap/ui/Device","./Control","./library","./ScrollBarRenderer","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(t,e,o,i,r,s,l,jQuery,h){"use strict";var n=o.ScrollBarAction;var c=e.extend("sap.ui.core.ScrollBar",{metadata:{library:"sap.ui.core",properties:{vertical:{type:"boolean",group:"Behavior",defaultValue:true},scrollPosition:{type:"int",group:"Behavior",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},steps:{type:"int",group:"Dimension",defaultValue:null}},events:{scroll:{parameters:{action:{type:"sap.ui.core.ScrollBarAction"},forward:{type:"boolean"},newScrollPos:{type:"int"},oldScrollPos:{type:"int"}}}}},renderer:i});c.prototype.init=function(){this.ontouchstart=this.ontouchstart.bind(this);this.ontouchmove=this.ontouchmove.bind(this);this.ontouchend=this.ontouchend.bind(this);this.ontouchcancel=this.ontouchcancel.bind(this);this.onmousewheel=this.onmousewheel.bind(this);this.onscroll=this.onscroll.bind(this);this._$ScrollDomRef=null;this._iOldScrollPos=0;this._iOldStep=0;this._bScrollPosIsChecked=false;this._bRTL=h.getRTL();this._bSuppressScroll=false;this._iMaxContentDivSize=1e6;if(l.touchEventMode==="ON"){sap.ui.requireSync("sap/ui/thirdparty/zyngascroll");this._iLastTouchScrollerPosition=null;this._iTouchStepTreshold=24;this._bSkipTouchHandling=false;this._oTouchScroller=new window.Scroller(this._handleTouchScroll.bind(this),{bouncing:false})}};c.prototype.onBeforeRendering=function(){this.$("sb").off("scroll",this.onscroll)};c.prototype.onAfterRendering=function(){this._iSteps=this.getSteps();var e=this.getContentSize();this._bStepMode=!e;var o=this.getSize();if(o.endsWith("px")){o=o.substr(0,o.length-2)}else{o=this.getVertical()?this.$().height():this.$().width()}var i=null;var r=this.$("ffsize");if(t.browser.firefox){i=r.outerHeight();if(i===0){i=window.getComputedStyle(jQuery("body").get(0))["font-size"];if(i.endsWith("px")){i=i.substr(0,i.length-2)}i=parseInt(i)}}r.remove();if(t.browser.webkit){if(!document.width){i=Math.round(40/(window.outerWidth/jQuery(document).width()))}else{i=Math.round(40/(document.width/jQuery(document).width()))}}if(this.getVertical()){if(t.browser.firefox){this._iFactor=i}else if(t.browser.webkit){this._iFactor=i}else{this._iFactor=Math.floor(o*.125)}this._iFactorPage=t.browser.firefox?o-i:Math.floor(o*.875)}else{if(t.browser.firefox){this._iFactor=10;this._iFactorPage=Math.floor(o*.8)}else if(t.browser.webkit){this._iFactor=i;this._iFactorPage=Math.floor(o*.875)}else{this._iFactor=7;this._iFactorPage=o-14}}this._$ScrollDomRef=this.$("sb");if(this._bStepMode){if(this.getVertical()){var s=this._iSteps*this._iFactor;if(s>this._iMaxContentDivSize){this._iFactor=this._iFactor/(s/this._iMaxContentDivSize)}var h=this._$ScrollDomRef.height()+Math.ceil(this._iSteps*this._iFactor);this._$ScrollDomRef.find("div").height(h)}else{var h=this._$ScrollDomRef.width()+this._iSteps*this._iFactor;this._$ScrollDomRef.find("div").width(h)}}this.setCheckedScrollPosition(this.getScrollPosition()?this.getScrollPosition():0,true);this._$ScrollDomRef.on("scroll",this.onscroll);if(l.touchEventMode==="ON"){this._bSkipTouchHandling=true;var n={width:0,height:0};n[this.getVertical()?"height":"width"]=this._bStepMode?this.getSteps()*this._iTouchStepTreshold:parseInt(this.getContentSize());this._oTouchScroller.setDimensions(0,0,n.width,n.height);var c=this._$ScrollDomRef.get(0);if(c){var a=c.getBoundingClientRect();this._oTouchScroller.setPosition(a.left+c.clientLeft,a.top+c.clientTop);this._bSkipTouchHandling=false}}};c.prototype.onmousewheel=function(t){if(this.$().is(":visible")){var e=t.originalEvent;var o=e.detail?e.detail:e.wheelDelta*-1/40;var i=o>0?true:false;if(this._$ScrollDomRef[0]&&this._$ScrollDomRef[0].contains(t.target)){this._doScroll(n.MouseWheel,i)}else{this._bMouseWheel=true;var r=null;if(this._bStepMode){r=o+this._iOldStep}else{r=o*this._iFactor+this._iOldScrollPos}this.setCheckedScrollPosition(r,true)}t.preventDefault();t.stopPropagation();return false}};c.prototype.ontouchstart=function(t){var e=t.touches;var o=e[0];if(o&&o.target&&o.target.tagName.match(/input|textarea|select/i)){return}if(this._oTouchScroller){this._oTouchScroller.doTouchStart(e,t.timeStamp)}if(e.length==1){t.preventDefault()}};c.prototype.ontouchmove=function(t){if(this._oTouchScroller){this._oTouchScroller.doTouchMove(t.touches,t.timeStamp,t.scale)}};c.prototype.ontouchend=function(t){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(t.timeStamp)}};c.prototype.ontouchcancel=function(t){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(t.timeStamp)}};c.prototype.onscroll=function(e){if(this._bSuppressScroll){this._bSuppressScroll=false;e.preventDefault();e.stopPropagation();return false}var o=null;if(this._$ScrollDomRef){if(this.getVertical()){o=Math.round(this._$ScrollDomRef.scrollTop())}else{o=Math.round(this._$ScrollDomRef.scrollLeft());if(t.browser.firefox&&this._bRTL){o=Math.abs(o)}else if(t.browser.webkit&&this._bRTL){var i=this._$ScrollDomRef.get(0);o=i.scrollWidth-i.clientWidth-i.scrollLeft}}}var r=o-this._iOldScrollPos;var s=r>0?true:false;if(r<0){r=r*-1}var l=n.Drag;if(r==this._iFactor){l=n.Step}else if(r==this._iFactorPage){l=n.Page}else if(this._bMouseWheel){l=n.MouseWheel}if(this._bLargeDataScrolling&&l===n.Drag){this._eAction=l;this._bForward=s}else{this._doScroll(l,s)}e.preventDefault();e.stopPropagation();return false};c.prototype._onScrollTimeout=function(){this._scrollTimeout=undefined;this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined};c.prototype.onmouseup=function(){if(this._bLargeDataScrolling&&(this._eAction||this._bForward||this._bTouchScroll)){this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined}};c.prototype.ontouchend=c.prototype.onmouseup;c.prototype._handleTouchScroll=function(t,e,o){if(this._bSkipTouchHandling){return}var i=this.getVertical()?e:t;var r;if(this._bStepMode){r=Math.max(Math.round(i/this._iTouchStepTreshold),0)}else{r=Math.round(i)}if(this._iLastTouchScrollerPosition!==r){this._iLastTouchScrollerPosition=r;this.setCheckedScrollPosition(r,true);if(this._bLargeDataScrolling){this._bTouchScroll=true}else{this.fireScroll()}}};c.prototype.unbind=function(e){if(e){this._$OwnerDomRef=jQuery(e);if(this.getVertical()){this._$OwnerDomRef.off(t.browser.firefox?"DOMMouseScroll":"mousewheel",this.onmousewheel)}if(l.touchEventMode==="ON"){this._$OwnerDomRef.off(this._getTouchEventType("touchstart"),this.ontouchstart);this._$OwnerDomRef.off(this._getTouchEventType("touchmove"),this.ontouchmove);this._$OwnerDomRef.off(this._getTouchEventType("touchend"),this.ontouchend);this._$OwnerDomRef.off(this._getTouchEventType("touchcancel"),this.ontouchcancel)}}};c.prototype.bind=function(e){if(e){this._$OwnerDomRef=jQuery(e);if(this.getVertical()){this._$OwnerDomRef.on(t.browser.firefox?"DOMMouseScroll":"mousewheel",this.onmousewheel)}if(l.touchEventMode==="ON"){this._$OwnerDomRef.on(this._getTouchEventType("touchstart"),this.ontouchstart);this._$OwnerDomRef.on(this._getTouchEventType("touchmove"),this.ontouchmove);this._$OwnerDomRef.on(this._getTouchEventType("touchend"),this.ontouchend);this._$OwnerDomRef.on(this._getTouchEventType("touchcancel"),this.ontouchcancel)}}};c.prototype._getTouchEventType=function(t){return l.touchEventMode==="SIM"?"sap"+t:t};c.prototype.pageUp=function(){this._doScroll(n.Page,false)};c.prototype.pageDown=function(){this._doScroll(n.Page,true)};c.prototype.setScrollPosition=function(t){if(this._$ScrollDomRef){this.setCheckedScrollPosition(t,true)}else{this.setProperty("scrollPosition",t)}return this};c.prototype.setCheckedScrollPosition=function(e,o){var i=Math.max(e,0);if(this._bStepMode===undefined){this._bStepMode=!this.getContentSize()}var r=i;if(this._bStepMode){i=Math.min(i,this.getSteps());r=i*this._iFactor}i=Math.round(i);this._bSuppressScroll=!o;this.setProperty("scrollPosition",i,true);if(this.getVertical()){this._$ScrollDomRef.scrollTop(r)}else{if(t.browser.firefox&&this._bRTL){this._$ScrollDomRef.scrollLeft(-r)}else if(t.browser.webkit&&this._bRTL){var s=this._$ScrollDomRef.get(0);this._$ScrollDomRef.scrollLeft(s.scrollWidth-s.clientWidth-r)}else{this._$ScrollDomRef.scrollLeft(r)}}if(l.touchEventMode==="ON"){var h=i;if(this._bStepMode){h=Math.round(i*this._iTouchStepTreshold)}this._oTouchScroller.__scrollTop=this.getVertical()?h:0;this._oTouchScroller.__scrollLeft=this.getVertical()?0:h}};c.prototype.setContentSize=function(t){this.setProperty("contentSize",t,true);this._bStepMode=false;var e=this.$("sbcnt");if(e){if(this.getVertical()){e.height(t)}else{e.width(t)}}return this};c.prototype._doScroll=function(e,o){var i=null;if(this._$ScrollDomRef){if(this.getVertical()){i=Math.round(this._$ScrollDomRef.scrollTop())}else{i=Math.round(this._$ScrollDomRef.scrollLeft());if(t.browser.firefox&&this._bRTL){i=Math.abs(i)}else if(t.browser.webkit&&this._bRTL){var l=this._$ScrollDomRef.get(0);i=l.scrollWidth-l.clientWidth-l.scrollLeft}}}if(this._bStepMode){var h=Math.round(i/this._iFactor);var n=this._iOldStep;if(n!==h){this.setCheckedScrollPosition(h,false);s.debug("-----STEPMODE-----: New Step: "+h+" --- Old Step: "+n+" --- Scroll Pos in px: "+i+" --- Action: "+e+" --- Direction is forward: "+o);this.fireScroll({action:e,forward:o,newScrollPos:h,oldScrollPos:n});this._iOldStep=h}}else{i=Math.round(i);this.setProperty("scrollPosition",i,true);s.debug("-----PIXELMODE-----: New ScrollPos: "+i+" --- Old ScrollPos: "+this._iOldScrollPos+" --- Action: "+e+" --- Direction is forward: "+o);this.fireScroll({action:e,forward:o,newScrollPos:i,oldScrollPos:this._iOldScrollPos})}this._bSuppressScroll=false;this._iOldScrollPos=i;this._bMouseWheel=false;r.notifyScrollEvent({type:e})};c.prototype.onThemeChanged=function(){this.rerender()};c.prototype.getNativeScrollPosition=function(){if(this._$ScrollDomRef){if(this.getVertical()){return Math.round(this._$ScrollDomRef.scrollTop())}else{return Math.round(this._$ScrollDomRef.scrollLeft())}}return 0};c.prototype.setNativeScrollPosition=function(t){var e=Math.round(t);if(this._$ScrollDomRef){if(this.getVertical()){this._$ScrollDomRef.scrollTop(e)}else{this._$ScrollDomRef.scrollLeft(e)}}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ScrollBarRenderer", ["sap/ui/Device","sap/ui/dom/getScrollbarSize","sap/ui/core/Configuration"],function(e,t,i){"use strict";var s={apiVersion:2};s.render=function(s,l){var o=i.getRTL();s.openStart("div",l);s.class("sapUiScrollBar");var n;if(e.support.touch){n="sapUiScrollBarTouch";s.class(n)}var r=l.getVertical();var d=l.getSize();var p=l.getContentSize();var a=t(n);var h=a.width;var v=a.height;if(r){s.style("overflow","hidden");s.style("width",h+"px");s.style("height",d);s.openEnd();s.openStart("div",l.getId()+"-sb");s.style("width",h*2+"px");s.style("height","100%");s.style("overflow-y","scroll");s.style("overflow-x","hidden");if(o){s.style("margin-right","-"+h+"px")}else{s.style("margin-left","-"+h+"px")}s.openEnd();s.openStart("div",l.getId()+"-sbcnt");s.style("width",h+"px");s.style("height",p);s.openEnd();s.close("div");s.close("div");s.openStart("div");s.openEnd();s.openStart("span",l.getId()+"-ffsize");s.style("position","absolute");s.style("top","-9000px");s.style("left","-9000px");s.style("visibility","hidden");s.style("line-height","normal");s.openEnd();s.text("FF Size");s.close("span");s.close("div")}else{s.style("overflow","hidden");s.style("height",v+"px");s.style("width",d);s.openEnd();s.openStart("div",l.getId()+"-sb");s.style("height",v*2+"px");s.style("margin-top","-"+v+"px");s.style("overflow-x","scroll");s.style("overflow-y","hidden");s.openEnd();s.openStart("div",l.getId()+"-sbcnt");s.style("height",v+"px");s.style("width",p);s.openEnd();s.close("div");s.close("div")}s.close("div")};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/SeparatorItem", ["./Item","./library"],function(e){"use strict";var r=e.extend("sap.ui.core.SeparatorItem",{metadata:{library:"sap.ui.core"}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Shortcut", ["sap/ui/core/StaticArea","sap/ui/core/util/ShortcutHelper","sap/base/assert"],function(t,e,r){"use strict";var o={register:function(r,o,i){if(!r){throw new Error("Shortcut.register: oScopeControl must be given.")}if(typeof i!=="function"){throw new Error("Shortcut.register: a function fnCallback must be given.")}var n=e.getNormalizedShortcutSpec(o);e.validateKeyCombination(n);var u=e.findShortcut(r,n);if(u){throw new Error("Same shortcut is already registered on this element")}function a(){var e=document.activeElement,r=document.createElement("span"),o=t.getDomRef(),n=arguments;r.setAttribute("tabindex",0);r.setAttribute("id","sap-ui-shortcut-focus");r.style.position="absolute";r.style.top="50%";r.style.bottom="50%";r.style.left="50%";r.style.right="50%";o.appendChild(r);setTimeout(function(){r.focus();setTimeout(function(){e.focus();o.removeChild(r);i.apply(null,n)})})}var c={};c["onkeydown"]=e.handleKeydown.bind(null,n,o,a);r.addEventDelegate(c);var s=r.data("sap.ui.core.Shortcut");if(!s){s=[];r.data("sap.ui.core.Shortcut",s)}s.push({shortcutSpec:n,platformIndependentShortcutString:e.getNormalizedShortcutString(n),delegate:c})},isRegistered:function(t,o){r(t,"Shortcut.isRegistered: oScopeControl must be given.");var i=e.getNormalizedShortcutSpec(o);return!!e.findShortcut(t,i)},unregister:function(t,o){r(t,"Shortcut.unregister: oScopeControl must be given.");var i=e.getNormalizedShortcutSpec(o);var n=e.findShortcut(t,i);if(n){t.removeEventDelegate(n.delegate);var u=t.data("sap.ui.core.Shortcut");var a=u.indexOf(n);u.splice(a,1);return true}return false}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ShortcutHint", ["sap/base/Log","sap/ui/core/CommandExecution","sap/ui/core/Lib"],function(t,o,e){"use strict";var n=function(t,o){this.oControl=t;this.oConfig=o};n.prototype._getShortcutText=function(){var t;if(this.oConfig.commandName){t=this._getShortcutHintFromCommandExecution(this.oControl,this.oConfig.commandName)}else if(this.oConfig.message){t=this.oConfig.message}else if(this.oConfig.messageBundleKey){t=this._getShortcutHintFromMessageBundle(this.oControl,this.oConfig.messageBundleKey)}return t};n.prototype._getShortcutHintFromCommandExecution=function(e,n){try{return o.find(e,n)._getCommandInfo().shortcut}catch(o){t.error("Error on retrieving command shortcut. Command "+n+" was not found!")}};n.prototype._getShortcutHintFromMessageBundle=function(t,o){var n=e.getResourceBundleFor(t.getMetadata().getLibraryName());return n.getText(o)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ShortcutHintsMixin", ["sap/ui/base/EventProvider","./Element","./ShortcutHint","./Popup","./InvisibleText","sap/ui/events/checkMouseEnterOrLeave","sap/ui/Device"],function(t,e,i,n,o,r,s){"use strict";var u=function(t){this.sControlId=t.getId();this._hintConfigs=[]};u.init=function(t){t._shortcutHintsMixin=new u(t)};u.addConfig=function(t,e,i){if(s.system.phone){return}if(/sap-ui-xx-noshortcuthints=true/.test(document.location.search)){return}var n=t._shortcutHintsMixin;if(!n){u.init(t);n=t._shortcutHintsMixin}n._hintConfigs.push(e);n.initHint(e,i)};u.hideAll=function(){var t;for(var i in f.mControls){t=e.getElementById(i);if(t){t._shortcutHintsMixin.hideShortcutHint()}}};u.isDOMIDRegistered=function(t){return f.mDOMNodes[t]&&!!f.mDOMNodes[t].length};u.isControlRegistered=function(t){return!!f.mControls[t]};u.prototype._attachToEvents=function(){var t;if(!u.isControlRegistered(this.sControlId)){t=e.getElementById(this.sControlId);t.addEventDelegate(c,this)}};u.prototype.register=function(t,n,o){this._attachToEvents();if(!u.isControlRegistered(this.sControlId)){var r=e.getElementById(this.sControlId);r._originalExit=r.exit;r.exit=function(){if(r._originalExit){r._originalExit.apply(r,arguments)}this.deregister()}.bind(this)}f.mControls[this.sControlId]=true;if(!f.mDOMNodes[t]){f.mDOMNodes[t]=[]}f.mDOMNodes[t].push(new i(o,n))};u.prototype.deregister=function(){var t=this.getRegisteredShortcutInfos(),e;delete f.mControls[this.sControlId];for(e=0;e<t.length;e++){delete f.mDOMNodes[t[e].id]}};u.prototype.initHint=function(e,i){var n=this._getShortcutHintInfo(e);if(n.message){this.register(n.id,{message:n.message},i)}else if(n.messageBundleKey){this.register(n.id,{messageBundleKey:n.messageBundleKey},i)}else if(n.event){var o=t.getEventList(i)[n.event],r=[];if(o){r=o.reduce(function(t,e){if(e.fFunction&&e.fFunction._sapui_commandName){t.push(e.fFunction._sapui_commandName)}return t},[])}if(r.length){this.register(n.id,{commandName:r[0]},i)}else{i.attachEvent("EventHandlerChange",function(t){var e=t.getParameter("func");if(t.getParameter("type")==="listenerAttached"&&e&&e._sapui_commandName&&t.getParameter("EventId")===n.event){this.register(n.id,{commandName:e._sapui_commandName},i)}},this)}}};u.prototype._getShortcutHintInfos=function(){return this._hintConfigs.map(this._getShortcutHintInfo,this)};u.prototype._getShortcutHintInfo=function(t){var e;if(t.domrefid){e=t.domrefid}else if(t.domrefid_suffix){e=this.sControlId+t.domrefid_suffix}else{e=this.sControlId}return{id:e,event:t.event,position:t.position,messageBundleKey:t.messageBundleKey,message:t.message,addAccessibilityLabel:t.addAccessibilityLabel}};u.prototype.getRegisteredShortcutInfos=function(){return this._getShortcutHintInfos().filter(function(t){return u.isDOMIDRegistered(t.id)},this)};u.prototype.showShortcutHint=function(t){var e,i=t[0].position||"0 8",o=n.Dock.CenterTop,r=n.Dock.CenterBottom,s=h(),u=t[0].ref,f=d(t[0].id),c;if(!m(u)||!g(u)){return}c=this._getControlTooltips();if(c[t[0].id]){f=c[t[0].id].tooltip+" ("+f+")"}if(!s){s=l(f)}s.oContent.children[0].textContent=f;if(!s.isOpen()){s.open(1e3,o,r,u,i,"flipfit",function(t){s.oContent.style.visibility="hidden";if(e){clearTimeout(e)}e=setTimeout(function(){if(!m(u)||!g(u)){return}s.oContent.style.visibility="visible"},1e3);s._applyPosition(s._oLastPosition)})}};u.prototype.hideShortcutHint=function(){var t=h();if(t&&t.isOpen()){t.close()}};u.prototype._findShortcutOptionsForRef=function(t){var e,i=this.getRegisteredShortcutInfos(),n,o=[];for(n=0;n<i.length;n++){e=i[n];e.ref=document.getElementById(e.id);if(e.ref&&e.ref.contains(t)){o.push(e)}}return o};u.prototype._getControlTooltips=function(){var t=this.getRegisteredShortcutInfos(),i=e.getElementById(this.sControlId);return t.reduce(function(t,e){var n=i._getTitleAttribute&&i._getTitleAttribute(e.id);if(!n){n=i.getTooltip()}if(n){t[e.id]={tooltip:n}}return t},{})};u.prototype._updateShortcutHintAccLabel=function(t){var i,n,o;if(!t.addAccessibilityLabel){return}o=e.getElementById(this.sControlId);if(!o.getAriaDescribedBy){return}i=a(o);n=i.getId();i.setText(d(t.id));if(!i.getText()){o.removeAriaDescribedBy(n)}else if(o.getAriaDescribedBy().indexOf(n)===-1){o.addAriaDescribedBy(n)}};var f=Object.create(null);f.mControls={};f.mDOMNodes={};var c={onfocusin:function(t){var e=this._findShortcutOptionsForRef(t.target);if(!e.length){return}u.hideAll();this._updateShortcutHintAccLabel(e[0]);this.showShortcutHint(e)},onfocusout:function(t){var e=this._findShortcutOptionsForRef(t.target);if(!e.length){return}this.hideShortcutHint()},onmouseover:function(t){var e=this._findShortcutOptionsForRef(t.target),i;if(!e.length){return}i=e[0].ref;if(!v(i)){return}if(r(t,i)){u.hideAll();this.showShortcutHint(e)}},onmouseout:function(t){var e=this._findShortcutOptionsForRef(t.target);if(!e.length){return}if(r(t,e[0].ref)){if(e[0].ref.contains(document.activeElement)){return}this.hideShortcutHint()}},onAfterRendering:function(){var t=this.getRegisteredShortcutInfos(),e,i;for(var n=0;n<t.length;n++){i=t[n].id;e=document.getElementById(i);e.setAttribute("aria-keyshortcuts",d(i))}}};function d(t){var e=f.mDOMNodes[t];if(!e||!e.length){return}return e.map(function(t){return t._getShortcutText()}).join(", ")}function a(t){if(!t._shortcutInvisibleText){var e=t.exit;t._shortcutInvisibleText=new o;t._shortcutInvisibleText.toStatic();t.exit=function(){this._shortcutInvisibleText.destroy();e.call(this)}}return t._shortcutInvisibleText}function h(){return u._popup}function l(t){var e,i,o;i=document.createElement("span");i.classList.add("sapUiHintContainer");o=document.createElement("div");o.classList.add("sapUiHintText");o.textContent=t;i.appendChild(o);e=new n(i,false,false,false);e.setAnimations(function(t,e,i){setTimeout(i,e)},function(t,e,i){i()});u._popup=e;return e}function g(t){var e;if(!t){return false}e=t.getBoundingClientRect();return e.top>=0&&e.left>=0&&e.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&e.right<=(window.innerWidth||document.documentElement.clientWidth)}function m(t){return t.offsetWidth>0||t.offsetHeight>0||t.getClientRects().length>0}function p(t){var e=t.tabIndex;return e!=null&&e>=0&&(t.getAttribute("disabled")==null||t.getAttribute("tabindex"))}function v(t){return t.nodeType==1&&m(t)&&p(t)}return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/StashedControlSupport", ["sap/base/assert","sap/ui/core/Element"],function(t,e){"use strict";var r={},a={};r.mixInto=function(e){t(!e.prototype.unstash,"StashedControlSupport: fnClass already has method 'unstash', sideeffects possible",e.getMetadata().getName());if(e.getMetadata().isA("sap.ui.core.Fragment")||e.getMetadata().isA("sap.ui.core.mvc.View")){throw new Error("Stashing is not supported for sap.ui.coreFragment or sap.ui.core.mvc.View")}n(e)};function n(t){t.prototype.unstash=function(){if(this.isStashed()){var t=o(this);t.stashed=false;return t}return this};t.prototype.isStashed=function(){return!!a[this.getId()]};var e=t.prototype.clone;t.prototype.clone=function(){if(this.isStashed()){throw new Error("A stashed control cannot be cloned, id: '"+this.getId()+"'.")}return e.apply(this,arguments)};var r=t.prototype.destroy;t.prototype.destroy=function(){delete a[this.getId()];r.apply(this,arguments)}}function o(t){var e;var r;var n;var o=a[t.getId()];e=t.getParent();if(e){n=e.getMetadata().getAggregation(t.sParentAggregationName);r=n.indexOf(e,t);n.remove(e,t)}t.destroy();var s=sap.ui.require("sap/ui/core/Component");var i=s&&e&&s.getOwnerComponentFor(e);var p;var u=o.fnCreate;if(i){p=i.runAsOwner(u)}else{p=u()}if(r>=0){p.forEach(function(t){n.insert(e,t,r)})}delete a[t.getId()];return p[0]}function s(t,r){var n=[];for(var o in a){var s=e.getElementById(a[o].wrapperId);var i=t?s:o;var p=s&&s.getParent();if(!r||p&&p.getId()===r){n.push(i)}}return n}r.getStashedControlIds=function(t){return s(false,t)};r.getStashedControls=function(t){return s(true,t)};r.createStashedControl=function(t){var e={wrapperId:t.wrapperId,fnCreate:t.fnCreate};a[t.wrapperId]=e;return e};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Title", ["./Element","./library"],function(e,a){"use strict";var l=a.TitleLevel;var p=e.extend("sap.ui.core.Title",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},level:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:l.Auto},emphasized:{type:"boolean",group:"Appearance",defaultValue:false}}}});return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/TooltipBase", ["./Control","./Element","./Popup","./StaticArea","./library","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(t,e,o,i,s,r,jQuery){"use strict";var n=s.OpenState;var p=t.extend("sap.ui.core.TooltipBase",{metadata:{abstract:true,library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},openDuration:{type:"int",group:"Behavior",defaultValue:200},closeDuration:{type:"int",group:"Behavior",defaultValue:200},myPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:"begin top"},atPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:"begin bottom"},offset:{type:"string",group:"Behavior",defaultValue:"10 3"},collision:{type:"sap.ui.core.Collision",group:"Behavior",defaultValue:"flip"},openDelay:{type:"int",group:"Misc",defaultValue:500},closeDelay:{type:"int",group:"Misc",defaultValue:100}},events:{closed:{}}},renderer:null});p.prototype._getPopup=function(){var t=new o;t.setShadow(true);p.prototype._getPopup=function(){return t};return t};p.prototype.onfocusin=function(t){var o=e.closestTo(t.target);if(o!=null){var s=o.getFocusDomRef();this.sStoredTooltip=null;if(s.title&&s.title!=""){this.sStoredTooltip=s.title;s.title=""}var r=this._getPopup();if(!(r.isOpen()&&r.getContent()==this)){sap.ui.getCore().createRenderManager().render(this,i.getDomRef(),true)}var n=s.getAttribute("aria-describedby");var p=this.getId()+"-title "+this.getId()+"-txt";if(n==null||n==""){s.setAttribute("aria-describedby",p)}else if(n.indexOf(p)==-1){s.setAttribute("aria-describedby",n+" "+p)}}};p.prototype.onfocusout=function(t){var o=e.closestTo(t.target);if(o!=null){var i=o.getFocusDomRef();if(this.sStoredTooltip){i.title=this.sStoredTooltip}var s=i.getAttribute("aria-describedby");var r=this.getId()+"-title "+this.getId()+"-txt";if(s&&s.indexOf(r)>=0){if(s.trim()==r){i.removeAttribute("aria-describedby")}else{s=s.replace(r,"");i.setAttribute("aria-describedby",s)}}}if(p.sOpenTimeout){clearTimeout(p.sOpenTimeout);p.sOpenTimeout=undefined}this.sCloseNowTimeout=setTimeout(this["closePopup"].bind(this),this.getCloseDelay())};p.prototype.isStandardTooltip=function(t){return typeof t==="string"&&!!t.trim()};p.prototype.onmouseover=function(t){var o=e.closestTo(t.target),i=e.closestTo(t.currentTarget),s=e.closestTo(t.relatedTarget);if(!o){return}if(o===this){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null}t.stopPropagation();t.preventDefault();return}if(i===o||!this.isStandardTooltip(o.getTooltip())){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;t.stopPropagation();t.preventDefault()}}if(s){if(s.getParent()){if(s.getParent()===i&&i===o){var r=s.getTooltip();if(!this.isStandardTooltip(r)&&(!r||!(r instanceof p))){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;t.stopPropagation();t.preventDefault()}}}}}if(this._currentControl===o||!this.isStandardTooltip(o.getTooltip())){this.removeStandardTooltips();if(p.sOpenTimeout){clearTimeout(p.sOpenTimeout)}p.sOpenTimeout=setTimeout(this["openPopup"].bind(this,this._currentControl),this.getOpenDelay());t.stopPropagation();t.preventDefault()}};p.prototype.onmouseout=function(t){if(p.sOpenTimeout){clearTimeout(p.sOpenTimeout);p.sOpenTimeout=undefined}if(!this.sCloseNowTimeout){this.sCloseNowTimeout=setTimeout(this["closePopup"].bind(this),this.getCloseDelay())}this.restoreStandardTooltips();t.stopPropagation();t.preventDefault()};p.prototype.closePopup=function(){var t=this._getPopup();if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout)}this.sCloseNowTimeout=undefined;t.attachClosed(this.handleClosed,this);t.close();this.restoreStandardTooltips()};p.prototype.handleClosed=function(){this._getPopup().detachClosed(this.handleClosed,this);this.fireClosed()};p.prototype.openPopup=function(t){if(!this.getVisible()){return}if(t.getTooltip()!=null){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;return}var e=this._getPopup();if(e.isOpen()&&e.getContent()==this){return}var o=t.getDomRef();e.setContent(this);e.setPosition(this.getMyPosition(),this.getAtPosition(),o,this.getOffset(),this.getCollision());e.setDurations(this.getOpenDuration(),this.getCloseDuration());e.open();this.removeStandardTooltips()}};p.prototype.removeStandardTooltips=function(){var t=this._currentControl.getDomRef();if(!this.aStoredTooltips){this.aStoredTooltips=[]}else{return}var e="";while(t&&!(t===document)){e=t.title;if(e){this.aStoredTooltips.push({domref:t,tooltip:e});t.title=""}t=t.parentNode}if(this._currentControl.getTooltipDomRefs){var o=this._currentControl.getTooltipDomRefs();for(var i=0;i<o.length;i++){t=o[i];if(t){e=t.title;if(e){this.aStoredTooltips.push({domref:t,tooltip:e});t.title=""}}}}};p.prototype.restoreStandardTooltips=function(){var t=this._getPopup();var e=t.getOpenState();if(e===n.OPEN||e===n.OPENING){return}if(p.sOpenTimeout){return}if(this.aStoredTooltips){for(var o=0;o<this.aStoredTooltips.length;o++){var i=this.aStoredTooltips[o].domref;i.title=this.aStoredTooltips[o].tooltip}}this.aStoredTooltips=null};p.prototype.setParent=function(e,o){var i=this._getPopup();if(i&&i.isOpen()){this.closePopup()}t.prototype.setParent.apply(this,arguments)};p.prototype.onkeydown=function(t){if(t.ctrlKey&&t.which==r.I){var o=e.closestTo(t.target);if(o!=null){if(this._currentControl===o||!this.isStandardTooltip(o.getTooltip())){this.removeStandardTooltips();this.openPopup(this._currentControl);t.preventDefault();t.stopPropagation()}}}else if(t.which==r.ESCAPE){if(p.sOpenTimeout){clearTimeout(p.sOpenTimeout);p.sOpenTimeout=undefined}var i=this.oPopup&&this.oPopup.isOpen();this.closePopup();if(i){t.preventDefault();t.stopPropagation()}}};p.prototype._closeOrPreventOpen=function(){var t=this._getPopup();if(t.isOpen()){this.closePopup()}else if(p.sOpenTimeout){clearTimeout(p.sOpenTimeout);p.sOpenTimeout=undefined}};return p});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/UIComponent", ["../base/ManagedObject","./Component","./Element","sap/ui/core/mvc/ViewType","sap/ui/core/mvc/XMLProcessingMode","./UIComponentMetadata","./mvc/Controller","./mvc/View","sap/base/util/ObjectPath","sap/base/Log"],function(t,e,o,n,r,i,s,a,u,c){"use strict";var p=e.extend("sap.ui.core.UIComponent",{constructor:function(t,o){var n=false;try{if(typeof t!=="string"){o=t;t=undefined}if(o&&o.hasOwnProperty("_routerHashChanger")){this._oRouterHashChanger=o._routerHashChanger;delete o._routerHashChanger}if(o&&o.hasOwnProperty("_propagateTitle")){this._bRoutingPropagateTitle=o._propagateTitle;delete o._propagateTitle}e.apply(this,arguments);n=true}finally{if(!n){this._destroyCreatedInstances()}}},metadata:{abstract:true,rootView:null,publicMethods:["render"],aggregations:{rootControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},designtime:"sap/ui/core/designtime/UIComponent.designtime",routing:{}}},i);p._fnOnInstanceInitialized=null;p._fnOnInstanceDestroy=null;p.prototype.init=function(){var e=this;var o={};var n;if(this.getAutoPrefixId()){o.id=function(t){return e.createId(t)}}function r(t){var o=function(){if(typeof p._fnOnInstanceInitialized==="function"){p._fnOnInstanceInitialized(e)}};var n=function(t){e.setAggregation("rootControl",t)};if(t instanceof Promise){e.pRootControlLoaded=e.pRootControlLoaded.then(function(t){n(t);o();return t})}else if(t instanceof a&&t.oAsyncState&&t.oAsyncState.promise){n(t);e.pRootControlLoaded=e.pRootControlLoaded.then(function(t){o();return t})}else{n(t);o()}}function i(t,o){var n;if(t instanceof Promise){n=e.pRootControlLoaded.then(function(t){return t instanceof a?t.getId():undefined})}else if(t instanceof a){n=t.getId()}if(n){if(o.targetParent===undefined){o.targetParent=n}if(e._oTargets){e._oTargets._setRootViewId(n)}}}function s(t){c.error(`The routing related class '${t}' was loaded synchronously as a result of a synchronous Component creation. Resolving a class in this fashion is deprecated. `+`Please use the asynchronous Component.create() factory instead and ensure all non-default routing relevant classes are maintained in the manifest.json.`)}var u=this._getManifestEntry("/sap.ui5/routing",true)||{},l=u.config||{},g=u.routes;if(this.isA("sap.ui.core.IAsyncContentCreation")){l.async=true}if(g){var d;var h=this._getRouterClassName();if(h){d=f(h)}else{d=sap.ui.require("sap/ui/core/routing/Router");if(!d){d=sap.ui.requireSync("sap/ui/core/routing/Router");s("sap/ui/core/routing/Router")}}this._oRouter=new d(g,l,this,u.targets,this._oRouterHashChanger);this._oTargets=this._oRouter.getTargets();this._oViews=this._oRouter.getViews()}else if(u.targets){var y=sap.ui.require("sap/ui/core/routing/Views");if(!y){y=sap.ui.requireSync("sap/ui/core/routing/Views")}this._oViews=new y({component:this});var C;if(l.targetsClass){C=f(l.targetsClass)}else{C=sap.ui.require("sap/ui/core/routing/Targets");if(!C){C=sap.ui.requireSync("sap/ui/core/routing/Targets");s("sap/ui/core/routing/Targets")}}this._oTargets=new C({targets:u.targets,config:l,views:this._oViews})}this.runAsOwner(function(){t.runWithPreprocessors(function(){n=e.createContent()},o)});if(n instanceof Promise){if(this.isA("sap.ui.core.IAsyncContentCreation")){this.pRootControlLoaded=n}else{throw new Error("Interface 'sap.ui.core.IAsyncContentCreation' must be implemented for component '"+this.getMetadata().getComponentName()+"' when 'createContent' is implemented asynchronously")}}else if(n instanceof a&&n.oAsyncState&&n.oAsyncState.promise){this.pRootControlLoaded=n.loaded()}else{this.pRootControlLoaded=Promise.resolve(n)}i(n,l);r(n)};function f(t){var e;if(typeof t==="string"){e=sap.ui.require(t.replace(/\./g,"/"));if(!e){e=u.get(t);if(e){c.error(`The class '${t}' was accessed via globals. `+"Retrieving routing classes via globals is deprecated and a result of synchronous Component creation, "+"please use the asynchronous sap.ui.core.Component.create() factory instead.")}}if(!e){c.error("[FUTURE FATAL] The specified class for router or targets '"+t+"' is undefined.",this)}}else{e=t}return e}p.prototype.rootControlLoaded=function(){if(!this.pRootControlLoaded){c.error("[FUTURE FATAL] Mandatory init() not called for UIComponent: '"+this.getManifestObject().getComponentName()+"'. This is likely caused by a missing super call in the component's init implementation.",null,"sap.ui.support",function(){return{type:"missingInitInUIComponent"}})}return this.pRootControlLoaded||Promise.resolve(this.getRootControl())};p.prototype.destroy=function(){if(typeof p._fnOnInstanceDestroy==="function"){p._fnOnInstanceDestroy(this)}this._destroyCreatedInstances();return e.prototype.destroy.apply(this,arguments)};p.prototype._destroyCreatedInstances=function(){if(this._oRouter){this._oRouter.destroy();delete this._oRouter}else{if(this._oTargets){this._oTargets.destroy();this._oTargets=null}if(this._oViews){this._oViews.destroy();this._oViews=null}}};p.getRouterFor=function(t){var o=t;if(o instanceof s){o=o.getView()}if(o instanceof a){var n=e.getOwnerComponentFor(o);if(n){return n.getRouter()}else{return undefined}}};p.prototype.getRouter=function(){return this._oRouter};p.prototype.hasNativeRouter=function(){return this._oRouter===this.getRouter()};p.prototype.getTargets=function(){return this._oTargets};p.prototype.getAutoPrefixId=function(){return!!this.getManifestObject().getEntry("/sap.ui5/autoPrefixId")};p.prototype.byId=function(t){return o.getElementById(this.createId(t))};p.prototype.createId=function(t){if(!this.isPrefixedId(t)){t=this.getId()+"---"+t}return t};p.prototype.getLocalId=function(t){var e=this.getId()+"---";return t&&t.indexOf(e)===0?t.slice(e.length):null};p.prototype.isPrefixedId=function(t){return!!(t&&t.indexOf(this.getId()+"---")===0)};p.prototype.createContent=function(){var t=this._getManifestEntry("/sap.ui5/rootView",true);if(t&&typeof t==="string"){return a._create({viewName:t,type:n.XML})}else if(t&&typeof t==="object"){if(!t.type&&!a._getModuleName(t)){t.type=n.XML}if(t.id){t.id=this.createId(t.id)}if(t.async&&t.type===n.XML){t.processingMode=r.Sequential}if(this.isA("sap.ui.core.IAsyncContentCreation")){return a.create(t)}return a._create(t)}else if(t){throw new Error("Configuration option 'rootView' of component '"+this.getMetadata().getName()+"' is invalid! 'rootView' must be type of string or object!")}return null};p.prototype.getRootControl=function(){return this.getAggregation("rootControl")};p.prototype.render=function(t){var e=this.getRootControl();if(e&&t){t.renderControl(e)}};p.prototype.getUIArea=function(){return this.oContainer?this.oContainer.getUIArea():null};p.prototype.getEventingParent=function(){return this.getUIArea()};p.prototype.setContainer=function(e){this.oContainer=e;if(e){this._applyContextualSettings(e._getContextualSettings())}else{this._oContextualSettings=t._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oContainer){this._propagateContextualSettings()}}.bind(this),0)}}return this};p.prototype.onBeforeRendering=function(){};p.prototype.onAfterRendering=function(){};p.prototype._getRouterClassName=function(){var t=this._getManifestEntry("/sap.ui5/routing",true)||{},e=t.config||{};return e.routerClass};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/UIComponentMetadata", ["./ComponentMetadata","sap/ui/core/mvc/ViewType"],function(t,o){"use strict";var e=function(o,e){t.apply(this,arguments)};e.prototype=Object.create(t.prototype);e.prototype.constructor=e;e.preprocessClassInfo=function(t){if(t&&typeof t.metadata==="string"){t.metadata={_src:t.metadata}}return t};e.prototype.getRootView=function(t){return this.getManifestEntry("/sap.ui5/rootView",!t)};e.prototype.getRoutingConfig=function(t){return this.getManifestEntry("/sap.ui5/routing/config",!t)};e.prototype.getRoutes=function(t){return this.getManifestEntry("/sap.ui5/routing/routes",!t)};e.prototype._convertLegacyMetadata=function(e,r){t.prototype._convertLegacyMetadata.call(this,e,r);var i=r["sap.ui5"];var n=i["rootView"]||e["rootView"];if(n){i["rootView"]=n}var a=i["routing"]||e["routing"];if(a){i["routing"]=a}if(i["rootView"]&&typeof i["rootView"]==="string"){i["rootView"]={viewName:i["rootView"],type:o.XML}}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ValueStateSupport", ["./Element","./library","./Lib","sap/base/assert"],function(e,t,r,n){"use strict";var a=t.ValueState;var u={};var i=null;var o=function(){if(!i){i={};var e=r.getResourceBundleFor("sap.ui.core");i[a.Error]=e.getText("VALUE_STATE_ERROR");i[a.Warning]=e.getText("VALUE_STATE_WARNING");i[a.Success]=e.getText("VALUE_STATE_SUCCESS");i[a.Information]=e.getText("VALUE_STATE_INFORMATION")}};u.enrichTooltip=function(t,r){n(t instanceof e,"oElement must be an Element");if(!r&&t.getTooltip()){return undefined}var a=u.getAdditionalText(t);if(a){return(r?r+" - ":"")+a}return r};u.getAdditionalText=function(e){var t=null;if(e&&e.getValueState){t=e.getValueState()}else if(a[e]){t=e}if(t&&t!=a.None){o();return i[t]}return null};u.formatValueState=function(e){switch(e){case 1:return a.Warning;case 2:return a.Success;case 3:return a.Error;case 4:return a.Information;default:return a.None}};return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/VariantLayoutData", ["./LayoutData","./library"],function(a){"use strict";var t=a.extend("sap.ui.core.VariantLayoutData",{metadata:{library:"sap.ui.core",aggregations:{multipleLayoutData:{type:"sap.ui.core.LayoutData",multiple:true,singularName:"multipleLayoutData"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/XMLComposite", ["sap/ui/core/Control","sap/ui/core/XMLCompositeMetadata","sap/ui/model/base/ManagedObjectModel","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/model/resource/ResourceModel","sap/base/Log","sap/ui/performance/Measurement"],function(e,t,i,r,o,n,a,s){"use strict";var g="sap.ui.core.XMLComposite";var p=e.extend("sap.ui.core.XMLComposite",{metadata:{interfaces:["sap.ui.core.IDScope"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},displayBlock:{type:"boolean",group:"Appearance",defaultValue:true,invalidate:true}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden",invalidate:true}}},constructor:function(){this._bIsCreating=true;e.apply(this,arguments);delete this._bIsCreating},renderer:{apiVersion:2,render:function(e,t){a.debug("Start rendering '"+t.sId,g);s.start(t.getId()+"---renderControl","Rendering of "+t.getMetadata().getName(),["rendering","control"]);e.openStart("div",t);e.accessibilityState(t);if(!t.getDisplayBlock()&&(t.getWidth()!=="100%"||t.getHeight()!=="100%")){e.style("display","inline-block")}e.style("height",t.getHeight());e.style("width",t.getWidth());e.openEnd();var i=t._renderingContent?t._renderingContent():t._getCompositeAggregation();if(i){e.renderControl(i)}e.close("div");s.end(t.getId()+"---renderControl");a.debug("Stop rendering '"+t.sId,g)}}},t);p.prototype.byId=function(e){return r.getElementById(o.createId(this.getId(),e))};p.prototype._getManagedObjectModel=function(){if(!this._oManagedObjectModel){this._oManagedObjectModel=new i(this)}return this._oManagedObjectModel};p.prototype.getSuppressInvalidateAggregation=function(e,t){var i=this.getMetadata(),r=i.getAggregation(e)||i.getAllPrivateAggregations()[e];if(!r){return true}t=i._suppressInvalidate(r,t);return t};p.prototype.setProperty=function(t,i,r){var o=this.getMetadata(),n=o.getManagedProperty(t);if(!n){return this}r=o._suppressInvalidate(n,r);return e.prototype.setProperty.apply(this,[t,i,r])};p.prototype.setAggregation=function(t,i,r){return e.prototype.setAggregation.apply(this,[t,i,this.getSuppressInvalidateAggregation(t,r)])};p.prototype.addAggregation=function(t,i,r){return e.prototype.addAggregation.apply(this,[t,i,this.getSuppressInvalidateAggregation(t,r)])};p.prototype.insertAggregation=function(t,i,r,o){return e.prototype.insertAggregation.apply(this,[t,i,r,this.getSuppressInvalidateAggregation(t,o)])};p.prototype.removeAggregation=function(t,i,r){return e.prototype.removeAggregation.apply(this,[t,i,this.getSuppressInvalidateAggregation(t,r)])};p.prototype.removeAllAggregation=function(t,i){return e.prototype.removeAllAggregation.apply(this,[t,this.getSuppressInvalidateAggregation(t,i)])};p.prototype.destroyAggregation=function(t,i){return e.prototype.destroyAggregation.apply(this,[t,this.getSuppressInvalidateAggregation(t,i)])};p.prototype.updateAggregation=function(t,i){var r=this.getMetadata().getAggregation(t);if(r&&r.type==="TemplateMetadataContext"){this.invalidate();return}e.prototype.updateAggregation.apply(this,arguments)};p.prototype.setVisible=function(e){this.setProperty("visible",e);if(this.getParent()){this.getParent().invalidate()}return this};p.prototype._destroyCompositeAggregation=function(){var e=this._getCompositeAggregation();if(e){e.destroy("KeepDom")}return this};p.prototype.updateBindings=function(){if(this._bIsCreating){return}var t=e.prototype.updateBindings.apply(this,arguments);for(var i in this.mBindingInfos){var r=this.getMetadata().getAggregation(i);if(r&&r.multiple&&!r._doesNotRequireFactory&&this.isBound(i)&&!this.getBinding(i)){this[r._sDestructor]()}}return t};p.prototype._getCompositeAggregation=function(){var e=this.getMetadata().getCompositeAggregationName();return this.getAggregation(e)};p.prototype._setCompositeAggregation=function(e){var t=this.getMetadata().getCompositeAggregationName();this._destroyCompositeAggregation();if(!this._oManagedObjectModel){this._getManagedObjectModel()}if(Array.isArray(e)){this.setAggregation(t,null);return}if(e){if(!e.enhanceAccessibilityState){e.enhanceAccessibilityState=function(e,t){this.enhanceAccessibilityState(e,t)}.bind(this)}e.bindObject("$"+this.alias+">/");e.setModel(this._oManagedObjectModel,"$"+this.alias);if(this.bUsesI18n){var i=this._getResourceModel();if(i){e.setModel(i,"$"+this.alias+".i18n")}}}this.setAggregation(t,e)};p.mResourceModels={};p.getLibraryResourceModel=function(e){var t=p.mResourceModels[e];if(!t){t=new n({bundleName:e+".messagebundle",async:true});p.mResourceModels[e]=t}return t};p.prototype._getResourceModel=function(){if(this.resourceModel){return this.resourceModel}if(this.messageBundle){this.resourceModel=new n({bundleName:this.messageBundle,async:true});return this.resourceModel}else{this.sLibraryName=this.sLibraryName||this.getMetadata().getLibraryName();if(this.sLibraryName){return p.getLibraryResourceModel(this.sLibraryName)}}};p.prototype.getResourceBundle=function(){var e=this._getResourceModel();return e?e.getResourceBundle():null};p.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);if(this.resourceModel){this.resourceModel.destroy()}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy()}};p.prototype._initCompositeSupport=function(e){var t=this.getMetadata(),i=t._fragment,r=t.getCompositeAggregationName();this._destroyCompositeAggregation();if(e&&r&&e[r]){var o=e[r];if(o.localName==="FragmentDefinition"){i=o;delete e[r]}}var n=i?(new XMLSerializer).serializeToString(i):undefined;this.bUsesI18n=n?n.indexOf("$"+this.alias+".i18n")!=-1:true;this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:i,oController:this}));this._bIsInitialized=true};p.prototype.enhanceAccessibilityState=function(e,t){var i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(this,t)}};p.prototype.getFocusDomRef=function(){var e=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return e.getFocusDomRef()};p.prototype.getFocusInfo=function(){var e=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return e.getFocusInfo()};p.prototype.getIdForLabel=function(){var e=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return e.getIdForLabel()};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/XMLCompositeMetadata", ["sap/ui/core/ElementMetadata","sap/ui/core/XMLTemplateProcessor","sap/base/Log"],function(t,e,r){"use strict";var a={};var n=function(e,a){this.InvalidationMode={Render:true,None:false};if(!a.hasOwnProperty("renderer")){a.renderer="sap.ui.core.XMLCompositeRenderer"}if(!a.hasOwnProperty("alias")){a.alias="this"}t.apply(this,arguments);var n=this._bAbstract;if(!n){if(!a.fragment&&e!=="sap.ui.core.XMLComposite"){a.fragment=e;a.fragmentUnspecified=true}if(!this._fragment&&a.fragment){try{if(!this._fragment){if(a.fragmentContent){if(typeof a.fragmentContent==="string"){var o=new DOMParser;a.fragmentContent=o.parseFromString(a.fragmentContent,"text/xml").documentElement;if(a.fragmentContent&&a.fragmentContent.getElementsByTagName("parsererror").length){var i=a.fragmentContent.getElementsByTagName("parsererror")[0].innerText;throw new Error("There was an error parsing the XML fragment for XMLComposite '"+e+"'. The following message may contain hints to find the problem: "+i)}}this._fragment=a.fragmentContent}else{this._fragment=this._loadFragment(a.fragment,"control")}}}catch(t){if(!a.fragmentUnspecified||t.message.startsWith("There was an error parsing")){throw t}else{r.warning("Implicitly inferred fragment xml "+a.fragment+" not found. "+e+" is not abstract!")}}}}this._sCompositeAggregation=a.metadata?a.metadata.compositeAggregation||null:null;this._createPrivateAggregationAccessors();this._applyAggregationSettings()};n.prototype=Object.create(t.prototype);n.prototype.constructor=n;n.uid=t.uid;n.extend=function(t){for(var e in t){n[e]=t[e]}return n};n.prototype.getCompositeAggregationName=function(){return this._sCompositeAggregation||"_content"};n.prototype.getFragment=function(){if(this._fragment){return this._fragment.cloneNode(true)}};n.prototype._applyAggregationSettings=function(){var t=this.getAllAggregations();for(var e in t){if(t[e].type==="TemplateMetadataContext"){this.getAggregation(e)._doesNotRequireFactory=true}}};n.prototype._createPrivateAggregationAccessors=function(){var t=this.getAllPrivateAggregations(),e=this.getClass().prototype,r=function(t,r){if(!e[t]){e[t]=r}};for(var a in t){t[a].generate(r)}};n.prototype._suppressInvalidate=function(t,e){if(e){return true}if(!t.appData){t.appData={};t.appData.invalidate=this.InvalidationMode.None}if(t&&t.appData&&t.appData.invalidate===this.InvalidationMode.Render){return false}return true};n.prototype.getMandatoryAggregations=function(){if(!this._mMandatoryAggregations){var t=this.getAllAggregations(),e={};for(var r in t){if(t[r].type==="TemplateMetadataContext"&&t[r].appData.mandatory){e[r]=t[r]}}this._mMandatoryAggregations=e}return this._mMandatoryAggregations};n.prototype._loadFragment=function(t,r){var n=r+"$"+t;if(!a[n]){a[n]=e.loadTemplate(t,r)}return a[n]};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/XMLTemplateProcessor", ["sap/ui/base/DataType","sap/ui/base/BindingInfo","sap/ui/core/CustomData","sap/ui/core/Component","./mvc/View","./mvc/ViewType","./mvc/XMLProcessingMode","./mvc/EventHandlerResolver","./ExtensionPoint","./StashedControlSupport","sap/ui/base/SyncPromise","sap/base/Log","sap/base/util/ObjectPath","sap/base/assert","sap/base/util/LoaderExtensions","sap/base/util/JSTokenizer","sap/base/util/each","sap/base/util/isEmptyObject","sap/ui/base/DesignTime","sap/ui/core/Lib"],function(e,t,n,r,i,a,o,s,u,l,c,f,d,p,g,m,v,h,w,b){"use strict";function y(n,r,i,a,o,s){var u=!!s;var l;var c=t.parse(r,a,true,false,false,false,o,u);if(u&&c){s.push(c.resolved);l=c.bindingInfo}else{l=c}if(l&&typeof l==="object"){return l}var d=r=typeof l==="string"?l:r;var p=e.getType(n);if(p){if(p instanceof e){d=p.parseValue(r,{context:a,locals:o});if(!p.isValid(d)){f.error("[FUTURE FATAL] Value '"+r+"' is not valid for type '"+p.getName()+"'.")}}}else{throw new Error("Property "+i+" has unknown type "+n)}return typeof d==="string"?t.escape(d):d}function A(e){return e.localName||e.nodeName}var C="http://www.w3.org/1999/xhtml";var N="http://www.w3.org/2000/xmlns/";var _="http://www.w3.org/2000/svg";var x="sap.ui.core";var M="sap.ui.core.mvc";var E="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var T="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1";var V="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1";var I="http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1";var L="http://schemas.sap.com/sapui5/preprocessorextension/";var P=["controllerName","resourceBundleName","resourceBundleUrl","resourceBundleLocale","resourceBundleAlias"];var R=/^(?:area|base|br|col|embed|hr|img|input|link|meta|param|source|track|wbr)$/;function S(e,t){function n(e,n){var r,i=[];for(var a=0;a<e.childNodes.length;a++){r=t(e,e.childNodes[a],n);if(r){i.push(r.unwrap())}}return c.resolve(i)}function r(e,n){var r=Promise.resolve(),i=[n.chain];for(var a=0;a<e.childNodes.length;a++){r=r.then(t.bind(null,e,e.childNodes[a],n));i.push(r)}return Promise.all(i)}return e?r:n}var U={};U.loadTemplate=function(e,t){var n=e.replace(/\./g,"/")+("."+(t||"view")+".xml");return g.loadResource(n).documentElement};U.loadTemplatePromise=function(e,t){var n=e.replace(/\./g,"/")+("."+(t||"view")+".xml");return g.loadResource(n,{async:true}).then(function(e){return e.documentElement})};U.parseViewAttributes=function(e,t){var n,r;for(n=0;n<e.attributes.length;n++){r=e.attributes[n];if(P.includes(r.name)){t["_"+r.name]=r.value}}};U.enrichTemplateIds=function(e,t){U.enrichTemplateIdsPromise(e,t,false);return e};U.enrichTemplateIdsPromise=function(e,t,n){return j(e,t,true,n).then(function(){return e})};U.parseTemplate=function(e,t,n){return U.parseTemplatePromise(e,t,false,{settings:n}).unwrap()};U.parseTemplatePromise=function(e,t,n,r){return j(e,t,false,n,r).then(function(e){if(t.isA("sap.ui.core.mvc.View")){var n,r;for(r=e.length-1;r>=0;r--){n=e[r];if(n&&n._isExtensionPoint){var i=[r,1].concat(n._aControls);Array.prototype.splice.apply(e,i)}}}return e})};function F(e){var t,n=/^[a-zA-Z_$][a-zA-Z0-9_$]*$/;if(!e||typeof e!=="object"){t="core:require in XMLView can't be parsed to a valid object"}else{Object.keys(e).some(function(r){if(!n.test(r)){t="core:require in XMLView contains invalid identifier: '"+r+"'";return true}if(!e[r]||typeof e[r]!=="string"){t="core:require in XMLView contains invalid value '"+e[r]+"'under key '"+r+"'";return true}return false})}return t}function q(e,t){var n=e.getAttributeNS(x,"require"),r,i,a;if(n){try{r=m.parseJS(n)}catch(t){f.error("Require attribute can't be parsed on Node: ",e.nodeName);throw t}a=F(r);if(a){throw new Error(a+" on Node: "+e.nodeName)}if(!h(r)){i={};if(t){return new Promise(function(e,t){var n=Object.keys(r).reduce(function(e,t){i[t]=sap.ui.require(r[t]);return e&&i[t]!==undefined},true);if(n){e(i);return}sap.ui.require(Object.values(r),function(){var t=arguments;Object.keys(r).forEach(function(e,n){i[e]=t[n]});e(i)},t)})}else{Object.keys(r).forEach(function(e){i[e]=sap.ui.requireSync(r[e])});return c.resolve(i)}}}}function B(e,t,n){var r=c.resolve();if(!h(n)){var i=[];var a;if(e){r=new Promise(function(e){a=e})}Object.keys(n).forEach(function(e){var r=n[e];r.forEach(function(e){e.targetControl=t;var n=sap.ui.require(e.providerClass);if(n){i.push(n.applyExtensionPoint(e))}else{var r=new Promise(function(t,n){sap.ui.require([e.providerClass],function(e){t(e)},n)}).then(function(t){return t.applyExtensionPoint(e)});i.push(r)}})});if(e){Promise.all(i).then(a)}}return r}function X(e,t,n){var r=n;for(var i=0;i<100;i++){var a=e.lookupNamespaceURI(r);if(a==null||a===t){return r}r=n+i}throw new Error("Could not find an unused namespace prefix after 100 tries, giving up")}function j(e,g,m,F,j){var k=[],O=X(e,I,"__ui5"),D=q(e,F)||c.resolve(),H={openStart:function(e,t){k.push(["openStart",[e,t]])},voidStart:function(e,t){k.push(["voidStart",[e,t]])},style:function(e,t){k.push(["style",[e,t]])},class:function(e){k.push(["class",[e]])},attr:function(e,t){k.push(["attr",[e,t]])},openEnd:function(){k.push(["openEnd"])},voidEnd:function(){k.push(["voidEnd"])},text:function(e){k.push(["text",[e]])},unsafeHtml:function(e){k.push(["unsafeHtml",[e]])},close:function(e){k.push(["close",[e]])},renderControl:function(e){k.push(e)}};if(j?.settings?.requireContext){D=D.then(e=>Object.assign({},j.settings.requireContext,e))}F=F&&!!g._sProcessingMode;f.debug("XML processing mode is "+(g._sProcessingMode||"default")+".","","XMLTemplateProcessor");f.debug("XML will be processed "+(F?"asynchronously":"synchronously")+".","","XMLTemplateProcessor");var K=w.isDesignModeEnabled();if(K){g._sapui_declarativeSourceInfo={xmlNode:e,xmlRootNode:g._oContainingView===g?e:g._oContainingView._sapui_declarativeSourceInfo.xmlRootNode}}if(!g.isSubView()){e.setAttributeNS(N,"xmlns:"+O,I)}var W=ee(e,D);var $=0;function z(){for(;$<k.length;$++){var e=k[$];if(e&&typeof e.then==="function"){return e.then(J).then(z)}}return k}function J(e){var t=[$,1].concat(e);Array.prototype.splice.apply(k,t)}return D.then(z).then(function(t){if(W){var n=e.parentNode;n.removeChild(e);if(n.parentNode){n.parentNode.replaceChild(e,n)}}return t});function Z(e){return e}function G(e){return g._oContainingView.createId(e)}function Q(e,t){var n=g.getMetadata().isA("sap.ui.core.mvc.View")?"View":"Fragment";var r=e.outerHTML?e.cloneNode(false).outerHTML:e.textContent;return"Error found in "+n+" (id: '"+g.getId()+"').\nXML node: '"+r+"':\n"+t}function Y(e){var t=A(e),n;if(g.isA("sap.ui.core.mvc.XMLView")&&(e.namespaceURI===C||e.namespaceURI===_)){n=e.ownerDocument.createElementNS(M,"View")}else if(g.isA("sap.ui.core.Fragment")&&(t!=="FragmentDefinition"||e.namespaceURI!==x)){n=e.ownerDocument.createElementNS(x,"FragmentDefinition")}if(n){var r=e.parentNode;if(r){r.replaceChild(n,e)}n.appendChild(e)}return n}function ee(e,t){var n=false,r=g.sViewName||g._sFragmentName,i,a;if(!r){var o=g;var s=0;while(++s<1e3&&o&&o!==o._oContainingView){o=o._oContainingView}r=o.sViewName}i=Y(e);if(i){e=i;n=true}a=A(e);if(g.isA("sap.ui.core.mvc.XMLView")){if(a!=="View"&&a!=="XMLView"||e.namespaceURI!==M){f.error("[FUTURE FATAL] XMLView's root node must be 'View' or 'XMLView' and have the namespace 'sap.ui.core.mvc'"+(r?" (View name: "+r+")":""))}D=t.then(function(){return ae(e,g.getMetadata().getClass(),t,null,{rootArea:true,rootNode:true})})}else{var u=S(F,function(e,t,n){if(t.nodeType===1){return re(t,n.chain,null,undefined,{rootArea:true})}});D=t.then(function(){return u(e,{chain:t})})}return n}function te(e){if(g.fnScopedRunWithOwner){return g.fnScopedRunWithOwner(e)}else{return e()}}function ne(e,t){var n;var r=b.all();v(r,function(r,i){if(e===i.namespace||e===i.name){n=i.name+"."+(i.tagNames&&i.tagNames[t]||t)}});n=n||e+"."+t;function i(e){if(!e){let t=`[FUTURE FATAL] Control '${n}' did not return a class definition from sap.ui.define.`;(()=>{e=d.get(n);if(e){t+=" The control class was instead retrieved via a deprecated access to the global namespace. This fallback behavior will be removed in the next major version (2.0)."}})();f.error(t,"","XMLTemplateProcessor")}return e}var a=n.replace(/\./g,"/");var o=sap.ui.require(a);if(!o){if(!F){o=sap.ui.requireSync(a);o=i(o);return o}return new Promise(function(e,t){sap.ui.require([a],function(t){t=i(t);e(t)},t)})}return o}function re(e,t,n,r,i){var a=i&&i.rootArea,o=i&&i.rootNode&&g.isSubView(),s=A(e),u=a&&(g.isA("sap.ui.core.Fragment")||r&&r.name==="content"),l,d;if(e.nodeType===1){if(e.namespaceURI===C||e.namespaceURI===_){if(a){if(r&&r.name!=="content"){f.error(Q(e,"XHTML nodes can only be added to the 'content' aggregation and not to the '"+r.name+"' aggregation."));return c.resolve([])}if(i&&i.contentBound){throw new Error(Q(e,"No XHTML or SVG node is allowed because the 'content' aggregation is bound."))}var p=e.namespaceURI===C;var v=e.getAttribute("id");if(v!=null){v=se(g,e)}else{v=o?g.getId():undefined}if(s==="style"){var h=e.attributes;var w=e.textContent;e=document.createElement(s);e.textContent=w;for(d=0;d<h.length;d++){var b=h[d];if(!b.prefix){e.setAttribute(b.name,b.value)}}if(v!=null){e.setAttribute("id",v)}if(o){e.setAttribute("data-sap-ui-preserve",g.getId())}H.unsafeHtml(e.outerHTML);return c.resolve([])}var y=R.test(s);if(y){H.voidStart(s,v)}else{H.openStart(s,v)}for(d=0;d<e.attributes.length;d++){var N=e.attributes[d];if(N.name!=="id"&&(N.localName!=="require"||N.namespaceURI!==x)){H.attr(p?N.name.toLowerCase():N.name,N.value)}}if(o){H.attr("data-sap-ui-preserve",g.getId())}if(y){H.voidEnd();if(e.firstChild){f.error("Content of void HTML element '"+s+"' will be ignored")}}else{H.openEnd();var M=q(e,F);if(M){t=c.all([t,M]).then(function(e){return Object.assign({},...e)})}var E=e instanceof HTMLTemplateElement?e.content:e;var T=S(F,function(e,t,n){return re(t,n.chain,n.closestBinding,n.aggregation,n.config)});l=T(E,{chain:t,closestBinding:n,aggregation:r,config:{rootArea:a}});return l.then(function(e){H.close(s);return e.reduce(function(e,t){if(Array.isArray(t)){t.forEach(function(t){e.push(t)})}return e},[])})}}else{var V=e.attributes["id"]?e.attributes["id"].textContent||e.attributes["id"].text:null;if(m){return U.enrichTemplateIdsPromise(e,g,F).then(function(){return[]})}else{var I=function(t,n){var r={id:V?se(g,e,V):undefined,xmlNode:e,requireContext:n,containingView:g._oContainingView,processingMode:g._sProcessingMode};return te(function(){return new t(r)})};return t.then(function(e){if(F){return new Promise(function(t,n){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(n){t([I(n,e)])},n)})}else{var t=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return[I(t,e)]}})}}}else{l=ie(e,t,n);if(u){H.renderControl(l)}return l}}else if(e.nodeType===3&&u){if(!i||!i.contentBound){H.text(e.textContent)}else if(e.textContent.trim()){throw new Error(Q(e,"Text node isn't allowed because the 'content' aggregation is bound."))}}return c.resolve([])}function ie(e,t,n){if(A(e)==="ExtensionPoint"&&e.namespaceURI===x){if(m){return c.resolve([])}else{var r=g instanceof i?g._oContainingView:g;var a=u._factory.bind(null,r,e.getAttribute("name"),function(){var r=c.resolve();var i=[];var a=e.childNodes;for(var o=0;o<a.length;o++){var s=a[o];if(s.nodeType===1){r=r.then(re.bind(null,s,t,n));i.push(r)}}return c.all(i).then(function(e){var t=[];e.forEach(function(e){t=t.concat(e)});return t})},undefined,undefined,F);return c.resolve(te(a))}}else{var o=A(e);var s=o;var l=o.lastIndexOf(".");if(l>=0){s=o.substring(l+1,o.length)}if(/^[a-z].*/.test(s)){var d=g.sViewName||g._sFragmentName||g.getId();f.warning("View or Fragment '"+d+"' contains a Control tag that starts with lower case '"+s+"'",g.getId(),"sap.ui.core.XMLTemplateProcessor#lowerCase")}var p=ne(e.namespaceURI,o);if(p&&typeof p.then==="function"){return p.then(function(r){return ae(e,r,t,n)})}else{return ae(e,p,t,n)}}}function ae(e,u,d,v,w){var b=e.namespaceURI,C={},N={},_="",M=[],R=null,X=null,k=e.getAttribute("stashed")==="true",O=w&&w.rootArea,D=w&&w.rootNode,H;if(!m){e.removeAttribute("stashed")}if(!u){return c.resolve([])}if(D){C.id=g.getId()}var W=u.getMetadata();var $=W.getAllSettings();var z=!O?q(e,F):undefined;if(z){d=c.all([d,z]).then(function(e){return Object.assign({},e[0],e[1])})}d=d.then(function(r){if(h(r)){r=null}H=r;var i=F?[]:undefined;if(!m){for(var a=0;a<e.attributes.length;a++){var o=e.attributes[a],l=o.name,c=o.namespaceURI,d=$[l],v=o.value;if(D&&P.includes(l)){continue}if(l==="id"&&!D){C[l]=se(g,e,v)}else if(l==="class"){_+=v}else if(l==="viewName"){C[l]=v}else if(l==="fragmentName"){C[l]=v;C["containingView"]=g._oContainingView}else if(l==="binding"&&!d||l==="objectBindings"){if(!k){var w=t.parse(v,g._oContainingView.oController);if(w){C.objectBindings=C.objectBindings||{};C.objectBindings[w.model||undefined]=w}}}else if(l==="metadataContexts"){if(!k){var b=null;try{b=U._calculatedModelMapping(v,g._oContainingView.oController,true)}catch(e){f.error("[FUTURE FATAL] "+g+":"+e.message)}if(b){C.metadataContexts=b;if(U._preprocessMetadataContexts){U._preprocessMetadataContexts(u.getMetadata().getName(),C,g._oContainingView.oController)}}}}else if(l.indexOf(":")>-1){c=o.namespaceURI;if(c===E){var N=A(o);M.push(new n({key:N,value:y("any",v,N,g._oContainingView.oController,r,i)}))}else if(c===T){X=v}else if(c&&c.startsWith(L)){f.debug(g+": XMLView parser ignored preprocessor attribute '"+l+"' (value: '"+v+"')")}else if(c===I&&A(o)==="invisible"){d=$.visible;if(d&&d._iKind===0&&d.type==="boolean"){C.visible=false}}else if(c===x||c===I||l.startsWith("xmlns:")){}else{if(!R){R={}}if(!R.hasOwnProperty(o.namespaceURI)){R[o.namespaceURI]={}}R[o.namespaceURI][A(o)]=o.nodeValue;f.debug(g+": XMLView parser encountered unknown attribute '"+l+"' (value: '"+v+"') with unknown namespace, stored as sap-ui-custom-settings of customData")}}else if(d&&d._iKind===0){C[l]=y(d.type,v,l,g._oContainingView.oController,r,i)}else if(d&&d._iKind===1&&d.altTypes){if(!k){C[l]=y(d.altTypes[0],v,l,g._oContainingView.oController,r)}}else if(d&&d._iKind===2){if(!k){var w=t.parse(v,g._oContainingView.oController,false,false,false,false,r);if(w){C[l]=w}else{f.error("[FUTURE FATAL] "+g+": aggregations with cardinality 0..n specifies a non valid BindingInfo (wrong value: "+l+"='"+v+"')")}}}else if(d&&d._iKind===3){if(!k){C[l]=G(v)}}else if(d&&d._iKind===4){if(!k){C[l]=v.split(/[\s,]+/g).filter(Z).map(G)}}else if(d&&d._iKind===5){if(!k){var V=[];s.parse(v).forEach(function(e){var t=s.resolveEventHandler(e,g._oContainingView.oController,r);if(t){V.push(t)}else{f.warning("[FUTURE FATAL] "+g+': event handler function "'+e+'" is not a function or does not exist in the controller.')}});if(V.length){C[l]=V}}}else if(d&&d._iKind===-1){if(W.isA("sap.ui.core.mvc.View")&&l=="async"){C[l]=y(d.type,v,l,g._oContainingView.oController,r)}else{f.warning("[FUTURE FATAL] "+g+": setting '"+l+"' for class "+W.getName()+" (value:'"+v+"') is not supported")}}else{p(l==="xmlns","[FUTURE FATAL] "+g+": encountered unknown setting '"+l+"' for class "+W.getName()+" (value:'"+v+"')");if(U._supportInfo){U._supportInfo({context:e,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+l+"' for class "+W.getName()}})}}}if(R){M.push(new n({key:"sap-ui-custom-settings",value:R}))}if(M.length>0){C.customData=M}}if(Array.isArray(i)){return Promise.all(i).then(function(){return r})}return r}).catch(function(t){if(!t.isEnriched){t=new Error(Q(e,t));t.isEnriched=true;f.error(t)}if(F&&g._sProcessingMode!==o.SequentialLegacy){throw t}});var J=S(F,Y);function Y(e,t,n){var r=n.aggregation,i=n.allAggregations,a=n.chain,o=n.closestBinding,s=n.config,u,f;if(t.nodeType===1){if(t.namespaceURI===V){C[A(t)]=t.querySelector("*");return undefined}u=t.namespaceURI===b&&i&&i[A(t)];if(u){return J(t,{aggregation:u,allAggregations:null,chain:a,closestBinding:o,config:s})}else if(r){if(t.getAttribute("stashed")==="true"&&!m){var d=t;t=t.cloneNode();d.removeAttribute("stashed");f=function(){var n=se(g,t);l.createStashedControl({wrapperId:n,fnCreate:function(){var t=F;F=false;try{return Y(e,d,{aggregation:r,allAggregations:i,chain:c.resolve(H),closestBinding:o}).unwrap()}finally{F=t}}})};te(f);t.removeAttribute("visible");oe(t,"invisible")}if(C[r.name]&&typeof C[r.name].path==="string"){o={aggregation:r.name,id:C.id};if(D&&r.name==="content"){s=s||{};s.contentBound=true}}return re(t,a,o,r,s).then(function(e){for(var t=0;t<e.length;t++){var n=e[t];var i=r.name;if(n._isExtensionPoint){if(!C[i]){C[i]=[]}var a=N[i];if(!a){a=N[i]=[]}n.index=C[i].length;n.aggregationName=i;n.closestAggregationBindingCarrier=o&&o.id;n.closestAggregationBinding=o&&o.aggregation;var s=a[a.length-1];if(s){s._nextSibling=n}a.push(n)}else if(r.multiple){if(!C[i]){C[i]=[]}if(typeof C[i].path==="string"){p(!C[i].template,"list bindings support only a single template object");C[i].template=n}else{C[i].push(n)}}else{p(!C[i],"multiple aggregates defined for aggregation with cardinality 0..1");C[i]=n}}return e})}else{throw new Error(Q(t,"Cannot add direct child without default aggregation defined for control "+W.getElementName()))}}else if(t.nodeType===3){if(s&&s.rootArea){re(t,a,o,r,s)}else{var v=t.textContent||t.text;if(v&&v.trim()){throw new Error(Q(t,"Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed."))}}}}var ee=W.getDefaultAggregation();var ne=W.getAllAggregations();return J(e,{aggregation:ee,allAggregations:ne,chain:d,closestBinding:v,config:w}).then(function(){var t;var n=c.resolve();var o=c.resolve();var s=e.getAttribute("type");var l=r.getOwnerComponentFor(g);var f=l&&l.isA("sap.ui.core.IAsyncContentCreation");if(m){if(!O&&e.hasAttribute("id")){ue(g,e)}}else if(!D&&u.getMetadata().isA("sap.ui.core.mvc.View")){if(!u._sType&&!C.viewName){C.viewName="module:"+u.getMetadata().getName().replace(/\./g,"/")}C.type=u._sType||s;if(f&&F){if(C.async===false){throw new Error("A nested view contained in a Component implementing 'sap.ui.core.IAsyncContentCreation' is processed asynchronously by default and cannot be processed synchronously.\n"+"Affected Component '"+l.getMetadata().getComponentName()+"' and View '"+C.viewName+"'.")}o=te(function(){return i.create(C)})}else{if(u.getMetadata().isA("sap.ui.core.mvc.XMLView")&&g._sProcessingMode){C.processingMode=g._sProcessingMode}var d=i._getViewClassName(C,true);if(F&&d){o=new Promise(function(e,t){sap.ui.require([d],e,t)}).then(function(){return te(function(){return i._create(C)})})}else{t=te(function(){return i._create(C)})}}}else if(u.getMetadata().isA("sap.ui.core.Fragment")&&F){if(s!==a.JS){C.processingMode=g._sProcessingMode}var p="sap/ui/core/Fragment";var v=sap.ui.require(p);C.name=C.name||C.fragmentName;if(v){o=v.load(C)}else{o=new Promise(function(e,t){sap.ui.require([p],function(t){t.load(C).then(function(t){e(t)})},t)})}}else{var h=function(){var e;if(D){e=g;if(!F){if(j&&j.settings){Object.keys(C).forEach(function(e){if(j.settings.hasOwnProperty(e)){j.settings[e]=C[e];delete C[e]}})}}g.applySettings(C)}else{e=te(function(){var e=new u(C);return e})}n=B(F,e,N);return e};if(j&&j.fnRunWithPreprocessor){t=j.fnRunWithPreprocessor(h)}else{t=h()}}return o.then(function(e){return e||t}).then(function(t){if(_&&t.addStyleClass){t.addStyleClass(_)}if(!t){t=[]}else if(!Array.isArray(t)){t=[t]}if(U._supportInfo&&t){for(var r=0,i=t.length;r<i;r++){var a=t[r];if(a&&a.getId()){var o=U._supportInfo({context:e,env:{caller:"createRegularControls",nodeid:e.getAttribute("id"),controlid:a.getId()}}),s=X?X+",":"";s+=o;U._supportInfo.addSupportInfo(a.getId(),s)}}}if(K){t.forEach(function(t){if(W.getCompositeAggregationName){var n=e.getElementsByTagName(t.getMetadata().getCompositeAggregationName());for(var r=0;r<n.length;r++){e.removeChild(n[0])}}t._sapui_declarativeSourceInfo={xmlNode:e,xmlRootNode:g._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:W.getName()==="sap.ui.core.Fragment"?C["fragmentName"]:null}})}return n.then(function(){return t})})})}function oe(e,t){var n=X(e,I,O);e.setAttributeNS(I,n+":"+t,"true")}function se(e,t,n){if(t.getAttributeNS(I,"id")){return t.getAttribute("id")}else{return G(n?n:t.getAttribute("id"))}}function ue(e,t){t.setAttribute("id",G(t.getAttribute("id")));oe(t,"id")}}U._preprocessMetadataContexts=null;U._calculatedModelMapping=function(e,n,r){var i,a={},o=t.parse(e,n);function s(e){if(e.length%2===0){throw new Error("The last entry is no binding")}for(var t=1;t<=e.length;t=t+2){if(typeof e[t-1]=="string"){throw new Error("Binding expected not a string")}if(e[t]){if(typeof e[t]!="string"||e[t]!=","){throw new Error("Missing delimiter ','")}}}}if(o){if(!o.formatter){i=o;o={parts:[i]}}else{s(o.formatter.textFragments)}for(var u=0;u<o.parts.length;u++){i=o.parts[u];a[i.model]=a[i.model]||(r?[]:null);if(Array.isArray(a[i.model])){a[i.model].push(i)}else{a[i.model]=i}}}return a};return U},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/_IconRegistry", ["sap/ui/thirdparty/URI","sap/base/i18n/ResourceBundle","sap/base/Log","sap/base/util/fetch","sap/base/util/syncFetch","sap/base/util/isPlainObject","sap/ui/core/Lib","sap/ui/core/Theming","sap/ui/core/theming/ThemeHelper"],function(e,t,a,r,n,o,i,s,c){"use strict";var l="SAP-icons";var d="sap-icon";var u={undefined:{config:{fontFamily:l},metadataLoaded:true,deprecatedNames:new Set(["soccor","clinical-tast-tracker"])}};var p={undefined:{"accidental-leave":57344,account:57345,wrench:57346,"windows-doors":57347,"washing-machine":57348,visits:57349,video:57350,"travel-expense":122887,temperature:57352,task:122889,synchronize:57354,survey:122891,settings:57356,search:122893,"sales-document":122894,"retail-store":57359,refresh:57360,product:57361,present:57362,"ppt-attachment":57363,pool:57364,"pie-chart":57365,picture:57366,"photo-voltaic":57367,phone:57368,pending:57369,"pdf-attachment":57370,past:122907,"outgoing-call":57372,opportunity:57373,opportunities:122910,notes:57375,"money-bills":122912,map:57377,log:57378,"line-charts":57379,lightbulb:57380,leads:57381,lead:122918,laptop:57383,"kpi-managing-my-area":122920,"kpi-corporate-performance":122921,"incoming-call":57386,inbox:57387,"horizontal-bar-chart":57388,history:57389,"heating-cooling":57390,"gantt-bars":57391,future:122928,fridge:57393,fallback:57394,"expense-report":122931,"excel-attachment":57396,"energy-saving-lightbulb":57397,employee:57398,email:57399,edit:57400,duplicate:57401,download:57402,"doc-attachment":57403,dishwasher:57404,delete:57405,decline:57406,complete:122943,competitor:57408,"collections-management":57409,chalkboard:122946,cart:57411,card:57412,camera:57413,calendar:122950,begin:57415,basket:57416,"bar-chart":57417,attachment:57418,"arrow-top":57419,"arrow-right":57420,"arrow-left":57421,"arrow-bottom":57422,approvals:122959,appointment:57424,"alphabetical-order":122961,"along-stacked-chart":57426,alert:57427,addresses:57428,"address-book":122965,"add-filter":57430,"add-favorite":57431,add:57432,activities:122969,action:57434,accept:122971,hint:122972,group:57437,"check-availability":122974,"weather-proofing":57439,"payment-approval":122976,"batch-payments":122977,bed:57442,arobase:122979,"family-care":57444,favorite:57445,"navigation-right-arrow":57446,"navigation-left-arrow":57447,"e-care":57448,less:57449,lateness:57450,lab:57451,"internet-browser":57452,instance:57453,inspection:57454,"image-viewer":57455,home:57456,grid:57457,goalseek:57458,"general-leave-request":57459,"create-leave-request":57460,flight:57461,filter:57462,"favorite-list":57463,factory:57464,endoscopy:57465,"employee-pane":57466,"employee-approvals":123003,"email-read":57468,electrocardiogram:57469,documents:57470,decision:57471,database:57472,"customer-history":57473,customer:57474,"credit-card":57475,"create-entry-time":57476,contacts:57477,compare:57478,"clinical-order":57479,"chain-link":57480,"pull-down":57481,"cargo-train":57482,"car-rental":57483,"business-card":57484,"bar-code":57485,"folder-blank":57486,"passenger-train":57487,"question-mark":123024,world:57489,iphone:57490,ipad:57491,warning:57492,sort:57493,"course-book":57494,"course-program":57495,"add-coursebook":57496,print:57497,save:57498,play:123035,pause:57500,record:57501,response:57502,"pushpin-on":57503,"pushpin-off":57504,unfavorite:57505,"learning-assistant":57506,timesheet:57507,"time-entry-request":57508,list:57509,"action-settings":57510,share:57511,feed:57512,role:57513,flag:123050,post:57515,inspect:57516,"inspect-down":57517,"appointment-2":57518,"target-group":57519,"marketing-campaign":57520,notification:57521,"message-error":57521,comment:57522,"shipping-status":57523,collaborate:57524,shortcut:57525,"lead-outdated":123062,"tools-opportunity":57527,permission:57528,supplier:57529,"table-view":57530,"table-chart":57531,"switch-views":57532,"e-learning":57533,manager:57534,"switch-classes":57535,"simple-payment":123072,signature:57537,"sales-order-item":123074,"sales-order":123075,request:57540,receipt:57541,puzzle:57542,process:57543,private:57544,"popup-window":57545,"person-placeholder":57546,"per-diem":123083,"paper-plane":57548,"paid-leave":123085,"pdf-reader":123086,"overview-chart":57551,overlay:57552,"org-chart":57553,"number-sign":57554,"notification-2":57555,"my-sales-order":123092,meal:57557,loan:123094,"order-status":123095,"customer-order-entry":123096,performance:57561,menu:57562,"employee-lookup":57563,education:57564,"customer-briefing":57565,"customer-and-contacts":57566,"my-view":57567,accelerated:57568,"to-be-reviewed":57569,warning2:57570,"feeder-arrow":57571,"quality-issue":57572,"workflow-tasks":57573,create:57574,"home-share":57575,globe:123112,tags:57577,"work-history":57578,"x-ray":57579,"wounds-doc":57580,"web-cam":57581,waiver:123118,"vertical-bar-chart":57583,"upstacked-chart":57584,"trip-report":57585,microphone:57586,"unpaid-leave":123123,tree:57588,"toaster-up":57589,"toaster-top":57590,"toaster-down":57591,"time-account":57592,theater:57593,taxi:57594,"subway-train":57595,"study-leave":57596,stethoscope:57597,step:57598,sonography:57599,soccor:57600,soccer:57600,"physical-activity":57601,pharmacy:57602,"official-service":57603,"offsite-work":57604,"nutrition-activity":57605,newspaper:57606,"monitor-payments":123143,"map-2":57608,machine:57609,"mri-scan":57610,"end-user-experience-monitoring":57611,unwired:57612,"customer-financial-fact-sheet":123149,"retail-store-manager":57614,"Netweaver-business-client":57615,"electronic-medical-record":57616,"eam-work-order":123153,"customer-view":57618,"crm-service-manager":57619,"crm-sales":123156,widgets:123157,"commission-check":123158,"collections-insight":123159,"clinical-tast-tracker":57624,"clinical-task-tracker":57624,"citizen-connect":57625,"cart-approval":123162,"capital-projects":123163,"bo-strategy-management":57628,"business-objects-mobile":57629,"business-objects-explorer":57630,"business-objects-experience":57631,"bbyd-dashboard":57632,"bbyd-active-sales":123169,"business-by-design":123170,"business-one":123171,"sap-box":57636,"manager-insight":57637,"accounting-document-verification":123174,"hr-approval":123175,"idea-wall":57640,"Chart-Tree-Map":57641,"cart-5":57642,"cart-4":57643,wallet:57644,"vehicle-repair":57645,upload:57646,unlocked:57647,umbrella:57648,"travel-request":123185,"travel-expense-report":123186,"travel-itinerary":57651,"time-overtime":123188,"thing-type":57653,"technical-object":57654,tag:57655,syringe:57656,syntax:57657,suitcase:57658,simulate:57659,shield:57660,"share-2":57661,"sales-quote":123198,repost:57663,provision:57664,projector:57665,"add-product":57666,"pipeline-analysis":57667,"add-photo":57668,palette:57669,nurse:57670,"sales-notification":123207,mileage:57672,"meeting-room":57673,"media-forward":123210,"media-play":123211,"media-pause":57676,"media-reverse":123213,"media-rewind":123214,"measurement-document":57679,"measuring-point":57680,measure:57681,"map-3":57682,locked:57683,letter:57684,"journey-arrive":57685,"journey-change":57686,"journey-depart":57687,"it-system":57688,"it-instance":57689,"it-host":57690,"iphone-2":57691,"ipad-2":57692,inventory:57693,"insurance-house":57694,"insurance-life":57695,"insurance-car":57696,initiative:57697,incident:123234,"group-2":57699,goal:57700,"functional-location":57701,"full-screen":57702,form:57703,"fob-watch":57704,"blank-tag":57705,"family-protection":57706,folder:57707,"fax-machine":57708,example:57709,eraser:57710,"employee-rejections":57711,"drop-down-list":57712,"draw-rectangle":57713,document:57714,doctor:57715,"discussion-2":57716,discussion:57717,dimension:57718,"customer-and-supplier":57719,crop:57720,"add-contact":57721,"compare-2":57722,"color-fill":57723,collision:57724,curriculum:57725,"chart-axis":57726,"full-stacked-chart":57727,"full-stacked-column-chart":57728,"vertical-bar-chart-2":57729,"horizontal-bar-chart-2":57730,"horizontal-stacked-chart":57731,"vertical-stacked-chart":57732,"choropleth-chart":123269,"geographic-bubble-chart":123270,"multiple-radar-chart":57735,"radar-chart":57736,"crossed-line-chart":57737,"multiple-line-chart":57738,"multiple-bar-chart":57739,"line-chart":57740,"line-chart-dual-axis":57741,"bubble-chart":57742,"scatter-chart":57743,"multiple-pie-chart":57744,"column-chart-dual-axis":57745,"tag-cloud-chart":57746,"area-chart":57747,cause:57748,"cart-3":57749,"cart-2":57750,"bus-public-transport":57751,burglary:57752,building:57753,border:57754,bookmark:57755,badge:57756,"attachment-audio":57757,"attachment-video":57758,"attachment-html":57759,"attachment-photo":57760,"attachment-e-pub":57761,"attachment-zip-file":57762,"attachment-text-file":57763,"add-equipment":57764,"add-activity":123301,"activity-individual":57766,"activity-2":123303,"add-activity-2":123304,"activity-items":57769,"activity-assigned-to-goal":57770,"status-completed":57771,"status-positive":57771,"status-error":57772,"status-negative":57772,"status-inactive":57773,"status-in-process":57774,"status-critical":57774,"blank-tag-2":57775,"cart-full":57776,"locate-me":57777,paging:57778,"company-view":57779,"document-text":57780,explorer:57781,"personnel-view":57782,"sorting-ranking":57783,"drill-down":57784,"drill-up":57785,"vds-file":57786,"sap-logo-shape":123323,"folder-full":57788,"system-exit":57789,"system-exit-2":57790,"close-command-field":57791,"open-command-field":57792,"sys-enter-2":123329,"sys-enter":123330,"sys-help-2":123331,"sys-help":123332,"sys-back":57797,"sys-back-2":57798,"sys-cancel":57799,"sys-cancel-2":57800,"open-folder":57801,"sys-find-next":57802,"sys-find":57803,"sys-monitor":57804,"sys-prev-page":57805,"sys-first-page":57806,"sys-next-page":57807,"sys-last-page":57808,"generate-shortcut":57809,"create-session":57810,"display-more":57811,"enter-more":57812,"zoom-in":57813,"zoom-out":57814,header:57815,"detail-view":57816,"show-edit":57816,collapse:57817,expand:57818,positive:57819,negative:57820,display:57821,menu2:57822,redo:57823,undo:57824,"navigation-up-arrow":57825,"navigation-down-arrow":57826,down:57827,up:57828,shelf:57829,background:57830,resize:57831,move:57832,show:57833,hide:57834,"nav-back":57835,error:57836,"slim-arrow-right":57837,"slim-arrow-left":57838,"slim-arrow-down":57839,"slim-arrow-up":57840,forward:57841,overflow:57842,"value-help":57843,"multi-select":123380,"exit-full-screen":57845,"sys-add":57846,"sys-minus":57847,dropdown:57848,"expand-group":57849,"vertical-grip":57850,"horizontal-grip":57851,"sort-descending":57852,"sort-ascending":57853,"arrow-down":57854,legend:57855,"collapse-group":57856,"message-warning":57857,"message-information":123394,"message-success":123395,restart:57860,stop:57861,"add-process":57862,"cancel-maintenance":57863,activate:57864,"resize-horizontal":57865,"resize-vertical":57866,connected:57867,disconnected:57868,"edit-outside":57869,key:57870,minimize:57871,"back-to-top":57872,"hello-world":57873,outbox:57874,"donut-chart":57875,"heatmap-chart":57876,"horizontal-bullet-chart":57877,"vertical-bullet-chart":57878,call:57879,"download-from-cloud":57880,"upload-to-cloud":57881,jam:57882,"sap-ui5":57883,"message-popup":57884,cloud:57885,"horizontal-waterfall-chart":123422,"vertical-waterfall-chart":123423,"broken-link":57888,headset:57889,"thumb-up":123426,"thumb-down":123427,"multiselect-all":123428,"multiselect-none":123429,scissors:57894,sound:123431,"sound-loud":123432,"sound-off":123433,"date-time":123434,"user-settings":57899,"key-user-settings":57900,"developer-settings":57901,"text-formatting":123438,"bold-text":123439,"italic-text":123440,"underline-text":123441,"text-align-justified":123442,"text-align-left":123443,"text-align-center":123444,"text-align-right":123445,"bullet-text":123446,"numbered-text":123447,co:57912,"ui-notifications":57913,bell:57914,"cancel-share":57915,"write-new-document":57916,"write-new":57917,cancel:123454,"screen-split-one":57919,"screen-split-two":57920,"screen-split-three":57921,customize:57922,"user-edit":57923,"source-code":57924,copy:57925,paste:57926,"line-chart-time-axis":123463,"clear-filter":57928,reset:57929,"trend-up":57930,"trend-down":57931,"cursor-arrow":57932,"add-document":57933,"create-form":57934,"resize-corner":57935,"chevron-phase":57936,"chevron-phase-2":57937,"rhombus-milestone":57938,"rhombus-milestone-2":57939,"circle-task":57940,"circle-task-2":57941,"project-definition-triangle":57942,"project-definition-triangle-2":57943,"master-task-triangle":57944,"master-task-triangle-2":57945,"program-triangles":57946,"program-triangles-2":57947,"mirrored-task-circle":57948,"mirrored-task-circle-2":57949,"checklist-item":57950,"checklist-item-2":57951,checklist:57952,"checklist-2":57953,"chart-table-view":57954,"filter-analytics":57955,"filter-facets":57956,"filter-fields":57957,indent:57958,outdent:57959,heading1:123496,heading2:123497,heading3:123498,"decrease-line-height":57963,"increase-line-height":57964,fx:123501,"add-folder":57966,away:57967,busy:57968,"appear-offline":57969,blur:57970,pixelate:57971,"horizontal-combination-chart":57972,"add-employee":57973,"text-color":123510,"browse-folder":57975,"primary-key":57976,"two-keys":57977,strikethrough:57978,text:57979,responsive:57980,"desktop-mobile":57981,"table-row":57982,"table-column":57983,validate:123520,"keyboard-and-mouse":57985,touch:57986,"expand-all":57987,"collapse-all":57988,combine:57989,split:57990,megamenu:57991,feedback:57992,information:57993,s4hana:123530,translate:123531,"clear-all":57996,"command-line-interfaces":57997,sum:123534,"qr-code":123535,"space-navigation":58e3,"in-progress":123537,"not-editable":58002,heart:58003,"heart-2":58004,"tri-state":58005,"bookmark-2":58006,"detail-less":58007,"detail-more":58008,"flag-2":123545,"folder-2":58010,"paint-bucket":58011,"direction-arrows":58012,"non-binary":58013,female:58014,male:123551,"bell-2":58016,accessibility:58017,"high-priority":58018,da:123555,"da-2":123556,ai:123557,"gender-male-and-female":123648,rotate:58113,"locate-me-2":58114,"map-fill":58115,"cloud-check":123652,enablement:123653,"biometric-thumb":58118,"biometric-face":58119,"people-connected":58120,"light-mode":58121,"dark-mode":58122,"select-appointments":123659,"time-off":58124,"add-calendar":58125,currency:58126}};var m;function f(){if(!m){m=i.getResourceBundleFor("sap.ui.core")}return m}var h={sapIconFontFamily:l};h.get=function(){return p};h.getFontRegistry=function(){return u};h.addIcon=function(r,n,o){if(typeof o==="string"){o={fontFamily:arguments[2],content:arguments[3],overWrite:!!arguments[4],suppressMirroring:!!arguments[5]}}if(typeof n!=="string"){n=String(n)}n=n==="undefined"?undefined:n;if(!p[n]){p[n]={}}var i=p[n],s=i[r],c,l,u,m;if(s){if(n===undefined){a.warning("Icon with name '"+r+"' in built-in collection already exists and can not be overwritten.","sap.ui.core.IconPool");return}else if(!o.overWrite){a.warning("Icon with name '"+r+"' in collection '"+n+"' already exists. Specify 'iconInfo.overWrite' in order to overwrite.","sap.ui.core.IconPool");return}}c={protocol:d,hostname:n||r,path:n?r:undefined};if(Array.isArray(o.content)){l=o.content.map(y).join("")}else{l=y(o.content)}if(o.resourceBundle instanceof t){m="Icon."+r;if(o.resourceBundle.hasText(m)){u=o.resourceBundle.getText(m)}}s=i[r]={name:r,collection:n,uri:e.build(c),fontFamily:o.fontFamily,content:l,text:u||"",suppressMirroring:o.suppressMirroring,skipMirroring:o.suppressMirroring};return s};h.getIconURI=function(e,t){var a=this.getIconInfo(e,t);return a&&a.uri};h.getIconInfo=function(t,r,n){var o,i,s,c,l=h.isIconURI(t);if(!t){return}if(!n&&l){n=r}n=n||"sync";s=n==="async"||n==="mixed";function d(){var e=p[r];var a=e&&e[t];if(typeof a==="number"){p[r][t]=undefined;a=h.addIcon(t,r,{fontFamily:u[r].config.fontFamily,content:a&65535,suppressMirroring:!!(a&65536),resourceBundle:f()})}return a}if(l){o=e.parse(t);if(o.path.length===1){r=undefined;t=o.hostname}else{r=o.hostname;t=o.path.slice(1)}if(!t){return}}if(typeof r!=="string"){r=String(r)}r=r==="undefined"?undefined:r;i=d();if(i===undefined&&r!==undefined){c=h._loadFontMetadata(r,s)}if(s){if(c){return c.then(function(){i=d();if(!i){a.warning("Icon info for icon '"+t+"' in collection '"+r+"' could not be found")}return i})}else if(n==="async"){if(!i){a.warning("Icon info for icon '"+t+"' in collection '"+r+"' could not be found")}return Promise.resolve(i)}else{i=d()}}else{i=d()}if(!i){a.warning("Icon info for icon '"+t+"' in collection '"+r+"' could not be found")}return i};h.isIconURI=function(t){if(!t){return false}var a=e.parse(t);return a.protocol===d&&!!a.hostname};h.getIconCollectionNames=function(){return Object.keys(p)};h.getIconNames=function(e){var t=p[e],a=u[e]&&u[e].deprecatedNames,r=[];for(var n in t){if(t.hasOwnProperty(n)&&(!a||!a.has(n))){r.push(n)}}return r};h.insertFontFaceStyle=function(e,t,r){var n,o=h.getFontRegistry();function i(e){return h._convertUrl?h._convertUrl(e):e}if(arguments.length===0||e===l){a.info("It's not needed to call IconPool.insertFontFaceStyle to insert font-face for the predefined icon font SAP-icons because the font-face is included in the library.css of sap.ui.core");return}if(e&&t===undefined){a.error("IconPool.insertFontFaceStyle must be called with at least two parameters!");return}if(r===undefined){r=e}if(!o[r]){a.error("Icon font '"+r+"' has not been registered yet.");return}if(t==o[r].currentFontURI){a.info("The font face style of icon font '"+r+"' was already inserted.");return}o[r].currentFontURI=t;n=new FontFace(e,"url("+i(t+e+".woff2")+") format('woff2'),"+"local("+e+")",{weight:"normal",style:"normal"});document.fonts.add(n);n.load();o[r].fontFace=e};s.attachApplied(function(){for(const e in u){const t=u[e].themeConfig;if(!t){continue}const a=u[e].config;const r=g(t)||a.fontURI;h.insertFontFaceStyle(a.fontFamily,r,e)}});function g(e){let t;if(o(e)){const a=e["path"];const r=[s.getTheme()];const n=c.getMetadata("sap-ui-core");const o=n?.Extends[0];if(o){r.push(o)}r.some(e=>Object.keys(a).some(r=>{const n=new RegExp(r);if(n.test(e)){t=a[r];if(t.charAt(t.length-1)!=="/"){t+="/"}t=sap.ui.require.toUrl(t);return true}}))}return t}h._loadFontMetadata=function(e,t){var i,s=h.get(),c=h.getFontRegistry();if(c[e]){if(typeof c[e].metadataLoaded==="boolean"){return}if(t&&c[e].metadataLoaded instanceof Promise){return c[e].metadataLoaded}i=c[e].config}else{if(!s[e]){a.error("The font configuration for collection '"+e+"' is not registered")}c[e]={metadataLoaded:false}}function l(t){let r=t;let n=i.fontURI;if(t?.config&&o(t.config)){c[e].themeConfig=t.config;n=g(t.config)||i.fontURI;r=t.icons;if(!o(r)){a.error(`There is something wrong with the structure of the font metadata loaded from ${n}.`)}}for(const e in r){r[e]=parseInt(r[e],16)}s[e]=r;h.insertFontFaceStyle(i.fontFamily,n,e);c[e].metadataLoaded=true}var d=function(){a.error("An error occurred loading the font metadata for collection '"+e+"'");c[e].metadataLoaded=false};if(i){if(i.metadataURI===undefined){i.metadataURI=i.fontURI+i.fontFamily+".json"}if(t&&!i.metadata){if(c[e].metadataLoaded instanceof Promise){return c[e].metadataLoaded}if(s[e]===undefined){var u=new AbortController;c[e].abortController=u;c[e].metadataLoaded=r(i.metadataURI,{headers:{Accept:r.ContentTypes.JSON},signal:u.signal}).then(function(t){if(t.ok){return t.json().then(function(t){l(t);delete c[e].abortController})}throw new Error}).catch(function(e){if(e.name!=="AbortError"){d()}})}return c[e].metadataLoaded}if(!(t&&!i.metadata)&&i.metadataURI){if(c[e].abortController){c[e].abortController.abort("Replaced by sync request");c[e].abortController=null}a.warning("Synchronous loading of font meta data in IconPool, due to .getIconInfo() call"+" for '"+e+"'. Use loading mode 'async' to avoid this call.","SyncXHR",null,function(){return{type:"SyncXHR",name:"IconPool"}});try{var p=n(i.metadataURI,{headers:{Accept:n.ContentTypes.JSON}});if(p.ok){var m=p.json();l(m)}else{d()}}catch(e){d()}return}l(i.metadata)}};function y(e){return String.fromCharCode(typeof e==="number"?e:parseInt(e,16))}return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/boot", ["sap/base/Log","sap/base/config/_Configuration","sap/base/config/GlobalConfigurationProvider","sap/base/util/Deferred","sap/ui/core/boot/initDOM","sap/ui/core/boot/loadManifest","sap/ui/core/boot/onInit"],function(e,n,t,r,o,i){"use strict";var u=e.getLevel();e.setLevel(e.Level.WARNING);e.warning("sap-ui-boot.js: This is a private module, its API must not be used in production and is subject to change!");e.setLevel(u);var a=false;var s=new r;var c;var f={ready:function(e){if(e&&a){e()}else{s.promise.then(e)}return s.promise}};var l=o.run(f);var p=n.getWritableBootInstance();delete n.getWritableBootInstance;function v(e){e=e||[];var n=new Promise(function(n,t){sap.ui.require(e,function(){n(Array.from(arguments))},t)});return n}function b(e,n){return Promise.all(e.map(function(e){return e.run(n)}))}i().then(function(e){c=e;return v(c.preBoot)}).then(function(e){return b(e,p)}).then(function(){t.freeze();return v(c.boot)}).then(function(e){return b(e,f)}).then(function(){return v(c.postBoot)}).then(function(e){return Promise.all([b(e),l])}).then(function(){s.resolve();a=true}).catch(s.reject);return f},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/boot/initDOM", ["sap/base/Log","sap/ui/Device","sap/base/i18n/Localization","sap/ui/dom/_ready"],function(e,t,n,o){"use strict";function a(){var t=n.getRTL()?"rtl":"ltr";document.documentElement.setAttribute("dir",t);e.info("Content direction set to '"+t+"'",null,"sap.ui.core.boot")}function i(){var n=document.documentElement;var o=t.browser;var a=o.name;if(a){if(a===o.BROWSER.SAFARI&&o.mobile){a="m"+a}a=a+(o.version===-1?"":Math.floor(o.version));n.dataset.sapUiBrowser=a;e.debug("Browser-Id: "+a,null,"sap.ui.core.boot")}}function r(){var e=document.documentElement;e.dataset.sapUiOs=t.os.name+t.os.versionStr;var n=null;if(t.os.name===t.os.OS.IOS){n="sap-ios"}else if(t.os.name===t.os.OS.ANDROID){n="sap-android"}if(n){e.classList.add(n)}}function s(e){var t=document.createElement("div");t.textContent="bootstrapping UI5...";t.style.color="transparent";document.body.append(t);e.ready().then(function(){document.body.removeChild(t)})}return{run:function(e){return o().then(function(){a();i();r();s(e)})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/boot/loadCalendar", ["sap/base/config","sap/base/i18n/Localization","sap/base/util/LoaderExtensions"],function(e,a,n){"use strict";var r=new Promise(function(a,n){sap.ui.require(["sap/ui/core/date/"+e.get({name:"sapUiCalendarType",type:"string",defaultValue:"Gregorian"})],function(e){a(e)},n)});var i=new Promise(function(e,r){var i=a.getLanguageTag().language;n.loadResource("sap/ui/core/cldr/"+i+".json",{async:true,dataType:"text"}).then(function(a){var n={};n["sap/ui/core/cldr/"+i+".json"]=a;sap.ui.require.preload(n);e()})});return{run:function(){return Promise.all([r,i])}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/boot/loadManifest", ["sap/base/config","sap/base/util/LoaderExtensions"],function(t,o){"use strict";function e(t,o){var e=Object.assign({},t);delete o.boot;e.preBoot=e.preBoot?e.preBoot:[];e.preBoot=e.preBoot.concat(o.preBoot||[]);o.postBoot=o.postBoot?o.postBoot:[];e.postBoot=o.postBoot.concat(e.postBoot||[]);return e}function n(t){var r=o.loadResource(t,{async:true}).then(function(t){if(t.extends){return n(t.extends).then(function(o){return e(o,t)})}return t});return r}function r(){var o=t.get({name:"sapUiBootManifest",type:t.Type.String});return n(o)}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/boot/loadModules", ["sap/base/config"],function(e){"use strict";var n=Promise.resolve();var i=Promise.resolve();var r=[];var u=e.get({name:"sapUiModules",type:e.Type.StringArray});var a=e.get({name:"sapUiLibs",type:e.Type.StringArray});if(a.length>0){i=new Promise(function(e,n){sap.ui.require(["sap/ui/core/Lib"],function(n){e(n)},n)}).then(function(e){var n=[];a.forEach(function(i){n.push(e.load({name:i}))});return Promise.all(n)})}r.push(new Promise(function(e,n){sap.ui.require(["sap/ui/events/jquery/EventSimulation"],function(){e()})}));if(u.length>0){u.forEach(function(e){var n=/^\[([^\[\]]+)?\]$/.exec(e);r.push(new Promise(function(i,r){sap.ui.require([n&&n[1]||e],function(){i()},n?i:r)}))})}n=Promise.all(r);return{run:function(){return Promise.all([n,i])}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/boot/onInit", ["sap/base/config"],function(e){"use strict";var i;var n=e.get({name:"sapUiOnInit",type:e.Type.String});if(n){i=n.split("@");if(i.length>1){var r={};var t=/^.*[\/\\]/.exec(i[0])[0];t=t.substr(0,t.length-1);r[t]=i[1];sap.ui.loader.config({paths:r})}}return{run:function(){var e=Promise.resolve();if(n){e=new Promise(function(e,n){sap.ui.require([i[0]],e,n)})}return e}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/cache/CacheManager", ["./LRUPersistentCache","./CacheManagerNOP","sap/ui/Device","sap/base/config","sap/base/Log","sap/ui/performance/Measurement","sap/ui/performance/trace/Interaction"],function(e,n,t,s,r,i,a){"use strict";var o=s.getWritableInstance();function c(){return o.get({name:"sapUiXxCacheUse",type:s.Type.Boolean,defaultValue:true,external:true})}function u(e){o.set("sapUiXxCacheUse",e)}var h={_instance:null,_getInstance:function(){var e,n=b("_getInstance"),t=this;e=new Promise(function(e,s){var a;r.debug("Cache Manager: Initialization...");if(!h._instance){a=t._findImplementation();i.start(l,"CM",d);a.init().then(o,s);i.end(l,"CM")}else{o(h._instance)}function o(t){h._instance=t;n.endAsync();r.debug("Cache Manager initialized with implementation ["+h._instance.name+"], resolving _getInstance promise");e(t)}});n.endSync();return e},_findImplementation:function(){if(g()&&this._isSupportedEnvironment()){return e}else{r.debug("UI5 Cache Manager is switched off");return n}},set:function(e,n){var t,s=b("set",e);r.debug("Cache Manager: Setting value of type["+typeof n+"] with key ["+e+"]");t=this._callInstanceMethod("set",arguments).then(function e(){this.logResolved("set");s.endAsync()}.bind(this),function(n){r.error("Cache Manager: Setting key ["+e+"] failed. Error:"+n);s.endAsync();throw n});s.endSync();return t},get:function(e){var n,t=a.notifyAsyncStep(),s=b("get",e);r.debug("Cache Manager: Getting key ["+e+"]");n=this._callInstanceMethod("get",arguments).then(function e(n){this.logResolved("get");s.endAsync();return n}.bind(this),function(n){r.debug("Cache Manager: Getting key ["+e+"] failed. Error: "+n);s.endAsync();throw n}).finally(t);s.endSync();return n},has:function(e){var n,t=b("has",e);r.debug("Cache Manager: has key ["+e+"] called");n=this._callInstanceMethod("has",arguments).then(function e(n){this.logResolved("has");t.endAsync();return n}.bind(this));t.endSync();return n},del:function(e){var n,t=b("del",e);r.debug("Cache Manager: del called.");n=this._callInstanceMethod("del",arguments).then(function e(){this.logResolved("del");t.endAsync()}.bind(this),function(e){r.debug("Cache Manager: del failed. Error: "+e);t.endAsync();throw e});t.endSync();return n},delWithFilters:function(e){var n;r.debug("Cache Manager: delWithFilters called.");n=this._callInstanceMethod("delWithFilters",arguments).then(function e(){this.logResolved("delWithFilters")}.bind(this),function(e){r.debug("Cache Manager: delWithFilters failed. Error: "+e);throw e});return n},reset:function(){var e,n=b("reset");r.debug("Cache Manager: Reset called.");e=this._callInstanceMethod("reset",arguments).then(function e(){this.logResolved("reset");n.endAsync()}.bind(this),function(e){r.debug("Cache Manager: Reset failed. Error: "+e);n.endAsync();throw e});n.endSync();return e},_switchOff:function(){var e=this;return Promise.resolve().then(function(){y(e);u(false)})},_switchOn:function(){var e=this;return Promise.resolve().then(function(){if(!c()){y(e);u(true)}return Promise.resolve()})},_callInstanceMethod:function(e,n){var t,s="[sync ] _callInstanceMethod";i.start(s,"CM",d);if(this._instance){r.debug("Cache Manager: calling instance...");return this._instance[e].apply(this._instance,n)}r.debug("Cache Manager: getting instance...");t=this._getInstance().then(function t(s){return s[e].apply(s,n)});i.end(s);return t},_isSupportedEnvironment:function(){var e=[];if(this._bSupportedEnvironment==undefined){e.push({system:t.system.SYSTEMTYPE.DESKTOP,browserName:t.browser.BROWSER.CHROME,browserVersion:49});e.push({system:t.system.SYSTEMTYPE.DESKTOP,browserName:t.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:t.system.SYSTEMTYPE.TABLET,browserName:t.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:t.system.SYSTEMTYPE.PHONE,browserName:t.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:t.system.SYSTEMTYPE.TABLET,os:t.os.OS.ANDROID,browserName:t.browser.BROWSER.CHROME,browserVersion:80});e.push({system:t.system.SYSTEMTYPE.PHONE,os:t.os.OS.ANDROID,browserName:t.browser.BROWSER.CHROME,browserVersion:80});this._bSupportedEnvironment=e.some(function(e){var n=t.system[e.system],s=e.os?e.os===t.os.name:true,r=e.browserName===t.browser.name,i=t.browser.version>=e.browserVersion;try{return n&&s&&r&&i&&window.indexedDB}catch(e){return false}})}return this._bSupportedEnvironment},logResolved:function(e){this._instance.logResolved&&this._instance.logResolved(e)}};var d="CacheManager",l="[sync ] _initImplementation",f=0;function g(){return c()}function y(e){if(e._instance){e._instance._destroy();e._instance=null}}function b(e,n){f++;var t="[async]  "+e+"["+n+"]- #"+f,s="[sync ]  "+e+"["+n+"]- #"+f;i.start(t,"CM",[d,e]);i.start(s,"CM",[d,e]);return{sMeasureAsync:t,sMeasureSync:s,endAsync:function(){i.end(this.sMeasureAsync)},endSync:function(){i.end(this.sMeasureSync)}}}return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/cache/CacheManagerNOP", ["sap/base/Log"],function(e){"use strict";var n={name:"CacheManagerNOP",logResolved:function(n){e.debug("Cache Manager is not supported on this environment.")},set:function(){return Promise.resolve()},get:function(){return Promise.resolve(undefined)},has:function(){return Promise.resolve(false)},del:function(){return Promise.resolve()},delWithFilters:function(){return Promise.resolve()},reset:function(){return Promise.resolve()},init:function(){return Promise.resolve(this)},_db:{close:function(){}},_getCount:function(){return Promise.resolve(0)},_destroy:function(){}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/cache/LRUPersistentCache", ["sap/base/config","sap/base/Log","sap/ui/performance/Measurement","sap/ui/Global"],function(e,t,a,n){"use strict";var r={name:"LRUPersistentCache",logResolved:function(e){t.debug("Cache Manager: "+e+" completed successfully.")},defaultOptions:{databaseName:"ui5-cachemanager-db",_contentStoreName:"content-store",_metadataStoreName:"metadata-store",_metadataKey:"metadataKey"},_db:{},init:function(){this._metadata={};this._mru=-1;this._lru=-1;return g(this)},_destroy:function(){if(this._db.close){this._db.close()}this._metadata=null;this._ui5version=null},set:function(e,n){if(R(e)){t.warning("Cache Manager ignored 'set' for key ["+e+"]");return Promise.resolve()}if(e==null){return Promise.reject("Cache Manager does not accept undefined or null as key")}if(typeof n==="undefined"){return Promise.reject("Cache Manager does not accept undefined as value")}t.debug("Cache Manager LRUPersistentCache: adding item with key ["+e+"]...");var r=this,o="[sync ] fnSet: total[sync]  key ["+e+"]",i="[sync ] fnSet: txStart[sync]  key ["+e+"]",c="[sync ] fnSet: storeOpen[sync]  key ["+e+"]",u="[sync ] fnSet: putContent[sync]  key ["+e+"]",d="[sync ] fnSet: putMetadata[sync]  key ["+e+"]",l="[sync ] fnSet: serialize[sync]  key ["+e+"]";return new Promise(function f(m,_){a.start(o,"CM",s);var g,y,C,S,w;w=b(r._metadata);S=new p(e,n,typeof n,++r._mru,l,s).serialize();a.start(i,"CM",s);var P=r._db.transaction([r.defaultOptions._contentStoreName,r.defaultOptions._metadataStoreName],"readwrite");a.end(i);P.onerror=function(e){var a="Cache Manager cannot complete add/put transaction for entry with key: "+S.oData.key+". Details: "+L(e);t.error(a);r._metadata=w;M(r);_(a)};P.onabort=function(a){r._metadata=w;M(r);var o=v(r);if(D(a)&&o>0){t.warning("Cache Manager is trying to free some space to add/put new item");O(r,e,n).then(function(){t.debug("Cache Manager LRUPersistentCache: set completed after freeing space. ItemCount changed from "+o+" to "+v(r));m()},function(e){var a="Cache Manager LRUPersistentCache: set unsuccessful. Cannot free space to add/put entry. Details: "+e;t.error(a);_(a)})}else{var s="Cache Manager LRUPersistentCache: set failed: "+L(a);t.error(s);_(s)}};P.oncomplete=function(){t.debug("Cache Manager LRUPersistentCache: adding item with key ["+e+"]... done");m()};a.start(c,"CM",s);g=P.objectStore(r.defaultOptions._contentStoreName);C=P.objectStore(r.defaultOptions._metadataStoreName);a.end(c);a.start(u,"CM",s);y=g.put(S.oData,S.oData.key);a.end(u);a.end(o);y.onsuccess=function(){h(r,S);a.start(d,"CM",s);C.put(r._metadata,r.defaultOptions._metadataKey);a.end(d)};if(t.getLevel()>=t.Level.DEBUG){t.debug("Cache Manager LRUPersistentCache: measurements: "+o+": "+a.getMeasurement(o).duration+"; "+l+": "+a.getMeasurement(l).duration+"; "+i+": "+a.getMeasurement(i).duration+"; "+c+": "+a.getMeasurement(c).duration+"; "+u+": "+a.getMeasurement(u).duration+"; "+d+": "+a.getMeasurement(d).duration)}})},has:function(e){if(R(e)){t.warning("Cache Manager ignored 'has' for key ["+e+"]");return Promise.resolve(false)}return this.get(e).then(function(a){var n=typeof a!=="undefined";t.debug("Cache Manager: has key ["+e+"] returned "+n);return n})},_getCount:function(){return Promise.resolve(v(this))},_getAll:function(e){var t=this,a,n="[sync ] _getAll: deserialize";return new Promise(function(e,r){var s=[],i=t._db.transaction([t.defaultOptions._contentStoreName],"readonly"),c=i.objectStore(t.defaultOptions._contentStoreName);i.onerror=function(e){r(L(e))};i.oncomplete=function(t){e(s)};c.openCursor().onsuccess=function(e){var t=e.target.result;if(t&&t.value){a=new p(t.value,n,o).deserialize();s.push({key:a.oData.key,value:a.oData.value});t.continue()}}})},_loadMetaStructure:function(){var e=this;return new Promise(function(a,n){var r=e._db.transaction([e.defaultOptions._metadataStoreName],"readonly");r.onerror=function(e){if(!r.errorHandled){r.errorHandled=true;var a="Cache Manager cannot complete transaction for read metadata. Details: "+r.error;t.error(a);n(a)}};var o=r.objectStore(e.defaultOptions._metadataStoreName);try{var s=o.get(e.defaultOptions._metadataKey);s.onsuccess=function(n){e._metadata=s.result?s.result:C(e._ui5version);if(e._metadata.__ui5version!==e._ui5version){e.reset().then(a,function(e){t.error("Cannot reset the cache. Details:"+e);r.abort()})}else{if(!e._metadata.timestamps){e._metadata.timestamps={}}a()}};s.onerror=function(e){t.error("Cache Manager cannot complete transaction for read metadata items. Details: "+e.message);n(e.message)}}catch(a){t.error("Cache Manager cannot read metadata entries behind key: "+e.defaultOptions._metadataKey+". Details: "+a.message);n(a.message)}})},get:function(e){if(R(e)){t.warning("Cache Manager ignored 'get' for key ["+e+"]");return Promise.resolve()}return d(this,e)},del:function(e){if(R(e)){t.warning("Cache Manager ignored 'del' for key ["+e+"]");return Promise.resolve()}return u(this,e)},delWithFilters:function(e){var a=this,n=e||{};return new Promise(function(e,r){var o=b(a._metadata),s=a._db.transaction([a.defaultOptions._contentStoreName,a.defaultOptions._metadataStoreName],"readwrite"),i=s.objectStore(a.defaultOptions._contentStoreName),c=s.objectStore(a.defaultOptions._metadataStoreName),u=i.openCursor(),d=n.prefix||"";function l(){a._metadata=o;M(a)}function f(e){l();r(L(e))}s.onerror=f;s.onabort=f;s.oncomplete=function(t){e()};u.onsuccess=function(e){var r=e.target.result,o,s;if(!r){c.put(a._metadata,a.defaultOptions._metadataKey);return}o=r.value.key;if(o.indexOf(d)===0&&(!n.olderThan||!(o in a._metadata.timestamps)||a._metadata.timestamps[o]<=n.olderThan)){s=r.delete();s.onsuccess=function(){t.debug("Deleted "+o+"!");P(a,o)}}r.continue()}})},reset:function(){var e=this;return new Promise(function(a,r){var o,s,i,c,u;u=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");u.onerror=u.onabort=function(e){if(!u.errorHandled){u.errorHandled=true;var a="Cache Manager LRUPersistentCache: transaction for reset() failed. Details: "+u.error;t.error(a);r(a)}};u.oncomplete=function(e){a()};o=u.objectStore(e.defaultOptions._contentStoreName);s=u.objectStore(e.defaultOptions._metadataStoreName);try{i=o.clear();i.onerror=function(){u.abort()};i.onsuccess=function(){c=s.clear();c.onerror=function(){u.abort()};c.onsuccess=function(){e._metadata=C(n.version);M(e)}}}catch(e){u.abort()}})}};var o="LRUPersistentCache,get",s="LRUPersistentCache,set",i=0;function c(e,a){var n;e._metadata.timestamps[a.oData.key]=Date.now();n=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");n.onerror=n.onabort=function(e){t.warning("Cache Manager cannot persist the information about usage of an entry. This may lead to earlier removal of the entry if browser storage space is over. Details: "+n.error)};try{n.objectStore(e.defaultOptions._metadataStoreName).put(e._metadata,e.defaultOptions._metadataKey)}catch(e){t.warning("Cache Manager cannot persist the information about usage of an entry. This may lead to earlier removal of the entry if browser storage space is over. Details: "+e.message)}}function u(e,a){return new Promise(function(n,r){var o,s;o=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");s=b(e._metadata);function i(n){e._metadata=s;M(e);var o="Cache Manager LRUPersistentCache: cannot delete item with key: "+a+". Details: "+L(n);t.error(o);r(o)}o.onerror=i;o.onabort=i;o.oncomplete=function(){if(v(e)===0){e._lru=-1;e._mru=-1;e._metadata=C(e._ui5version)}t.debug("Cache Manager LRUPersistentCache: item with key "+a+" deleted");n()};t.debug("Cache Manager LRUPersistentCache: deleting item ["+a+"]");var c=o.objectStore(e.defaultOptions._contentStoreName).delete(a);c.onsuccess=function(){t.debug("Cache Manager LRUPersistentCache: request for deleting item ["+a+"] is successful, updating metadata...");P(e,a);o.objectStore(e.defaultOptions._metadataStoreName).put(e._metadata,e.defaultOptions._metadataKey)}})}function d(e,n){if(e.getCounter===undefined){e.getCounter=0}e.getCounter++;var r="[sync ] fnGet"+e.getCounter+": total[sync]  key ["+n+"]",s="[sync ] fnGet"+e.getCounter+": txStart[sync]  key ["+n+"]",i="[sync ] fnGet"+e.getCounter+": storeOpen[sync]  key ["+n+"]",u="[sync ] fnGet"+e.getCounter+": access result[sync]  key ["+n+"]",d="[sync ] fnGet"+e.getCounter+": putMetadata[sync]  key ["+n+"]",l="[sync ] fnGet"+e.getCounter+": deserialize[sync]  key ["+n+"]",f="[sync ]  _instance.get",m="[sync ]  getRequest.onSuccess";t.debug("Cache Manager LRUPersistentCache: get for key ["+n+"]...");a.start(f,"CM",o);var _=new Promise(function f(_,g){var y,C,b,M;a.start(r,"CM",o);a.start(s,"CM",o);C=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");a.end(s);C.onerror=function(e){var a="Cache Manager cannot complete delete transaction for entry with key: "+n+". Details: "+C.error;t.error(a);g(a)};try{a.start(i,"CM",o);b=C.objectStore(e.defaultOptions._contentStoreName).get(n);a.end(i);b.onsuccess=function(r){a.start(m,"CM",o);a.start(u,"CM",o);M=new p(b.result,l,o);a.end(u);I("Cache Manager LRUPersistentCache: accessing the result",n,u);if(M.oData){a.start(d,"CM",o);if(M.oData.lu!==e._mru){M.oData.lu=++e._mru;h(e,M)}c(e,M);a.end(d);y=M.deserialize().oData.value}a.end(m);t.debug("Cache Manager LRUPersistentCache: get for key ["+n+"]...done");_(y)};b.onerror=function(e){t.error("Cache Manager cannot get entry with key: "+n+". Details: "+e.message);g(e.message)}}catch(e){t.error("Cache Manager cannot get entry with key: "+n+". Details: "+e.message);g(e.message);return}a.end(r)});a.end(f);return _}function l(e){var a=S(e);if(a==undefined){var n="Cache Manager LRUPersistentCache: deleteItemAndUpdateMetadata cannot find item to delete";t.debug(n);return Promise.reject(n)}return m(e,a).then(function(){return Promise.resolve().then(function(){P(e,a);return f(e).then(function(){return a},function(){t.warning("Cache Manager LRUPersistentCache: Free space algorithm deleted item "+"but the metadata changes could not be persisted. This won't break the functionality.");return a})})})}function f(e){return new Promise(function(a,n){try{var r=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");r.onerror=o;r.onabort=o;r.oncomplete=function(){t.debug("Cache Manager LRUPersistentCache: persistMetadata - metadata was successfully updated");a()};r.objectStore(e.defaultOptions._metadataStoreName).put(e._metadata,e.defaultOptions._metadataKey)}catch(e){o(null,e)}function o(e,a){var r="Cache Manager LRUPersistentCache: persistMetadata error - metadata was not successfully persisted. Details: "+L(e)+". Exception: "+(a?a.message:"");t.debug(r);n(r)}})}function m(e,a){return new Promise(function(n,r){var o=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");function s(e){var n="Cache Manager LRUPersistentCache: internalDel cannot complete delete transaction for entry with key: "+a+". Details: "+L(e);t.warning(n);r(e)}o.onerror=s;o.onabort=s;o.oncomplete=function(){if(v(e)===0){e._lru=0;e._mru=0;e._metadata=C(e._ui5version)}t.debug("Cache Manager LRUPersistentCache: internalDel deleting item ["+a+"]...done");n()};t.debug("Cache Manager LRUPersistentCache: internalDel deleting item ["+a+"]...");o.objectStore(e.defaultOptions._contentStoreName).delete(a)})}function _(e,a,n){return new Promise(function(r,o){var i,c,u,d="[sync ] internalSet: serialize[sync]  key ["+a+"]";u=b(e._metadata);var l=new p(a,n,typeof n,++e._mru,d,s).serialize();t.debug("Cache Manager: LRUPersistentCache: internal set with parameters: key ["+l.oData.key+"], access index ["+l.oData.lu+"]");c=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");c.onerror=f;c.onabort=f;function f(a){t.debug("Cache Manager: LRUPersistentCache: internal set failed. Details: "+L(a));e._metadata=u;M(e);o(a)}c.oncomplete=function(){t.debug("Cache Manager: LRUPersistentCache: Internal set transaction completed. ItemCount: "+v(e));r()};i=c.objectStore(e.defaultOptions._contentStoreName).put(l.oData,l.oData.key);i.onsuccess=function(){h(e,l);c.objectStore(e.defaultOptions._metadataStoreName).put(e._metadata,e.defaultOptions._metadataKey)}})}function h(e,a){if(e._metadata.__byKey__[a.oData.key]!=null){var n=e._metadata.__byKey__[a.oData.key];delete e._metadata.__byIndex__[n];t.debug("Cache Manager LRUPersistentCache: set/internalset - item already exists, so its indexes are updated")}e._metadata.__byIndex__[a.oData.lu]=a.oData.key;e._metadata.__byKey__[a.oData.key]=a.oData.lu;k(e)}function g(e){e._ui5version=n.version;return new Promise(function a(n,r){var o;t.debug("Cache Manager "+"_initIndexedDB started");function s(){try{o=window.indexedDB.open(e.defaultOptions.databaseName,1)}catch(e){t.error("Could not open Cache Manager database. Details: "+e.message);r(e.message)}}s();o.onerror=function(e){t.error("Could not initialize Cache Manager database. Details: "+e.message);r(e.error)};o.onsuccess=function(a){var s=x("init_onsuccess");e._db=o.result;e._db.onversionchange=function(e){if(!e.newVersion){e.target.close()}};e._loadMetaStructure().then(function(){t.debug("Cache Manager "+" metadataLoaded. Serialization support: "+N()+", resolving initIndexDb promise");n(e)},r);s.endSync()};o.onupgradeneeded=function(a){var n=a.target.result;n.onerror=function(e){t.error("Cache Manager error. Details: "+e.message);r(n.error)};try{var o=n.createObjectStore(e.defaultOptions._contentStoreName);n.createObjectStore(e.defaultOptions._metadataStoreName)}catch(e){t.error("Could not initialize Cache Manager object store. Details: "+e.message);throw e}o.createIndex("ui5version","ui5version",{unique:false})}})}function y(e,t,a,n){this.key=e;this.sOrigType=a;this.value=t;this.lu=n}function p(e,t,a,n,r,o){if(arguments.length===3){this.oData=e;this.sMeasureId=t;this.sMsrCat=a}else{this.oData=new y(e,t,a,n)}}p.prototype.deserialize=function(){if(N()&&this.oData.sOrigType==="object"){a.start(this.sMeasureId,this.sMeasureId,this.sMsrCat);this.oData.value=JSON.parse(this.oData.value);a.end(this.sMeasureId);I("Cache Manager LRUPersistentCache: de-serialization the result",this.oData.key,this.sMeasureId)}return this};p.prototype.serialize=function(){if(N()&&this.oData.sOrigType==="object"){a.start(this.sMeasureId,this.sMeasureId,this.sMsrCat);this.oData.value=JSON.stringify(this.oData.value);a.end(this.sMeasureId);I("Cache Manager LRUPersistentCache: serialization of the value",this.oData.key,this.sMeasureId)}return this};function C(e){return{timestamps:{},__byKey__:{},__byIndex__:{},__ui5version:e}}function b(e){var t=C(e.__ui5version);for(var a in e.__byIndex__){t.__byIndex__[a]=e.__byIndex__[a]}for(var n in e.__byKey__){t.__byKey__[n]=e.__byKey__[n]}for(var n in e.timestamps){t.timestamps[n]=e.timestamps[n]}return t}function M(e){var a=w(e._metadata.__byIndex__);e._mru=a.mru;e._lru=a.lru;t.debug("Cache Manager LRUPersistentCache: LRU counters are assigned to the CM: "+JSON.stringify(a))}function v(e){return Object.keys(e._metadata.__byKey__).length}function S(e){var t=e._metadata.__byIndex__[e._lru];if(t==undefined&&!k(e)){return null}else{return e._metadata.__byIndex__[e._lru]}}function w(e){var t=-1,a=-1,n=Number.MAX_VALUE,r=Object.keys(e),o=r.length;if(o===0){return{mru:-1,lru:-1}}else{while(++t<o){var s=parseInt(r[t]);if(a<s){a=s}if(n>s){n=s}}return{mru:a,lru:n}}}function O(e,a,n){return new Promise(function(r,o){var s=0;i(e,a,n);function i(e,a,n){s++;t.debug("Cache Manager LRUPersistentCache: cleanAndStore: freeing space attempt ["+s+"]");l(e).then(function(s){t.debug("Cache Manager LRUPersistentCache: cleanAndStore: deleted item with key ["+s+"]. Going to put "+a);return _(e,a,n).then(r,function(r){if(D(r)){t.debug("Cache Manager LRUPersistentCache: cleanAndStore: QuotaExceedError during freeing up space...");if(v(e)>0){i(e,a,n)}else{o("Cache Manager LRUPersistentCache: cleanAndStore: even when the cache is empty, the new item with key ["+a+"] cannot be added")}}else{o("Cache Manager LRUPersistentCache: cleanAndStore: cannot free space: "+L(r))}})},o)}})}function D(e){return e&&e.target&&e.target.error&&e.target.error.name==="QuotaExceededError"}function P(e,t){var a=e._metadata.__byKey__[t];delete e._metadata.__byKey__[t];delete e._metadata.__byIndex__[a];if(e._metadata.timestamps[t]){delete e._metadata.timestamps[t]}k(e)}function k(e){while(e._lru<=e._mru&&e._metadata.__byIndex__[e._lru]==undefined){e._lru++}return e._lru<=e._mru}function L(e){if(!e){return""}var t=e.message;if(e.target&&e.target.error&&e.target.error.name){t+=" Error name: "+e.target.error.name}return t}function N(){return e.get({name:"sapUiXxCacheSerialization",type:e.Type.Boolean,external:true})}function U(){return e.get({name:"sapUiXxCacheExcludedKeys",type:e.Type.StringArray,external:true})}function R(e){return U().some(function(t){return e.indexOf(t)>-1})}function x(e,t){i++;var n="[async]  "+e+"["+t+"]- #"+i,r="[sync ]  "+e+"["+t+"]- #"+i;a.start(n,"CM",["LRUPersistentCache",e]);a.start(r,"CM",["LRUPersistentCache",e]);return{sMeasureAsync:n,sMeasureSync:r,endAsync:function(){a.end(this.sMeasureAsync)},endSync:function(){a.end(this.sMeasureSync)}}}function I(e,n,r){if(t.getLevel()>=t.Level.DEBUG){t.debug(e+" for key ["+n+"] took: "+a.getMeasurement(r).duration)}}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Buddhist", ["./UniversalDate","../CalendarType","./_Calendars"],function(t,e,r){"use strict";var n=t.extend("sap.ui.core.date.Buddhist",{constructor:function(){var t=arguments;if(t.length>1){t=u(t)}this.oDate=this.createDate(Date,t);this.sCalendarType=e.Buddhist}});n.UTC=function(){var t=u(arguments);return Date.UTC.apply(Date,t)};n.now=function(){return Date.now()};function a(r){var n=t.getEraStartDate(e.Buddhist,0).year,a=r.year-n+1;if(r.year<1941&&r.month<3){a-=1}if(r.year===null){a=undefined}return{year:a,month:r.month,day:r.day}}function i(r){var n=t.getEraStartDate(e.Buddhist,0).year,a=r.year+n-1;if(a<1941&&r.month<3){a+=1}if(r.year===null){a=undefined}return{year:a,month:r.month,day:r.day}}function u(t){var e,r;e={year:t[0],month:t[1],day:t[2]!==undefined?t[2]:1};r=i(e);t[0]=r.year;return t}n.prototype._getBuddhist=function(){var t={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return a(t)};n.prototype._setBuddhist=function(t){var e=i(t);return this.oDate.setFullYear(e.year,e.month,e.day)};n.prototype._getUTCBuddhist=function(){var t={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return a(t)};n.prototype._setUTCBuddhist=function(t){var e=i(t);return this.oDate.setUTCFullYear(e.year,e.month,e.day)};n.prototype.getYear=function(){return this._getBuddhist().year};n.prototype.getFullYear=function(){return this._getBuddhist().year};n.prototype.getUTCFullYear=function(){return this._getUTCBuddhist().year};n.prototype.setYear=function(t){var e=this._getBuddhist();e.year=t;return this._setBuddhist(e)};n.prototype.setFullYear=function(t,e,r){var n=this._getBuddhist();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setBuddhist(n)};n.prototype.setUTCFullYear=function(t,e,r){var n=this._getUTCBuddhist();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setUTCBuddhist(n)};r.set(e.Buddhist,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/CalendarUtils", ["sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/Configuration","sap/ui/core/LocaleData"],function(e,t,a){"use strict";var i={getWeekConfigurationValues:function(n,r){var u,o;if(!n){return i.getWeekConfigurationValues(t.getCalendarWeekNumbering(),r)}o=e.getWeekConfigurationValues(n);if(o){return o}if(n===e.Default){r=r||t.getFormatSettings().getFormatLocale();u=a.getInstance(r);return{firstDayOfWeek:u.getFirstDayOfWeek(),minimalDaysInFirstWeek:u.getMinimalDaysInFirstWeek()}}return undefined}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/CalendarWeekNumbering", ["sap/ui/base/DataType","sap/base/i18n/date/CalendarWeekNumbering"],function(e,a){"use strict";e.registerEnum("sap.ui.core.date.CalendarWeekNumbering",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Gregorian", ["./UniversalDate","../CalendarType","./_Calendars"],function(e,t,a){"use strict";var n=e.extend("sap.ui.core.date.Gregorian",{constructor:function(){this.oDate=this.createDate(Date,arguments);this.sCalendarType=t.Gregorian}});n.UTC=function(){return Date.UTC.apply(Date,arguments)};n.now=function(){return Date.now()};a.set(t.Gregorian,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Islamic", ["./UniversalDate","../CalendarType","sap/base/Log","sap/base/i18n/Formatting","./_Calendars"],function(t,e,a,r,o){"use strict";var n=t.extend("sap.ui.core.date.Islamic",{constructor:function(){var t=arguments;if(t.length>1){t=p(t)}this.oDate=this.createDate(Date,t);this.sCalendarType=e.Islamic}});n.UTC=function(){var t=p(arguments);return Date.UTC.apply(Date,t)};n.now=function(){return Date.now()};var i=1400,s=1721425.5,h=1948439.5,l=-425215872e5,f=864e5;var u=null;var c=["A","B"];function y(t){var e=t.year,a=t.month,r=t.day,o,n,i,l,f,u,c;u=0;if(a+1>2){u=v(e)?-1:-2}c=s-1+365*(e-1)+Math.floor((e-1)/4)+-Math.floor((e-1)/100)+Math.floor((e-1)/400)+Math.floor((367*(a+1)-362)/12+u+r);c=Math.floor(c)+.5;f=c-h;l=Math.floor(f/29.530588853);if(l<0){o=Math.floor(l/12)+1;n=l%12;if(n<0){n+=12}i=f-I(o,n)+1}else{l++;while(M(l)>f){l--}o=Math.floor(l/12)+1;n=l%12;i=f-M(12*(o-1)+n)+1}return{day:i,month:n,year:o}}function m(t){var e=t.year,a=t.month,r=t.day,o=e<1?I(e,a):M(12*(e-1)+a),n=r+o+h-1,i=Math.floor(n-.5)+.5,l=i-s,f=Math.floor(l/146097),u=C(l,146097),c=Math.floor(u/36524),y=C(u,36524),m=Math.floor(y/1461),p=C(y,1461),d=Math.floor(p/365),g=f*400+c*100+m*4+d,T,D,_,U,F,Y,w,b;if(!(c==4||d==4)){g++}_=s+365*(g-1)+Math.floor((g-1)/4)-Math.floor((g-1)/100)+Math.floor((g-1)/400);U=i-_;F=s-1+365*(g-1)+Math.floor((g-1)/4)-Math.floor((g-1)/100)+Math.floor((g-1)/400)+Math.floor(739/12+(v(g)?-1:-2)+1);w=0;if(i<F){w=0}else{w=v(g)?1:2}T=Math.floor(((U+w)*12+373)/367);Y=s-1+365*(g-1)+Math.floor((g-1)/4)-Math.floor((g-1)/100)+Math.floor((g-1)/400);b=0;if(T>2){b=v(g)?-1:-2}Y+=Math.floor((367*T-362)/12+b+1);D=i-Y+1;return{day:D,month:T-1,year:g}}function p(t){var e=Array.prototype.slice.call(t),a,r;a={year:t[0],month:t[1],day:t[2]!==undefined?t[2]:1};r=m(a);e[0]=r.year;e[1]=r.month;e[2]=r.day;return e}function d(){var t,e;u={};t=r.getABAPDateFormat();t=T(t)?t:"A";e=r.getCustomIslamicCalendarData();e=e||[];if(!e.length){a.warning("No calendar customizations.");return}e.forEach(function(e){if(e.dateFormat===t){var a=g(e.gregDate);var r=new Date(Date.UTC(a.year,a.month-1,a.day));var o=r.getTime();var n=(o-l)/f;a=g(e.islamicMonthStart);var i=(a.year-1)*12+a.month-1;u[i]=n}});a.info("Working with date format: ["+t+"] and customization: "+JSON.stringify(e))}function g(t){return{year:parseInt(t.substr(0,4)),month:parseInt(t.substr(4,2)),day:parseInt(t.substr(6,2))}}function M(t){if(!u){d()}var e=u[t];if(!e){var a=Math.floor(t/12)+1;var r=t%12;e=I(a,r)}return e}function I(t,e){return Math.ceil(29.5*e)+(t-1)*354+Math.floor((3+11*t)/30)}function C(t,e){return t-e*Math.floor(t/e)}function v(t){return!(t%400)||!(t%4)&&!!(t%100)}function T(t){return c.indexOf(t)!==-1}n.prototype._getIslamic=function(){return y({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()})};n.prototype._setIslamic=function(t){var e=m(t);return this.oDate.setFullYear(e.year,e.month,e.day)};n.prototype._getUTCIslamic=function(){return y({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()})};n.prototype._setUTCIslamic=function(t){var e=m(t);return this.oDate.setUTCFullYear(e.year,e.month,e.day)};n.prototype.getDate=function(t){return this._getIslamic().day};n.prototype.getMonth=function(){return this._getIslamic().month};n.prototype.getYear=function(){return this._getIslamic().year-i};n.prototype.getFullYear=function(){return this._getIslamic().year};n.prototype.setDate=function(t){var e=this._getIslamic();e.day=t;return this._setIslamic(e)};n.prototype.setMonth=function(t,e){var a=this._getIslamic();a.month=t;if(e!==undefined){a.day=e}return this._setIslamic(a)};n.prototype.setYear=function(t){var e=this._getIslamic();e.year=t+i;return this._setIslamic(e)};n.prototype.setFullYear=function(t,e,a){var r=this._getIslamic();r.year=t;if(e!==undefined){r.month=e}if(a!==undefined){r.day=a}return this._setIslamic(r)};n.prototype.getUTCDate=function(t){return this._getUTCIslamic().day};n.prototype.getUTCMonth=function(){return this._getUTCIslamic().month};n.prototype.getUTCFullYear=function(){return this._getUTCIslamic().year};n.prototype.setUTCDate=function(t){var e=this._getUTCIslamic();e.day=t;return this._setUTCIslamic(e)};n.prototype.setUTCMonth=function(t,e){var a=this._getUTCIslamic();a.month=t;if(e!==undefined){a.day=e}return this._setUTCIslamic(a)};n.prototype.setUTCFullYear=function(t,e,a){var r=this._getUTCIslamic();r.year=t;if(e!==undefined){r.month=e}if(a!==undefined){r.day=a}return this._setUTCIslamic(r)};o.set(e.Islamic,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Japanese", ["./UniversalDate","../CalendarType","./_Calendars"],function(e,t,a){"use strict";var n=e.extend("sap.ui.core.date.Japanese",{constructor:function(){var e=arguments;if(e.length>1){e=i(e)}this.oDate=this.createDate(Date,e);this.sCalendarType=t.Japanese}});n.UTC=function(){var e=i(arguments);return Date.UTC.apply(Date,e)};n.now=function(){return Date.now()};function r(a){var n=e.getEraByDate(t.Japanese,a.year,a.month,a.day),r=e.getEraStartDate(t.Japanese,n).year;return{era:n,year:a.year-r+1,month:a.month,day:a.day}}function o(a){var n=e.getEraStartDate(t.Japanese,a.era).year;return{year:n+a.year-1,month:a.month,day:a.day}}function i(a){var n,r,i,s=a[0];if(typeof s=="number"){if(s>=100){return a}else{i=e.getCurrentEra(t.Japanese);s=[i,s]}}else if(!Array.isArray(s)){s=[]}n={era:s[0],year:s[1],month:a[1],day:a[2]!==undefined?a[2]:1};r=o(n);a[0]=r.year;return a}n.prototype._getJapanese=function(){var e={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return r(e)};n.prototype._setJapanese=function(e){var t=o(e);return this.oDate.setFullYear(t.year,t.month,t.day)};n.prototype._getUTCJapanese=function(){var e={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return r(e)};n.prototype._setUTCJapanese=function(e){var t=o(e);return this.oDate.setUTCFullYear(t.year,t.month,t.day)};n.prototype.getYear=function(){return this._getJapanese().year};n.prototype.getFullYear=function(){return this._getJapanese().year};n.prototype.getEra=function(){return this._getJapanese().era};n.prototype.getUTCFullYear=function(){return this._getUTCJapanese().year};n.prototype.getUTCEra=function(){return this._getUTCJapanese().era};n.prototype.setYear=function(e){var t=this._getJapanese();t.year=e;return this._setJapanese(t)};n.prototype.setFullYear=function(e,t,a){var n=this._getJapanese();n.year=e;if(t!==undefined){n.month=t}if(a!==undefined){n.day=a}return this._setJapanese(n)};n.prototype.setEra=function(a,n,o,i){var s=e.getEraStartDate(t.Japanese,a),u=r(s);if(n!==undefined){u.year=n}if(o!==undefined){u.month=o}if(i!==undefined){u.day=i}return this._setJapanese(u)};n.prototype.setUTCFullYear=function(e,t,a){var n=this._getUTCJapanese();n.year=e;if(t!==undefined){n.month=t}if(a!==undefined){n.day=a}return this._setUTCJapanese(n)};n.prototype.setUTCEra=function(a,n,o,i){var s=e.getEraStartDate(t.Japanese,a),u=r(s);if(n!==undefined){u.year=n}if(o!==undefined){u.month=o}if(i!==undefined){u.day=i}return this._setUTCJapanese(u)};n.prototype.getWeek=function(t,a){return e.getWeekByDate(this.sCalendarType,this.oDate.getFullYear(),this.getMonth(),this.getDate(),t,a)};n.prototype.getUTCWeek=function(t,a){return e.getWeekByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate(),t,a)};a.set(t.Japanese,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Persian", ["./UniversalDate","../CalendarType","./_Calendars"],function(t,e,r){"use strict";var n=t.extend("sap.ui.core.date.Persian",{constructor:function(){var t=arguments;if(t.length>1){t=s(t)}this.oDate=this.createDate(Date,t);this.sCalendarType=e.Persian}});n.UTC=function(){var t=s(arguments);return Date.UTC.apply(Date,t)};n.now=function(){return Date.now()};var a=1300;function i(t){var e=f(t.year,t.month+1,t.day);return h(e)}function o(t){var e=y(t.year,t.month+1,t.day);return p(e)}function s(t){var e=Array.prototype.slice.call(t),r,n;if(typeof t[0]!=="number"||typeof t[1]!=="number"||t[2]!==undefined&&typeof t[2]!="number"){e[0]=NaN;e[1]=NaN;e[2]=NaN;return e}r={year:t[0],month:t[1],day:t[2]!==undefined?t[2]:1};n=o(r);e[0]=n.year;e[1]=n.month;e[2]=n.day;return e}function u(t){var e=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178],r=e.length,n=t+621,a=-14,i=e[0],o,s,u,y,h,f,p;for(p=1;p<r;p+=1){o=e[p];s=o-i;if(t<o){break}a=a+c(s,33)*8+c(d(s,33),4);i=o}f=t-i;a=a+c(f,33)*8+c(d(f,33)+3,4);if(d(s,33)===4&&s-f===4){a+=1}y=c(n,4)-c((c(n,100)+1)*3,4)-150;h=20+a-y;if(s-f<6){f=f-s+c(s+4,33)*33}u=d(d(f+1,33)-1,4);if(u===-1){u=4}return{leap:u,gy:n,march:h}}function y(t,e,r){while(e<1){e+=12;t--}while(e>12){e-=12;t++}var n=u(t);return f(n.gy,3,n.march)+(e-1)*31-c(e,7)*(e-7)+r-1}function h(t){var e=p(t).year,r=e-621,n=u(r),a=f(e,3,n.march),i,o,s;s=t-a;if(s>=0){if(s<=185){o=1+c(s,31);i=d(s,31)+1;return{year:r,month:o-1,day:i}}else{s-=186}}else{r-=1;s+=179;if(n.leap===1){s+=1}}o=7+c(s,30);i=d(s,30)+1;return{year:r,month:o-1,day:i}}function f(t,e,r){var n=c((t+c(e-8,6)+100100)*1461,4)+c(153*d(e+9,12)+2,5)+r-34840408;n=n-c(c(t+100100+c(e-8,6),100)*3,4)+752;return n}function p(t){var e,r,n,a,i;e=4*t+139361631;e=e+c(c(4*t+183187720,146097)*3,4)*4-3908;r=c(d(e,1461),4)*5+308;n=c(d(r,153),5)+1;a=d(c(r,153),12)+1;i=c(e,1461)-100100+c(8-a,6);return{year:i,month:a-1,day:n}}function c(t,e){return~~(t/e)}function d(t,e){return t-~~(t/e)*e}n.prototype._getPersian=function(){return i({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()})};n.prototype._setPersian=function(t){var e=o(t);return this.oDate.setFullYear(e.year,e.month,e.day)};n.prototype._getUTCPersian=function(){return i({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()})};n.prototype._setUTCPersian=function(t){var e=o(t);return this.oDate.setUTCFullYear(e.year,e.month,e.day)};n.prototype.getDate=function(t){return this._getPersian().day};n.prototype.getMonth=function(){return this._getPersian().month};n.prototype.getYear=function(){return this._getPersian().year-a};n.prototype.getFullYear=function(){return this._getPersian().year};n.prototype.setDate=function(t){var e=this._getPersian();e.day=t;return this._setPersian(e)};n.prototype.setMonth=function(t,e){var r=this._getPersian();r.month=t;if(e!==undefined){r.day=e}return this._setPersian(r)};n.prototype.setYear=function(t){var e=this._getPersian();e.year=t+a;return this._setPersian(e)};n.prototype.setFullYear=function(t,e,r){var n=this._getPersian();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setPersian(n)};n.prototype.getUTCDate=function(t){return this._getUTCPersian().day};n.prototype.getUTCMonth=function(){return this._getUTCPersian().month};n.prototype.getUTCFullYear=function(){return this._getUTCPersian().year};n.prototype.setUTCDate=function(t){var e=this._getUTCPersian();e.day=t;return this._setUTCPersian(e)};n.prototype.setUTCMonth=function(t,e){var r=this._getUTCPersian();r.month=t;if(e!==undefined){r.day=e}return this._setUTCPersian(r)};n.prototype.setUTCFullYear=function(t,e,r){var n=this._getUTCPersian();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setUTCPersian(n)};r.set(e.Persian,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/UI5Date", ["sap/ui/core/Configuration","sap/ui/core/format/TimezoneUtil"],function(t,e){"use strict";var n=["year","month","day","hour","minute","second","fractionalSecond"],o=/Z|GMT|:.*[\+|\-]|^([\+|\-]\d{2})?\d{4}(-\d{2}){0,2}$/,r=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],i=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],a={Sun:0,Mon:1,Tue:2,Wed:3,Thu:4,Fri:5,Sat:6};function s(t,e){return(t<0?"-":"")+Math.abs(t).toString().padStart(e,"0")}function u(t,e){var r=u._createDateInstance(t);Object.defineProperties(this,{sTimezoneID:{value:e},oDate:{value:r,writable:true},oDateParts:{value:undefined,writable:true}});if(isNaN(r)){return}if(t.length>1||t.length===1&&typeof t[0]==="string"&&!o.test(t[0])){this._setParts(n,[r.getFullYear(),r.getMonth(),r.getDate(),r.getHours(),r.getMinutes(),r.getSeconds(),r.getMilliseconds()])}}u.prototype=Object.create(Date.prototype,{constructor:{value:Date}});u.prototype[Symbol.toStringTag]="Date";u.prototype._getPart=function(t){var n;if(isNaN(this.oDate)){return NaN}this.oDateParts=this.oDateParts||e._getParts(this.oDate,this.sTimezoneID);if(t==="weekday"){return a[this.oDateParts.weekday]}n=parseInt(this.oDateParts[t]);if(t==="month"){n-=1}else if(t==="year"){if(this.oDateParts.era==="B"){n=1-n}}return n};u.prototype._setParts=function(t,n){var o,r,i,a,s,u,c={},h=Math.min(t.length,n.length);if(h===0){return this.setTime(NaN)}for(o=0;o<h;o+=1){u=parseInt(+n[o]);s=t[o];if(isNaN(u)){return this.setTime(NaN)}if(s==="month"){u+=1}else if(s==="year"){if(u<=0){u=1-u;c.era="B"}else{c.era="A"}}c[s]=u.toString()}if(this.oDateParts){r=this.oDateParts}else if(isNaN(this.oDate)){r={day:"1",fractionalSecond:"0",hour:"0",minute:"0",month:"1",second:"0"}}else{r=e._getParts(this.oDate,this.sTimezoneID)}c=Object.assign({},r,c);i=e._getDateFromParts(c);if(isNaN(i)){return this.setTime(NaN)}a=i.getTime()+e.calculateOffset(i,this.sTimezoneID)*1e3;return this.setTime(a)};u.prototype.clone=function(){return u.getInstance(this)};u.prototype.getDate=function(){return this._getPart("day")};u.prototype.getDay=function(){return this._getPart("weekday")};u.prototype.getFullYear=function(){return this._getPart("year")};u.prototype.getHours=function(){return this._getPart("hour")};u.prototype.getMilliseconds=function(){return this._getPart("fractionalSecond")};u.prototype.getMinutes=function(){return this._getPart("minute")};u.prototype.getMonth=function(){return this._getPart("month")};u.prototype.getSeconds=function(){return this._getPart("second")};u.prototype.getTimezoneOffset=function(){return e.calculateOffset(this.oDate,this.sTimezoneID)/60};u.prototype.getYear=function(){return this._getPart("year")-1900};u.prototype.setDate=function(t){return this._setParts(["day"],arguments)};u.prototype.setFullYear=function(t,e,n){return this._setParts(["year","month","day"],arguments)};u.prototype.setHours=function(t,e,n,o){return this._setParts(["hour","minute","second","fractionalSecond"],arguments)};u.prototype.setMilliseconds=function(t){return this._setParts(["fractionalSecond"],arguments)};u.prototype.setMinutes=function(t,e,n){return this._setParts(["minute","second","fractionalSecond"],arguments)};u.prototype.setMonth=function(t,e){return this._setParts(["month","day"],arguments)};u.prototype.setSeconds=function(t,e){return this._setParts(["second","fractionalSecond"],arguments)};u.prototype.setTime=function(t){this.oDateParts=undefined;return this.oDate.setTime(t)};u.prototype.setYear=function(t){var e=parseInt(t);e=e<0||e>99?e:e+1900;return this._setParts(["year"],[e])};u.prototype.toDateString=function(){if(isNaN(this.oDate)){return this.oDate.toDateString()}return r[this.getDay()]+" "+i[this.getMonth()]+" "+s(this.getDate(),2)+" "+s(this.getFullYear(),4)};u.prototype.toString=function(){if(isNaN(this.oDate)){return this.oDate.toString()}return this.toDateString()+" "+this.toTimeString()};u.prototype.toTimeString=function(){var t,e,n,o;if(isNaN(this.oDate)){return this.oDate.toTimeString()}o=this.getTimezoneOffset();n=o>0?"-":"+";t=Math.floor(Math.abs(o)/60);e=Math.abs(o)%60;return s(this.getHours(),2)+":"+s(this.getMinutes(),2)+":"+s(this.getSeconds(),2)+" GMT"+n+s(t,2)+s(e,2)};["getTime","getUTCDate","getUTCDay","getUTCFullYear","getUTCHours","getUTCMilliseconds","getUTCMinutes","getUTCMonth","getUTCSeconds","toGMTString","toISOString","toJSON","toUTCString","valueOf"].forEach(function(t){u.prototype[t]=function(){return this.oDate[t].apply(this.oDate,arguments)}});["toLocaleDateString","toLocaleString","toLocaleTimeString"].forEach(function(e){u.prototype[e]=function(n,o){return this.oDate[e](n||t.getLanguageTag(),Object.assign({timeZone:this.sTimezoneID},o))}});["setUTCDate","setUTCFullYear","setUTCHours","setUTCMilliseconds","setUTCMinutes","setUTCMonth","setUTCSeconds"].forEach(function(t){u.prototype[t]=function(){this.oDateParts=undefined;return this.oDate[t].apply(this.oDate,arguments)}});u._createDateInstance=function(t){if(t[0]instanceof Date){t[0]=t[0].valueOf()}return new(Function.prototype.bind.apply(Date,[].concat.apply([null],t)))};u.getInstance=function(){var n=t.getTimezone();if(n!==e.getLocalTimezone()){return new u(arguments,n)}return u._createDateInstance(arguments)};u.checkDate=function(n){if(isNaN(n.getTime())){throw new Error("The given Date is not valid")}if(!(n instanceof u)&&t.getTimezone()!==e.getLocalTimezone()){throw new Error("Configured time zone requires the parameter 'oDate' to be an instance of"+" sap.ui.core.date.UI5Date")}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/UniversalDate", ["sap/ui/base/Object","sap/ui/core/Configuration","sap/ui/core/LocaleData","./_Calendars","./CalendarUtils","./CalendarWeekNumbering","./UI5Date"],function(e,t,r,a,n,o,i){"use strict";var s=e.extend("sap.ui.core.date.UniversalDate",{constructor:function(){var e=s.getClass();return this.createDate(e,arguments)}});s.UTC=function(){var e=s.getClass();return e.UTC.apply(e,arguments)};s.now=function(){return Date.now()};s.prototype.createDate=function(e,t){if(e===Date){return i.getInstance.apply(null,t)}switch(t.length){case 0:return new e;case 1:return new e(t[0]instanceof Date?t[0].getTime():t[0]);case 2:return new e(t[0],t[1]);case 3:return new e(t[0],t[1],t[2]);case 4:return new e(t[0],t[1],t[2],t[3]);case 5:return new e(t[0],t[1],t[2],t[3],t[4]);case 6:return new e(t[0],t[1],t[2],t[3],t[4],t[5]);case 7:return new e(t[0],t[1],t[2],t[3],t[4],t[5],t[6])}};s.getInstance=function(e,r){var a,n;if(e instanceof s){e=e.getJSDate()}if(e&&isNaN(e.getTime())){throw new Error("The given date object is invalid")}if(!r){r=t.getCalendarType()}a=s.getClass(r);n=Object.create(a.prototype);n.oDate=e?i.getInstance(e):i.getInstance();n.sCalendarType=r;return n};s.getClass=function(e){if(!e){e=t.getCalendarType()}return a.get(e)};["getDate","getMonth","getFullYear","getYear","getDay","getHours","getMinutes","getSeconds","getMilliseconds","getUTCDate","getUTCMonth","getUTCFullYear","getUTCDay","getUTCHours","getUTCMinutes","getUTCSeconds","getUTCMilliseconds","getTime","valueOf","getTimezoneOffset","toString","toDateString","setDate","setFullYear","setYear","setMonth","setHours","setMinutes","setSeconds","setMilliseconds","setUTCDate","setUTCFullYear","setUTCMonth","setUTCHours","setUTCMinutes","setUTCSeconds","setUTCMilliseconds"].forEach(function(e){s.prototype[e]=function(){return this.oDate[e].apply(this.oDate,arguments)}});s.prototype.getJSDate=function(){return this.oDate};s.prototype.getCalendarType=function(){return this.sCalendarType};s.prototype.getEra=function(){return s.getEraByDate(this.sCalendarType,this.oDate.getFullYear(),this.oDate.getMonth(),this.oDate.getDate())};s.prototype.setEra=function(e){};s.prototype.getUTCEra=function(){return s.getEraByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.oDate.getUTCMonth(),this.oDate.getUTCDate())};s.prototype.setUTCEra=function(e){};s.prototype.getWeek=function(e,t){return s.getWeekByDate(this.sCalendarType,this.getFullYear(),this.getMonth(),this.getDate(),e,t)};s.prototype.setWeek=function(e,t,r){var a=s.getFirstDateOfWeek(this.sCalendarType,e.year||this.getFullYear(),e.week,t,r);this.setFullYear(a.year,a.month,a.day)};s.prototype.getUTCWeek=function(e,t){return s.getWeekByDate(this.sCalendarType,this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate(),e,t)};s.prototype.setUTCWeek=function(e,t,r){var a=s.getFirstDateOfWeek(this.sCalendarType,e.year||this.getFullYear(),e.week,t,r);this.setUTCFullYear(a.year,a.month,a.day)};s.prototype.getQuarter=function(){return Math.floor(this.getMonth()/3)};s.prototype.getUTCQuarter=function(){return Math.floor(this.getUTCMonth()/3)};s.prototype.getDayPeriod=function(){if(this.getHours()<12){return 0}else{return 1}};s.prototype.getUTCDayPeriod=function(){if(this.getUTCHours()<12){return 0}else{return 1}};s.prototype.getTimezoneShort=function(){if(this.oDate.getTimezoneShort){return this.oDate.getTimezoneShort()}};s.prototype.getTimezoneLong=function(){if(this.oDate.getTimezoneLong){return this.oDate.getTimezoneLong()}};var u=7*24*60*60*1e3;s.getWeekByDate=function(e,r,a,n,o,i){i=i||t.getCalendarWeekNumbering();f(i);o=o||t.getFormatSettings().getFormatLocale();var s=this.getClass(e);var u=c(s,r,o,i);var l=new s(s.UTC(r,a,n));var y,h,C,T,D;var d=g(i,o);if(d){y=p(u,l)}else{h=r-1;C=r+1;T=c(s,h,o,i);D=c(s,C,o,i);if(l>=D){r=C;y=0}else if(l<u){r=h;y=p(T,l)}else{y=p(u,l)}}return{year:r,week:y}};s.getFirstDateOfWeek=function(e,r,a,n,o){o=o||t.getCalendarWeekNumbering();f(o);n=n||t.getFormatSettings().getFormatLocale();var i=this.getClass(e);var s=c(i,r,n,o);var l=new i(s.valueOf()+a*u);var p=g(o,n);if(p&&a===0&&s.getUTCFullYear()<r){return{year:r,month:0,day:1}}return{year:l.getUTCFullYear(),month:l.getUTCMonth(),day:l.getUTCDate()}};function g(e,t){var a=r.getInstance(t);return(e===o.Default||e===o.WesternTraditional)&&a.firstDayStartsFirstWeek()}function f(e){if(typeof e==="object"){if(typeof e.firstDayOfWeek!=="number"||typeof e.minimalDaysInFirstWeek!=="number"){throw new TypeError("Week config requires firstDayOfWeek and minimalDaysInFirstWeek to be set")}}else if(!Object.values(o).includes(e)){throw new TypeError("Illegal format option calendarWeekNumbering: '"+e+"'")}}function l(e,t){if(typeof e==="object"&&typeof e.firstDayOfWeek==="number"&&typeof e.minimalDaysInFirstWeek==="number"){return e}return n.getWeekConfigurationValues(e,t)}function c(e,r,a,n){a=a||t.getFormatSettings().getFormatLocale();var o=l(n,a);var i=o.minimalDaysInFirstWeek;var s=o.firstDayOfWeek;var u=new e(e.UTC(r,0,1));var g=7;if(isNaN(u.getTime())){throw new Error("Could not determine the first day of the week, because the date "+"object is invalid")}while(u.getUTCDay()!==s){u.setUTCDate(u.getUTCDate()-1);g--}if(g<i){u.setUTCDate(u.getUTCDate()+7)}return u}function p(e,t){return Math.floor((t.valueOf()-e.valueOf())/u)}var y={};s.getEraByDate=function(e,t,r,a){var n=h(e),o=new Date(0).setUTCFullYear(t,r,a),i;for(var s=n.length-1;s>=0;s--){i=n[s];if(!i){continue}if(i._start&&o>=i._startInfo.timestamp){return s}if(i._end&&o<i._endInfo.timestamp){return s}}};s.getCurrentEra=function(e){var t=i.getInstance();return this.getEraByDate(e,t.getFullYear(),t.getMonth(),t.getDate())};s.getEraStartDate=function(e,t){var r=h(e),a=r[t]||r[0];if(a._start){return a._startInfo}};function h(e){var a=t.getFormatSettings().getFormatLocale(),n=r.getInstance(a),o=y[e];if(!o){var o=n.getEraDates(e);if(!o[0]){o[0]={_start:"1-1-1"}}for(var i=0;i<o.length;i++){var s=o[i];if(!s){continue}if(s._start){s._startInfo=C(s._start)}if(s._end){s._endInfo=C(s._end)}}y[e]=o}return o}function C(e){var t=e.split("-"),r,a,n;if(t[0]==""){r=-parseInt(t[1]);a=parseInt(t[2])-1;n=parseInt(t[3])}else{r=parseInt(t[0]);a=parseInt(t[1])-1;n=parseInt(t[2])}return{timestamp:new Date(0).setUTCFullYear(r,a,n),year:r,month:a,day:n}}return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/UniversalDateUtils", ["sap/ui/core/date/UniversalDate","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/base/assert","sap/ui/core/Configuration"],function(e,t,r,a,n){"use strict";function u(t){a(t instanceof e,"method accepts only instances of UniversalDate");return t.createDate(t.constructor,[t.getJSDate()])}var s={};s.getRange=function(e,t,r,a){if(a===undefined){a=true}if(isNaN(e)){throw new TypeError("duration is NaN, but is "+e)}e=Math.trunc(e);var n=s.resetStartTime(r==undefined?null:r),i;if(a){switch(t){case"MINUTE":case"HOUR":n=s.createNewUniversalDate();break;case"DAY":break;case"WEEK":n=s.getWeekStartDate(n);break;case"MONTH":n=s.getMonthStartDate(n);break;case"QUARTER":n=s.getQuarterStartDate(n);break;case"YEAR":n=s.getYearStartDate(n);break;default:throw new TypeError("invalid unit "+t)}}switch(t){case"MINUTE":i=u(n);i.setMinutes(n.getMinutes()+e);break;case"HOUR":i=u(n);i.setHours(n.getHours()+e);break;case"DAY":if(e>0){n.setDate(n.getDate()+1)}i=u(n);e=e==0?1:e;i.setDate(n.getDate()+e);break;case"WEEK":if(e>0){n.setDate(n.getDate()+7)}i=u(n);e=e==0?1:e;i.setDate(n.getDate()+e*7);break;case"MONTH":if(e>0){n.setMonth(n.getMonth()+1)}i=u(n);e=e==0?1:e;i.setMonth(n.getMonth()+e);break;case"QUARTER":if(e>0){n.setMonth(n.getMonth()+3)}i=u(n);e=e==0?1:e;i.setMonth(n.getMonth()+e*3);break;case"YEAR":if(e>0){n.setFullYear(n.getFullYear()+1)}i=u(n);e=e==0?1:e;i.setFullYear(n.getFullYear()+e);break;default:throw new TypeError("invalid unit "+t)}if(i.getTime()<n.getTime()){i=[n,n=i][0]}if(t==="HOUR"||t==="MINUTE"){return[n,i]}i.setDate(i.getDate()-1);return[s.resetStartTime(n),s.resetEndTime(i)]};s.getWeekStartDate=function(e,a){var i=a?new t(a):n.getFormatSettings().getFormatLocale(),g=r.getInstance(i),o=g.getFirstDayOfWeek();e=e?u(e):u(s.createNewUniversalDate());e.setDate(e.getDate()-e.getDay()+o);return s.resetStartTime(e)};s.getWeekLastDate=function(e,t){var r=s.getWeekStartDate(e,t);r.setDate(r.getDate()+6);return s.resetStartTime(r)};s.getMonthStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setDate(1);return s.resetStartTime(e)};s.getMonthEndDate=function(e){var t=s.getMonthStartDate(e);t.setMonth(t.getMonth()+1);t.setDate(0);return s.resetStartTime(t)};s.getQuarterStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setMonth(3*Math.floor(e.getMonth()/3));e.setDate(1);return s.resetStartTime(e)};s.getQuarterEndDate=function(e){var t=s.getQuarterStartDate(e);t.setMonth(t.getMonth()+3);t.setDate(0);return s.resetStartTime(t)};s.getYearStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setMonth(0);e.setDate(1);return s.resetStartTime(e)};s.getYearEndDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setFullYear(e.getFullYear()+1);e.setMonth(0);e.setDate(0);return s.resetStartTime(e)};s.resetStartTime=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setHours(0,0,0,0);return e};s.resetEndTime=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setHours(23,59,59,999);return e};s.createNewUniversalDate=function(){return new e};s._getDateFromWeekStartByDayOffset=function(t,r){var a=n.getCalendarType(),u=n.getFormatSettings().getFormatLocale(),i=s.createNewUniversalDate(),g=i.getWeek(u,t),o=e.getFirstDateOfWeek(a,g.year,g.week,u,t);if(r===undefined){r=0}return new e(o.year,o.month,o.day+r,0,0,0)};s.ranges={lastDays:function(e){return s.getRange(-e,"DAY")},lastMinutes:function(e){return s.getRange(-e,"MINUTE")},lastHours:function(e){return s.getRange(-e,"HOUR")},yesterday:function(){return s.getRange(-1,"DAY")},today:function(){return s.getRange(0,"DAY")},tomorrow:function(){return s.getRange(1,"DAY")},nextMinutes:function(e){return s.getRange(e,"MINUTE")},nextHours:function(e){return s.getRange(e,"HOUR")},nextDays:function(e){return s.getRange(e,"DAY")},lastWeeks:function(e,t){var r;if(t){r=s._getDateFromWeekStartByDayOffset(t);return s.getRange(-e,"WEEK",r,false)}return s.getRange(-e,"WEEK")},lastWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(-1,"WEEK",t,false)}return s.getRange(-1,"WEEK")},currentWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(0,"WEEK",t,false)}return s.getRange(0,"WEEK")},firstDayOfWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return[s.resetStartTime(t),s.resetEndTime(t)]}var r=s.getWeekStartDate();return[r,s.resetEndTime(r)]},lastDayOfWeek:function(e){var t,r;if(e){r=6;t=s._getDateFromWeekStartByDayOffset(e,r);return[t,s.resetEndTime(t)]}var a=s.getWeekLastDate();return[a,s.resetEndTime(a)]},nextWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(1,"WEEK",t,false)}return s.getRange(1,"WEEK")},nextWeeks:function(e,t){var r;if(t){r=s._getDateFromWeekStartByDayOffset(t);return s.getRange(e,"WEEK",r,false)}return s.getRange(e,"WEEK")},lastMonths:function(e){return s.getRange(-e,"MONTH")},lastMonth:function(){return s.getRange(-1,"MONTH")},currentMonth:function(){return s.getRange(0,"MONTH")},firstDayOfMonth:function(){var e=s.getMonthStartDate();return[e,s.resetEndTime(e)]},lastDayOfMonth:function(){var e=s.getMonthEndDate();return[e,s.resetEndTime(e)]},nextMonth:function(){return s.getRange(1,"MONTH")},nextMonths:function(e){return s.getRange(e,"MONTH")},lastQuarters:function(e){return s.getRange(-e,"QUARTER")},lastQuarter:function(){return s.getRange(-1,"QUARTER")},firstDayOfQuarter:function(){var e=s.getQuarterStartDate();return[e,s.resetEndTime(e)]},lastDayOfQuarter:function(){var e=s.getQuarterEndDate();return[e,s.resetEndTime(e)]},currentQuarter:function(){return s.getRange(0,"QUARTER")},nextQuarter:function(){return s.getRange(1,"QUARTER")},nextQuarters:function(e){return s.getRange(e,"QUARTER")},quarter:function(e){if(e<=2){return s.getRange(e-1,"QUARTER",s.getYearStartDate())}else{var t=s.getRange(e-2,"QUARTER",s.getYearStartDate());var r=t[1];r.setMilliseconds(1e3);return s.getRange(0,"QUARTER",r)}},lastYears:function(e){return s.getRange(-e,"YEAR")},lastYear:function(){return s.getRange(-1,"YEAR")},firstDayOfYear:function(){var e=s.getYearStartDate();return[e,s.resetEndTime(e)]},lastDayOfYear:function(){var e=s.getYearEndDate();return[e,s.resetEndTime(e)]},currentYear:function(){return s.getRange(0,"YEAR")},nextYear:function(){return s.getRange(1,"YEAR")},nextYears:function(e){return s.getRange(e,"YEAR")},yearToDate:function(){var e=s.createNewUniversalDate();return[s.getYearStartDate(e),s.resetEndTime(e)]},dateToYear:function(){var e=s.createNewUniversalDate();return[s.resetStartTime(e),s.resetEndTime(s.getYearEndDate(e))]}};return s});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/_Calendars", [],function(){"use strict";var e=new Map;var r={get:function(r){if(!e.has(r)){sap.ui.requireSync("sap/ui/core/date/"+r)}if(e.has(r)){return e.get(r)}throw new TypeError("Load required calendar 'sap/ui/core/date/"+r+"' in advance")},set:function(r,a){e.set(r,a)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/delegate/ItemNavigation", ["sap/base/i18n/Localization","sap/ui/base/EventProvider","sap/base/assert","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/core/Element","sap/ui/dom/jquery/Selectors"],function(e,t,s,i,o,jQuery,a){"use strict";var n=t.extend("sap.ui.core.delegate.ItemNavigation",{constructor:function(e,s,i){t.apply(this);this.oDomRef=null;if(e){this.setRootDomRef(e)}this.aItemDomRefs=[];if(s){this.setItemDomRefs(s)}this.iTabIndex=-1;this.iActiveTabIndex=i?-1:0;this.iFocusedIndex=-1;this.iSelectedIndex=-1;this.bCycling=true;this.bTableMode=false;this.iPageSize=-1;this._bMouseDownHappened=false;this.oDisabledModifiers={sapend:["alt","shift"],saphome:["alt","shift"]}}});n.Events={BeforeFocus:"BeforeFocus",AfterFocus:"AfterFocus",BorderReached:"BorderReached",FocusAgain:"FocusAgain",FocusLeave:"FocusLeave"};n.prototype.setDisabledModifiers=function(e){this.oDisabledModifiers=e;return this};n.prototype.getDisabledModifiers=function(e){return this.oDisabledModifiers};n.prototype.hasDisabledModifier=function(e){var t=this.oDisabledModifiers[e.type.replace("modifiers","")];if(Array.isArray(t)){for(var s=0;s<t.length;s++){if(e[t[s]+"Key"]){return true}}}return false};n.prototype.setRootDomRef=function(e){this.oDomRef=e;if(!jQuery(this.oDomRef).data("sap.INItem")){if(this.iFocusedIndex>=0){jQuery(this.oDomRef).attr("tabindex",this.iTabIndex)}else{jQuery(this.oDomRef).attr("tabindex",this.iActiveTabIndex)}}jQuery(this.oDomRef).data("sap.INRoot",this);return this};n.prototype.getRootDomRef=function(){return this.oDomRef};n.prototype.getItemDomRefs=function(){return this.aItemDomRefs};n.prototype.setItemDomRefs=function(e){s(typeof e==="object"&&typeof e.length==="number","aItemDomRefs must be an array of DOM elements");this.aItemDomRefs=e;if(this.iFocusedIndex>-1){var t=e.length;if(this.iFocusedIndex>t-1){this.iFocusedIndex=t-1}var i=document.activeElement;if(i&&i!=this.aItemDomRefs[this.iFocusedIndex]){for(var o=0;o<t;o++){if(i==this.aItemDomRefs[o]){this.iFocusedIndex=o;break}}}}for(var o=0;o<this.aItemDomRefs.length;o++){if(this.aItemDomRefs[o]){var a=jQuery(this.aItemDomRefs[o]);if(o==this.iFocusedIndex&&!a.data("sap.INRoot")){a.attr("tabindex",this.iActiveTabIndex)}else if(a.attr("tabindex")=="0"){a.attr("tabindex",-1)}a.data("sap.INItem",true);a.data("sap.InNavArea",true);if(a.data("sap.INRoot")&&o!=this.iFocusedIndex){a.data("sap.INRoot").setNestedItemsTabindex()}}}return this};n.prototype.setItemsTabindex=function(){for(var e=0;e<this.aItemDomRefs.length;e++){if(this.aItemDomRefs[e]){var t=jQuery(this.aItemDomRefs[e]);if(t.is(":sapFocusable")){if(e==this.iFocusedIndex&&!t.data("sap.INRoot")){t.attr("tabindex",this.iActiveTabIndex)}else{t.attr("tabindex",-1)}}}}return this};n.prototype.setNestedItemsTabindex=function(){if(jQuery(this.oDomRef).data("sap.INItem")){for(var e=0;e<this.aItemDomRefs.length;e++){if(this.aItemDomRefs[e]&&jQuery(this.aItemDomRefs[e]).attr("tabindex")=="0"){jQuery(this.aItemDomRefs[e]).attr("tabindex",-1)}}}return this};n.prototype.destroy=function(){if(this.oDomRef){jQuery(this.oDomRef).removeData("sap.INRoot");this.oDomRef=null}if(this.aItemDomRefs){for(var e=0;e<this.aItemDomRefs.length;e++){if(this.aItemDomRefs[e]){jQuery(this.aItemDomRefs[e]).removeData("sap.INItem");jQuery(this.aItemDomRefs[e]).removeData("sap.InNavArea")}}this.aItemDomRefs=null}this._bItemTabIndex=undefined;this.iFocusedIndex=-1};n.prototype.setCycling=function(e){this.bCycling=e;return this};n.prototype.setTableMode=function(e,t){this.bTableMode=e;this.bTableList=e?t:false;return this};n.prototype.setPageSize=function(e){this.iPageSize=e;return this};n.prototype.setSelectedIndex=function(e){this.iSelectedIndex=e;return this};n.prototype.setColumns=function(e,t){this.iColumns=e;this.bNoColumnChange=t;return this};n.prototype.setHomeEndColumnMode=function(e,t){this._bStayInRow=e;this._bCtrlEnabled=t;return this};n.prototype.focusItem=function(t,s,a){i.info("FocusItem: "+t+" iFocusedIndex: "+this.iFocusedIndex,"focusItem","ItemNavigation");if(t==this.iFocusedIndex&&this.aItemDomRefs[this.iFocusedIndex]==document.activeElement){this.fireEvent(n.Events.FocusAgain,{index:t,event:s});return}if(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){if(this.bTableMode){var h=t%this.iColumns;var f=t;if(s&&s.keyCode==o.ARROW_RIGHT){if(h<this.iColumns-1){t+=e.getRTL()?-1:1}}else if(s&&s.keyCode==o.ARROW_LEFT){if(h>1){t-=e.getRTL()?-1:1}}else{if(h>1){t-=1}}if(t!=f){this.focusItem(t,s)}}return}if(!this.fireEvent(n.Events.BeforeFocus,{index:t,event:s},true)){i.info("Focus prevented on ID: "+this.aItemDomRefs[this.iFocusedIndex].id,"focusItem","ItemNavigation");return}this.setFocusedIndex(t);this.bISetFocus=true;if(s&&jQuery(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot")){var r=jQuery(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot");r._sFocusEvent=s.type}i.info("Set Focus on ID: "+this.aItemDomRefs[this.iFocusedIndex].id,"focusItem","ItemNavigation");this.aItemDomRefs[this.iFocusedIndex].focus({preventScroll:a});this.fireEvent(n.Events.AfterFocus,{index:t,event:s})};n.prototype.setFocusedIndex=function(e){var t;if(this.aItemDomRefs.length<0){this.iFocusedIndex=-1;return this}if(e<0){e=0}if(e>this.aItemDomRefs.length-1){e=this.aItemDomRefs.length-1}jQuery(this.oDomRef).attr("tabindex",this.iTabIndex);if(this.iFocusedIndex!==-1&&this.aItemDomRefs.length>this.iFocusedIndex){jQuery(this.aItemDomRefs[this.iFocusedIndex]).attr("tabindex",-1);t=jQuery(this.aItemDomRefs[this.iFocusedIndex]);if(t.data("sap.INRoot")&&e!=this.iFocusedIndex){jQuery(t.data("sap.INRoot").aItemDomRefs[t.data("sap.INRoot").iFocusedIndex]).attr("tabindex",-1)}}this.iFocusedIndex=e;var s=this.aItemDomRefs[this.iFocusedIndex];t=jQuery(this.aItemDomRefs[this.iFocusedIndex]);if(!t.data("sap.INRoot")){jQuery(s).attr("tabindex",this.iActiveTabIndex)}return this};n.prototype.getFocusedDomRef=function(){return this.aItemDomRefs[this.iFocusedIndex]};n.prototype.getFocusedIndex=function(){return this.iFocusedIndex};n.prototype.onfocusin=function(e){var t=e.target;var s=0;if(t==this.oDomRef){if(!this._bItemTabIndex){this.setItemsTabindex();this._bItemTabIndex=true}if(this._bMouseDownHappened){return}var i;if(jQuery(this.oDomRef).data("sap.INItem")&&this._sFocusEvent&&!jQuery(this.oDomRef).data("sap.InNavArea")){switch(this._sFocusEvent){case"sapnext":i=0;break;case"sapprevious":i=this.aItemDomRefs.length-1;break;default:if(this.iSelectedIndex!=-1){i=this.iSelectedIndex}else if(this.iFocusedIndex!=-1){i=this.iFocusedIndex}else{i=0}break}this._sFocusEvent=undefined}else{if(this.iSelectedIndex!=-1){i=this.iSelectedIndex}else if(this.iFocusedIndex!=-1){i=this.iFocusedIndex}else{i=0}}this.focusItem(i,e);if(this.iFocusedIndex==-1){for(s=i+1;s<this.aItemDomRefs.length;s++){this.focusItem(s,e);if(this.iFocusedIndex==s){break}}if(this.iFocusedIndex==-1&&i>0){for(s=i-1;s>=0;s--){this.focusItem(s,e);if(this.iFocusedIndex==s){break}}}}e.preventDefault();e.stopPropagation()}else if(!this.bISetFocus){if(this.aItemDomRefs&&e.target!=this.aItemDomRefs[this.iFocusedIndex]){for(s=0;s<this.aItemDomRefs.length;s++){if(e.target==this.aItemDomRefs[s]){this.focusItem(s,e);break}}}else{this.fireEvent(n.Events.AfterFocus,{index:this.iFocusedIndex,event:e})}}this.bISetFocus=false};n.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!this.oDomRef||!this.oDomRef.contains(a.getElementById(e.relatedControlId).getFocusDomRef())){var t;if(this.iSelectedIndex!=-1){t=this.iSelectedIndex}else if(this.iFocusedIndex!=-1){t=this.iFocusedIndex}else{t=0}this.setFocusedIndex(t);var s;if(jQuery(this.oDomRef).data("sap.INItem")){var i;s=jQuery(this.oDomRef);while(!i){s=s.parent();if(s.data("sap.INRoot")){i=s.get(0)}}if(!e.relatedControlId||i.contains(a.getElementById(e.relatedControlId).getFocusDomRef())){jQuery(this.aItemDomRefs[this.iFocusedIndex]).attr("tabindex",-1)}}s=jQuery(this.oDomRef);if(s.data("sap.InNavArea")===false){s.data("sap.InNavArea",true)}this.fireEvent(n.Events.FocusLeave,{index:t,event:e})}};n.prototype.onmousedown=function(e){var t=e.target;var s=function(e,t){var s=false;var i=jQuery(e);while(!i.is(":sapFocusable")&&i.get(0)!=t){i=i.parent()}if(i.get(0)!=t){s=true}return s};if(this.oDomRef&&this.oDomRef.contains(t)){for(var i=0;i<this.aItemDomRefs.length;i++){var o=this.aItemDomRefs[i];if(o&&o.contains(t)){if(!this.bTableMode){this.focusItem(i,e,true)}else{if(o===t||!s(t,o)){this.focusItem(i,e,true)}}return}}if(t==this.oDomRef){this._bMouseDownHappened=true;var a=this;window.setTimeout(function(){a._bMouseDownHappened=false},20)}}};n.prototype.onsapnext=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(jQuery(this.oDomRef).data("sap.InNavArea")){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=this.iFocusedIndex,s=true,i=false;if(t>-1){if(this.bTableMode){var a=this.aItemDomRefs.length/this.iColumns,h=Math.floor(t/this.iColumns),f=t%this.iColumns;if(e.keyCode==o.ARROW_DOWN){if(h<a-1){t+=this.iColumns}}else{if(f<this.iColumns-1){t+=1}}}else{do{if(this.iColumns>1&&e.keyCode==o.ARROW_DOWN){if(t+this.iColumns>=this.aItemDomRefs.length){if(!this.bNoColumnChange){if(t%this.iColumns<this.iColumns-1){t=t%this.iColumns+1}else if(this.bCycling){t=0}}else{t=this.iFocusedIndex;i=true}}else{t=t+this.iColumns}}else{if(t==this.aItemDomRefs.length-1){if(jQuery(this.oDomRef).data("sap.INItem")){return}else if(this.bCycling){t=0}else{t=this.iFocusedIndex;i=true}}else{t++}}if(t===this.iFocusedIndex){if(s){s=false}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the next one")}}}while(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable"))}this.focusItem(t,e);if(i){this.fireEvent(n.Events.BorderReached,{index:t,event:e})}e.preventDefault();e.stopPropagation()}};n.prototype.onsapnextmodifiers=function(e){if(this.hasDisabledModifier(e)){return}this.onsapnext(e)};n.prototype.onsapprevious=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(jQuery(this.oDomRef).data("sap.InNavArea")){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=this.iFocusedIndex,s=true,i=false;var a=0;if(t>-1){if(this.bTableMode){var h=Math.floor(t/this.iColumns);a=t%this.iColumns;if(e.keyCode==o.ARROW_UP){if(h>0){t-=this.iColumns}}else{if(a>0){t-=1}}}else{do{if(this.iColumns>1&&e.keyCode==o.ARROW_UP){if(t-this.iColumns<0){if(!this.bNoColumnChange){a=0;if(t%this.iColumns>0){a=t%this.iColumns-1}else if(this.bCycling){a=Math.min(this.iColumns-1,this.aItemDomRefs.length-1)}if(t===0&&a===0){t=0}else{var f=Math.ceil(this.aItemDomRefs.length/this.iColumns);t=a+(f-1)*this.iColumns;if(t>=this.aItemDomRefs.length){t=t-this.iColumns}}}else{t=this.iFocusedIndex;i=true}}else{t=t-this.iColumns}}else{if(t==0){if(jQuery(this.oDomRef).data("sap.INItem")){return}else if(this.bCycling){t=this.aItemDomRefs.length-1}else{t=this.iFocusedIndex;i=true}}else{t--}}if(t==this.iFocusedIndex){if(s){s=false}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the previous one")}}}while(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable"))}this.focusItem(t,e);if(i){this.fireEvent(n.Events.BorderReached,{index:t,event:e})}e.preventDefault();e.stopPropagation()}};n.prototype.onsappreviousmodifiers=function(e){if(this.hasDisabledModifier(e)){return}this.onsapprevious(e)};n.prototype.onsappageup=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=0;var s=false;if(this.iPageSize>0){t=this.iFocusedIndex;if(t>-1){t=t-this.iPageSize;while(t>0&&!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){t--}if(t<0){if(!this.bNoColumnChange){t=0}else{t=this.iFocusedIndex;s=true}}this.focusItem(t,e)}}else if(this.bTableMode){t=this.iFocusedIndex%this.iColumns;this.focusItem(t,e)}if(s){this.fireEvent(n.Events.BorderReached,{index:t,event:e})}e.preventDefault();e.stopPropagation()};n.prototype.onsappagedown=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=0;var s=false;if(this.iPageSize>0){t=this.iFocusedIndex;if(t>-1){t=t+this.iPageSize;while(t<this.aItemDomRefs.length-1&&!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){t++}if(t>this.aItemDomRefs.length-1){if(!this.bNoColumnChange){t=this.aItemDomRefs.length-1}else{t=this.iFocusedIndex;s=true}}this.focusItem(t,e)}}else if(this.bTableMode){var i=this.aItemDomRefs.length/this.iColumns,o=this.iFocusedIndex%this.iColumns;t=(i-1)*this.iColumns+o;this.focusItem(t,e)}if(s){this.fireEvent(n.Events.BorderReached,{index:t,event:e})}e.preventDefault();e.stopPropagation()};n.prototype.onsaphome=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=0;var s=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){s=Math.floor(this.iFocusedIndex/this.iColumns);t=s*this.iColumns}}else{if((e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){s=Math.floor(this.iFocusedIndex/this.iColumns);t=s*this.iColumns}else{while(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){t++;if(t==this.aItemDomRefs.length){return}}}}this.focusItem(t,e);e.preventDefault();e.stopPropagation()};n.prototype.onsaphomemodifiers=function(e){if(this.hasDisabledModifier(e)){return}this.onsaphome(e)};n.prototype.onsapend=function(e){if(!this.oDomRef||!this.oDomRef.contains(e.target)){return}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return}var t=this.aItemDomRefs.length-1;var s=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){s=Math.floor(this.iFocusedIndex/this.iColumns);t=s*this.iColumns+this.iColumns-1}}else{if((e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){s=Math.floor(this.iFocusedIndex/this.iColumns);t=(s+1)*this.iColumns-1;if(t>=this.aItemDomRefs.length){t=this.aItemDomRefs.length-1}}else{while(!this.aItemDomRefs[t]||!jQuery(this.aItemDomRefs[t]).is(":sapFocusable")){t--;if(t<0){return}}}}this.focusItem(t,e);e.preventDefault();e.stopPropagation()};n.prototype.onsapendmodifiers=function(e){if(this.hasDisabledModifier(e)){return}this.onsapend(e)};n.prototype.setTabIndex0=function(){this.iTabIndex=0;this.iActiveTabIndex=0};n.prototype.onkeyup=function(e){if(e.keyCode==o.F2){var t=jQuery(this.oDomRef);if(t.data("sap.InNavArea")){t.data("sap.InNavArea",false)}else if(t.data("sap.InNavArea")===false){t.data("sap.InNavArea",true)}e.preventDefault();e.stopPropagation()}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/delegate/ScrollEnablement", ["sap/base/i18n/Localization","sap/ui/Device","sap/ui/base/Object","sap/ui/core/IntervalTrigger","sap/ui/core/ResizeHandler","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes"],function(t,i,o,e,s,jQuery,l){"use strict";var r=o.extend("sap.ui.core.delegate.ScrollEnablement",{constructor:function(t,i,e){o.apply(this);this._oControl=t;this._oControl.addDelegate(this);this._sContentId=i;this._sContainerId=e.scrollContainerId;this._bHorizontal=!!e.horizontal;this._bVertical=!!e.vertical;this._scrollX=0;this._scrollY=0;this._scrollCoef=.9;this._iLastMaxScrollTop=0;this._iScrollPaddingTop=0;h(this);if(this._init){this._init.apply(this,arguments)}},setHorizontal:function(t){this._bHorizontal=!!t;this._setOverflow&&this._setOverflow()},setVertical:function(t){this._bVertical=!!t;this._setOverflow&&this._setOverflow()},getHorizontal:function(){return this._bHorizontal},getVertical:function(){return this._bVertical},setBounce:function(t){},setPullDown:function(t){this._oPullDown=t;return this},setGrowingList:function(t,i,o){this._fnScrollLoadCallback=t;this._sScrollLoadDirection=i;this.onOverflowChange(o);return this},onOverflowChange:function(t){this._fnOverflowChangeCallback=t;if(!this._fnOverflowChangeCallback){this._deregisterOverflowMonitor()}},setOnAfterScrollToElement:function(t){this._fnAfterScrollToElement=t},setIconTabBar:function(t,i,o){this._oIconTabBar=t;if(i){this._fnScrollEndCallback=i.bind(t)}if(o){this._fnScrollStartCallback=o.bind(t)}return this},setScrollPaddingTop:function(t){if(typeof t==="number"){this._iScrollPaddingTop=t}},scrollTo:function(t,i,o,e){this._scrollX=t;this._scrollY=i;this._scrollTo(t,i,o,e);return this},getChildPosition:function(t){var i=t instanceof jQuery?t:jQuery(t),o=i.position(),e=i.offsetParent(),s;while(!e.is(this._$Container)&&!e.is("html")&&e.length){s=e.position();o.top+=s.top;o.left+=s.left;e=e.offsetParent()}return o},scrollToElement:function(t,i,o,e){o=o||[0,0];if(!this._$Container[0].contains(t)||t.style.display==="none"||t.offsetParent.nodeName.toUpperCase()==="HTML"){return this}o[1]-=this._iScrollPaddingTop;if(e&&this._isInScrollport(t,o)){return this}var s=jQuery(t),l=this.getChildPosition(s),r=this.getScrollLeft()+l.left+o[0],n=this.getScrollTop()+l.top+o[1];if(this._bFlipX){r=this.getScrollLeft()-(l.left-this._$Container.width())-s.width()}this._scrollTo(r,n,i,this._fnAfterScrollToElement);return this},destroy:function(){if(this._exit){this._exit()}if(this._oControl){this._oControl.removeDelegate(this);this._oControl=undefined}},refresh:function(){if(this._refresh){this._refresh()}},_useDefaultScroll:function(t){return t.isContentEditable},onkeydown:function(i){if(this._useDefaultScroll(i.target)){return}var o=this._$Container[0];if(i.altKey&&this.getHorizontal()){switch(i.keyCode){case l.PAGE_UP:this._customScrollTo(this._scrollX-o.clientWidth,this._scrollY,i);break;case l.PAGE_DOWN:this._customScrollTo(this._scrollX+o.clientWidth,this._scrollY,i);break}}if(i.ctrlKey&&!i.altKey){switch(i.keyCode){case l.ARROW_UP:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY-o.clientHeight*this._scrollCoef,i)}break;case l.ARROW_DOWN:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY+o.clientHeight*this._scrollCoef,i)}break;case l.ARROW_LEFT:if(this.getHorizontal()){this._customScrollTo(this._scrollX-o.clientWidth,this._scrollY,i)}break;case l.ARROW_RIGHT:if(this.getHorizontal()){this._customScrollTo(this._scrollX+o.clientWidth,this._scrollY,i)}break;case l.HOME:if(this.getHorizontal()){this._customScrollTo(0,this._scrollY,i)}if(this.getVertical()){this._customScrollTo(this._scrollX,0,i)}break;case l.END:var e=o.scrollWidth-o.clientWidth;var s=o.scrollHeight-o.clientHeight;if(!this.getHorizontal()){s=this._scrollY}if(!this.getVertical()){e=t.getRTL()?o.clientWidth-o.scrollWidth:this._scrollX}this._customScrollTo(e,s,i);break}}},_customScrollTo:function(t,i,o){var e=o.target.nodeName;if(e!="INPUT"&&e!="TEXTAREA"){o.preventDefault();o.setMarked();this._scrollTo(t,i)}}});var n={getScrollTop:function(){return this._scrollY||0},getScrollLeft:function(){return this._scrollX||0},getScrollHeight:function(){var t=this._$Container;return t&&t[0]?t[0].scrollHeight:0},getMaxScrollTop:function(){var t=this._$Container;return t&&t[0]?t[0].scrollHeight-t[0].clientHeight:-1},getContainerDomRef:function(){return this._$Container&&this._$Container[0]},_cleanup:function(){if(this._sResizeListenerId){s.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this._deregisterOverflowMonitor()},_setOverflow:function(){var t=this._$Container;if(!t||!t[0]){return}if(i.os.ios){t.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"scroll":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"scroll":"hidden").css("-webkit-overflow-scrolling","touch")}else{t.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"auto":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"auto":"hidden")}},_refresh:function(){var t=this._$Container;if(!(t&&t.length)){return}if(this._oPullDown&&this._oPullDown._bTouchMode){var i=this._oPullDown.getDomRef();if(i){i.style.marginTop=this._oPullDown._iState==2?"":"-"+i.offsetHeight+"px"}}if(t.scrollTop()!=this._scrollY){t.scrollTop(this._scrollY)}if(!(this._oPullDown&&this._oPullDown._bTouchMode)&&!this._fnScrollLoadCallback){s.deregister(this._sResizeListenerId);this._sResizeListenerId=null}},_onScroll:function(){var t=this._$Container,i=t.scrollTop(),o=i-this._scrollY;this._scrollX=t.scrollLeft();this._scrollY=i;if(this._fnScrollLoadCallback){if(this._sScrollLoadDirection=="Upwards"){if(o<0&&i<10){this._fnScrollLoadCallback()}}else if(o>=0&&t[0].scrollHeight-i-t[0].clientHeight<100){this._fnScrollLoadCallback()}}if(this._oIconTabBar&&this._fnScrollEndCallback){this._fnScrollEndCallback()}},_onStart:function(t){var i=this._$Container[0];if(!i){return}this._bDoDrag=this._bDragScroll;var o=t.touches?t.touches[0]:t;this._iX=o.pageX;this._iY=o.pageY;this._bPullDown=false;this._iDirection=""},_onTouchMove:function(t){var i=this._$Container[0];var o=t.touches?t.touches[0]:t;var e=o.pageX-this._iX;var s=o.pageY-this._iY;if(this._iDirection==""){if(e!=0||s!=0){this._iDirection=Math.abs(s)>Math.abs(e)?"v":"h"}if(this._oPullDown&&this._oPullDown._bTouchMode&&this._iDirection=="v"&&i.scrollTop<=1){if(s>Math.abs(e)){this._bPullDown=true}}}if(this._bPullDown===true){var l=this._oPullDown.getDomRef();var r=t.touches[0].pageY-this._iY-l.offsetHeight;if(r>20){r=20}l.style.marginTop=r+"px";this._oPullDown.doPull(r);t.preventDefault();this._bDoDrag=false}if(this._bDoDrag){var n=i.scrollLeft,h=i.scrollTop;if(this._bHorizontal){if(this._bFlipX){i.scrollLeft=n-this._iX+o.pageX}else{i.scrollLeft=n+this._iX-o.pageX}}if(this._bVertical){i.scrollTop=h+this._iY-o.pageY}if(i.scrollLeft!=n||i.scrollTop!=h){t.setMarked&&t.setMarked();t.preventDefault()}this._iX=o.pageX;this._iY=o.pageY;return}},_onEnd:function(t){if(this._oPullDown&&this._oPullDown._bTouchMode){this._oPullDown.doScrollEnd();this._refresh()}if(this._bDragScroll&&this._iDirection){t.setMarked&&t.setMarked()}},_onMouseDown:function(t){if(this._bDragScroll&&t.button==0){this._bScrolling=true;this._onStart(t)}},_onMouseMove:function(t){if(this._bScrolling){var i=t.originalEvent||t;var o=i.buttons||i.which;if(o==1||t.pressure){var e=this._$Container[0];if(this._bHorizontal){if(this._bFlipX){e.scrollLeft=e.scrollLeft-this._iX+t.pageX}else{e.scrollLeft=e.scrollLeft+this._iX-t.pageX}}if(this._bVertical){e.scrollTop=e.scrollTop+this._iY-t.pageY}this._iX=t.pageX;this._iY=t.pageY}}},_onMouseUp:function(){if(this._bScrolling){this._bScrolling=false;this._onEnd()}},onBeforeRendering:function(){if(this._sResizeListenerId){s.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this._deregisterOverflowMonitor();var t=this._$Container;if(t){if(t.height()>0){this._scrollX=t.scrollLeft();this._scrollY=t.scrollTop()}t.off()}},_checkOverflowChange:function(t){var i=this.getMaxScrollTop(),o=i>0&&this._iLastMaxScrollTop===0,e=i===0&&this._iLastMaxScrollTop>0,s=o||e;if(s){this._fnOverflowChangeCallback(o,i)}this._iLastMaxScrollTop=i},_registerOverflowMonitor:function(){this._fnOverflowChangeCallback&&e.addListener(this._checkOverflowChange,this)},_deregisterOverflowMonitor:function(){e.removeListener(this._checkOverflowChange,this)},onAfterRendering:function(){var t=this._$Container=this._sContainerId?jQuery(document.getElementById(this._sContainerId)):jQuery(document.getElementById(this._sContentId)).parent();var o=this._refresh;var e=t.is(":visible");t.addClass("sapUiScrollDelegate");this._setOverflow();if(this._scrollX!==0||this._scrollY!==0){this._scrollTo(this._scrollX,this._scrollY)}this._refresh();if(!e||this._oPullDown||this._fnScrollLoadCallback){this._sResizeListenerId=s.register(t[0],o.bind(this))}if(this._fnOverflowChangeCallback){this._iOverflowTimer&&window.cancelAnimationFrame(this._iOverflowTimer);this._iOverflowTimer=window.requestAnimationFrame(this._registerOverflowMonitor.bind(this))}t.on("scroll",this._onScroll.bind(this));var l=t[0];function r(t,i){t.split(" ").forEach(function(t){l&&l.addEventListener(t,i)})}function n(t){return t.pointerType=="touch"?this._onStart(t):this._onMouseDown(t)}function h(t){return t.pointerType=="touch"?this._onTouchMove(t):this._onMouseMove(t)}function c(t){return t.pointerType=="touch"?this._onEnd(t):this._onMouseUp(t)}if(i.support.pointer&&i.system.desktop){if(this._bDragScroll){r("pointerdown",n.bind(this));r("pointermove",h.bind(this));r("pointerup pointercancel pointerleave",c.bind(this))}}else if(i.support.touch){if(this._bDragScroll||this._oPullDown&&this._oPullDown._bTouchMode){t.on("touchcancel touchend",this._onEnd.bind(this)).on("touchstart",this._onStart.bind(this)).on("touchmove",this._onTouchMove.bind(this))}}else if(this._bDragScroll){t.on("mouseup mouseleave",this._onMouseUp.bind(this)).on("mousedown",this._onMouseDown.bind(this)).on("mousemove",this._onMouseMove.bind(this))}},_readActualScrollPosition:function(){if(this._$Container.width()>0){this._scrollX=this._$Container.scrollLeft()}if(this._$Container.height()>0){this._scrollY=this._$Container.scrollTop()}},_scrollTo:function(t,i,o,e){if(this._$Container.length>0){if(o>0){this._$Container.finish().animate({scrollTop:i,scrollLeft:t},{duration:o,complete:this._readActualScrollPosition.bind(this),always:e})}else{this._$Container.scrollTop(i);this._$Container.scrollLeft(t);this._readActualScrollPosition();e&&e()}}},_isInScrollport:function(t,i){var o=t.getBoundingClientRect(),e=this._$Container[0].getBoundingClientRect(),s=e.top-i[1];return Math.ceil(o.top)>=Math.floor(s)&&Math.floor(o.bottom)<=Math.ceil(e.bottom)}};function h(i){var o={_init:function(i,o,e){if(jQuery.event&&jQuery.event.special&&jQuery.event.special.swipe&&jQuery.event.special.swipe.scrollSupressionThreshold<120){jQuery.event.special.swipe.scrollSupressionThreshold=120}Object.assign(this,n);if(e.nonTouchScrolling===true){this._bDragScroll=true}if(t.getRTL()){this._scrollX=9999}},_exit:function(){if(this._cleanup){this._cleanup()}}};Object.assign(i,o)}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/dnd/DragAndDrop", ["../library","sap/ui/Device","sap/ui/core/Element","sap/ui/core/StaticArea","../UIArea","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,r,n,o,jQuery,i){"use strict";var a=e.dnd.RelativeDropPosition;var f={},g=null,s=null,u=null,l=[],c=[],d=null,p,D,h,v,m={},w,b,C;function E(e,t){if(!e){return}if(e.addStyleClass){e.addStyleClass(t)}else{e.$().addClass(t)}}function y(e,t){if(!e){return}if(e.removeStyleClass){e.removeStyleClass(t)}else{e.$().removeClass(t)}}function S(e,t){var n=r.closestTo(e.target,true);if(!n){return}var o=jQuery.Event(null,e);o.type=t;n.getUIArea()._handleEvent(o)}function A(e){return!e.disabled&&/^(input|textarea)$/.test(e.localName)}function O(e,t){if(!e||!e.getDragGhost){return}var r=e.getDragGhost();if(!r){return}if(!D){D=jQuery('<div class="sapUiDnDGhostContainer"></div>');jQuery(document.body).append(D)}D.append(r);window.setTimeout(function(){D.empty()},0);var n=t.originalEvent;n.dataTransfer.setDragImage(r,n.offsetX,n.offsetY)}function T(e){var t={},r,n=e.originalEvent.dataTransfer,o=function(e,t){n.setData(e,t)};return{setData:function(e,r){r=""+r;t[e]=r;o(e,r)},getData:function(e){return t[e]},setTextData:function(e){e=""+e;t["text/plain"]=e;t["text"]=e;o("text/plain",e);o("text",e)},getTextData:function(){return t["text/plain"]},setComplexData:function(e,r){t[e]=r},getComplexData:function(e){return t[e]},getIndicator:function(){return p&&p[0]},setIndicatorConfig:function(e){r=e},getIndicatorConfig:function(e){return r},getDragControl:function(){return g},getDropControl:function(){return u},setDropControl:function(e){u=e},getDropInfo:function(){return c[0]||null},getDropPosition:function(){return h}}}function x(e){g=s=u=d=null;h="";C=false;l=[];c=[]}function I(){if(p){return p}p=jQuery("<div class='sapUiDnDIndicator'></div>");jQuery(n.getDomRef()).append(p);return p}function B(){if(p){p.removeAttr("style");p.hide();m={}}}function R(e,t,r,n){if(!t){return}var o=u.getDropAreaRect?u.getDropAreaRect(n):t.getBoundingClientRect(),f=e.dragSession&&e.dragSession.getIndicatorConfig(),g=window.pageYOffset,s=window.pageXOffset,l=I(),c,d={},p={top:o.top+g,bottom:o.bottom+g,left:o.left+s,right:o.right+s,width:o.width,height:o.height};if(!r||r=="On"){c=a.On;n=""}else if(n=="Horizontal"){var D=e.pageX-p.left;d.height=p.height;d.top=p.top;if(r=="Between"){d.width="";if(D<p.width*.5){c=a.Before;d.left=p.left}else{c=a.After;d.left=p.right}}else if(r=="OnOrBetween"){if(D<p.width*.25){c=a.Before;d.left=p.left;d.width=""}else if(D>p.width*.75){c=a.After;d.left=p.right;d.width=""}else{c=a.On}}if(c!=a.On&&i.getRTL()){c=c==a.After?a.Before:a.After}}else{var h=e.pageY-p.top;d.width=p.width;d.left=p.left;if(r=="Between"){d.height="";if(h<p.height*.5){c=a.Before;d.top=p.top}else{c=a.After;d.top=p.bottom}}else if(r=="OnOrBetween"){if(h<p.height*.25){c=a.Before;d.top=p.top;d.height=""}else if(h>p.height*.75){c=a.After;d.top=p.bottom;d.height=""}else{c=a.On}}}if(f&&f.display=="none"){return c}if(c==a.On){d.top=p.top;d.left=p.left;d.width=p.width;d.height=p.height;r=c}else{r="Between"}if(m.top!=d.top||m.left!=d.left||m.width!=d.width||m.height!=d.height){l.attr("data-drop-layout",n);l.attr("data-drop-position",r);l.css(Object.assign(d,f));l.show();m=d}return c}function N(e){var t=e.getParent(),r=e.getDragDropConfig?e.getDragDropConfig():[],n=t&&t.getDragDropConfig?t.getDragDropConfig():[];return r.concat(n)}function U(e){var t=N(e);return t.filter(function(t){return t.isDraggable(e)})}function k(e,t,r){var n=N(e);t=t||[];return n.filter(function(e){return!e.isA("sap.ui.core.dnd.IDragInfo")}).concat(t).filter(function(n){if(!n.isDroppable(e,r)){return false}var o=n.getGroupName();if(!o){return true}return t.some(function(e){return e.getGroupName()==o})})}function P(e,t){e.preventDefault();if(g){var r=t.getDropEffect().toLowerCase();e.originalEvent.dataTransfer.dropEffect=r}}function M(e,t,r){var n=t.getTargetAggregation();if(!n){return R(e,r.getDomRef())}var o;if(e.getMark("DragWithin")==n){o=r.getDomRefForSetting(n)}o=o||r.getDomRef();return R(e,o,t.getDropPosition(true),t.getDropLayout(true))}f.preprocessEvent=function(e){if(d&&e.type.indexOf("dr")==0){e.dragSession=d}var t="onbefore"+e.type;if(f[t]){f[t](e)}};f.postprocessEvent=function(e){var t="onafter"+e.type;if(f[t]){f[t](e)}};f.onbeforemousedown=function(e){if(t.browser.firefox&&A(e.target)){w=jQuery(e.target).closest("[data-sap-ui-draggable=true]").prop("draggable",false)[0]}};f.onbeforemouseup=function(e){if(w){w.draggable=true;w=null}};f.onbeforedragstart=function(e){if(!e.target.draggable){return}if(A(document.activeElement)){e.target.getAttribute("data-sap-ui-draggable")&&e.preventDefault();return}g=r.closestTo(e.target,true);if(!g){return}l=U(g);if(!l.length){return}if(!t.system.desktop&&!e.originalEvent.dataTransfer.getData("text")){e.originalEvent.dataTransfer.setData("text"," ")}e.dragSession=d=T(e)};f.onafterdragstart=function(e){if(!l.length||e.isDefaultPrevented()){x();return}l=e.isMarked("NonDraggable")?[]:l.filter(function(t){return t.fireDragStart(e)});if(!l.length){e.preventDefault();x();return}O(g,e);E(g,"sapUiDnDDragging");if(jQuery(e.target).closest(".sapUiScrollDelegate")[0]){jQuery("html").addClass("sapUiDnDNoScrolling")}};f.onbeforedragenter=function(e){var t=r.closestTo(e.target,true);if(t&&s===t){e.setMark("DragWithin","SameControl")}else{v=Date.now();s=t}var n=[],o;u=t;for(var i=0;i<20&&u;i++){n=k(u,l,e);if(n.length){break}o=u.getDomRef();o=o&&o.parentElement;u=r.closestTo(o,true)}if(e.getMark("DragWithin")!="SameControl"){c=n;if(d){d.setIndicatorConfig(null)}}if(!c.length){u=null}else if(!d){C=true;e.dragSession=d=T(e)}};f.onafterdragenter=function(e){if(!u||e.isMarked("NonDroppable")){c=[]}else if(e.getMark("DragWithin")!="SameControl"){c=c.filter(function(t){return t.fireDragEnter(e)})}var t=c[0];if(!t||t.getDropEffect()=="None"){B();h=""}else{P(e,t);h=M(e,t,u)}};f.onbeforedragover=function(e){var t=Date.now();if(t-v>=1e3){S(e,"longdragover");v=t}};f.onafterdragover=function(e){var t=c[0];if(!t||t.getDropEffect()=="None"){return}c.forEach(function(t){t.fireDragOver(e)});P(e,t);if(t&&t.getDropPosition(true)=="On"){return}h=M(e,t,u)};f.onafterdragleave=function(e){if(C&&!e.relatedTarget){B();x()}};f.onbeforedrop=function(e){if(c.length){e.preventDefault()}};f.onafterdrop=function(e){c.forEach(function(t){t.fireDrop(e)});b=requestAnimationFrame(this.onafterdragend.bind(this,e))};f.onafterdragend=function(e){b=cancelAnimationFrame(b);l.forEach(function(t){t.fireDragEnd(e)});y(g,"sapUiDnDDragging");jQuery("html").removeClass("sapUiDnDNoScrolling");B();x()};o.addEventPreprocessor(f.preprocessEvent);o.addEventPostprocessor(f.postprocessEvent);return f},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/dnd/DragDropBase", ["sap/base/Log","../Element","../library","./DragAndDrop"],function(e,t){"use strict";var a=t.extend("sap.ui.core.dnd.DragDropBase",{metadata:{abstract:true,library:"sap.ui.core",properties:{groupName:{type:"string",defaultValue:null,invalidate:false},enabled:{type:"boolean",defaultValue:true,invalidate:false}}}});a.prototype.bIgnoreMetadataCheck=false;a.prototype.isDraggable=function(e){return false};a.prototype.isDroppable=function(e,t){return false};a.prototype.checkMetadata=function(t,a,r){if(this.bIgnoreMetadataCheck){return true}var n=t.getMetadata().getDragDropInfo(a);if(!n[r]){e.warning((a?a+" aggregation of ":"")+t+" is not configured to be "+r);return false}return true};a.prototype.setProperty=function(e,a,r){r=r==undefined?(this.getMetadata().getProperty(e).appData||{}).invalidate===false:r;return t.prototype.setProperty.call(this,e,a,r)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/dnd/DragDropInfo", ["sap/ui/core/Element","./DragInfo","./DropInfo","sap/base/Log"],function(e,t,r,a){"use strict";var n=r.extend("sap.ui.core.dnd.DragDropInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDragInfo","sap.ui.core.dnd.IDropInfo"],properties:{sourceAggregation:{type:"string",defaultValue:null}},associations:{targetElement:{type:"sap.ui.core.Element",multiple:false}},events:{dragStart:{allowPreventDefault:true},dragEnd:{}}}});t.Mixin.apply(n.prototype);n.prototype.getDropTarget=function(){var t=this.getTargetElement();if(t){return e.getElementById(t)}return this.getParent()};n.prototype.setGroupName=function(){a.error("groupName property must not be set on "+this);return this};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/dnd/DragInfo", ["./DragDropBase"],function(t){"use strict";var e=t.extend("sap.ui.core.dnd.DragInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDragInfo"],properties:{sourceAggregation:{type:"string",defaultValue:null}},events:{dragStart:{allowPreventDefault:true},dragEnd:{}}}});e.Mixin=function(){this.isDraggable=function(t){if(!this.getEnabled()){return false}var e=this.getParent();if(!e){return false}var r=this.getSourceAggregation();if(!this.checkMetadata(e,r,"draggable")){return false}if(e===t&&!r||t.getParent()===e&&r===t.sParentAggregationName){return t.isDragAllowed&&!t.isDragAllowed(this)?false:true}return false};this.fireDragStart=function(t){if(!t||!t.dragSession){return}var e=t.dragSession;return this.fireEvent("dragStart",{dragSession:e,browserEvent:t.originalEvent,target:e.getDragControl()},true)};this.fireDragEnd=function(t){if(!t||!t.dragSession){return}var e=t.dragSession;return this.fireEvent("dragEnd",{dragSession:e,browserEvent:t.originalEvent,target:e.getDragControl()})};this.setEnabled=function(t){this.setProperty("enabled",t,false);this.invalidateDraggables();return this};this.setParent=function(){t.prototype.setParent.apply(this,arguments);this.invalidateDraggables();return this};this.setSourceAggregation=function(t){var e=this.getSourceAggregation();if(e==t){return this}e&&this.invalidateDraggables();this.setProperty("sourceAggregation",t,false);this.invalidateDraggables();return this};this.invalidateDraggables=function(){var t=this.getParent();if(t&&t.bOutput==true){var e=this.getSourceAggregation();if(e){[].concat(t.getAggregation(e)).forEach(function(t){if(t&&t.bOutput==true){t.invalidate()}})}else{t.invalidate()}}}};e.Mixin.apply(e.prototype);return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/dnd/DropInfo", ["./DragDropBase"],function(r){"use strict";var t=r.extend("sap.ui.core.dnd.DropInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDropInfo"],properties:{targetAggregation:{type:"string",defaultValue:null,invalidate:false},dropEffect:{type:"sap.ui.core.dnd.DropEffect",defaultValue:"Move",invalidate:false},dropPosition:{type:"sap.ui.core.dnd.DropPosition",defaultValue:"On",invalidate:false},dropLayout:{type:"sap.ui.core.dnd.DropLayout",defaultValue:"Default",invalidate:false}},events:{dragEnter:{allowPreventDefault:true},dragOver:{},drop:{}}}});t.prototype.getDropTarget=function(){return this.getParent()};t.prototype.isDroppable=function(r,t){this.sTemporaryDropPosition="";if(!this.getEnabled()){return false}var e=this.getDropTarget();if(!e){return false}var o=this.getTargetAggregation();if(!this.checkMetadata(e,o,"droppable")){return false}var o=this.getTargetAggregation();if(e===r&&!o){return true}if(r.getParent()===e&&o===r.sParentAggregationName){return true}if(t&&o&&e===r){var a=r.getDomRefForSetting(o);if(a&&a!=t.target&&a.contains(t.target)){t.setMark("DragWithin",o);this.sTemporaryDropPosition="On";return true}}return false};t.prototype.getDropPosition=function(r){if(r&&this.sTemporaryDropPosition){return this.sTemporaryDropPosition}return this.getProperty("dropPosition")};t.prototype.getDropLayout=function(r){var t=this.getProperty("dropLayout");if(!r||t!="Default"){return t}return this.getDropTarget().getMetadata().getDragDropInfo(this.getTargetAggregation()).layout};t.prototype.fireDragEnter=function(r){if(!r||!r.dragSession){return}var t=r.dragSession;return this.fireEvent("dragEnter",{dragSession:r.dragSession,browserEvent:r.originalEvent,target:t.getDropControl()},true)};t.prototype.fireDragOver=function(r){if(!r||!r.dragSession){return}var t=r.dragSession;return this.fireEvent("dragOver",{dragSession:r.dragSession,browserEvent:r.originalEvent,target:t.getDropControl(),dropPosition:t.getDropPosition()})};t.prototype.fireDrop=function(r){if(!r||!r.dragSession){return}var t=r.dragSession;this.fireEvent("drop",{dragSession:r.dragSession,browserEvent:r.originalEvent,dropPosition:t.getDropPosition(),draggedControl:t.getDragControl(),droppedControl:t.getDropControl()})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/format/DateFormat", ["sap/base/Log","sap/base/strings/formatMessage","sap/base/util/deepEqual","sap/base/util/extend","sap/ui/core/CalendarType","sap/ui/core/Configuration","sap/ui/core/Core","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/Supportability","sap/ui/core/date/CalendarUtils","sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/date/UI5Date","sap/ui/core/date/UniversalDate","sap/ui/core/format/TimezoneUtil"],function(e,t,a,r,n,i,o,s,l,u,f,c,d,h,m){"use strict";var g=function(){throw new Error};var p={DATE:"date",TIME:"time",DATETIME:"datetime",DATETIME_WITH_TIMEZONE:"datetimeWithTimezone"};var y={};var v=function(e){if(typeof e!=="string"&&!(e instanceof String)&&e!=null){throw new TypeError("The given timezone must be a string.")}};g.oDateInfo={type:p.DATE,oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(e,t,a){return e.getDatePattern(t,a)},oRequiredParts:{text:true,year:true,weekYear:true,month:true,day:true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date"]};g.oDateTimeInfo={type:p.DATETIME,oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(e,t,a){var r=t.indexOf("/");if(r>0){return e.getCombinedDateTimePattern(t.substr(0,r),t.substr(r+1),a)}else{return e.getCombinedDateTimePattern(t,t,a)}},oRequiredParts:{text:true,year:true,weekYear:true,month:true,day:true,hour0_23:true,hour1_24:true,hour0_11:true,hour1_12:true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date","DayPeriod","Hours","Minutes","Seconds"]};g._getDateTimeWithTimezoneInfo=function(e){var t=e.showDate===undefined||e.showDate;var a=e.showTime===undefined||e.showTime;var r=e.showTimezone===undefined||e.showTimezone;var n=g.oDateTimeInfo;if(t&&!a){n=g.oDateInfo}else if(!t&&a){n=g.oTimeInfo}return Object.assign({},n,{type:p.DATETIME_WITH_TIMEZONE,getTimezonePattern:function(e){if(!t&&!a&&r){return"VV"}else if(!r){return e}else{return e+" VV"}},getPattern:function(e,i,o){if(!t&&!a&&r){return"VV"}if(!r){return n.getPattern(e,i,o)}var s=n.getPattern(e,i,o);return e.applyTimezonePattern(s)}})};g.oTimeInfo={type:p.TIME,oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(e,t,a){return e.getTimePattern(t,a)},oRequiredParts:{text:true,hour0_23:true,hour1_24:true,hour0_11:true,hour1_12:true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["DayPeriod","Hours","Minutes","Seconds"]};g.getInstance=function(e,t){return this.getDateInstance(e,t)};g.getDateInstance=function(e,t){return this.createInstance(e,t,this.oDateInfo)};g.getDateTimeInstance=function(e,t){return this.createInstance(e,t,this.oDateTimeInfo)};g.getDateTimeWithTimezoneInstance=function(e,t){if(e&&!(e instanceof s)){(function(){e=Object.assign({},e);if(typeof e.showTimezone==="string"){var t=e.showTimezone;if(e.showDate===undefined&&e.showTime===undefined){if(t==="Hide"){e.showTimezone=false}else if(t==="Only"){e.showDate=false;e.showTime=false}}e.showTimezone=t!=="Hide"}})();if(e.showDate===false&&e.showTime===false&&e.showTimezone===false){throw new TypeError("Invalid Configuration. One of the following format options must be true: "+"showDate, showTime or showTimezone.")}}return this.createInstance(e,t,g._getDateTimeWithTimezoneInfo(e||{}))};g.getTimeInstance=function(e,t){return this.createInstance(e,t,this.oTimeInfo)};g.createInstance=function(e,t,a,n){var o,u,f;u=Object.create(this.prototype);if(e instanceof s){t=e;e=undefined}if(!t){t=i.getFormatSettings().getFormatLocale()}u.oLocale=t;u.oLocaleData=l.getInstance(t);u.oFormatOptions=r({},a.oDefaultFormatOptions,e);if(a.type===p.DATETIME_WITH_TIMEZONE){u.oFormatOptions.interval=false;u.oFormatOptions.singleIntervalValue=false;u.oFormatOptions.UTC=false}else{u.oFormatOptions.showTimezone=undefined;u.oFormatOptions.showDate=undefined;u.oFormatOptions.showTime=undefined}u.type=a.type;if(!u.oFormatOptions.calendarType){u.oFormatOptions.calendarType=i.getCalendarType()}if(u.oFormatOptions.firstDayOfWeek===undefined&&u.oFormatOptions.minimalDaysInFirstWeek!==undefined||u.oFormatOptions.firstDayOfWeek!==undefined&&u.oFormatOptions.minimalDaysInFirstWeek===undefined){throw new TypeError("Format options firstDayOfWeek and minimalDaysInFirstWeek need both to be set, but only one was provided.")}if(u.oFormatOptions.calendarWeekNumbering&&!Object.values(c).includes(u.oFormatOptions.calendarWeekNumbering)){throw new TypeError("Illegal format option calendarWeekNumbering: '"+u.oFormatOptions.calendarWeekNumbering+"'")}if(!u.oFormatOptions.pattern){if(u.oFormatOptions.format){u.oFormatOptions.pattern=u.oLocaleData.getCustomDateTimePattern(u.oFormatOptions.format,u.oFormatOptions.calendarType)}else{u.oFormatOptions.pattern=a.getPattern(u.oLocaleData,u.oFormatOptions.style,u.oFormatOptions.calendarType)}}if(u.oFormatOptions.interval){var d,h=u.oFormatOptions.intervalDelimiter;if(u.oFormatOptions.format){u.intervalPatterns=u.oLocaleData.getCustomIntervalPattern(u.oFormatOptions.format,null,u.oFormatOptions.calendarType);if(typeof u.intervalPatterns==="string"){u.intervalPatterns=[u.intervalPatterns]}d=u.oLocaleData.getCustomDateTimePattern(u.oFormatOptions.format,u.oFormatOptions.calendarType);u.intervalPatterns.push(d)}else{d=u.oFormatOptions.pattern;u.intervalPatterns=[u.oLocaleData.getCombinedIntervalPattern(u.oFormatOptions.pattern,u.oFormatOptions.calendarType),u.oFormatOptions.pattern]}u.intervalPatterns.push(u.oFormatOptions.pattern+" - "+u.oFormatOptions.pattern);if(h){h=h.replace(/'/g,"''");h="'"+h+"'";u.intervalPatterns.unshift(d+h+d)}u.intervalPatterns=Array.from(new Set(u.intervalPatterns))}if(!n){o=a.aFallbackFormatOptions;if(a.bShortFallbackFormatOptions){f=a.getPattern(u.oLocaleData,"short");o=o.concat(g._createFallbackOptionsWithoutDelimiter(f))}if(u.oFormatOptions.pattern&&a.bPatternFallbackWithoutDelimiter){o=g._createFallbackOptionsWithoutDelimiter(u.oFormatOptions.pattern).concat(o)}o=o.reduce(function(e,t){var a=Object.keys(t),r=e.some(function(e){return Object.keys(e).length===a.length&&a.every(function(a){return e[a]===t[a]})});if(!r){e.push(t)}return e},[]);u.aFallbackFormats=g._createFallbackFormat(o,u.oFormatOptions.calendarType,t,a,u.oFormatOptions)}u.oRequiredParts=a.oRequiredParts;u.aRelativeScales=a.aRelativeScales;u.aRelativeParseScales=a.aRelativeParseScales;u.aIntervalCompareFields=a.aIntervalCompareFields;u.init();return u};g.prototype.init=function(){var e=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData._getMonthsWithAlternatives("abbreviated",e);this.aMonthsWide=this.oLocaleData.getMonths("wide",e);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",e);this.aMonthsAbbrevSt=this.oLocaleData._getMonthsStandAloneWithAlternatives("abbreviated",e);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",e);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",e);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",e);this.aDaysWide=this.oLocaleData.getDays("wide",e);this.aDaysNarrow=this.oLocaleData.getDays("narrow",e);this.aDaysShort=this.oLocaleData.getDays("short",e);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",e);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",e);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",e);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",e);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",e);this.aQuartersWide=this.oLocaleData.getQuarters("wide",e);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",e);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",e);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",e);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",e);this.aErasNarrow=this.oLocaleData.getEras("narrow",e);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",e);this.aErasWide=this.oLocaleData.getEras("wide",e);this.aDayPeriodsAbbrev=this.oLocaleData.getDayPeriods("abbreviated",e);this.aDayPeriodsNarrow=this.oLocaleData.getDayPeriods("narrow",e);this.aDayPeriodsWide=this.oLocaleData.getDayPeriods("wide",e);this.oFlexibleDayPeriodsAbbrev=this.oLocaleData.getFlexibleDayPeriods("abbreviated",e);this.oFlexibleDayPeriodsNarrow=this.oLocaleData.getFlexibleDayPeriods("narrow",e);this.oFlexibleDayPeriodsWide=this.oLocaleData.getFlexibleDayPeriods("wide",e);this.oFlexibleDayPeriodsAbbrevSt=this.oLocaleData.getFlexibleDayPeriodsStandAlone("abbreviated",e);this.oFlexibleDayPeriodsNarrowSt=this.oLocaleData.getFlexibleDayPeriodsStandAlone("narrow",e);this.oFlexibleDayPeriodsWideSt=this.oLocaleData.getFlexibleDayPeriodsStandAlone("wide",e);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray)};g._createFallbackFormat=function(e,t,a,r,n){return e.map(function(e){var i=Object.assign({},e);i.showDate=n.showDate;i.showTime=n.showTime;i.showTimezone=n.showTimezone;if(typeof r.getTimezonePattern==="function"&&i.pattern){i.pattern=r.getTimezonePattern(i.pattern)}if(n.interval){i.interval=true}i.calendarType=t;return g.createInstance(i,a,r,true)})};g._createFallbackOptionsWithoutDelimiter=function(e){var t=/[^dMyGU]/g,a={regex:/d+/g,replace:"dd"},r={regex:/M+/g,replace:"MM"},n={regex:/[yU]+/g,replace:["yyyy","yy"]};e=e.replace(t,"");e=e.replace(a.regex,a.replace);e=e.replace(r.regex,r.replace);return n.replace.map(function(t){return{pattern:e.replace(n.regex,t),strictParsing:true}})};var D={isNumber:function(e){return e>=48&&e<=57},findNumbers:function(e,t){var a=0;while(a<t&&this.isNumber(e.charCodeAt(a))){a++}return e.substr(0,a)},startsWithIgnoreCase:function(e,t,a){if(e.startsWith(t)){return true}try{var r=t.toLocaleUpperCase(a);var n=e.toLocaleUpperCase(a);if(r.length!==t.length||n.length!==e.length){return false}return n.startsWith(r)}catch(e){return false}},findEntry:function(e,t,a){let r=-1;let n=0;t.forEach((t,i)=>{(Array.isArray(t)?t:[t]).forEach(t=>{if(t.length>n&&this.startsWithIgnoreCase(e,t,a)){r=i;n=t.length}})});return{index:r,length:n}},parseTZ:function(e,t){var a=0;var r=e.charAt(0)==="+"?-1:1;var n;if(e[0]==="Z"){return{length:1,tzDiff:0}}a++;n=this.findNumbers(e.substr(a),2);var i=parseInt(n);a+=2;if(t){a++}n=this.findNumbers(e.substr(a),2);var o=0;if(n){a+=2;o=parseInt(n)}return{length:a,tzDiff:(o+60*i)*60*r}},checkValid:function(e,t,a){if(e in a.oRequiredParts&&t){return false}return true}};g._oParseHelper=D;g._createPatternSymbol=function(e){var t=typeof e.isNumeric==="function"&&e.isNumeric||function(){return e.isNumeric||false};return{name:e.name,format:e.format||function(){return""},parse:e.parse||function(){return{}},isNumeric:t}};g.prototype.oSymbols={"":g._createPatternSymbol({name:"text",format:function(e,t){return e.value},parse:function(e,t,a,r){var n;var i=true;var o=0;var s=0;var l="-~‐‑‒–—﹘﹣－～";const u=g._normalize(t.value);for(;s<u.length;s++){n=u.charAt(s);if(n===" "){while(e.charAt(o)===" "){o++}}else if(l.includes(n)){if(!l.includes(e.charAt(o))){i=false}o++}else{if(e.charAt(o)!==n){i=false}o++}if(!i){break}}if(i){return{length:o}}else{var f=false;if(r.index<r.formatArray.length-1){f=r.formatArray[r.index+1].type in a.oRequiredParts}return{valid:D.checkValid(t.type,f,a)}}}}),G:g._createPatternSymbol({name:"era",format:function(e,t,a,r){var n=t.getUTCEra();if(e.digits<=3){return r.aErasAbbrev[n]}else if(e.digits===4){return r.aErasWide[n]}else{return r.aErasNarrow[n]}},parse:function(e,t,a,r){var n=[a.aErasWide,a.aErasAbbrev,a.aErasNarrow];for(var i=0;i<n.length;i++){var o=n[i];var s=D.findEntry(e,o,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{era:s.index,length:s.length}}}return{era:a.aErasWide.length-1,valid:D.checkValid(t.type,true,a)}}}),y:g._createPatternSymbol({name:"year",format:function(e,t,a,r){var i=t.getUTCFullYear();var o=String(i);var s=r.oFormatOptions.calendarType;if(e.digits===2&&o.length>2){o=o.substr(o.length-2)}if(s!==n.Japanese&&e.digits===1&&i<100){o=o.padStart(4,"0")}return o.padStart(e.digits,"0")},parse:function(e,t,a,r){var i,o,s,l=a.oFormatOptions.calendarType;if(t.digits===1){i=4}else if(t.digits===2){i=2}else{i=t.digits}o=D.findNumbers(e,i);s=o===""||r.exactLength&&o.length!==i;var u=parseInt(o);if(l!==n.Japanese&&o.length<=2){var f=h.getInstance(d.getInstance(),l),c=f.getUTCFullYear(),m=Math.floor(c/100),g=m*100+u-c;if(g<-70){u+=(m+1)*100}else if(g<30){u+=m*100}else{u+=(m-1)*100}}return{length:o.length,valid:D.checkValid(t.type,s,a),year:u}},isNumeric:true}),Y:g._createPatternSymbol({name:"weekYear",format:function(e,t,a,r){var i=t.getUTCWeek(r.oLocale,T(r.oFormatOptions));var o=i.year;var s=String(o);var l=r.oFormatOptions.calendarType;if(e.digits===2&&s.length>2){s=s.substr(s.length-2)}if(l!==n.Japanese&&e.digits===1&&o<100){s=s.padStart(4,"0")}return s.padStart(e.digits,"0")},parse:function(e,t,a,r){var i,o,s,l=a.oFormatOptions.calendarType;if(t.digits===1){i=4}else if(t.digits===2){i=2}else{i=t.digits}o=D.findNumbers(e,i);s=o===""||r.exactLength&&o.length!==i;var u=parseInt(o);var f=u;if(l!==n.Japanese&&o.length<=2){var c=h.getInstance(d.getInstance(),l),m=c.getUTCFullYear(),g=Math.floor(m/100),p=g*100+f-m;if(p<-70){f+=(g+1)*100}else if(p<30){f+=g*100}else{f+=(g-1)*100}}return{length:o.length,valid:D.checkValid(t.type,s,a),year:u,weekYear:f}},isNumeric:true}),M:g._createPatternSymbol({name:"month",format:function(e,t,a,r){var n=t.getUTCMonth();if(e.digits===3){const e=r.aMonthsAbbrev[n];return Array.isArray(e)?e[0]:e}else if(e.digits===4){return r.aMonthsWide[n]}else if(e.digits>4){return r.aMonthsNarrow[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s,l=[a.aMonthsWide,a.aMonthsWideSt,a.aMonthsAbbrev,a.aMonthsAbbrevSt,a.aMonthsNarrow,a.aMonthsNarrowSt];if(t.digits<3){i=D.findNumbers(e,Math.max(t.digits,2));o=i===""||r.exactLength&&i.length<2;s=D.checkValid(t.type,o,a);n=parseInt(i)-1;if(r.strict&&(n>11||n<0)){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var c=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(c.index!==-1){return{month:c.index,length:c.length}}}s=D.checkValid(t.type,true,a)}return{month:n,length:i?i.length:0,valid:s}},isNumeric:function(e){return e<3}}),L:g._createPatternSymbol({name:"monthStandalone",format:function(e,t,a,r){var n=t.getUTCMonth();if(e.digits===3){const e=r.aMonthsAbbrevSt[n];return Array.isArray(e)?e[0]:e}else if(e.digits===4){return r.aMonthsWideSt[n]}else if(e.digits>4){return r.aMonthsNarrowSt[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s,l=[a.aMonthsWide,a.aMonthsWideSt,a.aMonthsAbbrev,a.aMonthsAbbrevSt,a.aMonthsNarrow,a.aMonthsNarrowSt];if(t.digits<3){i=D.findNumbers(e,Math.max(t.digits,2));o=i===""||r.exactLength&&i.length<2;s=D.checkValid(t.type,o,a);n=parseInt(i)-1;if(r.strict&&(n>11||n<0)){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var c=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(c.index!==-1){return{month:c.index,length:c.length}}}s=D.checkValid(t.type,true,a)}return{month:n,length:i?i.length:0,valid:s}},isNumeric:function(e){return e<3}}),w:g._createPatternSymbol({name:"weekInYear",format:function(e,t,a,r){var n=t.getUTCWeek(r.oLocale,T(r.oFormatOptions));var i=n.week;var o=String(i+1);if(e.digits<3){o=o.padStart(e.digits,"0")}else{o=r.oLocaleData.getCalendarWeek(e.digits===3?"narrow":"wide",o.padStart(2,"0"))}return o},parse:function(e,t,a,r){var n,i,o,s,l=0;if(t.digits<3){n=D.findNumbers(e,2);l=n.length;s=parseInt(n)-1;i=!n||r.exactLength&&l<2;o=D.checkValid(t.type,i,a)}else{n=a.oLocaleData.getCalendarWeek(t.digits===3?"narrow":"wide");n=n.replace("{0}","([0-9]+)");var u=new RegExp(n),f=u.exec(e);if(f){l=f[0].length;s=parseInt(f[f.length-1])-1}else{o=D.checkValid(t.type,true,a)}}return{length:l,valid:o,week:s}},isNumeric:function(e){return e<3}}),W:g._createPatternSymbol({name:"weekInMonth"}),D:g._createPatternSymbol({name:"dayInYear"}),d:g._createPatternSymbol({name:"day",format:function(e,t){var a=t.getUTCDate();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=n===""||r.exactLength&&n.length<2,o=D.checkValid(t.type,i,a),s=parseInt(n);if(r.strict&&(s>31||s<1)){o=false}return{day:s,length:n.length,valid:o}},isNumeric:true}),Q:g._createPatternSymbol({name:"quarter",format:function(e,t,a,r){var n=t.getUTCQuarter();if(e.digits===3){return r.aQuartersAbbrev[n]}else if(e.digits===4){return r.aQuartersWide[n]}else if(e.digits>4){return r.aQuartersNarrow[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s;var l=[a.aQuartersWide,a.aQuartersWideSt,a.aQuartersAbbrev,a.aQuartersAbbrevSt,a.aQuartersNarrow,a.aQuartersNarrowSt];if(t.digits<3){n=D.findNumbers(e,Math.max(t.digits,2));i=n===""||r.exactLength&&n.length<2;s=D.checkValid(t.type,i,a);o=parseInt(n)-1;if(r.strict&&o>3){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var c=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(c.index!==-1){return{quarter:c.index,length:c.length}}}s=D.checkValid(t.type,true,a)}return{length:n?n.length:0,quarter:o,valid:s}},isNumeric:function(e){return e<3}}),q:g._createPatternSymbol({name:"quarterStandalone",format:function(e,t,a,r){var n=t.getUTCQuarter();if(e.digits===3){return r.aQuartersAbbrevSt[n]}else if(e.digits===4){return r.aQuartersWideSt[n]}else if(e.digits>4){return r.aQuartersNarrowSt[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s;var l=[a.aQuartersWide,a.aQuartersWideSt,a.aQuartersAbbrev,a.aQuartersAbbrevSt,a.aQuartersNarrow,a.aQuartersNarrowSt];if(t.digits<3){n=D.findNumbers(e,Math.max(t.digits,2));i=n===""||r.exactLength&&n.length<2;s=D.checkValid(t.type,i,a);o=parseInt(n)-1;if(r.strict&&o>3){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var c=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(c.index!==-1){return{quarter:c.index,length:c.length}}}s=D.checkValid(t.type,true,a)}return{length:n?n.length:0,quarter:o,valid:s}},isNumeric:function(e){return e<3}}),F:g._createPatternSymbol({name:"dayOfWeekInMonth"}),E:g._createPatternSymbol({name:"dayNameInWeek",format:function(e,t,a,r){var n=t.getUTCDay();if(e.digits<4){return r.aDaysAbbrev[n]}else if(e.digits===4){return r.aDaysWide[n]}else if(e.digits===5){return r.aDaysNarrow[n]}else{return r.aDaysShort[n]}},parse:function(e,t,a,r){var n=[a.aDaysWide,a.aDaysWideSt,a.aDaysAbbrev,a.aDaysAbbrevSt,a.aDaysShort,a.aDaysShortSt,a.aDaysNarrow,a.aDaysNarrowSt];for(var i=0;i<n.length;i++){var o=n[i];var s=D.findEntry(e,o,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{dayOfWeek:s.index,length:s.length}}}}}),c:g._createPatternSymbol({name:"dayNameInWeekStandalone",format:function(e,t,a,r){var n=t.getUTCDay();if(e.digits<4){return r.aDaysAbbrevSt[n]}else if(e.digits===4){return r.aDaysWideSt[n]}else if(e.digits===5){return r.aDaysNarrowSt[n]}else{return r.aDaysShortSt[n]}},parse:function(e,t,a,r){var n=[a.aDaysWide,a.aDaysWideSt,a.aDaysAbbrev,a.aDaysAbbrevSt,a.aDaysShort,a.aDaysShortSt,a.aDaysNarrow,a.aDaysNarrowSt];for(var i=0;i<n.length;i++){var o=n[i];var s=D.findEntry(e,o,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{day:s.index,length:s.length}}}}}),u:g._createPatternSymbol({name:"dayNumberOfWeek",format:function(e,t,a,r){var n=t.getUTCDay();return r._adaptDayOfWeek(n)},parse:function(e,t,a,r){var n=D.findNumbers(e,t.digits),i=r.exactLength&&n.length!==t.digits;return{dayNumberOfWeek:parseInt(n),length:n.length,valid:D.checkValid(t.type,i,a)}},isNumeric:true}),a:g._createPatternSymbol({name:"amPmMarker",format:function(e,t,a,r){var n=t.getUTCDayPeriod();if(e.digits<=3){return r.aDayPeriodsAbbrev[n]}else if(e.digits===4){return r.aDayPeriodsWide[n]}else{return r.aDayPeriodsNarrow[n]}},parse:function(e,t,a,r,n){var i,o,s,l,u,f,c=[a.aDayPeriodsWide,a.aDayPeriodsAbbrev,a.aDayPeriodsNarrow];i=/[aApP](?:\.)?[\x20\xA0]?[mM](?:\.)?/;u=e.match(i);o=u&&u.index===0;function d(e){return e.replace(/[\x20\xA0]/g,"").replace(/\./g,"")}if(o){e=d(e)}for(l=0;l<c.length;l+=1){f=c[l].map(e=>g._normalize(e));if(o){f=f.map(d)}s=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{pm:s.index===1,length:o?u[0].length:s.length}}}return{valid:false}}}),B:g._createPatternSymbol({name:"flexibleDayPeriod",format:function(e,t,a,r){var n=r.aFormatArray.some(function(e){return"hHKk".includes(e.symbol)}),i=r.oLocaleData.getFlexibleDayPeriodOfTime(t.getUTCHours(),t.getUTCMinutes());if(n){if(e.digits<=3){return r.oFlexibleDayPeriodsAbbrev[i]}if(e.digits===4){return r.oFlexibleDayPeriodsWide[i]}return r.oFlexibleDayPeriodsNarrow[i]}if(e.digits<=3){return r.oFlexibleDayPeriodsAbbrevSt[i]}if(e.digits===4){return r.oFlexibleDayPeriodsWideSt[i]}return r.oFlexibleDayPeriodsNarrowSt[i]},parse:function(e,t,a,r){var n,i,o,s=a.aFormatArray.some(function(e){return"hHKk".includes(e.symbol)}),l=[a.oFlexibleDayPeriodsWide,a.oFlexibleDayPeriodsAbbrev,a.oFlexibleDayPeriodsNarrow];if(s){for(n=0;n<l.length;n++){o=l[n];i=D.findEntry(e,Object.values(o),a.oLocaleData.sCLDRLocaleId);if(i.index!==-1){return{flexDayPeriod:Object.keys(o)[i.index],length:i.length}}}}return{valid:false}}}),H:g._createPatternSymbol({name:"hour0_23",format:function(e,t){var a=t.getUTCHours();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=D.checkValid(t.type,o,a);if(r.strict&&i>23){s=false}return{hour:i,length:n.length,valid:s}},isNumeric:true}),k:g._createPatternSymbol({name:"hour1_24",format:function(e,t){var a=t.getUTCHours();var r=a===0?"24":String(a);return r.padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=D.checkValid(t.type,o,a);if(i===24){i=0}if(r.strict&&i>23){s=false}return{hour:i,length:n.length,valid:s}},isNumeric:true}),K:g._createPatternSymbol({name:"hour0_11",format:function(e,t){var a=t.getUTCHours();var r=String(a>11?a-12:a);return r.padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=D.checkValid(t.type,o,a);if(r.strict&&i>11){s=false}return{hour:i,length:n.length,valid:s}},isNumeric:true}),h:g._createPatternSymbol({name:"hour1_12",format:function(e,t){var a=t.getUTCHours();var r;if(a>12){r=String(a-12)}else if(a===0){r="12"}else{r=String(a)}return r.padStart(e.digits,"0")},parse:function(e,t,a,r){var n=r.dateValue.pm,i=D.findNumbers(e,Math.max(t.digits,2)),o=parseInt(i),s=i===""||r.exactLength&&i.length<2,l=D.checkValid(t.type,s,a);if(o===12){o=0;n=n===undefined?true:n}if(r.strict&&o>11){l=false}return{hour:o,length:i.length,pm:n,valid:l}},isNumeric:true}),m:g._createPatternSymbol({name:"minute",format:function(e,t){var a=t.getUTCMinutes();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=D.checkValid(t.type,o,a);if(r.strict&&i>59){s=false}return{length:n.length,minute:i,valid:s}},isNumeric:true}),s:g._createPatternSymbol({name:"second",format:function(e,t){var a=t.getUTCSeconds();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=Math.max(t.digits,2),i=D.findNumbers(e,n),o=i===""||r.exactLength&&i.length<n,s=parseInt(i),l=D.checkValid(t.type,o,a);if(r.strict&&s>59){l=false}return{length:i.length,second:s,valid:l}},isNumeric:true}),S:g._createPatternSymbol({name:"fractionalsecond",format:function(e,t){var a=t.getUTCMilliseconds();var r=String(a);var n=r.padStart(3,"0");n=n.substr(0,e.digits);n=n.padEnd(e.digits,"0");return n},parse:function(e,t,a,r){var n=D.findNumbers(e,t.digits),i=n.length,o=r.exactLength&&i<t.digits;n=n.substr(0,3);n=n.padEnd(3,"0");var s=parseInt(n);return{length:i,millisecond:s,valid:D.checkValid(t.type,o,a)}},isNumeric:true}),z:g._createPatternSymbol({name:"timezoneGeneral",format:function(e,t,a,r,n){if(e.digits>3&&t.getTimezoneLong&&t.getTimezoneLong()){return t.getTimezoneLong()}else if(t.getTimezoneShort&&t.getTimezoneShort()){return t.getTimezoneShort()}var i=m.calculateOffset(t,n);var o="GMT";var s=Math.abs(i/60);var l=i>0;var u=Math.floor(s/60);var f=Math.floor(s%60);if(!a&&s!==0){o+=l?"-":"+";o+=String(u).padStart(2,"0");o+=":";o+=String(f).padStart(2,"0")}else{o+="Z"}return o},parse:function(e,t,a,r){var n=0;var i;var o=e.substring(0,3);if(o==="GMT"||o==="UTC"){n=3}else if(e.substring(0,2)==="UT"){n=2}else if(e.charAt(0)==="Z"){n=1;i=0}else{return{error:"cannot be parsed correctly by sap.ui.core.format.DateFormat: The given timezone is not supported!"}}if(e.charAt(0)!=="Z"){var s=D.parseTZ(e.substr(n),true);n+=s.length;i=s.tzDiff}return{length:n,tzDiff:i}}}),Z:g._createPatternSymbol({name:"timezoneRFC822",format:function(e,t,a,r,n){var i=m.calculateOffset(t,n);var o=Math.abs(i/60);var s=i>0;var l=Math.floor(o/60);var u=Math.floor(o%60);var f="";if(!a){f+=s?"-":"+";f+=String(l).padStart(2,"0");f+=String(u).padStart(2,"0")}return f},parse:function(e,t,a,r){return D.parseTZ(e,false)}}),X:g._createPatternSymbol({name:"timezoneISO8601",format:function(e,t,a,r,n){var i=m.calculateOffset(t,n);var o=Math.abs(i/60);var s=i>0;var l=Math.floor(o/60);var u=Math.floor(o%60);var f="";if(!a&&o!==0){f+=s?"-":"+";f+=String(l).padStart(2,"0");if(e.digits>1||u>0){if(e.digits===3||e.digits===5){f+=":"}f+=String(u).padStart(2,"0")}}else{f+="Z"}return f},parse:function(e,t,a,r){if(e.charAt(0)==="Z"){return{length:1,tzDiff:0}}else{return D.parseTZ(e,t.digits===3||t.digits===5)}}}),V:g._createPatternSymbol({name:"timezoneID",format:function(e,t,a,r,n){if(!a&&e.digits===2){return r.oLocaleData.getTimezoneTranslations()[n]||n}return""},parse:function(e,t,a,r,n){var i={timezone:"",length:0};if(t.digits===2){var o=a.oLocaleData.getTimezoneTranslations();if(e===o[n]){return{timezone:n,length:e.length}}var s=Object.values(o);var l=D.findEntry(e,s,a.oLocaleData.sCLDRLocaleId);if(l.index!==-1){return{timezone:Object.keys(o)[l.index],length:l.length}}var u="";for(var f=e.length;f>0;f-=1){u=e.slice(0,f);if(m.isValidTimezone(u)){i.timezone=u;i.length=u.length;break}}}return i}})};g.prototype._format=function(e,t,a){if(this.oFormatOptions.relative){var r=this.formatRelative(e,t,this.oFormatOptions.relativeRange,a);if(r){return r}}var n=this.oFormatOptions.calendarType;var i=h.getInstance(e,n);var o=[],s,l,f;for(var c=0;c<this.aFormatArray.length;c++){s=this.aFormatArray[c];f=s.symbol||"";o.push(this.oSymbols[f].format(s,i,t,this,a))}l=o.join("");if(u.collectOriginInfo()){l=new String(l);l.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern}}return l};g.prototype.format=function(t,a){var r;if(this.type===p.DATETIME_WITH_TIMEZONE){r=a;a=false;v(r);if(r&&!m.isValidTimezone(r)){e.error("The given timezone isn't valid.");return""}}var o=this.oFormatOptions.calendarType,s;if(a===undefined){a=this.oFormatOptions.UTC}r=r||i.getTimezone();if(Array.isArray(t)){if(!this.oFormatOptions.interval){e.error("Non-interval DateFormat can't format more than one date instance.");return""}if(t.length!==2){e.error("Interval DateFormat can only format with 2 date instances but "+t.length+" is given.");return""}t=t.map(function(e){return S(e,r,a)});if(this.oFormatOptions.singleIntervalValue){if(t[0]===null){e.error("First date instance which is passed to the interval DateFormat shouldn't be null.");return""}if(t[1]===null){s=this._format(t[0],a,r)}}if(s===undefined){if(!t.every(k)){e.error("At least one date instance which is passed to the interval DateFormat isn't valid.");return""}s=this._formatInterval(t,a)}}else{if(!k(t)){if(this.type===p.DATETIME_WITH_TIMEZONE&&this.oFormatOptions.pattern.includes("VV")){return this.oLocaleData.getTimezoneTranslations()[r]||r}e.error("The given date instance isn't valid.");return""}if(this.oFormatOptions.interval){e.error("Interval DateFormat expects an array with two dates for the first argument but only one date is given.");return""}t=S(t,r,a);s=this._format(t,a,r)}if(o===n.Japanese&&this.oLocale.getLanguage()==="ja"){s=s.replace(/(^|[^\d])1年/g,"$1元年")}return s};g.prototype._useCustomIntervalDelimiter=function(e){var t;if(!this.oFormatOptions.intervalDelimiter){return false}if(this.oFormatOptions.format){t=this.oLocaleData._parseSkeletonFormat(this.oFormatOptions.format);return t.some(function(t){return e[t.group]})}return true};g.prototype._formatInterval=function(e,t){var a,r,n,i,o=[],s=this.oFormatOptions.calendarType,l=[],u=h.getInstance(e[0],s),f=h.getInstance(e[1],s),c=this._getDiffFields([u,f]);if(!c){return this._format(e[0],t)}if(this._useCustomIntervalDelimiter(c)){n=this.intervalPatterns[0]}else if(this.oFormatOptions.format){n=this.oLocaleData.getCustomIntervalPattern(this.oFormatOptions.format,c,s)}else{n=this.oLocaleData.getCombinedIntervalPattern(this.oFormatOptions.pattern,s)}l=this.parseCldrDatePattern(n);a=u;for(var d=0;d<l.length;d++){r=l[d];i=r.symbol||"";if(r.repeat){a=f}o.push(this.oSymbols[i].format(r,a,t,this))}return o.join("")};var b={Era:"Era",FullYear:"Year",Quarter:"Quarter",Month:"Month",Week:"Week",Date:"Day",DayPeriod:"DayPeriod",Hours:"Hour",Minutes:"Minute",Seconds:"Second"};g.prototype._getDiffFields=function(e){var t=false,r={};this.aIntervalCompareFields.forEach(function(n){var i="getUTC",o=i+n,s=b[n],l=e[0][o].apply(e[0]),u=e[1][o].apply(e[1]);if(!a(l,u)){t=true;r[s]=true}});if(t){return r}return null};g.prototype._parse=function(e,t,a,n,i){var o,s,l,u,f,c,d,h={valid:true,lastTimezonePatternSymbol:""},m=0,g={formatArray:t,dateValue:h,strict:n},p=this;function y(e){return p.oSymbols[e.symbol||""]}function v(e){return!!e&&y(e).isNumeric(e.digits)}for(var D=0;D<t.length;D++){d=e.substr(m);l=t[D];f=t[D-1];s=t[D+1];g.index=D;g.exactLength=v(l)&&(v(f)||v(s));c=y(l).parse(d,l,this,g,i)||{};if(c.tzDiff!==undefined||c.timezone){c.lastTimezonePatternSymbol=l.symbol}h=r(h,c);if(c.valid===false){break}m+=c.length||0}h.index=m;u=h.pm;if(h.flexDayPeriod&&h.hour*60+(h.minute||0)<720){o=this.oLocaleData.getFlexibleDayPeriodOfTime(h.hour+12,h.minute||0);u=h.flexDayPeriod===o}if(u){h.hour+=12}if(h.dayNumberOfWeek===undefined&&h.dayOfWeek!==undefined){h.dayNumberOfWeek=this._adaptDayOfWeek(h.dayOfWeek)}if(h.quarter!==undefined&&h.month===undefined&&h.day===undefined){h.month=3*h.quarter;h.day=1}return h};g.prototype._parseInterval=function(e,t,a,r,n){var i,o,s;this.intervalPatterns.some(function(t){var l=this.parseCldrDatePattern(t);o=undefined;for(var u=0;u<l.length;u++){if(l[u].repeat){o=u;break}}if(o===undefined){s=this._parse(e,l,a,r,n);if(s.index===0||s.index<e.length){s.valid=false}if(s.valid===false){return}i=[s,s];return true}else{i=[];s=this._parse(e,l.slice(0,o),a,r,n);if(s.valid===false){return}i.push(s);var f=s.index;s=this._parse(e.substring(f),l.slice(o),a,r,n);if(s.index===0||s.index+f<e.length){s.valid=false}if(s.valid===false){return}i.push(s);return true}}.bind(this));return i};function T(e){if(e.calendarWeekNumbering){return e.calendarWeekNumbering}else if(e.firstDayOfWeek!==undefined&&e.minimalDaysInFirstWeek!==undefined){return{firstDayOfWeek:e.firstDayOfWeek,minimalDaysInFirstWeek:e.minimalDaysInFirstWeek}}return undefined}var S=function(e,t,a){if(!a&&k(e)){return m.convertToTimezone(e,t)}return e};var F=function(e,t,a,r,n,i,o){if(!e.valid){return null}var s,l=typeof e.year==="number"?e.year:1970;s=h.getInstance(new Date(0),t);s.setUTCEra(e.era||h.getCurrentEra(t));s.setUTCFullYear(l);s.setUTCMonth(e.month||0);s.setUTCDate(e.day||1);s.setUTCHours(e.hour||0);s.setUTCMinutes(e.minute||0);s.setUTCSeconds(e.second||0);s.setUTCMilliseconds(e.millisecond||0);if(r&&(e.day||1)!==s.getUTCDate()){return null}if(e.week!==undefined&&(e.month===undefined||e.day===undefined)){s.setUTCWeek({year:e.weekYear||e.year,week:e.week},o,T(i));if(e.dayNumberOfWeek!==undefined){s.setUTCDate(s.getUTCDate()+e.dayNumberOfWeek-1)}}s=s.getJSDate();if(!a&&(e.lastTimezonePatternSymbol==="V"&&e.timezone||e.tzDiff===undefined)){if(e.timezone){n=e.timezone}if(n){e.tzDiff=m.calculateOffset(s,n)}}if(e.tzDiff){s.setUTCSeconds(s.getUTCSeconds()+e.tzDiff)}return s};function O(e,t){if(e===t){return e}var a={};Object.keys(e).forEach(function(t){a[t]=e[t]});Object.keys(t).forEach(function(e){if(!a.hasOwnProperty(e)){a[e]=t[e]}});return a}function w(e,t){if(e.getTime()>t.getTime()){return false}return true}function k(e){return e&&typeof e.getTime==="function"&&!isNaN(e.getTime())}g.prototype.parse=function(t,a,r){var o=this.oFormatOptions.showDate===undefined||this.oFormatOptions.showDate;var s=this.oFormatOptions.showTime===undefined||this.oFormatOptions.showTime;if(this.type===p.DATETIME_WITH_TIMEZONE&&(o&&!s||!o&&s)){throw new TypeError("The input can only be parsed back to date if both date and time are supplied.")}var l;if(a===undefined&&this.type!==p.DATETIME_WITH_TIMEZONE){a=this.oFormatOptions.UTC}var u=a;if(this.type===p.DATETIME_WITH_TIMEZONE){l=a;a=false;v(l);if(l&&!m.isValidTimezone(l)){e.error("The given timezone isn't valid.");return null}}t=t==null?"":String(t).trim();t=g._normalize(t);var f;var c=this.oFormatOptions.calendarType;l=l||i.getTimezone();if(r===undefined){r=this.oFormatOptions.strictParsing}if(c===n.Japanese&&this.oLocale.getLanguage()==="ja"){t=t.replace(/元年/g,"1年")}if(!this.oFormatOptions.interval){var d=this.parseRelative(t,a);if(d){return d}f=this._parse(t,this.aFormatArray,a,r,l);if(f.index===0||f.index<t.length){f.valid=false}d=F(f,c,a,r,l,this.oFormatOptions,this.oLocale);if(d){if(this.type===p.DATETIME_WITH_TIMEZONE){var h=this.oFormatOptions.showTimezone===undefined||this.oFormatOptions.showTimezone;if(!h&&o&&s){return[d,undefined]}else if(h&&!o&&!s){return[undefined,f.timezone]}return[d,f.timezone||undefined]}return d}}else{var y=this._parseInterval(t,c,a,r,l);var D,b;if(y&&y.length===2){var T=O(y[0],y[1]);var S=O(y[1],y[0]);D=F(T,c,a,r,l,this.oFormatOptions,this.oLocale);b=F(S,c,a,r,l,this.oFormatOptions,this.oLocale);if(D&&b){if(this.oFormatOptions.singleIntervalValue&&D.getTime()===b.getTime()){return[D,null]}var k=w(D,b);if(r&&!k){e.error("StrictParsing: Invalid date range. The given end date is before the start date.");return[null,null]}return[D,b]}}}if(this.aFallbackFormats){var I;this.aFallbackFormats.every(function(e){I=e.parse(t,u,r);if(Array.isArray(I)){if(e.type===p.DATETIME_WITH_TIMEZONE){return false}return!(I[0]&&I[1])}else{return!I}});return I}if(!this.oFormatOptions.interval){return null}else{return[null,null]}};g.prototype.parseCldrDatePattern=function(e){if(y[e]){return y[e]}var t=[],a,r=false,n=null,i="",o="",s={},l=false;for(a=0;a<e.length;a++){var u=e.charAt(a),f,c,d;if(r){if(u==="'"){c=e.charAt(a-1);d=e.charAt(a-2);f=e.charAt(a+1);if(c==="'"&&d!=="'"){r=false}else if(f==="'"){a+=1}else{r=false;continue}}if(i==="text"){n.value+=u}else{n={type:"text",value:u};t.push(n);i="text"}}else{if(u==="'"){r=true}else if(this.oSymbols[u]){o=this.oSymbols[u].name;if(i===o){n.digits++}else{n={type:o,symbol:u,digits:1};t.push(n);i=o;if(!l){if(s[o]){n.repeat=true;l=true}else{s[o]=true}}}}else{if(i==="text"){n.value+=u}else{n={type:"text",value:u};t.push(n);i="text"}}}}y[e]=t;return t};g.prototype.parseRelative=function(e,t){var a,r,n,i,o;if(!e){return null}a=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var s=0;s<a.length;s++){r=a[s];n=new RegExp("^\\s*"+r.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");i=n.exec(e);if(i){if(r.value!==undefined){return l(r.value,r.scale)}else{o=parseInt(i[1]);return l(o*r.sign,r.scale)}}}function l(e,a){var r=d.getInstance();if(t){r.setUTCFullYear(r.getFullYear(),r.getMonth(),r.getDate());r.setUTCHours(r.getHours(),r.getMinutes(),r.getSeconds(),r.getMilliseconds());switch(a){case"second":r.setUTCSeconds(r.getUTCSeconds()+e);break;case"minute":r.setUTCMinutes(r.getUTCMinutes()+e);break;case"hour":r.setUTCHours(r.getUTCHours()+e);break;case"day":r.setUTCDate(r.getUTCDate()+e);break;case"week":r.setUTCDate(r.getUTCDate()+e*7);break;case"month":r.setUTCMonth(r.getUTCMonth()+e);break;case"quarter":r.setUTCMonth(r.getUTCMonth()+e*3);break;case"year":r.setUTCFullYear(r.getUTCFullYear()+e);break}}else{switch(a){case"second":r.setSeconds(r.getSeconds()+e);break;case"minute":r.setMinutes(r.getMinutes()+e);break;case"hour":r.setHours(r.getHours()+e);break;case"day":r.setDate(r.getDate()+e);break;case"week":r.setDate(r.getDate()+e*7);break;case"month":r.setMonth(r.getMonth()+e);break;case"quarter":r.setMonth(r.getMonth()+e*3);break;case"year":r.setFullYear(r.getFullYear()+e);break}}return r}};g.prototype.formatRelative=function(e,a,r,n){var i,o,s,l,u=S(new Date,n),f=this.oFormatOptions.relativeScale||"day";s=(e.getTime()-u.getTime())/1e3;if(this.oFormatOptions.relativeScale==="auto"){f=this._getScale(s,this.aRelativeScales);f=I(e,u,f,s)}if(!r){r=this._mRanges[f]}if(f==="year"||f==="month"||f==="day"){u=new Date(Date.UTC(u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate()));i=new Date(0);i.setUTCFullYear(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate());e=i}o=this._getDifference(f,[u,e]);if(this.oFormatOptions.relativeScale!=="auto"&&(o<r[0]||o>r[1])){return null}l=this.oLocaleData.getRelativePattern(f,o,s>0,this.oFormatOptions.relativeStyle);return t(l,[Math.abs(o)])};g.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};g.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592e3,quarter:7776e3,year:31536e3};g.prototype._getScale=function(e,t){var a,r;e=Math.abs(e);for(var n=0;n<t.length;n++){r=t[n];if(e>=this._mScales[r]){a=r;break}}if(!a){a=t[t.length-1]}return a};function I(e,t,a,r){var n=Math.abs(e.getUTCMonth()-t.getUTCMonth());if(a==="week"&&n===2){return"month"}else if(a==="week"&&n===1){if(e.getUTCDate()===t.getUTCDate()||r<0&&e.getUTCDate()<t.getUTCDate()||r>0&&e.getUTCDate()>t.getUTCDate()){return"month"}}else if(a==="month"&&n===1){if(r>0&&e.getUTCDate()<t.getUTCDate()||r<0&&e.getUTCDate()>t.getUTCDate()){return"week"}}return a}function M(e,t){var a,r=["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],n=new Date(e.getTime());for(var i=t;i<r.length;i++){a="setUTC"+r[t];n[a].apply(n,[0])}return n}var C={year:function(e,t){return t.getUTCFullYear()-e.getUTCFullYear()},month:function(e,t){return t.getUTCMonth()-e.getUTCMonth()+this.year(e,t)*12},week:function(e,t,a){var r=a._adaptDayOfWeek(e.getUTCDay());var n=a._adaptDayOfWeek(t.getUTCDay());e=M(e,3);t=M(t,3);return(t.getTime()-e.getTime()-(n-r)*a._mScales.day*1e3)/(a._mScales.week*1e3)},day:function(e,t,a){e=M(e,3);t=M(t,3);return(t.getTime()-e.getTime())/(a._mScales.day*1e3)},hour:function(e,t,a){e=M(e,4);t=M(t,4);return(t.getTime()-e.getTime())/(a._mScales.hour*1e3)},minute:function(e,t,a){e=M(e,5);t=M(t,5);return(t.getTime()-e.getTime())/(a._mScales.minute*1e3)},second:function(e,t,a){e=M(e,6);t=M(t,6);return(t.getTime()-e.getTime())/(a._mScales.second*1e3)}};g.prototype._adaptDayOfWeek=function(e){var t=T(this.oFormatOptions),a;if(typeof t==="object"){a=t.firstDayOfWeek}else{a=f.getWeekConfigurationValues(t,this.oLocale).firstDayOfWeek}var r=e-(a-1);if(r<=0){r+=7}return r};g.prototype._getDifference=function(e,t){var a=t[0];var r=t[1];return Math.round(C[e](a,r,this))};g.prototype.getAllowedCharacters=function(e){if(this.oFormatOptions.relative){return""}var t="";var a=false;var r=false;var n;for(var i=0;i<e.length;i++){n=e[i];switch(n.type){case"text":if(t.indexOf(n.value)<0){t+=n.value}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!a){t+="0123456789";a=true}break;case"month":case"monthStandalone":if(n.digits<3){if(!a){t+="0123456789";a=true}}else{r=true}break;default:r=true;break}}if(r){t=""}return t};g.prototype.getPlaceholderText=function(){var e=o.getLibraryResourceBundle();return e.getText("date.placeholder",[this.format.apply(this,this.getSampleValue())])};g.prototype.getSampleValue=function(){var e,t=d.getInstance().getFullYear(),a=this.oFormatOptions.UTC;function r(e,t,r,n,i,o,s){return a?d.getInstance(Date.UTC(e,t,r,n,i,o,s)):d.getInstance(e,t,r,n,i,o,s)}e=r(t,11,31,23,59,58,123);if(this.type===p.DATETIME_WITH_TIMEZONE){return[e,i.getTimezone()]}if(this.oFormatOptions.interval){return[[r(t,11,22,9,12,34,567),e]]}return[e]};const P=/[\u200e\u200f\u202a\u202b\u202c]/g;const L=/\s/g;g._normalize=function(e){return e.replace(P,"").replace(L," ")};return g},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/format/DateFormatTimezoneDisplay", [],function(){"use strict";var e={Show:"Show",Hide:"Hide",Only:"Only"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/format/FileSizeFormat", ["sap/ui/base/Object","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/format/NumberFormat","sap/ui/core/Configuration"],function(t,e,a,i,r){"use strict";var n=[{binaryFactor:1,decimalFactor:1,decimalUnit:"Byte",binaryUnit:"Byte"},{binaryFactor:1,decimalFactor:1,decimalUnit:"Bytes",binaryUnit:"Bytes"},{binaryFactor:Math.pow(2,10),decimalFactor:1e3,decimalUnit:"Kilobyte",binaryUnit:"Kibibyte"},{binaryFactor:Math.pow(2,20),decimalFactor:1e6,decimalUnit:"Megabyte",binaryUnit:"Mebibyte"},{binaryFactor:Math.pow(2,30),decimalFactor:1e9,decimalUnit:"Gigabyte",binaryUnit:"Gibibyte"},{binaryFactor:Math.pow(2,40),decimalFactor:1e12,decimalUnit:"Terabyte",binaryUnit:"Tebibyte"},{binaryFactor:Math.pow(2,50),decimalFactor:1e15,decimalUnit:"Petabyte",binaryUnit:"Pebibyte"},{binaryFactor:Math.pow(2,60),decimalFactor:1e18,decimalUnit:"Exabyte",binaryUnit:"Exbibyte"},{binaryFactor:Math.pow(2,70),decimalFactor:1e21,decimalUnit:"Zettabyte",binaryUnit:"Zebibyte"},{binaryFactor:Math.pow(2,80),decimalFactor:1e24,decimalUnit:"Yottabyte",binaryUnit:"Yobibyte"}];var o=t.extend("sap.ui.core.format.FileSizeFormat",{constructor:function(t){throw new Error}});o.getInstance=function(t,e){return this.createInstance(t,e)};o.createInstance=function(t,n){var o=Object.create(this.prototype);if(t instanceof e){n=t;t=undefined}if(!n){n=r.getFormatSettings().getFormatLocale()}o.oLocale=n;o.oLocaleData=a.getInstance(n);o.oNumberFormat=i.getFloatInstance(t,n);o.oBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",n.toString());o.bBinary=t?!!t.binaryFilesize:false;return o};o.prototype.format=function(t){var e=null,a;if(typeof t=="string"){try{if(/^\s*[\+-]?0[xX]/.test(t)){e=parseInt(t,16)}else{e=parseFloat(t,10)}}catch(t){}}else if(typeof t=="number"){e=t}if(e===null){return"NaN"}a=e;var i=c(e,this.bBinary),r=this.oNumberFormat.format(e/i.factor);if(!i.noSecondRounding){e=this.oNumberFormat.parse(r);if(this.bBinary&&Math.abs(e)>=1024||!this.bBinary&&Math.abs(e)>=1e3){i=c(e*i.factor,this.bBinary);r=this.oNumberFormat.format(a/i.factor)}}return this.oBundle.getText("FileSize."+i.unit,[r])};o.prototype.parse=function(t){var e,a,i,r;if(!t){return NaN}for(var o=0;o<n.length;o++){e=n[o];a=s(this.oBundle,e.decimalUnit,t);if(a){r=false;break}else{a=s(this.oBundle,e.binaryUnit,t);if(a){r=true;break}}}if(!a){a=t;r=false;e=n[0]}i=this.oNumberFormat.parse(a);return i*(r?e.binaryFactor:e.decimalFactor)};function c(t,e){var a=Math.abs(t),i,r;for(var o=n.length-1;o>=2;o--){i=n[o];r=e?i.binaryFactor:i.decimalFactor;if(a>=r){return{factor:r,unit:e?i.binaryUnit:i.decimalUnit,noSecondRounding:o==n.length-1}}}return{factor:1,unit:n[a>=2?1:0].decimalUnit}}function s(t,e,a){var i=t.getText("FileSize."+e),r;if(i.startsWith("{0}")){r=i.substr(3,i.length);if(typeof r=="string"&&r!=""?a.toLowerCase().endsWith(r.toLowerCase()):false){return a.substr(0,a.length-r.length)}}else if(i.endsWith("{0}")){r=i.substr(0,i.length-3);if(typeof r=="string"&&r!=""?a.toLowerCase().startsWith(r.toLowerCase()):false){return a.substr(r.length,a.length)}}else{r=i.split("{0}");if(r.length==2&&(typeof r[0]=="string"&&r[0]!=""?a.toLowerCase().startsWith(r[0].toLowerCase()):false)&&(typeof r[1]=="string"&&r[1]!=""?a.toLowerCase().endsWith(r[1].toLowerCase()):false)){return a.substr(r[0].length,a.length-r[1].length)}}return null}return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/format/ListFormat", ["sap/ui/core/Locale","sap/ui/core/LocaleData","sap/base/Log","sap/base/util/extend","sap/base/util/isEmptyObject","sap/ui/core/Configuration"],function(t,e,r,a,o,i){"use strict";var n=function(){throw new Error};n.oDefaultListFormat={type:"standard",style:"wide"};n.getInstance=function(t,e){return this.createInstance(t,e)};n.createInstance=function(r,o){var n=Object.create(this.prototype);if(r instanceof t){o=r;r=undefined}if(!o){o=i.getFormatSettings().getFormatLocale()}n.oLocale=o;n.oLocaleData=e.getInstance(o);n.oOriginalFormatOptions=a({},this.oDefaultListFormat,r);return n};n.prototype.format=function(t){if(!Array.isArray(t)){r.error("ListFormat can only format with an array given.");return""}var e=this.oOriginalFormatOptions,a,i,n,s,l,p,c=[].concat(t),f,u;a=this.oLocaleData.getListFormat(e.type,e.style);if(o(a)){r.error("No list pattern exists for the provided format options (type, style).");return""}function g(t,e){var r=t[0];for(var a=1;a<t.length;a++){r=e.replace("{0}",r);r=r.replace("{1}",t[a])}return r}if(a[c.length]){i=a[c.length];for(var h=0;h<c.length;h++){i=i.replace("{"+h+"}",c[h])}n=i}else if(c.length<2){n=c.toString()}else{f=c.shift();p=c.pop();u=c;s=a.start.replace("{0}",f);p=a.end.replace("{1}",p);l=g(u,a.middle);n=s.replace("{1}",p.replace("{0}",l))}return n};n.prototype.parse=function(t){if(typeof t!=="string"){r.error("ListFormat can only parse a String.");return[]}var e=[],a=[],i=[],s=[],l=[],p=this.oOriginalFormatOptions,c,f=/\{[01]\}/g,u,g,h,y,m;if(!p){p=n.oDefaultListFormat}c=this.oLocaleData.getListFormat(p.type,p.style);if(o(c)){r.error("No list pattern exists for the provided format options (type, style).");return[]}h=c.start.replace(f,"");y=c.middle.replace(f,"");m=c.end.replace(f,"");a=t.split(h);e=e.concat(a.shift());s=a.join(h).split(m);u=s.pop();i=s.join(m).split(y);e=e.concat(i);e.push(u);if(a.length<1||i.length<1||s.length<1){g=c["2"].replace(f,"");l=t.split(g);if(l.length===2){return l}if(t){return[t]}else{return[]}}return e};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/format/NumberFormat", ["sap/ui/base/Object","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/Supportability","sap/base/Log","sap/base/assert","sap/base/util/extend","sap/ui/core/Configuration"],function(e,r,t,i,n,a,o,s){"use strict";var u=e.extend("sap.ui.core.format.NumberFormat",{constructor:function(e){throw new Error}});var c=/\s/g,l=/\d/,g=/^(-?)0+(\d)/,f=/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6\u0020\xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000]/,m=/0+(\.0+)?/,p=/^0+$/;var d=function(e,r,t){var i=E(e);return new RegExp("^\\d+"+"(?:"+i+"?"+"\\d{"+r+"}"+")*"+""+i+"?"+"\\d{"+t+"}"+"$")};var h={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var C={FLOOR:"FLOOR",CEILING:"CEILING",TOWARDS_ZERO:"TOWARDS_ZERO",AWAY_FROM_ZERO:"AWAY_FROM_ZERO",HALF_FLOOR:"HALF_FLOOR",HALF_CEILING:"HALF_CEILING",HALF_TOWARDS_ZERO:"HALF_TOWARDS_ZERO",HALF_AWAY_FROM_ZERO:"HALF_AWAY_FROM_ZERO"};var y={};y[C.FLOOR]=Math.floor;y[C.CEILING]=Math.ceil;y[C.TOWARDS_ZERO]=function(e){return e>0?Math.floor(e):Math.ceil(e)};y[C.AWAY_FROM_ZERO]=function(e){return e>0?Math.ceil(e):Math.floor(e)};y[C.HALF_TOWARDS_ZERO]=function(e){return e>0?Math.ceil(e-.5):Math.floor(e+.5)};y[C.HALF_AWAY_FROM_ZERO]=function(e){return e>0?Math.floor(e+.5):Math.ceil(e-.5)};y[C.HALF_FLOOR]=function(e){return Math.ceil(e-.5)};y[C.HALF_CEILING]=Math.round;u.RoundingMode=C;u.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,strictGroupingValidation:false,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:h.INTEGER,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};u.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:h.FLOAT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};u.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:h.PERCENT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};u.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:h.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:"standard",style:"standard",showNumber:true,customCurrencies:undefined,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};u.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:h.UNIT,showMeasure:true,style:"standard",showNumber:true,customUnits:undefined,allowedUnits:undefined,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};u.getInstance=function(e,r){return this.getFloatInstance(e,r)};u.getFloatInstance=function(e,r){var t=this.createInstance(e,r),i=this.getLocaleFormatOptions(t.oLocaleData,h.FLOAT);t.oFormatOptions=o({},this.oDefaultFloatFormat,i,t.oOriginalFormatOptions);return t};u.getIntegerInstance=function(e,r){var t=this.createInstance(e,r),i=this.getLocaleFormatOptions(t.oLocaleData,h.INTEGER);t.oFormatOptions=o({},this.oDefaultIntegerFormat,i,t.oOriginalFormatOptions);return t};u.getCurrencyInstance=function(e,r){var t=this.createInstance(e,r);var i=t.oOriginalFormatOptions&&t.oOriginalFormatOptions.currencyContext;var n=O(t.oOriginalFormatOptions);if(n){i=i||this.oDefaultCurrencyFormat.style;i="sap-"+i}var a=this.getLocaleFormatOptions(t.oLocaleData,h.CURRENCY,i);t.oFormatOptions=o({},this.oDefaultCurrencyFormat,a,t.oOriginalFormatOptions);t.oFormatOptions.trailingCurrencyCode=n;t._defineCustomCurrencySymbols();return t};u.getUnitInstance=function(e,r){var t=this.createInstance(e,r),i=this.getLocaleFormatOptions(t.oLocaleData,h.UNIT);t.oFormatOptions=o({},this.oDefaultUnitFormat,i,t.oOriginalFormatOptions);return t};u.getPercentInstance=function(e,r){var t=this.createInstance(e,r),i=this.getLocaleFormatOptions(t.oLocaleData,h.PERCENT);t.oFormatOptions=o({},this.oDefaultPercentFormat,i,t.oOriginalFormatOptions);return t};u.createInstance=function(e,i){var n=Object.create(this.prototype),o;if(e instanceof r){i=e;e=undefined}if(!i){i=s.getFormatSettings().getFormatLocale()}n.oLocale=i;n.oLocaleData=t.getInstance(i);n.oOriginalFormatOptions=e;if(e){if(e.pattern){o=this.parseNumberPattern(e.pattern);Object.keys(o).forEach(function(r){e[r]=o[r]})}if(e.emptyString!==undefined){a(e.emptyString===""||e.emptyString===0||e.emptyString===null||e.emptyString!==e.emptyString,"The format option 'emptyString' must be either '', 0, null, or NaN")}}return n};u.getDefaultUnitPattern=function(e){return"{0} "+e};u.getLocaleFormatOptions=function(e,r,t){var i,n;switch(r){case h.PERCENT:n=e.getPercentPattern();break;case h.CURRENCY:n=e.getCurrencyPattern(t);break;case h.UNIT:n=e.getDecimalPattern();break;default:n=e.getDecimalPattern()}i=this.parseNumberPattern(n);i.plusSign=e.getNumberSymbol("plusSign");i.minusSign=e.getNumberSymbol("minusSign");i.decimalSeparator=e.getNumberSymbol("decimal");i.groupingSeparator=e.getNumberSymbol("group");i.percentSign=e.getNumberSymbol("percentSign");i.pattern=n;switch(r){case h.UNIT:case h.FLOAT:case h.PERCENT:i.minFractionDigits=0;i.maxFractionDigits=99;break;case h.INTEGER:i.minFractionDigits=0;i.maxFractionDigits=0;i.groupingEnabled=false;break;case h.CURRENCY:i.minFractionDigits=undefined;i.maxFractionDigits=undefined;break}return i};u.parseNumberPattern=function(e){var r=0,t=0,i=0,n=false,a=0,o=0,s=e.indexOf(";"),u={Integer:0,Fraction:1},c=u.Integer;if(s!==-1){e=e.substring(0,s)}for(var l=0;l<e.length;l++){var g=e[l];switch(g){case",":if(n){a=o;o=0}n=true;break;case".":c=u.Fraction;break;case"0":if(c===u.Integer){r++;if(n){o++}}else{t++;i++}break;case"#":if(c===u.Integer){if(n){o++}}else{i++}break}}if(!a){a=o;o=0}return{minIntegerDigits:r,minFractionDigits:t,maxFractionDigits:i,groupingEnabled:n,groupingSize:a,groupingBaseSize:o}};u.prototype._defineCustomCurrencySymbols=function(){var e=this.oFormatOptions;var r=this.oLocaleData.getCurrencySymbols();var t=function(e,r){var t=[];var i;for(var a in e){i=e[a];if(t.indexOf(i)===-1){t.push(i)}else if(i!==undefined){r[i]=true;n.error("Symbol '"+i+"' is defined multiple times in custom currencies.",undefined,"NumberFormat")}}};if(e.customCurrencies&&typeof e.customCurrencies==="object"){this.mKnownCurrencySymbols={};this.mKnownCurrencyCodes={};Object.keys(e.customCurrencies).forEach(function(t){if(e.customCurrencies[t].symbol){this.mKnownCurrencySymbols[t]=e.customCurrencies[t].symbol}else{var i=e.customCurrencies[t].isoCode;if(i){this.mKnownCurrencySymbols[t]=r[i]}}this.mKnownCurrencyCodes[t]=t}.bind(this))}else{this.mKnownCurrencySymbols=r;this.mKnownCurrencyCodes=this.oLocaleData.getCustomCurrencyCodes()}this.mDuplicatedSymbols={};t(this.mKnownCurrencySymbols,this.mDuplicatedSymbols)};function S(e,r){if(e.indexOf(".")>=0&&!v(e)&&e.endsWith("0")){var t=e.length-e.lastIndexOf(".")-1;var i=t-r;if(i>0){while(e.endsWith("0")&&i-- >0){e=e.substring(0,e.length-1)}if(e.endsWith(".")){e=e.substring(0,e.length-1)}}}return e}function b(e,r){var t=r.groupingSize,i=r.groupingBaseSize||t,n=e.length,a=Math.max(n-i,0)%t||t,o=e.slice(0,a);while(n-a>=i){o+=r.groupingSeparator;o+=e.slice(a,a+t);a+=t}o+=e.slice(a,n);return o}u.prototype.format=function(e,r){if(Array.isArray(e)){r=e[1];e=e[0]}var i="",a="",o="",s="",c="",l="",g=e<0,f=-1,m=Object.assign({},this.oFormatOptions),p=this.oOriginalFormatOptions,d=m.type===h.CURRENCY&&r==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",C,y,D,O,v,N,E=e===undefined||e===null;if(m.groupingEnabled&&m.groupingSize<=0){n.error("Grouping requires the 'groupingSize' format option to be a positive number, but it is '"+m.groupingSize+"' instead.");return""}if(m.showNumber&&(e===m.emptyString||isNaN(e)&&isNaN(m.emptyString))){return""}if(r!==undefined&&r!==null&&typeof r!=="string"&&!(r instanceof String)){return""}if(!m.showNumber&&!r){return""}if(E&&(!r||!m.showMeasure||m.showNumber)){return""}if(r&&m.customCurrencies&&!m.customCurrencies[r]){n.error("Currency '"+r+"' is unknown.");return""}if(!m.showNumber&&!m.showMeasure){return""}if(r&&m.type===h.UNIT){if(m.customUnits&&typeof m.customUnits==="object"){v=m.customUnits[r]}else{N=this.oLocaleData.getUnitFromMapping(r)||r;v=this.oLocaleData.getUnitFormat(N)}if(m.showMeasure){var A=!m.allowedUnits||m.allowedUnits.indexOf(r)>=0;if(!A){return""}}if(!v&&!m.showNumber){return this._addOriginInfo(r)}m.decimals=v&&(typeof v.decimals==="number"&&v.decimals>=0)?v.decimals:m.decimals;m.precision=v&&(typeof v.precision==="number"&&v.precision>=0)?v.precision:m.precision}if(m.type==h.CURRENCY){if(r&&m.trailingCurrencyCode){if(!this.mKnownCurrencyCodes[r]&&!/(^[A-Z]{3}$)/.test(r)){m.trailingCurrencyCode=false;m.pattern=this.oLocaleData.getCurrencyPattern(m.currencyContext)}}if(!m.showNumber){if(!m.currencyCode){var w;if(m.customCurrencies&&typeof m.customCurrencies==="object"){w=this.mKnownCurrencySymbols[r]}else{w=this.oLocaleData.getCurrencySymbol(r)}if(w&&w!==r){r=w}}return r}if(m.customCurrencies&&m.customCurrencies[r]){m.decimals=m.customCurrencies[r].decimals!==undefined?m.customCurrencies[r].decimals:m.decimals}}if(m.decimals!==undefined){m.minFractionDigits=m.decimals;m.maxFractionDigits=m.decimals}if(m.shortLimit===undefined||Math.abs(e)>=m.shortLimit){D=m.shortRefNumber===undefined?e:m.shortRefNumber;y=F(D,m,this.oLocaleData,d);if(y&&y.formatString!="0"){e=e/y.magnitude;if(m.shortDecimals!==undefined){m.minFractionDigits=m.shortDecimals;m.maxFractionDigits=m.shortDecimals}else{if(p.minFractionDigits===undefined&&p.maxFractionDigits===undefined&&p.decimals===undefined&&p.precision===undefined&&p.pattern===undefined){m.precision=2;m.minFractionDigits=0;m.maxFractionDigits=99}if(p.maxFractionDigits===undefined&&p.decimals===undefined){m.maxFractionDigits=99}}m.roundingMode=u.RoundingMode.HALF_AWAY_FROM_ZERO}}if((y||!m.ignorePrecision)&&m.precision!==undefined){m.maxFractionDigits=Math.min(m.maxFractionDigits,I(e,m.precision));m.minFractionDigits=Math.min(m.minFractionDigits,m.maxFractionDigits)}if(m.type==h.PERCENT){e=u._shiftDecimalPoint(e,2)}if(m.type==h.CURRENCY){var _=this.oLocaleData.getCurrencyDigits(r);if(m.customCurrencies&&m.customCurrencies[r]&&m.customCurrencies[r].decimals!==undefined){_=m.customCurrencies[r].decimals}if(m.maxFractionDigits===undefined){m.maxFractionDigits=_}if(m.minFractionDigits===undefined){m.minFractionDigits=_}}if(typeof e==="number"&&!m.preserveDecimals){e=R(e,m.maxFractionDigits,m.roundingMode)}if(e==0){g=false}if(m.preserveDecimals&&(typeof e==="string"||e instanceof String)){e=S(e,m.maxFractionDigits)}if(!E){c=t.convertToDecimal(e)}if(c=="NaN"){return c}if(g){c=c.substr(1)}f=c.indexOf(".");if(f>-1){i=c.substr(0,f);a=c.substr(f+1)}else{i=c}if(i.length<m.minIntegerDigits){i=i.padStart(m.minIntegerDigits,"0")}else if(i.length>m.maxIntegerDigits){i="".padStart(m.maxIntegerDigits,"?")}if(a.length<m.minFractionDigits){a=a.padEnd(m.minFractionDigits,"0")}else if(a.length>m.maxFractionDigits&&!m.preserveDecimals){a=a.substr(0,m.maxFractionDigits)}if(m.type===h.UNIT&&!m.showNumber){if(v){O=this._getPluralCategory(i,a,y);l=v["unitPattern-count-"+O];if(!l){l=v["unitPattern-count-other"]}if(!l){return this._addOriginInfo(r)}if(O!=="other"&&l.indexOf("{0}")===-1){l=v["unitPattern-count-other"];if(!l){return this._addOriginInfo(r)}}if(l.indexOf("{0}")===-1){n.warning("Cannot separate the number from the unit because unitPattern-count-other '"+l+"' does not include the number placeholder '{0}' for unit '"+r+"'")}else{return this._addOriginInfo(l.replace("{0}","").trim())}}}if(m.groupingEnabled){o=b(i,m)}else{o=i}if(g){s=m.minusSign}s+=o;if(a){s+=m.decimalSeparator+a}if(y&&y.formatString&&m.showScale&&m.type!==h.CURRENCY){O=this._getPluralCategory(i,a);y.formatString=this.oLocaleData.getDecimalFormat(m.style,y.key,O);s=y.formatString.replace(y.valueSubString,s);s=s.replace(/'.'/g,".")}if(m.type===h.CURRENCY){l=m.pattern;if(y&&y.formatString&&m.showScale){var M;if(m.trailingCurrencyCode){M="sap-short"}else{M="short"}O=this._getPluralCategory(i,a);if(d){l=L(M,y.key,O)}else{l=this.oLocaleData.getCurrencyFormat(M,y.key,O)}l=l.replace(/'.'/g,".")}C=l.split(";");if(C.length===2){l=g?C[1]:C[0];if(g){s=s.substring(m.minusSign.length)}}if(!m.currencyCode){var w;if(m.customCurrencies&&typeof m.customCurrencies==="object"){w=this.mKnownCurrencySymbols[r]}else{w=this.oLocaleData.getCurrencySymbol(r)}if(w&&w!==r){r=w}}s=this._composeCurrencyResult(l,s,r,{showMeasure:m.showMeasure,negative:g,minusSign:m.minusSign})}if(m.type===h.PERCENT){l=m.pattern;s=l.replace(/[0#.,]+/,s);s=s.replace(/%/,m.percentSign)}if(m.showMeasure&&r&&m.type===h.UNIT){O=this._getPluralCategory(i,a,y);if(v){l=v["unitPattern-count-"+O];if(!l){l=v["unitPattern-count-other"]}if(!l){l=u.getDefaultUnitPattern(r)}}else{l=u.getDefaultUnitPattern(r)}s=l.replace("{0}",s)}return this._addOriginInfo(s)};u.prototype._getPluralCategory=function(e,r,t){var i=e;if(r){i+="."+r}if(t){i+="c"+t.magnitude.toExponential().slice(2)}return this.oLocaleData.getPluralCategory(i)};u.prototype._addOriginInfo=function(e){if(i.collectOriginInfo()){e=new String(e);e.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()}}return e};u.prototype._composeCurrencyResult=function(e,r,t,i){var n=i.minusSign;e=e.replace(/[0#.,]+/,r);if(i.showMeasure&&t){var a="¤",o={"[:digit:]":l,"[[:^S:]&[:^Z:]]":f},s=e.indexOf(a),u=s<e.length/2?"after":"before",c=this.oLocaleData.getCurrencySpacing(u),g=u==="after"?t.charAt(t.length-1):t.charAt(0),m,p=o[c.currencyMatch],d=o[c.surroundingMatch],h;e=e.replace(a,t);m=u==="after"?e.charAt(s+t.length):e.charAt(s-1);if(p&&p.test(g)&&d&&d.test(m)){if(u==="after"){h=s+t.length}else{h=s}e=e.slice(0,h)+c.insertBetween+e.slice(h)}else if(i.negative&&u==="after"){n="\ufeff"+i.minusSign}}else{e=e.replace(/\s*\u00a4\s*/,"")}if(i.negative){e=e.replace(/-/,n)}return e};u.prototype.parse=function(e){var r=this.oFormatOptions,t=r.plusSign+this.oLocaleData.getLenientNumberSymbols("plusSign"),i=r.minusSign+this.oLocaleData.getLenientNumberSymbols("minusSign"),o=E(t+i),s=E(r.groupingSeparator),l=E(r.decimalSeparator),g="^\\s*(["+o+"]?(?:[0-9"+s+"]+|[0-9"+s+"]*"+l+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",f="^\\s*(["+o+"]?[0-9"+s+"]+)\\s*$",m=new RegExp(s,"g"),p=new RegExp(l,"g"),d=this.oLocaleData.getNumberSymbol("percentSign"),C=r.type===h.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",y,S,b,F,O=0,L,R;if(e===""){if(!r.showNumber){return null}R=r.emptyString;if(r.parseAsString&&(r.emptyString===0||isNaN(r.emptyString))){R=r.emptyString+""}if(r.type===h.CURRENCY||r.type===h.UNIT){return[R,undefined]}else{return R}}if(typeof e!=="string"&&!(e instanceof String)){return null}if(r.groupingSeparator===r.decimalSeparator){n.error("The grouping and decimal separator both have the same value '"+r.groupingSeparator+"'. "+"They must be different from each other such that values can be parsed correctly.")}F=r.type===h.PERCENT?r.pattern:this.oLocaleData.getPercentPattern();if(F.charAt(0)==="%"){g=g.slice(0,1)+"%?"+g.slice(1)}else if(F.charAt(F.length-1)==="%"){g=g.slice(0,g.length-1)+"%?"+g.slice(g.length-1)}var I;if(r.type===h.UNIT&&r.showMeasure){var w;if(r.customUnits&&typeof r.customUnits==="object"){w=r.customUnits}else{w=this.oLocaleData.getUnitFormats()}a(w,"Unit patterns cannot be loaded");if(r.allowedUnits){var M={};for(var x=0;x<r.allowedUnits.length;x++){var U=r.allowedUnits[x];M[U]=w[U]}w=M}var P=A(w,e,r.showNumber,this.oLocaleData.sCLDRLocaleId);var T=false;I=P.cldrCode;if(I.length===1){b=I[0];if(!r.showNumber){return[undefined,b]}}else if(I.length===0){if(r.unitOptional){P.numberValue=e}else{return null}}else{a(I.length===1,"Ambiguous unit ["+I.join(", ")+"] for input: '"+e+"'");b=undefined;T=true}if(r.strictParsing){if(T){return null}}e=P.numberValue||e}var k;if(r.type===h.CURRENCY&&r.showMeasure){k=_({value:e,currencySymbols:this.mKnownCurrencySymbols,customCurrencyCodes:this.mKnownCurrencyCodes,duplicatedSymbols:this.mDuplicatedSymbols,customCurrenciesAvailable:!!r.customCurrencies});if(!k){return null}if(r.strictParsing){if(!k.currencyCode||k.duplicatedSymbolFound){return null}}e=k.numberValue;b=k.currencyCode;if(r.customCurrencies&&b===null){return null}if(!r.showNumber){if(e){return null}return[undefined,b]}}e=e.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");e=e.replace(c,"");L=D(e,this.oLocaleData,C);if(L){e=L.number}var W=v(e);if(r.isInteger&&!L&&!W){y=new RegExp(f)}else{y=new RegExp(g)}if(!y.test(e)){return r.type===h.CURRENCY||r.type===h.UNIT?null:NaN}var Y=e.length;for(var z=0;z<Y;z++){var Z=e[z];if(t.includes(Z)){e=e.replace(Z,"+");break}else if(i.includes(Z)){e=e.replace(Z,"-");break}}e=e.replace(/^\+/,"");if(!r.isInteger&&e.indexOf(d)!==-1){S=true;e=e.replace(d,"")}var G=e;e=e.replace(m,"");if(L){e=e.replace(p,".");e=u._shiftDecimalPoint(e,Math.round(Math.log(L.factor)/Math.LN10))}if(r.isInteger){var H;if(W){e=e.replace(p,".");H=N(e);if(H===undefined){return NaN}}else{H=parseInt(e)}O=r.parseAsString?e:H}else{e=e.replace(p,".");O=r.parseAsString?e:parseFloat(e);if(S){O=u._shiftDecimalPoint(O,-2)}}var V=this._checkGrouping(G,r,W);if(!V){return r.type===h.CURRENCY||r.type===h.UNIT?null:NaN}if(r.parseAsString&&!S){O=u._shiftDecimalPoint(e,0)}if(r.type===h.CURRENCY||r.type===h.UNIT){return[O,b]}return O};u.prototype.getScale=function(){if(this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long"||this.oFormatOptions.shortRefNumber===undefined){return}var e=F(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),r;if(e&&e.formatString){r=e.formatString.replace(m,"").replace(/'.'/g,".").trim();if(r){return r}}};u._shiftDecimalPoint=function(e,r){if(typeof r!=="number"){return NaN}var t="";var i=e.toString().toLowerCase().split("e");if(typeof e==="number"){r=i[1]?+i[1]+r:r;return+(i[0]+"e"+r)}else if(typeof e==="string"){if(parseFloat(e)===0&&r>=0){return e.replace(g,"$1$2")}var n=i[0].charAt(0);t=n==="-"?n:"";if(t){i[0]=i[0].slice(1)}e=i[0];var a=e.indexOf("."),o,s,u;if(a===-1){e=e+".";a=e.length-1}if(i[1]){a+=+i[1]}o=a+r;if(o<=0){e=e.padStart(e.length-o+1,"0");o=1}else if(o>=e.length-1){e=e.padEnd(o+1,"0");o=e.length-1}e=e.replace(".","");s=e.substring(0,o);u=e.substring(o);s=s.replace(g,"$1$2");return t+s+(u?"."+u:"")}else{return null}};function F(e,r,t,i){var n,a,o,s,u=r.style,c=r.precision!==undefined?r.precision:2;if(u!="short"&&u!="long"){return undefined}for(var l=0;l<15;l++){a=Math.pow(10,l);if(R(Math.abs(e)/a,c-1)<10){break}}o=a.toString();if(r.type===h.CURRENCY){if(r.trailingCurrencyCode){u="sap-short"}if(i){s=L(u,o,"other",true)}else{s=t.getCurrencyFormat(u,o,"other")}}else{s=t.getDecimalFormat(u,o,"other")}if(!s||s=="0"){return undefined}else{n={};n.key=o;n.formatString=s;var g=s.match(m);if(g){n.valueSubString=g[0];var f=n.valueSubString.indexOf(".");if(f==-1){n.decimals=0;n.magnitude=a*Math.pow(10,1-n.valueSubString.length)}else{n.decimals=n.valueSubString.length-f-1;n.magnitude=a*Math.pow(10,1-f)}}else{return undefined}}return n}function D(e,r,t){var i,n=1,a=10,o=r.getPluralCategories(),s,u={number:undefined,factor:n},c=function(t,a,o,c){if(c){s=L(o,a.toString(),t,true)}else{s=r.getDecimalFormat(o,a.toString(),t)}if(s){s=s.replace(/[\s\u00a0\u200F]/g,"");s=s.replace(/'.'/g,".");var l=s.match(m);if(l){var g=l[0];var f=s.replace(g,"");if(!f){return}var p=e.indexOf(f);if(p>=0){i=e.replace(f,"");i=i.replace(/\u200F/g,"");n=a;n*=Math.pow(10,1-g.length);if(u.number===undefined||i.length<u.number.length){u.number=i;u.factor=n}}}}};["long","short"].forEach(function(e){a=10;while(a<1e15){for(var r=0;r<o.length;r++){var t=o[r];c(t,a,e)}a=a*10}});if(t&&!i){a=10;while(a<1e15){for(var l=0;l<o.length;l++){var g=o[l];c(g,a,"short",true)}a=a*10}}if(!i){return}return u}function O(e){var r=s.getFormatSettings().getTrailingCurrencyCode();if(e){if(e.trailingCurrencyCode!==undefined){r=e.trailingCurrencyCode}if(e.pattern){r=false}if(e.currencyCode===false){r=false}}return r}function L(e,r,t,i){var n,a={short:{"1000-one":"¤0000","1000-other":"¤0000","10000-one":"¤00000","10000-other":"¤00000","100000-one":"¤0 Lk","100000-other":"¤0 Lk","1000000-one":"¤00 Lk","1000000-other":"¤00 Lk","10000000-one":"¤0 Cr","10000000-other":"¤0 Cr","100000000-one":"¤00 Cr","100000000-other":"¤00 Cr","1000000000-one":"¤000 Cr","1000000000-other":"¤000 Cr","10000000000-one":"¤0000 Cr","10000000000-other":"¤0000 Cr","100000000000-one":"¤00000 Cr","100000000000-other":"¤00000 Cr","1000000000000-one":"¤0 Lk Cr","1000000000000-other":"¤0 Lk Cr","10000000000000-one":"¤00 Lk Cr","10000000000000-other":"¤00 Lk Cr","100000000000000-one":"¤0 Cr Cr","100000000000000-other":"¤0 Cr Cr"},"sap-short":{"1000-one":"0000 ¤","1000-other":"0000 ¤","10000-one":"00000 ¤","10000-other":"00000 ¤","100000-one":"0 Lk ¤","100000-other":"0 Lk ¤","1000000-one":"00 Lk ¤","1000000-other":"00 Lk ¤","10000000-one":"0 Cr ¤","10000000-other":"0 Cr ¤","100000000-one":"00 Cr ¤","100000000-other":"00 Cr ¤","1000000000-one":"000 Cr ¤","1000000000-other":"000 Cr ¤","10000000000-one":"0000 Cr ¤","10000000000-other":"0000 Cr ¤","100000000000-one":"00000 Cr ¤","100000000000-other":"00000 Cr ¤","1000000000000-one":"0 Lk Cr ¤","1000000000000-other":"0 Lk Cr ¤","10000000000000-one":"00 Lk Cr ¤","10000000000000-other":"00 Lk Cr ¤","100000000000000-one":"0 Cr Cr ¤","100000000000000-other":"0 Cr Cr ¤"}},o={short:{"1000-one":"0000","1000-other":"0000","10000-one":"00000","10000-other":"00000","100000-one":"0 Lk","100000-other":"0 Lk","1000000-one":"00 Lk","1000000-other":"00 Lk","10000000-one":"0 Cr","10000000-other":"0 Cr","100000000-one":"00 Cr","100000000-other":"00 Cr","1000000000-one":"000 Cr","1000000000-other":"000 Cr","10000000000-one":"0000 Cr","10000000000-other":"0000 Cr","100000000000-one":"00000 Cr","100000000000-other":"00000 Cr","1000000000000-one":"0 Lk Cr","1000000000000-other":"0 Lk Cr","10000000000000-one":"00 Lk Cr","10000000000000-other":"00 Lk Cr","100000000000000-one":"0 Cr Cr","100000000000000-other":"0 Cr Cr"}};o["sap-short"]=o["short"];var s=i?o:a;var u=s[e];if(!u){u=s["short"]}if(t!=="one"){t="other"}n=u[r+"-"+t];return n}u.prototype._checkGrouping=function(e,r,t){if(r.groupingSeparator&&e.includes(r.groupingSeparator)){e=e.replace(/^-/,"");e=e.replace(/^0+(\d)/,"$1");if(e.startsWith("0")||e.startsWith(r.groupingSeparator)){return false}if(t){e=e.replace(/[eE].*/,"")}var i=e.includes(r.decimalSeparator);if(r.decimalSeparator===r.groupingSeparator){i=false}else if(i){e=e.split(r.decimalSeparator)[0]}var n=e.split(r.groupingSeparator).length===2;if(n&&!i){var a=e.length-e.lastIndexOf(r.groupingSeparator);var o=r.groupingBaseSize||r.groupingSize;if(a!==o+r.groupingSeparator.length){return false}}if(r.strictGroupingValidation){if(!this._rGrouping){this._rGrouping=d(r.groupingSeparator,r.groupingSize,r.groupingBaseSize||r.groupingSize)}if(!this._rGrouping.test(e)){return false}}}return true};function v(e){return e.indexOf("e")>0||e.indexOf("E")>0}function N(e){var r=u._shiftDecimalPoint(e,0);if(r.indexOf(".")>0&&!p.test(r.split(".")[1])){return undefined}var t=parseFloat(r);var i=""+t;if(v(i)){i=u._shiftDecimalPoint(i,0)}var n=parseInt(i);if(n!==t){return undefined}return n}function R(e,r,t){if(typeof e!=="number"){return NaN}t=t||u.RoundingMode.HALF_AWAY_FROM_ZERO;r=parseInt(r);var i=""+e;if(!v(i)){var n=i.indexOf(".");if(n<0){return e}if(i.substring(n+1).length<=r){return e}}if(typeof t==="function"){e=t(e,r)}else{if(t.match(/^[a-z_]+$/)){t=t.toUpperCase()}if(!r){return y[t](e)}e=u._shiftDecimalPoint(y[t](u._shiftDecimalPoint(e,r)),-r)}return e}function E(e){return e.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1")}function I(e,r){var t=Math.floor(Math.log(Math.abs(e))/Math.LN10);return Math.max(0,r-t-1)}function A(e,r,t,i){var n,a,o,s,u,c,l,g,f,m,p,d={numberValue:undefined,cldrCode:[]},h=[],C=true,y=true,S=Number.POSITIVE_INFINITY,b=true,F=r.toLocaleLowerCase(i);for(f in e){for(a in e[f]){if(!a.startsWith("unitPattern")){continue}m=e[f][a];s=m.indexOf("{0}");n=s>-1;if(n&&!t){m=m.replace("{0}","").trim();n=false}o=undefined;C=true;if(n){l=m.substring(0,s);g=l.toLocaleLowerCase(i);u=m.substring(s+"{0}".length);c=u.toLocaleLowerCase(i);if(r.startsWith(l)&&r.endsWith(u)){o=r.substring(l.length,r.length-u.length)}else if(F.startsWith(g)&&F.endsWith(c)){C=false;o=r.substring(g.length,F.length-c.length)}if(o){if(o.length<S){S=o.length;b=C;d.numberValue=o;d.cldrCode=[f]}else if(o.length===S&&d.cldrCode.indexOf(f)===-1){if(C&&!b){d.numberValue=o;d.cldrCode=[f];b=true}else if(C||!b){d.cldrCode.push(f)}}}}else{p=m.toLocaleLowerCase(i);if(m===r||p===F){if(t){if(a.endsWith("-zero")){o="0"}else if(a.endsWith("-one")){o="1"}else if(a.endsWith("-two")){o="2"}if(m===r){d.numberValue=o;d.cldrCode=[f];return d}else if(!d.cldrCode.includes(f)){y=false;d.numberValue=o;d.cldrCode.push(f)}}else if(d.cldrCode.indexOf(f)===-1){if(m===r){d.cldrCode.push(f)}else if(!h.includes(f)){h.push(f)}}}}}}if((!b||!y)&&d.cldrCode.length>1){d.numberValue=undefined}if(!t&&!d.cldrCode.length){d.cldrCode=h}return d}function w(e,r,t){var i,n,a,o,u,l,g,f,m=false,p=false,d="";for(n in r){a=r[n];if(!a){continue}a=a.replace(c," ");if(e.indexOf(a)>=0&&d.length<=a.length){i=n;m=false;p=true;d=a;g=a}else if(t){l=s.getLanguageTag();o=a.toLocaleUpperCase(l);u=e.toLocaleUpperCase(l).indexOf(o);if(u>=0){if(d.length===a.length&&!p){m=true}else if(d.length<a.length){f=e.substring(u,u+a.length);if(f.toLocaleUpperCase(l)===o){i=n;m=false;p=false;d=a;g=f}}}}}if(m||!i){return{}}return{code:i,recognizedCurrency:g,symbol:d}}function _(e){var r,t=e.value.replace(c," ");var i=w(t,e.currencySymbols);if(!i.code){i=w(t,e.customCurrencyCodes,true);if(!i.code&&!e.customCurrenciesAvailable){r=t.match(/(^[A-Z]{3}|[A-Z]{3}$)/i);i.code=r&&r[0].toLocaleUpperCase(s.getLanguageTag());i.recognizedCurrency=r&&r[0]}}if(i.code){var a=i.recognizedCurrency.length-1;var o=i.recognizedCurrency.charAt(a);var u;var l=/[\-\s]+/;if(/\d$/.test(o)){if(t.startsWith(i.recognizedCurrency)){u=a+1;if(!l.test(t.charAt(u))){return undefined}}}else if(/^\d/.test(i.recognizedCurrency)){if(t.endsWith(i.recognizedCurrency)){u=t.indexOf(i.recognizedCurrency)-1;if(!l.test(t.charAt(u))){return undefined}}}t=t.replace(i.recognizedCurrency,"")}var g=false;if(e.duplicatedSymbols&&e.duplicatedSymbols[i.symbol]){i.code=undefined;g=true;n.error("The parsed currency symbol '"+i.symbol+"' is defined multiple "+"times in custom currencies.Therefore the result is not distinct.")}return{numberValue:t,currencyCode:i.code||undefined,duplicatedSymbolFound:g}}return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/format/TimezoneUtil", ["sap/base/i18n/date/TimezoneUtils"],function(e){"use strict";return e});
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/core/hyphenation/Hyphenation", ["./HyphenationTestingWords","sap/ui/base/ManagedObject","sap/base/Log","sap/ui/core/Locale","sap/ui/core/Configuration"],function(e,n,t,r,i){"use strict";var a={bg:true,ca:true,hr:true,cs:false,// no valid license
da:true,nl:true,"en-us":true,et:true,fi:true,fr:true,de:true,"el-monoton":true,hi:true,hu:true,it:true,lt:true,"nb-no":true,pl:false,// no valid license
pt:true,ru:true,sr:false,// no valid license
sl:true,es:true,sv:true,th:true,tr:true,uk:true};var o={bg:"Bulgarian",ca:"Catalan",hr:"Croatian",cs:"Czech",da:"Danish",nl:"Dutch",en:"English",et:"Estonian",fi:"Finnish",fr:"French",de:"German",el:"Greek",hi:"Hindi",hu:"Hungarian",it:"Italian",lt:"Lithuanian",nb:"Norwegian Bokmål",no:"Norwegian",pl:"Polish",pt:"Portuguese",ru:"Russian",sr:"Serbian",sl:"Slovenian",es:"Spanish",sv:"Swedish",th:"Thai",tr:"Turkish",uk:"Ukrainian"};var u={};var s={};var p={};var h=null;var l=null;var c={};function y(e){t.info("[UI5 Hyphenation] Initializing third-party module for language "+P(e),"sap.ui.core.hyphenation.Hyphenation.initialize()");var n=d();n.require[e]="FORCEHYPHENOPOLY";return f(sap.ui.require.toUrl("sap/ui/thirdparty/hyphenopoly/"),"Hyphenopoly_Loader.js").then(function(){delete n.require[e];return window.Hyphenopoly.hyphenators[e]})}function d(){if(!window.Hyphenopoly){window.Hyphenopoly={require:{},setup:{selectors:{".hyphenate":{hyphen:"­",leftmin:3,rightmin:3,compound:"all"}},hide:"DONT_HIDE"},handleEvent:{error:function(e){if(e.msg.match(/engine for language .* loaded, but no elements found./)){e.preventDefault()}}}}}return window.Hyphenopoly}function f(e,n){return new Promise(function(t,r){var i=document.createElement("script");i.async=true;i.src=e+n;i.addEventListener("load",t);i.addEventListener("error",function(){return r("Error loading script: "+n)});i.addEventListener("abort",function(){return r(n+" Script loading aborted.")});document.head.appendChild(i)})}var g=function e(){var n=["visibility:hidden;","-moz-hyphens:auto;","-webkit-hyphens:auto;","hyphens:auto;","width:48px;","font-size:12px;","line-height:12px;","border:none;","padding:0;","word-wrap:normal"];return n.join("")}();function v(e,n){if(!l){l=document.createElement("body")}var t=document.createElement("div");t.lang=e;t.id=e;t.style.cssText=g;t.appendChild(document.createTextNode(n));l.appendChild(t)}function m(e){if(l){e.appendChild(l);return l}return null}function H(){if(l){l.parentNode.removeChild(l)}}function b(e){return e.style.hyphens==="auto"||e.style.webkitHyphens==="auto"||e.style.msHyphens==="auto"||e.style["-moz-hyphens"]==="auto"}function w(e){var n;if(e){n=new r(e)}else{n=i.getLocale()}var t=n.getLanguage().toLowerCase();switch(t){case"en":t="en-us";break;case"nb":t="nb-no";break;case"no":t="nb-no";break;case"el":t="el-monoton";break;default:break}return t}function L(e){if(e){return new r(e).toString()}return i.getLocale().toString()}function I(e){if(typeof e==="string"){return e.substring(0,2)}else{return null}}function P(e){var n=I(e);if(o.hasOwnProperty(n)){return"'"+o[n]+"' (code:'"+n+"')"}else{return"'"+n+"'"}}function E(e){h.fireError(e);t.error("[UI5 Hyphenation] "+e,"sap.ui.core.hyphenation.Hyphenation")}var k=n.extend("sap.ui.core.hyphenation.Hyphenation",{metadata:{library:"sap.ui.core",events:{error:{parameters:{sErrorMessage:{type:"string"}}}}}});k.prototype.canUseNativeHyphenation=function(n){var r=L(n),i=w(n),a;if(!this.isLanguageSupported(i)){return null}if(!u.hasOwnProperty(r)){v(r,e[i.toLowerCase()]);var o=m(document.documentElement);if(o!==null){var s=document.getElementById(r);if(b(s)&&s.offsetHeight>12){a=true}else{a=false}H()}u[r]=a;if(a){t.info("[UI5 Hyphenation] Browser-native hyphenation can be used for language "+P(r),"sap.ui.core.hyphenation.Hyphenation.canUseNativeHyphenation()")}else{t.info("[UI5 Hyphenation] Browser-native hyphenation is not supported by current platform for language "+P(r),"sap.ui.core.hyphenation.Hyphenation.canUseNativeHyphenation()")}}else{a=u[r]}return a};k.prototype.canUseThirdPartyHyphenation=function(e){var n=w(e),r;if(!this.isLanguageSupported(e)){return null}if(!p.hasOwnProperty(n)){r=a.hasOwnProperty(n)&&a[n];if(r){t.info("[UI5 Hyphenation] Third-party hyphenation can be used for language "+P(n),"sap.ui.core.hyphenation.Hyphenation.canUseThirdPartyHyphenation()")}else{t.info("[UI5 Hyphenation] Third-party hyphenation is not supported for language "+P(n),"sap.ui.core.hyphenation.Hyphenation.canUseThirdPartyHyphenation()")}p[n]=r}else{r=p[n]}return r};k.prototype.isLanguageSupported=function(n){var r=w(n),i;if(!s.hasOwnProperty(r)){i=e.hasOwnProperty(r);if(!i){t.info("[UI5 Hyphenation] Language "+P(r)+" is not known to the Hyphenation API","sap.ui.core.hyphenation.Hyphenation.isLanguageSupported()")}s[r]=i}else{i=s[r]}return i};k.prototype.hyphenate=function(e,n){var t=w(n);if(!c.hasOwnProperty(t)){E("Language "+P(t)+" is not initialized. You have to initialize it first with method 'initialize()'");return e}return c[t](e)};k.prototype.getInitializedLanguages=function(){return Object.keys(c).map(function(e){return I(e)})};k.prototype.isLanguageInitialized=function(e){var n=w(e);return Object.keys(c).indexOf(n)!=-1};k.prototype.initialize=function(e){var n=w(e);if(!a[n]){var t="Language "+P(e)+" can not be initialized. It is either not supported by the third-party module or an error occurred";E(t);return Promise.reject(t)}if(c[n]){return Promise.resolve()}var r;if(!this._pInitLanguage){r=this._pInitLanguage=y(n).then(function(e){c[n]=e;this._pInitLanguage=null}.bind(this))}else{r=this._pInitLanguage.then(function(){return this.initialize(e)}.bind(this))}return r};k.getInstance=function(){if(!h){h=new k}return h};return k});
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/core/hyphenation/HyphenationTestingWords", [],function(){"use strict";var i={bg:"непротивоконституционствувателствувайте",ca:"psiconeuroimmunoendocrinologia",hr:"prijestolonasljednikovičičinima",cs:"nejnezdevětadevadesáteronásobitelnějšími",da:"gedebukkebensoverogundergeneralkrigskommandersergenten",nl:"meervoudigepersoonlijkheidsstoornissen","en-us":"pneumonoultramicroscopicsilicovolcanoconiosis",et:"sünnipäevanädalalõpupeopärastlõunaväsimus",fi:"kolmivaihekilowattituntimittari",fr:"hippopotomonstrosesquippedaliophobie",de:"Kindercarnavalsoptochtvoorbereidingswerkzaamhedenplan","el-monoton":"ηλεκτροεγκεφαλογράφημα",hi:"किंकर्तव्यविमूढ़",hu:"megszentségteleníthetetlenségeskedéseitekért",it:"hippopotomonstrosesquippedaliofobia",lt:"nebeprisikiškiakopūstlapiaujančiuosiuose","nb-no":"supercalifragilisticexpialidocious",pl:"dziewięćdziesięciokilkuletniemu",pt:"pneumoultramicroscopicossilicovulcanoconiose",ru:"превысокомногорассмотрительствующий",sr:"семпаравиливичинаверсаламилитипиковски",sl:"dialektičnomaterialističen",es:"electroencefalografistas",sv:"realisationsvinstbeskattning",th:"ตัวอย่างข้อความที่จะใช้ในการยืนยันการถ่ายโอน",tr:"muvaffakiyetsizleştiricileştiriveremeyebileceklerimizdenmişsinizcesine",uk:"нікотинамідаденіндинуклеотидфосфат"};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/library", ["sap/ui/base/DataType","sap/ui/core/Lib","sap/ui/core/message/MessageType","sap/ui/core/mvc/ViewType","./CalendarType"],function(e,i,o,r,a){"use strict";var t=i.init({name:"sap.ui.core",version:"1.120.10",designtime:"sap/ui/core/designtime/library.designtime",...{apiVersion:2},types:["any","boolean","float","int","object","string","void","sap.ui.core.AbsoluteCSSSize","sap.ui.core.AccessibleRole","sap.ui.core.AccessibleLandmarkRole","sap.ui.core.aria.HasPopup","sap.ui.core.BarColor","sap.ui.core.BusyIndicatorSize","sap.ui.core.CalendarType","sap.ui.core.CSSColor","sap.ui.core.CSSSize","sap.ui.core.CSSSizeShortHand","sap.ui.core.Collision","sap.ui.core.ComponentLifecycle","sap.ui.core.Design","sap.ui.core.Dock","sap.ui.core.HorizontalAlign","sap.ui.core.ID","sap.ui.core.IconColor","sap.ui.core.ImeMode","sap.ui.core.IndicationColor","sap.ui.core.MessageType","sap.ui.core.OpenState","sap.ui.core.Orientation","sap.ui.core.Percentage","sap.ui.core.Priority","sap.ui.core.ScrollBarAction","sap.ui.core.Scrolling","sap.ui.core.SortOrder","sap.ui.core.TextAlign","sap.ui.core.TextDirection","sap.ui.core.TitleLevel","sap.ui.core.URI","sap.ui.core.ValueState","sap.ui.core.VerticalAlign","sap.ui.core.Wrapping","sap.ui.core.InvisibleMessageMode","sap.ui.core.dnd.DropEffect","sap.ui.core.dnd.DropLayout","sap.ui.core.dnd.DropPosition","sap.ui.core.mvc.ViewType","sap.ui.core.routing.HistoryDirection"],interfaces:["sap.ui.core.IShrinkable","sap.ui.core.Label","sap.ui.core.PopupInterface","sap.ui.core.Toolbar","sap.ui.core.IContextMenu","sap.ui.core.IFormContent","sap.ui.core.dnd.IDragInfo","sap.ui.core.dnd.IDropInfo","sap.ui.core.IDScope","sap.ui.core.ITitleContent","sap.ui.core.IAsyncContentCreation","sap.ui.core.IPlaceholderSupport","sap.ui.core.IColumnHeaderMenu"],controls:["sap.ui.core.ComponentContainer","sap.ui.core.Control","sap.ui.core.HTML","sap.ui.core.Icon","sap.ui.core.InvisibleText","sap.ui.core.LocalBusyIndicator","sap.ui.core.ScrollBar","sap.ui.core.TooltipBase","sap.ui.core.XMLComposite","sap.ui.core.mvc.HTMLView","sap.ui.core.mvc.JSONView","sap.ui.core.mvc.JSView","sap.ui.core.mvc.TemplateView","sap.ui.core.mvc.View","sap.ui.core.mvc.XMLView","sap.ui.core.tmpl.DOMElement","sap.ui.core.tmpl.TemplateControl","sap.ui.core.util.Export"],elements:["sap.ui.core.CustomData","sap.ui.core.Element","sap.ui.core.Item","sap.ui.core.LayoutData","sap.ui.core.ListItem","sap.ui.core.Message","sap.ui.core.SeparatorItem","sap.ui.core.Title","sap.ui.core.VariantLayoutData","sap.ui.core.dnd.DragDropBase","sap.ui.core.dnd.DragInfo","sap.ui.core.dnd.DropInfo","sap.ui.core.dnd.DragDropInfo","sap.ui.core.search.OpenSearchProvider","sap.ui.core.search.SearchProvider","sap.ui.core.tmpl.DOMAttribute","sap.ui.core.util.ExportCell","sap.ui.core.InvisibleMessage"],extensions:{"sap.ui.support":{diagnosticPlugins:["sap/ui/core/support/plugins/TechInfo","sap/ui/core/support/plugins/ControlTree","sap/ui/core/support/plugins/Debugging","sap/ui/core/support/plugins/Trace","sap/ui/core/support/plugins/Selector","sap/ui/core/support/plugins/Breakpoint","sap/ui/core/support/plugins/ViewInfo","sap/ui/core/support/plugins/LocalStorage","sap/ui/core/support/plugins/Interaction","sap/ui/core/support/plugins/Performance"],publicRules:true,internalRules:true}}});t.AbsoluteCSSSize=e.createType("sap.ui.core.AbsoluteCSSSize",{isValid:function(e){return/^([-+]?(0*|([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]))|calc\(\s*(\(\s*)*[-+]?(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC])?)(\s*(\)\s*)*(\s[-+]\s|[*\/])\s*(\(\s*)*([-+]?(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC])?)))*\s*(\)\s*)*\))$/.test(e)}},e.getType("string"));t.AccessibleRole={Alert:"Alert",AlertDialog:"AlertDialog",Application:"Application",Banner:"Banner",Button:"Button",Checkbox:"Checkbox",ColumnHeader:"ColumnHeader",Combobox:"Combobox",
/**
		 * Information about the content on the page. Examples are footnotes, copyrights, or links to privacy statements.
		 *
		 * @public
		 */
ContentInfo:"ContentInfo",Definition:"Definition",Description:"Description",Dialog:"Dialog",Directory:"Directory",Document:"Document",Grid:"Grid",GridCell:"GridCell",Group:"Group",Heading:"Heading",Img:"Img",Link:"Link",List:"List",Listbox:"Listbox",ListItem:"ListItem",Log:"Log",Main:"Main",Marquee:"Marquee",Menu:"Menu",Menubar:"Menubar",MenuItem:"MenuItem",MenuItemCheckbox:"MenuItemCheckbox",MenuItemRadio:"MenuItemRadio",Navigation:"Navigation",Note:"Note",Option:"Option",Presentation:"Presentation",ProgressBar:"ProgressBar",Radio:"Radio",RadioGroup:"RadioGroup",Region:"Region",Row:"Row",RowHeader:"RowHeader",Search:"Search",Secondary:"Secondary",SeeAlso:"SeeAlso",Separator:"Separator",Slider:"Slider",SpinButton:"SpinButton",Status:"Status",Tab:"Tab",Tablist:"Tablist",Tabpanel:"Tabpanel",Textbox:"Textbox",Timer:"Timer",Toolbar:"Toolbar",Tooltip:"Tooltip",Tree:"Tree",TreeGrid:"TreeGrid",TreeItem:"TreeItem"};e.registerEnum("sap.ui.core.AccessibleRole",t.AccessibleRole);t.AccessibleLandmarkRole={None:"None",Banner:"Banner",Main:"Main",Region:"Region",Navigation:"Navigation",Search:"Search",Complementary:"Complementary",Form:"Form",ContentInfo:"ContentInfo"};e.registerEnum("sap.ui.core.AccessibleLandmarkRole",t.AccessibleLandmarkRole);t.aria=t.aria||{};t.aria.HasPopup={None:"None",Menu:"Menu",ListBox:"ListBox",Tree:"Tree",Grid:"Grid",Dialog:"Dialog"};e.registerEnum("sap.ui.core.aria.HasPopup",t.aria.HasPopup);t.BarColor={NEUTRAL:"NEUTRAL",POSITIVE:"POSITIVE",CRITICAL:"CRITICAL",NEGATIVE:"NEGATIVE"};e.registerEnum("sap.ui.core.BarColor",t.BarColor);t.BusyIndicatorSize={Auto:"Auto",Small:"Small",Medium:"Medium",Large:"Large",Section:"Section"};e.registerEnum("sap.ui.core.BusyIndicatorSize",t.BusyIndicatorSize);t.CalendarType=a;t.CSSColor=e.createType("sap.ui.core.CSSColor",{isValid:function(e){return/^(#([0-9a-fA-F]{3}|[0-9a-fA-F]{6})|rgb\(\s*((1?[0-9]?[0-9]|2([0-4][0-9]|5[0-5]))|([0-9]?[0-9](\.[0-9]+)?|100(\.0+)?)%)\s*(,\s*((1?[0-9]?[0-9]|2([0-4][0-9]|5[0-5]))|([0-9]?[0-9](\.[0-9]+)?|100(\.0+)?)%)\s*){2}\)|rgba\((\s*((1?[0-9]?[0-9]|2([0-4][0-9]|5[0-5]))|([0-9]?[0-9](\.[0-9]+)?|100(\.0+)?)%)\s*,){3}\s*(0(\.[0-9]+)?|1(\.0+)?)\s*\)|hsl\(\s*([0-2]?[0-9]?[0-9]|3([0-5][0-9]|60))\s*(,\s*(([0-9]?[0-9](\.[0-9]+)?|100(\.0+)?)%)\s*){2}\)|hsla\(\s*([0-2]?[0-9]?[0-9]|3([0-5][0-9]|60))\s*,(\s*(([0-9]?[0-9](\.[0-9]+)?|100(\.0+)?)%)\s*,){2}\s*(0(\.[0-9]+)?|1(\.0+)?)\s*\)|aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgrey|darkgreen|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|grey|green|greenyellow|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgrey|lightgreen|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silverskyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen|transparent|inherit|)$/.test(e)}},e.getType("string"));t.CSSSize=e.createType("sap.ui.core.CSSSize",{isValid:function(e){return/^(auto|inherit|[-+]?(0*|([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|[vV][wW]|[vV][hH]|[vV][mM][iI][nN]|[vV][mM][aA][xX]|%))|calc\(\s*(\(\s*)*[-+]?(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|[vV][wW]|[vV][hH]|[vV][mM][iI][nN]|[vV][mM][aA][xX]|%)?)(\s*(\)\s*)*(\s[-+]\s|[*\/])\s*(\(\s*)*([-+]?(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|[vV][wW]|[vV][hH]|[vV][mM][iI][nN]|[vV][mM][aA][xX]|%)?)))*\s*(\)\s*)*\))$/.test(e)}},e.getType("string"));t.CSSSizeShortHand=e.createType("sap.ui.core.CSSSizeShortHand",{isValid:function(e){return/^(inherit|(auto|[-+]?(0*|(\d+|\d*\.\d+)([eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|%))){1}(\s(auto|[-+]?(0*|(\d+|\d*\.\d+)([eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|%)))){0,3})$/.test(e)}},e.getType("string"));t.Collision=e.createType("sap.ui.core.Collision",{isValid:function(e){return/^((flip|fit|flipfit|none)( (flip|fit|flipfit|none))?)$/.test(e)}},e.getType("string"));t.Design={Standard:"Standard",Monospace:"Monospace"};e.registerEnum("sap.ui.core.Design",t.Design);t.Dock=e.createType("sap.ui.core.Dock",{isValid:function(e){return/^((begin|left|center|right|end) (top|center|bottom))$/.test(e)}},e.getType("string"));t.HorizontalAlign={Begin:"Begin",End:"End",Left:"Left",Right:"Right",Center:"Center"};e.registerEnum("sap.ui.core.HorizontalAlign",t.HorizontalAlign);t.ID=e.createType("sap.ui.core.ID",{isValid:function(e){return/^([A-Za-z_][-A-Za-z0-9_.:]*)$/.test(e)}},e.getType("string"));t.IconColor={Default:"Default",Positive:"Positive",Negative:"Negative",Critical:"Critical",Neutral:"Neutral",Contrast:"Contrast",NonInteractive:"NonInteractive",Tile:"Tile",Marker:"Marker"};e.registerEnum("sap.ui.core.IconColor",t.IconColor);t.ImeMode={Auto:"Auto",Active:"Active",Inactive:"Inactive",Disabled:"Disabled"};e.registerEnum("sap.ui.core.ImeMode",t.ImeMode);t.IndicationColor={Indication01:"Indication01",Indication02:"Indication02",Indication03:"Indication03",Indication04:"Indication04",Indication05:"Indication05",Indication06:"Indication06",Indication07:"Indication07",Indication08:"Indication08",Indication09:"Indication09",Indication10:"Indication10",Indication11:"Indication11",Indication12:"Indication12",Indication13:"Indication13",Indication14:"Indication14",Indication15:"Indication15",Indication16:"Indication16",Indication17:"Indication17",Indication18:"Indication18",Indication19:"Indication19",Indication20:"Indication20"};e.registerEnum("sap.ui.core.IndicationColor",t.IndicationColor);t.OpenState={OPEN:"OPEN",CLOSED:"CLOSED",OPENING:"OPENING",CLOSING:"CLOSING"};e.registerEnum("sap.ui.core.OpenState",t.OpenState);t.Orientation={Horizontal:"Horizontal",Vertical:"Vertical"};e.registerEnum("sap.ui.core.Orientation",t.Orientation);t.Percentage=e.createType("sap.ui.core.Percentage",{isValid:function(e){return/^([0-9][0-9]*(\.[0-9]+)?%)$/.test(e)}},e.getType("string"));t.Priority={None:"None",Low:"Low",Medium:"Medium",High:"High"};e.registerEnum("sap.ui.core.Priority",t.Priority);t.ScrollBarAction={Step:"Step",Page:"Page",MouseWheel:"MouseWheel",Drag:"Drag"};e.registerEnum("sap.ui.core.ScrollBarAction",t.ScrollBarAction);t.Scrolling={None:"None",Auto:"Auto",Scroll:"Scroll",Hidden:"Hidden"};e.registerEnum("sap.ui.core.Scrolling",t.Scrolling);t.SortOrder={None:"None",Ascending:"Ascending",Descending:"Descending"};e.registerEnum("sap.ui.core.SortOrder",t.SortOrder);t.TextAlign={Begin:"Begin",End:"End",Left:"Left",Right:"Right",Center:"Center",Initial:"Initial"};e.registerEnum("sap.ui.core.TextAlign",t.TextAlign);t.TextDirection={LTR:"LTR",RTL:"RTL",Inherit:"Inherit"};e.registerEnum("sap.ui.core.TextDirection",t.TextDirection);t.TitleLevel={Auto:"Auto",H1:"H1",H2:"H2",H3:"H3",H4:"H4",H5:"H5",H6:"H6"};e.registerEnum("sap.ui.core.TitleLevel",t.TitleLevel);t.URI=e.createType("sap.ui.core.URI",{isValid:function(e){return/^((([^:\/?#]+):)?(\/\/([^\/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?)$/.test(e)}},e.getType("string"));t.ValueState={Error:"Error",Warning:"Warning",Success:"Success",Information:"Information",None:"None"};e.registerEnum("sap.ui.core.ValueState",t.ValueState);t.VerticalAlign={Bottom:"Bottom",Middle:"Middle",Top:"Top",Inherit:"Inherit"};e.registerEnum("sap.ui.core.VerticalAlign",t.VerticalAlign);t.Wrapping={None:"None",Soft:"Soft",Hard:"Hard",Off:"Off"};e.registerEnum("sap.ui.core.Wrapping",t.Wrapping);t.dnd=t.dnd||{};t.dnd.DropPosition={On:"On",Between:"Between",OnOrBetween:"OnOrBetween"};e.registerEnum("sap.ui.core.dnd.DropPosition",t.dnd.DropPosition);t.dnd.RelativeDropPosition={On:"On",Before:"Before",After:"After"};e.registerEnum("sap.ui.core.dnd.RelativeDropPosition",t.dnd.RelativeDropPosition);t.dnd.DropLayout={Default:"Default",Vertical:"Vertical",Horizontal:"Horizontal"};e.registerEnum("sap.ui.core.dnd.DropLayout",t.dnd.DropLayout);t.dnd.DropEffect={Copy:"Copy",Move:"Move",Link:"Link",None:"None"};e.registerEnum("sap.ui.core.dnd.DropEffect",t.dnd.DropEffect);t.mvc=t.mvc||{};t.MessageType=o;e.registerEnum("sap.ui.core.MessageType",t.MessageType);t.mvc.ViewType=r;t.routing=t.routing||{};t.routing.HistoryDirection={Forwards:"Forwards",Backwards:"Backwards",NewEntry:"NewEntry",Unknown:"Unknown"};t.ComponentLifecycle={Legacy:"Legacy",Application:"Application",Container:"Container"};e.registerEnum("sap.ui.core.ComponentLifecycle",t.ComponentLifecycle);t.InvisibleMessageMode={Polite:"Polite",Assertive:"Assertive"};e.registerEnum("sap.ui.core.InvisibleMessageMode",t.InvisibleMessageMode);(function(){var e=sap.ui.lazyRequire;function i(i,o,r){for(var a=0;a<o.length;a++){if(r){e(r,o[a].toLowerCase(),i+o[a])}else{e(i+o[a],"new extend getMetadata")}}}e("sap.ui.core.message.MessageManager");e("sap.ui.core.BusyIndicator","show hide attachOpen detachOpen attachClose detachClose");e("sap.ui.core.tmpl.Template","registerType unregisterType");e("sap.ui.core.Fragment","registerType byId createId");e("sap.ui.core.IconPool","createControlByURI addIcon getIconURI getIconInfo isIconURI getIconCollectionNames getIconNames getIconForMimeType");e("sap.ui.core.service.ServiceFactoryRegistry","register unregister get");e("sap.ui.model.odata.AnnotationHelper","createPropertySetting format getNavigationPath"+" gotoEntitySet gotoEntityType gotoFunctionImport isMultiple resolvePath simplePath");var o=sap.ui.model&&sap.ui.model.odata&&sap.ui.model.odata.AnnotationHelper;if(o){o.format.requiresIContext=true;o.getNavigationPath.requiresIContext=true;o.isMultiple.requiresIContext=true;o.simplePath.requiresIContext=true}e("sap.ui","xmlfragment","sap.ui.core.Fragment");e("sap.ui","jsfragment","sap.ui.core.Fragment");e("sap.ui","htmlfragment","sap.ui.core.Fragment");i("sap.ui.model.",["Filter","Sorter","json.JSONModel","resource.ResourceModel","odata.ODataModel","odata.v2.ODataModel","odata.v4.ODataModel","xml.XMLModel"]);i("sap.ui.model.type.",["Boolean","Integer","Float","String","Date","Time","DateTime","FileSize","Currency","Unit","DateInterval","DateTimeInterval","TimeInterval"]);i("sap.ui.model.odata.type.",["Boolean","Byte","Currency","Date","DateTime","DateTimeOffset","DateTimeWithTimezone","Decimal","Double","Guid","Int16","Int32","Int64","Raw","SByte","Single","Stream","String","Time","TimeOfDay","Unit"]);i("sap.ui.core.",["Locale","LocaleData","mvc.Controller","UIComponent"]);i("sap.ui.core.mvc.",["Controller","View","JSView","JSONView","XMLView","HTMLView","TemplateView"],"sap.ui");i("sap.ui.core.",["Component"],"sap.ui");i("sap.ui.core.tmpl.",["Template"],"sap.ui");i("sap.ui.core.routing.",["HashChanger","History","Route","Router","Target","Targets","Views"]);i("sap.ui.core.service.",["ServiceFactory","Service"])})();return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/message/MessageManager", ["sap/ui/core/Messaging","sap/ui/base/Object","sap/base/Log"],function(e,s,r){"use strict";var t=s.extend("sap.ui.core.message.MessageManager",{constructor:function(){r.error("MessageManager is deprecated and should not be created! "+"Please require 'sap/ui/core/Messaging' instead and use the module export directly without using 'new'.");s.apply(this,arguments)},metadata:{publicMethods:["addMessages","removeMessages","updateMessages","removeAllMessages","registerMessageProcessor","unregisterMessageProcessor","registerObject","unregisterObject","getMessageModel","destroy"]}});t.prototype.addMessages=e.addMessages;t.prototype.removeAllMessages=e.removeAllMessages;t.prototype.removeMessages=e.removeMessages;t.prototype.updateMessages=e.updateMessages;t.prototype.registerMessageProcessor=e.registerMessageProcessor;t.prototype.unregisterMessageProcessor=e.unregisterMessageProcessor;t.prototype.registerObject=e.registerObject;t.prototype.unregisterObject=e.unregisterObject;t.prototype.destroy=function(){r.warning("Deprecated: Do not call destroy on a MessageManager")};t.prototype.getMessageModel=e.getMessageModel;return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/message/MessageMixin", ["sap/ui/core/Element","sap/ui/core/library","sap/base/Log","sap/ui/core/LabelEnablement"],function(e,t,i,a){"use strict";var s=t.ValueState;var n=function(){this.refreshDataState=r;this.fnDestroy=this.destroy;this.destroy=g};function r(t,n){if(n.getChanges().messages&&this.getBinding(t)&&this.getBinding(t).isA("sap.ui.model.PropertyBinding")){var r=n.getMessages();var g=a.getReferencingLabels(this);var o=g[0];var l=false;r.forEach(function(t){if(g&&g.length>0){var a=e.getElementById(o);if(a.getMetadata().isInstanceOf("sap.ui.core.Label")&&a.getText){if(t.getAdditionalText()!==a.getText()){t.setAdditionalText(a.getText());l=true}}else{i.warning("sap.ui.core.message.Message: Can't create labelText."+"Label with id "+o+" is no valid sap.ui.core.Label.",this)}}if(t.getControlId()!==this.getId()){t.addControlId(this.getId());l=true}}.bind(this));var d=sap.ui.require("sap/ui/core/Messaging");if(d){var h=d.getMessageModel();h.checkUpdate(l,true)}if(r&&r.length>0){var u=r[0];if(s[u.type]){this.setValueState(u.type);this.setValueStateText(u.message)}}else{this.setValueState(s.None);this.setValueStateText("")}}}function g(){var e=this.getId();function t(t){t.removeControlId(e)}for(var i in this.mBindingInfos){var a=this.mBindingInfos[i];if(a.binding){var s=a.binding.getDataState();var n=s.getAllMessages();n.forEach(t)}}this.fnDestroy.apply(this,arguments)}return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/message/MessageParser", ["sap/ui/base/Object","sap/base/Log"],function(e,s){"use strict";var r=e.extend("sap.ui.core.message.MessageParser",{metadata:{publicMethods:["parse","setProcessor"]},constructor:function(){this._processor=null}});r.prototype.setProcessor=function(e){this._processor=e;return this};r.prototype.getProcessor=function(){return this._processor};r.prototype.parse=function(e,r){s.error("MessageParser: parse-method must be implemented in the specific parser class. Messages "+"have been ignored.")};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/Controller", ["sap/base/util/ObjectPath","sap/base/util/extend","sap/ui/base/EventProvider","sap/ui/base/ManagedObject","sap/ui/core/mvc/ControllerMetadata","sap/ui/core/mvc/ControllerExtension","sap/ui/core/mvc/ControllerExtensionProvider","sap/ui/core/mvc/OverrideExecution","sap/base/Log"],function(e,t,n,r,o,i,a,s,l){"use strict";var u={};var d=n.extend("sap.ui.core.mvc.Controller",{metadata:{stereotype:"controller",methods:{byId:{public:true,final:true},getInterface:{public:false,final:true},getMetadata:{public:true,final:true},getView:{public:true,final:true},isA:{public:true,final:true},onExit:{public:false,final:false,overrideExecution:s.Before},onInit:{public:false,final:false,overrideExecution:s.After},onAfterRendering:{public:false,final:false,overrideExecution:s.After},onBeforeRendering:{public:false,final:false,overrideExecution:s.Before}}},constructor:function(e){var r=null;if(typeof e=="string"){if(!u[e]){l.warning("Do not call sap.ui.core.mvc.Controller constructor for non typed scenario!")}r=u[e]}n.apply(this,arguments);if(r){t(this,u[e])}if(this.extension){throw new Error("The keyword 'extension' cannot be used as a member of a controller")}this["_sapui_Extensions"]={};d.extendByMember(this,false);this._sapui_isExtended=false;this._aDestroyables=[]},_isExtended:function(){return this._sapui_isExtended},getInterface:function(){var e={};var t=this.getMetadata();var n=t._aAllPublicMethods;n.forEach(function(t){var n=this[t];if(typeof n==="function"){e[t]=function(){var e=n.apply(this,arguments);return e instanceof d?e.getInterface():e}.bind(this)}}.bind(this));this.getInterface=function(){return e};return e}},o);function f(t,n,r){var o=n.getMetadata().getName();var a=t.getMetadata();var s=t["_sapui_Extensions"];var u=t.getInterface();var d=i.getMetadata().getLifecycleConfiguration();var f={namespace:o,extension:n,reloadNeeded:false};n._setController(u);if(n.getMetadata().hasOverrides()){var c,p,h,g,v=n.getMetadata().getOverrides(),x=n.getMetadata().getStaticOverrides();for(g in x){h=n.getMetadata();if(!h.isMethodFinal(g)){i.overrideMethod(g,n,x,n,h.getOverrideExecution(g))}else{l.error("[FUTURE FATAL] Method '"+g+"' of extension '"+o+"' is flagged final and cannot be overridden by calling 'override'")}}for(g in v){if(g!=="extension"){if(g in n.base){l.debug("Overriding  member '"+g+"' of original controller.");var y=v[g];var E=t[g];if(typeof E=="object"&&typeof y=="object"){p=s[g];h=p.extension.getMetadata();for(c in y){if(!h.isMethodFinal(c)){i.overrideMethod(c,E,y,n,h.getOverrideExecution(c))}else{l.error("[FUTURE FATAL] Method '"+c+"' of extension '"+p.namespace+"' is flagged final and cannot be overridden by extension '"+o+"'")}}}else if(!a.isMethodFinal(g)){i.overrideMethod(g,t,v,n,a.getOverrideExecution(g))}else{l.error("[FUTURE FATAL] Method '"+g+"' of controller '"+t.getMetadata().getName()+"' is flagged final and cannot be overridden by extension '"+o+"'")}}else if(g in d){i.overrideMethod(g,t,v,n,a.getOverrideExecution(g))}else if(g.startsWith("extHook")&&t[g]===null){i.overrideMethod(g,t,v,n)}else{l.error("[FUTURE FATAL] Method '"+g+"' does not exist in controller "+t.getMetadata().getName()+" and cannot be overridden")}}f.reloadNeeded=true}if(v&&v.extension){for(var b in v.extension){h=s[b].extension.getMetadata();var m=e.create(b,t.extension);var M=s[b].extension;var w=v.extension[b];for(c in w){if(!h.isMethodFinal(c)){i.overrideMethod(c,m,w,n,h.getOverrideExecution(c));i.overrideMethod(c,M,w,n,h.getOverrideExecution(c))}else{l.error("[FUTURE FATAL] Method '"+c+"' of extension '"+b+"' is flagged final and cannot be overridden by extension '"+o+"'")}}}}}var C=n.getInterface();if(r){s[r]=f;f.location=r;t[r]=C;u[r]=C}else{s[o]=f;f.location="extension."+o;e.set("extension."+o,C,t);e.set("extension."+o,C,u)}}function c(e,t,n){if(t instanceof i){f(e,t,n)}else if(t.getMetadata&&t.getMetadata().getStereotype()=="controllerextension"){var r=new t;f(e,r,n)}else{var o=i.getMetadata().getLifecycleConfiguration();for(var a in t){if(a in o){i.overrideMethod(a,e,t,e,o[a].overrideExecution)}else{i.overrideMethod(a,e,t)}}}}function p(t,n){if(!t){throw new Error("Controller name ('sName' parameter) is required")}var r=t.replace(/\./g,"/")+".controller",o=i(sap.ui.require(r));function i(n){if(n){return n}else if(u[t]){return d}else{return e.get(t)}}if(!n){if(!o){o=sap.ui.requireSync(r);return i(o)}else{return o}}return new Promise(function(e,t){if(!o){sap.ui.require([r],function(t){e(i(t))},t)}else{e(o)}})}function h(e,t){var n;if(u[t]){n=new e(t)}else{n=new e}if(!n){throw new Error("Controller "+t+" couldn't be instantiated")}return n}d.extendByMember=function(e,t){var n;for(n in e){if(e[n]&&e[n].getMetadata&&e[n].getMetadata().getStereotype()=="controllerextension"){e[n]=new e[n]}}for(n in e){if(e[n]&&e[n].getMetadata&&e[n].getMetadata().getStereotype()=="controllerextension"){c(e,e[n],n)}}if(t){return Promise.resolve(e)}else{return e}};d.applyExtensions=function(e,t,n,r,o){function i(e,t){if(e){return p(t,true).then(function(e){e=u[t]||e;if(e!==undefined){if(e.getMetadata&&e.getMetadata().isA("sap.ui.core.mvc.Controller")){l.fatal("[FUTURE-FATAL] Attempt to load Extension Controller "+t+" was not successful","Controller extension should be a plain object.",null,function(){return{type:"ControllerExtension",name:t}})}return e}},function(e){l.error("[FUTURE FATAL] Attempt to load Extension Controller "+t+" was not successful - is the Controller correctly defined in its file?")})}else{if(!u[t]&&!sap.ui.require(t)){p(t)}if(u[t]!==undefined){return u[t]}else{l.error("Attempt to load Extension Controller "+t+" was not successful - is the Controller correctly defined in its file?",null,function(){return{type:"ControllerExtension",name:t}});return{}}}}if(o){return a.getControllerExtensions(t,n,r,o).then(function(t){var n=t.customizingControllerNames.map(function(e){return i(true,e)});return Promise.all(n).then(function(n){var r=n.concat(t.providerControllers);for(var o=0,i=r.length;o<i;o++){c(e,r[o])}return e})},function(t){l.error("[FUTURE FATAL] Controller Extension Provider: Error '"+t+"' thrown in "+d._sExtensionProvider+"; extension provider ignored.");return e})}else{var s=a.getControllerExtensions(t,n,r,o);var f=s.customizingControllerNames.map(i.bind(null,false));var h=f.concat(s.providerControllers);for(var g=0,v=h.length;g<v;g++){c(e,h[g])}}return e};d.create=function(e){return g(e.name,undefined,true,e._viewId)};sap.ui.controller=function(e,t,n,r){if(n){l.info("Do not use deprecated factory function 'sap.ui.controller("+e+")'. Use 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:e}})}else{l.warning("Do not use synchronous controller creation for controller '"+e+"'! Use the new asynchronous factory 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:e}})}return g.apply(this,arguments)};function g(e,t,n,o){var i,a,s=r._sOwnerId;if(typeof t==="boolean"){t=undefined}if(!t){if(n){return p(e,n).then(function(t){return h(t,e)}).then(function(t){return d.applyExtensions(t,e,s,o,n)}).then(function(e){e._sapui_isExtended=true;return e})}else{a=p(e,n);i=h(a,e);i=d.applyExtensions(i,e,s,o,n);i._sapui_isExtended=true}return i}else{u[e]=t;l.info("For defining controllers use Controller.extend instead")}}d.prototype.getPublicMethods=function(){var e={},n=this.getMetadata(),r=n.getAllMethods(),o=n.getLifecycleConfiguration();Object.keys(r).forEach(function(t){if(n.isMethodPublic(t)){e[t]=r[t];e[t].reloadNeeded=!!(t in o)}});delete e.extension;var i=this["_sapui_Extensions"];Object.keys(i).forEach(function(n){var r=i[n];var o=r.extension.getInterface();var a=r.extension.getMetadata().getAllMethods();Object.keys(o).forEach(function(n){delete e[r.location];var o=t({},a[n],{reloadNeeded:r.reloadNeeded});e[r.location+"."+n]=o})});return e};d.prototype._getDestroyables=function(){if(!this._aDestroyables){l.error("[FUTURE FATAL] Mandatory super constructor not called for Controller: '"+this.getMetadata().getName()+"'.",null,"sap.ui.support",function(){return{type:"missingSuperConstructor"}});this._aDestroyables=[]}return this._aDestroyables};d.prototype.destroyFragments=function(){function e(e){e=Array.isArray(e)?e:[e];for(var t=0;t<e.length;t++){if(!e[t].isDestroyed()){e[t].destroy()}}}var t=this._getDestroyables();for(var n=0;n<t.length;n++){t[n]=t[n].then(e)}};d.prototype.destroy=function(){if(this["_sapui_Extensions"]){Object.keys(this["_sapui_Extensions"]).forEach(function(t){var n=this["_sapui_Extensions"][t];e.set(n.location,null,this)}.bind(this));delete this["_sapui_Extensions"]}n.prototype.destroy.apply(this,arguments)};d.prototype.getView=function(){return this.oView};d.prototype.byId=function(e){return this.oView?this.oView.byId(e):undefined};d.prototype.createId=function(e){return this.oView?this.oView.createId(e):undefined};d.prototype.getOwnerComponent=function(){var e=sap.ui.require("sap/ui/core/Component");if(e){return e.getOwnerComponentFor(this.getView())}else{return undefined}};d.prototype.connectToView=function(e){this.oView=e;if(this.onInit){e.attachAfterInit(this.onInit,this)}if(this.onExit){e.attachBeforeExit(this.onExit,this)}if(e.bControllerIsViewManaged){e.attachBeforeExit(this.destroyFragments,this)}if(this.onAfterRendering){e.attachAfterRendering(this.onAfterRendering,this)}if(this.onBeforeRendering){e.attachBeforeRendering(this.onBeforeRendering,this)}};d.prototype.loadFragment=function(e){if(!this.getView()){throw new Error("Calling 'loadFragment' without a view attached is not supported!")}else if(!e||!e.name){throw new Error("oOptions must provide at least a fragment name!")}var t=this.getOwnerComponent();var n=e.addToDependents!==false;var r=e.autoPrefixId!==false;var o={name:e.name,type:e.type,id:e.id,controller:this};var i=this._getDestroyables();var a=new Promise(function(e,t){sap.ui.require(["sap/ui/core/Fragment"],function(t){e(t)},t)}).then(function(n){if(!e.id&&r){o.id=this.getView().getId()}else if(r){o.id=this.createId(e.id)}if(t){return t.runAsOwner(function(){return n.load(o)})}else{return n.load(o)}}.bind(this)).then(function(e){if(n){this.getView().applySettings({dependents:e})}i.splice(i.indexOf(a),1);return e}.bind(this));i.push(a);return a};d._sExtensionProvider=null;d.registerExtensionProvider=function(e){d._sExtensionProvider=e;a.registerExtensionProvider(e)};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/ControllerExtension", ["sap/ui/base/Object","sap/ui/base/Metadata","sap/ui/core/mvc/ControllerMetadata","sap/ui/core/mvc/OverrideExecution","sap/base/util/uid","sap/base/Log"],function(e,t,i,n,a,r){"use strict";var o=e.extend("sap.ui.core.mvc.ControllerExtension",{metadata:{stereotype:"controllerextension",methods:{byId:{public:true,final:true},getInterface:{public:false,final:true},getMetadata:{public:true,final:true},getView:{public:true,final:true},isA:{public:true,final:true}}},_setController:function(e){this.base=e},byId:function(e){var t=this.getMetadata().getNamespace();e=t+"."+e;return this.base?this.base.byId(e):undefined},getView:function(){return this.base.getView()},getInterface:function(){var e={};var t=this.getMetadata();var i=t._aAllPublicMethods;i.forEach(function(t){var i=this[t];if(typeof i==="function"){e[t]=function(){var e=i.apply(this,arguments);return e instanceof o?e.getInterface():e}.bind(this)}}.bind(this));this.getInterface=function(){return e};return e}},i);o.override=function(e){var n=t.createClass(this,"anonymousExtension~"+a(),{},i);n.getMetadata()._staticOverride=e;n.getMetadata()._override=this.getMetadata()._override;return n};o.overrideMethod=function(e,t,i,a,o){var s=t[e];var f=i[e];o=o||n.Instead;function u(i){(function(i,n,a,r){t[e]=function(){if(r){i.apply(a,arguments);return n.apply(t,arguments)}else{n.apply(t,arguments);return i.apply(a,arguments)}}})(f,s,a,i)}if(typeof f==="function"&&a){f=f.bind(a)}switch(o){case n.Before:if(s&&typeof s==="function"){u(true)}else if(typeof f==="function"){t[e]=f}else{r.error("[FUTURE FATAL] Controller extension failed: lifecycleMethod '"+e+"', is not a function")}break;case n.After:if(s&&typeof s==="function"){u(false)}else if(typeof f==="function"){t[e]=f}else{r.error("[FUTURE FATAL] Controller extension failed: lifecycleMethod '"+e+"', is not a function")}break;case n.Instead:default:if(e in t){r.debug("Overriding  member '"+e+"' of extension "+this.getMetadata().getName());if(!this.getMetadata().isMethodFinal(e)){t[e]=f}else{r.error("[FUTURE FATAL] Error in ControllerExtension.override: Method '"+e+"' of extension '"+this.getMetadata().getName()+"' is flagged final and cannot be overridden!")}}else{t[e]=f}break}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/ControllerExtensionProvider", ["sap/base/Log","sap/ui/core/Component"],function(e,r){"use strict";var n={};var o={};o._sExtensionProvider=null;o.registerExtensionProvider=function(e){o._sExtensionProvider=e};o.getControllerExtensions=function(n,s,l,u){var a={customizingControllerNames:[],providerControllers:[]};var v=r.getComponentById(s);if(v&&v.getLocalId){l=v.getLocalId(l)||l}var f=t(n,v,l);a.customizingControllerNames=f;if(u){if(o._sExtensionProvider){return i(u).then(function(e){return e.getControllerExtensions(n,s,u,l)}).then(function(e){a.providerControllers=e||[];return a})}else{return Promise.resolve(a)}}else{if(o._sExtensionProvider){var c=i();if(c){var d=c.getControllerExtensions(n,s,u,l);if(d&&Array.isArray(d)){a.providerControllers=d}else{e.error("[FUTURE FATAL] Controller Extension Provider: Error in ExtensionProvider.getControllerExtensions: "+o._sExtensionProvider+" - no valid extensions returned. Return value must be an array of ControllerExtensions.")}}}return a}};function t(e,n,o){var t=[];var i=r.getCustomizing(n,{type:"sap.ui.controllerExtensions",name:e+"#"+o});var s=[];if(i){s.push(i)}else{var l=r.getCustomizing(n,{type:"sap.ui.controllerExtensions",name:e});if(l){s.push(l)}}for(var u=0;u<s.length;u++){var a=s[u];if(a){var v=typeof a==="string"?a:a.controllerName;t=t.concat(a.controllerNames||[]);if(v){t.unshift(v)}}}return t}function i(e){var r=o._sExtensionProvider.replace(/\./g,"/"),t=n[r];if(t){return e?Promise.resolve(t):t}if(r){if(e){return new Promise(function(e,o){sap.ui.require([r],function(o){t=new o;n[r]=t;e(t)},o)})}else{var i=sap.ui.requireSync(r);t=new i;n[r]=t;return t}}else{return e?Promise.resolve():undefined}}return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/ControllerMetadata", ["sap/ui/base/Metadata","sap/base/util/merge","sap/ui/core/mvc/OverrideExecution","sap/base/Log"],function(t,e,i,r){"use strict";var o=function(e,i){t.apply(this,arguments);if(this.isA("sap.ui.core.mvc.ControllerExtension")&&this.getParent().getClass().override){this.getClass().override=this.getParent().getClass().override}};o.prototype=Object.create(t.prototype);o.prototype.constructor=o;o.prototype.applySettings=function(o){if(o.overrides||o.override){this._override=o.overrides||o.override;delete o.override;delete o.overrides}t.prototype.applySettings.call(this,o);var s=o.metadata;this._defaultLifecycleMethodMetadata={onInit:{public:true,final:false,overrideExecution:i.After},onExit:{public:true,final:false,overrideExecution:i.Before},onBeforeRendering:{public:true,final:false,overrideExecution:i.Before},onAfterRendering:{public:true,final:false,overrideExecution:i.After}};var a=this.isA("sap.ui.core.mvc.ControllerExtension");var n=/^_/;var h=this._oParent.isA("sap.ui.core.mvc.Controller");var d=o.metadata&&o.metadata.methods?true:false;if(!a){if(h&&!d){n=/^_|^on|^init$|^exit$/}if(h&&d){e(s.methods,this._defaultLifecycleMethodMetadata)}}if(a||d){this._aPublicMethods=[]}this._mMethods=s.methods||{};for(var l in o){if(l!=="metadata"&&l!=="constructor"){if(!l.match(n)){if(h&&this._oParent&&this._oParent.isMethodFinal(l)){r.error("[FUTURE FATAL] Method: '"+l+"' of controller '"+this._oParent.getName()+"' is final and cannot be overridden by controller '"+this.getName()+"'");delete this._oClass.prototype[l]}if(!(l in this._mMethods)&&typeof o[l]==="function"){if(!(o[l].getMetadata&&o[l].getMetadata().isA("sap.ui.core.mvc.ControllerExtension"))){this._mMethods[l]={public:true,final:false}}}}}}for(var c in this._mMethods){if(this.isMethodPublic(c)){this._aPublicMethods.push(c)}}};o.prototype.afterApplySettings=function(){t.prototype.afterApplySettings.call(this);var i=this.isA("sap.ui.core.mvc.ControllerExtension");if(this._oParent){var r=this._oParent._mMethods?this._oParent._mMethods:{};for(var o in r){if(this._mMethods[o]&&!i){var s=this._mMethods[o].public;this._mMethods[o]=e({},r[o]);if(s!==undefined){this._mMethods[o].public=s}if(!this.isMethodPublic(o)&&this._mMethods[o].public!==r[o].public){this._aAllPublicMethods.splice(this._aAllPublicMethods.indexOf(o),1)}}else{this._mMethods[o]=r[o]}}}if(this._oParent&&this._oParent.isA("sap.ui.core.mvc.ControllerExtension")){this._bFinal=true}};o.prototype.getNamespace=function(){var t=this._sClassName.indexOf("anonymousExtension~")==0;var e=t?this._oParent._sClassName:this._sClassName;return e.substr(0,e.lastIndexOf("."))};o.prototype.isMethodFinal=function(t){var e=this._mMethods[t];return e&&e.final};o.prototype.isMethodPublic=function(t){var e=this._mMethods[t];return e&&e.public};o.prototype.getAllMethods=function(){return this._mMethods};o.prototype.getOverrideExecution=function(t){var e=this._mMethods[t];var r=i.Instead;if(e){r=e.overrideExecution}return r};o.prototype.getOverrides=function(){return this._override};o.prototype.getStaticOverrides=function(){return this._staticOverride};o.prototype.hasOverrides=function(){return!!this._override||!!this._staticOverride};o.prototype.getLifecycleConfiguration=function(){return this._defaultLifecycleMethodMetadata};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/EventHandlerResolver", ["sap/ui/base/BindingParser","sap/ui/core/CommandExecution","sap/ui/model/BindingMode","sap/ui/model/CompositeBinding","sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel","sap/base/util/JSTokenizer","sap/base/util/ObjectPath","sap/base/util/resolveReference","sap/base/Log","sap/ui/base/DesignTime"],function(e,t,r,n,a,i,s,o,d,l,f){"use strict";var p={resolveEventHandler:function(r,n,s){var o,p,m;r=r.trim();if(f.isControllerCodeDeactivated()){o=function(){}}else{if(r.startsWith("cmd:")){var c=r.substr(4);o=function(e){var n=t.find(e.getSource(),c);if(n){n.trigger()}else{l.error("[FUTURE FATAL] Handler '"+r+"' could not be resolved. No CommandExecution defined for command: "+c)}};o._sapui_commandName=c}else{p=r.indexOf("(");m=r;if(p>0){m=r.substring(0,p).trim()}else if(p===0){throw new Error("Event handler name starts with a bracket, must start with a function name "+"(or with a dot followed by controller-local function name): "+r)}o=d(m,Object.assign({".":n},s),{preferDotContext:m.indexOf(".")===-1,bindContext:false})}if(o&&p>0){var g=r.lastIndexOf(")");if(g>p){if(r.substring(p).indexOf("{=")>-1){l.warning("[FUTURE FATAL] It looks like an event handler parameter contains a binding expression ({=...}). This is not allowed and will cause an error later on "+"because the entire event handler is already considered an expression: "+r)}o=function(t,n){return function(o){var d,l,f=r;if(r.indexOf("$parameters")>-1){d=new a(o.mParameters)}if(r.indexOf("$source")>-1){l=new i(o.getSource())}var p={$controller:n,$event:o};if(t.indexOf(".")>0){var m=t.split(".")[0];p[m]=window[m]}else if(t.indexOf(".")===-1){if(n&&n[t]){f="$controller."+f}else if(window[t]){p[t]=window[t]}}Object.assign(p,s);var c=e.parseExpression(f.replace(/^\./,"$controller."),0,{oContext:n},p);if(c.result){try{u(c.result,o.getSource(),n,d,l)}catch(e){e.message="Error when evaluating event handler '"+r+"': "+e.message;throw e}}if(d){d.destroy()}if(l){l.destroy()}}}(m,n)}else{l.error("[FUTURE FATAL] Syntax error in event handler '"+r+"': arguments must be enclosed in a pair of brackets")}}}if(typeof o==="function"){o._sapui_handlerName=r;return[o,n]}l.warning("[FUTURE FATAL] Event handler name '"+r+"' could not be resolved to an event handler function")},parse:function e(t){t=t.trim();var r=new s;var n=[];var a="";var i=0;r.init(t,0);for(;;){var o=r.next();if(o==='"'||o==="'"){var d=r.getIndex();r.string();a+=t.slice(d,r.getIndex());o=r.getCh()}if(!o){break}switch(o){case"(":i++;break;case")":i--;break;default:break}if(o===";"&&i===0){n.push(a.trim());a=""}else{a+=o}}if(a){n.push(a.trim())}return n}};function u(e,t,a,i,s){var o,d;e.mode=r.OneWay;if(!e.parts){e.parts=[];e.parts[0]={path:e.path,targetType:e.targetType,type:e.type,suspended:e.suspended,formatOptions:e.formatOptions,constraints:e.constraints,model:e.model,mode:e.mode};delete e.path;delete e.targetType;delete e.mode;delete e.model}for(var l=0;l<e.parts.length;l++){d=e.parts[l];if(typeof d=="string"){d={path:d};e.parts[l]=d}if(!d.path&&d.parts){throw new Error("Bindings in event handler parameters cannot use parts. Just use one single path.")}var f=d.path.indexOf(">");if(f>0){d.model=d.path.substr(0,f);d.path=d.path.substr(f+1)}}var p,u,m=[];e.parts.forEach(function(n){var a;if(n.model==="$parameters"){a=i;p=i.createBindingContext("/")}else if(n.model==="$source"){a=s;p=s.createBindingContext("/")}else{a=t.getModel(n.model);p=t.getBindingContext(n.model)}o=n.type;u=a.bindProperty(n.path,p,e.parameters);u.setType(o,n.targetType||"any");u.setFormatter(n.formatter);u.setBindingMode(r.OneTime);m.push(u)});if(m.length>1||e.formatter&&e.formatter.textFragments){o=e.type;u=new n(m,e.useRawValues,e.useInternalValues);u.setType(o,d.targetType||"any");u.setBindingMode(r.OneTime)}else{u=m[0]}u.setFormatter(e.formatter);u.initialize();return u.getExternalValue()}return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/HTMLView", ["./View","./HTMLViewRenderer","./ViewType","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/DeclarativeSupport","sap/ui/model/resource/ResourceModel","sap/base/util/LoaderExtensions"],function(e,t,r,n,o,i,a,l){"use strict";var s=e.extend("sap.ui.core.mvc.HTMLView",{metadata:{library:"sap.ui.core",deprecated:true},renderer:t});s.create=function(t){var o=n({},t);o.type=r.HTML;return e.create(o)};sap.ui.htmlview=function(e,t){return sap.ui.view(e,t,r.HTML)};s._sType=r.HTML;s.asyncSupport=true;s._mTemplates={};s._mAllowedSettings={viewName:true,controller:true,viewContent:true,definition:true,controllerName:true,resourceBundleName:true,resourceBundleUrl:true,resourceBundleLocale:true,resourceBundleAlias:true};s._getTemplate=function(e,t){var r=this._getViewUrl(e);var n=this._mTemplates[r];if(!n){n=this._loadTemplate(e,t);if(t&&t.async){var o=this;return n.then(function(e){o._mTemplates[r]=e;return Promise.resolve(e)})}else{this._mTemplates[r]=n}}return t.async?Promise.resolve(n):n};s.prototype.getControllerName=function(){return this._controllerName};s._getViewUrl=function(e){return sap.ui.require.toUrl(e.replace(/\./g,"/"))+".view.html"};s._loadTemplate=function(e,t){var r=e.replace(/\./g,"/")+".view.html";return l.loadResource(r,t)};s.prototype.initViewSettings=function(e){if(!e){throw new Error("mSettings must be given")}if(e.viewName&&e.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.")}else if(!e.viewName&&!e.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.")}var t=this;function r(){t._oTemplate=document.createElement("div");if(typeof n==="string"){t._oTemplate.innerHTML=n}else{var r=n;var o=document.createDocumentFragment();for(var l=0;l<r.length;l++){o.appendChild(r.item(l))}t._oTemplate.appendChild(o)}var u=t._oTemplate.getElementsByTagName("template")[0];var c=t.getMetadata().getAllProperties();if(u){var m=u.getAttributeNames();for(var p=0;p<m.length;p++){var d=m[p];var v=i.convertAttributeToSettingName(d,t.getId());var f=u.getAttribute(d);var h=c[v];if(!e[v]){if(h){e[v]=i.convertValueToType(i.getPropertyDataType(h),f)}else if(s._mAllowedSettings[v]){e[v]=f}}}t._oTemplate=u}if(t._oTemplate.content){var o=t._oTemplate.content;t._oTemplate=document.createElement("div");t._oTemplate.appendChild(o)}if(e.controllerName){t._controllerName=e.controllerName}if((e.resourceBundleName||e.resourceBundleUrl)&&(!e.models||!e.models[e.resourceBundleAlias])){var g=new a({bundleName:e.resourceBundleName,bundleUrl:e.resourceBundleUrl,bundleLocale:e.resourceBundleLocale,async:e.async});var _=g.getResourceBundle();if(_ instanceof Promise){return _.then(function(){t.setModel(g,e.resourceBundleAlias)})}t.setModel(g,e.resourceBundleAlias)}}var n=e.viewContent;if(!n){n=s._getTemplate(e.viewName,{async:e.async})}if(e.async){return n.then(function(e){n=e;return r()})}r()};s.prototype.onControllerConnected=function(e){var t=this;o.runWithPreprocessors(function(){i.compile(t._oTemplate,t)},{settings:this._fnSettingsPreprocessor})};s.prototype.exit=function(){this._oTemplate=null;e.prototype.exit.call(this);if(this._connectedControls){for(var t=0;t<this._connectedControls.length;t++){this._connectedControls[t].destroy()}this._connectedControls=null}};s.prototype.connectControl=function(e){this._connectedControls=this._connectedControls||[];this._connectedControls.push(e)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/HTMLViewRenderer", ["./ViewRenderer"],function(e){"use strict";var r={apiVersion:1};r.render=function(i,t){i.openStart("div",t);i.class("sapUiView");i.class("sapUiHTMLView");e.addDisplayClass(i,t);i.style("width",t.getWidth());i.style("height",t.getHeight());i.openEnd();if(t._oTemplate){var a=t._oTemplate.innerHTML;var n=t.getContent();var s=[];var l=function(e){var t=r._getHTML(i,e,a);if(t){a=t}else{s.push(e)}};if(n){if(Array.isArray(n)){for(var d=0;d<n.length;d++){l(n[d])}}else if(n){l(n)}}i.unsafeHtml(a);for(var v=0;v<s.length;v++){i.renderControl(s[v])}}i.close("div")};r._getHTML=function(e,r,i){var t=r.getId();i=i.replace(/(<div)/gi,"\n$1");var a=new RegExp('<div.*?data-sap-ui-id="'+t+'".*?></div>',"gi");var n=a.exec(i);if(n){i=i.replace(n[0],e.getHTML(r));return i}else{return""}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/JSONView", ["./View","./JSONViewRenderer","./ViewType","./EventHandlerResolver","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/model/resource/ResourceModel","sap/base/Log","sap/base/util/LoaderExtensions"],function(e,t,n,r,i,o,s,a,u){"use strict";var c=e.extend("sap.ui.core.mvc.JSONView",{metadata:{library:"sap.ui.core"},renderer:t});c.create=function(t){var r=i({},t);for(var o in r){if(o==="preprocessors"){delete r["preprocessors"];a.warning("JSONView.create does not support the option preprocessors!")}}r.type=n.JSON;return e.create(r)};sap.ui.jsonview=function(e,t){return sap.ui.view(e,t,n.JSON)};c._sType=n.JSON;c.asyncSupport=true;c.prototype.initViewSettings=function(e){if(!e){throw new Error("mSettings must be given")}if(e.viewName&&e.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.")}else if(!e.viewName&&!e.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.")}var t=this;var n=function(){if((t._oJSONView.resourceBundleName||t._oJSONView.resourceBundleUrl)&&(!e.models||!e.models[t._oJSONView.resourceBundleAlias])){var n=new s({bundleName:t._oJSONView.resourceBundleName,bundleUrl:t._oJSONView.resourceBundleUrl,async:e.async});var r=n.getResourceBundle();if(r instanceof Promise){return r.then(function(){t.setModel(n,t._oJSONView.resourceBundleAlias)})}t.setModel(n,t._oJSONView.resourceBundleAlias)}};if(e.viewName){if(e.async){return this._loadTemplate(e.viewName,{async:true}).then(n)}else{this._loadTemplate(e.viewName);n()}}else if(e.viewContent){this.mProperties["viewContent"]=e.viewContent;if(typeof e.viewContent==="string"){this._oJSONView=JSON.parse(e.viewContent);if(!this._oJSONView){throw new Error("error when parsing viewContent: "+e.viewContent)}}else if(typeof e.viewContent==="object"){this._oJSONView=e.viewContent}else{throw new Error("viewContent must be a JSON string or object, but is a "+typeof e.viewContent)}if(e.async){return Promise.resolve().then(n)}else{n()}}};c.prototype.onControllerConnected=function(e){var t=this;o.runWithPreprocessors(function(){t.applySettings({content:t._oJSONView.content},e)},{id:function(e){return t.createId(e)},settings:function(n){var i=this.getMetadata(),o=i.getJSONKeys(),s,a,u;for(s in n){if((u=o[s])!==undefined){a=n[s];switch(u._iKind){case 3:if(typeof a==="string"){n[s]=t.createId(a)}break;case 5:if(typeof a==="string"){n[s]=r.resolveEventHandler(a,e)}break}}}}})};c.prototype._loadTemplate=function(e,t){var n=e.replace(/\./g,"/")+".view.json";if(!t||!t.async){this._oJSONView=u.loadResource(n)}else{var r=this;return u.loadResource(n,t).then(function(e){r._oJSONView=e})}};c.prototype.getControllerName=function(){return this._oJSONView.controllerName};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/JSONViewRenderer", ["./ViewRenderer"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,i){t.openStart("div",i);t.class("sapUiView");t.class("sapUiJSONView");e.addDisplayClass(t,i);t.style("width",i.getWidth());t.style("height",i.getHeight());t.openEnd();i.getContent().forEach(t.renderControl,t);t.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/JSView", ["./View","./JSViewRenderer","./ViewType","sap/base/util/extend","sap/base/util/merge","sap/ui/base/ManagedObject","sap/base/Log"],function(e,i,t,r,n,s,o){"use strict";var a=e.extend("sap.ui.core.mvc.JSView",{metadata:{library:"sap.ui.core"},renderer:i});var p={};a.asyncSupport=true;a._sType=t.JS;a.create=function(i){var n=r({},i);for(var s in n){if(s==="definition"||s==="preprocessors"){delete n[s];o.warning("JSView.create does not support the options definition or preprocessor!")}}n.type=t.JS;return e.create(n)};sap.ui.jsview=function(e,i,t){return c.apply(this,arguments)};function c(e,i,t){var r={},n;if(i&&typeof i=="string"){r.viewName=i;if(typeof arguments[2]=="boolean"){r.async=t}else if(typeof arguments[2]=="object"){r.controller=arguments[2];r.async=!!arguments[3]}if(r.viewName.startsWith("module:")){throw Error("Legacy factory sap.ui.jsview doesn't support typed views!")}n=new a(e,r);return n}else if(i&&typeof i=="object"){p[e]=i;sap.ui.loader._.declareModule(e.replace(/\./g,"/")+".view.js");o.warning("For defining views, use typed views with 'sap.ui.core.mvc.View.extend()'.")}else if(arguments.length==1&&typeof e=="string"||arguments.length==2&&typeof arguments[0]=="string"&&typeof arguments[1]=="boolean"){r.viewName=arguments[0];r.async=!!arguments[1];n=r.id?new a(r.id,r):new a(r);return n}else{throw new Error("Wrong arguments ('"+e+"', '"+i+"')!"+" Either call sap.ui.jsview([sId,] sViewName) to instantiate a View"+" or sap.ui.jsview(sViewName, oViewImpl) to define a View type.")}}a.prototype.initViewSettings=function(e){var i;o.warning("Do not use deprecated sap.ui.core.mvc.JSView: (View: "+(e.id||e.viewName)+"). "+"Use typed views defined by 'sap.ui.core.mvc.View.extend()' and created by 'sap.ui.core.mvc.View.create()'. "+"For further information, have a look at https://sdk.openui5.org/topic/e6bb33d076dc4f23be50c082c271b9f0.","sap.ui.core.mvc.JSView",null,function(){return{type:"sap.ui.core.mvc.JSView",name:e.viewName}});if(Object.getPrototypeOf(this)===a.prototype){if(!p[e.viewName]){var t=e.viewName.replace(/\./g,"/")+".view";if(e.async){i=new Promise(function(e,i){sap.ui.require([t],e,i)})}else{sap.ui.requireSync(t)}}if(e.async){return Promise.resolve(i).then(function(){n(this,p[e.viewName])}.bind(this))}n(this,p[e.viewName])}else if(e.async){return Promise.resolve()}};a.prototype.onControllerConnected=function(e){s.runWithPreprocessors(function(){this.applySettings({content:this.createContent(e)})},{id:this.getAutoPrefixId()?this.createId.bind(this):undefined,settings:this._fnSettingsPreprocessor},this)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/JSViewRenderer", ["./ViewRenderer"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,i){t.openStart("div",i);t.class("sapUiView");t.class("sapUiJSView");e.addDisplayClass(t,i);t.style("width",i.getWidth());t.style("height",i.getHeight());t.openEnd();i.getContent().forEach(t.renderControl,t);t.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/OverrideExecution", function(){"use strict";var e={After:"After",Before:"Before",Instead:"Instead"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/TemplateView", ["./View","./TemplateViewRenderer","./ViewType","sap/base/Log"],function(e,t,i,r){"use strict";var n=e.extend("sap.ui.core.mvc.TemplateView",{metadata:{library:"sap.ui.core"},renderer:t});(function(){sap.ui.templateview=function(e,t){r.warning("sap.ui.core.mvc.TemplateView is deprecated. Use XMLView or JSView instead.");return sap.ui.view(e,t,i.Template)};n._sType=i.Template;n.prototype.getControllerName=function(){return this._sControllerName};n._getViewUrl=function(e){return sap.ui.require.toUrl(e.replace(/\./g,"/"))+".view.tmpl"};n.prototype.initViewSettings=function(e){if(!e){throw new Error("mSettings must be given")}if(!e.viewName){throw new Error("No view name is given.")}this._oTemplate=sap.ui.template({id:this.getId(),src:n._getViewUrl(e.viewName)});this._sControllerName=this._oTemplate._sControllerName;this._oTemplate=this._oTemplate.createControl(undefined,undefined,this);this.addContent(this._oTemplate)}})();return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/TemplateViewRenderer", ["./ViewRenderer"],function(e){"use strict";var i={apiVersion:2};i.render=function(i,t){i.openStart("div",t);i.class("sapUiView");i.class("sapUiTmplView");e.addDisplayClass(i,t);i.style("width",t.getWidth());i.style("height",t.getHeight());i.openEnd();i.renderControl(t._oTemplate);i.close("div")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/View", ["sap/base/assert","sap/base/Log","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/Control","sap/ui/base/DesignTime","sap/ui/core/Element","./Controller","./ViewRenderer","./ViewType","./XMLProcessingMode"],function(e,t,r,n,o,i,s,a,c,p,u,f,l){"use strict";var d=s.extend("sap.ui.core.mvc.View",{metadata:{interfaces:["sap.ui.core.IDScope"],abstract:true,library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:"sap.ui.core.mvc.Controller",controllerName:"string",preprocessors:"Object",resourceBundleName:"string",resourceBundleUrl:"sap.ui.core.URI",resourceBundleLocale:"string",resourceBundleAlias:"string",type:"string",definition:"any",viewContent:{type:"any",deprecated:true},viewData:"any",async:{type:"boolean",defaultValue:false}},designtime:"sap/ui/core/designtime/mvc/View.designtime"},renderer:u});d._mPreprocessors={};function g(e){e._settings={};for(var t in e){if(t.indexOf("_")!==0){e._settings[t]=e[t]}}}function m(e,t){var r;if(typeof e.preprocessor==="string"){var n=e.preprocessor.replace(/\./g,"/");if(t){return new Promise(function(e,t){sap.ui.require([n],function(t){e(t)},t)})}else{return sap.ui.requireSync(n)}}else if(typeof e.preprocessor==="function"&&!e.preprocessor.process){r={process:e.preprocessor}}else{r=e.preprocessor}if(t){return Promise.resolve(r)}else{return r}}function h(e,t){var n=this.mPreprocessors[t]||[],o=[],i,s,a,c=[];if(d._mPreprocessors[e]&&d._mPreprocessors[e][t]){o=d._mPreprocessors[e][t].map(function(e){return Object.assign({},e)})}for(i=0,s=o.length;i<s;i++){if(o[i]._onDemand){a=o[i]}else{c.push(o[i])}}for(i=0,s=n.length;i<s;i++){var p=!n[i].preprocessor;if(p&&a){c.unshift(r(n[i],a))}else if(!p){c.push(n[i])}}return c}function y(e,t){var r=e.getMetadata().getClass();function n(e){e.preprocessor=m(e,t.async)}e.mPreprocessors=Object.assign({},t.preprocessors);for(var o in r.PreprocessorType){var i=r.PreprocessorType[o];if(e.mPreprocessors[i]&&!Array.isArray(e.mPreprocessors[i])){e.mPreprocessors[i]=[e.mPreprocessors[i]]}else if(!e.mPreprocessors[i]){e.mPreprocessors[i]=[]}e.mPreprocessors[i].forEach(g);e.mPreprocessors[i]=h.call(e,r._sType,i);e.mPreprocessors[i].forEach(n)}}function w(e){e.oAsyncState={};e.oAsyncState.promise=null}var v=function(e,t){var r=t.async;var n=function(t){e.oController=t;t.oView=e};if(!a.isControllerCodeDeactivated()){var o=t.controller,s=o&&typeof o.getMetadata==="function"&&o.getMetadata().getName();if(!o&&e.getControllerName){e.bControllerIsViewManaged=true;var c=e.getControllerName();if(c){var u=sap.ui.require("sap/ui/core/Component");if(u){var f=u.getCustomizing(e,{type:"sap.ui.controllerReplacements",name:c});if(f){c=typeof f==="string"?f:f.controllerName}}if(r){o=p.create({name:c,_viewId:e.sId})}else{o=sap.ui.controller(c,true,false,e.sId)}}}else if(o){e.bControllerIsViewManaged=false;var l=i._sOwnerId;if(!o._isExtended()){o=p.applyExtensions(o,s,l,e.sId,r)}else if(r){o=Promise.resolve(o)}}if(o){if(r){if(!e.oAsyncState){throw new Error("The view "+e.sViewName+" runs in sync mode and therefore cannot use async controller extensions!")}return o.then(n)}else{n(o)}}}else if(r){const e=Object.assign(new p,{"_sap.ui.core.mvc.EmptyControllerImpl":true});return Promise.resolve(e).then(n)}else{sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl",{"_sap.ui.core.mvc.EmptyControllerImpl":true});e.oController=sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl")}};d.prototype._initCompositeSupport=function(o){o=o||{};e(!o.preprocessors||this.getMetadata().getName().indexOf("XMLView"),"Preprocessors only available for XMLView");this.oViewData=o.viewData;this.sViewName=o.viewName;if(this.sViewName&&this.sViewName.startsWith("module:")){this.sViewName=this.sViewName.slice("module:".length).replace(/\//g,".")}var i=this;y(this,o);if(o.async){w(this)}var s=sap.ui.require("sap/ui/core/Component");if(s){var a=s.getCustomizing(this,{type:"sap.ui.viewModifications",name:this.sViewName});if(!n(a)){this._fnSettingsPreprocessor=function(e){var n=this.getId();if(n){if(i.isPrefixedId(n)){n=n.substring((i.getId()+"--").length)}var o=Object.assign({},a[n]);if(o){for(var s in o){if(s!=="visible"){t.warning("[FUTURE FATAL] Customizing: custom value for property '"+s+"' of control '"+n+"' in View '"+i.sViewName+"' ignored: only the 'visible' property can be customized.");delete o[s]}}t.info("Customizing: custom value for property 'visible' of control '"+n+"' in View '"+i.sViewName+"' applied: "+o.visible);e=r(e,o)}}}}}var c=function(t,r){e(typeof t==="function","fn must be a function");var n=s&&s.getOwnerComponentFor(i);if(n){if(r){i.fnScopedRunWithOwner=i.fnScopedRunWithOwner||function(e){return n.runAsOwner(e)}}return n.runAsOwner(t)}return t()};var p=function(e){if(e.oController&&e.oController.connectToView){return e.oController.connectToView(e)}};var u=function(e){if(i.onControllerConnected){return i.onControllerConnected(i.oController,e)}};if(o.async){this.oAsyncState.promise=this.initViewSettings(o).then(function(){return c(v.bind(null,i,o),true)}).then(function(){return c(u.bind(null,o),true)}).then(function(){return p(i)}).then(function(){return i.runPreprocessor("controls",i,false)}).then(function(){return c(i.fireAfterInit.bind(i),true)}).then(function(){return i}).catch(function(e){this.deregister();throw e}.bind(this))}else{this.initViewSettings(o);v(this,o);u(o);p(this);this.runPreprocessor("controls",this,true);this.fireAfterInit()}};d.prototype.getController=function(){return this.oController};d.prototype.byId=function(e){return c.getElementById(this.createId(e))};d.prototype.createId=function(e){if(!this.isPrefixedId(e)){e=this.getId()+"--"+e}return e};d.prototype.getLocalId=function(e){var t=this.getId()+"--";return e&&e.indexOf(t)===0?e.slice(t.length):null};d.prototype.isPrefixedId=function(e){return!!(e&&e.indexOf(this.getId()+"--")===0)};d.prototype.getViewData=function(){return this.oViewData};function P(){this.oAsyncState=null}d.prototype.exit=function(){this.fireBeforeExit();if(this.oController&&this.bControllerIsViewManaged){this.oController.destroy();delete this.oController}delete this.oPreprocessorInfo;if(this.oAsyncState){var e=P.bind(this);this.oAsyncState.promise.then(e,e)}};d.prototype.onAfterRendering=function(){this.fireAfterRendering()};d.prototype.onBeforeRendering=function(){this.fireBeforeRendering()};d.prototype.clone=function(e,r){t.error("[FUTURE FATAL] Cloning a View and/or using a View as a binding template is deprecated. Please call the corresponding View factory instead, e.g. XMLView.create()");var n={},o,i;for(o in this.mProperties&&!(this.isBound&&this.isBound(o))){if(this.mProperties.hasOwnProperty(o)){n[o]=this.mProperties[o]}}i=s.prototype.clone.call(this,e,r,{cloneChildren:false,cloneBindings:true});var a,c,p;for(a in i.mEventRegistry){c=i.mEventRegistry[a];for(p=c.length-1;p>=0;p--){if(c[p].oListener===this.getController()){c[p]={oListener:i.getController(),fFunction:c[p].fFunction,oData:c[p].oData}}}}i.applySettings(n);return i};d.prototype.getPreprocessors=function(){return this.mPreprocessors};d.prototype.getPreprocessorInfo=function(e){if(!this.oPreprocessorInfo){this.oPreprocessorInfo={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!e}}if(d._supportInfo){this.oPreprocessorInfo._supportInfo=d._supportInfo}return this.oPreprocessorInfo};d.prototype.runPreprocessor=function(e,r,n){var o=this.getPreprocessorInfo(n),i=this.mPreprocessors&&this.mPreprocessors[e]||[],s,a,c;if(!n){a=function(e,t){return function(r){return t.preprocessor.then(function(n){return n.process(r,e,t._settings)})}};c=Promise.resolve(r)}for(var p=0,u=i.length;p<u;p++){if(n&&i[p]._syncSupport===true){s=i[p].preprocessor.process;r=s(r,o,i[p]._settings)}else if(!n){c=c.then(a(o,i[p]))}else{t.debug('Async "'+e+'"-preprocessor was skipped in sync view execution for '+this.getMetadata().getClass()._sType+"View",this.getId())}}return n?r:c};function C(e,t){if(!d._mPreprocessors[t]){d._mPreprocessors[t]={}}if(!d._mPreprocessors[t][e]){d._mPreprocessors[t][e]=[]}}function V(e,t){return d._mPreprocessors[e][t].some(function(e){return!!e._onDemand})}d.registerPreprocessor=function(e,r,n,o,i,s){if(typeof i!=="boolean"){s=i;i=false}if(r){C(e,n);if(i&&V(n,e)){t.error('[FUTURE FATAL] Registration for "'+e+'" failed, only one on-demand-preprocessor allowed',this.getMetadata().getName());return}d._mPreprocessors[n][e].push({preprocessor:r,_onDemand:i,_syncSupport:o,_settings:s});t.debug("Registered "+(i?"on-demand-":"")+'preprocessor for "'+e+'"'+(o?" with syncSupport":""),this.getMetadata().getName())}else{t.error('[FUTURE FATAL] Registration for "'+e+'" failed, no preprocessor specified',this.getMetadata().getName())}};d.prototype.hasPreprocessor=function(e){return!!this.mPreprocessors[e].length};d.create=function(e){var t=o({},e);t.async=true;t.viewContent=t.definition;var r=sap.ui.require("sap/ui/core/Component");var n;if(r&&i._sOwnerId){n=r.getComponentById(i._sOwnerId)}function s(){return b(t.id,t,t.type).loaded()}return new Promise(function(e,r){var n=d._getViewClassName(t);sap.ui.require([n],function(t){e(t)},r)}).then(function(e){if(e.getMetadata().isA("sap.ui.core.mvc.XMLView")){t.processingMode=l.Sequential}if(n){return n.runAsOwner(s)}else{return s()}})};d._create=b;sap.ui.view=function(e,r,n){var o=typeof e==="string"?e:r;o=typeof o==="object"?o.viewName:o;t.warning("Do not use deprecated view factory functions (View: "+o+"). "+"Use the static create function on the view module instead: [XML|HTML|JSON]View.create().","sap.ui.view",null,function(){return{type:"sap.ui.view",name:o}});return b(e,r,n)};function b(n,o,s){var a=null,c={};if(typeof n==="object"||typeof n==="string"&&o===undefined){o=n;n=undefined}if(o){if(typeof o==="string"){c.viewName=o}else{c=o}}e(!c.async||typeof c.async==="boolean","sap.ui.view factory: Special setting async has to be of the type 'boolean'!");if(n){c.id=n}if(s){c.type=s}if(c.type===f.XML&&c.async){c.processingMode=c.processingMode||l.SequentialLegacy}var p=sap.ui.require("sap/ui/core/Component");if(p&&i._sOwnerId){var u=p.getCustomizing(i._sOwnerId,{type:"sap.ui.viewReplacements",name:c.viewName});if(u){delete u.async;t.info("Customizing: View replacement for view '"+c.viewName+"' found and applied: "+u.viewName+" (type: "+u.type+")");r(c,u)}else{t.debug("Customizing: no View replacement found for view '"+c.viewName+"'.")}}var g=d._getViewClassName(c);a=I(g,c);return a}d._getViewClassName=function(e,r){var n=d._getModuleName(e);if(n){if(e.type&&!r){t.error("When using the view factory, the 'type' setting must be omitted for typed views. When embedding typed views in XML, don't use the <JSView> tag, use the <View> tag instead.")}return n}if(!e.type){throw new Error("No view type specified.")}if(e.type===f.XML){return"sap/ui/core/mvc/XMLView"}if(e.type===f.JS){n="sap/ui/core/mvc/JSView"}else if(e.type===f.JSON){n="sap/ui/core/mvc/JSONView"}else if(e.type===f.HTML){n="sap/ui/core/mvc/HTMLView"}else if(e.type===f.Template){n="sap/ui/core/mvc/TemplateView"}if(!n){throw new Error("Unknown view type "+e.type+" specified.")}return n};function I(e,r){var n=sap.ui.require(e);if(!n){n=sap.ui.requireSync(e);if(r.async){t.warning("sap.ui.view was called without requiring the according view class.")}}return new n(r)}d.prototype.loaded=function(){if(this.oAsyncState&&this.oAsyncState.promise){return this.oAsyncState.promise}else{return Promise.resolve(this)}};d._getModuleName=function(e){var t;if(e.viewName&&e.viewName.startsWith("module:")){t=e.viewName.slice("module:".length)}return t};d.prototype.getAutoPrefixId=function(){return false};d.prototype.onControllerConnected=function(e,t){if(!this.createContent&&typeof this.createContent!=="function"){return}var r={id:this.getAutoPrefixId()?this.createId.bind(this):undefined,settings:this._fnSettingsPreprocessor};return i.runWithPreprocessors(function(){var r=this.createContent(e);if(t.async){r=Promise.resolve(r);return r.then(function(e){this.applySettings({content:e})}.bind(this))}else if(r instanceof Promise){throw new Error("An asynchronous view (createContent) cannot be instantiated synchronously. Affected view: '"+this.getMetadata().getName()+"'.")}else{this.applySettings({content:r})}}.bind(this),r)};d.prototype.initViewSettings=function(e){if(!this.getMetadata()._oRenderer){this.getMetadata().getRenderer=function(){return d.getMetadata().getRenderer()};this.getMetadata().getRendererName=function(){return d.getMetadata().getRendererName()}}if(e.async){return Promise.resolve()}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/ViewRenderer", function(){"use strict";var e={apiVersion:2};e.render=function(t,i){t.openStart("div",i);t.class("sapUiView");e.addDisplayClass(t,i);t.style("width",i.getWidth());t.style("height",i.getHeight());t.openEnd();i.getContent().forEach(t.renderControl,t);t.close("div")};e.addDisplayClass=function(e,t){if(t.getDisplayBlock()||t.getWidth()==="100%"&&t.getHeight()==="100%"){e.class("sapUiViewDisplayBlock")}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/XMLProcessingMode", [],function(){"use strict";var e={Sequential:"Sequential",SequentialLegacy:"SequentialLegacy"};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/XMLView", ["./View","./ViewType","./XMLViewRenderer","sap/base/config","sap/base/Log","sap/base/strings/hash","sap/base/util/LoaderExtensions","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/RenderManager","sap/ui/core/XMLTemplateProcessor","sap/ui/core/cache/CacheManager","sap/ui/model/resource/ResourceModel","sap/ui/util/XMLHelper","sap/ui/Global","sap/ui/VersionInfo","sap/ui/performance/trace/Interaction","sap/ui/thirdparty/jquery"],function(e,t,n,r,i,o,s,a,c,u,l,d,p,f,h,m,g,v,w,jQuery){"use strict";var y=d.RenderPrefixes,C="XMLViewCacheError",P={};var M=l.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{metadata:{library:"sap.ui.core"},renderer:{apiVersion:2,render:function(e,t){e.text("")}}});var b=e.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:"sap.ui.core.mvc.XMLView",visibility:"hidden"},xmlNode:{type:"Element",visibility:"hidden"},cache:"Object",processingMode:{type:"sap.ui.core.mvc.XMLProcessingMode",visibility:"hidden"},requireContext:"Object"},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"},renderer:n});sap.ui.xmlview=function(e,n){return sap.ui.view(e,n,t.XML)};b.create=function(n){var r=a({},n);r.viewContent=r.definition;r.async=true;r.type=t.XML;return e.create(r)};b._sType=t.XML;b.asyncSupport=true;b._bUseCache=r.get({name:"sapUiXxViewCache",type:r.Type.Boolean,defaultValue:true,external:true})&&f._isSupportedEnvironment();function x(e){if(e.parseError.errorCode!==0){var t=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+t.url+" code: "+t.errorCode+" reason: "+t.reason+" src: "+t.srcText+" line: "+t.line+" linepos: "+t.linepos+" filepos: "+t.filepos)}}function E(e,t){if(!t){throw new Error("mSettings must be given")}else if(t.viewName&&t.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.")}else if((t.viewName||t.viewContent)&&t.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.")}else if(!(t.viewName||t.viewContent)&&!t.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.")}else if(t.cache&&!(t.cache.keys&&t.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.")}}function N(e,t){e.mProperties["viewContent"]=t.viewContent;var n=m.parse(t.viewContent);x(n);return n.documentElement}function _(e,t){if((e._resourceBundleName||e._resourceBundleUrl)&&(!t.models||!t.models[e._resourceBundleAlias])){var n=new h({bundleName:e._resourceBundleName,bundleUrl:e._resourceBundleUrl,bundleLocale:e._resourceBundleLocale,async:t.async});var r=n.getResourceBundle();if(r instanceof Promise){return r.then(function(){e.setModel(n,e._resourceBundleAlias)})}e.setModel(n,e._resourceBundleAlias)}}function V(e){e.oAfterRenderingNotifier=new M;e.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){e.onAfterRenderingBeforeChildren()}})}function A(e){var t=sap.ui.require("sap/ui/core/Component"),n;if(t){while(e){var r=t.getOwnerComponentFor(e);if(r){e=n=r}else{if(e instanceof t){n=e}e=e.getParent&&e.getParent()}}}return n}function R(e,t){var n=A(e),r=n?JSON.stringify(n.getManifest()):null,i=[];i=i.concat(T(e,n),I(),X(e),t.keys);return D(e,i).then(function(e){return{key:e+"("+o(r||"")+")",componentManifest:r,additionalData:t.additionalData}})}function L(e){return e}function D(e,t){return Promise.all(t).then(function(e){e=e.filter(function(e){return e!==P});if(e.every(L)){return e.join("_")}else{var t=new Error("Provided cache keys may not be empty or undefined.");t.name=C;return Promise.reject(t)}})}function T(e,t){var n=t&&t.getMetadata().getName();return[n||window.location.host+window.location.pathname,e.getId(),u.getLanguageTag()].concat(t&&t.getActiveTerminologies()||[])}function X(e){var t=e.getPreprocessors(),n=e.getPreprocessorInfo(false),r=[];function i(e){r.push(e.preprocessor.then(function(e){if(e.getCacheKey){return e.getCacheKey(n)}else{return P}}))}for(var o in t){t[o].forEach(i)}return r}function I(){return v.load().then(function(e){var t="";if(!e.libraries){t=g.buildinfo.buildtime}else{e.libraries.forEach(function(e){t+=e.buildTimestamp})}return t}).catch(function(e){i.warning("version info could not be retrieved","sap.ui.core.mvc.XMLView");i.debug(e);return""})}function S(e,t){var n=e.key;delete e.key;var r=e.additionalData;e.xml=m.serialize(t);if(r&&r.setAdditionalCacheData&&r.getAdditionalCacheData){e.additionalData=r.getAdditionalCacheData()}return f.set(n,e)}function B(e){return f.get(e.key).then(function(t){if(t&&t.componentManifest==e.componentManifest){t.xml=m.parse(t.xml,"application/xml").documentElement;if(t.additionalData){var n=e.additionalData;if(n&&n.setAdditionalCacheData&&n.getAdditionalCacheData){n.setAdditionalCacheData(t.additionalData)}else{i.error("Deprecated: Don't use an object reference for caching additional Data! Use a CacheDataProvider instead!");a(e.additionalData,t.additionalData)}}return t}})}b.prototype.initViewSettings=function(t){var n=this,r;function o(r){n._xContent=r;if(e._supportInfo){e._supportInfo({context:n._xContent,env:{caller:"view",viewinfo:a({},n),settings:a({},t||{}),type:"xmlview"}})}if(!n.isSubView()){p.parseViewAttributes(r,n)}else{delete t.controller}var i=_(n,t);if(i instanceof Promise){return i.then(function(){V(n)})}V(n)}function c(e,t){if(n.hasPreprocessor("viewxml")){return p.enrichTemplateIdsPromise(e,n,t).then(function(){return n.runPreprocessor("viewxml",e,!t)})}return e}function u(e){var t=w.notifyAsyncStep("VIEW PREPROCESSING");return n.runPreprocessor("xml",e).then(function(e){return c(e,true)}).finally(t)}function l(e){return s.loadResource(e,{async:true}).then(function(e){return e.documentElement})}function d(e,t){return l(e).then(u).then(function(e){if(t){S(t,e)}return e})}function f(e,t){return R(n,t).then(function(t){return B(t).then(function(n){if(!n){return d(e,t)}else{return n.xml}})}).catch(function(t){if(t.name===C){i.error(t.message,t.name,"sap.ui.core.mvc.XMLView");i.error("Processing the View without caching.","sap.ui.core.mvc.XMLView");return d(e)}else{return Promise.reject(t)}})}this._oContainingView=t.containingView||this;this._sProcessingMode=t.processingMode;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true}E(this,t);if(t.viewName){var h=t.viewName.replace(/\./g,"/")+".view.xml";if(t.async){if(t.cache&&b._bUseCache){return f(h,t.cache).then(o)}else{return l(h).then(u).then(o)}}else{r=s.loadResource(h).documentElement}}else if(t.viewContent){if(t.viewContent.nodeType===window.Node.DOCUMENT_NODE){r=t.viewContent.documentElement}else{r=N(this,t)}}else if(t.xmlNode){r=t.xmlNode}if(t.async){return u(r).then(o)}else{r=this.runPreprocessor("xml",r,true);r=c(r,false);if(r&&typeof r.getResult==="function"){if(r.isRejected()){throw r.getResult()}r=r.getResult()}o(r)}};b.prototype.onBeforeRendering=function(){var t=this.getDomRef();if(t&&!d.isPreservedContent(t)){d.preserveContent(t,true)}e.prototype.onBeforeRendering.apply(this,arguments)};b.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy()}e.prototype.exit.apply(this,arguments)};b.prototype.onControllerConnected=function(e,t){var n=this;function r(e){return c.runWithPreprocessors(e,{settings:n._fnSettingsPreprocessor})}if(!this.oAsyncState){this._aParsedContent=r(p.parseTemplate.bind(null,this._xContent,this,t))}else{var i=w.notifyAsyncStep("VIEW PROCESSING");return p.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:r}).then(function(e){n._aParsedContent=e;delete n.oAsyncState.suppressPreserve}).finally(i)}};b.prototype.getControllerName=function(){return this._controllerName};b.prototype.isSubView=function(){return this._oContainingView!=this};b.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var t=0;t<e.length;t++){var n=document.getElementById(y.Temporary+e[t].getId())||e[t].getDomRef()||document.getElementById(y.Invisible+e[t].getId());if(n){jQuery(document.getElementById(y.Dummy+e[t].getId())).replaceWith(n)}}}jQuery(document.getElementById(y.Temporary+this.getId())).replaceWith(this._$oldContent)}this._$oldContent=undefined};b.prototype._onChildRerenderedEmpty=function(e,t){jQuery(t).replaceWith('<div id="'+y.Dummy+e.getId()+'" class="sapUiHidden"></div>');return true};b.registerPreprocessor=function(t,n,r,o,s,a){var c=this.getMetadata().getClass()._sType;if(typeof r==="string"){if(r!==c){throw new TypeError("View types other than "+c+" are not supported by XMLView.registerPreprocessor,"+" check View.registerPreprocessor instead")}}else{a=s;s=o;o=r}t=t.toUpperCase();if(b.PreprocessorType[t]){e.registerPreprocessor(b.PreprocessorType[t],n,c,o,s,a)}else{i.error('[FUTURE FATAL] Preprocessor could not be registered due to unknown sType "'+t+'"',this.getMetadata().getName())}};b.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};b.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/mvc/XMLViewRenderer", ["./ViewRenderer","../RenderManager","sap/ui/thirdparty/jquery"],function(e,t,jQuery){"use strict";var n=t.RenderPrefixes.Dummy,r=t.RenderPrefixes.Invisible,i=t.RenderPrefixes.Temporary;var s={apiVersion:2};s.render=function(s,d){function a(t){s.openStart("div",d);s.class("sapUiView");s.class("sapUiXMLView");e.addDisplayClass(s,d);if(t){s.attr("data-sap-ui-preserve",d.getId())}s.style("width",d.getWidth());s.style("height",d.getHeight());s.openEnd()}function o(){s.close("div")}var l=d._aParsedContent,f;if(d.isBound("content")){a();var p=d.getContent();for(f=0;f<p.length;f++){s.renderControl(p[f])}o()}else{var v=d._$oldContent=t.findPreservedContent(d.getId());if(v.length===0){var c=d.isSubView();if(!c){a(!d.oAsyncState||!d.oAsyncState.suppressPreserve)}if(l){for(f=0;f<l.length;f++){var g=l[f];if(Array.isArray(g)){s[g[0]].apply(s,g[1])}else if(!g._isExtensionPoint){s.renderControl(g);if(!g.bOutput){s.openStart("div",n+g.getId());s.class("sapUiHidden");s.openEnd();s.close("div")}}}}if(!c){o()}}else{s.renderControl(d.oAfterRenderingNotifier);s.openStart("div",i+d.getId());s.class("sapUiHidden");s.openEnd();for(f=0;f<l.length;f++){var u=l[f];if(!Array.isArray(u)&&!u._isExtensionPoint){s.renderControl(u);var y=u.getId(),h=jQuery(document.getElementById(y));if(h.length==0){h=jQuery(document.getElementById(r+y))}if(!t.isPreservedContent(h[0])){h.replaceWith('<div id="'+n+y+'" class="sapUiHidden"></div>')}}}s.close("div")}}};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/plugin/TemplatingSupport", ["sap/base/Log","sap/ui/core/tmpl/Template","sap/ui/core/Core"],function(t){"use strict";var i=function(){};i.prototype.startPlugin=function(i,e){t.info("Starting TemplatingSupport plugin.");this.oCore=i;sap.ui.template()};i.prototype.stopPlugin=function(){t.info("Stopping TemplatingSupport plugin.");this.oCore=null};sap.ui.getCore().registerPlugin(new i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/postmessage/Bus", ["sap/ui/core/EventBus","sap/base/util/isPlainObject","sap/base/Log"],function(e,t,i){"use strict";var n;var r="______UI5______";var s=e.extend("sap.ui.core.postmessage.Bus",{constructor:function(){if(n){return n}n=this;e.apply(this,arguments);this._aAcceptedOrigins=[window.location.origin];this._aDeclinedOrigins=[];this._oPendingProcess=null;this._aEventQueue=[];this._receiver=this._receiver.bind(this);window.addEventListener("message",this._receiver)}});s.event={CONNECT:"______CONNECT______",READY:"______READY______",ACCEPTED:"______ACCEPTED______",DECLINED:"______DECLINED______"};s.prototype.destroy=function(){window.removeEventListener("message",this._receiver);this._aEventQueue=[];e.prototype.destroy.apply(this,arguments);n=undefined;this.bIsDestroyed=true};s.getInstance=function(){if(!n){n=new s}return n};s.prototype.publish=function(e){var t=e.target;var i=e.origin;var n=e.channelId;var o=e.eventId;var a=e.data;if(o===s.event.READY){if(!t){if(window.opener&&window.opener!==window){t=window.opener}else if(window.parent!==window){t=window.parent}else{return}}if(!i){i="*"}}if(typeof window==="undefined"||!(t!=null&&t===t.window)||t===window){throw TypeError("Target must be a window object and has to differ from current window")}if(typeof i!=="string"){throw TypeError("Origin must be a string")}if(typeof n!=="string"){throw TypeError("ChannelId must be a string")}if(typeof o!=="string"){throw TypeError("EventId must be a string")}if(![s.event.READY,s.event.ACCEPTED,s.event.DECLINED].includes(o)&&i!=="*"&&!this._aAcceptedOrigins.includes(i)){this._aAcceptedOrigins.push(i)}var c={origin:i,channelId:n,eventId:o,data:a};c[r]=true;t.postMessage(c,i)};s.prototype._callListener=function(e,t,i,n,r){e.call(t,r)};s.prototype._getText=function(e,t){return sap.ui.getCore().getLibraryResourceBundle(true).then(function(i){return i.getText(e,t)})};s.prototype._receiver=function(e){var i=e.data;if(!t(i)||!i.hasOwnProperty(r)){return}if(this._oPendingProcess){this._aEventQueue.push(e)}else{this._oPendingProcess=this._processEvent(e)}};s.prototype._processEvent=function(e){return new Promise(function(t,i){var n=e.data;var r=e.origin;if(this._aDeclinedOrigins.includes(r)){t();return}switch(n.eventId){case s.event.CONNECT:{if(typeof n.data!=="string"){this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:s.event.DECLINED});t()}else if(this._aAcceptedOrigins.includes(r)){this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:s.event.ACCEPTED});t()}else{sap.ui.require(["sap/ui/core/postmessage/confirmationDialog"],function(i){this._getText("PostMessage.Message",[n.data,r]).then(function(e){return i(e)}).then(function(){this.addAcceptedOrigin(r);this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:s.event.ACCEPTED})}.bind(this),function(){this.addDeclinedOrigin(r);this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:s.event.DECLINED})}.bind(this)).then(t)}.bind(this),i)}break}case s.event.ACCEPTED:case s.event.DECLINED:case s.event.READY:{e.data.data=undefined;this._emitMessage(e);t();break}default:{if(this._aAcceptedOrigins.includes(r)){this._emitMessage(e)}t()}}}.bind(this)).catch(function(e){var t;var n;if(typeof e==="string"){t=e}else if(e instanceof Error){t=e.message;n=e.stack}else{t="Some unexpected error happened during post message processing"}i.error(t,n,"sap.ui.core.postmessage.Bus")}).then(function(){this._oPendingProcess=this._aEventQueue.length>0?this._processEvent(this._aEventQueue.shift()):null}.bind(this))};s.prototype._emitMessage=function(t){var i=t.data.channelId;var n=t.data.eventId;e.prototype.publish.call(this,i,n,{originalEvent:t,channelId:i,eventId:n,source:t.source,origin:t.origin,data:t.data.data})};s.prototype.getAcceptedOrigins=function(){return this._aAcceptedOrigins.slice()};s.prototype.setAcceptedOrigins=function(e){if(!Array.isArray(e)){throw new TypeError("Expected an array, but got "+typeof e)}this._aAcceptedOrigins=e.slice()};s.prototype.addAcceptedOrigin=function(e){if(typeof e!=="string"){throw new TypeError("Expected a string, but got "+typeof e)}if(!this._aAcceptedOrigins.includes(e)){this._aAcceptedOrigins.push(e)}};s.prototype.resetAcceptedOrigins=function(){this.setAcceptedOrigins([])};s.prototype.getDeclinedOrigins=function(){return this._aDeclinedOrigins.slice()};s.prototype.setDeclinedOrigins=function(e){if(!Array.isArray(e)){throw new TypeError("Expected an array, but got "+typeof e)}this._aDeclinedOrigins=e.slice()};s.prototype.addDeclinedOrigin=function(e){if(typeof e!=="string"){throw new TypeError("Expected a string, but got "+typeof e)}if(!this._aDeclinedOrigins.includes(e)){this._aDeclinedOrigins.push(e)}};s.prototype.resetDeclinedOrigins=function(){this.setDeclinedOrigins([])};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/postmessage/confirmationDialog", function(){"use strict";return function(e){return new Promise(function(i,n){var o=sap.ui.getCore().getLoadedLibraries().hasOwnProperty("sap.m");if(o){sap.ui.require(["sap/m/MessageBox"],function(o){o.confirm(e,{actions:[o.Action.YES,o.Action.NO],onClose:function(e){if(e===o.Action.YES){i()}else{n()}}})},n)}else{var r=window.confirm(e);if(r){i()}else{n()}}})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/HashChanger", ["./HashChangerBase","./RouterHashChanger","sap/ui/thirdparty/hasher","sap/base/Log","sap/base/util/ObjectPath","sap/ui/performance/trace/Interaction"],function(e,t,s,a,n,r){"use strict";var h=e.extend("sap.ui.core.routing.HashChanger",{constructor:function(){e.apply(this)}});h.prototype.init=function(){if(this._initialized){a.info("this HashChanger instance has already been initialized.");return false}this._initialized=true;s.changed.add(this.fireHashChanged,this);if(!s.isActive()){s.initialized.addOnce(this.fireHashChanged,this);s.init()}else{this.fireHashChanged(s.getHash())}return this._initialized};h.prototype.fireHashChanged=function(e,t){this.fireEvent("hashChanged",{newHash:e,oldHash:t})};h.prototype.createRouterHashChanger=function(){if(!this._oRouterHashChanger){var e=this._parseHash(this.getHash());this._oRouterHashChanger=new t({parent:this,hash:e.hash,subHashMap:e.subHashMap});this._registerListenerToRelevantEvents();this._oRouterHashChanger.attachEvent("hashSet",this._onHashModified,this);this._oRouterHashChanger.attachEvent("hashReplaced",this._onHashModified,this)}this._oRouterHashChanger.attachEvent("hashChanged",function(){r.notifyNavigation()});return this._oRouterHashChanger};h.prototype._registerListenerToRelevantEvents=function(){if(!this._mEventListeners){this._mEventListeners={};this.getRelevantEventsInfo().forEach(function(e){var t=e.name,s=this._onHashChangedForRouterHashChanger.bind(this,e);this._mEventListeners[t]=s;this.attachEvent(t,s,this)}.bind(this))}};h.prototype._deregisterListenerFromRelevantEvents=function(){if(this._mEventListeners){var e=Object.keys(this._mEventListeners);e.forEach(function(e){this.detachEvent(e,this._mEventListeners[e],this)}.bind(this));delete this._mEventListeners}};h.prototype._onHashChangedForRouterHashChanger=function(e,t){if(this._oRouterHashChanger){var s=e.paramMapping||{},a=s["newHash"]||"newHash",n=t.getParameter(a)||"",r=this._parseHash(n);this._oRouterHashChanger.fireHashChanged(r.hash,r.subHashMap,!!e.updateHashOnly)}};h.prototype._onHashModified=function(e){var t=e.getId(),s=[e.getParameter("hash")],a=[e.getParameter("key")],n=e.getParameter("nestedHashInfo"),r=e.getParameter("deletePrefix")||[];if(Array.isArray(n)){n.forEach(function(e){s.push(e.hash);a.push(e.key);if(Array.isArray(e.deletePrefix)){e.deletePrefix.forEach(function(e){if(r.indexOf(e)===-1){r.push(e)}})}})}if(t==="hashSet"){this._setSubHash(a,s,r)}else{this._replaceSubHash(a,s,r)}};h.prototype._setSubHash=function(e,t,s){var a=this._reconstructHash(e,t,s);this.setHash(a)};h.prototype._replaceSubHash=function(e,t,s){var a=this._reconstructHash(e,t,s);this.replaceHash(a)};h.prototype._reconstructHash=function(e,t,s){var a=this.getHash().split("&/"),n=a.shift();e.forEach(function(e,r){if(s){s=s.filter(function(t){return t!==e})}var h=t[r];if(e===undefined){n=h+""}else{var i=a.some(function(t,a,n){if(t.startsWith(e)){if(h){n[a]=e+"/"+h}else{s.push(e)}return true}return false});if(!i){a.push(e+"/"+h)}}});if(s&&s.length>0){a=a.filter(function(e){return!s.some(function(t){return e.startsWith(t)})})}a.unshift(n);return a.join("&/")};h.prototype._parseHash=function(e){var t=e.split("&/");return{hash:t.shift(),subHashMap:t.reduce(function(e,t){var s=t.indexOf("/");if(s===-1){e[t]=""}else{e[t.substring(0,s)]=t.substring(s+1)}return e},{})}};h.prototype.setHash=function(t){e.prototype.setHash.apply(this,arguments);s.setHash(t)};h.prototype.replaceHash=function(t){e.prototype.replaceHash.apply(this,arguments);s.replaceHash(t)};h.prototype.getHash=function(){return s.getHash()};h.prototype.getRelevantEventsInfo=function(){return[{name:"hashChanged",paramMapping:{fullHash:"newHash"}}]};h.prototype.destroy=function(){if(this._oRouterHashChanger){this._deregisterListenerFromRelevantEvents();this._oRouterHashChanger.destroy();this._oRouterHashChanger=undefined}delete this._initialized;s.changed.remove(this.fireHashChanged,this);e.prototype.destroy.apply(this,arguments)};h.prototype.deregisterRouterHashChanger=function(){this._deregisterListenerFromRelevantEvents();delete this._oRouterHashChanger};(function(){var e=null;h.getInstance=function(){if(!e){e=new h}return e};function t(t){var s,a,n;for(s in e.mEventRegistry){if(e.mEventRegistry.hasOwnProperty(s)){a=e.mEventRegistry[s];n=t.mEventRegistry[s];if(n){t.mEventRegistry[s]=a.concat(n)}else{t.mEventRegistry[s]=a}}}}h.replaceHashChanger=function(s){if(e&&s){var a=n.get("sap.ui.core.routing.History.getInstance"),r;if(a){r=a();r._setHashChanger(s)}if(e._oRouterHashChanger){e._oRouterHashChanger.detachEvent("hashSet",e._onHashModified,e);e._oRouterHashChanger.detachEvent("hashReplaced",e._onHashModified,e);e._deregisterListenerFromRelevantEvents();s._oRouterHashChanger=e._oRouterHashChanger;s._oRouterHashChanger.parent=s;delete e._oRouterHashChanger;s._oRouterHashChanger.attachEvent("hashSet",s._onHashModified,s);s._oRouterHashChanger.attachEvent("hashReplaced",s._onHashModified,s);s._registerListenerToRelevantEvents()}t(s);e.destroy()}e=s}})();return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/HashChangerBase", ["sap/ui/base/EventProvider"],function(e){"use strict";var a=e.extend("sap.ui.core.routing.HashChangerBase",{metadata:{abstract:true,publicMethods:["getHash","setHash","replaceHash"]},constructor:function(){e.apply(this)}});a.M_EVENTS={HashChanged:"hashChanged",HashSet:"hashSet",HashReplaced:"hashReplaced"};a.prototype.setHash=function(e){this.fireEvent("hashSet",{sHash:e,hash:e})};a.prototype.replaceHash=function(e,a){this.fireEvent("hashReplaced",{sHash:e,hash:e,direction:a})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/History", ["sap/ui/core/library","./HashChanger","sap/base/Log","sap/base/util/ObjectPath"],function(t,i,s,e){"use strict";var a=t.routing.HistoryDirection;var r="Direction_Unchanged";var n=function(t){var i=this;this._iHistoryLength=window.history.length;this.aHistory=[];this._bIsInitial=true;function e(t){if(n._bUsePushState&&!n.getInstance()){var e=window.history.state===null?{}:window.history.state;if(typeof e==="object"){e.sap=e.sap?e.sap:{};if(e.sap.history&&Array.isArray(e.sap.history)&&e.sap.history[e.sap.history.length-1]===t){n._aStateHistory=e.sap.history}else{n._aStateHistory.push(t);e.sap.history=n._aStateHistory;window.history.replaceState(e,window.document.title)}}else{s.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History")}}i._reset()}if(!t){s.error("[FUTURE FATAL] sap.ui.core.routing.History constructor was called and it did not get a hashChanger as parameter")}this._setHashChanger(t);if(t._initialized){e(t.getHash())}else{t.attachEventOnce("hashChanged",function(t){e(t.getParameter("newHash"))})}};n._aStateHistory=[];n._bUsePushState=window.self===window.top;n.prototype.getHistoryStateOffset=function(){if(!n._bUsePushState){return undefined}var t=e.get("history.state.sap.history");if(!Array.isArray(t)){return undefined}return t.length-n._aStateHistory.length};n.prototype.destroy=function(){this._unRegisterHashChanger()};n.prototype.getDirection=function(t){if(t!==undefined&&this._bIsInitial){return undefined}if(t===undefined){return this._sCurrentDirection}return this._getDirection(t)};n.prototype.getPreviousHash=function(){return this.aHistory[this.iHistoryPosition-1]};n.prototype._setHashChanger=function(t){if(this._oHashChanger){this._unRegisterHashChanger()}this._oHashChanger=t;this._mEventListeners={};t.getRelevantEventsInfo().forEach(function(t){var i=t.name,s=t.paramMapping||{},e=this._onHashChange.bind(this,s);this._mEventListeners[i]=e;this._oHashChanger.attachEvent(i,e,this)}.bind(this));this._oHashChanger.attachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.attachEvent("hashSet",this._hashSet,this)};n.prototype._unRegisterHashChanger=function(){if(this._mEventListeners){var t=Object.keys(this._mEventListeners);t.forEach(function(t){this._oHashChanger.detachEvent(t,this._mEventListeners[t],this)}.bind(this));delete this._mEventListeners}this._oHashChanger.detachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.detachEvent("hashSet",this._hashSet,this);this._oHashChanger=null};n.prototype._reset=function(){this.aHistory.length=0;this.iHistoryPosition=0;this._bUnknown=true;this.aHistory[0]=this._oHashChanger.getHash()};n.prototype._getDirection=function(t,i,s){if(s&&this._oNextHash&&this._oNextHash.sHash===t){return a.NewEntry}if(i){return a.NewEntry}if(this._bUnknown){return a.Unknown}if(this.aHistory[this.iHistoryPosition+1]===t&&this.aHistory[this.iHistoryPosition-1]===t){return a.Unknown}if(this.aHistory[this.iHistoryPosition-1]===t){return a.Backwards}if(this.aHistory[this.iHistoryPosition+1]===t){return a.Forwards}return a.Unknown};n.prototype._getDirectionWithState=function(t){var i=window.history.state===null?{}:window.history.state,e,o;if(typeof i==="object"){if(i.sap===undefined){n._aStateHistory.push(t);i.sap={};i.sap.history=n._aStateHistory;window.history.replaceState(i,document.title);o=a.NewEntry}else{e=i.sap.history.every(function(t,i){return t===n._aStateHistory[i]});if(e&&i.sap.history.length===n._aStateHistory.length){o=r}else{o=e?a.Backwards:a.Forwards;n._aStateHistory=i.sap.history}}}else{s.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History")}return o};n.prototype._onHashChange=function(t,i){var s=t.newHash||"newHash",e=t.oldHash||"oldHash",a=t.fullHash||"fullHash";this._hashChange(i.getParameter(s),i.getParameter(e),i.getParameter(a))};n.prototype._hashChange=function(t,i,s){var e=window.history.length,o;if(this._oNextHash&&this._oNextHash.bWasReplaced&&this._oNextHash.sHash===t){if(this._oNextHash.sDirection){o=this._oNextHash.sDirection}else{this.aHistory[this.iHistoryPosition]=t;if(s!==undefined&&n._bUsePushState&&this===n.getInstance()){n._aStateHistory[n._aStateHistory.length-1]=s;window.history.replaceState({sap:{history:n._aStateHistory}},window.document.title)}this._oNextHash=null;if(!this._bIsInitial){this._sCurrentDirection=a.Unknown}return}}this._bIsInitial=false;if(o){this._adaptToDirection(o,{oldHash:i,newHash:t,fullHash:s})}else{if(!o&&s!==undefined&&n._bUsePushState&&this===n.getInstance()){o=this._getDirectionWithState(s)}if(o===r){return}if(!o){o=this._getDirection(t,this._iHistoryLength<window.history.length,true)}this._bUnknown=false;switch(o){case a.Unknown:this._reset();break;case a.NewEntry:this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,t);this.iHistoryPosition++;break;case a.Forwards:this.iHistoryPosition++;break;case a.Backwards:this.iHistoryPosition--;break;default:break}}this._sCurrentDirection=o;this._iHistoryLength=e;if(this._oNextHash){this._oNextHash=null}};n.prototype._adaptToDirection=function(t,i){var e=i.fullHash,r=i.newHash,o,h;if(n._bUsePushState&&this===n.getInstance()&&e!==undefined){switch(t){case a.NewEntry:case a.Forwards:n._aStateHistory.push(e);break;case a.Backwards:o=n._aStateHistory.lastIndexOf(e);if(o!==-1){n._aStateHistory.splice(o+1)}else{n._aStateHistory=[e];s.debug("Can't find "+e+" in "+JSON.stringify(n._aStateHistory))}break;case a.Unknown:n._aStateHistory[n._aStateHistory.length-1]=e;break;default:break}h={};h.sap={};h.sap.history=n._aStateHistory;window.history.replaceState(h,document.title)}switch(t){case a.NewEntry:this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,r);this.iHistoryPosition+=1;break;case a.Forwards:o=this.aHistory.indexOf(r,this.iHistoryPosition+1);if(o!==-1){this.iHistoryPosition=o}else{this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,r);this.iHistoryPosition++}break;case a.Backwards:o=this.aHistory.lastIndexOf(r,this.iHistoryPosition-1);if(o!==-1){this.iHistoryPosition=o}else{this.aHistory=[r];this.iHistoryPosition=0}break;case a.Unknown:this.aHistory[this.iHistoryPosition]=r;break;default:break}};n.prototype._hashSet=function(t){var i=t.getParameter("hash");if(i===undefined){i=t.getParameter("sHash")}this._hashChangedByApp(i,false)};n.prototype._hashReplaced=function(t){var i=t.getParameter("hash"),s=t.getParameter("direction");if(i===undefined){i=t.getParameter("sHash")}if(i===this._oHashChanger.getHash()&&s){this._sCurrentDirection=s}this._hashChangedByApp(i,true,s)};n.prototype._hashChangedByApp=function(t,i,s){this._oNextHash={sHash:t,bWasReplaced:i,sDirection:s}};var o;n.getInstance=function(){return o};o=new n(i.getInstance());return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/Route", ["sap/ui/base/EventProvider","sap/ui/core/routing/Target","sap/ui/core/routing/async/Route","sap/ui/core/routing/sync/Route","sap/ui/core/Component","sap/base/Log","sap/base/assert","sap/base/util/deepExtend"],function(t,e,r,n,o,a,i,s){"use strict";var u=t.extend("sap.ui.core.routing.Route",{metadata:{publicMethods:["getURL","getPattern"]},constructor:function(o,i,s){t.apply(this,arguments);this._validateConfig(i);this._aPattern=[];this._aRoutes=[];this._oParent=s;this._oConfig=i;this._oRouter=o;var u=this,h=i.pattern,c,f,g,d,_=o._isAsync();d=_?r:n;for(var p in d){this[p]=d[p]}if(!Array.isArray(h)){h=[h]}if(i.parent){var m=this._getParentRoute(i.parent);if(!m){a.error("[FUTURE FATAL] No parent route with '"+i.parent+"' could be found",this)}else if(m._aPattern.length>1){a.error("[FUTURE FATAL] Routes with multiple patterns cannot be used as parent for nested routes",this);return}else{this._oNestingParent=m;h.forEach(function(t,e){var r=m._aPattern[0];r=r.charAt(r.length)==="/"?r:r+"/";h[e]=r+t})}}if(Array.isArray(i.subroutes)){c=i.subroutes;i.subroutes={};c.forEach(function(t){i.subroutes[t.name]=t})}if(!i.target){var l=this._convertToTargetOptions(i);l._async=_;this._oTarget=new e(l,o._oViews,s&&s._oTarget);this._oTarget._bUseRawViewId=true}if(i.subroutes){for(f in i.subroutes){g=i.subroutes[f];if(g.name===undefined){g.name=f}o.addRoute(g,u)}}if(i.pattern===undefined){return}h.forEach(function(t,e){u._aPattern[e]=t;u._aRoutes[e]=o._oRouter.addRoute(t);u._checkRoute(u._aRoutes[e]);u._aRoutes[e].greedy=i.greedy;u._aRoutes[e].matched.add(function(){var t={};Array.from(arguments).forEach(function(r,n){t[u._aRoutes[e]._paramsIds[n]]=r});u._routeMatched(t,true)});u._aRoutes[e].switched.add(function(){u._routeSwitched()})})},_checkRoute:function(t){var e=t._paramsIds;if(Array.isArray(e)){var r=e.filter(function(t){return t.charAt(0)==="?"}).filter(function(t){return e.indexOf(t.substring(1))>-1}).map(function(t){return t.substring(1)});if(r.length>0){throw Error("The config of route '"+this._oConfig.name+"' contains standard parameter and query parameter with the same name: '"+r+"'. The name of the routing parameters and query parameter have to differentiate.")}}},_routeSwitched:function(){this._suspend();this.fireEvent("switched",{name:this._oConfig.name})},_suspend:function(){if(this._oRouter._oTargets){this._oRouter._oTargets.suspend(this._oConfig.target);if(this._oConfig.dynamicTarget){this._oRouter._oTargets.suspend(this._oConfig.dynamicTarget)}}},_resume:function(){if(this._oRouter._oTargets){this._oRouter._oTargets.resume(this._oConfig.target);if(this._oConfig.dynamicTarget){this._oRouter._oTargets.resume(this._oConfig.dynamicTarget)}}},destroy:function(){t.prototype.destroy.apply(this);this._aPattern=null;this._aRoutes=null;this._oParent=null;this._oConfig=null;this.bIsDestroyed=true;return this},getURL:function(t){return this._aRoutes[0].interpolate(t||{})},_alignTargetsConfig:function(t){if(!t){return[]}if(!Array.isArray(t)){return typeof t==="string"?[{name:t}]:[t]}return t.map(function(t){if(typeof t==="string"){t={name:t}}return t})},_changeHashWithComponentTargets:function(t,e){var r=this._alignTargetsConfig(this._oConfig.target),n=this._oRouter._oTargets,o,i;if(r&&r.length>0&&n){o=n.getTarget(r);if(!Array.isArray(o)){o=[o]}}else{o=[]}var s=this;i=o.map(function(n,o){if(n._oOptions.type==="Component"){var i=n._load({prefix:r[o].prefix,propagateTitle:r[o].hasOwnProperty("propagateTitle")?r[o].propagateTitle:s._oRouter._oConfig.propagateTitle});return i.then(function(n){var i=n.getRouter(),s=i&&i.getHashChanger(),u=t&&t[r[o].name],h=u&&u.route,c=i&&i.getRoute(h),f;if(u){if(c){f=i._getLastMatchedRouteName()!==h;s.setHash(c.getURL(u.parameters),e||!f);return c._changeHashWithComponentTargets(u.componentTargetInfo,e||f)}else{a.error("[FUTURE FATAL] Can not navigate to route with name '"+h+"' because the route does not exist in component with id '"+n.getId()+"'")}}})}return});return Promise.all(i)},getPattern:function(){return this._aPattern[0]},match:function(t){return this._aRoutes.some(function(e){return e.match(t)})},attachMatched:function(t,e,r){return this.attachEvent("matched",t,e,r)},detachMatched:function(t,e){return this.detachEvent("matched",t,e)},attachBeforeMatched:function(t,e,r){return this.attachEvent("beforeMatched",t,e,r)},detachBeforeMatched:function(t,e){return this.detachEvent("beforeMatched",t,e)},fireBeforeMatched:function(t){this.fireEvent("beforeMatched",t);return this},attachPatternMatched:function(t,e,r){return this.attachEvent("patternMatched",t,e,r)},detachPatternMatched:function(t,e){return this.detachEvent("patternMatched",t,e)},_validateConfig:function(t){if(!t.name){a.error("[FUTURE FATAL] A name has to be specified for every route",this)}if(t.viewName){a.error("[FUTURE FATAL] The 'viewName' option shouldn't be used in Route. please use 'view' instead",this)}},_convertToTargetOptions:function(t){return s({},t,{rootView:t.targetParent,controlId:t.targetControl,controlAggregation:t.targetAggregation,clearControlAggregation:t.clearTarget,viewName:t.view,viewType:t.viewType,viewId:t.viewId})},_getParentRoute:function(t){var e=t.split(":");if(e.length===1||e.length===2&&!e[0]){return this._oRouter.getRoute(e[e.length-1])}else{i(this._oRouter._oOwner,"No owner component for "+this._oRouter._oOwner.getId());var r=o.getOwnerComponentFor(this._oRouter._oOwner);while(r){if(r.isA(e[0])){var n=r.getRouter();return n.getRoute(e[1])}r=o.getOwnerComponentFor(r)}return null}},getPatternArguments:function(t){return this._aRoutes[0].extrapolate(t)}});u.M_EVENTS={BeforeMatched:"beforeMatched",Matched:"matched",PatternMatched:"patternMatched"};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/Router", ["sap/ui/core/library","sap/ui/base/EventProvider","./HashChanger","./Route","./Views","./Targets","./History","sap/ui/thirdparty/crossroads","sap/base/util/each","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/Log","sap/ui/thirdparty/jquery","./RouterHashChanger","sap/ui/core/Component"],function(t,e,i,s,n,a,r,h,o,u,d,f,jQuery,c,g){"use strict";var _={};var l=e.extend("sap.ui.core.routing.Router",{constructor:function(t,s,a,r,u){e.apply(this);this._oConfig=s||{};this._oRouter=h.create();this._oRouter.ignoreState=true;this._oRoutes={};this._oOwner=a;function d(){if(new URLSearchParams(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){f.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Router");return true}return false}this._oConfig._async=this._oConfig.async;if(this._oConfig._async===undefined){this._oConfig._async=d()}this._oViews=new n({component:a,async:this._oConfig._async});if(r){this._oTargets=this._createTargets(this._oConfig,r);this._oTargets._setRouter(this);this._oTargets.attachDisplay(function(t){var e=t.getParameter("routeRelevant");if(this.isInitialized()&&!this._bMatchingProcessStarted){var i=this.getHashChanger();if(i instanceof c&&!e){i.resetHash(this)}}},this)}var g=this,_;if(!t){t={}}if(Array.isArray(t)){_=t;t={};_.forEach(function(e){t[e.name]=e})}o(t,function(t,e){if(e.name===undefined){e.name=t}g.addRoute(e)});this._oRouter.bypassed.add(this._onBypassed.bind(this));if(!u){u=i.getInstance().createRouterHashChanger()}this.setHashChanger(u);var l=this._getParentRouter();if(l){this.attachTitleChanged(function(t){if(this._oOwner&&!this._oOwner._bRoutingPropagateTitle){return}var e=t.getParameters(),i,s;if(l._fnTitleChangedFiredOnChild){l._fnTitleChangedFiredOnChild(e)}else{i=e.nestedHistory.slice();i.unshift({ownerComponentId:l._oOwner.getId(),history:l.getTitleHistory()});s={propagated:true,title:e.title,history:e.history,nestedHistory:i};l.fireTitleChanged(s)}})}},addRoute:function(t,e){if(!t.name){f.error("[FUTURE FATAL] A name has to be specified for every route",this)}if(this._oRoutes[t.name]){f.error("Route with name "+t.name+" already exists",this)}this._oRoutes[t.name]=this._createRoute(this,t,e)},parse:function(t){if(this._oRouter){this._oRouter.parse(t)}else{f.warning("[FUTURE FATAL] This router has been destroyed while the hash changed. No routing events where fired by the destroyed instance.",this)}},initialize:function(t){var e=this,i;if(this._bIsInitialized){f.warning("Router is already initialized.",this);return this}this._bIsInitialized=true;this._bLastHashReplaced=false;this._bHashChangedAfterTitleChange=false;this.fnHashChanged=function(t){e.parse(t.getParameter("newHash"));e._bHashChangedAfterTitleChange=true};if(!this.oHashChanger){f.error("[FUTURE FATAL] navTo of the router is called before the router is initialized. If you want to replace the current hash before you initialize the router you may use getUrl and use replaceHash of the Hashchanger.",this);return this}if(this._oTargets){var s=this._oRoutes[this._oConfig.homeRoute];this._oTargets.attachTitleChanged(this._forwardTitleChanged,this);this._aHistory=[];var n=s&&C(this._oOwner,s);if(n){this._aHistory.push(n)}}if(this.oHashChanger instanceof c){this.oHashChanger._setActiveRouter(this)}this.oHashChanger.init();i=this.oHashChanger.getHash();this.oHashChanger.attachEvent("hashChanged",this.fnHashChanged);if(t){if(this._oMatchedRoute){this._oMatchedRoute._resume()}}else if(i!==c.InvalidHash){this.parse(i)}return this},_forwardTitleChanged:function(t){var e=t.getParameters();var i={title:e.title};var s=this._oRoutes[this._oConfig.homeRoute];if(s&&p(e.name,s._oConfig.name)){i.isHome=true}this.fireTitleChanged(i)},stop:function(){if(!this._bIsInitialized){f.warning("Router is not initialized. But it got stopped",this)}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged)}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced)}if(this._oTargets){this._oTargets.detachTitleChanged(this._forwardTitleChanged,this);this._oTargets._oLastTitleTarget={}}if(this._oMatchedRoute){this._oMatchedRoute._routeSwitched()}this._bIsInitialized=false;delete this._oPreviousTitleChangedRoute;return this},isStopped:function(){return this._bIsInitialized===false},isInitialized:function(){return this._bIsInitialized===true},getHashChanger:function(){return this.oHashChanger},setHashChanger:function(t){if(this.oHashChanger){f.warning("The Router already has a HashChanger set and this call is ignored")}else{this.oHashChanger=t}return this},destroy:function(){if(this.bIsDestroyed){return this}e.prototype.destroy.apply(this);if(this._oViews){this._oViews.destroy();this._oViews=null}if(!this._bIsInitialized){f.info("Router is not initialized, but got destroyed.",this)}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged)}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced)}this._oRouter.removeAllRoutes();this._oRouter=null;o(this._oRoutes,function(t,e){e.destroy()});this._oRoutes=null;this._oConfig=null;if(this._oTargets){this._oTargets.destroy();this._oTargets=null}delete this._bIsInitialized;this.bIsDestroyed=true;return this},getURL:function(t,e){var i=this.getRoute(t);if(i){return i.getURL(e)}else{f.warning("[FUTURE FATAL] Route with name "+t+" does not exist",this)}},match:function(t){return Object.keys(this._oRoutes).some(function(e){return this._oRoutes[e].match(t)}.bind(this))},getRouteByHash:function(t){for(var e in this._oRoutes){if(this._oRoutes.hasOwnProperty(e)){var i=this.getRoute(e);if(i.match(t)){return i}}}},getRouteInfoByHash:function(t){var e=this.getRouteByHash(t);if(!e){return undefined}return{name:e._oConfig.name,arguments:e.getPatternArguments(t)}},getRoute:function(t){return this._oRoutes[t]},getViews:function(){return this._oViews},_createTargets:function(t,e){return new a({views:this._oViews,config:t,targets:e})},_createRoute:function(t,e,i){return new s(t,e,i)},getView:function(t,e,i){f.warning("Deprecated API Router#getView called - use Router#getViews instead.",this);var s=this._oViews._getViewWithGlobalId({viewName:t,type:e,id:i},true);this.fireViewCreated({view:s,viewName:t,type:e});return s},setView:function(t,e){this._oViews.setView(t,e);return this},_getParentRouter:function(){var t=this._oOwner&&g.getOwnerComponentFor(this._oOwner);return t&&t.getRouter()},navTo:function(t,e,i,s){var n=this,a=this.getRoute(t),r,h;if(this.isStopped()){f.info("The router instance "+this._sId+" is stopped. No navigation can be performed.");return this}if(!a){f.warning("[FUTURE FATAL] Route with name "+t+" does not exist",this);return this}var o=this._getLastMatchedRouteName()!==t&&this._sRouteInProgress!==t;this._sRouteInProgress=t;if(typeof i==="boolean"){s=i}if(e===undefined){e={}}if(i&&!d(i)){if(!this._oConfig._async){f.error("navTo with component target info is only supported with async router",this);return this}r=a._changeHashWithComponentTargets(i,o)}h=a.getURL(e);if(s){n._bLastHashReplaced=true;n.oHashChanger.replaceHash(h,r,!o)}else{n.oHashChanger.setHash(h,r,!o)}return this},_getLastMatchedRouteName:function(){return this._oMatchedRoute&&this._oMatchedRoute._oConfig.name},getTargets:function(){return this._oTargets},getTarget:function(t){return this._oTargets.getTarget(t)},attachRouteMatched:function(t,e,i){this.attachEvent("routeMatched",t,e,i);return this},detachRouteMatched:function(t,e){this.detachEvent("routeMatched",t,e);return this},fireRouteMatched:function(t){this.fireEvent("routeMatched",t);if(l._interceptRouteMatched){l._interceptRouteMatched(this._oConfig.controlId,this)}return this},attachBeforeRouteMatched:function(t,e,i){this.attachEvent("beforeRouteMatched",t,e,i);return this},detachBeforeRouteMatched:function(t,e){this.detachEvent("beforeRouteMatched",t,e);return this},fireBeforeRouteMatched:function(t){this.fireEvent("beforeRouteMatched",t);return this},attachViewCreated:function(t,e,i){this.attachEvent("viewCreated",t,e,i);return this},detachViewCreated:function(t,e){this.detachEvent("viewCreated",t,e);return this},fireViewCreated:function(t){this.fireEvent("viewCreated",t);return this},attachRoutePatternMatched:function(t,e,i){this.attachEvent("routePatternMatched",t,e,i);return this},detachRoutePatternMatched:function(t,e){this.detachEvent("routePatternMatched",t,e);return this},fireRoutePatternMatched:function(t){this.fireEvent("routePatternMatched",t);return this},attachBypassed:function(t,e,i){return this.attachEvent(l.M_EVENTS.BYPASSED,t,e,i)},detachBypassed:function(t,e){return this.detachEvent(l.M_EVENTS.BYPASSED,t,e)},fireBypassed:function(t){return this.fireEvent(l.M_EVENTS.BYPASSED,t)},attachTitleChanged:function(t,e,i){this.attachEvent(l.M_EVENTS.TITLE_CHANGED,t,e,i);return this},detachTitleChanged:function(t,e){return this.detachEvent(l.M_EVENTS.TITLE_CHANGED,t,e)},fireTitleChanged:function(e){if(this.isStopped()){return this}var i=!this._pWaitForTitleChangedOnChild;if(!e.propagated){e.propagated=false;var s=r.getInstance().getDirection(),n=this.getHashChanger().getHash(),a=t.routing.HistoryDirection,h=this._aHistory[this._aHistory.length-1],o;if(s===a.Backwards&&h&&!h.isHome){if(h&&h.title!==e.title){this._aHistory.pop()}}else if(h&&h.hash==n){h.title=e.title;this._aHistory.some(function(t,e,i){if(e<i.length-1&&u(t,h)){i.splice(e,1);return true}return false})}else{if(this._bLastHashReplaced){this._aHistory.pop()}o={hash:n,title:e.title};this._aHistory.some(function(t,e,i){if(u(t,o)){return i.splice(e,1)}});this._aHistory.push(o)}e.history=this._aHistory.slice(0,-1);e.nestedHistory=[{history:this.getTitleHistory(),ownerComponentId:this._oOwner&&this._oOwner.getId()}];this._bLastHashReplaced=false;this._oPreviousTitleChangedRoute=this._oMatchedRoute;this._bFireTitleChanged=false;if(this._pWaitForTitleChangedOnChild){this._pWaitForTitleChangedOnChild.then(function(t){e.title=t.title;e.propagated=true;Array.prototype.push.apply(e.nestedHistory,t.nestedHistory);this._stopWaitingTitleChangedFromChild();this.fireEvent(l.M_EVENTS.TITLE_CHANGED,e)}.bind(this))}}if(i){if(this._bMatchingProcessStarted&&this._isAsync()){this.attachEventOnce("routeMatched",function(){this.fireEvent(l.M_EVENTS.TITLE_CHANGED,e)},this)}else{this.fireEvent(l.M_EVENTS.TITLE_CHANGED,e)}}return this},getTitleHistory:function(){return this._aHistory||[]},_waitForTitleChangedOn:function(t){if(this._bFireTitleChanged){this._pWaitForTitleChangedOnChild=new Promise(function(t){this._fnTitleChangedFiredOnChild=t}.bind(this))}},_stopWaitingTitleChangedFromChild:function(){delete this._pWaitForTitleChangedOnChild;delete this._fnTitleChangedFiredOnChild},register:function(t){_[t]=this;return this},_onBypassed:function(t){var e=function(){this.fireBypassed({hash:t})}.bind(this);if(this._oConfig.bypassed){var i=this._oTargets.display(this._oConfig.bypassed.target,{hash:t});if(i instanceof Promise){i.then(e);return}}e()},_isAsync:function(){return this._oConfig._async},metadata:{publicMethods:["initialize","getURL","register","getRoute"]}});function p(t,e){return e&&e.indexOf(t)>-1}function C(t,e){var i=e.getPattern(),s=t&&t.getManifestEntry("sap.app/title");if(i===""||i!==undefined&&!/({.*})+/.test(i)){return{hash:i,isHome:true,title:s}}else{f.error("[FUTURE FATAL] Routes with dynamic parts cannot be resolved as home route.")}}l.M_EVENTS={BEFORE_ROUTE_MATCHED:"beforeRouteMatched",ROUTE_MATCHED:"routeMatched",ROUTE_PATTERN_MATCHED:"routePatternMatched",VIEW_CREATED:"viewCreated",BYPASSED:"bypassed",TITLE_CHANGED:"titleChanged"};l._interceptRouteMatched=undefined;l.getRouter=function(t){return _[t]};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/RouterHashChanger", ["./HashChangerBase"],function(e){"use strict";var t=e.extend("sap.ui.core.routing.RouterHashChanger",{constructor:function(t){if(!t||!t.parent){throw new Error("sap.ui.core.routing.RouterHashChanger can't be instantiated without a parent")}this.parent=t.parent;this.hash=t.hash||"";this.subHashMap=t.subHashMap;this.key=t.key||"";e.apply(this)}});t.InvalidHash="SapUiCoreRoutingInvalidHash"+(new Date).getTime();t.prototype.init=function(){this.parent.init()};t.prototype._generatePrefixedKey=function(e){return this.key?this.key+"-"+e:e};t.prototype.createSubHashChanger=function(e){this.children=this.children||{};var i=this._generatePrefixedKey(e);if(this.children[i]){return this.children[i]}var h=new t({key:i,parent:this,subHashMap:this.subHashMap,hash:this.subHashMap&&this.subHashMap[i]||""});h.attachEvent("hashSet",this._onChildHashChanged.bind(this,i));h.attachEvent("hashReplaced",this._onChildHashChanged.bind(this,i));this.children[i]=h;return h};t.prototype.fireHashChanged=function(e,t,i){var h,s=this.hash;this.hash=e;this.subHashMap=t;if(!i&&e!==s){this.fireEvent("hashChanged",{newHash:e,oldHash:s})}if(this.children){h=Object.keys(this.children);h.forEach(function(e){var h=t[e]===undefined?"":t[e];this.children[e].fireHashChanged(h,t,i)}.bind(this))}};t.prototype._onChildHashChanged=function(e,t){var i=t.getParameter("key")||e,h=t.getParameter("hash"),s=t.getParameter("nestedHashInfo"),n=t.getParameter("deletePrefix");if(this._bCollectMode){this._collectHash(i,h,n)}else{this.fireEvent(t.getId(),{hash:h,key:i,nestedHashInfo:s,deletePrefix:n})}};t.prototype._collectHash=function(e,t,i){this._aCollectedHashInfo=this._aCollectedHashInfo||[];this._aCollectedHashInfo.push({key:e,hash:t,deletePrefix:i})};t.prototype._hasRouterAttached=function(){return this.hasListeners("hashChanged")};t.prototype._collectActiveDescendantPrefix=function(){if(this.children){var e=Object.keys(this.children);return e.reduce(function(e,t){var i=this.children[t];if(i._hasRouterAttached()){e.push(t);Array.prototype.push.apply(e,i._collectActiveDescendantPrefix())}return e}.bind(this),[])}else{return[]}};t.prototype.getHash=function(){if(this._isUnderCollectMode()){return t.InvalidHash}else{return this.hash}};t.prototype._setActiveRouter=function(e){if(e.getHashChanger()===this){this._oActiveRouter=e}return this};t.prototype.resetHash=function(e){if(e&&this._oActiveRouter===e){this.hash=undefined}return this};t.prototype.setHash=function(e,t,i){if(!(t instanceof Promise)){i=t;t=null}return this._modifyHash(e,t,i)};t.prototype.replaceHash=function(e,t,i,h){if(typeof t!=="string"){h=i;i=t;t=undefined}if(!(i instanceof Promise)){h=i;i=null}return this._modifyHash(e,i,h,true,t)};t.prototype._modifyHash=function(e,t,i,h,s){var n=h?"hashReplaced":"hashSet",r=this,a={hash:e};if(h&&s){a.direction=s}if(!i){a.deletePrefix=this._collectActiveDescendantPrefix()}if(t){this._bCollectMode=true;return t.then(function(){a.nestedHashInfo=r._aCollectedHashInfo;r.fireEvent(n,a);r._aCollectedHashInfo=null;r._bCollectMode=false})}else{this.fireEvent(n,a)}};t.prototype._isUnderCollectMode=function(){return this.parent instanceof t&&this.parent._isInCollectMode()};t.prototype._isInCollectMode=function(){return this._bCollectMode||this.parent instanceof t&&this.parent._isInCollectMode()};t.prototype.destroy=function(){this.parent.deregisterRouterHashChanger(this);if(this.children){Object.keys(this.children).forEach(function(e){var t=this.children[e];t.destroy()}.bind(this));delete this.children}delete this.hash;delete this.subHashMap;delete this.parent;delete this.key;e.prototype.destroy.apply(this,arguments)};t.prototype.deregisterRouterHashChanger=function(e){if(this.children){Object.keys(this.children).some(function(t){var i=this.children[t];if(i===e){delete this.children[t];return true}}.bind(this))}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/Target", ["sap/ui/core/Control","sap/ui/base/EventProvider","sap/ui/core/mvc/View","sap/ui/core/routing/async/Target","sap/ui/core/routing/sync/Target","sap/base/Log"],function(t,e,i,n,r,o){"use strict";var s=t.extend("sap.ui.core.routing.Target.TitleProvider",{metadata:{library:"sap.ui.core",properties:{title:{type:"string",group:"Data",defaultValue:null}}},constructor:function(e){this._oTarget=e.target;delete e.target;t.prototype.constructor.call(this,e)},setTitle:function(t){this.setProperty("title",t,true);if(this._oTarget._bIsDisplayed&&t){this._oTarget.fireTitleChanged({name:this._oTarget._oOptions._name,title:t})}}});var a=e.extend("sap.ui.core.routing.Target",{constructor:function(t,i){var a;function h(){if(new URLSearchParams(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){o.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Target");return true}return false}if(t._async===undefined){t._async=h()}if(t.type==="Component"&&!t._async){a="sap.ui.core.routing.Target doesn't support loading component in synchronous mode, please switch routing to async";o.error(a);throw new Error(a)}this._updateOptions(t);this._oCache=i;e.apply(this,arguments);if(this._oOptions.title){this._oTitleProvider=new s({target:this})}var l=this._oOptions._async?n:r;for(var d in l){this[d]=l[d]}this._bIsDisplayed=false;this._bIsLoaded=false},destroy:function(){this._oParent=null;this._oOptions=null;this._oCache=null;if(this._oTitleProvider){this._oTitleProvider.destroy()}this._oTitleProvider=null;e.prototype.destroy.apply(this,arguments);this.bIsDestroyed=true;return this},attachDisplay:function(t,e,i){return this.attachEvent(this.M_EVENTS.DISPLAY,t,e,i)},detachDisplay:function(t,e){return this.detachEvent(this.M_EVENTS.DISPLAY,t,e)},fireDisplay:function(t){var e=this._oTitleProvider&&this._oTitleProvider.getTitle();if(e){this.fireTitleChanged({name:this._oOptions._name,title:e})}this._bIsDisplayed=true;t=t||{};t.config=this._oRawOptions;return this.fireEvent(this.M_EVENTS.DISPLAY,t)},attachTitleChanged:function(t,e,i){var n=this.hasListeners("titleChanged"),r=this._oTitleProvider&&this._oTitleProvider.getTitle();this.attachEvent(this.M_EVENTS.TITLE_CHANGED,t,e,i);if(!n&&r&&this._bIsDisplayed){this.fireTitleChanged({name:this._oOptions._name,title:r})}return this},detachTitleChanged:function(t,e){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,t,e)},fireTitleChanged:function(t){return this.fireEvent(this.M_EVENTS.TITLE_CHANGED,t)},_getEffectiveObjectName:function(t){var e=this._oOptions.path;if(e){t=e+"."+t}return t},_updateOptions:function(t){var e=Object.assign({},t);if(e.viewName){if(e.name){e._name=e.name}e.type="View";e.name=e.viewName;if(e._async){delete e.viewName}if(e.viewPath){e.path=e.viewPath;if(e._async){delete e.viewPath}}if(e.viewId){e.id=e.viewId;if(e._async){delete e.viewId}}}else if(!e._async&&e.type){o.error("Sync Target '"+e._name+"' uses the new options which are only supported by async Target.")}this._oOptions=e;this._oRawOptions=t},_bindTitleInTitleProvider:function(t){if(this._oTitleProvider&&t instanceof i){this._oTitleProvider.applySettings({title:this._oOptions.title},t.getController())}},_addTitleProviderAsDependent:function(t){if(!this._oTitleProvider){return}var e=this._oTitleProvider.getParent();if(e){e.removeDependent(this._oTitleProvider)}if(t instanceof i){t.addDependent(this._oTitleProvider)}},_beforePlacingViewIntoContainer:function(t){},M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/TargetCache", ["sap/ui/base/EventProvider","sap/ui/core/routing/async/TargetCache","sap/ui/core/routing/sync/TargetCache","sap/base/assert","sap/base/Log"],function(e,t,n,o,r){"use strict";var i=e.extend("sap.ui.core.routing.TargetCache",{constructor:function(r){if(!r){r={}}this._oCache={view:{},component:{}};this._oComponent=r.component;if(this._oComponent){o(this._oComponent.isA("sap.ui.core.UIComponent"),this+" - the component passed to the constructor needs to be an instance of UIComponent")}e.apply(this,arguments);this.async=r.async;if(this.async===undefined){this.async=true}var i=this.async?t:n;for(var s in i){this[s]=i[s]}},metadata:{publicMethods:["get","set"]},get:function(e,t){var n;try{if(t==="Component"&&!this.async){r.error("sap.ui.core.routing.Target doesn't support loading component in synchronous mode, please switch routing to async");throw new Error("sap.ui.core.routing.Target doesn't support loading component in synchronous mode, please switch routing to async")}if(!e){r.error("the oOptions parameter of getObject is mandatory",this);throw new Error("the oOptions parameter of getObject is mandatory")}n=this._get(e,t)}catch(e){return Promise.reject(e)}if(n instanceof Promise){return n}else if(n.isA("sap.ui.core.mvc.View")){return n.loaded()}else{return Promise.resolve(n)}},fetch:function(e,t){return this._get(e,t,undefined,undefined,true)},set:function(e,t,n){var r;this._checkName(e,t);o(t==="View"||t==="Component","sType must be either 'View' or 'Component'");r=this._oCache[t.toLowerCase()][e];if(!r){r=this._oCache[t.toLowerCase()][e]={}}r[undefined]=n;return this},destroy:function(){e.prototype.destroy.apply(this);if(this.bIsDestroyed){return this}function t(e){if(e&&e.destroy&&!e._bIsBeingDestroyed){e.destroy()}}Object.keys(this._oCache).forEach(function(e){var n=this._oCache[e];Object.keys(n).forEach(function(e){var o=n[e];Object.keys(o).forEach(function(e){var n=o[e];if(n instanceof Promise){n.then(t)}else{t(n)}})})}.bind(this));this._oCache=undefined;this.bIsDestroyed=true;return this},attachCreated:function(e,t,n){return this.attachEvent("created",e,t,n)},detachCreated:function(e,t){return this.detachEvent("created",e,t)},fireCreated:function(e){return this.fireEvent("created",e)},_get:function(e,t,n,o,r){var i;switch(t){case"View":i=this._getView(e,n,r);break;case"Component":i=this._getComponent(e,n,o,r);break;default:throw Error("The given sType: "+t+" isn't supported by TargetCache.getObject")}return i},_getView:function(e,t,n){if(!t){e=this._createId(e)}return this._getViewWithGlobalId(e,false,n)},_getComponent:function(e,t,n,o){if(!t){e=this._createId(e)}return this._getComponentWithGlobalId(e,n,o)},_createId:function(e){if(this._oComponent&&e.id){e=Object.assign({},e,{id:this._oComponent.createId(e.id)})}return e},_checkName:function(e,t){if(!e){var n="A name for the "+t.toLowerCase()+" has to be defined";r.error(n,this);throw Error(n)}}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/Targets", ["sap/ui/base/EventProvider","./Target","./async/Targets","./sync/Targets","sap/base/Log","sap/base/util/deepExtend"],function(t,e,i,a,n,r){"use strict";var s=t.extend("sap.ui.core.routing.Targets",{constructor:function(e){t.apply(this);this._mTargets={};this._oLastTitleTarget={};this._oConfig=e.config;this._oCache=e.cache||e.views;if(!this._oConfig){this._oConfig={_async:false}}function r(){if(new URLSearchParams(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){n.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Targets");return true}return false}if(this._oConfig._async===undefined){this._oConfig._async=this._oConfig.async===undefined?r():this._oConfig.async}var s=this._oConfig._async?i:a;for(var o in s){this[o]=s[o]}Object.keys(e.targets).forEach(function(t){this._createTarget(t,e.targets[t])}.bind(this));Object.keys(this._mTargets).forEach(function(t){this._addParentTo(this._mTargets[t])}.bind(this))},_setRouter:function(t){if(!this._oRouter){this._oRouter=t}else{n.warning("The Targets is already connected with a router and this call of _setRouter is ignored")}return this},destroy:function(){var e;t.prototype.destroy.apply(this);for(e in this._mTargets){if(this._mTargets.hasOwnProperty(e)){this._mTargets[e].destroy()}}this._mTargets=null;this._oCache=null;this._oConfig=null;this.bIsDestroyed=true;return this},getViews:function(){return this._oCache},getCache:function(){return this._oCache},getTarget:function(t,e){var i=this,a=this._alignTargetsInfo(t),r;r=a.reduce(function(t,a){var r=i._mTargets[a.name];if(r){t.push(r)}else if(!e){n.error('The target you tried to get "'+a.name+'" does not exist!',i)}return t},[]);return r.length<=1?r[0]:r},addTarget:function(t,e){var i=this.getTarget(t,true),a;if(i){n.error("[FUTURE FATAL] Target with name "+t+" already exists",this)}else{a=this._createTarget(t,e);this._addParentTo(a)}return this},suspend:function(t){var e=this._alignTargetsInfo(t);e.forEach(function(t){var e=t.name;var i=this.getTarget(e);if(i){i.suspend()}}.bind(this));return this},resume:function(t){var e=this._alignTargetsInfo(t);e.forEach(function(t){var e=t.name;var i=this.getTarget(e);if(i){i.resume()}}.bind(this));return this},attachDisplay:function(t,e,i){return this.attachEvent(this.M_EVENTS.DISPLAY,t,e,i)},detachDisplay:function(t,e){return this.detachEvent(this.M_EVENTS.DISPLAY,t,e)},fireDisplay:function(t){return this.fireEvent(this.M_EVENTS.DISPLAY,t)},attachTitleChanged:function(t,e,i){this.attachEvent(this.M_EVENTS.TITLE_CHANGED,t,e,i);return this},detachTitleChanged:function(t,e){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,t,e)},fireTitleChanged:function(t){if(this._oLastTitleTarget.name!==t.name||this._oLastTitleTarget.title!==t.title){this._oLastTitleTarget.name=t.name;this._oLastTitleTarget.title=t.title;this.fireEvent(this.M_EVENTS.TITLE_CHANGED,t)}return this},M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"},_alignTargetsInfo:function(t){if(t===undefined){return[]}if(!Array.isArray(t)){return typeof t==="object"?[t]:[{name:t}]}return t.map(function(t){if(typeof t!=="object"){t={name:t}}return t})},_createTarget:function(t,e){var i,a,n={_name:t};if(this._vRootViewId){n.rootView=this._vRootViewId}a=r(n,this._oConfig,e);i=this._constructTarget(a);i.attachDisplay(function(e){var i=e.getParameters();this.fireDisplay({name:t,view:i.view,object:i.object,control:i.control,config:i.config,data:i.data,routeRelevant:i.routeRelevant})},this);this._mTargets[t]=i;return i},_addParentTo:function(t){var e,i=t._oOptions.parent;if(!i){return}e=this._mTargets[i];if(!e){n.error("[FUTURE FATAL] The target '"+t._oOptions._name+" has a parent '"+i+"' defined, but it was not found in the other targets",this);return}t._oParent=e},_constructTarget:function(t,i){return new e(t,this._oCache,i)},_setRootViewId:function(t){var e,i;for(e in this._mTargets){if(this._mTargets.hasOwnProperty(e)){i=this._mTargets[e]._oOptions;if(i.rootView===undefined){i.rootView=t}}}this._vRootViewId=t},_getTitleTargetName:function(t,e){var i,a;if(e){t=[e]}t=this._alignTargetsInfo(t);t.some(function(t){i=this.getTarget(t);while(i&&!i._oOptions.title){i=i._oParent}if(i){a=i._oOptions._name;return true}}.bind(this));return a},_forwardTitleChanged:function(t){this.fireTitleChanged({name:t.getParameter("name"),title:t.getParameter("title")})},_attachTitleChanged:function(t,e){var i,a;a=this._getTitleTargetName(t,e);if(a){i=this.getTarget(a)}if(this._oLastDisplayedTitleTarget){this._oLastDisplayedTitleTarget.detachTitleChanged(this._forwardTitleChanged,this);this._oLastDisplayedTitleTarget._bIsDisplayed=false}if(i){i.attachTitleChanged({name:i._oOptions._name},this._forwardTitleChanged,this);this._oLastDisplayedTitleTarget=i}else if(e){n.error('[FUTURE FATAL] The target with the name "'+e+'" where the titleChanged event should be fired does not exist!',this)}}});return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/Views", ["./TargetCache","sap/base/Log"],function(e,t){"use strict";var i=e.extend("sap.ui.core.routing.Views",{metadata:{publicMethods:["getView","setView"]},constructor:function(i){if(!i){i={}}function n(){if(new URLSearchParams(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){t.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","TargetCache");return true}return false}if(i.async===undefined){i.async=n()}e.apply(this,[i])},getView:function(e){return this.get(e,"View")},setView:function(e,t){return this.set(e,"View",t)},fireCreated:function(e){if(e){e.view=e.object;e.viewOptions=e.options}return this.fireEvent("created",e)}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/async/Route", ["sap/base/Log","sap/base/util/extend","sap/ui/core/Component"],function(e,t,i){"use strict";return{_routeMatched:function(o,a,r){var n=this._oRouter,s,h,g,u,_=null,f=null,l,c,d,p,T=n._oMatchedRoute===this;n._sRouteInProgress=null;n._stopWaitingTitleChangedFromChild();if(n._oMatchedRoute){delete n._oMatchedRoute._oConfig.dynamicTarget}n._oMatchedRoute=this;n._bMatchingProcessStarted=true;g=t({},n._oConfig,this._oConfig);h=n.getTargets();var C;if(h){C=h._getTitleTargetName(g.target,g.titleTarget);if(C&&n._oPreviousTitleChangedRoute!==this){n._bFireTitleChanged=true;if(n._oOwner&&n._oOwner._bRoutingPropagateTitle){var R=i.getOwnerComponentFor(n._oOwner);var v=R&&R.getRouter();if(v){v._waitForTitleChangedOn(n)}}}else{n._bFireTitleChanged=false}if(this._oConfig.target){p=h._alignTargetsInfo(this._oConfig.target);p.forEach(function(e){e.propagateTitle=e.hasOwnProperty("propagateTitle")?e.propagateTitle:n._oConfig.propagateTitle;e.routeRelevant=true;e.repeatedRoute=T})}}else{p=this._oConfig.target}if(!a||a===true){l=true;a=Promise.resolve()}if(this._oParent){a=this._oParent._routeMatched(o,a)}else if(this._oNestingParent){this._oNestingParent._routeMatched(o,a,this)}c=Object.assign({},o);c.routeConfig=g;u={name:g.name,arguments:o,config:g};if(r){u.nestedRoute=r}this.fireBeforeMatched(u);n.fireBeforeRouteMatched(u);if(this._oTarget){s=this._oTarget;s._updateOptions(this._convertToTargetOptions(g));a=s._place(a,{legacy:true});if(this._oRouter._oTargetHandler&&this._oRouter._oTargetHandler._chainNavigation){d=a;a=this._oRouter._oTargetHandler._chainNavigation(function(){return d})}}else{a=n._oTargets._display(p,c,this._oConfig.titleTarget,a)}return a.then(function(t){n._bMatchingProcessStarted=false;var i,a,r;if(Array.isArray(t)){i=t;t=i[0]}t=t||{};_=t.view;f=t.control;u.view=_;u.targetControl=f;if(i){a=[];r=[];i.forEach(function(e){a.push(e.view);r.push(e.control)});u.views=a;u.targetControls=r}if(g.callback){g.callback(this,o,g,f,_)}this.fireEvent("matched",u);n.fireRouteMatched(u);if(l){e.info("The route named '"+g.name+"' did match with its pattern",this);this.fireEvent("patternMatched",u);n.fireRoutePatternMatched(u)}return t}.bind(this))}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/async/Target", ["sap/base/Log","sap/ui/base/ManagedObjectMetadata","sap/ui/core/ComponentContainer","sap/ui/core/Element","sap/ui/core/Placeholder","sap/ui/core/library","sap/ui/core/Configuration"],function(e,t,o,n,i,r,a){"use strict";var s=r.ComponentLifecycle;return{display:function(e){var t=Promise.resolve();return this._display(e,t)},_display:function(e,t,o){if(this._oParent){t=this._oParent._display(e,t,Object.assign({},o))}return this._place(e,t,o)},suspend:function(){if(this._oParent){this._oParent.suspend()}if(this._isLoaded()){var t=this._get(),o;if(t.isA("sap.ui.core.UIComponent")&&(o=t.getRouter())&&t.hasNativeRouter()){o.stop()}}else{e.warning("The target with name '"+this._oOptions._name+"' can't be suspended because it's being loaded or not loaded yet")}return this},resume:function(){if(this._oParent){this._oParent.resume()}if(this._isLoaded()){var e=this._get(),t;if(e.isA("sap.ui.core.UIComponent")&&(t=e.getRouter())&&e.hasNativeRouter()){t.initialize(true)}}return this},_isLoaded:function(){return this._bIsLoaded},_getCreateOptions:function(){var e=this._getEffectiveObjectName(this._oOptions.name),o=this._oOptions,n;switch(o.type){case"View":n={name:e,type:o.viewType,id:o.id,async:true};break;case"Component":o.id=o.id||t.uid("uicomponent");n={id:o.id};if(o.usage){n.usage=o.usage}else{n.name=e}n=Object.assign({},o.options||{},n);break;default:throw new Error("The given type "+o.type+" isn't support by sap.ui.core.routing.Target")}return n},_get:function(e){var t=this._getCreateOptions();return this._oCache._get(t,this._oOptions.type,this._bUseRawViewId,e)},_load:function(e){var t=this._get(e),o;if(!(t instanceof Promise)){if(t.isA("sap.ui.core.mvc.View")){o=t.loaded()}else{o=Promise.resolve(t)}}else{o=t}return o.then(function(e){this._bIsLoaded=true;return e}.bind(this))},load:function(e){return this._load(e).then(function(t){return{object:t,nestedComponentReady:this.waitForComponentTarget({target:t,createInfo:e})}}.bind(this))},waitForComponentTarget:function(e){return new Promise(function(t,o){var n=e.target;var i=e.createInfo;var r=true;if(n.isA("sap.ui.core.UIComponent")){var a=n.getRouter();if(a&&n.hasNativeRouter()){var s=a.getHashChanger().getHash();var l=a.getRouteByHash(s);var c=i&&i.ignoreInitialHash;if(!a._oConfig.async){throw new Error("The router of component '"+n.getId()+"' which is loaded via the target '"+this._oOptions._name+"' is defined as synchronous which is not supported using as a nested component.")}if(a._oOwner&&i){a._oOwner._bRoutingPropagateTitle=i.propagateTitle}if(!c&&(!a.isInitialized()||a._bMatchingProcessStarted)&&l&&l._oConfig.target){r=false;a.attachRouteMatched(t)}if(a.isStopped()){a.initialize(c)}}}if(r){t()}}.bind(this))},resolveContainerControl:function(e){return Promise.resolve().then(function(){e=e||{};var t=this._oOptions;var o=this._isValid(e);var i;if(o!==true){i=o;return this._refuseInvalidTarget(t._name,i)}var r=e.view,a=e.control,s,l;if(r&&r.isA("sap.ui.core.ComponentContainer")){r=r.getComponentInstance().getRootControl()}if(!r&&t.rootView){s=Promise.resolve(t.rootView).then(function(e){var o;if(e){o=n.getElementById(e);t.rootView=e}if(!o){i="Did not find the root view with the id "+t.rootView;return this._refuseInvalidTarget(t._name,i)}else{return o}}.bind(this))}else{s=Promise.resolve(r)}s=s.then(function(e){if(e&&e.isA("sap.ui.core.mvc.View")){return e.loaded()}else{return e}});if(t.controlId){l=s.then(function(e){var o;if(e){o=e.byId(t.controlId)}if(!o){o=n.getElementById(t.controlId)}return o})}else{l=Promise.resolve(a)}return l.then(function(e){if(!e){i="Control with ID "+t.controlId+" could not be found";return this._refuseInvalidTarget(t._name,i)}else{return e}}.bind(this))}.bind(this))},displayPlaceholder:function(e,t){var r,a=this._oOptions,l=a.type==="Component",c=false,d=e.placeholder||a.placeholder||{},h=Promise.resolve();if(i.hasProviders()){Object.assign(d,i.getPlaceholderFromProviders({name:a.name,type:a.type}))}if(Object.keys(d).length>0){if(d.autoClose===undefined){d.autoClose=true}c=true}if(l){var u=this._oCache._oComponent;var f=a.id+"-container";r=u&&u.byId(f)||n.getElementById(f);if(!r){var p=Object.assign({height:"100%",width:"100%",lifecycle:s.Application},a.containerOptions);if(u){u.runAsOwner(function(){r=new o(u.createId(f),p)})}else{r=new o(f,p)}}if(c){d.container=r}}if(c&&t.isA("sap.ui.core.IPlaceholderSupport")){d.container=t}if(d.container&&!e.repeatedRoute){d.aggregation=this._oOptions.controlAggregation;var g=this._getCreateOptions();var v=this._oCache.fetch(g,this._oOptions.type);if(v&&l){d.object=r}else{d.object=v}if(d.html){d.placeholder=new i({html:d.html})}if(d.placeholder&&i.isEnabled()){h=this.showPlaceholder(d)}}return h.then(function(e){return{containerControl:t,object:r,placeholderConfig:d,placeholderShown:!!e}})},_place:function(t,o,n){var i=this._oOptions,r=this,a,s=i.type==="Component";var l,c;if(t instanceof Promise){n=o;o=t;t=undefined}n=n||{};if((i.name||i.usage)&&i.type){l=this.load(n);if(this._oParent||n.legacy){c=o.then(this.resolveContainerControl.bind(this))}else{c=this.resolveContainerControl()}c=c.then(this.displayPlaceholder.bind(this,n));o=Promise.all([l,c,o]).then(function(e){var t=e[0].object,o=e[1],n,i;o.nestedComponentReady=e[0].nestedComponentReady;if(s){var a=t.destroy;t.destroy=function(){if(a){a.apply(this)}o.object.destroy()};o.object.setComponent(t);i=t.getRootControl();if(i&&i.isA("sap.ui.core.mvc.View")){n=i}}else{o.object=t;n=t}r._bindTitleInTitleProvider(n);r._addTitleProviderAsDependent(n);return o}).then(function(o){var n=o.containerControl,s=o.object;r._beforePlacingViewIntoContainer({container:n,view:s,data:t});var l=n.getMetadata().getJSONKeys()[i.controlAggregation];if(!l){a="Control "+i.controlId+" does not have an aggregation called "+i.controlAggregation;return r._refuseInvalidTarget(i._name,a)}if(i.clearControlAggregation===true){n[l._sRemoveAllMutator]()}e.info("Did place the "+i.type.toLowerCase()+" target '"+(i.name?r._getEffectiveObjectName(i.name):i.usage)+"' with the id '"+s.getId()+"' into the aggregation '"+i.controlAggregation+"' of a control with the id '"+n.getId()+"'",r);n[l._sMutator](s);return{name:i._name,view:s,control:n,nestedComponentReady:o.nestedComponentReady,placeholderConfig:o.placeholderConfig,placeholderShown:o.placeholderShown}})}else{o=o.then(function(){return{name:i._name}})}return o.then(function(e){var o=e.nestedComponentReady||Promise.resolve();return o.then(function(){var o=e.control,i=e.view,a=e.placeholderConfig;if(o&&i){r.fireDisplay({view:i.isA("sap.ui.core.mvc.View")?i:undefined,object:i,control:o,data:t,routeRelevant:n.routeRelevant})}if(a&&a.container&&a.autoClose&&r.hidePlaceholder){r.hidePlaceholder(a)}return e})})},showPlaceholder:function(e){if(e.container&&e.container.showPlaceholder){return e.container.showPlaceholder(e)}else{return Promise.resolve()}},hidePlaceholder:function(e){if(e.container.hidePlaceholder){e.container.hidePlaceholder()}},_isValid:function(t){var o=this._oOptions,n=t&&t.control,i=n||o.controlId,r=true,a="";if(!i){a="[FUTURE FATAL] The target "+o._name+" has no controlId set and no parent so the target cannot be displayed.";r=false}if(!o.controlAggregation){a="[FUTURE FATAL] The target "+o._name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";r=false}if(a){e.error(a,this)}return r||a},_refuseInvalidTarget:function(e,t){return Promise.reject(new Error(t+" - Target: "+e))}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/async/TargetCache", ["sap/ui/core/mvc/View","sap/ui/core/Component","sap/ui/core/routing/HashChanger"],function(e,t,n){"use strict";return{_getObjectWithGlobalId:function(n,i,r,a,o){var s=this,u,c,h,f=this._oComponent,d=[];r=r||{};function g(){switch(i){case"View":n.viewName=n.name;delete n.name;return!n.async||a?e._create(n):e.create(n);case"Component":n.settings=n.settings||{};n.settings._propagateTitle=r.propagateTitle;var o=s._createRouterHashChanger(r.prefix);if(o){n.settings._routerHashChanger=o}if(n.usage){return f.createComponent(n)}else{return t.create(n)}default:}}function C(e){if(s._oCache){d.forEach(function(t){h[t]=e});if(r.afterCreate){r.afterCreate(e)}s.fireCreated({object:e,type:i,options:n})}return e}if(n.async===undefined){n.async=true}c=n.usage||n.name;this._checkName(c,i);h=this._oCache[i.toLowerCase()][c];u=h&&h[n.id];if(o||u){return u}if(f){u=f.runAsOwner(g);if(u instanceof Promise){f.registerForDestroy(u)}}else{u=g()}if(u instanceof Promise){u=u.then(C)}else{u.loaded().then(C)}if(!h){h=this._oCache[i.toLowerCase()][c]={};h[undefined]=u;d.push(undefined)}if(n.id!==undefined){h[n.id]=u;d.push(n.id)}return u},_getViewWithGlobalId:function(e,t,n){if(e&&!e.name){e.name=e.viewName}return this._getObjectWithGlobalId(e,"View",undefined,t,n)},_getComponentWithGlobalId:function(e,t,n){return this._getObjectWithGlobalId(e,"Component",t,n)},_createRouterHashChanger:function(e){var t;var i=this._oComponent&&this._oComponent.getRouter();if(i){t=i.getHashChanger();if(t&&e){t=t.createSubHashChanger(e)}}return t||n.getInstance().createRouterHashChanger()}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/async/Targets", ["sap/base/Log"],function(e){"use strict";return{display:function(e,t,a){var r=Promise.resolve();return this._display(e,t,a,r)},_display:function(e,t,a,r){var i=this,n=[];if(!Array.isArray(e)){e=[e]}this._attachTitleChanged(e,a);return this._alignTargetsInfo(e).reduce(function(e,a){var r={prefix:a.prefix,propagateTitle:a.propagateTitle||false,ignoreInitialHash:a.ignoreInitialHash,placeholder:a.placeholder,repeatedRoute:a.repeatedRoute,routeRelevant:a.routeRelevant||false};return i._displaySingleTarget(a,t,e,r).then(function(e){e=e||{};e.targetInfo=a;n.push(e)})},r).then(function(){return n})},_addDynamicTargetToRoute:function(e){if(this._oRouter){var t=this._oRouter._getLastMatchedRouteName();var a,r;if(t){a=this._oRouter.getRoute(t);if(a&&a._oConfig&&a._oConfig.target){r=this._alignTargetsInfo(a._oConfig.target).some(function(t){return t.name===e.name});if(!r){a._oConfig.dynamicTarget=a._oConfig.dynamicTarget||[];a._oConfig.dynamicTarget.push(e)}}}}},_displaySingleTarget:function(t,a,r,i){var n=t.name,o=this.getTarget(n);if(o!==undefined){if(t.routeRelevant){this._addDynamicTargetToRoute(t)}return o._display(a,r,i)}else{var s='[FUTURE FATAL] The target with the name "'+n+'" does not exist!';e.error(s,this);return Promise.resolve({name:n,error:s})}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/sync/Route", ["sap/base/Log","sap/base/util/extend"],function(t,e){"use strict";return{_routeMatched:function(i,a,r){var o=this._oRouter,s,n,h,f,g,c=null,u=null,_,l,d,p,C;o._sRouteInProgress=null;o._oMatchedRoute=this;o._bMatchingProcessStarted=true;if(this._oParent){s=this._oParent._routeMatched(i)}else if(this._oNestingParent){this._oNestingParent._routeMatched(i,false,this)}f=e({},o._oConfig,this._oConfig);_=Object.assign({},i);_.routeConfig=f;g={name:f.name,arguments:i,config:f};if(r){g.nestedRoute=r}this.fireBeforeMatched(g);o.fireBeforeRouteMatched(g);if(this._oTarget){h=this._oTarget;h._updateOptions(this._convertToTargetOptions(f));if(h._isValid(s,false)){n=h._place(s)}n=n||{};c=n.oTargetParent;u=n.oTargetControl;g.view=c;g.targetControl=u}else{d=[];p=[];l=function(t){d.push(t.getParameter("view"));p.push(t.getParameter("control"))};if(Array.isArray(this._oConfig.target)){C=this._oConfig.target}else{C=[this._oConfig.target]}C.forEach(function(t){var e=o._oTargets.getTarget(t);if(e){e.attachEventOnce("display",l)}});o._oTargets._display(this._oConfig.target,_,this._oConfig.titleTarget);g.view=d[0];g.targetControl=p[0];g.views=d;g.targetControls=p}o._bMatchingProcessStarted=false;if(f.callback){f.callback(this,i,f,u,c)}this.fireEvent("matched",g);o.fireRouteMatched(g);if(a){t.info("The route named '"+f.name+"' did match with its pattern",this);this.fireEvent("patternMatched",g);o.fireRoutePatternMatched(g)}return n}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/sync/Target", ["sap/base/Log","sap/ui/core/Element"],function(e,t){"use strict";return{display:function(e){var t;if(this._oParent){t=this._oParent.display(e)}return this._place(t,e)},suspend:function(){return this},resume:function(){return this},_place:function(o,i){var r=this._oOptions;o=o||{};var n,a=o.oTargetControl,d=o.oTargetParent;if(!this._isValid(o,true)){return undefined}if(!d&&r.rootView){d=t.getElementById(r.rootView);if(!d){e.error("Did not find the root view with the id "+r.rootView,this);return undefined}}if(r.controlId){if(d){a=d.byId(r.controlId)}if(!a){a=t.getElementById(r.controlId)}if(!a){e.error("Control with ID "+r.controlId+" could not be found",this);return undefined}}var s=a.getMetadata().getJSONKeys()[r.controlAggregation];if(!s){e.error("Control "+r.controlId+" does not have an aggregation called "+r.controlAggregation,this);return undefined}var l=this._getEffectiveObjectName(r.viewName);var g={name:l,type:r.viewType,id:r.viewId};n=this._oCache._get(g,"View",this._bUseRawViewId);this._beforePlacingViewIntoContainer({container:a,view:n,data:i});this._bindTitleInTitleProvider(n);this._addTitleProviderAsDependent(n);if(r.clearControlAggregation===true){a[s._sRemoveAllMutator]()}e.info("Did place the view '"+l+"' with the id '"+n.getId()+"' into the aggregation '"+r.controlAggregation+"' of a control with the id '"+a.getId()+"'",this);a[s._sMutator](n);this.fireDisplay({view:n,control:a,data:i});return{oTargetParent:n,oTargetControl:a}},_isValid:function(t,o){var i=this._oOptions,r=t&&t.oTargetControl,n=r||i.controlId,a=true,d="";if(!n){d="The target "+i._name+" has no controlId set and no parent so the target cannot be displayed.";a=false}if(!i.controlAggregation){d="The target "+i._name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";a=false}if(!i.viewName){d="The target "+i._name+" no viewName defined.";a=false}if(o&&d){e.error(d,this)}return a}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/sync/TargetCache", ["sap/ui/core/mvc/View"],function(e){"use strict";return{_getObjectWithGlobalId:function(i){function t(){i.viewName=i.name;delete i.name;return e._create(i)}var n,o=i.name,a;this._checkName(o,"View");a=this._oCache.view[o];n=a&&a[i.id];if(n){return n}if(this._oComponent){n=this._oComponent.runAsOwner(t)}else{n=t()}a=this._oCache.view[o];if(!a){a=this._oCache.view[o]={};a[undefined]=n}if(i.id!==undefined){a[i.id]=n}this.fireCreated({object:n,type:"View",options:i});return n},_getViewWithGlobalId:function(e){if(e&&!e.name){e.name=e.viewName}return this._getObjectWithGlobalId(e)}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/routing/sync/Targets", ["sap/base/Log"],function(i){"use strict";return{display:function(i,t,e){this._display(i,t,e)},_display:function(i,t,e){var a=this;this._attachTitleChanged(i,e);if(Array.isArray(i)){i.forEach(function(i){a._displaySingleTarget(i,t)})}else{this._displaySingleTarget(i,t)}return this},_displaySingleTarget:function(t,e){var a=this.getTarget(t);if(a!==undefined){a.display(e)}else{i.error('The target with the name "'+t+'" does not exist!',this)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/search/OpenSearchProvider", ["./SearchProvider","sap/base/Log","sap/base/security/encodeURL","sap/base/util/fetch","sap/ui/thirdparty/jquery","sap/ui/core/library"],function(e,r,t,s,jQuery){"use strict";var a=e.extend("sap.ui.core.search.OpenSearchProvider",{metadata:{library:"sap.ui.core",properties:{suggestUrl:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},suggestType:{type:"string",group:"Misc",defaultValue:"json"}}}});a.prototype.suggest=function(e,a){var i=this.getSuggestUrl();if(!i){return}i=i.replace("{searchTerms}",t(e));var n=this.getSuggestType();var u;if(n&&n.toLowerCase()==="xml"){n="xml";u=function(r){var t=jQuery(r);var s=t.find("Text");var i=[];s.each(function(){i.push(jQuery(this).text())});a(e,i)}}else{n="json";u=function(r){a(e,r[1])}}s(i,{headers:{Accept:s.ContentTypes[n.toUpperCase()]}}).then(function(e){if(e.ok){return e.text().then(function(e){var r;if(n==="json"){r=JSON.parse(e)}else{var t=new DOMParser;r=t.parseFromString(e,"text/xml")}u(r)})}else{throw new Error(e.statusText||e.status)}}).catch(function(e){r.fatal("The following problem occurred: "+e.message)})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/search/SearchProvider", ["sap/ui/core/Element","sap/base/Log","sap/ui/core/library"],function(e,r){"use strict";var a=e.extend("sap.ui.core.search.SearchProvider",{metadata:{abstract:true,library:"sap.ui.core",properties:{icon:{type:"string",group:"Misc",defaultValue:null}}}});a.prototype.suggest=function(e,a){r.warning("sap.ui.core.search.SearchProvider is the abstract base class for all SearchProviders. Do not create instances of this class, but use a concrete sub class instead.")};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/service/Service", ["sap/ui/base/Object","sap/base/assert","sap/base/Log"],function(t,e,i){"use strict";var o=t.extend("sap.ui.core.service.Service",{metadata:{abstract:true,library:"sap.ui.core"},constructor:function(i){t.apply(this);if(i){e(typeof i.scopeObject==="object","The service context requires a scope object!");e(typeof i.scopeType==="string","The service context requires a scope type!")}this._oServiceContext=i;if(typeof this.init==="function"){this.init()}}});o.create=function(t){var e=function e(r){for(var n in t){if(!n.match(/^(metadata|constructor|getContext|destroy)$/)){this[n]=t[n]}else{i.warning("The member "+n+" is not allowed for anonymous service declaration and will be ignored!")}}o.apply(this,arguments)};e.prototype=Object.create(o.prototype);return e};o.prototype.getInterface=function(){var t=Object.create(null);for(var e in this){if(!e.match(/^_|^metadata$|^constructor$|^getInterface$|^destroy$|^init$|^exit$|^getContext$/)&&typeof this[e]==="function"){t[e]=this[e].bind(this)}}this.getInterface=function(){return t};return t};o.prototype.getContext=function(){return this._oServiceContext};o.prototype.destroy=function(){if(typeof this.exit==="function"){this.exit()}t.prototype.destroy.apply(this,arguments);delete this._oServiceContext};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/service/ServiceFactory", ["sap/ui/base/Object","sap/ui/core/service/Service","sap/base/assert"],function(e,r,t){"use strict";var c=e.extend("sap.ui.core.service.ServiceFactory",{metadata:{library:"sap.ui.core"},constructor:function(c){e.apply(this);var o=typeof c==="object"?r.create(c):c;t(!o||o&&typeof o==="function","The service constructor either should be undefined or a constructor function!");this._fnService=o}});c.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);delete this._fnService};c.prototype.createInstance=function(e){if(typeof this._fnService==="function"){return Promise.resolve(new this._fnService(e))}else{return Promise.reject(new Error("Usage of sap.ui.core.service.ServiceFactory requires a service constructor function to create a new service instance or to override the createInstance function!"))}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/service/ServiceFactoryRegistry", ["./ServiceFactory","sap/base/assert"],function(e,t){"use strict";var r=Object.create(null);var n=Object.create(null);n.register=function(n,c){t(n,"sServiceFactoryName must not be empty, null or undefined");t(c instanceof e,"oServiceFactory must be an instance of sap.ui.core.service.ServiceFactory");r[n]=c;return this};n.unregister=function(e){t(e,"sServiceFactoryName must not be empty, null or undefined");delete r[e];return this};n.get=function(e){return r[e]};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/syncStyleClass", ["sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/base/assert"],function(jQuery,e,s){"use strict";var t=function(t,r,a){if(!t){return a}if(e.isObjectA(r,"sap.ui.core.Control")){r=r.$()}else if(typeof r==="string"){r=jQuery(document.getElementById(r))}else if(!(r instanceof jQuery)){s(false,"sap/ui/core/syncStyleClass(): vSource must be a jQuery object or a Control or a string");return a}var o=!!r.closest("."+t).length;if(a instanceof jQuery){a.toggleClass(t,o)}else if(e.isObjectA(a,"sap.ui.core.Control")){a.toggleStyleClass(t,o)}else{s(false,"sap/ui/core/syncStyleClass(): vDestination must be a jQuery object or a Control")}return a};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/theming/Parameters", ["sap/ui/core/Lib","sap/ui/core/Theming","sap/ui/thirdparty/URI","../Element","sap/base/Log","sap/base/util/extend","sap/base/util/syncFetch","sap/ui/core/theming/ThemeManager","./ThemeHelper"],function(e,r,t,a,n,i,s,o,u){"use strict";var c=sap.ui.loader._.getSyncCallBehavior();var f={};var l=null;var m=null;var p=[];var d=[];var h=new t(sap.ui.require.toUrl(""),document.baseURI).origin();var g={};var v=/url[\s]*\('?"?([^\'")]*)'?"?\)/;var y=new URLSearchParams(window.location.search).get("sap-ui-xx-no-inline-theming-parameters")!=="true";function b(e,r){var a=v.exec(e);if(a){var n=new t(a[1]);if(n.is("relative")){var i=n.absoluteTo(r).normalize().toString();e="url('"+i+"')"}}return e}function A(e,r,t){for(var a in r){if(typeof e[a]==="undefined"){e[a]=b(r[a],t)}}return e}function U(e,r){if(typeof e["default"]!=="object"){e={default:e,scopes:{}}}l=l||{};l["default"]=l["default"]||{};l["scopes"]=l["scopes"]||{};A(l["default"],e["default"],r);if(typeof e["scopes"]==="object"){for(var t in e["scopes"]){l["scopes"][t]=l["scopes"][t]||{};A(l["scopes"][t],e["scopes"][t],r)}}}function w(e){document.querySelectorAll("link[id^=sap-ui-theme-]").forEach(function(r){e(r.getAttribute("id"))})}function T(e,r){var t=L(e);var a=u.checkAndRemoveStyle({id:e});if(!a&&!r){n.warning("Parameters have been requested but theme is not applied, yet.","sap.ui.core.theming.Parameters")}if(a&&y){var i=document.getElementById(e);var s=window.getComputedStyle(i).getPropertyValue("background-image");var o=/\(["']?data:text\/plain;utf-8,(.*?)['"]?\)$/i.exec(s);if(o&&o.length>=2){var c=o[1];if(c.charAt(0)!=="{"&&c.charAt(c.length-1)!=="}"){try{c=decodeURIComponent(c)}catch(e){n.warning("[FUTURE FATAL] Could not decode theme parameters URI from "+t.styleSheetUrl)}}try{var f=JSON.parse(c);U(f,t.themeBaseUrl);return true}catch(e){n.warning("[FUTURE FATAL] Could not parse theme parameters from "+t.styleSheetUrl+". Loading library-parameters.json as fallback solution.")}}}return r?a:false}function P(e){var r=L(e);if(!T(e)){var a=r.styleSheetUrl.replace(/\/(?:css_variables|library)([^\/.]*)\.(?:css|less)($|[?#])/,function(e,r,t){return"/library-parameters.json"+(t?t:"")});if(c===2){n.error("[nosync] Loading library-parameters.json ignored",a,"sap.ui.core.theming.Parameters");return}else if(c===1){n.error("[nosync] Loading library-parameters.json with sync XHR",a,"sap.ui.core.theming.Parameters")}var i=new t(r.themeBaseUrl).origin();var s=g[i];var o=[];if(s===undefined){if(a.startsWith(h)){o=[false,true]}else{o=[true,false]}}else{o=[s]}R(a,r.themeBaseUrl,o)}}function L(e){var r=document.getElementById(e);if(!r){n.warning("[FUTURE FATAL] Could not find stylesheet element with ID",e,"sap.ui.core.theming.Parameters");return undefined}var a=r.href;return{themeBaseUrl:new t(a).filename("").query("").toString(),styleSheetUrl:a}}function R(e,r,a){var i={Accept:s.ContentTypes.JSON};var o=a.shift();if(o){i["X-Requested-With"]="XMLHttpRequest"}function u(t){n.error("[FUTURE FATAL] Could not load theme parameters from: "+e,t);if(a.length>0){n.warning("Initial library-parameters.json request failed ('withCredentials="+o+"'; sUrl: '"+e+"').\n"+"Retrying with 'withCredentials="+!o+"'.","sap.ui.core.theming.Parameters");R(e,r,a)}}try{var c=s(e,{credentials:o?"include":"omit",headers:i});if(c.ok){var f=c.json();var l=new t(r).origin();g[l]=o;if(Array.isArray(f)){for(var m=0;m<f.length;m++){var p=f[m];U(p,r)}}else{U(f,r)}}else{throw new Error(c.statusText||c.status)}}catch(e){u(e)}}function E(e){if(!l){U({},"");w(function(r){if(e){if(!T(r,e)){p.push(r)}}else{P(r)}})}return l}function S(){var e=[];p.forEach(function(r){if(!T(r,true)){e.push(r)}});p=e}function j(){p.forEach(P);p=[]}f._addLibraryTheme=function(e){if(l){p.push("sap-ui-theme-"+e)}};function F(r){var t=r.async,a=E(t);if(r.scopeName){a=a["scopes"][r.scopeName]}else{a=a["default"]}var n=a[r.parameterName];if(!n){var i=r.parameterName.indexOf(":");if(i!=-1){var s=r.parameterName.substr(i+1);n=a[s]}}if(r.loadPendingParameters&&typeof n==="undefined"&&!t){var u=e.getAllInstancesRequiringCss();u.forEach(function(e){o._includeLibraryThemeAndEnsureThemeRoot(e)});j();n=F({parameterName:r.parameterName,scopeName:r.scopeName,loadPendingParameters:false})}return n}function I(e,r,t){var a=f.getActiveScopesFor(r,t);var n=a.flat().reduce(function(e,r){if(e.indexOf(r)===-1){e.push(r)}return e},[]);for(var i=0;i<n.length;i++){var s=n[i];var o=F({parameterName:e,scopeName:s,async:t});if(o){return o}}return F({parameterName:e,async:t})}f._getScopes=function(e,r){if(e&&!l){return}var t=E(r);var a=Object.keys(t["scopes"]);return a};f.getActiveScopesFor=function(e,r){var t=[];if(e instanceof a){var n=e.getDomRef();if(r){S()}else{j()}var i=this._getScopes(undefined,r);if(i.length){if(n){var s=function(e){var r=n.classList;return r&&r.contains(e)};while(n){var o=i.filter(s);if(o.length>0){t.push(o)}n=n.parentNode}}else{var u=function(r){return typeof e.hasStyleClass==="function"&&e.hasStyleClass(r)};while(e){var o=i.filter(u);if(o.length>0){t.push(o)}e=typeof e.getParent==="function"&&e.getParent()}}}}return t};f.get=function(e,t){var i,s,u,c,f;var l=function(e){return e.callback===s};if(!m){m=r.getTheme()}if(arguments.length===0){n.warning("Legacy variant usage of sap.ui.core.theming.Parameters.get API detected. Do not use the Parameters.get() API to retrieve ALL theming parameters, "+"as this will lead to unwanted synchronous requests. "+"Use the asynchronous API variant instead and retrieve a fixed set of parameters.","LegacyParametersGet","sap.ui.support",function(){return{type:"LegacyParametersGet"}});j();var p=E();return Object.assign({},p["default"])}if(!e){return undefined}if(e instanceof Object&&!Array.isArray(e)){if(!e.name){n.warning("[FUTURE FATAL] sap.ui.core.theming.Parameters.get was called with an object argument without one or more parameter names.");return undefined}t=e.scopeElement;s=e.callback;c=typeof e.name==="string"?[e.name]:e.name;u=true}if(!(e instanceof Object&&!Array.isArray(e))){if(typeof e==="string"){c=[e]}else{c=e}n.warning("Legacy variant usage of sap.ui.core.theming.Parameters.get API detected for parameter(s): '"+c.join(", ")+"'. This could lead to bad performance and additional synchronous XHRs, as parameters might not be available yet. Use asynchronous variant instead.","LegacyParametersGet","sap.ui.support",function(){return{type:"LegacyParametersGet"}})}var h,g;var v=function(e){if(t instanceof a){return I(e,t,u)}else{if(u){S()}return F({parameterName:e,loadPendingParameters:!u,async:u})}};g={};for(var y=0;y<c.length;y++){i=c[y];var b=v(i);if(!u||b){g[i]=b}}if(u&&s&&Object.keys(g).length!==c.length){if(!o.themeLoaded){h=function(){o._detachThemeApplied(h);var r=this.get({name:e.name,scopeElement:e.scopeElement});if(!r||typeof r==="object"&&Object.keys(r).length!==c.length){n.error("[FUTURE FATAL] One or more parameters could not be found.","sap.ui.core.theming.Parameters")}s(r);d.splice(d.findIndex(l),1)}.bind(this);f=d.findIndex(l);if(f>=0){o._detachThemeApplied(d[f].eventHandler);d[f].eventHandler=h}else{d.push({callback:s,eventHandler:h})}o._attachThemeApplied(h);return undefined}else{n.error("[FUTURE FATAL] One or more parameters could not be found.","sap.ui.core.theming.Parameters")}}return c.length===1?g[c[0]]:g};f._setOrLoadParameters=function(e){l={default:{},scopes:{}};m=r.getTheme();w(function(r){var t=r.substr(13);if(e[t]){i(l["default"],e[t])}else{P(r)}})};f.reset=function(){this._reset.apply(this,arguments)};f._reset=function(){var e=arguments[0]===true;if(!e||r.getTheme()!==m){m=r.getTheme();p=[];l=null}};f._getThemeImage=function(e,r){e=e||"sapUiGlobalLogo";var t=f.get(e);if(t){var a=v.exec(t);if(a){t=a[1]}else if(t==="''"||t==="none"){t=null}}if(r&&!t){return sap.ui.require.toUrl("sap/ui/core/themes/base/img/1x1.gif")}return t};return f},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/theming/ThemeManager", ["sap/base/assert","sap/base/Eventing","sap/base/Log","sap/base/config","sap/base/i18n/Localization","sap/base/util/each","sap/base/util/LoaderExtensions","sap/ui/Device","sap/ui/Global","sap/ui/core/Lib","sap/ui/core/Theming","sap/ui/core/theming/ThemeHelper","sap/ui/dom/includeStylesheet"],function(e,t,r,a,i,s,n,u,o,c,l,m,d){"use strict";const h=new t;var f=150;var p={};var g=/\.sapUiThemeDesignerCustomCss/i;var v=0;var T="sap-ui-core-customcss";var b=false;var y=null;var L=null;var E={};var k;var U={themeLoaded:true,checkThemeApplied:function(){U.reset();S(true);if(!k){U.fireThemeApplied()}},reset:function(){U.themeLoaded=false;if(k){clearTimeout(k);k=null;v=0;L=null;E={}}},_includeLibraryThemeAndEnsureThemeRoot:function(e){var t=e.name;_(t,l.getTheme());_(t,"base");p[t]=e;if(!e.preloadedCss){U.includeLibraryTheme(t,e.variant,e)}},includeLibraryTheme:function(t,s,n){e(typeof t==="string","sLibName must be a string");e(s===undefined||typeof s==="string","sVariant must be a string or undefined");var u=n;if(typeof u==="object"){u=I(n)}if(t!="sap.ui.legacy"&&t!="sap.ui.classic"){var o=a.get({name:"sapUiXxCssVariables",type:a.Type.String,external:true});if(!s){s=""}var c=/^(true|x)$/i.test(o)?"_skeleton":"";var m=i.getRTL()?"-RTL":"";var h,f=t+(s.length>0?"-["+s+"]":s);if(t&&t.indexOf(":")==-1){h="library"+s+c+m}else{h=t.substring(t.indexOf(":")+1)+s;t=t.substring(0,t.indexOf(":"))}var p="sap-ui-theme-"+f;var g="sap-ui-themeskeleton-"+f;var v=/^(true|x|additional)$/i.test(o);if(!document.querySelector("LINK[id='"+p+"']")||v&&!document.querySelector("LINK[id='"+g+"']")){var T=new URL(U._getThemePath(t,l.getTheme()),document.baseURI).toString();var b=document.createElement("link");b.href=T+h+".css"+(u?u:"");var y=b.href;b.href=T+"css_variables.css"+(u?u:"");var L=b.href;x(p);if(v){r.info("Including "+L+" -  sap.ui.core.theming.ThemeManager.includeLibraryTheme()");d(L,p);p="sap-ui-themeskeleton-"+f;x(p)}r.info("Including "+y+" -  sap.ui.core.theming.ThemeManager.includeLibraryTheme()");d(y,p);var E=sap.ui.require("sap/ui/core/theming/Parameters");if(E){E._addLibraryTheme(f)}U.checkThemeApplied()}}},_getThemePath:function(e,t){_(e,t);return sap.ui.require.toUrl((e+".themes."+t).replace(/\./g,"/")+"/")},_updateThemeUrls:function(e,t){var r=document.querySelectorAll("link[id^=sap-ui-theme-],link[id^=sap-ui-themeskeleton-]");Array.prototype.forEach.call(r,function(r){w(r,e,t)})},_attachThemeApplied:function(e){h.attachEvent("applied",e)},_detachThemeApplied:function(e){h.detachEvent("applied",e)},fireThemeApplied:function(){m.reset();var e=sap.ui.require("sap/ui/core/theming/Parameters");if(e){e._reset(true)}h.fireEvent("applied",{theme:l.getTheme()})}};function A(){var e=l.getTheme();var t=U._getThemePath("sap.ui.core",e)+"custom.css";var a=e.indexOf("sap_")===0||e==="base";var i=true;var n=[];if(b&&y===e){p[T]={}}function u(s){var u="sap-ui-theme-"+s;var o=m.checkAndRemoveStyle({prefix:"sap-ui-theme-",id:s});if(o&&document.getElementById("sap-ui-themeskeleton-"+s)){o=m.checkAndRemoveStyle({prefix:"sap-ui-themeskeleton-",id:s})}i=i&&o;if(i){if(!b||y!=e){if(!a&&C(s)){var c=t;var l=I(p["sap.ui.core"]);if(l){c+=l}d(c,T);b=true;r.debug("ThemeManager: delivered custom CSS needs to be loaded, Theme not yet applied");y=e;i=false;return false}else if(b){var h=document.querySelector("LINK[id='"+T+"']");if(h){h.remove();r.debug("ThemeManager: Custom CSS removed")}b=false}}}if(!a&&o&&!E[s]){var f=document.getElementById(u);if(f&&f.getAttribute("data-sap-ui-ready")==="false"&&!(f.sheet&&m.hasSheetCssRules(f.sheet))){n.push(s)}}}s(p,u);if(n.length>0){if(!L){for(var o in p){var c=m.getMetadata(o);if(c&&c.Extends&&c.Extends[0]){L=c.Extends[0];break}}}if(L){n.forEach(function(t){var a="sap-ui-theme-"+t;var i=document.getElementById(a);r.warning("ThemeManager: Custom theme '"+e+"' could not be loaded for library '"+t+"'. "+"Falling back to its base theme '"+L+"'.");w(i,L);E[t]=true});i=false}}if(!i){r.debug("ThemeManager: Theme not yet applied.")}else{y=e}return i}function C(e){var t=window.document.getElementById("sap-ui-theme-"+e);if(!t){return false}var a=window.getComputedStyle(t,":after");var i=a?a.getPropertyValue("content"):null;if(!i&&u.browser.safari){var s=document.documentElement;s.classList.add("sapUiThemeDesignerCustomCss");i=window.getComputedStyle(s,":after").getPropertyValue("content");s.classList.remove("sapUiThemeDesignerCustomCss")}if(i&&i!=="none"){try{if(i[0]==="'"||i[0]==='"'){i=i.substring(1,i.length-1)}return i==="true"}catch(e){r.error("[FUTURE FATAL] Custom check: Error parsing JSON string for custom.css indication.",e)}}var n=t.sheet?m.safeAccessSheetCssRules(t.sheet):null;if(!n||n.length===0){r.warning("Custom check: Failed retrieving a CSS rule from stylesheet "+e);return false}for(var o=0;o<2&&o<n.length;o++){if(g.test(n[o].selectorText)){return true}}return false}function S(e){v++;var t=v>f;if(!A()&&!t){var a;if(v<=100){a=2}else if(v<=110){a=500}else{a=1e3}k=setTimeout(S,a)}else if(!e){U.reset();U.themeLoaded=true;U.fireThemeApplied();if(t){r.error("[FUTURE FATAL] ThemeManager: max. check cycles reached.")}}else{U.themeLoaded=true}}function x(e){var t=document.getElementById(e);if(t){t.dataset.sapUiFoucmarker=e}}function R(e){var t=document.documentElement;var r=e.new;U._updateThemeUrls(r,true);t.classList.remove("sapUiTheme-"+e.old);t.classList.add("sapUiTheme-"+r);U.checkThemeApplied()}function _(e,t){var r=l.getThemeRoot(t,e);if(r){r=r+(r.slice(-1)=="/"?"":"/")+e.replace(/\./g,"/")+"/themes/"+t+"/";n.registerResourcePath((e+".themes."+t).replace(/\./g,"/"),r)}}function w(e,t,r){var a,s=e.href.search(/[?#]/),n,u,o="library",c=i.getRTL()?"-RTL":"",l,m;var h=/^sap-ui-theme(?:skeleton)?-(.*)$/i.exec(e.id);if(Array.isArray(h)){a=h[1]}else{a=e.id.slice(13)}p[a]=p[a]||{};if(s>-1){n=e.href.substring(0,s);u=e.href.substring(s)}else{n=e.href;u=""}n=n.substring(n.lastIndexOf("/")+1);if((m=a.indexOf("-["))>0){o+=a.slice(m+2,-1);a=a.slice(0,m)}if(n===o+".css"||n===o+"-RTL.css"){n=o+c+".css"}l=new URL(U._getThemePath(a,t)+n+u,document.baseURI).toString();if(l!=e.href){if(r){e.dataset.sapUiFoucmarker=e.id}d(l,e.id)}}function I(e){var t;if(c.getVersionedLibCss()&&e){t="?version="+e.version;if(o.versioninfo){t+="&sap-ui-dist-version="+o.versioninfo.version}}return t}document.documentElement.classList.add("sapUiTheme-"+l.getTheme());r.info("Declared theme "+l.getTheme(),null);l.attachChange(function(e){var t=e.themeRoots;var r=e.theme;if(t&&t.forceUpdate){U._updateThemeUrls(l.getTheme())}if(r){R(r)}});l.registerThemeManager(U);return U});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/tmpl/DOMAttribute", ["sap/ui/core/Element","sap/ui/core/library"],function(t){"use strict";var e=t.extend("sap.ui.core.tmpl.DOMAttribute",{metadata:{library:"sap.ui.core",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});e.prototype.setValue=function(t){this.setProperty("value",t,true);var e=this.getParent(),r=e&&e.$();if(r&&r.length>0){r.attr(this.getName(),this.getProperty("value"))}return this};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/tmpl/DOMElement", ["sap/ui/core/Control","./DOMAttribute","./DOMElementRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/library"],function(t,e,i,r,jQuery){"use strict";var a=t.extend("sap.ui.core.tmpl.DOMElement",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},tag:{type:"string",group:"Behavior",defaultValue:"span"}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.core.tmpl.DOMAttribute",multiple:true,singularName:"attribute"},elements:{type:"sap.ui.core.tmpl.DOMElement",multiple:true,singularName:"element"}}},renderer:i});a.prototype.applySettings=function(i){var a=this.getMetadata(),n=a.getJSONKeys();if(i){if(!i["attributes"]){var s=i["attributes"]=[];jQuery.each(i,function(t,r){if(t!=="id"&&!n[t]&&typeof r==="string"){s.push(new e({name:t,value:r}));delete i[t]}})}else{r.warning("DOMElement#"+this.getId()+": custom attributes in settings will be ignored since attributes are provided!")}}t.prototype.applySettings.apply(this,arguments)};a.prototype.exit=a.prototype.onBeforeRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().off("change")}};a.prototype.onAfterRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().on("change",jQuery.proxy(this.oninputchange,this))}};a.prototype.oninputchange=function(t){var e=this.getTag().toLowerCase();if(e==="input"){var i=this.$().val();this.getAttributes().forEach(function(t){if(t.getName().toLowerCase()==="value"){t.setValue(i)}})}else if(e==="textarea"){var r=this.$().val();this.setText(r)}else if(e==="select"){var r="";this.$().find("select option:selected").each(function(){r+=jQuery(this).text()+" "});this.setText(r)}};a.prototype.attr=function(t,i){var r=this.getAttributes().find(function(e){var i=e.getName();return i.toLowerCase()===t});if(i===undefined){return r&&r.getValue()}else{if(r){if(i===null){this.removeAttribute(r)}else{r.setValue(i)}}else{if(i!==null){this.addAttribute(new e({name:t,value:i}))}}return this}};a.prototype.removeAttr=function(t){this.attr(t,null);return this};a.prototype.setText=function(t){this.setProperty("text",t,true);var e=this.$();if(e.length>0){var i=this.getTag().toLowerCase();if(i==="textarea"){e.val(this.getProperty("text"))}else{e.text(this.getProperty("text"))}}return this};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/tmpl/DOMElementRenderer", ["sap/base/Log","sap/base/security/encodeXML"],function(e,t){"use strict";var r={apiVersion:2};var a=/^(?:area|base|br|col|embed|hr|img|input|link|meta|param|source|track|wbr)$/i;r.render=function(r,i){var n=t(i.getTag()),s=a.test(n);if(s){r.voidStart(n,i)}else{r.openStart(n,i)}i.getAttributes().forEach(function(a){var i=a.getName().toLowerCase();if(i==="class"){var n=a.getValue().split(" ");n.forEach(function(e){var e=e.trim();if(e){r.class(e)}})}else if(i==="style"){var s=a.getValue().split(";");s.forEach(function(e){var a=e.indexOf(":");if(a!=-1){var i=e.substring(0,a).trim();var n=e.substring(a+1).trim();r.style(t(i),n)}})}else if(a.getName()){r.attr(t(a.getName()),a.getValue())}else{e.error("Attributes must have a non-empty name")}});if(s){r.voidEnd()}else{r.openEnd()}var o=i.getElements(),f=!!i.getText()||o.length>0;if(f){if(s){e.error("Void element '"+n+"' is rendered with children")}if(i.getText()){r.text(i.getText())}o.forEach(function(e,t){r.renderControl(t)})}if(!s){r.close(n)}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/tmpl/HandlebarsTemplate", ["./Template","./TemplateControl","sap/ui/thirdparty/handlebars","sap/ui/base/ManagedObject","sap/base/util/ObjectPath","sap/base/security/encodeXML","sap/base/util/isEmptyObject","sap/ui/core/Core"],function(e,t,a,r,n,o,i){"use strict";var s=e.extend("sap.ui.core.tmpl.HandlebarsTemplate",{metadata:{library:"sap.ui.core"},constructor:function(t,a){e.apply(this,arguments)}});e.registerType("text/x-handlebars-template","sap.ui.core.tmpl.HandlebarsTemplate");function h(e){for(var t in e){e[t]=e[t].replace("&gt;",">").replace("&lt;","<").replace("&quot;",'"').replace("&amp;","&")}}function l(e,t){var a=/^((\w+)>)?(.*)/,r=a.exec(e),n=r[2],o=a.exec(t),i=o[2];var r=a.exec(e);if(t&&n==i){return t+r[3]}else{return e}}s.RENDER_HELPERS=function(){var e=a.helpers["each"],t=a.helpers["with"],s=a.helpers["if"],p=a.helpers["unless"],g=sap.ui.getCore().createRenderManager();g.renderControl=function(e){this.writeControlData(e);this.writeClasses(e);this.writeStyles(e)};var f={each:function(t,r){r=r||t;if(!r.hash.path){return e.apply(this,arguments)}else{h(r.hash);var n=r.data.renderManager,o=r.data.rootControl,i=r.data.path,s=r.data.parentControl,p=l(r.hash.path,i),g=o.bindList(p),f=[],d;if(r.data){d=a.createFrame(r.data)}if(g){for(var u in g){if(d){d.renderManager=n;d.rootControl=o;d.path=p+"/"+u+"/";d.parentControl=s}f.push(r.fn({},{data:d}))}}if(!s){return new a.SafeString(f.join(""))}}},with:function(e,a){a=a||e;if(!a.hash.path){return t.apply(this,arguments)}},if:function(e,t){t=t||e;if(!t.hash.path){return s.apply(this,arguments)}else{h(t.hash);var a=t.data.rootControl,r=t.data.path,n=l(t.hash.path,r);if(n){var o=a.bindProp(n);if(o){return t.fn(this)}else{return t.inverse(this)}}}},unless:function(e,t){t=t||e;if(!t.hash.path){return p.apply(this,arguments)}else{h(t.hash);var a=t.data.rootControl,r=t.data.path,n=l(t.hash.path,r);if(n){var o=a.bindProp(n);if(!o){return t.fn(this)}else{return t.inverse(this)}}}},text:function(e,t){t=t||e;h(t.hash);var r=t.data.rootControl,n=t.data.path,i=l(t.hash.path,n);if(i){var s=r.bindProp(i);return s&&new a.SafeString(o(s))}else{throw new Error('The expression "text" requires the option "path"!')}},element:function(e,t){t=t||e;h(t.hash);var r=t.data.renderManager,n=t.data.rootControl,o=n.createDOMElement(t.hash,t.data.path),i=t.data.parentElement;if(t.fn){t.fn({},{data:{renderManager:r,rootControl:n,parentElement:o}})}if(i){i.addElement(o);return}return new a.SafeString(r.getHTML(o))},control:function(e,t){t=t||e;h(t.hash);var o=t.data.renderManager,s=t.data.control;if(s){return new a.SafeString(o.getHTML(s))}var l=t.data.rootControl,p=t.data.path,g=t.data.children,f=t.hash["sap-ui-type"],d=n.get(f||""),u=d&&d.getMetadata(),c=t.hash["sap-ui-default-aggregation"]||u&&u.getDefaultAggregationName(),v=t.data.view;if(!d){throw new Error("Control of type "+f+" cannot be found.")}var m={};if(t.fn){t.fn({},{data:{rootControl:l,path:p,children:m,defaultAggregation:c,view:v}})}var C=Object.assign({},t.hash),w;for(var b in C){if(b==="sap-ui-class"&&typeof C[b]==="string"){w=C["sap-ui-class"]&&C["sap-ui-class"].split(" ");delete C[b]}else if(m[b]){delete C[b]}}var y=l.createControl(C,t.data.path,!!g,v);if(w&&w.length>0){w.forEach(y.addStyleClass.bind(y))}if(!i(m)){C=t.hash;var M=u.getAllAggregations();for(var E in m){var S=m[E];for(var T=0,A=S.length;T<A;T++){var x=S[T],j=M[E],H=j&&j.multiple;if(typeof C[E]==="string"){var L=r.bindingParser(C[E],v&&v.getController());L.template=x;y.bindAggregation(E,L)}else{if(H){y.addAggregation(E,x)}else{y.setAggregation(E,x)}}}}}if(g){var E=t.hash["sap-ui-aggregation"]||t.data.defaultAggregation;g[E]=g[E]||[];g[E].push(y);return}return new a.SafeString(o.getHTML(y))},property:function(e,t){t=t||e;h(t.hash);var a=t.data.rootControl,r=a.getMetadata(),n=t.hash.name,o=r.getProperty(n)._sGetter;return a[o]()},aggregation:function(e,t){t=t||e;h(t.hash);if(t.data.children){var r=t.hash.name;if(t.fn){var n=Object.assign({},t.data,{defaultAggregation:r});t.fn({},{data:n})}}else{var o=t.data.renderManager,i=t.data.rootControl,s=i.getMetadata(),r=t.hash.name,l=s.getAggregation(r)._sGetter,p=[];var g=i[l]();if(g){for(var f=0,d=g.length;f<d;f++){if(t.fn){p.push(t.fn({},{data:{renderManager:o,rootControl:i,control:g[f]}}))}else{p.push(o.getHTML(g[f]))}}}return new a.SafeString(p.join(""))}},event:function(e,t){t=t||e},controlData:function(e,t){t=t||e;var r=t.data.rootControl;return new a.SafeString(g.getHTML(r))}};return f}();s.prototype.createMetadata=function(){var e=this.getContent(),r=this._fnTemplate=this._fnTemplate||a.compile(e);var n={},o=t.getMetadata().getAllSettings(),i=t.getMetadata().getAllPrivateAggregations();var s={property:function(e,t){t=t||e;h(t.hash);var a=t.hash.name;if(a&&a!=="id"&&!o[a]){n.properties=n.properties||{};n.properties[a]=Object.assign({},{type:"string"},t.hash)}else{throw new Error('The property name "'+a+'" is reserved.')}},aggregation:function(e,t){t=t||e;h(t.hash);var a=t.hash.name;if(a&&!o[a]&&!i[a]){t.hash.multiple=t.hash.multiple=="true";n.aggregations=n.aggregations||{};n.aggregations[a]=Object.assign({},t.hash)}else{throw new Error('The aggregation name "'+a+'" is reserved.')}},event:function(e,t){t=t||e},controlData:function(e,t){t=t||e;n._hasControlData=true}};["each","if","unless","with"].forEach(function(e){s[e]=function(){}});r({},{helpers:s});return n};s.prototype.createRenderer=function(e){var t=this.getContent(),r=this._fnTemplate=this._fnTemplate||a.compile(t);var n=function(t,a){var n=r(a.getContext()||{},{data:{renderManager:t,rootControl:a,view:e},helpers:s.RENDER_HELPERS});t.write(n)};return n};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/tmpl/Template", ["sap/ui/base/ManagedObject","sap/ui/base/BindingInfo","sap/ui/base/BindingParser","sap/ui/core/Control","sap/ui/core/RenderManager","sap/base/util/ObjectPath","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery","sap/ui/core/tmpl/TemplateControl","./_parsePath"],function(e,t,r,a,n,i,o,s,jQuery,p,c){"use strict";var l=e.extend("sap.ui.core.tmpl.Template",{constructor:function(t,r){e.apply(this,arguments)},metadata:{stereotype:"template",abstract:true,library:"sap.ui.core",properties:{content:{type:"string",group:"Data",defaultValue:null}},publicMethods:["declareControl","createControl","placeAt","createMetadata","createRenderer"]}});var u={};l.prototype.register=function(){var e=this.getId(),t=u[e],r;if(t&&this!==t){r="adding template with duplicate id '"+e+"'";o.error(r);throw new Error("Error: "+r)}u[e]=this};l.prototype.deregister=function(){delete u[this.getId()]};l.byId=function(e){return u[e]};l.prototype.getInterface=function(){return this};l._mSupportedTypes={};l.registerType=function(e,t){l._mSupportedTypes[e]=t};l.unregisterType=function(e){delete l._mSupportedTypes[e]};l.parsePath=c;l.prototype.init=function(e,n){if(this.getMetadata().getName()==="sap.ui.core.tmpl.Template"){throw new Error("The class 'sap.ui.core.tmpl.Template' is abstract and must not be instantiated!")}if(t.parse===r.complexParser){l.prototype.extractBindingInfo=function(e,n,i){t.parse=r.simpleParser;var o=a.prototype.extractBindingInfo.apply(this,arguments);t.parse=r.complexParser;return o}}};l.prototype.declareControl=function(e){s(!!e,"A fully qualified name must be specified!");if(e){var t=this.createMetadata(),r=this.createRenderer(),a=this;p.extend(e,{metadata:t,init:function(){p.prototype.init.apply(this,arguments);this.setTemplate(a)},renderer:{renderTemplate:r,hasControlData:t._hasControlData}});return i.get(e||"")}};l.prototype.createControl=function(e,t,r){var a=new p({id:e,template:this,context:t});a.setTemplateRenderer(this.createRenderer(r));return a};l.prototype.placeAt=function(e,t,r,i){if(typeof t==="string"||typeof t==="number"){r=t;t=undefined}var o;if(!(e instanceof a)&&i){var s=typeof e==="string"?jQuery(document.getElementById(e)):jQuery(e);if(s.length>0){o=s.attr("id");e=s.get(0);var p=s.attr("data-context");t=t||p&&JSON.parse(p);n.markInlineTemplate(s)}}var c=this.createControl(o,t);c.placeAt(e,r);return c};l.prototype.createMetadata=function(){o.error("The function createMetadata is an abstract function which needs to be implemented by subclasses.")};l.prototype.createRenderer=function(){o.error("The function createRenderer is an abstract function which needs to be implemented by subclasses.")};sap.ui.template=function(e){var t=function(e){o.warning("The usage of Template Views is deprecated since 1.56. Please make use of the asynchronous create functions of the different view classes, e.g. XMLView.create()","Deprecation",null,function(){return{type:"sap.ui.template",name:e}})};if(!e){var r=[];jQuery.each(l._mSupportedTypes,function(e,t){jQuery("script[type='"+e+"'], [data-type='"+e+"']").each(function(a,n){r.push(sap.ui.template({id:n.id,domref:n,type:e,_class:t}))})});return r}else{if(typeof e==="string"){return sap.ui.template({id:e})}else if(e&&e.tagName&&e.nodeName&&e.ownerDocument&&e.nodeType===1){return sap.ui.template({id:e.id,domref:e})}e=jQuery.extend({type:l.DEFAULT_TEMPLATE},e);t(e.id);var a,n,s,p,c=false,u=typeof e.src==="string",d=false;if(u){jQuery.ajax({url:e.src,dataType:"text",async:false,success:function(t){a=e.id;n=e.type;s=e.control;p=t;var r=/^<!--\sUI5:Template\stype=([a-z\/\-]*)\s(?:controller=([A-Za-z.]*)\s)?-->/,i=p.match(r);if(i){n=i[1];if(i.length==3){c=i[2]}p=p.substr(i[0].length)}},error:function(){throw new Error("The template could not be loaded from "+e.src+"!")}})}else{var f=e.domref||(e.id?window.document.getElementById(e.id):null),m=jQuery(f);d=false;a=e.id||f&&f.id;n=m.attr("type")||e.type;s=m.attr("data-control")||e.control;if(a){var h=sap.ui.getCore().getTemplate(a);if(!h instanceof l){throw new Error('Object for id "'+a+'" is no sap.ui.core.tmpl.Template!')}else{if(h){return h}}}if(m.length===0){throw new Error('DOM element for the Template with the id "'+a+'" not found!')}p=m.html();var y=f.tagName.toLowerCase();if(y!=="script"){d=m.parents("body").length===1}}var g=e._class;if(!g){g=l._mSupportedTypes[n];if(!g){throw new Error('The type "'+n+'" is not supported.')}}var T=sap.ui.requireSync(g.replace(/\./g,"/"));T=T||i.get(g||"");var b=new T({id:a,content:p});if(s){b.declareControl(s)}if(c){b._sControllerName=c}if(d){b.placeAt(a,e.context,undefined,true)}return b}};l.DEFAULT_TEMPLATE="text/x-handlebars-template";l.registerType(l.DEFAULT_TEMPLATE,"sap.ui.core.tmpl.HandlebarsTemplate");return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/tmpl/TemplateControl", ["sap/ui/core/Control","sap/ui/core/DeclarativeSupport","sap/ui/core/Element","sap/ui/core/UIArea","./DOMElement","./TemplateControlRenderer","./_parsePath","sap/base/strings/capitalize","sap/base/strings/hyphenate","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/library"],function(t,e,n,i,r,o,a,p,s,l,jQuery){"use strict";var c=t.extend("sap.ui.core.tmpl.TemplateControl",{metadata:{library:"sap.ui.core",properties:{context:{type:"object",group:"Data",defaultValue:null}},aggregations:{controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},associations:{template:{type:"sap.ui.core.tmpl.Template",multiple:false}},events:{afterRendering:{},beforeRendering:{}}},renderer:o});c.prototype.init=function(){this._aBindingInfos=[]};c.prototype.isInline=function(){var t=false,e=this.getParent();if(e instanceof i&&jQuery(e.getRootNode()).attr("id")===this.getId()){t=true}return t};c.prototype.placeAt=function(e,n){var i=this.isInline();var r=this.$(),o=this.getUIArea();t.prototype.placeAt.apply(this,arguments);if(i&&r.length===1){r.remove();o.destroyContent()}};c.prototype.getTemplateRenderer=function(){return this.fnRenderer};c.prototype.setTemplateRenderer=function(t){this.fnRenderer=t;return this};c.prototype._cleanup=function(){this.destroyAggregation("controls");this._aBindingInfos.forEach(function(t){var e=t.binding;if(e){e.detachChange(t.changeHandler);e.destroy()}});this._aBindingInfos=[]};c.prototype._compile=function(){var t=n.getElementById(this.getTemplate()),i=t&&t.getDeclarativeSupport();if(i){var r=this;setTimeout(function(){e.compile(r.getDomRef())})}};c.prototype.exit=function(){this._cleanup()};c.prototype.onBeforeRendering=function(){this.fireBeforeRendering();this._cleanup()};c.prototype.onAfterRendering=function(){this.fireAfterRendering()};c.prototype.clone=function(){var e=t.prototype.clone.apply(this,arguments);e.fnRenderer=this.fnRenderer;return e};c.prototype.updateBindings=function(e,n){t.prototype.updateBindings.apply(this,arguments);if(this.getDomRef()){this.invalidate()}};c.prototype.bind=function(t,e){var n=a(t),i=this.getModel(n.model),t=n.path,r=e?"bind"+p(e):"bindProperty",o=i&&i[r](t),s={binding:o,path:n.path,model:n.model};if(o){s.changeHandler=function(){l.debug("TemplateControl#"+this.getId()+": "+e+' binding changed for path "'+t+'"');this.invalidate()}.bind(this);o.attachChange(s.changeHandler)}this._aBindingInfos.push(s);return o};c.prototype.calculatePath=function(t,e){var n=this.getBindingContext(),i=n&&n.getPath();if(t&&i&&!t.startsWith("/")){if(!i.endsWith("/")){i+="/"}t=i+t}return t};c.prototype.bindProp=function(t){var e=this.bind(this.calculatePath(t),"property");return e&&e.getExternalValue()};c.prototype.bindList=function(t){var e=this.bind(this.calculatePath(t),"list"),n=e&&e.getModel(),t=e&&e.getPath();return e&&n.getProperty(t)};c.prototype.createDOMElement=function(t,e,n){var i=new r(t);if(e){i.bindObject(e)}if(!n){this.addAggregation("controls",i)}return i};c.prototype.createControl=function(t,n,i,r){var o={};jQuery.each(t,function(t,e){o["data-"+s(t)]=e});var a=jQuery("<div></div>",o);var p=e._createControl(a.get(0),r);if(n){p.bindObject(n)}if(!i){this.addAggregation("controls",p)}return p};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/tmpl/TemplateControlRenderer", function(){"use strict";var e={apiVersion:1};e.render=function(e,i){var n=i.isInline()||this.hasControlData;if(!n){e.openStart("div",i).openEnd()}var r=this.renderTemplate||i.getTemplateRenderer();if(r){r.apply(this,arguments)}if(!n){e.close("div")}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/tmpl/_parsePath", [],function(){"use strict";return function(t){var n,r=t.indexOf(">");if(r>0){n=t.substr(0,r);t=t.substr(r+1)}return{path:t,model:n}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/AsyncHintsHelper", [],function(){"use strict";var r={};r.modifyUrls=function(r,u){function e(r,u){if(u===undefined){delete r.url}}[r.components,r.libs].forEach(function(r){if(Array.isArray(r)){r.forEach(function(r){if(typeof r!=="object"){return}if(typeof r.url==="string"){r.url=u(r.url);e(r,r.url)}else if(typeof r.url==="object"&&typeof r.url.url==="string"){r.url.url=u(r.url.url);e(r,r.url.url)}})}});return r};return r});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/DraftEnabledMockServer", ["sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject"],function(jQuery,t){"use strict";return{_oDraftMetadata:{},_oConstants:{COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT:"com.sap.vocabularies.Common.v1.DraftRoot",COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE:"com.sap.vocabularies.Common.v1.DraftNode",COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY:"com.sap.vocabularies.Common.v1.SemanticKey",EMPTY_GUID:"00000000-0000-0000-0000-000000000000",SIBLINGENTITY_NAVIGATION:"SiblingEntity",DRAFT_ADMINISTRATIVE_DATA:"DraftAdministrativeData",DRAFT_ADMINISTRATIVE_DATA_UUID:"DraftAdministrativeDataUUID",ACTIVATION_ACTION:"ActivationAction",EDIT_ACTION:"EditAction",VALIDATE_ACTION:"ValidationFunction",PREPARE_ACTION:"PreparationAction"},handleDraft:function(t,a){var e=sap.ui.require("sap/ui/core/util/MockServer");var r=e._syncAjax;var o=function(t){var a=t.getParameter("oEntity");a.IsActiveEntity=false;a.HasActiveEntity=false;a.HasDraftEntity=false};var i=function(t){var a=t.getParameter("oXhr");var e=r({url:a.url,dataType:"json"}).data.d;for(var o=0;o<this._oDraftMetadata.draftNodes.length;o++){for(var i in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[i].to.entitySet===this._oDraftMetadata.draftNodes[o]){var s=r({url:e[i].__deferred.uri,dataType:"json"});if(s.data&&s.data.d&&s.data.d.results){var n;for(var f=0;f<s.data.d.results.length;f++){n=s.data.d.results[f];r({url:n.__metadata.uri,type:"DELETE"})}}}}}};if(t&&t.EntityContainer){var s=t.EntityContainer[Object.keys(t.EntityContainer)[0]];for(var n in s){var f=s[n];if(f[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT]){this._oDraftMetadata.draftRootName=n;this._oDraftMetadata.annotations=t;this._oDraftMetadata.mockServerRootUri=a.getRootUri();if(f[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION]){this._oDraftMetadata.draftRootActivationName=f[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION].String}if(this._oDraftMetadata.draftRootActivationName){this._oDraftMetadata.draftRootActivationName=this._oDraftMetadata.draftRootActivationName.substring(this._oDraftMetadata.draftRootActivationName.lastIndexOf("/")+1)}this._oDraftMetadata.draftRootEditName=f[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.EDIT_ACTION];this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName?this._oDraftMetadata.draftRootEditName.String:undefined;if(this._oDraftMetadata.draftRootEditName){this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName.substring(this._oDraftMetadata.draftRootEditName.lastIndexOf("/")+1)}this._oDraftMetadata.draftRootValidationName=f[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.VALIDATE_ACTION];this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName?this._oDraftMetadata.draftRootValidationName.String:undefined;if(this._oDraftMetadata.draftRootValidationName){this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName.substring(this._oDraftMetadata.draftRootValidationName.lastIndexOf("/")+1)}this._oDraftMetadata.draftRootPreparationtionName=f[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.PREPARE_ACTION];this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName?this._oDraftMetadata.draftRootPreparationtionName.String:undefined;if(this._oDraftMetadata.draftRootPreparationtionName){this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName.substring(this._oDraftMetadata.draftRootPreparationtionName.lastIndexOf("/")+1)}jQuery.extend(a,this);a.attachAfter(e.HTTPMETHOD.POST,o,this._oDraftMetadata.draftRootName);a.attachBefore(e.HTTPMETHOD.DELETE,i,this._oDraftMetadata.draftRootName);a.attachAfter(e.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftRootName)}}}},_calcSemanticKeys:function(t,a){var e=[];for(var r in this._oDraftMetadata.annotations){if(r.lastIndexOf(a[t].type)>-1){e=this._oDraftMetadata.annotations[r][this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY]||[];break}}var o=[];var i;for(var s=0;s<e.length;s++){i=e[s];for(var n in i){o.push(i[n])}}return o},_prepareDraftMetadata:function(t){var a=this;var e=sap.ui.require("sap/ui/core/util/MockServer");this._oDraftMetadata.draftNodes=[];this._oDraftMetadata.draftRootKey=t[this._oDraftMetadata.draftRootName].keys.filter(function(e){return a._calcSemanticKeys(a._oDraftMetadata.draftRootName,t).indexOf(e)<0})[0];var r=a._oDraftMetadata.annotations;var o=r.EntityContainer[Object.keys(r.EntityContainer)[0]];for(var i in o){var s=o[i];if(s[a._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE]){this._oDraftMetadata.draftNodes.push(i)}}for(var n=0;n<this._oDraftMetadata.draftNodes.length;n++){this.attachAfter(e.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftNodes[n])}},_fnDraftAdministrativeData:function(a){var e={};var r=a.getParameter("oFilteredData");if(!r){e=a.getParameter("oEntry");if(e.IsActiveEntity&&!e.HasDraftEntity){e[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null}}else{if(r.results){r=r.results}else{if(t(r)){r=null;return}}for(var o=0;o<r.length;o++){e=r[o];if(e.IsActiveEntity&&!e.HasDraftEntity){e[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null}}}},_handleDraftArtifacts:function(t){var a=this;var e=this._oMockdata;var r=e[this._oDraftMetadata.draftRootName];var o=function(t,a){return t.filter(function(t){return a.indexOf(t)<0})[0]};if(r.length===100){for(var i=0;i<r.length;i++){var s=r[i];if(i<25){s.IsActiveEntity=true;s.HasActiveEntity=false;s.HasDraftEntity=false;s[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(s[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){s[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null}var n=[];var f=[];for(var d=0;d<this._oDraftMetadata.draftNodes.length;d++){f=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[d],t);n=e[this._oDraftMetadata.draftNodes[d]];var _=t[this._oDraftMetadata.draftRootName];for(var D in _.navprops){var h=_.navprops[D];if(h.to.entitySet===this._oDraftMetadata.draftNodes[d]){var v=h.from.propRef.length;for(var u=0;u<v;u++){n[i][h.to.propRef[u]]=s[h.from.propRef[u]]}}}n[i].IsActiveEntity=true;n[i].HasActiveEntity=false;n[i].HasDraftEntity=false;n[i][this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(n[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){n[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null}var M=o(t[this._oDraftMetadata.draftNodes[d]].keys,f);n[i][M]=this._oConstants.EMPTY_GUID}}else if(i<50){s.IsActiveEntity=false;s.HasActiveEntity=false;s.HasDraftEntity=false;n=[];f=[];for(var d=0;d<this._oDraftMetadata.draftNodes.length;d++){f=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[d],t);n=e[this._oDraftMetadata.draftNodes[d]];var _=t[this._oDraftMetadata.draftRootName];for(var D in _.navprops){var h=_.navprops[D];if(h.to.entitySet===this._oDraftMetadata.draftNodes[d]){var v=h.from.propRef.length;for(var u=0;u<v;u++){n[i][h.to.propRef[u]]=s[h.from.propRef[u]]}}}n[i].IsActiveEntity=false;n[i].HasActiveEntity=false;n[i].HasDraftEntity=false;M=o(t[this._oDraftMetadata.draftNodes[d]].keys,f)}}else if(i<75){var A=jQuery.extend(true,{},s);s.IsActiveEntity=true;s.HasActiveEntity=false;s.HasDraftEntity=true;s[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;n=[];f=[];for(var d=0;d<this._oDraftMetadata.draftNodes.length;d++){f=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[d],t);n=e[this._oDraftMetadata.draftNodes[d]];var _=t[this._oDraftMetadata.draftRootName];for(var D in _.navprops){var h=_.navprops[D];if(h.to.entitySet===this._oDraftMetadata.draftNodes[d]){var v=h.from.propRef.length;for(var u=0;u<v;u++){n[i][h.to.propRef[u]]=s[h.from.propRef[u]]}}}n[i].IsActiveEntity=true;n[i].HasActiveEntity=false;n[i].HasDraftEntity=true;M=o(t[this._oDraftMetadata.draftNodes[d]].keys,f);n[i][M]=this._oConstants.EMPTY_GUID}A.IsActiveEntity=false;A.HasActiveEntity=true;A.HasDraftEntity=false;r[i+25]=A}}}var p=this._getRootUri();jQuery.each(t,function(t,r){jQuery.each(e[t],function(e,o){o.__metadata=o.__metadata||{};o.__metadata.uri=p+t+"("+a._createKeysString(r,o)+")";o.__metadata.type=r.schema+"."+r.type;jQuery.each(r.navprops,function(e){o[e]={__deferred:{uri:p+t+"("+a._createKeysString(r,o)+")/"+e}}})})})},_activate:function(t){var a=sap.ui.require("sap/ui/core/util/MockServer");var e=a._syncAjax;var r;var o=function(t,a){return t.filter(function(t){return a.indexOf(t)<0})[0]};for(var i=0;i<this._oDraftMetadata.draftNodes.length;i++){for(var s in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[s].to.entitySet===this._oDraftMetadata.draftNodes[i]){r=e({url:t[s].__deferred.uri,dataType:"json"});if(r.success&&r.data&&r.data.d&&r.data.d.results){var n;for(var f=0;f<r.data.d.results.length;f++){n=r.data.d.results[f];n.IsActiveEntity=true;n.HasActiveEntity=false;n.HasDraftEntity=false;n[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;var d=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[i],this._mEntitySets);var _=o(this._mEntitySets[this._oDraftMetadata.draftNodes[i]].keys,d);n[_]=this._oConstants.EMPTY_GUID;e({url:n.__metadata.uri,type:"PATCH",data:JSON.stringify(n)})}}}}}t.IsActiveEntity=true;t.HasActiveEntity=false;t.HasDraftEntity=false;t[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;e({url:t.__metadata.uri,type:"PATCH",data:JSON.stringify(t)});return t},setRequests:function(a){var e=this;var r=sap.ui.require("sap/ui/core/util/MockServer");var o=r._syncAjax;a.push({method:"POST",path:new RegExp(e._oDraftMetadata.draftRootActivationName),response:function(t){var a=JSON.parse(t.requestBody);var r=[];for(var i in a){r.push(i+" eq "+a[i])}var s=o({url:e._oDraftMetadata.mockServerRootUri+e._oDraftMetadata.draftRootName+"?$filter="+r.join(" and "),dataType:"json"});if(!s.success||!s.data.d.results[0]){t.respond(404)}var n=s.data.d.results[0];if(n.IsActiveEntity){t.respond(400)}if(n.HasActiveEntity){var f=n.SiblingEntity.__deferred.uri;s=o({url:f,dataType:"json"});if(s.success&&s.data&&s.data.d.__metadata){var d=s.data.d;s=o({url:d.__metadata.uri,type:"DELETE"})}}n=e._activate(n);t.respondJSON(200,{},JSON.stringify({d:n}));return true}});if(e._oDraftMetadata.draftRootEditName){a.push({method:"POST",path:new RegExp(e._oDraftMetadata.draftRootEditName+"(\\?(.*))?"),response:function(a,r){var i=[];var s=JSON.parse(a.requestBody);if(s&&!t(s)){for(var n in s){i.push(n+" eq "+s[n])}}else{var f=decodeURIComponent(r).replace("?","&").split("&");for(var d in f){var _=f[d];var D=new RegExp("(.*)=(.*)");var h;if(_){h=D.exec(_);i.push(h[1]+" eq "+h[2])}}}var v=o({url:e._oDraftMetadata.mockServerRootUri+e._oDraftMetadata.draftRootName+"?$filter="+i.join(" and "),dataType:"json"});if(!v.success||!v.data.d.results[0]){a.respond(404)}var u=v.data.d.results[0];if(!u.IsActiveEntity||u.HasDraftEntity){a.respond(400)}var M=jQuery.extend(true,{},u);M.IsActiveEntity=false;M.HasActiveEntity=true;M.HasDraftEntity=false;M[e._oDraftMetadata.draftRootKey]=e._generatePropertyValue(e._oDraftMetadata.draftRootKey,"Guid");var A=e._getRootUri();var p=e._mEntitySets[e._oDraftMetadata.draftRootName];M.__metadata=M.__metadata||{};M.__metadata.uri=A+e._oDraftMetadata.draftRootName+"("+e._createKeysString(p,M)+")";M.__metadata.type=p.schema+"."+p.type;jQuery.each(p.navprops,function(t){M[t]={__deferred:{uri:A+e._oDraftMetadata.draftRootName+"("+e._createKeysString(p,M)+")/"+t}}});e._oMockdata[e._oDraftMetadata.draftRootName].push(M);v=o({url:u.__metadata.uri,type:"PATCH",data:JSON.stringify({HasDraftEntity:true})});a.respondJSON(200,{},JSON.stringify({d:M}));return true}})}if(e._oDraftMetadata.draftRootValidationName){a.push({method:"GET",path:new RegExp(e._oDraftMetadata.draftRootValidationName+"(\\?(.*))?"),response:function(t,a){var o=e._oDraftMetadata.draftRootValidationName;e.fireEvent(r.HTTPMETHOD.GET+o+":before",{oXhr:t,sUrlParams:a});e.fireEvent(r.HTTPMETHOD.GET+":before",{oXhr:t,sUrlParams:a});var i={d:{}};i.d[o]={__metadata:{type:"ValidationResult"},IsValid:true};e.fireEvent(r.HTTPMETHOD.GET+o+":after",{oXhr:t,oResult:i});e.fireEvent(r.HTTPMETHOD.GET+":after",{oXhr:t,oResult:i});t.respondJSON(200,{},JSON.stringify(i));return true}})}if(e._oDraftMetadata.draftRootPreparationtionName){a.push({method:"POST",path:new RegExp(e._oDraftMetadata.draftRootPreparationtionName),response:function(t){e.fireEvent(r.HTTPMETHOD.POST+e._oDraftMetadata.draftRootPreparationtionName+":before",{oXhr:t});e.fireEvent(r.HTTPMETHOD.POST+":before",{oXhr:t});var a=JSON.parse(t.requestBody);var i=[];for(var s in a){i.push(s+" eq "+a[s])}var n=o({url:e._oDraftMetadata.mockServerRootUri+e._oDraftMetadata.draftRootName+"?$filter="+i.join(" and "),dataType:"json"});if(!n.success||!n.data.d.results[0]){t.respond(404)}var f=n.data.d.results[0];e.fireEvent(r.HTTPMETHOD.POST+e._oDraftMetadata.draftRootPreparationtionName+":after",{oXhr:t,oEntry:f});e.fireEvent(r.HTTPMETHOD.POST+":after",{oXhr:t,oEntry:f});t.respondJSON(200,{},JSON.stringify({d:f}));return true}})}r.prototype.setRequests.apply(this,[a])},_generateMockdata:function(t,a){var e=sap.ui.require("sap/ui/core/util/MockServer");e.prototype._generateMockdata.apply(this,[t,a]);this._handleDraftArtifacts(t)},_loadMockdata:function(t,a){var e=sap.ui.require("sap/ui/core/util/MockServer");e.prototype._loadMockdata.apply(this,[t,a]);this._handleDraftArtifacts(t)},_resolveNavigation:function(t,a,e,r){var o=sap.ui.require("sap/ui/core/util/MockServer");var i=o.prototype._resolveNavigation.apply(this,[t,a,e,r]);if(e===this._oConstants.SIBLINGENTITY_NAVIGATION){if(r&&r.IsActiveEntity){i.splice(0,1)}else{i.length>1?i.splice(1,1):i.splice(0,1)}}else if(e===this._oConstants.DRAFT_ADMINISTRATIVE_DATA){if(r){if(r.IsActiveEntity&&!r.HasDraftEntity){i[0]=null}}else{i[0]=null}}return i},_findEntitySets:function(t){var a=sap.ui.require("sap/ui/core/util/MockServer");var e=a.prototype._findEntitySets.apply(this,[t]);this._prepareDraftMetadata(e);return e},getEntitySetData:function(t){var a=sap.ui.require("sap/ui/core/util/MockServer");var e=a.prototype.getEntitySetData.apply(this,[t]);var r=function(){return e};if(t===this._oDraftMetadata.draftRootName){this._fnDraftAdministrativeData({getParameter:r});return e}for(var o=0;o<this._oDraftMetadata.draftNodes.length;o++){if(t===this._oDraftMetadata.draftNodes[o]){this._fnDraftAdministrativeData({getParameter:r});return e}}return e}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/Export", ["sap/ui/core/Control","./ExportRow","./File","sap/base/Log","./ExportColumn","./ExportType"],function(e,t,r,n){"use strict";function i(e,t){if(e){return function(){return e.apply(t,arguments)}}else{return e}}function o(e){n.warning("Usage of deprecated jQuery Promise method: '"+e+"'. "+"Please use the standard Promise methods 'then' / 'catch' instead!","","sap.ui.core.util.Export")}function s(e,t){var r=new Promise(e);t=t||r;var n=false,s=false;r.then(function(e){n=true;return e},function(e){s=true;throw e});var a={then:r.then,catch:r["catch"]};function l(e){e.then=function(r,n){var o=[i(r,t),i(n,t)];return l(a.then.apply(e,o),t)};e["catch"]=function(r){var n=[i(r,t)];return l(a["catch"].apply(e,n),t)};[{jq:"done",es6:"then"},{jq:"fail",es6:"catch"},{jq:"always",es6:"then"}].forEach(function(r){e[r.jq]=function(){o(r.jq);var n=null;Array.prototype.concat.apply([],arguments).forEach(function(o){var s=i(o,t);var l=function(e){s.apply(this,arguments);return e};var p=[l];if(r.jq==="always"){p.push(l)}if(!n){n=a[r.es6].apply(e,p)}else{n=n[r.es6].apply(n,p)}});return l(n,t)}});e.pipe=function(t,r){o("pipe");return e.then(t,r)};e.state=function(){o("state");if(n){return"resolved"}else if(s){return"rejected"}else{return"pending"}};return e}return l(r)}var a=e.extend("sap.ui.core.util.Export",{metadata:{publicMethods:["generate","saveFile"],library:"sap.ui.core",aggregations:{exportType:{type:"sap.ui.core.util.ExportType",multiple:false},columns:{type:"sap.ui.core.util.ExportColumn",multiple:true,bindable:"bindable"},rows:{type:"sap.ui.core.util.ExportRow",multiple:true,bindable:"bindable"},_template:{type:"sap.ui.core.util.ExportRow",multiple:false,visibility:"hidden"}}},renderer:null});a.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;a.prototype.init=function(){this._oPromise=null;this._fnResolvePromise=null;this._oRowBindingArgs=null};a.prototype.exit=function(){delete this._oPromise;delete this._fnResolvePromise;delete this._oRowBindingArgs};a.prototype._createRowTemplate=function(){var e=new t(this.getId()+"-row"),r=this.getColumns();for(var n=0,i=r.length;n<i;n++){var o=r[n].getTemplate();if(o){e.addCell(o.clone("col"+n))}}return e};a.prototype.bindAggregation=function(t,r){if(t==="rows"){this._oRowBindingArgs=arguments;return this}return e.prototype.bindAggregation.apply(this,arguments)};a.prototype.updateRows=function(e){if(e==="change"&&this._fnResolvePromise){var t=this.getExportType()._generate(this);this.destroyAggregation("_template");this.unbindAggregation("rows");this._fnResolvePromise(t);this._oPromise=null;this._fnResolvePromise=null}};a.prototype.generate=function(){var t=this;if(!this._oPromise){this._oPromise=s(function(r,n){t._fnResolvePromise=r;if(!t.hasModel()){n("Generate is not possible beause no model was set.")}else{var i=t._createRowTemplate();t.setAggregation("_template",i,true);e.prototype.bindAggregation.apply(t,t._oRowBindingArgs);if(t.getBinding("rows")){t.getBinding("rows").getContexts(0,t.getBinding("rows").getLength())}}},this)}return this._oPromise};a.prototype.saveFile=function(e){return this.generate().then(function(t){var n=this.getExportType();r.save(t,e||"data",n.getFileExtension(),n.getMimeType(),n.getCharset(),n.getByteOrderMark())})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/ExportCell", ["sap/ui/core/Element"],function(e){"use strict";var t=e.extend("sap.ui.core.util.ExportCell",{metadata:{library:"sap.ui.core",properties:{content:"string"}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/ExportColumn", ["sap/ui/base/ManagedObject","./ExportCell"],function(e){"use strict";var t=e.extend("sap.ui.core.util.ExportColumn",{metadata:{library:"sap.ui.core",properties:{name:"string"},aggregations:{template:{type:"sap.ui.core.util.ExportCell",multiple:false}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/ExportRow", ["sap/ui/base/ManagedObject","./ExportCell"],function(e){"use strict";var t=e.extend("sap.ui.core.util.ExportRow",{metadata:{library:"sap.ui.core",aggregations:{cells:{type:"sap.ui.core.util.ExportCell",multiple:true}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/ExportType", ["sap/ui/base/ManagedObject"],function(e){"use strict";var t=e.extend("sap.ui.core.util.ExportType",{metadata:{library:"sap.ui.core",properties:{fileExtension:"string",mimeType:"string",charset:"string",byteOrderMark:{type:"boolean",defaultValue:undefined}}}});t.prototype.init=function(){this._oExport=null};t.prototype._generate=function(e){this._oExport=e;var t=this.generate();this._oExport=null;return t};t.prototype.generate=function(){return""};t.prototype.getColumnCount=function(){if(this._oExport){return this._oExport.getColumns().length}return 0};t.prototype.getRowCount=function(){if(this._oExport&&this._oExport.getBinding("rows")){return this._oExport.getBinding("rows").getLength()}return 0};t.prototype.columnGenerator=function(){var e=0,t=this._oExport.getColumns(),n=t.length;return{next:function(){if(e<n){var r=e;e++;return{value:{index:r,name:t[r].getName()},done:false}}else{return{value:undefined,done:true}}}}};t.prototype.cellGenerator=function(){var e=0,t=this._oExport.getAggregation("_template"),n=t.getCells(),r=n.length;return{next:function(){if(e<r){var t=e;e++;var o={};n[t].getCustomData().forEach(function(e){o[e.getKey()]=e.getValue()});return{value:{index:t,content:n[t].getContent(),customData:o},done:false}}else{return{value:undefined,done:true}}}}};t.prototype.rowGenerator=function(){var e=this,t=0,n=this._oExport,r=n.getBinding("rows"),o=n.getBindingInfo("rows"),i=r.getContexts(0,r.getLength()),u=i.length,a=n.getAggregation("_template");return{next:function(){if(t<u){var n=t;t++;a.setBindingContext(i[n],o.model);return{value:{index:n,cells:e.cellGenerator()},done:false}}else{return{value:undefined,done:true}}}}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/ExportTypeCSV", ["./ExportType"],function(e){"use strict";var t=/[\r\n"\t;,]/;var r=/^[=\+\-@](?![\d.,]+(?:e[\+-]?\d+)?$)/i;var a=e.extend("sap.ui.core.util.ExportTypeCSV",{metadata:{library:"sap.ui.core",properties:{separatorChar:{type:"string",defaultValue:","}}}});a.MAX_CELL_LENGTH=32760;a.prototype.setSeparatorChar=function(e){var e=this.validateProperty("separatorChar",e);if(e.length>1){throw new Error('Value of property "separatorChar" needs to be exactly one character or empty. '+'"'+e+'" is '+e.length+" characters long.")}return this.setProperty("separatorChar",e)};a.prototype.init=function(){this.setProperty("fileExtension","csv",true);this.setProperty("mimeType","text/csv",true);this.setProperty("charset","utf-8",true)};a.prototype.escapeContent=function(e){if(!e){return e}if(e.length>a.MAX_CELL_LENGTH){e=e.slice(0,a.MAX_CELL_LENGTH)}if(r.test(e)){e="'"+e}var o=e.indexOf(this.getSeparatorChar())>-1;if(o||t.test(e)){e=e.replace(/"/g,'""');e='"'+e+'"'}return e};a.prototype.generate=function(){var e=[];this.generateColumns(e);this.generateRows(e);return e.join("\r\n")};a.prototype.generateColumns=function(e){var t=[],r=this.columnGenerator(),a;while(!(a=r.next()).done){t.push(this.escapeContent(a.value.name))}e.push(t.join(this.getSeparatorChar()))};a.prototype.generateRows=function(e){var t=this.rowGenerator(),r;while(!(r=t.next()).done){var a=[];var o=r.value.cells,n;while(!(n=o.next()).done){a.push(this.escapeContent(n.value.content))}e.push(a.join(this.getSeparatorChar()))}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/File", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var e={save:function(e,o,n,r,a,t){var i=o+"."+n;if(typeof t==="undefined"&&a==="utf-8"&&n==="csv"){t=true}if(t===true&&a==="utf-8"){e="\ufeff"+e}if(window.Blob){var d="data:"+r;if(a){d+=";charset="+a}var w=new window.Blob([e],{type:d});if(window.navigator.msSaveOrOpenBlob){window.navigator.msSaveOrOpenBlob(w,i)}else{var u=window.URL||window.webkitURL;var f=u.createObjectURL(w);var l=window.document.createElement("a");if("download"in l){var v=jQuery(document.body);var p=jQuery(l).attr({download:i,href:f,style:"display:none"});v.append(p);p.get(0).click();p.remove()}else{e=encodeURI(e);var c=window.open(d+","+e);c.opener=null;if(!c){throw new Error("Could not download the file, please deactivate your pop-up blocker.")}}}}}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/LibraryInfo", ["sap/ui/base/Object","sap/base/Log","sap/base/util/fetch","sap/base/util/Version","sap/ui/thirdparty/jquery"],function(e,t,r,a,jQuery){"use strict";var n=e.extend("sap.ui.core.util.LibraryInfo",{constructor:function(){e.apply(this);this._oLibInfos={}},destroy:function(){e.prototype.destroy.apply(this,arguments);this._oLibInfos={}},getInterface:function(){return this}});n.prototype._loadLibraryMetadata=function(e,a){e=e.replace(/\//g,".");if(this._oLibInfos[e]){setTimeout(a.bind(window,this._oLibInfos[e]),0);return}var n=this,o,i,s=/themelib_(.*)/i.exec(e),l;if(!s){i=".library";o=sap.ui.require.toUrl(e.replace(/\./g,"/"))+"/"}else{i=".theme";o=sap.ui.require.toUrl("sap/ui/core/themes/"+s[1]+"/")}l=typeof n.getResourceUrl==="function"?n.getResourceUrl(o):o;function f(r){t.error("failed to load library details from '"+o+i+": "+r.message+", "+r);n._oLibInfos[e]={name:e,data:null,url:o};a(n._oLibInfos[e])}r(l+i,{headers:{Accept:r.ContentTypes.XML}}).then(function(t){if(t.ok){return t.text().then(function(t){var r=new DOMParser;var i=r.parseFromString(t,"text/xml");n._oLibInfos[e]={name:e,data:i,url:o};a(n._oLibInfos[e])})}else{throw new Error(t.statusText||t.status)}}).catch(f)};n.prototype._getLibraryInfo=function(e,t){this._loadLibraryMetadata(e,function(e){var r={libs:[],library:e.name,libraryUrl:e.url};if(e.data){var a=jQuery(e.data);r.vendor=a.find("vendor").text();r.copyright=a.find("copyright").text();r.version=a.find("version").text();r.documentation=a.find("documentation").text();r.releasenotes=a.find("releasenotes").attr("url");r.componentInfo=n.prototype._getLibraryComponentInfo(a)}t(r)})};n.prototype._getThirdPartyInfo=function(e,t){this._loadLibraryMetadata(e,function(e){var r={libs:[],library:e.name,libraryUrl:e.url};if(e.data){var a=jQuery(e.data).find("appData").find("thirdparty").children();a.each(function(t,a){if(a.nodeName==="lib"){var n=jQuery(a);var o=n.children("license");r.libs.push({displayName:n.attr("displayName"),homepage:n.attr("homepage"),license:{url:o.attr("url"),type:o.attr("type"),file:e.url+o.attr("file")}})}})}t(r)})};n.prototype._getDocuIndex=function(e,a){var n=this;this._loadLibraryMetadata(e,function(e){var o=e.name,i=e.url,s={docu:{},library:o,libraryUrl:i};if(!e.data){a(s);return}var l=jQuery(e.data).find("appData").find("documentation");var f=l.attr("indexUrl");if(!f){a(s);return}if(l.attr("resolve")=="lib"){f=e.url+f}if(typeof n.getResourceUrl==="function"){f=n.getResourceUrl(f)}r(f,{headers:{Accept:r.ContentTypes.JSON}}).then(function(e){if(e.ok){e.json().then(function(e){e.library=o;e.libraryUrl=i;a(e)})}else{throw new Error(e.statusText||e.status)}}).catch(function(e){t.error("failed to load library docu from '"+f+"': "+e.message+", "+e);a(s)})})};n.prototype._getReleaseNotes=function(e,n,o){var i=this;this._loadLibraryMetadata(e,function(s){if(!s.data){o({});return}var l=n.split(".").length===3&&!/-SNAPSHOT/.test(n);var f=a(n);var u=f.getMajor();var c=f.getMinor();var p=f.getPatch();var d=jQuery(s.data).find("appData").find("releasenotes");var h=d.attr("url");var y=typeof i.getResourceUrl==="function";if(!h){t.warning("failed to load release notes for library "+e);o({});return}if(f.getSuffix()==="-SNAPSHOT"){if(c%2!=0){c=c+1;p=0}n=u+"."+c+"."+p}var m=y?i.getResourceUrl(""):window.location.href,g=/\/\d.\d{1,2}.\d{1,2}\//;if(d.attr("resolve")=="lib"){if(g.test(m)||l===false){h=s.url+h}else{h="{major}.{minor}.{patch}/"+s.url+h}}h=h.replace(/\{major\}/g,u);h=h.replace(/\{minor\}/g,c);h=h.replace(/\{patch\}/g,p);if(y){h=i.getResourceUrl(h)}r(h,{headers:{Accept:r.ContentTypes.JSON}}).then(function(e){if(e.ok){return e.json().then(function(e){o(e,n)})}else{throw new Error(e.statusText||e.status)}}).catch(function(r){if(r.name==="SyntaxError"){t.error("failed to parse release notes for library '"+e+", "+r)}else{t.warning("failed to load release notes for library '"+e+", "+r)}o({})})})};n.prototype._getLibraryComponentInfo=function(e){var t={};var r=[];var a="";e.find("ownership > component").each(function(e,t){if(t.childElementCount===0){a=t.textContent}else{var n=t.getElementsByTagName("name");if(n&&n.length>0){n=n[0].textContent;var o=t.getElementsByTagName("module");if(n&&o&&o.length>0){var i=[];for(var s=0;s<o.length;s++){var l=o[s].textContent.replace(/\//g,".");if(l){i.push(l)}}if(i.length>0){r.push({component:n,modules:i})}}}}});t["defaultComponent"]=a;if(r&&r.length>0){t["specialCases"]=r}return t};n.prototype._getActualComponent=function(e,r){function a(e,t){e=e.toLowerCase();t=t.toLowerCase();return e===t||t.match(/\*$/)&&e.indexOf(t.slice(0,-1))===0||t.match(/\.\*$/)&&e===t.slice(0,-2)}if(r){for(var n in e){if(!e[n]){t.error("No library information deployed for "+n);continue}var o;if(r.indexOf(n)===0){o=e[n].defaultComponent}var i=e[n].specialCases;if(i){for(var s=0;s<i.length;s++){var l=i[s].modules;for(var f=0;f<l.length;f++){if(a(r,l[f])){o=i[s].component}}}}if(o){return o}}}};n.prototype._getDefaultComponent=function(e){return e&&e.componentInfo&&e.componentInfo.defaultComponent};return n});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/MockServer", ["sap/base/Log","sap/base/util/isEmptyObject","sap/ui/base/ManagedObject","sap/ui/core/util/DraftEnabledMockServer","sap/ui/model/odata/ODataMetadata","sap/ui/thirdparty/jquery","sap/ui/thirdparty/sinon"],function(e,t,r,n,a,jQuery,s){"use strict";var o=r.extend("sap.ui.core.util.MockServer",{constructor:function(e,t){r.apply(this,arguments);o._aServers.push(this)},metadata:{library:"sap.ui.core",properties:{rootUri:"string",recordRequests:{type:"boolean",defaultValue:true},requests:{type:"object[]",defaultValue:[]}}},_oServer:null,_aFilter:null,_oMockdata:null,_oMetadata:null,_sMetadataUrl:null,_sMockdataBaseUrl:null,_mEntitySets:null,_oErrorMessages:{INVALID_SYSTEM_QUERY_OPTION_VALUE:"Invalid system query options value",IS_NOT_A_VALID_SYSTEM_QUERY_OPTION:"## is not a valid system query option",URI_VIOLATING_CONSTRUCTION_RULES:"The URI is violating the construction rules defined in the Data Services specification",UNSUPPORTED_FORMAT_VALUE:"Unsupported format value. Only json format is supported",MALFORMED_SYNTAX:"The Data Services Request could not be understood due to malformed syntax",RESOURCE_NOT_FOUND:"Resource not found",INVALID_SORTORDER_DETECTED:"Invalid sortorder ## detected",PROPERTY_NOT_FOUND:"Property ## not found",INVALID_FILTER_QUERY_STATEMENT:"Invalid filter query statement",INVALID_FILTER_OPERATOR:"Invalid $filter operator ##",RESOURCE_NOT_FOUND_FOR_SEGMENT:"Resource not found for the segment ##",MALFORMED_URI_LITERAL_SYNTAX_IN_KEY:"Malformed URI literal syntax in key ##",INVALID_KEY_NAME:"Invalid key name in key predicate. Expected name is ##",INVALID_KEY_PREDICATE_QUANTITY:"Invalid key predicate. The quantity of provided keys does not match the expected value",INVALID_KEY_TYPE:"Invalid key predicate. The key literal for key property ## does not match its type."},_oRandomSeed:{}});o.prototype._getPseudoRandomNumber=function(e){if(!this._oRandomSeed){this._oRandomSeed={}}if(!this._oRandomSeed.hasOwnProperty(e)){this._oRandomSeed[e]=0}this._oRandomSeed[e]=(this._oRandomSeed[e]+11)*25214903917%0xffffffffffff;return this._oRandomSeed[e]/0xffffffffffff};o.prototype._resetPseudoRandomNumberGenerator=function(){this._oRandomSeed={}};o.prototype.start=function(){this._oServer=o._getInstance();this._aFilters=[];var e=this.getRequests();var t=this;e.forEach(function(e){var r;if(t.getRecordRequests()===false&&e.response){r=function(){e.response.apply(this,arguments);t._oServer.requests=[]}}else{r=e.response}t._addRequestHandler(e.method,e.path,r)})};o.prototype.stop=function(){if(this.isStarted()){this._removeAllRequestHandlers();this._removeAllFilters();this._oServer=null}};o.prototype.attachBefore=function(e,t,r){r=r?r:"";this.attachEvent(e+r+":before",t)};o.prototype.attachAfter=function(e,t,r){r=r?r:"";this.attachEvent(e+r+":after",t)};o.prototype.detachBefore=function(e,t,r){r=r?r:"";this.detachEvent(e+r+":before",t)};o.prototype.detachAfter=function(e,t,r){r=r?r:"";this.detachEvent(e+r+":after",t)};o.prototype.isStarted=function(){return!!this._oServer};o.prototype.getEntitySetData=function(t){var r=this;var n;if(this._oMockdata&&this._oMockdata.hasOwnProperty(t)){n=jQuery.extend(true,[],r._oMockdata[t])}else{e.error("Unrecognized EntitySet name: "+t)}return n};o.prototype.setEntitySetData=function(t,r){if(this._oMockdata&&this._oMockdata.hasOwnProperty(t)){this._oMockdata[t]=r}else{e.error("Unrecognized EntitySet name: "+t)}};o.prototype._applyQueryOnCollection=function(e,t,r,n){var a=t.split("=");var s=a[1];if(s===""){return}if(s.lastIndexOf(",")===s.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES)}switch(a[0]){case"$top":if(!new RegExp(/^\d+$/).test(s)){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE)}e.results=e.results.slice(0,s);break;case"$skip":if(!new RegExp(/^\d+$/).test(s)){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE)}e.results=e.results.slice(s,e.results.length);break;case"$orderby":e.results=this._getOdataQueryOrderby(e.results,s,r);break;case"$filter":e.results=this._recursiveOdataQueryFilter(e.results,s);break;case"search-focus":break;case"search":var o="";for(var i=0;i<n.length;i++){if(n[i].indexOf("search-focus")!=-1){o=n[i].split("=")[1];break}}e.results=this._recursiveOdataQuerySearch(e.results,s,o,r);break;case"$select":e.results=this._getOdataQuerySelect(e.results,s,r);break;case"$inlinecount":var u=this._getOdataInlineCount(e.results,s);if(u){e.__count=u}break;case"$expand":e.results=this._getOdataQueryExpand(e.results,s,r);break;case"$format":e.results=this._getOdataQueryFormat(e.results,s);break;default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0])}};o.prototype._applyQueryOnEntry=function(e,t,r){var n=t.split("=");var a=n[1];if(a===""){return}if(a.lastIndexOf(",")===a.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES)}switch(n[0]){case"$filter":return this._recursiveOdataQueryFilter([e],a)[0];case"$select":return this._getOdataQuerySelect([e],a,r)[0];case"$expand":return this._getOdataQueryExpand([e],a,r)[0];case"$format":return this._getOdataQueryFormat([e],a);default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,n[0])}};o.prototype._getOdataQueryOrderby=function(e,t,r){var n=t.split(",");var a=this;jQuery.each(n,function(e,t){n[e]=a._trim(t)});var s=function e(t,s){for(var o=0;o<n.length;o++){var i=n[o].split(" ");var u=1;if(i.length>1){switch(i[1]){case"asc":u=1;break;case"desc":u=-1;break;default:a._logAndThrowMockServerCustomError(400,a._oErrorMessages.INVALID_SORTORDER_DETECTED,i[1])}}var f,c;var d=i[0].indexOf("/");if(d!==-1){f=i[0].substring(d+1);c=i[0].substring(0,d);if(!t[c].hasOwnProperty(f)){var p=false;var l=[];if(c){var h=a._mEntitySets[r].navprops[c].to.entitySet;l=a._mEntityTypes[a._mEntitySets[h].type].properties;for(var o=0;o<l.length;o++){if(l[o].name===f){p=true;break}}}if(!p){a._logAndThrowMockServerCustomError(400,a._oErrorMessages.PROPERTY_NOT_FOUND,f)}}if(t[c][f]<s[c][f]){return-1*u}if(t[c][f]>s[c][f]){return 1*u}}else{f=i[0];if(!t.hasOwnProperty(f)){a._logAndThrowMockServerCustomError(400,a._oErrorMessages.PROPERTY_NOT_FOUND,f)}if(t[f]<s[f]){return-1*u}if(t[f]>s[f]){return 1*u}}}return 0};return e.sort(s)};o.prototype._arrayUnique=function(e){var t=e.concat();for(var r=0;r<t.length;++r){for(var n=r+1;n<t.length;++n){if(t[r]===t[n]){t.splice(n--,1)}}}return t};o.prototype._getBracketIndices=function(e){var t=[];var r=0;var n,a=0;for(var s=0;s<e.length;s++){if(e[s]==="("){if(/[substringof|endswith|startswith]$/.test(e.substring(0,s))){++r}else{t.push(e[s]);if(n===undefined){n=s}}}else if(e[s]===")"){if(!r){t.pop();a=s;if(t.length===0){return{start:n,end:a}}}else{--r}}}return{start:n,end:a}};o.prototype._recursiveOdataQueryFilter=function(e,t){var r=this._getBracketIndices(t);if(r.start===0&&r.end===t.length-1){t=this._trim(t.substring(r.start+1,r.end));return this._recursiveOdataQueryFilter(e,t)}var n=/([^substringof|endswith|startswith]|^)\((.*)\)/,a,s;var o;if(n.test(t)){var i=t.substring(r.start,r.end+1);var u=new RegExp("(.*) +(or|and) +("+this._trim(this._escapeStringForRegExp(i))+".*)");if(r.start===0){u=new RegExp("("+this._trim(this._escapeStringForRegExp(i))+") +(or|and) +(.*)")}var f=u.exec(t);if(f===null){return this._getOdataQueryFilter(e,this._trim(t))}var c=f[1];o=f[2];var d=f[3];var p=this._recursiveOdataQueryFilter(e,c);if(o==="or"){a=this._recursiveOdataQueryFilter(e,d);return this._arrayUnique(p.concat(a))}if(o==="and"){return this._recursiveOdataQueryFilter(p,d)}}else{s=t.split(/ +and | or +/);if(s.length===1){return this._getOdataQueryFilter(e,this._trim(t))}var l=this._recursiveOdataQueryFilter(e,s[0]);var h;for(var v=1;v<s.length;v++){h=new RegExp(this._trim(this._escapeStringForRegExp(s[v-1]))+" +(and|or) +"+this._trim(this._escapeStringForRegExp(s[v])));o=h.exec(t)[1];if(o==="or"){a=this._recursiveOdataQueryFilter(e,s[v]);l=this._arrayUnique(l.concat(a))}if(o==="and"){l=this._recursiveOdataQueryFilter(l,s[v])}}return l}};o.prototype._getOdataQueryFilter=function(t,r){if(t.length===0){return t}var n=new RegExp("(.*) (eq|ne|gt|lt|le|ge) (.*)");var a=new RegExp("(endswith|startswith|substringof)\\((.*)");var s=null;var o=n.exec(r);if(o){s=o[2]}else{o=a.exec(r);if(o){s=o[1]}else{this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_FILTER_QUERY_STATEMENT)}}var i=this;var u=function(a,s,o,u){var f,c,d;if(!a){f=n.exec(r);c=i._trim(f[s+1]);d=i._trim(f[o+1])}else{var p=new RegExp("(substringof|startswith|endswith)\\(([^\\)]*),(.*)\\)");f=p.exec(r);c=i._trim(f[s+2]);d=i._trim(f[o+2])}if(/^\(.+\)$/.test(c)){c=c.replace(/^\(|\)$/g,"")}if(c.indexOf("datetime")===0){c=i._getJsonDate(c)}else if(c.indexOf("guid")===0){c=c.substring(5,c.length-1)}else if(c==="true"){c=true}else if(c==="false"){c=false}else if(i._isValidNumber(c)){c=parseFloat(c)}else if(c.charAt(0)==="'"&&c.charAt(c.length-1)==="'"){c=c.substr(1,c.length-2)}var l=d.indexOf("/");if(l!==-1){var h=d.substring(l+1);var v=d.substring(0,l);if(t[0][v]){if(!t[0][v].hasOwnProperty(h)){var _=i._oErrorMessages.PROPERTY_NOT_FOUND.replace("##","'"+h+"'");e.error("MockServer: navigation property '"+v+"' was not expanded, so "+_);return t}}else{i._logAndThrowMockServerCustomError(400,i._oErrorMessages.PROPERTY_NOT_FOUND,d)}return u(d,c,v,h)}else{if(!t[0].hasOwnProperty(d)){i._logAndThrowMockServerCustomError(400,i._oErrorMessages.PROPERTY_NOT_FOUND,d)}return u(d,c)}};switch(s){case"substringof":return u(true,0,1,function(e,r,n,a){return t.filter(function(t){if(n&&a){return typeof t[n][a]==="string"&&t[n][a].indexOf(r)!==-1}return typeof t[e]==="string"&&t[e].indexOf(r)!==-1})});case"startswith":return u(true,1,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return typeof t[n][a]==="string"&&t[n][a].indexOf(r)===0}return typeof t[e]==="string"&&t[e].indexOf(r)===0})});case"endswith":return u(true,1,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return typeof t[n][a]==="string"&&t[n][a].indexOf(r)===t[n][a].length-r.length}return typeof t[e]==="string"&&t[e].indexOf(r)===t[e].length-r.length})});case"eq":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]===r}return t[e]===r})});case"ne":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]!==r}return t[e]!==r})});case"gt":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]>r}return t[e]>r})});case"lt":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]<r}return t[e]<r})});case"ge":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]>=r}return t[e]>=r})});case"le":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]<=r}return t[e]<=r})});default:this._logAndThrowMockServerCustomError(400,i._oErrorMessages.INVALID_FILTER_OPERATOR,s)}};o.prototype._recursiveOdataQuerySearch=function(e,t,r,n){var a="";if(r==""||r==undefined){for(var s=0;s<this._mEntitySets[n].keys.length;s++){if(s!=0){a=a+" or "}a=a+"startswith("+this._mEntitySets[n].keys[s]+",'"+t+"')"}}else{a="substringof('"+t+"',"+r+")"}return this._recursiveOdataQueryFilter(e,a)};o.prototype._getOdataQuerySelect=function(e,t,r){var n=this;var a=t.split(",");var s=[];var o=e[0]?e[0][a[0].split("/")[0]]:null;if(!(o!=null&&o.results&&o.results.length>0)){var i=function(e,t,a,s){jQuery.each(e,function(e,o){if(t["__metadata"]){a["__metadata"]=t["__metadata"]}if(o.indexOf("/")>-1){var u=o.split("/");var f=u[0];var c=u.splice(1).join("/");a[f]=a[f]||{};if(t[f]&&t[f].results){var d=a[f].results=a[f].results||[];jQuery.each(t[f].results,function(e,t){d[e]=i([c],t,d[e]||{},f)})}else{a[f]=i([c],t[f],a[f]||{},f)}}else{if(t&&!t.hasOwnProperty(o)){var p=false;var l=[];if(s){var h=n._mEntitySets[r].navprops[s].to.entitySet;l=n._mEntityTypes[n._mEntitySets[h].type].properties;for(var e=0;e<l.length;e++){if(l[e].name===o){p=true;break}}}if(!p){n._logAndThrowMockServerCustomError(404,n._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,o)}}a[o]=t[o]}});return a};if(a.indexOf("*")!==-1){return e}jQuery.each(a,function(e,t){a[e]=n._trim(t)});jQuery.each(e,function(e,t){s.push(i(a,t,{}))})}else{var u=function(e,t,r){var n={};r=r||"";if(typeof e!=="object"){return e}if(typeof e.slice==="function"){return e.map(function(e,n){return u(e,t,r)})}if(e.__metadata!==undefined&&r.length===0){n.__metadata=e.__metadata}t.filter(function(e){return(e+"/").indexOf(r)===0}).forEach(function(t,a,s){var o=t.substr(r.length).split("/")[0];if(e[o]!==undefined){n[o]=u(e[o],s,r+o+"/")}});if(e.results!==undefined){n.results=u(e.results,t,r)}return n};s=u(e,a)}return s};o.prototype._getOdataInlineCount=function(e,t){var r=t.split(",");if(r.length!==1||r[0]!=="none"&&r[0]!=="allpages"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE)}if(r[0]==="none"){return}return e.length};o.prototype._getOdataQueryFormat=function(e,t){if(t!=="json"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.UNSUPPORTED_FORMAT_VALUE)}return e};o.prototype._getOdataQueryExpand=function(e,t,r){var n=this;var a=t.split(",");jQuery.each(a,function(e,t){a[e]=n._trim(t)});var s=n._mEntitySets[r].navprops;jQuery.each(e,function(e,t){jQuery.each(a,function(e,a){var o=a.split("/");var i=o[0];if(!t[i]){n._logAndThrowMockServerCustomError(404,n._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,i)}var u=t[i].results||t[i];if(!u||u.__deferred){u=jQuery.extend(true,[],n._resolveNavigation(r,t,i,t))}else if(!Array.isArray(u)){u=[u]}if(u&&o.length>1){var f=o.splice(1,o.length).join("/");u=n._getOdataQueryExpand(u,f,s[i].to.entitySet)}if(s[i].to.multiplicity==="*"){t[i]={results:u}}else{t[i]=u[0]?u[0]:{}}})});return e};o.prototype._refreshData=function(){var e=this._loadMetadata(this._sMetadataString);if(!e){return}this._mEntitySets=this._findEntitySets(this._oMetadata);this._mEntityTypes=this._findEntityTypes(this._oMetadata);if(!this._sMockdataBaseUrl){this._generateMockdata(this._mEntitySets,this._oMetadata)}else{if(!this._sMockdataBaseUrl.endsWith("/")&&!this._sMockdataBaseUrl.endsWith(".json")){this._sMockdataBaseUrl+="/"}this._loadMockdata(this._mEntitySets,this._sMockdataBaseUrl)}};o.prototype._getRootUri=function(){var e=this.getRootUri();e=e&&/([^?#]*)([?#].*)?/.exec(e)[1];return e};o.prototype._loadMetadata=function(t){var t;t=t.trim();if(t.substring(0,1)!=="<"){t=i({url:t,dataType:"text"}).data;if(!t){e.error('MockServer: The metadata for url "'+t+'" could not be found!')}}this._sMetadata=t;try{this._oMetadata=jQuery.parseXML(t)}catch(t){e.error("MockServer: Invalid metadata XML! Reason: "+t)}return this._oMetadata};o.prototype._findEntitySets=function(e){var t={};var r=jQuery(e).find("Principal");var n=jQuery(e).find("Dependent");jQuery(e).find("EntitySet").each(function(e,r){var n=jQuery(r);var a=/((.*)\.)?(.*)/.exec(n.attr("EntityType"));t[n.attr("Name")]={name:n.attr("Name"),schema:a[2],type:a[3],keys:[],keysType:{},navprops:{},props:{}}});var a=function(e,t,a,s){var o=jQuery(a).find("End[Role='"+e+"']").attr("EntitySet");var i=jQuery(t).find("End[Role='"+e+"']").attr("Multiplicity");var u=[];var f=jQuery(t).find("ReferentialConstraint > [Role='"+e+"']");if(f&&f.length>0){jQuery(f[0]).children("PropertyRef").each(function(e,t){u.push(jQuery(t).attr("Name"))})}else{var c=s?r:n;jQuery(c).each(function(t,r){if(e===jQuery(r).attr("Role")){jQuery(r).children("PropertyRef").each(function(e,t){u.push(jQuery(t).attr("Name"))});return false}})}return{role:e,entitySet:o,propRef:u,multiplicity:i}};jQuery.each(t,function(t,r){var n=jQuery(e).find("EntityType[Name='"+r.type+"']");var s=jQuery(n).find("PropertyRef");jQuery.each(s,function(e,t){var a=jQuery(t).attr("Name");r.keys.push(a);r.keysType[a]=jQuery(n).find("Property[Name='"+a+"']").attr("Type")});var o=jQuery(e).find("EntityType[Name='"+r.type+"'] Property");jQuery.each(o,function(e,t){var n=jQuery(t);r.props[n.attr("Name")]={name:n.attr("Name"),type:n.attr("Type")}});var i=jQuery(e).find("EntityType[Name='"+r.type+"'] NavigationProperty");jQuery.each(i,function(t,n){var s=jQuery(n);var o=s.attr("Relationship").split(".");var i=jQuery(e).find("AssociationSet[Association = '"+o.join(".")+"']");var u=o.pop();var f=jQuery(e).find("Association[Name = '"+u+"']");r.navprops[s.attr("Name")]={name:s.attr("Name"),from:a(s.attr("FromRole"),f,i,true),to:a(s.attr("ToRole"),f,i,false)}})});return t};o.prototype._findEntityTypes=function(e){var t={};jQuery(e).find("EntityType").each(function(e,r){var n=jQuery(r);t[n.attr("Name")]={name:n.attr("Name"),properties:[],keys:[]};n.find("Property").each(function(e,r){var a=jQuery(r);var s=a.attr("Type");t[n.attr("Name")].properties.push({schema:s.substring(0,s.lastIndexOf(".")),type:s.substring(s.lastIndexOf(".")+1),name:a.attr("Name"),precision:a.attr("Precision"),scale:a.attr("Scale")})});n.find("PropertyRef").each(function(e,r){var a=jQuery(r);var s=a.attr("Name");t[n.attr("Name")].keys.push(s)})});return t};o.prototype._findComplexTypes=function(e){var t={};jQuery(e).find("ComplexType").each(function(e,r){var n=jQuery(r);t[n.attr("Name")]={name:n.attr("Name"),properties:[]};n.find("Property").each(function(e,r){var a=jQuery(r);var s=a.attr("Type");t[n.attr("Name")].properties.push({schema:s.substring(0,s.lastIndexOf(".")),type:s.substring(s.lastIndexOf(".")+1),name:a.attr("Name"),precision:a.attr("Precision"),scale:a.attr("Scale")})})});return t};o.prototype._createKeysString=function(e,t){var r=this;var n="";if(t){jQuery.each(e.keys,function(a,s){if(n){n+=","}var o=t[s];if(e.keysType[s]==="Edm.String"){o=encodeURIComponent("'"+o+"'")}else if(e.keysType[s]==="Edm.DateTime"){o=r._getDateTime(o);o=encodeURIComponent(o)}else if(e.keysType[s]==="Edm.Guid"){o="guid'"+o+"'"}if(e.keys.length===1){n+=o;return n}n+=s+"="+o})}return n};o.prototype._loadMockdata=function(t,r){var n=this,a={};this._oMockdata={};var s=function(t,r){var n=i({url:t,dataType:"json"});if(n.success){if(n.data.d){if(n.data.d.results){a[r.name]=n.data.d.results}else{e.error('The mock data format for entity set "'+r.name+'" invalid')}}else{if(Array.isArray(n.data)){a[r.name]=n.data}else{e.error('The mock data for entity set "'+r.name+'" could not be loaded due to wrong format!');return false}}return true}else{if(n.status==="parsererror"){e.error('The mock data for entity set "'+r.name+'" could not be loaded due to a parsing error!')}return false}};if(r.endsWith(".json")){var o=i({url:r,dataType:"json"});if(o.success){a=o.data}else{e.warning('The mock data for all the entity types could not be found at "'+r+'"!')}}else{var u={};if(n._aEntitySetsNames&&n._aEntitySetsNames.length>0){var f;for(var c=0;c<n._aEntitySetsNames.length;c++){f=n._aEntitySetsNames[c];if(t[f]){u[f]=t[f]}}}else{u=t}jQuery.each(u,function(t,o){if(!a[o.type]||!a[o.name]){var i=r+o.name+".json";if(!s(i,o)){e.warning('The mock data for entity set "'+o.name+'" could not be found at "'+r+'"!');var u=r+o.type+".json";if(!s(u,o)){e.warning('The mock data for entity type "'+o.type+'" could not be found at "'+r+'"!');if(n._bGenerateMissingMockData){var f={};f[o.name]=o;a[o.type]=n._generateODataMockdataForEntitySet(f,n._oMetadata)[o.name]}}}}})}jQuery.each(t,function(e,t){n._oMockdata[e]=[];if(a[t.name]){jQuery.each(a[t.name],function(t,r){n._oMockdata[e].push(jQuery.extend(true,{},r))})}else if(a[t.type]){jQuery.each(a[t.type],function(t,r){n._oMockdata[e].push(jQuery.extend(true,{},r))})}});jQuery.each(t,function(e,t){if(n._oMockdata[e].length>0){n._enhanceWithMetadata(t,n._oMockdata[e]);n._oMockdata[e].forEach(function(e){Object.keys(t.props).forEach(function(r){switch(t.props[r].type){case"Edm.DateTime":case"Edm.DateTimeOffset":if(e[r]!=null){var n=new Date(e[r]);if(n&&!isNaN(n)){e[r]="/Date("+n.getTime()+")/"}}break;default:}})})}});return this._oMockdata};o.prototype._enhanceWithMetadata=function(e,r){if(r){var n=this,a=this._getRootUri(),s=e&&e.name;jQuery.each(r,function(r,o){o.__metadata=o.__metadata||{};o.__metadata.id=a+s+"("+n._createKeysString(e,o)+")";o.__metadata.type=e.schema+"."+e.type;o.__metadata.uri=a+s+"("+n._createKeysString(e,o)+")";jQuery.each(e.navprops,function(r,i){if(o[r]&&!t(o[r])&&!o[r]["__deferred"]){n._oMockdata[i.to.entitySet]=n._oMockdata[i.to.entitySet].concat(o[r])}o[r]={__deferred:{uri:a+s+"("+n._createKeysString(e,o)+")/"+r}}})})}};o.prototype._isRequestedKeysValid=function(e,t){if(t.length===1){var r=t[0].split("=");if(this._trim(r[0])!==e.keys[0]){t=[e.keys[0]+"="+t[0]]}}for(var n=0;n<t.length;n++){var a=this._trim(t[n].substring(0,t[n].indexOf("=")));var s=this._trim(t[n].substring(t[n].indexOf("=")+1));var o=s.charAt(0);var i=s.charAt(s.length-1);if(e.keysType[a]==="Edm.String"){if(o!=="'"||i!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}else if(e.keysType[a]==="Edm.DateTime"){if(o==="'"||i!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}else if(e.keysType[a]==="Edm.Guid"){if(o==="'"||i!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}else if(e.keysType[a]==="Edm.Binary"){if(!new RegExp("(binary|X)'[A-Fa-f0-9][A-Fa-f0-9]*'").test(s)){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}else{if(o==="'"&&i!=="'"||i==="'"&&o!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}var u=e.keys.join(",");if(e.keys.indexOf(a)===-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_KEY_NAME,u)}}};o.prototype._parseKeys=function(e,t){var r={};var n=e.split(",");var a,s,o;for(var i=0;i<n.length;i++){o=n[i].split("=");if(o.length===1&&t.keys.length===1){a=t.keys[0];s=o[0]}else{if(o.length===2){a=o[0];s=o[1]}}r[a]=s;switch(t.keysType[a]){case"Edm.String":r[a]=r[a].replace(/^\'|\'$/g,"");break;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":r[a]=parseFloat(r[a]);break;case"Edm.Guid":r[a]=r[a].replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":case"Edm.Binary":case"Edm.DateTimeOffset":default:}}return r};o.prototype._generatePropertyValue=function(e,t,r,n){var a=n;if(!a){a=Math.floor(this._getPseudoRandomNumber("String")*1e4)+101}switch(t){case"String":return e+" "+a;case"DateTime":var s=new Date;s.setFullYear(2e3+Math.floor(this._getPseudoRandomNumber("DateTime")*20));s.setDate(Math.floor(this._getPseudoRandomNumber("DateTime")*30));s.setMonth(Math.floor(this._getPseudoRandomNumber("DateTime")*12));s.setMilliseconds(0);return"/Date("+s.getTime()+")/";case"Int16":case"Int32":case"Int64":return Math.floor(this._getPseudoRandomNumber("Int")*1e4);case"Decimal":return Math.floor(this._getPseudoRandomNumber("Decimal")*1e6)/100;case"Boolean":return this._getPseudoRandomNumber("Boolean")<.5;case"Byte":return Math.floor(this._getPseudoRandomNumber("Byte")*10);case"Double":return this._getPseudoRandomNumber("Double")*10;case"Single":return this._getPseudoRandomNumber("Single")*1e9;case"SByte":return Math.floor(this._getPseudoRandomNumber("SByte")*10);case"Time":return"PT"+Math.floor(this._getPseudoRandomNumber("Time")*23)+"H"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"M"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"S";case"Guid":return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=this._getPseudoRandomNumber("Guid")*16|0,r=e==="x"?t:t&3|8;return r.toString(16)}.bind(this));case"Binary":var o=Math.floor(-2147483648+this._getPseudoRandomNumber("Binary")*4294967295),i="";for(var u=0,f=o;u<32;u++,i+=String(f>>>31),f<<=1);return i;case"DateTimeOffset":var s=new Date;s.setFullYear(2e3+Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*20));s.setDate(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*30));s.setMonth(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*12));s.setMilliseconds(0);return"/Date("+s.getTime()+"+0000)/";default:return this._generateDataFromEntity(r[t],a,r)}};o.prototype._isFalseyValue=function(e,t,r){switch(r){case"Edm.String":return e==="";case"Edm.Boolean":return e===false;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":return e===0||isNaN(e);default:return false}};o.prototype._completeKey=function(e,t,r){if(r){for(var n=0;n<e.keys.length;n++){var a=e.keys[n];if(t[a]!==undefined&&t[a]!==null){if(!r[a]){switch(e.keysType[a]){case"Edm.DateTime":r[a]=this._getJsonDate(t[a]);break;case"Edm.Guid":r[a]=t[a].replace(/^guid\'|\'$/g,"");break;default:r[a]=t[a]}}}else{if(!r[a]){r[a]=this._generatePropertyValue(a,e.keysType[a].substring(e.keysType[a].lastIndexOf(".")+1))}}}}};o.prototype._generateDataFromEntity=function(e,t,r){var n={};if(!e){return n}for(var a=0;a<e.properties.length;a++){var s=e.properties[a];n[s.name]=this._generatePropertyValue(s.name,s.type,r,t)}return n};o.prototype._generateDataFromEntitySet=function(e,t,r){var n=t[e.type];var a=[];for(var s=0;s<100;s++){a.push(this._generateDataFromEntity(n,s+1,r))}return a};o.prototype._generateMockdata=function(e,t){var r=this;var n={};var a=this._getRootUri();jQuery.each(e,function(e,a){var s={};s[a.name]=a;n[e]=r._generateODataMockdataForEntitySet(s,t)[e]});jQuery.each(e,function(e,t){for(var s in t.navprops){var o=t.navprops[s];var i=o.from.propRef.length;for(var u=0;u<i;u++){for(var f=0;f<n[e].length;f++){var c=n[e][f];n[o.to.entitySet][f][o.to.propRef[u]]=c[o.from.propRef[u]]}}}jQuery.each(n[e],function(n,s){s.__metadata={uri:a+e+"("+r._createKeysString(t,s)+")",type:t.schema+"."+t.type};jQuery.each(t.navprops,function(n,o){s[n]={__deferred:{uri:a+e+"("+r._createKeysString(t,s)+")/"+n}}})})});this._oMockdata=n};o.prototype._generateODataMockdataForEntitySet=function(e,t){var r=this,n={};var a=this._findEntityTypes(t);var s=this._findComplexTypes(t);jQuery.each(e,function(e,t){n[e]=r._generateDataFromEntitySet(t,a,s)});return n};o.prototype._resolveNavigation=function(e,t,r){var n=this._mEntitySets[e];var a=n.navprops[r];if(!a){this._logAndThrowMockServerCustomError(404,this._oErrorMessages.RESOURCE_NOT_FOUND)}var s=[];var o=a.from.propRef.length;if(o===0){if(a.to.multiplicity==="*"){return this._oMockdata[a.to.entitySet]}else{s.push(this._oMockdata[a.to.entitySet][0]);return s}}jQuery.each(this._oMockdata[a.to.entitySet],function(e,r){var n=true;for(var i=0;i<o;i++){if(t[a.from.propRef[i]]!==r[a.to.propRef[i]]){n=false;break}}if(n){s.push(r)}});return s};o.prototype.simulate=function(r,s){var i=this;this._sMetadataString=r;if(!s||typeof s==="string"){this._sMockdataBaseUrl=s}else{this._sMockdataBaseUrl=s.sMockdataBaseUrl;this._bGenerateMissingMockData=s.bGenerateMissingMockData;this._aEntitySetsNames=s.aEntitySetsNames}var u=this._loadMetadata(this._sMetadataString);if(!u){return}if(this._sMetadata){var f=a.getServiceAnnotations(this._sMetadata);n.handleDraft(f,this)}this._resetPseudoRandomNumberGenerator();this._refreshData();var c=function(e,t){if(e.requestHeaders["x-csrf-token"]==="Fetch"||e.requestHeaders["X-CSRF-Token"]==="Fetch"){t["X-CSRF-Token"]="42424242424242424242424242424242"}};var d=function(e,t){t=decodeURIComponent(t);var r;var n=i._mEntitySets[e];var a=n.keys;var s=t.split(",");if(s.length!==a.length){i._logAndThrowMockServerCustomError(400,i._oErrorMessages.INVALID_KEY_PREDICATE_QUANTITY)}i._isRequestedKeysValid(n,s);if(s.length===1&&!s[0].split("=")[1]){s=[a[0]+"="+s[0]]}jQuery.each(i._oMockdata[e],function(e,t){for(var o=0;o<s.length;o++){var u=s[o].split("=");var f=i._trim(u[0]);if(!a||a.indexOf(f)===-1){return true}var c=i._trim(u[1]);var d=t[f];switch(n.keysType[f]){case"Edm.String":c=c.replace(/^\'|\'$/g,"");break;case"Edm.Time":case"Edm.DateTime":d=i._getDateTime(d);break;case"Edm.Int16":case"Edm.Int32":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":if(!i._isValidNumber(c)){return false}c=parseFloat(c);break;case"Edm.Guid":c=c.replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":if(["true","false"].indexOf(c)===-1){i._logAndThrowMockServerCustomError(400,i._oErrorMessages.INVALID_KEY_TYPE,f)}c=c==="true";break;case"Edm.Binary":case"Edm.DateTimeOffset":default:}if(d!==c){return true}}r={index:e,entry:t};return false});return r};var p=function(e,t,r){var n=e.name;var a;if(r){a=e.navprops[r]}if(a){n=a.to.entitySet}return n};var l=function(e){var t=[];var r=function(e){var t=e.indexOf("'");var r=e.indexOf('"');if(t===-1&&r===-1){return null}else{if(t>-1&&r===-1){return"appost"}if(r>-1&&t===-1){return"doublequotes"}if(t>-1&&r>-1&&t<r){return"appost"}if(t>-1&&r>-1&&r<t){return"doublequotes"}}};var n=function(e,t,r,n){var a=e[r];var s=r+1;while(s<e.length&&e[s].indexOf(n)===-1){a=a+"&"+e[s];s++}a=a+"&"+e[s];t.push(a);r=s;return r};for(var a=0;a<e.length;a++){if(!r(e[a])){t.push(e[a])}if(r(e[a])==="appost"){var s=e[a].indexOf("'");if(e[a].indexOf("'",s+1)===-1){a=n(e,t,a,"'")}else{t.push(e[a])}}if(r(e[a])==="doublequotes"){var o=e[a].indexOf('"');if(e[a].indexOf('"',o+1)===-1){a=n(e,t,a,'"')}else{t.push(e[a])}}}return t};var h=function(e,t,r,n){r=r?decodeURIComponent(r):r;var a=JSON.parse(e.requestBody);if(a){var s={};if(r){s=i._parseKeys(r,i._mEntitySets[t])}i._completeKey(i._mEntitySets[t],s,a);i._enhanceWithMetadata(i._mEntitySets[t],[a]);return a}return null};var v=[];v.push({method:"GET",path:new RegExp("\\$metadata([?#].*)?"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r={"Content-Type":"application/xml;charset=utf-8"};c(t,r);t.respond(200,r,i._sMetadata);e.debug("MockServer: response sent with: 200, "+i._sMetadata);return true}});v.push({method:"HEAD",path:new RegExp("$"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r={"Content-Type":"application/json;charset=utf-8"};c(t,r);t.respond(200,r);e.debug("MockServer: response sent with: 200");return true}});v.push({method:"GET",path:new RegExp("$"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r={"Content-Type":"application/json;charset=utf-8"};c(t,r);var n=[];jQuery.each(i._mEntitySets,function(e,t){n.push(e)});var a={EntitySets:n};t.respond(200,r,JSON.stringify({d:a}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:a}));return true}});v.push({method:"POST",path:new RegExp("\\$batch([?#].*)?"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r=function(e){switch(e.statusCode){case 200:return"200 OK";case 201:return"201 Created";case 204:return"204 No Content";case 400:return"400 Bad Request";case 401:return"401 Unauthorized";case 403:return"403 Forbidden";case 404:return"404 Not Found";case 405:return"405 Method Not Allowed";case 409:return"409 Conflict";case 412:return"412 Precondition Failed";case 415:return"415 Unsupported Media Type";case 500:return"500 Internal Server Error";case 501:return"501 Not Implemented";case 503:return"503 Service Unavailable";default:return e.statusCode+" "+e.status}};var n=function(e,t){var n;if(e.success){n=JSON.stringify(e.data)||""}else{n=e.errorResponse}t=t||"application/json";if(e.responseHeaders){return"HTTP/1.1 "+r(e)+"\r\n"+e.responseHeaders+"dataserviceversion: 2.0\r\n\r\n"+n+"\r\n"}else{return"HTTP/1.1 "+r(e)+"\r\nContent-Type: "+t+"\r\nContent-Length: "+n.length+"\r\ndataserviceversion: 2.0\r\n\r\n"+n+"\r\n"}};var a=function(e,t,r,a,s){var o;var i=function(e,t,r){o={success:true,data:e,status:t,statusCode:r&&r.status,responseHeaders:r&&r.getAllResponseHeaders()}};var u=function(e,t,r){o={success:false,data:undefined,status:t,error:r,statusCode:e.status,errorResponse:e.responseText,responseHeaders:e&&e.getAllResponseHeaders()}};jQuery.ajax({type:r,async:false,url:e,headers:s,data:t,dataType:"json",success:i,error:u});if(o.statusCode===400||o.statusCode===404){var f=n(o);throw new Error(f)}a.push(n(o))};var s=function(e,t){var r;var a;var s=function(e,t,n){r={success:true,data:e,status:t,statusCode:n&&n.status,responseHeaders:n&&n.getAllResponseHeaders()}};var o=function(e,t,n){r={success:false,data:undefined,status:t,error:n,statusCode:e.status,errorResponse:e.responseText,responseHeaders:e&&e.getAllResponseHeaders()}};jQuery.ajax({async:false,url:e,dataType:"json",success:s,error:o});var a;if(e.indexOf("$count")!==-1){a=n(r,"text/plain")}else{a=n(r)}t.push("\r\nContent-Type: application/http\r\n"+"Content-Length: "+a.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+a)};var o=function(e){var t={};e.split("HTTP/1.1")[1].split("{")[0].split("\n").forEach(function(e){if(e.indexOf(":")!==-1){var r=e.split(":");t[r[0].trim()]=r[1].trim()}});delete t["Content-Length"];return t};var u=t.requestBody;var f=new RegExp("--batch_[a-z0-9-]*");var d=f.exec(u)[0];if(d){var p=[];var l=u.split(d);var h=t.url.split("$")[0];var v=new RegExp("PUT (.*) HTTP");var _=new RegExp("MERGE (.*) HTTP");var E=new RegExp("POST (.*) HTTP");var y=new RegExp("DELETE (.*) HTTP");var g=new RegExp("GET (.*) HTTP");for(var m=1;m<l.length-1;m++){var T=l[m];if(g.test(T)&&T.indexOf("multipart/mixed")===-1){if(v.test(T)||E.test(T)||y.test(T)){t.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");e.debug("MockServer: response sent with: 400");return true}s(h+g.exec(T)[1],p)}else{var S=jQuery.extend(true,{},i._oMockdata);var M=[];var O=T.substring(T.indexOf("boundary=")+9,T.indexOf("\r\n\r\n"));var R=T.split("--"+O);try{for(var k=1;k<R.length-1;k++){var b=R[k];var N;if(g.test(b)){i._oMockdata=S;t.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");e.debug("MockServer: response sent with: 400");return}else{var N=b.substring(b.indexOf("{"),b.lastIndexOf("}")+1),x=o(b),D,P;if(v.test(b)){P="PUT";D=v.exec(b)[1]}else if(_.test(b)){P="MERGE";D=_.exec(b)[1]}else if(E.test(b)){P="POST";D=E.exec(b)[1]}else if(y.test(b)){P="DELETE";N=undefined;D=y.exec(b)[1]}a(h+D,N,P,M,x)}}var I="\r\nContent-Type: multipart/mixed; boundary=ejjeeffe1\r\n\r\n--ejjeeffe1";for(var w=0;w<M.length;w++){I+="\r\nContent-Type: application/http\r\n"+"Content-Length: "+M[w].length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+M[w]+"--ejjeeffe1"}I+="--\r\n";p.push(I)}catch(e){i._oMockdata=S;var A="\r\nContent-Type: application/http\r\n"+"Content-Length: "+e.message.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+e.message;p.push(A)}}}var C="--ejjeeffe0";for(var H=0;H<p.length;H++){C+=p[H]+"--ejjeeffe0"}C+="--";var x={"Content-Type":"multipart/mixed; boundary=ejjeeffe0"};c(t,x);t.respond(202,x,C);e.debug("MockServer: response sent with: 202, "+C)}else{t.respond(202)}return true}});jQuery.each(this._mEntitySets,function(r,n){v.push({method:"GET",path:new RegExp("("+r+")/\\$count/?(.*)?"),response:function(t,r,n){e.debug("MockServer: incoming request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.GET+r+":before",{oXhr:t,sUrlParams:n});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:t,sUrlParams:n});var a={"Content-Type":"text/plain;charset=utf-8"};c(t,a);try{var s=i._oMockdata[r];if(s){var u={results:jQuery.extend(true,[],s)};if(n){var f=decodeURIComponent(n).replace("?","&").split("&");f=l(f);if(f.length>1){f=i._orderQueryOptions(f)}jQuery.each(f,function(e,t){i._applyQueryOnCollection(u,t,r,f)})}i.fireEvent(o.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:u});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:u});t.respond(200,a,""+u.results.length);e.debug("MockServer: response sent with: 200, "+u.results.length)}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,a,JSON.stringify(r))}else{e.error("MockServer: request failed due to invalid system query options value!");t.respond(parseInt(r.message||r.number))}}return true}});v.push({method:"GET",path:new RegExp("("+r+")/?(\\?(.*))?"),response:function(t,r,n){e.debug("MockServer: incoming request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.GET+r+":before",{oXhr:t,sUrlParams:n});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:t,sUrlParams:n});var a={"Content-Type":"application/json;charset=utf-8"};c(t,a);try{var s=i._oMockdata[r];if(s){var u={results:jQuery.extend(true,[],s)};if(n){var f=decodeURIComponent(n).replace("?","&").split("&");f=l(f);if(f.length>1){f=i._orderQueryOptions(f)}jQuery.each(f,function(e,t){i._applyQueryOnCollection(u,t,r,f)})}i.fireEvent(o.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:u});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:u});t.respond(200,a,JSON.stringify({d:u}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:u}))}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,a,JSON.stringify(r))}else{e.debug("MockServer: response sent with: "+parseInt(r.message||r.number));t.respond(parseInt(r.message||r.number))}}return true}});v.push({method:"GET",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(\\?(.*))?"),response:function(r,n,a,s){e.debug("MockServer: incoming request for url: "+r.url);i.fireEvent(o.HTTPMETHOD.GET+n+":before",{oXhr:r,sKeys:a,sUrlParams:s});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:r,sKeys:a,sUrlParams:s});var u={"Content-Type":"application/json;charset=utf-8"};try{var f=jQuery.extend(true,{},d(n,a));if(!t(f)){if(s){var c=decodeURIComponent(s).replace("?","&").split("&");c=l(c);if(c.length>1){c=i._orderQueryOptions(c)}jQuery.each(c,function(e,t){f.entry=i._applyQueryOnEntry(f.entry,t,n)})}i.fireEvent(o.HTTPMETHOD.GET+n+":after",{oXhr:r,oEntry:f.entry});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:r,oEntry:f.entry});r.respond(200,u,JSON.stringify({d:f.entry}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:f.entry}))}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(t){if(t.error){r.respond(t.error.code,u,JSON.stringify(t))}else{e.debug("MockServer: response sent with: "+parseInt(t.message||t.number));r.respond(parseInt(t.message||t.number))}}return true}});jQuery.each(n.navprops,function(t,n){v.push({method:"GET",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/("+t+")/\\$count/?(.*)?"),response:function(t,r,n,a,s){e.debug("MockServer: incoming request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.GET+r+":before",{oXhr:t,sKeys:n,sNavProp:a,sUrlParams:s});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:t,sKeys:n,sNavProp:a,sUrlParams:s});var u={"Content-Type":"text/plain;charset=utf-8"};c(t,u);try{var f=d(r,n);if(f){var p,h={};p=i._resolveNavigation(r,f.entry,a);var v=i._mEntitySets[r].navprops[a].to.multiplicity;if(v==="*"){h={results:jQuery.extend(true,[],p)}}else{h=jQuery.extend(true,{},p[0])}if(p&&p.length!==0){if(s){var _=decodeURIComponent(s).replace("?","&").split("&");_=l(_);if(_.length>1){_=i._orderQueryOptions(_)}if(v==="*"){jQuery.each(_,function(e,t){i._applyQueryOnCollection(h,t,i._mEntitySets[r].navprops[a].to.entitySet,_)})}else{jQuery.each(_,function(e,t){h=i._applyQueryOnEntry(h,t,i._mEntitySets[r].navprops[a].to.entitySet)})}}}i.fireEvent(o.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:h});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:h});h.results=h.results||[];t.respond(200,u,""+h.results.length);e.debug("MockServer: response sent with: 200, "+h.results.length)}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,u,JSON.stringify(r))}else{e.debug("MockServer: response sent with: "+parseInt(r.message||r.number));t.respond(parseInt(r.message||r.number))}}return true}});v.push({method:"GET",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/("+t+")/?(\\?(.*))?"),response:function(t,r,n,a,s){e.debug("MockServer: incoming request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.GET+r+":before",{oXhr:t,sKeys:n,sNavProp:a,sUrlParams:s});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:t,sKeys:n,sNavProp:a,sUrlParams:s});var u={"Content-Type":"application/json;charset=utf-8"};c(t,u);try{var f=d(r,n);if(f){var p,h={};p=i._resolveNavigation(r,f.entry,a,f.entry);var v=i._mEntitySets[r].navprops[a].to.multiplicity;if(v==="*"){h={results:jQuery.extend(true,[],p)}}else{h=jQuery.extend(true,{},p[0])}if(p&&p.length!==0){if(s){var _=decodeURIComponent(s).replace("?","&").split("&");_=l(_);if(_.length>1){_=i._orderQueryOptions(_)}if(v==="*"){jQuery.each(_,function(e,t){i._applyQueryOnCollection(h,t,i._mEntitySets[r].navprops[a].to.entitySet,_)})}else{jQuery.each(_,function(e,t){h=i._applyQueryOnEntry(h,t,i._mEntitySets[r].navprops[a].to.entitySet)})}}}i.fireEvent(o.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:h});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:h});t.respond(200,u,JSON.stringify({d:h}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:h}))}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,u,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}})});v.push({method:"POST",path:new RegExp("("+r+")(\\(([^/\\?#]+)\\)/?(.*)?)?"),response:function(t,r,a,s,u){var f=false;if(t.requestHeaders["x-http-method"]==="MERGE"){f=true}e.debug("MockServer: incoming create request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.POST+r+":before",{oXhr:t,sKeys:s,sNavName:u});i.fireEvent(o.HTTPMETHOD.POST+":before",{oXhr:t,sKeys:s,sNavName:u});var c=null;var l=null;var v=405;try{if(s&&!s.split("=")[1]){s=i._mEntitySets[r].keys[0]+"="+s}var _=p(n,decodeURIComponent(s),u);if(_){var E=h(t,_,s,u);if(E){l={"Content-Type":"application/json;charset=utf-8"};i.fireEvent(o.HTTPMETHOD.POST+r+":after",{oXhr:t,oEntity:E});i.fireEvent(o.HTTPMETHOD.POST+":after",{oXhr:t,oEntity:E});if(f){var y=d(r,s);if(y){jQuery.extend(i._oMockdata[r][y.index],E)}v=204}else{var g=i._getRootUri()+_+"("+i._createKeysString(i._mEntitySets[_],E)+")";c=JSON.stringify({d:E,uri:g});i._oMockdata[_]=i._oMockdata[_].concat([E]);v=201}}}t.respond(v,l,c);e.debug("MockServer: response sent with: "+v+", "+c)}catch(r){if(r.error){var m={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,m,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"PUT",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,a,s){e.debug("MockServer: incoming update request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.PUT+r+":before",{oXhr:t,sKeys:a,sNavName:s});i.fireEvent(o.HTTPMETHOD.PUT+":before",{oXhr:t,sKeys:a,sNavName:s});var u=405;var f=null;var c=null;try{var l=p(n,decodeURIComponent(a),s);if(l){var v=h(t,l,a,s);if(v){c={"Content-Type":"application/json;charset=utf-8"};i.fireEvent(o.HTTPMETHOD.PUT+r+":after",{oXhr:t,oEntity:v});i.fireEvent(o.HTTPMETHOD.PUT+":after",{oXhr:t,oEntity:v});var _=d(r,a);if(_){i._oMockdata[r][_.index]=v}u=204}}t.respond(u,c,f);e.debug("MockServer: response sent with: "+u+", "+f)}catch(r){if(r.error){var E={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,E,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"MERGE",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,a,s){e.debug("MockServer: incoming merge update request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.MERGE+r+":before",{oXhr:t,sKeys:a,sNavName:s});i.fireEvent(o.HTTPMETHOD.MERGE+":before",{oXhr:t,sKeys:a,sNavName:s});var u=405;var f=null;var c=null;try{var l=p(n,decodeURIComponent(a),s);if(l){var v=h(t,l,a,s);if(v){c={"Content-Type":"application/json;charset=utf-8"};i.fireEvent(o.HTTPMETHOD.MERGE+r+":after",{oXhr:t,oEntity:v});i.fireEvent(o.HTTPMETHOD.MERGE+":after",{oXhr:t,oEntity:v});var _=d(r,a);if(_){jQuery.extend(i._oMockdata[r][_.index],v)}u=204}}t.respond(u,c,f);e.debug("MockServer: response sent with: "+u+", "+f)}catch(r){if(r.error){var E={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,E,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"PATCH",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,a,s){e.debug("MockServer: incoming patch update request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.PATCH+r+":before",{oXhr:t,sKeys:a,sNavName:s});i.fireEvent(o.HTTPMETHOD.PATCH+":before",{oXhr:t,sKeys:a,sNavName:s});var u=405;var f=null;var c=null;try{var l=p(n,decodeURIComponent(a),s);if(l){var v=h(t,l,a,s);if(v){c={"Content-Type":"application/json;charset=utf-8"};i.fireEvent(o.HTTPMETHOD.PATCH+r+":after",{oXhr:t,oEntity:v});i.fireEvent(o.HTTPMETHOD.PATCH+":after",{oXhr:t,oEntity:v});var _=d(r,a);if(_){jQuery.extend(i._oMockdata[r][_.index],v)}u=204}}t.respond(u,c,f);e.debug("MockServer: response sent with: "+u+", "+f)}catch(r){if(r.error){var E={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,E,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"DELETE",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,n,a){e.debug("MockServer: incoming delete request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.DELETE+r+":before",{oXhr:t});i.fireEvent(o.HTTPMETHOD.DELETE+":before",{oXhr:t});var s=204;try{var u=d(r,n);if(u){i._oMockdata[r].splice(u.index,1)}else{s=400}i.fireEvent(o.HTTPMETHOD.DELETE+r+":after",{oXhr:t});i.fireEvent(o.HTTPMETHOD.DELETE+":after",{oXhr:t});t.respond(s,null,null);e.debug("MockServer: response sent with: "+s)}catch(r){if(r.error){var f={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,f,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}})});this.setRequests(v)};o.prototype._orderQueryOptions=function(e){var t,r,n,a,s,o,i,u,f,c,d=[];var p=this;jQuery.each(e,function(d,l){var h=e.indexOf(l);switch(l.split("=")[0]){case"$top":a=h;break;case"$skip":n=h;break;case"$orderby":s=h;break;case"$expand":i=h;break;case"$filter":t=h;break;case"$select":o=h;break;case"$inlinecount":r=h;break;case"$format":u=h;break;case"search-focus":c=h;break;case"search":f=h;break;default:if(l.split("=")[0].indexOf("$")===0){p._logAndThrowMockServerCustomError(400,p._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,l.split("=")[0])}}});if(i>=0){d.push(e[i])}if(t>=0){d.push(e[t])}if(c>=0){d.push(e[c])}if(f>=0){d.push(e[f])}if(r>=0){d.push(e[r])}if(s>=0){d.push(e[s])}if(n>=0){d.push(e[n])}if(a>=0){d.push(e[a])}if(o>=0){d.push(e[o])}if(u>=0){d.push(e[u])}return d};o.prototype._removeAllRequestHandlers=function(){var e=this.getRequests();var t=e.length;for(var r=0;r<t;r++){o._removeResponse(e[r].response)}};o.prototype._removeAllFilters=function(){for(var e=0;e<this._aFilters.length;e++){o._removeFilter(this._aFilters[e])}this._aFilters=null};o.prototype._addRequestHandler=function(t,r,n){t=t?t.toUpperCase():t;if(typeof t!=="string"){throw new Error("Error in request configuration: value of 'method' has to be a string")}if(!(typeof r==="string"||r instanceof RegExp)){throw new Error("Error in request configuration: value of 'path' has to be a string or a regular expression")}if(typeof n!=="function"){throw new Error("Error in request configuration: value of 'response' has to be a function")}var a=this._getRootUri();a=a&&new RegExp(this._escapeStringForRegExp(a));if(r&&!(r instanceof RegExp)){r=new RegExp(this._createRegExpPattern(r))}var s=this._createRegExp(a?a.source+r.source:r.source);this._addFilter(this._createFilter(t,s));this._oServer.respondWith(t,s,n);e.debug("MockServer: adding "+t+" request handler for pattern "+s)};o.prototype._createRegExp=function(e){return new RegExp("^"+e+"$")};o.prototype._createRegExpPattern=function(e){return e.replace(/:([\w\d]+)/g,"([^/]+)")};o.prototype._escapeStringForRegExp=function(e){return e.replace(/[\\\/\[\]\{\}\(\)\-\*\+\?\.\^\$\|]/g,"\\$&")};o.prototype._trim=function(e){return e&&e.replace(/^\s+|\s+$/g,"")};o.prototype._isValidNumber=function(e){if(/^([-+]?)0*(\d+)(\.\d+|)([eE][-+]?\d+[d]?|[mldf])?$/i.test(e)){var t=parseFloat(e);return!isNaN(t)&&isFinite(t)}return false};o.prototype._getDateTime=function(e){if(!e){return}return"datetime'"+new Date(Number(e.replace("/Date(","").replace(")/",""))).toJSON().substring(0,19)+"'"};o.prototype._getJsonDate=function(e){if(!e){return}var t=function(e){var t=jQuery.map(e.slice(0,-5).split(/\D/),function(e){return parseInt(e)||0});t[1]-=1;t=new Date(Date.UTC.apply(Date,t));var r=e.slice(-5);var n=parseInt(r)/100;if(r.slice(0,1)==="+"){n*=-1}t.setHours(t.getHours()+n);return t.getTime()};if(e.indexOf("datetimeoffset")>-1){return"/Date("+t(e.substring("datetimeoffset'".length,e.length-1))+")/"}else{return"/Date("+t(e.substring("datetime'".length,e.length-1))+")/"}};o.prototype._addFilter=function(e){this._aFilters.push(e);o._addFilter(e)};o.prototype._createFilter=function(e,t){return function(r,n,a,s,o){return e===r&&t.test(n)}};o.prototype._logAndThrowMockServerCustomError=function(t,r,n){if(r.indexOf("##")>-1&&n){r=r.replace("##","'"+n+"'")}e.error("MockServer: "+r);throw{error:{code:t,message:{lang:"en",value:r}}}};o.prototype.destroy=function(e){r.prototype.destroy.apply(this,arguments);this.stop();var t=o._aServers;var n=t.indexOf(this);t.splice(n,1)};o._aFilters=[];o._oServer=null;o._aServers=[];o._getInstance=function(){if(!this._oServer){this._oServer=window.sinon.fakeServer.create();this._oServer.autoRespond=true}return this._oServer};o.config=function(e){var t=this._getInstance();t.autoRespond=e.autoRespond===false?false:true;t.autoRespondAfter=e.autoRespondAfter||0;t.fakeHTTPMethods=e.fakeHTTPMethods||false};o.respond=function(){this._getInstance().respond()};o.startAll=function(){for(var e=0;e<this._aServers.length;e++){this._aServers[e].start()}};o.stopAll=function(){for(var e=0;e<this._aServers.length;e++){this._aServers[e].stop()}this._getInstance().restore();this._oServer=null};o.destroyAll=function(){this.stopAll();while(this._aServers.length>0){this._aServers[0].destroy()}};o.HTTPMETHOD={GET:"GET",POST:"POST",DELETE:"DELETE",PUT:"PUT",MERGE:"MERGE",PATCH:"PATCH"};o._addFilter=function(e){this._aFilters.push(e)};o._removeFilter=function(e){this._aFilters.splice(this._aFilters.indexOf(e),1)};o._removeResponse=function(e){var t=this._oServer.responses;var r=t.length;for(var n=0;n<r;n++){if(t[n].response===e){t.splice(n,1);return true}}return false};function i(e){var t;Object.assign(e,{async:false,success:function(e,r,n){t={success:true,data:e,status:r,statusCode:n&&n.status}},error:function(e,r,n){t={success:false,data:undefined,status:r,error:n,statusCode:e.status,errorResponse:e.responseText}}});jQuery.ajax(e);return t}o._syncAjax=i;window.sinon.FakeXMLHttpRequest.useFilters=true;window.sinon.FakeXMLHttpRequest.addFilter(function(e,t,r,n,a){var s=o._aFilters;for(var i=0;i<s.length;i++){var u=s[i];if(u(e,t,r,n,a)){return false}}return true});var u=function(e){if(/.*\.json$/i.test(e)){return"JSON"}if(/.*\.xml$/i.test(e)){return"XML"}if(/.*metadata$/i.test(e)){return"XML"}return null};window.sinon.FakeXMLHttpRequest.prototype.respondFile=function(e,t,r){var n=i({url:r,dataType:"text"});if(!n.success){throw new Error("Could not load file from: "+r)}var a=n.data;var s=u(r);if(this["respond"+s]){this["respond"+s](e,t,a)}else{this.respond(e,t,a)}};window.sinon.FakeXMLHttpRequest.prototype.respondJSON=function(e,t,r){t=t||{};t["Content-Type"]=t["Content-Type"]||"application/json";this.respond(e,t,typeof r==="string"?r:JSON.stringify(r))};window.sinon.FakeXMLHttpRequest.prototype.respondXML=function(e,t,r){t=t||{};t["Content-Type"]=t["Content-Type"]||"application/xml";this.respond(e,t,r)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/PasteHelper", ["sap/ui/core/Core","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/base/Log"],function(e,r,n,t){"use strict";var a={};a.getClipboardText=function(e){return typeof e=="string"?e:e.clipboardData.getData("text")};a.getPastedDataAs2DArray=function(e){var r,n,t=[];var a=/sapui5Placeholder4MultiLine/g;var i=a.source;var o=/""/g;var s=this.getClipboardText(e);var l=[];var p=false;var u=s.indexOf('"'),f=-1;var c,h;while(u>-1){h=s.charAt(u-1);if(u===0||h==="\n"||h==="\t"||h==="\r"){f=s.indexOf('"',u+1);if(f>-1){c=s.charAt(f+1);while(f>-1&&c==='"'){f=s.indexOf('"',f+2);c=s.charAt(f+1)}if(c==="\n"||c==="\t"||c===""||c==="\r"){var g=s.substring(u+1,f);s=s.replace('"'+g+'"',i);g=g.replace(o,'"');l.push(g);u=s.indexOf('"',u+i.length+1);p=true}}}if(!p){u=s.indexOf('"',u+1)}p=false}r=s.split(/\r\n|\r|\n/);var v=0;var m=function(){return l[v++]};for(var y=0;y<r.length;y++){n=r[y];if(l.length>0){n=n.replace(a,m)}if(n.length||y<r.length-1){t.push(n.split("\t"))}}return t};a.parse=function(r,n){var t={parsedData:null,errors:null};if(!r){throw new Error("Parameter aData is not specified")}if(n){for(var i=0;i<n.length;i++){var o=n[i];if(o.ignore){continue}if(o.property){if(o.type){var s=o.type;if(s.isA&&s.isA("sap.ui.model.SimpleType")){o.typeInstance=s}else{throw new Error("Data type "+o.type+" is not an instance of any data type")}}else if(o.customParseFunction==undefined){throw new Error("Missing ColumnInfo.type or custom type parse function for column "+(i+1)+". Check the application calling PasteHelper.parse(aData, aColumnInfo) and specify the missing type in the parameter aColumnInfo.")}}else{throw new Error("Missing ColumnInfo.property for column "+(i+1)+". Check the application calling PasteHelper.parse(aData, aColumnInfo) and specify the missing property in the parameter aColumnInfo.")}}}else{throw new Error("Missing parameter aColumnInfo")}var l=[],p=[],u=e.getLibraryResourceBundle();var f=function(e,r){return r.parseValue(e,"string")};var c=function(e,r){return r.validateValue(e)};for(var i=0;i<r.length;i++){var h=r[i];var g=a._parseRow(h,n,i,f,c,u,l);p.push(g)}return Promise.all(p).then(function(e){if(l.length>0){t.parsedData=null;t.errors=l}else{if(e){t.parsedData=e}t.errors=null}return t})};a._parseRow=function(e,r,n,t,i,o,s){var l=[],p={};for(var u=0;u<r.length&&u<e.length;u++){var f=r[u];if(f.ignore){continue}var c=e[u];if(!f.typeInstance){t=f.customParseFunction;i=function(){}}var h=a._parseCell(u,c,f,n,t,i,o,p,s);l.push(h)}return Promise.all(l).then(function(){return p})};a._parseCell=function(e,a,i,o,s,l,p,u,f){return Promise.resolve(a).then(function(e){return s(e,i.typeInstance)}).then(function(e){return Promise.all([e,l(e,i.typeInstance)])}).then(function(e){u[i.property]=e[0]}).catch(function(s){if(s instanceof r||s instanceof n){var l={row:o+1,column:e+1,property:i.property,value:a,type:i.type,message:p.getText("PasteHelper.ErrorMessage",[a,o+1,e+1])+" "+s.message+"\n"};f.push(l);a=null}else{t.error(s)}})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/ResponsivePaddingsEnablement", ["sap/base/Log","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/thirdparty/jquery","sap/ui/core/library"],function(e,i,n,jQuery){"use strict";var s={S:599,M:1023,L:1439};var t={S:"sapUi-Std-PaddingS",M:"sapUi-Std-PaddingM",L:"sapUi-Std-PaddingL",XL:"sapUi-Std-PaddingXL"};var r=function(r){if(!this.isA||!this.isA("sap.ui.core.Control")){e.error("Responsive Paddings enablement could be applied over controls only");return}this._initResponsivePaddingsEnablement=function(){this.addEventDelegate({onAfterRendering:d,onBeforeRendering:a},this)};function a(){u(this)}function d(){var e=c(this,r);if(e.length){window.requestAnimationFrame(function(){o(this)}.bind(this))}}function o(e){f(e);if(!e.__iResponsivePaddingsResizeHandlerId__){e.__iResponsivePaddingsResizeHandlerId__=n.register(e,f.bind(e,e))}}function u(e){if(e.__iResponsivePaddingsResizeHandlerId__){n.deregister(e.__iResponsivePaddingsResizeHandlerId__);e.__iResponsivePaddingsResizeHandlerId__=null}}function f(e,i){var n=c(e,r);var s=l(e,n);var t=i?i.size.width:e.$().width();p(s);v(s,t)}function c(e,i){var n=g(i);n=n.filter(function(i){return e.hasStyleClass(i)});if(!n.length){return[]}n=n.map(function(e){return e.split("--")[1]});n=n.map(function(e){return i[e]}).filter(function(e){return e});return n}function l(e,i){var n=jQuery();i.forEach(function(i){if(i.suffix){n=n.add(e.$(i.suffix))}if(i.selector){n=n.add(e.$().find(i.selector).first())}});return n}function p(e){var n=Object.keys(t).map(function(e){return t[e]});e.each(function(e,s){var t=i.closestTo(s);if(s===t.getDomRef()){n.forEach(t.removeStyleClass.bind(t))}else{jQuery(s).removeClass(n.join(" "))}})}function v(e,n){var r;switch(true){case n<=s.S:r="S";break;case n<=s.M&&n>s.S:r="M";break;case n<=s.L&&n>s.M:r="L";break;default:r="XL";break}e.each(function(e,n){var s=i.closestTo(n);if(n===s.getDomRef()){s.addStyleClass(t[r])}else{jQuery(n).addClass(t[r])}})}function g(e){return Object.keys(e).map(function(e){return"sapUiResponsivePadding--"+e})}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/ShortcutHelper", ["sap/ui/Device","sap/ui/events/jquery/EventExtension"],function(e){"use strict";var t={plus:"+",space:" "};var r={OS:"Meta"};var a={"ctrl+l":"jump to address bar","ctrl+n":"new window, cannot be registered in Chrome","ctrl+shift+n":"new incognito window, cannot be registered in Chrome","ctrl+alt+shift+p":"UI5 Technical Info","ctrl+q":"quit Chrome in Mac","ctrl+alt+shift+s":"UI5 Support Popup","ctrl+t":"new tab, cannot be registered in Chrome","ctrl+shift+t":"reopen last tab, cannot be registered in Chrome","ctrl+w":"close tab, cannot be registered in Chrome","ctrl+shift+w":"close window, cannot be registered in Chrome","ctrl+0":"reset zoom","ctrl+-":"zoom out","ctrl++":"zoom in","ctrl+shift+=":"cannot be handled",tab:"TAB-based keyboard navigation","shift+tab":"TAB-based keyboard navigation","ctrl+tab":"cycling through tabs, cannot be registered in Chrome","ctrl+shift+tab":"cycling through tabs, cannot be registered in Chrome","ctrl+alt+delete":"nice try","ctrl+pageup":"cycling through tabs, cannot be registered in Chrome","ctrl+pagedown":"cycling through tabs, cannot be registered in Chrome",f6:"F6-based group navigation",f11:"fullscreen, cannot be registered in Chrome",f12:"browser dev tools"};var n=false;document.addEventListener("keydown",function(e){try{if(e.keyCode===18){n=typeof e.location!=="number"||e.location===1;return}}catch(e){}});var o={findShortcut:function(e,t){var r=e.data("sap.ui.core.Shortcut");if(!r){return}var a=r.filter(function(e){var r=e.shortcutSpec.key===t.key&&e.shortcutSpec.ctrlKey===t.ctrlKey&&e.shortcutSpec.altKey===t.altKey&&e.shortcutSpec.shiftKey===t.shiftKey&&e.shortcutSpec.metaKey===t.metaKey;return r});return a[0]},getNormalizedShortcutSpec:function(t){var r;if(typeof t==="string"){r=o.parseShortcut(t)}else{var a=t.key;var n=/^([a-z0-9\.,\-\*\/= +]|Tab|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i.test(a);if(!n){throw new Error("Shortcut key '"+a+"' is not a valid shortcut key. It must match /^([a-z0-9.,-*/= +]|Tab|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i")}r={key:o.translateRegisteredKeyToStandard(a).toLowerCase(),ctrlKey:e.os.macintosh?false:!!t.ctrl,ctrlRequested:t.ctrl,altKey:!!t.alt,shiftKey:!!t.shift,metaKey:e.os.macintosh?!!t.ctrl:false}}return r},parseShortcut:function(t){this.validateShortcutString(t);var r=t.toLowerCase().split("+");return{key:o.translateRegisteredKeyToStandard(r.pop()),ctrlKey:e.os.macintosh?false:r.indexOf("ctrl")>-1,ctrlRequested:r.indexOf("ctrl")>-1,altKey:r.indexOf("alt")>-1,shiftKey:r.indexOf("shift")>-1,metaKey:e.os.macintosh?r.indexOf("ctrl")>-1:false}},translateRegisteredKeyToStandard:function(e){return t.hasOwnProperty(e)?t[e]:e},validateShortcutString:function(e){var t=/^((Ctrl|Shift|Alt)\+){0,3}([a-z0-9\.,\-\*\/=]|Plus|Tab|Space|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|Escape|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|F[1-9]|F1[0-2])$/i.test(e);if(!t){throw new Error("Shortcut '"+e+"' is not a valid shortcut string. It must be a '+'-separated list of modifier keys and the actual key, like 'Ctrl+Alt+S'. Or more generally, it must match the expression /^((Ctrl|Shift|Alt)+){0,3}([a-z0-9.,-*/=]|Plus|Tab|Space|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i.")}},validateKeyCombination:function(e){var t=e.ctrlRequested?"ctrl+":"";t+=e.altKey?"alt+":"";t+=e.shiftKey?"shift+":"";t+=e.key;if(a[t]){throw new Error("Registering the shortcut '"+t+"' is not allowed ("+a[t]+").")}if([".",",","-","+","=","*","/"].indexOf(e.key)>-1&&t.indexOf("shift")>-1){throw new Error("Registering the shortcut '"+t+"' is not allowed because the 'Shift' modifier changes the meaning of the "+e.key+" key on many keyboards.")}},getNormalizedShortcutString:function(e){var t=e.ctrlRequested?"ctrl+":"";t+=e.altKey?"alt+":"";t+=e.shiftKey?"shift+":"";t+=e.key;return t},shortcutMayBeUsedHere:function(e,t){var r=t.tagName.toLowerCase();if((r==="input"||r==="textarea")&&e.key.includes("arrow")){return false}return true},handleKeydown:function(e,t,a,i){if(i.key==="Control"||i.key==="Shift"||i.key==="Alt"||i.key==="AltGraph"||i.key==="Meta"){return}if(i.isMarked()){return}if(i.altKey&&!n){return}var s=r.hasOwnProperty(i.key)?r[i.key]:i.key;s=s.toLowerCase();if(s!==e.key||i.ctrlKey!==e.ctrlKey||i.altKey!==e.altKey||i.shiftKey!==e.shiftKey||i.metaKey!==e.metaKey){return}if(!o.shortcutMayBeUsedHere(e,i.target||i.srcElement)){return}i.preventDefault();i.setMarked();i.stopPropagation();var c={registeredShortcut:t,originalBrowserEvent:i.originalEvent||i};a(c)}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/XMLPreprocessor", ["sap/base/Log","sap/base/util/deepExtend","sap/base/util/JSTokenizer","sap/base/util/ObjectPath","sap/ui/base/BindingInfo","sap/ui/base/BindingParser","sap/ui/base/ManagedObject","sap/ui/base/SyncPromise","sap/ui/core/Component","sap/ui/core/XMLTemplateProcessor","sap/ui/model/BindingMode","sap/ui/model/CompositeBinding","sap/ui/model/Context","sap/ui/performance/Measurement"],function(e,t,n,r,i,o,a,u,s,f,l,c,d,g){"use strict";var p="http://schemas.sap.com/sapui5/extension/sap.ui.core.template/1",m="sap.ui.core.util.XMLPreprocessor",h=[m],v=m+"/getResolvedBinding",b=m+"/insertFragment",y=m+".process",x=u.resolve(),w=u.resolve(true),C=Object.prototype.toString,N={},A=a.extend("sap.ui.core.util._with",{metadata:{library:"sap.ui.core",properties:{any:"any"},aggregations:{child:{multiple:false,type:"sap.ui.core.util._with"}}},updateProperty:function(){this.setAny(this.mBindingInfos.any.binding.getExternalValue())}}),M=A.extend("sap.ui.core.util._repeat",{metadata:{library:"sap.ui.core",aggregations:{list:{multiple:true,type:"n/a",_doesNotRequireFactory:true}}},updateList:function(){}});function P(e,t,n,r){function i(t){if(!r){r=e.getBinding("any");if(r instanceof c){r=r.getBindings();if(n!==undefined){r=r[n]}}}return Array.isArray(r)?r[t]:r}function o(e){return e instanceof d?e.getPath():e.getModel().resolve(e.getPath(),e.getContext())}return{_slice:function(e,n){i(0);return!e&&n>=r.length?this:P(null,t,undefined,r.slice(e,n))},getInterface:function(e,n){var o,a,u;if(typeof e==="string"){n=e;e=undefined}i();if(Array.isArray(r)){if(e>=0&&e<r.length){a=r[e]}else{throw new Error("Invalid index of part: "+e)}}else if(e!==undefined){throw new Error("Not the root formatter of a composite binding")}else if(n){a=r}else{throw new Error("Missing path")}if(n){u=a.getModel();if(n.charAt(0)!=="/"){o=a instanceof d?a:u.createBindingContext(a.getPath(),a.getContext())}a=u.createBindingContext(n,o);if(!a){throw new Error("Model could not create binding context synchronously: "+u)}}return P(null,t,undefined,a)},getModel:function(e){var t=i(e);return t&&t.getModel()},getPath:function(e){var t=i(e);return t&&o(t)},getSetting:function(e){if(e==="bindingContexts"||e==="models"){throw new Error("Illegal argument: "+e)}return t[e]}}}function E(e,t,n,r,i){var o=false;function a(t,a){var s=t.formatter,f=t.model,c=e.getModel(f);if(s&&s.requiresIContext===true){s=t.formatter=s.bind(null,P(e,n,a))}if(s&&i&&(c&&c.$$valueAsPromise||a===undefined&&o)){t.formatter=function(){var e=this;return u.all(arguments).then(function(t){return s.apply(e,t)})};t.formatter.textFragments=s.textFragments}t.mode=l.OneTime;t.parameters=t.parameters||{};t.parameters.scope=r;if(i&&c&&c.$$valueAsPromise){o=t.parameters.$$valueAsPromise=true}}try{t.parts.forEach(a);a(t);e.bindProperty("any",t);return u.resolve(e.getAny())}catch(e){return u.reject(e)}finally{e.unbindProperty("any",true)}}function I(e,t){var n=-1;function r(i){if(i){return e[n]}n+=1;if(n<e.length){return t(e[n],n,e).then(r)}}return e.length?r():x}function B(e){var t,n=e.attributes,r="<"+e.nodeName,i,o;for(i=0,o=n.length;i<o;i+=1){t=n.item(i);r+=" "+t.name+'="'+t.value+'"'}return r+(e.childNodes.length?">":"/>")}function F(e,t){return t.visitNode(e)}return{plugIn:function(t,n,r){var i=N[n];if(t!==null&&typeof t!=="function"||t===F){throw new Error("Invalid visitor: "+t)}if(!n||n===p||n==="sap.ui.core"||n.indexOf(" ")>=0){throw new Error("Invalid namespace: "+n)}e.debug("Plug-in visitor for namespace '"+n+"', local name '"+r+"'",t,m);if(r){n=n+" "+r;i=N[n]||i}N[n]=t;return i||F},visitNodeWrapper:F,process:function(a,c,P){var F=c.caller,j=e.isLoggable(e.Level.DEBUG,m),O=j,R=c.name,S={},$,L=0,U={},T=c._supportInfo,q=e.isLoggable(e.Level.WARNING,m);function k(e){return{find:function(e,t){try{return u.resolve(I(e,t))}catch(e){return u.reject(e)}},getContext:function(t){var n,r,i;t=t||"";if(t[0]==="{"){throw new Error("Must be a simple path, not a binding: "+t)}n=o.simpleParser("{"+t+"}");r=e.getModel(n.model);if(!r){throw new Error("Unknown model '"+n.model+"': "+t)}i=r.resolve(n.path,e.getBindingContext(n.model));if(!i){throw new Error("Cannot resolve path: "+t)}return r.createBindingContext(i)},getResult:function(t,n){return G(t,n,e,true)},getSettings:function(){return P},getViewInfo:function(){return t({},c)},insertFragment:function(t,n){return V(t,n,e)},visitAttribute:function(t,n){return oe(t,n,e)},visitAttributes:function(t){return ae(t,e)},visitChildNodes:function(t){return ue(t,e)},visitNode:function(t){try{return se(t,e)}catch(e){return u.reject(e)}},with:function(t,n){var r,i=false,o,a=new A;if(!n){e.setChild(a)}for(o in t){r=t[o];i=true;a.setModel(r.getModel(),o);a.bindObject({model:o,path:r.getPath()})}return i||n?k(a):this}}}function _(t){if(j){e.debug(W()+Array.prototype.slice.call(arguments,1).join(" "),t&&B(t),m)}}function D(t){if(j){e.debug(W()+"Finished","</"+t.nodeName+">",m)}}function X(t,n){t=t+B(n);e.error(t,F,m);throw new Error(F+": "+t)}function J(e){var t,n=Array.prototype.filter.call(e.childNodes,a),r,i,o=false;function a(e){return e.nodeType===1}function u(e,t){return e.namespaceURI===p&&e.localName===t}if(!n.length||!u(n[0],"then")){return null}for(r=1,i=n.length;r<i;r+=1){t=n[r];if(o){X("Expected </"+e.prefix+":if>, but instead saw ",t)}if(u(t,"else")){o=true}else if(!u(t,"elseif")){X("Expected <"+e.prefix+":elseif> or <"+e.prefix+":else>, but instead saw ",n[r])}}return n}function W(){return(L<10?"[ ":"[")+L+"] "}function z(e){return e&&e.charAt(0)==="."?r.get(e.slice(1),U):r.get(e||"",U)||r.get(e||"")}function G(e,t,n,r,a){try{g.average(v,"",h);let s;try{s=o.complexParser(e,U,r,true,true,true,null,!c.sync)}catch(e){return u.reject(e)}let f;if(s){if(!c.sync){if(s.wait){f=u.resolve(s.resolved)}s=s.bindingInfo}if(typeof s==="string"){a?.();return u.resolve(s)}s=i.createProperty(s)}else{a?.();return u.resolve(e)}if(s.functionsNotFound){if(r){fe(t,"Function name(s)",s.functionsNotFound.join(", "),"not found")}return null}const l=s.parts.every(e=>e.value!==undefined||n.getModel(e.model));if(!l){if(r){fe(t,"Binding not ready")}return null}if(!f){const r=E(n,s,P,U,!c.sync);if(c.sync&&r.isPending()){X("Async formatter in sync view in "+e+" of ",t)}return r}return f.then(function(){return E(n,s,P,U,true)})}finally{g.end(v)}}function V(e,t,n){var r,i=c.sync?f.loadTemplate:f.loadTemplatePromise,o=R;n.$mFragmentContexts=n.$mFragmentContexts||{};if(n.$mFragmentContexts[e]){X("Cyclic reference to fragment '"+e+"' ",t)}L++;_(t,"fragmentName =",e);n.$mFragmentContexts[e]=true;R=e;g.average(b,"",h);r=S[e];if(!r){S[e]=r=u.resolve(i(e,"fragment"))}return r.then(function(e){e=t.ownerDocument.importNode(e,true);g.end(b);return Q(e).then(function(){if(e.namespaceURI==="sap.ui.core"&&e.localName==="FragmentDefinition"){return H(e,n,t)}t.parentNode.insertBefore(e,t);return se(e,n)})}).then(function(){t.parentNode.removeChild(t);R=o;n.$mFragmentContexts[e]=false;D(t);L-=1})}function H(e,t,n){return ue(e,t).then(function(){var t;n=n||e;while(t=e.firstChild){n.parentNode.insertBefore(t,n)}})}function K(e,t){var n=fe.bind(null,e,"Constant test condition"),r=G(e.getAttribute("test"),e,t,true,n)||u.resolve(false);return r.catch(function(t){fe(e,"Error in formatter:",t)}).then(function(t){var n=!!t&&t!=="false";if(j){if(typeof t==="string"){t=JSON.stringify(t)}else if(t===undefined){t="undefined"}else if(Array.isArray(t)){t="[object Array]"}_(e,"test ==",t,"--\x3e",n)}return n})}function Q(e){var t={},r=e.getAttributeNodeNS(p,"require"),i,o;function a(){return new u(function(e,t){var n=o.map(sap.ui.require);if(n.every(Boolean)){e(n)}else{sap.ui.require(o,function(){e(arguments)},t)}}).then(function(e){Object.keys(t).forEach(function(t,n){U[t]=e[n]})})}if(r&&r.value){i=r.value;e.removeAttributeNode(r);if(i[0]==="{"){t=n.parseJS(i);o=Object.keys(t).map(function(e){return t[e]});return a()}o=i.split(" ").map(function(e){return e.replace(/\./g,"/")});if(!c.sync){return a()}o.forEach(sap.ui.requireSync)}return x}function Y(e,t,n){var r=G(t.value,e,n,false);if(!r){_(e,"Binding not ready for attribute",t.name);return x}return r.then(function(n){if(n===null||n===undefined){_(e,"Removed attribute",t.name);e.removeAttributeNode(t)}else if(n!==t.value){switch(typeof n){case"boolean":case"number":case"string":_(e,t.name,"=",n);t.value=n;break;default:_(e,"Ignoring",C.call(n),"value for attribute",t.name)}}},function(n){_(e,"Error in formatter of attribute",t.name,n)})}function Z(e,t){var n=e.getAttribute("name"),r,i,o=e.getAttribute("value");if(n&&n[0]==="."){n=n.slice(1)}if(!n||n.includes(".")){X("Missing proper relative name in ",e)}r=z(o);if(!r){X("Invalid value in ",e)}i=U[n];U[n]=r;return H(e,t).then(function(){e.parentNode.removeChild(e);U[n]=i})}function ee(e,t){var n=e.getAttribute("name"),r=G(n,e,t,true);if(!r){return w}return r.then(function(r){var i;if(r!==n){_(e,"name =",r)}i=s.getCustomizing(c.componentId,{extensionName:r,name:R,type:"sap.ui.viewExtensions"});if(i&&i.className==="sap.ui.core.Fragment"&&i.type==="XML"){return V(i.fragmentName,e,t)}return true},function(t){fe(e,"Error in formatter:",t);return true})}function te(e,t){var n=e.getAttribute("fragmentName"),r=G(n,e,t,true);if(!r){return x}return r.then(function(n){var r=U;U=Object.create(U);return V(n,e,t).then(function(){U=r})},function(t){fe(e,"Error in formatter:",t)})}function ne(e,t){L++;return I(J(e)||[e],function(n){if(n.localName==="else"){return w}if(n.localName==="then"){n=e}return K(n,t)}).then(function(n){return(n?H(n,t,e):x).then(function(){e.parentNode.removeChild(e);D(e);L-=1})})}function re(e,t){var n=e.getAttribute("list")||"",r=o.complexParser(n,U,false,true,true,true),i,a,s,f,d,g=e.getAttribute("var");if(g===""){X("Missing variable name for ",e)}if(!r){X("Missing binding for ",e)}if(r.functionsNotFound){fe(e,"Function name(s)",r.functionsNotFound.join(", "),"not found")}f=new M;t.setChild(f);r.mode=l.OneTime;f.bindAggregation("list",r);a=f.getBinding("list");f.unbindAggregation("list",true);s=r.model;if(!a){X("Missing model '"+s+"' in ",e)}a.enableExtendedChangeDetection();i=a.getContexts(r.startIndex,r.length||Infinity);if(!c.sync&&i.dataRequested){d=new u(function(e){a.attachEventOnce("change",e)}).then(function(){return a.getContexts(r.startIndex,r.length)})}else{d=u.resolve(i)}g=g||s;f.setModel(a.getModel(),g);L++;_(e,"Starting");return d.then(function(t){return I(t,function(n,r){var i=r===t.length-1?e:e.cloneNode(true);f.setBindingContext(n,g);_(e,g,"=",n.getPath());return H(i,f,e)}).then(function(){D(e);L-=1;e.parentNode.removeChild(e)})})}function ie(e,t){var n,r,i,a,s=e.getAttribute("helper"),f,l=e.getAttribute("path"),g,p,m=e.getAttribute("var");if(m===""){X("Missing variable name for ",e)}i=new A;t.setChild(i);n=o.simpleParser("{"+l+"}");m=m||n.model;if(s||m){r=t.getModel(n.model);if(!r){X("Missing model '"+n.model+"' in ",e)}p=r.resolve(n.path,t.getBindingContext(n.model));if(!p){X("Cannot resolve path for ",e)}f=r.createBindingContext(p);if(s){a=z(s);if(typeof a!=="function"){X("Cannot resolve helper for ",e)}f=a(f)}g=u.resolve(f);if(c.sync&&g.isPending()){X("Async helper in sync view in ",e)}g=g.then(function(t){if(t instanceof d){r=t.getModel();p=t.getPath()}else if(t!==undefined){if(typeof t!=="string"||t===""){X("Illegal helper result '"+t+"' in ",e)}p=t}i.setModel(r,m);i.bindObject({model:m,path:p})})}else{p=l;i.bindObject(p);g=x}return g.then(function(){L++;_(e,m,"=",p);if(i.getBindingContext(m)===t.getBindingContext(m)){fe(e,"Set unchanged path:",p);i=t}return H(e,i).then(function(){e.parentNode.removeChild(e);D(e);L-=1})})}function oe(e,t,n){if(T){T({context:undefined,env:{caller:"visitAttribute",before:{name:t.name,value:t.value}}})}return Y(e,t,n).then(function(){if(T){T({context:undefined,env:{caller:"visitAttribute",after:{name:t.name,value:t.value}}})}})}function ae(e,t){function n(e,t){return e.name.localeCompare(t.name)}return I(Array.prototype.slice.apply(e.attributes).sort(n),function(n){return oe(e,n,t)})}function ue(e,t){return I(Array.prototype.slice.apply(e.childNodes),function(e){return se(e,t)})}function se(e,t){var n;function r(){return ae(e,t).then(function(){return ue(e,t)}).then(function(){if(T){T({context:e,env:{caller:"visitNode",after:{name:e.tagName}}})}})}if(e.nodeType!==1){return x}if(T){T({context:e,env:{caller:"visitNode",before:{name:e.tagName}}})}if(e.namespaceURI===p){switch(e.localName){case"alias":return Z(e,t);case"if":return ne(e,t);case"repeat":return re(e,t);case"with":return ie(e,t);default:X("Unexpected tag ",e)}}else if(e.namespaceURI==="sap.ui.core"){switch(e.localName){case"ExtensionPoint":return ee(e,t).then(function(e){if(e){return r()}});case"Fragment":if(e.getAttribute("type")==="XML"){return te(e,t)}break}}else{n=N[e.namespaceURI+" "+e.localName]||N[e.namespaceURI];if(n){L++;_(e,"Calling visitor");return n(e,k(t)).then(function(t){if(t!==undefined){X("Unexpected return value from visitor for ",e)}D(e);L-=1})}}return r()}function fe(t){if(q){if(!O){O=true;e.warning("Warning(s) during processing of "+F,null,m)}e.warning(W()+Array.prototype.slice.call(arguments,1).join(" "),t&&B(t),m)}}g.average(y,"",h);P=P||{};if(j){_(undefined,"Start processing",F);if(P.bindingContexts instanceof d){_(undefined,"undefined =",P.bindingContexts)}else{for($ in P.bindingContexts){_(undefined,$,"=",P.bindingContexts[$])}}}if(T){T({context:a,env:{caller:"view",viewinfo:t({},c),settings:t({},P),clone:a.cloneNode(true),type:"template"}})}return Q(a).then(function(){return se(a,new A({models:P.models,bindingContexts:P.bindingContexts}))}).then(function(){_(undefined,"Finished processing",F);g.end(y);return a}).unwrap()}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/reflection/BaseTreeModifier", ["sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectMetadata","sap/ui/util/XMLHelper","sap/ui/core/XMLTemplateProcessor","sap/ui/core/util/XMLPreprocessor","sap/base/util/isPlainObject","sap/base/Log"],function(e,t,n,r,i,o,a){"use strict";return{bySelectorExtensionPointEnabled:function(e,t,n){return Promise.resolve(this.bySelector(e,t,n))},bySelectorTypeIndependent:function(e,t,n){var r;return Promise.resolve().then(function(){if(e&&e.name){n=n||this.bySelector(e.viewSelector,t);return this.getExtensionPointInfo(e.name,n).then(function(e){return e?e.parent:undefined})}r=this.getControlIdBySelector(e,t);return this._byId(r,n)}.bind(this))},bySelector:function(e,t,n){var r=this.getControlIdBySelector(e,t);return this._byId(r,n)},getControlIdBySelector:function(e,t){if(!e){return undefined}if(typeof e==="string"){e={id:e}}var n=e.id;if(e.idIsLocal){if(t){n=t.createId(n)}else{throw new Error("App Component instance needed to get a control's ID from selector")}}return n},getSelector:function(e,t,n){var r=e;if(typeof r!=="string"){r=e?this.getId(e):undefined}else if(!t){throw new Error("App Component instance needed to get a selector from string ID")}if(n&&(n.id||n.idIsLocal)){throw new Error("A selector of control with the ID '"+r+"' was requested, "+"but core properties were overwritten by the additionally passed information.")}var i=this.checkControlId(r,t);if(!i){throw new Error("Generated ID attribute found - to offer flexibility a stable control ID is needed to assign the changes to, but for this control the ID was generated by SAPUI5 "+r)}var o=Object.assign({},n,{id:"",idIsLocal:false});if(this.hasLocalIdSuffix(r,t)){var a=t.getLocalId(r);o.id=a;o.idIsLocal=true}else{o.id=r}return o},checkControlId:function(n,r){var i=n instanceof e?n.getId():n;var o=t.isGeneratedId(i);return!o||this.hasLocalIdSuffix(n,r)},hasLocalIdSuffix:function(t,n){var r=t instanceof e?t.getId():t;if(!n){return false}return!!n.getLocalId(r)},_checkAndPrefixIdsInFragment:function(e,t){var r=n.getParseError(e);if(r.errorCode!==0){return Promise.reject(new Error(e.parseError.reason))}var i=e.documentElement;var o=[],a=[];if(i.localName==="FragmentDefinition"){o=this._getElementNodeChildren(i)}else{o=[i]}a=[].concat(o);function s(e){a.push(e)}var u=Promise.resolve();for(var c=0,f=o.length;c<f;c++){u=u.then(this._traverseXmlTree.bind(this,s,o[c]))}return u.then(function(){for(var e=0,n=a.length;e<n;e++){if(a[e].getAttribute("id")){a[e].setAttribute("id",t+"."+a[e].getAttribute("id"))}else{throw new Error("At least one control does not have a stable ID")}}return i})},_getElementNodeChildren:function(e){var t=[];var n=e.childNodes;for(var r=0,i=n.length;r<i;r++){if(n[r].nodeType===1){t.push(n[r])}}return t},_getControlMetadataInXml:function(e){var t=this._getControlTypeInXml(e).replace(/\./g,"/");var n=sap.ui.require(t);if(n&&n.getMetadata){return Promise.resolve(n.getMetadata())}return new Promise(function(e,n){sap.ui.require([t],function(t){if(t.getMetadata){e(t.getMetadata())}n(new Error("getMetadata function is not available on control type"))},function(){n(new Error("Required control '"+t+"' couldn't be found"))})})},getControlMetadata:function(e){},getLibraryName:function(e){return this.getControlMetadata(e).then(function(e){return e.getLibraryName()})},_getControlTypeInXml:function(e){var t=e.namespaceURI;t=t?t+".":"";t+=e.localName;return t},_traverseXmlTree:function(e,t){function n(t,r,i){return Promise.resolve().then(function(){if(!i){return this._getControlMetadataInXml(r,true)}return undefined}.bind(this)).then(function(e){return e&&e.getAllAggregations()}).then(function(t){var i=this._getElementNodeChildren(r);var o=Promise.resolve();i.forEach(function(i){var a=t&&t[i.localName];o=o.then(function(){return n.call(this,r,i,a).then(function(){if(!a){e(i)}})}.bind(this))}.bind(this));return o}.bind(this))}return n.call(this,t,t,false)},_getSerializedValue:function(e){if(this._isSerializable(e)&&typeof e!=="string"){return JSON.stringify(e)}return e},_isSerializable:function(e){return o(e)||Array.isArray(e)||Object(e)!==e},_escapeCurlyBracketsInString:function(e){return typeof e==="string"?e.replace(/({|})/g,"\\$&"):e},_templateFragment:function(e,t){return Promise.resolve(i.process(r.loadTemplate(e,"fragment"),{name:e},t))},getPropertyBindingOrProperty:function(e,t){var n=this.getPropertyBinding(e,t);if(n){return Promise.resolve(n)}return this.getProperty(e,t)},setPropertyBindingOrProperty:function(e,t,n){var r=n&&(n.path||n.parts);var i=n&&typeof n==="string"&&n.substring(0,1)==="{"&&n.slice(-1)==="}";var o=r||i?"setPropertyBinding":"setProperty";this[o](e,t,n)},setVisible:function(e,t){},getVisible:function(e){},setStashed:function(e,t){},getStashed:function(e){},bindProperty:function(e,t,n){},unbindProperty:function(e,t){},bindAggregation:function(e,t,n){},unbindAggregation:function(e,t){},setProperty:function(e,t,n){},getProperty:function(e,t){},isPropertyInitial:function(e,t){},setPropertyBinding:function(e,t,n){},getPropertyBinding:function(e,t){},createAndAddCustomData:function(e,t,n,r){},getCustomDataInfo:function(e,t){},createControl:function(e,t,n,r,i){},applySettings:function(e,t){},_byId:function(e,t){},getId:function(e){},getParent:function(e){},getControlType:function(e){},setAssociation:function(e,t,n){},getAssociation:function(e,t){},getAllAggregations:function(e){},getAggregation:function(e,t){},insertAggregation:function(e,t,n,r,i,o){},removeAggregation:function(e,t,n){},moveAggregation:function(e,t,n,r,i,o,a,s){},replaceAllAggregation:function(e,t,n){},removeAllAggregation:function(e,t){},getBindingTemplate:function(e,t){},updateAggregation:function(e,t){},findIndexInParentAggregation:function(e){},getParentAggregationName:function(e,t){},findAggregation:function(e,t){},validateType:function(e,t,n,r,i){},instantiateFragment:function(e,t,n){},templateControlFragment:function(e,t,n){},destroy:function(e){},getChangeHandlerModulePath:function(e){return this._getFlexCustomData(e,"flexibility")},_getFlexCustomData:function(e){},getFlexDelegate:function(e){var t;var n=this._getFlexCustomData(e,"delegate");if(typeof n==="string"){try{t=JSON.parse(n);if(t.payload===undefined){t.payload={}}}catch(t){a.error("Flex Delegate for control "+this.getId(e)+" is malformed",t.message)}}return t},attachEvent:function(e,t,n,r,i){},detachEvent:function(e,t,n,r){},getExtensionPointInfo:function(e,t){}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/reflection/JsControlTreeModifier", ["sap/ui/base/BindingParser","./BaseTreeModifier","./XmlTreeModifier","sap/base/util/ObjectPath","sap/ui/util/XMLHelper","sap/base/util/merge","sap/ui/core/Element","sap/ui/core/Fragment"],function(t,e,n,r,i,o,a,s){"use strict";var u={targets:"jsControlTree",setVisible:function(t,e){if(t.setVisible){this.unbindProperty(t,"visible");t.setVisible(e)}else{throw new Error("Provided control instance has no setVisible method")}},getVisible:function(t){if(t.getVisible){return Promise.resolve(t.getVisible())}else{return Promise.reject(new Error("Provided control instance has no getVisible method"))}},setStashed:function(t,e){e=!!e;if(t.unstash){if(t.isStashed()===true&&e===false){t=t.unstash()}if(t.setVisible){this.setVisible(t,!e)}return t}else{throw new Error("Provided control instance has no unstash method")}},getStashed:function(t){if(t.isStashed){if(t.isStashed()){return Promise.resolve(true)}return this.getVisible(t).then(function(t){return!t})}return Promise.reject(new Error("Provided control instance has no isStashed method"))},bindProperty:function(t,e,n){t.bindProperty(e,n)},unbindProperty:function(t,e){if(t){t.unbindProperty(e,true)}},setProperty:function(e,n,r){var i=e.getMetadata().getPropertyLikeSetting(n);var o;var a;this.unbindProperty(e,n);try{o=t.complexParser(r,undefined,true)}catch(t){a=true}if(i){if(this._isSerializable(r)){if(o&&typeof o==="object"||a){r=this._escapeCurlyBracketsInString(r)}var s=i._sMutator;e[s](r)}else{throw new TypeError("Value cannot be stringified","sap.ui.core.util.reflection.JsControlTreeModifier")}}},getProperty:function(t,e){var n=t.getMetadata().getPropertyLikeSetting(e);var r;if(n){var i=n._sGetter;r=t[i]()}return Promise.resolve(r)},isPropertyInitial:function(t,e){return t.isPropertyInitial(e)},setPropertyBinding:function(t,e,n){this.unbindProperty(t,e);var r={};r[e]=n;return t.applySettings(r)},getPropertyBinding:function(t,e){return t.getBindingInfo(e)},createAndAddCustomData:function(t,e,n,r){return this.createControl("sap.ui.core.CustomData",r).then(function(r){this.setProperty(r,"key",e);this.setProperty(r,"value",n);return this.insertAggregation(t,"customData",r,0)}.bind(this))},getCustomDataInfo:function(t,e){var n;if(t.getCustomData){t.getCustomData().some(function(t){if(t.getKey()===e){n=t;return true}return false})}if(n){return{customData:n,customDataValue:n.getValue()}}else{return{}}},createControl:function(t,e,n,r,i){t=t.replace(/\./g,"/");if(this.bySelector(r,e)){var o="Can't create a control with duplicated ID "+(r.id||r);return Promise.reject(o)}var a;var s=sap.ui.require(t);if(s){a=Promise.resolve(s)}else{a=new Promise(function(e,n){sap.ui.require([t],function(t){e(t)},function(){n(new Error("Required control '"+t+"' couldn't be created asynchronously"))})})}return a.then(function(t){var n=this.getControlIdBySelector(r,e);return new t(n,i)}.bind(this))},applySettings:function(t,e){return Promise.resolve(t.applySettings(e))},_byId:function(t){return a.getElementById(t)},getId:function(t){return t.getId()},getParent:function(t){return t.getParent&&t.getParent()},getControlMetadata:function(t){return Promise.resolve(t&&t.getMetadata())},getControlType:function(t){return t&&t.getMetadata().getName()},setAssociation:function(t,e,n){var r=t.getMetadata().getAssociation(e);r.set(t,n)},getAssociation:function(t,e){var n=t.getMetadata().getAssociation(e);return n.get(t)},getAllAggregations:function(t){return Promise.resolve(t.getMetadata().getAllAggregations())},getAggregation:function(t,e){return this.findAggregation(t,e).then(function(e){if(e){return t[e._sGetter]()}return undefined})},insertAggregation:async function(t,e,n,r){if(e==="customData"){t.insertAggregation(e,n,r,true);return}const i=await this.findAggregation(t,e);if(i){if(i.multiple){const e=r||0;t[i._sInsertMutator](n,e)}else{t[i._sMutator](n)}}},removeAggregation:async function(t,e,n){if(e==="customData"){t.removeAggregation(e,n,true);return}const r=await this.findAggregation(t,e);if(r){t[r._sRemoveMutator](n)}},moveAggregation:async function(t,e,n,r,i,o){let a;let s;if(e==="customData"){t.removeAggregation(e,i,true)}else{a=await this.findAggregation(t,e)}if(r==="customData"){n.insertAggregation(r,i,o,true)}else{s=await this.findAggregation(n,r)}if(a&&s){t[a._sRemoveMutator](i);if(s.multiple){n[s._sInsertMutator](i,o)}else{n[s._sMutator](i)}}},replaceAllAggregation:async function(t,e,n){const r=await this.findAggregation(t,e);t[r._sRemoveAllMutator]();n.forEach((e,n)=>{t[r._sInsertMutator](e,n)})},removeAllAggregation:function(t,e){if(e==="customData"){t.removeAllAggregation(e,true);return Promise.resolve()}return this.findAggregation(t,e).then(function(e){if(e){t[e._sRemoveAllMutator]()}})},getBindingTemplate:function(t,e){var n=t.getBindingInfo(e);return Promise.resolve(n&&n.template)},updateAggregation:function(t,e){return this.findAggregation(t,e).then(function(n){if(n&&t.getBinding(e)){t[n._sDestructor]();t.updateAggregation(e)}})},findIndexInParentAggregation:function(t){var e=this.getParent(t);if(!e){return Promise.resolve(-1)}return this.getParentAggregationName(t).then(function(t){return this.getAggregation(e,t)}.bind(this)).then(function(e){if(Array.isArray(e)){return e.indexOf(t)}else{return 0}})},getParentAggregationName:function(t){return Promise.resolve(t.sParentAggregationName)},findAggregation:function(t,e){return new Promise(function(n,r){if(t){if(t.getMetadata){var i=t.getMetadata();var o=i.getAllAggregations();if(o){n(o[e]);return}}}n()})},validateType:function(t,e,n,r){var i=e.type;return this.getAggregation(n,e.name).then(function(n){if(e.multiple===false&&n&&n.length>0){return false}return t.isA(i)})},instantiateFragment:function(t,e,n){var r=i.parse(t);return this._checkAndPrefixIdsInFragment(r,e).then(function(t){return s.load({definition:t,sId:n&&n.getId(),controller:n.getController()})}).then(function(t){if(t&&!Array.isArray(t)){t=[t]}return t||[]})},templateControlFragment:function(t,n,r){return e._templateFragment(t,n).then(function(t){var e=r&&r.getController()||undefined;return s.load({definition:t,controller:e})})},destroy:function(t,e){t.destroy(e)},_getFlexCustomData:function(t,e){var n=typeof t==="object"&&typeof t.data==="function"&&t.data("sap-ui-custom-settings");return r.get(["sap.ui.fl",e],n)},attachEvent:function(t,e,n,r,i){return new Promise(function(n,o){if(typeof i!=="function"){o(new Error("Can't attach event: fnCallback parameter missing or not a function"))}n(t.attachEvent(e,r,i))})},detachEvent:function(t,e,n,r){return new Promise(function(n,i){if(typeof r!=="function"){i(new Error("Can't detach event: fnCallback parameter missing or not a function"))}n(t.detachEvent(e,r))})},bindAggregation:function(t,e,n){return Promise.resolve(t.bindAggregation(e,n))},unbindAggregation:function(t,e){return Promise.resolve(t.unbindAggregation(e))},getExtensionPointInfo:function(t,e){var r=e._xContent?e._xContent:e;return n.getExtensionPointInfo(t,r).then(function(t){if(t){t.index--;t.parent=t.parent&&this._byId(e.createId(t.parent.getAttribute("id")));t.defaultContent=t.defaultContent.map(function(t){var n=e.createId(t.getAttribute("id"));return this._byId(n)}.bind(this)).filter(function(t){return!!t})}return t}.bind(this))}};return o({},e,u)},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/reflection/XmlTreeModifier", ["./BaseTreeModifier","sap/ui/base/ManagedObject","sap/ui/base/DataType","sap/base/util/merge","sap/ui/util/XMLHelper","sap/ui/core/mvc/EventHandlerResolver","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/core/Fragment"],function(e,t,n,r,i,o,a,u,g){"use strict";var s="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";async function f(e,t,n,r,i,o,a){let u;if(!a){const n=e.namespaceURI;u=await this.createControl(n+"."+t,undefined,i);e.appendChild(u)}else{u=a}if(!o){const e=u.children;let t=0;const n=r<e.length?r:e.length;for(let r=0;r<n;r++){if(e[r].namespaceURI==="sap.ui.core"&&e[r].tagName.includes("ExtensionPoint")){t=t+1-e[r].children.length}}r=r+t}if(r>=u.childElementCount){u.appendChild(n)}else{const t=await this._getControlsInAggregation(e,u);u.insertBefore(n,t[r])}return undefined}var c=r({},e,{targets:"xmlTree",setVisible:function(e,t){if(t){e.removeAttribute("visible")}else{e.setAttribute("visible",t)}},getVisible:function(e){return c.getProperty(e,"visible")},setStashed:function(e,t){if(!t){e.removeAttribute("stashed")}else{e.setAttribute("stashed",t)}c.setVisible(e,!t)},getStashed:function(e){return Promise.all([c.getProperty(e,"stashed"),c.getProperty(e,"visible")]).then(function(e){return!!e[0]||!e[1]})},bindProperty:function(e,t,n){e.setAttribute(t,"{"+n+"}")},unbindProperty:function(e,t){e.removeAttribute(t)},_setProperty:function(e,t,n,r){var i=c._getSerializedValue(n);if(r){i=c._escapeCurlyBracketsInString(i)}e.setAttribute(t,i)},setProperty:function(e,t,n){c._setProperty(e,t,n,true)},getProperty:function(e,r){var i;var o;var a=e.getAttribute(r);return c.getControlMetadata(e).then(function(t){i=t.getProperty(r);if(i){o=i.getType();if(r==="value"&&c.getControlType(e)==="sap.ui.core.CustomData"){return c.getProperty(e,"key").then(function(e){if(e==="sap-ui-custom-settings"){o=n.getType("object")}})}}return undefined}).then(function(){if(i){if(a===null){a=i.getDefaultValue()||o.getDefaultValue()}else{var e=t.bindingParser(a,undefined,true);if(u(e)){if(e.path||e.parts){a=undefined}else{a=e}}else{a=o.parseValue(e||a)}}}return a})},isPropertyInitial:function(e,t){var n=e.getAttribute(t);return n==null},setPropertyBinding:function(e,t,n){if(typeof n!=="string"){throw new Error("For XML, only strings are supported to be set as property binding.")}e.setAttribute(t,n)},getPropertyBinding:function(e,n){var r=e.getAttribute(n);if(r){var i=t.bindingParser(r,undefined,true);if(i&&(i.path||i.parts)){return i}}return undefined},createAndAddCustomData:function(e,t,n){e.setAttributeNS(s,"custom.data.via.modifier:"+t,c._escapeCurlyBracketsInString(n));return Promise.resolve()},getCustomDataInfo:function(e,t){var n=e.attributes["custom.data.via.modifier:"+t];if(n){return{customData:n,customDataValue:n.value}}else{return{}}},createControl:function(e,t,n,r,i,o){var a,u,g;if(!c.bySelector(r,t,n)){var s=e.split(".");var f="";if(s.length>1){u=s.pop();f=s.join(".")}var l=n.ownerDocument.createElementNS(f,u);a=c.getControlIdBySelector(r,t);if(a){l.setAttribute("id",a)}return Promise.resolve().then(function(){if(i){return c.applySettings(l,i)}return undefined}).then(function(){return Promise.resolve(l)})}else{g=new Error("Can't create a control with duplicated ID "+a);return Promise.reject(g)}},applySettings:function(e,t){return c.getControlMetadata(e).then(function(n){var r=n.getJSONKeys();Object.keys(t).forEach(function(n){var i=r[n];var o=t[n];switch(i._iKind){case 0:c._setProperty(e,n,o,false);break;case 3:c.setAssociation(e,n,o);break;default:throw new Error("Unsupported in applySettings on XMLTreeModifier: "+n)}})})},_byId:function(e,t){if(t){if(t.ownerDocument&&t.ownerDocument.getElementById&&t.ownerDocument.getElementById(e)){return t.ownerDocument.getElementById(e)}return t.querySelector("[id='"+e+"']")}return undefined},getId:function(e){return e.getAttribute("id")},getParent:function(e){var t=e.parentNode;if(t&&!c.getId(t)&&!c._isExtensionPoint(t)){t=t.parentNode}return t},_getLocalName:function(e){return e.localName||e.baseName||e.nodeName},getControlType:function(e){return c._getControlTypeInXml(e)},setAssociation:function(e,t,n){if(typeof n!=="string"){n=c.getId(n)}e.setAttribute(t,n)},getAssociation:function(e,t){return e.getAttribute(t)},getAllAggregations:function(e){return c.getControlMetadata(e).then(function(e){return e.getAllAggregations()})},getAggregation:function(e,t){var n=[];var r;return c._isSingleValueAggregation(e,t).then(function(n){r=n;return c._findAggregationNode(e,t)}).then(function(i){if(i){return c._getControlsInAggregation(e,i).then(function(e){n=e})}return c._isAltTypeAggregation(e,t).then(function(i){if(i&&r){return c.getProperty(e,t).then(function(e){n.push(e)})}return undefined})}).then(function(){if(t==="customData"){var i;var o=Array.prototype.slice.call(e.attributes).reduce(function(t,n){var r=c._getLocalName(n);if(n.namespaceURI===s){var o=e.ownerDocument.createElementNS("sap.ui.core","CustomData");o.setAttribute("key",r);o.setAttribute("value",n.value);t.push(o)}else if(n.namespaceURI&&n.name.indexOf("xmlns:")!==0){if(!i){i={}}if(!i.hasOwnProperty(n.namespaceURI)){i[n.namespaceURI]={}}i[n.namespaceURI][r]=n.nodeValue}return t},[]);n=n.concat(o);if(i){var a=e.ownerDocument.createElementNS("sap.ui.core","CustomData");a.setAttribute("key","sap-ui-custom-settings");c.setProperty(a,"value",i);n.push(a)}}return r?n[0]:n})},insertAggregation:async function(e,t,n,r,i,o){const a=await c._findAggregationNode(e,t);return f.call(this,e,t,n,r,i,o,a)},removeAggregation:async function(e,t,n){const r=await c._findAggregationNode(e,t);r.removeChild(n)},moveAggregation:async function(e,t,n,r,i,o,a,u){const g=await c._findAggregationNode(e,t);const s=await c._findAggregationNode(n,r);g.removeChild(i);await f.call(this,n,r,i,o,a,u,s)},replaceAllAggregation:async function(e,t,n){const r=await c._findAggregationNode(e,t);const i=await c._getControlsInAggregation(e,r);i.forEach(function(e){r.removeChild(e)});n.forEach(e=>{r.appendChild(e)})},removeAllAggregation:function(e,t){return c._findAggregationNode(e,t).then(function(t){if(e===t){return c._getControlsInAggregation(e,e).then(function(t){t.forEach(function(t){e.removeChild(t)})})}return e.removeChild(t)})},_findAggregationNode:function(e,t){var n;var r=c._children(e);for(var i=0;i<r.length;i++){var o=r[i];if(o.localName===t){n=o;break}}var a=Promise.resolve(n);if(!n){a=a.then(c._isDefaultAggregation.bind(c,e,t)).then(function(t){if(t){return e}return n})}return a},_isDefaultAggregation:function(e,t){return c.getControlMetadata(e).then(function(e){var n=e.getDefaultAggregation();return n&&t===n.name})},_isNotNamedAggregationNode:function(e,t){return c.getAllAggregations(e).then(function(n){var r=n[t.localName];return e.namespaceURI!==t.namespaceURI||!r})},_isSingleValueAggregation:function(e,t){return c.getAllAggregations(e).then(function(e){var n=e[t];return!n.multiple})},_isAltTypeAggregation:function(e,t){return c.getControlMetadata(e).then(function(e){return e.getAllAggregations()[t]}).then(function(e){return!!e.altTypes})},_isExtensionPoint:function(e){return c._getControlTypeInXml(e)==="sap.ui.core.ExtensionPoint"},getControlMetadata:function(e){return c._getControlMetadataInXml(e)},_getControlsInAggregation:function(e,t){var n=Array.prototype.slice.call(c._children(t));return Promise.all(n.map(function(t){return c._isNotNamedAggregationNode(e,t).then(function(e){return e?t:undefined})})).then(function(e){return e.filter(function(e){return!!e})})},_children:function(e){if(e.children){return e.children}else{var t=[];for(var n=0;n<e.childNodes.length;n++){var r=e.childNodes[n];if(r.nodeType===r.ELEMENT_NODE){t.push(r)}}return t}},getBindingTemplate:function(e,t){return c._findAggregationNode(e,t).then(function(e){if(e){var t=c._children(e);if(t.length===1){return t[0]}}return undefined})},updateAggregation:function(e,t){},findIndexInParentAggregation:function(e){var t=c.getParent(e);if(!t){return Promise.resolve(-1)}return c.getParentAggregationName(e,t).then(function(e){return c.getAggregation(t,e)}).then(function(t){if(Array.isArray(t)){var n=t.map(function(e){return Promise.resolve().then(function(){if(c._isExtensionPoint(e)){return e}return c.getProperty(e,"stashed").then(function(t){return!t?e:undefined})})});return Promise.all(n).then(function(t){return t.filter(function(e){return!!e}).indexOf(e)})}else{return 0}})},getParentAggregationName:function(e,t){return Promise.resolve().then(function(){if(!t.isSameNode(e.parentNode)){return false}else{return c._isNotNamedAggregationNode(t,e)}}).then(function(n){if(n){return c.getControlMetadata(t).then(function(e){return e.getDefaultAggregationName()})}else{return c._getLocalName(e.parentNode)}})},findAggregation:function(e,t){return c.getControlMetadata(e).then(function(e){return e.getAllAggregations()}).then(function(e){if(e){return e[t]}return undefined})},validateType:function(e,t,n,r,i){var o=t.type;return c.getAggregation(n,t.name).then(function(e){if(t.multiple===false&&e&&e.length>0){return false}return g.load({definition:r})}).then(function(e){if(!Array.isArray(e)){e=[e]}var t=e[i].isA(o);e.forEach(function(e){e.destroy()});return t})},instantiateFragment:function(e,t,n){var r=i.parse(e);return c._checkAndPrefixIdsInFragment(r,t).then(function(e){var t;if(e.localName==="FragmentDefinition"){t=c._getElementNodeChildren(e)}else{t=[e]}t.forEach(function(e){if(c._byId(e.getAttribute("id"),n)){throw Error("The following ID is already in the view: "+e.getAttribute("id"))}});return t})},templateControlFragment:function(t,n){return e._templateFragment(t,n).then(function(e){return c._children(e)})},destroy:function(e){var t=e.parentNode;if(t){t.removeChild(e)}},_getFlexCustomData:function(e,t){if(!e){return undefined}return e.getAttributeNS("sap.ui.fl",t)},attachEvent:function(e,t,n,r,i){if(typeof i!=="function"){return Promise.reject(new Error("Can't attach event: fnCallback parameter missing or not a function"))}return c.getProperty(e,t).then(function(i){i=i||"";var a=o.parse(i);var u=n;var g=["$event"];if(r){g.push(JSON.stringify(r))}u+="("+g.join(",")+")";if(!a.includes(u)){a.push(u)}e.setAttribute(t,a.join(";"))})},detachEvent:function(e,t,n,r){if(typeof r!=="function"){return Promise.reject(new Error("Can't detach event: fnCallback parameter missing or not a function"))}return c.getProperty(e,t).then(function(r){r=r||"";var i=o.parse(r);var a=i.findIndex(function(e){return e.includes(n)});if(a>-1){i.splice(a,1)}if(i.length){e.setAttribute(t,i.join(";"))}else{e.removeAttribute(t)}})},bindAggregation:function(e,t,n,r){return Promise.resolve().then(function(){c.bindProperty(e,t,n.path);return c.insertAggregation(e,t,n.template,0,r)})},unbindAggregation:function(e,t){return Promise.resolve().then(function(){if(e.hasAttribute(t)){e.removeAttribute(t);return c.removeAllAggregation(e,t)}return undefined})},getExtensionPointInfo:function(e,t){return Promise.resolve().then(function(){if(t&&e){var n=Array.prototype.slice.call(t.getElementsByTagNameNS("sap.ui.core","ExtensionPoint"));var r=n.filter(function(t){return t.getAttribute("name")===e});var i=r.length===1?r[0]:undefined;if(i){var o=c.getParent(i);return Promise.all([c.getParentAggregationName(i,o),c.findIndexInParentAggregation(i)]).then(function(e){var t={parent:o,aggregationName:e[0],index:e[1]+1,defaultContent:Array.prototype.slice.call(c._children(i))};return t})}}return undefined})}});return c},true);
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/serializer/HTMLViewSerializer", ["sap/ui/base/EventProvider","./Serializer","./delegate/HTML","sap/ui/thirdparty/vkbeautify"],function(e,t,i,r){"use strict";var n=e.extend("sap.ui.core.util.serializer.HTMLViewSerializer",{constructor:function(t,i,r,n){e.apply(this);this._oView=t;this._oWindow=i;this._fnGetControlId=r;this._fnGetEventHandlerName=n}});n.prototype.serialize=function(){var e=this;var n=function(t){return t?.isA?.("sap.ui.core.mvc.View")&&t!==e._oView};var o=new t(this._oView,new i(this._fnGetControlId,this._fnGetEventHandlerName),true,this._oWindow,n);var a=o.serialize();var s=[];s.push("<template");if(this._oView.getControllerName&&this._oView.getControllerName()){s.push(' data-controller-name="'+this._oView.getControllerName()+'"')}s.push(" >");s.push(a);s.push("</template>");return r.xml(s.join(""))};return n});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/serializer/Serializer", ["sap/ui/base/EventProvider","sap/base/assert"],function(e,t){"use strict";var i=e.extend("sap.ui.core.util.serializer.Serializer",{constructor:function(t,i,r,s,a,n){e.apply(this);this._oRootControl=t;this._delegate=i;this._bSkipRoot=!!r;this._oWindow=s||globalThis;this._fnSkipAggregations=a;this._fnSkipElement=n}});i.prototype.serialize=function(){return this._serializeRecursive(this._oRootControl,0)};i.prototype._serializeRecursive=function(e,i,r,s){t(typeof e!=="undefined","The control must not be undefined");var a=[];var n=!this._bSkipRoot||i!==0;if(n){var o=this._delegate.start(e,r,s);var g=this._delegate.middle(e,r,s);a.push(o+g)}var l=e.getMetadata().getAllAggregations();if(l){for(var h in l){if(this._fnSkipAggregations&&this._fnSkipAggregations(e,h)){continue}var u=[];var f=l[h];var p=e[f._sGetter]();if(e.getBindingPath(h)&&e.getBindingInfo(h).template){u.push(e.getBindingInfo(h).template)}else if(p&&p.length){for(var _=0;_<p.length;_++){var d=p[_];if(this._isObjectSerializable(d)){u.push(d)}}}else if(this._isObjectSerializable(p)){u.push(p)}if(u.length>0){if(n){a.push(this._delegate.startAggregation(e,h))}var v=this._isDefaultAggregation(e,h);for(var c=0;c<u.length;c++){a.push(this._serializeRecursive(u[c],i+1,h,v))}if(n){a.push(this._delegate.endAggregation(e,h))}}}}if(n){var b=this._delegate.end(e,r,s);a.push(b)}return a.join("")};i.prototype._isObjectSerializable=function(e){return!!e?.isA?.("sap.ui.core.Element")&&!(this._fnSkipElement&&this._fnSkipElement(e))};i.prototype._isDefaultAggregation=function(e,t){return e.getMetadata().getDefaultAggregationName()===t};return i});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/serializer/ViewSerializer", ["sap/ui/base/EventProvider","./HTMLViewSerializer","./XMLViewSerializer","sap/base/assert","sap/ui/base/DesignTime"],function(e,i,t,r,s){"use strict";var o=e.extend("sap.ui.core.util.serializer.ViewSerializer",{constructor:function(i,t,r){e.apply(this);this._oRootControl=i;this._oWindow=t||globalThis;this._mViews={};this._sDefaultXmlNamespace=r}});o.prototype.serializeToXML=function(){return this.serialize("XML")};o.prototype.serializeToHTML=function(){return this.serialize("HTML")};o.prototype.serialize=function(e){this._mViews={};this._sConvertToViewType=e||undefined;return this._serializeRecursive(this._oRootControl)};o.prototype._getViewType=function(e){if(!this._sConvertToViewType){if(e?.isA?.("sap.ui.core.mvc.HTMLView")){return"HTML"}if(e?.isA?.("sap.ui.core.mvc.XMLView")){return"XML"}}return this._sConvertToViewType};o.prototype._serializeRecursive=function(e){r(typeof e!=="undefined","The control must not be undefined");var i=this._oWindow.sap.ui.require("sap/ui/core/UIArea");var t=this._oWindow.sap.ui.require("sap/ui/core/ComponentContainer");if(e?.isA?.("sap.ui.core.mvc.View")){var s=this._getViewSerializer(e,this._getViewType(e));if(s){var o=e.getViewName()||e.getControllerName();if(!this._mViews[o]){this._mViews[o]=s.serialize(this._getViewType(e))}}}if(e.getMetadata().getClass()===i){var n=e.getContent();for(var a=0;a<n.length;a++){this._serializeRecursive(n[a])}}else if(e.getMetadata().getClass()===t){this._serializeRecursive(e.getComponentInstance().getRootControl())}else{var u=e.getMetadata().getAllAggregations();if(u){for(var l in u){var p=u[l];var c=e[p._sGetter]();if(c&&c.length){for(var a=0;a<c.length;a++){var f=c[a];if(f?.isA?.("sap.ui.core.Element")){this._serializeRecursive(f)}}}else if(c?.isA?.("sap.ui.core.Element")){this._serializeRecursive(c)}}}}return this._mViews};o.prototype._getViewSerializer=function(e,r){var o=function(i){if(i.fFunction&&i.fFunction._sapui_handlerName){var t=i.fFunction._sapui_handlerName;var r=e.getController();if(r[t]||s.isControllerCodeDeactivated()){return t}}};var n=function(i){if(i._sapui_controlId){return i._sapui_controlId}return i.getId().replace(e.createId(""),"")};if(r==="HTML"){return new i(e,this._oWindow,n,o)}if(r==="XML"){return new t(e,this._oWindow,this._sDefaultXmlNamespace,n,o)}else{var a=e?e.constructor:"?";throw Error("View type '"+a+"' is not supported for conversion. Only HTML and XML is supported")}};return o});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/serializer/XMLViewSerializer", ["sap/ui/base/EventProvider","./Serializer","./delegate/XML","sap/ui/thirdparty/vkbeautify"],function(e,i,t,r){"use strict";var s=e.extend("sap.ui.core.util.serializer.XMLViewSerializer",{constructor:function(i,t,r,s,a){e.apply(this);this._oView=i;this._oWindow=t;this._sDefaultNamespace=r;this._fnGetControlId=s;this._fnGetEventHandlerName=a}});s.prototype.serialize=function(){var e=[];var s=function(i,t){if(!t){var r=i?i.constructor:"?";throw Error("Controls with empty package are currently not supported by the XML serializer: "+r)}if(e.indexOf(t)===-1){e.push(t)}};var a=this;var o=function(e){return e?.isA?.("sap.ui.core.mvc.View")&&e!==a._oView};var n=new i(this._oView,new t(this._sDefaultNamespace,this._fnGetControlId,this._fnGetEventHandlerName,s),true,this._oWindow,o);var u=n.serialize();var l=[];l.push("<sap.ui.core.mvc:View");if(this._oView.getControllerName&&this._oView.getControllerName()){l.push(' controllerName="'+this._oView.getControllerName()+'"')}if(e.indexOf("sap.ui.core.mvc")===-1){e.push("sap.ui.core.mvc")}for(var h=0;h<e.length;h++){if(this._sDefaultNamespace&&this._sDefaultNamespace===e[h]){l.push(' xmlns="'+e[h]+'"')}else{l.push(" xmlns:"+e[h]+'="'+e[h]+'"')}}l.push(" >");l.push(u);l.push("</sap.ui.core.mvc:View>");return r.xml(l.join(""))};return s});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/serializer/delegate/Delegate", ["sap/ui/base/EventProvider"],function(t){"use strict";var e=t.extend("sap.ui.core.util.serializer.delegate.Delegate",{constructor:function(){t.apply(this)}});e.prototype.start=function(t,e,r){return""};e.prototype.middle=function(t,e,r){return""};e.prototype.end=function(t,e,r){return""};e.prototype.startAggregation=function(t,e){return""};e.prototype.endAggregation=function(t,e){return""};return e});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/serializer/delegate/HTML", ["./Delegate","sap/base/strings/hyphenate","sap/base/util/deepEqual"],function(t,e,r){"use strict";var i=t.extend("sap.ui.core.util.serializer.delegate.HTML",{constructor:function(e,r){t.apply(this);this._fnGetControlId=e;this._fnGetEventHandlerName=r}});i.prototype.startAggregation=function(t,e){return'<div data-sap-ui-aggregation="'+e+'">'};i.prototype.endAggregation=function(t,e){return"</div>"};i.prototype.start=function(t,e,r){return"<div"};i.prototype.middle=function(t,e,i){var a=[];var n=this._fnGetControlId?this._fnGetControlId(t):t.getId();if(n.indexOf("__")!==0){a.push(this._createAttribute("id",n))}a.push(this._createAttribute("data-sap-ui-type",t.getMetadata()._sClassName));if(t.aCustomStyleClasses){var s=t.aCustomStyleClasses;var u=[];for(var o=0;o<s.length;o++){var l=s[o];if(!l.startsWith("sapM")&&!l.startsWith("sapUi")){u.push(l)}}if(u.length>0){a.push(this._createAttribute("class",u.join(" ")))}}if(this._fnGetEventHandlerName){var g=t.getMetadata().getAllEvents();for(var p in g){if(t.hasListeners(p)){var f=t.mEventRegistry[p];for(var o=0;o<f.length;o++){var d=this._fnGetEventHandlerName(f[o]);if(d){a.push(this._createAttribute("data-"+this._createHtmlAttributeName(p),d));break}}}}}var c=t.getMetadata().getAllAssociations();this._createAttributes(a,t,c,function(t,e){if(c[t].multiple){return e.join(" ")}return e},function(t,e){return e!==null&&e!==""});var h=t.getMetadata().getAllProperties();var v=t.getMetadata().getPropertyDefaults();this._createAttributes(a,t,h,null,function(t,e){return!r(e,v[t])});var _=t.getMetadata().getAllAggregations();this._createAttributes(a,t,_,null,function(e,r){if(!t.getBindingInfo(e)&&(!r||typeof r!=="string")){return false}return true});a.push(">");return a.join("")};i.prototype.end=function(t,e,r){return"</div>"};i.prototype._createAttributes=function(t,e,r,i,a){for(var n in r){var s=r[n];var u=s._sGetter;if(e[u]){var o=e[u]();o=i?i(n,o):o;if(!e.getBindingInfo(n)){if(!a||a(n,o)){t.push(this._createAttribute("data-"+this._createHtmlAttributeName(n),o))}}else{t.push(this._createDataBindingAttribute(e,n,o))}}}};i.prototype._createDataBindingAttribute=function(t,e,r){var i=t.getBindingInfo(e);var a=null;var n=r;if(!i.bindingString){if(i.binding){var s=i.binding.getMetadata().getName();if(s==="sap.ui.model.PropertyBinding"||s==="sap.ui.model.resource.ResourcePropertyBinding"){a=i.binding.getValue()}}if(i.parts){i=i.parts[0]}var u=i.model;if(a===r||a===null){n="{"+(u?u+">"+i.path:i.path)+"}"}}else{n=i.bindingString}return this._createAttribute("data-"+this._createHtmlAttributeName(e),n)};i.prototype._createAttribute=function(t,e){return" "+t+'="'+e+'"'};i.prototype._createHtmlAttributeName=function(t){return e(t)};return i});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/serializer/delegate/XML", ["./Delegate","sap/base/util/deepEqual","sap/base/security/encodeXML"],function(t,e,r){"use strict";var a=t.extend("sap.ui.core.util.serializer.delegate.XML",{constructor:function(e,r,a,i){t.apply(this);this._sDefaultNamespace=e;this._fnGetControlId=r;this._fnMemorizePackage=i;this._fnGetEventHandlerName=a}});a.prototype.startAggregation=function(t,e){return"<"+this._createAggregationName(t,e)+">"};a.prototype.endAggregation=function(t,e){return"</"+this._createAggregationName(t,e)+">"};a.prototype.start=function(t,e,r){return"<"+this._createTagName(t)};a.prototype.end=function(t,e,r){return"</"+this._createTagName(t)+">"};a.prototype.middle=function(t,r,a){var i=[];var n=this._fnGetControlId?this._fnGetControlId(t):t.getId();if(n.indexOf("__")!==0){i.push(this._createAttribute("id",n))}if(t.aCustomStyleClasses){var s=t.aCustomStyleClasses;var o=[];for(var u=0;u<s.length;u++){var g=s[u];if(!g.startsWith("sapM")&&!g.startsWith("sapUi")){o.push(g)}}if(o.length>0){i.push(this._createAttribute("class",o.join(" ")))}}if(this._fnGetEventHandlerName){var f=t.getMetadata().getAllEvents();for(var c in f){if(t.hasListeners(c)){var l=t.mEventRegistry[c];for(var u=0;u<l.length;u++){var p=this._fnGetEventHandlerName(l[u]);if(p){i.push(this._createAttribute(c,p));break}}}}}var d=t.getMetadata().getAllAssociations();this._createAttributes(i,t,d,function(t,e){if(d[t].multiple){return e.join(" ")}return e},function(t,e){return e!==null&&e!==""});var h=t.getMetadata().getAllProperties();var v=t.getMetadata().getPropertyDefaults();this._createAttributes(i,t,h,null,function(t,r){return!e(r,v[t])});var _=t.getMetadata().getAllAggregations();this._createAttributes(i,t,_,null,function(e,r){if(!t.getBindingInfo(e)&&(!r||typeof r!=="string")){return false}return true});i.push(">");return i.join("")};a.prototype._createAttributes=function(t,e,r,a,i){for(var n in r){var s=r[n];var o=s._sGetter;if(e[o]){var u=e[o]();u=a?a(n,u):u;if(!e.getBindingInfo(n)){if(!i||i(n,u)){t.push(this._createAttribute(n,u))}}else{t.push(this._createDataBindingAttribute(e,n,u))}}}};a.prototype._createDataBindingAttribute=function(t,e,r){var a=t.getBindingInfo(e);var i=null;var n=r;if(!a.bindingString){if(a.binding){var s=a.binding.getMetadata().getName();if(s==="sap.ui.model.PropertyBinding"||s==="sap.ui.model.resource.ResourcePropertyBinding"){i=a.binding.getValue()}}if(a.parts){a=a.parts[0]}var o=a.model;if(i===r||i===null){n="{"+(o?o+">"+a.path:a.path)+"}"}}else{n=a.bindingString}return this._createAttribute(e,n)};a.prototype._createAttribute=function(t,e){var a=typeof e==="string"||e instanceof String?r(e):e;return" "+t+'="'+a+'"'};a.prototype._createTagName=function(t){var e=t.getMetadata()._sClassName;var r=e.lastIndexOf(".");var a=r===-1?e:e.substring(r+1);var i=r===-1?e:e.substring(0,r);if(this._fnMemorizePackage){this._fnMemorizePackage(t,i)}return this._createNamespace(i,a)};a.prototype._createAggregationName=function(t,e){var r=t.getMetadata()._sClassName;var a=r.lastIndexOf(".");var i=a===-1?r:r.substring(0,a);return this._createNamespace(i,e)};a.prototype._createNamespace=function(t,e){if(this._sDefaultNamespace&&this._sDefaultNamespace===t){return e}else{return t+":"+e}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/webc/WebComponent", ["../Control","../Element","./WebComponentMetadata","./WebComponentRenderer","sap/base/strings/hyphenate","sap/base/strings/camelize","../library","../LabelEnablement"],function(t,e,n,r,o,i,a,s){"use strict";var p=a.TextDirection;var u=function(t){if(t.id&&e.getElementById(t.id)){return e.getElementById(t.id)}};var f=function(t,e,n){if(e===undefined){e=0}if(n===undefined){n=2}if(t==null){return t}if(t instanceof window.HTMLElement){var r=u(t);return r?r:t}if(e<n){if(Array.isArray(t)){return t.map(f,e+1,n)}if(typeof t==="object"){var o={};for(var i in t){if(t.hasOwnProperty(i)){o[i]=f(t[i],e+1,n)}}return o}}return t};var d=t.extend("sap.ui.core.webc.WebComponent",{metadata:{stereotype:"webcomponent",abstract:true,library:"sap.ui.core",properties:{__isBusy:{type:"boolean",visibility:"hidden",defaultValue:false,mapping:{type:"property",to:"__is-busy"}}}},constructor:function(e,n){t.apply(this,arguments);this.__busyIndicatorTimeout=null;this.__onInvalidationBound=this.__onInvalidation.bind(this);this.__handleCustomEventBound=this.__handleCustomEvent.bind(this);this.__delegates={onBeforeRendering:this.__onBeforeRenderingDelegate,onAfterRendering:this.__onAfterRenderingDelegate};this.addDelegate(this.__delegates,true,this,false)},renderer:r},n);d.prototype._setSlot=function(t,e){var n=["tooltip","customData","layoutData","dependents","dragDropConfig"];if(t&&!n.includes(e)){var r=this.getMetadata().getAggregationSlot(e);t.__slot=r}};d.prototype._unsetSlot=function(t){if(t){delete t.__slot}};d.prototype.setAggregation=function(e,n,r){var o=t.prototype.setAggregation.apply(this,arguments);this._setSlot(n,e);return o};d.prototype.insertAggregation=function(e,n,r,o){var i=t.prototype.insertAggregation.apply(this,arguments);this._setSlot(n,e);return i};d.prototype.addAggregation=function(e,n,r){var o=t.prototype.addAggregation.apply(this,arguments);this._setSlot(n,e);return o};d.prototype.removeAggregation=function(e,n,r){var o=t.prototype.removeAggregation.apply(this,arguments);this._unsetSlot(o);return o};d.prototype.removeAllAggregation=function(e,n){var r=t.prototype.removeAllAggregation.apply(this,arguments);r.forEach(function(t){this._unsetSlot(t)},this);return r};d.prototype.__onBeforeRenderingDelegate=function(){this.__detachCustomEventsListeners()};d.prototype.__onAfterRenderingDelegate=function(){this.__attachCustomEventsListeners();var t=this.getDomRef();this.__updateObjectProperties(t);window.customElements.whenDefined(t.localName).then(function(){if(typeof t.attachInvalidate==="function"){t.attachInvalidate(this.__onInvalidationBound)}if(t._individualSlot){this.__slot=t._individualSlot}}.bind(this))};d.prototype.__updateObjectProperties=function(t){var e=this.getMetadata().getPropertiesByMapping("property");for(var n in e){if(this.isPropertyInitial(n)){continue}var r=e[n];var o=r.get(this);if(r.type==="object"||typeof o==="object"){var i=r._sMapTo?r._sMapTo:n;t[i]=o}}};d.prototype.setBusy=function(t){var e=this.getBusy();this.setProperty("busy",t,true);if(e!==t){if(t){this.__busyIndicatorTimeout=setTimeout(function(){this.setProperty("__isBusy",t)}.bind(this),this.getBusyIndicatorDelay())}else{this.setProperty("__isBusy",t);clearTimeout(this.__busyIndicatorTimeout)}}return this};d.prototype.__onInvalidation=function(t){if(t.type==="property"){var e=t.name;var n=t.newValue;var r=this.getMetadata().getProperty(e);if(r){this.setProperty(e,n,true)}}};d.prototype.__attachCustomEventsListeners=function(){var t=this.getMetadata().getEvents();for(var e in t){var n=o(e);this.getDomRef().addEventListener(n,this.__handleCustomEventBound)}};d.prototype.__detachCustomEventsListeners=function(){var t=this.getDomRef();if(!t){return}var e=this.getMetadata().getEvents();for(var n in e){if(e.hasOwnProperty(n)){var r=o(n);t.removeEventListener(r,this.__handleCustomEventBound)}}};d.prototype.__handleCustomEvent=function(t){var e=t.type;var n=i(e);var r=this.__formatEventData(t.detail);var o=this.getMetadata().getEvent(n);var a=!o.fire(this,r);if(a){t.preventDefault()}};d.prototype.__formatEventData=function(t){if(typeof t==="object"){return f(t)}return{}};d.prototype.__callPublicMethod=function(t,n){if(!this.getDomRef()){throw new Error("Method called before custom element has been created by: "+this.getId())}var r=Array.from(n).map(function(t){if(t instanceof e){return t.getDomRef()}return t});var o=this.getDomRef()[t].apply(this.getDomRef(),r);if(typeof o==="object"){o=f(o)}return o};d.prototype.__callPublicGetter=function(t){if(!this.getDomRef()){throw new Error("Getter called before custom element has been created by: "+this.getId())}var e=this.getDomRef()[t];if(typeof e==="object"){e=f(e)}return e};d.prototype.destroy=function(){var e=this.getDomRef();this.__detachCustomEventsListeners();if(e&&typeof e.detachInvalidate==="function"){e.detachInvalidate(this.__onInvalidationBound)}return t.prototype.destroy.apply(this,arguments)};d.prototype._mapEnabled=function(t){return!t};d.prototype._mapTextDirection=function(t){if(t===p.Inherit){return null}return t.toLowerCase()};d.prototype._getAriaLabelledByForRendering=function(t){var e=s.getReferencingLabels(this);if(Array.isArray(t)){t.forEach(function(t){if(e.indexOf(t)<0){e.unshift(t)}})}return e.join(" ")};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/webc/WebComponentMetadata", ["../ElementMetadata","./WebComponentRenderer","sap/base/strings/camelize"],function(t,r,e){"use strict";var o=["property","style","textContent","slot","none"];var p=function(r,e){t.apply(this,arguments)};p.prototype=Object.create(t.prototype);p.prototype.constructor=p;var i=function(t){return o.includes(t)?t:o[0]};var a=t.prototype.metaFactoryProperty;var n=function(t,r,e){a.apply(this,arguments);if(!e.mapping||typeof e.mapping==="string"){this._sMapping=i(e.mapping)}else if(typeof e.mapping==="object"){this._sMapping=i(e.mapping.type);this._sMapTo=e.mapping.to;this._fnMappingFormatter=e.mapping.formatter}};n.prototype=Object.create(a.prototype);n.prototype.constructor=n;p.prototype.metaFactoryProperty=n;var s=t.prototype.metaFactoryAggregation;var c=function(t,r,e){s.apply(this,arguments);this._sSlot=e.slot||""};c.prototype=Object.create(s.prototype);c.prototype.constructor=c;p.prototype.metaFactoryAggregation=c;var g=t.prototype.metaFactoryAssociation;var y=function(t,r,e){g.apply(this,arguments);if(!e.mapping||typeof e.mapping!=="object"){this._sMapping=""}else{this._sMapping="property";this._sMapTo=e.mapping.to;this._fnMappingFormatter=e.mapping.formatter}};y.prototype=Object.create(g.prototype);y.prototype.constructor=y;p.prototype.metaFactoryAssociation=y;p.prototype.applySettings=function(r){var e=r.metadata;this._sTag=e.tag;this._aMethods=e.methods||[];this._aGetters=e.getters||[];t.prototype.applySettings.call(this,r)};p.prototype.generateAccessors=function(){t.prototype.generateAccessors.call(this);var r=this.getClass().prototype;this._aMethods.forEach(function(t){if(!r[t]){r[t]=function(){return this.__callPublicMethod(t,arguments)}}});this._aGetters.forEach(function(t){var e="get"+t.substr(0,1).toUpperCase()+t.substr(1);if(!r[e]){r[e]=function(){return this.__callPublicGetter(t)}}})};p.prototype.getTag=function(){return this._sTag};p.prototype.getMethods=function(){return this._aMethods};p.prototype.getGetters=function(){return this._aGetters};p.prototype.getAggregationSlot=function(t){var r=this._mAllAggregations[t];return r?r._sSlot:undefined};p.prototype.isManagedAttribute=function(t){var r=this.getAllProperties();for(var o in r){if(r.hasOwnProperty(o)){var p=r[o];if(p._sMapping==="property"&&(p._sMapTo===t||e(t)===o)){return true}}}var i=this.getAllAssociations();for(var a in i){if(i.hasOwnProperty(a)){var n=i[a];if(n._sMapping==="property"&&n._sMapTo===e(t)){return true}}}return false};p.prototype.getPropertiesByMapping=function(t){var r={};var e=this.getAllProperties();var o=this.getAllPrivateProperties();for(var p in e){if(e.hasOwnProperty(p)){var i=e[p];if(i._sMapping===t){r[p]=i}}}for(var p in o){if(o.hasOwnProperty(p)){var i=o[p];if(i._sMapping===t){r[p]=i}}}return r};p.prototype.getAssociationsWithMapping=function(){var t={};var r=this.getAllAssociations();for(var e in r){if(r.hasOwnProperty(e)){var o=r[e];if(o._sMapping){t[e]=o}}}return t};p.prototype.getRenderer=function(){if(this._oRenderer){return this._oRenderer}return r};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/webc/WebComponentRenderer", ["../Element","../Control","sap/base/strings/hyphenate"],function(t,e,r){"use strict";var a={apiVersion:2};a.render=function(t,e){var r=e.getMetadata().getTag();t.openStart(r,e);this.renderAttributeProperties(t,e);this.renderStyleProperties(t,e);this.renderAssociationProperties(t,e);this.renderTooltipAggregation(t,e);this.customRenderInOpeningTag(t,e);this.preserveUnmanagedAttributes(t,e);this.preserveUnmanagedStyles(t,e);t.openEnd();this.renderTextContentProperties(t,e);this.renderSlotProperties(t,e);this.renderAggregations(t,e);this.customRenderInsideTag(t,e);t.close(r)};a.renderAttributeProperties=function(t,e){var a=e.getMetadata().getPropertiesByMapping("property");var n=["enabled"];for(var i in a){if(e.isPropertyInitial(i)&&!n.includes(i)){continue}var o=a[i];var s=o.get(e);if(o.type==="object"||typeof s==="object"){continue}var p=o._sMapTo?o._sMapTo:r(i);if(o._fnMappingFormatter){s=e[o._fnMappingFormatter].call(e,s)}if(o.type==="boolean"){if(s){t.attr(p,"")}}else{if(s!=null){t.attr(p,s)}}}};a.preserveUnmanagedAttributes=function(t,e){var r=e.getDomRef();if(!r){return}var a=r.getAttributeNames();var n=["id","data-sap-ui","style","class","__is-busy"];a.forEach(function(a){if(n.indexOf(a)!==-1){return}if(e.getMetadata().isManagedAttribute(a)){return}var i=r.getAttribute(a);if(i!==null){t.attr(a,i)}})};a.preserveUnmanagedStyles=function(t,e){var a=e.getDomRef();if(!a){return}var n=Array.prototype.slice.apply(a.style);if(n.length===0){return}var i=e.getMetadata().getPropertiesByMapping("style");var o=[];for(var s in i){var p=i[s];var g=p._sMapTo?p._sMapTo:r(s);o.push(g)}n.forEach(function(e){if(o.indexOf(e)!==-1){return}var r=e.startsWith("--")?window.getComputedStyle(a).getPropertyValue(e):a.style[e];t.style(e,r)})};a.renderStyleProperties=function(t,e){var a=e.getMetadata().getPropertiesByMapping("style");for(var n in a){var i=a[n];var o=i._sMapTo?i._sMapTo:r(n);var s=i.get(e);if(i._fnMappingFormatter){s=e[i._fnMappingFormatter].call(e,s)}if(s!=null){t.style(o,s)}}};a.renderAssociationProperties=function(t,e){var a=e.getMetadata().getAssociationsWithMapping();for(var n in a){var i=a[n];var o=i.get(e);var s=r(i._sMapTo);if(i._fnMappingFormatter){o=e[i._fnMappingFormatter].call(e,o)}if(!i.multiple&&o&&typeof o==="object"){o=o.getId()}if(o){t.attr(s,o)}}};a.renderTooltipAggregation=function(t,e){var r=e.getTooltip_Text();if(r){t.attr("tooltip",r)}};a.renderTextContentProperties=function(t,e){var r=e.getMetadata().getPropertiesByMapping("textContent");for(var a in r){var n=r[a];var i=n.get(e);if(n._fnMappingFormatter){i=e[n._fnMappingFormatter].call(e,i)}t.text(i)}};a.renderSlotProperties=function(t,e){var r=e.getMetadata().getPropertiesByMapping("slot");for(var a in r){var n=r[a];var i=n.get(e);if(n._fnMappingFormatter){i=e[n._fnMappingFormatter].call(e,i)}var o=n._sMapTo?n._sMapTo:"span";if(i){t.openStart(o);t.attr("slot",a);t.openEnd();t.text(i);t.close(o)}}};a.renderAggregations=function(r,a){var n=a.getMetadata().getAllAggregations();for(var i in n){if(t.getMetadata().getAggregations().hasOwnProperty(i)||e.getMetadata().getAggregations().hasOwnProperty(i)){continue}var o=n[i];var s=o.get(a);if(o.multiple){s.forEach(r.renderControl,r)}else{if(s){r.renderControl(s)}}}};a.customRenderInOpeningTag=function(t,e){};a.customRenderInsideTag=function(t,e){};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ws/ReadyState", function(){"use strict";var e={CONNECTING:0,OPEN:1,CLOSING:2,CLOSED:3};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ws/SapPcpWebSocket", ["./WebSocket","sap/base/Log"],function(e,t){"use strict";var r=e.extend("sap.ui.core.ws.SapPcpWebSocket",{constructor:function(t,r){e.apply(this,arguments)}});r.SUPPORTED_PROTOCOLS={v10:"v10.pcp.sap.com"};r._deserializeRegexp=/((?:[^:\\]|(?:\\.))+):((?:[^:\\\n]|(?:\\.))*)/;r._SEPARATOR="\n\n";r._MESSAGE="MESSAGE";r.prototype._onopen=function(){var e=false;if(this.getProtocol()===""){e=true}else{for(var i in r.SUPPORTED_PROTOCOLS){if(r.SUPPORTED_PROTOCOLS.hasOwnProperty(i)){if(r.SUPPORTED_PROTOCOLS[i]===this.getProtocol()){e=true;break}}}}if(e){this.fireOpen()}else{t.error("Unsupported protocol '"+this.getProtocol()+"' selected by the server. "+"Connection will be closed.");this.close("Unsupported protocol selected by the server")}};r.prototype._onmessage=function(e){var i=-1,n={};if(typeof e.data==="string"){i=e.data.indexOf(r._SEPARATOR)}if(i!==-1){n.pcpFields=this._extractPcpFields(e.data.substring(0,i));n.data=e.data.substr(i+r._SEPARATOR.length)}else{t.warning("Invalid PCP message received: "+e.data);n.pcpFields={};n.data=e.data}this.fireMessage(n)};r.prototype._extractPcpFields=function(e){var t=e.split("\n"),i=[],n={};for(var o=0;o<t.length;o++){i=t[o].match(r._deserializeRegexp);if(i&&i.length===3){n[this._unescape(i[1])]=this._unescape(i[2])}}return n};r.prototype._unescape=function(e){var t=e.split("\b"),r="";for(var i=0;i<t.length;i++){t[i]=t[i].replace(/\\\\/g,"\b").replace(/\\:/g,":").replace(/\\n/g,"\n").replace(/\u0008/g,"\\")}r=t.join("\b");return r};r.prototype._serializePcpFields=function(e,t,r){var i="",n="",o="";if(t==="string"){o="text"}else if(t==="blob"||t==="arraybuffer"){o="binary"}if(e&&typeof e==="object"){for(n in e){if(e.hasOwnProperty(n)&&n.indexOf("pcp-")!==0){i+=this._escape(n)+":"+this._escape(String(e[n]))+"\n"}}}return"pcp-action:"+r+"\npcp-body-type:"+o+"\n"+i+"\n"};r.prototype._escape=function(e){return e.replace(/\\/g,"\\\\").replace(/:/g,"\\:").replace(/\n/g,"\\n")};r.prototype.send=function(t,i){var n=typeof t,o="";o=this._serializePcpFields(i,n,r._MESSAGE);e.prototype.send.call(this,o+t);return this};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ws/WebSocket", ["sap/ui/Device","sap/ui/base/EventProvider","./ReadyState","sap/ui/thirdparty/URI","sap/base/Log"],function(t,e,o,n,s){"use strict";var r=e.extend("sap.ui.core.ws.WebSocket",{constructor:function(o,n){e.apply(this);if(!t.support.websocket){throw new Error("Browser does not support WebSockets.")}if(typeof o!=="string"){throw new Error("sUrl must be a string.")}if(typeof n!=="undefined"&&!Array.isArray(n)&&typeof n!=="string"){throw new Error("aProtocols must be a string, array of strings or undefined.")}this._openConnection(o,n)},metadata:{publicMethods:["send","close","getReadyState","getProtocol"]}});r.prototype.getInterface=function(){return this};r.M_EVENTS={Open:"open",Close:"close",Error:"error",Message:"message"};r.prototype.attachOpen=function(t,e,o){this.attachEvent("open",t,e,o);return this};r.prototype.detachOpen=function(t,e){this.detachEvent("open",t,e);return this};r.prototype.fireOpen=function(t){this.fireEvent("open",t);return this};r.prototype.attachClose=function(t,e,o){this.attachEvent("close",t,e,o);return this};r.prototype.detachClose=function(t,e){this.detachEvent("close",t,e);return this};r.prototype.fireClose=function(t){this.fireEvent("close",t);return this};r.prototype.attachError=function(t,e,o){this.attachEvent("error",t,e,o);return this};r.prototype.detachError=function(t,e){this.detachEvent("error",t,e);return this};r.prototype.fireError=function(t){this.fireEvent("error",t);return this};r.prototype.attachMessage=function(t,e,o){this.attachEvent("message",t,e,o);return this};r.prototype.detachMessage=function(t,e){this.detachEvent("message",t,e);return this};r.prototype.fireMessage=function(t){this.fireEvent("message",t);return this};r.prototype._resolveFullUrl=function(t){var e=new n(t);var o=new n(document.baseURI);o.search("");o.protocol(o.protocol()==="https"?"wss":"ws");e=e.absoluteTo(o);return e.toString()};r.prototype._openConnection=function(t,e){t=this._resolveFullUrl(t);this._oWs=typeof e==="undefined"?new window.WebSocket(t):new window.WebSocket(t,e);this._oWs.onopen=this._onopen.bind(this);this._oWs.onclose=this._onclose.bind(this);this._oWs.onmessage=this._onmessage.bind(this);this._oWs.onerror=this._onerror.bind(this)};r.prototype._onopen=function(){this.fireOpen()};r.prototype._onclose=function(t){this.fireClose({code:t.code,reason:t.reason,wasClean:t.wasClean})};r.prototype._onerror=function(t){this.fireError()};r.prototype._onmessage=function(t){this.fireMessage({data:t.data})};r.prototype.send=function(t){if(this.getReadyState()===o.OPEN){this._oWs.send(t)}else if(this.getReadyState()===o.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.send(t)})}else{s.warning("Unable to send WebSocket message. "+"Connection is already closed or closing. message: "+t)}return this};r.prototype.close=function(t,e){if(typeof t==="string"){e=t;t=undefined}t=typeof t==="undefined"?1e3:t;e=typeof e==="undefined"?"":e;if(this.getReadyState()===o.OPEN){this._oWs.close(t,e)}else if(this.getReadyState()===o.CONNECTING){this.attachEventOnce("open",function(o){this._oWs.close(t,e)})}else{var n="";switch(this.getReadyState()){case o.CLOSED:n="Connection is already closed.";break;case o.CLOSING:n="Connection is already closing.";break}s.warning("Unable to close WebSocket connection. "+n)}return this};r.prototype.getReadyState=function(){return this._oWs.readyState};r.prototype.getProtocol=function(){return this._oWs.protocol};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/containsOrEquals", [],function(){"use strict";var n=function(n,t){if(t&&n&&t!=document&&t!=window){return n.contains(t)}return false};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/denormalizeScrollBeginRTL", ["sap/ui/util/_FeatureDetection"],function(i){"use strict";var t;if(i.initialScrollPositionIsZero()){t=function(i,t){return-i}}else{t=function(i,t){return t.scrollWidth-t.clientWidth-i}}var n=function(i,n){if(n){return t(i,n)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/denormalizeScrollLeftRTL", ["sap/ui/util/_FeatureDetection"],function(i){"use strict";var t;if(i.initialScrollPositionIsZero()){t=function(i,t){return t.clientWidth+i-t.scrollWidth}}else{t=function(i,t){return i}}var n=function(i,n){if(n){return t(i,n)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/getFirstEditableInput", ["sap/ui/thirdparty/jquery","sap/ui/dom/isHidden"],function(jQuery,t){"use strict";function e(t,e){var n="textarea[readonly],input[type=hidden],input[type=button],input[type=submit],input[type=reset],input[type=image],button",i=":enabled:visible:first";if(e){return jQuery(t).find("input, textarea").not(n).filter(i)[0]}else{return jQuery(t).find("input, textarea").not("input[readonly],"+n).filter(i)[0]}}function n(n,i){var u;if(!n||t(n)){return null}if(i){u=i.includeReadOnly}return e(n,u)}return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/getOwnerWindow", [],function(){"use strict";var n=function n(e){if(e.ownerDocument.parentWindow){return e.ownerDocument.parentWindow}return e.ownerDocument.defaultView};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/getScrollbarSize", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var i={};var e=function(e,t){if(typeof e==="boolean"){t=e;e=null}var r=e||"#DEFAULT";if(t){if(e){delete i[e]}else{i={}}}if(i[r]){return i[r]}if(!document.body){return{width:0,height:0}}var s=jQuery("<DIV></DIV>").css("visibility","hidden").css("height","0").css("width","0").css("overflow","hidden");if(e){s.addClass(e)}s.prependTo(document.body);var d=jQuery("<div></div>");d[0].style="visibility:visible;position:absolute;height:100px;width:100px;overflow:scroll;opacity:0;";s.append(d);var o=d.get(0);var h=o.offsetWidth-o.scrollWidth;var l=o.offsetHeight-o.scrollHeight;s.remove();if(h===0||l===0){return{width:h,height:l}}i[r]={width:h,height:l};return i[r]};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/isBehindOtherElement", ["sap/base/Log"],function(e){"use strict";function t(t){if(!t){return false}var n=t.getBoundingClientRect(),i=n.left+1,o=n.right-1,r=n.top+1,m=n.bottom-1;if(i<0||o<0||r<0||m<0){e.warning("isBehindOtherElement :: Element with id "+t.id+" is outside the visible viewport, cannot determine whether it is behind another DOM element",this);return false}if(document.elementFromPoint(i,r)!==t&&!t.contains(document.elementFromPoint(i,r))){return true}if(document.elementFromPoint(o,r)!==t&&!t.contains(document.elementFromPoint(o,r))){return true}if(document.elementFromPoint(i,m)!==t&&!t.contains(document.elementFromPoint(i,m))){return true}if(document.elementFromPoint(o,m)!==t&&!t.contains(document.elementFromPoint(o,m))){return true}return false}return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/isHidden", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";function i(i){return i.offsetWidth<=0&&i.offsetHeight<=0||jQuery.css(i,"visibility")==="hidden"}return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/Aria", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";function i(i,t,r){var e=this.attr(i);if(!e){return this.attr(i,t)}var n=e.split(" ");if(n.indexOf(t)==-1){r?n.unshift(t):n.push(t);this.attr(i,n.join(" "))}return this}function t(i,t){var r=this.attr(i)||"",e=r.split(" "),n=e.indexOf(t);if(n==-1){return this}e.splice(n,1);if(e.length){this.attr(i,e.join(" "))}else{this.removeAttr(i)}return this}jQuery.fn.addAriaLabelledBy=function(t,r){return i.call(this,"aria-labelledby",t,r)};jQuery.fn.removeAriaLabelledBy=function(i){return t.call(this,"aria-labelledby",i)};jQuery.fn.addAriaDescribedBy=function(t,r){return i.call(this,"aria-describedby",t,r)};jQuery.fn.removeAriaDescribedBy=function(i){return t.call(this,"aria-describedby",i)};return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/Focusable", ["sap/ui/thirdparty/jquery","sap/ui/dom/isHidden","./hasTabIndex"],function(jQuery,i){"use strict";function n(e,r){var t=r?e.firstChild:e.lastChild,u;while(t){if(t.nodeType==1&&!i(t)){if(jQuery(t).hasTabIndex()){return t}u=n(t,r);if(u){return u}}t=r?t.nextSibling:t.previousSibling}return null}jQuery.fn.firstFocusableDomRef=function(){var e=this.get(0);if(!e||i(e)){return null}return n(e,true)};jQuery.fn.lastFocusableDomRef=function(){var e=this.get(0);if(!e||i(e)){return null}return n(e,false)};return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/Selection", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";jQuery.fn.disableSelection=function(){return this.on(("onselectstart"in document.createElement("div")?"selectstart":"mousedown")+".ui-disableSelection",function(e){e.preventDefault()})};jQuery.fn.enableSelection=function(){return this.off(".ui-disableSelection")};return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/control", ["sap/ui/thirdparty/jquery","sap/ui/core/Element","sap/ui/Global"],function(jQuery,t){"use strict";jQuery.fn.control=function(a,e){var i=this.map(function(){var a;if(e){var i=jQuery(this).closest("[data-sap-ui],[data-sap-ui-related]");a=i.attr("data-sap-ui-related")||i.attr("id")}else{a=jQuery(this).closest("[data-sap-ui]").attr("id")}return t.getElementById(a)});return i.get(a)};return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/cursorPos", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var t=function t(e){var r=arguments.length,s,i;s=this.prop("tagName");i=this.prop("type");if(this.length===1&&(s=="INPUT"&&(i=="text"||i=="password"||i=="search")||s=="TEXTAREA")){var n=this.get(0);if(r>0){if(typeof n.selectionStart=="number"){n.focus();n.selectionStart=e;n.selectionEnd=e}return this}else{if(typeof n.selectionStart=="number"){return n.selectionStart}return-1}}else{return this}};jQuery.fn.cursorPos=t;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/getSelectedText", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var t=function(){var t=this.get(0);try{if(typeof t.selectionStart==="number"){return t.value.substring(t.selectionStart,t.selectionEnd)}}catch(t){}return""};jQuery.fn.getSelectedText=t;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/hasTabIndex", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var t=function(t){var n=jQuery.prop(t,"tabIndex");return n!=null&&n>=0&&(!jQuery.attr(t,"disabled")||jQuery.attr(t,"tabindex"))};jQuery.fn.hasTabIndex=function(){return t(this.get(0))};return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/parentByAttribute", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var t=function t(r,e){if(this.length>0){if(e){return this.first().parents("["+r+"='"+e+"']").get(0)}else{return this.first().parents("["+r+"]").get(0)}}};jQuery.fn.parentByAttribute=t;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/rect", ["sap/ui/thirdparty/jquery","sap/ui/dom/getOwnerWindow"],function(jQuery,t){"use strict";var e=function e(){var i=this.get(0);if(i){if(i.getBoundingClientRect){var r=i.getBoundingClientRect();var n={top:r.top,left:r.left,width:r.right-r.left,height:r.bottom-r.top};var o=t(i);n.left+=jQuery(o).scrollLeft();n.top+=jQuery(o).scrollTop();return n}else{return{top:10,left:10,width:i.offsetWidth,height:i.offsetHeight}}}return null};jQuery.fn.rect=e;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/rectContains", ["sap/ui/thirdparty/jquery","sap/base/assert","sap/ui/dom/jquery/rect"],function(jQuery,t){"use strict";var e=function e(r,s){t(!isNaN(r),"iPosX must be a number");t(!isNaN(s),"iPosY must be a number");var i=this.rect();if(i){return r>=i.left&&r<=i.left+i.width&&s>=i.top&&s<=i.top+i.height}return false};jQuery.fn.rectContains=e;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/scrollLeftRTL", ["sap/ui/dom/denormalizeScrollLeftRTL","sap/ui/util/_FeatureDetection","sap/ui/thirdparty/jquery"],function(t,e,jQuery){"use strict";var i;if(e.initialScrollPositionIsZero()){i=function(t){return t.scrollWidth+t.scrollLeft-t.clientWidth}}else{i=function(t){return t.scrollLeft}}var r=function(e){var r=this.get(0);if(r){if(e===undefined){return i(r)}else{r.scrollLeft=t(e,r);return this}}};jQuery.fn.scrollLeftRTL=r;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/scrollRightRTL", ["sap/ui/util/_FeatureDetection","sap/ui/thirdparty/jquery"],function(t,jQuery){"use strict";var i;if(t.initialScrollPositionIsZero()){i=function(t){return-t.scrollLeft}}else{i=function(t){return t.scrollWidth-t.scrollLeft-t.clientWidth}}var r=function(){var t=this.get(0);if(t){return i(t)}};jQuery.fn.scrollRightRTL=r;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/selectText", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var t=function t(e,r){var i=this.get(0);try{if(typeof i.selectionStart==="number"){i.setSelectionRange(e>0?e:0,r)}}catch(t){}return this};jQuery.fn.selectText=t;return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/zIndex", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";function e(e,n){var t=Object.getOwnPropertyDescriptor(e,n);return t&&t.value}if(!e(jQuery.fn,"zIndex")){var n=function(e){if(e!==undefined){return this.css("zIndex",e)}if(this.length){var n=jQuery(this[0]),t,i;while(n.length&&n[0]!==document){t=n.css("position");if(t==="absolute"||t==="relative"||t==="fixed"){i=parseInt(n.css("zIndex"));if(!isNaN(i)&&i!==0){return i}}n=n.parent()}}return 0};
/*!
		 * The following function is taken from
		 * jQuery UI Core 1.11.1
		 * http://jqueryui.com
		 *
		 * Copyright 2014 jQuery Foundation and other contributors
		 * Released under the MIT license.
		 * http://jquery.org/license
		 *
		 * http://api.jqueryui.com/category/ui-core/
		 */jQuery.fn.zIndex=n}return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/units/Rem", ["sap/base/assert"],function(e){"use strict";function t(){var e=document.documentElement;if(!e){return 16}return parseFloat(window.getComputedStyle(e).getPropertyValue("font-size"))}var r={fromPx:function(r){e(typeof r==="string"&&r!==""&&!isNaN(parseFloat(r))&&typeof parseFloat(r)==="number"||typeof r==="number"&&!isNaN(r),'Rem.fromPx: either the "vPx" parameter must be an integer, or a string e.g.: "16px"');return parseFloat(r)/t()},toPx:function(r){e(typeof r==="string"&&r!==""&&!isNaN(parseFloat(r))&&typeof parseFloat(r)==="number"||typeof r==="number"&&!isNaN(r),'Rem.toPx: either the "vRem" parameter must be an integer, or a string e.g.: "1rem"');return parseFloat(r)*t()}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/isMouseEventDelayed", ["sap/ui/Device"],function(r){"use strict";var e=function(e){e=e||navigator;return!!(r.browser.mobile&&!(r.os.ios&&r.os.version>=8&&r.browser.safari&&!r.browser.webview||r.browser.chrome&&!/SAMSUNG/.test(e.userAgent)&&r.browser.version>=32))};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/isSpecialKey", function(){"use strict";var e=function(e){function r(e){var r=e.key;return r==="Shift"||r==="Control"||r==="Alt"||r==="AltGraph"||r==="CapsLock"||r==="NumLock"}function t(e){var r=e.key;return r==="ArrowLeft"||r==="ArrowUp"||r==="ArrowRight"||r==="ArrowDown"}var n=e.key,a=r(e)||t(e)||n==="PageUp"||n==="PageDown"||n==="End"||n==="Home"||n==="PrintScreen"||n==="Insert"||n==="Delete"||n==="F1"||n==="F2"||n==="F3"||n==="F4"||n==="F5"||n==="F6"||n==="F7"||n==="F8"||n==="F9"||n==="F10"||n==="F11"||n==="F12"||n==="Pause"||n==="Backspace"||n==="Tab"||n==="Enter"||n==="Escape"||n==="ScrollLock";switch(e.type){case"keydown":case"keyup":case"keypress":return a;default:return false}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/jquery/EventTriggerHook", ["sap/base/Log","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/base/util/uid"],function(e,r,jQuery,i){"use strict";var t={};function o(i){var o=e.isLoggable(e.Level.DEBUG),n=t[i.type],s=n.originalTriggerHook,a=window.performance.now(),d,f,u;if(!i.isPropagationStopped()&&!i.isSimulated){for(f in n.domRefs){u=n.domRefs[f];if(u.excludedDomRefs.indexOf(i.target)===-1&&r(u.domRef,i.target)){i.preventDefault();i.stopImmediatePropagation();if(o){d=window.performance.now();e.debug("Perf: jQuery trigger suppression event handler "+i.type+" took "+(d-a)+" milliseconds.")}return false}}}if(s){return s.call(this,i)}}function n(e){if(!jQuery.event.special[e]){jQuery.event.special[e]={}}var r=jQuery.event.special[e],i=r.trigger;r.trigger=o;return i}function s(e,r,o){var s=t[e];var a=i();if(!s){s=t[e]={domRefs:{},originalTriggerHook:n(e)}}s.domRefs[a]={domRef:r,excludedDomRefs:[].concat(o)};return{id:a,type:e}}function a(r){if(!r){e.error("Release trigger events must not be called without passing a valid handler!");return}var i=t[r.type];if(!i){return}else if(!i.domRefs[r.id]||!i.domRefs[r.id].domRef){e.warning("Release trigger event for event type "+r.type+"on Control "+r.id+": DomRef does not exists");return}delete i.domRefs[r.id]}return{suppress:s,release:a}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/ClientTreeBindingAdapter", ["sap/ui/model/TreeBinding","sap/ui/model/ClientTreeBinding","./TreeBindingAdapter","sap/ui/model/ChangeReason","sap/base/assert","sap/base/Log"],function(e,t,i,o,r,n){"use strict";var p=function(){if(!(this instanceof e)||this._bIsAdapted){return}i.apply(this);for(var t in p.prototype){if(p.prototype.hasOwnProperty(t)){this[t]=p.prototype[t]}}this._invalidTree=true;this.setNumberOfExpandedLevels(this.mParameters.numberOfExpandedLevels||0)};p.prototype.setNumberOfExpandedLevels=function(e){this._iNumberOfExpandedLevels=parseInt(e)};p.prototype.getNumberOfExpandedLevels=function(){return this._iNumberOfExpandedLevels};p.prototype.nodeHasChildren=function(e){r(e,"TreeBindingAdapter.nodeHasChildren: No node given!");if(!e){return false}else if(e.isArtificial){return true}else{return t.prototype.hasChildren.call(this,e.context)}};p.prototype.resetData=function(e,i){var r=t.prototype.resetData.call(this,e,i);this._aRowIndexMap=[];this._oRootNode=undefined;this._iPageSize=0;this._iThreshold=0;if(!i||i.reason!==o.Sort){this.clearSelection();this._createTreeState(true)}return r};p.prototype._calculateGroupID=function(e){var t=this.getPath();var i;if(e.context){var o=e.context.getPath();if(t!="/"){var r=o.match(t+"(.*)");if(r!=null&&r[1]){i=r[1]}else{n.warning("CTBA: BindingPath/ContextPath matching problem!")}}if(!i){i=o}if(i.startsWith("/")){i=i.substring(1,i.length)}var p;if(!e.parent){p=this._calculateGroupID({context:e.context._parentContext||null})}else{p=e.parent.groupID}i=p+i.replace(/\//g,"_")+"/"}else if(e.context===null){i="/"}return i};p.prototype.expand=function(){this._buildTree();i.prototype.expand.apply(this,arguments)};p.prototype.collapse=function(){this._buildTree();i.prototype.collapse.apply(this,arguments)};p.prototype._buildTree=function(e,t){if(this._invalidTree){e=e||0;t=t||this.getRootContexts().length;this._invalidTree=false;this._aRowIndexMap=[];i.prototype._buildTree.call(this,e,t)}};p.prototype.findNode=function(e){this._buildTree();return i.prototype.findNode.apply(this,arguments)};p.prototype.setSelectedIndex=function(e){this._buildTree();i.prototype.setSelectedIndex.apply(this,arguments)};p.prototype.setSelectionInterval=function(e,t){this._buildTree();i.prototype.setSelectionInterval.apply(this,arguments)};p.prototype.addSelectionInterval=function(){this._buildTree();i.prototype.addSelectionInterval.apply(this,arguments)};p.prototype.removeSelectionInterval=function(){this._buildTree();i.prototype.removeSelectionInterval.apply(this,arguments)};p.prototype.clearSelection=function(){this._buildTree();i.prototype.clearSelection.apply(this,arguments)};p.prototype.selectAll=function(){this._buildTree();i.prototype.selectAll.apply(this,arguments)};p.prototype._calculateRequestLength=function(e,t){return e};p.prototype.getLength=function(){this._buildTree();return i.prototype.getLength.apply(this,arguments)};p.prototype._fireChange=function(){this._invalidTree=true;this.constructor.prototype._fireChange.apply(this,arguments)};return p},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/MetaModel", ["./Model"],function(t){"use strict";var n=t.extend("sap.ui.model.MetaModel",{constructor:function(){t.apply(this,arguments)}});n.prototype.createBindingContext=function(t,n,e,i){if(typeof n=="function"){i=n;n=null}if(typeof e=="function"){i=e;e=null}var o=this.resolve(t,n),u=o==undefined?undefined:this.getContext(o?o:"/");if(!u){u=null}if(i){i(u)}return u};n.prototype.destroyBindingContext=function(){};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/SelectionModel", ["sap/ui/base/EventProvider","sap/base/assert"],function(e,t){"use strict";var n=e.extend("sap.ui.model.SelectionModel",{constructor:function(t){e.apply(this);this.iSelectionMode=t||n.SINGLE_SELECTION;this.aSelectedIndices=[];this.iLeadIndex=-1;this.fnSort=function(e,t){return e-t};this.fnSortReverse=function(e,t){return t-e}}});n.SINGLE_SELECTION=0;n.MULTI_SELECTION=1;n.prototype.getSelectionMode=function(){return this.iSelectionMode};n.prototype.setSelectionMode=function(e){this.iSelectionMode=e||n.SINGLE_SELECTION};n.prototype.isSelectedIndex=function(e){return this.aSelectedIndices.indexOf(e)!==-1};n.prototype.getLeadSelectedIndex=function(){return this.iLeadIndex};n.prototype.setLeadSelectedIndex=function(e){t(typeof e==="number","iLeadIndex must be an integer");this.setSelectionInterval(e,e);return this};n.prototype.getMinSelectionIndex=function(){if(this.aSelectedIndices.length>0){var e=this.aSelectedIndices.sort(this.fnSort);return e[0]}else{return-1}};n.prototype.getMaxSelectionIndex=function(){if(this.aSelectedIndices.length>0){var e=this.aSelectedIndices.sort(this.fnSortReverse);return e[0]}else{return-1}};n.prototype.getSelectedIndices=function(){var e=this.aSelectedIndices.sort(this.fnSort);return e};n.prototype.setSelectionInterval=function(e,i){t(typeof e==="number","iFromIndex must be an integer");t(typeof i==="number","iToIndex must be an integer");if(this.iSelectionMode===n.SINGLE_SELECTION){e=i}var r=Math.min(e,i);var s=Math.max(e,i);var a=this.aSelectedIndices.slice();var o={};var d=[];for(var h=0;h<a.length;h++){o[a[h]]=true;if(a[h]<e||a[h]>i){d.push(a[h])}}var c=[];for(var u=r;u<=s;u++){c.push(u);if(!o[u]){d.push(u)}}this._update(c,i,d);return this};n.prototype.addSelectionInterval=function(e,i){t(typeof e==="number","iFromIndex must be an integer");t(typeof i==="number","iToIndex must be an integer");if(this.iSelectionMode===n.SINGLE_SELECTION){return this.setSelectionInterval(e,i)}var r=Math.min(e,i);var s=Math.max(e,i);var a=[];var o=this.aSelectedIndices;for(var d=r;d<=s;d++){if(o.indexOf(d)===-1){o.push(d);a.push(d)}}this._update(o,s,a);return this};n.prototype.moveSelectionInterval=function(e,n){t(typeof e==="number","iFromIndex must be an integer");t(typeof n==="number","iToIndex must be an integer");var i=[];var r=this.aSelectedIndices;var s=this.iLeadIndex;for(var a=0;a<r.length;a++){var o=r[a];if(o>=e){i.push(r[a]);r[a]+=n;i.push(r[a]);if(o===this.iLeadIndex){s+=n}}}this._update(r,s,i);return this};n.prototype.removeSelectionInterval=function(e,i){t(typeof e==="number","iFromIndex must be an integer");t(typeof i==="number","iToIndex must be an integer");if(this.iSelectionMode===n.SINGLE_SELECTION){e=i}var r=Math.min(e,i);var s=Math.max(e,i);var a=[];var o=this.aSelectedIndices;var d=this.iLeadIndex;for(var h=r;h<=s;h++){var c=o.indexOf(h);if(c>-1){o.splice(c,1);a.push(h)}if(h===this.iLeadIndex){d=-1}}this._update(o,d,a);return this};n.prototype.sliceSelectionInterval=function(e,n){t(typeof e==="number","iFromIndex must be an integer");t(typeof n==="number","iToIndex must be an integer");var i=Math.min(e,n);var r=Math.max(e,n);var s=[];var a=[];var o=this.aSelectedIndices.slice(0);var d=this.aSelectedIndices;var h=this.iLeadIndex;var c=r-i+1;for(var u=r;u>=i;u--){var f=d.indexOf(u);if(f>-1){d.splice(f,1);a.push(u)}if(u===this.iLeadIndex){h=-1}}for(var u=0;u<d.length;u++){var l=d[u];if(l>=i){var p=d[u]-c;if(l===h){h=p}d[u]=p;if(o.indexOf(p)===-1){s.push(p)}}}for(var I=0;I<a.length;I++){var u=o[o.length-1-I];if(s.indexOf(u)===-1){s.push(u)}}for(var I=0;I<a.length;I++){if(d.indexOf(a[I])===-1&&s.indexOf(a[I])===-1){s.push(a[I])}}this._update(d,h,s);return this};n.prototype.clearSelection=function(){if(this.aSelectedIndices.length>0||this.iLeadIndex!==-1){this._update([],-1,this.aSelectedIndices.slice())}return this};n.prototype.attachSelectionChanged=function(e,t,n){this.attachEvent("selectionChanged",e,t,n);return this};n.prototype.detachSelectionChanged=function(e,t){this.detachEvent("selectionChanged",e,t);return this};n.prototype.fireSelectionChanged=function(e){this.fireEvent("selectionChanged",e);return this};n.prototype._update=function(e,t,n,i){var r={rowIndices:n&&n.sort(this.fnSort),selectAll:i};this.aSelectedIndices=e;r.oldIndex=this.iLeadIndex;if(this.iLeadIndex!==t){this.iLeadIndex=t;r.leadIndex=this.iLeadIndex}if(n.length>0||typeof r.leadIndex!=="undefined"){this.fireSelectionChanged(r)}};n.prototype.selectAll=function(e){t(typeof e==="number","iToIndex must be an integer");var n=this.aSelectedIndices.slice();var i={};var r=[];var s=[];var a=0;for(a=0;a<n.length;a++){i[n[a]]=true;if(n[a]>e){r.push(n[a])}}for(a=0;a<=e;a++){s.push(a);if(!i[a]){r.push(a)}}this._update(s,0,r,true);return this};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/TreeAutoExpandMode", [],function(){"use strict";var e={Sequential:"Sequential",Bundled:"Bundled"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/TreeBindingAdapter", ["sap/ui/model/TreeBinding","sap/ui/model/TreeAutoExpandMode","sap/ui/model/ChangeReason","sap/ui/model/TreeBindingUtils","sap/base/assert","sap/base/Log","sap/base/util/each","sap/base/util/isEmptyObject"],function(e,t,i,o,n,r,a,s){"use strict";var d=function(){if(!(this instanceof e)||this._bIsAdapted){return}for(var i in d.prototype){if(d.prototype.hasOwnProperty(i)){this[i]=d.prototype[i]}}this.mParameters=this.mParameters||{};this._aRowIndexMap=[];this._iThreshold=0;this._iPageSize=0;this.setAutoExpandMode(this.mParameters.autoExpandMode||t.Sequential);if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive}this._createTreeState();this._bIsAdapted=true};d.prototype.getCurrentTreeState=function(){var e=";",t;var i={};for(t in this._mTreeState.expanded){i[t]=true}var o={};for(t in this._mTreeState.collapsed){o[t]=true}var n={};for(t in this._mTreeState.selected){n[t]=true}return{_getExpandedList:function(){return Object.keys(i).join(e)},_getCollapsedList:function(){return Object.keys(o).join(e)},_getSelectedList:function(){return Object.keys(n).join(e)},_isExpanded:function(e){return!!i[e]},_isCollapsed:function(e){return!!o[e]},_remove:function(e){delete i[e];delete o[e];delete n[e]}}};d.prototype.setTreeState=function(e){this._oInitialTreeState=e};d.prototype.setAutoExpandMode=function(e){this._autoExpandMode=e};d.prototype.getLength=function(){if(!this._oRootNode){return 0}return this._oRootNode.magnitude};d.prototype.getContextByIndex=function(e){if(this.isInitial()){return undefined}var t=this.findNode(e);return t?t.context:undefined};d.prototype.getNodeByIndex=function(e){if(this.isInitial()){return undefined}if(e>=this.getLength()){return undefined}return this.findNode(e)};d.prototype.findNode=function(e){if(this.isInitial()){return undefined}var t=typeof e;var i;var o=[];if(t==="number"){i=this._aRowIndexMap[e];if(!i){var n=-1;this._match(this._oRootNode,o,1,function(t){if(n===e){return true}n+=1;return false});i=o[0]}}return i};d.prototype._createTreeState=function(e){if(!this._mTreeState||e){this._mTreeState={expanded:{},collapsed:{},selected:{},deselected:{}}}};d.prototype._updateTreeState=function(e){e=e||{};var t=e.expanded?this._mTreeState.expanded:this._mTreeState.collapsed;var i=e.expanded?this._mTreeState.collapsed:this._mTreeState.expanded;var o=this._getNodeState(e.groupID);if(!o){o=e.fallbackNodeState||this._createNodeState({groupID:e.groupID,expanded:e.expanded,sum:e.sum})}delete i[e.groupID];t[e.groupID]=o;o.expanded=e.expanded;return o};d.prototype._createNodeState=function(e){if(!e.groupID){n(false,"To create a node state a group ID is mandatory!");return undefined}var t;var i;if(this._oInitialTreeState){t=this._oInitialTreeState._isExpanded(e.groupID);i=this._oInitialTreeState._isCollapsed(e.groupID);this._oInitialTreeState._remove(e.groupID)}var o=e.expanded||t||false;var r=e.selected||false;var a={groupID:e.groupID,expanded:o,sections:e.sections||[{startIndex:0,length:this._iPageSize}],sum:e.sum||false,selected:r};if(t||i){this._updateTreeState({groupID:e.groupID,fallbackNodeState:a,expanded:t,collapsed:i})}return a};d.prototype._getNodeState=function(e){var t=this._mTreeState.expanded[e];var i=this._mTreeState.collapsed[e];var o=this._mTreeState.selected[e];var n=this._mTreeState.deselected[e];return t||i||o||n};d.prototype._updateNodeSections=function(e,t){var i=this._getNodeState(e);if(!i){n(false,"No Node State for Group ID '"+e+"' found!");return undefined}else if(!t){n(false,"No Section given!");return undefined}else if(t.length<=0){n(false,"The length of the given section must be positive greater than 0.");return undefined}else if(t.startIndex<0){n(false,"The sections start index must be greater/equal to 0.");return undefined}i.sections=o.mergeSections(i.sections,t);return i.sections};d.prototype._increaseSections=function(){var e=function(e){if(!e){return}var t=this._getMaxGroupSize(e);var i=e.nodeState;if(t===undefined){var n=[];for(var r=0;r<i.sections.length;r++){var a=i.sections[r];a.length=Math.max(a.length,this._iPageSize);n=o.mergeSections(n,a)}i.sections=n}};this._map(this._oRootNode,e)};d.prototype._getMaxGroupSize=function(e){var t=0;if(e.isArtificial){var i=this.oModel.isList(this.sPath,this.getContext());if(this.bDisplayRootNode&&!i&&!this._bRootMissing){t=1}else{t=this._getGroupSize(e)||0}}else{t=this.nodeHasChildren(e)?this._getGroupSize(e):0}return t};d.prototype.getContexts=function(e,t,i){return this._getContextsOrNodes(false,e,t,i)};d.prototype._getContextsOrNodes=function(e,t,i,o){var n,r,s=[],d=[];if(!this.isResolved()||this.isInitial()){return[]}t=t||0;i=i||this.oModel.iSizeLimit;o=o||0;if(i>this._iPageSize){this._iPageSize=i;this._increaseSections()}this._iThreshold=Math.max(this._iThreshold,o);this._aRowIndexMap=[];this._buildTree(t,i);if(this._oRootNode){d=this._retrieveNodeSection(this._oRootNode,t,i)}this._updateRowIndexMap(d,t);for(var l=0;l<d.length;l++){r=d[l];if(!r.context){n=n||{};var u=r.parent;n[u.groupID]=u;this._updateNodeSections(u.groupID,{startIndex:r.positionInParent,length:1})}s.push(r.context)}if(n){var h=this;a(n,function(e,t){t.magnitude=0;t.numberOfTotals=0;h._loadChildContexts(t)});s=[];for(var p=0;p<d.length;p++){r=d[p];s.push(r.context)}}if(e){return d}else{return s}};d.prototype.getNodes=function(e,t,i){return this._getContextsOrNodes(true,e,t,i)};d.prototype._updateRowIndexMap=function(e,t){this._aRowIndexMap=[];for(var i=0;i<e.length;i++){this._aRowIndexMap[t+i]=e[i]}};d.prototype._retrieveNodeSection=function(e,t,i){var o=-1;var n=[];this._match(this._oRootNode,[],i,function(e,r,a){if(!e||!e.isArtificial){o++}if(o>=t&&o<t+i){if(!e){e=this._createNode({parent:a,positionInParent:r});a.children[r]=e}n.push(e);return true}return false});return n};d.prototype._buildTree=function(e,t){this._oRootNode=undefined;var i=null;var o=this._calculateGroupID({context:i,parent:null});var n=this._getNodeState(o);if(!n){n=this._createNodeState({groupID:o,sum:true,sections:[{startIndex:e,length:t}]});this._updateTreeState({groupID:n.groupID,fallbackNodeState:n,expanded:true})}this._oRootNode=this._createNode({context:i,parent:null,level:this.bDisplayRootNode&&!(i===null)?0:-1,nodeState:n,isLeaf:false,autoExpand:this.getNumberOfExpandedLevels()+1});this._oRootNode.isArtificial=true;if(this._mTreeState.expanded[this._oRootNode.groupID]){this._loadChildContexts(this._oRootNode)}};d.prototype._calculateRequestLength=function(e,t){var i;if(!e){i=t.length}else{i=Math.max(Math.min(t.length,e-t.startIndex),0)}return i};d.prototype._loadChildContexts=function(e){var i=e.nodeState;var o=this._getMaxGroupSize(e);if(o>0){if(!e.children[o-1]){e.children[o-1]=undefined}i.leafCount=o}if(this.bClientOperation){i.sections=[{startIndex:0,length:o}]}for(var n=0;n<i.sections.length;n++){var r=i.sections[n];var a=this._calculateRequestLength(o,r);if(e.autoExpand>=0&&this._autoExpandMode===t.Bundled){a=Math.max(0,o)}var s;if(e.isArtificial){s=this.getRootContexts(r.startIndex,a,this._iThreshold)}else{s=this.nodeHasChildren(e)?this.getNodeContexts(e.context,r.startIndex,a,this._iThreshold):[]}for(var d=0;d<s.length;d++){var l=s[d];if(!l){continue}var u=d+r.startIndex;var h=e.children[u];var p={context:s[d],parent:e,level:e.level+1,positionInParent:u,autoExpand:Math.max(e.autoExpand-1,-1)};if(h){h.context=p.context;h.parent=p.parent;h.level=p.level;h.positionInParent=p.positionInParent;h.magnitude=0;h.numberOfTotals=0;h.autoExpand=p.autoExpand;var f;if(l){f=this._calculateGroupID(h)}h.groupID=f}else{h=this._createNode(p)}h.nodeState=this._getNodeState(h.groupID);if(!h.nodeState){h.nodeState=this._createNodeState({groupID:h.groupID,expanded:false})}h.nodeState.parentGroupID=e.groupID;h.isLeaf=!this.nodeHasChildren(h);e.children[u]=h;if(h.isLeaf){e.numberOfLeafs+=1}if(h.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[h.groupID]){this.setNodeSelection(h.nodeState,true)}if((h.autoExpand>0||h.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[h.groupID]&&!h.isLeaf){this._updateTreeState({groupID:h.nodeState.groupID,fallbackNodeState:h.nodeState,expanded:true});this._loadChildContexts(h)}e.magnitude+=Math.max(h.magnitude||0,0);e.numberOfLeafs+=h.numberOfLeafs}}}e.magnitude+=Math.max(o||0,0)};d.prototype.isGrouped=function(){return true};d.prototype._calculateGroupID=function(e){r.error("TreeBindingAdapter#_calculateGroupID: Not implemented. Needs to be implemented in respective sub-classes.")};d.prototype._createNode=function(e){e=e||{};var t=e.context;var i=e.level||0;var o={context:t,level:i,children:e.children||[],parent:e.parent,nodeState:e.nodeState,isLeaf:e.isLeaf||false,positionInParent:e.positionInParent,magnitude:e.magnitude||0,numberOfTotals:e.numberOfTotals||0,numberOfLeafs:e.numberOfLeafs||0,autoExpand:e.autoExpand||0,absoluteNodeIndex:e.absoluteNodeIndex||0,totalNumberOfLeafs:0};if(t!==undefined){o.groupID=this._calculateGroupID(o)}return o};d.prototype.expand=function(e,t){var o=this.findNode(e);if(!o){n(false,"No node found for index "+e);return}this._updateTreeState({groupID:o.nodeState.groupID,fallbackNodeState:o.nodeState,expanded:true});if(!t){this._fireChange({reason:i.Expand})}};d.prototype.expandToLevel=function(e){this._mTreeState.collapsed={};this.setNumberOfExpandedLevels(e);this._fireChange({reason:i.Expand})};d.prototype.isExpanded=function(e){var t=this.findNode(e);return t&&t.nodeState?t.nodeState.expanded:false};d.prototype.collapse=function(e,t){var o;var r=this;if(typeof e==="object"){o=e}else if(typeof e==="number"){var s=this.findNode(e);if(!s){n(false,"No node found for index "+e);return}o=s.nodeState}this._updateTreeState({groupID:o.groupID,fallbackNodeState:o,expanded:false});o.selectAllMode=false;if(this.bCollapseRecursive){var d=o.groupID;a(this._mTreeState.expanded,function(e,t){if(typeof d=="string"&&d.length>0&&e.startsWith(d)){r._updateTreeState({groupID:e,expanded:false})}});var l=[];a(this._mTreeState.selected,function(e,t){if(typeof d=="string"&&d.length>0&&e.startsWith(d)&&e!==d){t.selectAllMode=false;r.setNodeSelection(t,false);l.push(e)}});if(l.length){var u={rowIndices:[]};var h=-1;this._map(this._oRootNode,function(e){if(!e||!e.isArtificial){h++}if(e&&l.indexOf(e.groupID)!==-1){if(e.groupID===this._sLeadSelectionGroupID){u.oldIndex=h;u.leadIndex=-1}u.rowIndices.push(h)}});this._publishSelectionChanges(u)}}if(!t){this._fireChange({reason:i.Collapse})}};d.prototype.collapseToLevel=function(e){if(!e||e<0){e=0}var t=this;a(this._mTreeState.expanded,function(i,o){var n=t._getGroupIdLevel(i)-1;if(n===e){t.collapse(o,true)}});if(this.bCollapseRecursive){this.setNumberOfExpandedLevels(e)}this._fireChange({reason:i.Collapse})};d.prototype._map=function(e,t){t.call(this,e);if(!e){return}for(var i=0;i<e.children.length;i++){var o=e.children[i];this._map(o,t)}if(this._afterMapHook){this._afterMapHook(e,t)}};d.prototype._match=function(e,t,i,o,n,r){if(t.length===i){return true}var a=o.call(this,e,n,r);if(a){t.push(e)}if(!e){return false}for(var s=0;s<e.children.length;s++){var d=e.children[s];var l=this._match(d,t,i,o,s,e);if(l){return true}}return this._afterMatchHook?this._afterMatchHook(e,t,i,o,n,r):false};d.prototype.toggleIndex=function(e){var t=this.findNode(e);if(!t){n(false,"There is no node at index "+e+".");return}if(t.nodeState.expanded){this.collapse(e)}else{this.expand(e)}};d.prototype._getGroupIdLevel=function(e){if(e==null){r.warning("assertion failed: no need to determine level of group ID = null");return-1}return e.split("/").length-2};d.prototype._getGroupSize=function(e){return this.getChildCount(e.context)};d.prototype.setNodeSelection=function(e,t){if(!e.groupID){n(false,"NodeState must have a group ID!");return}e.selected=t;if(t){this._mTreeState.selected[e.groupID]=e;delete this._mTreeState.deselected[e.groupID]}else{delete this._mTreeState.selected[e.groupID];this._mTreeState.deselected[e.groupID]=e}};d.prototype.isIndexSelected=function(e){var t=this.getNodeByIndex(e);return t&&t.nodeState?t.nodeState.selected:false};d.prototype.isIndexSelectable=function(e){var t=this.getNodeByIndex(e);return this._isNodeSelectable(t)};d.prototype._isNodeSelectable=function(e){return!!e&&!e.isArtificial};d.prototype.setSelectedIndex=function(e){var t=this.findNode(e);if(t&&this._isNodeSelectable(t)){var i=this._clearSelection();var o=i.rowIndices.indexOf(e);if(o>=0){i.rowIndices.splice(o,1)}else{i.rowIndices.push(e)}i.leadGroupID=t.groupID;i.leadIndex=e;this.setNodeSelection(t.nodeState,true);this._publishSelectionChanges(i)}else{r.warning("TreeBindingAdapter: The selection was ignored. Please make sure to only select rows, for which data has been fetched to the client. For AnalyticalTables, some rows might not be selectable at all.")}};d.prototype.getSelectedIndex=function(){if(!this._sLeadSelectionGroupID||s(this._mTreeState.selected)){return-1}var e=-1;var t=false;var i=function(i){if(!i||!i.isArtificial){e++}if(i){if(i.groupID===this._sLeadSelectionGroupID){t=true;return true}}return false};this._match(this._oRootNode,[],1,i);if(t){return e}return-1};d.prototype.getSelectedIndices=function(){var e=[];var t=this;if(s(this._mTreeState.selected)){return e}var i=Object.keys(this._mTreeState.selected).length;var o=-1;var n=function(i){if(!i||!i.isArtificial){o++}if(i){if(i.nodeState&&i.nodeState.selected&&!i.isArtificial){e.push(o);t._aRowIndexMap[o]=i;return true}}return false};this._match(this._oRootNode,[],i,n);return e};d.prototype.getSelectedNodesCount=function(){var e;if(this._oRootNode&&this._oRootNode.nodeState.selectAllMode){var t,i,o,n;var r,a=[];if(this.filterInfo&&this.oCombinedFilter){for(var s=this.filterInfo.aFilteredContexts.length-1;s>=0;s--){r=this.filterInfo.aFilteredContexts[s];a.push(this._calculateGroupID({context:r}))}}i=0;for(t in this._mTreeState.expanded){if(!this.oCombinedFilter||a.indexOf(t)!==-1){n=this._mTreeState.expanded[t];if(!n.selectAllMode&&n.leafCount!==undefined){i+=n.leafCount}}}for(t in this._mTreeState.selected){if(!this.oCombinedFilter||a.indexOf(t)!==-1){n=this._mTreeState.selected[t];o=this._mTreeState.expanded[n.parentGroupID];if(o&&!o.selectAllMode){i--}}}for(t in this._mTreeState.deselected){if(!this.oCombinedFilter||a.indexOf(t)!==-1){n=this._mTreeState.deselected[t];o=this._mTreeState.expanded[n.parentGroupID];if(o&&o.selectAllMode){i++}}}e=this._getSelectableNodesCount(this._oRootNode)-i}else{e=Object.keys(this._mTreeState.selected).length}return e};d.prototype._getSelectableNodesCount=function(e){if(e){return e.magnitude}else{return 0}};d.prototype.getSelectedContexts=function(){var e=[];var t=this;if(s(this._mTreeState.selected)){return e}var i=Object.keys(this._mTreeState.selected).length;var o=-1;var n=function(i){if(!i||!i.isArtificial){o++}if(i){if(i.nodeState&&i.nodeState.selected&&!i.isArtificial){e.push(i.context);t._aRowIndexMap[o]=i;return true}}return false};this._match(this._oRootNode,[],i,n);return e};d.prototype.setSelectionInterval=function(e,t){var i,o,n=this._clearSelection(),r={},a=[],s=this._setSelectionInterval(e,t,true);for(i=0;i<n.rowIndices.length;i++){o=n.rowIndices[i];r[o]=true}for(i=0;i<s.rowIndices.length;i++){o=s.rowIndices[i];if(r[o]){delete r[o]}else{r[o]=true}}for(o in r){if(r[o]){a.push(parseInt(o))}}this._publishSelectionChanges({rowIndices:a,oldIndex:n.oldIndex,leadIndex:s.leadIndex,leadGroupID:s.leadGroupID})};d.prototype._setSelectionInterval=function(e,t,i){var o=Math.min(e,t);var n=Math.max(e,t);var r=[];var a=[];var s=Math.abs(n-o)+1;var d;var l=-1;var u=function(e){if(!e||!e.isArtificial){l++}if(e){if(l>=o&&l<=n){if(this._isNodeSelectable(e)){if(e.nodeState.selected!==!!i){a.push(l)}if(e.groupID===this._sLeadSelectionGroupID){d=l}this.setNodeSelection(e.nodeState,!!i)}return true}}return false};this._match(this._oRootNode,r,s,u);var h={rowIndices:a,oldIndex:d,leadIndex:d&&!i?-1:undefined};if(r.length>0&&i){var p=r[r.length-1];h.leadGroupID=p.groupID;h.leadIndex=n}return h};d.prototype.addSelectionInterval=function(e,t){var i=this._setSelectionInterval(e,t,true);this._publishSelectionChanges(i)};d.prototype.removeSelectionInterval=function(e,t){var i=this._setSelectionInterval(e,t,false);this._publishSelectionChanges(i)};d.prototype.selectAll=function(){this._mTreeState.deselected={};var e={rowIndices:[],oldIndex:-1,selectAll:true};var t=-1;this._map(this._oRootNode,function(i){if(!i||!i.isArtificial){t++}if(i){if(i.groupID===this._sLeadSelectionGroupID){e.oldIndex=t}if(this._isNodeSelectable(i)){if(i.nodeState.selected!==true){e.rowIndices.push(t)}this.setNodeSelection(i.nodeState,true);e.leadGroupID=i.groupID;e.leadIndex=t}if(i.nodeState.expanded){i.nodeState.selectAllMode=true}}});this._publishSelectionChanges(e)};d.prototype._clearSelection=function(){var e=-1;var t=-1;var i;var o=[];if(this._oRootNode&&!this._oRootNode.nodeState.selectAllMode){i=0;for(var n in this._mTreeState.selected){if(n){i++}}}var r=function(i){if(!i||!i.isArtificial){e++}if(i){i.nodeState.selectAllMode=false;if(this._mTreeState.selected[i.groupID]){if(!i.isArtificial){o.push(e)}this.setNodeSelection(i.nodeState,false);if(i.groupID===this._sLeadSelectionGroupID){t=e}return true}}return false};this._match(this._oRootNode,[],i,r);if(this._oRootNode&&this._oRootNode.nodeState&&this._oRootNode.isArtificial){this._oRootNode.nodeState.selectAllMode=false}return{rowIndices:o,oldIndex:t,leadIndex:-1}};d.prototype.clearSelection=function(e){var t=this._clearSelection();if(!e){this._publishSelectionChanges(t)}};d.prototype._publishSelectionChanges=function(e){e.oldIndex=e.oldIndex||this.getSelectedIndex();e.rowIndices.sort(function(e,t){return e-t});if(e.leadIndex>=0&&e.leadGroupID){this._sLeadSelectionGroupID=e.leadGroupID}else if(e.leadIndex===-1){this._sLeadSelectionGroupID=undefined}else{e.leadIndex=e.oldIndex}if(e.rowIndices.length>0||e.leadIndex!=undefined&&e.leadIndex!==-1){this.fireSelectionChanged(e)}};d.prototype.setCollapseRecursive=function(e){this.bCollapseRecursive=!!e};d.prototype.getCollapseRecursive=function(){return this.bCollapseRecursive};d.prototype.attachSelectionChanged=function(e,t,i){this.attachEvent("selectionChanged",e,t,i);return this};d.prototype.detachSelectionChanged=function(e,t){this.detachEvent("selectionChanged",e,t);return this};d.prototype.fireSelectionChanged=function(e){this.fireEvent("selectionChanged",e);return this};return d},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/TreeBindingCompatibilityAdapter", ["sap/base/util/each"],function(t){"use strict";var e=function(e,n){Object.assign(e,{_init:function(t){this._bExpandFirstLevel=t;this.mContextInfo={};this._initContexts();if(t&&!this._bFirstLevelExpanded){this._expandFirstLevel()}},_initContexts:function(t){this.aContexts=this.getRootContexts(0,Number.MAX_VALUE);for(var e=0,n=this.aContexts.length;e<n;e++){var i=this._getContextInfo(this.aContexts[e]);this._setContextInfo({oContext:this.aContexts[e],iLevel:0,bExpanded:i?i.bExpanded:false})}if(this._bExpandFirstLevel&&!this._bFirstLevelExpanded){this._expandFirstLevel(t)}},_expandFirstLevel:function(e){var n=this;if(this.aContexts&&this.aContexts.length>0){t(this.aContexts.slice(),function(t,i){if(!e){n._loadChildContexts(i)}n._getContextInfo(i).bExpanded=true});this._bFirstLevelExpanded=true}},_fnFireFilter:e._fireFilter,_fireFilter:function(){this._fnFireFilter.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts)},_fnFireChange:e._fireChange,_fireChange:function(){this._fnFireChange.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts)},_restoreContexts:function(e){var n=this;var i=[];t(e.slice(),function(t,e){var o=n._getContextInfo(e);if(o&&o.bExpanded){i.push.apply(i,n._loadChildContexts(e))}});if(i.length>0){this._restoreContexts(i)}},_loadChildContexts:function(t){var e=this._getContextInfo(t);var n=this.aContexts?this.aContexts.indexOf(t):-1;var i=this.getNodeContexts(t,0,Number.MAX_VALUE);for(var o=0,s=i.length;o<s;o++){this.aContexts.splice(n+o+1,0,i[o]);var a=this._getContextInfo(i[o]);this._setContextInfo({oParentContext:t,oContext:i[o],iLevel:e.iLevel+1,bExpanded:a?a.bExpanded:false})}return i},_getContextInfo:function(t){return t?this.mContextInfo[t.getPath()]:undefined},_setContextInfo:function(t){if(t&&t.oContext){this.mContextInfo[t.oContext.getPath()]=t}},getLength:function(){return this.aContexts?this.aContexts.length:0},getContexts:function(t,e){return this.aContexts.slice(t,t+e)},getNodes:function(t,e){var n=this.getContexts(t,t+e);var i=[];for(var o=0;o<n.length;o++){var s=this._getContextInfo(n[o])||{};var a=n[o];i.push({context:a,level:s.iLevel,parent:s.oParentContext,nodeState:{expanded:s.bExpanded,collapsed:!s.bExpanded,selected:false}})}return i},hasChildren:function(){return true},nodeHasChildren:function(){return true},getContextByIndex:function(t){return this.aContexts[t]},getLevel:function(t){var e=this._getContextInfo(t);return e?e.iLevel:-1},isExpanded:function(t){var e=this.getContextByIndex(t);var n=this._getContextInfo(e);return n?n.bExpanded:false},expandContext:function(t){var e=this._getContextInfo(t);if(e&&!e.bExpanded){this.storeSelection();this._loadChildContexts(t);e.bExpanded=true;this._fireChange();this.restoreSelection()}},expand:function(t){this.expandContext(this.getContextByIndex(t))},collapseContext:function(t,e){var n=this._getContextInfo(t);if(n&&n.bExpanded){this.storeSelection();for(var i=this.aContexts.length-1;i>0;i--){if(this._getContextInfo(this.aContexts[i]).oParentContext===t){this.aContexts.splice(i,1)}}n.bExpanded=false;if(!e){this._fireChange()}this.restoreSelection()}},collapse:function(t){this.collapseContext(this.getContextByIndex(t))},collapseToLevel:function(t){if(!t||t<0){t=0}var e=this.aContexts.slice();for(var n=e.length-1;n>=0;n--){var i=this.getLevel(e[n]);if(i!=-1&&i>=t){this.collapseContext(e[n],true)}}this._fireChange()},toggleContext:function(t){var e=this._getContextInfo(t);if(e){if(e.bExpanded){this.collapseContext(t)}else{this.expandContext(t)}}},toggleIndex:function(t){this.toggleContext(this.getContextByIndex(t))},storeSelection:function(){var e=n.getSelectedIndices();var i=[];t(e,function(t,e){i.push(n.getContextByIndex(e))});this._aSelectedContexts=i},restoreSelection:function(){n.clearSelection();var e=this._aSelectedContexts;t(this.aContexts,function(t,i){if((e?e.indexOf(i):-1)>=0){n.addSelectionInterval(t,t)}});this._aSelectedContexts=undefined},attachSelectionChanged:function(){return undefined},detachSelectionChanged:function(){},clearSelection:function(){n._oSelection.clearSelection()},attachSort:function(){},detachSort:function(){}});e._init(n.getExpandFirstLevel())};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/TreeBindingUtils", function(){"use strict";var i=function(){};i.mergeSections=function(i,e){var t=[];for(var r=0;r<i.length;r++){var n=i[r];var s=n.startIndex+n.length;var a=e.startIndex+e.length;if(e.startIndex<=s&&a>=s&&e.startIndex>=n.startIndex){e.startIndex=n.startIndex;e.length=a-n.startIndex}else if(e.startIndex<=n.startIndex&&a>=n.startIndex&&a<=s){e.length=s-e.startIndex}else if(e.startIndex>=n.startIndex&&a<=s){e.startIndex=n.startIndex;e.length=n.length}else if(a<n.startIndex||e.startIndex>s){t.push(n)}}t.push(e);return t};i._determineRequestDelta=function(i,e){var t=i.iSkip+i.iTop;var r=e.iSkip+e.iTop;if(i.iSkip===e.iSkip&&i.iTop===e.iTop){return false}else if(i.iSkip<e.iSkip&&t>e.iSkip&&t<=r){i.iTop=e.iSkip-i.iSkip;if(i.iThreshold){i.iTop=i.iTop+i.iThreshold;i.iSkip=Math.max(0,i.iSkip-i.iThreshold);i.iThreshold=0}}else if(i.iSkip<r&&t>r&&i.iSkip>=e.iSkip){i.iSkip=r;i.iTop=t-i.iSkip;if(i.iThreshold){i.iTop+=i.iThreshold;i.iThreshold=0}}else if(i.iSkip>=e.iSkip&&t<=r){return false}else if(i.iSkip<=e.iSkip&&t>=r){e.oRequestHandle.abort()}else if(t<=e.iSkip||i.iSkip>=r){}return undefined};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/_Helper", ["sap/base/util/deepEqual","sap/base/util/extend","sap/base/util/isPlainObject","sap/base/util/merge"],function(e,a,s,i){"use strict";var t={deepEqual:e,extend:a,isPlainObject:s,merge:i};return t},false);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/analytics/AnalyticalBinding", ["./BatchResponseCollector","./odata4analytics","sap/base/Log","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/uid","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/Sorter","sap/ui/model/TreeAutoExpandMode","sap/ui/model/TreeBinding","sap/ui/model/odata/CountMode","sap/ui/model/odata/ODataUtils"],function(e,t,i,r,s,n,a,o,u,l,d,h,p,f,g,y,c,v){"use strict";var m="sap.ui.model.analytics.AnalyticalBinding",_=0,I=i.getLogger(m);function R(e){var i,r,s,n,a,o,u,l,d,h=new t.QueryResultRequest(e.oAnalyticalQueryResult),p=e.mParameters.select.split(","),f=q(p,e.sPath);h.setAggregationLevel(e.aMaxAggregationLevel);h.setMeasures(e.aMeasureName);Object.keys(e.oDimensionDetailsSet).forEach(function(t){n=e.oDimensionDetailsSet[t];h.includeDimensionKeyTextAttributes(t,true,n.textPropertyName!==undefined,n.aAttributeName)});Object.keys(e.oMeasureDetailsSet).forEach(function(t){u=e.oMeasureDetailsSet[t];h.includeMeasureRawFormattedValueUnit(t,u.rawValuePropertyName!==undefined,u.formattedValuePropertyName!==undefined,u.unitPropertyName!==undefined)});s=h.getURIQueryOptionValue("$select");if(s){r=s.split(",");for(a=0,l=r.length;a<l;a++){d=r[a];o=p.indexOf(d);if(o<0){i=e.mAnalyticalInfoByProperty[d];if(!i||!i.visible&&!i.inResult){continue}I.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+d+"'",e.sPath);f=true}else{p.splice(o,1)}}}const g=[];for(a=0;a<p.length;a+=1){d=p[a];n=e.oAnalyticalQueryResult.findDimensionByPropertyName(d);if(n){const t=e.oDimensionDetailsSet[n.getName()];if(t===undefined){M(e.sPath,d,n);f=true}else{b._updateDimensionDetailsTextProperty(n,d,t);continue}}u=e.oAnalyticalQueryResult.findMeasureByPropertyName(d);if(u&&e.oMeasureDetailsSet[u.getName()]===undefined){M(e.sPath,d,u);f=true}g.push(d)}return f?[]:g}function M(e,i,r){var s=r instanceof t.Dimension?"dimension":"measure";if(r.getName()===i){I.warning("Ignored the 'select' binding parameter, because it contains"+" the "+s+" property '"+i+"' which is not contained in the analytical info (see updateAnalyticalInfo)",e)}else{I.warning("Ignored the 'select' binding parameter, because the property '"+i+"' is associated with the "+s+" property '"+r.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",e)}}function q(e,t){var i,r=false,s,n;for(s=0,n=e.length;s<n;s++){e[s]=e[s].trim()}for(s=e.length-1;s>=0;s--){i=e[s];if(e.indexOf(i)!==s){I.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+i+"' multiple times",t);e.splice(s,1);r=true}}return r}var b=y.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(e,t,i,r,s,n){y.call(this,e,t,i,s,n);this.aAdditionalSelects=[];this.sEntitySetName=n.entitySet?n.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(s);this.aControlFilter=undefined;this.aSorter=r?r:[];if(!Array.isArray(this.aSorter)){this.aSorter=[this.aSorter]}this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=n.useBatchRequests===true;this.bProvideTotalSize=n.provideTotalResultSize!==false;this.bProvideGrandTotals=n.provideGrandTotals!==false;this.bReloadSingleUnitMeasures=n.reloadSingleUnitMeasures!==false;this.bUseAcceleratedAutoExpand=n.useAcceleratedAutoExpand!==false;this.bNoPaging=n.noPaging===true;_+=1;this._iId=_;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(n.countMode==c.None){I.fatal("requested count mode is ignored; OData requests will include"+" $inlinecount options")}else if(n.countMode==c.Request||n.countMode==c.Both){I.warning("default count mode is ignored; OData requests will include"+" $inlinecount options")}else if(this.oModel.sDefaultCountMode==c.Request){I.warning("default count mode is ignored; OData requests will include"+" $inlinecount options")}this.iModelVersion=b._getModelVersion(this.oModel);if(this.iModelVersion===null){I.error("The AnalyticalBinding does not support the given model");return}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=n.analyticalInfo;this.bInitial=true}});function x(e,t){return function(){if(!e.__supportUID){e.__supportUID=o()}return{type:m,analyticalError:t,analyticalBindingId:e.__supportUID}}}b.prototype.setContext=function(e){var t;if(this.oContext!==e){this.oContext=e;if(!this.isRelative()){return}this.oDataState=null;this.bApplySortersToGroups=true;this.iTotalSize=-1;this._abortAllPendingRequests();t=this.getResolvedPath();if(t){this.resetData();this._initialize();this._fireChange({reason:u.Context})}else{this.bInitial=true}}};b.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var e=this.isRelative();if(!e||e&&this.oContext){this._initialize()}this._fireRefresh({reason:u.Refresh})}return this};b.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw"Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition."}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:u.Refresh})}};b.prototype.getRootContexts=function(e,t,i,r){if(typeof e!=="object"){e={length:t,numberOfExpandedLevels:i,startIndex:e,threshold:r}}if(this.isInitial()){return[]}var s=e&&e.numberOfExpandedLevels?e.numberOfExpandedLevels+1:1;var n=null;var a=this._getRequestId(b._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(a)){return n}n=this._getContextsForParentContext(null);if(n.length==1){return n}if(s<=1){if(s==1){this._considerRequestGrouping([a,this._getRequestId(b._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:e.startIndex,length:e.length,threshold:e.threshold,level:0,numberOfExpandedLevels:0})}}else{var o=this._prepareGroupMembersAutoExpansionRequestIds("/",e.numberOfExpandedLevels);o.push(a);this._considerRequestGrouping(o);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:e.startIndex,length:e.length,threshold:e.threshold,level:0,numberOfExpandedLevels:e.numberOfExpandedLevels})}if(n.length>1){I.fatal("assertion failed: grand total represented by a single entry")}return n};b.prototype.getNodeContexts=function(e,t){if(this.isInitial()){return[]}var i,r,s,n,a,o;if(typeof t=="object"){i=t.startIndex;r=t.length;s=t.threshold;n=t.level;a=t.numberOfExpandedLevels;o=t.supressRequest}else{i=arguments[1];r=arguments[2];s=arguments[3];n=arguments[4];a=arguments[5];o=arguments[6]}var u=this._getContextsForParentContext(e,i,r,s,n,a,o);return u};b.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};b.prototype.hasAvailableNodeContexts=function(e,t){var i=this._getGroupIdFromContext(e,t);if(this._getKeys(i)!=undefined){if(this.mFinalLength[i]==true){return b.prototype.ContextsAvailabilityStatus.ALL}else{return b.prototype.ContextsAvailabilityStatus.SOME}}else{return b.prototype.ContextsAvailabilityStatus.NONE}};b.prototype.getGroupSize=function(e,t){if(e===undefined){return 0}var i=this._getGroupIdFromContext(e,t);return this.mFinalLength[i]?this.mLength[i]:-1};b.prototype.getCount=function(){return this.iTotalSize>=0?this.iTotalSize:undefined};b.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){I.fatal("total size of result explicitly turned off, but getter invoked")}return this.iTotalSize};b.prototype.hasChildren=function(e,t){t=t||{level:1};if(e===undefined){return false}if(e==null){return true}var i=t.level;if(i==0){return true}if(this.aAggregationLevel.length<i){return false}return this.aMaxAggregationLevel.indexOf(this.aAggregationLevel[i-1])<this.aMaxAggregationLevel.length-1};b.prototype.hasMeasures=function(){var e=false;for(var t in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(t)){e=true;break}}return e};b.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet};b.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet};b.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals};b.prototype.getProperty=function(e){if(this.isInitial()){return{}}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(e)};b.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[]}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames()};b.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[]}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames()};b.prototype.getPropertyLabel=function(e){if(this.isInitial()){return""}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(e)};b.prototype.getPropertyHeading=function(e){if(this.isInitial()){return""}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(e)};b.prototype.getPropertyQuickInfo=function(e){if(this.isInitial()){return""}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(e)};b.prototype.isMeasure=function(e){return this.aMeasureName&&this.aMeasureName.indexOf(e)!==-1};b.prototype.filter=function(e,t){if(!e){e=[]}if(e instanceof l){e=[e]}e=this._convertDeprecatedFilterObjects(e);if(t==p.Application){this.aApplicationFilter=e}else{this.aControlFilter=e}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:u.Filter});return this};b.prototype.getFilterInfo=function(e){var t=h.combineFilters(this.aControlFilter,this.aApplicationFilter);if(t){return t.getAST(e)}return null};b.prototype.sort=function(e){if(e instanceof f){e=[e]}this.aSorter=e?e:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:u.Sort});this._fireRefresh({reason:u.Sort});return this};b.prototype.getGroupName=function(e,t){if(e===undefined){return""}var i=this.aAggregationLevel[t-1],r=this.oAnalyticalQueryResult.findDimensionByPropertyName(i),s=this.mAnalyticalInfoByProperty[i]&&this.mAnalyticalInfoByProperty[i].formatter,n=e.getProperty(i),a,o,u,l,d,h,p,f;if(r&&this.oDimensionDetailsSet[i].textPropertyName){d=r.getTextProperty()}if(d){h=d.name;f=this.mAnalyticalInfoByProperty[h]&&this.mAnalyticalInfoByProperty[h].formatter;p=e.getProperty(h);a=s?s(n,p):n;o=f?f(p,n):p}else{a=s?s(n):n}l=r.getLabelText&&r.getLabelText();u=(l?l+": ":"")+a;if(o){u+=" - "+o}return u};b.prototype.updateAnalyticalInfo=function(e,r){var s,a,o,l,d=this;function h(e){var t=e.level,i=e.name;l=l||o.getAllHierarchyPropertyNames();l.forEach(function(r){var s=d.oAnalyticalQueryResult.findDimensionByPropertyName(r).getHierarchy(),n=null,a=s.getNodeIDProperty().name,u;if(a===i){n=p(s)}else{u=s.getNodeExternalKeyProperty();if(u&&u.name===i){n=p(s);n.nodeExternalKeyName=i}else{u=o.getTextPropertyOfProperty(a);if(u&&u.name===i){n=p(s);n.nodeTextName=i}}}if(n&&"level"in e){if(typeof t==="number"){if("level"in n&&n.level!==t){throw new Error("Multiple different level filter for hierarchy '"+a+"' defined")}n.level=t;n.grouped=!!e.grouped}else{throw new Error("The level of '"+a+"' has to be an integer value")}}})}function p(e){var t=e.getNodeIDProperty().name,i,r=d.mHierarchyDetailsByName[t];if(!r){i=e.getNodeLevelProperty();r={dimensionName:e.getNodeValueProperty().name,nodeIDName:t,nodeLevelName:i&&i.name};d.mHierarchyDetailsByName[t]=r}return r}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return}s=t.helper.deepEqual(this._aLastChangedAnalyticalInfo,e,function(e){d.mAnalyticalInfoByProperty[e.name].formatter=e.formatter});if(s){this._aLastChangedAnalyticalInfo=[];for(var f=0;f<e.length;f++){this._aLastChangedAnalyticalInfo[f]=n({},e[f])}}if(s<2){if(r||s){setTimeout(function(){this._fireChange({reason:u.Change})}.bind(this),0)}return}var g=this.oDimensionDetailsSet||{},y=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};o=this.oAnalyticalQueryResult.getEntityType();for(var c=0;c<e.length;c++){var v=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[c].name);if(v&&(e[c].inResult==true||e[c].visible==true)){e[c].dimensionPropertyName=v.getName();a=this.oDimensionDetailsSet[v.getName()];if(!a){a={};a.name=v.getName();a.aAttributeName=[];a.grouped=false;this.oDimensionDetailsSet[v.getName()]=a;this.aMaxAggregationLevel.push(a.name);if(e[c].grouped==true){this.aAggregationLevel.push(a.name)}}if(e[c].grouped==true){if(!this.getSortablePropertyNames()||this.getSortablePropertyNames().indexOf(v.getName())==-1){I.fatal("property "+v.getName()+" must be sortable in order to be used as grouped dimension")}a.grouped=true}if(v.getName()==e[c].name){a.keyPropertyName=e[c].name}b._updateDimensionDetailsTextProperty(v,e[c].name,a);if(v.findAttributeByName(e[c].name)){a.aAttributeName.push(e[c].name)}a.analyticalInfo=e[c]}var m=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[c].name);if(m&&(e[c].inResult==true||e[c].visible==true)){e[c].measurePropertyName=m.getName();var _=this.oMeasureDetailsSet[m.getName()];if(!_){_={};_.name=m.getName();this.oMeasureDetailsSet[m.getName()]=_;this.aMeasureName.push(_.name)}if(m.getRawValueProperty().name==e[c].name){_.rawValuePropertyName=e[c].name}var M=m.getFormattedValueProperty();if(M&&M.name==e[c].name){_.formattedValuePropertyName=e[c].name}_.analyticalInfo=e[c]}if(!v&&!m){h(e[c])}this.mAnalyticalInfoByProperty[e[c].name]=e[c]}Object.keys(this.mHierarchyDetailsByName).forEach(function(e){var t=d.mHierarchyDetailsByName[e];if(!("level"in t)){delete d.mHierarchyDetailsByName[e];if(I.isLoggable(i.Level.INFO)){I.info("No level specified for hierarchy node '"+e+"'; ignoring hierarchy","")}}else if(!d.oDimensionDetailsSet[e]){d.oDimensionDetailsSet[e]={aAttributeName:[],grouped:t.grouped,isHierarchyDimension:true,name:e};d.aMaxAggregationLevel.push(e);if(t.grouped){d.aAggregationLevel.push(e)}}});for(var q in this.oMeasureDetailsSet){var x=this.oAnalyticalQueryResult.findMeasureByName(q).getUnitProperty();if(x){this.oMeasureDetailsSet[q].unitPropertyName=x.name}}var S=Object.keys(g).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(S){this.iTotalSize=-1}if(S||Object.keys(y).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=R(this)}if(r){this._fireChange({reason:u.Change})}};b.prototype.getAnalyticalInfoForColumn=function(e){return this.mAnalyticalInfoByProperty[e]};b.prototype.loadGroups=function(e){var t=[];for(var i in e){t.push(i);this._resetData(i);var r=e[i];for(var s=0;s<r.length;s++){var n=r[s];this._getContextsForParentGroupId(i,n.startIndex,n.length,n.threshold)}var a=[];for(var o=-1,u;(u=t[++o])!==undefined;){a.push(this._getRequestId(b._requestType.groupMembersQuery,{groupId:u}))}this._considerRequestGrouping(a)}};b.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult};b._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};b._artificialRootContextGroupId="artificialRootContext";b._addHierarchyLevelFilters=function(e,t){e.forEach(function(e){t.removeConditions(e.propertyName);t.addCondition(e.propertyName,d.EQ,e.level)})};b._getModelVersion=function(e){const t=e.getMetadata().getName();let i=t==="sap.ui.model.odata.v2.ODataModel"?2:null;if(t==="sap.ui.model.odata.ODataModel"){i=1}return i};b.prototype._getContextsForParentContext=function(e,t,i,r,s,n,a){if(e===undefined){return[]}if(e&&e.getPath()=="/"+b._artificialRootContextGroupId){e=this.getModel().getContext("/")}var o=this._getGroupIdFromContext(e,s);return this._getContextsForParentGroupId(o,t,i,r,n,a)};b.prototype._getContextsForParentGroupId=function(e,t,i,r,s,n){if(e===undefined){return[]}if(!t){t=0}if(!i){i=this.oModel.iSizeLimit}if(this.mFinalLength[e]&&this.mLength[e]<t+i){i=this.mLength[e]-t;if(i<0){I.fatal("invalid start index greater than total group length passed")}}if(!r){r=0}if(!s){s=0}if(e==null){if(s>0){I.fatal("invalid request to determine nodes of root context");return null}}else{if(this._getGroupIdLevel(e)>=this.aAggregationLevel.length&&s>0){I.fatal("invalid request to determine nodes of context with group ID "+e);return null}if(this._getGroupIdLevel(e)+s>this.aAggregationLevel.length){s=this.aAggregationLevel.length-this._getGroupIdLevel(e)-1}}var a=[],o,u,l,d;var h=e==null?0:this._getGroupIdLevel(e)+1;if(!this.aMultiUnitLoadFactor[h]){this.aMultiUnitLoadFactor[h]=1}var p=s>0&&e!=null;if(p){var f=this._getGroupIdLevel(e);var g=f+s;var y=true;if(!n){l=this._calculateRequiredGroupExpansion(e,g,t,i+r);y=l.groupId_Missing==null;y=y||l.groupId_Missing.length<e.length||l.groupId_Missing.substring(0,e.length)!=e}if(y){a=this._getLoadedContextsForGroup(e,t,i)}else{d=i+r}o=!y;d=Math.ceil(d*this.aMultiUnitLoadFactor[h])}else{a=this._getLoadedContextsForGroup(e,t,i,n);o=false;if(!n){if(this._oWatermark&&e===this._oWatermark.groupID){r=1e4}u=this._calculateRequiredGroupSection(e,t,i,r);var c=u.length>0&&i<u.length;o=a.length!=i&&!(this.mFinalLength[e]&&a.length>=this.mLength[e]-t)||c;u.length=Math.ceil(u.length*this.aMultiUnitLoadFactor[h])}}if(!o){this._cleanupGroupingForCompletedRequest(this._getRequestId(b._requestType.groupMembersQuery,{groupId:e}))}var v=false;if(this.oModel.getServiceMetadata()){if(o){var m=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(b._requestType.totalSizeQuery));v=true;var _;if(this.bUseBatchRequests){if(p){_=this._prepareGroupMembersAutoExpansionRequestIds(e,s);for(var R=-1,M;(M=_[++R])!==undefined;){if(this._isRequestPending(M)){v=false;break}}if(v){this.aBatchRequestQueue.push([b._requestType.groupMembersAutoExpansionQuery,e,l,d,s])}}else{v=u.length&&!this._isRequestPending(this._getRequestId(b._requestType.groupMembersQuery,{groupId:e}));if(v){this.aBatchRequestQueue.push([b._requestType.groupMembersQuery,e,u.startIndex,u.length]);_=[this._getRequestId(b._requestType.groupMembersQuery,{groupId:e})]}}if(v&&m){_.push(this._getRequestId(b._requestType.totalSizeQuery));this._considerRequestGrouping(_);this.aBatchRequestQueue.push([b._requestType.totalSizeQuery])}if(v){if(e==null){this._abortAllPendingRequests()}Promise.resolve().then(b.prototype._processRequestQueue.bind(this))}}else{var q;if(p){_=this._prepareGroupMembersAutoExpansionRequestIds(e,s);for(var x=-1,S;(S=_[++x])!==undefined;){if(this._isRequestPending(S)){v=false;break}}if(v){q=this._prepareGroupMembersAutoExpansionQueryRequest(b._requestType.groupMembersAutoExpansionQuery,e,l,d,s)}}else{v=u.length&&!this._isRequestPending(this._getRequestId(b._requestType.groupMembersQuery,{groupId:e}));if(v){q=this._prepareGroupMembersQueryRequest(b._requestType.groupMembersQuery,e,u.startIndex,u.length);_=[q.sRequestId]}}if(v){if(e==null){this._abortAllPendingRequests()}this._executeQueryRequest(q);if(m&&!q.bIsFlatListRequest){_.push(this._getRequestId(b._requestType.totalSizeQuery));this._considerRequestGrouping(_);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(b._requestType.totalSizeQuery))}}}}}return a};b.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(e,t){var i,r=[],s=this;if(t===null){return r}i=Object.keys(this.mHierarchyDetailsByName);if(i.length>0&&t!=="/"){I.error("Hierarchy cannot be requested for members of a group",t);return r}i.forEach(function(t){var i=s.mHierarchyDetailsByName[t];e.addRecursiveHierarchy(i.dimensionName,!!i.nodeExternalKeyName,!!i.nodeTextName);r.push({propertyName:i.nodeLevelName,level:i.level})});return r};b.prototype._getNonHierarchyDimensions=function(e){var t=this;return e.filter(function(e){return!t.oDimensionDetailsSet[e].isHierarchyDimension})};b.prototype._processRequestQueue=function(e){if(e===undefined||e===null){e=this.aBatchRequestQueue||[]}if(e.length==0){return}var t=[];var i=false;var r,s,n;for(r=-1;(n=e[++r])!==undefined;){if(n[0]==b._requestType.groupMembersQuery){s=b.prototype._prepareGroupMembersQueryRequest.apply(this,n);i=i||s.bIsFlatListRequest;t.push(s)}}for(r=-1;(n=e[++r])!==undefined;){s=null;switch(n[0]){case b._requestType.groupMembersQuery:continue;case b._requestType.totalSizeQuery:if(!i){s=b.prototype._prepareTotalSizeQueryRequest.apply(this,n);t.push(s)}break;case b._requestType.groupMembersAutoExpansionQuery:s=b.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,n);for(var a=-1,o;(o=s.aGroupMembersAutoExpansionRequestDetails[++a])!==undefined;){t.push(o)}break;case b._requestType.reloadMeasuresQuery:{var u=n[1];for(var l=-1,d;(d=u[++l])!==undefined;){t.push(d)}break}default:I.fatal("unhandled request type "+e[r][0]);continue}}if(t.length>1){this._executeBatchRequest(t)}else{this._executeQueryRequest(t[0])}if(e===this.aBatchRequestQueue){this.aBatchRequestQueue=[]}};b.prototype._prepareGroupMembersQueryRequest=function(e,i,r,s){var n=[],a=[],o;var u=new t.QueryResultRequest(this.oAnalyticalQueryResult);u.setResourcePath(this._getResourcePath());u.getSortExpression().clear();var l=0,h=-1;if(i){n=this._getGroupIdComponents(i);l=h=n.length;var p=0;for(var f=0,g=0;f<l;g++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[g]].grouped==false){++p}else{++f}}l=h=l+p;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[h]].grouped==false){if(++h==this.aMaxAggregationLevel.length){break}}}}var y=h>=this.aMaxAggregationLevel.length-1;o=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(u,i);var c=this.aMaxAggregationLevel.slice(0,h+1);var v=this._getNonHierarchyDimensions(c);u.setAggregationLevel(v);for(var m=0;m<v.length;m++){var _=this.oDimensionDetailsSet[v[m]];var R=_.textPropertyName!=undefined;u.includeDimensionKeyTextAttributes(_.name,true,R,_.aAttributeName);if(_.grouped){a.push({sPath:v[m],bDescending:false})}}var M=u.getFilterExpression();M.clear();if(this.aApplicationFilter){M.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){M.addUI5FilterConditions(this.aControlFilter)}if(l>=1){for(var q=0,x=n.length;q<x;q++){M.removeConditions(this.aAggregationLevel[q]);M.addCondition(this.aAggregationLevel[q],d.EQ,n[q])}}b._addHierarchyLevelFilters(o,M);var S;var A;var P;var L;var N=[];if(i!=null||this.bProvideGrandTotals||this._canApplySortersToGroups()&&this.aSorter.length>0){u.setMeasures(this.aMeasureName);for(var D in this.oMeasureDetailsSet){L=this.oMeasureDetailsSet[D];if(!y&&this._isSkippingTotalForMeasure(D)){S=false;A=false;P=false}else{S=L.rawValuePropertyName!=undefined;A=L.formattedValuePropertyName!=undefined;P=L.unitPropertyName!=undefined;if(P){if(N.indexOf(L.unitPropertyName)==-1){N.push(L.unitPropertyName)}}}u.includeMeasureRawFormattedValueUnit(L.name,S,A,P)}for(var G in v){var Q;if((Q=N.indexOf(v[G]))!=-1){N.splice(Q,1)}}}if(i){this._addSorters(u.getSortExpression(),a)}if(s==0){I.fatal("unhandled case: load 0 entities of sub group")}var F=this._getKeyIndexMapping(i,r);if(!this.bNoPaging){u.setResultPageBoundaries(F.iServiceKeyIndex+1,F.iServiceKeyIndex+s)}u.setRequestOptions(null,!this.mFinalLength[i]);return{iRequestType:e,sRequestId:this._getRequestId(b._requestType.groupMembersQuery,{groupId:i}),oAnalyticalQueryRequest:u,sGroupId:i,aSelectedUnitPropertyName:N,aAggregationLevel:c,bIsFlatListRequest:y&&l==0,bIsLeafGroupsRequest:y,iStartIndex:r,iLength:s,oKeyIndexMapping:F}};b.prototype._prepareTotalSizeQueryRequest=function(e){var i;var r=new t.QueryResultRequest(this.oAnalyticalQueryResult);r.setResourcePath(this._getResourcePath());i=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(r,"/");r.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));r.setMeasures([]);var s=r.getFilterExpression();s.clear();if(this.aApplicationFilter){s.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){s.addUI5FilterConditions(this.aControlFilter)}b._addHierarchyLevelFilters(i,s);r.setRequestOptions(null,null,true);r.setRequestOptions(null,true);return{iRequestType:e,sRequestId:this._getRequestId(b._requestType.totalSizeQuery),oAnalyticalQueryRequest:r}};b.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(e,i,s,n,a){var o=this;var u=function(e,t){var i=[];if(e.groupId_Missing==null){I.fatal("missing group Id not present");return i}var s=o._getGroupIdComponents(e.groupId_Missing);var n=s.length;if(n>t){I.fatal("the given group ID is too deep for requested level for auto expansion");return i}var a=[];for(var u=0;u<n;u++){var h=o.aAggregationLevel[u];var p=s[u];var f=o._getFilterOperatorMatchingPropertySortOrder(h);a[u]=new l(h,f,p)}var g=null;if(e.startIndex_Missing>0){var y=o._getKey(e.groupId_Missing,e.startIndex_Missing-1);var c=o.oModel.getObject("/"+y);var v=o.aAggregationLevel[n];var m=c[v];g=new l(v,o._getFilterOperatorMatchingPropertySortOrder(v,false),m)}for(var _=0;_<t;_++){var R=[];var M=Math.min(n,_+1);for(var q=0;q<M;q++){var b=[];var x=Math.min(n,q+1);var S=e.startIndex_Missing>0;for(var A=0;A<x;A++){var P=new l("x",d.EQ,"x");P=r(P,a[A]);if(x>1&&A<x-1){P.sOperator=d.EQ}if(A==n-1&&_>n-1&&!S){if(P.sOperator==d.GT){P.sOperator=d.GE}else{P.sOperator=d.LE}}b.push(P)}if(b.length>0){R.push(new l(b,true));if(_>n-1&&q==n-1&&S){var L=[];for(var N=0;N<b.length;N++){var D=new l("x",d.EQ,"x");D=r(D,b[N]);L.push(D)}L[n-1].sOperator=d.EQ;L.push(g);R.push(new l(L,true));break}}}if(R.length>0){i[_]=new l(R,false)}else{i[_]=null}}return i};var h=function(e,i,r,s,n,a,u,l){var d;var h=new t.QueryResultRequest(o.oAnalyticalQueryResult);h.setResourcePath(o._getResourcePath());h.getSortExpression().clear();var p=0,g=-1;p=g=r-1;var y=0;for(var c=0,v=0;c<p;v++){if(o.oDimensionDetailsSet[o.aMaxAggregationLevel[v]].grouped==false){++y}else{++c}}p=g=p+y;if(o.aMaxAggregationLevel.length>0){while(o.aMaxAggregationLevel[g]&&o.oDimensionDetailsSet[o.aMaxAggregationLevel[g]].grouped==false){if(++g==o.aMaxAggregationLevel.length){break}}}var m=g>=o.aMaxAggregationLevel.length-1;d=o._getHierarchyLevelFiltersAndAddRecursiveHierarchy(h,i);var _=o.aMaxAggregationLevel.slice(0,g+1);h.setAggregationLevel(_);const R=[];for(var M=0;M<_.length;M++){var q=o.oDimensionDetailsSet[_[M]];var x=q.textPropertyName!=undefined;h.includeDimensionKeyTextAttributes(q.name,true,x,q.aAttributeName);if(q.grouped){R.push(new f(_[M]))}}var S=h.getFilterExpression();S.clear();if(o.aApplicationFilter){S.addUI5FilterConditions(o.aApplicationFilter)}if(o.aControlFilter){S.addUI5FilterConditions(o.aControlFilter)}if(s){S.addUI5FilterConditions([s])}b._addHierarchyLevelFilters(d,S);var A;var P;var L;var N;var D=[];h.setMeasures(o.aMeasureName);for(var G in o.oMeasureDetailsSet){N=o.oMeasureDetailsSet[G];if(!m&&o._isSkippingTotalForMeasure(G)){A=false;P=false;L=false}else{A=N.rawValuePropertyName!=undefined;P=N.formattedValuePropertyName!=undefined;L=N.unitPropertyName!=undefined;if(L){if(D.indexOf(N.unitPropertyName)==-1){D.push(N.unitPropertyName)}}}h.includeMeasureRawFormattedValueUnit(N.name,A,P,L)}for(var Q in _){var F;if((F=D.indexOf(_[Q]))!=-1){D.splice(F,1)}}o._mergeAndAddSorters(R,h.getSortExpression());if(a==0){I.fatal("unhandled case: load 0 entities of sub group")}var T=n;if(!l){T=0}else{var C=0;for(var E in o.mServiceKey){if(E.split("/").length===r+1){C+=o.mServiceKey[E].length}}T=Math.max(T,C)}if(!o.bNoPaging){h.setResultPageBoundaries(T+1,T+a)}return{iRequestType:e,sRequestId:null,oAnalyticalQueryRequest:h,iLevel:r,aSelectedUnitPropertyName:D,aAggregationLevel:_,bIsFlatListRequest:m,bIsLeafGroupsRequest:m,iStartIndex:n,iLength:a,bAvoidLengthUpdate:u}};var p=[];var g=[];if(!s){I.fatal("no first missing group member specified")}var y=this._getGroupIdLevel(i)+a+1;var c=o._getGroupIdComponents(s.groupId_Missing);var v=c.length;var m=u(s,y);var _;for(var R=1;R<=y;R++){var M;if(R>=v+2){M=0;_=undefined}else if(R==v+1){M=s.startIndex_Missing;_=s.groupId_Missing}else if(v>0){if(R==v){_=s.groupId_Missing}else{_=this._getGroupIdAncestors(s.groupId_Missing,-(v-R))[0]}var q=this._getGroupIdAncestors(s.groupId_Missing,-(v-R+1))[0];if(!q){I.fatal("failed to determine group id at parent level; group ID = "+i+", level = "+R)}M=this._findKeyIndex(q,this.mEntityKey[_]);if(M==-1){I.fatal("failed to determine position of value "+_+" in group "+q)}_=q;M++}var x=n>R?Math.ceil((n-R)/(y-R+1)):n;var S=m[R-1];if(this.bUseAcceleratedAutoExpand){var A=h(b._requestType.levelMembersQuery,i,R,S,M,x,false,S==null?true:false);A.sGroupId_Missing_AtLevel=_;A.sRequestId=this._getRequestId(b._requestType.levelMembersQuery,{groupId:i,level:R});p.push(A);g.push(A.sRequestId)}else if(S&&S.aFilters.length>0){if(!S._bMultiFilter||S.bAnd){I.fatal("level filter in wrong shape; cannot break it up")}for(var P=0;P<S.aFilters.length;P++){var L=S.aFilters[P];var N=h(b._requestType.levelMembersQuery,i,R,L,M,x,false,S==null?true:false);N.sGroupId_Missing_AtLevel=_;N.sRequestId=this._getRequestId(b._requestType.levelMembersQuery,{groupId:i,level:R,tupleIndex:P});p.push(N);g.push(N.sRequestId)}}else{var D=h(b._requestType.levelMembersQuery,i,R,null,M,x,false,S==null?true:false);D.sGroupId_Missing_AtLevel=_;D.sRequestId=this._getRequestId(b._requestType.levelMembersQuery,{groupId:i,level:R});p.push(D);g.push(D.sRequestId)}}return{iRequestType:e,aRequestId:g,aGroupMembersAutoExpansionRequestDetails:p,sGroupId:i,iLength:n}};b.prototype._prepareReloadMeasurePropertiesQueryRequest=function(e,i,r){var s=new t.QueryResultRequest(this.oAnalyticalQueryResult);s.setResourcePath(this._getResourcePath());s.getSortExpression().clear();var n=i.aAggregationLevel;s.setAggregationLevel(n);var a=i.bIsLeafGroupsRequest;var o=s.getFilterExpression();o.clear();if(this.aApplicationFilter){o.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){o.addUI5FilterConditions(this.aControlFilter)}var u=[];for(var h=0;h<n.length;h++){var p=new l(n[h],d.EQ,r.oEntry[n[h]]);u.push(p)}o.addUI5FilterConditions(u);var f;var g;var y;var c;var v=[];s.setMeasures(r.aReloadMeasurePropertyName);for(var m in this.oMeasureDetailsSet){c=this.oMeasureDetailsSet[m];if(!r.aReloadMeasurePropertyName||r.aReloadMeasurePropertyName.indexOf(c.name)==-1){continue}if(!a&&this._isSkippingTotalForMeasure(m)){f=false;g=false;y=false}else{f=c.rawValuePropertyName!=undefined;g=c.formattedValuePropertyName!=undefined;y=c.unitPropertyName!=undefined;if(y){if(v.indexOf(c.unitPropertyName)==-1){v.push(c.unitPropertyName)}}}s.includeMeasureRawFormattedValueUnit(c.name,f,g,y)}for(var _ in n){var I;if((I=v.indexOf(n[_]))!=-1){v.splice(I,1)}}return{iRequestType:e,sRequestId:this._getRequestId(b._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(r.oEntry)}),oAnalyticalQueryRequest:s,aSelectedUnitPropertyName:v,aAggregationLevel:n,oMultiUnitRepresentative:r}};b.prototype._prepareGroupMembersAutoExpansionRequestIds=function(e,t){var i=this._getGroupIdLevel(e)+1;var r=i+t;var s=[];for(var n=i;n<=r;n++){s.push(this._getRequestId(b._requestType.levelMembersQuery,{groupId:e,level:n}))}return s};b.prototype._getQueryODataRequestOptions=function(e,t,i){var r;i=i||{};try{e.getFilterExpression().checkValidity()}catch(e){I.fatal("filter expression is not valid",e.toString());return undefined}var s=e.getURIQueryOptionValue("$select");var n=e.getURIQueryOptionValue("$filter");var a=e.getURIQueryOptionValue("$orderby");var o=e.getURIQueryOptionValue("$skip");var u=e.getURIQueryOptionValue("$top");var l=e.getURIQueryOptionValue("$inlinecount");if(t&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",")}if(this.mParameters&&this.mParameters["filter"]){if(n===null){n=this.mParameters["filter"]}else{n+="and ("+this.mParameters["filter"]+")"}}var d=[];if(s!==null){d.push("$select="+s)}if(n!==null){d.push("$filter="+n)}if(a!==null){d.push("$orderby="+a)}if(o!==null){d.push("$skip="+o)}if(u!==null){d.push("$top="+u)}if(l!==null){d.push("$inlinecount="+l)}if(i.encode===true){for(r=0;r<d.length;r++){d[r]=d[r].replace(/\ /g,"%20")}}return d};b.prototype._executeBatchRequest=function(t){var i=this.iAnalyticalInfoVersionNumber,r,s=this;var n=[],a=[];function o(){s.fireDataReceived({__simulateAsyncAnalyticalBinding:true})}var u=new e;function l(e,t){u.success(t)}function d(e,t){u.error(t||e)}this.bNeedsUpdate=true;for(var h=0;h<t.length;h++){var p=t[h];if(p.aAggregationLevel&&p.aAggregationLevel.length>0){this.bNeedsUpdate=false}}for(var f=-1,g;(g=t[++f])!==undefined;){var y=g.oAnalyticalQueryRequest,c=g.sGroupId;if(y.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});c=null;this.mServiceLength[c]=this.mLength[c]=1;this.mServiceFinalLength[c]=true;this._setServiceKey(this._getKeyIndexMapping(c,0),b._artificialRootContextGroupId);setTimeout(o);this.bArtificalRootContext=true;continue}var v=y.getURIToQueryResultEntries();if(!this.oContext&&v[0]!=="/"){v="/"+v}if(!this._isRequestPending(g.sRequestId)){this._registerNewRequest(g.sRequestId);if(this.iModelVersion===1){n.push(this.oModel.createBatchOperation(v.replace(/\ /g,"%20"),"GET"))}if(this.iModelVersion===2){var m=this._getQueryODataRequestOptions(y,g.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){m.push(this.sCustomParams)}var _=this.oModel.read(v.replace(/\ /g,"%20"),{success:l,error:d,context:this.oContext,urlParameters:m});n.push(_)}a.push(g)}}if(n.length>0){I.debug("AnalyticalBinding: executing batch request with "+a.length+" operations");var R;r=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===1){this.oModel.addBatchReadOperations(n);R=this.oModel.submitBatch(M,q,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}})}if(this.iModelVersion===2){R={abort:function(){for(var e=0;e<n.length;e++){n[e].abort()}}};u.setup({executedRequests:a,binding:this,success:M,error:q})}this._registerNewRequestHandle(r,R)}function M(e,t){s._deregisterHandleOfCompletedRequest(r);if(a.length!=e.__batchResponses.length){I.fatal("assertion failed: received "+e.__batchResponses.length+" responses for "+a.length+" read operations in the batch request")}if(i!=s.iAnalyticalInfoVersionNumber){for(var n=0;n<a.length;n++){var o=a[n].sRequestId;if(o!==undefined){s._deregisterCompletedRequest(o);s._cleanupGroupingForCompletedRequest(o)}}s.fireDataReceived({data:[]});return}var u=0;for(var l=0;l<e.__batchResponses.length;l++){if(e.__batchResponses[l].data!=undefined){if(e.__batchResponses[l].data.results.length==0){u++}switch(a[l].iRequestType){case b._requestType.groupMembersQuery:s._processGroupMembersQueryResponse(a[l],e.__batchResponses[l].data);break;case b._requestType.totalSizeQuery:s._processTotalSizeQueryResponse(a[l],e.__batchResponses[l].data);break;case b._requestType.levelMembersQuery:s._processLevelMembersQueryResponse(a[l],e.__batchResponses[l].data);break;case b._requestType.reloadMeasuresQuery:s._processReloadMeasurePropertiesQueryResponse(a[l],e.__batchResponses[l].data);break;default:I.fatal("invalid request type "+a[l].iRequestType);continue}}s._deregisterCompletedRequest(a[l].sRequestId);s._cleanupGroupingForCompletedRequest(a[l].sRequestId)}if(s.mParameters&&s.mParameters.numberOfExpandedLevels>0){if(u==e.__batchResponses.length){s.mLength["/"]=0;s.mFinalLength["/"]=true}}s.fireDataReceived({data:e});if(s.iModelVersion===1){let i=true;let r={};const n=s.oModel._getBatchErrors(e);if(n.length>0){i=false;r=s.oModel._handleError(n[0])}s.oModel.fireRequestCompleted({url:t.requestUri,type:"POST",async:true,info:"",infoObject:{},success:i,errorobject:i?{}:r});if(i){s.oModel.checkUpdate()}}}function q(e){if(e&&e.statusText!="abort"){s._deregisterHandleOfCompletedRequest(r);for(var t=-1,n;(n=a[++t])!==undefined;){s._deregisterCompletedRequest(n.sRequestId);s._cleanupGroupingForCompletedRequest(n.sRequestId)}}if(i!=s.iAnalyticalInfoVersionNumber){s.fireDataReceived();return}if(s.iModelVersion===1){e=s.oModel._handleError(e)}s.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:e});if(s.iModelVersion===1){s.oModel.fireRequestFailed(e)}s.fireDataReceived()}};b.prototype._executeQueryRequest=function(e){if(e.iRequestType==b._requestType.groupMembersAutoExpansionQuery){for(var t=-1,i;(i=e.aGroupMembersAutoExpansionRequestDetails[++t])!==undefined;){this._executeQueryRequest(i)}return}var r=this.iAnalyticalInfoVersionNumber;var s=e.oAnalyticalQueryRequest,n=e.sGroupId;var a=s.getURIToQueryResultEntitySet();var o=this._getQueryODataRequestOptions(s,e.bIsLeafGroupsRequest);if(!o){return}var u=this;if(s.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});n=null;this.mServiceLength[n]=this.mLength[n]=1;this.mServiceFinalLength[n]=true;this._setServiceKey(this._getKeyIndexMapping(n,0),b._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(u._cleanupGroupingForCompletedRequest(e.sRequestId)){u.fireDataReceived({__simulateAsyncAnalyticalBinding:true})}});this.bArtificalRootContext=true;return}this._registerNewRequest(e.sRequestId);this.fireDataRequested();for(var l=0;l<o.length;l++){o[l]=o[l].replace(/\ /g,"%20")}I.debug("AnalyticalBinding: executing query request");var d=this._getIdForNewRequestHandle();if(this.iModelVersion===1){this.oModel._loadData(a,o,p,g,false,y,f)}if(this.iModelVersion===2){if(this.sCustomParams){o.push(this.sCustomParams)}var h=this.oModel.read(a.replace(/ /g,"%20"),{success:p,error:g,context:this.oContext,urlParameters:o});u._registerNewRequestHandle(d,h)}function p(t){u._deregisterHandleOfCompletedRequest(d);if(r!=u.iAnalyticalInfoVersionNumber){u._deregisterCompletedRequest(e.sRequestId);return}switch(e.iRequestType){case b._requestType.groupMembersQuery:u._processGroupMembersQueryResponse(e,t);break;case b._requestType.totalSizeQuery:u._processTotalSizeQueryResponse(e,t);break;case b._requestType.levelMembersQuery:u._processLevelMembersQueryResponse(e,t);break;case b._requestType.reloadMeasuresQuery:u._processReloadMeasurePropertiesQueryResponse(e,t);break;default:I.fatal("invalid request type "+e.iRequestType);break}u._deregisterCompletedRequest(e.sRequestId);if(u.iModelVersion===2){f(t)}}function f(t){if(r!=u.iAnalyticalInfoVersionNumber){return}if(u._cleanupGroupingForCompletedRequest(e.sRequestId)){u.fireDataReceived({data:t})}}function g(t){if(t&&t.statusText=="abort"){u.fireDataReceived();return}u._deregisterHandleOfCompletedRequest(d);u._deregisterCompletedRequest(e.sRequestId);u._cleanupGroupingForCompletedRequest(e.sRequestId);if(r!=u.iAnalyticalInfoVersionNumber){return}u.fireDataReceived()}function y(e){u._registerNewRequestHandle(d,e)}};b.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests()};b.prototype._processGroupMembersQueryResponse=function(e,t){var i,r=e.sGroupId,s=this.aSorter.length>0,n=e.aSelectedUnitPropertyName,a=e.aAggregationLevel,o=e.oKeyIndexMapping.iIndex,u=e.oKeyIndexMapping.iServiceKeyIndex,l=e.iLength,d=e.oKeyIndexMapping,h=r==null?0:this._getGroupIdLevel(r)+1,p=n.length>0,f,g,y,c=0,v,m,_=[];var R=t.results.length;if(r===null&&R>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(s?"binding is refreshed":undefined);if(s){setTimeout(this.refresh.bind(this),0);return}}var M=this._getServiceKeys(r,d.iIndex-1);f=undefined;if(M&&M.length>0){for(var q=0,S=M.length;q<S;q++){t.results[q-S]=this.oModel.getObject("/"+M[q])}var A=t.results[-M.length];f="";for(var P=0;P<a.length;P++){f+=b._getDimensionValue(A[a[P]])+"|"}}v=M&&M.length==1;for(var L=0;L<R;L++){var N=t.results[L];if(p){g="";for(var D=0;D<a.length;D++){g+=b._getDimensionValue(N[a[D]])+"|"}if(f==g){this._warnNoSortingOfGroups();if(y===undefined){if(L==0){y=-M.length;d.iServiceKeyIndex-=M.length-1}else{y=L-1}}var G=-1,Q=t.results[L-1];for(var F=0;F<n.length;F++){if(Q[n[F]]!=N[n[F]]){G=F;break}}if(G==-1){I.fatal("assertion failed: no deviating units found for result entries "+(L-1)+" and "+L,null,null,x(this,"NO_DEVIATING_UNITS"))}}if((f!=g||L==R-1)&&y!==undefined){var T=[];for(var C=y;C<L;C++){T.push(t.results[C])}if(f==g){T.push(t.results[L])}var E=b._getDeviatingUnitPropertyNames(n,T);var K=this._createMultiUnitRepresentativeEntry(r,t.results[y],n,E,e.bIsFlatListRequest);if(K.aReloadMeasurePropertyName.length>0){m=this._prepareReloadMeasurePropertiesQueryRequest(b._requestType.reloadMeasuresQuery,e,K);if(m.oAnalyticalQueryRequest&&m.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){_.push(m)}}var O=this._setAdjacentMultiUnitKeys(d,K,T);var U;if(K.bIsNewEntry){U=T.length-1}else{U=O}if(v){v=false}if(U<0){I.fatal("assertion failed: iDiscardedEntriesCount must be non-negative")}c+=U;var w=this.oModel._getKey(K.oEntry);var V=this.oModel.getContext("/"+w);this._getGroupIdFromContext(V,h);this.mEntityKey[i]=w;y=undefined;if(f!=g){v=this._setServiceKey(d,this.oModel._getKey(N))}}else if(f!=g){v=this._setServiceKey(d,this.oModel._getKey(N))}f=g}else{this._setServiceKey(d,this.oModel._getKey(N))}if(!e.bIsLeafGroupsRequest){var B=this._getKey(r,d.iIndex-1);i=this._getGroupIdFromContext(this.oModel.getContext("/"+B),h);this.mEntityKey[i]=B}}var k=[];if(this.bReloadSingleUnitMeasures&&_.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([b._requestType.reloadMeasuresQuery,_]);Promise.resolve().then(b.prototype._processRequestQueue.bind(this))}else{for(var H=0;H<_.length;H++){var z=_[H];this._executeQueryRequest(z)}}for(var j=0;j<_.length;j++){var $=_[j];k.push($.sRequestId)}this._considerRequestGrouping(k)}if(M&&M.length>0){for(var Z=0,W=M.length;Z<W;Z++){delete t.results[Z-W]}}if(p){c+=this._mergeLoadedKeyIndexWithSubsequentIndexes(d,a,n,e.bIsFlatListRequest)}if(!e.bAvoidLengthUpdate){var J=false;if(t.__count){this.mServiceLength[r]=parseInt(t.__count);this.mLength[r]=this.mServiceLength[r]-c;this.mFinalLength[r]=true;if(e.bIsFlatListRequest){this.iTotalSize=this.mServiceLength[r]}J=true}if(!(r in this.mServiceLength)||this.mServiceLength[r]<u+R){this.mServiceLength[r]=u+R;this.mLength[r]=o+R-c;this.mFinalLength[r]=false}if(R<l||l===undefined){this.mServiceLength[r]=u+R;this.mLength[r]=o+d.iIndex-o;this.mFinalLength[r]=true;J=true}if(R==0){this.mLength[r]=this.mServiceLength[r]=0;this.mFinalLength[r]=true;J=true}if(!J&&this.mLength[r]!==undefined&&c>0){this.mLength[r]-=c}}this.bNeedsUpdate=true;if(c>0){if(t.results.length-c>0){this.aMultiUnitLoadFactor[a.length]=t.results.length/(t.results.length-c)}if(this.aMultiUnitLoadFactor[a.length]<1.5){this.aMultiUnitLoadFactor[a.length]=2}}I.info("MultiUnit Situation in Group ("+r+"), discarded: "+c+", load-factor is now: "+this.aMultiUnitLoadFactor[a.length])};b.prototype._processTotalSizeQueryResponse=function(e,t){if(t.__count==undefined){I.fatal("missing entity count in query result");return}this.iTotalSize=parseInt(t.__count)};b.prototype._processLevelMembersQueryResponse=function(e,t){var i=this;var s,n;var a=function(a,o){var u={iRequestType:b._requestType.groupMembersQuery,sRequestId:i._getRequestId(b._requestType.groupMembersQuery,{groupId:s}),oAnalyticalQueryRequest:e.oAnalyticalQueryRequest,sGroupId:s,aSelectedUnitPropertyName:e.aSelectedUnitPropertyName,aAggregationLevel:e.aAggregationLevel,bIsFlatListRequest:e.bIsFlatListRequest,bIsLeafGroupsRequest:e.bIsLeafGroupsRequest,iStartIndex:a?e.iStartIndex:0,iLength:e.iLength,bAvoidLengthUpdate:e.bAvoidLengthUpdate};if(a&&e.iStartIndex>0&&(e.sGroupId_Missing_AtLevel!=u.sGroupId||i._getKeys(u.sGroupId)===undefined)){var l=i._getParentGroupId(u.sGroupId);var d=i._findKeyIndex(l,i.mEntityKey[u.sGroupId]);if(d<0){I.fatal("assertion failed: failed to determine position of "+u.sGroupId+" in group "+l)}else if(!d){i.mFinalLength[e.sGroupId_Missing_AtLevel]=true;u.iStartIndex=0}else if(i._getKey(l,d-1)!==undefined){var h=i._getKey(l,d-1);var p=i._getGroupIdFromContext(i.oModel.getContext("/"+h),i._getGroupIdLevel(u.sGroupId));i.mFinalLength[p]=true;u.iStartIndex=0}}if(o){u.iLength=n.length}u.oKeyIndexMapping=i._getKeyIndexMapping(u.sGroupId,u.iStartIndex);var f=r({},t);f.results=n;i._processGroupMembersQueryResponse(u,f)};if(t.results.length==0){this.bNeedsUpdate=true;return}s=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(t.results[0])),e.iLevel-1);n=[];var o=true;for(var u=0;u<t.results.length;u++){var l=t.results[u];var d=this.oModel.getContext("/"+this.oModel._getKey(t.results[u]));var h=this._getGroupIdFromContext(d,e.iLevel-1);if(s==h){n.push(l);if(u<t.results.length-1){continue}}a(o,t.results.length==e.iLength&&u==t.results.length-1);o=false;if(s!=h){n=[l]}s=h}if(t.results.length>1&&n.length==1){a(o,t.results.length==e.iLength)}};b.prototype._processReloadMeasurePropertiesQueryResponse=function(e,t){var i=e.oMultiUnitRepresentative;var r=this.oModel.getKey(i.oEntry);if(t.results.length!=1){I.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+r);return}var s=t.results[0];var n=this.oModel.getObject("/"+r);if(!n){I.fatal("assertion failed: no entity found with key "+r);return}var a=i.aReloadMeasurePropertyName;for(var o=0;o<a.length;o++){n[a[o]]=s[a[o]]}};b.prototype._getLoadedContextsForGroup=function(e,t,i,r){var s=[],n,a,o=this._getKeys(e),u;if(!o){return s}if(!t){t=0}if(!i){i=this.oModel.iSizeLimit;if(this.mFinalLength[e]){i=this.mLength[e]}}if(r){a=t||0;u=o(a);while(u){n=this.oModel.getContext("/"+u);s.push(n);a++;u=o(a)}return s}for(a=t;a<t+i;a++){u=o(a);if(!u){break}n=this.oModel.getContext("/"+u);s.push(n)}return s};b.prototype._calculateRequiredGroupSection=function(e,t,i,r){var s=this.mKeyIndex[e]||[],n=this.mFinalLength[e]?this.mLength[e]:undefined,a=v._getReadIntervals(s,t,i,r,n),o=v._mergeIntervals(a);if(o){return{startIndex:o.start,length:o.end-o.start}}return{startIndex:0,length:Math.min(0,i)}};b.prototype._calculateRequiredGroupExpansion=function(e,t,i,r){var s={groupId_Missing:null,length_Missing:0};var n=this;var a=function(e,t,i,r){var o=n._getGroupIdLevel(e);if(o==t){var u=n._getLoadedContextsForGroup(e,i,r);var l=i+u.length-1;if(u.length>=r){return s}else if(n.mFinalLength[e]){if(u.length>=n.mLength[e]){return{groupId_Missing:null,length_Missing:r-u.length}}else{return{groupId_Missing:e,startIndex_Missing:l+1,length_Missing:r-u.length}}}else{return{groupId_Missing:e,startIndex_Missing:l+1,length_Missing:r-u.length}}}var d=n._getLoadedContextsForGroup(e,i,r);var h=r,p=i+d.length-1;for(var f=-1,g;(g=d[++f])!==undefined;){h--;var y=a(n._getGroupIdFromContext(g,o+1),t,0,h);if(y.groupId_Missing==null){if(y.length_Missing==0){return y}else{h=y.length_Missing}}else{return y}if(h==0){break}}if(n.mFinalLength[e]||h==0){return{groupId_Missing:null,length_Missing:h}}else{return{groupId_Missing:e,startIndex_Missing:p+1,length_Missing:h}}};var o=this._getGroupIdLevel(e);if(o==t+1){e=this._getParentGroupId(e);--o}if(e==null||o>t){return s}var u=r,l=i;while(e!=null){var d=a(e,t,l,u);if(d.groupId_Missing!=null){return d}else if(d.length_Missing==0){return d}else{var h=false;while(!h){var p=this._getParentGroupId(e);if(p==null){e=p;--o;break}var f=this.mEntityKey[e];if(!f){return s}var g=this._findKeyIndex(p,f);if(g==-1){return s}if(g==this._getKeyCount(p)-1){if(this.mFinalLength[p]){e=p;--o;continue}else{return{groupId_Missing:p,startIndex_Missing:g+1,length_Missing:u}}}else{f=this._getKey(p,g+1);e=this._getGroupIdFromContext(this.oModel.getContext("/"+f),o);h=true}}l=0;u=d.length_Missing}}return{groupId_Missing:null,length_Missing:u}};b.prototype._getResourcePath=function(){return this.isRelative()?this.getResolvedPath():this.sPath};b.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results"}}return e};b.prototype._getEffectiveSortOrder=function(e){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==e){return this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending}}return null};b.prototype._getFilterOperatorMatchingPropertySortOrder=function(e,i){var r;switch(this._getEffectiveSortOrder(e)){case t.SortOrder.Ascending:if(i){r=d.GE}else{r=d.GT}break;case t.SortOrder.Descending:if(i){r=d.LE}else{r=d.LT}break;default:r=d.GT}return r};b.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e}var t=sap.ui.require("sap/ui/model/odata/Filter");if(typeof t==="function"){for(var i=0,r=e.length;i<r;i++){if(e[i]instanceof t){e[i]=e[i].convert()}}}return e};b.prototype._getGroupIdFromContext=function(e,t){if(!e){return null}var i="/";var r=null;if(t>this.aAggregationLevel.length){I.fatal("assertion failed: aggregation level deeper than number of current aggregation levels")}for(var s=0;s<t;s++){r=e.getProperty(this.aAggregationLevel[s]);if(r!=null){if(r.__edmType==="Edm.Time"){r=r.ms}i+=encodeURIComponent(r)+"/"}else{i+="@/"}}return i};b.prototype._getGroupIdLevel=function(e){if(e==null){I.fatal("assertion failed: no need to determine level of group ID = null");return-1}return e.split("/").length-2};b.prototype._getGroupIdComponents=function(e){if(e==null){return null}var t=e.split("/");var i=[];for(var r=1;r<t.length-1;r++){if(t[r]=="@"){i[r-1]=null}else{i[r-1]=decodeURIComponent(t[r])}}return i};b.prototype._getGroupIdAncestors=function(e,t){if(!t){return[]}if(e==null){I.fatal("group ID null does not have ancestors");return[]}if(e=="/"){if(Math.abs(t)==1){return[null]}else{I.fatal("invalid level count "+t+" for ancestors of groupId "+e);return[]}}var i=e.split("/");var r=[],s="";var n=0,a=i.length-3;if(t>0){if(t-1>a){I.fatal("invalid level count "+t+" for ancestors of groupId "+e)}else{a=t-1}}else if(-(t+1)>a){I.fatal("invalid level count "+t+" for ancestors of groupId "+e)}else{n=a+1+t;for(var o=0;o<n;o++){s+=i[o]+"/"}}for(var u=n;u<=a;u++){s+=i[u]+"/";r.push(s)}return r};b.prototype._getParentGroupId=function(e){return this._getGroupIdAncestors(e,-1)[0]};b.prototype._removeDuplicatesFromStringArray=function(e){var t={};for(var i=0;i<e.length;i++){t[e[i]]=true}var r=[];for(var s in t){r.push(s)}return r};b.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[]}for(var e=0;e<this.oPendingRequestHandle.length;e++){if(this.oPendingRequestHandle[e]===undefined){return e}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1};b.prototype._registerNewRequestHandle=function(e,t){if(this.oPendingRequestHandle[e]!==undefined){I.fatal("request handle ID already in use")}this.oPendingRequestHandle[e]=t};b.prototype._deregisterHandleOfCompletedRequest=function(e){if(a(this.oPendingRequestHandle)){I.warning("No request handles to be cleared. Previous abort/resetData?");return}if(this.oPendingRequestHandle[e]===undefined){I.fatal("no handle found for this request ID")}this.oPendingRequestHandle[e]=undefined};b.prototype._abortAllPendingRequestsByHandle=function(){for(var e=0;e<this.oPendingRequestHandle.length;e++){if(this.oPendingRequestHandle[e]){if(this.oPendingRequestHandle[e]!==undefined){this.oPendingRequestHandle[e].abort()}}}this.oPendingRequestHandle=[]};b.prototype._getRequestId=function(e,t){switch(e){case b._requestType.groupMembersQuery:if(t.groupId===undefined){I.fatal("missing group ID")}return b._requestType.groupMembersQuery+(t.groupId==null?"":t.groupId);case b._requestType.levelMembersQuery:if(t.level===undefined){I.fatal("missing level")}if(t.groupId===undefined){I.fatal("missing groupId")}return""+b._requestType.levelMembersQuery+t.level+(t.tupleIndex?"-"+t.tupleIndex:"");case b._requestType.totalSizeQuery:return b._requestType.totalSizeQuery;case b._requestType.reloadMeasuresQuery:if(!t.multiUnitEntryKey){I.fatal("missing multi unit entry key")}return b._requestType.reloadMeasuresQuery+t.multiUnitEntryKey;default:I.fatal("invalid request type "+e);return-1}};b.prototype._registerNewRequest=function(e){if(e==undefined||e==""){I.fatal("missing request ID");return}if(!this.oPendingRequests[e]){this.oPendingRequests[e]=1}else{++this.oPendingRequests[e]}};b.prototype._considerRequestGrouping=function(e){for(var t=-1,i;(i=e[++t])!==undefined;){if(this.oGroupedRequests[i]===undefined){this.oGroupedRequests[i]={}}var r=this.oGroupedRequests[i];for(var s=0;s<e.length;s++){r[e[s]]=true}}};b.prototype._isRequestPending=function(e){return this.oPendingRequests[e]!=undefined&&this.oPendingRequests[e]>0};b.prototype._deregisterCompletedRequest=function(e){if(a(this.oPendingRequests)){I.warning("There are no pending requests which could be set to 'completed'.");return}if(!this.oPendingRequests[e]){I.fatal("assertion failed: there is no pending request ID "+e)}if(this.oPendingRequests[e]==1){delete this.oPendingRequests[e]}else{--this.oPendingRequests[e]}};b.prototype._cleanupGroupingForCompletedRequest=function(e){if(this._isRequestPending(e)){return false}var t=true;if(this.oGroupedRequests[e]!=undefined){for(var i in this.oGroupedRequests[e]){if(this.oPendingRequests[i]){t=false;break}}}if(t){var r=this.oGroupedRequests[e];delete this.oGroupedRequests[e];for(var s in r){if(s!=e){this._cleanupGroupingForCompletedRequest(s)}}}return t};b.prototype._getKeyIndexMapping=function(e,t){var i,r,s,n=this.mKeyIndex[e],a={sGroupId:e,iIndex:t,iServiceKeyIndex:t},o=this.mServiceKey[e];if(n!==undefined){if(n[t]!==undefined){a.iServiceKeyIndex=n[t]==="ZERO"?0:Math.abs(n[t]);return a}r=t;if(r>0){while(--r>0){if(n[r]!==undefined){break}}}if(r==0){s=0}else{if(n[r]>=0){s=n[r]}else if(n[r+1]===undefined){s=-n[r];while(o[s+1]!==undefined){++s}}else{s=Math.abs(n[r+1])-1}if(o[s]===undefined){I.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+s)}}i=t-r;a.iServiceKeyIndex=s+i}return a};b.prototype._moveKeyIndexMapping=function(e,t){return this._getKeyIndexMapping(e.sGroupId,e.iIndex+t)};b.prototype._getKey=function(e,t){var i=this.mKeyIndex[e][t];if(i===undefined){return undefined}if(i>=0){return this.mServiceKey[e][i]}if(this.mMultiUnitKey[e]===undefined){I.fatal("assertion failed: missing expected multi currency key for group with ID "+e);return null}var r=this.mMultiUnitKey[e][t];if(r===undefined){I.fatal("assertion failed: missing expected multi currency key for group with ID "+e+" at pos "+t);return null}return r};b.prototype._getKeys=function(e){if(this.mKeyIndex[e]===undefined){return undefined}var t=this;return function(i){return t._getKey(e,i)}};b.prototype._getServiceKeys=function(e,t){var i=this.mKeyIndex[e];if(i===undefined){return undefined}var r=this.mServiceKey[e],s=i[t];if(s===undefined){return undefined}if(s>=0){return[r[s]]}var n=[];if(i[t+1]===undefined){s=i[t]=="ZERO"?0:-i[t];while(r[s]!==undefined){n.push(r[s++])}}else{s=i[t]=="ZERO"?0:-i[t];for(var a=s,o=Math.abs(i[t+1]);a<o;a++){n.push(