/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/ObjectPath","sap/base/util/extend","sap/ui/base/EventProvider","sap/ui/base/ManagedObject","sap/ui/core/mvc/ControllerMetadata","sap/ui/core/mvc/ControllerExtension","sap/ui/core/mvc/ControllerExtensionProvider","sap/ui/core/mvc/OverrideExecution","sap/base/Log"],function(e,t,n,r,o,i,a,s,l){"use strict";var u={};var d=n.extend("sap.ui.core.mvc.Controller",{metadata:{stereotype:"controller",methods:{byId:{public:true,final:true},getInterface:{public:false,final:true},getMetadata:{public:true,final:true},getView:{public:true,final:true},isA:{public:true,final:true},onExit:{public:false,final:false,overrideExecution:s.Before},onInit:{public:false,final:false,overrideExecution:s.After},onAfterRendering:{public:false,final:false,overrideExecution:s.After},onBeforeRendering:{public:false,final:false,overrideExecution:s.Before}}},constructor:function(e){var r=null;if(typeof e=="string"){if(!u[e]){l.warning("Do not call sap.ui.core.mvc.Controller constructor for non typed scenario!")}r=u[e]}n.apply(this,arguments);if(r){t(this,u[e])}if(this.extension){throw new Error("The keyword 'extension' cannot be used as a member of a controller")}this["_sapui_Extensions"]={};d.extendByMember(this,false);this._sapui_isExtended=false;this._aDestroyables=[]},_isExtended:function(){return this._sapui_isExtended},getInterface:function(){var e={};var t=this.getMetadata();var n=t._aAllPublicMethods;n.forEach(function(t){var n=this[t];if(typeof n==="function"){e[t]=function(){var e=n.apply(this,arguments);return e instanceof d?e.getInterface():e}.bind(this)}}.bind(this));this.getInterface=function(){return e};return e}},o);function f(t,n,r){var o=n.getMetadata().getName();var a=t.getMetadata();var s=t["_sapui_Extensions"];var u=t.getInterface();var d=i.getMetadata().getLifecycleConfiguration();var f={namespace:o,extension:n,reloadNeeded:false};n._setController(u);if(n.getMetadata().hasOverrides()){var c,p,h,g,v=n.getMetadata().getOverrides(),x=n.getMetadata().getStaticOverrides();for(g in x){h=n.getMetadata();if(!h.isMethodFinal(g)){i.overrideMethod(g,n,x,n,h.getOverrideExecution(g))}else{l.error("[FUTURE FATAL] Method '"+g+"' of extension '"+o+"' is flagged final and cannot be overridden by calling 'override'")}}for(g in v){if(g!=="extension"){if(g in n.base){l.debug("Overriding  member '"+g+"' of original controller.");var y=v[g];var E=t[g];if(typeof E=="object"&&typeof y=="object"){p=s[g];h=p.extension.getMetadata();for(c in y){if(!h.isMethodFinal(c)){i.overrideMethod(c,E,y,n,h.getOverrideExecution(c))}else{l.error("[FUTURE FATAL] Method '"+c+"' of extension '"+p.namespace+"' is flagged final and cannot be overridden by extension '"+o+"'")}}}else if(!a.isMethodFinal(g)){i.overrideMethod(g,t,v,n,a.getOverrideExecution(g))}else{l.error("[FUTURE FATAL] Method '"+g+"' of controller '"+t.getMetadata().getName()+"' is flagged final and cannot be overridden by extension '"+o+"'")}}else if(g in d){i.overrideMethod(g,t,v,n,a.getOverrideExecution(g))}else if(g.startsWith("extHook")&&t[g]===null){i.overrideMethod(g,t,v,n)}else{l.error("[FUTURE FATAL] Method '"+g+"' does not exist in controller "+t.getMetadata().getName()+" and cannot be overridden")}}f.reloadNeeded=true}if(v&&v.extension){for(var b in v.extension){h=s[b].extension.getMetadata();var m=e.create(b,t.extension);var M=s[b].extension;var w=v.extension[b];for(c in w){if(!h.isMethodFinal(c)){i.overrideMethod(c,m,w,n,h.getOverrideExecution(c));i.overrideMethod(c,M,w,n,h.getOverrideExecution(c))}else{l.error("[FUTURE FATAL] Method '"+c+"' of extension '"+b+"' is flagged final and cannot be overridden by extension '"+o+"'")}}}}}var C=n.getInterface();if(r){s[r]=f;f.location=r;t[r]=C;u[r]=C}else{s[o]=f;f.location="extension."+o;e.set("extension."+o,C,t);e.set("extension."+o,C,u)}}function c(e,t,n){if(t instanceof i){f(e,t,n)}else if(t.getMetadata&&t.getMetadata().getStereotype()=="controllerextension"){var r=new t;f(e,r,n)}else{var o=i.getMetadata().getLifecycleConfiguration();for(var a in t){if(a in o){i.overrideMethod(a,e,t,e,o[a].overrideExecution)}else{i.overrideMethod(a,e,t)}}}}function p(t,n){if(!t){throw new Error("Controller name ('sName' parameter) is required")}var r=t.replace(/\./g,"/")+".controller",o=i(sap.ui.require(r));function i(n){if(n){return n}else if(u[t]){return d}else{return e.get(t)}}if(!n){if(!o){o=sap.ui.requireSync(r);return i(o)}else{return o}}return new Promise(function(e,t){if(!o){sap.ui.require([r],function(t){e(i(t))},t)}else{e(o)}})}function h(e,t){var n;if(u[t]){n=new e(t)}else{n=new e}if(!n){throw new Error("Controller "+t+" couldn't be instantiated")}return n}d.extendByMember=function(e,t){var n;for(n in e){if(e[n]&&e[n].getMetadata&&e[n].getMetadata().getStereotype()=="controllerextension"){e[n]=new e[n]}}for(n in e){if(e[n]&&e[n].getMetadata&&e[n].getMetadata().getStereotype()=="controllerextension"){c(e,e[n],n)}}if(t){return Promise.resolve(e)}else{return e}};d.applyExtensions=function(e,t,n,r,o){function i(e,t){if(e){return p(t,true).then(function(e){e=u[t]||e;if(e!==undefined){if(e.getMetadata&&e.getMetadata().isA("sap.ui.core.mvc.Controller")){l.fatal("[FUTURE-FATAL] Attempt to load Extension Controller "+t+" was not successful","Controller extension should be a plain object.",null,function(){return{type:"ControllerExtension",name:t}})}return e}},function(e){l.error("[FUTURE FATAL] Attempt to load Extension Controller "+t+" was not successful - is the Controller correctly defined in its file?")})}else{if(!u[t]&&!sap.ui.require(t)){p(t)}if(u[t]!==undefined){return u[t]}else{l.error("Attempt to load Extension Controller "+t+" was not successful - is the Controller correctly defined in its file?",null,function(){return{type:"ControllerExtension",name:t}});return{}}}}if(o){return a.getControllerExtensions(t,n,r,o).then(function(t){var n=t.customizingControllerNames.map(function(e){return i(true,e)});return Promise.all(n).then(function(n){var r=n.concat(t.providerControllers);for(var o=0,i=r.length;o<i;o++){c(e,r[o])}return e})},function(t){l.error("[FUTURE FATAL] Controller Extension Provider: Error '"+t+"' thrown in "+d._sExtensionProvider+"; extension provider ignored.");return e})}else{var s=a.getControllerExtensions(t,n,r,o);var f=s.customizingControllerNames.map(i.bind(null,false));var h=f.concat(s.providerControllers);for(var g=0,v=h.length;g<v;g++){c(e,h[g])}}return e};d.create=function(e){return g(e.name,undefined,true,e._viewId)};sap.ui.controller=function(e,t,n,r){if(n){l.info("Do not use deprecated factory function 'sap.ui.controller("+e+")'. Use 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:e}})}else{l.warning("Do not use synchronous controller creation for controller '"+e+"'! Use the new asynchronous factory 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:e}})}return g.apply(this,arguments)};function g(e,t,n,o){var i,a,s=r._sOwnerId;if(typeof t==="boolean"){t=undefined}if(!t){if(n){return p(e,n).then(function(t){return h(t,e)}).then(function(t){return d.applyExtensions(t,e,s,o,n)}).then(function(e){e._sapui_isExtended=true;return e})}else{a=p(e,n);i=h(a,e);i=d.applyExtensions(i,e,s,o,n);i._sapui_isExtended=true}return i}else{u[e]=t;l.info("For defining controllers use Controller.extend instead")}}d.prototype.getPublicMethods=function(){var e={},n=this.getMetadata(),r=n.getAllMethods(),o=n.getLifecycleConfiguration();Object.keys(r).forEach(function(t){if(n.isMethodPublic(t)){e[t]=r[t];e[t].reloadNeeded=!!(t in o)}});delete e.extension;var i=this["_sapui_Extensions"];Object.keys(i).forEach(function(n){var r=i[n];var o=r.extension.getInterface();var a=r.extension.getMetadata().getAllMethods();Object.keys(o).forEach(function(n){delete e[r.location];var o=t({},a[n],{reloadNeeded:r.reloadNeeded});e[r.location+"."+n]=o})});return e};d.prototype._getDestroyables=function(){if(!this._aDestroyables){l.error("[FUTURE FATAL] Mandatory super constructor not called for Controller: '"+this.getMetadata().getName()+"'.",null,"sap.ui.support",function(){return{type:"missingSuperConstructor"}});this._aDestroyables=[]}return this._aDestroyables};d.prototype.destroyFragments=function(){function e(e){e=Array.isArray(e)?e:[e];for(var t=0;t<e.length;t++){if(!e[t].isDestroyed()){e[t].destroy()}}}var t=this._getDestroyables();for(var n=0;n<t.length;n++){t[n]=t[n].then(e)}};d.prototype.destroy=function(){if(this["_sapui_Extensions"]){Object.keys(this["_sapui_Extensions"]).forEach(function(t){var n=this["_sapui_Extensions"][t];e.set(n.location,null,this)}.bind(this));delete this["_sapui_Extensions"]}n.prototype.destroy.apply(this,arguments)};d.prototype.getView=function(){return this.oView};d.prototype.byId=function(e){return this.oView?this.oView.byId(e):undefined};d.prototype.createId=function(e){return this.oView?this.oView.createId(e):undefined};d.prototype.getOwnerComponent=function(){var e=sap.ui.require("sap/ui/core/Component");if(e){return e.getOwnerComponentFor(this.getView())}else{return undefined}};d.prototype.connectToView=function(e){this.oView=e;if(this.onInit){e.attachAfterInit(this.onInit,this)}if(this.onExit){e.attachBeforeExit(this.onExit,this)}if(e.bControllerIsViewManaged){e.attachBeforeExit(this.destroyFragments,this)}if(this.onAfterRendering){e.attachAfterRendering(this.onAfterRendering,this)}if(this.onBeforeRendering){e.attachBeforeRendering(this.onBeforeRendering,this)}};d.prototype.loadFragment=function(e){if(!this.getView()){throw new Error("Calling 'loadFragment' without a view attached is not supported!")}else if(!e||!e.name){throw new Error("oOptions must provide at least a fragment name!")}var t=this.getOwnerComponent();var n=e.addToDependents!==false;var r=e.autoPrefixId!==false;var o={name:e.name,type:e.type,id:e.id,controller:this};var i=this._getDestroyables();var a=new Promise(function(e,t){sap.ui.require(["sap/ui/core/Fragment"],function(t){e(t)},t)}).then(function(n){if(!e.id&&r){o.id=this.getView().getId()}else if(r){o.id=this.createId(e.id)}if(t){return t.runAsOwner(function(){return n.load(o)})}else{return n.load(o)}}.bind(this)).then(function(e){if(n){this.getView().applySettings({dependents:e})}i.splice(i.indexOf(a),1);return e}.bind(this));i.push(a);return a};d._sExtensionProvider=null;d.registerExtensionProvider=function(e){d._sExtensionProvider=e;a.registerExtensionProvider(e)};return d});
//# sourceMappingURL=Controller.js.map