/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/Plugin","sap/m/Menu","sap/m/MenuItem","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/dt/util/_createPromise","sap/ui/Device","sap/base/assert","sap/ui/events/KeyCodes"],function(e,t,n,o,i,r,s,u,a){"use strict";var h=e.extend("sap.ui.dt.plugin.ContextMenu",{metadata:{library:"sap.ui.dt",properties:{contextElement:{type:"object"},openOnClick:{type:"boolean",defaultValue:true}},events:{openedContextMenu:{},closedContextMenu:{}}}});var c="sapUiDtContextMenu";var l="sapUiDtContextMiniMenu";h.prototype.init=function(){this.oContextMenuControl=new t;this.oContextMenuControl.attachItemSelected(this._onItemSelected,this);this.oContextMenuControl.attachClosed(this._contextMenuClosed,this);this.oContextMenuControl.addStyleClass(c);this._aMenuItems=[];this._aGroupedItems=[];this._aSubMenus=[]};h.prototype.exit=function(){delete this._aMenuItems;if(this.oContextMenuControl){this.oContextMenuControl.destroy()}};h.prototype.addMenuItem=function(e,t,n){var o={menuItem:e,fromPlugin:!!t,bPersistOneTime:n};this._aMenuItems.push(o)};h.prototype.registerElementOverlay=function(e){e.attachBrowserEvent("click",this._openContextMenu,this);e.attachBrowserEvent("touchstart",this._openContextMenu,this);e.attachBrowserEvent("contextmenu",this._openContextMenu,this);e.attachBrowserEvent("keydown",this._onKeyDown,this);e.attachBrowserEvent("keyup",this._onKeyUp,this)};h.prototype.deregisterElementOverlay=function(e){e.detachBrowserEvent("click",this._openContextMenu,this);e.detachBrowserEvent("touchstart",this._openContextMenu,this);e.detachBrowserEvent("contextmenu",this._openContextMenu,this);e.detachBrowserEvent("keydown",this._onKeyDown,this);e.detachBrowserEvent("keyup",this._onKeyUp,this)};h.prototype.open=function(e,t,i,s){var u;function a(o,i){i.forEach(function(i,r){var s=typeof i.text==="function"?i.text(e):i.text;var h=typeof i.enabled==="function"?i.enabled(u):i.enabled;var c;if(!t){c=s}o.addItem(new n({key:i.id,icon:i.icon,text:s,enabled:h}).setTooltip(c));if(i.submenu){a(o.getItems()[r],i.submenu)}})}this._bContextMenu=!!t;if(this._bContextMenu){this.oContextMenuControl.removeStyleClass(l)}else{this.oContextMenuControl.addStyleClass(l)}var h=e.getElement();if(this._fnCancelMenuPromise){if(this.getContextElement()===h){return}this._fnCancelMenuPromise();delete this._fnCancelMenuPromise}this.setContextElement(h);this.getDesignTime().getSelectionManager().attachChange(this._onSelectionChanged,this);u=this.getSelectedOverlays().filter(function(t){return t!==e});u.unshift(e);this._aMenuItems=this._aMenuItems.filter(function(e){if(e.bPersistOneTime){e.bPersistOneTime=false;return true}return!e.fromPlugin});this.oContextMenuControl.destroyItems();var c=Promise.resolve();if(!i){var p=r(function(e,t){o.waitForSynced(this.getDesignTime())().then(e).catch(t)}.bind(this));this._fnCancelMenuPromise=p.cancel;c=p.promise.then(function(){this._aGroupedItems=[];this._aSubMenus=[];var e=[];var t=this.getDesignTime().getPlugins();t.forEach(function(t){var n=t.getMenuItems(u);if(!(n instanceof Promise)){n=Promise.resolve(n)}e.push(n)});var n=r(function(t,n){Promise.all(e).then(t).catch(n)});this._fnCancelMenuPromise=n.cancel;return n.promise}.bind(this)).then(function(e){return e.reduce(function(e,t){return e.concat(t)})}).then(function(e){e.forEach(function(e){var n=typeof e.enabled==="function"?e.enabled(u):e.enabled;if(!n&&!t){return}if(e.group!==undefined&&!t){this._addMenuItemToGroup(e)}else if(e.submenu!==undefined){this._addSubMenu(e)}else{this.addMenuItem(e,true)}}.bind(this));this._addItemGroupsToMenu();delete this._fnCancelMenuPromise}.bind(this))}c.then(function(){var t=this._aMenuItems.map(function(e){return e.menuItem});if(t.length>0){t=this._sortMenuItems(t);a(this.oContextMenuControl,t);this.oContextMenuControl.openAsContextMenu(s,e)}this.fireOpenedContextMenu()}.bind(this)).catch(function(e){throw o.createError("ContextMenu#open",`An error occurred during calling getMenuItems: ${e}`)})};h.prototype._sortMenuItems=function(e){return e.sort(function(e,t){if(!e.rank&&!t.rank){return 0}if(!e.rank&&t.rank){return-1}if(e.rank&&!t.rank){return 1}return e.rank-t.rank})};h.prototype._onItemSelected=function(e){this._ensureSelection(this._oCurrentOverlay);function t(e,t){var n=e.responsible||this.getSelectedOverlays()||[];u(n.length>0,"sap.ui.rta - Opening context menu, with empty selection - check event order");var o={};o.eventItem=t;o.contextElement=this.getContextElement();e.handler(n,o)}var n=e.getParameter("item").getKey();this._aMenuItems.some(function(o){var i=o.menuItem;if(n===o.menuItem.id){t.apply(this,[i,e]);return true}else if(i.submenu){i.submenu.some(function(o){if(n===o.id){t.apply(this,[o,e]);return true}}.bind(this))}},this)};h.prototype._onKeyUp=function(e){var t=i.getOverlay(e.currentTarget.id);if(e.keyCode===a.ENTER&&t.getIgnoreEnterKeyUpOnce()){t.setIgnoreEnterKeyUpOnce(false);e.stopPropagation();e.preventDefault();return}if((e.keyCode===a.SPACE||e.keyCode===a.ENTER)&&e.shiftKey===false&&e.altKey===false&&e.ctrlKey===false){if(!this._checkForPluginLock()){this._openContextMenu(e);e.stopPropagation();e.preventDefault()}}if(e.keyCode===a.F10&&e.shiftKey===true&&e.altKey===false&&e.ctrlKey===false){if(!this._checkForPluginLock()){this._openContextMenu(e);e.stopPropagation();e.preventDefault()}}};h.prototype._onKeyDown=function(e){var t=i.getOverlay(e.currentTarget.id);if(e.keyCode===a.SPACE&&e.shiftKey===false&&e.altKey===false&&e.ctrlKey===false){if(t&&t.isSelectable()&&!this._checkForPluginLock()){t.setSelected(true);e.stopPropagation();e.preventDefault()}}};h.prototype._openContextMenu=function(e){var t=i.getOverlay(e.currentTarget.id);if(t&&t.isSelectable()&&t.getSelected()){this._oCurrentOverlay=t;var n=e.type==="contextmenu"||e.keyCode===a.F10;this.open(t,n,undefined,e)}};h.prototype._contextMenuClosed=function(){this.oContextMenuControl.removeStyleClass(l);this.fireClosedContextMenu()};h.prototype._onSelectionChanged=function(){this.getDesignTime().getSelectionManager().detachChange(this._onSelectionChanged,this)};h.prototype._ensureSelection=function(e){if(e&&!e.isSelected()){e.setSelected(true)}};h.prototype._checkForPluginLock=function(){if(s.os.ios){return false}if(this.getDesignTime().getBusyPlugins().length){return true}return false};h.prototype._addMenuItemToGroup=function(e){var t=this._aGroupedItems.some(function(t){if(t.sGroupName===e.group){t.aGroupedItems.push(e);return true}});if(!t){this._aGroupedItems.push({sGroupName:e.group,aGroupedItems:[e]})}};h.prototype._addSubMenu=function(e){e.submenu.forEach(function(t){t.handler||=e.handler});this._aSubMenus.push({sSubMenuId:e.id,aSubMenuItems:e.submenu});this.addMenuItem(e,true)};h.prototype._addItemGroupsToMenu=function(){this._aGroupedItems.forEach(function(e){if(e.aGroupedItems.length===1){this.addMenuItem(e.aGroupedItems[0],true)}else{this.addMenuItem({id:`${e.sGroupName}-groupItem`,enabled:true,text:e.sGroupName,icon:e.aGroupedItems[0].icon,rank:e.aGroupedItems[0].rank,submenu:e.aGroupedItems},true)}}.bind(this))};return h});
//# sourceMappingURL=ContextMenu.js.map