/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

sap.ui.define([
	"sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils",
	"sap/ui/fl/initial/_internal/StorageUtils"
], function(
	ObjectStorageUtils,
	StorageUtils
) {
	"use strict";

	function loadDataFromStorage(mPropertyBag) {
		var aFlexObjects = [];

		return ObjectStorageUtils.forEachObjectInStorage(mPropertyBag, function(mFlexObject) {
			aFlexObjects.push(mFlexObject.changeDefinition);
		}).then(function() {
			return aFlexObjects;
		});
	}

	/**
	 * Base Connector for requesting data from session or local storage
	 *
	 * @namespace sap.ui.fl.apply._internal.connectors.ObjectStorageConnector
	 * @implements {sap.ui.fl.interfaces.BaseLoadConnector}
	 * @deprecated
	 * @since 1.70
	 * @private
	 * @ui5-restricted sap.ui.fl.apply._internal.Storage, sap.ui.fl.write._internal.Storage, SAP Web IDE
	 */
	var ObjectStorageConnector = {
		/**
		 * can be either window.sessionStorage or window.localStorage
		 */
		oStorage: undefined,
		layers: [
			"ALL"
		],

		/**
		 * Provides the flex data stored in the session or local storage;
		 * Changes can be filtered by reference and layer.
		 *
		 * @param {object} mPropertyBag properties needed by the connectors
		 * @param {string} mPropertyBag.reference reference of the application
		 * @returns {Promise<Object>} resolving with an object containing a data contained in the changes-bundle
		 */
		loadFlexData(mPropertyBag) {
			return loadDataFromStorage({
				storage: this.oStorage,
				reference: mPropertyBag.reference
			}).then(function(aFlexObjects) {
				var mGroupedFlexObjects = StorageUtils.getGroupedFlexObjects(aFlexObjects);
				return StorageUtils.filterAndSortResponses(mGroupedFlexObjects);
			});
		}
	};

	ObjectStorageConnector.storage = ObjectStorageConnector.oStorage;

	return ObjectStorageConnector;
});
