/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t){"use strict";var r={};r.SOURCE_ALIAS="source";r.TARGET_ALIAS="target";r.MOVED_ELEMENTS_ALIAS="movedElements";function o(e,t,r,o){if(!e){throw new Error("No change instance")}var n=e.getContent();if(!n||!n.movedElements||n.movedElements.length===0){throw new Error("Change format invalid")}if(!n.source||!n.source.selector){throw new Error("No source supplied for move")}if(!n.target||!n.target.selector){throw new Error("No target supplied for move")}if(!t.bySelector(n.source.selector,o,r)){throw new Error("Move source parent not found")}if(!t.bySelector(n.target.selector,o,r)){throw new Error("Move target parent not found")}if(!n.source.selector.aggregation){throw new Error("No source aggregation supplied for move")}if(!n.target.selector.aggregation){throw new Error("No target aggregation supplied for move")}}async function n(e,t,r,o){if(!e.selector&&!e.id){throw new Error("Change format invalid - moveElements element has no id attribute")}if(typeof e.targetIndex!=="number"){throw new Error(`Missing targetIndex for element with id '${e.selector.id}' in movedElements supplied`)}const n=await t.bySelector(e.selector||e.id,r,o);if(!n){throw new Error(`Control to move was not found. Id: '${e.selector.id}'`)}return n}function a(e){if(!e.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required")}if(e.movedElements.length===0){throw new Error("MovedElements array is empty")}e.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute")}if(typeof e.sourceIndex!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number")}if(typeof e.targetIndex!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number")}})}async function g(e,t,r){delete t.source.publicAggregation;delete t.target.publicAggregation;const o=t.source.parent||await e.bySelector(t.source.id,r);const n=t.target.parent||await e.bySelector(t.target.id,r);var a=t.source.aggregation;var g=t.target.aggregation;var s={aggregation:t.source.aggregation,type:e.getControlType(o)};var i={aggregation:t.target.aggregation,type:e.getControlType(n)};var c={source:{id:o.getId(),aggregation:a,type:s.type,selector:e.getSelector(t.source.id,r,s)},target:{id:n.getId(),aggregation:g,type:i.type,selector:e.getSelector(t.target.id,r,i)},movedElements:t.movedElements};return c}r.applyChange=async function(e,t,r){const a=r.modifier;const g=r.view;const s=r.appComponent;const i=e.getContent();const c=[];let l=false;o(e,a,g,s);for(const e of i.movedElements){const t=await n(e,a,s,g);let o=a.getParent(t);let d=r.sourceAggregation||await a.getParentAggregationName(t,o);const u=await a.bySelector(i.target.selector,s,g);const m=r.targetAggregation||i.target.selector.aggregation;let f=await a.findIndexInParentAggregation(t);const v=e.targetIndex;if(f>-1){if(f===v&&d===m&&a.getParent(t)===u){f=e.sourceIndex;d=r.sourceAggregation||i.source.selector.aggregation;l=true;o=await a.bySelector(i.source.selector,s,g)||o}}if(f>-1){c.unshift({index:f,aggregation:d,sourceParent:a.getSelector(o,s)})}if(!l){await a.moveAggregation(o,d,u,m,t,v,g)}}e.setRevertData(c)};r.revertChange=async function(e,t,r){var a=r.modifier;var g=r.view;var s=r.appComponent;var i=e.getContent();o(e,a,g,s);let c=await a.bySelector(i.source.selector,s,g);const l=await a.bySelector(i.target.selector,s,g);let d=i.source.selector.aggregation;const u=i.target.selector.aggregation;const m=e.getRevertData();i.movedElements.reverse();let f=0;for(const e of i.movedElements){const t=await n(e,a,s,g);if(!t){throw new Error("Element to move not found")}let r=e.sourceIndex;if(m){var v=m[f];d=v.aggregation;r=v.index;c=await a.bySelector(v.sourceParent,s,g)||c}await a.moveAggregation(l,u,c,d,t,r,g);f++}e.resetRevertData()};r.completeChangeContent=async function(e,t,o){var n=o.modifier;var s=o.appComponent;a(t);const i=await g(n,t,s);var c={movedElements:[],source:{selector:i.source.selector},target:{selector:i.target.selector}};for(const t of i.movedElements){const a=t.element||await n.bySelector(t.id,s);c.movedElements.push({selector:n.getSelector(a,s),sourceIndex:t.sourceIndex,targetIndex:t.targetIndex});e.addDependentControl(i.source.id,r.SOURCE_ALIAS,o);e.addDependentControl(i.target.id,r.TARGET_ALIAS,o);e.addDependentControl(i.movedElements.map(function(e){return e.id}),r.MOVED_ELEMENTS_ALIAS,o)}e.setContent(c)};r.getCondenserInfo=function(e){var r=e.getContent();var o=e.getRevertData()[0];return{affectedControl:r.movedElements[0].selector,classification:t.Move,sourceContainer:o.sourceParent,targetContainer:r.target.selector,sourceIndex:o.index,sourceAggregation:o.aggregation,targetAggregation:r.target.selector.aggregation,setTargetIndex(e,t){var r=e.getContent();r.movedElements[0].targetIndex=t;e.setContent(r)},getTargetIndex(e){return e.getContent().movedElements[0].targetIndex},setIndexInRevertData(e,t){var r=e.getRevertData();r[0].index=t;e.setRevertData(r)}}};r.getChangeVisualizationInfo=function(e){var t=e.getContent();var r=e.getRevertData()[0];return{affectedControls:[t.movedElements[0].selector],dependentControls:[t.source.selector],descriptionPayload:{sourceContainer:r.sourceParent,targetContainer:t.target.selector}}};return r},true);
//# sourceMappingURL=MoveControls.js.map