//@ui5-bundle sap/ui/fl/library-preload-apply.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ApplyUtil", ["sap/ui/thirdparty/URI"],function(r){"use strict";var e={formatBundleName(e,t){if(t.startsWith("/")){throw Error("Absolute paths are not supported")}var a=new r(`${e}/${t}`).normalize().path();return a.replace(/\//g,".").replace("..",".").replace(/.properties$/g,"")}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/Registration", ["sap/ui/fl/requireAsync"],function(e){"use strict";var a={appdescr_ui5_addLibraries:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddLibrary"),appdescr_app_setTitle:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/SetTitle"),appdescr_ovp_changeCard:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ovp/ChangeCard"),appdescr_ovp_addNewCard:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ovp/AddNewCard"),appdescr_ovp_removeCard:e.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ovp/DeleteCard"),appdescr_ui_generic_app_addNewObjectPage:e.bind(this,"sap/suite/ui/generic/template/manifestMerger/AddNewObjectPage"),appdescr_ui_generic_app_changePageConfiguration:e.bind(this,"sap/suite/ui/generic/template/manifestMerger/ChangePageConfiguration"),appdescr_fe_changePageConfiguration:e.bind(this,"sap/fe/core/manifestMerger/ChangePageConfiguration")};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/RegistrationBuild", ["sap/ui/fl/requireAsync","sap/ui/fl/apply/_internal/changes/descriptor/Registration"],function(a,e){"use strict";var i={appdescr_app_changeDataSource:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeDataSource"),appdescr_ui5_addNewModelEnhanceWith:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModelEnhanceWith"),appdescr_ui5_addComponentUsages:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddComponentUsages"),appdescr_ui5_setMinUI5Version:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetMinUI5Version"),appdescr_fiori_setRegistrationIds:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetRegistrationIds"),appdescr_ui5_setFlexExtensionPointEnabled:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetFlexExtensionPointEnabled"),appdescr_ui5_addNewModel:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModel"),appdescr_app_addAnnotationsToOData:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/AddAnnotationsToOData"),appdescr_app_removeAllInboundsExceptOne:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/RemoveAllInboundsExceptOne"),appdescr_app_changeInbound:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeInbound"),appdescr_app_addNewInbound:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewInbound"),appdescr_fiori_setAbstract:a.bind(this,"sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetAbstract")};var n=Object.assign({},e);return Object.assign(n,i)});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/AddAnnotationsToOData", ["sap/ui/fl/util/DescriptorChangeCheck"],function(t){"use strict";var n=["BEGINNING","END"];function e(t,n){return Object.keys(t).indexOf(n)>=0}function a(t,n){return!t[n].type||t[n].type==="OData"}function o(t,n,e){return t[e]&&t[e].type==="ODataAnnotation"||n[e]}function r(t,n){return t[n].type&&t[n].type==="ODataAnnotation"}function i(t,n){return t.indexOf(n)>=0}function s(t,n){if(n){if(Object.keys(t).length>0){if(!e(t,n)){throw new Error(`There is no dataSource '${n}' existing in the manifest. You can only add annotations to already existing dataSources in the manifest`)}if(!a(t,n)){throw new Error(`The dataSource '${n}' is existing in the manifest but is not type of 'OData'. The type of the dataSource in the manifest is '${t[n].type}'`)}}else{throw new Error("There are no dataSources in the manifest at all")}}else{throw new Error("Invalid change format: The mandatory 'dataSourceId' is not defined. Please define the mandatory property 'dataSourceId' and refer it to an existing OData")}}function f(t){if(t){if(t.length===0){throw new Error("Invalid change format: The 'annotations' array property is empty")}}else{throw new Error("Invalid change format: The mandatory 'annotations' array property is not defined. Please define the 'annotations' array property")}}function c(t){if(!(n.indexOf(t)>=0)&&!(t===undefined)){throw new Error(`The defined insert position '${t}' is not supported. The supported insert positions are: ${n.join("|")}`)}}function d(n,e,a){if(n){if(Object.keys(n).length===0){throw new Error("The 'dataSource' object is empty")}Object.keys(n).forEach(function(o){t.checkIdNamespaceCompliance(o,a);if(!r(n,o)){throw new Error(`The dataSource annotation '${o}' is type of '${n[o].type}'. Only dataSource annotations of type 'ODataAnnotation' is supported`)}if(!i(e,o)){throw new Error(`The annotation '${o}' is not part of 'annotations' array property. Please add the annotation '${o}' in the 'annotations' array property`)}})}else{throw new Error("Invalid change format: The mandatory 'dataSource' object is not defined. Please define the mandatory 'dataSource' object")}}function p(t,n,e,a,o){h(t[n],e,a);u(t,o)}function h(t,n,e){t.settings||={};t.settings.annotations||=[];var a=t.settings.annotations.filter(function(t){return n.indexOf(t)<0});t.settings.annotations=a;if(e==="END"){t.settings.annotations=t.settings.annotations.concat(n)}else{t.settings.annotations=n.concat(t.settings.annotations)}}function u(t,n){Object.assign(t,n)}function y(t,n,e){e.forEach(function(e){if(!o(t,n,e)){throw new Error(`The annotation '${e}' is part of 'annotations' array property but does not exists in the change property 'dataSource' and in the manifest (or it is not type of 'ODataAnnotation' in the manifest)`)}})}var g={applyChange(t,n){var e=n.getContent().dataSourceId;var a=n.getContent().annotations;var o=n.getContent().annotationsInsertPosition;var r=n.getContent().dataSource;s(t["sap.app"].dataSources,e);f(a);c(o);d(r,a,n);y(t["sap.app"].dataSources,r,a);p(t["sap.app"].dataSources,e,a,o,r);return t}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewInbound", ["sap/ui/fl/util/DescriptorChangeCheck"],function(n){"use strict";function o(n){var o=Object.keys(n.inbound);if(o.length>1){throw new Error("It is not allowed to add more than one inbound")}if(o.length<1){throw new Error("Inbound does not exist")}if(o[0]===""){throw new Error("The ID of your inbound is empty")}return o[o.length-1]}var r={applyChange(r,e){r["sap.app"].crossNavigation||={};r["sap.app"].crossNavigation.inbounds||={};var a=e.getContent();var i=o(a);var t=r["sap.app"].crossNavigation.inbounds[i];if(!t){n.checkIdNamespaceCompliance(i,e);r["sap.app"].crossNavigation.inbounds[i]=a.inbound[i]}else{throw new Error(`Inbound with ID "${i}" already exist.`)}return r}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeDataSource", ["sap/ui/fl/util/changePropertyValueByPath","sap/ui/fl/util/DescriptorChangeCheck"],function(e,t){"use strict";var a=["UPDATE","UPSERT"];var r=["uri","settings/maxAge"];var n={applyChange(n,o){var i=n["sap.app"].dataSources;var u=o.getContent();t.checkEntityPropertyChange(u,r,a);if(i){var s=i[u.dataSourceId];if(s){e(u.entityPropertyChange,s)}else{throw new Error(`Nothing to update. DataSource with ID "${u.dataSourceId}" does not exist.`)}}else{throw Error("No sap.app/dataSource found in manifest.json")}return n}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeInbound", ["sap/ui/fl/util/changePropertyValueByPath","sap/ui/fl/util/DescriptorChangeCheck"],function(n,e){"use strict";var t=["UPDATE","UPSERT"];var a=["title","subTitle","icon","signature/parameters/*"];var i={applyChange(i,r){var o=i["sap.app"].crossNavigation;var s=r.getContent();e.checkEntityPropertyChange(s,a,t);if(o&&o.inbounds){var p=o.inbounds[s.inboundId];if(p){n(s.entityPropertyChange,p)}else{throw new Error(`Nothing to update. Inbound with ID "${s.inboundId}" does not exist.`)}}else{throw new Error("sap.app/crossNavigation or sap.app/crossNavigation/inbounds sections have not been found in manifest.json")}return i}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/RemoveAllInboundsExceptOne", [],function(){"use strict";function n(n){if(!n["sap.app"].hasOwnProperty("crossNavigation")){throw new Error("No sap.app/crossNavigation path exists in the manifest")}if(!n["sap.app"].crossNavigation.hasOwnProperty("inbounds")){throw new Error("No sap.app/crossNavigation/inbounds path exists in the manifest")}}function o(n){var o=n.inboundId;if(o===""){throw new Error("The ID of your inbound is empty")}if(typeof o!=="string"){throw new Error("The type of your inbound ID must be string")}return o}function i(n,o){var i={};i[o]=n["sap.app"].crossNavigation.inbounds[o];n["sap.app"].crossNavigation.inbounds=i}var s={applyChange(s,r){n(s);var a=o(r.getContent());if(s["sap.app"].crossNavigation.inbounds[a]){i(s,a)}else{throw new Error(`No inbound exists with the ID "${a}" in sap.app/crossNavigation/inbounds`)}return s}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/app/SetTitle", [],function(){"use strict";var p={applyChange(p){p["sap.app"].title=`{{${p["sap.app"].id}_sap.app.title}}`;return p}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetAbstract", ["sap/base/util/ObjectPath"],function(t){"use strict";var e={applyChange(e,a){if(!a.getContent().hasOwnProperty("abstract")){throw new Error("No abstract in change content provided")}if(a.getContent().abstract!==false){throw new Error(`The current change value of property abstract is '${a.getContent().abstract}'. Only allowed value for property abstract is boolean 'false'`)}t.set(["sap.fiori","abstract"],a.getContent().abstract,e);return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetRegistrationIds", ["sap/base/util/ObjectPath"],function(t){"use strict";var e={applyChange(e,i){t.set(["sap.fiori","registrationIds"],i.getContent().registrationIds,e);return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ovp/AddNewCard", [],function(){"use strict";var r={applyChange(r,e){var a=e.getContent();var n=r["sap.ovp"].cards;if("card"in a&&Object.keys(a.card).length>0&&!(Object.keys(a.card)in n)){Object.assign(n,a.card)}else{throw Error("No new card found")}return r}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ovp/ChangeCard", ["sap/base/util/ObjectPath"],function(r){"use strict";var t={applyChange(t,e){var a=e.getContent();var o=a.entityPropertyChange.operation==="UPSERT";var n=t["sap.ovp"].cards;var p=a.entityPropertyChange;if(Array.isArray(p)){throw Error("Expected value for oPropertyChange was an object")}if(!o){throw Error("This Operation is not supported")}if(a.cardId in n&&"propertyPath"in p){r.set([a.cardId,p.propertyPath],p.propertyValue,n)}else{throw Error("Change card settings was not found")}return t}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ovp/DeleteCard", [],function(){"use strict";var e={applyChange(e,r){var t=r.getContent();var a=e["sap.ovp"].cards;if(t.cardId in a){delete a[t.cardId]}else{throw Error("The card to be deleted was not found")}return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddComponentUsages", [],function(){"use strict";var e={applyChange(e,n){var s=n.getContent().componentUsages;e["sap.ui5"].componentUsages||={};var t=e["sap.ui5"].componentUsages;Object.keys(s).forEach(function(e){if(t[e]){throw new Error(`Component usage '${e}' already exists`)}else{t[e]=s[e]}});return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddLibrary", ["sap/base/util/Version"],function(e){"use strict";function i(i,n){var r={};if(n.minVersion){var s=new e(i.minVersion);r.minVersion=s.compareTo(n.minVersion)>=0?i.minVersion:n.minVersion}if(n.lazy){r.lazy=i.lazy===n.lazy===true}return r}var n={applyChange(e,n){e["sap.ui5"].dependencies.libs||={};var r=e["sap.ui5"].dependencies.libs;var s=n.getContent().libraries;Object.keys(s).forEach(function(e){if(r[e]){r[e]=i(r[e],s[e])}else{r[e]=s[e]}});return e}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModel", [],function(){"use strict";var e=["OData","INA","XML","JSON","FHIR","http","WebSocket"];var t=e.concat(["ODataAnnotation"]);function n(e,t,n){return!e[t].type||n.indexOf(e[t].type)>=0}function r(e,t){return s(e).some(function(e){return(!e.type||e.type==="OData")&&e.settings.annotations.indexOf(t)>=0})}function o(t,n,r){return a(n,r,e)||i(t,r)}function a(e,t,r){return u(e,t)&&n(e,t,r)}function i(e,t){if(u(e,t)){if(e[t].type&&e[t].type==="ODataAnnotation"){throw new Error(`The already existing dataSource '${t}' in the manifest is type of 'ODataAnnotation'. A model must not reference to a dataSource which is of type 'ODataAnnotation'`)}return true}return false}function u(e,t){return e&&Object.keys(e).indexOf(t)>=0}function c(e,t,n){if(t){Object.keys(t).forEach(function(r){if(e[r]){throw new Error(`The ${n} '${r}' already exists`)}e[r]=t[r]})}}function d(e,t,n,r,o){e[n][r]||={};c(e[n][r],t.getContent()[o],o);return e[n][r]}function f(e,t,n){if(e[n].type==="ODataAnnotation"){return true}return s(t).some(function(e){return e.dataSource&&e.dataSource===n})}function h(e,t){return e[t].type||e[t].dataSource}function s(e){return Object.keys(e).map(function(t){return e[t]})}var y={applyChange(a,i){var u=i.getContent().model;var c=i.getContent().dataSource;if(u){if(Object.keys(u).length!==1){throw new Error(`There are currently '${Object.keys(u).length}' models in the change. Currently it is only allowed to add '1' model`)}Object.keys(u).forEach(function(t){if(!h(u,t)){throw new Error(`There is no 'dataSource' or 'type' in the change model defined. Please define either 'type' or 'dataSource' in property '${t}'`)}if(u[t].dataSource){if(!o(a["sap.app"].dataSources,c,u[t].dataSource)){throw new Error(`The defined dataSource '${u[t].dataSource}' in the model does not exists as dataSource or must be allowed type of ${e.join("|")}`)}}})}else{throw new Error("No model defined")}if(c){Object.keys(c).forEach(function(e){if(!n(c,e,t)){throw new Error(`The dataSource '${e}' has the type '${c[e].type}', but only dataSources with the follwing types are supported: ${t.join("|")}`)}if(!f(c,u,e)){throw new Error(`The dataSource in the change '${e}' is not used by any model in the change. A dataSource in the change must be used by model in the change`)}if(c[e].type==="ODataAnnotation"){if(!r(c,e)){throw new Error(`There is no dataSource with type 'OData' defined which includes the annotation '${e}'`)}}})}d(a,i,"sap.ui5","models","model");d(a,i,"sap.app","dataSources","dataSource");return a}};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModelEnhanceWith", ["sap/ui/fl/apply/_internal/changes/descriptor/ApplyUtil","sap/base/util/ObjectPath"],function(e,t){"use strict";var s={applyChange(s,a){var i=a.getContent().modelId;var n=e.formatBundleName(s["sap.app"].id,a.getTexts().i18n);var p=s["sap.ui5"].models[i];if(p){if(p.type&&p.type==="sap.ui.model.resource.ResourceModel"){if(!(p.settings&&p.settings.enhanceWith)){t.set("settings.enhanceWith",[],p)}var r=p.settings.enhanceWith;r.push({bundleName:n})}}return s},skipPostprocessing:true};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetFlexExtensionPointEnabled", ["sap/base/util/ObjectPath"],function(n){"use strict";var e={applyChange(e,t){if(!t.getContent().flexExtensionPointEnabled){throw new Error("No flexExtensionPointEnabled in change content provided")}n.set(["sap.ui5","flexExtensionPointEnabled"],t.getContent().flexExtensionPointEnabled,e);return e}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetMinUI5Version", ["sap/base/util/Version"],function(e){"use strict";var n={applyChange(n,i){var s=new e(n["sap.ui5"].dependencies.minUI5Version);if(s.compareTo(i.getContent().minUI5Version)<=0){n["sap.ui5"].dependencies.minUI5Version=i.getContent().minUI5Version}return n}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/connectors/ObjectStorageConnector", ["sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils","sap/ui/fl/initial/_internal/StorageUtils"],function(e,t){"use strict";function n(t){var n=[];return e.forEachObjectInStorage(t,function(e){n.push(e.changeDefinition)}).then(function(){return n})}var r={oStorage:undefined,layers:["ALL"],loadFlexData(e){return n({storage:this.oStorage,reference:e.reference}).then(function(e){var n=t.getGroupedFlexObjects(e);return t.filterAndSortResponses(n)})}};r.storage=r.oStorage;return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils", [],function(){"use strict";var e="sap.ui.fl";return{forEachObjectInStorage(r,t){var n=r.storage.getItems&&r.storage.getItems()||r.storage;return Promise.resolve(n).then(function(n){var a=Object.keys(n).map(function(a){var i=a.includes(e);if(!i){return}var s=n[a];var c=r.storage._itemsStoredAsObjects?s:JSON.parse(s);var o=true;if(r.reference){o=this.isSameReference(c,r.reference)}var u=true;if(r.layer){u=c.layer===r.layer}if(!o||!u){return}return t({changeDefinition:c,key:a})}.bind(this));return Promise.all(a)}.bind(this))},getAllFlexObjects(e){var r=[];return this.forEachObjectInStorage(e,function(e){r.push(e)}).then(function(){return r})},createFlexKey(r){if(r){return`${e}.${r}`}},createFlexObjectKey(e){return this.createFlexKey(e.fileName)},isSameReference(e,r){var t=r.endsWith(".Component")?r.replace(/\.Component$/,""):`${r}.Component`;return e.reference===r||e.reference===t}}});
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/apply/_internal/extensionPoint/Processor", ["sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/changes/ExtensionPointState","sap/ui/fl/Utils","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/base/SyncPromise","sap/base/util/merge","sap/ui/base/DesignTime"],function(e,n,t,i,r,o,a,s){"use strict";var u;function f(e,n,t,i,r){return r(e,true).then(function(r){r.forEach(function(e,r){n.splice(t+r+i,0,e)});e.index+=i;return r.length-1})}function l(e,n,t){var i=[];var r=[];var a=0;var s;t.forEach(function(t,o){if(t._isExtensionPoint){t.targetControl=e.targetControl;t.aggregationName=e.aggregationName;t.fragmentId=e.fragmentId;t.index=o;if(s){s._nextSibling=t}s=t;t.referencedExtensionPoint=e;i.push(function(){return f(t,r,o,a,n).then(function(e){a+=e})})}else{r.push(t)}});if(i.length>0){return i.reduce(function(e,n){return e.then(n)},o.resolve()).then(function(){return r})}return o.resolve(r)}function g(e,o){var s=i.getAppComponentForControl(e.targetControl);var f={};var l=a({defaultContent:[]},e);f.appComponent=s;f.modifier=r;f.viewId=e.view.getId();f.componentId=s.getId();return u.registerExtensionPoint(l).then(n.initialize.bind(n,f)).then(t.enhanceExtensionPointChanges.bind(t,f,e)).then(u.createDefaultContent.bind(this,e,o,g)).then(u.addDefaultContentToExtensionPointInfo.bind(this,l,o))}u={oExtensionPointRegistry:undefined,oRegistryPromise:Promise.resolve(),registerExtensionPoint(e){if(s.isDesignModeEnabled()){if(u.oExtensionPointRegistry){u.oExtensionPointRegistry.registerExtensionPoint(e);return o.resolve()}u.oRegistryPromise=u.oRegistryPromise.then(function(){return new Promise(function(n,t){sap.ui.require(["sap/ui/fl/write/_internal/extensionPoint/Registry"],function(t){u.oExtensionPointRegistry=t;t.registerExtensionPoint(e);n()},function(e){t(e)})})});return u.oRegistryPromise}return o.resolve()},createDefaultContent(e,n,t,i){if(i.length===0){return e.createDefault().then(l.bind(undefined,e,t)).then(function(t){if(!n){t.forEach(function(n,t){r.insertAggregation(e.targetControl,e.aggregationName,n,e.index+t,e.view)});e.ready(t)}return t})}return o.resolve([])},addDefaultContentToExtensionPointInfo(e,n,t){if(!n){e.defaultContent=e.defaultContent.concat(t)}return t},applyExtensionPoint(n){var t=g(n,false);e.addPreConditionForInitialChangeApplying(t);return t}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState", ["sap/ui/fl/apply/_internal/flexState/FlexState"],function(e){"use strict";var t={};t.getPersonalization=function(t,n,i){var r=e.getUI2Personalization(t);if(!r||!r[n]){return i?undefined:[]}if(!i){return r[n]}return r[n].filter(function(e){return e.itemName===i})[0]};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/changes/ExtensionPointState", ["sap/base/util/restricted/_omit","sap/base/util/merge","sap/base/Log","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/ChangePersistenceFactory"],function(e,n,t,i,o,a){"use strict";var r={};function s(e,n){if(n.getSelector().name!==e.extensionPointName){return false}return i.filterChangeByView(e,n)}function g(e,n){if(n.fragmentId){var t=e.getExtensionPointInfo&&e.getExtensionPointInfo();if(t){return n.fragmentId!==t.fragmentId}return true}return false}function l(e,t,i){var o=e.getSelector();if(t.closestAggregationBindingCarrier&&t.closestAggregationBinding){o=n(o,{id:t.closestAggregationBindingCarrier,idIsLocal:false});var a={id:t.targetControl.getId(),idIsLocal:false};if(i){e.originalSelectorToBeAdjusted=a}else{e.setDependentSelectors({originalSelector:a})}e.setContent({boundAggregation:t.closestAggregationBinding})}else{o=n(o,{id:t.targetControl.getId(),idIsLocal:false})}e.setSelector(o)}r.getChangesForExtensionPoint=function(e,n){if(!n.extensionPointName){t.error("Missing name from extension point info!");return Promise.resolve([])}return e.getChangesForComponent().then(function(e){return e.filter(s.bind(undefined,n))})};r.enhanceExtensionPointChanges=function(n,t){n.extensionPointName=t.name;var i=a.getChangePersistenceForControl(t.targetControl);return r.getChangesForExtensionPoint(i,n).then(function(a){var r=[];a.forEach(function(a){if(a.isInInitialState()&&!(a.getExtensionPointInfo&&a.getExtensionPointInfo())){a.setExtensionPointInfo(t);l(a,t,false);if(i.isChangeMapCreated()){i.addChangeAndUpdateDependencies(n.appComponent,a)}}else if(g(a,t)){var s=a.convertToFileContent();var c=a.getContent();var f=e(s,["dependentSelector","fileName","selector","content"]);Object.keys(c).forEach(function(e){f[e]=c[e]});f.support.sourceChangeFileName=a.getId()||"";r.push(o.create({changeSpecificData:f,selector:{view:t.view,name:t.name}}).then(function(e){l(e,t,true);e.setExtensionPointInfo(t);var o=e.getFlexObjectMetadata();o.moduleName=a.getFlexObjectMetadata().moduleName;e.setFlexObjectMetadata(o);e.setCreation(a.getCreation());i.addChangeAndUpdateDependencies(n.appComponent,e,a)}))}});return Promise.all(r).then(function(){return a})})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/SmartVariantManagementApplyAPI", ["sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/apply/_internal/flexState/compVariants/Utils","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(t,a,e,n,r,i){"use strict";function o(t){const r=n.getFlexReferenceForControl(t);const i=a.getPersistencyKey(t);const o=e.getCompVariantsMap(r);return o._getOrCreate(i)}function s(t){var r=t.control;var o=r.getVariantManagement&&r.getVariantManagement()||r;var s=o.getId();var l=n.getFlexReferenceForControl(r);return e.initialize({reference:l,componentData:{},manifest:i.getAppDescriptor(r),componentId:i.getAppComponentForControl(r).getId()}).then(function(){var n=a.getPersistencyKey(r);var i=e.getCompVariantsMap(l);e.setInitialNonFlCompVariantData(l,n,t.standardVariant,t.variants,s);return i._initialize(n,t.variants,s)})}var l={async loadVariants(e){const n=await s(e);const r=a.getPersistencyKey(e.control);const i=a.getDefaultVariantId(o(e.control));const l=t.merge(r,n,e.standardVariant,e.control);l.defaultVariantId=i;return l},isVendorLayer(){return r.isVendorLayer()},isVariantDownport(){var t=new URLSearchParams(window.location.search);var a=t.get("hotfix");return l.isVendorLayer()&&a==="true"},getDefaultVariantId(t){var a=o(t.control).defaultVariants;var e=a[a.length-1];return e?e.getContent().defaultVariantName:""}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/UI2PersonalizationApplyAPI", ["sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils"],function(e,t,a){"use strict";var n={async load(n){n.reference=a.getFlexReferenceForSelector(n.selector);if(!n.reference||!n.containerKey){throw new Error("not all mandatory properties were provided for the loading of the personalization")}await t.initialize({componentId:n.selector.getId()});return e.getPersonalization(n.reference,n.containerKey,n.itemName)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/LrepConnector", ["sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/Utils","sap/ui/dom/includeScript","sap/base/util/restricted/_pick"],function(e,t,i,s){"use strict";var n={DATA:"/flex/data/",MODULES:"/flex/modules/"};return{layers:["ALL"],xsrfToken:undefined,settings:undefined,_loadModules(e){return new Promise(function(t,s){i(e,undefined,t,s)})},_addClientInfo(e){var i=t.getUrlParameter("sap-client");if(!e&&i){e={}}if(i){e["sap-client"]=i}},loadFlexData(t){if(t.cacheKey==="<NO CHANGES>"){return Promise.resolve()}var i=s(t,["version","allContexts","adaptationId"]);this._addClientInfo(i);e.addSAPLogonLanguageInfo(i);var a;if(t.appDescriptor&&t.appDescriptor["sap.app"]){a=t.appDescriptor["sap.app"].id}if(t.preview){t.reference=t.preview.reference;i.upToLayerType=t.preview.maxLayer}var r=e.getUrl(n.DATA,t,i);return e.sendRequest(r,"GET",{initialConnector:this,xsrfToken:this.xsrfToken,siteId:t.siteId,sAppDescriptorId:a}).then(function(s){var a=s.response;if(s.etag){a.cacheKey=s.etag}else if(t.cacheKey){a.cacheKey=t.cacheKey}a.changes=a.changes.concat(a.compVariants||[]);if(a.settings){this.settings=a.settings;this.settings.isVariantAdaptationEnabled=!!this.settings.isPublicLayerAvailable;this.settings.isContextSharingEnabled=true;this.settings.isLocalResetEnabled=true}if(!a.loadModules){return a}var r=e.getUrl(n.MODULES,t,i);return this._loadModules(r).then(function(){return a})}.bind(this))}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/Utils", ["sap/ui/core/Lib","sap/base/i18n/Localization","sap/base/security/encodeURLParameters"],function(e,s,t){"use strict";var r=2e4;var n=function(e,s){var t=new Error(e.statusText);t.status=e.status;t.userMessage=s;return t};var a=function(s){return e.getResourceBundleFor("sap.ui.fl").getText(s)};return{addLanguageInfo(e){if(!e){throw new Error("No parameters map were passed")}e["sap-language"]=s.getLanguage()},addSAPLogonLanguageInfo(e){if(!e){throw new Error("No parameters map were passed")}e["sap-language"]=s.getSAPLogonLanguage()},getUrl(e,s,r){if(!e||!s.url){throw new Error("Not all necessary parameters were passed")}var n=s.url+e;if(s.cacheKey){n+=`~${s.cacheKey}~/`}if(s.reference){n+=s.reference}else if(s.fileName){n+=s.fileName}if(r){Object.keys(r).forEach(function(e){if(r[e]===undefined){delete r[e]}});var a=t(r);if(a.length>0){n+=`?${a}`}}return n},sendRequest(e,s,t){s||="GET";s=s.toUpperCase();return new Promise(function(o,i){var p=new XMLHttpRequest;p.open(s,e);p.timeout=r;if((s==="GET"||s==="HEAD")&&(!t||!t.initialConnector||!t.initialConnector.xsrfToken)){p.setRequestHeader("X-CSRF-Token","fetch")}if((s==="POST"||s==="PUT"||s==="DELETE")&&t&&t.initialConnector&&t.initialConnector.xsrfToken){p.setRequestHeader("X-CSRF-Token",t.initialConnector.xsrfToken)}if(t&&t.contentType){p.setRequestHeader("Content-Type",t.contentType)}if(t&&t.siteId){p.setRequestHeader("X-LRep-Site-Id",t.siteId)}if(t&&t.sAppDescriptorId){p.setRequestHeader("X-LRep-AppDescriptor-Id",t.sAppDescriptorId)}if(t&&t.dataType){p.responseType=t.dataType}p.onload=function(){if(p.status>=200&&p.status<400){try{var s={};if(p.status!==204&&p.status!==205){if(!p.response&&p.responseText){p.response=p.responseText}s.response=p.response;if(s.response&&typeof s.response==="string"&&p.getResponseHeader("content-type")&&p.getResponseHeader("content-type").indexOf("json")>0){s.response=JSON.parse(s.response)}}s.status=p.status;if(p.getResponseHeader("X-CSRF-Token")){if(!e.match(/\/~.*~/g)){s.xsrfToken=p.getResponseHeader("X-CSRF-Token");if(t&&t.initialConnector){t.initialConnector.xsrfToken=s.xsrfToken}}}if(p.getResponseHeader("Etag")){s.etag=p.getResponseHeader("Etag")}o(s)}catch(e){e.userMessage=a("MSG_LOADING_SERVER_RESPONSE_ERROR");i(e)}}else{var r="";try{var f=typeof p.response==="string"?JSON.parse(p.response):p.response;if(Array.isArray(f.messages)&&f.messages.length){r=f.messages.reduce(function(e,s){return e.concat(s.severity==="Error"?`${s.text}\n`:"")},r)}}catch(e){}i(n(p,r))}};p.ontimeout=function(){i(n(p,a("MSG_CONNECTION_TIMEOUT_ERROR")))};p.onerror=function(){i(n(p,a("MSG_NETWORK_ERROR")))};p.addEventListener("error",function(){i(n(p,a("MSG_NETWORK_ERROR")))});if(t&&t.payload){p.send(t.payload)}else{p.send()}})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/transport/TransportDialog", ["sap/ui/fl/write/_internal/transport/TransportDialog"],function(r){"use strict";var a=r.extend("sap.ui.fl.transport.TransportDialog",{metadata:{library:"sap.ui.fl",deprecated:true},renderer:{apiVersion:2}});return a});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/transport/TransportSelection", ["sap/ui/fl/write/_internal/transport/TransportSelection"],function(t){"use strict";return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/DescriptorChangeCheck", ["sap/base/util/includes","sap/ui/fl/Layer"],function(r,e){"use strict";function t(r,e,t){if(Array.isArray(r)){r.forEach(function(r){a(r,e,t)})}else{a(r,e,t)}}function o(r){var e=[];var t=r.filter(function(r){return r.endsWith("/*")});t.forEach(function(r){var t=r.replaceAll("/*","");if(t){e.push(t)}});return e}function n(r,e){var t=o(r);return t.some(function(r){return e.startsWith(r)})}function a(e,t,o){if(!e.propertyPath){throw new Error("Invalid change format: The mandatory 'propertyPath' is not defined. Please define the mandatory property 'propertyPath'")}if(!e.operation){throw new Error("Invalid change format: The mandatory 'operation' is not defined. Please define the mandatory property 'operation'")}if(e.operation.toUpperCase()!=="DELETE"){if(!e.hasOwnProperty("propertyValue")){throw new Error("Invalid change format: The mandatory 'propertyValue' is not defined. Please define the mandatory property 'propertyValue'")}}if(!r(t,e.propertyPath)&&!n(t,e.propertyPath)){throw new Error(`Changing ${e.propertyPath} is not supported. The supported 'propertyPath' is: ${t.join("|")}`)}if(!r(o,e.operation)){throw new Error(`Operation ${e.operation} is not supported. The supported 'operation' is ${o.join("|")}`)}}function i(r,e,o){var n=Object.keys(r).filter(function(r){return r.endsWith("Id")}).shift();if(!r[n]){throw new Error(`Mandatory "${n}" parameter is not provided.`)}if(!r.entityPropertyChange){throw new Error(`Changes for "${r[n]}" are not provided.`)}t(r.entityPropertyChange,e,o)}var p={};p[e.CUSTOMER]="customer.";p[e.CUSTOMER_BASE]="customer.";p[e.PARTNER]="partner.";p[e.VENDOR]=null;function s(r,e){var t=e.getLayer();if(!t){throw new Error("Mandatory layer parameter is not provided.")}var o=h(t);if(o===null){Object.keys(p).forEach(function(e){if(p[e]&&r.startsWith(p[e])){throw new Error(`Id ${r} must not start with reserved ${p[e]}`)}})}else if(!r.startsWith(o)){throw new Error(`Id ${r} must start with ${o}`)}}function h(r){var e=p[r];if(e===undefined){throw new Error(`Layer ${r} not supported.`)}return e}return{checkEntityPropertyChange:i,checkIdNamespaceCompliance:s,getNamespacePrefixForLayer:h,getClearedGenericPath:o,isGenericPropertyPathSupported:n}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/IFrame.flexibility", ["sap/ui/fl/changeHandler/UpdateIFrame"],function(e){"use strict";return{updateIFrame:e,hideControl:"default",unhideControl:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/changePropertyValueByPath", ["sap/base/util/ObjectPath"],function(r){"use strict";function t(t,a){var o=t.propertyPath.split("/");var e=r.get(o,a);if(e&&t.operation==="INSERT"){throw new Error("Path has already a value. 'INSERT' operation is not appropriate.")}if(!e&&t.operation==="UPDATE"){throw new Error("Path does not contain a value. 'UPDATE' operation is not appropriate.")}r.set(o,t.propertyValue,a)}return function(r,a){if(Array.isArray(r)){r.forEach(function(r){t(r,a)})}else{t(r,a)}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/Utils", ["sap/ui/fl/initial/_internal/connectors/Utils"],function(n){"use strict";function t(t,e,i){if(t.initialConnector){delete t.initialConnector.xsrfToken}return n.sendRequest(t.tokenUrl,"HEAD",{initialConnector:t.initialConnector}).then(n.sendRequest.bind(undefined,e,i,t))}function e(n,t,i){if(!t[i]){t[i]=n[i];return}if(Array.isArray(t[i])){t[i]=t[i].concat(n[i]);return}if(typeof t[i]==="object"){Object.keys(n[i]).forEach(function(r){e(n[i],t[i],r)})}t[i]=n[i]}return{getRequestOptions(n,t,e,i,r){var o={tokenUrl:t,initialConnector:n};if(e){o.payload=JSON.stringify(e)}if(i){o.contentType=i}if(r){o.dataType=r}return o},sendRequest(e,i,r){if(!r.initialConnector||!r.initialConnector.xsrfToken&&!(i==="GET")&&!(i==="HEAD")){return t(r,e,i)}return n.sendRequest(e,i,r).then(function(n){return n}).catch(function(n){if(n.status===403){return t(r,e,i)}throw n})},mergeResults(n){var t={};n.forEach(function(n){Object.keys(n).forEach(function(i){e(n,t,i)})});return t}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/transport/TransportDialog", ["sap/m/List","sap/m/InputListItem","sap/m/Button","sap/m/ComboBox","sap/m/Dialog","sap/m/Input","sap/m/MessageToast","sap/ui/core/ListItem","sap/ui/core/Lib","sap/ui/fl/write/_internal/transport/Transports","sap/ui/core/library"],function(t,e,s,o,r,a,i,n,l,p,u){"use strict";var{ValueState:c}=u;var h=r.extend("sap.ui.fl.write._internal.transport.TransportDialog",{metadata:{library:"sap.ui.fl",properties:{pkg:{type:"string",group:"Misc",defaultValue:null},transports:{type:"any",group:"Misc",defaultValue:null},lrepObject:{type:"any",group:"Misc",defaultValue:null},localObjectVisible:{type:"boolean",group:"Misc",defaultValue:true},hidePackage:{type:"boolean",group:"Misc",defaultValue:null}},events:{ok:{},cancel:{}}},renderer:{apiVersion:2}});h.prototype.init=function(){r.prototype.init.apply(this);this._oResources=l.getResourceBundleFor("sap.ui.fl");this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));this._oPackageLabel=null;this._oPackage=this._createPackageField();this._oTransport=this._createTransportCombo();this.addContent(this._createContentList());this._createButtons();this.setEscapeHandler(function(t){this.fireCancel();t.resolve()}.bind(this))};h.prototype._createContentList=function(){this._oPackageListItem=new e({label:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),content:[this._oPackage]});this._oTransportListItem=new e({label:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),content:[this._oTransport]});return new t({items:[this._oPackageListItem,this._oTransportListItem]})};h.prototype._createButtons=function(){var t=this;this._oLocalObjectButton=new s({text:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),press(){t._onLocal()}});this.addButton(this._oLocalObjectButton);this.addButton(new s({text:this._oResources.getText("TRANSPORT_DIALOG_OK"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_OK"),enabled:false,press(){t._onOkay()}}));this.addButton(new s({text:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),press(){t.fireCancel();t.close();t.destroy()}}))};h.prototype._onLocal=function(){this.fireOk({selectedTransport:"",selectedPackage:this.getPkg()||"$TMP",dialog:true});this.close();this.destroy()};h.prototype._onOkay=function(){var t=this._oTransport.getSelectedKey();if(this._checkOkay(t)){this.fireOk({selectedTransport:t,selectedPackage:this.getPkg()||this._oPackage.getValue(),dialog:true});this.close();this.destroy()}else{this.getButtons()[1].setEnabled(false);this._oTransport.setValueState(c.Error);this._oTransport.setValueStateText(this.getTitle())}};h.prototype._checkOkay=function(t){if(t){return true}return false};h.prototype._createTransportCombo=function(){var t=this;return new o({showSecondaryValues:true,enabled:false,tooltip:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),width:"100%",selectionChange(){if(t._oPackageListItem.getVisible()&&!t._oPackage.getValue()){return}t.getButtons()[1].setEnabled(true);t._oTransport.setValueState(c.None)},change(e){var s=function(t){if(t&&e.mParameters.newValue!==t.getText()||!t){return true}return false};if(e&&e.mParameters&&e.mParameters.newValue){if(s(t._oTransport.getSelectedItem())){t.getButtons()[1].setEnabled(false);t._oTransport.setValueState(c.Error);t._oTransport.setValueStateText(t._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"))}}}})};h.prototype._createPackageField=function(){var t=this;return new a({tooltip:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),width:"100%",change(){var e;var s;s=t._createObjectInfo();e=p.getTransports(s);e.then(function(e){t._onPackageChangeSuccess(e)},function(e){t._onPackageChangeError(e)})},liveChange(e){if(e.mParameters.liveValue&&e.mParameters.liveValue.length>3){t._oTransport.setEnabled(true)}}})};h.prototype._createObjectInfo=function(){var t;var e={package:this._oPackage.getValue()||""};t=this.getProperty("lrepObject");if(t){if(t.name){e.name=t.name}if(t.type){e.type=t.type}if(t.namespace){e.namespace=t.namespace}}return e};h.prototype._onPackageChangeSuccess=function(t){if(t){if(t.localonly){this._oTransport.setEnabled(false);this.getButtons()[1].setEnabled(true)}else if(t.transports&&t.transports.length>0){this._oTransport.setEnabled(true);this._setTransports(t)}else if(t.errorCode){this.getButtons()[1].setEnabled(false);this._oPackage.setValueState(c.Error);this._oPackage.setValueStateText(this._oResources.getText(`TRANSPORT_DIALOG_${t.errorCode}`));this._setTransports(t)}else{i.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"))}}};h.prototype._setTransports=function(t){var e;var s;e=this._hasLock(t.transports);if(e){s=[e]}else{s=t.transports}this.setTransports(s);if(s&&s.length===1){this._oTransport.setValue(s[0].description,true);this.getButtons()[1].setEnabled(true)}if(!s||s.length===0){this._oTransport.setSelectedKey(null);this._oTransport.setValueState(c.None);this.getButtons()[1].setEnabled(false)}};h.prototype._onPackageChangeError=function(t){i.show(t);this.setTransports([])};h.prototype._hasLock=function(t){var e;var s=t.length;while(s--){e=t[s];if(e.locked){return e}}return null};h.prototype.setLocalObjectVisible=function(t){this._oLocalObjectButton.setVisible(t);this.setProperty("localObjectVisible",t)};h.prototype.setPkg=function(t){if(t&&!this.getProperty("pkg")){this.setProperty("pkg",t);this._oPackage.setValue(t);this._oPackage.setEnabled(false);this._oTransport.setEnabled(true);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));this.getButtons()[0].setVisible(false)}return this};h.prototype.setTransports=function(t){var e;var s=0;var o;if(t){this.setProperty("transports",t);this._oTransport.removeAllItems();s=t.length;for(e=0;e<s;e++){o=t[e];this._oTransport.addItem(new n({key:o.transportId,text:o.transportId,additionalText:o.description}))}if(s===1){this._oTransport.setSelectedKey(t[0].transportId);this.getButtons()[1].setEnabled(true)}if(s>0){this._oTransport.setEnabled(true)}}return this};h.prototype.setLrepObject=function(t){if(t&&!this.getProperty("lrepObject")){this.setProperty("lrepObject",t)}return this};h.prototype.setHidePackage=function(t){this.setProperty("hidePackage",t);this._oPackageListItem.setVisible(!t);if(t){this.getButtons()[0].setEnabled(t);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"))}return this};return h},true);
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/transport/TransportSelection", ["sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/write/_internal/transport/Transports","sap/ui/fl/write/_internal/transport/TransportDialog","sap/ui/fl/registry/Settings","sap/ui/core/BusyIndicator"],function(e,t,a,r,n,s,o){"use strict";var i=function(){};i.prototype.selectTransport=function(n,o,i,c,p,l,u){if(!e.getLrepUrl()){o(this._createEventObject(n,{transportId:""}));return}var f=function(e,a,n,s,o,i){r.getTransports(e).then(function(r){if(this._checkDialog(r,i)){this._openDialog({hidePackage:!t.doesCurrentLayerRequirePackage(),pkg:e.package,transports:r.transports,localObjectVisible:u,lrepObject:this._toLREPObject(e)},a,n,s,o)}else{var c=!r.localonly&&i?{transportId:"ATO_NOTIFICATION"}:this._getTransport(r);a(this._createEventObject(e,c))}}.bind(this),function(e){n(e)})};var g=t.getCurrentLayer();if(g&&(g===a.CUSTOMER||g===a.CUSTOMER_BASE)){s.getInstance().then(function(e){if(e.isAtoEnabled()){if(!(n&&n.name&&n.namespace&&n.type)){var t={transportId:"ATO_NOTIFICATION"};o(this._createEventObject(n,t))}else{f.apply(this,[n,o,i,c,l,true])}}else{f.apply(this,[n,o,i,c,l,false])}}.bind(this))}else{f.apply(this,[n,o,i,c,l,false])}};i.prototype._createEventObject=function(e,t){return{mParameters:{selectedTransport:t.transportId,selectedPackage:e.package,dialog:false},getParameters(){return this.mParameters},getParameter(e){return this.mParameters[e]}}};i.prototype._toLREPObject=function(e){var t={};if(e.namespace){t.namespace=e.namespace}if(e.name){t.name=e.name}if(e.type){t.type=e.type}return t};i.prototype._openDialog=function(e,t,a,r,s){var i=new n(e);i.attachOk(t);i.attachCancel(a);i.addStyleClass(s);if(r){i.addStyleClass("sapUiSizeCompact")}else{i.removeStyleClass("sapUiSizeCompact")}i.open();o.hide();return i};i.prototype._getTransport=function(e){var t;if(!e.localonly){t=this._hasLock(e.transports)}else{t={transportId:""}}return t};i.prototype._checkDialog=function(e,t){if(e){if(e.localonly||this._hasLock(e.transports)||!e.localonly&&t){return false}}return true};i.prototype._hasLock=function(e){var t=e.length;while(t--){var a=e[t];if(a.locked){return a}}return false};i.prototype.setTransports=function(e,t){var a=e.length-1;var r=this;var n=function(e,t,a,s,o){if(t>=0){var i=e[t];if(o===true){if(i.getFlexObjectMetadata().packageName!=="$TMP"){i.setRequest(s)}t--;return n(e,t,a,s,o)}if(i.getFlexObjectMetadata().packageName!=="$TMP"){var c={name:i.getId(),type:i.getFileType(),package:i.getFlexObjectMetadata().packageName,namespace:i.getNamespace()};return r.openTransportSelection(c,a).then(function(r){if(r==="cancel"){return Promise.reject("cancel")}i.setRequest(r.transport);if(r.fromDialog===true){s=r.transport;o=true}t--;return n(e,t,a,s,o)},function(){return null})}t--;return n(e,t,a,s,o)}return Promise.resolve()};return n(e,a,t)};i.prototype.openTransportSelection=function(e,t,a,r){var n=this;return new Promise(function(s,o){var i=function(e){if(e&&e.getParameters){var t=e.getParameters().selectedTransport;var a=e.getParameters().selectedPackage;var r=e.getParameters().dialog;var n={transport:t,packageName:a,fromDialog:r};s(n)}else{s({})}};var c=function(e){if(e.sId==="cancel"){s(e.sId)}else{o(e)}};n.selectTransport(e||{},i,c,false,t,a,r)})};i.prototype.checkTransportInfo=function(e){return e&&e.transport&&e.packageName!=="$TMP"};i.prototype._prepareChangesForTransport=function(e,t,a,n){var s=r.convertToChangeTransportData(t,a);var o={};o.package=e.packageName;o.transportId=e.transport;o.changeIds=s;o.reference=n.reference;o.layer=n.layer;return r.makeChangesTransportable(o).then(function(){t.forEach(function(t){var a=t.getFlexObjectMetadata();if(a.packageName==="$TMP"){a.packageName=e.packageName;t.setFlexObjectMetadata(a)}})})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/transport/Transports", ["sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils"],function(e,r,t,n){"use strict";var a={ACTION_GET_TRANSPORTS:"/actions/gettransports/",ACTION_MAKE_CHANGE_TRANSPORTABLE:"/actions/make_changes_transportable/",ACTION_GET_TOKEN:"/actions/getcsrftoken/"};return{getTransports(e){if(r.getClient()){e["sap-client"]=r.getClient()}var n=t.getUrl(a.ACTION_GET_TRANSPORTS,{url:r.getLrepUrl()},e);n=decodeURIComponent(n);return t.sendRequest(n,"GET").then(function(e){if(e.response){e.response.localonly||=false;e.response.errorCode||="";return Promise.resolve(e.response)}return Promise.reject("response is empty")})},makeChangesTransportable(s){if(!s.transportId){return Promise.reject(new Error("no transportId provided as attribute of mParameters"))}if(!s.changeIds){return Promise.reject(new Error("no changeIds provided as attribute of mParameters"))}if(!s.reference){return Promise.reject(new Error("no reference provided as attribute of mParameters"))}var i=r.getClient()?{"sap-client":r.getClient()}:{};var o=t.getUrl(a.ACTION_MAKE_CHANGE_TRANSPORTABLE,{url:r.getLrepUrl()},i);var l=t.getUrl(a.ACTION_GET_TOKEN,{url:r.getLrepUrl()});var p=n.getRequestOptions(e,l,s,"application/json; charset=utf-8","json");return n.sendRequest(o,"POST",p)},convertToChangeTransportData(e,r){var t=[];var n;if(r&&r.length){for(n=0;n<r.length;n++){var a=r[n];var s={};s.namespace=a.getNamespace();s.fileName=a.getDefinition().fileName;s.fileType=a.getDefinition().fileType;t.push(s)}}var i=e.length;for(n=0;n<i;n++){var o=e[n];var l={};l.namespace=o.getNamespace();l.fileName=o.getId();l.fileType=o.getFileType();t.push(l)}return t}}},true);
//# sourceMappingURL=library-preload-apply.js.map
