/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/fl/write/api/Adaptations","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/write/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/_internal/Versions","sap/ui/model/json/JSONModel"],function(e,t,r,a,n,i,o,l,d,s,c,p,u,f,v,y,g){"use strict";var h={};var A;var x=[o.VENDOR,o.PARTNER,o.CUSTOMER_BASE,o.CUSTOMER];var I={};function m(e){var t=n.getFlexReferenceForControl(e);if(!t){throw Error("The application ID could not be determined")}return t}function C(e,t,r){if(r){return y.updateModelFromBackend({reference:t.appId,layer:t.layer}).then(function(){return e})}y.onAllChangesSaved({reference:t.appId,layer:t.layer,contextBasedAdaptation:true});return Promise.resolve(e)}I.initialize=function(t){A||=e.getResourceBundleFor("sap.ui.fl");if(!t.layer){return Promise.reject("No layer was provided")}if(!t.control){return Promise.reject("No control was provided")}var a=m(t.control);t.reference=a;var n=t.layer;if(h&&h[a]&&h[a][n]){return Promise.resolve(h[a][n])}var i;return r.isContextBasedAdaptationAvailable(n).then(function(e){i=e;var r=i?I.load(t):Promise.resolve({adaptations:[]});return r}).then(function(e){var r=s.get(t.control)||{};var a=e.adaptations[0];if(r.adaptationId){a=e.adaptations.find(function(e){return e.id===r.adaptationId})||a}return I.createModel(e.adaptations,a,i)}).then(function(e){h[a]||={};h[a][n]||={};h[a][n]=e;return h[a][n]})};I.createModel=function(e,r,a){if(!Array.isArray(e)){throw Error("Adaptations model can only be initialized with an array of adaptations")}if(a&&!r){throw Error("Invalid call, must pass displayed adaptation")}if(!a&&e.length){throw Error("Invalid call, must not pass adaptations if feature is disabled")}var n=new g({allAdaptations:[],adaptations:[],count:0,displayedAdaptation:{},contextBasedAdaptationsEnabled:a});n.updateAdaptations=function(e){var r=e.filter(function(e,r){e.rank=r+1;return e.type!==t.Type.Default});n.setProperty("/adaptations",r);n.setProperty("/allAdaptations",e);n.setProperty("/count",r.length);var a=n.getProperty("/displayedAdaptation");var i=e.find(function(e){return!!a&&e.id===a.id});if(i){a=Object.assign({},i);n.setProperty("/displayedAdaptation",a)}n.updateBindings(true)};n.insertAdaptation=function(e){var t=n.getProperty("/allAdaptations");t.splice(e.priority,0,e);delete e.priority;n.updateAdaptations(t)};n.deleteAdaptation=function(){var e=n.getProperty("/displayedAdaptation").rank-1;var t=n.getProperty("/adaptations");var r=n.getProperty("/count");var a;if(r>1){a=t[e+(e===r-1?-1:1)].id}t.splice(e,1);var i=n.getProperty("/allAdaptations").pop();t.push(i);n.updateAdaptations(t);return a};n.switchDisplayedAdaptation=function(e){var t=n.getIndexByAdaptationId(e);var r=t?n.getProperty("/allAdaptations")[t]:n.getProperty("/allAdaptations")[0];n.setProperty("/displayedAdaptation",r);n.updateBindings(true)};n.updateAdaptationContent=function(e){var t=n.getProperty("/allAdaptations");var r=t.find(function(t){return e.adaptationId===t.id});r.title=e.title;r.contexts=e.contexts;var a=r.rank-1;if(a!==e.priority){var i=t.splice(a,1);t.splice(e.priority,0,i[0])}n.updateAdaptations(t)};n.getIndexByAdaptationId=function(e){var t=n.getProperty("/allAdaptations");var r=t.findIndex(function(t){return t.id===e});return r>-1?r:undefined};if(e.length>0){n.updateAdaptations(e);n.setProperty("/displayedAdaptation",r)}return n};I.getAdaptationsModel=function(e){if(!e.layer){throw Error("No layer was provided")}if(!e.control){throw Error("No control was provided")}e.reference=m(e.control);var t=e.reference;var r=e.layer;if(!I.hasAdaptationsModel(e)){throw Error(`Adaptations model for reference '${t}' and layer '${r}' were not initialized.`)}return h[t][r]};I.getDisplayedAdaptationId=function(e){var r=this.getAdaptationsModel(e).getProperty("/displayedAdaptation/id");return r!==t.Type.Default?r:undefined};I.hasAdaptationsModel=function(e){var t=e.reference;var r=e.layer;return h[t]&&h[t][r]};I.adaptationExists=function(e){var t=e.reference;var r=e.layer;return this.hasAdaptationsModel({reference:t,layer:r})&&h[t][r].getProperty("/count")>0};I.clearInstances=function(){h={}};I.refreshAdaptationModel=function(e){this.clearInstances();return this.initialize(e).then(function(e){return e.getProperty("/displayedAdaptation/id")})};function P(e,t){return e.get(t)||t}function V(e,t){return v.contextBasedAdaptation.create({layer:e.layer,flexObject:t,appId:e.appId,parentVersion:_(e)}).then(function(r){var a=this.getAdaptationsModel(e);a.insertAdaptation(t);return C(r,e)}.bind(this))}function b(e,t){return v.write({layer:e.layer,flexObjects:t,transport:"",isLegacyVariant:false,parentVersion:_(e)})}function j(e,t,r){if(r.isA("sap.ui.fl.apply._internal.flexObjects.CompVariant")){var a=t.filter(function(e){return e.getChangeType()==="updateVariant"&&e.getSelector().variantId===r.getId()});var n=r.clone();a.forEach(p.applyChangeOnVariant.bind(p,n));n.removeAllChanges();n.destroy();return n.mProperties}return e.find(function(e){return e.key===r.getId()})}function w(e,t){var r={};var a=[];e.forEach(function(e){var n=t[e.getId()];if(n.visible){var i=true;var o=Object.keys(n.contexts);o.forEach(function(t){var a=Array.from(n.contexts[t]);a.forEach(function(t){i=false;if(r[t]){r[t].variants.push(e)}else{r[t]={contextBasedAdaptationId:d.createDefaultFileName(),variants:[e]}}})});if(i){a.push(e)}}});return{uniqueContexts:r,unrestrictedViews:a}}function O(e,t,r){if(e.isA("sap.ui.fl.apply._internal.flexObjects.CompVariant")){var a=e.getPersistencyKey();e=u.updateVariant({reference:t.appId,persistencyKey:a,id:e.getId(),layer:t.layer,visible:false,adaptationId:r,forceCreate:true});return e.getChanges().reverse()[0].convertToFileContent()}var n=d.getAppComponentForControl(t.control);var o=n.getModel(i.getVariantModelName());var l=o.createVariantChange(e.getVariantManagementReference(),{changeType:"setVisible",visible:false,variantReference:e.getId(),layer:t.layer,appComponent:n,adaptationId:r});return l.convertToFileContent()}function E(e,t,r){var a=e.filter(function(e){return r===e.isA("sap.ui.fl.apply._internal.flexObjects.Variant")&&e.getLayer()===t});return a}function F(e){var t=e.getFileType();if(t==="change"){if(e.getSelector().variantId){return e.getSelector().variantId}if(e.getVariantReference()){return e.getVariantReference()}}else if(t==="ctrl_variant_change"&&e.getSelector().id){return e.getSelector().id}return undefined}function S(e){if(e.getFileType()==="ctrl_variant_change"&&e.getChangeType()==="setContexts"){return true}return false}function B(e,t){return t.filter(function(t){var r=F(t);if(S(t)){return false}return!r||e.indexOf(r)<0})}function M(e,t){var r=[];var a=[];var n=new Map;e.forEach(function(e){if(e.isA("sap.ui.fl.apply._internal.flexObjects.Variant")){r.push(e)}else{a.push(e)}});var i=N(r,n,t);var o=T(a,n,t);return i.concat(o).map(function(e){return e.convertToFileContent()})}function N(e,t,r){var n=[];e.forEach(function(e){var i=a.createFromFileContent(e.cloneFileContentWithNewId());i.setAdaptationId(r);i.setContexts();t.set(e.getId(),i.getId());n.push(i)});return n}function T(e,t,r){var n=[];e.forEach(function(e){var i=a.createFromFileContent(e.cloneFileContentWithNewId());var o=i.getContent();var l=i.getSelector();if(e.getFileType()==="change"){if(e.getSelector().variantId){l.variantId=P(t,i.getSelector().variantId);i.setSelector(l)}else if(e.getContent().defaultVariantName){o.defaultVariantName=P(t,i.getContent().defaultVariantName);i.setContent(o)}if(e.getVariantReference()){i.setVariantReference(P(t,i.getVariantReference()))}if(e.getChangeType()==="updateVariant"){delete i.getContent().contexts;if(!Object.keys(i.getContent()).length){return}}}else if(e.getFileType()==="ctrl_variant_change"&&e.getSelector().id){l.id=P(t,i.getSelector().id);i.setSelector(l)}else if(e.getFileType()==="ctrl_variant_management_change"&&e.getContent().defaultVariant){o.defaultVariant=P(t,i.getContent().defaultVariant);i.setContent(o)}i.setAdaptationId(r);n.push(i)});return n}function _(e){return y.getVersionsModel({layer:e.layer,reference:e.appId}).getProperty("/persistedVersion")}function R(e,t,r,a){var n={contextBasedAdaptations:[],flexObjects:[]};var i={};e.forEach(function(e){i[e.getId()]=j(t,r,e)});var l=w(e,i);var d=l.uniqueContexts;var s=l.unrestrictedViews;Object.entries(d).forEach(function(t){var i=t[0];var l=t[1];l.variants=l.variants.concat(s);var d=l.contextBasedAdaptationId;var c={id:d,title:A.getText("CBA_MIGRATED_ADAPTATION_TITLE",i),contexts:{role:[i]},priority:0};n.contextBasedAdaptations.push(c);var p=l.variants.filter(function(e){return e.getLayer()===o.CUSTOMER});var u=new Map;var f=N(p,u,d);f.forEach(function(e){n.flexObjects.push(e.convertToFileContent())});var v=l.variants.map(function(e){return e.getId()});var y=e.map(function(e){return e.getId()}).filter(function(e){return v.indexOf(e)<0});var g=B(y,r);var h=T(g,u,d);h.forEach(function(e){n.flexObjects.push(e.convertToFileContent())});e.forEach(function(e){if(e.getLayer()!==o.CUSTOMER&&v.indexOf(e.getId())<0){n.flexObjects.push(O(e,a,d))}})});e.forEach(function(e){var t=i[e.getId()];var r=s.indexOf(e)<0;if(t.visible===true&&r){n.flexObjects.push(O(e,a,undefined))}});return n}I.migrate=function(e){e.appId=m(e.control);var t=_(e);e.parentVersion=t;var r=[];var a=f.getAllVariants(n.getFlexReferenceForControl(e.control));var i={contextBasedAdaptation:[],flexObjects:[]};return c.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true}).then(function(e){x.forEach(function(t){r.push(E(e,t,true))});r.push(E(e,o.CUSTOMER,false));return Promise.all(r)}).then(function(t){var r=t.pop();var n=t.flat();i=R(n,a,r,e);var o=Promise.resolve();i.contextBasedAdaptations.forEach(function(t){o=o.then(V.bind(this,e,t))}.bind(this));return o}.bind(this)).then(function(){if(i.flexObjects.length>0){return b(e,i.flexObjects)}return Promise.resolve()}).then(function(){return this.refreshAdaptationModel({control:e.control,layer:e.layer})}.bind(this))};I.canMigrate=function(e){var t=I.getAdaptationsModel(e);if(t.getProperty("/count")!==0){return Promise.resolve(false)}return c.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true}).then(function(t){var r=[];x.forEach(function(e){r.push(E(t,e,true))});r=r.flat();var a=f.getAllVariants(n.getFlexReferenceForControl(e.control));return r.some(function(e){var r=j(a,t,e);return r.visible===true&&Object.keys(r.contexts).some(function(e){return r.contexts[e].length!==0})})})};I.create=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.contextBasedAdaptation){return Promise.reject("No contextBasedAdaptation was provided")}e.contextBasedAdaptation.id=d.createDefaultFileName();e.appId=m(e.control);return V.call(this,e,e.contextBasedAdaptation).then(function(){return c.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true,currentLayer:o.CUSTOMER})}).then(function(t){var r=l.filterChangeOrChangeDefinitionsByCurrentLayer(t,o.CUSTOMER);var a=M(r,e.contextBasedAdaptation.id);return b(e,a)})};I.update=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.contextBasedAdaptation){return Promise.reject("No contextBasedAdaptation was provided")}if(!e.adaptationId){return Promise.reject("No adaptationId was provided")}e.appId=m(e.control);return v.contextBasedAdaptation.update({layer:e.layer,flexObject:e.contextBasedAdaptation,appId:e.appId,adaptationId:e.adaptationId,parentVersion:_(e)}).then(function(t){return C(t,e)})};I.reorder=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.parameters||!e.parameters.priorities){return Promise.reject("No valid priority list was provided")}e.appId=m(e.control);return v.contextBasedAdaptation.reorder({layer:e.layer,flexObjects:e.parameters,appId:e.appId,parentVersion:_(e)}).then(function(t){return C(t,e)})};I.load=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}e.appId=m(e.control);return v.contextBasedAdaptation.load({layer:e.layer,appId:e.appId,version:_(e)}).then(function(e){e||={adaptations:[]};return e})};I.remove=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.adaptationId){return Promise.reject("No adaptationId was provided")}e.appId=m(e.control);return v.contextBasedAdaptation.remove({layer:e.layer,appId:e.appId,adaptationId:e.adaptationId,parentVersion:_(e)}).then(function(t){return C(t,e,true)})};return I});
//# sourceMappingURL=ContextBasedAdaptationsAPI.js.map