/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/model/json/JSONModel","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/isPlainObject","sap/base/strings/formatMessage"],function(e,t,a,i,s,n,r,u,o){"use strict";var l=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",metadata:{library:"sap.ui.integration"},init:function(){e.prototype.init.apply(this,arguments);this._itemsModel=new s;this._itemsModel.setDefaultBindingMode("OneWay");this.setModel(this._itemsModel,"itemsModel");this._supportedTypesModel=new s([]);this._supportedTypesModel.setDefaultBindingMode("OneWay");this.setModel(this._supportedTypesModel,"supportedTypes");this.attachModelContextChange(function(){if(this.getModel("i18n")){this._setSupportedTypesModel()}},this);this.attachConfigChange(this._setSupportedTypesModel,this);this._mTypes={}},setValue:function(t){t=u(t)?t:{};var a=this._getPositions(t);this.setDesigntimeMetadata(n({},this.getDesigntimeMetadata(),Object.keys(a).reduce(function(e,t){e[t]={__value:{position:a[t]}};return e},{})));e.prototype.setValue.call(this,t);var i=this._processValue(t);i=i.sort(function(e,t){return a[e.key]-a[t.key]}).map(function(e,t){e.index=t;e.total=i.length;return e});this._itemsModel.setData(i)},_processValue:function(e){return Object.keys(e).map(function(t){var i=this._prepareInputValue(e[t],t);this._mTypes[t]=i.type;var s={key:t,value:i,designtime:this.getNestedDesigntimeMetadata(t)};return this.getConfig().includeInvalidEntries||this._isValidItem(s,a(e[t]))?s:undefined},this).filter(Boolean)},_getPositions:function(e){var t=Object.keys(e);var a=t.map(function(e){var t=this.getNestedDesigntimeMetadataValue(e).position;return t>=0?t:-1}.bind(this));var i=a.reduce(function(e,t){return Math.max(e,t)},-1);var s={};a.forEach(function(e,a){s[t[a]]=e>=0?e:++i});return s},_prepareInputValue:function(e,t){var i=this.processInputValue(a(e),t);if(!i.type){i.type=this._mTypes[t]||this._getDesigntimeMetadataValue(t).type||this._getDefaultType(i.value)}return i},_getDesigntimeMetadataValue:function(e){var t=(this.getConfig()||{}).designtime||{};var a=t[e]||{};return a.__value||{}},_isValidItem:function(e){var t=e.value.type;return t&&this._getAllowedTypes().includes(t)},_getDefaultType:function(e){var t=this.getConfig().defaultType;if(t){return t}var a=this._getAllowedTypes();var i=typeof e;var s=a.includes(i)?i:undefined;if(!s&&a.includes("string")){s="string"}return s},_getAllowedTypes:function(){var e=this.getConfig();return e&&e.allowedTypes||l.configMetadata.allowedTypes.defaultValue},_setSupportedTypesModel:function(){var a=this._getAllowedTypes();var i=t.getTypes();Promise.all(a.map(function(t){return(i[t]||Promise.resolve(e)).then(function(e){return{key:t,editor:e}})})).then(function(e){var t=e.map(function(e){var t=e.editor.configMetadata.typeLabel.defaultValue;return{key:e.key,title:this.getI18nProperty(t)}}.bind(this));this._supportedTypesModel.setData(t)}.bind(this))},formatItemConfig:function(e){var t=e.key;var a=e.value.type;var i=e.value.value;if(a==="boolean"){i=e.value.value!==false}var s=(e.designtime||{}).__value;var n=this.getConfig();return[{label:this.getI18nProperty("BASE_EDITOR.MAP.KEY"),path:"key",value:t,type:"string",enabled:n.allowKeyChange,itemKey:t,allowBindings:false,validators:[{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue())}.bind(this),currentKey:function(e){return e.getValue()}}}]},{label:this.getI18nProperty("BASE_EDITOR.MAP.TYPE"),path:"type",value:a,type:"select",items:this._supportedTypesModel.getData(),visible:n.allowTypeChange,itemKey:t,allowBindings:false},{label:this.getI18nProperty("BASE_EDITOR.MAP.VALUE"),path:"value",value:i,type:a&&this._getAllowedTypes().includes(a)?a:this._getDefaultType(i),visible:a!=="group"&&a!=="separator",itemKey:t,designtime:(s||{}).value}]},getExpectedWrapperCount:function(e){return this._processValue(e).length},processInputValue:function(e){return{value:e}},processOutputValue:function(e){return e.value},_onRemoveElement:function(e){var t=e.getSource().getBindingContext("itemsModel").getObject().key;var i=this.getValue();this.setValue(r(i,t));var s=a(this.getDesigntimeMetadata());delete s[t];this.setDesigntimeMetadata(s)},_onAddElement:function(){var e=n({},this.getValue());var t=this._getUniqueKey(e);e[t]=this.processOutputValue(this._getItemTemplate());this.setValue(e)},_moveUp:function(e){var t=e.getSource().data("index");if(t>0){var a=this._itemsModel.getData();this._swapPositions(a[t].key,a[t-1].key)}},_moveDown:function(e){var t=e.getSource().data("index");var a=this._itemsModel.getData();if(t<a.length-1){this._swapPositions(a[t].key,a[t+1].key)}},_swapPositions:function(e,t){var a={};a[e]={__value:{position:this.getNestedDesigntimeMetadataValue(t).position}};a[t]={__value:{position:this.getNestedDesigntimeMetadataValue(e).position}};this.setDesigntimeMetadata(n({},this.getDesigntimeMetadata(),a));this.setValue(this.getValue())},_getItemTemplate:function(){return{value:"",type:"string"}},_isNewItem:function(e){return i(e.value,this._prepareInputValue(this.processOutputValue(this._getItemTemplate())))},_getUniqueKey:function(e){var t="key";var a=0;while(e.hasOwnProperty(t)){t="key"+ ++a}return t},_propertyEditorsChange:function(e){var t=e.getParameter("previousPropertyEditors");var a=e.getParameter("propertyEditors");if(Array.isArray(t)){t.forEach(function(e){e.detachValueChange(this._onItemChange,this);e.detachDesigntimeMetadataChange(this._onDesigntimeValueChange,this)},this)}if(Array.isArray(a)){a.forEach(function(e){e.attachValueChange(this._onItemChange,this);e.attachDesigntimeMetadataChange(this._onDesigntimeValueChange,this)},this)}},_onItemChange:function(e){var t=e.getSource().getConfig().itemKey;var a=e.getParameter("path");var i=this.getItemChangeHandlers()[a];if(typeof i!=="function"){i=this._onFieldChange}i.call(this,t,e)},_onDesigntimeValueChange:function(e){var t=e.getSource().getConfig().itemKey;var a=e.getParameter("path");if(a!=="value"){return}this._onDesigntimeChange(t,e)},_onDesigntimeChange:function(e,t){var a=n({},this.getConfig().designtime);var i={__value:{}};i.__value[t.getParameter("path")]=t.getParameter("value");a[e]=n({},a[e],i);this.setDesigntimeMetadata(a);this.setValue(this.getValue())},getItemChangeHandlers:function(){return{key:this._onKeyChange,type:this._onTypeChange}},_onKeyChange:function(e,t){if(t.getParameter("previousValue")===undefined){return}var a=n({},this.getValue());var i=t.getParameter("value");if(i!==e){var s={};Object.keys(a).forEach(function(t){var n=t===e?i:t;s[n]=a[t]});if(s[i]&&s[i].type!=="group"&&s[i].type!=="separator"&&s[i].manifestpath&&s[i].manifestpath.startsWith("/sap.card/configuration/parameters/")){s[i].manifestpath="/sap.card/configuration/parameters/"+i+"/value"}this._mTypes[i]=this._mTypes[e];delete this._mTypes[e];this.setValue(s);var r=n({},this.getConfig().designtime);if(r.hasOwnProperty(e)){r[i]=r[e];if(r[i].__value&&r[i].__value.type&&r[i].__value.type!=="group"&&r[i].__value.type!=="separator"&&r[i].__value.manifestpath){r[i].__value.manifestpath=r[i].__value.manifestpath.replace(e,i)}delete r[e];this.setDesigntimeMetadata(r)}}},_onTypeChange:function(e,t){if(t.getParameter("previousValue")===undefined){return}var a=n({},this.getValue());var i=t.getParameter("value");var s=t.getParameter("previousValue");if(i!==s){var r=this.processInputValue(a[e]);r.type=i;a[e]=this.processOutputValue(r);if(i==="simpleicon"){a[e].visualization={type:"IconSelect",settings:{value:"{currentSettings>value}",editable:"{currentSettings>editable}"}}}else{delete a[e].visualization}if(i!=="array"&&i!=="string"&&i!=="object"&&i!=="objectArray"){delete a[e].values}if(i==="object"&&typeof a[e].value!=="object"){delete a[e].value}if(i==="objectArray"&&!(a[e].value instanceof Array)){delete a[e].value}this._mTypes[e]=i;this.setValue(a);var u=n({},this.getConfig().designtime);if(u.hasOwnProperty(e)){if(i==="simpleicon"){u[e].__value.visualization={type:"IconSelect",settings:{value:"{currentSettings>value}",editable:"{currentSettings>editable}"}}}else{delete u[e].__value.visualization}if(i!=="array"&&i!=="string"&&i!=="object"&&i!=="objectArray"){delete u[e].__value.values}u[e].__value.type=i;this.setDesigntimeMetadata(u)}}},_onFieldChange:function(e,t){var a=n({},this.getValue());var i=t.getParameter("path");var s=t.getParameter("value");var r=this.processInputValue(a[e]);r[i]=s;a[e]=this.processOutputValue(r);this.setValue(a)},formatAddItemText:function(e,t){var a=this.getI18nProperty(t);return o(e,[a])},renderer:e.getMetadata().getRenderer().render});l.configMetadata=Object.assign({},e.configMetadata,{allowKeyChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowTypeChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowedTypes:{defaultValue:["string"],mergeStrategy:"intersection"},defaultType:{defaultValue:null},allowSorting:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},includeInvalidEntries:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},addItemLabelI18n:{defaultValue:"BASE_EDITOR.MAP.DEFAULT_TYPE"}});return l});
//# sourceMappingURL=MapEditor.js.map