/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/ui/core/Fragment","sap/ui/unified/ColorPickerPopover","sap/ui/unified/library","sap/ui/model/json/JSONModel","sap/base/util/deepClone","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_omit","sap/ui/core/IconPool"],function(t,e,o,i,s,a,n,r,l,g,p){"use strict";var c=t.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",{metadata:{library:"sap.ui.integration"},xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",renderer:t.getMetadata().getRenderer().render});c.configMetadata=Object.assign({},t.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.ICON"}});var d={config:{type:"simpleicon"},key:"src"};var u={config:{type:"string",maxLength:2,validators:{isAlphabetic:{type:"pattern",config:{pattern:"^[A-Za-z]*$"},errorMessage:"CARD_EDITOR.VALIDATOR.NOT_AN_ALPHABETIC"}}},key:"text"};var h={config:{type:"string"},key:"src"};var _={type:"icon",src:"",shape:"Circle",alt:"",text:"",backgroundColor:"",color:""};var f=s.ColorPickerMode;var y=s.ColorPickerDisplayMode;c.prototype.init=function(){this._oIconModel=new a(n(_));this._oIconModel.setDefaultBindingMode("OneWay");this.setModel(this._oIconModel,"icon");this._oConfigsModel=new a({selectConfig:{type:"select",items:[],allowBindings:false},valueConfig:d});this._oConfigsModel.setDefaultBindingMode("OneWay");this.setModel(this._oConfigsModel,"configs");this._oSettingsModel=new a({shapes:[],altVisible:true,backgroundColorVisible:false,colorVisible:false});this._oSettingsModel.setDefaultBindingMode("OneWay");this.setModel(this._oSettingsModel,"settings");this.attachModelContextChange(function(){if(this.getModel("i18n")){var t=n(this._oConfigsModel.getData());t.selectConfig.items=[{key:"icon",title:this.getI18nProperty("BASE_EDITOR.ICON.TYPE_ICON")},{key:"text",title:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_TEXT_LABEL")},{key:"picture",title:this.getI18nProperty("BASE_EDITOR.ICON.TYPE_PICTURE")}];this._oConfigsModel.setData(t);var e=n(this._oSettingsModel.getData());e.shapes=[{key:"Square",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_SQUARE")},{key:"Circle",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_CIRCLE")}];this._oSettingsModel.setData(e)}},this)};c.prototype.getExpectedWrapperCount=function(){return 2};c.prototype.setValue=function(e){var o=l(e)?undefined:e;t.prototype.setValue.call(this,o);this._oIconModel.setData(Object.assign({},this._oIconModel.getData(),e,{type:this.getDesigntimeMetadataValue().type||C(e)}))};function C(t){if(r(t)){if(t.src){if(t.backgroundColor||t.color||p.isIconURI(t.src)&&p.getIconInfo(t.src)||e(t.src,false)){return"icon"}else{return"picture"}}else if(t.text){return"text"}}return _.type}c.prototype._prepareValue=function(t,e){return e[t]};c.prototype._onTypeChange=function(t){var e;var o=t.getSource().getValue();switch(o){case"icon":e=d;this._oSettingsModel.setProperty("/altVisible",true);break;case"text":e=u;this._oSettingsModel.setProperty("/altVisible",false);break;case"picture":e=h;this._oSettingsModel.setProperty("/altVisible",true);break}this._oConfigsModel.setData(Object.assign({},this._oConfigsModel.getData(),{valueConfig:e}));this.setDesigntimeMetadataValue({type:o});this.setValue(this._processOutputValue(this._oIconModel.getData()))};c.prototype._updateValue=function(t){var e=this._oConfigsModel.getData().valueConfig.key;var o={};o[e]=t.getSource().getValue();var i=Object.assign({},this._oIconModel.getData(),o);this.setValue(this._processOutputValue(i))};c.prototype._handleSettings=function(){this._oOldData=n(this.getModel("icon").getData());if(!this._oSettingsDialog){return o.load({name:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditorSettingsDialog",controller:this}).then(function(t){this._oDialogModel=new a(this._oOldData);this._oSettingsDialog=t;this._oSettingsDialog.setModel(this._oDialogModel,"data");this.addDependent(this._oSettingsDialog);this._oSettingsDialog.open();return this._oSettingsDialog}.bind(this))}else{this._oSettingsDialog.open();this._oDialogModel.setData(this._oOldData);return Promise.resolve(this._oSettingsDialog)}};c.prototype._onSettingsSave=function(){this._oSettingsDialog.close();this.setValue(this._processOutputValue(this._oDialogModel.getData()))};c.prototype._onSettingsCancel=function(){this._oSettingsDialog.close()};c.prototype._processOutputValue=function(t){var e=this.getDesigntimeMetadataValue().type;var o=["type"];Object.keys(t).forEach(function(e){if(!t[e]||t[e]===_[e]){o.push(e)}});switch(e){case"icon":o.push("text");if(!t["src"]){o.push("shape","alt","backgroundColor","color")}break;case"picture":o.push("text","backgroundColor","color");if(!t["src"]){o.push("shape","alt")}break;case"text":o.push("src","alt");if(!t["text"]){o.push("shape","backgroundColor","color")}break}return g(t,o)};c.prototype._openColorPickerPopup=function(t){this._inputId=t.getSource().getId();if(!this.oColorPickerSimplifiedPopover){this.oColorPickerSimplifiedPopover=new i("oColorPickerSimpplifiedPopover",{colorString:"blue",displayMode:y.Simplified,mode:f.HSL,change:this._handleColorPickerChange.bind(this)})}this.oColorPickerSimplifiedPopover.openBy(t.getSource())};c.prototype._handleColorPickerChange=function(t){var e=sap.ui.getCore().byId(this._inputId);e.setValue(t.getParameter("hex"));e.setValueState("None");this._inputId=""};c.prototype.getFocusDomRef=function(){var t=this.getContent();if(t){return this.getContent().getItems()[0].getContent()[0].getFocusDomRef()}};c.prototype.getIdForLabel=function(){var t=this.getContent();if(t){return this.getContent().getItems()[0].getContent()[0].getIdForLabel()}};return c});
//# sourceMappingURL=IconEditor.js.map