/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/editor/fields/viz/VizBase","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/core/IconPool","sap/ui/core/_IconRegistry","sap/base/util/merge","sap/ui/core/Core","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/integration/formatters/IconFormatter","sap/m/Popover","sap/m/Image","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Text","sap/m/CheckBox","sap/m/SegmentedButton","sap/m/SegmentedButtonItem"],function(e,t,o,i,n,s,l,a,r,c,p,d,u,h,f,g,_,I,y){"use strict";var S=a.getLibraryResourceBundle("sap.ui.integration"),C,m,b=false;var T=e.extend("sap.ui.integration.editor.fields.viz.IconSelect",{metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:"sap-icon://accept"},allowFile:{type:"boolean",defaultValue:true},allowNone:{type:"boolean",defaultValue:true},allowDefaultIcons:{type:"boolean",defaultValue:true}}},renderer:{apiVersion:2}});T.prototype._initDefaultIcons=function(){C=[];var e=n.getIconNames();e=e.sort(function(e,t){return e.toLowerCase().localeCompare(t.toLowerCase())});e.filter(function(e){var t=n.getIconInfo(e).text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);C.push({icon:"sap-icon://"+e,key:"sap-icon://"+e,text:t,additionalText:"sap-icon://"+e,tooltip:t,enabled:true,type:"UI5"})});if(!b){return}var t=s.getFontRegistry();if(!t["SAP-icons-TNT"]){n.registerFont({fontFamily:"SAP-icons-TNT",collectionName:"SAP-icons-TNT",fontURI:sap.ui.require.toUrl("sap/tnt/themes/base/fonts")})}if(!t["BusinessSuiteInAppSymbols"]){n.registerFont({fontFamily:"BusinessSuiteInAppSymbols",collectionName:"BusinessSuiteInAppSymbols",fontURI:sap.ui.require.toUrl("sap/ushell/themes/base/fonts/")})}m=Promise.all([n.fontLoaded("SAP-icons-TNT"),n.fontLoaded("BusinessSuiteInAppSymbols")]).then(function(){e=n.getIconNames("SAP-icons-TNT");e=e.filter(function(e){var t=e.substring(0,1).charCodeAt();return e.indexOf(" ")<0&&t>=97&&t<=122});e.sort();e.filter(function(e){var t=n.getIconInfo(e,"SAP-icons-TNT").text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);C.push({icon:"sap-icon://SAP-icons-TNT/"+e,key:"sap-icon://SAP-icons-TNT/"+e,text:t,additionalText:"sap-icon://SAP-icons-TNT/"+e,tooltip:t,enabled:true,type:"SAP-icons-TNT"})});e=n.getIconNames("BusinessSuiteInAppSymbols");e.sort();e.filter(function(e){var t=n.getIconInfo(e,"BusinessSuiteInAppSymbols").text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);C.push({icon:"sap-icon://BusinessSuiteInAppSymbols/"+e,key:"sap-icon://BusinessSuiteInAppSymbols/"+e,text:t,additionalText:"sap-icon://BusinessSuiteInAppSymbols/"+e,tooltip:t,enabled:true,type:"BusinessSuiteInAppSymbols"})})})};T.prototype._initIconModel=function(){var e=[{icon:"",text:S.getText("EDITOR_ICON_NONE"),tooltip:"",key:p.SRC_FOR_HIDDEN_ICON,enabled:true,type:"Action"},{icon:"sap-icon://upload",text:S.getText("EDITOR_ICON_CHOOSE"),tooltip:"",key:"file",enabled:true,type:"Action"},{icon:"sap-icon://download",text:S.getText("EDITOR_ICON_SELECTED"),tooltip:"",key:"selected",enabled:false,type:"Action"}];this._oIconModel=new i(e);this._oIconModel.setSizeLimit(e.length)};T.prototype._initConfigModel=function(){var e={icons:{layout:"Grid",types:{Action:true,UI5:true,"SAP-icons-TNT":true,BusinessSuiteInAppSymbols:true}}};this._oConfigModel=new i(e)};T.prototype.onInit=function(){if(S&&S.sLocale!==a.getConfiguration().getLanguage()){S=a.getLibraryResourceBundle("sap.ui.integration")}if(!this._oIconModel){this._initIconModel()}if(!C){this._initDefaultIcons()}if(m){m.then(function(){if(this.getAllowDefaultIcons()){var e=this._oIconModel.getData();e=e.concat(r(C,500));this._oIconModel.setData(e);this._oIconModel.setSizeLimit(e.length);this._oIconModel.checkUpdate(true);this._oControl&&this._oControl.setSelectedKey(this.getValue())}m=undefined}.bind(this))}else if(this.getAllowDefaultIcons()){var e=this._oIconModel.getData();e=e.concat(r(C,500));this._oIconModel.setData(e);this._oIconModel.setSizeLimit(e.length)}if(!this._oConfigModel){this._initConfigModel()}var i=new o({icon:"{iconlist>icon}",text:"{iconlist>text}",tooltip:"{iconlist>tooltip}",key:"{iconlist>key}",additionalText:"{iconlist>additionalText}",enabled:{parts:["config>/icons/types","iconlist>type","iconlist>enabled"],formatter:function(e,t,o){return o&&e[t]}}});this._oFileUpload=document.createElement("INPUT");this._oFileUpload.type="file";this._oFileUpload.accept=".png,.jpg,.jpeg,.svg";this._boundFileUploadChange=this._fileUploadChange.bind(this);this._oFileUpload.addEventListener("change",this._boundFileUploadChange);this._oControl=new t({width:"100%",items:{path:"iconlist>/",template:i},change:function(e){var t=e.getSource(),o=e.getSource().getSelectedKey();if(o==="file"){t._customImage=null;this._oFileUpload.click();this._boundFocusBack=this._focusBack.bind(this);t.getDomRef("hiddenSelect").addEventListener("focus",this._boundFocusBack)}else{this.setValue(o)}}.bind(this)});this._oControl.setModel(this._oIconModel,"iconlist");this._oControl.setModel(this._oConfigModel,"config");this._oControl._fnOpen=this._oControl.open;if(this.getAllowDefaultIcons()){var n=this;this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);n._oPicker=this.getPicker();var e=false;if(!n._oPicker.getFooter()&&e){var t=new h({content:[new I({selectedKey:"{config>/icons/layout}",items:[new y({icon:"sap-icon://grid",tooltip:"Grid View",key:"Grid"}),new y({icon:"sap-icon://list",tooltip:"Details View",key:"Details"})],select:function(e){var t=e.getSource();var o=t.getSelectedKey();if(o==="Grid"){this._oPicker.addStyleClass("sapUiIntegrationIconSelectList");this._oControl.setShowSecondaryValues(false)}else if(o==="Details"){this._oPicker.removeStyleClass("sapUiIntegrationIconSelectList");this._oControl.setShowSecondaryValues(true)}}.bind(n)}),new f,new g({text:"Icon Types:"}),new _({selected:"{config>/icons/types/UI5}",text:"UI5",select:n.onIconTypeChanged.bind(n)}),new _({selected:"{config>/icons/types/SAP-icons-TNT}",text:"Fiori",select:n.onIconTypeChanged.bind(n)}),new _({selected:"{config>/icons/types/BusinessSuiteInAppSymbols}",text:"Business Suite",select:n.onIconTypeChanged.bind(n)})]});n._oPicker.setFooter(t)}if(!c(n._oConfigModel.getProperty("/icons/types"),{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){n._oPicker.addStyleClass("sapUiIntegrationIconSelectList");n._oPicker.setContentHeight("400px")}}}this._oControl.addDelegate({onAfterRendering:this.onAfterRenderingSelect.bind(this)});this._oControl.addDelegate({onsappageup:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();this._oControl.setSelectedIndex(e-50)}}.bind(this),onsappagedown:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();if(e<3){this._oControl.setSelectedIndex(29)}else{this._oControl.setSelectedIndex(e+50)}}}.bind(this),onsapup:function(){if(this._oControl.isOpen()){var e=this.getAllowFile();var t=this.getAllowNone();var o=this._oIconModel.getProperty("/2/enabled");var i=this._oControl.getSelectedIndex();if(i>11+2){this._oControl.setSelectedIndex(i-11)}else if(i>=3){if(t&&!e){this._oControl.setSelectedIndex(0)}else if(o){this._oControl.setSelectedIndex(2)}else{this._oControl.setSelectedIndex(3)}}}}.bind(this),onsapdown:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();if(e>1){this._oControl.setSelectedIndex(e+11)}}}.bind(this),onsapleft:function(){if(this._oControl.isOpen()){this._oControl.onsapup.apply(this._oControl,arguments)}}.bind(this),onsapright:function(){if(this._oControl.isOpen()){this._oControl.onsapdown.apply(this._oControl,arguments)}}.bind(this)},true)};T.prototype.applyStyle=function(e){e.class("sapUiIntegrationIconSelect");if(this._oControl&&this._oControl.getWidth){e.style("width",this._oControl.getWidth())}};T.prototype.onIconTypeChanged=function(e){this._oConfigModel.checkUpdate(true);var t=this._oConfigModel.getProperty("/icons/types");if(c(t,{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){this._oPicker.setContentHeight("")}else{this._oPicker.setContentHeight("400px")}var o=this.getValue();if(o&&o.indexOf("data:image/")===0){this._oControl._customImage=o;this._oIconModel.setProperty("/2/enabled",true);this._oControl.setSelectedKey("selected")}else{this._oControl.setSelectedKey(o)}};T.prototype._fileUploadChange=function(){var e=new window.FileReader;e.onload=function(){this.setValue(e.result);this._oControl.invalidate()}.bind(this);if(this._oFileUpload.files.length===1){e.readAsDataURL(this._oFileUpload.files[0])}};T.prototype._focusBack=function(){this._oControl.getDomRef("hiddenSelect").removeEventListener("focus",this._boundFocusBack);setTimeout(function(){this.setValue(this.getValue())}.bind(this),150)};T.prototype.bindPropertyToControl=function(e,t){if(e==="editable"){var o=l({},t);this._oControl.bindProperty("editable",o)}};T.prototype.setValue=function(e){this.setProperty("value",e,true);if(e&&e.indexOf("data:image/")===0){this._oControl._customImage=e;this._oIconModel.setProperty("/2/enabled",true);this._oControl.setSelectedKey("selected")}else{this._oControl._customImage=null;this._oIconModel.setProperty("/2/enabled",false);this._oControl.setSelectedKey(e)}this._oControl.invalidate();return this};T.prototype.setAllowFile=function(e){this.setProperty("allowFile",e,true);e=this.getAllowFile();this._oIconModel.setProperty("/1/enabled",e);return this};T.prototype.setAllowNone=function(e){this.setProperty("allowNone",e,true);e=this.getAllowNone();this._oIconModel.setProperty("/0/enabled",e);return this};T.prototype.onAfterRenderingSelect=function(){var e=this._oControl.getDomRef("labelIcon");if(e){var t=this._oControl._customImage;var o=a.byId(e.id);if(t){e.style.backgroundImage="url('"+t+"')";e.classList.add("sapMSelectListItemIconCustom");e.children[0].title=S.getText("EDITOR_IMAGE_CUSTOMICON_TOOLTIP");o.onclick=function(e){e.stopImmediatePropagation();o._oImagePopover=new d(o.getId()+"-imagePopover",{placement:"Right",showHeader:false,content:new u(o.getId()+"-imagePopover-image",{src:t}).addStyleClass("image")}).addStyleClass("sapUiIntegrationImageSelect");o._oImagePopover.openBy(o)}}else{e.style.backgroundImage="unset";e.classList.remove("sapMSelectListItemIconCustom");o.onclick=undefined}}};T.prototype.setAllowDefaultIcons=function(e){if(typeof e==="boolean"&&this.getAllowDefaultIcons()!==e){var t=this._oIconModel.getData();if(e){t=t.concat(r(C,500));var o=this._oConfigModel.getProperty("/icons/types");this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);if(!c(o,{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){this._oPicker.addStyleClass("sapUiIntegrationIconSelectList");this._oPicker.setContentHeight("400px")}}}else{t=t.slice(0,3);this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);this.getPicker().removeStyleClass("sapUiIntegrationIconSelectList")}}this._oIconModel.setData(t);this._oIconModel.setSizeLimit(t.length)}};return T});
//# sourceMappingURL=IconSelect.js.map