/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/model/json/JSONModel"],function(e,t,r,o){"use strict";var n=/\{\{csrfTokens.([^\}]+)/;var i="X-CSRF-Token";var s=e.extend("sap.ui.integration.util.CsrfTokenHandler",{metadata:{library:"sap.ui.integration"},constructor:function(t){e.call(this);t=t||{};this._oHost=t.host;this._oConfiguration=t.configuration}});s._mTokens=new Map;s.prototype.resolveToken=function(e){var t,o;e=r({},e);t=this._findCsrfPlaceholder(e);if(!t){return Promise.resolve(e)}o=this._getCsrfConfig(t.tokenName);if(this._oHost){return this._oHost.getCsrfToken(o).then(function(r){if(!r){return this._resolveTokenByUrl(e,t)}this._replaceCsrfPlaceholder(t,r);return e}.bind(this)).catch(function(e){return Promise.reject(e)})}return this._resolveTokenByUrl(e,t)};s.prototype._resolveTokenByUrl=function(e,t){var r=t.tokenName,o=this._getCsrfConfig(r).data.request.url;if(s._mTokens.has(o)){return s._mTokens.get(o).then(function(r){this._replaceCsrfPlaceholder(t,r);return e}.bind(this))}if(r){return this._requestToken(e,t)}return Promise.resolve(e)};s.prototype.setDataProviderFactory=function(e){this._oDataProviderFactory=e};s.prototype.setHost=function(e){this._oHost=e};s.prototype.isExpiredToken=function(e){if(!e){return false}var t=e.headers.get(i);return t&&t.toLowerCase()==="required"&&e.status===403};s.prototype._requestToken=function(e,t){var r=t.tokenName,n=this._getCsrfConfig(r);if(!r||!n){return Promise.reject("CSRF definition is incorrect")}var s=new Promise(function(e,t){var r=this._oDataProviderFactory.create(n.data);r.getData().then(function(t){var s,a;if(n.data.path){a=new o(t);s=a.getProperty(n.data.path);a.destroy()}else{s=r.getLastResponse().headers.get(i)}e(s)}).catch(function(){t("CSRF token cannot be resolved")})}.bind(this));this._registerToken(n,s);return s.then(function(r){this._replaceCsrfPlaceholder(t,r);return e}.bind(this))};s.prototype.resetTokenByRequest=function(e){var t=this._findCsrfPlaceholder(e);if(!t){return}this._deleteRegisteredToken(this._getCsrfConfig(t.tokenName))};s.prototype._getCsrfConfig=function(e){return this._oConfiguration[e]};s.prototype._replaceCsrfPlaceholder=function(e,t){var r=e.object[e.key];e.object[e.key]=r.replace("{{csrfTokens."+e.tokenName+"}}",t)};s.prototype._findCsrfPlaceholder=function(e){var r,o,n;for(o in e){r=e[o];if(typeof r==="string"){n=this._getCsrfTokenName(r);if(n){return{object:e,key:o,tokenName:n}}}if(t(r)){r=this._findCsrfPlaceholder(r);if(r){return r}}}return null};s.prototype._getCsrfTokenName=function(e){var t=e.match(n);if(!t){return""}return t[1]};s.prototype._registerToken=function(e,t){s._mTokens.set(e.data.request.url,t);if(this._oHost){this._oHost.csrfTokenFetched(e,t)}};s.prototype._deleteRegisteredToken=function(e){s._mTokens.delete(e.data.request.url);if(this._oHost){this._oHost.csrfTokenExpired(e)}};return s});
//# sourceMappingURL=CsrfTokenHandler.js.map