/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./library","./PaneContainer","./ResponsiveSplitterPage","./ResponsiveSplitterRenderer","./ResponsiveSplitterUtilities","./SplitPane","./Splitter","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/RenderManager"],function(t,e,i,n,a,s,o,r,l,p,g,u){"use strict";var h=l.extend("sap.ui.layout.ResponsiveSplitter",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"}},defaultAggregation:"rootPaneContainer",aggregations:{rootPaneContainer:{type:"sap.ui.layout.PaneContainer",multiple:false},_pages:{type:"sap.ui.layout.ResponsiveSplitterPage",multiple:true,visibility:"hidden"}},associations:{defaultPane:{type:"sap.ui.layout.SplitPane",multiple:false}},events:{}},renderer:n});var d={MAX_VISIBLE_BUTTONS:7};h.prototype.init=function(){this._aPaneContainers=[];this._aPanes=[];this._oResourceBundle=r.getLibraryResourceBundle("sap.ui.layout");this._oItemNavigation=new p;this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._iDefaultPageIndex=0};h.prototype.onBeforeRendering=function(){var t=this.getRootPaneContainer();if(t){this._oSplitterDelegate=this._oSplitterDelegate||{onAfterRendering:function(){this._setSplitterBarsTooltips(t._oSplitter);this._updatePaginatorButtonsTooltips()}};t._oSplitter.addEventDelegate(this._oSplitterDelegate,this);this._createWidthIntervals();this._createPages();this._detachResizeHandler()}};h.prototype.onAfterRendering=function(){this._parentResizeHandler=g.register(this,this._onParentResize.bind(this));var t=this.getRootPaneContainer();if(t){this._onParentResize();this._updatePaginatorButtonsTooltips()}this._setItemNavigation()};h.prototype.exit=function(){this._detachResizeHandler();this._clearItemNavigation();this._oSplitterDelegate=null};h.prototype._setSplitterBarsTooltips=function(t,e){var i=t.$().find(" > .sapUiLoSplitterBar"),n=t.$().find(" > .sapUiLoSplitterContent"),a="",s,l,p,g;for(var u=0;u<n.length;u++){g=n[u].childNodes[0].id;p=r.byId(g);s=u+1;l=u+2;if(e){a+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[e+"."+s,e+"."+l])}else{a+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[s,l])}if(i[u]){i[u].setAttribute("title",a);a=""}if(p instanceof o){this._setSplitterBarsTooltips(p,s)}}};h.prototype._updatePaginatorButtonsTooltips=function(){var t=Array.prototype.slice.call(this._getVisibleButtons()),e=this.getRootPaneContainer()._oSplitter.getAssociatedContentAreas().length,i=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_HOME")+" ",n=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_AND"),a="",s=this,o;if(t.length>0){o=t.shift();for(var r=1;r<=e;r++){i+=r;if(r<e-1){i+=", "}else if(r===e-1){i+=" "+n+" "}}o.setAttribute("title",i);[].forEach.call(t,function(t){a=s._oResourceBundle.getText("RESPONSIVE_SPLITTER_GOTO")+" "+(e+1);e+=1;t.setAttribute("title",a)})}};h.prototype.onsapright=function(t){this._handleArrowNavigation(6,"Forward",t)};h.prototype.onsapleft=function(t){this._handleArrowNavigation(0,"Back",t)};h.prototype._setItemNavigation=function(){var t=this._getVisibleButtons(),e=[];this._oItemNavigation.setRootDomRef(this.$().find(".sapUiResponsiveSplitterPaginator")[0]);for(var i=0;i<t.length;i++){if(t[i]){e.push(t[i])}}this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setFocusedIndex(this._iDefaultPageIndex)};h.prototype._clearItemNavigation=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation};h.prototype._handleArrowNavigation=function(t,e,i){if(i.target===this._getVisibleButtons()[t]){this["_handlePaginator"+e](i);this._setItemNavigation()}else{return}};h.prototype._onParentResize=function(){var t=this._intervalHasChanged(),e=this.getRootPaneContainer();if(t&&e){this._arrangeContent();this._setPaginatorVisibility()}};h.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){g.deregister(this._parentResizeHandler);this._parentResizeHandler=null}};h.prototype._createWidthIntervals=function(){var t=[];this._aIntervals=[];a.visitPanes(this.getRootPaneContainer(),function(e){var i=e.getRequiredParentWidth();if(t.indexOf(i)==-1){t.push(i)}});t.push(Number.NEGATIVE_INFINITY);t.push(Number.POSITIVE_INFINITY);t.sort(function(t,e){return t-e});for(var e=0;e<t.length-1;e++){var i=new a.splitterInterval(t[e],t[e+1],this.getRootPaneContainer());this._aIntervals.push(i)}};h.prototype._createPages=function(){var t=this._getMaxPageCount(),e=this.getAggregation("_pages")||[],n=e.length;if(n<t){while(n<t){n++;var a=new i;this.addAggregation("_pages",a,true)}}else if(n>t){while(n>t){n--;if(e[n].getDomRef()){u.preserveContent(e[n].getDomRef())}e[n].destroy()}}};h.prototype._intervalHasChanged=function(){var t=this.getDomRef().clientWidth,e=null,i=this._aIntervals;for(var n=0;n<i.length;n++){if(i[n].iFrom<t&&t<=i[n].iTo){e=i[n];break}}if(this._currentInterval!==e){this._currentInterval=e;return true}return false};h.prototype._setPaginatorVisibility=function(){var t=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),e=this.$().find(".sapUiResponsiveSplitterPaginatorNavButton"),i=this.$().find(".sapUiResponsiveSplitterPaginator"),n=this._getHiddenPanes().length+1,a=this._getMaxPageCount(),s=n<d.MAX_VISIBLE_BUTTONS;t.addClass("sapUiResponsiveSplitterHiddenElement");if(a>1&&n>1){this.addStyleClass("sapUiRSVisiblePaginator");t=t.slice(0,s?n:d.MAX_VISIBLE_BUTTONS);t.removeClass("sapUiResponsiveSplitterHiddenElement");t.removeClass("sapUiResponsiveSplitterHiddenPaginatorButton");e.toggleClass("sapUiResponsiveSplitterHiddenPaginatorButton",s);i.toggleClass("sapUiResponsiveSplitterWithNavButtons",!s)}else{this.removeStyleClass("sapUiRSVisiblePaginator")}};h.prototype._getMaxPageCount=function(){var t=0;this._aIntervals.forEach(function(e){if(e.iPagesCount>t){t=e.iPagesCount}});return t};h.prototype._arrangeContent=function(){var t=this.getAggregation("_pages")||[],e=0,i=r.byId(this.getDefaultPane()),n,a,s;this._clearContent();t.forEach(function(t){t.setVisible(false)});this._fillPageContent(this.getRootPaneContainer());if(i){n=i.getContent();if(n){a=n.getId();for(s=0;s<t.length;s++){if(t[s].containsControl(a)){e=s;break}}}}this._iDefaultPageIndex=e;this._activatePage(e)};h.prototype._activatePage=function(t){var e=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),i=this.$().find(".sapUiResponsiveSplitterPaginatorSelectedButton"),n=e.index(i),a=this.getAggregation("_pages")||[];a[n]&&a[n].setVisible(false);a[t]&&a[t].setVisible(true);i.removeClass("sapUiResponsiveSplitterPaginatorSelectedButton");e.eq(t).addClass("sapUiResponsiveSplitterPaginatorSelectedButton");i.attr("aria-selected",false);e.eq(t).attr("aria-selected",true)};h.prototype._fillPageContent=function(t){var i=t instanceof e,n=t instanceof s,a=t.getParent(),o=a instanceof e,r=this.getAggregation("_pages"),l,p,g,u,h,d;if(i&&r){this._aPaneContainers.push(t);p=this._getAllPanesInInterval(t,this._currentInterval.iFrom).length>0;g=t._oSplitter;if(o&&p){a._oSplitter.addAssociatedContentArea(g)}else if(!o){r[0].setContent(g)}t.getPanes().forEach(function(t){this._fillPageContent(t)},this)}else if(n&&r){this._assignDefault(t);this._aPanes.push(t);u=t.getDemandPane();l=this._getHiddenPanes();h=l.length;d=this._getMaxPageCount();var f;if(t._isInInterval(this._currentInterval.iFrom)){a._oSplitter.addAssociatedContentArea(t.getContent())}else if(u&&h<d){for(f=0;f<h;f++){r[f+1].setContent(l[f].getContent())}}else if(u&&h===d){for(f=0;f<h;f++){r[f].setContent(l[f].getContent())}}else if(this._isDefault(t)){r[0].setContent(t.getContent())}}};h.prototype._isDefault=function(t){return this.getDefaultPane()===t.getId()};h.prototype._assignDefault=function(t){var e=this.getDefaultPane();this.setDefaultPane(e||t)};h.prototype._getAllPanesInInterval=function(t,i){var n=[];function a(t){t.getPanes().forEach(function(t){if(t instanceof e){a(t)}else if(t._isInInterval(i)){n.push(t)}});return n}return a(t,i)};h.prototype._getHiddenPanes=function(){return this._aPanes.filter(function(t){return t.getDemandPane()&&!t._isInInterval(this._currentInterval.iFrom)},this)};h.prototype._clearContent=function(){this._aPaneContainers.forEach(function(t){t._oSplitter.removeAllAssociatedContentAreas()});this._aPaneContainers=[];this._aPanes=[]};h.prototype._getVisibleButtons=function(){return this.$().find(".sapUiResponsiveSplitterPaginatorButton:not(.sapUiResponsiveSplitterHiddenElement, .sapUiResponsiveSplitterHiddenPaginatorButton)")};h.prototype._handlePaginatorButtonTap=function(t){var e=t.target,i=t.target.classList,n;if(i&&i.contains("sapUiResponsiveSplitterPaginatorButton")){n=parseInt(e.getAttribute("page-index"));this._activatePage(n)}else if(i&&i.contains("sapUiResponsiveSplitterPaginatorNavButton")){if(i.contains("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(t)}else{this._handlePaginatorBack(t)}}};h.prototype._handlePaginatorForward=function(t){var e=this._getVisibleButtons(),i=this._getHiddenPanes().length,n=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),a,s=n.filter(function(){a=parseInt(this.getAttribute("page-index"));return a>=d.MAX_VISIBLE_BUTTONS&&a<=i});if(s.length>0){e.first().addClass("sapUiResponsiveSplitterHiddenElement");s.last().removeClass("sapUiResponsiveSplitterHiddenElement")}};h.prototype._handlePaginatorBack=function(t){var e=this._getVisibleButtons(),i=this._getMaxPageCount()-d.MAX_VISIBLE_BUTTONS,n=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),a=n.filter(function(){return parseInt(this.getAttribute("page-index"))<i});if(a.length>0){e.last().addClass("sapUiResponsiveSplitterHiddenElement");a.last().removeClass("sapUiResponsiveSplitterHiddenElement")}};h.prototype.ontap=h.prototype._handlePaginatorButtonTap;h.prototype.onsapenter=h.prototype._handlePaginatorButtonTap;h.prototype.onsapspace=h.prototype._handlePaginatorButtonTap;return h});
//# sourceMappingURL=ResponsiveSplitter.js.map