/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/ui/model/FilterOperator","sap/ui/model/Filter","sap/ui/model/ValidateException","sap/base/Log","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","./Operator","./RangeOperator","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/loadModules","sap/ui/core/date/UniversalDate","sap/ui/core/date/UniversalDateUtils","sap/ui/core/format/DateFormat","sap/ui/core/StaticArea","sap/ui/model/json/JSONModel","sap/ui/model/type/Integer"],function(e,t,a,r,n,s,o,l,i,u,p,m,c,f,O,y,T,g){"use strict";let d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")});const h={_mOperators:{equal:new o({name:s.EQ,alias:{Date:"DATE",DateTime:"DATETIME"},filterOperator:e.EQ,tokenParse:"^=([^=].*)$",tokenFormat:"{1} ({0})",valueTypes:[p.Self,null],displayFormats:{DescriptionValue:"{1} ({0})",ValueDescription:"{0} ({1})",Description:"{1}",Value:"{0}"},format:function(e,t,a,r,s,o,l){a=a||n.DescriptionValue;let i=this.valueTypes.length;const p=e.values;const m=e&&e.validated===u.Validated||p.length===2||r?"":"=";let c=m+this.displayFormats[a];if(!p[1]){c=m+this.displayFormats["Value"];i=1}for(let e=0;e<i;e++){let a,r=p[e];if(r===null||r===undefined){r=""}if(e===0){a=this._formatValue(r,t,s)}else{a=this._formatValue(r,o,l)}if(a===null){c=null;break}if(typeof a==="string"){a=a.replace(/\$/g,"$$$")}c=c.replace(new RegExp("\\$"+e+"|"+e+"\\$"+"|"+"\\{"+e+"\\}","g"),a)}return c},parse:function(e,t,a,r,s,l,i){a=a||n.DescriptionValue;let u=o.prototype.parse.apply(this,[e,t,a,r,s,l,i]);if(r&&(!u||u[0]===null||u[0]===undefined)&&a!==n.Value){a=n.Value;u=o.prototype.parse.apply(this,[e,t,a,r,s,l,i])}if(u&&(u[1]===null||u[1]===undefined)&&a===n.Value){u=[u[0]]}return u},getValues:function(e,t,a){const r=e.match(this.tokenParseRegExp);let n;if(r||a&&e){let s;const o=this.displayFormats[t];const l=o.indexOf("{0}");const i=o.indexOf("{1}");let u;let p;if(r){s=r[1]}else if(a){s=e}if(l>=0&&i>=0){if(s.lastIndexOf("(")>0&&(s.lastIndexOf(")")===s.length-1||s.lastIndexOf(")")===-1)){let e=s.length;if(s[e-1]===")"){e--}let t=s.substring(0,s.lastIndexOf("("));if(t[t.length-1]===" "){t=t.substring(0,t.length-1)}const a=s.substring(s.lastIndexOf("(")+1,e);if(l<i){u=t;p=a}else{u=a;p=t}}else if(l<i){u=s}else{p=s}}else if(l>=0){u=s}else{p=s}n=[u];if(i>=0){n.push(p)}}return n},isEmpty:function(e,t){let a=false;const r=e.values[0];if((r===null||r===undefined||r==="")&&!e.values[1]){a=true}return a},getCheckValue:function(e){return{value:e.values[0]}},checkValidated:function(e){if(e.values.length===2&&e.values[0]!==undefined&&e.values[1]!==null&&e.values[1]!==undefined){e.validated=u.Validated}else{e.validated=u.NotValidated}},validateInput:true}),between:new o({name:s.BT,alias:{Date:"DATERANGE",DateTime:"DATETIMERANGE"},filterOperator:e.BT,tokenParse:"^([^!].*)\\.\\.\\.(.+)$",tokenFormat:"{0}...{1}",valueTypes:[p.Self,p.Self],validate:function(e,t){if(e.length===2){if(E(e[0])&&E(e[1])){return}else if(E(e[0])||E(e[1])){throw new a(d.getText("operator.between.validate.missingValue"))}else if(e[0]===e[1]){throw new a(d.getText("operator.between.validate.sameValues"))}}o.prototype.validate.apply(this,[e,t])}}),notBetween:new o({name:s.NOTBT,filterOperator:e.NB,tokenParse:"^!(.+)\\.\\.\\.(.+)$",tokenFormat:"!({0}...{1})",valueTypes:[p.Self,p.Self],exclude:true,validate:function(e,t){h._mOperators.between.validate(e,t)}}),lessThan:new o({name:s.LT,filterOperator:e.LT,tokenParse:"^<([^=].*)$",tokenFormat:"<{0}",valueTypes:[p.Self]}),notLessThan:new o({name:s.NOTLT,filterOperator:e.GE,tokenParse:"^!<([^=].*)$",tokenFormat:"!(<{0})",valueTypes:[p.Self],exclude:true}),greaterThan:new o({name:s.GT,filterOperator:e.GT,tokenParse:"^>([^=].*)$",tokenFormat:">{0}",valueTypes:[p.Self]}),notGreaterThan:new o({name:s.NOTGT,filterOperator:e.LE,tokenParse:"^!>([^=].*)$",tokenFormat:"!(>{0})",valueTypes:[p.Self],exclude:true}),lessEqual:new o({name:s.LE,alias:{Date:"TO",DateTime:"TODATETIME"},filterOperator:e.LE,tokenParse:"^<=(.+)$",tokenFormat:"<={0}",valueTypes:[p.Self]}),notLessEqual:new o({name:s.NOTLE,filterOperator:e.GT,tokenParse:"^!<=(.+)$",tokenFormat:"!(<={0})",valueTypes:[p.Self],exclude:true}),greaterEqual:new o({name:s.GE,alias:{Date:"FROM",DateTime:"FROMDATETIME"},filterOperator:e.GE,tokenParse:"^>=(.+)$",tokenFormat:">={0}",valueTypes:[p.Self]}),notGreaterEqual:new o({name:s.NOTGE,filterOperator:e.LT,tokenParse:"^!>=(.+)$",tokenFormat:"!(>={0})",valueTypes:[p.Self],exclude:true}),startsWith:new o({name:s.StartsWith,filterOperator:e.StartsWith,tokenParse:"^([^!\\*]+.*)\\*$",tokenFormat:"{0}*",valueTypes:[p.SelfNoParse]}),notStartsWith:new o({name:s.NotStartsWith,filterOperator:e.NotStartsWith,tokenParse:"^!([^\\*].*)\\*$",tokenFormat:"!({0}*)",valueTypes:[p.SelfNoParse],exclude:true}),endsWith:new o({name:s.EndsWith,filterOperator:e.EndsWith,tokenParse:"^\\*(.*[^\\*])$",tokenFormat:"*{0}",valueTypes:[p.SelfNoParse]}),notEndsWith:new o({name:s.NotEndsWith,filterOperator:e.NotEndsWith,tokenParse:"^!\\*(.*[^\\*])$",tokenFormat:"!(*{0})",valueTypes:[p.SelfNoParse],exclude:true}),contains:new o({name:s.Contains,filterOperator:e.Contains,tokenParse:"^\\*(.*)\\*$",tokenFormat:"*{0}*",valueTypes:[p.SelfNoParse]}),notContains:new o({name:s.NotContains,filterOperator:e.NotContains,tokenParse:"^!\\*(.*)\\*$",tokenFormat:"!(*{0}*)",valueTypes:[p.SelfNoParse],exclude:true}),notEqual:new o({name:s.NE,filterOperator:e.NE,tokenParse:"^!=(.+)$",tokenFormat:"!(={0})",valueTypes:[p.Self],exclude:true}),empty:new o({name:s.Empty,filterOperator:e.EQ,tokenParse:"^<#tokenText#>$",tokenFormat:"<#tokenText#>",valueTypes:[],getModelFilter:function(a,r,n,s,o){let l=false;if(n){const e=n.parseValue("","string");try{n.validateValue(e);l=e===null}catch(e){l=false}}if(l){return new t({filters:[new t({path:r,operator:e.EQ,value1:""}),new t({path:r,operator:e.EQ,value1:null})],and:false})}else{return new t({path:r,operator:this.filterOperator,value1:""})}}}),notEmpty:new o({name:s.NotEmpty,filterOperator:e.NE,tokenParse:"^!<#tokenText#>$",tokenFormat:"!(<#tokenText#>)",valueTypes:[],exclude:true,getModelFilter:function(a,r,n,s,o){let l=false;if(n){const e=n.parseValue("","string");try{n.validateValue(e);l=e===null}catch(e){l=false}}if(l){return new t({filters:[new t({path:r,operator:e.NE,value1:""}),new t({path:r,operator:e.NE,value1:null})],and:true})}else{return new t({path:r,operator:this.filterOperator,value1:""})}}}),yesterday:new l({name:s.YESTERDAY,valueTypes:[p.Static],calcRange:function(){return f.ranges.yesterday()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),today:new l({name:s.TODAY,valueTypes:[p.Static],calcRange:function(){return f.ranges.today()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),tomorrow:new l({name:s.TOMORROW,valueTypes:[p.Static],calcRange:function(){return f.ranges.tomorrow()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDays:new l({name:s.LASTDAYS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastDays(e)}}),firstDayWeek:new l({name:s.FIRSTDAYWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.firstDayOfWeek()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayWeek:new l({name:s.LASTDAYWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastDayOfWeek()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayMonth:new l({name:s.FIRSTDAYMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.firstDayOfMonth()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayMonth:new l({name:s.LASTDAYMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastDayOfMonth()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayQuarter:new l({name:s.FIRSTDAYQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.firstDayOfQuarter()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayQuarter:new l({name:s.LASTDAYQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastDayOfQuarter()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayYear:new l({name:s.FIRSTDAYYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.firstDayOfYear()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayYear:new l({name:s.LASTDAYYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastDayOfYear()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),todayFromTo:new l({name:s.TODAYFROMTO,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}},{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["([-+]?\\d+)","([-+]?\\d+)"],additionalInfo:"",calcRange:function(e,t){let a=e>=0?f.ranges.lastDays(e)[0]:f.ranges.nextDays(-e)[1];let r=t>=0?f.ranges.nextDays(t)[1]:f.ranges.lastDays(-t)[0];if(a.oDate.getTime()>r.oDate.getTime()){r=[a,a=r][0]}return[f.resetStartTime(a),f.resetEndTime(r)]}}),nextDays:new l({name:s.NEXTDAYS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextDays(e)}}),lastWeek:new l({name:s.LASTWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastWeek()}}),thisWeek:new l({name:s.THISWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.currentWeek()}}),nextWeek:new l({name:s.NEXTWEEK,valueTypes:[p.Static],calcRange:function(){return f.ranges.nextWeek()}}),lastWeeks:new l({name:s.LASTWEEKS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastWeeks(e)}}),nextWeeks:new l({name:s.NEXTWEEKS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextWeeks(e)}}),lastMonth:new l({name:s.LASTMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastMonth()}}),thisMonth:new l({name:s.THISMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.currentMonth()}}),nextMonth:new l({name:s.NEXTMONTH,valueTypes:[p.Static],calcRange:function(){return f.ranges.nextMonth()}}),lastMonths:new l({name:s.LASTMONTHS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastMonths(e)}}),nextMonths:new l({name:s.NEXTMONTHS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextMonths(e)}}),lastQuarter:new l({name:s.LASTQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastQuarter()}}),thisQuarter:new l({name:s.THISQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.currentQuarter()}}),nextQuarter:new l({name:s.NEXTQUARTER,valueTypes:[p.Static],calcRange:function(){return f.ranges.nextQuarter()}}),lastQuarters:new l({name:s.LASTQUARTERS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastQuarters(e)}}),nextQuarters:new l({name:s.NEXTQUARTERS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextQuarters(e)}}),quarter1:new l({name:s.QUARTER1,valueTypes:[p.Static],calcRange:function(){return f.ranges.quarter(1)}}),quarter2:new l({name:s.QUARTER2,valueTypes:[p.Static],calcRange:function(){return f.ranges.quarter(2)}}),quarter3:new l({name:s.QUARTER3,valueTypes:[p.Static],calcRange:function(){return f.ranges.quarter(3)}}),quarter4:new l({name:s.QUARTER4,valueTypes:[p.Static],calcRange:function(){return f.ranges.quarter(4)}}),lastYear:new l({name:s.LASTYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.lastYear()}}),thisYear:new l({name:s.THISYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.currentYear()}}),nextYear:new l({name:s.NEXTYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.nextYear()}}),lastYears:new l({name:s.LASTYEARS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastYears(e)}}),nextYears:new l({name:s.NEXTYEARS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextYears(e)}}),specificMonth:new l({name:s.SPECIFICMONTH,valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}}],paramTypes:["(.+)"],additionalInfo:"",label:[d.getText("operators.SPECIFICMONTH_MONTH.label")],defaultValues:function(){const e=new c;return[e.getMonth()]},calcRange:function(e){let t=new c;t.setMonth(e);t=f.getMonthStartDate(t);return f.getRange(0,"MONTH",t)},format:function(e,t,a,r,n,s,o){const l=e.values[0];const i=this.tokenFormat;const u=v.apply(this)[l];if(r){return u}else{return u==null?null:i.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),u)}},getValues:function(e,t,a){const r=e.match(this.tokenParseRegExp);let n;if(r||a&&e){n=[];for(let t=0;t<this.valueTypes.length;t++){let s;if(r){s=r[t+1]}else if(a&&e){s=e}n.push(s)}return[w.call(this,n[0])]}return null},createControl:function(e,t,a,n){const s=sap.ui.require("sap/ui/mdc/Field");const o=D.call(this);if(s&&o){const a=new s(n,{value:{path:t,type:e,mode:"TwoWay",targetType:"raw"},display:"Description",width:"100%",valueHelp:o});return a}else{r.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null}}}),specificMonthInYear:new l({name:s.SPECIFICMONTHINYEAR,valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}},{name:"sap.ui.model.type.Integer",constraints:{minimum:1,maximum:9999}}],paramTypes:["(.+)","(.+)"],additionalInfo:"",label:[d.getText("operators.SPECIFICMONTHINYEAR_MONTH.label"),d.getText("operators.SPECIFICMONTHINYEAR_YEAR.label")],defaultValues:function(){const e=new c;return[e.getMonth(),e.getFullYear()]},calcRange:function(e,t){let a=new c;a.setMonth(e);a.setYear(t);a=f.getMonthStartDate(a);return f.getRange(0,"MONTH",a)},format:function(e,t,a,r,n,s,o){const l=e.values[0];const i=e.values[1];let u=this.tokenFormat;const p=v.apply(this)[l];if(r){return p+","+i}else{const e=new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g");const t=new RegExp("\\$"+1+"|"+1+"\\$"+"|"+"\\{"+1+"\\}","g");u=p==null?null:u.replace(e,p);return u.replace(t,i)}},getValues:function(e,t,a){const r=e.match(this.tokenParseRegExp);let n;if(r||a&&e){n=[];for(let t=0;t<this.valueTypes.length;t++){let s;if(r){s=r[t+1]}else if(a&&e){s=e}n.push(s)}return[w.call(this,n[0]),n[1]]}return null},createControl:function(e,t,a,n){let s;const o=sap.ui.require("sap/ui/mdc/Field");if(!o){r.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null}if(a==0){const a=D.call(this);if(a){s=new o(n,{value:{path:t,type:e,mode:"TwoWay",targetType:"raw"},display:"Description",width:"100%",valueHelp:a})}else{r.warning("Operator.createControl","not able to create the control for the operator "+this.name)}}if(a==1){s=new o(n,{value:{path:"$this>",type:e,mode:"TwoWay",targetType:"raw"},width:"100%"})}return s}}),yearToDate:new l({name:s.YEARTODATE,valueTypes:[p.Static],calcRange:function(){return f.ranges.yearToDate()}}),dateToYear:new l({name:s.DATETOYEAR,valueTypes:[p.Static],calcRange:function(){return f.ranges.dateToYear()}}),lastMinutes:new l({name:s.LASTMINUTES,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastMinutes(e)}}),nextMinutes:new l({name:s.NEXTMINUTES,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextMinutes(e)}}),lastHours:new l({name:s.LASTHOURS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.lastHours(e)}}),nextHours:new l({name:s.NEXTHOURS,valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return f.ranges.nextHours(e)}})},_mDefaultOpsForType:{},addOperator:function(e){h._mOperators[e.name]=e},addOperators:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(function(e){h.addOperator(e)})},removeOperators:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(function(e){h.removeOperator(e)})},removeOperator:function(e){if(typeof e==="string"){delete h._mOperators[e]}else{delete h._mOperators[e.name]}},setOperatorsForType:function(e,t,a){if(!Array.isArray(t)){t=[t]}if(!h._mDefaultOpsForType[e]){h._mDefaultOpsForType[e]={}}h._mDefaultOpsForType[e].operators=[];t.forEach(function(t){h.addOperatorForType(e,t)});if(a){h.setDefaultOperatorForType(e,a)}},setDefaultOperatorForType:function(e,t){if(!h._mDefaultOpsForType[e]){h._mDefaultOpsForType[e]={}}if(typeof t==="string"){t=h.getOperator(t)}h._mDefaultOpsForType[e].defaultOperator=t},addOperatorForType:function(e,t){h.insertOperatorForType(e,t)},insertOperatorForType:function(e,t,a){if(!h._mDefaultOpsForType[e]){h._mDefaultOpsForType[e]={operators:[]}}a=a===undefined?h._mDefaultOpsForType[e].operators.length:a;if(typeof t==="string"){t=h.getOperator(t)}h._mDefaultOpsForType[e].operators.splice(a,0,t)},removeOperatorForType:function(e,t){let a;if(typeof t==="string"){a=t}else{a=t.name}for(let t=0;t<h._mDefaultOpsForType[e].operators.length;t++){if(h._mDefaultOpsForType[e].operators[t].name===a){h._mDefaultOpsForType[e].operators.splice(t,1);return}}},getOperatorsForType:function(e){const t=[];for(let a=0;a<h._mDefaultOpsForType[e].operators.length;a++){t.push(h._mDefaultOpsForType[e].operators[a].name)}return t},getDefaultOperator:function(e){return h._mDefaultOpsForType[e].defaultOperator||h._mOperators.equal},getMatchingOperators:function(e,t){const a=[];for(let t=0;t<e.length;t++){const r=this.getOperator(e[t]);if(r){a.push(r)}}return _.call(this,a,t)},getOperator:function(e){for(const t in h._mOperators){const a=h._mOperators[t];if(a.name===e){return a}}return undefined},getEQOperator:function(e){if(e){for(let t=0;t<e.length;t++){const a=this.getOperator(e[t]);if(a&&a.validateInput&&!a.exclude&&a.valueTypes[0]&&a.valueTypes[0]!==p.Static){return a}}}return h._mOperators.equal},onlyEQ:function(e){if(e.length===1&&e[0]===s.EQ){return true}else{return false}},checkConditionsEmpty:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(function(e){const t=this.getOperator(e.operator);if(t){e.isEmpty=t.isEmpty(e)}}.bind(this))},updateConditionsValues:function(e){if(!Array.isArray(e)){e=[e]}for(let t=0;t<e.length;t++){this.updateConditionValues(e[t])}},updateConditionValues:function(e){const t=this.getOperator(e.operator);if(t&&e.validated!==u.Validated){let a=t.valueTypes.length;if(t.valueTypes.length===2&&t.valueTypes[1]===null&&(e.values.length<2||e.values[1]===null||e.values[1]===undefined)){a=a-1}if(t.valueTypes[0]==="static"){e.values=[]}else{while(e.values.length!=a){if(e.values.length<a){e.values.push(null)}if(e.values.length>a){e.values=e.values.slice(0,e.values.length-1)}}}}},indexOfCondition:function(e,t){let a=-1;for(let r=0;r<t.length;r++){if(this.compareConditions(e,t[r])){a=r;break}}return a},compareConditions:function(e,t){let a=false;if(e.operator===t.operator){const r=this.getOperator(e.operator);if(r){a=r.compareConditions(e,t)}}return a},compareConditionsArray:function(e,t){let a=false;if(e.length===t.length){a=true;for(let r=0;r<e.length;r++){if(!this.compareConditions(e[r],t[r])){a=false;break}}}return a},checkConditionValidated:function(e){const t=this.getOperator(e.operator);if(!e.validated&&t&&t.checkValidated){t.checkValidated(e)}},getOperatorForDynamicDateOption:function(e,t){let a;if(t&&e.startsWith(t)){a=this.getOperator(e.slice(t.length+1))}else{a=this.getOperator(e)}if(!a&&t){for(const r in h._mOperators){const n=h._mOperators[r];if(n.alias&&n.alias[t]===e){a=n;break}}}return a},getDynamicDateOptionForOperator:function(e,t,a){let r;if(e){if(t[e.name]){r=e.name}else if(e.alias&&t[e.alias[a]]){r=e.alias[a]}}return r},getCustomDynamicDateOptionForOperator:function(e,t){return t+"-"+e.name}};h.setOperatorsForType(i.String,[h._mOperators.contains,h._mOperators.equal,h._mOperators.between,h._mOperators.startsWith,h._mOperators.endsWith,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.empty,h._mOperators.notContains,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notStartsWith,h._mOperators.notEndsWith,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual,h._mOperators.notEmpty],h._mOperators.equal);h.setOperatorsForType(i.Date,[h._mOperators.equal,h._mOperators.between,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual,h._mOperators.today,h._mOperators.yesterday,h._mOperators.tomorrow,h._mOperators.firstDayWeek,h._mOperators.lastDayWeek,h._mOperators.firstDayMonth,h._mOperators.lastDayMonth,h._mOperators.firstDayQuarter,h._mOperators.lastDayQuarter,h._mOperators.firstDayYear,h._mOperators.lastDayYear,h._mOperators.todayFromTo,h._mOperators.lastDays,h._mOperators.nextDays,h._mOperators.thisWeek,h._mOperators.lastWeek,h._mOperators.lastWeeks,h._mOperators.nextWeek,h._mOperators.nextWeeks,h._mOperators.specificMonth,h._mOperators.specificMonthInYear,h._mOperators.thisMonth,h._mOperators.lastMonth,h._mOperators.lastMonths,h._mOperators.nextMonth,h._mOperators.nextMonths,h._mOperators.thisQuarter,h._mOperators.lastQuarter,h._mOperators.lastQuarters,h._mOperators.nextQuarter,h._mOperators.nextQuarters,h._mOperators.quarter1,h._mOperators.quarter2,h._mOperators.quarter3,h._mOperators.quarter4,h._mOperators.thisYear,h._mOperators.lastYear,h._mOperators.lastYears,h._mOperators.nextYear,h._mOperators.nextYears,h._mOperators.yearToDate,h._mOperators.dateToYear]);h.setOperatorsForType(i.DateTime,[h._mOperators.equal,h._mOperators.between,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual,h._mOperators.lastMinutes,h._mOperators.nextMinutes,h._mOperators.lastHours,h._mOperators.nextHours,h._mOperators.today,h._mOperators.yesterday,h._mOperators.tomorrow,h._mOperators.firstDayWeek,h._mOperators.lastDayWeek,h._mOperators.firstDayMonth,h._mOperators.lastDayMonth,h._mOperators.firstDayQuarter,h._mOperators.lastDayQuarter,h._mOperators.firstDayYear,h._mOperators.lastDayYear,h._mOperators.todayFromTo,h._mOperators.lastDays,h._mOperators.nextDays,h._mOperators.thisWeek,h._mOperators.lastWeek,h._mOperators.lastWeeks,h._mOperators.nextWeek,h._mOperators.nextWeeks,h._mOperators.specificMonth,h._mOperators.specificMonthInYear,h._mOperators.thisMonth,h._mOperators.lastMonth,h._mOperators.lastMonths,h._mOperators.nextMonth,h._mOperators.nextMonths,h._mOperators.thisQuarter,h._mOperators.lastQuarter,h._mOperators.lastQuarters,h._mOperators.nextQuarter,h._mOperators.nextQuarters,h._mOperators.quarter1,h._mOperators.quarter2,h._mOperators.quarter3,h._mOperators.quarter4,h._mOperators.thisYear,h._mOperators.lastYear,h._mOperators.lastYears,h._mOperators.nextYear,h._mOperators.nextYears,h._mOperators.yearToDate,h._mOperators.dateToYear]);h.setOperatorsForType(i.Numeric,[h._mOperators.equal,h._mOperators.between,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual]);h.setOperatorsForType(i.Time,[h._mOperators.equal,h._mOperators.between,h._mOperators.lessThan,h._mOperators.lessEqual,h._mOperators.greaterThan,h._mOperators.greaterEqual,h._mOperators.notEqual,h._mOperators.notBetween,h._mOperators.notLessThan,h._mOperators.notLessEqual,h._mOperators.notGreaterThan,h._mOperators.notGreaterEqual]);h.setOperatorsForType(i.Boolean,[h._mOperators.equal,h._mOperators.notEqual]);function _(e,t){const a=[];for(let r=0;r<e.length;r++){const n=e[r];if(n&&n.test&&n.test(t)){a.push(n)}}return a}function E(e){return e===null||e===undefined||e===""}function v(){if(!this._aMonths){const e=new c,t=O.getDateInstance({pattern:"LLLL"});e.setDate(15);e.setMonth(0);const a=[];for(let r=0;r<12;r++){a.push(t.format(e));e.setMonth(e.getMonth()+1)}this._aMonths=a}return this._aMonths}function w(e){const t=e.toLowerCase();const a=v.apply(this);let r=-1;a.some(function(e,a){if(e.toLowerCase()==t){r=a;return true}});return r}let S=false;function D(){const e="LFHForSpecificMonth";if(!S){S=true;m(["sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/core/Control"]).then(function(t){const a=t[0];const n=t[1];const s=t[2];const o=t[3];const l=t[4];const i=function(){if(!this._aMonthsItems){const e=v.apply(this);this._aMonthsItems=[];for(let t=0;t<12;t++){this._aMonthsItems.push({text:e[t],key:t})}}return this._aMonthsItems}.bind(this);const u=new s(e,{typeahead:new o(e+"-pop",{content:[new a(e+"-FL",{filterList:false,useFirstMatch:true,items:{path:"$items>/",template:new n({text:"{$items>text}",key:"{$items>key}"}),templateShareable:false}})]})}).setModel(new T(i()),"$items");try{const t=y.getUIArea();const a=new l(e+"-parent",{dependents:[u]});t.addContent(a,true)}catch(e){r.error(e);throw new Error("MonthValueHelp cannot be assigned because static UIArea cannot be determined.")}}.bind(this))}return e}return h},true);
//# sourceMappingURL=FilterOperatorUtil.js.map