/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/_Helper","sap/ui/model/CompositeType","sap/ui/model/FormatException","sap/ui/model/ParseException"],function(e,t,o,i,n,r){"use strict";var a="For type 'object', at least one of the format options 'showDate' or"+" 'showTime' must be enabled";var s=i.extend("sap.ui.model.odata.type.DateTimeWithTimezone",{constructor:function(e,t){if(t&&Object.keys(t).length){throw new Error("Type "+this.getName()+" does not support constraints")}e=Object.assign({},e);i.call(this,e);this.oFormat=null;this.bParseWithValues=true;this.bUseInternalValues=true;this.vEmptyTimezoneValue=null;this.bShowDate=e.showDate===undefined||e.showDate;this.bShowTime=e.showTime===undefined||e.showTime;this.bShowTimezone=e.showTimezone===undefined||e.showTimezone;this.setConstraints=function(){throw new Error("Constraints are immutable")};this.setFormatOptions=function(){throw new Error("Format options are immutable")}}});s.prototype._getErrorMessage=function(){var t=new Date(Date.UTC(e.getInstance().getFullYear(),11,31,23,59,58)),o=!this.bShowDate&&!this.bShowTime?"EnterDateTimeTimezone":"EnterDateTime";return sap.ui.getCore().getLibraryResourceBundle().getText(o,[this.formatValue([t,"America/New_York"],"string")])};s.prototype.formatValue=function(e,t){var o=e&&e[0],i=e&&e[1];if(!e||i===undefined||o===undefined||!o&&!this.bShowTimezone){return null}if(o&&!(o instanceof Date)){throw new n("Timestamp value for "+this.getName()+" is not an instance of Date: "+o)}switch(this.getPrimitiveType(t)){case"object":if(!this.bShowDate&&!this.bShowTime){throw new n(a)}return o;case"string":return this.getFormat().format(o,i);default:throw new n("Don't know how to format "+this.getName()+" to "+t)}};s.prototype.getFormat=function(){if(!this.oFormat){var e=o.extend({strictParsing:true},this.oFormatOptions);this.oFormat=t.getDateTimeWithTimezoneInstance(e)}return this.oFormat};s.prototype.getName=function(){return"sap.ui.model.odata.type.DateTimeWithTimezone"};s.prototype.getPartsIgnoringMessages=function(){if(!this.bShowDate&&!this.bShowTime){return[0]}else if(!this.bShowTimezone){return[1]}return[]};s.prototype.getPlaceholderText=function(){return this.getFormat().getPlaceholderText()};s.prototype.parseValue=function(e,t,o){var i;if(!o){throw new r("'aCurrentValues' is mandatory")}switch(this.getPrimitiveType(t)){case"object":if(!this.bShowDate&&!this.bShowTime){throw new r(a)}if(!e){return[null,undefined]}if(!(e instanceof Date)){throw new r("Given value must be an instance of Date")}return[e,undefined];case"string":if(!e){if(!this.bShowDate&&!this.bShowTime){return[undefined,this.vEmptyTimezoneValue]}return[null,undefined]}try{i=this.getFormat().parse(e,o[1])}catch(e){throw new r(e.message)}if(!i){throw new r(this._getErrorMessage())}return i;default:throw new r("Don't know how to parse "+this.getName()+" from "+t)}};s.prototype.processPartTypes=function(e){var t=e[1];if(t&&t.isA("sap.ui.model.odata.type.String")&&t.getFormatOptions().parseKeepsEmptyString===true){this.vEmptyTimezoneValue=""}};s.prototype.validateValue=function(e){};s.prototype._handleLocalizationChange=function(){this.oFormat=null};return s});
//# sourceMappingURL=DateTimeWithTimezone.js.map