/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/ODataUtils","sap/ui/model/odata/type/ODataType"],function(t,e,i,n,r,a,o){"use strict";var s=/^[-+]?(\d+)(?:\.(\d+))?$/,u=/(?:(\.[0-9]*[1-9]+)0+|\.0*)$/;function m(t){return t.oConstraints&&t.oConstraints.scale||0}function l(t,e){return sap.ui.getCore().getLibraryResourceBundle().getText(t,e)}function f(t){if(t.indexOf(".")>=0){t=t.replace(u,"$1")}return t}function c(e,i){var n,r,a,o,u;function m(i,n){t.warning("Illegal "+n+": "+i,null,e.getName())}function l(t,e,i,n){var r=typeof t==="string"?parseInt(t):t;if(r===undefined){return e}if(typeof r!=="number"||isNaN(r)||r<i){m(t,n);return e}return r}function f(t,e){if(t){if(t.match(s)){return t}m(t,e)}return undefined}function c(t,e){if(t===true||t==="true"){return true}if(t!==undefined&&t!==false&&t!=="false"){m(t,e)}return undefined}function p(t,i,n){if(i!==n){e.oConstraints=e.oConstraints||{};e.oConstraints[t]=i}}e.oConstraints=undefined;if(i){n=i.nullable;a=i.precision;u=i.scale;o=u==="variable"?Infinity:l(u,0,0,"scale");r=l(a,Infinity,1,"precision");if(o!==Infinity&&r<o){t.warning("Illegal scale: must be less than or equal to precision (precision="+a+", scale="+u+")",null,e.getName());o=Infinity}p("precision",r,Infinity);p("scale",o,0);if(n===false||n==="false"){p("nullable",false,true)}else if(n!==undefined&&n!==true&&n!=="true"){m(n,"nullable")}p("minimum",f(i.minimum,"minimum"));p("minimumExclusive",c(i.minimumExclusive,"minimumExclusive"));p("maximum",f(i.maximum,"maximum"));p("maximumExclusive",c(i.maximumExclusive,"maximumExclusive"))}e._handleLocalizationChange()}var p=o.extend("sap.ui.model.odata.type.Decimal",{constructor:function(t,e){o.apply(this,arguments);this.oFormatOptions=t;c(this,e);this.checkParseEmptyValueToZero()}});p.prototype.formatValue=function(t,e){if(t===null||t===undefined){return null}switch(this.getPrimitiveType(e)){case"any":return t;case"float":return parseFloat(t);case"int":return Math.floor(parseFloat(t));case"string":return this.getFormat().format(f(String(t)));default:throw new i("Don't know how to format "+this.getName()+" to "+e)}};p.prototype.getFormat=function(){if(!this.oFormat){var t={groupingEnabled:true,maxIntegerDigits:Infinity},i=m(this);if(i!==Infinity){t.minFractionDigits=t.maxFractionDigits=i}var n=this.oFormatOptions||{};if(n.style!=="short"&&n.style!=="long"){t.preserveDecimals=true}Object.assign(t,this.oFormatOptions);t.parseAsString=true;delete t.parseEmptyValueToZero;this.oFormat=e.getFloatInstance(t)}return this.oFormat};p.prototype.parseValue=function(t,i){var r=this.getEmptyValue(t);if(r!==undefined){return r}var a;switch(this.getPrimitiveType(i)){case"string":a=this.getFormat().parse(t);if(!a){throw new n(sap.ui.getCore().getLibraryResourceBundle().getText("EnterNumber"))}a=f(a);break;case"int":case"float":a=e.getFloatInstance({maxIntegerDigits:Infinity,decimalSeparator:".",groupingEnabled:false}).format(t);break;default:throw new n("Don't know how to parse "+this.getName()+" from "+i)}return a};p.prototype._handleLocalizationChange=function(){this.oFormat=null};p.prototype.validateValue=function(t){var e,i,n,o,u,f,c,p,h;if(t===null&&(!this.oConstraints||this.oConstraints.nullable!==false)){return}if(typeof t!=="string"){throw new r(l("EnterNumber"))}n=s.exec(t);if(!n){throw new r(l("EnterNumber"))}i=n[1].length;e=(n[2]||"").length;h=m(this);p=this.oConstraints&&this.oConstraints.precision||Infinity;f=this.oConstraints&&this.oConstraints.minimum;o=this.oConstraints&&this.oConstraints.maximum;if(e>h){if(h===0){throw new r(l("EnterInt"))}else if(i+h>p){if(h!==p){throw new r(l("EnterNumberIntegerFraction",[p-h,h]))}if(n[1]!=="0"){throw new r(l("EnterNumberFractionOnly",[h]))}}throw new r(l("EnterNumberFraction",[h]))}if(h===Infinity){if(i+e>p){throw new r(l("EnterNumberPrecision",[p]))}}else if(i>p-h){if(h!==p){if(h){throw new r(l("EnterNumberInteger",[p-h]))}throw new r(l("EnterMaximumOfDigits",[p]))}if(n[1]!=="0"){throw new r(l("EnterNumberFractionOnly",[h]))}}if(f){c=this.oConstraints.minimumExclusive;if(a.compare(f,t,true)>=(c?0:1)){throw new r(l(c?"EnterNumberMinExclusive":"EnterNumberMin",[this.formatValue(f,"string")]))}}if(o){u=this.oConstraints.maximumExclusive;if(a.compare(o,t,true)<=(u?0:-1)){throw new r(l(u?"EnterNumberMaxExclusive":"EnterNumberMax",[this.formatValue(o,"string")]))}}};p.prototype.getName=function(){return"sap.ui.model.odata.type.Decimal"};return p});
//# sourceMappingURL=Decimal.js.map