/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Context","./ODataBinding","./lib/_Cache","./lib/_Helper","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/PropertyBinding"],function(e,t,n,i,o,r,s,a,h){"use strict";var u="sap.ui.model.odata.v4.ODataPropertyBinding",d=Object.freeze([]),p={AggregatedDataStateChange:true,change:true,dataReceived:true,dataRequested:true,DataStateChange:true},l="/"+e.VIRTUAL,c=h.extend("sap.ui.model.odata.v4.ODataPropertyBinding",{constructor:f});function f(e,n,o,r){h.call(this,e,n);t.call(this);if(n.endsWith("/")){throw new Error("Invalid path: "+n)}if(r){this.checkBindingParameters(r,["$$groupId","$$ignoreMessages","$$noPatch"]);this.sGroupId=r.$$groupId;this.bNoPatch=r.$$noPatch;this.setIgnoreMessages(r.$$ignoreMessages)}else{this.sGroupId=undefined;this.bNoPatch=false}this.oCheckUpdateCallToken=undefined;this.oContext=o;this.bHasDeclaredType=undefined;this.bInitial=true;this.mQueryOptions=this.oModel.buildQueryOptions(i.clone(r),n.endsWith("$count"));this.vValue=undefined;this.fetchCache(o);e.bindingCreated(this)}t(c.prototype);c.prototype.attachEvent=function(e,t,n,i){if(!(e in p)){throw new Error("Unsupported event '"+e+"': v4.ODataPropertyBinding#attachEvent")}return h.prototype.attachEvent.apply(this,arguments)};c.prototype.checkUpdateInternal=function(e,t,n,h,d){var p=false,c=this.sPath.indexOf("##"),f=c>=0,g=this.oModel.getMetaModel(),y={data:{}},C=this.getResolvedPath(),v={forceUpdate:C&&(e||e===undefined&&this.getDataState().getControlMessages().length>0||this.oCheckUpdateCallToken&&this.oCheckUpdateCallToken.forceUpdate)},P=this.oType,R=this;this.oCheckUpdateCallToken=v;if(!P&&C&&this.sInternalType!=="any"&&!f&&!C.includes(l)){P=g.fetchUI5Type(this.sReducedPath||C)}if(d===undefined){d=this.oCachePromise.then(function(e){var t,i;if(e){return e.fetchValue(R.lockGroup(n||R.getGroupId()),undefined,function(){p=true;R.fireDataRequested(h)},R).then(function(t){R.assertSameCache(e);return t})}if(!R.isResolved()){return undefined}if(C.includes(l)){v.forceUpdate=false}if(!f){return R.oContext.fetchValue(R.sReducedPath,R)}t=R.sPath.slice(0,c);i=R.sPath.slice(c+2);if(i[0]==="/"){i="."+i}return g.fetchObject(i,g.getMetaContext(R.oModel.resolve(t,R.oContext)))}).then(function(e){if(!e||typeof e!=="object"){return e}if(R.sInternalType==="any"&&(R.getBindingMode()===s.OneTime||R.sPath[R.sPath.lastIndexOf("/")+1]==="#"&&!f)){if(f){return e}else if(R.bRelative){return i.publicClone(e)}}o.error("Accessed value is not primitive",C,u)},function(e){R.oModel.reportError("Failed to read path "+C,u,e);if(e.canceled){v.forceUpdate=false;return R.vValue}y={error:e}});if(e&&d.isFulfilled()){if(P&&P.isFulfilled&&P.isFulfilled()){this.oType=P.getResult()}this.vValue=d.getResult()}d=Promise.resolve(d)}return r.all([d,P]).then(function(e){var n=e[1],i=e[0];if(v===R.oCheckUpdateCallToken){R.oCheckUpdateCallToken=undefined;R.oType=n;if(v.forceUpdate||R.vValue!==i){R.bInitial=false;R.vValue=i;R._fireChange({reason:t||a.Change})}R.checkDataState()}if(p){R.fireDataReceived(y,h)}if(y.error){throw y.error}})};c.prototype.deregisterChangeListener=function(){if(this.sReducedPath){this.doDeregisterChangeListener(this.sReducedPath,this)}};c.prototype.destroy=function(){this.deregisterChangeListener();this.oModel.bindingDestroyed(this);this.oCheckUpdateCallToken=undefined;this.mQueryOptions=undefined;this.vValue=undefined;t.prototype.destroy.call(this);h.prototype.destroy.apply(this,arguments)};c.prototype.doCreateCache=function(e,t){return n.createProperty(this.oModel.oRequestor,e,t)};c.prototype.doFetchOrGetQueryOptions=function(){return this.isRoot()?this.mQueryOptions:undefined};c.prototype.getDependentBindings=function(){return d};c.prototype.getResumePromise=function(){};c.prototype.getValue=function(){return this.vValue};c.prototype.getValueListType=function(){var e=this.getResolvedPath();if(!e){throw new Error(this+" is unresolved")}return this.getModel().getMetaModel().getValueListType(e)};c.prototype.hasPendingChangesInDependents=function(){return false};c.prototype.initialize=function(){if(this.isResolved()){if(this.isRootBindingSuspended()){this.sResumeChangeReason=a.Change}else{this.checkUpdate(true)}}};c.prototype.isMeta=function(){return this.sPath.includes("##")};c.prototype.onChange=function(e,t){this.checkUpdateInternal(t,undefined,undefined,false,e).catch(this.oModel.getReporter())};c.prototype.onDelete=function(){};c.prototype.refreshInternal=function(e,t,n,i){var o=this;if(this.isRootBindingSuspended()){this.refreshSuspended(t);return r.resolve()}return this.oCachePromise.then(function(){if(o.oCache&&o.oCache.reset){o.oCache.reset()}else{o.fetchCache(o.oContext,false,true,i)}if(n){return o.checkUpdateInternal(undefined,a.Refresh,t,i)}})};c.prototype.requestValue=function(){var e=this;return Promise.resolve(this.checkUpdateInternal(false).then(function(){return e.getValue()}))};c.prototype.requestValueListInfo=function(e){var t=this.getResolvedPath();if(!t){throw new Error(this+" is unresolved")}return this.getModel().getMetaModel().requestValueListInfo(t,e,this.oContext)};c.prototype.requestValueListType=function(){var e=this.getResolvedPath();if(!e){throw new Error(this+" is unresolved")}return this.getModel().getMetaModel().requestValueListType(e)};c.prototype.resetChangesInDependents=function(){};c.prototype.resetInvalidDataState=function(){if(this.getDataState().isControlDirty()){this._fireChange({reason:a.Change})}};c.prototype.resume=function(){throw new Error("Unsupported operation: resume")};c.prototype.resumeInternal=function(e,t){var n=this.sResumeChangeReason;this.sResumeChangeReason=undefined;this.fetchCache(this.oContext);if(e){this.checkUpdateInternal(t?undefined:false,n).catch(this.oModel.getReporter())}};c.prototype.setContext=function(e){if(this.oContext!==e){if(this.bRelative){this.checkSuspended(true);this.deregisterChangeListener();if(e){if(this.oType&&!this.bHasDeclaredType&&i.getMetaPath(this.oModel.resolve(this.sPath,e))!==i.getMetaPath(this.sReducedPath)){this.oType=undefined}this.sReducedPath=undefined}}this.oContext=e;this.sResumeChangeReason=undefined;if(this.bRelative){this.fetchCache(this.oContext);this.checkUpdateInternal(this.bInitial||undefined,a.Context).catch(this.oModel.getReporter())}}};c.prototype.setType=function(e,t){var n=this.oType;this.bHasDeclaredType=!!e;if(e&&e.getName()==="sap.ui.model.odata.type.DateTimeOffset"){e.setV4()}h.prototype.setType.apply(this,arguments);if(!this.bInitial&&n!==e){this._fireChange({reason:a.Change})}};c.prototype.setValue=function(e,t){var n,o,r=this.getResolvedPath(),s=this;function h(e){s.oModel.reportError("Failed to update path "+r,u,e);return e}this.checkSuspended();if(this.bNoPatch&&t){throw h(new Error("Must not specify a group ID ("+t+") with $$noPatch"))}i.checkGroupId(t);if(typeof e==="function"||e&&typeof e==="object"){throw h(new Error("Not a primitive value"))}if(!this.bNoPatch&&this.vValue===undefined){throw h(new Error("Must not change a property before it has been read"))}if(this.vValue!==e){if(this.oCache){h(new Error("Cannot set value on this binding as it is not relative"+" to a sap.ui.model.odata.v4.Context"));return}n=this.bNoPatch?null:this.lockGroup(t,true,true);o=this.oContext.doSetProperty(this.sPath,e,n);o.catch(function(e){if(n){n.unlock(true)}h(e)});if(!o.isRejected()&&s.oModel.hasListeners("propertyChange")){s.oModel.firePropertyChange({context:s.oContext,path:s.sPath,promise:o.isPending()?o.getResult():undefined,reason:a.Binding,resolvedPath:r,value:e})}}};c.prototype.supportsIgnoreMessages=function(){return true};c.prototype.suspend=function(){throw new Error("Unsupported operation: suspend")};c.prototype.updateAfterCreate=function(){return this.checkUpdateInternal()};c.prototype.visitSideEffects=function(){};return c});
//# sourceMappingURL=ODataPropertyBinding.js.map