/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/each","sap/base/util/isEmptyObject","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/SimpleType","sap/ui/model/ValidateException"],function(t,e,o,a,r,i,n){"use strict";var s=i.extend("sap.ui.model.type.Integer",{constructor:function(){i.apply(this,arguments);this.sName="Integer"}});s.prototype.formatValue=function(t,e){var o=t;if(t==undefined||t==null){return null}if(this.oInputFormat){o=this.oInputFormat.parse(t);if(o==null){throw new a("Cannot format float: "+t+" has the wrong format")}}switch(this.getPrimitiveType(e)){case"string":return this.oOutputFormat.format(o);case"int":case"float":case"any":return o;default:throw new a("Don't know how to format Integer to "+e)}};s.prototype.parseValue=function(t,e){var o,a;switch(this.getPrimitiveType(e)){case"string":o=this.oOutputFormat.parse(String(t));if(isNaN(o)){a=sap.ui.getCore().getLibraryResourceBundle();throw new r(a.getText("EnterInt"))}break;case"float":o=Math.floor(t);if(o!=t){a=sap.ui.getCore().getLibraryResourceBundle();throw new r(a.getText("EnterInt"))}break;case"int":o=t;break;default:throw new r("Don't know how to parse Integer from "+e)}if(this.oInputFormat){o=this.oInputFormat.format(o)}return o};s.prototype.validateValue=function(e){if(this.oConstraints){var o=sap.ui.getCore().getLibraryResourceBundle(),a=[],r=[],i=e,s=this;if(this.oInputFormat){i=this.oInputFormat.parse(e)}t(this.oConstraints,function(t,e){switch(t){case"minimum":if(i<e){a.push("minimum");r.push(o.getText("Integer.Minimum",[s.oOutputFormat.format(e)]))}break;case"maximum":if(i>e){a.push("maximum");r.push(o.getText("Integer.Maximum",[s.oOutputFormat.format(e)]))}break;default:break}});if(a.length>0){throw new n(this.combineMessages(r),a)}}};s.prototype.setFormatOptions=function(t){this.oFormatOptions=t;this._createFormats()};s.prototype._handleLocalizationChange=function(){this._createFormats()};s.prototype._createFormats=function(){var t=this.oFormatOptions.source;this.oOutputFormat=o.getIntegerInstance(this.oFormatOptions);if(t){if(e(t)){t={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."}}this.oInputFormat=o.getIntegerInstance(t)}};return s});
//# sourceMappingURL=Integer.js.map