/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/formatter","sap/ui/support/supportRules/Constants","sap/m/OverflowToolbarAssociativePopoverControls","sap/base/util/deepExtend"],function(e,t,s,i,o,r,l,n,u){"use strict";var a={severityIcons:{High:"sap-icon://message-error",Medium:"sap-icon://message-warning",Low:"sap-icon://message-information",All:"sap-icon://multiselect-all"}};return e.extend("sap.ui.support.supportRules.ui.controllers.Issues",{ISSUES_LIMIT:1e3,formatter:r,onInit:function(){this.model=s;this.setCommunicationSubscriptions();this.getView().setModel(this.model);this.clearFilters();this._initElementTree();this.treeTable=this.byId("issuesList");this.issueTable=this.byId("issueTable");this.toolHeader=this.byId("toolHeader");this.toolHeader.removeStyleClass("sapTntToolHeader sapContrast sapContrastPlus");this.model.setProperty("/bEnabledFilterButton",false);var e=this.toolHeader._getPopover();e.removeStyleClass("sapTntToolHeaderPopover sapContrast sapContrastPlus");n._mSupportedControls["sap.ui.layout.VerticalLayout"]={canOverflow:true,listenForEvents:[],noInvalidationProps:[]}},setCommunicationSubscriptions:function(){t.subscribe(o.ON_ANALYZE_FINISH,function(e){var t=this;var s={};t.data=e;e.issues.forEach(function(e){if(!e.context||!e.context.id){return}if(!s[e.context.id]){s[e.context.id]=[e.name]}else{s[e.context.id].push(e.name)}});this.model.setSizeLimit(this.ISSUES_LIMIT);this.model.setProperty("/issues",e.issues);this.model.setProperty("/analyzePressed",true);this.model.setProperty("/issuesCount",this.data.issues.length);this.model.setProperty("/selectedIssue",null);this.elementTree.setData({controls:e.elementTree,issuesIds:s});this.clearFilters()},this);t.subscribe(o.GET_ISSUES,function(e){this.structuredIssuesModel=e.groupedIssues;this.model.setProperty("/issues",e.issuesModel);if(e.issuesModel[0]){this._setSelectedRule(e.issuesModel[0][0]);this.treeTable.setSelectedIndex(1);this.issueTable.setSelectedIndex(0)}},this)},_initElementTree:function(){var e=this;this.elementTree=new i(null,{onIssueCountClicked:function(t){e.clearFilters();e.model.setProperty("/elementFilter",t);e.updateIssuesVisibility()},onHoverChanged:function(e){t.publish(o.TREE_ELEMENT_MOUSE_ENTER,e)},onMouseOut:function(){t.publish(o.TREE_ELEMENT_MOUSE_OUT)}})},onAfterRendering:function(){this.elementTree.setContainerId(this.byId("elementTreeContainer").getId())},clearFilters:function(){this.model.setProperty("/severityFilter",l.FILTER_VALUE_ALL);this.model.setProperty("/categoryFilter",l.FILTER_VALUE_ALL);this.model.setProperty("/elementFilter",l.FILTER_VALUE_ALL);this.model.setProperty("/audienceFilter",l.FILTER_VALUE_ALL);if(this.data){this.model.setProperty("/issues",this.data.issues);this.setToolbarHeight()}this.model.setProperty("/bEnabledFilterButton",false);this.updateIssuesVisibility()},clearFiltersAndElementSelection:function(){this.clearFilters();this.elementTree.clearSelection()},onIssuePressed:function(e){var t=this.model.getProperty("/selectedIssue");this.elementTree.setSelectedElement(t.context.id,false)},onRowSelectionChanged:function(e){if(e.getParameter("rowContext")){var t=e.getParameter("rowContext").getObject(),s=l.MAX_VISIBLE_ISSUES_FOR_RULE;if(t.type==="rule"){this._setSelectedRule(t)}else{this.model.setProperty("/selectedIssue",null)}if(t.issueCount<s){s=t.issueCount}this.model.setProperty("/visibleRowCount",s)}},openDocumentation:function(e){var s=sap.ui.getCore().byId(e.mParameters.id),i=s.getBindingContext().getProperty("href");t.publish(o.OPEN_URL,i)},updateIssuesVisibility:function(){if(this.data){var e=this.data.issues.filter(this.filterIssueListItems,this);t.publish(o.REQUEST_ISSUES,e);this.model.setProperty("/visibleIssuesCount",e.length)}this.setToolbarHeight()},filterIssueListItems:function(e){var t=this.model.getProperty("/severityFilter"),s=e.severity===t||t===l.FILTER_VALUE_ALL,i=this.model.getProperty("/categoryFilter"),o=e.categories&&e.categories.indexOf(i)>-1||i===l.FILTER_VALUE_ALL,r=this.model.getProperty("/elementFilter"),n=r===e.context.id||r===l.FILTER_VALUE_ALL,u=this.model.getProperty("/audienceFilter"),a=e.audiences&&e.audiences.indexOf(u)>-1||u===l.FILTER_VALUE_ALL,d=t===l.FILTER_VALUE_ALL&&i===l.FILTER_VALUE_ALL&&u===l.FILTER_VALUE_ALL&&r===l.FILTER_VALUE_ALL;this.model.setProperty("/bEnabledFilterButton",!d);return s&&o&&n&&a},setToolbarHeight:function(){this.model.setProperty("/filterBarHeight","4rem")},onReportPress:function(e){var s=e.getParameter("item"),i=s.getText(),r=this._getReportData();if(i==="View"){t.publish(o.ON_SHOW_REPORT_REQUEST,r)}else{t.publish(o.ON_DOWNLOAD_REPORT_REQUEST,r)}},_getReportData:function(){return{executionScopes:this.model.getProperty("/executionScopes"),executionScopeTitle:this.model.getProperty("/executionScopeTitle"),analysisDurationTitle:this.model.getProperty("/analysisDurationTitle")}},onRowSelection:function(e){if(e.getParameter("rowContext")){var t=e.getParameter("rowContext").getObject();this.elementTree.setSelectedElement(t.context.id,false);this.model.setProperty("/selectedIssue/details",t.details)}},_setSelectedRule:function(e){var t,s;if(this.model.getProperty("/visibleIssuesCount")>0){t=this.structuredIssuesModel[e.ruleLibName][e.ruleId];s=u({},e);s.issues=t;s.resolutionUrls=t[0].resolutionUrls;this.issueTable.setSelectedIndex(0);this.model.setProperty("/selectedIssue/details",s.details);this.model.setProperty("/selectedIssue",s);this._setIconAndColorToIssue(s.issues)}else{this.model.setProperty("/selectedIssue",null)}},_setIconAndColorToIssue:function(e){e.forEach(function(e){switch(e.severity){case l.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:e.severityIcon=a.severityIcons.Low;e.severityColor=l.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR;break;case l.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:e.severityIcon=a.severityIcons.Medium;e.severityColor=l.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR;break;case l.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:e.severityIcon=a.severityIcons.High;e.severityColor=l.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR;break}})}})});
//# sourceMappingURL=Issues.controller.js.map