/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ExtensionBase","./AccessibilityRender","../utils/TableUtils","../library","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,a,r,jQuery,i){"use strict";var o=r.SelectionMode;var l=a.CELLTYPE;var n={getAccInfoOfControl:function(e){var t=null;if(e&&typeof e.getAccessibilityInfo==="function"){if(typeof e.getVisible==="function"&&!e.getVisible()){t=n._normalize({})}else{var r=e.getAccessibilityInfo();if(r){var i={};n._flatten(r,i);t=i}}if(t&&!t.description){t.description=a.getResourceText("TBL_CTRL_STATE_EMPTY")}}return t},_normalize:function(e){if(!e){return null}if(e._normalized){return e}e.role=e.role||"";e.type=e.type||"";e.description=e.description||"";e.enabled=e.enabled===true||e.enabled===false?e.enabled:null;e.editable=e.editable===true||e.editable===false?e.editable:null;e.children=e.children||[];e._normalized=true;return e},_flatten:function(e,t,a){a=a?a:0;n._normalize(e);if(a==0){n._normalize(t);t._descriptions=[]}t._descriptions.push(n._getFullDescription(e));e.children.forEach(function(e){if(!e.getAccessibilityInfo||e.getVisible&&!e.getVisible()){return}var r=e.getAccessibilityInfo();if(r){n._flatten(r,t,a+1)}});if(a==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined}},_getFullDescription:function(e){var t=e.type+" "+e.description;if(e.enabled===false){t=t+" "+a.getResourceText("TBL_CTRL_STATE_DISABLED")}else if(e.editable===false){t=t+" "+a.getResourceText("TBL_CTRL_STATE_READONLY")}else if(e.required===true){t=t+" "+a.getResourceText("TBL_CTRL_STATE_REQUIRED")}return t.trim()}};var s={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();var r=a.getFocusedItemInfo(t);return r.cellInRow-(a.hasRowHeader(t)?1:0)},getInfoOfFocusedCell:function(e){var t=e.getTable();var r=t._getItemNavigation();var i=t.getDomRef();if(!e.getAccMode()||!i||!r){return null}var o=r.getFocusedDomRef();if(!o||o!==document.activeElement){return null}return a.getCellInfo(o)},getRelevantColumnHeaders:function(e,t){var r=[];if(!e||!t||!e.getColumnHeaderVisible()){return r}var i=a.getHeaderRowCount(e);if(i>0){var o=t.getId();r.push(o);for(var l=1;l<i;l++){r.push(o+"_"+l)}var n=a.Column.getParentSpannedColumns(e,o);if(n&&n.length){for(var s=0;s<n.length;s++){var u=n[s].level;var c=n[s].column.getId();r[u]=u===0?c:c+"_"+u}}}return r},isHiddenCell:function(e,t){var r=a.Grouping.isInGroupHeaderRow(e);var i=a.Grouping.isInSummaryRow(e);var o=!!t&&!!t.hasStyleClass;var l=e.parent().hasClass("sapUiTableRowHidden");var n=e.hasClass("sapUiTableCellHidden");var s=r&&o&&t.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");var u=i&&o&&t.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return l||n||s||u},isTreeColumnCell:function(e,t){return a.Grouping.isInTreeMode(e.getTable())&&t.hasClass("sapUiTableCellFirst")},getColumnTooltip:function(e){if(!e){return null}var t=e.getLabel();function r(e){if(!e){return false}var a=t&&t.getText?t.getText():"";return e==a}var i=e.getTooltip_AsString();if(!r(i)){return i}if(a.isA(t,"sap.ui.core.Control")){i=t.getTooltip_AsString()}if(!r(i)){return i}return null},getGridSize:function(e){var t=a.hasRowHeader(e);var r=a.hasRowActions(e);var i=a.getVisibleColumnCount(e)+(t?1:0)+(r?1:0);var o=a.isNoDataVisible(e)?0:Math.max(e._getTotalRowCount(),e._getRowCounts()._fullsize);return{columnCount:i,rowCount:a.getHeaderRowCount(e)+o}},getRowIndex:function(e){return e.getIndex()+1+a.getHeaderRowCount(e.getTable())},updateRowColCount:function(e){var t=e.getTable(),r=t._getItemNavigation(),i=false,o=false,l=false,n=a.hasRowHeader(t);if(r){var u=s.getColumnIndexOfFocusedCell(e)+1+(n?1:0);var c=t.getRows()[a.getRowIndexOfFocusedCell(t)];var d=c?s.getRowIndex(c):0;var f=s.getGridSize(t);i=e._iLastRowNumber!=d||e._iLastRowNumber==d&&e._iLastColumnNumber==u;o=e._iLastColumnNumber!=u;l=e._iLastRowNumber==null&&e._iLastColumnNumber==null;t.$("rownumberofrows").text(i&&d>0?a.getResourceText("TBL_ROW_ROWCOUNT",[d,f.rowCount]):".");t.$("colnumberofcols").text(o?a.getResourceText("TBL_COL_COLCOUNT",[u,f.columnCount]):".");t.$("ariacount").text(l?a.getResourceText("TBL_DATA_ROWS_COLS",[f.rowCount,f.columnCount]):".");e._iLastRowNumber=d;e._iLastColumnNumber=u}return{rowChange:i,colChange:o,initial:l}},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null}},storeDefaultsBeforeCellModifications:function(e,t,a,r){e._cleanupInfo={cell:t,attr:{"aria-labelledby":a&&a.length?a.join(" "):null,"aria-describedby":r&&r.length?r.join(" "):null}}},performCellModifications:function(e,t,r,i,l,n,u,c){s.storeDefaultsBeforeCellModifications(e,t,r,i);var d=s.updateRowColCount(e);var f=e.getTable();f.$("cellacc").text(u||".");if(c){c(l,n,d.rowChange,d.colChange,d.initial)}var E="";if(d.initial){E=f.getId()+"-ariacount";if(f.getSelectionMode()!==o.None){E=E+" "+f.getId()+"-ariaselection"}}if(l&&l.length){E=E+" "+l.join(" ")}if(d.initial||d.rowChange){if(a.hasRowNavigationIndicators(f)){var T=a.getCellInfo(t);if(T.type!==a.CELLTYPE.COLUMNHEADER&&T.type!==a.CELLTYPE.COLUMNROWHEADER){var g=f.getRows()[T.rowIndex].getAggregation("_settings");if(g.getNavigated()){E=E+" "+f.getId()+"-rownavigatedtext"}}}}t.attr({"aria-labelledby":E?E:null,"aria-describedby":n&&n.length?n.join(" "):null})},modifyAccOfDATACELL:function(e){var t=this.getTable();var r=t.getId();var i=t._getItemNavigation();var o=e.cell;if(!i){return}var l=a.getRowIndexOfFocusedCell(t),c=s.getColumnIndexOfFocusedCell(this),d=a.getRowColCell(t,l,c,false),f=null,E=d.row,T=E.getId(),g=s.isHiddenCell(o,d.cell),p=s.isTreeColumnCell(this,o),b=s.getAriaAttributesFor(this,u.ELEMENTTYPES.DATACELL,{index:c,column:d.column,fixed:a.isFixedColumn(t,c)})["aria-labelledby"]||[],R=[],C=[r+"-rownumberofrows",r+"-colnumberofcols"],h=E.isGroupHeader(),A=E.isSummary();if(h){C.push(r+"-ariarowgrouplabel")}else if(E.isTotalSummary()){C.push(r+"-ariagrandtotallabel")}else if(E.isGroupSummary()){C.push(r+"-ariagrouptotallabel")}if(a.hasRowHighlights(t)&&!h&&!A){C.push(T+"-highlighttext")}C=C.concat(b);if(!g){f=n.getAccInfoOfControl(d.cell);C.push(f?r+"-cellacc":d.cell.getId());if(a.getInteractiveElements(o)!==null){C.push(r+"-toggleedit")}}var v=f?f.description:".";if(p&&!g){var w=s.getAriaAttributesFor(this,u.ELEMENTTYPES.TREEICON,{row:d.row});if(w&&w["aria-label"]){v=w["aria-label"]+" "+v}}s.performCellModifications(this,o,b,null,C,R,v,function(e,r,i,l){if(h&&i){e.splice(3,0,T+"-groupHeader")}var n=o.find(".sapUiTableTreeIcon").not(".sapUiTableTreeIconLeaf").length==1;if((n||h)&&(i||l)){r.push(t.getId()+(!E.isExpanded()?"-rowexpandtext":"-rowcollapsetext"))}else if(!g&&!h&&!A&&a.isRowSelectionAllowed(t)&&i){e.push(T+"-rowselecttext")}})},modifyAccOfROWHEADER:function(e){var t=this.getTable();var r=t.getId();var i=e.cell;var o=t.getRows()[e.rowIndex];var l=o.getId();var n=s.getAriaAttributesFor(this,u.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[];var c=n.concat([r+"-rownumberofrows",r+"-colnumberofcols"]);if(!o.isSummary()&&!o.isGroupHeader()&&!o.isContentHidden()){c.push(l+"-rowselecttext");if(a.hasRowHighlights(t)){c.push(l+"-highlighttext")}}if(o.isGroupHeader()){c.push(r+"-ariarowgrouplabel");c.push(l+"-groupHeader");c.push(r+(o.isExpanded()?"-rowcollapsetext":"-rowexpandtext"))}if(o.isTotalSummary()){c.push(r+"-ariagrandtotallabel")}else if(o.isGroupSummary()){c.push(r+"-ariagrouptotallabel")}s.performCellModifications(this,i,n,null,c,null,null)},modifyAccOfCOLUMNHEADER:function(e){var t=this.getTable();var r=e.cell;var i=sap.ui.getCore().byId(r.attr("data-sap-ui-colid"));var o=a.Column.getHeaderLabel(i);var l=s.getAriaAttributesFor(this,u.ELEMENTTYPES.COLUMNHEADER,{headerId:r.attr("id"),column:i,index:r.attr("data-sap-ui-colindex")});var n=s.getColumnTooltip(i);var c=[t.getId()+"-colnumberofcols"].concat(l["aria-labelledby"]);var d=e.columnSpan;if(a.isA(o,"sap.m.Label")&&o.getRequired()){c.push(t.getId()+"-ariarequired")}if(d>1){c.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(a.getResourceText("TBL_COL_DESC_SPAN",[""+d]))}if(n){c.push(t.getId()+"-cellacc")}if(d<=1&&i&&i.getFiltered()){c.push(t.getId()+"-ariacolfiltered")}s.performCellModifications(this,r,l["aria-labelledby"],l["aria-describedby"],c,l["aria-describedby"],n)},modifyAccOfCOLUMNROWHEADER:function(e){var t=this.getTable();var a=e.cell;var r=a.hasClass("sapUiTableSelAllVisible");var i=s.getAriaAttributesFor(this,u.ELEMENTTYPES.COLUMNROWHEADER,{enabled:r,checked:r&&!t.$().hasClass("sapUiTableSelAll")});var o=[t.getId()+"-colnumberofcols"].concat(i["aria-labelledby"]);s.performCellModifications(this,a,i["aria-labelledby"],i["aria-describedby"],o,i["aria-describedby"],null)},modifyAccOfROWACTION:function(e){var t=this.getTable();var r=t.getId();var i=e.cell;var o=t.getRows()[e.rowIndex];var l=o.getId();var n=s.isHiddenCell(i);var c=s.getAriaAttributesFor(this,u.ELEMENTTYPES.ROWACTION)["aria-labelledby"]||[];var d=[r+"-rownumberofrows",r+"-colnumberofcols"].concat(c);var f=[];var E=o.isGroupHeader();if(E){d.push(r+"-ariarowgrouplabel");d.push(r+(o.isExpanded()?"-rowcollapsetext":"-rowexpandtext"))}if(o.isTotalSummary()){d.push(r+"-ariagrandtotallabel")}else if(o.isGroupSummary()){d.push(r+"-ariagrouptotallabel")}if(a.hasRowHighlights(t)&&!o.isGroupHeader()&&!o.isSummary()){d.push(l+"-highlighttext")}var T="";if(!n){var g=o.getRowAction();if(g){var p=g.getAccessibilityInfo();if(p){d.push(r+"-cellacc");T=p.description;if(a.getInteractiveElements(i)!==null){f.push(r+"-toggleedit")}}}}s.performCellModifications(this,i,c,[],d,f,T,function(e,t,a){if(E&&a){var i=e.indexOf(r+"-ariarowgrouplabel")+1;e.splice(i,0,l+"-groupHeader")}})},getAriaAttributesFor:function(e,t,r){var i={},l=e.getTable(),n=l.getId();function c(e,t,r,o){var l="";if(r&&o){l="overlay,nodata"}else if(r&&!o){l="overlay"}else if(!r&&o){l="nodata"}var n=false;if(r&&e.getShowOverlay()||o&&a.isNoDataVisible(e)){n=true}if(n){i["aria-hidden"]="true"}if(l){i["data-sap-ui-table-acc-covered"]=l}}switch(t){case u.ELEMENTTYPES.COLUMNROWHEADER:var d=l._getSelectionPlugin().getRenderConfig();if(d.headerSelector.visible){if(d.headerSelector.type==="toggle"){i["role"]=["checkbox"];if(r&&r.enabled){i["aria-checked"]=r.checked?"true":"false"}}else if(d.headerSelector.type==="clear"){i["role"]=["button"];if(!r||!r.enabled){i["aria-disabled"]="true"}}}break;case u.ELEMENTTYPES.ROWHEADER:i["role"]="gridcell";i["aria-colindex"]=1;if(a.hasRowHeader(l)&&l.getSelectionMode()===o.None){i["aria-labelledby"]=[n+"-rowselecthdr"]}break;case u.ELEMENTTYPES.ROWACTION:i["role"]="gridcell";i["aria-colindex"]=a.getVisibleColumnCount(l)+1+(a.hasRowHeader(l)?1:0);i["aria-labelledby"]=[n+"-rowacthdr"];break;case u.ELEMENTTYPES.COLUMNHEADER:var f=r&&r.column;var E=r&&r.colspan;i["role"]="columnheader";i["aria-colindex"]=r.index+1+(a.hasRowHeader(l)?1:0);var T=[];if(r&&r.headerId){var g=s.getRelevantColumnHeaders(l,f);var p=g.indexOf(r.headerId);T=p>0?g.slice(0,p+1):[r.headerId]}for(var b=0;b<T.length;b++){T[b]=T[b]+"-inner"}i["aria-labelledby"]=T;if(r&&r.index<l.getComputedFixedColumnCount()){i["aria-labelledby"].push(n+"-ariafixedcolumn")}if(!E&&f){i["aria-sort"]=f.getSortOrder().toLowerCase();if(!f.getSorted()){delete i["aria-sort"]}}if(!E&&f){var R=f.getHeaderMenuInstance();if(R){var C=R.getAriaHasPopupType();if(C!=="None"){i["aria-haspopup"]=C.toLowerCase()}}if(!R&&f._menuHasItems()){i["aria-haspopup"]="menu"}}break;case u.ELEMENTTYPES.DATACELL:i["role"]="gridcell";i["aria-colindex"]=r.index+1+(a.hasRowHeader(l)?1:0);if(r.column){var T=s.getRelevantColumnHeaders(l,r.column);for(var b=0;b<T.length;b++){T[b]=T[b]+"-inner"}if(r&&r.fixed){T.push(n+"-ariafixedcolumn")}i["aria-labelledby"]=T}break;case u.ELEMENTTYPES.ROOT:break;case u.ELEMENTTYPES.TABLE:i["role"]="presentation";c(l,i,true,true);break;case u.ELEMENTTYPES.CONTAINER:break;case u.ELEMENTTYPES.CONTENT:i["role"]=a.Grouping.isInGroupMode(l)||a.Grouping.isInTreeMode(l)?"treegrid":"grid";i["aria-labelledby"]=[].concat(l.getAriaLabelledBy());if(l.getTitle()){i["aria-labelledby"].push(l.getTitle().getId())}if(l.getSelectionMode()===o.MultiToggle){i["aria-multiselectable"]="true"}var h=l._getRowCounts();var A=a.hasFixedColumns(l);var v=h.fixedTop>0;var w=h.fixedBottom>0;var L=a.hasRowHeader(l);var m=a.hasRowActions(l);var O=s.getGridSize(l);i["aria-owns"]=[n+"-table"];if(A){i["aria-owns"].push(n+"-table-fixed")}if(v){i["aria-owns"].push(n+"-table-fixrow");if(A){i["aria-owns"].push(n+"-table-fixed-fixrow")}}if(w){i["aria-owns"].push(n+"-table-fixrow-bottom");if(A){i["aria-owns"].push(n+"-table-fixed-fixrow-bottom")}}if(L){i["aria-owns"].push(n+"-sapUiTableRowHdrScr")}if(m){i["aria-owns"].push(n+"-sapUiTableRowActionScr")}i["aria-rowcount"]=O.rowCount;i["aria-colcount"]=O.columnCount;if(l.isA("sap.ui.table.AnalyticalTable")){i["aria-roledescription"]=a.getResourceText("TBL_ANALYTICAL_TABLE_ROLE_DESCRIPTION")}break;case u.ELEMENTTYPES.TABLEHEADER:i["role"]="heading";i["aria-level"]="2";c(l,i,true,false);break;case u.ELEMENTTYPES.COLUMNHEADER_TBL:i["role"]="presentation";break;case u.ELEMENTTYPES.COLUMNHEADER_ROW:i["role"]="row";c(l,i,true,false);break;case u.ELEMENTTYPES.CREATIONROW_TBL:i["role"]="presentation";break;case u.ELEMENTTYPES.CREATIONROW:i["role"]="form";i["aria-labelledby"]=r.creationRow.getId()+"-label";c(l,i,true,false);break;case u.ELEMENTTYPES.ROWHEADER_COL:c(l,i,true,true);break;case u.ELEMENTTYPES.TH:i["role"]="presentation";i["scope"]="col";i["aria-hidden"]="true";break;case u.ELEMENTTYPES.TR:i["role"]="row";if(r.rowNavigated){i["aria-current"]=true}if(!r.fixedCol){i["aria-owns"]=[];if(a.hasRowHeader(l)){i["aria-owns"].push(n+"-rowsel"+r.index)}if(a.hasFixedColumns(l)){for(var _=0;_<l.getComputedFixedColumnCount();_++){i["aria-owns"].push(n+"-rows-row"+r.index+"-col"+_)}}if(a.hasRowActions(l)){i["aria-owns"].push(n+"-rowact"+r.index)}}break;case u.ELEMENTTYPES.TREEICON:if(a.Grouping.isInTreeMode(l)){i={"aria-label":"",title:"",role:""};if(l.getBinding()){if(r&&r.row){if(r.row.isExpandable()){var S=a.getResourceText("TBL_COLLAPSE_EXPAND");i["title"]=S;i["aria-expanded"]=""+!!r.row.isExpanded();i["aria-hidden"]="false";i["role"]="button"}else{i["aria-label"]=a.getResourceText("TBL_LEAF");i["aria-hidden"]="true"}}}}break;case u.ELEMENTTYPES.NODATA:var N=a.getNoContentMessage(l);var T=[];i["role"]="gridcell";if(a.isA(N,"sap.ui.core.Control")){if(N.getAccessibilityReferences instanceof Function){var y=N.getAccessibilityReferences();T.push(y.title);T.push(y.description)}else{T.push(N.getId())}}else{T.push(n+"-noDataMsg")}i["aria-labelledby"]=T;c(l,i,true,false);break;case u.ELEMENTTYPES.OVERLAY:i["role"]="region";i["aria-labelledby"]=[].concat(l.getAriaLabelledBy());if(l.getTitle()){i["aria-labelledby"].push(l.getTitle().getId())}i["aria-labelledby"].push(n+"-ariainvalid");break;case u.ELEMENTTYPES.TABLEFOOTER:case u.ELEMENTTYPES.TABLESUBHEADER:c(l,i,true,false);break;case u.ELEMENTTYPES.ROWACTIONHEADER:i["aria-hidden"]="true";break;case"PRESENTATION":i["role"]="presentation";break}return i}};var u=e.extend("sap.ui.table.extensions.Accessibility",{_init:function(r,o,l){this._accMode=i.getAccessibility();this._busyCells=[];a.addDelegate(r,this);e.enrich(r,t);return"AccExtension"},_attachEvents:function(){a.Hook.register(this.getTable(),a.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this)},_detachEvents:function(){a.Hook.deregister(this.getTable(),a.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this)},_debug:function(){this._ExtensionHelper=s;this._ACCInfoHelper=n},destroy:function(){this.getTable().removeEventDelegate(this);this._busyCells=[];e.prototype.destroy.apply(this,arguments)},getAriaAttributesFor:function(e,t){return s.getAriaAttributesFor(this,e,t)},onfocusin:function(e){var t=this.getTable();if(!t||a.getCellInfo(e.target).cell==null){return}if(t._mTimeouts._cleanupACCExtension){clearTimeout(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null}this.updateAccForCurrentCell("Focus")},onfocusout:function(e){var t=this.getTable();if(!t){return}t._mTimeouts._cleanupACCExtension=setTimeout(function(){var e=this.getTable();if(!e){return}this._iLastRowNumber=null;this._iLastColumnNumber=null;s.cleanupCellModifications(this);e._mTimeouts._cleanupACCExtension=null}.bind(this),100)}});u.ELEMENTTYPES={DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",ROWACTION:"ROWACTION",COLUMNROWHEADER:"COLUMNROWHEADER",ROOT:"ROOT",CONTAINER:"CONTAINER",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_TBL:"COLUMNHEADER_TABLE",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",CREATIONROW_TBL:"CREATIONROW_TABLE",CREATIONROW:"CREATIONROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",TR:"TR",TREEICON:"TREEICON",ROWACTIONHEADER:"ROWACTIONHEADER",NODATA:"NODATA",OVERLAY:"OVERLAY"};u.prototype.getAccMode=function(){return this._accMode};u.prototype._updateAriaRowIndices=function(){if(!this._accMode){return}var e=this.getTable();var t=e.getRows();var a,r,i;for(r=0;r<t.length;r++){a=t[r];i=a.getDomRefs(true);i.row.not(i.rowHeaderPart).not(i.rowActionPart).attr("aria-rowindex",s.getRowIndex(a))}};u.prototype._updateAriaRowCount=function(){var e=this.getTable();var t=e.$("sapUiTableGridCnt");if(t){t.attr("aria-rowcount",s.getGridSize(e).rowCount)}};u.prototype.updateAccForCurrentCell=function(e){if(!this._accMode||!this.getTable()._getItemNavigation()){return}if(e==="Focus"||e===a.RowsUpdateReason.Expand||e===a.RowsUpdateReason.Collapse){s.cleanupCellModifications(this)}var t=s.getInfoOfFocusedCell(this);var r;if(!t||!t.isOfType(l.ANY)){return}if(t.isOfType(l.DATACELL)){r=u.ELEMENTTYPES.DATACELL}else if(t.isOfType(l.COLUMNHEADER)){r=u.ELEMENTTYPES.COLUMNHEADER}else if(t.isOfType(l.ROWHEADER)){r=u.ELEMENTTYPES.ROWHEADER}else if(t.isOfType(l.ROWACTION)){r=u.ELEMENTTYPES.ROWACTION}else if(t.isOfType(l.COLUMNROWHEADER)){r=u.ELEMENTTYPES.COLUMNROWHEADER}if(!s["modifyAccOf"+r]){return}if(e!=="Focus"&&e!==a.RowsUpdateReason.Expand&&e!==a.RowsUpdateReason.Collapse){if(t.isOfType(l.ANYCONTENTCELL)){t.cell.attr("role","status");t.cell.attr("role","gridcell")}else{return}}s["modifyAccOf"+r].apply(this,[t])};u.prototype.updateRowTooltips=function(e,t,r){if(!this._accMode){return}var i=this.getTable();var o=!e.isEmpty()&&!e.isGroupHeader()&&!e.isSummary()&&!i._getHideStandardTooltips();if(t.row){if(o&&a.isRowSelectionAllowed(i)&&!t.row.hasClass("sapUiTableRowHidden")){t.row.attr("title",r)}else{t.row.removeAttr("title")}}if(t.rowSelector){if(o&&a.isRowSelectorSelectionAllowed(i)){t.rowSelector.attr("title",r)}else{t.rowSelector.removeAttr("title")}}if(t.rowScrollPart){var l=t.rowScrollPart.add(t.rowFixedPart).add(t.rowActionPart);if(o&&a.isRowSelectionAllowed(i)){l.attr("title",r)}else{l.removeAttr("title")}}};u.prototype.updateSelectionStateOfRow=function(e){if(!this._accMode){return}var t=e.getDomRefs(true);var a="";var r="";if(!e.isEmpty()&&!e.isGroupHeader()&&!e.isSummary()){var i=this.getAriaTextsForSelectionMode(true);var o=this.getTable();var l=o._getSelectionPlugin().isSelected(e);if(t.row){t.row.not(t.rowHeaderPart).not(t.rowActionPart).add(t.row.children(".sapUiTableCell")).attr("aria-selected",l?"true":"false")}if(!l){a=i.keyboard["rowSelect"];r=i.mouse["rowSelect"]}else{a=i.keyboard["rowDeselect"];r=i.mouse["rowDeselect"]}}if(t.rowSelectorText){t.rowSelectorText.text(a)}this.updateRowTooltips(e,t,r)};u.prototype.updateAriaExpandAndLevelState=function(e){if(!this._accMode){return}var t=e.getDomRefs(true);var a=t.row.find(".sapUiTableTreeIcon");if(t.rowHeaderPart){t.rowHeaderPart.attr({"aria-haspopup":e.isGroupHeader()?"menu":null})}t.row.not(t.rowHeaderPart).not(t.rowActionPart).attr({"aria-expanded":e.isExpandable()?e.isExpanded()+"":null,"aria-level":e.getLevel()});if(a){a.attr(s.getAriaAttributesFor(this,u.ELEMENTTYPES.TREEICON,{row:e}))}};u.prototype.updateAriaStateOfRowHighlight=function(e){if(!this._accMode||!e){return}var t=e._getRow();var a=t?t.getDomRef("highlighttext"):null;if(a){a.innerText=e._getHighlightText()}};u.prototype._updateAriaStateOfNavigatedRow=function(e){if(!this._accMode||!e){return}var t=e._getRow();var a=e.getNavigated();t.getDomRefs(true).row.attr("aria-current",a?true:null)};u.prototype.updateAriaStateForOverlayAndNoData=function(){var e=this.getTable();if(!e||!e.getDomRef()||!this._accMode){return}if(e.getShowOverlay()){e.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true")}else{e.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(a.isNoDataVisible(e)){e.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true")}else{e.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden")}}};u.prototype.getAriaTextsForSelectionMode=function(e,t){var r=this.getTable();if(!t){t=r.getSelectionMode()}var i=!r._getHideStandardTooltips();var l={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var n=r._getSelectionPlugin().getSelectedCount();if(t===o.Single){l.mouse.rowSelect=i?a.getResourceText("TBL_ROW_SELECT"):"";l.mouse.rowDeselect=i?a.getResourceText("TBL_ROW_DESELECT"):"";l.keyboard.rowSelect=a.getResourceText("TBL_ROW_SELECT_KEY");l.keyboard.rowDeselect=a.getResourceText("TBL_ROW_DESELECT_KEY")}else if(t===o.MultiToggle){l.mouse.rowSelect=i?a.getResourceText("TBL_ROW_SELECT_MULTI_TOGGLE"):"";l.mouse.rowDeselect=i?a.getResourceText("TBL_ROW_DESELECT"):"";l.keyboard.rowSelect=a.getResourceText("TBL_ROW_SELECT_KEY");l.keyboard.rowDeselect=a.getResourceText("TBL_ROW_DESELECT_KEY");if(e===true&&n===0){l.mouse.rowSelect=i?a.getResourceText("TBL_ROW_SELECT"):""}}return l};u.prototype.setSelectAllState=function(e){var t=this.getTable();if(this._accMode&&t){t.$("selall").attr("aria-checked",e?"true":"false")}};u.prototype.addColumnHeaderLabel=function(e,t){var a=this.getTable();if(!this._accMode||!t.getAriaLabelledBy||!a){return}var r=a.getColumnHeaderVisible()?e.getId():null;if(!r){var i=e.getAggregation("label");if(i){r=i.getId()}}var o=t.getAriaLabelledBy();if(r&&o.indexOf(r)<0){t.addAriaLabelledBy(r)}};return u});
//# sourceMappingURL=Accessibility.js.map