/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/core/Element","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/control"],function(e,t,i,o,n,l,s,jQuery){"use strict";var r=i.SelectionMode;var a=i.SelectionBehavior;var u=["sapMBtnBase","sapMInputBase","sapMLnk","sapMSlt","sapMCb","sapMRI","sapMSegBBtn","sapUiIconPointer","sapMBtnIcon","sapMObjStatusActive"];var d={_getEventPosition:function(e,t){var i;function o(i){if(!t._isTouchEvent(i)){return null}var o=["touches","targetTouches","changedTouches"];for(var n=0;n<o.length;n++){var l=o[n];if(e[l]&&e[l][0]){return e[l][0]}if(e.originalEvent[l]&&e.originalEvent[l][0]){return e.originalEvent[l][0]}}return null}i=o(e)||e;return{x:i.pageX,y:i.pageY}},_skipClick:function(e,i,o){if(!o.isOfType(t.CELLTYPE.DATACELL|t.CELLTYPE.ROWACTION)){return false}if(e.isMarked()){return true}var l=n.closestTo(i[0]);if(l){var s=l.$();if(s.length){for(var r=0;r<u.length;r++){if(s.hasClass(u[r])){return typeof l.getEnabled==="function"?l.getEnabled():true}}}}return false},_handleClickSelection:function(e,i,o){t.toggleRowSelection(o,i,null,function(t){var i=o._getSelectionPlugin();if(e.shiftKey){i.setSelected(t,true,{range:true})}else if(o._legacyMultiSelection){o._legacyMultiSelection(t.getIndex(),e)}else{i.setSelected(t,!i.isSelected(t))}})}};var f={initColumnResizing:function(e,t){if(e._bIsColumnResizerMoving){return}e._bIsColumnResizerMoving=true;e._bColumnResizerMoved=false;e._iColumnResizeStart=d._getEventPosition(t,e).x;e.$().toggleClass("sapUiTableResizing",true);var i=jQuery(document);var o=e._isTouchEvent(t);e._$colResize=e.$("rsz");i.on((o?"touchend":"mouseup")+".sapUiTableColumnResize",f.exitColumnResizing.bind(e));i.on((o?"touchmove":"mousemove")+".sapUiTableColumnResize",f.onMouseMoveWhileColumnResizing.bind(e));e._disableTextSelection()},exitColumnResizing:function(e){var i=d._getEventPosition(e,this).x;var o=this._getVisibleColumns()[this._iLastHoveredVisibleColumnIndex];var n=this.$().find('th[data-sap-ui-colid="'+o.getId()+'"]');var l=n[0].offsetWidth;var s=n.width();var r=l-s;var a=i-(n.offset().left+(this._bRtlMode?0:l));var u=Math.round(l+a*(this._bRtlMode?-1:1))-r;var h=Math.max(u,t.Column.getMinColumnWidth());f._resizeColumn(this,this._iLastHoveredVisibleColumnIndex,this._bColumnResizerMoved?h:null)},onMouseMoveWhileColumnResizing:function(e){var t=d._getEventPosition(e,this).x;var i=this.$().find(".sapUiTableCnt").offset().left;var o=Math.floor(t-i);if(!this._bColumnResizerMoved&&Math.abs(t-this._iColumnResizeStart)>=5){this._bColumnResizerMoved=true}this._$colResize.css("left",o+"px");this._$colResize.toggleClass("sapUiTableColRszActive",true);if(this._isTouchEvent(e)){e.stopPropagation();e.preventDefault()}},_cleanupColumResizing:function(e){if(e._$colResize){e._$colResize.toggleClass("sapUiTableColRszActive",false);e._$colResize=null}e._bIsColumnResizerMoving=false;e.$().toggleClass("sapUiTableResizing",false);e._enableTextSelection();var t=jQuery(document);t.off("touchmove.sapUiTableColumnResize");t.off("touchend.sapUiTableColumnResize");t.off("mousemove.sapUiTableColumnResize");t.off("mouseup.sapUiTableColumnResize")},_resizeColumn:function(e,i,o){var n=e._getVisibleColumns();var l;if(i>=0&&i<n.length){l=n[i];if(o!=null){t.Column.resizeColumn(e,e.indexOfColumn(l),o)}}f._cleanupColumResizing(e);l.focus()},doAutoResizeColumn:function(e,t){var i=e._getVisibleColumns(),o;if(t>=0&&t<i.length){o=i[t];if(!o.getAutoResizable()||!o.getResizable()){return}var n=f._calculateAutomaticColumnWidth.apply(e,[o,t]);if(n){f._resizeColumn(e,t,n)}}},_calculateAutomaticColumnWidth:function(e,i){e=e||this.getColumns()[i];var o=this.$();var n=jQuery("<div>").addClass("sapUiTableHiddenSizeDetector sapUiTableHeaderDataCell sapUiTableDataCell");o.append(n);var l=o.find('td[data-sap-ui-colid = "'+e.getId()+'"]:not([colspan])').filter(function(e,t){return t.style.display!="none"}).children().clone();l.removeAttr("id");var s=n.append(l).width()+4;s=Math.min(s,o.find(".sapUiTableCnt").width());s=Math.max(s+4,t.Column.getMinColumnWidth());n.remove();return s},initColumnTracking:function(e){e.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").on("mousemove",function(e){var t=this.getDomRef("sapUiTableCnt");if(!t||this._bIsColumnResizerMoving){return}var i=e.clientX,o=t.getBoundingClientRect(),n=0,l=this._bRtlMode?1e4:-1e4;for(var s=0;s<this._aTableHeaders.length;s++){var r=this._aTableHeaders[s].getBoundingClientRect();if(this._bRtlMode){if(i<r.right-5&&i>=r.left){n=s;l=r.left-o.left;break}}else{if(i>r.left+5&&i<=r.right){n=s;l=r.right-o.left;break}}}var a=this._getVisibleColumns()[n];if(a&&a.getResizable()){this.$("rsz").css("left",l+"px");this._iLastHoveredVisibleColumnIndex=n}}.bind(e))}};var h={initReordering:function(e,i,o){var n=e.getColumns()[i],s=n.$(),r=e.$();e._disableTextSelection();r.addClass("sapUiTableDragDrop");var a=s.clone();a.find("*").addBack(a).removeAttr("id").removeAttr("data-sap-ui").removeAttr("tabindex");a.attr("id",e.getId()+"-roghost").addClass("sapUiTableColReorderGhost").css({left:-1e4,top:-1e4,"z-index":l.getNextZIndex()});a.toggleClass(t.getContentDensity(e),true);a.appendTo(document.body);e._$ReorderGhost=e.getDomRef("roghost");r.find("td[data-sap-ui-colid='"+n.getId()+"']").toggleClass("sapUiTableColReorderFade",true);var u=jQuery("<div id='"+e.getId()+"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>");u.appendTo(e.getDomRef("sapUiTableCnt"));e._$ReorderIndicator=e.getDomRef("roind");e._iDnDColIndex=i;var d=jQuery(document),f=e._isTouchEvent(o);d.on((f?"touchend":"mouseup")+".sapUiColumnMove",h.exitReordering.bind(e));d.on((f?"touchmove":"mousemove")+".sapUiColumnMove",h.onMouseMoveWhileReordering.bind(e))},onMouseMoveWhileReordering:function(e){var i=d._getEventPosition(e,this),o=i.x,n=i.y,l=this._iNewColPos;this._iNewColPos=this._iDnDColIndex;e.preventDefault();var s=h.findColumnForPosition(this,o);if(!s||!s.id){this._iNewColPos=l;return}var r=40,a=this.getDomRef("sapUiTableColHdrScr"),u=jQuery(a),f=a.getBoundingClientRect(),c=u.outerWidth(),C=this._bRtlMode?u.scrollLeftRTL():u.scrollLeft();this._bReorderScroll=false;if(o>f.left+c-r&&C+c<a.scrollWidth){this._bReorderScroll=true;h.doScroll(this,!this._bRtlMode);h.adaptReorderMarkerPosition(this,s,false)}else if(o<f.left+r&&C>0){this._bReorderScroll=true;h.doScroll(this,this._bRtlMode);h.adaptReorderMarkerPosition(this,s,false)}jQuery(this._$ReorderGhost).css({left:o+5,top:n+5});if(this._bReorderScroll||!s){return}if(s.before||s.after&&s.index==this._iDnDColIndex){this._iNewColPos=s.index}else if(s.after&&s.index!=this._iDnDColIndex){this._iNewColPos=s.index+1}if(!t.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)){this._iNewColPos=l}else{h.adaptReorderMarkerPosition(this,s,true)}},exitReordering:function(e){var i=this._iDnDColIndex;var o=this._iNewColPos;var n=jQuery(document);n.off("touchmove.sapUiColumnMove");n.off("touchend.sapUiColumnMove");n.off("mousemove.sapUiColumnMove");n.off("mouseup.sapUiColumnMove");this._bReorderScroll=false;this.$().removeClass("sapUiTableDragDrop");delete this._iDnDColIndex;delete this._iNewColPos;jQuery(this._$ReorderGhost).remove();delete this._$ReorderGhost;jQuery(this._$ReorderIndicator).remove();delete this._$ReorderIndicator;this.$().find(".sapUiTableColReorderFade").removeClass("sapUiTableColReorderFade");this._enableTextSelection();t.Column.moveColumnTo(this.getColumns()[i],o)},findColumnForPosition:function(e,t){var i,o,n,l,s,r,a;for(var u=0;u<e._aTableHeaders.length;u++){i=e._aTableHeaders[u];o=jQuery(i);n=i.getBoundingClientRect();l=o.outerWidth();s={left:n.left,center:n.left+l/2,right:n.left+l,width:l,index:parseInt(o.attr("data-sap-ui-headcolindex")),id:o.attr("data-sap-ui-colid")};r=t>=s.left&&t<=s.center;a=t>=s.center&&t<=s.right;if(r||a){s.before=e._bRtlMode?a:r;s.after=e._bRtlMode?r:a;return s}}return null},doScroll:function(e,t){if(e._mTimeouts.horizontalReorderScrollTimerId){window.clearTimeout(e._mTimeouts.horizontalReorderScrollTimerId);e._mTimeouts.horizontalReorderScrollTimerId=null}if(e._bReorderScroll){var i=t?30:-30;if(e._bRtlMode){i=-1*i}e._mTimeouts.horizontalReorderScrollTimerId=setTimeout(h.doScroll.bind(e,e,t),60);var o=e.$("sapUiTableColHdrScr");var n=e._bRtlMode?"scrollLeftRTL":"scrollLeft";o[n](o[n]()+i)}},adaptReorderMarkerPosition:function(e,t,i){if(!t||!e._$ReorderIndicator){return}var o=t.left-e.getDomRef().getBoundingClientRect().left;if(e._bRtlMode&&t.before||!e._bRtlMode&&t.after){o=o+t.width}jQuery(e._$ReorderIndicator).css({left:o+"px"}).toggleClass("sapUiTableColReorderIndicatorActive",i)}};var c={ROWAREAS:[".sapUiTableRowSelectionCell",".sapUiTableRowActionCell",".sapUiTableCtrlFixed > tbody > .sapUiTableTr",".sapUiTableCtrlScroll > tbody > .sapUiTableTr"],initRowHovering:function(e){var t=e.$();c.ROWAREAS.forEach(function(i){c._initRowHoveringForArea(e,t,i)})},_initRowHoveringForArea:function(e,t,i){t.find(i).on("mouseenter",function(){c._onHover(e,t,i,this)}).on("mouseleave",function(){c._onUnhover(e,t,i,this)})},_onHover:function(e,t,i,o){if(e.getSelectionMode()!==r.None&&e.getSelectionBehavior()!==a.RowSelector||e.hasListeners("cellClick")){var n=t.find(i).index(o);var l=e.getRows()[n];if(l){l._setHovered(true)}}},_onUnhover:function(e,t,i,o){var n=t.find(i).index(o);var l=e.getRows()[n];if(l){l._setHovered(false)}}};var C={onmousedown:function(e){var i=this._getPointerExtension();var n=t.getCell(this,e.target);var l=t.getCellInfo(n);var s=jQuery(e.target);var r;var a;var u;this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("rsz")){e.preventDefault();e.stopPropagation();f.initColumnResizing(this,e)}else if(s.hasClass("sapUiTableColResizer")){var h=s.closest(".sapUiTableHeaderCell").attr("data-sap-ui-colindex");this._iLastHoveredVisibleColumnIndex=this._getVisibleColumns().indexOf(this.getColumns()[h]);f.initColumnResizing(this,e)}else if(l.isOfType(t.CELLTYPE.COLUMNHEADER)){r=this.getColumns()[l.columnIndex];a=r.getAggregation("menu");u=a&&a.isOpen();if(!u){i._bShowMenu=true;this._mTimeouts.delayedMenuTimerId=setTimeout(function(){delete i._bShowMenu},200)}if(this.getEnableColumnReordering()&&!(this._isTouchEvent(e)&&s.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(l.columnIndex,e)}}if(o.browser.firefox&&(e.metaKey||e.ctrlKey)||s.closest(".sapUiTableHSb",this.getDomRef()).length===1||s.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault()}}if(e.button===2){if(d._skipClick(e,s,l)){i._bShowDefaultMenu=true;return}if(l.isOfType(t.CELLTYPE.COLUMNHEADER)){r=this.getColumns()[l.columnIndex];a=r.getAggregation("menu");u=a&&a.isOpen();if(!u){i._bShowMenu=true}else{i._bHideMenu=true}}else if(l.isOfType(t.CELLTYPE.ANYCONTENTCELL)){i._bShowMenu=true}else{i._bShowDefaultMenu=true}}},onmouseup:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId)},ondblclick:function(e){if(o.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();f.doAutoResizeColumn(this,this._iLastHoveredVisibleColumnIndex)}},ontap:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);if(e.isMarked()){return}var i=jQuery(e.target);var o=t.getCell(this,e.target);var n=t.getCellInfo(o);var l=this.getRows()[n.rowIndex];if(!n.isOfType(t.CELLTYPE.ANY)){return}if(n.isOfType(t.CELLTYPE.COLUMNHEADER)){var r=this._getPointerExtension();if(r._bShowMenu){t.Menu.openContextMenu(this,e);delete r._bShowMenu}}else if(n.isOfType(t.CELLTYPE.COLUMNROWHEADER)){this._getSelectionPlugin().onHeaderSelectorPress()}else if(l&&l.isSummary()){e.preventDefault()}else if(i.hasClass("sapUiTableGroupMenuButton")){t.Menu.openContextMenu(this,e)}else if(i.hasClass("sapUiTableGroupIcon")||i.hasClass("sapUiTableTreeIcon")){l.toggleExpandedState()}else{if(d._skipClick(e,i,n)){return}var a=window.getSelection().toString();if(!e.shiftKey&&a.length>0&&a!=="\n"){s.debug("DOM Selection detected -> Click event on table skipped, Target: "+e.target);return}if(!this._findAndfireCellEvent(this.fireCellClick,e)){d._handleClickSelection(e,o,this)}else{e.preventDefault()}}},oncontextmenu:function(e){var i=this._getPointerExtension();if(i._bShowDefaultMenu){e.setMarked("sapUiTableHandledByPointerExtension");delete i._bShowDefaultMenu}else if(i._bShowMenu){var o=t.Menu.openContextMenu(this,e);if(o){e.preventDefault()}e.setMarked("sapUiTableHandledByPointerExtension");delete i._bShowMenu}else if(i._bHideMenu){e.setMarked("sapUiTableHandledByPointerExtension");e.preventDefault();delete i._bHideMenu}}};var v=e.extend("sap.ui.table.extensions.Pointer",{_init:function(i,o,n){this._delegate=C;t.addDelegate(i,this._delegate,i);i._iLastHoveredVisibleColumnIndex=0;i._bIsColumnResizerMoving=false;i._iFirstReorderableIndex=o==e.TABLETYPES.TREE?1:0;return"PointerExtension"},_attachEvents:function(){var e=this.getTable();if(e){f.initColumnTracking(e);c.initRowHovering(e)}},_detachEvents:function(){var e=this.getTable();if(e){var t=e.$();t.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").off();t.find(".sapUiTableCtrl > tbody > tr").off();t.find(".sapUiTableRowSelectionCell").off()}},_debug:function(){this._ExtensionHelper=d;this._ColumnResizeHelper=f;this._ReorderHelper=h;this._ExtensionDelegate=C;this._RowHoverHandler=c;this._KNOWNCLICKABLECONTROLS=u},doAutoResizeColumn:function(e){var t=this.getTable();if(t){f.doAutoResizeColumn(t,e)}},doReorderColumn:function(e,i){var o=this.getTable();if(o&&t.Column.isColumnMovable(o.getColumns()[e])){o._mTimeouts.delayedColumnReorderTimerId=setTimeout(function(){h.initReordering(this,e,i)}.bind(o),200)}},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate)}this._delegate=null;e.prototype.destroy.apply(this,arguments)}});return v});
//# sourceMappingURL=Pointer.js.map