/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarAppointment","sap/ui/unified/CalendarLegendRenderer","sap/ui/Device","sap/ui/unified/library","sap/ui/core/InvisibleText","sap/ui/core/date/UI5Date","sap/base/Log","sap/ui/core/IconPool"],function(e,t,a,n,r,i,s,l){"use strict";var o=r.CalendarDayType;var p=r.CalendarIntervalType;var d=r.CalendarAppointmentVisualization;var g=r.CalendarAppointmentHeight;var c={apiVersion:2};c.render=function(e,t){var a=t.getTooltip_AsString();var r=t.getAppointmentsVisualization();var i=this.getLegendItems(t);e.openStart("div",t);e.class("sapUiCalendarRow");if(!n.system.phone&&t.getAppointmentsReducedHeight()){e.class("sapUiCalendarRowAppsRedHeight")}if(r!=d.Standard){e.class("sapUiCalendarRowVis"+r)}if(a){e.attr("title",a)}var s=t.getWidth();if(s){e.style("width",s)}var l=t.getHeight();if(l){e.style("height",l)}e.accessibilityState(t,{role:"row"});e.openEnd();this.renderAppointmentsRow(e,t,i);e.close("div")};c.renderAppointmentsRow=function(e,t,a){var n=t.getId();e.openStart("div",n+"-Apps");e.class("sapUiCalendarRowApps");e.attr("role","list");e.openEnd();this.renderBeforeAppointments(e,t);this.renderAppointments(e,t,a);this.renderAfterAppointments(e,t);e.close("div")};c.renderBeforeAppointments=function(e,t){};c.renderAfterAppointments=function(e,t){};c.renderResizeHandle=function(e,t,a){};c.renderAppointments=function(t,a,n){var r=a._getVisibleAppointments();var i=a._getVisibleIntervalHeaders();var s=a._getStartDate();var l=[];var o=0;var d=0;var g=[];var c=0;var v=0;var f=a.getIntervals();var u=a.getIntervalType();var A=100/f;var C=0;var T=new e(s);var I=false;var h=false;switch(u){case p.Hour:l=a.getNonWorkingHours()||[];o=s.getUTCHours();d=24;break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":l=a._getNonWorkingDays();o=s.getUTCDay();d=7;g=a.getNonWorkingHours()||[];c=s.getUTCHours();v=24;break;case p.Month:g=a._getNonWorkingDays();c=s.getUTCDay();v=7;break;default:break}if(a._isOneMonthsRowOnSmallSizes()){this.renderSingleDayInterval(t,a,r,n,i,l,o,d,g,c,v,true,true)}else{for(C=0;C<f;C++){if(h){I=true}else{I=false}h=false;switch(u){case p.Hour:T.setUTCHours(T.getUTCHours()+1);if(T.getUTCHours()==0){h=true}break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":T.setUTCDate(T.getUTCDate()+1);if(T.getUTCDate()==1){h=true}break;case p.Month:c=T.getUTCDay();T.setUTCMonth(T.getUTCMonth()+1);if(T.getUTCMonth()==0){h=true}break;default:break}this.renderInterval(t,a,C,A,i,l,o,d,g,c,v,I,h)}this.renderIntervalHeaders(t,a,A,i,f);if(!(a._getRelativeInfo&&a._getRelativeInfo().bIsRelative)){t.openStart("div",a.getId()+"-Now");t.class("sapUiCalendarRowNow");t.openEnd();t.close("div")}for(C=0;C<r.length;C++){var m=r[C];this.renderAppointment(t,a,m,n)}t.openStart("div",a.getId()+"-DummyApp");t.class("sapUiCalendarApp");t.class("sapUiCalendarAppTitleOnly");t.class("sapUiCalendarAppDummy");t.class("sapUiCalendarAppHeight1");t.openEnd();t.close("div")}};c.writeCustomAttributes=function(e,t){};c.renderInterval=function(t,a,n,r,i,l,o,d,g,c,v,f,u,A){var C=a.getId()+"-AppsInt"+n;var T;var I=a.getShowIntervalHeaders()&&(a.getShowEmptyIntervalHeaders()||i.length>0);var h=a.getStartDate().getMonth();var m=s.getInstance(a.getStartDate().getFullYear(),h+1,0).getDate();t.openStart("div",C);t.class("sapUiCalendarRowAppsInt");if(A){t.class(A)}t.style("width",r+"%");if(n>=m&&(a.getIntervalType()===p.OneMonth||a.getIntervalType()==="OneMonth")){t.class("sapUiCalItemOtherMonth")}for(T=0;T<l.length;T++){if((n+o)%d==l[T]){t.class("sapUiCalendarRowAppsNoWork");break}}if(!I){t.class("sapUiCalendarRowAppsIntNoHead")}if(f){t.class("sapUiCalendarRowAppsIntFirst")}if(u){t.class("sapUiCalendarRowAppsIntLast")}this.writeCustomAttributes(t,a);t.openEnd();if(I){t.openStart("div");t.class("sapUiCalendarRowAppsIntHead");t.openEnd();t.close("div")}if(a.getShowSubIntervals()){var U=a.getIntervalType();var b=0;switch(U){case p.Hour:b=4;break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":b=24;break;case p.Month:var S=a._getStartDate();var R=new e(S);R.setUTCMonth(R.getUTCMonth()+n+1,0);b=R.getUTCDate();R.setUTCDate(1);o=R.getUTCDay();break;default:break}var y=100/b;for(T=0;T<b;T++){t.openStart("div");t.class("sapUiCalendarRowAppsSubInt");t.style("width",y+"%");for(var w=0;w<g.length;w++){if((T+c)%v==g[w]){t.class("sapUiCalendarRowAppsNoWork");break}}t.openEnd();t.close("div")}}t.close("div")};c.renderIntervalHeaders=function(e,t,a,n,r){var i=t.getShowIntervalHeaders()&&(t.getShowEmptyIntervalHeaders()||n.length>0);if(i){for(var s=0;s<n.length;s++){var l=n[s],o,p;if(t._bRTL){p=a*l.interval;o=a*(r-l.last-1)}else{o=a*l.interval;p=a*(r-l.last-1)}this.renderIntervalHeader(e,t,l,t._bRTL,o,p)}}};c.renderIntervalHeader=function(e,t,a,n,r,i){var s=a.appointment.getId(),l={labelledby:{value:s+"-Descr",append:true}},p;var d=t._calculateAppoitnmentVisualCue(a.appointment);e.openStart("div",a.appointment);e.class("sapUiCalendarRowAppsIntHead");if(r!==undefined){e.style("left",r+"%")}if(i!==undefined){e.style("right",i+"%")}e.class("sapUiCalendarRowAppsIntHeadFirst");if(a.appointment.getSelected()){e.class("sapUiCalendarRowAppsIntHeadSel")}if(a.appointment.getTentative()){e.class("sapUiCalendarRowAppsIntHeadTent")}var g=a.appointment.getTooltip_AsString();if(g){e.attr("title",g)}var c=a.appointment.getType();var v=a.appointment.getColor();if(!v&&c&&c!=o.None){e.class("sapUiCalendarRowAppsIntHead"+c)}if(v){if(n){e.style("border-right-color",v)}else{e.style("border-left-color",v)}}e.accessibilityState(a.appointment,l);e.openEnd();e.openStart("div");e.class("sapUiCalendarIntervalHeaderCont");if(v){e.style("background-color",a.appointment._getCSSColorForBackground(v))}e.openEnd();if(d.appTimeUnitsDifRowStart>0){e.icon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null,role:"img"})}var f=a.appointment.getIcon();if(f){var u=["sapUiCalendarRowAppsIntHeadIcon"];var A={};A["id"]=s+"-Icon";A["title"]=null;A["alt"]=null;A["role"]="presentation";e.icon(f,u,A)}var C=a.appointment.getTitle();if(C){e.openStart("span",s+"-Title");e.class("sapUiCalendarRowAppsIntHeadTitle");e.openEnd();e.text(C);e.close("span")}var T=a.appointment.getText();if(T){e.openStart("span",s+"-Text");e.class("sapUiCalendarRowAppsIntHeadText");e.openEnd();e.text(T);e.close("span")}if(d.appTimeUnitsDifRowEnd>0){e.icon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null,role:"img"})}p=t._oRb.getText("CALENDAR_START_TIME")+": "+t._oFormatAria.format(a.appointment.getStartDate())+"; "+t._oRb.getText("CALENDAR_END_TIME")+": "+t._oFormatAria.format(a.appointment.getEndDate());if(c&&c!==o.None){p+="; "+this.getAriaTextForType(c,this.getLegendItems(t))}e.openStart("span",s+"-Descr");e.class("sapUiInvisibleText");e.openEnd();e.text(p);e.close("span");e.close("div");e.close("div")};c.renderAppointment=function(e,t,a,n,r){var s=a.appointment;var l=s.getTooltip_AsString();var p=s.getType();var c=s.getColor();var v=s.getTitle();var f=s.getText();var u=s.getDescription();var A=s.getIcon();var C=s.getId();var T=t._getAppointmentReducedHeight(a);var I={role:"listitem",labelledby:{value:i.getStaticId("sap.ui.unified","APPOINTMENT")+" "+C+"-Descr",append:true},selected:null};var h=t._getAppointmentRowCount(a,T);var m=t.getAriaLabelledBy();var U=t._calculateAppoitnmentVisualCue(s);if(m.length>0){I["labelledby"].value=I["labelledby"].value+" "+m.join(" ")}if(v){I["labelledby"].value=I["labelledby"].value+" "+C+"-Title"}if(f){I["labelledby"].value=I["labelledby"].value+" "+C+"-Text"}e.openStart("div",s);e.class("sapUiCalendarApp");e.class("sapUiCalendarAppHeight"+h);if(s.getSelected()){e.class("sapUiCalendarAppSel");I["labelledby"].value=i.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED")+" "+I["labelledby"].value}else{I["labelledby"].value=i.getStaticId("sap.ui.unified","APPOINTMENT_UNSELECTED")+" "+I["labelledby"].value}if(s.getTentative()){e.class("sapUiCalendarAppTent");I["labelledby"].value=I["labelledby"].value+" "+i.getStaticId("sap.ui.unified","APPOINTMENT_TENTATIVE")}if(h===1){e.class("sapUiCalendarAppTitleOnly")}if(A){e.class("sapUiCalendarAppWithIcon")}if(!r){if(t._bRTL){e.style("right",a.begin+"%");e.style("left",a.end+"%")}else{e.style("left",a.begin+"%");e.style("right",a.end+"%")}}e.attr("data-sap-level",a.level);if(t._sFocusedAppointmentId==C){e.attr("tabindex","0")}else{e.attr("tabindex","-1")}if(l){e.attr("title",l)}if(!c&&p&&p!=o.None){e.class("sapUiCalendarApp"+p)}if(c){if(t._bRTL){e.style("border-right-color",c)}else{e.style("border-left-color",c)}}e.accessibilityState(s,I);e.openEnd();e.openStart("div");e.class("sapUiCalendarAppCont");if(c&&t.getAppointmentsVisualization()===d.Filled){e.style("background-color",s._getCSSColorForBackground(c))}e.openEnd();if(s.getCustomContent().length){s.getCustomContent().forEach(function(t){e.renderControl(t)})}else{if(U.appTimeUnitsDifRowStart>0){e.icon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null,role:"img"})}if(A){var b=["sapUiCalendarAppIcon"];var S={};S["id"]=C+"-Icon";S["title"]=null;S["alt"]=null;S["role"]="presentation";e.icon(A,b,S)}e.openStart("div");e.class("sapUiCalendarAppTitleWrapper");e.openEnd();if(v){e.openStart("span",C+"-Title");e.class("sapUiCalendarAppTitle");e.openEnd();e.text(v);e.close("span")}if(f&&a.size!==g.HalfSize){e.openStart("span",C+"-Text");e.class("sapUiCalendarAppText");e.openEnd();e.text(f);e.close("span")}if(u&&a.size!==g.HalfSize&&(a.size!==g.Regular||!f)){e.openStart("span",C+"-Info");e.class("sapUiCalendarAppDescription");e.openEnd();e.text(u);e.close("span")}e.close("div");if(U.appTimeUnitsDifRowEnd>0){e.icon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null,role:"img"})}}var R=t._oRb.getText("CALENDAR_START_TIME")+": "+t._oFormatAria.format(s.getStartDate());R=R+"; "+t._oRb.getText("CALENDAR_END_TIME")+": "+t._oFormatAria.format(s.getEndDate());if(t._getRelativeInfo&&t._getRelativeInfo().bIsRelative){var y=t._getRelativeInfo();R=t._oRb.getText("CALENDAR_START_TIME")+": "+y.intervalLabelFormatter(y._getIndexFromDate(s.getStartDate()));R=R+"; "+t._oRb.getText("CALENDAR_END_TIME")+": "+y.intervalLabelFormatter(y._getIndexFromDate(s.getEndDate()))}if(p&&p!=o.None){R=R+"; "+this.getAriaTextForType(p,n)}e.openStart("span",C+"-Descr");e.class("sapUiInvisibleText");e.openEnd();e.text(R);e.close("span");e.close("div");this.renderResizeHandle(e,t,s);e.close("div")};c.renderSingleDayInterval=function(a,n,r,i,l,o,d,g,c,v,f,u,A){var C=1,T=100,I=n.getId()+"-AppsInt"+C,h,m=n.getShowIntervalHeaders()&&(n.getShowEmptyIntervalHeaders()||l.length>0),U=s.getInstance(n.getStartDate()),b=U.getMonth(),S=s.getInstance(U.getFullYear(),b+1,0).getDate(),R,y=n._getPlanningCalendar(),w,E,D=[];U.setHours(0,0,0,0);w=r.concat(n.getIntervalHeaders().filter(function(e){var t=e.getStartDate().getTime(),a=e.getEndDate().getTime(),n=U.getTime(),r=n+1e3*60*60*24;return!(t>=r||a<=n)}).map(function(e){return{appointment:e,isHeader:true}})).sort(t._getComparer(U));if(y){D=y._getSelectedDates()}a.openStart("div",I);a.class("sapUiCalendarRowAppsInt");a.class("sapUiCalendarMonthRowAppsS");a.style("width",T+"%");if(C>=S&&(n.getIntervalType()===p.OneMonth||n.getIntervalType()==="OneMonth")){a.class("sapUiCalItemOtherMonth")}for(h=0;h<o.length;h++){if((C+d)%g==o[h]){a.class("sapUiCalendarRowAppsNoWork");break}}if(!m){a.class("sapUiCalendarRowAppsIntNoHead")}if(u){a.class("sapUiCalendarRowAppsIntFirst")}if(A){a.class("sapUiCalendarRowAppsIntLast")}a.openEnd();if(m){a.openStart("div");a.class("sapUiCalendarRowAppsIntHead");a.openEnd();a.close("div")}if(D.length>0){var _=0,H=w.length;if(y.getRows()[0]._calculateVisibleAppointments){var N=y.getRows()[0]._calculateVisibleAppointments(D,w);_=N.iStart;H=N.iEnd}for(h=_;h<H;h++){E=w[h];a.openStart("div");a.class("sapUiCalendarAppContainer");a.openEnd();a.openStart("div");a.class("sapUiCalendarAppContainerLeft");a.openEnd();a.openStart("div");a.class("sapUiCalendarAppStart");a.openEnd();a.text(E.appointment._getDateRangeIntersectionText(U).start);a.close("div");a.openStart("div");a.class("sapUiCalendarAppEnd");a.openEnd();a.text(E.appointment._getDateRangeIntersectionText(U).end);a.close("div");a.close("div");a.openStart("div");a.class("sapUiCalendarAppContainerRight");a.openEnd();if(E.isHeader){this.renderIntervalHeader(a,n,E)}else{this.renderAppointment(a,n,E,i,true)}a.close("div");a.close("div")}}if(r.length===0||D.length===0){a.openStart("div");a.class("sapUiCalendarNoApps");a.openEnd();var x=sap.ui.getCore().byId(n.getAssociation("row"));R=x.getNoAppointmentsText()?x.getNoAppointmentsText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PLANNINGCALENDAR_ROW_NO_APPOINTMENTS");a.text(R);a.close("div")}if(!(n._getRelativeInfo&&n._getRelativeInfo().bIsRelative)){a.openStart("div",n.getId()+"-Now");a.class("sapUiCalendarRowNow");a.openEnd()}a.close("div");a.openStart("div",n.getId()+"-DummyApp");a.class("sapUiCalendarApp");a.class("sapUiCalendarAppTitleOnly");a.class("sapUiCalendarAppDummy");a.style("margin","0");a.style("height","0px");a.openEnd();a.close("div");if(n.getShowSubIntervals()){var M=n.getIntervalType();var k=0;switch(M){case p.Hour:k=4;break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":k=24;break;case p.Month:var L=new e(U);L.setUTCMonth(L.getUTCMonth()+C+1,0);k=L.getUTCDate();L.setUTCDate(1);d=L.getUTCDay();break;default:break}var O=100/k;for(h=0;h<k;h++){a.openStart("div");a.class("sapUiCalendarRowAppsSubInt");a.style("width",O+"%");for(var F=0;F<c.length;F++){if((h+v)%f==c[F]){a.class("sapUiCalendarRowAppsNoWork");break}}a.openEnd();a.close("div")}}a.close("div")};c.getLegendItems=function(e){var t=[],a,n=e.getLegend();if(n){a=sap.ui.getCore().byId(n);if(a){t=a.getItems()}else{l.error("CalendarLegend with id '"+n+"' does not exist!",e)}}return t};c.getAriaTextForType=function(e,t){var n,r,i,s;if(t&&t.length){for(var s=0;s<t.length;s++){i=t[s];if(i.getType()===e){n=i.getText();break}}}if(!n){r=a.getTypeAriaText(e);if(r){n=r.getText()}}return n};return c},true);
//# sourceMappingURL=CalendarRowRenderer.js.map