/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/CalendarLegend","sap/ui/unified/CalendarLegendRenderer","sap/ui/core/library","sap/ui/unified/library","sap/base/Log","sap/ui/core/InvisibleText","sap/ui/core/date/UI5Date","sap/ui/core/Configuration"],function(e,a,t,i,r,n,s,d,l,o){"use strict";var c=n.CalendarDayType;var p=r.CalendarType;var y={apiVersion:2};y.render=function(e,a){var t=this.getStartDate(a),i=a.getTooltip_AsString(),r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),n=a.getId(),s={value:"",append:true},l="",o=a.getWidth();e.openStart("div",a);this.getClass(e,a).forEach(function(a){e.class(a)});if(a._getSecondaryCalendarType()){e.class("sapUiCalMonthSecType")}this.addWrapperAdditionalStyles(e,a);if(i){e.attr("title",i)}if(a._getShowHeader()){s.value=s.value+" "+n+"-Head"}if(a._bCalendar){l+=" "+d.getStaticId("sap.ui.unified","CALENDAR_MONTH_PICKER_OPEN_HINT")+" "+d.getStaticId("sap.ui.unified","CALENDAR_YEAR_PICKER_OPEN_HINT")}if(o){e.style("width",o)}e.accessibilityState(a,{role:"grid",roledescription:r.getText("CALENDAR_DIALOG"),multiselectable:!a.getSingleSelection()||a.getIntervalSelection(),labelledby:s,describedby:l});e.openEnd();if(a.getIntervalSelection()){e.openStart("span",n+"-Start");e.style("display","none");e.openEnd();e.text(r.getText("CALENDAR_START_DATE"));e.close("span");e.openStart("span",n+"-End");e.style("display","none");e.openEnd();e.text(r.getText("CALENDAR_END_DATE"));e.close("span")}this.renderMonth(e,a,t);e.close("div")};y.addWrapperAdditionalStyles=function(){};y.getStartDate=function(e){return e._getDate()};y.getClass=function(e,a){var t=["sapUiCalMonthView"],i=a.getPrimaryCalendarType(),r=a.getShowWeekNumbers();if(i===p.Islamic||!r){t.push("sapUiCalNoWeekNum")}return t};y.renderMonth=function(e,a,t){this.renderHeader(e,a,t);this.renderDays(e,a,t)};y.renderHeader=function(e,a,t){var i=a._getLocaleData();var r=a._getFirstDayOfWeek();this.renderHeaderLine(e,a,i,t);e.openStart("div");e.accessibilityState(null,{role:"row"});e.style("overflow","hidden");e.openEnd();this.renderDayNames(e,a,i,r,7,true,undefined);e.close("div")};y.renderHeaderLine=function(a,t,i,r){e._checkCalendarDate(r);if(t._getShowHeader()){var n=t.getId();var s=t.getPrimaryCalendarType();var d=i.getMonthsStandAlone("wide",s);a.openStart("div",n+"-Head");a.class("sapUiCalHeadText");a.openEnd();a.text(d[r.getMonth()]);a.close("div")}};y.renderDayNames=function(e,a,t,i,r,n,s){var d=a._getFirstDayOfWeek();var l=a.getId();var o="";var c=a.getPrimaryCalendarType();var y=[];if(a._bLongWeekDays||!a._bNamesLengthChecked){y=t.getDaysStandAlone("abbreviated",c)}else{y=t.getDaysStandAlone("narrow",c)}var g=t.getDaysStandAlone("wide",c);if(a.getShowWeekNumbers()&&c!==p.Islamic){this.renderDummyCell(e,"sapUiCalWH",true,"columnheader")}for(var f=0;f<r;f++){if(n){o=l+"-WH"+(f+d)%7}else{o=l+"-WH"+f}e.openStart("div",o);e.class("sapUiCalWH");if(f===0){e.class("sapUiCalFirstWDay")}if(s){e.style("width",s)}e.accessibilityState(null,{role:"columnheader",label:g[(f+i)%7]});e.openEnd();e.text(y[(f+i)%7]);e.close("div")}};y.renderDays=function(a,t,i){var r,n,s,d,l,o,c;e._checkCalendarDate(i);if(!i){i=t._getFocusedDate()}o=i.toUTCJSDate().getTime();if(!o&&o!==0){throw new Error("Date is invalid "+t)}d=this.getDayHelper(t,i);n=t._getVisibleDays(i,true);c=t.getShowWeekNumbers();r=t.getPrimaryCalendarType()!==p.Islamic&&c;s=n.length;for(l=0;l<s;l++){if(l%7===0){a.openStart("div");a.attr("role","row");a.openEnd();if(r){this._renderWeekNumber(a,n[l],d,t)}}this.renderDay(a,t,n[l],d,true,r,-1);if(l%7===6||l===s-1){a.close("div")}}if(s===28){this.renderDummyCell(a,"sapUiCalItem",false,"")}};y.renderDummyCell=function(e,a,t,i){e.openStart("div");e.class(a);e.class("sapUiCalDummy");e.style("visibility",t?"visible":"hidden");e.attr("role",i);e.attr("aria-label",sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_WEEK"));e.openEnd();e.close("div")};y.getDayHelper=function(e,i){var r,n,d=e._getLocaleData(),o={sLocale:e._getLocale(),oLocaleData:d,iMonth:i.getMonth(),iYear:i.getYear(),iFirstDayOfWeek:e._getFirstDayOfWeek(),iWeekendStart:d.getWeekendStart(),iWeekendEnd:d.getWeekendEnd(),aNonWorkingDays:e._getNonWorkingDays(),sToday:d.getRelativeDay(0),oToday:a.fromLocalJSDate(l.getInstance(),e.getPrimaryCalendarType()),sId:e.getId(),oFormatLong:e._getFormatLong(),sPrimaryCalendarType:e.getPrimaryCalendarType(),sSecondaryCalendarType:e._getSecondaryCalendarType(),oLegend:undefined};n=e.getLegend();if(n&&typeof n==="string"){r=sap.ui.getCore().byId(n);if(r){if(!(r instanceof t)){throw new Error(r+" is not an sap.ui.unified.CalendarLegend. "+e)}o.oLegend=r}else{s.warning("CalendarLegend "+n+" does not exist!",e)}}return o};y.renderDay=function(t,r,n,s,d,l,o,p,y){e._checkCalendarDate(n);var g=new a(n,s.sSecondaryCalendarType),f={role:r._getAriaRole(),selected:false,label:"",describedby:""},u=n._bBeforeFirstYear,D="",C=s.oLegend,b;var S=r._oFormatYyyymmdd.format(n.toUTCJSDate(),true);var m=n.getDay();var h=r._checkDateSelected(n);var v=r._getDateTypes(n);var W=s&&s.oLegend?s.oLegend._getSpecialDateTypeFilter():"";var _=r._checkDateEnabled(n);var E=0;var k=r._isSpecialDateMarkerEnabled(n);if(u){_=false}t.openStart("div",s.sId+"-"+S);t.class("sapUiCalItem");t.class("sapUiCalWDay"+m);if(p){t.style("width",p)}if(m===s.iFirstDayOfWeek){t.class("sapUiCalFirstWDay")}if(d&&s.iMonth!==n.getMonth()){t.class("sapUiCalItemOtherMonth");f["disabled"]=true}if(n.isSame(s.oToday)){t.class("sapUiCalItemNow");f["label"]=s.sToday+" "}if(h>0){t.class("sapUiCalItemSel");f["selected"]=true}else{f["selected"]=false}if(h===2){t.class("sapUiCalItemSelStart");f["describedby"]=f["describedby"]+" "+s.sId+"-Start"}else if(h===3){t.class("sapUiCalItemSelEnd");f["describedby"]=f["describedby"]+" "+s.sId+"-End"}else if(h===4){t.class("sapUiCalItemSelBetween")}else if(h===5){t.class("sapUiCalItemSelStart");t.class("sapUiCalItemSelEnd");f["describedby"]=f["describedby"]+" "+s.sId+"-Start";f["describedby"]=f["describedby"]+" "+s.sId+"-End"}if(this.renderWeekNumbers&&r._oDate){f["describedby"]=f["describedby"]+" "+r.getId()+"-week-"+r._calculateWeekNumber(n)+"-text"}if(k){v.forEach(function(e){if(e.type!==c.None){if(e.type===c.NonWorking){t.class("sapUiCalItemWeekEnd");b=this._addNonWorkingDayText(f);return}if(W===""||W===c.None||W===e.type){t.class("sapUiCalItem"+e.type);D=e.type;if(e.tooltip){t.attr("title",e.tooltip)}}}}.bind(this))}if(!b){if(s.aNonWorkingDays){s.aNonWorkingDays.forEach(function(e){if(n.getDay()===e){this._addNonWorkingDayText(f)}}.bind(this))}else if(n.getDay()===s.iWeekendStart||n.getDay()===s.iWeekendEnd){this._addNonWorkingDayText(f)}}if((r.getParent()&&r.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval"||r.getMetadata().getName()==="sap.ui.unified.calendar.OneMonthDatesRow")&&r.getStartDate()&&s.iMonth!==n.getMonth()){t.class("sapUiCalItemOtherMonth")}if(!_){t.class("sapUiCalItemDsbl");f["disabled"]=true}if(s.aNonWorkingDays){for(E=0;E<s.aNonWorkingDays.length;E++){if(m===s.aNonWorkingDays[E]){t.class("sapUiCalItemWeekEnd");break}}}else if(m>=s.iWeekendStart&&m<=s.iWeekendEnd||s.iWeekendEnd<s.iWeekendStart&&(m>=s.iWeekendStart||m<=s.iWeekendEnd)){t.class("sapUiCalItemWeekEnd")}t.attr("tabindex","-1");t.attr("data-sap-day",S);if(y){f["label"]=f["label"]+s.aWeekDaysWide[m]+" "}f["label"]=f["label"]+s.oFormatLong.format(n.toUTCJSDate(),true);if(D!==""){i.addCalendarTypeAccInfo(f,D,C)}if(s.sSecondaryCalendarType){f["label"]=f["label"]+" "+r._oFormatSecondaryLong.format(g.toUTCJSDate(),true)}t.accessibilityState(null,f);t.openEnd();if(v[0]&&k){t.openStart("div");t.class("sapUiCalSpecialDate");if(v[0].color&&(W===""||W===c.None)){t.style("background-color",v[0].color)}t.openEnd();t.close("div")}t.openStart("span");t.class("sapUiCalItemText");if(v[0]&&v[0].color){t.class("sapUiCalItemTextCustomColor")}t.openEnd();if(!u){t.text(n.getDate())}t.close("span");if(y){t.openStart("span");t.class("sapUiCalDayName");t.openEnd();t.text(s.aWeekDays[m]);t.close("span")}if(s.sSecondaryCalendarType){t.openStart("span");t.class("sapUiCalItemSecText");t.openEnd();t.text(g.getDate());t.close("span")}t.close("div")};y._addNonWorkingDayText=function(e){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("LEGEND_NON_WORKING_DAY")+" ";e["label"]+=a;return a};y._renderWeekNumber=function(e,a,t,i){var r=i._calculateWeekNumber(a);var n=t.sId+"-WNum-"+r;e.openStart("div",n);e.class("sapUiCalWeekNum");e.accessibilityState(null,{role:"rowheader",labelledby:d.getStaticId("sap.ui.unified","CALENDAR_WEEK")+" "+n});e.openEnd();e.text(r);e.close("div")};return y},true);
//# sourceMappingURL=MonthRenderer.js.map