//@ui5-bundle sap/ui/unified/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/Calendar", ["sap/ui/core/CalendarType","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/LocaleData","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/DateTypeRange","./calendar/Header","./calendar/Month","./calendar/MonthPicker","./calendar/YearPicker","./calendar/YearRangePicker","./calendar/CalendarDate","sap/ui/core/date/UniversalDate","sap/ui/core/date/UI5Date","./library","sap/ui/Device","sap/ui/core/format/DateFormat","sap/ui/core/ResizeHandler","sap/ui/core/Locale","sap/ui/events/KeyCodes","./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/core/Configuration","sap/ui/core/date/CalendarWeekNumbering"],function(e,t,a,i,r,s,o,n,h,g,l,d,u,c,_,p,f,D,y,m,M,P,v,C,S,T){"use strict";var k=t.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true},showCurrentDateButton:{type:"boolean",group:"Behavior",defaultValue:false},_currentPicker:{type:"string",group:"Appearance",visibility:"hidden"},calendarWeekNumbering:{type:"sap.ui.core.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null},initialFocusedDate:{type:"object",group:"Data",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},yearRangePicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}},renderer:M});var Y={MONTH:"month",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker",YEAR_RANGE_PICKER:"yearRangePicker"};k.prototype.init=function(){this._iBreakPointTablet=p.media._predefinedRangeSets[p.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=p.media._predefinedRangeSets[p.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=p.media._predefinedRangeSets[p.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];this._iColumns=1;this.setProperty("_currentPicker",Y.MONTH_PICKER);this._oYearFormat=f.getDateInstance({format:"y",calendarType:this._getPrimaryCalendarType()});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=r._minDate(this._getPrimaryCalendarType());this._oMaxDate=r._maxDate(this._getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var e=this._createMonth(this.getId()+"--Month0");e.attachEvent("focus",this._handleFocus,this);e.attachEvent("select",R,this);e.attachEvent("_renderMonth",B,this);e.attachEvent("_bindMousemove",L,this);e.attachEvent("_unbindMousemove",N,this);e._bNoThemeChange=true;this.addAggregation("month",e);this._initializeMonthPicker();this._initializeYearPicker();this._initializeYearRangePicker();this._resizeProxy=A.bind(this);this._oSelectedMonth;this._bSkipCancelButtonRendering=false;this._bActionTriggeredFromSecondHeader=false};k.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth)}if(this._afterHeaderRenderAdjustCSS){this.removeDelegate(this._afterHeaderRenderAdjustCSS);this._afterHeaderRenderAdjustCSS=null}if(this._afterSecondHeaderRenderAdjustCSS){this.removeDelegate(this._afterSecondHeaderRenderAdjustCSS);this._afterSecondHeaderRenderAdjustCSS=null}if(this._sResizeListener){D.deregister(this._sResizeListener);this._sResizeListener=undefined}this._oSelectedMonth=null};k.prototype._initializeHeader=function(){var e=new o(this.getId()+"--Head");e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);e.attachEvent("pressCurrentDate",this._handleCurrentDate,this);e.attachEvent("pressButton1",this._handleButton1,this);e.attachEvent("pressButton2",this._handleButton2,this);e.attachEvent("pressButton3",this._handleButton1,this);e.attachEvent("pressButton4",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(e);e.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",e)};k.prototype._createOnAfterRenderingDelegate=function(e){return{onAfterRendering:function(){if(e.getVisible()&&!e.getVisibleButton1()){e.$().find(".sapUiCalHeadB2").addClass("sapUiCalSingleYearButton")}if(e.getVisible()&&!e._getVisibleButton3()){this._isTwoMonthsInTwoColumns()&&e.$().find(".sapUiCalHeadB4").addClass("sapUiCalSingleYearButton")}}.bind(this)}};k.prototype._initializeSecondMonthHeader=function(){var e=new o(this.getId()+"--SecondMonthHead",{visible:false});e.addStyleClass("sapUiCalHeadSecondMonth");e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);e.attachEvent("pressButton1",this._handleButton1,this);e.attachEvent("pressButton2",this._handleButton2,this);this._afterSecondHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(e);e.addDelegate(this._afterSecondHeaderRenderAdjustCSS);this.setAggregation("secondMonthHeader",e)};k.prototype._initializeMonthPicker=function(){var e=new h(this.getId()+"--MP");e._bCalendar=true;e.attachEvent("select",this._selectMonth,this);e.attachEvent("pageChange",I,this);e._bNoThemeChange=true;this.setAggregation("monthPicker",e);e._setSelectedDatesControlOrigin(this)};k.prototype._initializeYearPicker=function(){var e=new g(this.getId()+"--YP");e._bCalendar=true;e.attachEvent("select",this._selectYear,this);e.attachEvent("pageChange",E,this);this.setAggregation("yearPicker",e);e._setSelectedDatesControlOrigin(this)};k.prototype._initializeYearRangePicker=function(){var e=new l(this.getId()+"--YRP");e.attachEvent("select",this._selectYearRange,this);e.setPrimaryCalendarType(this._getPrimaryCalendarType());this.setAggregation("yearRangePicker",e)};k.prototype._createMonth=function(e){var t=new n(e,{width:"100%",calendarWeekNumbering:this.getCalendarWeekNumbering()});t._bCalendar=true;t.attachEvent("datehovered",this._handleDateHovered,this);t.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return t};k.prototype._handleWeekNumberSelect=function(e){var t=e.getParameter("weekDays"),a=this.fireWeekNumberSelect({weekNumber:e.getParameter("weekNumber"),weekDays:t});this._focusDate(d.fromLocalJSDate(t.getStartDate(),this._getPrimaryCalendarType()),true,false,false);if(!a){e.preventDefault()}return this};k.prototype._handleDateHovered=function(e){var t=this.getAggregation("month"),a=e.getParameter("date1"),i=e.getParameter("date2"),r;for(r=0;r<t.length;r++){t[r]._markDatesBetweenStartAndHoveredDate(a,i)}};k.prototype.onBeforeRendering=function(){var e=this.getAggregation("month"),t,a=e[0].getDate(),i=this._getFocusedDate();if(this.getFirstDayOfWeek()!==-1&&this.getCalendarWeekNumbering()!=="Default"){C.warning("Both properties firstDayOfWeek and calendarWeekNumbering should not be used at the same time!")}if(e.length>1&&a){t=d.fromLocalJSDate(a,this._getPrimaryCalendarType())}else if(e.length>1){t=w.call(this,this._getFocusedDate())}else{t=i}for(var r=0;r<e.length;r++){a=new d(t);if(r>0){a.setMonth(a.getMonth()+r,1)}var s=a;if(i.getYear()===a.getYear()&&i.getMonth()===a.getMonth()){s=i}e[r].displayDate(s.toLocalJSDate());e[r].setShowWeekNumbers(this.getShowWeekNumbers())}if(this._getMonthPicker()){this._setDisabledMonths(i.getYear(),this._getMonthPicker())}this._updateHeader(t);this._updateHeadersButtons();this._adjustYearRangeDisplay();this._updateLegendParent();if(this.getInitialFocusedDate()){this.focusDate(this.getInitialFocusedDate())}};k.prototype.onAfterRendering=function(e){if(!this._getSucessorsPickerPopup()){H.call(this)}if(F.call(this)>1||this._bInitMonth){e.size={width:this.getDomRef().offsetWidth};A.call(this,e,true);if(!this._sResizeListener){this._sResizeListener=D.register(this,this._resizeProxy)}this._bInitMonth=undefined}};k.prototype.removeSelectedDate=function(e){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",e)};k.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};k.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};k.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};k.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};k.prototype._setSpecialDatesControlOrigin=function(e){this._oSpecialDatesControlOrigin=e};k.prototype.getSpecialDates=function(){var e=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin.getSpecialDates()}if(e&&e.getSpecialDates){return e.getSpecialDates()}else{return this.getAggregation("specialDates",[])}};k.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("disabledDates");return e};k.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("disabledDates");return e};k.prototype.setLocale=function(e){if(this._sLocale!=e){this._sLocale=e;this._oLocaleData=undefined;this.invalidate();this._toggleTwoMonthsInTwoColumnsCSS()}return this};k.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=S.getFormatSettings().getFormatLocale().toString()}return this._sLocale};k.prototype._getFocusedDate=function(){if(!this._oFocusedDate){b.call(this)}return this._oFocusedDate};k.prototype._setFocusedDate=function(e){r._checkCalendarDate(e);this._oFocusedDate=new d(e,this._getPrimaryCalendarType())};k.prototype.focusDate=function(e){x.call(this,e,false);this._addMonthFocusDelegate();return this};k.prototype.displayDate=function(e){x.call(this,e,true);return this};k.prototype.getStartDate=function(){var e;if(this.getDomRef()){var t=this.getAggregation("month");e=d.fromLocalJSDate(t[0].getDate(),this._getPrimaryCalendarType())}else{e=new d(this._getFocusedDate())}e.setDate(1);return e.toLocalJSDate()};k.prototype.setCalendarWeekNumbering=function(e){var t=this.getAggregation("month");this.setProperty("calendarWeekNumbering",e);for(var a=0;a<t.length;a++){t[a].setProperty("calendarWeekNumbering",e)}return this};k.prototype.setMonths=function(e){this._bDateRangeChanged=undefined;this.setProperty("months",e);e=F.call(this);var t=this.getAggregation("month");var a=0;var i;if(t.length<e){for(a=t.length;a<e;a++){i=this._createMonth(this.getId()+"--Month"+a);i.attachEvent("focus",this._handleFocus,this);i.attachEvent("select",R,this);i.attachEvent("_renderMonth",B,this);i.attachEvent("_bindMousemove",L,this);i.attachEvent("_unbindMousemove",N,this);i._bNoThemeChange=true;i.setCalendarWeekNumbering(this.getCalendarWeekNumbering());i.setSecondaryCalendarType(this._getSecondaryCalendarType());this.addAggregation("month",i)}this._toggleTwoMonthsInTwoColumnsCSS()}else if(t.length>e){for(a=t.length;a>e;a--){i=this.removeAggregation("month",a-1);i.destroy()}if(e==1){this._bInitMonth=true}this._toggleTwoMonthsInTwoColumnsCSS()}if(e>1&&t[0].getDate()){t[0].setProperty("date",null,true)}return this};k.prototype.setPrimaryCalendarType=function(e){var t=this.getAggregation("month"),a,i,r,s,o;this.setProperty("primaryCalendarType",e);this._oYearFormat=f.getDateInstance({format:"y",calendarType:e});if(this._oFocusedDate){this._oFocusedDate=new d(this._oFocusedDate,e)}this._oMinDate=new d(this._oMinDate,e);this._oMaxDate=new d(this._oMaxDate,e);for(o=0;o<t.length;o++){a=t[o];a.setPrimaryCalendarType(e)}if(!this._getSucessorsPickerPopup()){i=this._getMonthPicker();i.setPrimaryCalendarType(e);r=this._getYearPicker();r.setPrimaryCalendarType(e);s=this.getAggregation("yearRangePicker");s.setPrimaryCalendarType(e)}return this};k.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);this._oYearFormatSecondary=f.getDateInstance({format:"y",calendarType:e});var t=this.getAggregation("month");for(var a=0;a<t.length;a++){var i=t[a];i.setSecondaryCalendarType(e)}this._getMonthPicker().setSecondaryCalendarType(e);this._getYearPicker().setSecondaryCalendarType(e);this._getYearRangePicker().setSecondaryCalendarType(e);return this};k.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||S.getCalendarType()};k.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};k.prototype._getActiveHeaderAggregation=function(){if(this._bActionTriggeredFromSecondHeader&&this._isTwoMonthsInOneColumn()){return this.getAggregation("secondMonthHeader")}else{return this.getAggregation("header")}};k.prototype._saveTriggeredHeader=function(e){if(e.getSource().sParentAggregationName==="secondMonthHeader"||e.sId==="pressButton3"||e.sId==="pressButton4"){this._bActionTriggeredFromSecondHeader=true}else{this._bActionTriggeredFromSecondHeader=false}};k.prototype.setMinDate=function(e){var t=this.getAggregation("month"),a=this._getPrimaryCalendarType(),i;if(v(e,this.getMinDate())){return this}if(!e){this._oMinDate=r._minDate(a)}else{r._checkJSDateObject(e);this._oMinDate=d.fromLocalJSDate(e,a);var s=this._oMinDate.getYear();r._checkYearInValidRange(s,a);if(this._oMaxDate.isBefore(this._oMinDate)){C.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=d.fromLocalJSDate(e,a);this._oMaxDate.setDate(r._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true)}this._setMinMaxDateExtend(d.fromLocalJSDate(e,a))}this.setProperty("minDate",e,false);if(!this._getSucessorsPickerPopup()){i=this._oMinDate.getYear();this._getYearPicker()._oMinDate.setYear(i);this._getYearRangePicker()._oMinDate.setYear(i)}for(var o=0;o<t.length;o++){t[o]._oMinDate=new d(this._oMinDate)}return this};k.prototype.setMaxDate=function(e){var t=this.getAggregation("month"),a=this._getPrimaryCalendarType(),i;if(v(e,this.getMaxDate())){return this}if(!e){this._oMaxDate=r._maxDate(a)}else{r._checkJSDateObject(e);this._oMaxDate=d.fromLocalJSDate(e,a);var s=this._oMaxDate.getYear();r._checkYearInValidRange(s,a);if(this._oMinDate.isAfter(this._oMaxDate)){C.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=d.fromLocalJSDate(e,a);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true)}this._setMinMaxDateExtend(d.fromLocalJSDate(e,a))}this.setProperty("maxDate",e,false);if(!this._getSucessorsPickerPopup()){i=this._oMaxDate.getYear();this._getYearPicker()._oMaxDate.setYear(i);this._getYearRangePicker()._oMaxDate.setYear(i)}for(var o=0;o<t.length;o++){t[o]._oMaxDate=new d(this._oMaxDate)}return this};k.prototype.setShowCurrentDateButton=function(e){this.getAggregation("header").setVisibleCurrentDateButton(e);return this.setProperty("showCurrentDateButton",e)};k.prototype._setMinMaxDateExtend=function(e){if(this._oFocusedDate){if(r._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){C.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+e.toString(),this);this.focusDate(e.toLocalJSDate())}}};k.prototype._getLocaleData=function(){if(!this._oLocaleData){var e=this.getLocale();var t=new y(e);this._oLocaleData=i.getInstance(t)}return this._oLocaleData};k.prototype._getShowMonthHeader=function(){var e=F.call(this);if(e>2){return true}else{return false}};k.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker")};k.prototype._getYearPicker=function(){return this.getAggregation("yearPicker")};k.prototype._getYearRangePicker=function(){return this.getAggregation("yearRangePicker")};k.prototype.onclick=function(e){var t=e.target;if(e.isMarked("delayedMouseEvent")){return}if(t.id==this.getId()+"-cancel"){this.onsapescape(e)}};k.prototype.onmousedown=function(e){if(e.cancelable){e.preventDefault()}e.setMark("cancelAutoClose")};k.prototype.onsapescape=function(e){this.fireCancel();this._closePickers();this._addMonthFocusDelegate();if(!this._getSucessorsPickerPopup()){this._setHeaderText(this._getFocusedDate())}};k.prototype.onsapshow=function(e){var t=e.which||e.keyCode;if(this._bPoupupMode&&t!==m.F4){this._closePickers();this._addMonthFocusDelegate();this.fireCancel();e.preventDefault()}};k.prototype.onkeydown=function(e){var t=e.which||e.keyCode,a=e.shiftKey;if(t!==m.F4){return}e.preventDefault();switch(this._iMode){case 0:if(a){this._showYearPicker()}else{this._showMonthPicker()}break;case 1:if(a){this._showYearPicker()}break;case 2:if(a){this._showYearRangePicker()}break;default:}};k.prototype.onsaphide=k.prototype.onsapshow;k.prototype.getFocusDomRef=function(){var e=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0],t=this._getMonthPicker(),a=this._getYearPicker(),i=this._getYearRangePicker();switch(this._iMode){case 0:return e.getFocusDomRef();case 1:return t.getFocusDomRef();case 2:return a.getFocusDomRef();case 3:return i.getFocusDomRef();default:return}};k.prototype.onThemeChanged=function(){var e,t=arguments;if(!this.getDomRef()){return}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){var a={onAfterRendering:function(){e.onThemeChanged(t);e._bNoThemeChange=true;H.call(this);this._bLongMonth=e._bLongMonth;this._closePickers();e.removeEventDelegate(a)}};e=this._getMonthPicker();this._showMonthPicker(true);e._bNoThemeChange=false;e.addEventDelegate(a,this)}var i=this.getAggregation("month");for(var r=0;r<i.length;r++){var s=i[r];s._bNoThemeChange=false;s.onThemeChanged(arguments);s._bNoThemeChange=true}var o;if(i.length>1){o=d.fromLocalJSDate(i[0].getDate(),this._getPrimaryCalendarType())}else{o=this._getFocusedDate()}this._setHeaderText(o);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS()};k.prototype._updateLegendParent=function(){var e=this.getLegend(),t=a.byId(e);t&&t._setParent(this)};k.prototype._updateHeader=function(e){this._setHeaderText(e);switch(this._iMode){case 0:this._togglePrevNext(e,true);break;case 1:this._togglePrevNext(e,false);break;case 2:case 3:this._togglePrevNexYearPicker();break}};k.prototype._togglePrevNext=function(e,t){var a=this._oMaxDate.getYear();var i=this._oMinDate.getYear();var s=this._oMaxDate.getMonth();var o=this._oMinDate.getMonth();var n=this.getAggregation("header");var h=F.call(this);var g=new d(e,this._getPrimaryCalendarType());if(this._iMode===1&&h>1){g=w.call(this,e);g.setMonth(g.getMonth()+h-1);g.setDate(r._daysInMonth(g))}else{g.setDate(r._daysInMonth(g))}var l=g.getYear();var u=g.getMonth();if((this._iMode===0||this._iMode===1)&&h>1){u+=h-1}if(l>a||l===a&&(!t||u>=s)||(this._iMode===0||this._iMode===1)&&this._getSucessorsPickerPopup()){n.setEnabledNext(false)}else{n.setEnabledNext(true)}if(this._iMode===1&&h>1){g.setMonth(g.getMonth()-h+1,1)}else{g.setDate(1)}l=g.getYear();u=g.getMonth();if(l<i||l==i&&(!t||u<=o)||this._iMode==1&&this._getSucessorsPickerPopup()){n.setEnabledPrevious(false)}else{n.setEnabledPrevious(true)}};k.prototype._togglePrevNexYearPicker=function(){var e=this.getAggregation("yearRangePicker"),t=this._getYearPicker(),a=this._getPrimaryCalendarType(),i=new d(this._oMinDate,a),r=new d(this._oMaxDate,a),s=this.getAggregation("header"),o=1,n,h,g,l;if(this._iMode===3){g=e.getYears();o=e.getRangeSize();n=new d(e.getProperty("_middleDate"));h=new d(n);n.setYear(n.getYear()-o*g/2);h.setYear(h.getYear()+o*g/2-1)}else{g=t.getYears();l=t.getProperty("_middleDate")?t.getProperty("_middleDate"):d.fromLocalJSDate(c.getInstance());n=new d(l);h=new d(l);n.setYear(n.getYear()-g/2);h.setYear(h.getYear()+g/2-1)}s.setEnabledNext(h.getYear()<r.getYear());s.setEnabledPrevious(n.getYear()>i.getYear())};k.prototype._handlePrevious=function(){var e=this._getFocusedDate(),t=F.call(this),a,i=false;switch(this._iMode){case 0:if(t>1){a=d.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this._getPrimaryCalendarType());a.setDate(1);this._setFocusedDate(a);e=this._getFocusedDate()}else{e.setDate(1)}e.setDate(e.getDate()-1);this._renderMonth(i,false);this._addMonthFocusDelegate();break;case 1:e.setYear(e.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(e.toUTCJSDate(),true));this._updateHeadersYearAdditionalTextHelper();this._togglePrevNext(e);this._setDisabledMonths(e.getYear());var r=this._getMonthPicker();r._setYear(e.getYear());r._setDate(e);r.invalidate();this.setProperty("_currentPicker",Y.MONTH_PICKER);break;case 2:this._getYearPicker().previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());this._updateHeadersYearAdditionalTextHelper();break;case 3:this.getAggregation("yearRangePicker").previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break}};k.prototype._handleNext=function(){var e=this._getFocusedDate(),t=F.call(this),a;switch(this._iMode){case 0:if(t>1){a=d.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this._getPrimaryCalendarType());a.setMonth(a.getMonth(),1);this._setFocusedDate(a);e=this._getFocusedDate()}e.setMonth(e.getMonth()+1,1);this._renderMonth(false,false);this._addMonthFocusDelegate();break;case 1:e.setYear(e.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(e.toUTCJSDate(),true));this._updateHeadersYearAdditionalTextHelper();this._togglePrevNext(e);this._setDisabledMonths(e.getYear());var i=this._getMonthPicker();i._setYear(e.getYear());i._setDate(e);i.invalidate();this.setProperty("_currentPicker",Y.MONTH_PICKER);break;case 2:this._getYearPicker().nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());this._updateHeadersYearAdditionalTextHelper();break;case 3:this.getAggregation("yearRangePicker").nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break}};k.prototype._updateHeadersYearAdditionalTextHelper=function(){if(!this._getSecondaryCalendarType()){return}var e=this._getDisplayedSecondaryYears();if(e.start.getYear()===e.end.getYear()){this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(e.start.toUTCJSDate(),true))}else{var t=this._getLocaleData();var a=t.getIntervalPattern();var i=a.replace(/\{0\}/,this._oYearFormatSecondary.format(e.start.toUTCJSDate(),true)).replace(/\{1\}/,this._oYearFormatSecondary.format(e.end.toUTCJSDate(),true));this._updateHeadersYearAdditionalText(i)}};k.prototype._handleCurrentDate=function(){var e=c.getInstance(),t=this.getMaxDate(),a=this.getMinDate();this.setProperty("_currentPicker",Y.MONTH);if(t&&t.getTime()<e.getTime()){this.focusDate(t)}else if(a&&a.getTime()>e.getTime()){this.focusDate(a)}else{this.focusDate(e)}};k.prototype._getYearString=function(){var e=this._getYearPicker(),t=e.getDomRef(),a=this._getFocusedDate();if(e&&t&&t.style.display===""){a=e.getProperty("_middleDate");a.setDate(1)}return this._oYearFormat.format(u.getInstance(a.toUTCJSDate(),a.getCalendarType()),true)};k.prototype._getDisplayedMonths=function(e){var t=[];var a=e.getMonth();var i=F.call(this);if(i>1){for(var r=0;r<i;r++){t.push((a+r)%12)}}else{t.push(a)}return t};k.prototype._getDisplayedSecondaryMonths=function(){var e=this._getPrimaryCalendarType(),t=this._getSecondaryCalendarType(),a=this.getAggregation("month"),i=d.fromLocalJSDate(a[0].getDate(),e),s=d.fromLocalJSDate(a[a.length-1].getDate(),e),o,n;i.setDate(1);i=new d(i,t);o=i.getMonth();s=d.fromLocalJSDate(a[a.length-1].getDate(),e);s.setDate(r._daysInMonth(s));s=new d(s,t);n=s.getMonth();return{start:o,end:n}};k.prototype._getDisplayedSecondaryYears=function(){var e=this._getPrimaryCalendarType(),t=this._getSecondaryCalendarType(),a,i,s,o,n,h,g;switch(this._iMode){case 0:n=this.getAggregation("month");a=d.fromLocalJSDate(n[0].getDate(),e);a.setDate(1);a=new d(a,t);i=d.fromLocalJSDate(n[n.length-1].getDate(),e);i.setDate(r._daysInMonth(i));i=new d(i,t);break;case 1:s=this._getFocusedDate();o=new d(s,e);o.setMonth(0,1);a=new d(o,e);a=new d(a,t);o.setYear(o.getYear()+1);o.setDate(o.getDate()-1);i=new d(o,e);i=new d(i,t);break;case 2:h=this._getYearPicker();g=h.getYears()/2-1;s=h.getProperty("_middleDate");a=new d(s,e);a.setYear(s.getYear()-g-1);a.setMonth(0,1);a=new d(a,t);i=new d(s,e);i.setYear(i.getYear()+g+1);a.setMonth(0,1);i.setDate(i.getDate()-1);i=new d(i,t);break;default:}return{start:a,end:i}};k.prototype._closePickers=function(){this.setProperty("_currentPicker",Y.MONTH);this._togglePrevNext(this._getFocusedDate(),true);if(this.getAggregation("month").length>1){this.getAggregation("month").forEach(function(e){e._oItemNavigation.iActiveTabIndex=0})}};k.prototype._setDisabledMonths=function(e,t){var a=0;var i=11;if(e===this._oMinDate.getYear()){a=this._oMinDate.getMonth()}if(e===this._oMaxDate.getYear()){i=this._oMaxDate.getMonth()}if(!t){t=this._getMonthPicker()}t.setMinMax(a,i)};k.prototype._handleFocus=function(e){var t=d.fromLocalJSDate(e.getParameter("date"),this._getPrimaryCalendarType()),a=e.getParameter("otherMonth"),i=e.getParameter("restoreOldDate");if(this.getIntervalSelection()){this.getAggregation("month").forEach(function(e){e.setProperty("_focusedDate",t)})}if(i){if(!v(this._getFocusedDate(),t)){this._renderMonth(false,true)}}else{this._focusDate(t,a,false,true)}};k.prototype._getVisibleDays=function(){var e=this.getAggregation("month")[0];return e._getVisibleDays(e._getDate(),false)};k.prototype._renderMonth=function(e,t){var a=this._getFocusedDate(),i=this.getAggregation("month"),s,o,n=w.call(this,new d(a,this._getPrimaryCalendarType())),h=0,g=i[0].checkDateFocusable(a.toLocalJSDate()),l=!t&&!g;for(h=0;h<i.length;h++){s=i[h];o=new d(n,this._getPrimaryCalendarType());o.setMonth(n.getMonth()+h);if(!e&&r._isSameMonthAndYear(o,a)){s.setDate(a.toLocalJSDate())}else{s.displayDate(o.toLocalJSDate())}}this._updateHeader(n);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(l){this.fireStartDateChange()}};k.prototype._updateMonthButtonVisibility=function(){var e=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?e.setVisibleButton1(!e.getVisibleButton1()):e._setVisibleButton3(!e._getVisibleButton3())}else{e.setVisibleButton1(false)}return this};k.prototype._showMonthPicker=function(e){var t=this._getFocusedDate(),a=this._getMonthPicker(),i=new d(this._getFocusedDate());this._updateActiveHeaderYearButtonVisibility();this._updateMonthButtonVisibility();this.setProperty("_currentPicker",Y.MONTH_PICKER);if(this._bActionTriggeredFromSecondHeader){i.setDate(1);i.setMonth(i.getMonth()+1);a._setYear(i.getYear());a._setDate(i)}else{a._setYear(t.getYear());a._setDate(t)}if(!e&&this._bActionTriggeredFromSecondHeader){a.setMonth(i.getMonth());this._setDisabledMonths(i.getYear(),a)}else if(!e){a.setMonth(t.getMonth());this._setDisabledMonths(t.getYear(),a)}if(this.getAggregation("month").length>1&&this.getProperty("_currentPicker")==Y.MONTH_PICKER){this.getAggregation("month").forEach(function(e){e._oItemNavigation.iActiveTabIndex=-1})}this._togglePrevNext(t,true);this._setHeaderText(this._getFocusedDate())};k.prototype._showYearPicker=function(){var e=this._getFocusedDate(),t=this._getYearPicker();this.setProperty("_currentPicker",Y.YEAR_PICKER);t.setDate(e.toLocalJSDate());this._togglePrevNexYearPicker();if(this._isTwoMonthsInOneColumn()){this._updateActiveHeaderYearButtonVisibility()}else{this._updateActiveHeaderYearButtonVisibility()}if(this._bActionTriggeredFromSecondHeader&&this.getAggregation("month")[1].getDate().getFullYear()>this._getFocusedDate().getYear()){var a=e.toLocalJSDate();a.setFullYear(a.getFullYear()+1);t.setDate(a);this._updateHeadersYearPrimaryText(this._getYearString())}else{t.setDate(e.toLocalJSDate());this._updateHeadersYearPrimaryText(this._getYearString())}if(this.getAggregation("month").length>1&&this.getProperty("_currentPicker")==Y.YEAR_PICKER){this.getAggregation("month").forEach(function(e){e._oItemNavigation.iActiveTabIndex=-1})}};k.prototype._focusDate=function(e,t,a,i){var r,s=false,o=false,n=this.getAggregation("month"),h;if(e.isBefore(this._oMinDate)){r=this._oMinDate;s=true}else if(e.isAfter(this._oMaxDate)){r=this._oMaxDate;s=true}else{r=e}if(this._focusDateExtend){o=this._focusDateExtend(e,t,a)}this._setFocusedDate(r);if(i&&!this._focusDateExtend){for(h=0;h<n.length;++h){if(n[h].checkDateFocusable(r.toLocalJSDate())){n[h].setDate(r.toLocalJSDate());n[h]._focusDate(r);return}}}if(s||t){this._renderMonth(false,a);this._addMonthFocusDelegate()}if(o){this.fireStartDateChange()}};k.prototype._setHeaderText=function(e){var t=this.getAggregation("header");var a=this.getAggregation("secondMonthHeader");var i=this._getLocaleData();var r=[];var s=[];var o=[];var n=[];var h;var g=false;var l;var u;var c;var _;var p;var f=this._getPrimaryCalendarType();var D=this._getSecondaryCalendarType();var y="";if(this._bLongMonth||!this._bNamesLengthChecked){r=i.getMonthsStandAlone("wide",f)}else{g=true;r=i.getMonthsStandAlone("abbreviated",f);s=i.getMonthsStandAlone("wide",f)}if(D){o=i.getMonthsStandAlone("abbreviated",D);n=i.getMonthsStandAlone("wide",D);var m=this._getDisplayedSecondaryMonths();if(m.start===m.end){c=o[m.start];y=n[m.start]}else{p=i.getIntervalPattern();c=p.replace(/\{0\}/,o[m.start]).replace(/\{1\}/,o[m.end]);y=p.replace(/\{0\}/,n[m.start]).replace(/\{1\}/,n[m.end])}}t.setAdditionalTextButton1(c);t._setAdditionalTextButton3(c);a.setAdditionalTextButton1(c);var M=this._getDisplayedMonths(e);this._sFirstMonthName=l=r[M[0]];u=r[M[M.length-1]];if(M.length>1&&!this._bShowOneMonth){if(!p){p=i.getIntervalPattern()}c=p.replace(/\{0\}/,l).replace(/\{1\}/,u);h=s.length?p.replace(/\{0\}/,s[M[0]]).replace(/\{1\}/,s[M[M.length-1]]):c;if(this._isTwoMonthsInTwoColumns()||this._isTwoMonthsInOneColumn()){c=l}}else{c=l;h=s[M[0]]||c}if(!this._getSucessorsPickerPopup()&&y){h+=", "+y}t.setTextButton1(c);t.setAriaLabelButton1(h);t._setTextButton3(u);t._setAriaLabelButton3(u);a.setTextButton1(u);a.setAriaLabelButton1(u);var P=new d(e,f);P.setDate(1);_=this._oYearFormat.format(P.toUTCJSDate(),true);if(P.getMonth()===11){this._updateHeadersYearPrimaryText(_,(parseInt(_)+1).toString())}else{this._updateHeadersYearPrimaryText(_,_)}if(D&&this._iMode!==3){this._updateHeadersYearAdditionalTextHelper()}else{this._updateHeadersYearAdditionalText()}return{sMonth:c,sYear:_,sAriaLabel:h,bShort:g}};k.prototype._handleButton1=function(e){if(this._iMode!=1){this._saveTriggeredHeader(e);this._showMonthPicker()}else{this.setProperty("_currentPicker",Y.MONTH);this._addMonthFocusDelegate()}};k.prototype._addMonthFocusDelegate=function(){var e=this.getAggregation("month"),t=e[0].getDate(),a=this._getFocusedDate(),i={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),undefined,true);this.removeDelegate(i)}},r,s;if(e.length>1&&r){t=d.fromLocalJSDate(r,this._getPrimaryCalendarType())}else if(e.length>1){t=w.call(this,this._getFocusedDate())}else{t=a}for(var o=0;o<e.length;o++){r=new d(t);if(o>0){r.setMonth(r.getMonth()+o,1)}if(a.getYear()===r.getYear()&&a.getMonth()===r.getMonth()){s=this.getAggregation("month")[o];s.addDelegate(i,s)}}};k.prototype._handleButton2=function(e){if(this._iMode<=1){this._saveTriggeredHeader(e);this._showYearPicker()}else{this._showYearRangePicker()}};k.prototype._selectMonth=function(){var e=new d(this._getFocusedDate(),this._getPrimaryCalendarType()),t=this._getMonthPicker(),a=t.getProperty("_focusedMonth"),i=a||a===0?a:t.getMonth(),s=d.fromLocalJSDate(c.getInstance(),this._getPrimaryCalendarType());s=t._iYear?s.setYear(t._iYear).setMonth(i-1,1):new d(this._getFocusedDate().getYear(),i-1,1);if(F.call(this)>1){if(this._bActionTriggeredFromSecondHeader&&s.getYear()>=r._minDate(this._getPrimaryCalendarType()).getYear()){e.setYear(s.getYear());i=s.getMonth()}else if(e.getYear()===r._maxDate(this._getPrimaryCalendarType()).getYear()&&i===11){i-=1}}e.setMonth(i);if(i!=e.getMonth()){e.setDate(0)}this._focusDate(e,true,false,false);this._closePickers();this._addMonthFocusDelegate()};k.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup()};k.prototype._selectYear=function(){var e=new d(this._getFocusedDate(),this._getPrimaryCalendarType()),t=e.getMonth(),a=this._getYearPicker(),i=d.fromLocalJSDate(a.getDate(),this._getPrimaryCalendarType());if(!this._bActionTriggeredFromSecondHeader){i.setMonth(t,e.getDate())}else{i.setYear(t===11?i.getYear()-1:i.getYear());i.setMonth(t,e.getDate())}e=i;this._focusDate(e,true,false,false);this._closePickers();this._addMonthFocusDelegate();this._setHeaderText(this._getFocusedDate())};k.prototype.setProperty=function(){var e=arguments[0],a=arguments[1];t.prototype.setProperty.apply(this,arguments);if(e==="_currentPicker"){switch(a){case"month":this._iMode=0;break;case"monthPicker":this._iMode=1;break;case"yearPicker":this._iMode=2;break;case"yearRangePicker":this._iMode=3;break;default:return}}return this};k.prototype._selectYearRange=function(){var e=this.getAggregation("yearRangePicker"),t=this.getAggregation("header"),a=e.getRangeSize(),i=this._getPrimaryCalendarType(),r=d.fromLocalJSDate(e.getDate(),i),s=new d(r.getYear()+a-1,0,1,i),o=this._getFocusedDate(),n,h;o.setYear(r.getYear()+a/2);r.setMonth(0,1);if(o.isBefore(this._oMinDate)){o=new d(this._oMinDate,this._getPrimaryCalendarType())}else if(o.isAfter(this._oMaxDate)){o=new d(this._oMaxDate,this._getPrimaryCalendarType())}this._setFocusedDate(o);this._showYearPicker();n=this._oYearFormat.format(u.getInstance(r.toUTCJSDate(),r.getCalendarType()),true);h=this._oYearFormat.format(u.getInstance(s.toUTCJSDate(),s.getCalendarType()),true);t.setTextButton2(n+" - "+h);t._setTextButton4(n+" - "+h)};k.prototype._showYearRangePicker=function(){var e=this.getAggregation("yearRangePicker"),t=this._getYearPicker(),a=d.fromLocalJSDate(t.getFirstRenderedDate(),this._getPrimaryCalendarType());this.setProperty("_currentPicker",Y.YEAR_RANGE_PICKER);a.setYear(a.getYear()+Math.floor(e.getRangeSize()/2));e.setDate(a.toLocalJSDate());this._togglePrevNexYearPicker()};k.prototype._setColumns=function(e){this._iColumns=e;return this};k.prototype._getColumns=function(){return this._iColumns};k.prototype._updateActiveHeaderYearButtonVisibility=function(){var e=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?e.setVisibleButton1(!e.getVisibleButton1()):e._setVisibleButton3(!e._getVisibleButton3())}else{e.setVisibleButton1(!e.getVisibleButton1())}return this};k.prototype._updateHeadersButtonsHelper=function(e,t,a,i){var r=this.getAggregation("header"),s=this.getAggregation("secondMonthHeader");r.setVisibleButton1(e);r.setVisibleButton2(t);r._setVisibleButton3(a);r._setVisibleButton4(i);if(s.getVisible()){s.setVisibleButton1(e);s.setVisibleButton2(t);s._setVisibleButton3(a);s._setVisibleButton4(i)}};k.prototype._updateHeadersButtons=function(){var e=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){e.setVisible(true);if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false)}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false)}else{this._updateHeadersButtonsHelper(true,true,false,false)}}else if(this._isTwoMonthsInTwoColumns()){e.setVisible(false);if(this._iMode===2){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true)}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false)}else if(this._iMode===1){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true)}else{this._updateHeadersButtonsHelper(true,true,true,true)}}else{e.setVisible(false);if(this._iMode===1){this._updateHeadersButtonsHelper(false,true,false,false)}else if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false)}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false)}else{this._updateHeadersButtonsHelper(true,true,false,false)}}if(this._getSucessorsPickerPopup()){this.getAggregation("header").setVisibleButton2(false)}};k.prototype._setPrimaryHeaderMonthButtonText=function(){var e=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){e.setTextButton1(this._sFirstMonthName)}};k.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(a.getConfiguration().getLocale().getLanguage().toLowerCase()==="ja"||a.getConfiguration().getLocale().getLanguage().toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns")}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh")}}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns")}};k.prototype._isTwoMonthsInOneColumn=function(){var e=F.call(this);return this._getColumns()===1&&e===2};k.prototype._isTwoMonthsInTwoColumns=function(){var e=F.call(this);return this._getColumns()===2&&e===2};k.prototype._updateHeadersYearPrimaryText=function(e,t){var a=this._getYearPicker(),i=this.getAggregation("header"),s=this.getAggregation("secondMonthHeader"),o=e,n=t||e,h=this._getPrimaryCalendarType();if(this._iMode===2&&a){var g=a.getProperty("_middleDate")?a.getProperty("_middleDate"):a._getDate(),l=new d(g,h),c=r._minDate(this._getPrimaryCalendarType()).getYear(),_=r._maxDate(this._getPrimaryCalendarType()).getYear(),p,f,D;l.setDate(1);l.setYear(l.getYear()-Math.floor(a.getYears()/2));if(l.getYear()<c){l.setYear(c)}else if(l.getYear()+a.getYears()>_){l.setYear(_-a.getYears()+1)}p=new d(l,h);p.setYear(p.getYear()+a.getYears()-1);f=this._oYearFormat.format(u.getInstance(l.toUTCJSDate(),l.getCalendarType()),true);D=this._oYearFormat.format(u.getInstance(p.toUTCJSDate(),p.getCalendarType()),true);if(this._bActionTriggeredFromSecondHeader){n=f+" - "+D}else{o=f+" - "+D}}i._setTextButton4(n);i._setAriaLabelButton4(n);s.setTextButton2(n);i.setTextButton2(o)};k.prototype._updateHeadersYearAdditionalText=function(e){var t=this.getAggregation("header"),a=this.getAggregation("secondMonthHeader");t.setAdditionalTextButton2(e);t._setAdditionalTextButton4(e);a.setAdditionalTextButton2(e)};k.prototype._adjustYearRangeDisplay=function(){var t=this.getAggregation("yearRangePicker"),a=sap.ui.getCore().getConfiguration().getLanguage().toLocaleLowerCase(),i=this._getPrimaryCalendarType();if(!this._getSucessorsPickerPopup()){if(i==e.Japanese){t.setColumns(1);t.setYears(4)}else if(a=="ko"||a=="ko-kr"||i!=e.Gregorian){t.setColumns(2);t.setYears(8)}else if(i==e.Gregorian){t.setColumns(3);t.setYears(9)}}};k.prototype._getSpecialDates=function(){var e=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin._getSpecialDates()}if(e&&e._getSpecialDates){return e._getSpecialDates()}else{var t=this.getSpecialDates();for(var a=0;a<t.length;a++){var i=t[a].getSecondaryType()===_.CalendarDayType.NonWorking&&t[a].getType()!==_.CalendarDayType.NonWorking;if(i){var r=new s;r.setType(t[a].getSecondaryType());r.setStartDate(t[a].getStartDate());if(t[a].getEndDate()){r.setEndDate(t[a].getEndDate())}t.push(r)}}return t}};function b(){var e=this.getSelectedDates();var t=this._getPrimaryCalendarType();if(e&&e[0]&&e[0].getStartDate()){this._oFocusedDate=d.fromLocalJSDate(e[0].getStartDate(),t)}else{this._oFocusedDate=d.fromLocalJSDate(c.getInstance(),t)}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new d(this._oMinDate,t)}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new d(this._oMaxDate,t)}}function A(e){var t=e.size.width;if(t<=0){return}if(t===this._iPrevWidth){return}this._iPrevWidth=t;var a=this._iSize;if(t<this._iBreakPointTablet){this._iSize=0}else if(t<this._iBreakPointDesktop){this._iSize=1}else if(t<this._iBreakPointLargeDesktop){this._iSize=2}else{this._iSize=3}var i=F.call(this);if(a!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break}if(i<this._getColumns()){this._setColumns(i)}if(this._getColumns()>2&&i>this._getColumns()){var r=this._getColumns();var s=0;var o=this._getColumns();while(r>=2){var n=i%r;if(n==0){o=r;break}else{var h=n/r;if(h>s){s=h;o=r}}r--}this._setColumns(o)}var g;var l=this.getAggregation("month");if(this._getColumns()>1){g=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle")}else{g="100%";this.$("content").addClass("sapUiCalContentSingle")}for(var d=0;d<l.length;d++){var u=l[d];u.setWidth(g)}this.invalidate()}this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS()}function w(e){var t=new d(e,this._getPrimaryCalendarType());t.setDate(1);var a=F.call(this);if(a<=12){var i=e.getMonth();if(12%a>0&&i+a>11){i=12-a}t.setMonth(i)}return t}function H(){var e,t,a;if(!this._bNamesLengthChecked){e=this._getMonthPicker();this._bLongMonth=e._bLongMonth;this._bNamesLengthChecked=true;this.setProperty("_currentPicker",Y.MONTH);if(!this._bLongMonth){t=this.getAggregation("month");if(t.length>1){a=d.fromLocalJSDate(t[0].getDate(),this._getPrimaryCalendarType())}else{a=this._getFocusedDate()}this._setHeaderText(a);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS()}}}function x(e,t){var a,i=this._getPrimaryCalendarType(),s;if(!e){return}a=d.fromLocalJSDate(e,i);s=a.getYear();r._checkYearInValidRange(s,i);if(r._isOutside(a,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this)}this._setFocusedDate(a);if(this.getDomRef()&&this._iMode==0){this._renderMonth(t,true)}}function F(){if(p.system.phone){return 1}else{return this.getMonths()}}function B(e){this.fireEvent("_renderMonth",{days:e.getParameter("days")})}function R(e){this._oSelectedMonth=e.oSource;this.fireSelect()}function L(e){var t,a,i;if(F.call(this)>1){t=this.getAggregation("month");for(i=0;i<t.length;i++){a=t[i];if(a.getId()!=e.oSource.getId()){a._bindMousemove()}}}}function N(e){var t,a,i;if(F.call(this)>1){t=this.getAggregation("month");for(i=0;i<t.length;i++){a=t[i];if(a.getId()!=e.oSource.getId()){a._unbindMousemove()}}}}function I(e){var t=e.getParameter("offset");if(t>0){this._handleNext(e)}if(t<0){this._handlePrevious(e)}}function E(){this._updateHeadersYearPrimaryText(this._getYearString())}return k});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarAppointment", ["./DateTypeRange","sap/ui/core/format/DateFormat","sap/ui/core/format/NumberFormat","sap/ui/core/format/TimezoneUtil","sap/ui/core/Core","./calendar/CalendarUtils","./library","sap/base/Log","sap/ui/core/Configuration","sap/ui/core/date/UI5Date"],function(t,e,a,i,n,r,o,u,g,s){"use strict";var p=t.extend("sap.ui.unified.CalendarAppointment",{metadata:{library:"sap.ui.unified",properties:{title:{type:"string",group:"Data"},text:{type:"string",group:"Data"},description:{type:"string",group:"Data"},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},tentative:{type:"boolean",group:"Data",defaultValue:false},selected:{type:"boolean",group:"Data",defaultValue:false},key:{type:"string",group:"Data",defaultValue:null},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}},aggregations:{customContent:{type:"sap.ui.core.Control",multiple:true}}}});p.prototype.init=function(){this._sAppointmentPartSuffix=null};p.prototype.applyFocusInfo=function(t){var e=this.getParent();if(e){e.applyFocusInfo(t)}return this};p.prototype._getDateRangeIntersectionText=function(t){var i=this.getStartDate(),n=this.getEndDate()?this.getEndDate():s.getInstance(864e12),r,o,u=s.getInstance(t.getFullYear(),t.getMonth(),t.getDate(),0,0,0),p=s.getInstance(u.getFullYear(),u.getMonth(),u.getDate()+1),l=e.getTimeInstance({pattern:"HH:mm"}),m=sap.ui.getCore().getLibraryResourceBundle("sap.m"),f=a.getUnitInstance({allowedUnits:["duration-hour"]},g.getFormatSettings().getFormatLocale()),c=a.getUnitInstance({allowedUnits:["duration-minute"]},g.getFormatSettings().getFormatLocale()),d,T,y,D;if(i.getTime()>p.getTime()||n.getTime()<u.getTime()){r=""}else if(i.getTime()<=u.getTime()&&n.getTime()>=p.getTime()){r=m.getText("PLANNINGCALENDAR_ALLDAY")}else if(i.getTime()<u.getTime()){r=m.getText("PLANNINGCALENDAR_UNTIL");o=l.format(n)}else if(n.getTime()>p.getTime()){r=m.getText("PLANNINGCALENDAR_FROM");o=l.format(i)}else{r=l.format(i);if(n.getTime()-i.getTime()<36e5){T=(n.getTime()-i.getTime())/6e4;o=c.format(T,"duration-minute")}else if((n.getTime()-i.getTime())%36e5===0){d=(n.getTime()-i.getTime())/36e5;o=f.format(d,"duration-hour")}else{d=Math.floor((n.getTime()-i.getTime())/36e5);y=f.format(d,"duration-hour");T=(n.getTime()-i.getTime())/6e4%60;D=c.format(T,"duration-minute");o=m.getText("PLANNINGCALENDAR_APP_DURATION",[y,D])}}return{start:r,end:o}};p._getComparer=function(t){var e=24*60*60*1e3,a=s.getInstance(t.getFullYear(),t.getMonth(),t.getDate(),0,0,0).getTime(),i=a+e;return function(t,e){var n=t.appointment.getStartDate().getTime(),r=e.appointment.getStartDate().getTime(),o=t.appointment.getEndDate()?t.appointment.getEndDate().getTime():864e12,u=e.appointment.getEndDate()?e.appointment.getEndDate().getTime():864e12,g=n<=a&&o>=i,s=r<=a&&u>=i,p;if(g&&s||!g&&!s){p=n-r;if(p===0){p=u-o}}else if(g){p=-1}else{p=1}return p}};p.prototype.setColor=function(t){if(t&&!t.match(/^#[0-9a-f]{6}$/i)){u.warning("setColor accepts only full hex color value with pound symbol, but value is '"+t+"'")}return this.setProperty("color",t)};p.prototype._getCSSColorForBackground=function(t){return"rgba("+[parseInt(t.substr(1,2),16),parseInt(t.substr(3,2),16),parseInt(t.substr(5,2),16)].join(",")+", 0.2)"};p.prototype._setAppointmentPartSuffix=function(t){this._sAppointmentPartSuffix=t;return this};p.prototype.getDomRef=function(t){if(document.getElementById(this.getId())){return document.getElementById(t?this.getId()+"-"+t:this.getId())}else if(this._sAppointmentPartSuffix){return document.getElementById(t?this.getId()+"-"+this._sAppointmentPartSuffix+"-"+t:this.getId()+"-"+this._sAppointmentPartSuffix)}var e=document.querySelectorAll(".sapUiCalendarRowApps[id^='"+this.getId()+"-']");return e.length>0?e[0]:null};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarDateInterval", ["./calendar/CalendarUtils","./Calendar","./calendar/DatesRow","./calendar/MonthPicker","./calendar/YearPicker","./calendar/YearRangePicker","./calendar/CalendarDate","./library","sap/ui/Device","./CalendarDateIntervalRenderer","sap/base/util/deepEqual","sap/m/Popover","sap/ui/core/CalendarType","sap/ui/core/Core","sap/base/Log","./DateRange","sap/ui/core/date/UI5Date"],function(e,t,a,r,i,s,o,n,h,g,p,c,l,u,_,d,D){"use strict";var f=t.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},designtime:"sap/ui/unified/designtime/CalendarDateInterval.designtime"},renderer:g});f.prototype.init=function(){t.prototype.init.apply(this,arguments);this._iDaysMonthHead=35};f.prototype.onBeforeRendering=function(){if(this._getSucessorsPickerPopup()){this.setProperty("_currentPicker","month")}t.prototype.onBeforeRendering.apply(this,arguments);this._bPoupupMode=this.getPickerPopup()};f.prototype._selectYearRange=function(){t.prototype._selectYearRange.apply(this,arguments);this.getAggregation("month")[0].setStartDate(this._getFocusedDate().toLocalJSDate())};f.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oPopup){this._oPopup.destroy();this._oPopup=null}if(this._oCalendar){this._oCalendar.removeDelegate(this._oFocusCalendarDelegate);this._oCalendar.destroy();this._oCalendar=null}};f.prototype._initializeMonthPicker=function(){var e=this._createMonthPicker();e._bCalendar=true;this.setAggregation("monthPicker",e);e._setSelectedDatesControlOrigin(this)};f.prototype._initializeYearPicker=function(){var e=this._createYearPicker();e._bCalendar=true;this.setAggregation("yearPicker",e);e._setSelectedDatesControlOrigin(this)};f.prototype._initializeYearRangePicker=function(){this.setAggregation("yearRangePicker",this._createYearRangePicker())};f.prototype.setPickerPopup=function(e){this.setProperty("pickerPopup",e);var t=this.getAggregation("header"),a,r;if(e){if(this._getMonthPicker()){this._getMonthPicker().destroy()}if(this._getYearPicker()){this._getYearPicker().destroy()}t.setVisibleButton2(false);t.detachEvent("pressButton2",this._handleButton2,this);this._setHeaderText(this._getFocusedDate(true))}else{if(!this._getMonthPicker()){this.setAggregation("monthPicker",this._createMonthPicker())}if(!this._getYearPicker()){this.setAggregation("yearPicker",this._createYearPicker())}a=this._getMonthPicker();r=this._getYearPicker();a.setColumns(0);a.setMonths(6);r.setColumns(0);r.setYears(6);r._oMinDate.setYear(this._oMinDate.getYear());r._oMaxDate.setYear(this._oMaxDate.getYear());t.setVisibleButton2(true);t.detachEvent("pressButton2",this._handleButton2,this);t.attachEvent("pressButton2",this._handleButton2,this)}return this};f.prototype._createMonthPicker=function(){var e=new r(this.getId()+"--MP");e.attachEvent("select",this._selectMonth,this);e._bNoThemeChange=true;e.setColumns(0);e.setMonths(3);e.attachEvent("pageChange",y,this);return e};f.prototype._createYearPicker=function(){var e=new i(this.getId()+"--YP");e.attachEvent("select",this._selectYear,this);e.setColumns(0);e.setYears(3);e.attachEvent("pageChange",P,this);return e};f.prototype._createYearRangePicker=function(){var e=new s(this.getId()+"--YRP");e.attachEvent("select",this._selectYearRange,this);e.setPrimaryCalendarType(this.getPrimaryCalendarType());e.setYears(6);e.setRangeSize(this._getYearPicker().getYears());return e};f.prototype._adjustYearRangeDisplay=function(){var e=this.getAggregation("yearRangePicker");if(!this._getSucessorsPickerPopup()){switch(this.getPrimaryCalendarType()){case l.Gregorian:e.setColumns(3);e.setYears(3);break;default:e.setColumns(2);e.setYears(2)}}else{t.prototype._adjustYearRangeDisplay.call(this,arguments)}};f.prototype._getCalendar=function(){var e;if(!this._oCalendar){e=new t(this.getId()+"--Cal");e.attachEvent("select",this._handleCalendarPickerDateSelect,this);e.attachEvent("cancel",function(e){this._closeCalendarPicker(true);var t=this.getAggregation("header").getDomRef("B1");if(t){t.focus()}},this);this._oFocusCalendarDelegate={onAfterRendering:function(){this.focus()}};e.addDelegate(this._oFocusCalendarDelegate,e);this._oCalendar=e}return this._oCalendar};f.prototype._setAriaRole=function(e){var t=this.getAggregation("month")[0];t._setAriaRole(e);t.invalidate();return this};f.prototype._handleButton1=function(e){if(this.getPickerPopup()){this._showCalendarPicker();this._showOverlay()}else{this._showMonthPicker()}};f.prototype._showOverlay=function(){this.$("contentOver").css("display","")};f.prototype._hideOverlay=function(){this.$("contentOver").css("display","none")};f.prototype._setHeaderText=function(e){var a;if(this.getStartDate()){a=t.prototype._setHeaderText.apply(this,[o.fromLocalJSDate(this.getStartDate(),this.getPrimaryCalendarType())])}else{a=t.prototype._setHeaderText.apply(this,arguments)}var r,i=a.sAriaLabel,s=this.getAggregation("header");var n=this._getLocaleData();var h=o.fromLocalJSDate(D.getInstance(e.toLocalJSDate().getTime()+(this._getDays()-1)*24*60*60*1e3),this.getPrimaryCalendarType());h.setDate(1);var g=n.getIntervalPattern().replace("{0}","").replace("{1}","");var p=this._oYearFormat.format(h.toUTCJSDate(),true);var c=a.sMonth;if(this.getPickerPopup()){if(n.oLocale.sLanguage.toLowerCase()==="ja"||n.oLocale.sLanguage.toLowerCase()==="zh"){if(p!=a.sYear){c=c.replace(g,g+p+" ");i=i.replace(g,g+p+" ")}r=a.sYear+" "+c;i=a.sYear+" "+i}else{if(p!=a.sYear){c=c.replace(g," "+a.sYear+g);i=i.replace(g," "+a.sYear+g)}r=c+" "+p;i=i+" "+p}s.setTextButton1(r,true);s.setAriaLabelButton1(i)}};f.prototype._showCalendarPicker=function(){var e=this.getStartDate(),t=this._getCalendar(),a=new d,r=D.getInstance(e.getTime());r.setDate(r.getDate()+this._getDays()-1);a.setStartDate(e);a.setEndDate(r);t.displayDate(this._getFocusedDate().toLocalJSDate());t.removeAllSelectedDates();t.addSelectedDate(a);t.setMinDate(this.getMinDate());t.setMaxDate(this.getMaxDate());this._openPickerPopup(t)};f.prototype._handleCalendarPickerDateSelect=function(e){var t=this._getCalendar(),a=t.getSelectedDates()[0].getStartDate(),r=o.fromLocalJSDate(a);this._setStartDate(r);this._setFocusedDate(r);this._closeCalendarPicker()};f.prototype._closeCalendarPicker=function(e){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close()}if(!e){this._renderMonth()}this._getCalendar()._closePickers()};f.prototype._getDaysLarge=function(){return 10};f.prototype._createMonth=function(e){var t=new a(e);t._bCalendar=true;return t};f.prototype.setStartDate=function(t){e._checkJSDateObject(t);if(p(this.getStartDate(),t)){return this}var a=t.getFullYear();e._checkYearInValidRange(a);var r=o.fromLocalJSDate(t,this.getPrimaryCalendarType());if(e._isOutside(r,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this)}var i=this.getMinDate();if(i&&t.getTime()<i.getTime()){_.warning("startDate < minDate -> minDate as startDate set",this);t=D.getInstance(i.getTime())}var s=this.getMaxDate();if(s&&t.getTime()>s.getTime()){_.warning("startDate > maxDate -> maxDate as startDate set",this);t=D.getInstance(s.getTime())}this.setProperty("startDate",t,true);r=o.fromLocalJSDate(t,this.getPrimaryCalendarType());this._oStartDate=r;var n=this.getAggregation("month")[0];n.setStartDate(t);this._updateHeader(r);var h=this._getFocusedDate(true).toLocalJSDate();if(!n.checkDateFocusable(h)){this._setFocusedDate(r);n.displayDate(t)}return this};f.prototype.getStartDate=function(){return this.getProperty("startDate")};f.prototype.setDays=function(e){var t=this.getAggregation("yearRangePicker");this.setProperty("days",e,true);e=this._getDays();var a=this.getAggregation("month")[0];a.setDays(e);if(!this.getPickerPopup()){var r=this._getMonthPicker();var i=Math.ceil(e/3);if(i>12){i=12}r.setMonths(i);var s=this._getYearPicker();var o=Math.floor(e/2);if(o>20){o=20}s.setYears(o);t.setRangeSize(o)}var n=this._getStartDate();this._updateHeader(n);if(this.getDomRef()){if(e>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge")}else{this.$().removeClass("sapUiCalIntLarge")}if(e>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead")}else{this.$().removeClass("sapUiCalIntHead")}}return this};f.prototype._getDays=function(){var e=this.getDays();if(h.system.phone&&e>8){return 8}else{return e}};f.prototype.setShowDayNamesLine=function(e){this.setProperty("showDayNamesLine",e,true);var t=this.getAggregation("month")[0];t.setShowDayNamesLine(e);return this};f.prototype._getShowMonthHeader=function(){var e=this._getDays();if(e>this._iDaysMonthHead){return true}else{return false}};f.prototype._getFocusedDate=function(e){if(!this._oFocusedDate||e){this._oFocusedDate=null;t.prototype._getFocusedDate.apply(this,arguments);var a=this.getStartDate();var r=this.getAggregation("month")[0];if(!a){this._setStartDate(this._oFocusedDate,false,true)}else if(!r.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=o.fromLocalJSDate(a,this.getPrimaryCalendarType())}}return this._oFocusedDate};f.prototype.setMonths=function(e){if(e==1){return this.setProperty("months",e,false)}else{throw new Error("Property months not supported "+this)}};f.prototype.setFirstDayOfWeek=function(e){if(e==-1){return this.setProperty("firstDayOfWeek",e,false)}else{throw new Error("Property firstDayOfWeek not supported "+this)}};f.prototype.focusDate=function(e){var a=this.getAggregation("month")[0];if(!a.checkDateFocusable(e)){this._focusDateExtend(o.fromLocalJSDate(e,this.getPrimaryCalendarType()),true,true)}t.prototype.focusDate.apply(this,arguments);return this};f.prototype._focusOnShiftTab=function(){var e=this.getAggregation("header");if(this.getPickerPopup()&&e.getDomRef("B1")){e.getDomRef("B1").focus()}else if(!this.getPickerPopup()&&e.getDomRef("B2")){e.getDomRef("B2").focus()}};f.prototype.onsapescape=function(e){if(this.getPickerPopup()){this._closeCalendarPicker();this.fireCancel()}else{if(this._iMode===0){this.fireCancel()}this._closePickers()}this._updateHeadersButtons();this._setHeaderText(this._getFocusedDate())};f.prototype._focusDateExtend=function(e,t,a){if(t){var r=this.getAggregation("month")[0],i=r._oItemNavigation?r._oItemNavigation.getFocusedIndex():0,s=new o(e,this.getPrimaryCalendarType());s.setDate(s.getDate()-i);this._setStartDate(s,false,true);if(!a){return true}}return false};f.prototype._setMinMaxDateExtend=function(e){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){_.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new o(this._oMinDate,this.getPrimaryCalendarType()),true,true)}else{var t=new o(this._oStartDate);t.setDate(t.getDate()+this._getDays()-1);if(t.isAfter(this._oMaxDate)){_.warning("end date > maxDate -> start date will be changed",this);var a=new o(this._oMaxDate);a.setDate(a.getDate()-this._getDays()+1);this._setStartDate(a,true,true)}}}};f.prototype._updateHeader=function(e){this._setHeaderText(e);switch(this._iMode){case 0:this._togglePrevNext(e,true);break;case 1:this._togglePrevNext(e);break;case 2:case 3:this._togglePrevNexYearPicker();break}};f.prototype._togglePrevNext=function(a,r){if(this._iMode>1||this._iMode==1&&this.getPickerPopup()){return t.prototype._togglePrevNext.apply(this,arguments)}var i=this._oMaxDate.getYear();var s=this._oMinDate.getYear();var n=this._oMaxDate.getMonth();var h=this._oMinDate.getMonth();var g=this._oMinDate.getDate();var p=this._oMaxDate.getDate();var c=this.getAggregation("header");var l=this._getDays();var u;var _;var d;var D;var f;if(this._iMode==1&&!r){var y=this._getMonthPicker();var P=y.getMonths();var v=y.getProperty("_firstMonth");var m=v+P-1;u=a.getYear();if(v==0||u==s&&v<=h){c.setEnabledPrevious(false)}else{c.setEnabledPrevious(true)}if(m>10||u==i&&m>=n){c.setEnabledNext(false)}else{c.setEnabledNext(true)}return}_=this._getStartDate();d=new o(_,this.getPrimaryCalendarType());d.setDate(d.getDate()+l-1);if(e._isOutside(a,_,d)){_=new o(a,this.getPrimaryCalendarType());d=new o(_,this.getPrimaryCalendarType());d.setDate(d.getDate()+l-1)}u=_.getYear();D=_.getMonth();f=_.getDate();if(u<s||u==s&&(!r||D<h||D==h&&f<=g)){c.setEnabledPrevious(false)}else{c.setEnabledPrevious(true)}u=d.getYear();D=d.getMonth();f=d.getDate();if(u>i||u==i&&(!r||D>n||D==n&&f>=p)){c.setEnabledNext(false)}else{c.setEnabledNext(true)}};f.prototype._shiftStartFocusDates=function(e,t,a){e.setDate(e.getDate()+a);t.setDate(t.getDate()+a);this._setFocusedDate(t);this._setStartDate(e,true)};f.prototype._handlePrevious=function(e){var t=new o(this._getFocusedDate(),this.getPrimaryCalendarType()),a,r,i;switch(this._iMode){case 0:r=new o(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(r,t,i*-1);this._addMonthFocusDelegate();break;case 1:if(!this.getPickerPopup()){a=this._getMonthPicker();if(a.getMonths()<12){a.previousPage();this._togglePrevNext(t)}else{t.setYear(t.getYear()-1);var s=this._focusDateExtend(t,true,false);this._setFocusedDate(t);this._updateHeader(t);this._setDisabledMonths(t.getYear());if(s){this.fireStartDateChange()}}}break;case 2:if(!this.getPickerPopup()){this._getYearPicker().previousPage();P.call(this)}break;case 3:if(!this.getPickerPopup()){this.getAggregation("yearRangePicker").previousPage();P.call(this)}break}};f.prototype._handleNext=function(e){var t=new o(this._getFocusedDate(),this.getPrimaryCalendarType()),a,r,i;switch(this._iMode){case 0:r=new o(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(r,t,i);this._addMonthFocusDelegate();break;case 1:if(!this.getPickerPopup()){a=this._getMonthPicker();if(a.getMonths()<12){a.nextPage();this._togglePrevNext(t)}else{t.setYear(t.getYear()+1);var s=this._focusDateExtend(t,true,false);this._setFocusedDate(t);this._updateHeader(t);this._setDisabledMonths(t.getYear());if(s){this.fireStartDateChange()}}}break;case 2:if(!this.getPickerPopup()){this._getYearPicker().nextPage();P.call(this)}break;case 3:if(!this.getPickerPopup()){this.getAggregation("yearRangePicker").nextPage();P.call(this)}break}};f.prototype._getDisplayedMonths=function(e){var t=[];var a=e.getMonth();var r=this._getDays();t.push(a);if(r>this._getDaysLarge()){var i=new o(e,this.getPrimaryCalendarType());i.setDate(i.getDate()+r-1);var s=i.getMonth();while(a!=s){a=(a+1)%12;t.push(a)}}return t};f.prototype._getDisplayedSecondaryMonths=function(e,t){var a=this._getDays();var r=new o(this._getStartDate(),t);var i=r.getMonth();var s=new o(r,this.getPrimaryCalendarType());s.setDate(s.getDate()+a-1);s=new o(s,t);var n=s.getMonth();return{start:i,end:n}};f.prototype._openPickerPopup=function(e){if(!this._oPopup){var t=new c({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});t.oPopup.setDurations(0,0);t.addEventDelegate({onsapescape:function(e){this._oCalendar.onsapescape(e);this._hideOverlay()}},this);this._oPopup=t}this._oPopup.addContent(e);this._oPopup.attachAfterClose(function(){this._closeCalendarPicker(true);this._hideOverlay()},this);this._oPopup.attachAfterOpen(function(){var e=a.$("B1");var t=this._oPopup.$();var r=Math.floor((t.width()-e.width())/2);this._oPopup.setOffsetX(u.getConfiguration().getRTL()?r:-r);var i=e.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?i:-i)},this);var a=this.getAggregation("header");this._oPopup.openBy(a.getDomRef("B1"))};f.prototype._getMaxDateAlignedToMinDate=function(e,t){var a=new o(e,this.getPrimaryCalendarType());if(a.isBefore(t)){a=new o(t);a.setDate(a.getDate()+this._getDays()-1)}return a};f.prototype._getStartDateAlignedToMinAndMaxDate=function(e,t,a){var r=new o(a,this.getPrimaryCalendarType());if(r.isBefore(t)){r=new o(t,this.getPrimaryCalendarType())}else if(r.isAfter(e)){r=e}return r};f.prototype._calculateStartDate=function(e,t,a){var r=new o(e,this.getPrimaryCalendarType());r.setDate(r.getDate()-this._getDays()+1);r=this._getMaxDateAlignedToMinDate(r,t);a=this._getStartDateAlignedToMinAndMaxDate(r,t,a);return a};f.prototype._setStartDate=function(e,t,a){e=this._calculateStartDate(this._oMaxDate,this._oMinDate,e);var r=e.toLocalJSDate();this.setProperty("startDate",r,true);this._oStartDate=e;var i=this.getAggregation("month")[0];i.setStartDate(r);this._updateHeader(e);if(t){var s=this._getFocusedDate().toLocalJSDate();if(!i.checkDateFocusable(s)){this._setFocusedDate(e);i.setDate(r)}else{i.setDate(s)}}if(!a){this.fireStartDateChange()}};f.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate()}return this._oStartDate};function y(e){var t=new o(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(t)}function P(e){this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString())}return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarDateIntervalRenderer", ["sap/ui/core/Renderer","./CalendarRenderer"],function(e,a){"use strict";var n=e.extend(a);n.apiVersion=2;n.renderCalContentOverlay=function(){};n.renderCalContentAndArrowsOverlay=function(e,a,n){if(a.getPickerPopup()){e.openStart("div",n+"-contentOver");e.class("sapUiCalContentOver");if(!a._oPopup||!a._oPopup.isOpen()){e.style("display","none")}e.openEnd();e.close("div")}};n.addAttributes=function(e,a){e.class("sapUiCalInt");e.class("sapUiCalDateInt");var n=a._getDays();if(n>a._getDaysLarge()){e.class("sapUiCalIntLarge")}if(n>a._iDaysMonthHead){e.class("sapUiCalIntHead")}if(a.getShowDayNamesLine()){e.class("sapUiCalWithDayNamesLine")}if(a.getShowWeekNumbers()){e.class("sapUiCalWithWeekNumbers")}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarLegend", ["sap/ui/core/Control","./library","./CalendarLegendRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarLegendItem","sap/ui/core/Core","sap/ui/Device","sap/ui/core/delegate/ItemNavigation"],function(e,t,i,n,jQuery,a,r,o,s){"use strict";var d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var p=t.CalendarDayType;var u=t.StandardCalendarLegendItem;var g=e.extend("sap.ui.unified.CalendarLegend",{metadata:{library:"sap.ui.unified",properties:{standardItems:{type:"string[]",group:"Misc",defaultValue:["Today","Selected","WorkingDay","NonWorkingDay"]},columnWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"120px"}},aggregations:{items:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,singularName:"item"},_standardItems:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarLegend.designtime"},constructor:function(t,i){e.prototype.constructor.apply(this,arguments);if(typeof t!=="string"){i=t}if(!i||i&&!i.standardItems){this._addStandardItems(this.getStandardItems())}this._bShouldRenderStandardItems=true;this._oItemNavigation=null},renderer:i});g.prototype.onAfterRendering=function(){if(!o.system.phone&&this._oParentControl){this._initItemNavigation()}};g.prototype.setStandardItems=function(e){var t;if(e&&e.length===1&&e[0]===""){e=[]}if(e&&e.length){e=this.validateProperty("standardItems",e);for(t=0;t<e.length;t++){if(!u[e[t]]){throw new Error("Invalid value '"+e[t]+"'. Property standardItems must contain values from sap.ui.unified.StandardCalendarLegendItem.")}}}this.setProperty("standardItems",e);this._addStandardItems(this.getStandardItems(),true);return this};g.prototype._initItemNavigation=function(){var e=this.getAggregation("_standardItems")||[],t=this.getItems()||[],i,n=[],a,r;i=e.concat(t);if(!i.length){return}r=i[0].getDomRef().parentElement;i.forEach(function(e,t){a=e.getFocusDomRef();a.setAttribute("tabindex","-1");n.push(a)});if(!this._oItemNavigation){this._oItemNavigation=(new s).setCycling(false).attachEvent(s.Events.AfterFocus,this._onItemNavigationAfterFocus,this).attachEvent(s.Events.FocusLeave,this._onItemNavigationFocusLeave,this).setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"],saphome:["alt","meta","ctrl"],sapend:["meta","ctrl"]});this.addDelegate(this._oItemNavigation)}this._oItemNavigation.setRootDomRef(r).setItemDomRefs(n).setPageSize(i.length).setFocusedIndex(0)};g.prototype._onItemNavigationAfterFocus=function(e){var t=e.getSource(),i=t.getItemDomRefs()[t.getFocusedIndex()],n=r.byId(i.id).getType(),a=this._getParent();this._setSpecialDateTypeFilter(n);a&&a.invalidate()};g.prototype._onItemNavigationFocusLeave=function(e){var t=this._getParent();this._setSpecialDateTypeFilter();t&&t.invalidate()};g.prototype._setSpecialDateTypeFilter=function(e){this._sSpecialDateTypeFilter=e||""};g.prototype._getSpecialDateTypeFilter=function(){return this._sSpecialDateTypeFilter||""};g.prototype._setParent=function(e){this._oParentControl=e};g.prototype._getParent=function(){return this._oParentControl};g.prototype._getLegendAriaLabel=function(){return d.getText("LEGEND_ARIA_LABEL")};g.prototype._addStandardItems=function(e,t){var i,n=this.getId();if(t){this.destroyAggregation("_standardItems")}for(i=0;i<e.length;i++){var r=new a(n+"-"+e[i],{text:d.getText(g._Standard_Items_TextKeys[e[i]])});this.addAggregation("_standardItems",r)}};g._Standard_Items_TextKeys={Today:"LEGEND_TODAY",Selected:"LEGEND_SELECTED",WorkingDay:"LEGEND_NORMAL_DAY",NonWorkingDay:"LEGEND_NON_WORKING_DAY"};g.prototype._getItemType=function(e,t){var i=e.getType(),a,r;if(i&&i!==p.None){return i}r=this._getUnusedItemTypes(t);a=t.filter(function(e){return!e.getType()||e.getType()===p.None}).indexOf(e);if(a<0){n.error("Legend item is not in the legend",this);return i}if(r[a]){i=r[a]}else{i="Type"+(Object.keys(p).length+a-r.length-1)}return i};g.prototype._getItemByType=function(e){var t,i=this.getItems(),n;for(n=0;n<i.length;n++){if(this._getItemType(i[n],i)===e){t=i[n];break}}return t};g.prototype._getUnusedItemTypes=function(e){var t=jQuery.extend({},p),i,n;delete t[p.None];delete t[p.NonWorking];for(n=0;n<e.length;n++){i=e[n].getType();if(t[i]){delete t[i]}}return Object.keys(t)};g.prototype._extractItemIdsString=function(e){return e.map(function(e){return e.getId()}).join(" ")};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarLegendItem", ["sap/ui/core/Element","./library"],function(e,a){"use strict";var r=a.CalendarDayType;var u=e.extend("sap.ui.unified.CalendarLegendItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:r.None},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});return u});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarLegendRenderer", ["sap/ui/core/InvisibleText"],function(e){"use strict";var t={apiVersion:2};t.render=function(e,t){var i=t.getAggregation("_standardItems"),n=t.getItems(),r=this.defineItemsLength(t,n.length),d=(i?i.length:0)+(n?n.length:0),a="",i=i||[],n=n||[],s,o,l,g=1;e.openStart("div",t);e.class("sapUiUnifiedLegend");e.attr("aria-label",t._getLegendAriaLabel());e.attr("role","list");a=t._extractItemIdsString(i.concat(n));e.attr("aria-owns",a);e.openEnd();this.renderItemsHeader(e,t);if(i||n){e.openStart("div");e.class("sapUiUnifiedLegendItems");l=t.getColumnWidth();e.style("column-width",l);e.style("-moz-column-width",l);e.style("-webkit-column-width",l);e.openEnd();if(i){o=t.getId().length+1;for(s=0;s<i.length;++s){var c="sapUiUnifiedLegend"+i[s].getId().slice(o);this.renderLegendItem(e,c,i[s],["sapUiUnifiedLegendSquareColor"],g++,d)}}if(n){for(s=0;s<r;s++){this.renderLegendItem(e,"sapUiCalLegDayType"+t._getItemType(n[s],n).slice(4),n[s],["sapUiUnifiedLegendSquareColor"],g++,d)}}this.renderAdditionalItems(e,t);e.close("div")}this.renderAdditionalContent(e,t);e.close("div")};t.renderLegendItem=function(e,t,i,n,r,d){var a=i.getText();var s=i.getTooltip_AsString();e.openStart("div",i);if(s){e.attr("title",s)}e.attr("role","listitem");e.attr("aria-posinset",r);e.attr("aria-setsize",d);e.class("sapUiUnifiedLegendItem");e.class(t);e.openEnd();e.openStart("div");e.class("sapUiUnifiedLegendSquare");e.openEnd();this.renderColor(e,i.getColor(),n);e.close("div");e.openStart("div",i.getId()+"-Text");e.class("sapUiUnifiedLegendDescription");e.openEnd();e.text(a);e.close("div");e.close("div")};t.renderItemsHeader=function(e,t){};t.renderAdditionalContent=function(e,t){};t.defineItemsLength=function(e,t){return t};t.renderAdditionalItems=function(e,t){};t.renderColor=function(e,t,i){e.openStart("div");for(var n=0;n<i.length;n++){e.class(i[n])}if(t){e.style("background-color",t)}e.openEnd();e.close("div")};t.addCalendarTypeAccInfo=function(e,i,n){var r,d;if(n){var a=n._getItemByType(i);if(a){r=a.getText()}}if(r){e["label"]=e["label"]?e["label"]+"; "+r:r}else{d=t.getTypeAriaText(i);if(d){e["describedby"]=e["describedby"]?e["describedby"]+" "+d.getId():d.getId()}}};t.typeARIATexts={};t.getTypeAriaText=function(i){var n,r;if(i.indexOf("Type")!==0){return}if(!t.typeARIATexts[i]){n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");r=n.getText("LEGEND_UNNAMED_TYPE",parseInt(i.slice(4)).toString());t.typeARIATexts[i]=new e({text:r});t.typeARIATexts[i].toStatic()}return t.typeARIATexts[i]};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarMonthInterval", ["sap/m/Popover","sap/ui/Device","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/format/DateFormat","./calendar/CalendarUtils","./calendar/CustomYearPicker","./calendar/Header","./calendar/MonthsRow","./calendar/YearPicker","./calendar/CalendarDate","./CalendarMonthIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/unified/DateRange","sap/ui/core/Configuration"],function(t,e,a,i,s,o,r,n,h,c,l,u,g,D,f,d,p,_,v){"use strict";var M=a.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},_currentPicker:{type:"string",group:"Appearance",defaultValue:"monthsRow",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}},renderer:D});var m={MONTHS_ROW:"monthsRow",YEAR_PICKER:"yearPicker"};M.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=r.getDateInstance({format:"y"});this._oMinDate=n._minDate();this._oMaxDate=n._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15};M.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent)}if(this._oPopup){this._oPopup.destroy();this._oPopup=null}if(this._oCustomYearPicker){this._oCustomYearPicker.removeDelegate(this._oFocusCYPDelegate);this._oCustomYearPicker.destroy();this._oCustomYearPicker=null}};M.prototype.onBeforeRendering=function(){var t=this.getAggregation("monthsRow");var e=this._getFocusedDate();A.call(this);t.displayDate(e.toLocalJSDate())};M.prototype._setAriaRole=function(t){var e=this.getAggregation("monthsRow");e._setAriaRole(t);e.invalidate();return this};M.prototype._initializeHeader=function(){var t=new c(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});t.attachEvent("pressPrevious",this._handlePrevious,this);t.attachEvent("pressNext",this._handleNext,this);t.attachEvent("pressButton2",L,this);this.setAggregation("header",t)};M.prototype._initializeMonthsRow=function(){var t=new l(this.getId()+"--MonthsRow");t.attachEvent("focus",O,this);t.attachEvent("select",J,this);t._bNoThemeChange=true;this.setAggregation("monthsRow",t)};M.prototype._initilizeYearPicker=function(){var t=this._createYearPicker();this.setAggregation("yearPicker",t);t._setSelectedDatesControlOrigin(this)};M.prototype._createYearPicker=function(){var t=new u(this.getId()+"--YP",{columns:0,years:6});t.attachEvent("select",B,this);t.attachEvent("pageChange",T,this);t._oMinDate.setYear(this._oMinDate.getYear());t._oMaxDate.setYear(this._oMaxDate.getYear());return t};M.prototype._getCalendarPicker=function(){var t;if(!this._oCustomYearPicker){t=new h(this.getId()+"--Cal");t.attachEvent("select",E,this);t.attachEvent("cancel",function(t){this._oPopup.close();var e=this.getAggregation("header").getDomRef("B2");if(e){e.focus()}},this);this._oFocusCYPDelegate={onAfterRendering:function(){this.focus()}};t.addDelegate(this._oFocusCYPDelegate,t);this._oCustomYearPicker=t}return this._oCustomYearPicker};M.prototype.setStartDate=function(t){n._checkJSDateObject(t);if(d(this.getStartDate(),t)){return this}var e=t.getFullYear();n._checkYearInValidRange(e);this.setProperty("startDate",t,true);this._oStartDate=g.fromLocalJSDate(t);this._oStartDate.setDate(1);var a=this.getAggregation("monthsRow");a.setStartDate(t);A.call(this);var i=this._getFocusedDate().toLocalJSDate();if(!a.checkDateFocusable(i)){this._setFocusedDate(this._oStartDate);a.displayDate(t)}return this};M.prototype.invalidate=function(t){if(!this._bDateRangeChanged&&(!t||!(t instanceof _))){a.prototype.invalidate.apply(this,arguments)}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(N.bind(this),0)}};M.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var t=this.removeAllAggregation("selectedDates");return t};M.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var t=this.destroyAggregation("selectedDates");return t};M.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var t=this.removeAllAggregation("specialDates");return t};M.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var t=this.destroyAggregation("specialDates");return t};M.prototype.setLocale=function(t){if(this._sLocale!=t){this._sLocale=t;this._oLocaleData=undefined;this.invalidate()}return this};M.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=v.getFormatSettings().getFormatLocale().toString()}return this._sLocale};M.prototype._getFocusedDate=function(){if(!this._oFocusedDate){k.call(this)}return this._oFocusedDate};M.prototype._setFocusedDate=function(t){n._checkCalendarDate(t);this._oFocusedDate=new g(t)};M.prototype.focusDate=function(t){var e=false;var a=this.getAggregation("monthsRow");if(t&&!a.checkDateFocusable(t)){H.call(this,g.fromLocalJSDate(t));e=true}b.call(this,t,false);if(e){this.fireStartDateChange()}return this};M.prototype.displayDate=function(t){b.call(this,t,true);return this};M.prototype.setMonths=function(t){this.setProperty("months",t,true);t=this._getMonths();var e=this.getAggregation("monthsRow");e.setMonths(t);if(!e.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var a=P.call(this);this._setFocusedDate(this._oStartDate);e.setDate(a.toLocalJSDate())}if(!this.getPickerPopup()){var i=this.getAggregation("yearPicker");var s=Math.floor(t/2);if(s>20){s=20}i.setYears(s)}A.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead")}else{this.$().removeClass("sapUiCalIntHead")}}return this};M.prototype._getMonths=function(){var t=this.getMonths();if(e.system.phone&&t>6){return 6}else{return t}};M.prototype._getLocaleData=function(){if(!this._oLocaleData){var t=this.getLocale();var e=new s(t);this._oLocaleData=o.getInstance(e)}return this._oLocaleData};M.prototype.setPickerPopup=function(t){var e;this.setProperty("pickerPopup",t,true);if(t){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy()}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker())}e=this.getAggregation("yearPicker");e.setColumns(0);e.setYears(6)}return this};M.prototype.setMinDate=function(t){if(d(t,this.getMinDate())){return this}if(!t){this._oMinDate=n._minDate()}else{n._checkJSDateObject(t);this._oMinDate=g.fromLocalJSDate(t);this._oMinDate.setDate(1);var e=this._oMinDate.getYear();n._checkYearInValidRange(e);if(this._oMaxDate.isBefore(this._oMinDate)){p.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=g.fromLocalJSDate(t);this._oMaxDate.setDate(n._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true)}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){p.warning("focused date < minDate -> minDate focused",this);this.focusDate(t)}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){p.warning("start date < minDate -> minDate set as start date",this);y.call(this,new g(this._oMinDate),true,true)}}this.setProperty("minDate",t,false);if(this.getPickerPopup()){var a=this._getCalendarPicker();a.setMinDate(t)}else{var i=this.getAggregation("yearPicker");i._oMinDate.setYear(this._oMinDate.getYear())}return this};M.prototype.setMaxDate=function(t){if(d(t,this.getMaxDate())){return this}if(!t){this._oMaxDate=n._maxDate()}else{n._checkJSDateObject(t);this._oMaxDate=g.fromLocalJSDate(t);this._oMaxDate.setDate(n._daysInMonth(this._oMaxDate));var e=this._oMaxDate.getYear();n._checkYearInValidRange(e);if(this._oMinDate.isAfter(this._oMaxDate)){p.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=g.fromLocalJSDate(t);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true)}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){p.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(t)}}if(this._oStartDate){var a=new g(this._oStartDate);a.setDate(1);a.setMonth(a.getMonth()+this._getMonths());a.setDate(0);if(a.isAfter(this._oMaxDate)){var i=new g(this._oMaxDate);i.setDate(1);i.setMonth(i.getMonth()-this._getMonths()+1);if(i.isSameOrAfter(this._oMinDate)){p.warning("end date > maxDate -> maxDate set as end date",this);y.call(this,i,true,true)}}}}this.setProperty("maxDate",t,false);if(this.getPickerPopup()){var s=this._getCalendarPicker();s.setMaxDate(t)}else{var o=this.getAggregation("yearPicker");o._oMaxDate.setYear(this._oMaxDate.getYear())}return this};M.prototype.onclick=function(t){if(t.isMarked("delayedMouseEvent")){return}if(t.target.id==this.getId()+"-cancel"){this.onsapescape(t)}};M.prototype.onmousedown=function(t){t.preventDefault();t.setMark("cancelAutoClose")};M.prototype.onsapescape=function(t){if(this.getPickerPopup()){I.call(this);this.fireCancel()}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:C.call(this);break}}};M.prototype._handlePrevious=function(t){var e,a,i,s;switch(this._iMode){case 0:e=this._getFocusedDate();a=this._getMonths();i=new g(P.call(this));i.setMonth(i.getMonth()-a);e.setMonth(e.getMonth()-a);this._setFocusedDate(e);y.call(this,i,true);break;case 1:if(!this.getPickerPopup()){s=this.getAggregation("yearPicker");s.previousPage();Y.call(this)}break}};M.prototype._handleNext=function(t){var e,a,i,s;switch(this._iMode){case 0:e=this._getFocusedDate();a=this._getMonths();i=new g(P.call(this));i.setMonth(i.getMonth()+a);e.setMonth(e.getMonth()+a);this._setFocusedDate(e);y.call(this,i,true);break;case 1:if(!this.getPickerPopup()){s=this.getAggregation("yearPicker");s.nextPage();Y.call(this)}break}};M.prototype._showOverlay=function(){this.$("contentOver").css("display","")};M.prototype._hideOverlay=function(){this.$("contentOver").css("display","none")};M.prototype._getShowItemHeader=function(){var t=this.getMonths();if(t>this._iDaysMonthsHead){return true}else{return false}};function y(t,e,a){var i=new g(this._oMaxDate);i.setDate(1);i.setMonth(i.getMonth()-this._getMonths()+1);if(i.isBefore(this._oMinDate)){i=new g(this._oMinDate);i.setMonth(i.getMonth()+this._getMonths()-1)}if(t.isBefore(this._oMinDate)){t=new g(this._oMinDate)}else if(t.isAfter(i)){t=i}t.setDate(1);var s=t.toLocalJSDate();this.setProperty("startDate",s,true);this._oStartDate=t;var o=this.getAggregation("monthsRow");o.setStartDate(s);A.call(this);if(e){var r=this._getFocusedDate().toLocalJSDate();if(!o.checkDateFocusable(r)){this._setFocusedDate(t);o.setDate(s)}else{o.setDate(r)}}if(!a){this.fireStartDateChange()}}function P(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1)}return this._oStartDate}function S(t){var e=this._getFocusedDate();var a=this.getAggregation("monthsRow");if(!t){a.setDate(e.toLocalJSDate())}else{a.displayDate(e.toLocalJSDate())}A.call(this)}function k(){var t=this.getSelectedDates();if(t&&t[0]&&t[0].getStartDate()){this._oFocusedDate=g.fromLocalJSDate(t[0].getStartDate())}else{this._oFocusedDate=new g}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new g(this._oMinDate)}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new g(this._oMaxDate)}}function w(){var t=this._getFocusedDate();var e=this.getAggregation("yearPicker");this.setProperty("_currentPicker",m.YEAR_PICKER);this._showOverlay();e.setDate(t.toLocalJSDate());Y.call(this);this._iMode=1}function C(t){this._iMode=0;this.setProperty("_currentPicker",m.MONTHS_ROW);this._hideOverlay();if(!t){S.call(this)}}function A(){F.call(this);x.call(this)}function x(){var t=new g(P.call(this));var e=this._getMonths();var a=t.getYear();var i=this._oMaxDate.getYear();var s=this._oMinDate.getYear();var o=t.getMonth();var r=this._oMaxDate.getMonth();var n=this._oMinDate.getMonth();var h=this.getAggregation("header");if(a<s||a==s&&o<=n){h.setEnabledPrevious(false)}else{h.setEnabledPrevious(true)}t.setMonth(t.getMonth()+e-1);a=t.getYear();o=t.getMonth();if(a>i||a==i&&o>=r){h.setEnabledNext(false)}else{h.setEnabledNext(true)}}function Y(){var t=this.getAggregation("yearPicker");var e=t.getYears();var a=new g(t.getProperty("_middleDate"));a.setYear(a.getYear()+Math.floor(e/2));var i=this.getAggregation("header");var s=new g(this._oMaxDate);s.setYear(s.getYear()-Math.ceil(e/2));s.setMonth(11,31);var o=new g(this._oMinDate);o.setYear(o.getYear()+Math.floor(e/2)+1);o.setMonth(0,1);i.setEnabledNext(!a.isAfter(s));i.setEnabledPrevious(!a.isBefore(o))}function F(){var t;var e=P.call(this);var a=this._oYearFormat.format(e.toUTCJSDate(),true);var i=new g(e);i.setMonth(i.getMonth()+this._getMonths()-1);var s=this._oYearFormat.format(i.toUTCJSDate(),true);if(a!=s){var o=this._getLocaleData();var r=o.getIntervalPattern();t=r.replace(/\{0\}/,a).replace(/\{1\}/,s)}else{t=a}var n=this.getAggregation("header");n.setTextButton2(t)}function R(t,e){var a;var i=false;if(t.isBefore(this._oMinDate)){a=this._oMinDate;i=true}else if(t.isAfter(this._oMaxDate)){a=this._oMaxDate;i=true}else{a=t}this._setFocusedDate(a);if(i||e){H.call(this,a);S.call(this,false);this.fireStartDateChange()}}function b(t,e){if(!t){return}var a=g.fromLocalJSDate(t);if(this._oFocusedDate&&this._oFocusedDate.isSame(a)){return}var i=a.getYear();n._checkYearInValidRange(i);if(n._isOutside(a,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this)}this._setFocusedDate(a);if(this.getDomRef()&&this._iMode==0){S.call(this,e)}}function L(t){var e;if(this.getPickerPopup()){this._showCalendarPicker()}else{if(this._iMode!=1){e=function(){var t=this.getAggregation("yearPicker");t.focus();t.removeDelegate(e)};w.call(this);this.getAggregation("yearPicker").addDelegate({onAfterRendering:e},this)}else{C.call(this)}}}M.prototype._showCalendarPicker=function(){var t=this._getFocusedDate(true).toLocalJSDate();var e=this._getCalendarPicker();var a=new _({startDate:t});var i=g.fromLocalJSDate(t);e.displayDate(t,false);i.setMonth(0,1);e._getYearPicker().setProperty("_middleDate",i);e.removeAllSelectedDates();e.addSelectedDate(a);e.setMinDate(this.getMinDate());e.setMaxDate(this.getMaxDate());V.call(this,e);this._showOverlay()};function I(t){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close()}this._hideOverlay();if(!t){S.call(this)}}function J(t){this.fireSelect()}function O(t){var e=g.fromLocalJSDate(t.getParameter("date"));var a=t.getParameter("notVisible");R.call(this,e,a)}function E(t){var e=new g(this._getFocusedDate());var a=this._getCalendarPicker();var i=a.getSelectedDates()[0].getStartDate();var s=g.fromLocalJSDate(i);s.setMonth(e.getMonth());s.setDate(e.getDate());R.call(this,s,true);I.call(this)}function B(t){var e=new g(this._getFocusedDate());var a=this.getAggregation("yearPicker");var i=g.fromLocalJSDate(a.getDate());var s={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(s)}};var o=this.getAggregation("monthsRow");i.setMonth(e.getMonth());i.setDate(e.getDate());e=i;R.call(this,e,true);C.call(this);o.addDelegate(s,o)}function N(){this._sInvalidateContent=undefined;var t=this.getAggregation("monthsRow");if(t){t._bDateRangeChanged=true;t._bInvalidateSync=true;t.invalidate();t._bInvalidateSync=undefined}this._bDateRangeChanged=undefined}function H(t){var e=this.getAggregation("monthsRow");var a=P.call(this);var i=e._oItemNavigation.getFocusedIndex();a=new g(t);a.setMonth(a.getMonth()-i);y.call(this,a,false,true)}function V(e){if(!this._oPopup){var a=new t({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});a.oPopup.setDurations(0,0);a.addEventDelegate({onsapescape:function(t){this._oCustomYearPicker.onsapescape(t);this._hideOverlay()}},this);this._oPopup=a}this._oPopup.addContent(e);this._oPopup.attachAfterClose(function(){this._hideOverlay()},this);this._oPopup.attachAfterOpen(function(){var t=s.$("B2");var e=this._oPopup.$();var a=Math.floor((e.width()-t.width())/2);this._oPopup.setOffsetX(i.getConfiguration().getRTL()?a:-a);var o=t.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?o:-o)},this);var s=this.getAggregation("header");this._oPopup.openBy(s.getDomRef("B2"))}function T(t){Y.call(this)}return M});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarMonthIntervalRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var a=t.getId();var n=t.getTooltip_AsString();e.openStart("div",t);e.class("sapUiCal");e.class("sapUiCalInt");e.class("sapUiCalMonthInt");if(t._getShowItemHeader()){e.class("sapUiCalIntHead")}var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var o={labelledby:{value:"",append:false}};if(t._bPoupupMode){o["role"]="dialog"}e.accessibilityState(t,o);if(n){e.attr("title",n)}var r=t.getWidth();if(r&&r!=""){e.style("width",r)}e.openEnd();var s=t.getAggregation("header");e.renderControl(s);e.openStart("div",a+"-content");e.class("sapUiCalContent");e.openEnd();e.renderControl(t.getAggregation(t.getProperty("_currentPicker")));e.close("div");e.openStart("button",a+"-cancel");e.class("sapUiCalCancel");e.attr("tabindex","-1");e.openEnd();e.text(i.getText("CALENDAR_CANCEL"));e.close("button");if(t.getPickerPopup()){e.openStart("div",a+"-contentOver");e.class("sapUiCalContentOver");if(!t._oPopup||!t._oPopup.isOpen()){e.style("display","none")}e.openEnd();e.close("div")}e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarOneMonthInterval", ["sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/Calendar","./library","sap/ui/unified/CalendarDateInterval","sap/ui/unified/calendar/OneMonthDatesRow","sap/ui/unified/DateRange","./CalendarOneMonthIntervalRenderer"],function(t,e,a,n,i,o,r,s,h){"use strict";var g=o.extend("sap.ui.unified.CalendarOneMonthInterval",{renderer:h});g.prototype.init=function(){o.prototype.init.apply(this,arguments);this._bShowOneMonth=true};g.prototype._getCalendar=function(){var n;if(!this._oCalendar){n=new t(this.getId()+"--Cal");n.attachEvent("select",function(){var t=this._getCalendar(),n=t._getFocusedDate(),i=e._getFirstDateOfMonth(new a(n,this.getPrimaryCalendarType()));var o=this.getAggregation("month")[0];this._setStartDate(i);if(o.getMode()<2){i=this._getStartDate()}this._adjustSelectedDate(i);this._oFocusDateOneMonth=i;this._closeCalendarPicker(true);this._focusDate(n,false,true)},this);n.attachEvent("cancel",function(t){var e=this._getCalendar(),a=e._getFocusedDate();this._closeCalendarPicker(true);this._oFocusDateOneMonth=a;this._focusDate(a,true);var n=this.getAggregation("header").getDomRef("B1");if(n){n.focus()}},this);this._oCalendar=n}return this._oCalendar};g.prototype._createMonth=function(t){return new r(t)};g.prototype._handleFocus=function(t){var n=!!t.getParameter("_outsideBorder"),i=t.getParameter("date"),r=a.fromLocalJSDate(i,this.getPrimaryCalendarType()),s=a.fromLocalJSDate(this.getStartDate()),h=!e._isSameMonthAndYear(r,s),g,l,u;if(n||h){if(e._isLastDateInMonth(r)){this._oFocusDateOneMonth=r}else{this._oFocusDateOneMonth=e._getFirstDateOfMonth(r)}g=r.isBefore(s)?-1:1;l=new a(this._getFocusedDate(),this.getPrimaryCalendarType());u=new a(this._getStartDate(),this.getPrimaryCalendarType());o.prototype._shiftStartFocusDates.call(this,l,u,g)}return o.prototype._handleFocus.apply(this,arguments)};g.prototype._focusDateExtend=function(t,e,a){var n,i;if(!this._oFocusDateOneMonth){return o.prototype._focusDateExtend.apply(this,arguments)}n=this.getAggregation("month")[0];i=this._oFocusDateOneMonth.toLocalJSDate();this._setFocusedDate(this._oFocusDateOneMonth);n._bNoRangeCheck=true;n.setDate(i);n._bNoRangeCheck=false;this._oFocusDateOneMonth=null;return!a};g.prototype._setDisplayMode=function(t){this.getAggregation("month")[0].setMode(t)};g.prototype._shiftStartFocusDates=function(t,e,n){var i=n,o=this.getAggregation("month")[0],r,s;if(i!==0){i=i>0?1:-1}t.setMonth(t.getMonth()+i);e.setYear(t.getYear());e.setMonth(t.getMonth(),t.getDate());this._setFocusedDate(e);this._setStartDate(t,true);r=this.getStartDate();s=a.fromLocalJSDate(r,this.getPrimaryCalendarType());if(this.getMinDate()&&this.getMinDate().getTime()>r.getTime()){s=a.fromLocalJSDate(this.getMinDate(),this.getPrimaryCalendarType())}if(this.getMaxDate()&&this.getMaxDate().getTime()<r.getTime()){s=a.fromLocalJSDate(this.getMaxDate(),this.getPrimaryCalendarType())}o.selectDate(s.toLocalJSDate());if(o.getMode()<2){this.fireSelect()}};g.prototype._adjustSelectedDate=function(t){var e=this.getAggregation("month")[0];if(e.getMode&&e.getMode()<2){this._selectDate(t)}};g.prototype._selectDate=function(t){var e=this.getAggregation("month")[0],a=t.toLocalJSDate();this.removeAllSelectedDates();this.addSelectedDate(new s({startDate:a}));e.selectDate(a);this._bDateRangeChanged=undefined};g.prototype._dateMatchesVisibleRange=function(t){return e._isSameMonthAndYear(a.fromLocalJSDate(this.getStartDate()),a.fromLocalJSDate(t))};g.prototype._togglePrevNext=function(t,n){var i=this.getAggregation("header");var o=this._oMaxDate.getYear();var r=this._oMinDate.getYear();var s=this._oMaxDate.getMonth();var h=this._oMinDate.getMonth();var g=e._getFirstDateOfMonth(new a(t,this.getPrimaryCalendarType()));var l=new a(g),u,d;l.setMonth(l.getMonth()+1);u=g.getYear();d=g.getMonth();if(u<r||u==r&&(!n||d<=h)){i.setEnabledPrevious(false)}else{i.setEnabledPrevious(true)}u=l.getYear();d=l.getMonth();if(u>o||u==o&&(!n||d>s)){i.setEnabledNext(false)}else{i.setEnabledNext(true)}};g.prototype._setMinMaxDateExtend=function(t){return n.prototype._setMinMaxDateExtend.apply(this,arguments)};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarOneMonthIntervalRenderer", ["sap/ui/core/Renderer","./CalendarDateIntervalRenderer"],function(e,t){"use strict";var n=e.extend(t);n.apiVersion=2;n.addAttributes=function(e,n){t.addAttributes.apply(this,arguments);e.class("sapUiCalOneMonthInt")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarRenderer", [],function(){"use strict";var e={apiVersion:2};var t={MONTH:"month",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker",YEAR_RANGE_PICKER:"yearRangePicker"};e.render=function(e,n){var r=n.getId(),a=n.getTooltip_AsString(),i=n.getAggregation("month"),o=n.getProperty("_currentPicker"),s=n.getWidth(),l=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),c={labelledby:{value:"",append:false}};e.openStart("div",n);e.class("sapUiCal");if(i.length>1){e.class("sapUiCalMulti")}e.accessibilityState(n,c);if(a){e.attr("title",a)}if(s){e.class("sapUiCalWidth");e.style("width",s)}if(n._getSecondaryCalendarType()){e.class("sapUiCalSecType")}if(this.addAttributes){this.addAttributes(e,n)}e.openEnd();var d=n.getAggregation("header");e.renderControl(d);e.openStart("div",r+"-content");e.class("sapUiCalContent");e.openEnd();if(n.getMonths()>1){switch(o){case t.MONTH_PICKER:case t.YEAR_PICKER:case t.YEAR_RANGE_PICKER:this.renderMonths(e,n,i);this.renderCalContentOverlay(e,n,r);break}}switch(o){case t.MONTH:this.renderMonths(e,n,i);break;case t.MONTH_PICKER:e.renderControl(n._getMonthPicker());break;case t.YEAR_PICKER:e.renderControl(n._getYearPicker());break;case t.YEAR_RANGE_PICKER:e.renderControl(n._getYearRangePicker());break}e.close("div");if(!n._bSkipCancelButtonRendering){e.openStart("button",r+"-cancel");e.class("sapUiCalCancel");e.attr("tabindex","-1");e.openEnd();e.text(l.getText("CALENDAR_CANCEL"));e.close("button")}this.renderCalContentAndArrowsOverlay(e,n,r);e.close("div")};e.renderMonths=function(e,t,n){n.forEach(function(r,a){e.renderControl(r);if(n.length===2&&a===0){e.renderControl(t.getAggregation("secondMonthHeader"))}})};e.renderCalContentOverlay=function(e,t,n){e.openStart("div",n+"-contentOver");e.class("sapUiCalContentOver");e.openEnd();e.close("div")};e.renderCalContentAndArrowsOverlay=function(e,t,n){};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarRow", ["sap/ui/core/Control","sap/ui/Device","sap/ui/core/LocaleData","sap/ui/unified/calendar/CalendarUtils","sap/ui/core/format/TimezoneUtil","sap/ui/core/Core","sap/ui/core/date/UniversalDate","./library","sap/ui/core/InvisibleText","sap/ui/core/format/DateFormat","sap/ui/core/ResizeHandler","sap/ui/core/Locale","./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarAppointment","sap/ui/core/InvisibleMessage","sap/ui/core/library","sap/ui/core/Configuration","sap/ui/core/date/UI5Date"],function(e,t,i,a,n,s,r,o,p,l,u,g,h,d,jQuery,c,f,m,v,T){"use strict";var C=o.CalendarDayType;var A=o.CalendarAppointmentVisualization;var _=o.GroupAppointmentsMode;var U=o.CalendarIntervalType;var y=o.CalendarAppointmentHeight;var D=o.CalendarAppointmentRoundWidth;var b=m.InvisibleMessageMode;var S=e.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalSize:{type:"int",group:"Appearance",defaultValue:1},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:U.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:_.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:A.Standard},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:y.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:D.None},multipleAppointmentsSelection:{type:"boolean",group:"Data",defaultValue:false}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}},renderer:h});S.prototype.init=function(){this._bRTL=v.getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=l.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+w.call(this).getTimePattern("medium")});this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(T.getInstance());this._resizeProxy=jQuery.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined};S.prototype.exit=function(){if(this._sResizeListener){u.deregister(this._sResizeListener);this._sResizeListener=undefined}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}this._fnCustomSortedAppointments=undefined};S.prototype.onBeforeRendering=function(){this._aVisibleAppointments=[];H.call(this);E.call(this);F.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}if(!this.getAppointments().length){this.aSelectedAppointments=[]}else{this.getAppointments().forEach(function(e){this._updateSelectedAppointmentsArray(e)}.bind(this))}this._oInvisibleMessage=f.getInstance()};S.prototype.onAfterRendering=function(){P.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=u.register(this,this._resizeProxy)}};S.prototype.onThemeChanged=function(e){if(this.getDomRef()){for(var t=0;t<this._aVisibleAppointments.length;t++){var i=this._aVisibleAppointments[t];i.level=-1}this.handleResize(e)}};S.prototype.invalidate=function(t){if(t&&t instanceof c){var i=false;for(var a=0;a<this._aVisibleAppointments.length;a++){if(this._aVisibleAppointments[a].appointment==t){i=true;break}}if(i){this._aVisibleAppointments=[]}this._updateSelectedAppointmentsArray(t)}e.prototype.invalidate.apply(this,arguments)};S.prototype.setStartDate=function(e){if(!e){e=T.getInstance()}a._checkJSDateObject(e);var t=e.getFullYear();a._checkYearInValidRange(t);this._oUTCStartDate=a._createUniversalUTCDate(e,undefined,true);this.setProperty("startDate",e);return this};S.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true)}return this._oUTCStartDate};S.prototype.setIntervalType=function(e){this.setProperty("intervalType",e);this._aVisibleAppointments=[];return this};S.prototype._getAppointmentReducedHeight=function(e){var i=!t.system.phone&&this.getAppointmentsReducedHeight()&&e.size===y.Regular;return i};S.prototype.onfocusin=function(e){if(jQuery(e.target).hasClass("sapUiCalendarApp")){Y.call(this,e.target.id)}else{var t=this._getVisibleAppointments();var i=false;var a;for(var n=0;n<t.length;n++){a=t[n].appointment;if(d(a.getDomRef(),e.target)){i=true;a.focus();break}}if(!i){a=this.getFocusedAppointment();if(a){a.focus()}}}};S.prototype.applyFocusInfo=function(e){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus()}return this};S.prototype.onsapleft=function(e){if(jQuery(e.target).hasClass("sapUiCalendarApp")){x.call(this,this._bRTL,1)}e.preventDefault();e.stopPropagation()};S.prototype.onsapright=function(e){if(jQuery(e.target).hasClass("sapUiCalendarApp")){x.call(this,!this._bRTL,1)}e.preventDefault();e.stopPropagation()};S.prototype.onsapup=function(e){this.fireLeaveRow({type:e.type})};S.prototype.onsapdown=function(e){this.fireLeaveRow({type:e.type})};S.prototype.onsaphome=function(e){B.call(this,e);e.preventDefault();e.stopPropagation()};S.prototype.onsapend=function(e){B.call(this,e);e.preventDefault();e.stopPropagation()};S.prototype.onsapselect=function(e){var t=this._getVisibleAppointments(),i,a;for(var n=0;n<t.length;n++){i=t[n].appointment;if(d(i.getDomRef(),e.target)){var s=!(this.getMultipleAppointmentsSelection()||e.ctrlKey||e.metaKey);O.call(this,i,s);break}}a=i.getSelected()?"APPOINTMENT_SELECTED":"APPOINTMENT_UNSELECTED";this._oInvisibleMessage.announce(this._oRb.getText(a),b.Polite);e.stopPropagation();e.preventDefault()};S.prototype.ontap=function(e){var t=this.$("Apps").children(".sapUiCalendarRowAppsInt");var i=0;var a=false;for(i=0;i<t.length;i++){var n=t[i];if(!this._isOneMonthsRowOnSmallSizes()&&d(n,e.target)){a=true;break}}if(a){j.call(this,i,e.target)}else{this.onsapselect(e)}};S.prototype.onsapselectmodifiers=function(e){this.onsapselect(e)};S.prototype.handleResize=function(e){if(e&&e.size&&e.size.width<=0){return this}var t=this.$("DummyApp");t.css("display","");P.call(this);return this};S.prototype.updateCurrentTimeVisualization=function(){var e=this.$("Now");var t=a._createUniversalUTCDate(T.getInstance(),undefined,true);var i=this.getIntervals();var n=this.getIntervalType();var s=this._getStartDate();var r=s.getTime();var o=this._oUTCEndDate;var p=o.getTime();this._sUpdateCurrentTime=undefined;if(t.getTime()<=p&&t.getTime()>=r){var l=L.call(this,n,i,s,o,r,t);var u=0;if(this._bRTL){e.css("right",l+"%")}else{e.css("left",l+"%")}e.css("display","");if(this.getUpdateCurrentTime()){switch(n){case U.Hour:u=6e4;break;case U.Day:case U.Week:case U.OneMonth:case"OneMonth":u=18e5;break;default:u=-1;break}if(u>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),u)}}}else{e.css("display","none")}return this};S.prototype.getFocusedAppointment=function(){var e=this._getAppointmentsSorted();var t=this.getAggregation("groupAppointments",[]);var i;var a=0;for(a=0;a<t.length;a++){if(t[a].getId()==this._sFocusedAppointmentId){i=t[a];break}}if(!i){for(a=0;a<e.length;a++){if(e[a].getId()==this._sFocusedAppointmentId){i=e[a];break}}}return i};S.prototype.focusAppointment=function(e){if(!e||!(e instanceof c)){throw new Error("Appointment must be a CalendarAppointment; "+this)}var t=e.getId();if(this._sFocusedAppointmentId!=t){Y.call(this,t)}else{e.focus()}return this};S.prototype.focusNearestAppointment=function(e){a._checkJSDateObject(e);var t=this._getAppointmentsSorted();var i;var n;var s;for(var r=0;r<t.length;r++){i=t[r];if(i.getStartDate()>e){if(r>0){n=t[r-1]}else{n=i}break}}if(i){if(n&&Math.abs(i.getStartDate()-e)>=Math.abs(n.getStartDate()-e)){s=n}else{s=i}this.focusAppointment(s)}return this};S.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments};S.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders};S.prototype._getNonWorkingDays=function(){if(this.getIntervalSize()!==1){return[]}var e=this.getNonWorkingDays();if(!e){var t=w.call(this);var i=t.getWeekendStart();var a=t.getWeekendEnd();e=[];for(var n=0;n<=6;n++){if(i<=a&&n>=i&&n<=a||i>a&&(n>=i||n<=a)){e.push(n)}}}else if(!Array.isArray(e)){e=[]}return e};S.prototype._isOneMonthsRowOnSmallSizes=function(){return(this.getIntervalType()===U.OneMonth||this.getIntervalType()==="OneMonth")&&this.getIntervals()===1};S.prototype._getAppointmentsSorted=function(){var e=this.getAppointments(),t=G;e.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:t);return e};S.prototype._setCustomAppointmentsSorterCallback=function(e){this._fnCustomSortedAppointments=e;this.invalidate()};S.prototype._calculateAppoitnmentVisualCue=function(e){if(M(this,e)){return{appTimeUnitsDifRowStart:0,appTimeUnitsDifRowEnd:0}}var t=e.getStartDate(),i=e.getEndDate(),a=new r(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes()),n=new r(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours(),i.getMinutes()),s=this.getIntervalType(),o=this.getStartDate(),p=s==="Hour"?new r(o.getFullYear(),o.getMonth(),o.getDate(),o.getHours()):new r(o.getFullYear(),o.getMonth(),o.getDate()),l=this.getIntervals(),u;switch(s){case"Hour":u=new r(o.getFullYear(),o.getMonth(),o.getDate(),o.getHours()+l);break;case"Day":case"Week":case"One Month":u=new r(o.getFullYear(),o.getMonth(),o.getDate()+l);break;case"Month":u=new r(o.getFullYear(),o.getMonth()+l,o.getDate());break;default:break}return{appTimeUnitsDifRowStart:p.getTime()-a.getTime(),appTimeUnitsDifRowEnd:n.getTime()-u.getTime()}};S.prototype._updateSelectedAppointmentsArray=function(e){if(e.getSelected()){if(this.aSelectedAppointments.indexOf(e.getId())===-1){this.aSelectedAppointments.push(e.getId())}}else{this.aSelectedAppointments=this.aSelectedAppointments.filter(function(t){return t!==e.getId()})}};function M(e,t){var i=e.getAggregation("groupAppointments",[]);var a;for(a=0;a<i.length;++a){if(t===i[a]){return true}}return false}function I(){if(!this._sLocale){this._sLocale=v.getFormatSettings().getFormatLocale().toString()}return this._sLocale}function w(){if(!this._oLocaleData){var e=I.call(this);var t=new g(e);this._oLocaleData=i.getInstance(t)}return this._oLocaleData}function H(){var e=this.getStartDate();var t;var i=this.getIntervals();var a=this.getIntervalType();this._oUTCStartDate=k.call(this,e);switch(a){case U.Hour:t=new r(this._oUTCStartDate.getTime());t.setUTCHours(t.getUTCHours()+i);break;case U.Day:case U.Week:case U.OneMonth:case"OneMonth":t=new r(this._oUTCStartDate.getTime());t.setUTCDate(t.getUTCDate()+i*this.getIntervalSize());break;case U.Month:t=new r(this._oUTCStartDate.getTime());t.setUTCMonth(t.getUTCMonth()+i);break;default:throw new Error("Unknown IntervalType: "+a+"; "+this)}t.setUTCMilliseconds(-1);this._iRowSize=t.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/i);this._oUTCEndDate=t}function k(e){var t=this.getIntervalType();var i=a._createUniversalUTCDate(e,undefined,true);switch(t){case U.Hour:i.setUTCMinutes(0);i.setUTCSeconds(0);i.setUTCMilliseconds(0);break;case U.Day:case U.Week:case U.OneMonth:case"OneMonth":i.setUTCHours(0);i.setUTCMinutes(0);i.setUTCSeconds(0);i.setUTCMilliseconds(0);break;case U.Month:i.setUTCDate(1);i.setUTCHours(0);i.setUTCMinutes(0);i.setUTCSeconds(0);i.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+t+"; "+this)}return i}function R(){return t.system.phone||this.getGroupAppointmentsMode()===_.Collapsed}function E(){var e=this._getAppointmentsSorted();var t;var i;var n;var s=this.getIntervals();var o=this.getIntervalType();var p=this._getStartDate();var l=p.getTime();var u=this._oUTCEndDate;var g=u.getTime();var h=[];var d=false;var c=0;var f=0;var m=R.call(this);var v=this._needAppointmentHorizontalFit();this.destroyAggregation("groupAppointments",true);for(c=0;c<e.length;c++){t=e[c];if(!t||!t.getStartDate()){continue}var C=a._createUniversalUTCDate(t.getStartDate(),undefined,true);var A=C.getTime();C.setUTCSeconds(0);C.setUTCMilliseconds(0);var _=t.getEndDate()?a._createUniversalUTCDate(t.getEndDate(),undefined,true):a._createUniversalUTCDate(T.getInstance(864e12),undefined,true);var y=_.getTime();_.setUTCSeconds(0);_.setUTCMilliseconds(0);var D=false;if(C.getTime()<l&&_.getTime()>=l){C=new r(l);D=true}if(_.getTime()>g&&C.getTime()<=g){_=new r(g);D=true}var b=(_.getTime()-C.getTime())/6e4;if(D&&b==0){continue}var S=0;var M=0;var I=-1;i=undefined;n=undefined;if(C&&C.getTime()<=g&&_&&_.getTime()>=l&&A<=y){if(m&&o==U.Month&&_.getTime()-C.getTime()<6048e5){i=V.call(this,C,t,o,s,p,u,l,h);var w=a._createUniversalUTCDate(i.getEndDate(),undefined,true);if(_.getTime()>w.getTime()){n=V.call(this,_,t,o,s,p,u,l,h)}}if(v){this._setHorizontalRoundingWidth(t,C,_)}S=L.call(this,o,s,p,u,l,C);M=z.call(this,o,s,p,u,l,_);if(i){i._iBegin=S;i._iEnd=M;i._iLevel=I;if(n){n._iBegin=S;n._iEnd=M;n._iLevel=I}continue}h.push({appointment:t,begin:S,end:M,calculatedEnd:M,level:I,size:this.getProperty("appointmentHeight")});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==t.getId()){d=true}}}var H=this.getAggregation("groupAppointments",[]);if(H.length>0){for(c=0;c<h.length;c++){t=h[c];if(t.appointment._aAppointments&&t.appointment._aAppointments.length<=1){i=t.appointment;var k=false;if(i._aAppointments.length==0){k=true}else{for(f=0;f<h.length;f++){if(h[f].appointment==i._aAppointments[0]){k=true;break}}}if(!k){for(f=0;f<H.length;f++){n=H[f];if(i!=n){for(var E=0;E<n._aAppointments.length;E++){if(i._aAppointments[0]==n._aAppointments[E]){n._aAppointments.splice(E,1);if(n._aAppointments.length==1){this.removeAggregation("groupAppointments",n);n.destroy();H=this.getAggregation("groupAppointments",[])}else{n.setProperty("title",n._aAppointments.length,true)}break}}}}t.begin=i._iBegin;t.end=i._iEnd;t.calculatedEnd=i._iEnd;t.level=i._iLevel;t.appointment=i._aAppointments[0]}else{h.splice(c,1);c--}this.removeAggregation("groupAppointments",i);i.destroy();H=this.getAggregation("groupAppointments",[])}}}if(!d){if(h.length>0){this._sFocusedAppointmentId=h[0].appointment.getId()}else{this._sFocusedAppointmentId=undefined}}this._aVisibleAppointments=h;return this._aVisibleAppointments}function V(e,t,i,n,s,o,p,l){var u=this.getAggregation("groupAppointments",[]);var g;var h=w.call(this);var d=h.getFirstDayOfWeek();var f=e.getUTCDay();var m=new r(e.getTime());m.setUTCHours(0);m.setUTCMinutes(0);m.setUTCSeconds(0);m.setUTCMilliseconds(0);if(d<=f){m.setDate(m.getDate()-(f-d))}else{m.setDate(m.getDate()-(7-f-d))}for(var v=0;v<u.length;v++){g=u[v];var A=a._createUniversalUTCDate(g.getStartDate(),undefined,true);if(A.getTime()==m.getTime()){break}g=undefined}if(!g){var _=new r(m.getTime());_.setDate(_.getDate()+7);_.setMilliseconds(-1);g=new c(this.getId()+"-Group"+u.length,{type:t.getType(),startDate:a._createLocalDate(T.getInstance(m.getTime()),true),endDate:a._createLocalDate(T.getInstance(_.getTime()),true)});g._aAppointments=[];this.addAggregation("groupAppointments",g,true);var U=L.call(this,i,n,s,o,p,m);var y=z.call(this,i,n,s,o,p,_);l.push({appointment:g,begin:U,end:y,calculatedEnd:y,level:-1,size:this.getProperty("appointmentHeight")})}g._aAppointments.push(t);if(g.getType()!=C.None&&g.getType()!=t.getType()){g.setType(C.None)}g.setProperty("title",g._aAppointments.length,true);return g}function L(e,t,i,a,n,s){var o=0;if(e!=U.Month){o=100*(s.getTime()-n)/this._iRowSize}else{var p=new r(s.getTime());p.setUTCDate(1);p.setUTCHours(0);p.setUTCMinutes(0);p.setUTCSeconds(0);p.setUTCMilliseconds(0);var l=new r(p.getTime());l.setUTCMonth(l.getUTCMonth()+1);l.setMilliseconds(-1);var u=l.getTime()-p.getTime();var g=(p.getUTCFullYear()-i.getUTCFullYear())*12+p.getUTCMonth()-i.getUTCMonth();o=100*g/t+100*(s.getTime()-p.getTime())/u/t}if(o<0){o=0}o=Math.round(o*1e5)/1e5;return o}function z(e,t,i,a,n,s){var o=0;if(e!=U.Month){o=100-100*(s.getTime()-n)/this._iRowSize}else{var p=new r(s.getTime());p.setUTCDate(1);p.setUTCHours(0);p.setUTCMinutes(0);p.setUTCSeconds(0);p.setUTCMilliseconds(0);var l=new r(p.getTime());l.setUTCMonth(l.getUTCMonth()+1);l.setMilliseconds(-1);var u=l.getTime()-p.getTime();var g=(p.getUTCFullYear()-i.getUTCFullYear())*12+p.getUTCMonth()-i.getUTCMonth();o=100-(100*g/t+100*(s.getTime()-p.getTime())/u/t)}if(o<0){o=0}o=Math.round(o*1e5)/1e5;return o}function F(){var e=[];if(this.getShowIntervalHeaders()){var t=this.getIntervalHeaders();var i;var n=this.getIntervals();var s=this.getIntervalType();var o=this._getStartDate();var p=o.getTime();var l=this._oUTCEndDate;var u=l.getTime();var g=0;var h=0;for(g=0;g<t.length;g++){i=t[g];var d=a._createUniversalUTCDate(i.getStartDate(),undefined,true);d.setUTCSeconds(0);d.setUTCMilliseconds(0);var c=i.getEndDate()?a._createUniversalUTCDate(i.getEndDate(),undefined,true):a._createUniversalUTCDate(T.getInstance(864e12),undefined,true);c.setUTCSeconds(0);c.setUTCMilliseconds(0);if(d&&d.getTime()<=u&&c&&c.getTime()>=p){var f=new r(o.getTime());var m=new r(o.getTime());m.setUTCMinutes(m.getUTCMinutes()-1);var v=-1;var C=-1;for(h=0;h<n;h++){switch(s){case U.Hour:m.setUTCHours(m.getUTCHours()+1);if(h>0){f.setUTCHours(f.getUTCHours()+1)}break;case U.Day:case U.Week:case U.OneMonth:case"OneMonth":m.setUTCDate(m.getUTCDate()+1);if(h>0){f.setUTCDate(f.getUTCDate()+1)}break;case U.Month:m.setUTCDate(1);m.setUTCMonth(m.getUTCMonth()+2);m.setUTCDate(0);if(h>0){f.setUTCMonth(f.getUTCMonth()+1)}break;default:throw new Error("Unknown IntervalType: "+s+"; "+this)}if(d&&d.getTime()<=f.getTime()&&c&&c.getTime()>=m.getTime()){if(v<0){v=h}C=h}}if(v>=0){e.push({interval:v,appointment:i,last:C})}}}}this._aVisibleIntervalHeaders=e;return this._aVisibleIntervalHeaders}function P(){if(this._isOneMonthsRowOnSmallSizes()){return}var e=this.$("Apps");var t=e.innerWidth();if(t<=0){return}var i=this.$("DummyApp");var a=i.outerHeight(true);if(a<=0){return}var n=4;var s=i.outerWidth();var r=s/t*100;var o=Math.ceil(1e3*r)/1e3;var p;var l;var u=0;var g=0;var h=0;var d=false;var c;var f=this._needAppointmentHorizontalFit();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){u=jQuery(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);d=true}for(h=0;h<this._aVisibleAppointments.length;h++){p=this._aVisibleAppointments[h];l=p.appointment.$();var m=Math.floor(1e3*(100-p.calculatedEnd-p.begin))/1e3;var v=false;if(m<o){p.end=100-p.begin-r;if(p.end<0){p.end=0}v=true;l.addClass("sapUiCalendarAppSmall")}else if(l.hasClass("sapUiCalendarAppSmall")){p.end=p.calculatedEnd;v=true;l.removeClass("sapUiCalendarAppSmall")}if(v){p.level=-1}if(v&&!f){if(this._bRTL){l.css("left",p.end+"%")}else{l.css("right",p.end+"%")}}if(f){p.end=p.calculatedEnd}}for(h=0;h<this._aVisibleAppointments.length;h++){p=this._aVisibleAppointments[h];l=p.appointment.$();var T={};if(p.level<0){for(var C=0;C<this._aVisibleAppointments.length;C++){var A=this._aVisibleAppointments[C];if(p!=A&&p.begin<Math.floor(1e3*(100-A.end))/1e3&&Math.floor(1e3*(100-p.end))/1e3>A.begin&&A.level>=0){this._setBlockedLevelsForAppointment(A,T)}}p.level=this._getAppointmetLevel(T,p);l.attr("data-sap-level",p.level)}c=a*p.level+u;if(!d){c+=n}l.css("top",c+"px");var _=p.level;_+=this._getAppointmentRowCount(p)-1;if(g<_){g=_}}g++;a=a*g+u;if(!d){a+=n}if(!this.getHeight()){e.outerHeight(a)}else{var U=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(h=0;h<U.length;h++){var y=jQuery(U[h]);y.outerHeight(a)}}i.css("display","none")}function O(e,t){var i=0;var a;var n;var s;var r;var o=p.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");var l=p.getStaticId("sap.ui.unified","APPOINTMENT_UNSELECTED");var u=!e.getSelected();if(t){var g=this.getAppointments();var h=this.getAggregation("groupAppointments",[]);jQuery.merge(g,h);for(i=0;i<g.length;i++){a=g[i];if(a.getId()!==e.getId()&&a.getSelected()){a.setProperty("selected",false,true);a.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==a.getId()){this.aSelectedAppointments.splice(i)}}n=a.$().attr("aria-labelledby");s=n?n.replace(o,l):"";a.$().attr("aria-labelledby",s)}}}r=e.$().attr("aria-labelledby").replace(l,o).trim();s=e.$().attr("aria-labelledby").replace(o,l).trim();if(e.getSelected()){e.setProperty("selected",false,true);e.$().removeClass("sapUiCalendarAppSel");e.$().attr("aria-labelledby",s);N(this,t)}else{e.setProperty("selected",true,true);e.$().addClass("sapUiCalendarAppSel");e.$().attr("aria-labelledby",r);N(this,t)}this._updateSelectedAppointmentsArray(e);if(e._aAppointments){for(i=0;i<e._aAppointments.length;i++){a=e._aAppointments[i];a.setProperty("selected",u,true)}this.fireSelect({appointments:e._aAppointments,multiSelect:!t,domRefId:e.getId()})}else{this.fireSelect({appointment:e,multiSelect:!t,domRefId:e.getId()})}}function W(e){var t=this._getPlanningCalendar();if(t){t["_onRow"+e]()}}S.prototype._needAppointmentHorizontalFit=function(){var e=this._getPlanningCalendar(),t,i,a;if(!e||this.getAppointmentRoundWidth()===D.None){return false}t=e.getViewKey();i=e._getView(t);a=e._getIntervals(i);return a>=20};S.prototype._setHorizontalRoundingWidth=function(e,t,i){var a;switch(this.getAppointmentRoundWidth()){case D.HalfColumn:a=12;break}this._roundAppointment(e,t,i,a)};S.prototype._roundAppointment=function(e,t,i,a){var n,s;n=e.getStartDate().getHours()-e.getStartDate().getHours()%a;t.setUTCHours(n);t.setUTCMinutes(0);t.setUTCSeconds(0);t.setUTCMilliseconds(0);s=e.getEndDate().getHours()-e.getEndDate().getHours()%a+a;i.setUTCHours(s);i.setUTCMinutes(0);i.setUTCSeconds(0);i.setUTCMilliseconds(0)};S.prototype._setBlockedLevelsForAppointment=function(e,t){var i=this._getAppointmentRowCount(e);for(var a=0;a<i;a++){t[e.level+a]=true}return t};S.prototype._getAppointmentRowCount=function(e){var t,i=this._getAppointmentReducedHeight(e);switch(e.size){case y.HalfSize:t=1;break;case y.Regular:t=2;if(i&&!e.appointment.getText()&&!e.appointment.getDescription()){t=1}break;case y.Large:t=3;break;case y.Automatic:t=1;if(e.appointment.getText()){t+=1}if(e.appointment.getDescription()){t+=1}break}return t};S.prototype._getAppointmetLevel=function(e,t){var i=0;var a=this._getAppointmentRowCount(t);var n=true;while(n){n=this._isPosibleToPositionAppointment(i,e,a);if(!n){n=true;i+=1}else{n=false}}return i};S.prototype._isPosibleToPositionAppointment=function(e,t,i){for(var a=e;a<i+e;a++){if(t[a]){return false}}return true};S.prototype._getPlanningCalendar=function(){var e=this;while(e.getParent()!==null){if(e.isA("sap.m.PlanningCalendar")){return e}e=e.getParent()}};function N(e,t){if(t){W.call(e,"DeselectAppointment")}}function $(e){var t=this.getAggregation("groupAppointments",[]);var i;var a=false;for(var n=0;n<t.length;n++){var s=t[n]._aAppointments;for(var r=0;r<s.length;r++){if(s[r].getId()==e){i=t[n];a=true;break}}if(a){break}}return i}function Y(e){if(this._sFocusedAppointmentId!=e){var t=this._getAppointmentsSorted();var i=this._aVisibleAppointments;var n;var s=0;n=$.call(this,e);if(n){e=n.getId();n=undefined}for(s=0;s<i.length;s++){if(i[s].appointment.getId()==e){n=i[s].appointment;break}}if(n){var r=this.getFocusedAppointment().$();var o=n.$();this._sFocusedAppointmentId=n.getId();r.attr("tabindex","-1");o.attr("tabindex","0");o.trigger("focus")}else{for(s=0;s<t.length;s++){if(t[s].getId()==e){n=t[s];break}}if(n){this._sFocusedAppointmentId=n.getId();var p=k.call(this,n.getStartDate());this.setStartDate(a._createLocalDate(p,true));if(!d(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus()}.bind(this),0)}this.fireStartDateChange()}}}}function x(e,t){var i=this._sFocusedAppointmentId;var a=this._getAppointmentsSorted();var n=this.getAggregation("groupAppointments",[]);var s;var r=0;var o=0;for(o=0;o<n.length;o++){if(n[o].getId()==i){var p=n[o]._aAppointments;if(e){i=p[p.length-1].getId()}else{i=p[0].getId()}break}}for(o=0;o<a.length;o++){if(a[o].getId()==i){r=o;break}}if(e){r=r+t}else{r=r-t}if(r<0){r=0}else if(r>=a.length){r=a.length-1}s=a[r];Y.call(this,s.getId())}function B(e){var t=this._getAppointmentsSorted();var i;var n=new r(this._getStartDate());var s=new r(this._oUTCEndDate);var o=this.getIntervalType();var p;var l;n.setUTCHours(0);s.setUTCHours(0);s.setUTCMinutes(0);s.setUTCSeconds(0);switch(o){case U.Hour:s.setUTCDate(s.getUTCDate()+1);s.setUTCMilliseconds(-1);break;case U.Day:case U.Week:case U.OneMonth:case"OneMonth":n.setUTCDate(1);s.setUTCMonth(s.getUTCMonth()+1);s.setUTCDate(1);s.setUTCMilliseconds(-1);break;case U.Month:n.setUTCMonth(0);n.setUTCDate(1);s.setUTCFullYear(s.getUTCFullYear()+1);s.setUTCMonth(1);s.setUTCDate(1);s.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+o+"; "+this)}var u=a._createLocalDate(n,true);var g=a._createLocalDate(s,true);for(var h=0;h<t.length;h++){if(t[h].getStartDate()>=u&&t[h].getStartDate()<=g){i=t[h];p=i.getId();if(e.type=="saphome"){break}}else if(t[h].getStartDate()>g){break}}l=$.call(this,p);if(l){i=l;p=i.getId()}if(p&&p!=this._sFocusedAppointmentId){Y.call(this,p)}else if(e._bPlanningCalendar&&i){i.focus()}else{this.fireLeaveRow({type:e.type})}}function j(e,t){var i=this.getIntervalType();var n=this._getStartDate();var s=new r(n.getTime());var o;var p=false;var l=0;var u=0;if(jQuery(t).hasClass("sapUiCalendarRowAppsSubInt")){p=true;var g=jQuery(jQuery(t).parent()).children(".sapUiCalendarRowAppsSubInt");u=g.length;for(l=0;l<u;l++){var h=g[l];if(h==t){break}}}switch(i){case U.Hour:s.setUTCHours(s.getUTCHours()+e);if(p){s.setUTCMinutes(s.getUTCMinutes()+l*60/u);o=new r(s.getTime());o.setUTCMinutes(o.getUTCMinutes()+60/u)}else{o=new r(s.getTime());o.setUTCHours(o.getUTCHours()+1)}break;case U.Day:case U.Week:case U.OneMonth:case"OneMonth":s.setUTCDate(s.getUTCDate()+e);if(p){s.setUTCHours(s.getUTCHours()+l*24/u);o=new r(s.getTime());o.setUTCHours(o.getUTCHours()+24/u)}else{o=new r(s.getTime());o.setUTCDate(o.getUTCDate()+1)}break;case U.Month:s.setUTCMonth(s.getUTCMonth()+e);if(p){s.setUTCDate(s.getUTCDate()+l);o=new r(s.getTime());o.setUTCDate(o.getUTCDate()+1)}else{o=new r(s.getTime());o.setUTCMonth(o.getUTCMonth()+1)}break;default:throw new Error("Unknown IntervalType: "+i+"; "+this)}o.setUTCMilliseconds(o.getUTCMilliseconds()-1);s=a._createLocalDate(s,true);o=a._createLocalDate(o,true);this.fireIntervalSelect({startDate:s,endDate:o,subInterval:p})}function G(e,t){var i=e.getStartDate()-t.getStartDate();if(i==0){i=t.getEndDate()-e.getEndDate()}return i}return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarRowRenderer", ["sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarAppointment","sap/ui/unified/CalendarLegendRenderer","sap/ui/Device","sap/ui/unified/library","sap/ui/core/InvisibleText","sap/ui/core/date/UI5Date","sap/base/Log","sap/ui/core/IconPool"],function(e,t,a,n,r,i,s,l){"use strict";var o=r.CalendarDayType;var p=r.CalendarIntervalType;var d=r.CalendarAppointmentVisualization;var g=r.CalendarAppointmentHeight;var c={apiVersion:2};c.render=function(e,t){var a=t.getTooltip_AsString();var r=t.getAppointmentsVisualization();var i=this.getLegendItems(t);e.openStart("div",t);e.class("sapUiCalendarRow");if(!n.system.phone&&t.getAppointmentsReducedHeight()){e.class("sapUiCalendarRowAppsRedHeight")}if(r!=d.Standard){e.class("sapUiCalendarRowVis"+r)}if(a){e.attr("title",a)}var s=t.getWidth();if(s){e.style("width",s)}var l=t.getHeight();if(l){e.style("height",l)}e.accessibilityState(t,{role:"row"});e.openEnd();this.renderAppointmentsRow(e,t,i);e.close("div")};c.renderAppointmentsRow=function(e,t,a){var n=t.getId();e.openStart("div",n+"-Apps");e.class("sapUiCalendarRowApps");e.attr("role","list");e.openEnd();this.renderBeforeAppointments(e,t);this.renderAppointments(e,t,a);this.renderAfterAppointments(e,t);e.close("div")};c.renderBeforeAppointments=function(e,t){};c.renderAfterAppointments=function(e,t){};c.renderResizeHandle=function(e,t,a){};c.renderAppointments=function(t,a,n){var r=a._getVisibleAppointments();var i=a._getVisibleIntervalHeaders();var s=a._getStartDate();var l=[];var o=0;var d=0;var g=[];var c=0;var v=0;var f=a.getIntervals();var u=a.getIntervalType();var A=100/f;var C=0;var T=new e(s);var I=false;var h=false;switch(u){case p.Hour:l=a.getNonWorkingHours()||[];o=s.getUTCHours();d=24;break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":l=a._getNonWorkingDays();o=s.getUTCDay();d=7;g=a.getNonWorkingHours()||[];c=s.getUTCHours();v=24;break;case p.Month:g=a._getNonWorkingDays();c=s.getUTCDay();v=7;break;default:break}if(a._isOneMonthsRowOnSmallSizes()){this.renderSingleDayInterval(t,a,r,n,i,l,o,d,g,c,v,true,true)}else{for(C=0;C<f;C++){if(h){I=true}else{I=false}h=false;switch(u){case p.Hour:T.setUTCHours(T.getUTCHours()+1);if(T.getUTCHours()==0){h=true}break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":T.setUTCDate(T.getUTCDate()+1);if(T.getUTCDate()==1){h=true}break;case p.Month:c=T.getUTCDay();T.setUTCMonth(T.getUTCMonth()+1);if(T.getUTCMonth()==0){h=true}break;default:break}this.renderInterval(t,a,C,A,i,l,o,d,g,c,v,I,h)}this.renderIntervalHeaders(t,a,A,i,f);if(!(a._getRelativeInfo&&a._getRelativeInfo().bIsRelative)){t.openStart("div",a.getId()+"-Now");t.class("sapUiCalendarRowNow");t.openEnd();t.close("div")}for(C=0;C<r.length;C++){var m=r[C];this.renderAppointment(t,a,m,n)}t.openStart("div",a.getId()+"-DummyApp");t.class("sapUiCalendarApp");t.class("sapUiCalendarAppTitleOnly");t.class("sapUiCalendarAppDummy");t.class("sapUiCalendarAppHeight1");t.openEnd();t.close("div")}};c.writeCustomAttributes=function(e,t){};c.renderInterval=function(t,a,n,r,i,l,o,d,g,c,v,f,u,A){var C=a.getId()+"-AppsInt"+n;var T;var I=a.getShowIntervalHeaders()&&(a.getShowEmptyIntervalHeaders()||i.length>0);var h=a.getStartDate().getMonth();var m=s.getInstance(a.getStartDate().getFullYear(),h+1,0).getDate();t.openStart("div",C);t.class("sapUiCalendarRowAppsInt");if(A){t.class(A)}t.style("width",r+"%");if(n>=m&&(a.getIntervalType()===p.OneMonth||a.getIntervalType()==="OneMonth")){t.class("sapUiCalItemOtherMonth")}for(T=0;T<l.length;T++){if((n+o)%d==l[T]){t.class("sapUiCalendarRowAppsNoWork");break}}if(!I){t.class("sapUiCalendarRowAppsIntNoHead")}if(f){t.class("sapUiCalendarRowAppsIntFirst")}if(u){t.class("sapUiCalendarRowAppsIntLast")}this.writeCustomAttributes(t,a);t.openEnd();if(I){t.openStart("div");t.class("sapUiCalendarRowAppsIntHead");t.openEnd();t.close("div")}if(a.getShowSubIntervals()){var U=a.getIntervalType();var b=0;switch(U){case p.Hour:b=4;break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":b=24;break;case p.Month:var S=a._getStartDate();var R=new e(S);R.setUTCMonth(R.getUTCMonth()+n+1,0);b=R.getUTCDate();R.setUTCDate(1);o=R.getUTCDay();break;default:break}var y=100/b;for(T=0;T<b;T++){t.openStart("div");t.class("sapUiCalendarRowAppsSubInt");t.style("width",y+"%");for(var w=0;w<g.length;w++){if((T+c)%v==g[w]){t.class("sapUiCalendarRowAppsNoWork");break}}t.openEnd();t.close("div")}}t.close("div")};c.renderIntervalHeaders=function(e,t,a,n,r){var i=t.getShowIntervalHeaders()&&(t.getShowEmptyIntervalHeaders()||n.length>0);if(i){for(var s=0;s<n.length;s++){var l=n[s],o,p;if(t._bRTL){p=a*l.interval;o=a*(r-l.last-1)}else{o=a*l.interval;p=a*(r-l.last-1)}this.renderIntervalHeader(e,t,l,t._bRTL,o,p)}}};c.renderIntervalHeader=function(e,t,a,n,r,i){var s=a.appointment.getId(),l={labelledby:{value:s+"-Descr",append:true}},p;var d=t._calculateAppoitnmentVisualCue(a.appointment);e.openStart("div",a.appointment);e.class("sapUiCalendarRowAppsIntHead");if(r!==undefined){e.style("left",r+"%")}if(i!==undefined){e.style("right",i+"%")}e.class("sapUiCalendarRowAppsIntHeadFirst");if(a.appointment.getSelected()){e.class("sapUiCalendarRowAppsIntHeadSel")}if(a.appointment.getTentative()){e.class("sapUiCalendarRowAppsIntHeadTent")}var g=a.appointment.getTooltip_AsString();if(g){e.attr("title",g)}var c=a.appointment.getType();var v=a.appointment.getColor();if(!v&&c&&c!=o.None){e.class("sapUiCalendarRowAppsIntHead"+c)}if(v){if(n){e.style("border-right-color",v)}else{e.style("border-left-color",v)}}e.accessibilityState(a.appointment,l);e.openEnd();e.openStart("div");e.class("sapUiCalendarIntervalHeaderCont");if(v){e.style("background-color",a.appointment._getCSSColorForBackground(v))}e.openEnd();if(d.appTimeUnitsDifRowStart>0){e.icon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null,role:"img"})}var f=a.appointment.getIcon();if(f){var u=["sapUiCalendarRowAppsIntHeadIcon"];var A={};A["id"]=s+"-Icon";A["title"]=null;A["alt"]=null;A["role"]="presentation";e.icon(f,u,A)}var C=a.appointment.getTitle();if(C){e.openStart("span",s+"-Title");e.class("sapUiCalendarRowAppsIntHeadTitle");e.openEnd();e.text(C);e.close("span")}var T=a.appointment.getText();if(T){e.openStart("span",s+"-Text");e.class("sapUiCalendarRowAppsIntHeadText");e.openEnd();e.text(T);e.close("span")}if(d.appTimeUnitsDifRowEnd>0){e.icon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null,role:"img"})}p=t._oRb.getText("CALENDAR_START_TIME")+": "+t._oFormatAria.format(a.appointment.getStartDate())+"; "+t._oRb.getText("CALENDAR_END_TIME")+": "+t._oFormatAria.format(a.appointment.getEndDate());if(c&&c!==o.None){p+="; "+this.getAriaTextForType(c,this.getLegendItems(t))}e.openStart("span",s+"-Descr");e.class("sapUiInvisibleText");e.openEnd();e.text(p);e.close("span");e.close("div");e.close("div")};c.renderAppointment=function(e,t,a,n,r){var s=a.appointment;var l=s.getTooltip_AsString();var p=s.getType();var c=s.getColor();var v=s.getTitle();var f=s.getText();var u=s.getDescription();var A=s.getIcon();var C=s.getId();var T=t._getAppointmentReducedHeight(a);var I={role:"listitem",labelledby:{value:i.getStaticId("sap.ui.unified","APPOINTMENT")+" "+C+"-Descr",append:true},selected:null};var h=t._getAppointmentRowCount(a,T);var m=t.getAriaLabelledBy();var U=t._calculateAppoitnmentVisualCue(s);if(m.length>0){I["labelledby"].value=I["labelledby"].value+" "+m.join(" ")}if(v){I["labelledby"].value=I["labelledby"].value+" "+C+"-Title"}if(f){I["labelledby"].value=I["labelledby"].value+" "+C+"-Text"}e.openStart("div",s);e.class("sapUiCalendarApp");e.class("sapUiCalendarAppHeight"+h);if(s.getSelected()){e.class("sapUiCalendarAppSel");I["labelledby"].value=i.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED")+" "+I["labelledby"].value}else{I["labelledby"].value=i.getStaticId("sap.ui.unified","APPOINTMENT_UNSELECTED")+" "+I["labelledby"].value}if(s.getTentative()){e.class("sapUiCalendarAppTent");I["labelledby"].value=I["labelledby"].value+" "+i.getStaticId("sap.ui.unified","APPOINTMENT_TENTATIVE")}if(h===1){e.class("sapUiCalendarAppTitleOnly")}if(A){e.class("sapUiCalendarAppWithIcon")}if(!r){if(t._bRTL){e.style("right",a.begin+"%");e.style("left",a.end+"%")}else{e.style("left",a.begin+"%");e.style("right",a.end+"%")}}e.attr("data-sap-level",a.level);if(t._sFocusedAppointmentId==C){e.attr("tabindex","0")}else{e.attr("tabindex","-1")}if(l){e.attr("title",l)}if(!c&&p&&p!=o.None){e.class("sapUiCalendarApp"+p)}if(c){if(t._bRTL){e.style("border-right-color",c)}else{e.style("border-left-color",c)}}e.accessibilityState(s,I);e.openEnd();e.openStart("div");e.class("sapUiCalendarAppCont");if(c&&t.getAppointmentsVisualization()===d.Filled){e.style("background-color",s._getCSSColorForBackground(c))}e.openEnd();if(s.getCustomContent().length){s.getCustomContent().forEach(function(t){e.renderControl(t)})}else{if(U.appTimeUnitsDifRowStart>0){e.icon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null,role:"img"})}if(A){var b=["sapUiCalendarAppIcon"];var S={};S["id"]=C+"-Icon";S["title"]=null;S["alt"]=null;S["role"]="presentation";e.icon(A,b,S)}e.openStart("div");e.class("sapUiCalendarAppTitleWrapper");e.openEnd();if(v){e.openStart("span",C+"-Title");e.class("sapUiCalendarAppTitle");e.openEnd();e.text(v);e.close("span")}if(f&&a.size!==g.HalfSize){e.openStart("span",C+"-Text");e.class("sapUiCalendarAppText");e.openEnd();e.text(f);e.close("span")}if(u&&a.size!==g.HalfSize&&(a.size!==g.Regular||!f)){e.openStart("span",C+"-Info");e.class("sapUiCalendarAppDescription");e.openEnd();e.text(u);e.close("span")}e.close("div");if(U.appTimeUnitsDifRowEnd>0){e.icon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null,role:"img"})}}var R=t._oRb.getText("CALENDAR_START_TIME")+": "+t._oFormatAria.format(s.getStartDate());R=R+"; "+t._oRb.getText("CALENDAR_END_TIME")+": "+t._oFormatAria.format(s.getEndDate());if(t._getRelativeInfo&&t._getRelativeInfo().bIsRelative){var y=t._getRelativeInfo();R=t._oRb.getText("CALENDAR_START_TIME")+": "+y.intervalLabelFormatter(y._getIndexFromDate(s.getStartDate()));R=R+"; "+t._oRb.getText("CALENDAR_END_TIME")+": "+y.intervalLabelFormatter(y._getIndexFromDate(s.getEndDate()))}if(p&&p!=o.None){R=R+"; "+this.getAriaTextForType(p,n)}e.openStart("span",C+"-Descr");e.class("sapUiInvisibleText");e.openEnd();e.text(R);e.close("span");e.close("div");this.renderResizeHandle(e,t,s);e.close("div")};c.renderSingleDayInterval=function(a,n,r,i,l,o,d,g,c,v,f,u,A){var C=1,T=100,I=n.getId()+"-AppsInt"+C,h,m=n.getShowIntervalHeaders()&&(n.getShowEmptyIntervalHeaders()||l.length>0),U=s.getInstance(n.getStartDate()),b=U.getMonth(),S=s.getInstance(U.getFullYear(),b+1,0).getDate(),R,y=n._getPlanningCalendar(),w,E,D=[];U.setHours(0,0,0,0);w=r.concat(n.getIntervalHeaders().filter(function(e){var t=e.getStartDate().getTime(),a=e.getEndDate().getTime(),n=U.getTime(),r=n+1e3*60*60*24;return!(t>=r||a<=n)}).map(function(e){return{appointment:e,isHeader:true}})).sort(t._getComparer(U));if(y){D=y._getSelectedDates()}a.openStart("div",I);a.class("sapUiCalendarRowAppsInt");a.class("sapUiCalendarMonthRowAppsS");a.style("width",T+"%");if(C>=S&&(n.getIntervalType()===p.OneMonth||n.getIntervalType()==="OneMonth")){a.class("sapUiCalItemOtherMonth")}for(h=0;h<o.length;h++){if((C+d)%g==o[h]){a.class("sapUiCalendarRowAppsNoWork");break}}if(!m){a.class("sapUiCalendarRowAppsIntNoHead")}if(u){a.class("sapUiCalendarRowAppsIntFirst")}if(A){a.class("sapUiCalendarRowAppsIntLast")}a.openEnd();if(m){a.openStart("div");a.class("sapUiCalendarRowAppsIntHead");a.openEnd();a.close("div")}if(D.length>0){var _=0,H=w.length;if(y.getRows()[0]._calculateVisibleAppointments){var N=y.getRows()[0]._calculateVisibleAppointments(D,w);_=N.iStart;H=N.iEnd}for(h=_;h<H;h++){E=w[h];a.openStart("div");a.class("sapUiCalendarAppContainer");a.openEnd();a.openStart("div");a.class("sapUiCalendarAppContainerLeft");a.openEnd();a.openStart("div");a.class("sapUiCalendarAppStart");a.openEnd();a.text(E.appointment._getDateRangeIntersectionText(U).start);a.close("div");a.openStart("div");a.class("sapUiCalendarAppEnd");a.openEnd();a.text(E.appointment._getDateRangeIntersectionText(U).end);a.close("div");a.close("div");a.openStart("div");a.class("sapUiCalendarAppContainerRight");a.openEnd();if(E.isHeader){this.renderIntervalHeader(a,n,E)}else{this.renderAppointment(a,n,E,i,true)}a.close("div");a.close("div")}}if(r.length===0||D.length===0){a.openStart("div");a.class("sapUiCalendarNoApps");a.openEnd();var x=sap.ui.getCore().byId(n.getAssociation("row"));R=x.getNoAppointmentsText()?x.getNoAppointmentsText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PLANNINGCALENDAR_ROW_NO_APPOINTMENTS");a.text(R);a.close("div")}if(!(n._getRelativeInfo&&n._getRelativeInfo().bIsRelative)){a.openStart("div",n.getId()+"-Now");a.class("sapUiCalendarRowNow");a.openEnd()}a.close("div");a.openStart("div",n.getId()+"-DummyApp");a.class("sapUiCalendarApp");a.class("sapUiCalendarAppTitleOnly");a.class("sapUiCalendarAppDummy");a.style("margin","0");a.style("height","0px");a.openEnd();a.close("div");if(n.getShowSubIntervals()){var M=n.getIntervalType();var k=0;switch(M){case p.Hour:k=4;break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":k=24;break;case p.Month:var L=new e(U);L.setUTCMonth(L.getUTCMonth()+C+1,0);k=L.getUTCDate();L.setUTCDate(1);d=L.getUTCDay();break;default:break}var O=100/k;for(h=0;h<k;h++){a.openStart("div");a.class("sapUiCalendarRowAppsSubInt");a.style("width",O+"%");for(var F=0;F<c.length;F++){if((h+v)%f==c[F]){a.class("sapUiCalendarRowAppsNoWork");break}}a.openEnd();a.close("div")}}a.close("div")};c.getLegendItems=function(e){var t=[],a,n=e.getLegend();if(n){a=sap.ui.getCore().byId(n);if(a){t=a.getItems()}else{l.error("CalendarLegend with id '"+n+"' does not exist!",e)}}return t};c.getAriaTextForType=function(e,t){var n,r,i,s;if(t&&t.length){for(var s=0;s<t.length;s++){i=t[s];if(i.getType()===e){n=i.getText();break}}}if(!n){r=a.getTypeAriaText(e);if(r){n=r.getText()}}return n};return c},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarTimeInterval", ["sap/m/Popover","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/LocaleData","sap/ui/unified/calendar/CalendarUtils","./calendar/Header","./calendar/TimesRow","./calendar/DatesRow","./calendar/MonthPicker","./calendar/YearPicker","sap/ui/core/date/UniversalDate","./library","sap/ui/core/format/DateFormat","sap/ui/Device","sap/ui/core/Locale","./CalendarTimeIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/unified/DateRange","sap/ui/core/date/UI5Date","sap/ui/unified/Calendar"],function(e,t,a,i,s,r,o,n,h,g,l,c,u,D,_,d,f,p,T,v,C,M){"use strict";var m=a.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},_currentPicker:{type:"string",group:"Appearance",defaultValue:"timesRow",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}},renderer:d});var U={TIMES_ROW:"timesRow",DATES_ROW:"datesRow",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker"};m.prototype.init=function(){this._iMode=0;this._oYearFormat=u.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new l(C.getInstance(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new l(C.getInstance(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initializeMonthPicker();this._initializeYearPicker();this.setPickerPopup(false);this._iItemsHead=15};m.prototype._initializeHeader=function(){var e=new r(this.getId()+"--Head"),a=t.getLibraryResourceBundle("sap.m");e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",e);if(e){e.setAriaLabelButton0(a.getText("DATETIMEPICKER_DATE"));e.setAriaLabelButton1(a.getText("MOBISCROLL_MONTH"));e.setAriaLabelButton2(a.getText("MOBISCROLL_YEAR"))}};m.prototype._initializeTimesRow=function(){var e=new o(this.getId()+"--TimesRow");e.attachEvent("focus",V,this);e.attachEvent("select",N,this);e._bNoThemeChange=true;this.setAggregation("timesRow",e)};m.prototype._initializeMonthPicker=function(){var e=this._createMonthPicker();this.setAggregation("monthPicker",e);e._setSelectedDatesControlOrigin(this)};m.prototype._initializeYearPicker=function(){var e=this._createYearPicker();this.setAggregation("yearPicker",e);e._setSelectedDatesControlOrigin(this)};m.prototype._createDatesRow=function(){var e=new n(this.getId()+"--DatesRow",{days:18,selectedDates:[new v(this.getId()+"--Range")]});e.attachEvent("focus",W,this);e.attachEvent("select",z,this);e._bNoThemeChange=true;e.getIntervalSelection=function(){return this.getProperty("intervalSelection")};e.getSingleSelection=function(){return this.getProperty("singleSelection")};e.getSelectedDates=function(){return this.getAggregation("selectedDates",[])};e.getSpecialDates=function(){return this.getAggregation("specialDates",[])};e.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[])};return e};m.prototype._createMonthPicker=function(){var e=new h(this.getId()+"--MP",{columns:0,months:6});e.attachEvent("select",j,this);e._bNoThemeChange=true;e.attachEvent("pageChange",Q,this);return e};m.prototype._createYearPicker=function(){var e=new g(this.getId()+"--YP",{columns:0,years:6});e.attachEvent("select",K,this);e.attachEvent("pageChange",Z,this);e._oMinDate.setYear(this._oMinDate.getUTCFullYear());e._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return e};m.prototype.exit=function(){if(this._oPopup){this._oPopup.destroy();this._oPopup=null}if(this._oCalendar){this._oCalendar.removeDelegate(this._oFocusCalendarDelegate);this._oCalendar.destroy();this._oCalendar=null}if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent)}};m.prototype.onBeforeRendering=function(){var e=this.getAggregation("timesRow");var t=this._getFocusedDate();x.call(this);e.displayDate(s._createLocalDate(t,true))};m.prototype._setAriaRole=function(e){var t=this.getAggregation("timesRow");t._setAriaRole(e);t.invalidate();return this};m.prototype._getCalendar=function(){var e;if(!this._oCalendar){e=new M(this.getId()+"--Cal",{});e.attachEvent("select",H,this);e.attachEvent("cancel",function(e){this._oPopup.close();var t=this.getAggregation("header").getDomRef("B1");if(t){t.focus()}},this);this._oFocusCalendarDelegate={onAfterRendering:function(){this.focus()}};e.addDelegate(this._oFocusCalendarDelegate,e);this._oCalendar=e}return this._oCalendar};m.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker")};m.prototype._getYearPicker=function(){return this.getAggregation("yearPicker")};m.prototype.setStartDate=function(e){s._checkJSDateObject(e);if(p(this.getStartDate(),e)){return this}var t=e.getFullYear();s._checkYearInValidRange(t);var a=this.getMinDate();if(a&&e.getTime()<a.getTime()){T.warning("startDate < minDate -> minDate as startDate set",this);e=C.getInstance(a)}var i=this.getMaxDate();if(i&&e.getTime()>i.getTime()){T.warning("startDate > maxDate -> maxDate as startDate set",this);e=C.getInstance(i)}this.setProperty("startDate",e);var r=this.getAggregation("timesRow");r.setStartDate(e);this._oUTCStartDate=new l(r._getStartDate().getTime());x.call(this);var o=s._createLocalDate(this._getFocusedDate(),true);if(!r.checkDateFocusable(o)){this._setFocusedDate(this._oUTCStartDate);r.displayDate(e)}return this};m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};m.prototype.setIntervalMinutes=function(e){if(e>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this)}if(1440%e>0){throw new Error("A day must be divisible by the interval size; "+this)}this.setProperty("intervalMinutes",e);var t=this.getAggregation("timesRow");var a=s._createLocalDate(this._getFocusedDate(),true);if(!t.checkDateFocusable(a)){var i=y.call(this);this._setFocusedDate(i);t.setDate(s._createLocalDate(i,true))}return this};m.prototype.setLocale=function(e){if(this._sLocale!=e){this._sLocale=e;this._oLocaleData=undefined;this.invalidate()}return this};m.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=t.getConfiguration().getFormatSettings().getFormatLocale().toString()}return this._sLocale};m.prototype._getFocusedDate=function(){if(!this._oFocusedDate){k.call(this)}return this._oFocusedDate};m.prototype._setFocusedDate=function(e){if(!(e instanceof l)){throw new Error("Date must be a UniversalDate object "+this)}this._oFocusedDate=new l(e.getTime())};m.prototype.focusDate=function(e){var t=false;var a=this.getAggregation("timesRow");if(!a.checkDateFocusable(e)){var i=s._createUniversalUTCDate(e,undefined,true);$.call(this,i);t=true}L.call(this,e,false);if(t){this.fireStartDateChange()}return this};m.prototype.displayDate=function(e){L.call(this,e,true);return this};m.prototype.setItems=function(e){this.setProperty("items",e);e=this._getItems();var t=this.getAggregation("timesRow");t.setItems(e);var a=s._createLocalDate(this._getFocusedDate(),true);if(!t.checkDateFocusable(a)){var i=y.call(this);this._setFocusedDate(i);t.setDate(s._createLocalDate(i,true))}if(!this.getPickerPopup()){var r=this.getAggregation("datesRow");var o=Math.floor(e*1.5);if(o>31){o=31}r.setDays(o);var n=this._getMonthPicker();var h=Math.floor(e/2);if(h>12){h=12}n.setMonths(h);var g=this._getYearPicker();var l=Math.floor(e/2);if(l>20){l=20}g.setYears(l)}x.call(this);return this};m.prototype._getItems=function(){var e=this.getItems();if(D.system.phone&&e>6){return 6}else{return e}};m.prototype._getLocaleData=function(){if(!this._oLocaleData){var e=this.getLocale();var t=new _(e);this._oLocaleData=i.getInstance(t)}return this._oLocaleData};m.prototype.setPickerPopup=function(e){var t=this.getAggregation("header"),a,i,s;this.setProperty("pickerPopup",e);if(a){a.destroy()}if(e){t.setVisibleButton0(false);t.setVisibleButton1(true);t.setVisibleButton2(false);t.detachEvent("pressButton1",J,this);t.attachEvent("pressButton1",J,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy()}if(this._getMonthPicker()){this._getMonthPicker().destroy()}if(this._getYearPicker()){this._getYearPicker().destroy()}}else{t.setVisibleButton0(true);t.setVisibleButton1(true);t.setVisibleButton2(true);t.detachEvent("pressButton0",O,this);t.attachEvent("pressButton0",O,this);t.detachEvent("pressButton1",J,this);t.attachEvent("pressButton1",J,this);t.detachEvent("pressButton2",B,this);t.attachEvent("pressButton2",B,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow())}if(!this._getYearPicker()){this.setAggregation("yearPicker",this._createYearPicker())}if(!this._getMonthPicker()){this.setAggregation("monthPicker",this._createMonthPicker())}i=this._getMonthPicker();s=this._getYearPicker();i.setColumns(0);i.setMonths(6);s.setColumns(0);s.setYears(6)}return this};m.prototype.setMinDate=function(e){var t,a,i,r;if(p(e,this.getMinDate())){return this}if(!e){s._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0)}else{s._checkJSDateObject(e);this._oMinDate=s._createUniversalUTCDate(e,undefined,true);t=this.getAggregation("timesRow");this._oMinDate=t._getIntervalStart(this._oMinDate);a=this._oMinDate.getUTCFullYear();s._checkYearInValidRange(a);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){T.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=s._createUniversalUTCDate(e,undefined,true);s._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",s._createLocalDate(this._oMaxDate,true))}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){T.warning("focused date < minDate -> minDate focused",this);this.focusDate(e)}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){T.warning("start date < minDate -> minDate set as start date",this);P.call(this,new l(this._oMinDate.getTime()),true,true)}}this.setProperty("minDate",e);if(this.getPickerPopup()){r=this._getCalendar();r.setMinDate(e)}else{i=this._getYearPicker();i._oMinDate.setYear(this._oMinDate.getUTCFullYear())}return this};m.prototype.setMaxDate=function(e){var t,a,i,r,o,n;if(p(e,this.getMaxDate())){return this}if(!e){s._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0)}else{s._checkJSDateObject(e);this._oMaxDate=s._createUniversalUTCDate(e,undefined,true);t=this.getAggregation("timesRow");this._oMaxDate=t._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);a=this._oMaxDate.getUTCFullYear();s._checkYearInValidRange(a);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){T.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=s._createUniversalUTCDate(e,undefined,true);s._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",s._createLocalDate(this._oMinDate,true))}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){T.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(e)}}if(this._oUTCStartDate){i=new l(this._oUTCStartDate.getTime());i.setUTCMinutes(i.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(i.getTime()>this._oMaxDate.getTime()){r=new l(this._oMaxDate.getTime());r.setUTCMinutes(r.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(r.getTime()>=this._oMinDate.getTime()){T.warning("end date > maxDate -> maxDate set as end date",this);P.call(this,r,true,true)}}}}this.setProperty("maxDate",e);if(this.getPickerPopup()){n=this._getCalendar();n.setMaxDate(e)}else{o=this._getYearPicker();o._oMaxDate.setYear(this._oMaxDate.getUTCFullYear())}return this};m.prototype.onclick=function(e){if(e.isMarked("delayedMouseEvent")){return}if(e.target.id==this.getId()+"-cancel"){this.onsapescape(e)}};m.prototype.onmousedown=function(e){e.preventDefault();e.setMark("cancelAutoClose")};m.prototype.onsapescape=function(e){if(this.getPickerPopup()){S.call(this);this.fireCancel()}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:case 2:case 3:this.setProperty("_currentPicker",U.TIMES_ROW);break}}};m.prototype.setProperty=function(){var e=arguments[0],t=arguments[1];a.prototype.setProperty.apply(this,arguments);if(e==="_currentPicker"){switch(t){case"timesRow":this._iMode=0;break;case"datesRow":this._iMode=1;break;case"monthPicker":this._iMode=2;break;case"yearPicker":this._iMode=3;break;default:return}}return this};m.prototype._handlePrevious=function(e){var t=this._getFocusedDate(),a,i,r,o,n,h,g,c;switch(this._iMode){case 0:a=this._getItems();i=new l(y.call(this).getTime());r=this.getIntervalMinutes();i.setUTCMinutes(i.getUTCMinutes()-a*r);t.setUTCMinutes(t.getUTCMinutes()-a*r);this._setFocusedDate(t);P.call(this,i,true);break;case 1:if(!this.getPickerPopup()){o=this.getAggregation("datesRow");n=s._createUniversalUTCDate(o.getDate());h=o.getDays();if(n.getUTCDate()<=h){n.setUTCDate(1)}else{n.setUTCDate(n.getUTCDate()-h)}q.call(this,n)}break;case 2:if(!this.getPickerPopup()){g=this._getMonthPicker();if(g.getMonths()<12){g.previousPage();A.call(this)}else{t.setUTCFullYear(t.getUTCFullYear()-1);$.call(this,t);this._setFocusedDate(t);x.call(this);G.call(this,t.getUTCFullYear(),g);this.fireStartDateChange()}}break;case 3:if(!this.getPickerPopup()){c=this._getYearPicker();c.previousPage();I.call(this)}break}};m.prototype._handleNext=function(e){var t=this._getFocusedDate();switch(this._iMode){case 0:var a=this._getItems();var i=new l(y.call(this).getTime());var r=this.getIntervalMinutes();i.setUTCMinutes(i.getUTCMinutes()+a*r);t.setUTCMinutes(t.getUTCMinutes()+a*r);this._setFocusedDate(t);P.call(this,i,true);break;case 1:if(!this.getPickerPopup()){var o=this.getAggregation("datesRow");var n=s._createUniversalUTCDate(o.getDate());var h=new l(n.getTime());h.setUTCDate(1);h.setUTCMonth(h.getUTCMonth()+1);h.setUTCDate(0);var g=o.getDays();if(n.getUTCDate()+g>h.getUTCDate()){n.setUTCDate(h.getUTCDate())}else{n.setUTCDate(n.getUTCDate()+g)}q.call(this,n)}break;case 2:if(!this.getPickerPopup()){var c=this._getMonthPicker();if(c.getMonths()<12){c.nextPage();A.call(this)}else{t.setUTCFullYear(t.getUTCFullYear()+1);$.call(this,t);this._setFocusedDate(t);x.call(this);G.call(this,t.getUTCFullYear(),c);this.fireStartDateChange()}}break;case 3:if(!this.getPickerPopup()){var u=this._getYearPicker();u.nextPage();I.call(this)}break}};m.prototype._getShowItemHeader=function(){var e=this.getItems();if(e>this._iItemsHead){return true}else{return false}};function P(e,t,a){var i=new l(this._oMaxDate.getTime());i.setUTCMinutes(i.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(i.getTime()<this._oMinDate.getTime()){i=new l(this._oMinDate.getTime());i.setUTCMinutes(i.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1))}if(e.getTime()<this._oMinDate.getTime()){e=new l(this._oMinDate.getTime())}else if(e.getTime()>i.getTime()){e=i}var r=this.getAggregation("timesRow");var o=s._createLocalDate(e,true);r.setStartDate(o);this._oUTCStartDate=new l(r._getStartDate().getTime());o=s._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",o);x.call(this);if(t){var n=s._createLocalDate(this._getFocusedDate(),true);if(!r.checkDateFocusable(n)){this._setFocusedDate(e);r.setDate(o)}else{r.setDate(n)}}if(!a){this.fireStartDateChange()}}function y(){if(!this._oUTCStartDate){var e=this.getAggregation("timesRow");e.setStartDate(s._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new l(e._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate)}return this._oUTCStartDate}function w(e){var t=this._getFocusedDate();var a=this.getAggregation("timesRow");if(!e){a.setDate(s._createLocalDate(t,true))}else{a.displayDate(s._createLocalDate(t,true))}x.call(this)}function k(){var e=this.getSelectedDates();if(e&&e[0]&&e[0].getStartDate()){this._oFocusedDate=s._createUniversalUTCDate(e[0].getStartDate(),undefined,true)}else{var t=C.getInstance();this._oFocusedDate=s._createUniversalUTCDate(t,undefined,true)}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new l(this._oMinDate.getTime())}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new l(this._oMaxDate.getTime())}}m.prototype._showCalendarPicker=function(){var e=s._createLocalDate(this._getFocusedDate(),true);var t=this._getCalendar();var a=new v({startDate:e});t.displayDate(e,false);t.removeAllSelectedDates();t.addSelectedDate(a);t.setMinDate(this.getMinDate());t.setMaxDate(this.getMaxDate());X.call(this,t);this._showOverlay()};m.prototype._showOverlay=function(){this.$("contentOver").css("display","")};m.prototype._hideOverlay=function(){this.$("contentOver").css("display","none")};function S(e){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close()}this._hideOverlay();if(!e){w.call(this)}this._getCalendar()._closePickers()}function F(){var e=this._getFocusedDate();var t=this._getItems();var a=this.getAggregation("datesRow");var i=a.getSelectedDates()[0];i.setStartDate(s._createLocalDate(e,true));var r=new l(e.getTime());r.setUTCDate(1);r.setUTCMonth(r.getUTCMonth()+1);r.setUTCDate(0);var o=r.getUTCDate();var n=Math.floor(t*1.5);if(n>o){n=o}a.setDays(n);this.setProperty("_currentPicker",U.DATES_ROW);this._showOverlay();q.call(this,e);this._iMode=1}function b(){var e=this._getFocusedDate();var t=this._getMonthPicker();this.setProperty("_currentPicker",U.MONTH_PICKER);this._showOverlay();t.setMonth(e.getUTCMonth());G.call(this,e.getUTCFullYear(),t);this._iMode=2;A.call(this)}function R(){var e=this._getFocusedDate();var t=this._getYearPicker();this.setProperty("_currentPicker",U.YEAR_PICKER);this._showOverlay();t.setDate(e.getJSDate());I.call(this);this._iMode=3}function x(){Y.call(this);A.call(this)}function A(e){var t=new l(y.call(this).getTime());var a=this._getItems();var i=t.getJSDate().getUTCFullYear();var s=this._oMaxDate.getJSDate().getUTCFullYear();var r=this._oMinDate.getJSDate().getUTCFullYear();var o=t.getJSDate().getUTCMonth();var n=this._oMaxDate.getJSDate().getUTCMonth();var h=this._oMinDate.getJSDate().getUTCMonth();var g=t.getJSDate().getUTCDate();var c=this._oMaxDate.getJSDate().getUTCDate();var u=this._oMinDate.getJSDate().getUTCDate();var D=t.getJSDate().getUTCHours();var _=this._oMaxDate.getJSDate().getUTCHours();var d=this._oMinDate.getJSDate().getUTCHours();var f=t.getJSDate().getUTCMinutes();var p=this._oMaxDate.getJSDate().getUTCMinutes();var T=this._oMinDate.getJSDate().getUTCMinutes();var v=this.getAggregation("header");if(this._iMode==2&&!e){var C=this._getMonthPicker();var M=C.getMonths();var m=C.getStartMonth();var U=m+M-1;if(m==0||i==r&&m<=h){v.setEnabledPrevious(false)}else{v.setEnabledPrevious(true)}if(U>10||i==s&&U>=n){v.setEnabledNext(false)}else{v.setEnabledNext(true)}return}if(i<r||i==r&&(e||(o<h||o==h&&(g<u||g==u&&(D<d||D==d&&f<=T))))||(this._iMode==1||this._iMode==2)&&this.getPickerPopup()){v.setEnabledPrevious(false)}else{v.setEnabledPrevious(true)}t.setUTCMinutes(t.getUTCMinutes()+a*this.getIntervalMinutes()-1);i=t.getJSDate().getUTCFullYear();o=t.getJSDate().getUTCMonth();g=t.getJSDate().getUTCDate();D=t.getJSDate().getUTCHours();f=t.getJSDate().getUTCMinutes();if(i>s||i==s&&(!e||(o>n||o==n&&(g>c||g==c&&(D>_||D==_&&f>=p))))||(this._iMode==1||this._iMode==2)&&this.getPickerPopup()){v.setEnabledNext(false)}else{v.setEnabledNext(true)}if(this._iMode===1){var P=new l(t.getTime());P.setUTCDate(1);P.setUTCMonth(P.getUTCMonth()+1);P.setUTCDate(0);var w=this.getAggregation("datesRow").getDays();t.setUTCDate(1+(Math.ceil(t.getUTCDate()/w)-1)*w);if(P.getUTCDate()-t.getUTCDate()<w){t.setUTCDate(P.getUTCDate()-w+1)}g=t.getUTCDate();if(g<=1||i==r&&o==h&&g<=u){v.setEnabledPrevious(false)}else{v.setEnabledPrevious(true)}if(g+w>=P.getUTCDate()||i==s&&o==n&&g>=c){v.setEnabledNext(false)}else{v.setEnabledNext(true)}}}function I(){var e=this._getYearPicker();var t=e.getYears();var a=s._createUniversalUTCDate(e.getProperty("_middleDate").toLocalJSDate());a.setUTCFullYear(a.getUTCFullYear()+Math.floor(t/2));var i=this.getAggregation("header");var r=new l(this._oMaxDate);r.setUTCFullYear(r.getUTCFullYear()-Math.ceil(t/2));r.setUTCMonth(11,31);var o=new l(this._oMinDate);o.setUTCFullYear(o.getUTCFullYear()+Math.floor(t/2)+1);o.setUTCMonth(0,1);if(a.getTime()>r.getTime()){i.setEnabledNext(false)}else{i.setEnabledNext(true)}if(a.getTime()<o.getTime()){i.setEnabledPrevious(false)}else{i.setEnabledPrevious(true)}}function Y(){var e=this.getAggregation("header");var t;var a=y.call(this);var i;var r=this._getLocaleData();var o=[];var n=[];var h;var g=false;var l;var c=false;if(r.oLocale.sLanguage.toLowerCase()==="ja"||r.oLocale.sLanguage.toLowerCase()==="zh"){l=u.getDateInstance({format:"d"}).format(a,true)}else{l=a.getUTCDate().toString()}if(this._bLongMonth||!this._bNamesLengthChecked){o=r.getMonthsStandAlone("wide")}else{g=true;o=r.getMonthsStandAlone("abbreviated");n=r.getMonthsStandAlone("wide")}var D=a.getUTCMonth();t=o[D];if(g){h=n[o[D]]}if(!this.getPickerPopup()){e.setTextButton0(l);e.setTextButton1(t);e.setTextButton2(this._oYearFormat.format(a,true))}else{i=u.getInstance({style:"long",strictParsing:true,relative:c},r.oLocale);h=l=i.format(s._createLocalDate(a,true));e.setTextButton1(l)}if(g){e.setAriaLabelButton1(h)}}function E(e,t){var a;var i=false;if(e.getTime()<this._oMinDate.getTime()){a=this._oMinDate;i=true}else if(e.getTime()>this._oMaxDate.getTime()){a=this._oMaxDate;i=true}else{a=e}this._setFocusedDate(a);if(i||t){$.call(this,a);w.call(this,false);this.fireStartDateChange()}}function L(e,t){if(e&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=e.getTime())){s._checkJSDateObject(e);e=s._createUniversalUTCDate(e,undefined,true);var a=e.getUTCFullYear();s._checkYearInValidRange(a);if(e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this)}this._setFocusedDate(e);if(this.getDomRef()&&this._iMode==0){w.call(this,t)}}}function O(e){if(this._iMode!=1){F.call(this)}else{this.setProperty("_currentPicker",U.TIMES_ROW)}}function J(e){var t;if(this.getPickerPopup()){this._showCalendarPicker()}else{if(this._iMode!=2){t=function(){var e=this._getMonthPicker();e._oItemNavigation.focusItem(e.getProperty("_focusedMonth"));e.removeDelegate(t)};b.call(this);this._getMonthPicker().addDelegate({onAfterRendering:t},this)}else{this.setProperty("_currentPicker",U.TIMES_ROW)}}}function B(e){var t;if(this._iMode!=3){t=function(){var e=this._getYearPicker();e.focus();e.removeDelegate(t)};R.call(this);this._getYearPicker().addDelegate({onAfterRendering:t},this)}else{this.setProperty("_currentPicker",U.TIMES_ROW)}}function N(e){this.fireSelect()}function V(e){var t=s._createUniversalUTCDate(e.getParameter("date"),undefined,true);var a=e.getParameter("notVisible");E.call(this,t,a)}function H(e){var t=e.getSource(),a=t.getSelectedDates()[0].getStartDate();var i=new l(this._getFocusedDate().getTime());var r=s._createUniversalUTCDate(a);i.setUTCFullYear(r.getUTCFullYear());i.setUTCMonth(r.getUTCMonth(),r.getUTCDate());E.call(this,i,true);S.call(this)}function z(e){var t=new l(this._getFocusedDate().getTime());var a=e.oSource;var i=a.getSelectedDates()[0];var r=s._createUniversalUTCDate(i.getStartDate());if(!this.getPickerPopup()||r.getUTCMonth()==t.getUTCMonth()){t.setUTCDate(r.getUTCDate());t.setUTCMonth(r.getUTCMonth());t.setUTCFullYear(r.getUTCFullYear());E.call(this,t,true);this.setProperty("_currentPicker",U.TIMES_ROW)}this._addTimesRowFocusDelegate()}function W(e){var t=new l(this._getFocusedDate().getTime());var a=s._createUniversalUTCDate(e.getParameter("date"),undefined,true);var i=e.getParameter("otherMonth");if(i&&a.getUTCMonth()==t.getUTCMonth()&&a.getUTCFullYear()==t.getUTCFullYear()){q.call(this,a)}}function j(e){var t=new l(this._getFocusedDate().getTime());var a=this._getMonthPicker();var i=a.getMonth();t.setUTCMonth(i);if(i!=t.getUTCMonth()){t.setUTCDate(0)}E.call(this,t,true);this.setProperty("_currentPicker",U.TIMES_ROW);this._addTimesRowFocusDelegate()}function K(e){var t=new l(this._getFocusedDate().getTime());var a=this._getYearPicker();var i=s._createUniversalUTCDate(a.getDate());var r=t.getUTCMonth();i.setUTCMonth(t.getUTCMonth(),t.getUTCDate());i.setUTCHours(t.getUTCHours());i.setUTCMinutes(t.getUTCMinutes());t=i;if(r!=t.getUTCMonth()){t.setUTCDate(0)}E.call(this,t,true);this.setProperty("_currentPicker",U.TIMES_ROW);this._addTimesRowFocusDelegate()}m.prototype._addTimesRowFocusDelegate=function(){var e={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(e)}},t=this.getAggregation("timesRow");t.addDelegate(e,t)};function $(e){var t=this.getAggregation("timesRow");var a=y.call(this);var i=t._oItemNavigation.getFocusedIndex();a=new l(e.getTime());a.setUTCMinutes(a.getUTCMinutes()-i*this.getIntervalMinutes());P.call(this,a,false,true)}function q(e){var t=this.getAggregation("datesRow");var a=this.getAggregation("header");if(!this.getPickerPopup()){var i=new l(e.getTime());i.setUTCDate(1);i.setUTCMonth(i.getUTCMonth()+1);i.setUTCDate(0);var r=t.getDays();var o=new l(e.getTime());o.setUTCDate(1+(Math.ceil(e.getUTCDate()/r)-1)*r);if(i.getUTCDate()-o.getUTCDate()<r){o.setUTCDate(i.getUTCDate()-r+1)}t.setStartDate(s._createLocalDate(o,true));var n=o.getJSDate().getUTCFullYear();var h=this._oMaxDate.getJSDate().getUTCFullYear();var g=this._oMinDate.getJSDate().getUTCFullYear();var c=o.getJSDate().getUTCMonth();var u=this._oMaxDate.getJSDate().getUTCMonth();var D=this._oMinDate.getJSDate().getUTCMonth();var _=o.getJSDate().getUTCDate();var d=this._oMaxDate.getJSDate().getUTCDate();var f=this._oMinDate.getJSDate().getUTCDate();if(_<=1||n==g&&c==D&&_<=f){a.setEnabledPrevious(false)}else{a.setEnabledPrevious(true)}if(_+r>=i.getUTCDate()||n==h&&c==u&&_>=d){a.setEnabledNext(false)}else{a.setEnabledNext(true)}if(!this._oFocusDatesRowDelegate){this._oFocusDatesRowDelegate={onAfterRendering:function(){this.focus()}};t.addDelegate(this._oFocusDatesRowDelegate,t)}}else{a.setEnabledPrevious(false);a.setEnabledNext(false)}t.setDate(s._createLocalDate(e,true))}function X(a){if(!this._oPopup){var i=new e({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});i.oPopup.setDurations(0,0);i.addEventDelegate({onsapescape:this._oCalendar.onsapescape},this._oCalendar);this._oPopup=i}this._oPopup.addContent(a);this._oPopup.attachAfterClose(function(){this._hideOverlay();this._addTimesRowFocusDelegate()},this);this._oPopup.attachAfterOpen(function(){var e=s.$("B1");var a=this._oPopup.$();var i=Math.floor((a.width()-e.width())/2);this._oPopup.setOffsetX(t.getConfiguration().getRTL()?i:-i);var r=e.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?r:-r)},this);var s=this.getAggregation("header");this._oPopup.openBy(s.getDomRef("B1"))}function G(e,t){var a=0;var i=11;if(e==this._oMinDate.getUTCFullYear()){a=this._oMinDate.getUTCMonth()}if(e==this._oMaxDate.getUTCFullYear()){i=this._oMaxDate.getUTCMonth()}t.setMinMax(a,i)}function Q(e){A.call(this)}function Z(e){I.call(this)}return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarTimeIntervalRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var a=t.getId();var i=t.getTooltip_AsString();e.openStart("div",t);e.class("sapUiCal");e.class("sapUiCalInt");e.class("sapUiCalTimeInt");if(t._getShowItemHeader()){e.class("sapUiCalIntHead")}if(t.getPickerPopup()){e.class("sapUiCalIntLarge")}var n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var r={labelledby:{value:"",append:false}};if(t._bPoupupMode){r["role"]="dialog"}e.accessibilityState(t,r);if(i){e.attr("title",i)}var o=t.getWidth();if(o&&o!=""){e.style("width",o)}e.openEnd();var s=t.getAggregation("header");e.renderControl(s);e.openStart("div",a+"-content");e.class("sapUiCalContent");e.openEnd();e.renderControl(t.getAggregation(t.getProperty("_currentPicker")));e.close("div");e.openStart("button",a+"-cancel");e.class("sapUiCalCancel");e.attr("tabindex","-1");e.openEnd();e.text(n.getText("CALENDAR_CANCEL"));e.close("button");if(t.getPickerPopup()){e.openStart("div",a+"-contentOver");e.class("sapUiCalContentOver");if(!t._oPopup||!t._oPopup.isOpen()){e.style("display","none")}e.openEnd();e.close("div")}e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CalendarWeekInterval", ["sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","./library","sap/ui/unified/CalendarDateInterval","sap/ui/unified/CalendarDateIntervalRenderer","sap/ui/unified/DateRange"],function(e,t,a,i,s,r){"use strict";var o=i.extend("sap.ui.unified.CalendarWeekInterval",{renderer:s});o.prototype._getDaysLarge=function(){return 6};o.prototype._handleFocus=function(a){var s=!!a.getParameter("_outsideBorder"),r,o,n;if(s){r=a.getParameter("date");this._oFocusDateWeek=t.fromLocalJSDate(r);o=e._getFirstDateOfWeek(this._oFocusDateWeek);n=this.getAggregation("month")[0];if(n.getDomRef()){this._setStartDate(o,false,true)}}return i.prototype._handleFocus.apply(this,arguments)};o.prototype._focusDateExtend=function(e,t,a){var s,r;if(!this._oFocusDateWeek){return i.prototype._focusDateExtend.apply(this,arguments)}s=this.getAggregation("month")[0];r=this._oFocusDateWeek.toLocalJSDate();this._setFocusedDate(this._oFocusDateWeek);s.setDate(r);this._oFocusDateWeek=null;return!a};o.prototype._dateMatchesVisibleRange=function(e){var a=this.getDays(),i=t.fromLocalJSDate(e),s=t.fromLocalJSDate(this.getStartDate()),r=t.fromLocalJSDate(this.getStartDate());r.setDate(r.getDate()+a);return i.isSameOrAfter(s)&&i.isBefore(r)};o.prototype._showCalendarPicker=function(){var e=this._getFocusedDate(),a=this._getStartDate(),i=this._getCalendar(),s=new r,o;o=new t(a);o.setDate(o.getDate()+this._getDays()-1);s.setStartDate(a.toLocalJSDate());s.setEndDate(o.toLocalJSDate());i.displayDate(e.toLocalJSDate(),false);i.removeAllSelectedDates();i.addSelectedDate(s);i.setMinDate(this.getMinDate());i.setMaxDate(this.getMaxDate());this._openPickerPopup(i)};o.prototype._handleCalendarPickerDateSelect=function(a){var i=this._getCalendar(),s=i.getSelectedDates()[0].getStartDate(),r=t.fromLocalJSDate(s),o;if(this._dateMatchesVisibleRange(r.toLocalJSDate())){this._oFocusDateWeek=r;this._focusDate(this._oFocusDateWeek,false,true)}else{o=e._getFirstDateOfWeek(r);this._setStartDate(o);this._oFocusDateWeek=r;this._focusDate(this._oFocusDateWeek,false,true)}this._closeCalendarPicker(true)};o.prototype._calculateStartDate=function(e,a,i){var e=new t(this._oMaxDate,this.getPrimaryCalendarType());e=this._getMaxDateAlignedToMinDate(e,this._oMinDate);i=this._getStartDateAlignedToMinAndMaxDate(e,this._oMinDate,i);return i};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ColorPicker", ["./library","sap/ui/core/Control","sap/ui/core/HTML","sap/ui/core/ResizeHandler","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/ui/core/theming/Parameters","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/core/library","./ColorPickerRenderer","./ColorPickerHelper","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/Global"],function(e,t,i,s,o,a,l,r,h,n,d,u,p,C,c,jQuery,g){"use strict";var f=u.ValueState,S=e.ColorPickerMode,b=e.ColorPickerDisplayMode;var _=t.extend("sap.ui.unified.ColorPicker",{metadata:{library:"sap.ui.unified",properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:S.HSV},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:b.Default}},aggregations:{_grid:{type:"sap.ui.layout.Grid",group:"Appearance",multiple:false,visibility:"hidden"},_invisibleTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"},_oCPBox:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oSlider:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oAlphaSlider:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oHexField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oRedField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oGreenField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oBlueField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oHueField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oSatField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oLitField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oValField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oAlphaField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oAlphaField2:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oRGBorHSLRBUnifiedGroup:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oButton:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}},renderer:p});var y="",R=sap.ui.require.toUrl("sap/ui/unified/img/ColorPicker/Alphaslider_BG.png"),H=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),F={};Object.defineProperties(F,{RGB:{value:"RGB"},CPResponsiveClass:{value:"sapUnifiedColorPicker"},CPMatrixClass:{value:"sapUiColorPicker-ColorPickerMatrix"},HSLClass:{value:"sapUiColorPickerHSL"},LabelClass:{value:"sapUiColorPicker-ColorPickerLabels"},UnitLabelClass:{value:"sapUiCPUnitLabel"},HEXClass:{value:"sapUiColorPicker-ColorPickerHexField"},LeftColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsLeft"},RightColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsRight"},SliderClass:{value:"sapUiColorPicker-ColorPickerSlider"},AlphaSliderClass:{value:"sapUiColorPicker-ColorPickerAlphaSlider"},OutputSelectorClass:{value:"sapUiColorPickerHSL-RB"},OutputSelectorRowClass:{value:"sapUiColorPicker-RBRow"},CPBoxClass:{value:"sapUiColorPicker-ColorPickerBox"},CPCircleClass:{value:"sapUiColorPicker-ColorPickerCircle"},LastColumnClass:{value:"sapUiColorPicker-ColorPickerLastColumn"},HideForHSVClass:{value:"hideForHSV"},HideForHSLClass:{value:"hideForHSL"},OldColorClass:{value:"sapUiColorPicker-ColorPickerOldColor"},NewColorClass:{value:"sapUiColorPicker-ColorPickerNewColor"},SwatchesClass:{value:"sapUiColorPicker-swatches"},Colors:{value:{aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgrey:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",grey:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"778899",lightslategrey:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32",transparent:"00000000"}}});_.prototype.init=function(){this.oColorPickerHelper=C.getHelper();if(d.browser.firefox){y="-moz-linear-gradient"}else if(d.browser.webkit){y="-webkit-linear-gradient"}else{y="linear-gradient"}this.Color={r:255,g:255,b:255,h:0,s:0,l:100,v:100,a:1,oldA:1,hex:"#ffffff",old:"#ffffff"};this.sHexString="ffffff";this.$CPBox=null;this.$CPCur=null;this.RGB={r:0,g:0,b:0};this.bRtl=g.getRTL();this.data("sap-ui-fastnavgroup","true",true);this.bResponsive=this.oColorPickerHelper.isResponsive();var e=this.bResponsive?"_sap_ui_unified_ColorPicker_CircleSize":"_sap_ui_unified_ColorPicker_commonsCircleSize";this._iCPCursorSize=0;var t=h.get({name:e,callback:function(e){this._iCPCursorSize=parseInt(e)}.bind(this)});if(t){this._iCPCursorSize=parseInt(t)}this._processChanges=this._processHSVChanges;this._bHSLMode=false;this.bPressed=false};var L=t.extend("sap.ui.unified._ColorPickerBox",{metadata:{events:{select:{parameters:{value:{type:"int"},saturation:{type:"int"}}},resize:{parameters:{size:{type:"int"}}}}},init:function(){this.bRtl=g.getRTL()},exit:function(){if(this._sResizeListener){s.deregister(this._sResizeListener)}},getWidth:function(){return this.$().width()},getOffset:function(){return this.$().offset()},onBeforeRendering:function(){if(this._sResizeListener){s.deregister(this._sResizeListener)}},onAfterRendering:function(){this._handle=this.$().find("> div."+F.CPCircleClass);this._sResizeListener=s.register(this.getDomRef(),this.handleResize.bind(this))},handleResize:function(e){this.fireResize({size:e.size.width})},getHandle:function(){return this._handle},ontouchstart:function(e){this.handleTouch(e)},ontouchend:function(e){this.handleTouch(e)},ontouchmove:function(e){this.handleTouch(e)},handleTouch:function(e){var t=this.calculateValuesFromEvent(e);if(t){this.fireSelect(t)}},calculateValuesFromEvent:function(e){var t=e.offsetX,i=e.offsetY,s,o=s=this.getWidth(),a,l;e.preventDefault&&e.preventDefault();if(!t){a=e.targetTouches?e.targetTouches[0]:e;if(!a||!a.pageX){a=e;if((!a||!a.pageX)&&e.changedTouches){a=e.changedTouches[0]}}if(!a.pageX){return false}l=this.getOffset();t=a.pageX-l.left;i=a.pageY-l.top}t=Math.min(Math.max(t,0),o);i=Math.min(Math.max(i,0),s);if(this.bRtl){t=o-t}return{value:t/o*100,saturation:(1-i/s)*100}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.class(F.CPBoxClass);e.openEnd();e.openStart("div",t.getId()+"-cpCur");e.class(F.CPCircleClass);e.openEnd().close("div");e.close("div")}}});_.prototype._createRowFromInput=function(e,t,i,s){var o=H.getText(t),a;a=new r({content:[this.oColorPickerHelper.factory.createLabel({text:i,tooltip:o,labelFor:e}).addStyleClass(F.LabelClass),e.setTooltip(o)]});if(s){a.addContent(this.oColorPickerHelper.factory.createLabel({text:s,labelFor:e}).addStyleClass(F.UnitLabelClass).addStyleClass(F.LabelClass))}return a};_.prototype._updateColorStringProperty=function(e,t){var i=this._getCSSColorString();this.setProperty("colorString",i,true);if(t){this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:i})}if(e){this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:i})}};_.prototype._handleCPBoxSelectEvent=function(e){var t=e.getParameter("value"),i=e.getParameter("saturation");this.oSatField.setValue(i);if(this._bHSLMode){this.oLitField.setValue(t)}else{this.oValField.setValue(t)}this._processChanges();this._updateColorStringProperty(false,true)};_.prototype._handleCPBoxResizeEvent=function(e){this._iCPBoxSize=e.getParameter("size");this._updateCursorPosition()};_.prototype._handleCPBoxTouchEndEvent=function(e){this._updateColorStringProperty(true,false)};_.prototype._createInteractionControls=function(){var t=this.getId();this.oCPBox=new L(t+"-cpBox",{select:this._handleCPBoxSelectEvent.bind(this),resize:this._handleCPBoxResizeEvent.bind(this)});this.oCPBox.addDelegate({ontouchend:this._handleCPBoxTouchEndEvent.bind(this)});this.oHexField=this.oColorPickerHelper.factory.createInput(t+"-hxF",{value:this.Color.hex.substr(1),change:this._handleHexValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_HEX")}).addStyleClass(F.HEXClass);this.oRedField=this.oColorPickerHelper.factory.createInput(t+"-rF",{value:this.Color.r,change:this._handleRedValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_RED")}).addStyleClass(F.LeftColumnInputClass);this.oGreenField=this.oColorPickerHelper.factory.createInput(t+"-gF",{value:this.Color.g,change:this._handleGreenValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_GREEN")}).addStyleClass(F.LeftColumnInputClass);this.oBlueField=this.oColorPickerHelper.factory.createInput(t+"-bF",{value:this.Color.b,change:this._handleBlueValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_BLUE")}).addStyleClass(F.LeftColumnInputClass);this.oHueField=this.oColorPickerHelper.factory.createInput(t+"-hF",{value:this.Color.h,change:this._handleHueValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_HUE")}).addStyleClass(F.RightColumnInputClass);this.oSatField=this.oColorPickerHelper.factory.createInput(t+"-sF",{value:this.Color.s,change:this._handleSatValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_SAT")+" "+n.getStaticId("sap.ui.unified","COLORPICKER_PERCENTAGE")}).addStyleClass(F.RightColumnInputClass);this.oLitField=this.oColorPickerHelper.factory.createInput(t+"-lF",{value:this.Color.l,change:this._handleLitValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_LIGHTNESS")+" "+n.getStaticId("sap.ui.unified","COLORPICKER_PERCENTAGE")}).addStyleClass(F.RightColumnInputClass).addStyleClass(F.HideForHSVClass);this.oAlphaField=this.oColorPickerHelper.factory.createInput(t+"-aF",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_ALPHA")}).addStyleClass(F.RightColumnInputClass).addStyleClass(F.HideForHSVClass).addStyleClass("sapUnifiedA");this.oAlphaField2=this.oColorPickerHelper.factory.createInput(t+"-aF2",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_ALPHA")}).addStyleClass(F.RightColumnInputClass).addStyleClass(F.HideForHSVClass).addStyleClass("sapUnifiedA");this.oValField=this.oColorPickerHelper.factory.createInput(t+"-vF",{value:this.Color.v,change:this._handleValValueChange.bind(this),ariaLabelledBy:n.getStaticId("sap.ui.unified","COLORPICKER_VALUE")}).addStyleClass(F.RightColumnInputClass).addStyleClass(F.HideForHSLClass);this.oRGBorHSLRBGroup=this.oColorPickerHelper.factory.createRadioButtonGroup({columns:2,buttons:[this.oColorPickerHelper.factory.createRadioButtonItem({text:F.RGB}),this.oColorPickerHelper.factory.createRadioButtonItem({text:e.ColorPickerMode.HSL})],select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:this.Color.formatHSL?1:0}).addStyleClass(F.OutputSelectorClass);this.oHueInvisibleText=new n({text:H.getText("COLORPICKER_HUE_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",this.oHueInvisibleText,true);this.oSlider=this.oColorPickerHelper.factory.createSlider(t+"-hSLD",{max:360,step:1,tooltip:H.getText("COLORPICKER_HUE"),value:parseInt(this.oHueField.getValue())}).addStyleClass(F.SliderClass).addAriaLabelledBy(this.oHueInvisibleText);this.oSlider.attachEvent("liveChange","liveChange",this._handleSliderChange.bind(this));this.oSlider.attachEvent("change","change",this._handleSliderChange.bind(this));this.oAlphaInvisibleText=new n({text:H.getText("COLORPICKER_ALPHA_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",this.oAlphaInvisibleText,true);this.oAlphaSlider=this.oColorPickerHelper.factory.createSlider(t+"-aSLD",{max:1,value:1,step:.01,tooltip:H.getText("COLORPICKER_ALPHA")}).addStyleClass(F.AlphaSliderClass).addAriaLabelledBy(this.oAlphaInvisibleText);this.oAlphaSlider.attachEvent("liveChange","liveChange",this._handleAlphaSliderChange.bind(this));this.oAlphaSlider.attachEvent("change","change",this._handleAlphaSliderChange.bind(this))};_.prototype._createLayout=function(){var e=this.getId(),t;if(this._bLayoutControlsCreated){return}this._createInteractionControls();if(this.getDisplayMode()===b.Large){this._toggleInputsEnabled(this.Color.formatHSL)}this.oCPBoxGD=new a({span:"L6 M6 S12"});this.icOne=new a({span:"L3 M3 S6"});this.icTwo=new a({span:"L3 M3 S6"});this.swatches=new a({span:"L3 M3 S12"});this.rbg=new a({span:"L6 M8 S12"});if(this.bResponsive){this._createUnifiedColorPicker(e)}else{t=this._createCommonsColorPicker(t,e);this.setAggregation("_grid",t,true)}this._bLayoutControlsCreated=true;if(!this.bResponsive){this._adaptControlToLibrary()}};_.prototype._adaptControlToLibrary=function(){var e;if(!this._bLayoutControlsCreated){return}e=this.getAggregation("_grid");if(this.bResponsive){if(!d.system.phone&&!jQuery("html").hasClass("sapUiMedia-Std-Phone")){e._setBreakPointTablet(400)}e.addStyleClass(F.CPResponsiveClass)}else{e.setProperty("hSpacing",0,true);e.setProperty("vSpacing",0,true);this.oCPBoxGD.setSpanS(5);this.icOne.setSpanS(4);this.icTwo.setSpanS(3);this.rbg.setSpanS(8)}};_.prototype._updateControlVisualState=function(){var e=this.getAggregation("_grid");if(!e){return}if(this.bResponsive){if(this._bHSLMode){e.addStyleClass(F.HSLClass);this.swatches.setSpanM(4).setLinebreak(true)}else{e.removeStyleClass(F.HSLClass);this.swatches.setSpanM(3).setLinebreak(false)}}else{if(this._bHSLMode){e.addStyleClass(F.HSLClass);this.swatches.setSpanS(4).setLinebreak(true)}else{e.removeStyleClass(F.HSLClass);this.swatches.setSpanS(3).setLinebreak(false)}}};_.prototype._processChanges=function(){};_.prototype.setMode=function(t,i){this._bLayoutControlsCreated=false;switch(t){case e.ColorPickerMode.HSL:this._processChanges=this._processHSLChanges;break;case e.ColorPickerMode.HSV:this._processChanges=this._processHSVChanges;break;default:c.error("Control must have a valid mode set to work correct");break}this._bHSLMode=t===e.ColorPickerMode.HSL;return this.setProperty("mode",t,i)};_.prototype.setDisplayMode=function(e){this._bLayoutControlsCreated=false;return this.setProperty("displayMode",e,false)};_.prototype._cleanup=function(){var e=[this.getAggregation("_grid"),this.getAggregation("_oCPBox"),this.getAggregation("_oHexField"),this.getAggregation("_oRedField"),this.getAggregation("_oGreenField"),this.getAggregation("_oBlueField"),this.getAggregation("_oHueField"),this.getAggregation("_oSatField"),this.getAggregation("_oLitField"),this.getAggregation("_oAlphaField"),this.getAggregation("_oAlphaField2"),this.getAggregation("_oValField"),this.getAggregation("_oSlider"),this.getAggregation("_oAlphaSlider"),this.oRGBorHSLRBUnifiedGroup,this.oCPBoxGD,this.icOne,this.icTwo,this.rbg,this.swatches,this.oAlphaInvisibleText,this.oHueInvisibleText,this.getAggregation("_oButton"),this.getAggregation("_oRGBorHSLRBUnifiedGroup"),this.oRGBorHSLRBGroup];e.forEach(function(e){if(e){e.destroy()}},this);this._bLayoutControlsCreated=false};_.prototype.exit=function(){this._cleanup()};_.prototype.onBeforeRendering=function(){this._cleanup();this._createLayout();this._updateControlVisualState();this._updateColorString()};_.prototype._updateColorString=function(){this._parseColorString(this.getColorString());this.oHexField.setValue(this.Color.hex.substr(1));this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(this.Color.a);this.oAlphaField2.setValue(this.Color.a);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);if(this.bResponsive){this.oRGBorHSLRBUnifiedGroup.setSelectedIndex(this.Color.formatHSL?1:0)}else{this.oRGBorHSLRBGroup.setSelectedIndex(this.Color.formatHSL?1:0)}}else{this.oValField.setValue(this.Color.v);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oAlphaField.setValue(this.Color.a);this.oAlphaField2.setValue(this.Color.a)}this._updateColorStringProperty(false,false)};_.prototype.isColor=function(e){return this._parseColorString(e,true)};_.prototype._handleSliderChange=function(e,t){var i=parseInt(this.oSlider.getValue());this.oHueField.setValue(i);this._processChanges();this._updateColorStringProperty(t==="change",t==="liveChange")};_.prototype._handleAlphaSliderChange=function(e,t){this.Color.a=this.oAlphaSlider.getValue();this.oAlphaField.setValue(this.Color.a);this.oAlphaField2.setValue(this.Color.a);this._updateSelColorBackground();this._updateColorStringProperty(t==="change",t==="liveChange")};_.prototype._getValueInRange=function(e,t,i){if(isNaN(e)){e=0}return Math.min(Math.max(e,t),i)};_.prototype._handleAlphaValueChange=function(e){var t=e.getParameter("id")=="cp-aF2"?parseFloat(this.oAlphaField2.getValue(),10):parseFloat(this.oAlphaField.getValue(),10);t=this._getValueInRange(t,0,1);this.Color.a=t;this.oAlphaField.setValue(t);this.oAlphaField2.setValue(t);this.oAlphaSlider.setValue(t);if(!this.Color.formatHSL){this._processRGBChanges()}else{this._processChanges()}this._updateColorStringProperty(true,true)};_.prototype._handleRGBorHSLValueChange=function(e){this.Color.formatHSL=e.getParameter("selectedIndex")===1;this._toggleInputsEnabled(this.Color.formatHSL);this._updateColorStringProperty(true,true)};_.prototype._toggleInputsEnabled=function(e){this.oRedField.setEnabled(!e);this.oGreenField.setEnabled(!e);this.oBlueField.setEnabled(!e);this.oHueField.setEnabled(!!e);this.oSatField.setEnabled(!!e);this.oLitField.setEnabled(!!e);this.oValField.setEnabled(!!e)};_.prototype._handleHueValueChange=function(){var e=parseInt(this.oHueField.getValue());e=this._getValueInRange(e,0,360);this.oHueField.setValue(e);this.oSlider.setValue(e);this._processChanges();this._updateColorStringProperty(true,true)};_.prototype._handleSatValueChange=function(){var e=parseInt(this.oSatField.getValue());e=this._getValueInRange(e,0,100);this.oSatField.setValue(e);this._processChanges();this._updateColorStringProperty(true,true)};_.prototype._handleValValueChange=function(){var e=parseInt(this.oValField.getValue());e=this._getValueInRange(e,0,100);this.oValField.setValue(e);this._processHSVChanges();this._updateColorStringProperty(true,true)};_.prototype._handleLitValueChange=function(){var e=parseInt(this.oLitField.getValue());e=this._getValueInRange(e,0,100);this.oLitField.setValue(e);this._processHSLChanges();this._updateColorStringProperty(true,true)};_.prototype._handleRedValueChange=function(){var e=parseInt(this.oRedField.getValue());e=this._getValueInRange(e,0,255);this.oRedField.setValue(e);this._processRGBChanges();this._updateColorStringProperty(true,true)};_.prototype._handleGreenValueChange=function(){var e=parseInt(this.oGreenField.getValue());e=this._getValueInRange(e,0,255);this.oGreenField.setValue(e);this._processRGBChanges();this._updateColorStringProperty(true,true)};_.prototype._handleBlueValueChange=function(){var e=parseInt(this.oBlueField.getValue());e=this._getValueInRange(e,0,255);this.oBlueField.setValue(e);this._processRGBChanges();this._updateColorStringProperty(true,true)};_.prototype._processHSVChanges=function(){var e=parseInt(this.oHueField.getValue());var t=parseInt(this.oSatField.getValue());var i=parseInt(this.oValField.getValue());this._calculateRGB(e,t,i);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=e;this.Color.s=t;this.Color.v=i;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oValField.setValue(this.Color.v);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground()};_.prototype._processHSLChanges=function(){var e=parseInt(this.oHueField.getValue()),t=parseInt(this.oSatField.getValue()),i=parseInt(this.oLitField.getValue());if(e>360){e%=360}this._calculateRGB(e,t,i);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=e;this.Color.s=t;this.Color.l=i;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oLitField.setValue(this.Color.l);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground()};_.prototype._processRGBChanges=function(){var e=Math.round(parseInt(this.oRedField.getValue())),t=Math.round(parseInt(this.oGreenField.getValue())),i=Math.round(parseInt(this.oBlueField.getValue())),s=e+t+i===765;this._calculateHEX(e,t,i);this.oHexField.setValue(this.sHexString);if(this._bHSLMode){this._calculateHSL(e,t,i);this.oLitField.setValue(this.Color.l)}else{if(!s){this._calculateHSV(e,t,i)}this.oValField.setValue(this.Color.v)}if(!s){this.oHueField.setValue(this.Color.h)}this.oSatField.setValue(this.Color.s);this.oSlider.setValue(parseInt(this.oHueField.getValue()));this.Color.r=e;this.Color.g=t;this.Color.b=i;this.Color.hex="#"+this.oHexField.getValue();this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground()};_.prototype._handleHexValueChange=function(){var e=this.oHexField.getValue().toLowerCase(),t=1,i;if(e.substr(0,1)==="#"){e=e.substr(1)}i=/^([0-9a-fA-F]{8})$/;if(i.test(e)!==false){t=Number((parseInt(e.substr(6,2),16)/255).toFixed(2));e=e.substr(0,6)}i=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;if(i.test(e)===false){this.oHexField.setValueState(f.Error);this.oSlider.setEnabled(false);this.oAlphaSlider.setEnabled(false);this.oHueField.setEnabled(false);this.oRedField.setEnabled(false);this.oGreenField.setEnabled(false);this.oBlueField.setEnabled(false);this.oSatField.setEnabled(false);this.oAlphaField.setEnabled(false);this.oAlphaField2.setEnabled(false);if(this._bHSLMode){this.oLitField.setEnabled(false)}else{this.oValField.setEnabled(false)}return}else if(this.oHexField.getValueState()===f.Error){this.oHexField.setValueState(f.None);this.oSlider.setEnabled(true);this.oAlphaSlider.setEnabled(true);this.oHueField.setEnabled(true);this.oRedField.setEnabled(true);this.oGreenField.setEnabled(true);this.oBlueField.setEnabled(true);this.oSatField.setEnabled(true);this.oAlphaField.setEnabled(true);this.oAlphaField2.setEnabled(true);if(this._bHSLMode){this.oLitField.setEnabled(true)}else{this.oValField.setEnabled(true)}}if(e.length===3){e=e.charAt(0)+e.charAt(0)+e.charAt(1)+e.charAt(1)+e.charAt(2)+e.charAt(2)}this._processHexChanges(e);this.oHexField.setValue(e);this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(1);this.oAlphaField2.setValue(1)}else{this.oValField.setValue(this.Color.v)}this.oSlider.setValue(parseInt(this.oHueField.getValue()));this.oAlphaSlider.setValue(t);this.Color.a=t;if(this._bHSLMode){this.oAlphaField.setValue(t);this.oAlphaField2.setValue(t)}this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();this._updateColorStringProperty(true,true)};_.prototype._processHexChanges=function(e){this._convertRGB(e);if(this._bHSLMode){this._calculateHSL(this.Color.r,this.Color.g,this.Color.b)}else{this._calculateHSV(this.Color.r,this.Color.g,this.Color.b)}this.Color.hex="#"+e.toLowerCase()};_.prototype._updateAlphaBackground=function(){var e=[this.Color.r,this.Color.g,this.Color.b].join(","),t=y+"(left,rgba("+e+",0),rgba("+e+",1)),url("+R+")";this.oAlphaSlider.$().find(this.bResponsive?".sapMSliderInner":".sapUiSliBar").css("background-image",t)};_.prototype._updateCursorPosition=function(){var e,t;if(!this._iCPBoxSize){return}if(this._bHSLMode){e=Math.round(this.oLitField.getValue()*this._iCPBoxSize/100)}else{e=Math.round(this.oValField.getValue()*this._iCPBoxSize/100)}if(g.getRTL()){e=this._iCPBoxSize-e}t=Math.round((1-this.oSatField.getValue()/100)*this._iCPBoxSize);e=Math.round(Math.max(e,0)-this._iCPCursorSize/2-1);t=Math.round(Math.max(t,0)-this._iCPCursorSize/2-1);this.$CPCur.css("left",e).css("top",t)};_.prototype._calculateRGB=function(e,t,i){var s,o,a,l,r,h,n;if(this._bHSLMode){this._calculateRGBAdvanced(e,t,i);return}e%=360;e/=60;t/=100;i/=100;h=i*t;r=h*(1-Math.abs(e%2-1));l=i-h;s=0;o=0;a=0;n=Math.floor(e);switch(n){case 0:s=h;o=r;break;case 1:s=r;o=h;break;case 2:o=h;a=r;break;case 3:o=r;a=h;break;case 4:s=r;a=h;break;case 5:s=h;a=r;break;default:s=0;a=0;o=0;break}this.RGB.r=Math.floor((s+l)*255);this.RGB.g=Math.floor((o+l)*255);this.RGB.b=Math.floor((a+l)*255)};_.prototype._calculateRGBAdvanced=function(e,t,i){var s,o,a,l,r,h,n,d,u;e=this._getValueInRange(e,0,360);e%=360;if(t>100){t=1}else if(t<0){t=0}else{t=t/100}if(i>100){i=1}else if(i<0){i=0}else{i=i/100}d=t*(1-Math.abs(2*i-1));n=255*(i-.5*d);h=d*(1-Math.abs(e/60%2-1));u=Math.floor(e/60);r=n+255*h;l=n+255*d;switch(u){case 0:s=l;o=r;a=n;break;case 1:s=r;o=l;a=n;break;case 2:s=n;o=l;a=r;break;case 3:s=n;o=r;a=l;break;case 4:s=r;o=n;a=l;break;case 5:s=l;o=n;a=r;break;default:s=0;o=0;a=0;break}this.RGB.r=Math.round(s);this.RGB.g=Math.round(o);this.RGB.b=Math.round(a)};_.prototype._getCSSColorString=function(){if(this.Color.formatHSL){if(this.Color.a<1){return"hsla("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%, "+this.Color.a+")"}else{return"hsl("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%)"}}if(this.Color.a<1){return"rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+", "+this.Color.a+")"}else{return"rgb("+this.Color.r+","+this.Color.g+","+this.Color.b+")"}};_.prototype._calculateHEX=function(e,t,i){var s=e.toString(16),o=t.toString(16),a=i.toString(16);if(s.length===1){s="0"+s}if(o.length===1){o="0"+o}if(a.length===1){a="0"+a}this.sHexString=(s+o+a).toLowerCase()};_.prototype._calculateHSV=function(e,t,i){var s=Math.max(Math.max(e,t),i),o=Math.min(Math.min(e,t),i),a=s-o,l=Math.round(s*100/255),r=s===0?0:100*a/s,h=0;if(r===0){h=0}else if(e===s){h=60*(t-i)/a}else if(t===s){h=120+60*(i-e)/a}else if(i===s){h=240+60*(e-t)/a}if(h<0){h+=359.9}h=Math.round(h);r=Math.round(r);this.Color.h=h;this.Color.s=r;this.Color.v=l};_.prototype._calculateHSL=function(e,t,i){var s=Math.max(e,t,i),o=Math.min(e,t,i),a=(s-o)/255,l=(s+o)/510,r=1-Math.abs(2*l-1),h=l===0?0:a/r,n=r!==0?h:0,d=0;l=Math.round(l*100);n=Math.round(n*100);if(l===0||n===0||e+t+i===765){d=0}else{var u=s-o;if(s===e){d=(t-i)/u%6}if(s===t){d=(i-e)/u+2}if(s===i){d=(e-t)/u+4}if(u===0){d=0}d*=60;if(d<0){d+=360}}if(d!==0||this.Color.h!==360){this.Color.h=Math.round(d)}this.Color.s=n;this.Color.l=l};_.prototype._convertRGB=function(e){this.Color.r=parseInt(e.substr(0,2),16);this.Color.g=parseInt(e.substr(2,2),16);this.Color.b=parseInt(e.substr(4,2),16)};_.prototype._updateGradientBoxBackground=function(e){if(this._bHSLMode){this._calculateRGBAdvanced(e,100,50)}else{this._calculateRGB(e,100,100)}this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.$CPBox.css("background-color","rgb("+[this.RGB.r,this.RGB.g,this.RGB.b].join(",")+")")};_.prototype._updateSelColorBackground=function(){this.$().find(".sapUiColorPicker-ColorPickerNewColor").css("background-color",this._getCSSColorString())};_.prototype._parseColorString=function(e,t){var i;if(e.substr(0,1)==="#"){e=e.substr(1)}e=e.trim().toLowerCase();i=this._parseColorName(e);if(i){if(t){return true}if(i.length===8){this.Color.a=this.Color.oldA=Number((parseInt(i.substr(6,2),16)/255).toFixed(2));i=i.substring(0,6)}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false}return true}if(/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(e)){if(t){return true}if(e.length===3){i=e[0]+e[0]+e[1]+e[1]+e[2]+e[2]}else{i=e}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false}return true}if(e.substr(0,3)==="rgb"){return this._parseRGB(e,t)}if(this._bHSLMode){return this._parseHSL(e,t)}else if(e.substr(0,3)==="hsv"){return this._parseHSV(e,t)}return false};_.prototype._parseHSV=function(e,t){var i=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),)(((\d{1,2})|(100)),)((\d{1,2})|(100))$/,s,o,a,l;e=e.substr(3).replace("(","").replace(")","").split(" ").join("");if(i.test(e)===true){if(t){return true}s=e.split(",");o=parseInt(s[0]);a=parseInt(s[1]);l=parseInt(s[2]);this._calculateRGB(o,a,l);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=o;this.Color.s=a;this.Color.v=l;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;return true}return false};_.prototype._parseHSL=function(e,t){var i,s=e.substr(0,4),o,a,l,r,h;if(s==="hsla"){o=true}else if(s==="hsl("){o=false}else{return false}e=e.substr(o?4:3).replace("(","").replace(")","").split(" ").join("");i=e.split(",");a=parseInt(i[0]);l=parseFloat(i[1]);r=parseFloat(i[2]);if(o){h=parseFloat(i[3])}else{if(i[3]&&parseFloat(i[3])>=0){return false}h=1}l=l<1&&l>0?l*100:l;r=r<1&&r>0?r*100:r;if(a>=0&&a<=360&&(l>=0&&l<=100)&&(r>=0&&r<=100)&&(h>=0&&h<=1)){if(t){return true}this._calculateRGB(a,l,r);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=a;this.Color.s=l;this.Color.l=r;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.oldA=h;this.Color.formatHSL=true}else{return false}return true};_.prototype._parseRGB=function(e,t){var i,s,o,a;s=e.substring(0,4);if(s==="rgba"){a=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),)([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1])$/;o=true}else if(s.substring(0,3)==="rgb"){a=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])))$/;o=false}else{return false}e=e.substr(o?4:3).replace("(","").replace(")","").split(" ").join("");if(a.test(e)){if(t){return true}i=e.split(",");this._calculateHEX(parseInt(i[0]),parseInt(i[1]),parseInt(i[2]));this._processHexChanges(this.sHexString);this.Color.old=this.Color.hex;if(o){this.Color.a=this.Color.oldA=parseFloat(i[3])}return true}if(this._bHSLMode){this.Color.formatHSL=false}return false};_.prototype._parseColorName=function(e){return F.Colors[e]};_.prototype.onAfterRendering=function(){var e=this._getCSSColorString(),t=this.getParent();this.$CPBox=this.oCPBox.$();this.$CPCur=this.oCPBox.getHandle();this.$().find(".sapUiColorPicker-ColorPickerNewColor").css("background-color",e);this.$().find(".sapUiColorPicker-ColorPickerOldColor").css("background-color",e);this._updateGradientBoxBackground(this.Color.h);this._iCPBoxSize=this.oCPBox.getWidth();this._updateCursorPosition();this._updateAlphaBackground();this.oSlider.iShiftGrip=Math.round(jQuery(this.oSlider.oGrip).outerWidth()/2);this.oAlphaSlider.iShiftGrip=Math.round(jQuery(this.oAlphaSlider.oGrip).outerWidth()/2);if(t&&t.getMetadata().getName()==="sap.m.Dialog"){t.addStyleClass("sapUiCPDialog")}this.addStyleClass("sapUiCPDisplayRGB");if(d.system.phone){this._toggleFields()}};_.prototype.getRGB=function(){return{r:this.Color.r,g:this.Color.g,b:this.Color.b}};_.prototype._getConstants=function(){return F};_.prototype._createCommonsColorPicker=function(e,t){e=new o({containerQuery:true,content:[this.oCPBox.setLayoutData(this.oCPBoxGD),new l({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED","R:"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN","G:"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE","B:"),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","#:")],layoutData:this.icOne}),new l({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE","H:"),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","S:","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","L:","%").addStyleClass(F.HideForHSVClass),this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","A:").addStyleClass(F.HideForHSVClass),this._createRowFromInput(this.oAlphaField2,"COLORPICKER_ALPHA","A:").addStyleClass(F.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE","V:").addStyleClass(F.HideForHSLClass)],layoutData:this.icTwo}).addStyleClass(F.LastColumnClass),new r({content:[new i({content:["<div id='",t,"-ocBox' class='",F.OldColorClass,"'></div>"].join("")}),new i({content:["<div id='",t,"-ncBox' class='",F.NewColorClass,"'></div>"].join("")})],layoutData:this.swatches}).addStyleClass(F.SwatchesClass),new r({content:[this.oColorPickerHelper.factory.createLabel({text:"Output:",labelFor:this.oRGBorHSLRBGroup}),this.oRGBorHSLRBGroup],layoutData:this.rbg}).addStyleClass(F.HideForHSVClass).addStyleClass(F.OutputSelectorRowClass),this.oSlider.setLayoutData(new a({span:"L6 M6 S12",linebreak:true})),this.oAlphaSlider.setLayoutData(new a({span:"L6 M6 S12"}))]}).addStyleClass(F.CPMatrixClass);return e};_.prototype._createUnifiedColorPicker=function(e){var t=this;this.oRbRGB=this.oColorPickerHelper.factory.createRadioButtonItem({tooltip:H.getText("COLORPICKER_SELECT_RGB_TOOLTIP")});this.oRbRGB.addStyleClass("sapUiCPRB");this.oRbHSLV=this.oColorPickerHelper.factory.createRadioButtonItem({tooltip:H.getText("COLORPICKER_SELECT_HSL_TOOLTIP")});this.oRbHSLV.addStyleClass("sapUiCPRB");this.oButton=this.oColorPickerHelper.factory.createButton(e+"-toggleMode",{type:d.system.phone?"Default":"Transparent",tooltip:H.getText("COLORPICKER_TOGGLE_BTN_TOOLTIP"),icon:"sap-icon://source-code",press:function(e){t._toggleFields()}});this.setAggregation("_oButton",this.oButton,true);this.oRGBorHSLRBUnifiedGroup=this.oColorPickerHelper.factory.createRadioButtonGroup({select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:this.Color.formatHSL?1:0});this.oRGBorHSLRBUnifiedGroup.addButton(this.oRbRGB);this.oRGBorHSLRBUnifiedGroup.addButton(this.oRbHSLV);this.setAggregation("_oRGBorHSLRBUnifiedGroup",this.oRGBorHSLRBUnifiedGroup,true);this.setAggregation("_oCPBox",this.oCPBox,true);this.setAggregation("_oHexField",this.oHexField,true);this.setAggregation("_oRedField",this.oRedField,true);this.setAggregation("_oGreenField",this.oGreenField,true);this.setAggregation("_oBlueField",this.oBlueField,true);this.setAggregation("_oHueField",this.oHueField,true);this.setAggregation("_oSatField",this.oSatField,true);this.setAggregation("_oLitField",this.oLitField,true);this.setAggregation("_oAlphaField",this.oAlphaField,true);this.setAggregation("_oAlphaField2",this.oAlphaField2,true);this.setAggregation("_oValField",this.oValField,true);this.setAggregation("_oSlider",this.oSlider,true);this.setAggregation("_oAlphaSlider",this.oAlphaSlider,true)};_.prototype._toggleFields=function(){if(!d.system.phone){this.toggleStyleClass("sapUiCPDisplayRGB",this.bPressed);this.bPressed=!this.bPressed}else{switch(this.sVisibleFiled){case"HSL":this.removeStyleClass("sapUiCPHexVisible");this.toggleStyleClass("sapUiCPDisplayRGB",false);this.addStyleClass("sapUiCPHideHex");this.sVisibleFiled="RGB";break;case"RGB":this.removeStyleClass("sapUiCPHexVisible");this.addStyleClass("sapUiCPHideHex");this.toggleStyleClass("sapUiCPDisplayRGB",true);this.sVisibleFiled="Hex";break;case"Hex":default:this.addStyleClass("sapUiCPHexVisible");this.removeStyleClass("sapUiCPHideHex");this.sVisibleFiled="HSL";break}}};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ColorPickerDisplayMode", [],function(){"use strict";var e={Default:"Default",Large:"Large",Simplified:"Simplified"};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ColorPickerHelper", ["sap/ui/core/Lib"],function(e){"use strict";var t;var n={isResponsive:function(){return true},factory:{createLabel:function(e){return new sap.m.Label(e)},createInput:function(e,t){return new sap.m.InputBase(e,t)},createSlider:function(e,t){return new sap.m.Slider(e,t)},createRadioButtonGroup:function(e){return new sap.m.RadioButtonGroup(e)},createRadioButtonItem:function(e){return new sap.m.RadioButton(e)},createButton:function(e,t){return new sap.m.Button(e,t)}}};var r={isResponsive:function(){return false},factory:{createLabel:function(e){return new sap.ui.commons.Label(e)},createInput:function(e,t){return new sap.ui.commons.TextField(e,t)},createSlider:function(e,t){if(t&&t.step){t.smallStepWidth=t.step;delete t.step}return new sap.ui.commons.Slider(e,t)},createRadioButtonGroup:function(e){if(e&&e.buttons){e.items=e.buttons;delete e.buttons}return new sap.ui.commons.RadioButtonGroup(e)},createRadioButtonItem:function(e){return new sap.ui.core.Item(e)}}};var o={isResponsive:function(){return false},factory:{createLabel:function(){throw new Error("no Label control available")},createInput:function(){throw new Error("no Input control available")},createSlider:function(){throw new Error("no Slider control available")},createRadioButtonGroup:function(){throw new Error("no RadioButtonGroup control available")},createRadioButtonItem:function(){throw new Error("no RadioButtonItem control available")}}};t={getHelper:function(){if(e.isLoaded("sap.m")){return n}else if(e.isLoaded("sap.ui.unified")){return r}return o}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ColorPickerPopover", ["sap/ui/core/Control","sap/ui/Device","sap/m/Button","sap/m/ResponsivePopover","./ColorPicker","./library","sap/m/library","sap/ui/thirdparty/jquery"],function(e,t,o,r,i,n,p,jQuery){"use strict";var a=p.PlacementType;var s=n.ColorPickerMode,l=n.ColorPickerDisplayMode;var u=p.ButtonType;var y=e.extend("sap.ui.unified.ColorPickerPopover",{metadata:{library:"sap.ui.unified",publicMethods:["openBy","close"],properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:s.HSV},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:l.Default}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}},renderer:{apiVersion:2}});var P=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var h={COLOR_PICKER_PROPS:{colorString:"setColorString",mode:"setMode",displayMode:"setDisplayMode"},POPOVER_METHODS:{getDomRef:"",close:""}};y.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null};y.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null}};y.prototype.openBy=function(e){return r.prototype.openBy.apply(this._ensurePopover(),arguments)};y.prototype._getColorPicker=function(){return this._ensurePopover().getContent()[0]};y.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover()}return this._oPopover};y.prototype._createPopover=function(){var e,i=this._createColorPicker(),n,p=this;e=new r(this.getId()+"-colorPickerPopover",{showHeader:t.system.phone,placement:a.VerticalPreferredBottom,showArrow:false,showCloseButton:false,beginButton:new o({text:P.getText("COLOR_PICKER_SUBMIT"),type:u.Emphasized,press:function(){p.fireChange(p._oLastChangeCPParams);e.close()}}),endButton:new o({text:P.getText("COLOR_PICKER_CANCEL"),press:function(){e.close()}}),title:P.getText("COLOR_PICKER_TITLE"),content:i});i.attachChange(function(e){this._handleChange(e)}.bind(this));i.attachLiveChange(function(e){this.fireLiveChange(e.getParameters())}.bind(this));n={onAfterRendering:function(){var e=this.$();e.attr("aria-modal","true");e.attr("aria-label",this.getTitle())}};e.addEventDelegate(n,e);e._onAfterRenderingDelegate=n;return e};y.prototype._handleChange=function(e){var t={};this._oLastChangeCPParams=jQuery.extend(t,e.getParameters());delete this._oLastChangeCPParams.id;return this};y.prototype._createColorPicker=function(){var e=new i(this.getId()+"-color_picker");return e};y.prototype.setProperty=function(t,o,r){var n;if(h.COLOR_PICKER_PROPS[t]!==undefined){n=h.COLOR_PICKER_PROPS[t]||t;i.prototype[n].call(this._getColorPicker(),o)}return e.prototype.setProperty.apply(this,arguments)};Object.keys(h.POPOVER_METHODS).forEach(function(e){var t=h.POPOVER_METHODS[e]||e;y.prototype[e]=function(){if(this._bPopoverDestroying){return null}var e=this._ensurePopover();return e[t].apply(e,arguments)}});return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ColorPickerRenderer", ["./ColorPickerDisplayMode","sap/ui/Device"],function(e,o){"use strict";var r={apiVersion:2};r.render=function(r,t){var n=t.getDisplayMode(),i=t.bResponsive;r.openStart("div",t);r.accessibilityState(t,{role:"group",roledescription:sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("COLOR_PICKER_TITLE")});if(i){r.class("sapUiColorPicker-ColorPickerMatrix");r.class("sapUiColorPicker-"+n);r.class("sapUnifiedColorPicker");if(t._bHSLMode){r.class("sapUiColorPickerHSL")}}if(o.system.phone){r.class("sapUiCPPhone")}r.openEnd();if(!i){r.renderControl(t.getAggregation("_grid"))}else{switch(n){case e.Default:this.renderDefaultColorPicker(r,t);break;case e.Large:this.renderLargeColorPicker(r,t);break;case e.Simplified:this.renderSimplifiedColorPicker(r,t)}}r.close("div")};r.renderDefaultColorPicker=function(e,r){e.renderControl(r.getAggregation("_oCPBox"));if(o.system.phone){e.openStart("div");e.class("sapUiCPPhoneContent");e.openEnd();e.openStart("div");e.class("sapUiCPSlidersPhone");e.openEnd();e.renderControl(r.getAggregation("_oSlider"));e.renderControl(r.getAggregation("_oAlphaSlider"));e.close("div");this.renderMobileSwatches(e,r);e.close("div")}else{e.renderControl(r.getAggregation("_oSlider"));e.renderControl(r.getAggregation("_oAlphaSlider"));this.renderDesktopSwatchesAndHexFields(e,r)}e.openStart("div");e.class("sapUiCPDefaultWrapper");e.openEnd();if(o.system.phone){e.renderControl(r.getAggregation("_oHexField"));e.openStart("div");e.class("sapUiCPHexText");e.openEnd();e.text("Hex");e.close("div")}e.openStart("div");e.class("sapUiCPDefaultRGB");e.openEnd();e.renderControl(r.getAggregation("_oRedField"));this.renderEmptyDiv(e);e.renderControl(r.getAggregation("_oGreenField"));this.renderEmptyDiv(e);e.renderControl(r.getAggregation("_oBlueField"));this.renderEmptyDiv(e);e.renderControl(r.getAggregation("_oAlphaField"));e.close("div");e.openStart("div");e.class("sapUiCPDefaultHSLV");e.openEnd();e.renderControl(r.getAggregation("_oHueField"));this.renderEmptyDiv(e);e.renderControl(r.getAggregation("_oSatField"));e.openStart("div");e.class("sapUiCPPercentSymbol");e.openEnd();e.text("%");e.close("div");e.renderControl(r.getAggregation("_oLitField"));e.renderControl(r.getAggregation("_oValField"));if(r.getMode()==="HSL"){e.openStart("div");e.class("sapUiCPPercentSymbol");e.openEnd();e.text("%");e.close("div")}else{this.renderEmptyDiv(e)}e.renderControl(r.getAggregation("_oAlphaField2"));e.close("div");e.renderControl(r.getAggregation("_oButton"));this.renderRGBLabel(e,r);this.renderHSLVLabel(e,r);e.close("div")};r.renderLargeColorPicker=function(e,o){e.renderControl(o.getAggregation("_oCPBox"));e.renderControl(o.getAggregation("_oSlider"));e.renderControl(o.getAggregation("_oAlphaSlider"));this.renderDesktopSwatchesAndHexFields(e,o);e.renderControl(o.oRGBorHSLRBUnifiedGroup);e.openStart("div");e.class("sapUiCPRGBA");e.openEnd();e.renderControl(o.getAggregation("_oRedField"));this.renderEmptyDiv(e);e.renderControl(o.getAggregation("_oGreenField"));this.renderEmptyDiv(e);e.renderControl(o.getAggregation("_oBlueField"));this.renderEmptyDiv(e);e.renderControl(o.getAggregation("_oAlphaField"));e.close("div");this.renderRGBLabel(e,o);e.openStart("div");e.class("sapUiCPHSLV");e.openEnd();e.renderControl(o.getAggregation("_oHueField"));this.renderEmptyDiv(e);e.renderControl(o.getAggregation("_oSatField"));e.openStart("div");e.class("sapUiCPPercentSymbol");e.openEnd();e.text("%");e.close("div");o.getMode()==="HSL"?this.renderLFirst(e,o):this.renderVFirst(e,o);e.close("div");this.renderHSLVLabel(e,o)};r.renderSimplifiedColorPicker=function(e,r){e.renderControl(r.getAggregation("_oCPBox"));if(o.system.phone){e.openStart("div");e.class("sapUiCPPhoneContent");e.openEnd();e.openStart("div");e.class("sapUiCPSlidersPhone");e.openEnd();e.renderControl(r.getAggregation("_oSlider"));e.close("div");e.renderControl(r.getAggregation("_oHexField"));this.renderMobileSwatches(e,r);e.openStart("div");e.class("sapUiCPHexWrapper");e.openEnd();e.openStart("div");e.class("sapUiCPHexText");e.openEnd();e.text("Hex");e.close("div");e.close("div");e.close("div")}else{e.renderControl(r.getAggregation("_oSlider"));this.renderDesktopSwatchesAndHexFields(e,r)}};r.renderDesktopSwatchesAndHexFields=function(e,o){e.openStart("div");e.class("sapUiCPComparisonWrapper");e.openEnd();e.openStart("div",o.getId()+"-ocBox");e.class("sapUiColorPicker-ColorPickerOldColor");e.openEnd();e.close("div");e.openStart("div",o.getId()+"-ncBox");e.class("sapUiColorPicker-ColorPickerNewColor");e.openEnd();e.close("div");e.close("div");e.openStart("div");e.class("sapUiCPHexWrapper");e.openEnd();e.openStart("span");e.class("sapUiCPHexText");e.openEnd();e.text("Hex");e.close("span");e.close("div");e.renderControl(o.getAggregation("_oHexField"))};r.renderMobileSwatches=function(e,o){e.openStart("div");e.class("sapUiCPComparisonWrapper");e.class("sapUiCPComparisonWrapperPhone");e.openEnd();e.openStart("div",o.getId()+"-ocBox");e.class("sapUiColorPicker-ColorPickerOldColor");e.openEnd();e.close("div");e.openStart("div",o.getId()+"-ncBox");e.class("sapUiColorPicker-ColorPickerNewColor");e.openEnd();e.close("div");e.close("div")};r.renderLFirst=function(e,o){e.renderControl(o.getAggregation("_oLitField"));e.openStart("div");e.class("sapUiCPPercentSymbol");e.openEnd();e.text("%");e.close("div");e.renderControl(o.getAggregation("_oValField"))};r.renderVFirst=function(e,o){e.renderControl(o.getAggregation("_oValField"));this.renderEmptyDiv(e);e.renderControl(o.getAggregation("_oLitField"))};r.renderEmptyDiv=function(e){e.openStart("div");e.class("sapUiCPEmptyDiv");e.openEnd();e.close("div")};r.renderRGBLabel=function(e,o){e.openStart("div");e.class("sapUiCPRGBText");e.openEnd();e.openStart("span");e.class("sapUiCPText");e.openEnd();e.text("R");e.close("span");this.renderEmptyDiv(e);e.openStart("span");e.class("sapUiCPText");e.openEnd();e.text("G");e.close("span");this.renderEmptyDiv(e);e.openStart("span");e.class("sapUiCPText");e.openEnd();e.text("B");e.close("span");this.renderEmptyDiv(e);if(o.getDisplayMode()==="Default"){e.openStart("span");e.class("sapUiCPText");e.openEnd();e.text("A");e.close("span")}else{e.openStart("span");e.class("sapUiCPText");e.openEnd();e.close("span")}e.close("div")};r.renderHSLVLabel=function(e,o){e.openStart("div");e.class("sapUiCPHSLVText");e.openEnd();e.openStart("span");e.class("sapUiCPText");e.openEnd();e.text("H");e.close("span");this.renderEmptyDiv(e);e.openStart("span");e.class("sapUiCPText");e.openEnd();e.text("S");e.close("span");this.renderEmptyDiv(e);if(o.getMode()==="HSL"){e.openStart("span");e.class("sapUiCPText");e.openEnd();e.text("L");e.close("span")}else{e.openStart("span");e.class("sapUiCPText");e.openEnd();e.text("V");e.close("span")}this.renderEmptyDiv(e);e.openStart("span");e.class("sapUiCPText");e.openEnd();e.text("A");e.close("span");e.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ContentSwitcher", ["sap/ui/core/Control","./library","./ContentSwitcherRenderer","sap/base/Log"],function(t,e,n,i){"use strict";var o=e.ContentSwitcherAnimation;var r=t.extend("sap.ui.unified.ContentSwitcher",{metadata:{deprecated:true,library:"sap.ui.unified",properties:{animation:{type:"string",group:"Appearance",defaultValue:"None"},activeContent:{type:"int",group:"Behavior",defaultValue:1}},aggregations:{content1:{type:"sap.ui.core.Control",multiple:true,singularName:"content1"},content2:{type:"sap.ui.core.Control",multiple:true,singularName:"content2"}}},renderer:n});(function(t){r.prototype.init=function(){};r.prototype.switchContent=function(){this.setActiveContent(this.getActiveContent()==1?2:1);return this};r.prototype.onAfterRendering=function(){this._$Contents=[this.$("content1"),this.$("content2")]};r.prototype._showActiveContent=function(t){if(this._$Contents){this._$Contents[0].toggleClass("sapUiUfdCSwitcherVisible",t===1);this._$Contents[1].toggleClass("sapUiUfdCSwitcherVisible",t===2)}};r.prototype.setActiveContent=function(t){t=parseInt(t);if(isNaN(t)||t<1){t=1;i.warning("setActiveContent argument must be either 1 or 2. Active content set to 1.")}else if(t>2){t=2;i.warning("setActiveContent argument must be either 1 or 2. Active content set to 2.")}this.setProperty("activeContent",t,true);this._showActiveContent(t);return this};r.prototype.setAnimation=function(t,e){if(typeof t!=="string"){t=o.None;i.warning('setAnimation argument must be a string. Animation was set to "'+o.None+'".')}t=t.replace(/[^a-zA-Z0-9]/g,"");var n=this.getProperty("animation");if(t===n){return this}var r=this.$();if(r[0]){r.toggleClass("sapUiUfdCSwitcherAnimation"+n,false);r.toggleClass("sapUiUfdCSwitcherAnimation"+t,true)}return this.setProperty("animation",t,e)}})(window);return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ContentSwitcherRenderer", ["sap/ui/unified/library","sap/base/security/encodeXML","sap/ui/core/Configuration"],function(t,e,i){"use strict";var n=t.ContentSwitcherAnimation;var r={};r.render=function(t,r){var o=r.getId();var a=r.getAnimation();if(i.getAnimationMode()===i.AnimationMode.none){a=n.None}var s=r.getActiveContent();t.write("<div");t.writeControlData(r);t.addClass("sapUiUfdCSwitcher");t.addClass("sapUiUfdCSwitcherAnimation"+e(a));t.writeClasses();t.write(">");t.write('<section id="'+o+'-content1" class="sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1'+(s==1?" sapUiUfdCSwitcherVisible":"")+'">');this.renderContent(t,r.getContent1());t.write("</section>");t.write('<section id="'+o+'-content2" class="sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2'+(s==2?" sapUiUfdCSwitcherVisible":"")+'">');this.renderContent(t,r.getContent2());t.write("</section>");t.write("</div>")};r.renderContent=function(t,e){for(var i=0;i<e.length;++i){t.renderControl(e[i])}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/Currency", ["sap/ui/core/Control","sap/m/library","sap/ui/core/format/NumberFormat","./CurrencyRenderer"],function(e,t,r,i){"use strict";var n=t.EmptyIndicatorMode;var u=e.extend("sap.ui.unified.Currency",{metadata:{library:"sap.ui.unified",properties:{value:{type:"float",group:"Appearance",defaultValue:0},stringValue:{type:"string",group:"Appearance",defaultValue:null},currency:{type:"string",group:"Appearance",defaultValue:null},maxPrecision:{type:"int",group:"Appearance"},useSymbol:{type:"boolean",group:"Appearance",defaultValue:true},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:n.Off}},designtime:"sap/ui/unified/designtime/Currency.designtime",dnd:{draggable:true,droppable:false}},renderer:i});u.FIGURE_SPACE=" ";u.PUNCTUATION_SPACE=" ";u.prototype.init=function(){this._oFormat=r.getCurrencyInstance({showMeasure:false})};u.prototype.exit=function(){this._oFormat=null;this._$Value=null;this._$Currency=null;this._sLastCurrency=null;this._iLastCurrencyDigits=null;this._bRenderNoValClass=null};u.prototype.onAfterRendering=function(){if(this.$()){this._$Value=this.$().find(".sapUiUfdCurrencyValue");this._$Currency=this.$().find(".sapUiUfdCurrencyCurrency")}};u.prototype.setValue=function(e){if(this.isBound("value")){this._bRenderNoValClass=e==null}this.setProperty("value",e,true);this._renderValue();return this};u.prototype.unbindProperty=function(t){e.prototype.unbindProperty.apply(this,arguments);if(t==="value"){this._bRenderNoValClass=false}};u.prototype.setCurrency=function(e){var t,r;this.setProperty("currency",e,true);this._renderCurrency();t=this._oFormat.oLocaleData.getCurrencyDigits(e);if(this._iLastCurrencyDigits!=null&&this._iLastCurrencyDigits!==t){r=true}else if(this._oFormat.oLocaleData.getCurrencyDigits()!==t){r=true}this._iLastCurrencyDigits=t;if(this._sLastCurrency==="*"||e==="*"){r=true}this._sLastCurrency=e;if(r){this._renderValue()}return this};u.prototype.setUseSymbol=function(e){this.setProperty("useSymbol",e,true);this._renderCurrency();return this};u.prototype.setMaxPrecision=function(e){this.setProperty("maxPrecision",e,true);this._renderValue();return this};u.prototype._renderValue=function(){if(this._$Value){this._$Value.text(this.getFormattedValue())}};u.prototype._renderCurrency=function(){if(this._$Currency){this._$Currency.text(this._getCurrency())}};u.prototype._getCurrency=function(){return this.getUseSymbol()?this.getCurrencySymbol():this.getCurrency()};u.prototype.getFormattedValue=function(){var e=this.getCurrency(),t,r,i,n=this.getMaxPrecision(),s=!n&&n!==0;if(e==="*"){return""}r=this._oFormat.oLocaleData.getCurrencyDigits(e);if(s){n=r}n=n<=0&&r>0?n-1:n;t=n-r;i=this._oFormat.format(this.getStringValue()||this.getValue(),e);if(t==n&&n>0){i+=u.PUNCTUATION_SPACE}if(t>0){i=i.padEnd(i.length+t,u.FIGURE_SPACE)}else if(t<0){i=i.substr(0,i.length+t)}return i};u.prototype.getCurrencySymbol=function(){return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency())};u.prototype.getAccessibilityInfo=function(){if(this._bRenderNoValClass){return{}}return{description:(this.getFormattedValue()||"")+" "+(this.getCurrency()||"").trim()}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/CurrencyRenderer", ["sap/m/library","sap/ui/core/Core"],function(e,t){"use strict";var n={apiVersion:2};var a=e.EmptyIndicatorMode;var r=t.getLibraryResourceBundle("sap.m");n.render=function(e,t){var n=t.getTooltip_AsString();e.openStart("div",t);if(n){e.attr("title",n)}e.class("sapUiUfdCurrency");if(t.getEmptyIndicatorMode()!==a.Off&&!t.getValue()){e.openEnd();this.renderEmptyIndicator(e,t)}else{e.openEnd();e.openStart("div");e.class("sapUiUfdCurrencyAlign");e.openEnd();e.openStart("span");e.attr("dir","ltr");e.class("sapUiUfdCurrencyValue");e.openEnd();e.text(t.getFormattedValue());e.close("span");e.openStart("span");e.class("sapUiUfdCurrencyCurrency");e.openEnd();e.text(t._getCurrency());e.close("span");e.close("div")}e.close("div")};n.renderEmptyIndicator=function(e,t){e.openStart("span");e.class("sapMEmptyIndicator");if(t.getEmptyIndicatorMode()===a.Auto){e.class("sapMEmptyIndicatorAuto")}e.openEnd();e.openStart("span");e.attr("aria-hidden",true);e.openEnd();e.text(r.getText("EMPTY_INDICATOR"));e.close("span");e.openStart("span");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(r.getText("EMPTY_INDICATOR_TEXT"));e.close("span");e.close("span")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/DateRange", ["sap/ui/core/Element","./library","sap/ui/unified/calendar/CalendarUtils"],function(e,t,a){"use strict";var r=e.extend("sap.ui.unified.DateRange",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Misc",defaultValue:null},endDate:{type:"object",group:"Misc",defaultValue:null}}}});r.prototype.setStartDate=function(e,t){if(e){a._checkJSDateObject(e);var r=e.getFullYear();a._checkYearInValidRange(r)}this.setProperty("startDate",e,t);return this};r.prototype.setEndDate=function(e,t){if(e){a._checkJSDateObject(e);var r=e.getFullYear();a._checkYearInValidRange(r)}this.setProperty("endDate",e,t);return this};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/DateTypeRange", ["./DateRange","./library"],function(e,a){"use strict";var p=a.CalendarDayType;var r=e.extend("sap.ui.unified.DateTypeRange",{metadata:{library:"sap.ui.unified",properties:{type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:p.Type01},secondaryType:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:p.None},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/FileUploader", ["sap/ui/core/Control","./library","sap/ui/core/LabelEnablement","sap/ui/core/InvisibleText","sap/ui/core/library","sap/ui/core/StaticArea","sap/ui/Device","./FileUploaderRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/Log","sap/base/security/encodeXML","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","./FileUploaderHelper","sap/ui/dom/jquery/Aria"],function(e,t,i,s,o,r,a,l,n,p,h,u,jQuery,d,f){var g=o.ValueState;var c=t.FileUploaderHttpRequestMethod;var y=e.extend("sap.ui.unified.FileUploader",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.unified.IProcessableBlobs"],library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/FileUploader.designtime",properties:{value:{type:"string",group:"Data",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},name:{type:"string",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:""},uploadOnChange:{type:"boolean",group:"Behavior",defaultValue:false},additionalData:{type:"string",group:"Data",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},buttonText:{type:"string",group:"Misc",defaultValue:null},fileType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},sendXHR:{type:"boolean",group:"Behavior",defaultValue:false},httpRequestMethod:{type:"sap.ui.unified.FileUploaderHttpRequestMethod",group:"Behavior",defaultValue:c.Post},placeholder:{type:"string",group:"Appearance",defaultValue:null},style:{type:"string",group:"Appearance",defaultValue:null},buttonOnly:{type:"boolean",group:"Appearance",defaultValue:false},useMultipart:{type:"boolean",group:"Behavior",defaultValue:true},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:g.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconHovered:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconSelected:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},iconOnly:{type:"boolean",group:"Appearance",defaultValue:false},directory:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{parameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"parameter"},headerParameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"headerParameter"},xhrSettings:{type:"sap.ui.unified.FileUploaderXHRSettings",multiple:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{newValue:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{fileName:{type:"string"},response:{type:"string"},readyStateXHR:{type:"string"},status:{type:"string"},responseRaw:{type:"string"},headers:{type:"object"},requestHeaders:{type:"object[]"}}},typeMissmatch:{parameters:{fileName:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"}}},fileSizeExceed:{parameters:{fileName:{type:"string"},fileSize:{type:"string"}}},fileEmpty:{parameters:{fileName:{type:"string"}}},fileAllowed:{},uploadProgress:{parameters:{lengthComputable:{type:"boolean"},loaded:{type:"float"},total:{type:"float"},fileName:{type:"string"},requestHeaders:{type:"object[]"}}},uploadAborted:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}},filenameLengthExceed:{parameters:{fileName:{type:"string"}}},uploadStart:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}},beforeDialogOpen:{},afterDialogClose:{}}},renderer:l});y.prototype.init=function(){var e=this;this.oFileUploaderHelper=f.getHelper();this.oFilePath=this.oFileUploaderHelper.createTextField(this.getId()+"-fu_input").addEventDelegate({onAfterRendering:function(){if(e.getWidth()){e._resizeDomElements()}}});this.oBrowse=this.oFileUploaderHelper.createButton(this.getId()+"-fu_button");this.oFilePath.setParent(this);this.oBrowse.setParent(this);this.oFileUpload=null;this.bMobileLib=this.oBrowse.getMetadata().getName()=="sap.m.Button";if(d.getAccessibility()){if(!y.prototype._sAccText){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");y.prototype._sAccText=t.getText("FILEUPLOAD_ACC")}if(this.oBrowse.addAriaDescribedBy){this.oBrowse.addAriaDescribedBy(this.getId()+"-AccDescr")}if(this.oFilePath){this.oFilePath.addAriaLabelledBy(s.getStaticId("sap.ui.unified","FILEUPLOAD_FILENAME"))}}this._submitAfterRendering=false};y.prototype.setIcon=function(e){this.oBrowse.setIcon(e);this.setProperty("icon",e,false);return this};y.prototype.setIconHovered=function(e){this.setProperty("iconHovered",e,false);if(this.oBrowse.setIconHovered){this.oBrowse.setIconHovered(e)}return this};y.prototype.setIconSelected=function(e){this.setProperty("iconSelected",e,false);if(this.oBrowse.setIconSelected){this.oBrowse.setIconSelected(e)}else{this.oBrowse.setActiveIcon(e)}return this};y.prototype.setIconFirst=function(e){this.oBrowse.setIconFirst(e);this.setProperty("iconFirst",e,false);return this};y.prototype.getIdForLabel=function(){return this.oBrowse.getId()};y.prototype._ensureBackwardsReference=function(){var e=this.oBrowse,t=e.getAriaLabelledBy(),s=i.getReferencingLabels(this);if(t){s.forEach(function(i){if(t.indexOf(i)===-1){e.addAriaLabelledBy(i)}})}return this};y.prototype.setFileType=function(e){var t=this._convertTypesToArray(e);this.setProperty("fileType",t,false);this._rerenderInputField();return this};y.prototype.setMimeType=function(e){var t=this._convertTypesToArray(e);this.setProperty("mimeType",t,false);this._rerenderInputField();return this};y.prototype.setMultiple=function(e){this.setProperty("multiple",e,false);this._rerenderInputField();return this};y.prototype.setDirectory=function(e){this.setProperty("directory",e,false);this._rerenderInputField();return this};y.prototype._rerenderInputField=function(){if(this.oFileUpload){var e=this.oFileUpload.files;this._clearInputField();this._prepareFileUpload();jQuery(this.oFileUpload).on("change",this.handlechange.bind(this));this.oFileUpload.files=e;this._cacheDOMEls()}};y.prototype.setTooltip=function(t){var i;e.prototype.setTooltip.call(this,t);if(this.oFileUpload){i=this.getTooltip_AsString();if(i){this.oFileUpload.setAttribute("title",i)}else{this.oFileUpload.setAttribute("title",this.getValue()?this.getValue():this._getNoFileChosenText())}}return this};y.prototype.addAriaLabelledBy=function(e){this.addAssociation("ariaLabelledBy",e);this.oBrowse.addAriaLabelledBy(e);return this};y.prototype.removeAriaLabelledBy=function(e){var t=this.removeAssociation("ariaLabelledBy",e);if(!t){return}this.oBrowse.removeAriaLabelledBy(t);return t};y.prototype.removeAllAriaLabelledBy=function(){var e=this.removeAllAssociation("ariaLabelledBy"),t=this.oBrowse.getAriaLabelledBy();e.forEach(function(e){if(t.indexOf(e)>=0){this.oBrowse.removeAriaLabelledBy(e)}}.bind(this));return e};y.prototype.addAriaDescribedBy=function(e){this.addAssociation("ariaDescribedBy",e);this.oBrowse.addAriaDescribedBy(e);return this};y.prototype.removeAriaDescribedBy=function(e){var t=this.removeAssociation("ariaDescribedBy",e);if(!t){return}this.oBrowse.removeAriaDescribedBy(t);return t};y.prototype.removeAllAriaDescribedBy=function(){var e=this.removeAllAssociation("ariaDescribedBy"),t=this.oBrowse.getAriaDescribedBy();e.forEach(function(e){if(t.indexOf(e)>=0){this.oBrowse.removeAriaDescribedBy(e)}}.bind(this));return e};y.prototype._generateAccDescriptionText=function(){var e=this.getTooltip_AsString(),t=this.getPlaceholder(),s=this.getValue(),o=i.isRequired(this),r="";if(o){r+=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("FILEUPLOAD_REQUIRED")+" "}if(e){r+=e+" "}if(s){r+=s+" "}else if(t){r+=t+" "}r+=this._sAccText;return r};y.prototype._convertTypesToArray=function(e){if(typeof e==="string"){if(e===""){return[]}else{return e.split(",").map(function(e){return e.trim()})}}return e};y.prototype.exit=function(){this.oFilePath.destroy();this.oBrowse.destroy();if(this.oIFrameRef){jQuery(this.oIFrameRef).off();r.getDomRef().removeChild(this.oIFrameRef);this.oIFrameRef=null}if(this.oFileUpload){this._clearInputField()}if(this.FUEl){this.FUEl=null}if(this.FUDataEl){this.FUDataEl=null}};y.prototype._clearInputField=function(){jQuery(this.oFileUpload).off();this.oFileUpload.parentElement.removeChild(this.oFileUpload);this.oFileUpload=null};y.prototype.onBeforeRendering=function(){var e=r.getDomRef();jQuery(this.oFileUpload).appendTo(e);if(!this.getName()){h.warning("Name property is not set. Id would be used instead to identify the control on the server.",this)}jQuery(this.oFileUpload).off();if(this.getIconOnly()&&this.getButtonOnly()){this.oBrowse.setText("");this.oBrowse.setTooltip(this.getTooltip_AsString()||this.getBrowseText())}else if(this.getIconOnly()){this.oBrowse.setText("");this.oBrowse.setTooltip(this.getBrowseText())}else{this.oBrowse.setText(this.getButtonText()||this.getBrowseText());this.oBrowse.setTooltip("")}this.oFilePath.setPlaceholder(this.getPlaceholder())};y.prototype.onAfterRendering=function(){this.prepareFileUploadAndIFrame();this._cacheDOMEls();this._addLabelFeaturesToBrowse();jQuery(this.oFileUpload).on("change",this.handlechange.bind(this));if(!this.bMobileLib){this.oFilePath.$().attr("tabindex","-1")}else{this.oFilePath.$().find("input").attr("tabindex","-1")}setTimeout(this._recalculateWidth.bind(this),0);this.oFilePath.$().find("input").removeAttr("role").attr("aria-live","polite");if(this._submitAfterRendering){this._submitAndResetValue();this._submitAfterRendering=false}};y.prototype._cacheDOMEls=function(){this.FUEl=this.getDomRef("fu");this.FUDataEl=this.getDomRef("fu_data")};y.prototype.onfocusin=function(e){if(!this.oFilePath.shouldValueStateMessageBeOpened||this.oFilePath.shouldValueStateMessageBeOpened()){this.openValueStateMessage()}};y.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!n(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){this.closeValueStateMessage()}};y.prototype._recalculateWidth=function(){if(this.getWidth()){if(this.getButtonOnly()&&this.oBrowse.getDomRef()){this.oBrowse.getDomRef().style.width=this.getWidth()}this._resizeDomElements()}};y.prototype.getFocusDomRef=function(){return this.oBrowse.getDomRef()};y.prototype._resizeDomElements=function(){var e=this.getId();this._oBrowseDomRef=this.oBrowse.getDomRef();var t=jQuery(this._oBrowseDomRef);var i=t.parent().outerWidth(true);this._oFilePathDomRef=this.oFilePath.getDomRef();var s=this._oFilePathDomRef;var o=this.getWidth();if(o.substr(-1)=="%"&&s){while(s.id!=e){s.style.width="100%";s=s.parentNode}s.style.width=o}else{if(s){s.style.width=o;var r=jQuery(this._oFilePathDomRef);var a=r.outerWidth()-i;if(a<0){this.oFilePath.getDomRef().style.width="0px";if(this.oFileUpload){this.oFileUpload.style.width=t.outerWidth(true)}}else{this.oFilePath.getDomRef().style.width=a+"px"}}}};y.prototype.onresize=function(){this._recalculateWidth()};y.prototype.onThemeChanged=function(){this._recalculateWidth()};y.prototype.setEnabled=function(e){var t=jQuery(this.oFileUpload);this.setProperty("enabled",e,false);this.oFilePath.setEnabled(e);this.oBrowse.setEnabled(e);if(this.getEnabled()){t.removeAttr("disabled")}else{t.attr("disabled","disabled")}return this};y.prototype.setValueState=function(e){this.setProperty("valueState",e,false);if(this.oFilePath.setValueState){this.oFilePath.setValueState(e)}else{h.warning("Setting the valueState property with the combination of libraries used is not supported.",this)}var t=n(this.getDomRef(),document.activeElement);switch(e){case g.Error:case g.Warning:case g.Success:this.oBrowse.addAssociation("ariaDescribedBy",this.oFilePath.getId()+"-message-sr");if(t){this.openValueStateMessage()}break;default:this.oBrowse.removeAssociation("ariaDescribedBy",this.oFilePath.getId()+"-message-sr");if(t){this.closeValueStateMessage()}}return this};y.prototype.setValueStateText=function(e){if(this.oFilePath.setValueStateText){this.oFilePath.setValueStateText(e)}else{h.warning("Setting the valueStateText property with the combination of libraries used is not supported.",this)}return this.setProperty("valueStateText",e,false)};y.prototype.setStyle=function(e){this.setProperty("style",e,true);if(e){if(e=="Transparent"){if(this.oBrowse.setLite){this.oBrowse.setLite(true)}else{this.oBrowse.setType("Transparent")}}else{if(this.oBrowse.setType){this.oBrowse.setType(e)}else{if(e=="Emphasized"){e="Emph"}this.oBrowse.setStyle(e)}}}return this};y.prototype.setValue=function(e,t,i){var s=this.getValue();var o;if(s!=e||this.getSameFilenameAllowed()){var r=this.getUploadOnChange()&&e;this.setProperty("value",e,r);if(this.oFileUpload&&!this.getTooltip_AsString()){this.oFileUpload.setAttribute("title",e?e:this._getNoFileChosenText())}if(this.oFilePath){this.oFilePath.setValue(e);if(this.oBrowse.getDomRef()&&!i&&n(this.getDomRef(),document.activeElement)){this.oBrowse.focus()}}var a=this.getDomRef("fu_form"),l=this.getDomRef("fu_input-inner");if(this.oFileUpload&&a&&!e){a.reset();this.getDomRef("fu_input").value="";if(l){l.value=""}jQuery(this.FUDataEl).val(this.getAdditionalData())}if(t){if(window.File){o=this.FUEl.files}if(!this.getSameFilenameAllowed()||e){this.fireChange({id:this.getId(),newValue:e,files:o})}}if(r){this.upload()}}return this};y.prototype.clear=function(){var e=this.getDomRef("fu_form");if(e){e.reset()}return this.setValue("",false,true)};y.prototype.openFilePicker=function(){if(this.oFileUpload){this.oFileUpload.click()}return this};y.prototype.getInputReference=function(){return this.oFileUpload};y.prototype.onmousedown=function(e){if(!this.bMobileLib){this.oBrowse.onmousedown(e)}};y.prototype.onmouseup=function(e){if(!this.bMobileLib){this.oBrowse.onmouseup(e)}};y.prototype.onmouseover=function(e){if(!this.bMobileLib){jQuery(this.oBrowse.getDomRef()).addClass("sapUiBtnStdHover");this.oBrowse.onmouseover(e)}};y.prototype.onmouseout=function(e){if(!this.bMobileLib){jQuery(this.oBrowse.getDomRef()).removeClass("sapUiBtnStdHover");this.oBrowse.onmouseout(e)}};y.prototype.setAdditionalData=function(e){this.setProperty("additionalData",e,true);var t=this.FUDataEl;if(t){e=this.getAdditionalData()||"";t.value=e}return this};y.prototype.sendFiles=function(e,t){var i=this;var s=true;for(var o=0;o<e.length;o++){if(!e[o].bPosted){s=false;break}}if(s){if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){i.setValue("",true)}return}var r=e[t];var a=r.file.name?r.file.name:"MultipartFile";var l=r.requestHeaders;var n=function(e){var t={lengthComputable:!!e.lengthComputable,loaded:e.loaded,total:e.total};i.fireUploadProgress({lengthComputable:t.lengthComputable,loaded:t.loaded,total:t.total,fileName:a,requestHeaders:l})};r.xhr.upload.addEventListener("progress",n);r.xhr.onreadystatechange=function(){var e;var t;var s={};var o;var n;var p;var h;h=r.xhr.readyState;var u=r.xhr.status;if(r.xhr.readyState==4){if(r.xhr.responseXML){e=r.xhr.responseXML.documentElement.textContent}t=r.xhr.response;o=r.xhr.getAllResponseHeaders();if(o){n=o.split("\r\n");for(var d=0;d<n.length;d++){if(n[d]){p=n[d].indexOf(": ");s[n[d].substring(0,p)]=n[d].substring(p+2)}}}i.fireUploadComplete({fileName:a,headers:s,response:e,responseRaw:t,readyStateXHR:h,status:u,requestHeaders:l})}i._bUploading=false};if(r.xhr.readyState===0||r.bPosted){t++;i.sendFiles(e,t)}else{r.xhr.send(r.file);r.bPosted=true;t++;i.sendFiles(e,t)}};y.prototype.upload=function(e){var t,i;if(!this.getEnabled()){return}t=this.getDomRef("fu_form");try{this._bUploading=true;if(this.getSendXHR()&&window.File){var s=this.FUEl.files;if(e){this._sendProcessedFilesWithXHR(s)}else{this._sendFilesWithXHR(s)}}else if(t){i=t.getAttribute("action");if(i!==this.getUploadUrl()){this._submitAfterRendering=true}else{this._submitAndResetValue()}}}catch(e){h.error("File upload failed:\n"+e.message)}};y.prototype._submitAndResetValue=function(){var e=this.getDomRef("fu_form");e.submit();this.fireUploadStart();this._resetValueAfterUploadStart()};y.prototype.abort=function(e,t){if(!this.getUseMultipart()){var i=this._aXhr.length-1;for(var s=i;s>-1;s--){if(e&&t){for(var o=0;o<this._aXhr[s].requestHeaders.length;o++){var r=this._aXhr[s].requestHeaders[o].name;var a=this._aXhr[s].requestHeaders[o].value;if(r==e&&a==t){this._aXhr[s].xhr.abort();this.fireUploadAborted({fileName:this._aXhr[s].fileName,requestHeaders:this._aXhr[s].requestHeaders});this._aXhr.splice(s,1);h.info("File upload aborted.");break}}}else{this._aXhr[s].xhr.abort();this.fireUploadAborted({fileName:this._aXhr[s].fileName,requestHeaders:this._aXhr[s].requestHeaders});this._aXhr.splice(s,1);h.info("File upload aborted.")}}}else if(this._uploadXHR&&this._uploadXHR.abort){this._uploadXHR.abort();this.fireUploadAborted({fileName:null,requestHeaders:null});h.info("File upload aborted.")}};y.prototype.onclick=function(e){if(this.getSameFilenameAllowed()&&this.getEnabled()){this.setValue("",true)}if(this.oBrowse.getDomRef()&&(a.browser.safari||n(this.getDomRef(),document.activeElement))){this.oBrowse.focus()}if(e.target.getAttribute("type")==="file"){this.fireBeforeDialogOpen();document.body.onfocus=function(){this.fireAfterDialogClose();document.body.onfocus=null}.bind(this)}};y.prototype.onkeydown=function(e){if(!this.getEnabled()){return}if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){this.setValue("",true)}var t=e.keyCode;if(t===p.ENTER){if(this.oFileUpload){this.oFileUpload.click();e.preventDefault();e.stopPropagation()}}this.oBrowse._bPressedSpace=false};y.prototype.onkeyup=function(e){if(!this.getEnabled()){return}if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){this.setValue("",true)}var t=e.keyCode,i=p;if(t===i.DELETE||t===i.BACKSPACE){if(this.oFileUpload){this.setValue("",true)}}else if(t===i.SPACE){this.oFileUpload.click();e.preventDefault();e.stopPropagation()}else if(t!==i.TAB&&t!==i.SHIFT&&t!==i.F6&&t!==i.PAGE_UP&&t!==i.PAGE_DOWN&&t!==i.ESCAPE&&t!==i.END&&t!==i.HOME&&t!==i.ARROW_LEFT&&t!==i.ARROW_UP&&t!==i.ARROW_RIGHT&&t!==i.ARROW_DOWN){e.preventDefault();e.stopPropagation()}this.oBrowse._bPressedSpace=false};y.prototype._isFilenameTooLong=function(e){var t=this.getMaximumFilenameLength();if(t!==0&&e.length>t){h.info("The filename of "+e+" ("+e.length+" characters)  is longer than the maximum of "+t+" characters.");return true}return false};y.prototype.handlechange=function(e){if(this.oFileUpload&&this.getEnabled()){var t=this.getFileType();var i="";var s,o,r,l;var n=this.getDomRef("fu_form");if(window.File){var p=e.target.files;if(this._areFilesAllowed(p)){this.fireFileAllowed();i=this._generateInputValue(p)}else{n.reset();this.setValue("",true,true);return}}else if(t&&t.length>0){s=true;o=this.oFileUpload.value||"";r=o.lastIndexOf(".");l=r===-1?"":o.substring(r+1);for(var u=0;u<t.length;u++){if(l==t[u]){s=false}}if(s){h.info("File: "+o+" is of type "+l+". Allowed types are: "+t+".");this.fireTypeMissmatch({fileName:o,fileType:l});n.reset();this.setValue("",true,true);return}if(this._isFilenameTooLong(o)){this.fireFilenameLengthExceed({fileName:o});n.reset();this.setValue("",true,true);return}if(o){this.fireFileAllowed()}}var d=this.oFileUpload.value||"";var f=d.lastIndexOf("\\");if(f>=0){d=d.substring(f+1)}if(this.getMultiple()||this.getDirectory()){d=i}if(d||a.browser.chrome){this.setValue(d,true)}}};y.prototype._sendFilesWithXHR=function(e){var t,i,s,o,r=this.getXhrSettings();if(e.length>0){if(this.getUseMultipart()){t=1}else{t=e.length}this._aXhr=this._aXhr||[];for(var a=0;a<t;a++){this._uploadXHR=new window.XMLHttpRequest;o={xhr:this._uploadXHR,requestHeaders:[]};this._aXhr.push(o);o.xhr.open(this.getHttpRequestMethod(),this.getUploadUrl(),true);if(r){o.xhr.withCredentials=r.getWithCredentials()}if(this.getHeaderParameters()){var l=this.getHeaderParameters();for(var n=0;n<l.length;n++){i=l[n].getName();s=l[n].getValue();o.requestHeaders.push({name:i,value:s})}}var p=e[a].name;var h=o.requestHeaders;o.fileName=p;o.file=e[a];this.fireUploadStart({fileName:p,requestHeaders:h});for(var u=0;u<h.length;u++){if(o.xhr.readyState===0){break}i=h[u].name;s=h[u].value;o.xhr.setRequestHeader(i,s)}}if(this.getUseMultipart()){var d=new window.FormData;var f=this.FUEl.name;for(var g=0;g<e.length;g++){this._appendFileToFormData(d,f,e[g])}d.append("_charset_","UTF-8");var c=this.FUDataEl.name;if(this.getAdditionalData()){var y=this.getAdditionalData();d.append(c,y)}else{d.append(c,"")}if(this.getParameters()){var m=this.getParameters();for(var F=0;F<m.length;F++){var b=m[F].getName();s=m[F].getValue();d.append(b,s)}}o.file=d;this.sendFiles(this._aXhr,0)}else{this.sendFiles(this._aXhr,0)}this._bUploading=false;this._resetValueAfterUploadStart()}return this};y.prototype._appendFileToFormData=function(e,t,i){if(i instanceof window.Blob&&i.name){e.append(t,i,i.name)}else{e.append(t,i)}};y.prototype._sendProcessedFilesWithXHR=function(e){this.getProcessedBlobsFromArray(e).then(function(e){this._sendFilesWithXHR(e)}.bind(this)).catch(function(e){h.error("File upload failed: "+e&&e.message?e.message:"no details available")});return this};y.prototype._areFilesAllowed=function(e){var t,i,s,o,r,a=this.getMaximumFileSize(),l=this.getMimeType(),n=this.getFileType();for(var p=0;p<e.length;p++){t=e[p].name;r=e[p].type||"unknown";var u=e[p].size/1024/1024;if(a&&u>a){h.info("File: "+t+" is of size "+u+" MB which exceeds the file size limit of "+a+" MB.");this.fireFileSizeExceed({fileName:t,fileSize:u});return false}if(u===0){h.info("File: "+t+" is empty!");this.fireFileEmpty({fileName:t})}if(this._isFilenameTooLong(t)){this.fireFilenameLengthExceed({fileName:t});return false}if(l&&l.length>0){var d=true;for(var f=0;f<l.length;f++){if(r==l[f]||l[f]=="*/*"||r.match(l[f])){d=false}}if(d&&r!=="unknown"){h.info("File: "+t+" is of type "+r+". Allowed types are: "+l+".");this.fireTypeMissmatch({fileName:t,mimeType:r});return false}}if(n&&n.length>0){i=true;s=t.lastIndexOf(".");o=s===-1?"":t.substring(s+1);for(var g=0;g<n.length;g++){if(o.toLowerCase()==n[g].toLowerCase()){i=false}}if(i){h.info("File: "+t+" is of type "+o+". Allowed types are: "+n+".");this.fireTypeMissmatch({fileName:t,fileType:o});return false}}}return true};y.prototype._sendFilesFromDragAndDrop=function(e){if(this._areFilesAllowed(e)){this._sendFilesWithXHR(e)}return this};y.prototype._generateInputValue=function(e){var t="";for(var i=0;i<e.length;i++){t=t+'"'+e[i].name+'" '}return t};y.prototype.getBrowseText=function(){if(!y.prototype._sBrowseText){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");y.prototype._sBrowseText=e.getText("FILEUPLOAD_BROWSE")}return y.prototype._sBrowseText?y.prototype._sBrowseText:"Browse..."};y.prototype._getNoFileChosenText=function(){if(!y.prototype._sNoFileChosenText){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");y.prototype._sNoFileChosenText=e.getText("FILEUPLOAD_NO_FILE_CHOSEN")}return y.prototype._sNoFileChosenText?y.prototype._sNoFileChosenText:"No file chosen"};y.prototype.getShortenValue=function(){return this.getValue()};y.prototype.prepareFileUploadAndIFrame=function(){this._prepareFileUpload();if(!this.oIFrameRef){var e=document.createElement("iframe");e.style.display="none";e.id=this.getId()+"-frame";r.getDomRef().appendChild(e);e.contentWindow.name=this.getId()+"-frame";this._bUploading=false;jQuery(e).on("load",function(e){if(this._bUploading){h.info("File uploaded to "+this.getUploadUrl());var t;try{t=this.oIFrameRef.contentWindow.document.body.innerHTML}catch(e){}this.fireUploadComplete({response:t});this._bUploading=false}}.bind(this));this.oIFrameRef=e}};y.prototype._prepareFileUpload=function(){if(!this.oFileUpload){var e=[];e.push("<input ");e.push('type="file" ');e.push('aria-hidden="true" ');if(this.getName()){if(this.getMultiple()||this.getDirectory()){e.push('name="'+u(this.getName())+'[]" ')}else{e.push('name="'+u(this.getName())+'" ')}}else{if(this.getMultiple()||this.getDirectory()){e.push('name="'+this.getId()+'[]" ')}else{e.push('name="'+this.getId()+'" ')}}e.push('id="'+this.getId()+'-fu" ');e.push('tabindex="-1" ');e.push('size="1" ');if(this.getTooltip_AsString()){e.push('title="'+u(this.getTooltip_AsString())+'" ')}else{e.push('title="'+u(this.getValue()?this.getValue():this._getNoFileChosenText())+'" ')}if(!this.getEnabled()){e.push('disabled="disabled" ')}if(this.getDirectory()){e.push("webkitdirectory ")}if(this.getMultiple()){e.push("multiple ")}if((this.getMimeType()||this.getFileType())&&window.File){var t=this._getAcceptedTypes();e.push('accept="'+u(t)+'" ')}e.push(">");this.oFileUpload=jQuery(e.join("")).prependTo(this.$().find(".sapUiFupInputMask")).get(0)}else{jQuery(this.oFileUpload).prependTo(this.$().find(".sapUiFupInputMask"))}};y.prototype.openValueStateMessage=function(){if(this.oFilePath.openValueStateMessage){this.oFilePath.openValueStateMessage()}};y.prototype.closeValueStateMessage=function(){if(this.oFilePath.closeValueStateMessage){this.oFilePath.closeValueStateMessage()}};y.prototype._getAcceptedTypes=function(){var e=this.getMimeType()||[],t=this.getFileType()||[];t=t.map(function(e){return e.indexOf(".")===0?e:"."+e});return t.concat(e).join(",")};y.prototype._resetValueAfterUploadStart=function(){h.info("File uploading to "+this.getUploadUrl());if(this.getSameFilenameAllowed()&&this.getUploadOnChange()&&this.getUseMultipart()){this.setValue("",true)}};y.prototype._addLabelFeaturesToBrowse=function(){var e;if(this.oBrowse&&this.oBrowse.$().length){e=this.oBrowse.$();e.attr("type', 'button");e.off("click").on("click",e=>{e.preventDefault();e.stopPropagation();this.FUEl.click()});e.off("dragover").on("dragover",e=>{e.preventDefault();e.stopPropagation()});e.off("dragenter").on("dragenter",e=>{e.preventDefault();e.stopPropagation()});e.off("drop").on("drop",e=>{e.preventDefault();e.stopPropagation();var t=e.originalEvent.dataTransfer.files;if(!this.getMultiple()&&t.length>1||this.getDirectory()){return}this.oFileUpload.files=t;var i={target:{files:t}};this.handlechange(i)})}};y.prototype.getProcessedBlobsFromArray=function(e){return new Promise(function(t){t(e)})};y.prototype.checkFileReadable=function(){return new Promise(function(e,t){var i;if(window.File&&this.FUEl&&this.FUEl.files.length){var i=new FileReader;i.readAsArrayBuffer(this.FUEl.files[0].slice(0,1));i.onload=function(){e()};i.onerror=function(){t(i.error)}}else{e()}}.bind(this))};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/FileUploaderHelper", ["sap/ui/core/Lib"],function(t){"use strict";var e={createTextField:function(t){var e=new sap.m.Input(t);return e},setTextFieldContent:function(t,e){t.setWidth(e)},createButton:function(t){var e=new sap.m.Button(t);return e},addFormClass:function(){return"sapUiFUM"}};var n={createTextField:function(t){var e=new sap.ui.commons.TextField(t);return e},setTextFieldContent:function(t,e){t.setWidth(e)},createButton:function(t){var e=new sap.ui.commons.Button(t);return e},addFormClass:function(){return"sapUiCFUM"}};var r={createTextField:function(t){throw new Error("no TextField control available!")},createTextFieldContent:function(t,e){throw new Error("no TextField control available!")},createButton:function(t){throw new Error("no Button control available!")},addFormClass:function(){return null}};var o={getHelper:function(){if(t.isLoaded("sap.m")){return e}else if(t.isLoaded("sap.ui.unified")){return n}return r}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/FileUploaderHttpRequestMethod", [],function(){"use strict";var t={Post:"POST",Put:"PUT"};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/FileUploaderParameter", ["sap/ui/core/Element","./library"],function(e,a){"use strict";var r=e.extend("sap.ui.unified.FileUploaderParameter",{metadata:{library:"sap.ui.unified",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/FileUploaderRenderer", ["sap/ui/unified/library","sap/ui/thirdparty/jquery","./FileUploaderHelper"],function(t,jQuery,e){"use strict";var a={};a.apiVersion=2;a.render=function(t,a){var r=a.getEnabled();var n=e.getHelper();t.openStart("div",a);t.class("sapUiFup");if(a.getButtonOnly()){t.class("sapUiFupButtonOnly")}var i=n.addFormClass();if(i){t.class(i)}if(!r){t.class("sapUiFupDisabled")}t.openEnd();t.openStart("form",a.getId()+"-fu_form");t.style("display","inline-block");t.attr("enctype","multipart/form-data");t.attr("method",a.getHttpRequestMethod().toLowerCase());t.attr("action",a.getUploadUrl());t.attr("target",a.getId()+"-frame");t.openEnd();t.openStart("div");if(!a.bMobileLib){t.class("sapUiFupInp")}t.openEnd();t.openStart("div");t.class("sapUiFupGroup");t.style("border","0");t.style("cellPadding","0");t.style("cellSpacing","0");t.openEnd();t.openStart("div");t.openEnd();t.openStart("div");if(a.getButtonOnly()){t.style("display","none")}t.openEnd();t.renderControl(a.oFilePath);t.close("div");t.openStart("div");t.openEnd();a._ensureBackwardsReference();t.renderControl(a.oBrowse);t.openStart("span",a.getId()+"-AccDescr");t.class("sapUiInvisibleText");t.attr("aria-hidden","true");t.openEnd();t.text(a._generateAccDescriptionText());t.close("span");t.close("div");t.close("div");t.close("div");var d=a.getName()||a.getId();t.openStart("div");t.class("sapUiFupInputMask");t.openEnd();t.voidStart("input");t.attr("type","hidden");t.attr("name","_charset_");t.attr("aria-hidden","true");t.voidEnd();t.voidStart("input",a.getId()+"-fu_data");t.attr("type","hidden");t.attr("aria-hidden","true");t.attr("name",d+"-data");t.attr("value",a.getAdditionalData()||"");t.voidEnd();jQuery.each(a.getParameters(),function(e,a){t.voidStart("input");t.attr("type","hidden");t.attr("aria-hidden","true");t.attr("name",a.getName()||"");t.attr("value",a.getValue()||"");t.voidEnd()});t.close("div");t.close("div");t.close("form");t.close("div")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/FileUploaderXHRSettings", ["sap/ui/core/Element","./library"],function(e){"use strict";var a=e.extend("sap.ui.unified.FileUploaderXHRSettings",{metadata:{library:"sap.ui.unified",properties:{withCredentials:{type:"boolean",group:"Data",defaultValue:false}}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/Menu", ["sap/ui/core/Element","sap/ui/core/Control","sap/ui/Device","sap/ui/core/Popup","./MenuItemBase","./library","sap/ui/core/library","sap/ui/unified/MenuRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/ControlEvents","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave","sap/ui/core/Configuration"],function(e,t,i,n,o,s,r,u,a,jQuery,p,h,f,l,d,g){"use strict";var c=n.Dock;var m=r.OpenState;var y=t.extend("sap.ui.unified.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},ariaDescription:{type:"string",group:"Accessibility",defaultValue:null,deprecated:true},maxVisibleItems:{type:"int",group:"Behavior",defaultValue:0},pageSize:{type:"int",group:"Behavior",defaultValue:5}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItemBase",multiple:true,singularName:"item"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{itemSelect:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}},renderer:u});(function(s){y.prototype.bCozySupported=true;y._DELAY_SUBMENU_TIMER=300;y._DELAY_SUBMENU_TIMER_EXT=400;y.prototype.init=function(){var e=this;this.bOpen=false;this.oOpenedSubMenu=null;this.oHoveredItem=null;this.oPopup=null;this._bOpenedAsContextMenu=false;this.fAnyEventHandlerProxy=jQuery.proxy(function(e){var t=this.getRootMenu();if(t!=this||!this.isOpen()||!this.getDomRef()||e.type!="mousedown"&&e.type!="touchstart"){return}t.handleOuterEvent(this.getId(),e)},this);this.fOrientationChangeHandler=function(){e.close()};this.bUseTopStyle=false};y.prototype._setCustomEnhanceAccStateFunction=function(e){this._fnCustomEnhanceAccStateFunction=e};y.prototype.enhanceAccessibilityState=function(e,t){var i=typeof this._fnCustomEnhanceAccStateFunction==="function";if(i){this._fnCustomEnhanceAccStateFunction(e,t)}};y.prototype.exit=function(){if(this.oPopup){this.oPopup.detachClosed(this._menuClosed,this);this.oPopup.destroy();delete this.oPopup}f.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){jQuery(s).off("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false}this._resetDelayedRerenderItems();this._detachResizeHandler()};y.prototype.invalidate=function(e){if(e instanceof o&&this.getDomRef()){this._delayedRerenderItems()}else if(this.oPopup&&this.oPopup.isOpen()){t.prototype.invalidate.apply(this,arguments)}};y.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems();this.$().off("mousemove")};y.prototype.onAfterRendering=function(){if(this.$().parent().attr("id")!="sap-ui-static"){h.error("sap.ui.unified.Menu: The Menu is popup based and must not be rendered directly as content of the page.");this.close();this.$().remove()}var e=this.getItems();for(var t=0;t<e.length;t++){if(e[t].onAfterRendering&&e[t].getDomRef()){e[t].onAfterRendering()}}if(this.oHoveredItem){this.oHoveredItem.hover(true,this)}b(this);this.$().on("mousemove",this._focusMenuItem.bind(this))};y.prototype._focusMenuItem=function(e){if(!i.system.desktop){return}var t=this.getItemByDomRef(e.target);if(!this.isOpen()||!t){return}if(this.oOpenedSubMenu&&a(this.oOpenedSubMenu.getDomRef(),e.target)){return}this.setHoveredItem(t);t&&t.focus(this);this._openSubMenuDelayed(t)};y.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getPopup().getOpenState()===m.OPEN){b(this);this.getPopup()._applyPosition(this.getPopup()._oLastPosition)}};y.prototype.addItem=function(e){this.addAggregation("items",e,!!this.getDomRef());this._delayedRerenderItems();return this};y.prototype.insertItem=function(e,t){this.insertAggregation("items",e,t,!!this.getDomRef());this._delayedRerenderItems();return this};y.prototype.removeItem=function(e){this.removeAggregation("items",e,!!this.getDomRef());this._delayedRerenderItems();return this};y.prototype.removeAllItems=function(){var e=this.removeAllAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return e};y.prototype.destroyItems=function(){this.destroyAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return this};y.prototype._delayedRerenderItems=function(){if(!this.getDomRef()){return}this._resetDelayedRerenderItems();this._discardOpenSubMenuDelayed();this._itemRerenderTimer=setTimeout(function(){var e=this.getDomRef();if(e){var t=sap.ui.getCore().createRenderManager();u.renderItems(t,this);t.flush(e);t.destroy();this.onAfterRendering();this.getPopup()._applyPosition(this.getPopup()._oLastPosition)}}.bind(this),0)};y.prototype._resetDelayedRerenderItems=function(){if(this._itemRerenderTimer){clearTimeout(this._itemRerenderTimer);delete this._itemRerenderTimer}};y.prototype._detachResizeHandler=function(){if(this._hasResizeListener){i.resize.detachHandler(this._handleResizeChange,this);this._hasResizeListener=false}};y.prototype.open=function(e,t,n,o,r,u,a){var p;this._bLeavingMenu=false;if(this.isOpen()){return}v(this,true);this.oOpenerRef=t;this.bIgnoreOpenerDOMRef=false;this.getPopup().open(0,n,o,r,u||"0 0",a||"flipfit flipfit",function(e){var t=this.getPopup()._getOfDom(r);if(!t||!jQuery(t).is(":visible")||!I(t)){this.close()}else{this.getPopup()._applyPosition(e.lastPosition)}}.bind(this));this.bOpen=this.getPopup().isOpen();i.resize.attachHandler(this._handleResizeChange,this);this._hasResizeListener=true;if(e||this.getRootMenu().getId()===this.getId()){p=this.getNextSelectableItem(-1);this.setHoveredItem(p);p&&p.focus(this)}f.bindAnyEvent(this.fAnyEventHandlerProxy);if(i.support.orientation&&this.getRootMenu()===this){jQuery(s).on("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=true}};y.prototype._handleResizeChange=function(){this.getPopup()._applyPosition(this.getPopup()._oLastPosition)};y.prototype.openAsContextMenu=function(t,i){var n,o,s,r,u;i=i instanceof e?i.getDomRef():i;if(t instanceof jQuery.Event){u=jQuery(i).offset();n=t.pageX-u.left;o=t.pageY-u.top;this._iX=t.clientX;this._iY=t.clientY}else{n=t.offsetX||0;o=t.offsetY||0;this._iX=t.left||0;this._iY=t.top||0}s=g.getRTL();r=c;if(s){n=i.clientWidth-n}this._bOpenedAsContextMenu=true;this.open(true,i,r.BeginTop,r.BeginTop,i,n+" "+o,"fit")};y.prototype._handleOpened=function(){var e,t,i,n,o,r,u,a,p,h;if(!this._bOpenedAsContextMenu){return}e=this.$();t=jQuery(s);i=this._iX;n=this._iY;o=t.scrollLeft()+t.width();r=t.scrollTop()+t.height();u=g.getRTL();a=false;p=e.width();h=e.height();if(n+h>r){n=n-h;a=true}if(u){if(o-i+p>o){i=o-(i+p);a=true}else{i=o-i;a=true}}else{if(i+p>o){i=i-p;a=true}}this._bOpenedAsContextMenu=false;a&&this.oPopup.setPosition("begin top","begin top",t,i+" "+n,"flipfit")};y.prototype.close=function(e){if(!this.isOpen()||y._dbg){return}this._discardOpenSubMenuDelayed();v(this,false);delete this._bFixed;f.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){jQuery(s).off("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false}this.closeSubmenu();this.setHoveredItem();if(!e){this.bIgnoreOpenerDOMRef=true}this.getPopup().close(0);this.bOpen=this.getPopup().isOpen();this._detachResizeHandler();this._resetDelayedRerenderItems();this.$().remove();this.bOutput=false;if(this.isSubMenu()){this.getParent().getParent().oOpenedSubMenu=null}};y.prototype.isOpen=function(){return this.getPopup().isOpen()};y.prototype._menuClosed=function(){if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef){try{this.oOpenerRef.focus()}catch(e){h.warning("Menu.close cannot restore the focus on opener "+this.oOpenerRef+", "+e)}}this.oOpenerRef=undefined}};y.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),false,!!(e.metaKey||e.ctrlKey));e.preventDefault();e.stopPropagation()};y.prototype.onsapnext=function(e){var t,i,n=this.oHoveredItem?this.oHoveredItem.getSubmenu():undefined;if(e.keyCode!==p.ARROW_DOWN&&!e.metaKey&&!e.altKey){if(n){if(n.isOpen()){i=n.getNextSelectableItem(-1);n.setHoveredItem(i);i&&i.focus(this)}else{this.openSubmenu(this.oHoveredItem,true)}}return}if(n&&n.isOpen()){this.closeSubmenu(false,true)}t=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;i=this.getNextSelectableItem(t);this.setHoveredItem(i);i&&i.focus(this);if(!e.metaKey&&!e.altKey){e.preventDefault();e.stopPropagation()}};y.prototype.onsapnextmodifiers=y.prototype.onsapnext;y.prototype.onsapprevious=function(e){var t=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,i=this.getPreviousSelectableItem(t),n=this.oHoveredItem?this.oHoveredItem.getSubmenu():null;if(e.keyCode!==p.ARROW_UP&&!e.metaKey&&!e.altKey){if(this.isSubMenu()){this.close(true)}e.preventDefault();e.stopPropagation();return}if(n&&n.isOpen()){this.closeSubmenu(false,true)}this.setHoveredItem(i);i&&i.focus(this);if(!e.metaKey&&!e.altKey){e.preventDefault();e.stopPropagation()}};y.prototype.onsappreviousmodifiers=y.prototype.onsapprevious;y.prototype.onsaphome=function(e){var t=this.getNextSelectableItem(-1);this.setHoveredItem(t);t&&t.focus(this);e.preventDefault();e.stopPropagation()};y.prototype.onsapend=function(e){var t=this.getPreviousSelectableItem(this.getItems().length);this.setHoveredItem(t);t&&t.focus(this);e.preventDefault();e.stopPropagation()};y.prototype.onsappagedown=function(e){var t=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,i;if(this.getPageSize()<1){this.onsapend(e);return}t+=this.getPageSize();if(t>=this.getItems().length){this.onsapend(e);return}i=this.getNextSelectableItem(t-1);this.setHoveredItem(i);i&&i.focus(this);e.preventDefault();e.stopPropagation()};y.prototype.onsappageup=function(e){var t=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,i;if(this.getPageSize()<1){this.onsaphome(e);return}t-=this.getPageSize();if(t<0){this.onsaphome(e);return}i=this.getPreviousSelectableItem(t+1);this.setHoveredItem(i);i&&i.focus(this);e.preventDefault();e.stopPropagation()};y.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=true;e.preventDefault();e.stopPropagation()};y.prototype.onkeyup=function(e){if(this.oHoveredItem&&jQuery(e.target).prop("tagName")!="INPUT"){var t=this.oHoveredItem.getDomRef();jQuery(t).trigger("focus")}if(!this._sapSelectOnKeyDown&&(e.key!==p.Space||!i.os.macintosh&&s.navigator.maxTouchPoints<=1)){return}else{this._sapSelectOnKeyDown=false}if(!l.events.sapselect.fnCheck(e)&&e.key!=="Enter"){return}this.selectItem(this.oHoveredItem,true,false);e.preventDefault();e.stopPropagation()};y.prototype.onsapbackspace=function(e){if(jQuery(e.target).prop("tagName")!="INPUT"){e.preventDefault()}};y.prototype.onsapbackspacemodifiers=y.prototype.onsapbackspace;y.prototype.onsapescape=function(e){this._bLeavingMenu=true;this.close(true);e.preventDefault();e.stopPropagation()};y.prototype.onsaptabnext=function(e){if(this.isSubMenu()){e.preventDefault()}this._bLeavingMenu=true;this.close(true);e.stopPropagation()};y.prototype.onsaptabprevious=y.prototype.onsaptabnext;y.prototype._openSubMenuDelayed=function(e){if(!e){return}this._discardOpenSubMenuDelayed();this._delayedSubMenuTimer=setTimeout(function(){if(e.getSubmenu()){this.setHoveredItem(e);e&&e.focus(this);this.openSubmenu(e,false,true)}}.bind(this),e.getSubmenu()?y._DELAY_SUBMENU_TIMER:y._DELAY_SUBMENU_TIMER_EXT)};y.prototype._discardOpenSubMenuDelayed=function(e){if(this._delayedSubMenuTimer){clearTimeout(this._delayedSubMenuTimer);this._delayedSubMenuTimer=null}};y.prototype.onmouseout=function(e){if(!i.system.desktop){return}if(d(e,this.getDomRef())){this.setHoveredItem(null);if(!this.oOpenedSubMenu||!(this.oOpenedSubMenu.getParent()===this.oHoveredItem)){this.setHoveredItem(this.oHoveredItem)}this._discardOpenSubMenuDelayed()}};y.prototype.onsapfocusleave=function(e){if(this.oOpenedSubMenu||!this.isOpen()){return}this.getRootMenu().handleOuterEvent(this.getId(),e)};y.prototype.handleOuterEvent=function(e,t){var n=false,o=i.support.touch||i.system.combi;this.bIgnoreOpenerDOMRef=false;if(t.type=="mousedown"||t.type=="touchstart"){if(o&&(t.isMarked("delayedMouseEvent")||t.isMarked("cancelAutoClose"))){return}var s=this;while(s&&!n){if(a(s.getDomRef(),t.target)){n=true}s=s.oOpenedSubMenu}}else if(t.type=="sapfocusleave"){if(o){return}if(t.relatedControlId){var s=this;while(s&&!n){if(s.oOpenedSubMenu&&s.oOpenedSubMenu.getId()==t.relatedControlId||a(s.getDomRef(),jQuery(document.getElementById(t.relatedControlId)).get(0))){n=true}s=s.oOpenedSubMenu}}if(!n){this.bIgnoreOpenerDOMRef=true}}if(!n){this.close()}};y.prototype.getItemByDomRef=function(e){var t=this.getItems(),i=t.length;for(var n=0;n<i;n++){var o=t[n],s=o.getDomRef();if(a(s,e)){return o}}return null};y.prototype.selectItem=function(e,t,n){if(!e||!(e instanceof o&&this.checkEnabled(e))){return}var s=e.getSubmenu();if(!s){this.getRootMenu().close(true)}else{if(!i.system.desktop&&this.oOpenedSubMenu===s){this.closeSubmenu()}else{this.openSubmenu(e,t)}}e.fireSelect({item:e,ctrlKey:n});this.getRootMenu().fireItemSelect({item:e})};y.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof y};y.prototype.getRootMenu=function(){var e=this;while(e.isSubMenu()){e=e.getParent().getParent()}return e};y.prototype.getMenuLevel=function(){var e=1;var t=this;while(t.isSubMenu()){t=t.getParent().getParent();e++}return e};y.prototype.getPopup=function(){if(!this.oPopup){this.oPopup=new n(this,false,true,false);this.oPopup.setDurations(0,0);this.oPopup.attachClosed(this._menuClosed,this);this.oPopup.attachOpened(this._handleOpened,this)}return this.oPopup};y.prototype.setHoveredItem=function(e){if(this.oHoveredItem){this.oHoveredItem.hover(false,this)}if(!e){this.oHoveredItem=null;return}this.oHoveredItem=e;e.hover(true,this);this.scrollToItem(this.oHoveredItem)};y.prototype.openSubmenu=function(e,t,i){var o=e.getSubmenu();if(!o){return}if(!this.checkEnabled(e)){return}if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==o){this.closeSubmenu()}if(this.oOpenedSubMenu){this.oOpenedSubMenu._bFixed=i&&this.oOpenedSubMenu._bFixed||!i&&!this.oOpenedSubMenu._bFixed;this.oOpenedSubMenu._bringToFront()}else{this.oOpenedSubMenu=o;var s=n.Dock;o.open(t,e,s.BeginTop,s.EndTop,e,"-4 4")}};y.prototype.closeSubmenu=function(e,t){if(this.oOpenedSubMenu){if(e&&this.oOpenedSubMenu._bFixed){return}if(t){this.oOpenedSubMenu.bIgnoreOpenerDOMRef=true}this.oOpenedSubMenu.close();this.oOpenedSubMenu=null}};y.prototype.scrollToItem=function(e){var t=this.getDomRef(),i=e?e.getDomRef():null;if(!i||!t){return}var n=t.scrollTop,o=i.offsetTop,s=jQuery(t).height(),r=jQuery(i).height();if(n>o){t.scrollTop=o}else if(o+r>n+s){t.scrollTop=Math.ceil(o+r-s)}};y.prototype._bringToFront=function(){jQuery(document.getElementById(this.getPopup().getId())).mousedown()};y.prototype.checkEnabled=function(e){return e&&e.getEnabled()&&this.getEnabled()};y.prototype.getNextSelectableItem=function(e){var t=this.getItems();var i=t[e];for(var n=e+1;n<t.length;n++){if(t[n].getVisible()){return t[n]}}return i&&i.getVisible()?i:null};y.prototype.getPreviousSelectableItem=function(e){var t=this.getItems();var i=t[e];for(var n=e-1;n>=0;n--){if(t[n].getVisible()){return t[n]}}return i&&i.getVisible()?i:null};y.prototype.setRootMenuTopStyle=function(e){this.getRootMenu().bUseTopStyle=e;y.rerenderMenu(this.getRootMenu())};y.rerenderMenu=function(e){var t=e.getItems();for(var i=0;i<t.length;i++){var n=t[i].getSubmenu();if(n){y.rerenderMenu(n)}}e.invalidate();e.rerender()};y.prototype.focus=function(){if(this.isOpen()){t.prototype.focus.apply(this,arguments)}};y.prototype.isCozy=function(){if(!this.bCozySupported){return false}if(this.hasStyleClass("sapUiSizeCozy")){return true}if(r(this.oOpenerRef)){return true}if(r(this.getParent())){return true}return false};function r(e){if(!e){return false}e=e.$?e.$():jQuery(e);return e.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy").hasClass("sapUiSizeCozy")}function v(e,t){var i=e.getParent();if(i&&i instanceof o){i.onSubmenuToggle(t)}}function b(e){var t=e.getMaxVisibleItems(),i=document.documentElement.clientHeight-10,n=e.$();if(t>0){var o=e.getItems();for(var s=0;s<o.length;s++){if(o[s].getDomRef()){i=Math.min(i,o[s].$().outerHeight(true)*t);break}}}if(n.outerHeight(true)>i){n.css("max-height",i+"px").toggleClass("sapUiMnuScroll",true)}else{n.css("max-height","").toggleClass("sapUiMnuScroll",false)}}function I(e){var t;if(!e){return false}if(e instanceof jQuery){e=e.get(0)}t=e.getBoundingClientRect();return t.top>=0&&t.left>=0&&t.bottom<=(s.innerHeight||document.documentElement.clientHeight)&&t.right<=(s.innerWidth||document.documentElement.clientWidth)}})(window);return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/MenuItem", ["sap/ui/core/IconPool","./MenuItemBase","./library","sap/ui/core/library"],function(e,t,i,s){"use strict";var a=t.extend("sap.ui.unified.MenuItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Appearance",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});e.insertFontFaceStyle();a.prototype.render=function(e,t,i,a){var n=e,o=t.getSubmenu(),p=t.getEnabled(),r;n.openStart("li",t);if(t.getVisible()){n.attr("tabindex","0")}n.class("sapUiMnuItm");if(a.iItemNo==1){n.class("sapUiMnuItmFirst")}else if(a.iItemNo==a.iTotalItems){n.class("sapUiMnuItmLast")}if(!i.checkEnabled(t)){n.class("sapUiMnuItmDsbl")}if(t.getStartsSection()){n.class("sapUiMnuItmSepBefore")}if(t.getTooltip_AsString()){n.attr("title",t.getTooltip_AsString())}if(a.bAccessible){n.accessibilityState(t,{role:"menuitem",disabled:!p,posinset:a.iItemNo,setsize:a.iTotalItems,labelledby:{value:this.getId()+"-txt",append:true}});if(o){n.attr("aria-haspopup",s.aria.HasPopup.Menu.toLowerCase());n.attr("aria-owns",o.getId())}}n.openEnd();n.openStart("div");n.class("sapUiMnuItmL");n.openEnd();n.close("div");if(t.getIcon()&&t._getIcon){n.openStart("div");n.class("sapUiMnuItmIco");n.openEnd();r=t._getIcon(t);n.renderControl(r);n.close("div")}n.openStart("div",this.getId()+"-txt");n.class("sapUiMnuItmTxt");n.openEnd();n.text(t.getText());n.close("div");n.openStart("div",this.getId()+"-scuttxt");n.class("sapUiMnuItmSCut");n.openEnd();n.close("div");n.openStart("div");n.class("sapUiMnuItmSbMnu");n.openEnd();if(o){n.openStart("div");n.class("sapUiIconMirrorInRTL");n.openEnd();n.close("div")}n.close("div");n.openStart("div");n.class("sapUiMnuItmR");n.openEnd();n.close("div");n.close("li")};a.prototype.hover=function(e,t){this.$().toggleClass("sapUiMnuItmHov",e)};a.prototype.focus=function(e){if(this.getVisible()){this.$().trigger("focus")}else{e.focus()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/MenuItemBase", ["sap/ui/core/Element","./library","sap/ui/core/IconPool"],function(e,t,o){"use strict";var n=e.extend("sap.ui.unified.MenuItemBase",{metadata:{library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"submenu",aggregations:{submenu:{type:"sap.ui.unified.Menu",multiple:false}},events:{select:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});n.prototype.init=function(){};n.prototype.render=function(e,t,o){var n=e;n.openStart("li",t);n.openEnd();n.openStart("div",this.getId()+"-txt");n.style("white-space","nowrap");n.style("display","inline-block");n.style("padding","1px");n.style("color","black");n.openEnd();n.text(t.getId());if(this.getSubmenu()){n.text("&nbsp;&nbsp;->")}n.close("div");n.close("li")};n.prototype.hover=function(e,t){this.$("txt").attr("style",e?"white-space:nowrap;display:inline-block;padding:1px;color:red;":"white-space:nowrap;display:inline-block;padding:1px;color:black;")};n.prototype.focus=function(){};n.prototype.onSubmenuToggle=function(e){this.$().toggleClass("sapUiMnuItmSubMnuOpen",e)};n.prototype.onAfterRendering=function(){};n.prototype.onsapshow=function(e){if(this.getParent()&&this.getParent().close){this.getParent().close(true)}e.preventDefault()};n.prototype._getIcon=function(e){return o.createControlByURI({src:e.getIcon(),useIconTooltip:false})};n.prototype.onsaphide=n.prototype.onsapshow;return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/MenuRenderer", ["sap/ui/core/Configuration"],function(e){"use strict";var i={apiVersion:2};i.render=function(t,s){var n=e.getAccessibility(),o=s.getRootMenu();if(s.oHoveredItem&&s.indexOfItem(s.oHoveredItem)<0){s.oHoveredItem=null}t.openStart("div",s);t.attr("tabindex",-1);t.attr("hideFocus",true);if(s.getTooltip_AsString()){t.attr("title",s.getTooltip_AsString())}if(n){t.accessibilityState(s,{disabled:null})}t.class("sapUiMnu");if(s.isSubMenu()){t.class("sapUiSubmenu")}if(o.bUseTopStyle){t.class("sapUiMnuTop")}if(o.isCozy()){t.class("sapUiSizeCozy")}if(s.bCozySupported){t.class("sapUiMnuCozySupport")}t.openEnd();i.renderItems(t,s);t.close("div")};i.renderItems=function(i,t){var s=t.getItems(),n=e.getAccessibility(),o=false,r=false,a=0,l=0,u,c;i.openStart("ul");i.attr("role","menu");i.class("sapUiMnuLst");for(u=0;u<s.length;u++){if(s[u].getIcon&&s[u].getIcon()){o=true}if(s[u].getSubmenu()){r=true}}if(!o){i.class("sapUiMnuNoIco")}if(!r){i.class("sapUiMnuNoSbMnu")}i.openEnd();a=0;for(u=0;u<s.length;u++){if(s[u].getVisible()&&s[u].render){a++}}for(u=0;u<s.length;u++){c=s[u];if(c.getVisible()&&c.render){l++;if(c.getStartsSection()){i.openStart("li");if(n){i.attr("role","separator")}i.class("sapUiMnuDiv");i.openEnd();i.openStart("div");i.class("sapUiMnuDivL");i.openEnd();i.close("div");i.voidStart("hr").voidEnd();i.openStart("div");i.class("sapUiMnuDivR");i.openEnd();i.close("div");i.close("li")}c.render(i,c,t,{bAccessible:n,iItemNo:l,iTotalItems:a})}}i.close("ul")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/MenuTextFieldItem", ["sap/ui/core/ValueStateSupport","./MenuItemBase","./library","sap/ui/core/library","sap/ui/Device","sap/base/Log","sap/ui/events/PseudoEvents","sap/ui/core/InvisibleText","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/core/IconPool","sap/ui/dom/jquery/cursorPos"],function(t,e,i,s,o,a,n,r,p,u){"use strict";var l=s.ValueState;var c=e.extend("sap.ui.unified.MenuTextFieldItem",{metadata:{library:"sap.ui.unified",properties:{label:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:l.None}}}});c.prototype.render=function(t,e,i,s){var o=t,a=i.checkEnabled(e),n=e.getId(),r;o.openStart("li",e);if(e.getVisible()){o.attr("tabindex","0")}o.class("sapUiMnuItm").class("sapUiMnuTfItm");if(s.iItemNo==1){o.class("sapUiMnuItmFirst")}else if(s.iItemNo==s.iTotalItems){o.class("sapUiMnuItmLast")}if(!i.checkEnabled(e)){o.class("sapUiMnuItmDsbl")}if(e.getStartsSection()){o.class("sapUiMnuItmSepBefore")}if(s.bAccessible){o.attr("role","menuitem");o.attr("aria-posinset",s.iItemNo);o.attr("aria-setsize",s.iTotalItems);o.attr("aria-disabled",!a)}o.openEnd();o.openStart("div").class("sapUiMnuItmL").openEnd().close("div");if(e.getIcon()){o.openStart("div").class("sapUiMnuItmIco").openEnd();r=e._getIcon(e);o.renderControl(r);o.close("div")}o.openStart("div",n+"-txt").class("sapUiMnuItmTxt").openEnd();o.openStart("label",n+"-lbl").class("sapUiMnuTfItemLbl").openEnd();o.text(e.getLabel());o.close("label");o.openStart("div",n+"-str").class("sapUiMnuTfItmStretch").openEnd().close("div");o.openStart("div").class("sapUiMnuTfItemWrppr").openEnd();o.voidStart("input",n+"-tf").attr("tabindex","-1");o.attr("role","textbox");if(e.getValue()){o.attr("value",e.getValue())}o.class("sapUiMnuTfItemTf").class(a?"sapUiMnuTfItemTfEnbl":"sapUiMnuTfItemTfDsbl");if(!a){o.attr("disabled","disabled")}if(s.bAccessible){o.accessibilityState(e,{disabled:null,describedby:e._fnInvisibleDescriptionFactory(s).getId(),labelledby:n+"-lbl"})}o.voidEnd().close("div").close("div");o.openStart("div").class("sapUiMnuItmR").openEnd().close("div");o.close("li")};c.prototype.exit=function(){if(this._invisibleDescription){this._fnInvisibleDescriptionFactory().destroy();this._invisibleDescription=null}};c.prototype.hover=function(t,e){this.$().toggleClass("sapUiMnuItmHov",t);if(t){e.closeSubmenu(false,true)}};c.prototype.focus=function(t){if(this.getVisible()&&this.getEnabled()){this.$("tf").get(0).focus()}else{this.$().trigger("focus")}};c.prototype.onAfterRendering=function(){this._adaptSizes();this.setValueState(this.getValueState())};c.prototype.onsapup=function(t){this.getParent().onsapprevious(t)};c.prototype.onsapdown=function(t){this.getParent().onsapnext(t)};c.prototype.onsaphome=function(t){if(this._checkCursorPosForNav(false)){this.getParent().onsaphome(t)}};c.prototype.onsapend=function(t){if(this._checkCursorPosForNav(true)){this.getParent().onsapend(t)}};c.prototype.onsappageup=function(t){this.getParent().onsappageup(t)};c.prototype.onsappagedown=function(t){this.getParent().onsappagedown(t)};c.prototype.onsapescape=function(t){this.getParent().onsapescape(t)};c.prototype.onkeydown=function(t){t.stopPropagation()};c.prototype.onclick=function(t){this.getParent().closeSubmenu(false,true);if(!o.system.desktop){this.focus()}t.stopPropagation()};c.prototype.onkeyup=function(t){if(!n.events.sapenter.fnCheck(t)&&t.key!=="Enter"){return}var e=this.$("tf").val();this.setValue(e);this.getParent().selectItem(this);t.preventDefault();t.stopPropagation()};c.prototype.setSubmenu=function(t){a.warning("The aggregation 'submenu' is not supported for this type of menu item.","","sap.ui.unified.MenuTextFieldItem");return this};c.prototype.setLabel=function(t){this.setProperty("label",t,true);this.$("lbl").text(t);this._adaptSizes();return this};c.prototype.setValue=function(t){this.setProperty("value",t,true);this.$("tf").val(t);return this};c.prototype.setValueState=function(e){this.setProperty("valueState",e,true);var i=this.$("tf");i.toggleClass("sapUiMnuTfItemTfErr",e==l.Error);i.toggleClass("sapUiMnuTfItemTfWarn",e==l.Warning);var s=t.enrichTooltip(this,this.getTooltip_AsString());if(s){this.$().attr("title",s)}return this};c.prototype.getFocusDomRef=function(){var t=this.$("tf");return t.length?t.get(0):null};c.prototype._adaptSizes=function(){var t=this.$("tf");var e=this.$("lbl");var i=e.length?e.get(0).offsetLeft:0;if(p.getConfiguration().getRTL()){t.parent().css({width:"auto",right:this.$().outerWidth(true)-i+(e.outerWidth(true)-e.outerWidth())+"px"})}else{t.parent().css({width:"auto",left:i+e.outerWidth(true)+"px"})}};c.prototype._checkCursorPosForNav=function(t){var e=u.getRTL();var i=t?e:!e;var s=this.$("tf");var o=s.cursorPos();var a=s.val().length;if(e){o=a-o}if(!i&&o!=a||i&&o!=0){return false}return true};c.prototype._fnInvisibleDescriptionFactory=function(t){var e,i,s;if(!this._invisibleDescription){s=p.getLibraryResourceBundle("sap.ui.unified");e=s.getText("UNIFIED_MENU_ITEM_COUNT_TEXT",[t.iItemNo,t.iTotalItems]);i=s.getText("UNIFIED_MENU_ITEM_HINT_TEXT");this._invisibleDescription=new r({text:e+" "+i}).toStatic()}return this._invisibleDescription};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/Shell", ["./ShellHeader","./ShellLayout","./library","./ShellRenderer"],function(e,t,r,a){"use strict";var i=t.extend("sap.ui.unified.Shell",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},showCurtain:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},showCurtainPane:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},searchVisible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{curtainContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainContent"},curtainPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainPaneContent"},headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headItem",forwarding:{idSuffix:"-header",aggregation:"headItems"}},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headEndItem",forwarding:{idSuffix:"-header",aggregation:"headEndItems"}},search:{type:"sap.ui.core.Control",multiple:false,forwarding:{idSuffix:"-header",aggregation:"search"}},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false,forwarding:{idSuffix:"-header",aggregation:"user"}}}},renderer:a});i.prototype.init=function(){t.prototype.init.apply(this,arguments);this._header=new e(this.getId()+"-header");this.setHeader(this._header)};i.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._header.destroy();delete this._header};i.prototype._getSearchWidth=function(){if(this._header===this.getHeader()&&this._header.getDomRef()){var e=this._header.$("hdr-center").children();if(e.length){return e.width()}}return-1};i.prototype.setIcon=function(e){this.setProperty("icon",e,true);this._header.setLogo(e);return this};i.prototype.getIcon=function(){return this._header.getLogo()};i.prototype.setSearchVisible=function(e){this.setProperty("searchVisible",e,true);this._header.setSearchVisible(e);return this};i.prototype.getSearchVisible=function(){return this._header.getSearchVisible()};i.prototype.setHeader=function(e){return t.prototype.setHeader.apply(this,[e?e:this._header])};i.prototype.destroyHeader=function(){if(this.getHeader()===this._header){return this}return t.prototype.destroyHeader.apply(this,[])};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ShellHeadItem", ["sap/ui/core/Element","sap/ui/core/IconPool","./library","sap/base/security/encodeXML","sap/ui/thirdparty/jquery"],function(e,t,r,a,jQuery){"use strict";var o=e.extend("sap.ui.unified.ShellHeadItem",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{startsSection:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},showSeparator:{type:"boolean",group:"Appearance",defaultValue:true},selected:{type:"boolean",group:"Appearance",defaultValue:false},toggleEnabled:{type:"boolean",group:"Appearance",defaultValue:true},showMarker:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});o.prototype.onclick=function(e){this.firePress();e.preventDefault()};o.prototype.onsapspace=o.prototype.onclick;o.prototype.onsapenter=o.prototype.onclick;o.prototype.setStartsSection=function(e){e=!!e;this.setProperty("startsSection",e,true);this.$().toggleClass("sapUiUfdShellHeadItmDelim",e);return this};o.prototype.setShowSeparator=function(e){e=!!e;this.setProperty("showSeparator",e,true);this.$().toggleClass("sapUiUfdShellHeadItmSep",e);return this};function s(){var e=this.$(),t=this.getToggleEnabled(),r=this.getSelected();if(!e.length){return}if(t){e.toggleClass("sapUiUfdShellHeadItmSel",r);e.attr("aria-pressed",r)}else{e.removeClass("sapUiUfdShellHeadItmSel");e.removeAttr("aria-pressed")}}o.prototype.setToggleEnabled=function(e){this.setProperty("toggleEnabled",!!e,true);s.apply(this);return this};o.prototype.setSelected=function(e){this.setProperty("selected",!!e,true);s.apply(this);return this};o.prototype.setVisible=function(e){this.setProperty("visible",!!e);return this};o.prototype.setShowMarker=function(e){e=!!e;this.setProperty("showMarker",e,true);this.$().toggleClass("sapUiUfdShellHeadItmMark",e);return this};o.prototype.setIcon=function(e){this.setProperty("icon",e,true);if(this.getDomRef()){this._refreshIcon()}return this};o.prototype._refreshIcon=function(){var e=jQuery(this.$().children()[0]);var r=this.getIcon();if(t.isIconURI(r)){var o=t.getIconInfo(r);e.html("").attr("style","");if(o){e.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'")}}else{var s=this.$("img-inner");if(s.length==0||s.attr("src")!=r){e.attr("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+a(r)+"'>")}}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ShellHeadUserItem", ["sap/ui/core/Element","sap/ui/core/IconPool","./library","sap/base/security/encodeXML"],function(e,t,a,i){"use strict";var r=e.extend("sap.ui.unified.ShellHeadUserItem",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{username:{type:"string",group:"Appearance",defaultValue:""},showPopupIndicator:{type:"boolean",group:"Accessibility",defaultValue:true},image:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});t.insertFontFaceStyle();r.prototype.onclick=function(e){this.firePress();e.preventDefault()};r.prototype.onsapspace=r.prototype.onclick;r.prototype.onsapenter=r.prototype.onclick;r.prototype.setImage=function(e){this.setProperty("image",e,true);if(this.getDomRef()){this._refreshImage()}return this};r.prototype._refreshImage=function(){var e=this.$("img");var a=this.getImage();if(!a){e.html("").attr("style","").css("display","none")}else if(t.isIconURI(a)){var r=t.getIconInfo(a);e.html("").attr("style","");if(r){e.text(r.content).attr("role","presentation").attr("aria-label",r.text||r.name).css("font-family","'"+r.fontFamily+"'")}}else{var s=this.$("img-inner");if(s.length==0||s.attr("src")!=a){e.attr("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+i(a)+"'>")}}};r.prototype._checkAndAdaptWidth=function(e){if(!this.getDomRef()){return false}var t=this.$(),a=this.$("name");var i=t.width();t.toggleClass("sapUiUfdShellHeadUsrItmLimit",false);var r=240;if(e){r=Math.min(r,.5*document.documentElement.clientWidth-225)}if(r<a.width()){t.toggleClass("sapUiUfdShellHeadUsrItmLimit",true)}return i!=t.width()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ShellHeader", ["./library","sap/ui/core/Control","sap/ui/Device","sap/ui/core/theming/Parameters","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,i,a,jQuery,r){"use strict";var s=t.extend("sap.ui.unified.ShellHeader",{metadata:{properties:{logo:{type:"sap.ui.core.URI",defaultValue:""},searchVisible:{type:"boolean",defaultValue:true}},aggregations:{headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},search:{type:"sap.ui.core.Control",multiple:false},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false}}},renderer:{render:function(e,t){var i=t.getId();e.write("<div");e.writeControlData(t);e.writeAttribute("class","sapUiUfdShellHeader");if(r.getAccessibility()){e.writeAttribute("role","toolbar")}e.write(">");e.write("<div id='",i,"-hdr-begin' class='sapUiUfdShellHeadBegin'>");this.renderHeaderItems(e,t,true);e.write("</div>");e.write("<div id='",i,"-hdr-center' class='sapUiUfdShellHeadCenter'>");this.renderSearch(e,t);e.write("</div>");e.write("<div id='",i,"-hdr-end' class='sapUiUfdShellHeadEnd'>");this.renderHeaderItems(e,t,false);e.write("</div>");e.write("</div>")},renderSearch:function(e,t){var i=t.getSearch();e.write("<div id='",t.getId(),"-hdr-search'");if(r.getAccessibility()){e.writeAttribute("role","search")}e.writeAttribute("class","sapUiUfdShellSearch"+(t.getSearchVisible()?"":" sapUiUfdShellHidden"));e.write("><div>");if(i){e.renderControl(i)}e.write("</div></div>")},renderHeaderItems:function(e,t,i){e.write("<div class='sapUiUfdShellHeadContainer'>");var a=i?t.getHeadItems():t.getHeadEndItems();for(var s=0;s<a.length;s++){e.write("<div tabindex='0'");e.writeElementData(a[s]);e.addClass("sapUiUfdShellHeadItm");if(a[s].getStartsSection()){e.addClass("sapUiUfdShellHeadItmDelim")}if(a[s].getShowSeparator()){e.addClass("sapUiUfdShellHeadItmSep")}if(!a[s].getVisible()){e.addClass("sapUiUfdShellHidden")}if(a[s].getSelected()&&a[s].getToggleEnabled()){e.addClass("sapUiUfdShellHeadItmSel")}if(a[s].getShowMarker()){e.addClass("sapUiUfdShellHeadItmMark")}e.writeClasses();var d=a[s].getTooltip_AsString();if(d){e.writeAttributeEscaped("title",d)}if(r.getAccessibility()){e.writeAccessibilityState(a[s],{role:"button",selected:null,pressed:a[s].getToggleEnabled()?a[s].getSelected():null})}e.write("><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></div>")}var l=t.getUser();if(!i&&l){e.write("<div tabindex='0'");e.writeElementData(l);e.addClass("sapUiUfdShellHeadUsrItm");if(!l.getShowPopupIndicator()){e.addClass("sapUiUfdShellHeadUsrItmWithoutPopup")}e.writeClasses();var d=l.getTooltip_AsString();if(d){e.writeAttributeEscaped("title",d)}if(r.getAccessibility()){e.writeAccessibilityState(l,{role:"button"});if(l.getShowPopupIndicator()){e.writeAttribute("aria-haspopup","true")}}e.write("><span id='",l.getId(),"-img' aria-hidden='true' class='sapUiUfdShellHeadUsrItmImg'></span>");e.write("<span id='"+l.getId()+"-name' class='sapUiUfdShellHeadUsrItmName'");var n=l.getUsername()||"";e.writeAttributeEscaped("title",n);e.write(">");e.writeEscaped(n);e.write("</span><span class='sapUiUfdShellHeadUsrItmExp' aria-hidden='true'></span></div>")}e.write("</div>");if(i){this._renderLogo(e,t)}},_renderLogo:function(e,t){var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),a=i.getText("SHELL_LOGO_TOOLTIP"),r=t._getLogo();e.write("<div class='sapUiUfdShellIco'>");e.write("<img id='",t.getId(),"-icon'");e.writeAttributeEscaped("title",a);e.writeAttributeEscaped("alt",a);e.write("src='");e.writeEscaped(r);e.write("'");if(!r){e.addStyle("display","none");e.writeStyles()}e.write(">");e.write("</div>")}}});s.prototype.init=function(){var e=this;this._rtl=r.getRTL();this._handleMediaChange=function(t){if(!e.getDomRef()){return}e._refresh()};i.media.attachHandler(this._handleMediaChange,this,i.media.RANGESETS.SAP_STANDARD);this._handleResizeChange=function(t){if(!e.getDomRef()||!e.getUser()){return}var i=this.getUser();var a=i._checkAndAdaptWidth(!e.$("hdr-search").hasClass("sapUiUfdShellHidden")&&!!e.getSearch());if(a){e._refresh()}};i.resize.attachHandler(this._handleResizeChange,this);this.data("sap-ui-fastnavgroup","true",true)};s.prototype.exit=function(){i.media.detachHandler(this._handleMediaChange,this,i.media.RANGESETS.SAP_STANDARD);delete this._handleMediaChange;i.resize.detachHandler(this._handleResizeChange,this);delete this._handleResizeChange};s.prototype.onAfterRendering=function(){this._refresh();this.$("hdr-center").toggleClass("sapUiUfdShellAnim",!this._noHeadCenterAnim)};s.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate()}};s.prototype._getLogo=function(){var e=this.getLogo();if(!e){e=a._getThemeImage(null,true)}return e};s.prototype._refresh=function(){function e(e){for(var t=0;t<e.length;t++){e[t]._refreshIcon()}}e(this.getHeadItems());e(this.getHeadEndItems());var t=this.getUser(),i=jQuery("html").hasClass("sapUiMedia-Std-Phone"),a=!this.$("hdr-search").hasClass("sapUiUfdShellHidden"),r=this.$("icon");if(t){t._refreshImage();t._checkAndAdaptWidth(a&&!!this.getSearch())}r.parent().toggleClass("sapUiUfdShellHidden",i&&a&&!!this.getSearch());var s=this.$("hdr-end").outerWidth(),d=this.$("hdr-begin").outerWidth(),l=Math.max(s,d),n=(i&&a?d:l)+"px",h=(i&&a?s:l)+"px";this.$("hdr-center").css({left:this._rtl?h:n,right:this._rtl?n:h})};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ShellLayout", ["sap/ui/Device","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/theming/Parameters","./SplitContainer","./library","./ShellLayoutRenderer","sap/ui/dom/containsOrEquals","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/dom/jquery/Focusable"],function(t,e,n,i,r,o,s,a,u,jQuery,d){"use strict";var h=e.extend("sap.ui.unified.ShellLayout",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{showPane:{type:"boolean",group:"Appearance",defaultValue:false},headerHiding:{type:"boolean",group:"Appearance",defaultValue:false},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",forwarding:{idSuffix:"-container",aggregation:"content"}},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent",forwarding:{idSuffix:"-container",aggregation:"secondaryContent"}},header:{type:"sap.ui.core.Control",multiple:false},canvasSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"},curtainSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"}}},renderer:s});h._SIDEPANE_WIDTH_PHONE=208;h._SIDEPANE_WIDTH_TABLET=208;h._SIDEPANE_WIDTH_DESKTOP=240;h._HEADER_ALWAYS_VISIBLE=true;h._HEADER_AUTO_CLOSE=true;h._HEADER_TOUCH_TRESHOLD=15;if(t.browser.chrome&&t.browser.version<36){h._HEADER_TOUCH_TRESHOLD=10}h.prototype.init=function(){this._rtl=d.getRTL();this._animation=d.getAnimation();this._showHeader=true;this._showCurtain=false;this._iHeaderHidingDelay=3e3;this._useStrongBG=false;this._cont=new r(this.getId()+"-container");this._cont._bRootContent=true;if(d.getAccessibility()){var e=this;this._cont.addEventDelegate({onAfterRendering:function(){e._cont.$("canvas").attr("role","main");e._cont.$("pane").attr("role","complementary")}})}this.setAggregation("canvasSplitContainer",this._cont,true);this._curtCont=new r(this.getId()+"-curt-container");this._curtCont._bRootContent=true;this.setAggregation("curtainSplitContainer",this._curtCont,true);this._setSidePaneWidth();t.media.attachHandler(this._handleMediaChange,this,t.media.RANGESETS.SAP_STANDARD);t.resize.attachHandler(this._handleResizeChange,this)};h.prototype.exit=function(){t.media.detachHandler(this._handleMediaChange,this,t.media.RANGESETS.SAP_STANDARD);t.resize.detachHandler(this._handleResizeChange,this);delete this._cont;delete this._curtCont};h.prototype.onAfterRendering=function(){var t=this;function e(e){var n=jQuery.event.fix(e);if(a(t.getDomRef("hdr"),n.target)){t._timedHideHeader(n.type==="focus")}}if(window.addEventListener&&!h._HEADER_ALWAYS_VISIBLE){var n=this.getDomRef("hdr");n.addEventListener("focus",e,true);n.addEventListener("blur",e,true)}this._refreshAfterRendering()};h.prototype.onThemeChanged=function(){this._refreshAfterRendering()};h.prototype.onfocusin=function(t){var e=this.getId();if(t.target.id===e+"-curt-focusDummyOut"&&this.$("hdrcntnt").firstFocusableDomRef()){this.$("hdrcntnt").firstFocusableDomRef().focus()}else if(t.target.id===e+"-main-focusDummyOut"&&this.$("curtcntnt").firstFocusableDomRef()){this.$("curtcntnt").firstFocusableDomRef().focus()}};(function(){function e(t){if(t._startY===undefined||t._currY===undefined){return}var e=t._currY-t._startY;if(Math.abs(e)>h._HEADER_TOUCH_TRESHOLD){t._doShowHeader(e>0);t._startY=t._currY}}if(t.support.touch){h._HEADER_ALWAYS_VISIBLE=false;h.prototype.ontouchstart=function(t){this._startY=t.touches[0].pageY;if(this._startY>2*48){this._startY=undefined}this._currY=this._startY};h.prototype.ontouchend=function(t){e(this);this._startY=undefined;this._currY=undefined};h.prototype.ontouchcancel=h.prototype.ontouchend;h.prototype.ontouchmove=function(t){this._currY=t.touches[0].pageY;e(this)}}})();h.prototype.setHeaderHiding=function(t){t=!!t;return this._mod(function(e){return this.setProperty("headerHiding",t,e)},function(){this._doShowHeader(!t?true:this._showHeader)})};h.prototype.setHeaderHidingDelay=function(t){this._iHeaderHidingDelay=t;return this};h.prototype.getHeaderHidingDelay=function(){return this._iHeaderHidingDelay};h.prototype.getShowPane=function(){return this._cont.getShowSecondaryContent()};h.prototype.setShowPane=function(t){this._cont.setShowSecondaryContent(t);this.setProperty("showPane",!!t,true);return this};h.prototype.setShowCurtainPane=function(t){this._curtCont.setShowSecondaryContent(t);return this};h.prototype.getShowCurtainPane=function(){return this._curtCont.getShowSecondaryContent()};h.prototype.setHeaderVisible=function(t){t=!!t;this.setProperty("headerVisible",t,true);this.$().toggleClass("sapUiUfdShellNoHead",!t);return this};h.prototype.setShowCurtain=function(t){t=!!t;return this._mod(function(e){this._showCurtain=t;return this},function(){this.$("main-focusDummyOut").attr("tabindex",t?0:-1);this.$().toggleClass("sapUiUfdShellCurtainHidden",!t).toggleClass("sapUiUfdShellCurtainVisible",t);if(t){var e=n.getNextZIndex();this.$("curt").css("z-index",e+1);this.$("hdr").css("z-index",e+3);this.$("brand").css("z-index",e+7);this.$().toggleClass("sapUiUfdShellCurtainClosed",false)}this._timedCurtainClosed(t);this._doShowHeader(true)})};h.prototype.getShowCurtain=function(){return this._showCurtain};h.prototype.setHeader=function(t){this.setAggregation("header",t,true);t=this.getHeader();if(this.getDomRef()){if(!t){this.$("hdrcntnt").html("")}else{var e=sap.ui.getCore().createRenderManager();e.renderControl(t);e.flush(this.getDomRef("hdrcntnt"));e.destroy()}}return this};h.prototype.destroyHeader=function(){this.destroyAggregation("header",true);this.$("hdrcntnt").html("");return this};h.prototype.getCurtainContent=function(){return this._curtCont.getContent()};h.prototype.insertCurtainContent=function(t,e){this._curtCont.insertContent(t,e);return this};h.prototype.addCurtainContent=function(t){this._curtCont.addContent(t);return this};h.prototype.removeCurtainContent=function(t){return this._curtCont.removeContent(t)};h.prototype.removeAllCurtainContent=function(){return this._curtCont.removeAllContent()};h.prototype.destroyCurtainContent=function(){this._curtCont.destroyContent();return this};h.prototype.indexOfCurtainContent=function(t){return this._curtCont.indexOfCurtainContent(t)};h.prototype.getCurtainPaneContent=function(){return this._curtCont.getSecondaryContent()};h.prototype.insertCurtainPaneContent=function(t,e){this._curtCont.insertSecondaryContent(t,e);return this};h.prototype.addCurtainPaneContent=function(t){this._curtCont.addSecondaryContent(t);return this};h.prototype.removeCurtainPaneContent=function(t){return this._curtCont.removeSecondaryContent(t)};h.prototype.removeAllCurtainPaneContent=function(){return this._curtCont.removeAllSecondaryContent()};h.prototype.destroyCurtainPaneContent=function(){this._curtCont.destroySecondaryContent();return this};h.prototype.indexOfCurtainPaneContent=function(t){return this._curtCont.indexOfSecondaryContent(t)};h.prototype._setStrongBackground=function(t){this._useStrongBG=!!t;this.$("strgbg").toggleClass("sapUiStrongBackgroundColor",this._useStrongBG)};h.prototype._mod=function(t,e){var n=!!this.getDomRef();var i=t.apply(this,[n]);if(n&&e){if(e instanceof o._ContentRenderer){e.render()}else{e.apply(this)}}return i};h.prototype._doShowHeader=function(t){var e=this._showHeader;this._showHeader=this._isHeaderHidingActive()?!!t:true;this.$().toggleClass("sapUiUfdShellHeadHidden",!this._showHeader).toggleClass("sapUiUfdShellHeadVisible",this._showHeader);if(this._showHeader){this._timedHideHeader()}if(e!=this._showHeader&&this._isHeaderHidingActive()){setTimeout(function(){try{var t=document.createEvent("UIEvents");t.initUIEvent("resize",true,false,window,0);window.dispatchEvent(t)}catch(t){u.error(t)}},500)}};h.prototype._timedHideHeader=function(t){if(this._headerHidingTimer){clearTimeout(this._headerHidingTimer);this._headerHidingTimer=null}if(t||!h._HEADER_AUTO_CLOSE||!this._isHeaderHidingActive()||this._iHeaderHidingDelay<=0){return}this._headerHidingTimer=setTimeout(function(){if(this._isHeaderHidingActive()&&this._iHeaderHidingDelay>0&&!a(this.getDomRef("hdr"),document.activeElement)){this._doShowHeader(false)}}.bind(this),this._iHeaderHidingDelay)};h.prototype._timedCurtainClosed=function(t){if(this._curtainClosedTimer){clearTimeout(this._curtainClosedTimer);this._curtainClosedTimer=null}if(t){return}var e=parseInt(i.get("_sap_ui_unified_ShellLayout_AnimDuration"));if(!this._animation){e=0}this._curtainClosedTimer=setTimeout(function(){this._curtainClosedTimer=null;this.$("curt").css("z-index","");this.$("hdr").css("z-index","");this.$("brand").css("z-index","");this.$().toggleClass("sapUiUfdShellCurtainClosed",true)}.bind(this),e)};h.prototype._isHeaderHidingActive=function(){if(h._HEADER_ALWAYS_VISIBLE||this.getShowCurtain()||!this.getHeaderHiding()||o._iNumberOfOpenedShellOverlays>0||!this.getHeaderVisible()){return false}return true};h.prototype._setSidePaneWidth=function(e){if(!e){e=t.media.getCurrentRange(t.media.RANGESETS.SAP_STANDARD).name}var n=h["_SIDEPANE_WIDTH_"+e.toUpperCase()]+"px";this._cont.setSecondaryContentSize(n);this._curtCont.setSecondaryContentSize(n)};h.prototype._handleMediaChange=function(t){if(!this.getDomRef()){return false}this._setSidePaneWidth(t.name)};h.prototype._handleResizeChange=function(t){};h.prototype._refreshAfterRendering=function(){var t=this.getDomRef();if(!t){return false}this._timedHideHeader();return true};h.prototype._getSearchWidth=function(){return-1};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ShellLayoutRenderer", ["sap/ui/core/Configuration"],function(i){"use strict";var e={};e.render=function(e,a){var d=a.getId();e.write("<div");e.writeControlData(a);e.addClass("sapUiUfdShell");if(a._animation){e.addClass("sapUiUfdShellAnim")}if(!a.getHeaderVisible()){e.addClass("sapUiUfdShellNoHead")}e.addClass("sapUiUfdShellHead"+(a._showHeader?"Visible":"Hidden"));if(a.getShowCurtain()){e.addClass("sapUiUfdShellCurtainVisible")}else{e.addClass("sapUiUfdShellCurtainHidden");e.addClass("sapUiUfdShellCurtainClosed")}e.writeClasses();e.write(">");e.write("<hr id='",d,"-brand' class='sapUiUfdShellBrand'>");e.write("<header id='",d,"-hdr'  class='sapUiUfdShellHead'");if(i.getAccessibility()){e.writeAttribute("role","banner")}e.write("><div><div id='",d,"-hdrcntnt' class='sapUiUfdShellCntnt'>");if(a.getHeader()){e.renderControl(a.getHeader())}e.write("</div>","</div>","</header>");e.write("<section id='",d,"-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>");e.write("<div id='",d,"-curtcntnt' class='sapUiUfdShellCntnt'>");e.renderControl(a._curtCont);e.write("</div>");e.write("<span id='",d,"-curt-focusDummyOut' tabindex='0'></span>");e.write("</section>");e.write("<div id='",d,"-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas sapUiGlobalBackgroundColor sapUiGlobalBackgroundColorForce'>");e.write("<div id='",d,"-strgbg' class='sapUiUfdShellBG"+(a._useStrongBG?" sapUiStrongBackgroundColor":"")+"'></div>");e.write("<div class='sapUiGlobalBackgroundImage sapUiGlobalBackgroundImageForce sapUiUfdShellBG'></div>");e.renderControl(a._cont);e.write("</div>");e.write("<span id='",d,"-main-focusDummyOut' tabindex='"+(a.getShowCurtain()?0:-1)+"'></span>");e.write("</div>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ShellOverlay", ["sap/ui/Device","sap/ui/core/Control","sap/ui/core/Popup","./library","sap/ui/core/theming/Parameters","./ShellOverlayRenderer","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/Selectors"],function(e,t,i,n,r,o,jQuery,s){"use strict";var a=t.extend("sap.ui.unified.ShellOverlay",{metadata:{library:"sap.ui.unified",deprecated:true,defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},search:{type:"sap.ui.core.Control",multiple:false}},associations:{shell:{type:"sap.ui.unified.ShellLayout",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{closed:{}}},renderer:o});a.prototype.open=function(){if(this._getPopup().isOpen()){return}this._opening=true;this._forceShellHeaderVisible();this._getPopup().setModal(true,i.blStack.length==0&&this._getAnimActive()?"sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp":"");this._getPopup().open(0,i.Dock.BeginTop,i.Dock.BeginTop,window,"0 0","none");var e=this.getSearch();if(e){e.focus()}this._opening=false;if(this._getAnimActive()){setTimeout(function(){jQuery(document.getElementById("sap-ui-blocklayer-popup")).toggleClass("sapUiUfdShellOvrlyBlyTp",false)},50)}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyOpening",false)}.bind(this),this._getAnimDuration(true))};a.prototype.close=function(){if(!this._getPopup().isOpen()){return}this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",true).toggleClass("sapUiUfdShellOvrlyClosing",true);this._setSearchWidth();setTimeout(function(){var e=jQuery(document.getElementById("sap-ui-blocklayer-popup"));if(i.blStack.length==1&&this._getAnimActive()&&e.hasClass("sapUiUfdShellOvrlyBly")){e.toggleClass("sapUiUfdShellOvrlyBlyTp",true)}}.bind(this),Math.max(this._getAnimDuration(false)-this._getBLAnimDuration(),0));setTimeout(function(){this._getPopup().close(0);this.$().remove();this._forceShellHeaderVisible();this.fireClosed()}.bind(this),this._getAnimDuration(false))};a.prototype.setShell=function(e){return this.setAssociation("shell",e,true)};a.prototype.setSearch=function(e){this.setAggregation("search",e,true);if(this.getDomRef()){this._headRenderer.render()}return this};a.prototype.insertContent=function(e,t){var i=this.insertAggregation("content",e,t,true);if(this.getDomRef()){this._contentRenderer.render()}return i};a.prototype.addContent=function(e){var t=this.addAggregation("content",e,true);if(this.getDomRef()){this._contentRenderer.render()}return t};a.prototype.removeContent=function(e){var t=this.removeAggregation("content",e,true);if(this.getDomRef()){this._contentRenderer.render()}return t};a.prototype.removeAllContent=function(){var e=this.removeAllAggregation("content",true);if(this.getDomRef()){this._contentRenderer.render()}return e};a.prototype.destroyContent=function(){var e=this.destroyAggregation("content",true);if(this.getDomRef()){this._contentRenderer.render()}return e};a.prototype.init=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;this._animation=s.getAnimation();this._opening=false;var e=this;this._headRenderer=new n._ContentRenderer(this,this.getId()+"-hdr-center",function(t){o.renderSearch(t,e)});this._contentRenderer=new n._ContentRenderer(this,this.getId()+"-cntnt",function(t){o.renderContent(t,e)})};a.prototype.exit=function(){if(this._popup){this._popup.close(0);this._popup.destroy();this._popup=null}this._getPopup=function(){return null};this._headRenderer.destroy();delete this._headRenderer;this._contentRenderer.destroy();delete this._contentRenderer};a.prototype.onAfterRendering=function(){if(this._opening){this._setSearchWidth()}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",false);this.$("search").css("width","")}.bind(this),10)};a.prototype.onclick=function(e){if(jQuery(e.target).attr("id")===this.getId()+"-close"){this.close();e.preventDefault()}};a.prototype.onsapspace=a.prototype.onclick;a.prototype.onThemeChanged=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1};a.prototype.onfocusin=function(e){var t,i;if(e.target.id==this.getId()+"-focfirst"){t=jQuery(":sapTabbable",this.$("inner"));i=t.get(t.length-1)}else if(e.target.id==this.getId()+"-foclast"){t=jQuery(":sapTabbable",this.$("inner"));i=t.get(0)}if(i){i.focus()}};a.prototype._getAnimDurationThemeParam=function(e,t){var i=parseInt(r.get(e));if(!this._getAnimActive()&&t){i=0}return i};a.prototype._getAnimDuration=function(e){if(e&&this._animOpenDuration==-1||!e&&this._animCloseDuration==-1){var t=e?"Open":"Close";this["_anim"+t+"Duration"]=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_"+t+"AnimOverAll",true)}return e?this._animOpenDuration:this._animCloseDuration};a.prototype._getBLAnimDuration=function(){if(this._animBlockLayerDuration==-1){this._animBlockLayerDuration=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_BlockLayerAnimDuration",true)}return this._animBlockLayerDuration};a.prototype._getAnimActive=function(){if(!this._animation){return false}return true};a.prototype._getPopup=function(){if(!this._popup){this._popup=new i(this,true,false,false);this._popup._applyPosition=function(e){this._$().css("left","0").css("top","0");this._oLastPosition=e;this._oLastOfRect=jQuery(window).rect()};this._popup.attachOpened(function(){n._iNumberOfOpenedShellOverlays++});this._popup.attachClosed(function(){n._iNumberOfOpenedShellOverlays--})}return this._popup};a.prototype._getShell=function(){var e=this.getShell();if(!e){return}var t=sap.ui.getCore().byId(e);if(!t||!(t instanceof sap.ui.unified.ShellLayout)){return}return t};a.prototype._forceShellHeaderVisible=function(){var e=this._getShell();if(e){e._doShowHeader(true)}};a.prototype._getSearchWidth=function(){var e=this._getShell();return e?e._getSearchWidth():-1};a.prototype._setSearchWidth=function(){var t=this._getSearchWidth();if(t<=0){return}var i=t+"px";if(e.browser.safari){var n=this.$("hdr-center").width();if(n>t){i=Math.round(t*100/n)+"%"}else{i="100%"}}this.$("search").css("width",i)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ShellOverlayRenderer", ["sap/ui/core/Configuration"],function(e){"use strict";var i={};i.render=function(t,r){t.write("<div");t.writeControlData(r);t.addClass("sapUiUfdShellOvrly");if(r._opening){t.addClass("sapUiUfdShellOvrlyCntntHidden");t.addClass("sapUiUfdShellOvrlyOpening")}if(r._getAnimActive()){t.addClass("sapUiUfdShellOvrlyAnim")}t.writeClasses();if(e.getAccessibility()){t.writeAccessibilityState(r,{role:"dialog"})}t.write("><span id='",r.getId(),"-focfirst' tabindex='0'></span><div id='",r.getId(),"-inner'>");t.write("<header class='sapUiUfdShellOvrlyHead'>");t.write("<hr class='sapUiUfdShellOvrlyBrand'>");t.write("<div class='sapUiUfdShellOvrlyHeadCntnt'");if(e.getAccessibility()){t.writeAttribute("role","toolbar")}t.write("><div id='"+r.getId()+"-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>");i.renderSearch(t,r);t.write("</div>");var d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),a=d.getText("SHELL_OVERLAY_CLOSE");t.write("<a tabindex='0' href='#' id='"+r.getId()+"-close' class='sapUiUfdShellOvrlyHeadClose'");t.writeAttributeEscaped("title",a);if(e.getAccessibility()){t.writeAttribute("role","button")}t.write(">");t.writeEscaped(a);t.write("</a></div></header>");t.write("<div id='"+r.getId()+"-cntnt' class='sapUiUfdShellOvrlyCntnt'>");i.renderContent(t,r);t.write("</div>");t.write("</div><span id='",r.getId(),"-foclast' tabindex='0'></span></div>")};i.renderSearch=function(e,i){var t=i._getSearchWidth();e.write("<div id='"+i.getId()+"-search' class='sapUiUfdShellOvrlySearch' ");if(t>0&&i._opening){e.addStyle("width",t+"px'");e.writeStyles()}e.write("><div>");var r=i.getSearch();if(r){e.renderControl(r)}e.write("</div></div>")};i.renderContent=function(e,i){e.write("<div>");var t=i.getContent();for(var r=0;r<t.length;r++){e.renderControl(t[r])}e.write("</div>")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/ShellRenderer", ["sap/ui/core/Renderer","./ShellLayoutRenderer"],function(e,r){"use strict";var n=e.extend(r);return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/SplitContainer", ["sap/ui/core/Control","sap/ui/core/theming/Parameters","./library","sap/ui/core/library","./SplitContainerRenderer","sap/base/Log","sap/ui/core/Configuration"],function(t,e,n,o,r,i,a){"use strict";var s=o.Orientation;var d=t.extend("sap.ui.unified.SplitContainer",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{showSecondaryContent:{type:"boolean",group:"Appearance",defaultValue:null},secondaryContentSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"250px"},secondaryContentWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"250px",deprecated:true},orientation:{type:"sap.ui.core.Orientation",group:"Appearance",defaultValue:s.Horizontal}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},secondaryContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondaryContent"}}},renderer:r});(function(t){d.prototype.init=function(){this.bRtl=a.getRTL();this._paneRenderer=new n._ContentRenderer(this,this.getId()+"-panecntnt","secondaryContent");this._canvasRenderer=new n._ContentRenderer(this,this.getId()+"-canvascntnt","content");this._moveContent=true};d.prototype.exit=function(){this._paneRenderer.destroy();delete this._paneRenderer;this._canvasRenderer.destroy();delete this._canvasRenderer;if(this._closeContentDelayId){clearTimeout(this._closeContentDelayId);delete this._closeContentDelayId}delete this._contentContainer;delete this._secondaryContentContainer};d.prototype.onAfterRendering=function(){this.bRtl=a.getRTL();this._contentContainer=this.$("canvas");this._secondaryContentContainer=this.$("pane");this._applySecondaryContentSize()};d.prototype._applySecondaryContentSize=function(){if(this.getDomRef()){var t=this.getOrientation()==s.Vertical;var n,o;var r,i;var a=this.getSecondaryContentSize();var d=this.getShowSecondaryContent();if(t){n="height";o="width";r="top";i=this.bRtl?"right":"left"}else{n="width";o="height";r=this.bRtl?"right":"left";i="top"}if(this._closeContentDelayId){clearTimeout(this._closeContentDelayId);delete this._closeContentDelayId}this._secondaryContentContainer.css(n,a);this._secondaryContentContainer.css(o,"");this._secondaryContentContainer.css(r,d?"0":"-"+a);this._secondaryContentContainer.css(i,"");if(this._moveContent){this._contentContainer.css(r,d?a:"0")}else{this._contentContainer.css(r,"0")}if(!d){var c=parseInt(e.get("_sap_ui_unified_SplitContainer_AnimationDuration"));this._closeContentDelayId=setTimeout(function(){this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",true)}.bind(this),c)}else{this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",false)}}};d.prototype._mod=function(t,e){var n=!!this.getDomRef();var o=t.apply(this,[n]);if(n&&e){e.render()}return o};d.prototype.setShowSecondaryContent=function(t){var e=this.getDomRef();this.setProperty("showSecondaryContent",!!t,e);this._applySecondaryContentSize();return this};d.prototype.setSecondaryContentSize=function(t){this.setProperty("secondaryContentSize",t,true);this._applySecondaryContentSize();return this};d.prototype.getSecondaryContentWidth=function(){i.warning('SplitContainer: Use of deprecated property "SecondaryContentWidth", please use '+'"SecondaryContentSize" instead.');return this.getSecondaryContentSize.apply(this,arguments)};d.prototype.setSecondaryContentWidth=function(){i.warning('SplitContainer: Use of deprecated property "SecondaryContentWidth", please use '+'"SecondaryContentSize" instead.');return this.setSecondaryContentSize.apply(this,arguments)};d.prototype.insertContent=function(t,e){return this._mod(function(n){return this.insertAggregation("content",t,e,n)},this._canvasRenderer)};d.prototype.addContent=function(t){return this._mod(function(e){return this.addAggregation("content",t,e)},this._canvasRenderer)};d.prototype.removeContent=function(t){return this._mod(function(e){return this.removeAggregation("content",t,e)},this._canvasRenderer)};d.prototype.removeAllContent=function(){return this._mod(function(t){return this.removeAllAggregation("content",t)},this._canvasRenderer)};d.prototype.destroyContent=function(){return this._mod(function(t){return this.destroyAggregation("content",t)},this._canvasRenderer)};d.prototype.insertSecondaryContent=function(t,e){return this._mod(function(n){return this.insertAggregation("secondaryContent",t,e,n)},this._paneRenderer)};d.prototype.addSecondaryContent=function(t){return this._mod(function(e){return this.addAggregation("secondaryContent",t,e)},this._paneRenderer)};d.prototype.removeSecondaryContent=function(t){return this._mod(function(e){return this.removeAggregation("secondaryContent",t,e)},this._paneRenderer)};d.prototype.removeAllSecondaryContent=function(){return this._mod(function(t){return this.removeAllAggregation("secondaryContent",t)},this._paneRenderer)};d.prototype.destroySecondaryContent=function(){return this._mod(function(t){return this.destroyAggregation("secondaryContent",t)},this._paneRenderer)}})(window);return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/SplitContainerRenderer", ["sap/ui/core/library","sap/ui/core/Configuration"],function(t,e){"use strict";var n=t.Orientation;var i={};i.render=function(t,i){var a=i.getId();var r=i.getOrientation()==n.Vertical;t.write("<div");t.writeControlData(i);t.addClass("sapUiUfdSpltCont");t.addClass("sapUiUfdSpltCont"+(r?"V":"H"));if(e.getAnimationMode()!==e.AnimationMode.none){t.addClass("sapUiUfdSpltContAnim")}if(!i.getShowSecondaryContent()){t.addClass("sapUiUfdSpltContPaneHidden")}t.writeClasses();t.write(">");var o=a+"-canvas";t.write("<section id='",o,"' class='sapUiUfdSpltContCanvas'>");this.renderContent(t,o,i.getContent(),i._bRootContent);t.write("</section>");var d=a+"-pane";var s=i.getShowSecondaryContent()?i.getSecondaryContentSize():"0";t.write("<aside id='",d);t.write("'");t.addStyle("width",s);t.writeStyles();t.addClass("sapUiUfdSpltContPane");if(!i.getShowSecondaryContent()){t.addClass("sapUiUfdSplitContSecondClosed")}t.writeClasses();t.write(">");this.renderContent(t,d,i.getSecondaryContent(),i._bRootContent);t.write("</aside>");t.write("</div>")};i.renderContent=function(t,e,n,i){t.write("<div id='",e,"cntnt' class='sapUiUfdSpltContCntnt'");if(i){t.writeAttribute("data-sap-ui-root-content","true")}t.write(">");for(var a=0;a<n.length;a++){t.renderControl(n[a])}t.write("</div>")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/CalendarDate", ["sap/ui/base/Object","sap/ui/core/date/UniversalDate","sap/ui/core/date/UI5Date"],function(t,e,a){"use strict";var n=t.extend("sap.ui.unified.calendar.CalendarDate",{constructor:function(){var t=arguments,e,o,i;switch(t.length){case 0:o=a.getInstance();return n.call(this,o.getFullYear(),o.getMonth(),o.getDate());case 1:case 2:if(!(t[0]instanceof n)){throw"Invalid arguments: the first argument must be of type sap.ui.unified.calendar.CalendarDate."}i=t[1]?t[1]:t[0]._oUDate.sCalendarType;e=a.getInstance(t[0].valueOf());e.setFullYear(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate());e.setHours(e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());this._oUDate=r(e,i);break;case 3:case 4:u(t[0],"Invalid year: "+t[0]);u(t[1],"Invalid month: "+t[1]);u(t[2],"Invalid date: "+t[2]);e=a.getInstance(0,0,1);e.setFullYear(t[0],t[1],t[2]);if(t[3]){i=t[3]}this._oUDate=r(e,i);break;default:throw"Invalid arguments. Accepted arguments are: 1) oCalendarDate, (optional)calendarType"+"or 2) year, month, date, (optional) calendarType"+t}}});n.prototype.getYear=function(){return this._oUDate.getUTCFullYear()};n.prototype.setYear=function(t){u(t,"Invalid year: "+t);this._oUDate.setUTCFullYear(t);return this};n.prototype.getMonth=function(){return this._oUDate.getUTCMonth()};n.prototype.setMonth=function(t,e){u(t,"Invalid month: "+t);if(e||e===0){u(e,"Invalid date: "+e);this._oUDate.setUTCMonth(t,e)}else{this._oUDate.setUTCMonth(t)}return this};n.prototype.getDate=function(){return this._oUDate.getUTCDate()};n.prototype.setDate=function(t){u(t,"Invalid date: "+t);this._oUDate.setUTCDate(t);return this};n.prototype.getDay=function(){return this._oUDate.getUTCDay()};n.prototype.getCalendarType=function(){return this._oUDate.sCalendarType};n.prototype.getEra=function(){return this._oUDate.getUTCEra()};n.prototype.isBefore=function(t){i(t);return this.valueOf()<t.valueOf()};n.prototype.isAfter=function(t){i(t);return this.valueOf()>t.valueOf()};n.prototype.isSameOrBefore=function(t){i(t);return this.valueOf()<=t.valueOf()};n.prototype.isSameOrAfter=function(t){i(t);return this.valueOf()>=t.valueOf()};n.prototype.isSame=function(t){i(t);return this.valueOf()===t.valueOf()};n.prototype.toLocalJSDate=function(){var t=a.getInstance(this._oUDate.getTime());t.setFullYear(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate());t.setHours(0,0,0,0);return t};n.prototype.toUTCJSDate=function(){var t=a.getInstance(this._oUDate.getTime());t.setUTCHours(0,0,0,0);return t};n.prototype.toString=function(){return this._oUDate.sCalendarType+": "+this.getYear()+"/"+(this.getMonth()+1)+"/"+this.getDate()};n.prototype.valueOf=function(){return this._oUDate.getTime()};n.fromLocalJSDate=function(t,e){if(!t||Object.prototype.toString.call(t)!=="[object Date]"||isNaN(t)){throw new Error("Date parameter must be a JavaScript or UI5Date date object: ["+t+"].")}return new n(t.getFullYear(),t.getMonth(),t.getDate(),e)};n.fromUTCDate=function(t,e){if(!t||Object.prototype.toString.call(t)!=="[object Date]"||isNaN(t)){throw new Error("Date parameter must be a JavaScript or UI5Date date object: ["+t+"].")}return new n(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate(),e)};function r(t,a){if(a){return e.getInstance(o(t),a)}else{return new e(o(t).getTime())}}function o(t){var e=a.getInstance(Date.UTC(0,0,1));e.setUTCFullYear(t.getFullYear(),t.getMonth(),t.getDate());return e}function i(t){if(!(t instanceof n)){throw"Invalid calendar date: ["+t+"]. Expected: sap.ui.unified.calendar.CalendarDate"}}function u(t,e){if(t==undefined||t===Infinity||isNaN(t)){throw e}}return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/CalendarUtils", ["sap/ui/core/date/UniversalDate","./CalendarDate","sap/ui/core/CalendarType","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/Configuration","sap/ui/core/date/UI5Date"],function(e,t,a,n,r,i,s){"use strict";var g={};g.MAX_MILLISECONDS=864e13;g.HOURS24=1e3*3600*24;g._createLocalDate=function(t,a){var n;if(t){var r;if(t instanceof e){r=t.getJSDate()}else{r=t}n=s.getInstance(r.getUTCFullYear(),r.getUTCMonth(),r.getUTCDate());if(r.getFullYear()<1e3){n.setFullYear(r.getFullYear())}if(a){n.setHours(r.getUTCHours());n.setMinutes(r.getUTCMinutes());n.setSeconds(r.getUTCSeconds());n.setMilliseconds(r.getUTCMilliseconds())}}return n};g._createUTCDate=function(t,a){var n;if(t){var r;if(t instanceof e){r=t.getJSDate()}else{r=t}n=s.getInstance(Date.UTC(r.getFullYear(),r.getMonth(),r.getDate()));if(r.getFullYear()<1e3){n.setUTCFullYear(r.getFullYear())}if(a){n.setUTCHours(r.getHours());n.setUTCMinutes(r.getMinutes());n.setUTCSeconds(r.getSeconds());n.setUTCMilliseconds(r.getMilliseconds())}}return n};g._createUniversalUTCDate=function(t,a,n){var r;if(a){r=e.getInstance(this._createUTCDate(t,n),a)}else{r=new e(this._createUTCDate(t,n).getTime())}return r};g.calculateWeekNumber=function(t,a,n,r){var i=0;var s=0;var g=r.getFirstDayOfWeek();var u=r.firstDayStartsFirstWeek();if(u){var l=new e(t.getTime());l.setUTCFullYear(a,0,1);s=l.getUTCDay();var o=new e(t.getTime());o.setUTCDate(o.getUTCDate()-o.getUTCDay()+s);i=Math.round((o.getTime()-l.getTime())/864e5/7)+1}else{var c=new e(t.getTime());c.setUTCDate(c.getUTCDate()-g);s=c.getUTCDay();c.setUTCDate(c.getUTCDate()-s+4);var T=new e(c.getTime());T.setUTCMonth(0,1);s=T.getUTCDay();var C=0;if(s>4){C=7}var f=new e(T.getTime());f.setUTCDate(1-s+4+C);i=Math.round((c.getTime()-f.getTime())/864e5/7)+1}return i};g.getFirstDateOfWeek=function(t,a){var n=new e(t.getTime()),s,g,u=r.getInstance(i.getFormatSettings().getFormatLocale()),l=i.getLocale(),o=u.getFirstDayOfWeek(),c;if(!a||(a.firstDayOfWeek===-1||a.firstDayOfWeek===undefined)){a={firstDayOfWeek:u.getFirstDayOfWeek(),minimalDaysInFirstWeek:u.getMinimalDaysInFirstWeek()}}c=e.getWeekByDate(n.getCalendarType(),n.getUTCFullYear(),n.getUTCMonth(),n.getUTCDate(),l,a);s=e.getFirstDateOfWeek(n.getCalendarType(),c.year,c.week,l,a);g=new e(e.UTC(s.year,s.month,s.day));if(a&&(a.firstDayOfWeek===-1||a.firstDayOfWeek===undefined)){while(g.getUTCDay()!==o){g.setUTCDate(g.getUTCDate()-1)}}return new e(e.UTC(g.getUTCFullYear(),g.getUTCMonth(),g.getUTCDate(),t.getUTCHours(),t.getUTCMinutes(),t.getUTCSeconds())).getJSDate()};g.getFirstDateOfMonth=function(t){var a=new e(t.getTime());a.setUTCDate(1);return a};g._getNumberOfWeeksForYear=function(e){var t=i.getFormatLocale(),a=r.getInstance(new n(t)),g=s.getInstance(Date.UTC(e,0,1)),u=g.getUTCDay(),l=52;if(a.getFirstDayOfWeek()===0){if(u===5||u===6){l=53}}else{if(u===3||u===4){l=53}}return l};g.monthsDiffer=function(e,t){return e.getMonth()!==t.getMonth()||e.getFullYear()!==t.getFullYear()};g.isDateLastInMonth=function(e){var t=s.getInstance(e.getTime()+24*60*60*1e3);return t.getUTCDate()<e.getUTCDate()};g._updateUTCDate=function(e,t,a,n,r,i,s,g){if(t!=null){e.setUTCFullYear(t)}if(a!=null){e.setUTCMonth(a)}if(n!=null){e.setUTCDate(n)}if(r!=null){e.setUTCHours(r)}if(i!=null){e.setUTCMinutes(i)}if(s!=null){e.setUTCSeconds(s)}if(g!=null){e.setUTCMilliseconds(g)}};g._checkJSDateObject=function(e){if(!e||Object.prototype.toString.call(e)!=="[object Date]"||isNaN(e)){throw new Error("Date must be a JavaScript or UI5Date date object.")}};g._checkYearInValidRange=function(e,n){var r=i.getCalendarType(),s=new t(this._minDate(a.Gregorian),n||r),g=new t(this._maxDate(a.Gregorian),n||r);if(typeof e!=="number"||e<s.getYear()||e>g.getYear()){throw new Error("Year must be in valid range (between year 0001 and year 9999 in Gregorian calendar type).")}};g._isNextMonth=function(e,t){return e.getMonth()>t.getMonth()&&e.getFullYear()===t.getFullYear()||e.getFullYear()>t.getFullYear()};g._minutesBetween=function(e,t){var a=(t.getTime()-e.getTime())/1e3;a=a/60;return Math.abs(Math.round(a))};g._areCurrentMinutesLessThan=function(e){var t=s.getInstance().getMinutes();return e>=t};g._areCurrentMinutesMoreThan=function(e){var t=s.getInstance().getMinutes();return e<=t};g._monthsBetween=function(e,t,a){var n=s.getInstance(Date.UTC(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate())),r=s.getInstance(Date.UTC(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate())),i;n.setUTCFullYear(e.getUTCFullYear());r.setUTCFullYear(t.getUTCFullYear());i=r.getUTCFullYear()*12+r.getUTCMonth()-(n.getUTCFullYear()*12+n.getUTCMonth());if(!a){i=Math.abs(i)}return i};g._hoursBetween=function(e,t){var a=s.getInstance(Date.UTC(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours()));var n=s.getInstance(Date.UTC(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate(),t.getUTCHours()));a.setUTCFullYear(e.getUTCFullYear());n.setUTCFullYear(t.getUTCFullYear());return Math.abs((a.getTime()-n.getTime())/(1e3*60*60))};g._isMidnight=function(e){return e.getHours()===0&&e.getMinutes()===0&&e.getSeconds()===0&&e.getMilliseconds()===0};g._daysInMonth=function(e){this._checkCalendarDate(e);e=new t(e);e.setDate(1);e.setMonth(e.getMonth()+1);e.setDate(0);return e.getDate()};g._isLastDateInMonth=function(e){return e.getDate()===g._daysInMonth(e)};g._getFirstDateOfWeek=function(e,a){var n=r.getInstance(i.getFormatSettings().getFormatLocale());this._checkCalendarDate(e);if(!a||(a.firstDayOfWeek===-1||a.firstDayOfWeek===undefined)){a={firstDayOfWeek:n.getFirstDayOfWeek(),minimalDaysInFirstWeek:n.getMinimalDaysInFirstWeek()}}if(e.getDay()!==a.firstDayOfWeek){var s=g.getFirstDateOfWeek(e.toUTCJSDate(),a);s.setFullYear(s.getUTCFullYear(),s.getUTCMonth(),s.getUTCDate());return t.fromLocalJSDate(s,e.getCalendarType())}return e};g._getFirstDateOfMonth=function(e){this._checkCalendarDate(e);var a=new t(e,e.getCalendarType());a.setDate(1);return a};g._minDate=function(e){var a=new t(1,0,1,e);a.setYear(1);a.setMonth(0);a.setDate(1);return a};g._maxDate=function(e){var a=new t(9999,11,1,e);a.setYear(9999);a.setMonth(11);a.setDate(this._daysInMonth(a));return new t(a)};g._isBetween=function(e,t,a,n){this._checkCalendarDate(e);this._checkCalendarDate(t);this._checkCalendarDate(a);if(n){return e.isSameOrAfter(t)&&e.isSameOrBefore(a)}else{return e.isAfter(t)&&e.isBefore(a)}};g._daysBetween=function(e,t){this._checkCalendarDate(e);this._checkCalendarDate(t);return Math.ceil((e.valueOf()-t.valueOf())/this.HOURS24)};g._isOutside=function(e,t,a){return!this._isBetween(e,t,a,true)};g._isSameMonthAndYear=function(e,t){this._checkCalendarDate(e);this._checkCalendarDate(t);return e.getEra()===t.getEra()&&e.getYear()===t.getYear()&&e.getMonth()===t.getMonth()};g._checkCalendarDate=function(e){if(!e||!(e instanceof t)){throw"Invalid calendar date: ["+e+"]. Expected: sap.ui.unified.calendar.CalendarDate"}};g._getWeek=function(t){this._checkCalendarDate(t);return e.getWeekByDate(t.getCalendarType(),t.getYear(),t.getMonth(),t.getDate())};g._isWeekend=function(e,t){var a=e.getDay();return a===t.getWeekendStart()||a===t.getWeekendEnd()};return g},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/CustomMonthPicker", ["sap/ui/core/Renderer","sap/ui/unified/Calendar","sap/ui/unified/CalendarRenderer","sap/ui/unified/calendar/Header","sap/ui/unified/DateRange"],function(e,t,i,r,a){"use strict";var n=e.extend(i);n.apiVersion=2;var s=t.extend("sap.ui.unified.internal.CustomMonthPicker",{metadata:{library:"sap.ui.unified"},renderer:n});s.prototype._initializeHeader=function(){var e=new r(this.getId()+"--Head",{visibleButton1:false});e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);e.attachEvent("pressButton2",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(e);e.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",e)};s.prototype.init=function(){t.prototype.init.apply(this,arguments);this.setProperty("_currentPicker","monthPicker");this._bNamesLengthChecked=true};s.prototype.onBeforeRendering=function(){var e=this.getSelectedDates(),i=this._getYearPicker().getDate(),r=this._getMonthPicker(),a,n=r&&!r._iYear;t.prototype.onBeforeRendering.apply(this,arguments);if(this._iMode===1){if(e.length&&e[0].getStartDate()&&(!i||n||e[0].getStartDate().getFullYear()===i.getFullYear())){a=e[0].getStartDate();r.setMonth(a.getMonth());r._iYear=a.getFullYear()}}};s.prototype._closePickers=function(){this.setProperty("_currentPicker","monthPicker");this._togglePrevNext(this._getFocusedDate(),true)};s.prototype._selectYear=function(){var e=this._getMonthPicker(),t=this._getYearPicker(),i=this._getFocusedDate();i.setYear(t.getDate().getFullYear());e._setYear(i.getYear());e._setDate(i);this._focusDate(i,true);this._showMonthPicker()};s.prototype._selectMonth=function(){var e=this._getMonthPicker(),t=this.getSelectedDates()[0],i=this._getFocusedDate();if(!t){t=new a}if(!e.getIntervalSelection()){i.setMonth(e.getMonth(),1);t.setStartDate(i.toLocalJSDate());this.addSelectedDate(t)}this.fireSelect()};s.prototype.onsapescape=function(e){this.fireCancel()};s.prototype._hideMonthPicker=function(){this._hideOverlay();this._togglePrevNext(this._getFocusedDate(),true);this._bActionTriggeredFromSecondHeader=false};s.prototype.setShowCurrentDateButton=function(e){return this};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/CustomYearPicker", ["sap/ui/core/Renderer","sap/ui/unified/Calendar","sap/ui/unified/CalendarRenderer","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/Header","sap/ui/unified/DateRange"],function(e,t,i,r,a,n){"use strict";var s=e.extend(i);s.apiVersion=2;var o=t.extend("sap.ui.unified.internal.CustomYearPicker",{metadata:{library:"sap.ui.unified"},renderer:s});o.prototype.init=function(){t.prototype.init.apply(this,arguments);this.setProperty("_currentPicker","yearPicker");this._bNamesLengthChecked=true};o.prototype.onBeforeRendering=function(){var e=this.getSelectedDates(),i=e.length?e[0].getStartDate():undefined,a=this._getYearPicker(),n,s;if(i){n=r.fromLocalJSDate(i);n.setMonth(0,1);s=new r(this._getFocusedDate());s.setMonth(0,1);if(s.isSame(n)){a.setDate(i)}}else{a.setProperty("_middleDate",this._getFocusedDate());a.setDate(this._getFocusedDate().toLocalJSDate())}t.prototype.onBeforeRendering.call(this,arguments)};o.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._fnYPDelegate){this.getAggregation("yearPicker").removeDelegate(this._fnYPDelegate)}};o.prototype._initializeHeader=function(){var e=new a(this.getId()+"--Head",{visibleButton1:false});e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);e.attachEvent("pressButton2",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(e);e.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",e)};o.prototype._closePickers=function(){this.setProperty("_currentPicker","yearPicker");this._togglePrevNexYearPicker()};o.prototype._selectYear=function(){var e=this.getSelectedDates()[0],t=this._getYearPicker();if(!e){e=new n}if(!t.getIntervalSelection()){e.setStartDate(this._getYearPicker().getDate());this.addSelectedDate(e)}this.fireSelect()};o.prototype.onsapescape=function(e){this.fireCancel()};o.prototype.setShowCurrentDateButton=function(e){return this};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/DatesRow", ["sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/Month","sap/ui/unified/library","./DatesRowRenderer","sap/ui/thirdparty/jquery","sap/ui/core/format/DateFormat","sap/ui/core/Locale","sap/ui/core/date/UI5Date"],function(e,t,a,r,i,jQuery,s,n,o){"use strict";var h=a.extend("sap.ui.unified.calendar.DatesRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},calendarWeekNumbering:{type:"sap.ui.core.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null}}},renderer:i});h.prototype.init=function(){a.prototype.init.apply(this,arguments);this._iColumns=1;this._aWeekNumbers=[];this._bAlwaysShowSpecialDates=true};h.prototype._setAriaRole=function(e){this._ariaRole=e;return this};h.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell"};h.prototype.setStartDate=function(a){e._checkJSDateObject(a);var r=a.getFullYear();e._checkYearInValidRange(r);this.setProperty("startDate",a);this._oStartDate=t.fromLocalJSDate(a,this.getPrimaryCalendarType());if(this.getDomRef()){var i=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(a);this._bNoRangeCheck=false;if(i&&this.checkDateFocusable(i)){this.displayDate(i)}}return this};h.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=t.fromLocalJSDate(o.getInstance(),this.getPrimaryCalendarType())}return this._oStartDate};h.prototype.setDate=function(e){if(!this._bNoRangeCheck&&!this.checkDateFocusable(e)){throw new Error("Date must be in visible date range; "+this)}a.prototype.setDate.apply(this,arguments);return this};h.prototype.displayDate=function(e){if(!this._bNoRangeCheck&&!this.checkDateFocusable(e)){throw new Error("Date must be in visible date range; "+this)}a.prototype.displayDate.apply(this,arguments);return this};h.prototype._setTopPosition=function(e){this._iTopPosition=e};h.prototype.setPrimaryCalendarType=function(e){a.prototype.setPrimaryCalendarType.apply(this,arguments);if(this._oStartDate){this._oStartDate=new t(this._oStartDate,e)}return this};h.setSecondaryCalendarType=function(e){this._bSecondaryCalendarTypeSet=true;a.prototype.setSecondaryCalendarType.apply(this,arguments);return this};h.prototype._handleBorderReached=function(e){var a=e.getParameter("event");var r=this._getRelativeInfo?this.getDays()*this._getRelativeInfo().iIntervalSize:this.getDays();var i=this._getRelativeInfo?this._getRelativeInfo().iIntervalSize:1;var s=this._getDate();var n=new t(s,this.getPrimaryCalendarType());if(a.type){switch(a.type){case"sapnext":case"sapnextmodifiers":n.setDate(n.getDate()+i);break;case"sapprevious":case"sappreviousmodifiers":n.setDate(n.getDate()-i);break;case"sappagedown":n.setDate(n.getDate()+r);break;case"sappageup":n.setDate(n.getDate()-r);break;default:break}this.fireFocus({date:n.toLocalJSDate(),otherMonth:true,_outsideBorder:true})}};h.prototype.checkDateFocusable=function(a){e._checkJSDateObject(a);if(this._bNoRangeCheck){return false}var r=this._getStartDate();var i=new t(r,this.getPrimaryCalendarType());var s=this.getDays();if(this._getRelativeInfo&&this._getRelativeInfo().bIsRelative){s=this.getDays()*this._getRelativeInfo().iIntervalSize}i.setDate(i.getDate()+s);var n=t.fromLocalJSDate(a,this.getPrimaryCalendarType());return n.isSameOrAfter(r)&&n.isBefore(i)};h.prototype._renderHeader=function(){var e=this._getStartDate();var t=e.getDay();var a=this._getLocaleData();var r=this.$("Names").children();var i=[];if(this._bLongWeekDays||!this._bNamesLengthChecked){i=a.getDaysStandAlone("abbreviated")}else{i=a.getDaysStandAlone("narrow")}var s=a.getDaysStandAlone("wide");var n=0;for(n=0;n<r.length;n++){var o=jQuery(r[n]);o.text(i[(n+t)%7]);o.attr("aria-label",s[(n+t)%7])}if(this._getShowHeader()){var h=this.$("Head");if(h.length>0){var p=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(p,this,a,e);p.flush(h[0]);p.destroy()}}};h.prototype._getFirstWeekDay=function(){return this._getStartDate().getDay()};h.prototype.getWeekNumbers=function(){var e=this.getDays(),a=this._getLocale(),r=this.getPrimaryCalendarType(),i=this._getStartDate(),o=new t(i,r),h=new t(i,r).setDate(o.getDate()+e),p=[];while(o.isBefore(h)){p.push(new t(o,r));o.setDate(o.getDate()+1)}this._aWeekNumbers=p.reduce(function(e,t){var r=s.getInstance({pattern:"w",calendarType:this.getPrimaryCalendarType(),calendarWeekNumbering:this.getCalendarWeekNumbering()},new n(a));var i=Number(r.format(t.toUTCJSDate(),true));if(!e.length||e[e.length-1].number!==i){e.push({len:0,number:i})}e[e.length-1].len++;return e}.bind(this),[]);return this._aWeekNumbers};h.prototype._getCachedWeekNumbers=function(){return this._aWeekNumbers};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/DatesRowRenderer", ["sap/ui/core/Renderer","sap/ui/unified/calendar/CalendarDate","./MonthRenderer","sap/ui/core/CalendarType"],function(e,a,t,r){"use strict";var n=e.extend(t);n.apiVersion=2;n.getStartDate=function(e){return e._getStartDate()};n.getClass=function(e,a){var t=["sapUiCalDatesRow","sapUiCalRow"];if(!a.getShowDayNamesLine()){t.push("sapUiCalNoNameLine")}return t};n.addWrapperAdditionalStyles=function(e,a){if(a._iTopPosition){e.style("top",a._iTopPosition+"px")}};n.renderMonth=function(e,a,r){if(a.isRelative&&a.isRelative()){n.renderCustomIntervals(e,a)}else{t.renderMonth.apply(this,arguments);this.renderWeekNumbers(e,a)}};n.renderCustomIntervals=function(e,a){var t;e.openStart("div",a.getId()+"-customintervals");e.openEnd();var r=a.getDays();t=100/r;var n=a._getRelativeInfo()._getIndexFromDate(a.getStartDate());for(var i=0;i<r;i++){e.openStart("div");e.class("sapUiCalItem");if(a._getRelativeInfo&&a._getRelativeInfo().bIsRelative){e.class("sapUiRelativeCalItem");e.attr("data-sap-ui-index",n+i);e.attr("tabindex","-1");var s=a._getRelativeInfo()._getDateFromIndex(n+i+1);e.attr("data-sap-day",a._oFormatYyyymmdd.format(s,true))}e.style("width",t+"%");e.openEnd();e.openStart("span");e.class("sapUiCalItemText");e.openEnd();e.text(a._getRelativeInfo?a._getRelativeInfo().intervalLabelFormatter(n+i):n+i);e.close("span");e.close("div")}e.close("div")};n.renderWeekNumbers=function(e,a){var t,n,i,s;if(a.getShowWeekNumbers()&&a.getPrimaryCalendarType()===r.Gregorian){t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");e.openStart("div",a.getId()+"-weeks");e.class("sapUiCalRowWeekNumbers");e.openEnd();n=a.getDays();i=100/n;s=a.getWeekNumbers();s.forEach(function(r){e.openStart("div",a.getId()+"-week-"+r.number+"-text");e.class("sapUiCalRowWeekNumber");e.style("width",r.len*i+"%");e.attr("data-sap-ui-week",r.number);e.openEnd();e.text(t.getText("CALENDAR_DATES_ROW_WEEK_NUMBER",[r.number]));e.close("div")});e.close("div")}};n.renderDummyCell=function(){};n.renderHeader=function(e,a,t){var r=a._getLocaleData();var n=a.getId();var i=a.getDays();var s="";if(a._getShowHeader()){e.openStart("div",n+"-Head");e.openEnd();this.renderHeaderLine(e,a,r,t);e.close("div")}s=100/i+"%";if(a.getShowDayNamesLine()){e.openStart("div",n+"-Names");e.style("display","inline");e.attr("role","row");e.openEnd();this.renderDayNames(e,a,r,t.getDay(),i,false,s);e.close("div")}};n.renderHeaderLine=function(e,t,r,n){var i=t.getId();var s=t.getDays();var o=new a(n,t.getPrimaryCalendarType());var d="";var l=0;var v=[];var p=0;for(p=0;p<s;p++){l=o.getMonth();if(v.length>0&&v[v.length-1].iMonth==l){v[v.length-1].iDays++}else{v.push({iMonth:l,iDays:1})}o.setDate(o.getDate()+1)}var g=r.getMonthsStandAlone("wide",t.getPrimaryCalendarType());for(p=0;p<v.length;p++){var u=v[p];d=100/s*u.iDays+"%";e.openStart("div",i+"-Head"+p);e.class("sapUiCalHeadText");e.style("width",d);e.openEnd();e.text(g[u.iMonth]);e.close("div")}};n.renderDays=function(e,t,r){var n=t.getDays();var i=100/n+"%";var s=t.getShowDayNamesLine();var o=t.getPrimaryCalendarType();if(!r){r=t._getFocusedDate()}var d=this.getDayHelper(t,r);if(!s){if(t._bLongWeekDays||!t._bNamesLengthChecked){d.aWeekDays=d.oLocaleData.getDaysStandAlone("abbreviated",o)}else{d.aWeekDays=d.oLocaleData.getDaysStandAlone("narrow",o)}d.aWeekDaysWide=d.oLocaleData.getDaysStandAlone("wide",o)}var l=new a(r,o);e.openStart("div");e.attr("role","row");e.openEnd();for(var v=0;v<n;v++){this.renderDay(e,t,l,d,false,false,v,i,!s);l.setDate(l.getDate()+1)}e.close("div")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/Header", ["sap/ui/core/Control","sap/ui/unified/library","./HeaderRenderer","sap/ui/dom/containsOrEquals"],function(t,e,i,n){"use strict";var r=t.extend("sap.ui.unified.calendar.Header",{metadata:{library:"sap.ui.unified",properties:{textButton0:{type:"string",group:"Appearance"},additionalTextButton0:{type:"string",group:"Appearance"},ariaLabelButton0:{type:"string",group:"Misc"},visibleButton0:{type:"boolean",group:"Appearance",defaultValue:false},textButton1:{type:"string",group:"Appearance"},additionalTextButton1:{type:"string",group:"Appearance"},ariaLabelButton1:{type:"string",group:"Misc"},visibleButton1:{type:"boolean",group:"Appearance",defaultValue:true},textButton2:{type:"string",group:"Appearance"},additionalTextButton2:{type:"string",group:"Appearance"},ariaLabelButton2:{type:"string",group:"Misc"},visibleButton2:{type:"boolean",group:"Appearance",defaultValue:true},enabledPrevious:{type:"boolean",group:"Behavior",defaultValue:true},enabledNext:{type:"boolean",group:"Behavior",defaultValue:true},visibleCurrentDateButton:{type:"boolean",group:"Appearance",defaultValue:false}},events:{pressPrevious:{},pressNext:{},pressCurrentDate:{},pressButton0:{},pressButton1:{},pressButton2:{}}},renderer:i});r.prototype._setVisibleButton3=function(t){this._visibleButton3=t;this.invalidate();return this};r.prototype._getVisibleButton3=function(){return this._visibleButton3};r.prototype._setTextButton3=function(t){o.call(this,3,t);return this};r.prototype._getTextButton3=function(){return this._textButton3};r.prototype._setAdditionalTextButton3=function(t){s.call(this,3,t);return this};r.prototype._getAdditionalTextButton3=function(){return this._additionalTextButton3};r.prototype._setAriaLabelButton3=function(t){u.call(this,3,t);return this};r.prototype._getAriaLabelButton3=function(){return this._ariaLabelButton3};r.prototype._setVisibleButton4=function(t){this._visibleButton4=t;this.invalidate();return this};r.prototype._getVisibleButton4=function(){return this._visibleButton4};r.prototype._setTextButton4=function(t){o.call(this,4,t);return this};r.prototype._getTextButton4=function(){return this._textButton4};r.prototype._setAdditionalTextButton4=function(t){s.call(this,4,t);return this};r.prototype._getAdditionalTextButton4=function(){return this._additionalTextButton4};r.prototype._setAriaLabelButton4=function(t){u.call(this,4,t);return this};r.prototype._getAriaLabelButton4=function(){return this._ariaLabelButton4};r.prototype.onclick=function(t){if(t.isMarked("delayedMouseEvent")){return}if(n(this.getDomRef("prev"),t.target)&&this.getEnabledPrevious()){this.firePressPrevious()}else if(n(this.getDomRef("next"),t.target)&&this.getEnabledNext()){this.firePressNext()}else if(n(this.getDomRef("today"),t.target)&&this.getVisibleCurrentDateButton()){this.firePressCurrentDate()}else if(n(this.getDomRef("B0"),t.target)){this.firePressButton0()}else if(n(this.getDomRef("B1"),t.target)){this.firePressButton1()}else if(n(this.getDomRef("B2"),t.target)){this.firePressButton2()}else if(n(this.getDomRef("B3"),t.target)){this.fireEvent("pressButton3")}else if(n(this.getDomRef("B4"),t.target)){this.fireEvent("pressButton4")}};r.prototype.onsapnext=function(t){t.preventDefault()};function o(t,e){this["_textButton"+t]=e;if(this.isActive()&&this["_getVisibleButton"+t]()){if(this.$("B"+t+"-Text").get(0)){this.$("B"+t+"-Text").text(e)}else{this.$("B"+t).text(e)}}}function s(t,e){var i=false;var n=this["_getAdditionalTextButton"+t]();if(n==e){return}if(!n&&e||n&&!e){i=true}this["_additionalTextButton"+t]=e;if(!i&&this.isActive()&&this["_getVisibleButton"+t]()){this.$("B"+t+"-AddText").text(e)}if(i){this.invalidate()}}function u(t,e){this["_ariaLabelButton"+t]=e;if(this.isActive()&&this["_getVisibleButton"+t]()){if(e){this.$("B"+t).attr("aria-label",e)}else{this.$("B"+t).removeAttr("aria-label")}}}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/HeaderRenderer", ["sap/ui/core/Configuration"],function(t){"use strict";var e=5;var a={apiVersion:2};a.render=function(a,i){var n=t.getLocale().getLanguage();var s=i.getTooltip_AsString();var l=i.getId();var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var r=o.getText("CALENDAR_BTN_NEXT");var u=o.getText("CALENDAR_BTN_PREV");var d=o.getText("CALENDAR_BTN_TODAY");a.openStart("div",i);a.class("sapUiCalHead");if(i.getVisibleCurrentDateButton()){a.class("sapUiCalHeaderWithTodayButton")}if(s){a.attr("title",s)}a.accessibilityState(i);a.openEnd();a.openStart("button",l+"-prev");a.attr("title",u);a.accessibilityState(null,{label:u});a.class("sapUiCalHeadPrev");if(!i.getEnabledPrevious()){a.class("sapUiCalDsbl");a.attr("disabled","disabled")}a.attr("tabindex","-1");a.openEnd();a.icon("sap-icon://slim-arrow-left",null,{title:null});a.close("button");var c=-1;var b=-1;var g=0;var B;for(g=0;g<e;g++){if(this.getVisibleButton(i,g)){if(c<0){c=g}b=g}}for(g=0;g<e;g++){if(n.toLowerCase()==="ja"||n.toLowerCase()==="zh"){B=e-1-g;if(this._isTwoMonthsCalendar(i)){switch(g){case 0:B=2;break;case 2:B=4;break;case 1:B=1;break;case 3:B=3;break}}}else{B=g}if(this._isTwoMonthsCalendar(i)){c=2;b=3}this.renderCalendarButtons(a,i,l,c,b,B)}if(!i.getVisibleButton0()&&!i.getVisibleButton1()&&!i.getVisibleButton2()&&!i._getVisibleButton3()&&!i._getVisibleButton4()){a.openStart("div",l+"-B"+"-Placeholder");a.class("sapUiCalHeadBPlaceholder");a.openEnd();a.close("span")}a.openStart("button",l+"-next");a.attr("title",r);a.accessibilityState(null,{label:r});a.class("sapUiCalHeadNext");if(!i.getEnabledNext()){a.class("sapUiCalDsbl");a.attr("disabled","disabled")}a.attr("tabindex","-1");a.openEnd();a.icon("sap-icon://slim-arrow-right",null,{title:null});a.close("button");if(i.getVisibleCurrentDateButton()){a.openStart("button",l+"-today");a.attr("title",d);a.accessibilityState(null,{label:d});a.class("sapUiCalHeadB");a.class("sapUiCalHeadToday");a.openEnd();a.icon("sap-icon://appointment",null,{title:null});a.close("button")}a.close("div")};a.renderCalendarButtons=function(t,e,a,i,n,s){var l={};if(this.getVisibleButton(e,s)){t.openStart("button",a+"-B"+s);t.class("sapUiCalHeadB");t.class("sapUiCalHeadB"+s);if(i===s){t.class("sapUiCalHeadBFirst")}if(n===s){t.class("sapUiCalHeadBLast")}if(this.getAriaLabelButton(e,s)){l["label"]=this.getAriaLabelButton(e,s)}t.accessibilityState(null,l);l={};t.openEnd();var o=this.getTextButton(e,s)||"";var r=this.getAdditionalTextButton(e,s)||"";if(r){t.openStart("span",a+"-B"+s+"-Text");t.class("sapUiCalHeadBText");t.openEnd();t.text(o);t.close("span");t.openStart("span",a+"-B"+s+"-AddText");t.class("sapUiCalHeadBAddText");t.openEnd();t.text(r);t.close("span")}else{t.text(o)}t.close("button")}};a.getVisibleButton=function(t,e){var a=false;if(t["getVisibleButton"+e]){a=t["getVisibleButton"+e]()}else if(t["_getVisibleButton"+e]){a=t["_getVisibleButton"+e]()}return a};a.getAriaLabelButton=function(t,e){var a;if(t["getAriaLabelButton"+e]){a=t["getAriaLabelButton"+e]()}else if(t["_getAriaLabelButton"+e]){a=t["_getAriaLabelButton"+e]()}return a};a.getTextButton=function(t,e){var a;if(t["getTextButton"+e]){a=t["getTextButton"+e]()}else if(t["_getTextButton"+e]){a=t["_getTextButton"+e]()}return a};a.getAdditionalTextButton=function(t,e){var a;if(t["getAdditionalTextButton"+e]){a=t["getAdditionalTextButton"+e]()}else if(t["_getAdditionalTextButton"+e]){a=t["_getAdditionalTextButton"+e]()}return a};a._isTwoMonthsCalendar=function(t){return t.getParent()instanceof sap.ui.unified.Calendar&&t.getParent().getMonths()>=2};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/IndexPicker", ["sap/ui/core/Control","sap/ui/unified/calendar/Header","sap/ui/unified/calendar/IndexPickerRenderer","sap/ui/core/delegate/ItemNavigation","sap/ui/events/KeyCodes"],function(e,t,i,a,n){"use strict";var s=e.extend("sap.ui.unified.calendar.IndexPicker",{metadata:{library:"sap.ui.unified",properties:{startIndex:{type:"int",group:"Data",defaultValue:0},selectedIndex:{type:"int",group:"Data",defaultValue:0},formatter:{type:"object",group:"Data"},rows:{type:"int",group:"Data",defaultValue:4},columns:{type:"int",group:"Data",defaultValue:3},periodSize:{type:"int",group:"Data",defaultValue:1}},aggregations:{header:{type:"sap.ui.unified.calendar.Header",multiple:false}},events:{select:{},focus:{}}},renderer:i});s.prototype.init=function(){this._initializeHeader();this.iCurrentIndex=0};s.prototype.onBeforeRendering=function(){this.getHeader().setEnabledPrevious(this.getStartIndex()>0)};s.prototype.onAfterRendering=function(){r.call(this)};s.prototype._initializeHeader=function(){var e=new t(this.getId()+"--Head",{visibleButton1:false,visibleButton2:false});e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",e)};s.prototype._handlePrevious=function(){this.goToPreviousPage()};s.prototype.goToPreviousPage=function(){var e=this.getStartIndex()-this.getRows()*this.getColumns();e=Math.max(0,e);this.setStartIndex(e)};s.prototype._handleNext=function(){this.goToNextPage()};s.prototype.goToNextPage=function(){var e=this.getStartIndex()+this.getRows()*this.getColumns();this.setStartIndex(e)};s.prototype.onmouseup=function(e){var t=e.target.getAttribute("data-sap-ui-index");if(!t){return}this._selectIndex(parseInt(t))};s.prototype.onkeydown=function(e){if(e.keyCode===n.ENTER){var t=e.target.getAttribute("data-sap-ui-index");if(!t){return}this._selectIndex(parseInt(t))}};s.prototype.onkeyup=function(e){if(e.keyCode===n.SPACE){e.preventDefault();var t=e.target.getAttribute("data-sap-ui-index");if(!t){return}this._selectIndex(parseInt(t))}};s.prototype._selectIndex=function(e){this.setSelectedIndex(e);this.iCurrentIndex=0;this.fireSelect({index:e})};s.prototype._getFormatter=function(){return this.getFormatter()||o};function o(e){return(e+1).toString()}function r(){var e=0,t=false,i=this.getDomRef(),n=i.querySelectorAll(".sapMIPItem"),s=this.getColumns();for(var o=0;o<n.length;o++){if(n[o].getAttribute("data-sap-ui-index")===this.getSelectedIndex()){e=o;t=true;break}}if(!this._oItemNavigation){this._oItemNavigation=new a;this._oItemNavigation.attachEvent(a.Events.AfterFocus,u,this);this._oItemNavigation.attachEvent(a.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(s>1){this._oItemNavigation.setHomeEndColumnMode(true,true)}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(s,true)}this._oItemNavigation.setRootDomRef(i);this._oItemNavigation.setItemDomRefs(n);if(!t){e=this.iCurrentIndex%n.length}this._oItemNavigation.setFocusedIndex(e);this._oItemNavigation.focusItem(e);this._oItemNavigation.setPageSize(n.length)}function u(e){var t=e.getParameter("index");var i=e.getParameter("event");if(!i){return}var a=e.getParameter("index");var n=this._oItemNavigation.getItemDomRefs();var s=n[t];this.iCurrentIndex=a;a=s.getAttribute("data-sap-ui-index");this.fireFocus({index:a})}s.prototype._handleBorderReached=function(e){var t=e.getParameter("event");var i=parseInt(t.target.getAttribute("data-sap-ui-index"));var a=e.getParameter("index");if(t.type){switch(t.type){case"sapnext":case"sapnextmodifiers":if(t.keyCode===n.ARROW_DOWN){i+=this.getColumns();a+=this.getColumns()}else{i+=1;a+=1}this.goToNextPage();break;case"sapprevious":case"sappreviousmodifiers":if(t.keyCode===n.ARROW_UP){i-=this.getColumns();a-=this.getColumns()}else{i-=1;a-=1}this.goToPreviousPage();break;default:break}var s=this._oItemNavigation.getItemDomRefs();a=Math.abs(s.length-Math.abs(a));this.iCurrentIndex=a;this._oItemNavigation.focusItem(s[a]);this.fireFocus({index:i})}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/IndexPickerRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var s,a={role:"gridcell",selected:false,label:"",describedby:""};e.openStart("div",t);e.class("sapMIP");e.openEnd();var l=t.getAggregation("header");e.renderControl(l);e.openStart("div");e.class("sapMIPContent");e.attr("role","grid");e.openEnd();for(var d=0;d<t.getRows();d++){e.openStart("div",t.getId()+"-"+d);e.class("sapMIPRow");e.attr("role","row");e.openEnd();var r=t.getSelectedIndex()+t.getPeriodSize()-1;for(var i=0;i<t.getColumns();i++){s=t.getStartIndex()+t.getColumns()*d+i;e.openStart("div");e.class("sapMIPItem");if(s===t.getSelectedIndex()){e.class("sapUiCalItemSel");e.class("sapUiCalItemSelStart");a["selected"]=true;a["describedby"]=a["describedby"]+" "+t.sId+"-Start"}else if(s===r){e.class("sapUiCalItemSel");e.class("sapUiCalItemSelEnd");a["selected"]=true;a["describedby"]=a["describedby"]+" "+t.sId+"-End"}else if(s>t.getSelectedIndex()&&s<r){e.class("sapUiCalItemSel");e.class("sapUiCalItemSelBetween");a["selected"]=true}else{a["selected"]=false}e.accessibilityState(null,a);e.class("sapUiCalItem");e.class("customWidth");e.attr("tabindex","-1");e.attr("data-sap-ui-index",s);e.openEnd();e.text(t._getFormatter()(s));e.close("div")}e.close("div")}e.close("div");e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/Month", ["sap/ui/core/Control","sap/ui/Device","sap/ui/core/LocaleData","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/DateRange","sap/ui/unified/DateTypeRange","sap/ui/unified/library","sap/ui/core/format/DateFormat","sap/ui/core/library","sap/ui/core/Locale","./MonthRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/core/InvisibleMessage","sap/ui/core/Configuration","sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/date/CalendarUtils","sap/ui/core/date/UI5Date","sap/base/Log"],function(e,t,a,i,s,r,o,n,l,h,g,d,u,c,p,jQuery,f,y,D,_,m,v){"use strict";var S=g.InvisibleMessageMode;var C=g.CalendarType;var b=l.CalendarDayType;var M=e.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true},_focusedDate:{type:"object",group:"Data",visibility:"hidden",defaultValue:null},calendarWeekNumbering:{type:"sap.ui.core.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}},renderer:u});M.prototype.init=function(){this._mouseMoveProxy=this._handleMouseMove.bind(this);this._iColumns=7;this._oMinDate=s._minDate(this._getPrimaryCalendarType());this._oMaxDate=s._maxDate(this._getPrimaryCalendarType());this._aVisibleDays=[];this._bAlwaysShowSpecialDates=false;this._oUnifiedRB=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified")};M.prototype._getAriaRole=function(){return"gridcell"};M.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth)}this._aVisibleDays=null;this._bAlwaysShowSpecialDates=null};M.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()]};M.prototype.onBeforeRendering=function(){this._oFormatYyyymmdd=h.getInstance({pattern:"yyyyMMdd",calendarType:C.Gregorian});this._oFormatLong=h.getInstance({style:"long",calendarType:this._getPrimaryCalendarType()});if(this.getFirstDayOfWeek()!==-1&&this.getCalendarWeekNumbering()!=="Default"){v.warning("Both properties firstDayOfWeek and calendarWeekNumbering should not be used at the same time!")}};M.prototype.onAfterRendering=function(){this.bSpaceButtonPressed=false;T.call(this);P.call(this);this._oInvisibleMessage=f.getInstance()};M.prototype.onmouseover=function(e){var t=jQuery(e.target),a=this.getSelectedDates()[0],i,s;if(!this._isMarkingUnfinishedRangeAllowed()){return}if(!t.hasClass("sapUiCalItemText")&&!t.hasClass("sapUiCalItem")){return}if(t.hasClass("sapUiCalItemText")){t=t.parent()}i=parseInt(this._oFormatYyyymmdd.format(a.getStartDate()));s=t.data("sapDay");if(this.hasListeners("datehovered")){this.fireEvent("datehovered",{date1:i,date2:s})}else{this._markDatesBetweenStartAndHoveredDate(i,s)}};M.prototype._markDatesBetweenStartAndHoveredDate=function(e,t){var a,i,s,r;a=this.$().find(".sapUiCalItem");if(e>t){e=e+t;t=e-t;e=e-t}for(r=0;r<a.length;r++){i=jQuery(a[r]);s=i.data("sapDay");if(s>e&&s<t&&this._isInAllowedRange(s)){i.addClass("sapUiCalItemSelBetween")}else{i.removeClass("sapUiCalItemSelBetween");if(s!=e&&s!=t){i.removeClass("sapUiCalItemSel")}}}};M.prototype._isInAllowedRange=function(e){return this._oFormatYyyymmdd.parse(e).getTime()>this._oMinDate.toLocalJSDate().getTime()&&this._oFormatYyyymmdd.parse(e).getTime()<this._oMaxDate.toLocalJSDate().getTime()};M.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!c(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(true);var t=this._selectDay(this._getDate());if(!t&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate)}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;w.call(this)}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this)}}};M.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};M.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};M.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};M.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};M.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("disabledDates");return e};M.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("disabledDates");return e};M.prototype.setDate=function(e){if(e){var t=r.fromLocalJSDate(e,this._getPrimaryCalendarType());I.call(this,t)}return this.setProperty("date",e)};M.prototype._getDate=function(){if(!this._oDate){this._oDate=r.fromLocalJSDate(m.getInstance(),this._getPrimaryCalendarType())}return this._oDate};M.prototype.displayDate=function(e){var t=r.fromLocalJSDate(e,this._getPrimaryCalendarType());I.call(this,t);return this};M.prototype.setPrimaryCalendarType=function(e){this.setProperty("primaryCalendarType",e);this._oFormatLong=h.getInstance({style:"long",calendarType:e});if(this._oDate){this._oDate=new r(this._oDate,e)}return this};M.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);this._oFormatSecondaryLong=h.getInstance({style:"long",calendarType:e});return this};M.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};M.prototype._getLocale=function(){var e=this.getParent();if(e&&e.getLocale){return e.getLocale()}else if(!this._sLocale){this._sLocale=y.getFormatSettings().getFormatLocale().toString()}return this._sLocale};M.prototype._getLocaleData=function(){var e=this.getParent();if(e&&e._getLocaleData){return e._getLocaleData()}else if(!this._oLocaleData){var t=this._getLocale();var i=new d(t);this._oLocaleData=a.getInstance(i)}return this._oLocaleData};M.prototype._getFormatLong=function(){var e=this._getLocale();if(this._oFormatLong.oLocale.toString()!==e){var t=new d(e);this._oFormatLong=h.getInstance({style:"long",calendarType:this._getPrimaryCalendarType()},t);if(this._oFormatSecondaryLong){this._oFormatSecondaryLong=h.getInstance({style:"long",calendarType:this._getSecondaryCalendarType()},t)}}return this._oFormatLong};M.prototype.getIntervalSelection=function(){var e=this.getParent();if(e&&e.getIntervalSelection){return e.getIntervalSelection()}else{return this.getProperty("intervalSelection")}};M.prototype.getSingleSelection=function(){var e=this.getParent();if(e&&e.getSingleSelection){return e.getSingleSelection()}else{return this.getProperty("singleSelection")}};M.prototype.getSelectedDates=function(){var e=this.getParent();if(e&&e.getSelectedDates){return e.getSelectedDates()}else{return this.getAggregation("selectedDates",[])}};M.prototype.getSpecialDates=function(){var e=this.getParent();if(e&&e.getSpecialDates){return e.getSpecialDates()}else{return this.getAggregation("specialDates",[])}};M.prototype.getDisabledDates=function(){var e=this.getParent();if(e&&e.getDisabledDates){return e.getDisabledDates()}else{return this.getAggregation("disabledDates",[])}};M.prototype.getPrimaryCalendarType=function(){var e=this.getParent();if(e&&e.getPrimaryCalendarType){return e.getPrimaryCalendarType()}return this.getProperty("primaryCalendarType")};M.prototype._getPrimaryCalendarType=function(){var e=this.getParent();if(e&&e._getPrimaryCalendarType){return e._getPrimaryCalendarType()}return this.getProperty("primaryCalendarType")||y.getCalendarType()};M.prototype._getShowHeader=function(){var e=this.getParent();if(e&&e._getShowMonthHeader){return e._getShowMonthHeader()}else{return this.getProperty("showHeader")}};M.prototype.getAriaLabelledBy=function(){var e=this.getParent();if(e&&e.getAriaLabelledBy){return e.getAriaLabelledBy()}else{return this.getAssociation("ariaLabelledBy",[])}};M.prototype.getLegend=function(){var e=this.getParent();if(e&&e.getLegend){return e.getLegend()}else{return this.getAssociation("legend",[])}};M.prototype._getFirstDayOfWeek=function(){var e=this.getParent();var t=0;if(e&&e.getFirstDayOfWeek){t=e.getFirstDayOfWeek()}else{t=this.getProperty("firstDayOfWeek")}if(t<0||t>6){var a=_.getWeekConfigurationValues(this.getCalendarWeekNumbering(),new d(this._getLocale()));if(a){t=a.firstDayOfWeek}else{var i=this._getLocaleData();t=i.getFirstDayOfWeek()}}return t};M.prototype._getNonWorkingDays=function(){var e=this.getParent();var t;if(e&&e.getNonWorkingDays){t=e.getNonWorkingDays()}else{t=this.getProperty("nonWorkingDays")}if(t&&!Array.isArray(t)){t=[]}return t};M.prototype._isSpecialDateMarkerEnabled=function(e){var t;if(this.getStartDate){t=this.getStartDate()}else if(this.getDate()){t=this.getDate()}else{t=m.getInstance()}return this._bAlwaysShowSpecialDates||s._isSameMonthAndYear(e,r.fromLocalJSDate(t))};M.prototype._checkDateSelected=function(e){s._checkCalendarDate(e);var t=0,a=this.getSelectedDates(),i=this._getPrimaryCalendarType(),o=0,n=this.getProperty("_focusedDate"),l=false,h=this.getParent(),g=this._bCalendar&&h.getMonths(),d,u;for(o=0;o<a.length;o++){var c=a[o],p=c.getStartDate()?r.fromLocalJSDate(c.getStartDate(),i):undefined,f=c.getEndDate()?r.fromLocalJSDate(c.getEndDate(),i):undefined;if(p&&f){u=this._arrangeStartAndEndDates(p,f);p=u.startDate;f=u.endDate}d=n&&p&&g===1&&n.getMonth()!==p.getMonth();l=this._isMarkingUnfinishedRangeAllowed()&&n&&!d&&(s._isBetween(e,p,n,true)||s._isBetween(e,n,p,true));if(p&&!f&&e.isSame(p)){t=1;break}else if(f&&e.isSame(p)){t=2;if(e.isSame(f)){t=5}break}else if(f&&e.isSame(f)){t=3;break}else if(f&&e.isAfter(p)&&e.isBefore(f)||l){t=4;break}if(this.getSingleSelection()){break}}return t};M.prototype._getDateTypes=function(e){s._checkCalendarDate(e);var t,a,i,r=[];var o=this._getSpecialDates();var n=e.toUTCJSDate().getTime();var l=m.getInstance(Date.UTC(0,0,1));for(var h=0;h<o.length;h++){var g=o[h];var d=g.getStartDate();var u=s.MAX_MILLISECONDS;if(d){l.setUTCFullYear(d.getFullYear(),d.getMonth(),d.getDate());u=l.getTime()}var c=g.getEndDate();var p=-s.MAX_MILLISECONDS;if(c){l.setUTCFullYear(c.getFullYear(),c.getMonth(),c.getDate());p=l.getTime()}i=g.getType()===b.NonWorking;if(n===u&&!c||n>=u&&n<=p){if(!i&&!t){t={type:g.getType(),tooltip:g.getTooltip_AsString(),color:g.getColor()};r.push(t)}else if(i&&!a){a={type:g.getType(),tooltip:g.getTooltip_AsString()};r.push(a)}if(t&&a){break}}}return r};M.prototype._checkDateEnabled=function(e){s._checkCalendarDate(e);var t=true;var a=this.getDisabledDates();var i=e.toUTCJSDate().getTime();var o=this._getPrimaryCalendarType();var n=this.getParent();if(n&&n._oMinDate&&n._oMaxDate){if(i<n._oMinDate.valueOf()||i>n._oMaxDate.valueOf()){return false}}for(var l=0;l<a.length;l++){var h=a[l];var g=h.getStartDate();var d=0;if(g){g=r.fromLocalJSDate(g,o);d=g.toUTCJSDate().getTime()}var u=h.getEndDate();var c=0;if(u){u=r.fromLocalJSDate(u,o);c=u.toUTCJSDate().getTime()}if(u){if(i>d&&i<c){t=false;break}}else if(i===d){t=false;break}}return t};M.prototype._handleMouseMove=function(e){if(!this.$().is(":visible")){this._unbindMousemove(true)}var t=jQuery(e.target);if(t.hasClass("sapUiCalItemText")){t=t.parent()}if(this._sLastTargetId&&this._sLastTargetId===t.attr("id")){return}this._sLastTargetId=t.attr("id");if(t.hasClass("sapUiCalItem")){var a=this._getDate();if(c(this.getDomRef(),e.target)){var i=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(t.attr("data-sap-day")),this._getPrimaryCalendarType());if(!i.isSame(a)){this._oDate=i;var s=this._selectDay(i,true);if(s){this._oMoveSelectedDate=new r(i,this._getPrimaryCalendarType())}this._bMoveChange=true}}}};M.prototype.onmousedown=function(e){this._oMousedownPosition={clientX:e.clientX,clientY:e.clientY};if(e.button||t.support.touch||!this._isWeekSelectionAllowed()||!e.target.classList.contains("sapUiCalWeekNum")){return}var a=jQuery(e.target),i=a.siblings().eq(0).attr("data-sap-day"),s=this._oFormatYyyymmdd.parse(i),o=r.fromLocalJSDate(s,this._getPrimaryCalendarType());this._handleWeekSelection(o,true)};M.prototype.onmouseup=function(e){var a=e.button!==2;if(this._bMouseMove){this._unbindMousemove(true);var i=this._getDate();var s=this._oItemNavigation.getItemDomRefs();for(var r=0;r<s.length;r++){var o=jQuery(s[r]);if(!o.hasClass("sapUiCalItemOtherMonth")){if(o.attr("data-sap-day")===this._oFormatYyyymmdd.format(i.toUTCJSDate(),true)){o.trigger("focus");break}}}if(this._bMoveChange){var n=this._selectDay(i);if(!n&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate)}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;w.call(this)}}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this)}else if(t.support.touch&&a&&this._areMouseEventCoordinatesInThreshold(e.clientX,e.clientY,10)){var l=e.target.classList,h=l.contains("sapUiCalItemText")||l.contains("sapUiCalDayName"),g=l.contains("sapUiCalWeekNum"),d=this._getSelectedDateFromEvent(e);if(g&&this._isWeekSelectionAllowed()){this._handleWeekSelection(d,true)}else if(h&&e.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(d)}else if(h){this._selectDay(d,false,false);w.call(this)}}};M.prototype.onsapselect=function(e){var t=this.getParent();if(this.bSpaceButtonPressed){return}if(t&&t._isMultiDatesSelectionHeaderAllowed&&!t._isMultiDatesSelectionHeaderAllowed()){return}var a=this._selectDay(this._getSelectedDateFromEvent(e));if(a){w.call(this)}e.stopPropagation();e.preventDefault()};M.prototype.onkeydown=function(e){if(e.which===p.SPACE){this.bSpaceButtonPressed=true}};M.prototype.onkeyup=function(e){if(e.which===p.SPACE){this.bSpaceButtonPressed=false}};M.prototype.onsapselectmodifiers=function(e){var t=this._getSelectedDateFromEvent(e),a,i=this.getParent();if(this._isWeekSelectionAllowed()&&e.shiftKey&&e.keyCode===p.SPACE){if(i&&i._isMultiDatesSelectionHeaderAllowed&&!i._isMultiDatesSelectionHeaderAllowed()){return}a=s._getFirstDateOfWeek(t);this._handleWeekSelection(a,false)}else if(this._isConsecutiveDaysSelectionAllowed()&&e.shiftKey&&e.keyCode===p.ENTER){this._handleConsecutiveDaysSelection(t)}e.preventDefault()};M.prototype.onsappageupmodifiers=function(e){var t=new r(this._getDate(),this._getPrimaryCalendarType());var a=t.getYear();if(e.metaKey||e.ctrlKey){t.setYear(a-10)}else{t.setYear(a-1)}this.fireFocus({date:t.toLocalJSDate(),otherMonth:true});e.preventDefault()};M.prototype.onsappagedownmodifiers=function(e){var t=new r(this._getDate(),this._getPrimaryCalendarType());var a=t.getYear();if(e.metaKey||e.ctrlKey){t.setYear(a+10)}else{t.setYear(a+1)}this.fireFocus({date:t.toLocalJSDate(),otherMonth:true});e.preventDefault()};M.prototype._isValueInThreshold=function(e,t,a){var i=e-a,s=e+a;return t>=i&&t<=s};M.prototype._areMouseEventCoordinatesInThreshold=function(e,t,a){return this._oMousedownPosition&&this._isValueInThreshold(this._oMousedownPosition.clientX,e,a)&&this._isValueInThreshold(this._oMousedownPosition.clientY,t,a)?true:false};M.prototype._bindMousemove=function(e){jQuery(window.document).on("mousemove",this._mouseMoveProxy);this._bMouseMove=true;if(e){this.fireEvent("_bindMousemove")}};M.prototype._unbindMousemove=function(e){jQuery(window.document).off("mousemove",this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(e){this.fireEvent("_unbindMousemove")}};M.prototype.onThemeChanged=function(){if(this._bNoThemeChange||!this.getDomRef()){return}var e=this.getDomRef().querySelectorAll(".sapUiCalWH:not(.sapUiCalDummy)"),t=this._getLocaleData(),a=this._getFirstWeekDay(),i=t.getDaysStandAlone("abbreviated",this._getPrimaryCalendarType()),s,r;this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;for(r=0;r<e.length;r++){s=e[r];s.textContent=i[(r+a)%7]}P.call(this)};M.prototype._handleBorderReached=function(e){var t=e.getParameter("event");var a=0;var i=this._getDate();var s=new r(i,this._getPrimaryCalendarType());if(t.type){switch(t.type){case"sapnext":case"sapnextmodifiers":if(t.keyCode===p.ARROW_DOWN){s.setDate(s.getDate()+7)}else{s.setDate(s.getDate()+1)}break;case"sapprevious":case"sappreviousmodifiers":if(t.keyCode===p.ARROW_UP){s.setDate(s.getDate()-7)}else{s.setDate(s.getDate()-1)}break;case"sappagedown":a=s.getMonth()+1;s.setMonth(a);if(a%12!==s.getMonth()){while(a!==s.getMonth()){s.setDate(s.getDate()-1)}}break;case"sappageup":a=s.getMonth()-1;s.setMonth(a);if(a<0){a=11}if(a!==s.getMonth()){while(a!==s.getMonth()){s.setDate(s.getDate()-1)}}break;default:break}this.fireFocus({date:s.toLocalJSDate(),otherMonth:true})}};M.prototype.checkDateFocusable=function(e){s._checkJSDateObject(e);var t=this._getDate();var a=r.fromLocalJSDate(e,this._getPrimaryCalendarType());return s._isSameMonthAndYear(a,t)};M.prototype.applyFocusInfo=function(e){return this};M.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek()};M.prototype._isMonthNameLong=function(e){var t;var a;for(t=0;t<e.length;t++){a=e[t];if(Math.abs(a.clientWidth-a.scrollWidth)>1){return true}}return false};M.prototype._getVisibleDays=function(e,t){var a,i,s,o,n,l,h;if(!e){return this._aVisibleDays}this._aVisibleDays=[];l=this._getFirstDayOfWeek();n=new r(e,this._getPrimaryCalendarType());n.setDate(1);o=n.getDay()-l;if(o<0){o=7+o}if(o>0){n.setDate(1-o)}i=new r(n);a=(e.getMonth()+1)%12;do{h=i.getYear();s=new r(i,this._getPrimaryCalendarType());if(t&&h<1){s._bBeforeFirstYear=true;this._aVisibleDays.push(s)}else if(h>0&&h<1e4){this._aVisibleDays.push(s)}i.setDate(i.getDate()+1)}while(i.getMonth()!==a||i.getDay()!==l);return this._aVisibleDays};M.prototype._handleMousedown=function(e,a){var i=e.target.classList.contains("sapUiCalWeekNum"),s=!e.button,o=this._getSelectedDateFromEvent(e);if(!s||t.support.touch){return this}if(i){this._isWeekSelectionAllowed()&&this._handleWeekSelection(o,true);return this}else if(e.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(o);return this}var n=this._selectDay(a);if(n){this._bMousedownChange=true}if(this._bMouseMove){this._unbindMousemove(true);this._bMoveChange=false;this._oMoveSelectedDate=undefined}else if(n&&this.getIntervalSelection()&&this.$().is(":visible")){this._bindMousemove(true);this._oMoveSelectedDate=new r(a,this._getPrimaryCalendarType())}e.preventDefault();e.setMark("cancelAutoClose")};M.prototype._getSelectedDateFromEvent=function(e){var t=e.target,a,i;if(t.classList.contains("sapUiCalWeekNum")){a=t.nextSibling.getAttribute("data-sap-day")}else{a=t.getAttribute("data-sap-day")||t.parentNode.getAttribute("data-sap-day")}i=this._oFormatYyyymmdd.parse(a);return i?r.fromLocalJSDate(i,this._getPrimaryCalendarType()):null};M.prototype._handleWeekSelection=function(e,t){var a=this._calculateWeekNumber(e),i=this._getLastWeekDate(e),s=this.getSingleSelection(),o=this.getIntervalSelection(),n=this._checkDateEnabled(e)?e:null,l=this._checkDateEnabled(i)?i:null;if(e.isAfter(this._oMaxDate)||i.isBefore(this._oMinDate)){return this}if(!n){n=new r(this._oMinDate)}if(!l){l=new r(this._oMaxDate)}if(!s&&!o){this._handleWeekSelectionByMultipleDays(a,n,l)}else if(s&&o){this._handleWeekSelectionBySingleInterval(a,n,l)}t&&this._focusDate(n);return this};M.prototype._handleConsecutiveDaysSelection=function(e){var t=this.getSelectedDates(),a=t.length&&t[t.length-1].getStartDate(),i=a?r.fromLocalJSDate(a):e,s;s=this._areAllDaysBetweenSelected(i,e);this._toggleDaysBetween(i,e,!s);return this};M.prototype._calculateWeekNumber=function(e){var t=new d(this._getLocale());var a=this._getLastWeekDate(e);var i=this._getLocaleData();var s;var r;s=h.getInstance({pattern:"w",calendarType:this._getPrimaryCalendarType(),calendarWeekNumbering:this.getCalendarWeekNumbering()},t);var o=i.firstDayStartsFirstWeek();if(a.getMonth()===0&&this._oDate.getMonth()===0&&o){r=s.format(a.toLocalJSDate())}else{r=s.format(e.toLocalJSDate())}return r};M.prototype._isWeekSelectionAllowed=function(){var e=this.getSingleSelection(),t=this.getIntervalSelection(),a=this._getPrimaryCalendarType(),i=this.getFirstDayOfWeek()!==-1,s=!e&&!t,r=e&&t,o=r||s;return a===C.Gregorian&&!i&&o};M.prototype._isConsecutiveDaysSelectionAllowed=function(){var e=this.getSingleSelection(),t=this.getIntervalSelection();return!e&&!t};M.prototype._isMarkingUnfinishedRangeAllowed=function(){var e=this.getSelectedDates()[0],t=!!(e&&e.getStartDate()&&!e.getEndDate());return this.getIntervalSelection()&&t};M.prototype._handleWeekSelectionByMultipleDays=function(e,t,a){var i,s,r;i=this._areAllDaysBetweenSelected(t,a)?new o({startDate:t.toLocalJSDate()}):new o({startDate:t.toLocalJSDate(),endDate:a.toLocalJSDate()});s=this.fireWeekNumberSelect({weekNumber:e,weekDays:i});r=i.getEndDate()?true:false;if(s){this._toggleDaysBetween(t,a,r)}return this};M.prototype._handleWeekSelectionBySingleInterval=function(e,t,a){var i=new o({startDate:t.toLocalJSDate(),endDate:a.toLocalJSDate()}),s=this.getParent(),r=this,n;if(s&&s.getSelectedDates){r=s}if(this._isIntervalSelected(i)){i=null}n=this.fireWeekNumberSelect({weekNumber:e,weekDays:i});if(n){r.removeAllSelectedDates();r.addSelectedDate(i)}return this};M.prototype._isIntervalSelected=function(e){var t=this.getSelectedDates(),a=t.length&&t[0],i=a&&a.getEndDate();return a&&a.getStartDate()&&a.getStartDate().getTime()===e.getStartDate().getTime()&&i&&a.getEndDate()&&a.getEndDate().getTime()===e.getEndDate().getTime()};M.prototype._getLastWeekDate=function(e){return new r(e).setDate(e.getDate()+6)};M.prototype._toggleDaysBetween=function(e,t,a){var i=this._arrangeStartAndEndDates(e,t),s=new r(i.startDate),o;do{o=this._checkDateSelected(s);if(!o&&a||o&&!a){this._selectDay(s);w.call(this)}s.setDate(s.getDate()+1)}while(s.isSameOrBefore(i.endDate));return this};M.prototype._areAllDaysBetweenSelected=function(e,t){var a=this._arrangeStartAndEndDates(e,t),i=new r(a.startDate),s=true;do{if(!this._checkDateSelected(i)){s=false;break}i.setDate(i.getDate()+1)}while(i.isSameOrBefore(a.endDate));return s};M.prototype._arrangeStartAndEndDates=function(e,t){var a=e.isSameOrBefore(t);return{startDate:a?e:t,endDate:a?t:e}};M.prototype._selectDay=function(e,t){if(!this._checkDateEnabled(e)){return false}var a=this.getSelectedDates();var i;var s=this._oItemNavigation.getItemDomRefs();var n;var l;var h=0;var g=this.getParent();var d=this;var u;var c=this._getPrimaryCalendarType();if(g&&g.isA("sap.ui.unified.Calendar")){d=g}if(this.getSingleSelection()){if(a.length>0){i=a[0];u=i.getStartDate();if(u){u=r.fromLocalJSDate(u,c)}}else{i=new o;d.addAggregation("selectedDates",i,true)}if(this.getIntervalSelection()&&(!i.getEndDate()||t)&&u){var p;if(e.isBefore(u)){p=u;u=e;if(!t){i.setProperty("startDate",u.toLocalJSDate());i.setProperty("endDate",p.toLocalJSDate())}}else if(e.isSameOrAfter(u)){p=e;if(!t){i.setProperty("endDate",p.toLocalJSDate())}}}else{i.setProperty("startDate",e.toLocalJSDate());i.setProperty("endDate",undefined)}this._oInvisibleMessage.announce(this._oUnifiedRB.getText("APPOINTMENT_SELECTED"),S.Assertive)}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection")}else{var f=this._checkDateSelected(e);if(f>0){for(h=0;h<a.length;h++){u=a[h].getStartDate();if(u&&e.isSame(r.fromLocalJSDate(u,c))){d.removeAggregation("selectedDates",h,true);break}}}else{this._oInvisibleMessage.announce(this._oUnifiedRB.getText("APPOINTMENT_SELECTED"),S.Assertive);i=new o({startDate:e.toLocalJSDate()});d.addAggregation("selectedDates",i,true)}l=this._oFormatYyyymmdd.format(e.toUTCJSDate(),true);for(h=0;h<s.length;h++){n=jQuery(s[h]);if(n.attr("data-sap-day")===l){if(f>0){n.removeClass("sapUiCalItemSel");n.attr("aria-selected","false")}else{n.addClass("sapUiCalItemSel");n.attr("aria-selected","true")}}}}}return true};M.prototype._getSpecialDates=function(){var e=this.getParent();if(e&&e._getSpecialDates){return e._getSpecialDates()}else{var t=this.getSpecialDates();for(var a=0;a<t.length;a++){var i=t[a].getSecondaryType()===l.CalendarDayType.NonWorking&&t[a].getType()!==l.CalendarDayType.NonWorking;if(i){var s=new n;s.setType(l.CalendarDayType.NonWorking);s.setStartDate(t[a].getStartDate());if(t[a].getEndDate()){s.setEndDate(t[a].getEndDate())}t.push(s)}}return t}};function T(){var e=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true),t=0,a=this.getDomRef(),s=a.querySelectorAll(".sapUiCalItem");for(var r=0;r<s.length;r++){if(s[r].getAttribute("data-sap-day")===e){t=r;break}}if(!this._oItemNavigation){this._oItemNavigation=new i;this._oItemNavigation.attachEvent(i.Events.AfterFocus,k,this);this._oItemNavigation.attachEvent(i.Events.FocusAgain,L,this);this._oItemNavigation.attachEvent(i.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(this._iColumns>1){this._oItemNavigation.setHomeEndColumnMode(true,true)}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this._iColumns,true)}this._oItemNavigation.setRootDomRef(a);this._oItemNavigation.setItemDomRefs(s);this._oItemNavigation.setFocusedIndex(t);this._oItemNavigation.setPageSize(s.length)}function k(e){var t=e.getParameter("index"),a=e.getParameter("event"),i=this._getDate(),s=new r(i,this._getPrimaryCalendarType()),o=false,n=true,l=this._oItemNavigation.getItemDomRefs(),h=l[t],g=h.getAttribute("data-sap-day"),d;if(!a){return}if(h.classList.contains("sapUiCalItemOtherMonth")||h.classList.contains("sapUiCalItemDsbl")){if(a.type==="saphomemodifiers"&&(a.metaKey||a.ctrlKey)){for(var u=0;u<l.length;++u){d=l[u];if(!(d.classList.contains("sapUiCalItemOtherMonth")||d.classList.contains("sapUiCalItemDsbl"))){s=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(d.getAttribute("data-sap-day")),this._getPrimaryCalendarType());break}}this._focusDate(s)}else if(a.type==="sapendmodifiers"&&(a.metaKey||a.ctrlKey)){for(var u=l.length-1;u>0;--u){d=l[u];if(!(d.classList.contains("sapUiCalItemOtherMonth")||d.classList.contains("sapUiCalItemDsbl"))){s=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(d.getAttribute("data-sap-day")),this._getPrimaryCalendarType());break}}this._focusDate(s)}else{o=true;s=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(g),this._getPrimaryCalendarType());if(!s){s=new r(i)}this._focusDate(i);if(a.type==="mousedown"||this._sTouchstartYyyyMMdd&&a.type==="focusin"&&this._sTouchstartYyyyMMdd===g||h.classList.contains("sapUiCalItemDsbl")){n=false;this.fireFocus({date:i.toLocalJSDate(),otherMonth:false,restoreOldDate:true})}this._sTouchstartYyyyMMdd=a.originalEvent&&a.originalEvent.type==="touchstart"?g:undefined}}else{if(a.target.classList.contains("sapUiCalWeekNum")){this._focusDate(s)}else{s=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(g),this._getPrimaryCalendarType());this._oDate=s}this._sTouchstartYyyyMMdd=undefined}if(a.type==="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=h.id}if(n){this.fireFocus({date:s.toLocalJSDate(),otherMonth:o})}if(a.type==="mousedown"){this._handleMousedown(a,s,t)}}function L(e){var t=e.getParameter("index");var a=e.getParameter("event");if(!a){return}if(a.type==="mousedown"){var i=this._getDate();if(this.getIntervalSelection()){var s=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=s[t].id}this._handleMousedown(a,i,t)}}function I(e){s._checkCalendarDate(e);var t=e.getYear();s._checkYearInValidRange(t);if(!this.getDate()||!e.isSame(r.fromLocalJSDate(this.getDate(),e.getCalendarType()))){var a=new r(e);this.setProperty("date",e.toLocalJSDate());this._oDate=a}else{this.invalidate()}}M.prototype._focusDate=function(e,a,i){if(!a){this.setDate(e.toLocalJSDate())}var s=this._oFormatYyyymmdd.format(e.toUTCJSDate(),true),r=this._oItemNavigation.getItemDomRefs(),o;for(var n=0;n<r.length;n++){o=r[n];if(o.getAttribute("data-sap-day")===s){if(document.activeElement!==r[n]){if(i||t.system.phone){this._oItemNavigation.setFocusedIndex(n)}else{this._oItemNavigation.focusItem(n)}}break}}};function w(){if(this._bMouseMove){this._unbindMousemove(true)}this.fireSelect()}function P(){if(!this._bNamesLengthChecked){var e,t=this.getDomRef().querySelectorAll(".sapUiCalWH:not(.sapUiCalDummy)"),a=this._isMonthNameLong(t),i,s,r,o;if(a){this._bLongWeekDays=false;i=this._getLocaleData();s=this._getFirstWeekDay();r=i.getDaysStandAlone("narrow",this._getPrimaryCalendarType());for(o=0;o<t.length;o++){e=t[o];e.textContent=r[(o+s)%7]}}else{this._bLongWeekDays=true}this._bNamesLengthChecked=true}}return M});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/MonthPicker", ["sap/ui/core/Control","sap/ui/Device","sap/ui/core/LocaleData","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/library","sap/ui/core/Locale","./MonthPickerRenderer","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/ui/unified/DateRange","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/core/Configuration","sap/ui/core/date/UI5Date"],function(t,e,a,i,s,o,n,jQuery,r,h,l,g,c,f){"use strict";var d=12,u=2,p={OneYearBackward:-1,OneYearForward:1};var _=t.extend("sap.ui.unified.calendar.MonthPicker",{metadata:{library:"sap.ui.unified",properties:{month:{type:"int",group:"Data",defaultValue:0},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},columns:{type:"int",group:"Appearance",defaultValue:3},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},_firstMonth:{type:"int",group:"Data",visibility:"hidden",defaultValue:0},_focusedMonth:{type:"int",group:"Data",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},pageChange:{}}},renderer:n});_.prototype.init=function(){this._iMinMonth=0;this._iMaxMonth=11};_.prototype.onAfterRendering=function(){var t,e=this.getMonth(),a=this.getMonths(),i=this.getProperty("_firstMonth"),s=this.getProperty("_focusedMonth"),o=this._oItemNavigation?this._oItemNavigation.getFocusedIndex():0;m.call(this);D.call(this);if(this.getColumns()>0){t=s%a;var n=parseInt(d/a),r=n*a;if(s>=r){t=12-r+1+t}}else if(e<i||e>i+a-1){t=o}else{t=e-i}this._oItemNavigation.focusItem(t)};_.prototype.setMonth=function(t){var e=Math.floor(t/this.getMonths())*this.getMonths();if(e+this.getMonths()>12){e=12-this.getMonths()}this.setProperty("month",t);this.setProperty("_focusedMonth",t);this.setProperty("_firstMonth",e);t=this.getProperty("month");if(t<0||t>11){throw new Error("Property month must be between 0 and 11; "+this)}if(this.getIntervalSelection()){this._oItemNavigation&&this._oItemNavigation.focusItem(t);return this}if(this.getDomRef()){if(this.getMonths()<12){var a=this.getStartMonth();if(t>=a&&t<=a+this.getMonths()-1){this._selectMonth(t,true);this._oItemNavigation.focusItem(t-a)}else{S.call(this,t)}}else{this._selectMonth(t,true);this._oItemNavigation.focusItem(t)}}return this};_.prototype.getSelectedDates=function(){if(this._oSelectedDatesControlOrigin){return this._oSelectedDatesControlOrigin.getSelectedDates()}return this.getAggregation("selectedDates")};_.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||c.getCalendarType()};_.prototype._getSelectedDates=function(){var t=this.getSelectedDates(),e;if(t){return t}else if(!this._aMPSelectedDates||!this._aMPSelectedDates.length){this._aMPSelectedDates=[new h];e=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());e.setMonth(this.getMonth(),1);this._iYear&&e.setYear(this._iYear);this._aMPSelectedDates[0].setStartDate(e.toLocalJSDate());return this._aMPSelectedDates}else{return this._aMPSelectedDates}};_.prototype.exit=function(){if(this._aMPSelectedDates&&this._aMPSelectedDates.length){this._aMPSelectedDates.forEach(function(t){t.destroy()});this._aMPSelectedDates=undefined}};_.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()]};_.prototype._setSelectedDatesControlOrigin=function(t){this._oSelectedDatesControlOrigin=t};_.prototype._setYear=function(t){this._iYear=t};_.prototype._setDate=function(t){this._oDate=t};_.prototype._getLocale=function(){var t=this._oSelectedDatesControlOrigin;if(t&&t._getLocale){return t._getLocale()}else if(!this._sLocale){this._sLocale=c.getFormatSettings().getFormatLocale().toString()}return this._sLocale};_.prototype._getLocaleData=function(){var t=this._oSelectedDatesControlOrigin;if(t&&t._getLocaleData){return t._getLocaleData()}else if(!this._oLocaleData){var e=this._getLocale();var i=new o(e);this._oLocaleData=a.getInstance(i)}return this._oLocaleData};_.prototype.onsapspace=function(t){t.preventDefault()};_.prototype.onsapselect=function(t){var e=this._oItemNavigation.getFocusedIndex();var a=e+this.getStartMonth();if(a>=this._iMinMonth&&a<=this._iMaxMonth){this._selectMonth(a);this.fireSelect()}};_.prototype.onmousedown=function(t){this._oMousedownPosition={clientX:t.clientX,clientY:t.clientY}};_.prototype.onmouseup=function(t){var a=t.target,i=this._getSelectedDates()[0],s,o,n;if(this._bMousedownChange){this._bMousedownChange=false;if(this.getIntervalSelection()&&a.classList.contains("sapUiCalItem")&&i){s=g.fromLocalJSDate(i.getStartDate(),this._getPrimaryCalendarType());o=i.getEndDate();n=this._extractMonth(a);if(n!==s.getMonth()&&!o&&n>=this._iMinMonth&&n<=this._iMaxMonth){this._selectMonth(n);this._oItemNavigation.focusItem(n)}}this.fireSelect()}else if(e.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,t.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,t.clientY,10)){n=this._oItemNavigation.getFocusedIndex()+this.getStartMonth();if(n>=this._iMinMonth&&n<=this._iMaxMonth){this._selectMonth(n);this.fireSelect()}}};_.prototype.onmouseover=function(t){var e=t.target,a=this._getSelectedDates()[0],i,s;if(!a){return}if(a.getStartDate()){i=g.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());i.setDate(1)}if(e.classList.contains("sapUiCalItem")){s=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());s.setMonth(this._extractMonth(e),1);this._iYear&&s.setYear(this._iYear);if(this._isSelectionInProgress()){this._markInterval(i,s)}}};_.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return}if(!this.getDomRef()){return}var t=this._oItemNavigation.getItemDomRefs(),e=this._getLocaleData(),a=e.getMonthsStandAlone("wide",this._getPrimaryCalendarType()),i,s;this._bNamesLengthChecked=undefined;this._bLongMonth=false;for(i=0;i<t.length;i++){s=jQuery(t[i]);s.text(a[i])}D.call(this)};_.prototype.nextPage=function(){var t=this.getStartMonth(),e=this._oItemNavigation.getFocusedIndex(),a=e+t,i=this.getMonths();a=a+i;if(a>d-1){a=d-1}S.call(this,a);var s=Math.floor(this.getStartMonth()+this.getMonths())%d;if(s+this.getMonths()>12){s=12-this.getMonths()}this.setProperty("_firstMonth",s);return this};_.prototype.previousPage=function(){var t=this.getStartMonth(),e=this._oItemNavigation.getFocusedIndex(),a=e+t,i=this.getMonths();a=a-i;if(a<0){a=0}S.call(this,a);var s=Math.floor(this.getStartMonth()-this.getMonths())%d;if(s<0){s=0}this.setProperty("_firstMonth",s);return this};_.prototype.setMinMax=function(t,e){var a,i,s,o;if(t==this._iMinMonth&&e==this._iMaxMonth){return this}t=parseInt(t);if(isNaN(t)||t<0||t>11){t=0}e=parseInt(e);if(isNaN(e)||e<0||e>11){e=11}if(t<=e){this._iMinMonth=t;this._iMaxMonth=e}else{this._iMaxMonth=t;this._iMinMonth=e}if(this.getDomRef()){a=this._oItemNavigation.getItemDomRefs();for(o=0;o<a.length;o++){i=jQuery(a[o]);s=this._extractMonth(a[o]);if(s<this._iMinMonth||s>this._iMaxMonth){i.addClass("sapUiCalItemDsbl");i.attr("aria-disabled",true)}else{i.removeClass("sapUiCalItemDsbl");i.removeAttr("aria-disabled")}}}return this};_.prototype.getStartMonth=function(){return this.getProperty("_firstMonth")};_.prototype._isValueInThreshold=function(t,e,a){var i=t-a,s=t+a;return e>=i&&e<=s};_.prototype._getSecondaryCalendarType=function(){var t=this.getSecondaryCalendarType();if(t===this._getPrimaryCalendarType()){return undefined}return t};_.prototype._getDisplayedSecondaryDates=function(t){var e=this.getSecondaryCalendarType(),a=new g(this._oDate?this._oDate:g.fromLocalJSDate(f.getInstance()),this._getPrimaryCalendarType()),i,s;a.setMonth(t);a.setDate(1);i=new g(a,e);a.setDate(l._daysInMonth(a));s=new g(a,e);return{start:i,end:s}};function m(){var t=this.getDomRef(),e=this.$().find(".sapUiCalItem"),a=this.getColumns();if(!this._oItemNavigation){this._oItemNavigation=new i;this._oItemNavigation.attachEvent(i.Events.AfterFocus,this._handleAfterFocus,this);this._oItemNavigation.attachEvent(i.Events.FocusAgain,M,this);this._oItemNavigation.attachEvent(i.Events.BorderReached,y,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]})}this._oItemNavigation.setRootDomRef(t);this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(a,true);var s=this.getMonth()-this.getStartMonth();this._oItemNavigation.setFocusedIndex(s);this._oItemNavigation.setPageSize(e.length)}_.prototype._handleAfterFocus=function(t){var e=t.getParameter("index"),a=t.getParameter("event"),i=this._oItemNavigation.aItemDomRefs[e],s=this._getSelectedDates()[0],o,n;if(!a){return}if(a.type==="mousedown"){this._handleMousedown(a,e)}else if(a.type==="sapnext"||a.type==="sapprevious"){if(!s){return}if(s.getStartDate()){o=g.fromLocalJSDate(s.getStartDate(),this._getPrimaryCalendarType());o.setDate(1)}n=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());n.setMonth(this._extractMonth(i),1);this._iYear&&n.setYear(this._iYear);if(this._isSelectionInProgress()){this._markInterval(o,n)}}};function M(t){this._handleAfterFocus(t)}_.prototype._isSelectionInProgress=function(){var t=this._getSelectedDates()[0];if(!t){return false}return this.getIntervalSelection()&&t.getStartDate()&&!t.getEndDate()};_.prototype._extractMonth=function(t){var e=this.getId().length+u;return parseInt(t.id.slice(e))};_.prototype._markInterval=function(t,e){var a=this._oItemNavigation.getItemDomRefs(),i=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType()),s;if(t.isAfter(e)){e=[t,t=e][0]}if(this._bMousedownChange){if(e.getMonth()>this._iMinMonth&&e.getMonth()<this._iMaxMonth){jQuery(a[e.getMonth()]).addClass("sapUiCalItemSel")}if(t.getMonth()>this._iMinMonth&&t.getMonth()<this._iMaxMonth){jQuery(a[t.getMonth()]).addClass("sapUiCalItemSel")}}for(s=0;s<a.length;++s){i.setMonth(this._extractMonth(a[s]),1);this._iYear&&i.setYear(this._iYear);if(l._isBetween(i,t,e)&&i.getMonth()>this._iMinMonth&&i.getMonth()<this._iMaxMonth){jQuery(a[s]).addClass("sapUiCalItemSelBetween")}else{jQuery(a[s]).removeClass("sapUiCalItemSelBetween")}if(this._bMousedownChange&&!i.isSame(t)&&!i.isSame(e)){jQuery(a[s]).removeClass("sapUiCalItemSel")}}};_.prototype._handleMousedown=function(t,a){if(t.button||e.support.touch&&!e.system.combi){return}var i=a+this.getStartMonth();if(i>=this._iMinMonth&&i<=this._iMaxMonth){this._selectMonth(i);this._bMousedownChange=true}t.preventDefault();t.setMark("cancelAutoClose")};function y(t){var e=t.getParameter("event"),a=this._oItemNavigation.getFocusedIndex()+this.getStartMonth(),i=this.getMonths(),s=this.getColumns(),o=this._getSelectedDates()[0],n,h=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType()),l=s===0&&i<d;this._iYear&&h.setYear(this._iYear);if(o&&o.getStartDate()){n=g.fromLocalJSDate(o.getStartDate(),this._getPrimaryCalendarType());n.setDate(1)}if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":if(l){this._oneRowChangePage(a,true)}else if(e.keyCode===r.ARROW_DOWN&&s<=i){if(a<d-i){S.call(this,a+s,false,p.OneYearForward)}else if(i===d){this.firePageChange({offset:p.OneYearForward});this._oItemNavigation.focusItem(a%s);h.setMonth(a%s,1);this.setProperty("_focusedMonth",a%s);this._isSelectionInProgress()&&this._markInterval(n,h)}else{if(s===0){s=i}S.call(this,a%s,true,p.OneYearForward)}}else{if(a<d-i){S.call(this,a+1,false,p.OneYearForward)}else if(i===d){this.firePageChange({offset:p.OneYearForward});this._oItemNavigation.focusItem(0);h.setMonth(0,1);this._isSelectionInProgress()&&this._markInterval(n,h)}else{S.call(this,0,true,p.OneYearForward)}}break;case"sapprevious":case"sappreviousmodifiers":if(l){this._oneRowChangePage(a)}else if(e.keyCode===r.ARROW_UP&&s<=i){if(a>=i){S.call(this,a-s,false,p.OneYearBackward)}else if(i===d){this.firePageChange({offset:p.OneYearBackward});this._oItemNavigation.focusItem(i-s+a);h.setMonth(i-s+a,1);this.setProperty("_focusedMonth",i-s+a);this._isSelectionInProgress()&&this._markInterval(n,h)}else{S.call(this,d-s+a,true,p.OneYearBackward)}}else{if(a>=i){S.call(this,a-1,false,p.OneYearBackward)}else if(i===d){this.firePageChange({offset:p.OneYearBackward});this._oItemNavigation.focusItem(i-1);h.setMonth(i-1,1);this._isSelectionInProgress()&&this._markInterval(n,h)}else{S.call(this,d-1,true,p.OneYearBackward)}}break;case"sappagedown":if(a<d-i){S.call(this,a+i,false,p.OneYearForward)}else if(i===d){this.firePageChange({offset:p.OneYearForward})}else{S.call(this,a,true,p.OneYearForward)}break;case"sappageup":if(a>i){S.call(this,a-i,false,p.OneYearBackward)}else if(i===d){this.firePageChange({offset:p.OneYearBackward})}else{S.call(this,a,true,p.OneYearBackward)}break;default:break}}}_.prototype._oneRowChangePage=function(t,e){var a=this.getProperty("_firstMonth"),i=this.getMonths(),s=e?a+i<d:a>0,o=e?1:-1;if(s){e&&this.nextPage()||this.previousPage();this.firePageChange({offset:0});this.setMonth(t+o)}};_.prototype._selectMonth=function(t,e){var a=this._getSelectedDates()[0],i=this.getAggregation("selectedDates"),s,o;this.setProperty("_focusedMonth",t);if(!a){return}!e&&this.setProperty("month",t);o=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());o.setMonth(t,1);this._iYear&&o.setYear(this._iYear);if(!this._oSelectedDatesControlOrigin){if(!i||!i.length){this.addAggregation("selectedDates",a,true)}!this.getIntervalSelection()&&a.setStartDate(o.toLocalJSDate())}if(this.getIntervalSelection()&&!e){if(!a.getStartDate()){a.setStartDate(o.toLocalJSDate())}else if(!a.getEndDate()){s=g.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());if(o.isBefore(s)){a.setEndDate(s.toLocalJSDate());a.setStartDate(o.toLocalJSDate())}else{a.setEndDate(o.toLocalJSDate())}}else{a.setStartDate(o.toLocalJSDate());a.setEndDate(undefined)}}};function D(){if(!this._bNamesLengthChecked){var t=0,e=this._oItemNavigation.getItemDomRefs(),a=false,i=this.getMonths(),s=Math.ceil(d/i),o=i-1;for(var n=0;n<s;n++){if(i<d){S.call(this,o);o=o+i;if(o>d-1){o=d-1}}for(t=0;t<e.length;t++){var r=e[t];if(Math.abs(r.clientWidth-r.scrollWidth)>1){a=true;break}}if(a){break}}if(i<d){o=this.getMonth();S.call(this,o)}if(a){this._bLongMonth=false;var h=this._getLocaleData(),l=this._getPrimaryCalendarType(),g=h.getMonthsStandAlone("abbreviated",l),c=h.getMonthsStandAlone("wide",l);for(t=0;t<e.length;t++){var f=jQuery(e[t]);f.text(g[t]);f.attr("aria-label",c[t])}}else{this._bLongMonth=true}this._bNamesLengthChecked=true}}function S(t,e,a){var i=this._getSelectedDates()[0],s,o;this.setProperty("_focusedMonth",t);if(i&&i.getStartDate()){s=g.fromLocalJSDate(i.getStartDate(),this._getPrimaryCalendarType());s.setDate(1)}if(i&&i.getEndDate()){o=g.fromLocalJSDate(i.getEndDate(),this._getPrimaryCalendarType());o.setDate(1)}else{o=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());this._iYear&&o.setYear(this._iYear);o.setMonth(t,1)}this._isSelectionInProgress()&&this._markInterval(s,o);if(e){this.firePageChange({offset:a})}}_.prototype._fnShouldApplySelection=function(t){var e=this._getSelectedDates()[0],a,i;if(!e){return false}a=e.getStartDate();i=e.getEndDate();if(a){a=g.fromLocalJSDate(a,this._getPrimaryCalendarType());a.setDate(1)}if(this.getIntervalSelection()&&a&&i){i=g.fromLocalJSDate(i,this._getPrimaryCalendarType());i.setDate(1);if(t.isSame(a)||t.isSame(i)){return true}}else if(a&&t.isSame(a)){return true}return false};_.prototype._fnShouldApplySelectionBetween=function(t){var e=this._getSelectedDates()[0],a,i;if(!e){return false}a=e.getStartDate();i=e.getEndDate();if(this.getIntervalSelection()&&a&&i){a=g.fromLocalJSDate(a,this._getPrimaryCalendarType());a.setDate(1);i=g.fromLocalJSDate(i,this._getPrimaryCalendarType());i.setDate(1);if(l._isBetween(t,a,i)){return true}}return false};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/MonthPickerRenderer", ["sap/ui/unified/calendar/CalendarDate","sap/ui/core/format/DateFormat","sap/ui/core/InvisibleText","sap/ui/core/date/UI5Date"],function(e,t,a,n){"use strict";var r={apiVersion:2};r.render=function(r,i){var l=i.getProperty("_firstMonth")!==undefined?i.getProperty("_firstMonth"):i.getMonth(),o=i.getMonths(),s=0,d=i.getColumns(),c=i.getTooltip_AsString(),p=i._getLocaleData(),g=i.getId(),f="",u=[],y=[],S=i.getPrimaryCalendarType(),h=i._getSecondaryCalendarType(),C=t.getDateInstance({format:"y",calendarType:i.getPrimaryCalendarType()}),b=i._iYear?i._iYear:n.getInstance().getFullYear(),_=C.format(n.getInstance(Date.UTC(b,0,1)),true),m,M,I;if(i._bLongMonth||!i._bNamesLengthChecked){u=p.getMonthsStandAlone("wide",S)}else{u=p.getMonthsStandAlone("abbreviated",S);y=p.getMonthsStandAlone("wide",S)}r.openStart("div",i);r.class("sapUiCalMonthPicker");if(h){r.class("sapUiCalMonthSecType")}if(c){r.attr("tooltip",c)}r.accessibilityState(i,{role:"grid",readonly:"true",multiselectable:i.getIntervalSelection(),roledescription:sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("MONTH_PICKER"),describedby:i._bCalendar?a.getStaticId("sap.ui.unified","CALENDAR_YEAR_PICKER_OPEN_HINT"):""});r.openEnd();var v;if(o>12){o=12}else if(o<12){s=l}if(d>0){f=100/d+"%"}else{f=100/o+"%"}for(m=0;m<o;m++){var T=m+s,D=e.fromLocalJSDate(n.getInstance(),i.getPrimaryCalendarType());D.setMonth(T,1);i._iYear&&D.setYear(i._iYear);v={role:"gridcell"};if(!i._bLongMonth&&i._bNamesLengthChecked){v["label"]=y[T]}if(d>0&&m%d===0){r.openStart("div");r.accessibilityState(null,{role:"row"});r.openEnd()}r.openStart("div",g+"-m"+T);r.class("sapUiCalItem");M=i._fnShouldApplySelection(D);I=i._fnShouldApplySelectionBetween(D);if(M){r.class("sapUiCalItemSel");v["selected"]=true}if(I){r.class("sapUiCalItemSelBetween");v["selected"]=true}if(!M&&!I){v["selected"]=false}if(T<i._iMinMonth||T>i._iMaxMonth){r.class("sapUiCalItemDsbl");v["disabled"]=true}v["label"]=u[T]+" "+_;if(h){var U=i.getSecondaryCalendarType(),A=p.getMonthsStandAlone("abbreviated",U),P=t.getDateInstance({format:"y",calendarType:U}),E=i._getDisplayedSecondaryDates(T),L,x,Y;if(E.start.getMonth()===E.end.getMonth()){L=A[E.start.getMonth()];x=P.format(E.start.toUTCJSDate(),true)}else{Y=p.getIntervalPattern();L=Y.replace(/\{0\}/,A[E.start.getMonth()]).replace(/\{1\}/,A[E.end.getMonth()]);x=Y.replace(/\{0\}/,P.format(E.start.toUTCJSDate(),true)).replace(/\{1\}/,P.format(E.end.toUTCJSDate(),true))}v["label"]=v["label"]+" "+L+" "+x}r.attr("tabindex","-1");r.style("width",f);r.accessibilityState(null,v);r.openEnd();r.text(u[T]);if(h){r.openStart("div",g+"-m"+T+"-secondary");r.class("sapUiCalItemSecText");r.openEnd();r.text(L);r.close("div")}r.close("div");if(d>0&&(m+1)%d===0){r.close("div")}}r.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/MonthRenderer", ["sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/CalendarLegend","sap/ui/unified/CalendarLegendRenderer","sap/ui/core/library","sap/ui/unified/library","sap/base/Log","sap/ui/core/InvisibleText","sap/ui/core/date/UI5Date","sap/ui/core/Configuration"],function(e,a,t,i,r,n,s,d,l,o){"use strict";var c=n.CalendarDayType;var p=r.CalendarType;var y={apiVersion:2};y.render=function(e,a){var t=this.getStartDate(a),i=a.getTooltip_AsString(),r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),n=a.getId(),s={value:"",append:true},l="",o=a.getWidth();e.openStart("div",a);this.getClass(e,a).forEach(function(a){e.class(a)});if(a._getSecondaryCalendarType()){e.class("sapUiCalMonthSecType")}this.addWrapperAdditionalStyles(e,a);if(i){e.attr("title",i)}if(a._getShowHeader()){s.value=s.value+" "+n+"-Head"}if(a._bCalendar){l+=" "+d.getStaticId("sap.ui.unified","CALENDAR_MONTH_PICKER_OPEN_HINT")+" "+d.getStaticId("sap.ui.unified","CALENDAR_YEAR_PICKER_OPEN_HINT")}if(o){e.style("width",o)}e.accessibilityState(a,{role:"grid",roledescription:r.getText("CALENDAR_DIALOG"),multiselectable:!a.getSingleSelection()||a.getIntervalSelection(),labelledby:s,describedby:l});e.openEnd();if(a.getIntervalSelection()){e.openStart("span",n+"-Start");e.style("display","none");e.openEnd();e.text(r.getText("CALENDAR_START_DATE"));e.close("span");e.openStart("span",n+"-End");e.style("display","none");e.openEnd();e.text(r.getText("CALENDAR_END_DATE"));e.close("span")}this.renderMonth(e,a,t);e.close("div")};y.addWrapperAdditionalStyles=function(){};y.getStartDate=function(e){return e._getDate()};y.getClass=function(e,a){var t=["sapUiCalMonthView"],i=a.getPrimaryCalendarType(),r=a.getShowWeekNumbers();if(i===p.Islamic||!r){t.push("sapUiCalNoWeekNum")}return t};y.renderMonth=function(e,a,t){this.renderHeader(e,a,t);this.renderDays(e,a,t)};y.renderHeader=function(e,a,t){var i=a._getLocaleData();var r=a._getFirstDayOfWeek();this.renderHeaderLine(e,a,i,t);e.openStart("div");e.accessibilityState(null,{role:"row"});e.style("overflow","hidden");e.openEnd();this.renderDayNames(e,a,i,r,7,true,undefined);e.close("div")};y.renderHeaderLine=function(a,t,i,r){e._checkCalendarDate(r);if(t._getShowHeader()){var n=t.getId();var s=t.getPrimaryCalendarType();var d=i.getMonthsStandAlone("wide",s);a.openStart("div",n+"-Head");a.class("sapUiCalHeadText");a.openEnd();a.text(d[r.getMonth()]);a.close("div")}};y.renderDayNames=function(e,a,t,i,r,n,s){var d=a._getFirstDayOfWeek();var l=a.getId();var o="";var c=a.getPrimaryCalendarType();var y=[];if(a._bLongWeekDays||!a._bNamesLengthChecked){y=t.getDaysStandAlone("abbreviated",c)}else{y=t.getDaysStandAlone("narrow",c)}var g=t.getDaysStandAlone("wide",c);if(a.getShowWeekNumbers()&&c!==p.Islamic){this.renderDummyCell(e,"sapUiCalWH",true,"columnheader")}for(var f=0;f<r;f++){if(n){o=l+"-WH"+(f+d)%7}else{o=l+"-WH"+f}e.openStart("div",o);e.class("sapUiCalWH");if(f===0){e.class("sapUiCalFirstWDay")}if(s){e.style("width",s)}e.accessibilityState(null,{role:"columnheader",label:g[(f+i)%7]});e.openEnd();e.text(y[(f+i)%7]);e.close("div")}};y.renderDays=function(a,t,i){var r,n,s,d,l,o,c;e._checkCalendarDate(i);if(!i){i=t._getFocusedDate()}o=i.toUTCJSDate().getTime();if(!o&&o!==0){throw new Error("Date is invalid "+t)}d=this.getDayHelper(t,i);n=t._getVisibleDays(i,true);c=t.getShowWeekNumbers();r=t.getPrimaryCalendarType()!==p.Islamic&&c;s=n.length;for(l=0;l<s;l++){if(l%7===0){a.openStart("div");a.attr("role","row");a.openEnd();if(r){this._renderWeekNumber(a,n[l],d,t)}}this.renderDay(a,t,n[l],d,true,r,-1);if(l%7===6||l===s-1){a.close("div")}}if(s===28){this.renderDummyCell(a,"sapUiCalItem",false,"")}};y.renderDummyCell=function(e,a,t,i){e.openStart("div");e.class(a);e.class("sapUiCalDummy");e.style("visibility",t?"visible":"hidden");e.attr("role",i);e.attr("aria-label",sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_WEEK"));e.openEnd();e.close("div")};y.getDayHelper=function(e,i){var r,n,d=e._getLocaleData(),o={sLocale:e._getLocale(),oLocaleData:d,iMonth:i.getMonth(),iYear:i.getYear(),iFirstDayOfWeek:e._getFirstDayOfWeek(),iWeekendStart:d.getWeekendStart(),iWeekendEnd:d.getWeekendEnd(),aNonWorkingDays:e._getNonWorkingDays(),sToday:d.getRelativeDay(0),oToday:a.fromLocalJSDate(l.getInstance(),e.getPrimaryCalendarType()),sId:e.getId(),oFormatLong:e._getFormatLong(),sPrimaryCalendarType:e.getPrimaryCalendarType(),sSecondaryCalendarType:e._getSecondaryCalendarType(),oLegend:undefined};n=e.getLegend();if(n&&typeof n==="string"){r=sap.ui.getCore().byId(n);if(r){if(!(r instanceof t)){throw new Error(r+" is not an sap.ui.unified.CalendarLegend. "+e)}o.oLegend=r}else{s.warning("CalendarLegend "+n+" does not exist!",e)}}return o};y.renderDay=function(t,r,n,s,d,l,o,p,y){e._checkCalendarDate(n);var g=new a(n,s.sSecondaryCalendarType),f={role:r._getAriaRole(),selected:false,label:"",describedby:""},u=n._bBeforeFirstYear,D="",C=s.oLegend,b;var S=r._oFormatYyyymmdd.format(n.toUTCJSDate(),true);var m=n.getDay();var h=r._checkDateSelected(n);var v=r._getDateTypes(n);var W=s&&s.oLegend?s.oLegend._getSpecialDateTypeFilter():"";var _=r._checkDateEnabled(n);var E=0;var k=r._isSpecialDateMarkerEnabled(n);if(u){_=false}t.openStart("div",s.sId+"-"+S);t.class("sapUiCalItem");t.class("sapUiCalWDay"+m);if(p){t.style("width",p)}if(m===s.iFirstDayOfWeek){t.class("sapUiCalFirstWDay")}if(d&&s.iMonth!==n.getMonth()){t.class("sapUiCalItemOtherMonth");f["disabled"]=true}if(n.isSame(s.oToday)){t.class("sapUiCalItemNow");f["label"]=s.sToday+" "}if(h>0){t.class("sapUiCalItemSel");f["selected"]=true}else{f["selected"]=false}if(h===2){t.class("sapUiCalItemSelStart");f["describedby"]=f["describedby"]+" "+s.sId+"-Start"}else if(h===3){t.class("sapUiCalItemSelEnd");f["describedby"]=f["describedby"]+" "+s.sId+"-End"}else if(h===4){t.class("sapUiCalItemSelBetween")}else if(h===5){t.class("sapUiCalItemSelStart");t.class("sapUiCalItemSelEnd");f["describedby"]=f["describedby"]+" "+s.sId+"-Start";f["describedby"]=f["describedby"]+" "+s.sId+"-End"}if(this.renderWeekNumbers&&r._oDate){f["describedby"]=f["describedby"]+" "+r.getId()+"-week-"+r._calculateWeekNumber(n)+"-text"}if(k){v.forEach(function(e){if(e.type!==c.None){if(e.type===c.NonWorking){t.class("sapUiCalItemWeekEnd");b=this._addNonWorkingDayText(f);return}if(W===""||W===c.None||W===e.type){t.class("sapUiCalItem"+e.type);D=e.type;if(e.tooltip){t.attr("title",e.tooltip)}}}}.bind(this))}if(!b){if(s.aNonWorkingDays){s.aNonWorkingDays.forEach(function(e){if(n.getDay()===e){this._addNonWorkingDayText(f)}}.bind(this))}else if(n.getDay()===s.iWeekendStart||n.getDay()===s.iWeekendEnd){this._addNonWorkingDayText(f)}}if((r.getParent()&&r.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval"||r.getMetadata().getName()==="sap.ui.unified.calendar.OneMonthDatesRow")&&r.getStartDate()&&s.iMonth!==n.getMonth()){t.class("sapUiCalItemOtherMonth")}if(!_){t.class("sapUiCalItemDsbl");f["disabled"]=true}if(s.aNonWorkingDays){for(E=0;E<s.aNonWorkingDays.length;E++){if(m===s.aNonWorkingDays[E]){t.class("sapUiCalItemWeekEnd");break}}}else if(m>=s.iWeekendStart&&m<=s.iWeekendEnd||s.iWeekendEnd<s.iWeekendStart&&(m>=s.iWeekendStart||m<=s.iWeekendEnd)){t.class("sapUiCalItemWeekEnd")}t.attr("tabindex","-1");t.attr("data-sap-day",S);if(y){f["label"]=f["label"]+s.aWeekDaysWide[m]+" "}f["label"]=f["label"]+s.oFormatLong.format(n.toUTCJSDate(),true);if(D!==""){i.addCalendarTypeAccInfo(f,D,C)}if(s.sSecondaryCalendarType){f["label"]=f["label"]+" "+r._oFormatSecondaryLong.format(g.toUTCJSDate(),true)}t.accessibilityState(null,f);t.openEnd();if(v[0]&&k){t.openStart("div");t.class("sapUiCalSpecialDate");if(v[0].color&&(W===""||W===c.None)){t.style("background-color",v[0].color)}t.openEnd();t.close("div")}t.openStart("span");t.class("sapUiCalItemText");if(v[0]&&v[0].color){t.class("sapUiCalItemTextCustomColor")}t.openEnd();if(!u){t.text(n.getDate())}t.close("span");if(y){t.openStart("span");t.class("sapUiCalDayName");t.openEnd();t.text(s.aWeekDays[m]);t.close("span")}if(s.sSecondaryCalendarType){t.openStart("span");t.class("sapUiCalItemSecText");t.openEnd();t.text(g.getDate());t.close("span")}t.close("div")};y._addNonWorkingDayText=function(e){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("LEGEND_NON_WORKING_DAY")+" ";e["label"]+=a;return a};y._renderWeekNumber=function(e,a,t,i){var r=i._calculateWeekNumber(a);var n=t.sId+"-WNum-"+r;e.openStart("div",n);e.class("sapUiCalWeekNum");e.accessibilityState(null,{role:"rowheader",labelledby:d.getStaticId("sap.ui.unified","CALENDAR_WEEK")+" "+n});e.openEnd();e.text(r);e.close("div")};return y},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/MonthsRow", ["sap/ui/core/Control","sap/ui/core/LocaleData","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/library","sap/ui/core/format/DateFormat","sap/ui/core/library","sap/ui/core/Locale","./MonthsRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange","sap/ui/core/Configuration","sap/ui/core/Core","sap/ui/core/date/UI5Date"],function(e,t,a,r,i,o,s,n,l,h,g,jQuery,p,c,u,f){"use strict";var d=e.extend("sap.ui.unified.calendar.MonthsRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}},renderer:h});d.prototype.init=function(){var e=this._getPrimaryCalendarType();this._oFormatYyyymm=s.getInstance({pattern:"yyyyMMdd",calendarType:e});this._oFormatOnlyYearLong=s.getInstance({pattern:"yyyy",calendarType:e});this._oFormatLong=s.getInstance({pattern:"MMMM y",calendarType:e});this._mouseMoveProxy=jQuery.proxy(this._handleMouseMove,this);this._rb=u.getLibraryResourceBundle("sap.ui.unified")};d.prototype.setPrimaryCalendarType=function(e){this.setProperty("primaryCalendarType",e);this._oFormatYyyymm=s.getInstance({pattern:"yyyyMMdd",calendarType:e});this._oFormatLong=s.getInstance({pattern:"MMMM y",calendarType:e});return this};d.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||c.getCalendarType()};d.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);this._oFormatYearInSecType=s.getDateInstance({format:"y",calendarType:e});this._oFormatLongInSecType=s.getInstance({pattern:"MMMM y",calendarType:e});return this};d.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};d.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}if(this._sInvalidateMonths){clearTimeout(this._sInvalidateMonths)}};d.prototype.onAfterRendering=function(){y.call(this);L.call(this)};d.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){if(this._bMouseMove){T.call(this,true);b.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;M.call(this)}if(this._bMousedownChange){this._bMousedownChange=false;M.call(this)}}};d.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};d.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};d.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};d.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};d.prototype.setDate=function(e){if(e){var t=i.fromLocalJSDate(e,this.getProperty("primaryCalendarType"));this._oDate=t;S.call(this,t,false)}return this.setProperty("date",e)};d.prototype._getDisplayedSecondaryDates=function(e,t){var a=this._getSecondaryCalendarType(),o,s,n;if(this._oDate){o=new i(this._oDate)}else{o=new i(i.fromLocalJSDate(f.getInstance()),this._getPrimaryCalendarType())}o.setYear(t);o.setMonth(e);o.setDate(1);s=new i(o,a);o.setDate(r._daysInMonth(o));n=new i(o,a);return{start:s,end:n}};d.prototype._getDate=function(){if(!this._oDate){this._oDate=i.fromLocalJSDate(f.getInstance(),this.getProperty("primaryCalendarType"))}return this._oDate};d.prototype.setStartDate=function(e){r._checkJSDateObject(e);var t,a,o;a=e.getFullYear();r._checkYearInValidRange(a);t=i.fromLocalJSDate(e,this.getProperty("primaryCalendarType"));this.setProperty("startDate",e,true);this._oStartDate=t;this._oStartDate.setDate(1);if(this.getDomRef()){o=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(e);this._bNoRangeCheck=false;if(o&&this.checkDateFocusable(o)){this.setDate(o)}}return this};d.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=i.fromLocalJSDate(f.getInstance(),this.getProperty("primaryCalendarType"));this._oStartDate.setDate(1)}return this._oStartDate};d.prototype.displayDate=function(e){S.call(this,i.fromLocalJSDate(e,this.getProperty("primaryCalendarType")),true);return this};d.prototype._getLocale=function(){var e=this.getParent();if(e&&e.getLocale){return e.getLocale()}else if(!this._sLocale){this._sLocale=c.getFormatSettings().getFormatLocale().toString()}return this._sLocale};d.prototype._getLocaleData=function(){var e=this.getParent();if(e&&e._getLocaleData){return e._getLocaleData()}else if(!this._oLocaleData){var a=this._getLocale();var r=new l(a);this._oLocaleData=t.getInstance(r)}return this._oLocaleData};d.prototype._getFormatLong=function(){var e=this._getLocale();if(this._oFormatLong.oLocale.toString()!=e){var t=new l(e);this._oFormatLong=s.getInstance({style:"long",calendarType:this.getProperty("primaryCalendarType")},t)}return this._oFormatLong};d.prototype.getIntervalSelection=function(){var e=this.getParent();if(e&&e.getIntervalSelection){return e.getIntervalSelection()}else{return this.getProperty("intervalSelection")}};d.prototype.getSingleSelection=function(){var e=this.getParent();if(e&&e.getSingleSelection){return e.getSingleSelection()}else{return this.getProperty("singleSelection")}};d.prototype.getSelectedDates=function(){var e=this.getParent();if(e&&e.getSelectedDates){return e.getSelectedDates()}else{return this.getAggregation("selectedDates",[])}};d.prototype.getSpecialDates=function(){var e=this.getParent();if(e&&e.getSpecialDates){return e.getSpecialDates()}else{return this.getAggregation("specialDates",[])}};d.prototype._getShowHeader=function(){var e=this.getParent();if(e&&e._getShowItemHeader){return e._getShowItemHeader()}else{return this.getProperty("showHeader")}};d.prototype.getAriaLabelledBy=function(){var e=this.getParent();if(e&&e.getAriaLabelledBy){return e.getAriaLabelledBy()}else{return this.getAssociation("ariaLabelledBy",[])}};d.prototype._setLegendControlOrigin=function(e){this._oLegendControlOrigin=e};d.prototype.getLegend=function(){var e=this.getParent();if(this._oLegendControlOrigin){return this._oLegendControlOrigin.getLegend()}if(e&&e.getLegend){return e.getLegend()}else{return this.getAssociation("ariaLabelledBy",[])}};d.prototype._setAriaRole=function(e){this._ariaRole=e;return this};d.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell"};d.prototype._checkDateSelected=function(e){var t,a,o,s,n=0,l=0,h=0,g=this.getProperty("primaryCalendarType"),p,c,u;r._checkCalendarDate(e);c=this.getSelectedDates();u=new i(e);u.setDate(1);s=u.toUTCJSDate().getTime();for(p=0;p<c.length;p++){t=c[p];a=t.getStartDate();n=0;if(a){a=i.fromLocalJSDate(a,g);a.setDate(1);n=a.toUTCJSDate().getTime()}o=t.getEndDate();l=0;if(o){o=i.fromLocalJSDate(o,g);o.setDate(1);l=o.toUTCJSDate().getTime()}if(s==n&&!o){h=1;break}else if(s==n&&o){h=2;if(o&&s==l){h=5}break}else if(o&&s==l){h=3;break}else if(o&&s>n&&s<l){h=4;break}if(this.getSingleSelection()){break}}return h};d.prototype._getDateType=function(e){r._checkCalendarDate(e);var t,a,o,s,n=0,l,h=0,g,p=this.getSpecialDates(),c=new i(e),u=this.getProperty("primaryCalendarType");c.setDate(1);g=c.toUTCJSDate().getTime();for(o=0;o<p.length;o++){a=p[o];s=a.getStartDate();n=0;if(s){s=i.fromLocalJSDate(s,u);s.setDate(1);n=s.toUTCJSDate().getTime()}l=a.getEndDate();h=0;if(l){l=i.fromLocalJSDate(l,u);l.setDate(r._daysInMonth(l));h=l.toUTCJSDate().getTime()}if(g==n&&!l||g>=n&&g<=h){t={type:a.getType(),tooltip:a.getTooltip_AsString()};break}}return t};d.prototype._checkMonthEnabled=function(e){r._checkCalendarDate(e);var t=this.getParent();if(t&&t._oMinDate&&t._oMaxDate){if(r._isOutside(e,t._oMinDate,t._oMaxDate)){return false}}return true};d.prototype._handleMouseMove=function(e){if(!this.$().is(":visible")){T.call(this,true)}var t=jQuery(e.target);if(t.hasClass("sapUiCalItemText")){t=t.parent()}if(t.hasClass("sapUiCalItem")){var a=this._getDate();var r=i.fromLocalJSDate(this._oFormatYyyymm.parse(t.attr("data-sap-month"),this.getProperty("primaryCalendarType")));r.setDate(1);if(!r.isSame(a)){this.setDate(r.toLocalJSDate());b.call(this,r,true);this._bMoveChange=true}}};d.prototype.onmouseup=function(e){if(this._bMouseMove){T.call(this,true);var t=this._getDate();var a=this._oItemNavigation.getItemDomRefs();for(var r=0;r<a.length;r++){var o=jQuery(a[r]);if(o.attr("data-sap-month")==this._oFormatYyyymm.format(t.toUTCJSDate(),true)){o.trigger("focus");break}}if(this._bMoveChange){var s=jQuery(e.target);if(s.hasClass("sapUiCalItemText")){s=s.parent()}if(s.hasClass("sapUiCalItem")){t=i.fromLocalJSDate(this._oFormatYyyymm.parse(s.attr("data-sap-month")));t.setDate(1)}b.call(this,t);this._bMoveChange=false;this._bMousedownChange=false;M.call(this)}}if(this._bMousedownChange){this._bMousedownChange=false;M.call(this)}};d.prototype.onsapselect=function(e){var t=b.call(this,this._getDate());if(t){M.call(this)}e.stopPropagation();e.preventDefault()};d.prototype.onsapselectmodifiers=function(e){this.onsapselect(e)};d.prototype.onsappageupmodifiers=function(e){var t=new i(this._getDate());var a=t.getYear();if(e.metaKey||e.ctrlKey){t.setYear(a-10)}else{var r=this.getMonths();if(r<=12){t.setYear(a-1)}else{t.setMonth(t.getMonth()-r)}}this.fireFocus({date:t.toLocalJSDate(),notVisible:true});e.preventDefault()};d.prototype.onsappagedownmodifiers=function(e){var t=new i(this._getDate());var a=t.getYear();if(e.metaKey||e.ctrlKey){t.setYear(a+10)}else{var r=this.getMonths();if(r<=12){t.setYear(a+1)}else{t.setMonth(t.getMonth()+r)}}this.fireFocus({date:t.toLocalJSDate(),notVisible:true});e.preventDefault()};d.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var e=this._getLocaleData();var t=e.getMonthsStandAlone("wide",this.getProperty("primaryCalendarType"));var a=this.$("months").children();var r=this._getStartDate().getMonth();for(var i=0;i<a.length;i++){var o=jQuery(jQuery(a[i]).children(".sapUiCalItemText"));o.text(t[(i+r)%12])}L.call(this)};d.prototype.checkDateFocusable=function(e){r._checkJSDateObject(e);if(this._bNoRangeCheck){return false}var t=this._getStartDate();var a=new i(t);a.setDate(1);a.setMonth(a.getMonth()+this.getMonths());var o=i.fromLocalJSDate(e,this.getProperty("primaryCalendarType"));return o.isSameOrAfter(t)&&o.isBefore(a)};d.prototype.applyFocusInfo=function(e){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this};function y(){var e=this._getDate();var t=this._oFormatYyyymm.format(e.toUTCJSDate(),true);var r=0;var i=this.$("months").get(0);var o=this.$("months").children(".sapUiCalItem");for(var s=0;s<o.length;s++){var n=jQuery(o[s]);if(n.attr("data-sap-month")===t){r=s;break}}if(!this._oItemNavigation){this._oItemNavigation=new a;this._oItemNavigation.attachEvent(a.Events.AfterFocus,m,this);this._oItemNavigation.attachEvent(a.Events.FocusAgain,D,this);this._oItemNavigation.attachEvent(a.Events.BorderReached,v,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true)}this._oItemNavigation.setRootDomRef(i);this._oItemNavigation.setItemDomRefs(o);this._oItemNavigation.setFocusedIndex(r);this._oItemNavigation.setPageSize(o.length)}function m(e){var t=e.getParameter("index");var a=e.getParameter("event");if(!a){return}var r=this._getDate();var o=new i(r);var s=this._oItemNavigation.getItemDomRefs();var n=jQuery(s[t]);o=i.fromLocalJSDate(this._oFormatYyyymm.parse(n.attr("data-sap-month")));o.setDate(1);this.setDate(o.toLocalJSDate());this.fireFocus({date:o.toLocalJSDate(),notVisible:false});if(a.type=="mousedown"){_.call(this,a,o,t)}}function D(e){var t=e.getParameter("index");var a=e.getParameter("event");if(!a){return}if(a.type=="mousedown"){var r=this._getDate();_.call(this,a,r,t)}}function v(e){var t=e.getParameter("event");var a=this.getMonths();var r=this._getDate();var o=new i(r);if(t.type){switch(t.type){case"sapnext":case"sapnextmodifiers":o.setMonth(o.getMonth()+1);break;case"sapprevious":case"sappreviousmodifiers":o.setMonth(o.getMonth()-1);break;case"sappagedown":o.setMonth(o.getMonth()+a);break;case"sappageup":o.setMonth(o.getMonth()-a);break;default:break}this.fireFocus({date:o.toLocalJSDate(),notVisible:true})}}function _(e,t,a){if(e.button){return}var r=b.call(this,t);if(r){this._bMousedownChange=true}if(this._bMouseMove){T.call(this,true);this._bMoveChange=false}else if(r&&this.getIntervalSelection()&&this.$().is(":visible")){I.call(this,true)}e.preventDefault();e.setMark("cancelAutoClose")}function S(e,t){r._checkCalendarDate(e);var a=e.getYear();r._checkYearInValidRange(a);var o=true;if(!this.getDate()||!e.isSame(i.fromLocalJSDate(this.getDate(),this.getProperty("primaryCalendarType")))){var s=new i(e);s.setDate(1);o=this.checkDateFocusable(e.toLocalJSDate());if(!this._bNoRangeCheck&&!o){throw new Error("Date must be in visible date range; "+this)}this.setProperty("date",e.toLocalJSDate());this._oDate=s}if(this.getDomRef()){if(o){C.call(this,this._oDate,t)}}}function C(e,t){var a=this._oFormatYyyymm.format(e.toUTCJSDate(),true);var r=this._oItemNavigation.getItemDomRefs();var i;for(var o=0;o<r.length;o++){i=jQuery(r[o]);if(i.attr("data-sap-month")==a){if(document.activeElement!=r[o]){if(t){this._oItemNavigation.setFocusedIndex(o)}else{this._oItemNavigation.focusItem(o)}}break}}}function b(e,t){if(!this._checkMonthEnabled(e)){return false}var a=this.getSelectedDates();var r;var o=0;var s=this.getParent();var n=this;var l;if(s&&s.getSelectedDates){n=s}if(this.getSingleSelection()){if(a.length>0){r=a[0];l=r.getStartDate();if(l){l=i.fromLocalJSDate(l,this.getProperty("primaryCalendarType"));l.setDate(1)}}else{r=new p;n.addAggregation("selectedDates",r)}if(this.getIntervalSelection()&&(!r.getEndDate()||t)&&l){var h;if(e.isBefore(l)){h=l;l=e;if(!t){r.setProperty("startDate",l.toLocalJSDate());r.setProperty("endDate",h.toLocalJSDate())}}else if(e.isSameOrAfter(l)){h=e;if(!t){r.setProperty("endDate",h.toLocalJSDate())}}}else{r.setProperty("startDate",e.toLocalJSDate());r.setProperty("endDate",undefined)}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection")}else{var g=this._checkDateSelected(e);if(g>0){for(o=0;o<a.length;o++){l=a[o].getStartDate();if(l){l=i.fromLocalJSDate(l,this.getProperty("primaryCalendarType"));l.setDate(1);if(e.isSame(l)){n.removeAggregation("selectedDates",o);break}}}}else{r=new p({startDate:e.toLocalJSDate()});n.addAggregation("selectedDates",r)}}}return true}function M(){if(this._bMouseMove){T.call(this,true)}this.fireSelect()}function L(){if(!this._bNamesLengthChecked){var e=0;var t=this.$("months").children();var a=false;var r=this.getMonths();var i=Math.ceil(12/r);var o=0;var s=this._getLocaleData();var n=s.getMonthsStandAlone("wide",this.getProperty("primaryCalendarType"));var l;for(var h=0;h<i;h++){if(r<12){for(e=0;e<t.length;e++){l=jQuery(jQuery(t[e]).children(".sapUiCalItemText"));l.text(n[(e+o)%12])}o=o+r;if(o>11){o=11}}for(e=0;e<t.length;e++){var g=t[e];if(Math.abs(g.clientWidth-g.scrollWidth)>1){a=true;break}}if(a){break}}if(r<12){o=this._getStartDate().getMonth();for(e=0;e<t.length;e++){l=jQuery(jQuery(t[e]).children(".sapUiCalItemText"));l.text(n[(e+o)%12])}}if(a){this._bLongMonth=false;var p=s.getMonthsStandAlone("abbreviated",this.getProperty("primaryCalendarType"));o=this._getStartDate().getMonth();for(e=0;e<t.length;e++){l=jQuery(jQuery(t[e]).children(".sapUiCalItemText"));l.text(p[(e+o)%12])}}else{this._bLongMonth=true}this._bNamesLengthChecked=true}}function I(){jQuery(window.document).on("mousemove",this._mouseMoveProxy);this._bMouseMove=true}function T(){jQuery(window.document).off("mousemove",this._mouseMoveProxy);this._bMouseMove=undefined}return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/MonthsRowRenderer", ["sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/CalendarLegendRenderer","sap/ui/unified/library","sap/base/Log","sap/ui/core/date/UI5Date"],function(e,t,a,n,r,o){"use strict";var s=n.CalendarDayType;var l={apiVersion:2};l.render=function(e,t){var a=t._getStartDate();var n=t.getTooltip_AsString();var r=t.getId();var o={value:r+"-Descr",append:true};e.openStart("div",t);e.class("sapUiCalMonthsRow");e.class("sapUiCalRow");if(n){e.attr("title",n)}e.accessibilityState(t,{role:"grid",readonly:"true",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:o});e.openEnd();e.openStart("span",r+"-Descr");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_DIALOG"));e.close("span");if(t.getIntervalSelection()){e.openStart("span",r+"-Start");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_START_MONTH"));e.close("span");e.openStart("span",r+"-End");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_END_MONTH"));e.close("span")}this.renderRow(e,t,a);e.close("div")};l.renderRow=function(e,t,a){var n=t.getId();this.renderHeader(e,t,a);e.openStart("div",n+"-months");e.class("sapUiCalItems");e.attr("role","row");e.openEnd();this.renderMonths(e,t,a);e.close("div")};l.renderHeader=function(t,a,n){e._checkCalendarDate(n);if(a._getShowHeader()){var r=a._getLocaleData();var o=a.getId();t.openStart("div",o+"-Head");t.openEnd();this.renderHeaderLine(t,a,r,n);t.close("div")}};l.renderHeaderLine=function(a,n,r,o){e._checkCalendarDate(o);var s=n.getId();var l=n.getMonths();var d=new t(o);var i="";var c=0;var p=[];var g=0;for(g=0;g<l;g++){c=d.getYear();if(p.length>0&&p[p.length-1].iYear==c){p[p.length-1].iMonths++}else{p.push({iYear:c,iMonths:1})}d.setMonth(d.getMonth()+1)}for(g=0;g<p.length;g++){var h=p[g];i=100/l*h.iMonths+"%";a.openStart("div",s+"-Head"+g);a.class("sapUiCalHeadText");a.style("width",i);a.openEnd();a.text(h.iYear);a.close("div")}};l.renderMonths=function(e,a,n){var r=this.getHelper(a,n);var o=a.getMonths();var s=100/o+"%";var l=new t(n);l.setDate(1);for(var d=0;d<o;d++){this.renderMonth(e,a,l,r,s);l.setMonth(l.getMonth()+1)}};l.getHelper=function(a,n){e._checkCalendarDate(n);var s={};var l=a.getProperty("primaryCalendarType");s.sLocale=a._getLocale();s.oLocaleData=a._getLocaleData();s.oToday=t.fromLocalJSDate(o.getInstance(),l);s.sCurrentMonth=a._rb.getText("CALENDAR_CURRENT_MONTH");s.sId=a.getId();s.oFormatLong=a._getFormatLong();if(a._bLongMonth||!a._bNamesLengthChecked){s.aMonthNames=s.oLocaleData.getMonthsStandAlone("wide",l)}else{s.aMonthNames=s.oLocaleData.getMonthsStandAlone("abbreviated",l);s.aMonthNamesWide=s.oLocaleData.getMonthsStandAlone("wide",l)}var d=a.getLegend();if(d){var i=sap.ui.getCore().byId(d);if(i){if(!(i instanceof sap.ui.unified.CalendarLegend)){throw new Error(i+" is not an sap.ui.unified.CalendarLegend. "+a)}s.oLegend=i}else{r.warning("CalendarLegend "+d+" does not exist!",a)}}s.convertTextInfoToSecondaryType=function(e){var t=a._getSecondaryCalendarType(),n=s.oLocaleData.getMonthsStandAlone("abbreviated",t),r=a._oFormatYearInSecType,o=a._getDisplayedSecondaryDates(e.getMonth(),e.getYear()),l,d,i;if(o.start.getMonth()===o.end.getMonth()){l=n[o.start.getMonth()]}else{i=a._getLocaleData().getIntervalPattern();l=i.replace(/\{0\}/,n[o.start.getMonth()]).replace(/\{1\}/,n[o.end.getMonth()])}if(o.start.getYear()===o.end.getYear()){d=r.format(o.start.toUTCJSDate(),true)}else{d=i.replace(/\{0\}/,r.format(o.start.toUTCJSDate(),true)).replace(/\{1\}/,r.format(o.end.toUTCJSDate(),true))}return{sMonthInfo:l,sYearInfo:d}};return s};l.renderMonth=function(t,n,r,o,l){e._checkCalendarDate(r);var d=!!n._getSecondaryCalendarType(),i;if(d){i=o.convertTextInfoToSecondaryType(r)}var c={role:n._getAriaRole(),selected:false,label:"",describedby:""};var p=n._oFormatYyyymm.format(r.toUTCJSDate(),true);var g=n._checkDateSelected(r);var h=n._getDateType(r);var f=n._checkMonthEnabled(r);t.openStart("div",o.sId+"-"+p);t.class("sapUiCalItem");if(l){t.style("width",l)}if(e._isSameMonthAndYear(r,o.oToday)){t.class("sapUiCalItemNow");c["label"]=o.sCurrentMonth+" "}if(g>0){t.class("sapUiCalItemSel");c["selected"]=true}if(g==2){t.class("sapUiCalItemSelStart");c["describedby"]=c["describedby"]+" "+o.sId+"-Start"}else if(g==3){t.class("sapUiCalItemSelEnd");c["describedby"]=c["describedby"]+" "+o.sId+"-End"}else if(g==4){t.class("sapUiCalItemSelBetween")}else if(g==5){t.class("sapUiCalItemSelStart");t.class("sapUiCalItemSelEnd");c["describedby"]=c["describedby"]+" "+o.sId+"-Start";c["describedby"]=c["describedby"]+" "+o.sId+"-End"}if(h&&h.type!=s.None){t.class("sapUiCalItem"+h.type);if(h.tooltip){t.attr("title",h.tooltip)}}if(!f){t.class("sapUiCalItemDsbl");c["disabled"]=true}t.attr("tabindex","-1");t.attr("data-sap-month",p);c["label"]=c["label"]+o.oFormatLong.format(r.toUTCJSDate(),true);if(d){c["label"]=c["label"]+", "+i.sMonthInfo+" "+i.sYearInfo}if(h&&h.type!=s.None){a.addCalendarTypeAccInfo(c,h.type,o.oLegend)}t.accessibilityState(null,c);if(d){t.class("sapUiCalItemWithSecondaryType")}t.openEnd();t.openStart("span");t.class("sapUiCalItemText");t.openEnd();t.text(o.aMonthNames[r.getMonth()]);t.close("span");if(d){t.openStart("span");t.class("sapUiCalItemAddText");t.openEnd();t.text(i.sMonthInfo);t.close("span")}t.close("div")};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/OneMonthDatesRow", ["sap/ui/unified/calendar/DatesRow","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/library","./OneMonthDatesRowRenderer"],function(t,e,a,i,o){"use strict";var s=t.extend("sap.ui.unified.calendar.OneMonthDatesRow",{metadata:{library:"sap.ui.unified"},renderer:o});s.prototype.init=function(){t.prototype.init.apply(this,arguments);this.iMode=2};s.prototype.setMode=function(t){var e=this.getSelectedDates(),a,i=this.iMode!==t;this.iMode=t;if(i&&e.length){if(this.iMode<2){a=this.getStartDate()}e[0].setProperty("startDate",a)}this.iMode<2?this._bAlwaysShowSpecialDates=false:this._bAlwaysShowSpecialDates=true;return this};s.prototype.getMode=function(){return this.iMode};s.prototype.selectDate=function(t){if(this.iMode<2&&this.getSelectedDates().length){this.getSelectedDates()[0].setStartDate(t)}return this};s.prototype.setDate=function(e){if(!this._bNoRangeCheck&&!this.checkDateFocusable(e)){return this}t.prototype.setDate.apply(this,arguments);return this};s.prototype.getDays=function(){if(this.iMode===2){return 31}else{return e._daysInMonth(a.fromLocalJSDate(this.getStartDate(),this.getPrimaryCalendarType()))}};s.prototype.displayDate=function(e){if(!this._bNoRangeCheck&&!this.checkDateFocusable(e)){return this}t.prototype.displayDate.apply(this,arguments);return this};s.prototype.onsaphome=function(t){var e=a.fromLocalJSDate(this.getStartDate());r(t);this.setDate(e.toLocalJSDate());this._focusDate(e);this.fireFocus({date:e.toLocalJSDate(),otherMonth:false})};s.prototype.onsapend=function(t){var i=this.getStartDate(),o;o=a.fromLocalJSDate(i);o.setDate(e._daysInMonth(o));r(t);this.setDate(o.toLocalJSDate());this._focusDate(o);this.fireFocus({date:o.toLocalJSDate(),otherMonth:false})};function r(t){t.stopPropagation();t.preventDefault();t.stopImmediatePropagation(true)}return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/OneMonthDatesRowRenderer", ["sap/ui/core/Renderer","./MonthRenderer","./DatesRowRenderer"],function(e,r,a){"use strict";var n=e.extend(a);n.apiVersion=2;["getClass","renderMonth","renderDays","renderHeader"].forEach(function(e){n[e]=function(n,s){if(s.iMode<2){return r[e].apply(r,arguments)}else{if(e==="getClass"){var t=["sapUiCalDatesRow","sapUiCalRow","sapUiCalOneMonthDatesRow"];if(!s.getShowDayNamesLine()){t.push("sapUiCalNoNameLine")}return t}return a[e].apply(a,arguments)}}});return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/TimesRow", ["sap/ui/core/Control","sap/ui/core/LocaleData","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/calendar/CalendarUtils","sap/ui/core/date/UniversalDate","sap/ui/unified/library","sap/ui/core/format/DateFormat","sap/ui/core/Locale","./TimesRowRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange","sap/ui/core/Configuration","sap/ui/core/date/UI5Date"],function(e,t,a,i,r,s,n,o,l,g,u,jQuery,c,h,p){"use strict";var f=e.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}},renderer:l});f.prototype.init=function(){this._oFormatYyyyMMddHHmm=n.getInstance({pattern:"yyyyMMddHHmm",calendarType:this.getProperty("primaryCalendarType")});this._oFormatLong=n.getDateTimeInstance({style:"long/short",calendarType:this.getProperty("primaryCalendarType")});this._oFormatDate=n.getDateInstance({style:"medium",calendarType:this.getProperty("primaryCalendarType")});this._mouseMoveProxy=jQuery.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified")};f.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}};f.prototype.onAfterRendering=function(){d.call(this)};f.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){if(this._bMouseMove){M.call(this,true);C.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;I.call(this)}if(this._bMousedownChange){this._bMousedownChange=false;I.call(this)}}};f.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};f.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};f.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};f.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};f.prototype.setIntervalMinutes=function(e){if(e>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this)}if(1440%e>0){throw new Error("A day must be divisible by the interval size; "+this)}this.setProperty("intervalMinutes",e,false);this._oFormatTime=undefined;return this};f.prototype.setDate=function(e){D.call(this,e,false);return this.setProperty("date",e)};f.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=i._createUniversalUTCDate(p.getInstance(),undefined,true)}return this._oUTCDate};f.prototype.setStartDate=function(e){i._checkJSDateObject(e);var t=e.getFullYear();i._checkYearInValidRange(t);var a=i._createUniversalUTCDate(e,undefined,true);this.setProperty("startDate",e);this._oUTCStartDate=this._getIntervalStart(a);if(this.getDomRef()){var r=i._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(e);this._bNoRangeCheck=false;if(r&&this.checkDateFocusable(r)){this.displayDate(r)}}return this};f.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=i._createUniversalUTCDate(p.getInstance(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate)}return this._oUTCStartDate};f.prototype.displayDate=function(e){D.call(this,e,true);return this};f.prototype._getLocale=function(){var e=this.getParent();if(e&&e.getLocale){return e.getLocale()}else if(!this._sLocale){this._sLocale=h.getFormatSettings().getFormatLocale().toString()}return this._sLocale};f.prototype._getLocaleData=function(){var e=this.getParent();if(e&&e._getLocaleData){return e._getLocaleData()}else if(!this._oLocaleData){var a=this._getLocale();var i=new o(a);this._oLocaleData=t.getInstance(i)}return this._oLocaleData};f.prototype._getFormatLong=function(){var e=this._getLocale();if(this._oFormatLong.oLocale.toString()!=e){var t=new o(e);this._oFormatLong=n.getDateTimeInstance({style:"long/short",calendarType:this.getProperty("primaryCalendarType")},t)}return this._oFormatLong};f.prototype._getFormatTime=function(){var e=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=e){var t=new o(e);var a=this.getIntervalMinutes();var i=this._getLocaleData();var r;var s=i.getTimePattern("short");this._oFormatTimeAmPm=undefined;if(a%60==0){r=S(s);if(s.search("a")>=0){this._oFormatTimeAmPm=n.getTimeInstance({pattern:"a",calendarType:this.getProperty("primaryCalendarType")},t)}}else{r=s;r=r.replace("HH","H");r=r.replace("hh","h");if(r.search("a")>=0){this._oFormatTimeAmPm=n.getTimeInstance({pattern:"a",calendarType:this.getProperty("primaryCalendarType")},t);r=r.replace("a","").trim()}}this._oFormatTime=n.getTimeInstance({pattern:r,calendarType:this.getProperty("primaryCalendarType")},t)}return this._oFormatTime};f.prototype._getFormatDate=function(){var e=this._getLocale();if(this._oFormatDate.oLocale.toString()!=e){var t=new o(e);this._oFormatDate=n.getDateInstance({style:"medium",calendarType:this.getProperty("primaryCalendarType")},t)}return this._oFormatDate};f.prototype.getIntervalSelection=function(){var e=this.getParent();if(e&&e.getIntervalSelection){return e.getIntervalSelection()}else{return this.getProperty("intervalSelection")}};f.prototype.getSingleSelection=function(){var e=this.getParent();if(e&&e.getSingleSelection){return e.getSingleSelection()}else{return this.getProperty("singleSelection")}};f.prototype.getSelectedDates=function(){var e=this.getParent();if(e&&e.getSelectedDates){return e.getSelectedDates()}else{return this.getAggregation("selectedDates",[])}};f.prototype.getSpecialDates=function(){var e=this.getParent();if(e&&e.getSpecialDates){return e.getSpecialDates()}else{return this.getAggregation("specialDates",[])}};f.prototype._getShowHeader=function(){var e=this.getParent();if(e&&e._getShowItemHeader){return e._getShowItemHeader()}else{return this.getProperty("showHeader")}};f.prototype.getIntervalMinutes=function(){var e=this.getParent();if(e&&e.getIntervalMinutes){return e.getIntervalMinutes()}else{return this.getProperty("intervalMinutes")}};f.prototype.getAriaLabelledBy=function(){var e=this.getParent();if(e&&e.getAriaLabelledBy){return e.getAriaLabelledBy()}else{return this.getAssociation("ariaLabelledBy",[])}};f.prototype._setLegendControlOrigin=function(e){this._oLegendControlOrigin=e};f.prototype.getLegend=function(){var e=this.getParent();if(this._oLegendControlOrigin){return this._oLegendControlOrigin.getLegend()}if(e&&e.getLegend){return e.getLegend()}else{return this.getAssociation("ariaLabelledBy",[])}};f.prototype._checkDateSelected=function(e){if(!(e instanceof r)){throw new Error("Date must be a UniversalDate object "+this)}var t=0;var a=this.getSelectedDates();var s=new r(e.getTime());s=this._getIntervalStart(s);var n=s.getTime();for(var o=0;o<a.length;o++){var l=a[o];var g=l.getStartDate();var u=0;if(g){g=i._createUniversalUTCDate(g,undefined,true);g=this._getIntervalStart(g);u=g.getTime()}var c=l.getEndDate();var h=0;if(c){c=i._createUniversalUTCDate(c,undefined,true);c=this._getIntervalStart(c);h=c.getTime()}if(n==u&&!c){t=1;break}else if(n==u&&c){t=2;if(c&&n==h){t=5}break}else if(c&&n==h){t=3;break}else if(c&&n>u&&n<h){t=4;break}if(this.getSingleSelection()){break}}return t};f.prototype._getDateType=function(e){if(!(e instanceof r)){throw new Error("Date must be a UniversalDate object "+this)}var t;var a=this.getSpecialDates();var s=new r(e.getTime());s=this._getIntervalStart(s);var n=s.getTime();for(var o=0;o<a.length;o++){var l=a[o];var g=l.getStartDate();var u=0;if(g){g=i._createUniversalUTCDate(g,undefined,true);g=this._getIntervalStart(g);u=g.getTime()}var c=l.getEndDate();var h=0;if(c){c=i._createUniversalUTCDate(c,undefined,true);c=this._getIntervalStart(c);c.setUTCMinutes(c.getUTCMinutes()+this.getIntervalMinutes()-1);h=c.getTime()}else if(g.getUTCHours()==0&&g.getUTCMinutes()==0&&g.getUTCSeconds()==0&&g.getUTCMilliseconds()==0){c=new r(g.getTime());c.setUTCDate(c.getUTCDate()+1);h=c.getTime()}if(n==u&&!c||n>=u&&n<=h){t={type:l.getType(),tooltip:l.getTooltip_AsString(),color:l.getColor()};break}}return t};f.prototype._checkTimeEnabled=function(e){if(!(e instanceof r)){throw new Error("Date must be a UniversalDate object "+this)}var t=e.getTime();var a=this.getParent();if(a&&a._oMinDate&&a._oMaxDate){if(t<a._oMinDate.getTime()||t>a._oMaxDate.getTime()){return false}}return true};f.prototype._handleMouseMove=function(e){if(!this.$().is(":visible")){M.call(this,true)}var t=jQuery(e.target);if(t.hasClass("sapUiCalItemText")){t=t.parent()}if(t.hasClass("sapUiCalItem")){var a=this._getDate();var i=new r(this._oFormatYyyyMMddHHmm.parse(t.attr("data-sap-time"),true).getTime());if(i.getTime()!=a.getTime()){this._oUTCDate=i;C.call(this,i,true);this._bMoveChange=true}}};f.prototype.onmouseup=function(e){if(this._bMouseMove){M.call(this,true);var t=this._getDate();var a=this._oItemNavigation.getItemDomRefs();for(var i=0;i<a.length;i++){var s=jQuery(a[i]);if(s.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(t.getJSDate(),true)){s.trigger("focus");break}}if(this._bMoveChange){var n=jQuery(e.target);if(n.hasClass("sapUiCalItemText")){n=n.parent()}if(n.hasClass("sapUiCalItem")){t=new r(this._oFormatYyyyMMddHHmm.parse(n.attr("data-sap-time"),true).getTime())}C.call(this,t);this._bMoveChange=false;this._bMousedownChange=false;I.call(this)}}if(this._bMousedownChange){this._bMousedownChange=false;I.call(this)}};f.prototype.onsapselect=function(e){var t=C.call(this,this._getDate());if(t){I.call(this)}e.stopPropagation();e.preventDefault()};f.prototype.onsapselectmodifiers=function(e){this.onsapselect(e)};f.prototype.onsappageupmodifiers=function(e){var t=new r(this._getDate().getTime());var a=t.getUTCDate();if(e.metaKey||e.ctrlKey){t.setUTCDate(a-7)}else{t.setUTCDate(a-1)}this.fireFocus({date:i._createLocalDate(t,true),notVisible:true});e.preventDefault()};f.prototype.onsappagedownmodifiers=function(e){var t=new r(this._getDate().getTime());var a=t.getUTCDate();if(e.metaKey||e.ctrlKey){t.setUTCDate(a+7)}else{t.setUTCDate(a+1)}this.fireFocus({date:i._createLocalDate(t,true),notVisible:true});e.preventDefault()};f.prototype.checkDateFocusable=function(e){i._checkJSDateObject(e);if(this._bNoRangeCheck){return false}var t=this._getStartDate();var a=new r(t.getTime());a.setUTCMinutes(a.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var s=i._createUniversalUTCDate(e,undefined,true);if(s.getTime()>=t.getTime()&&s.getTime()<a.getTime()){return true}else{return false}};f.prototype.applyFocusInfo=function(e){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this};f.prototype._getIntervalStart=function(e){var t=e.getTime();var a=new r(e.getTime());a.setUTCHours(0);a.setUTCMinutes(0);a.setUTCSeconds(0);a.setUTCMilliseconds(0);var i=this.getIntervalMinutes();while(a.getTime()<=t){a.setUTCMinutes(a.getUTCMinutes()+i)}var s=new r(a.getTime());s.setUTCMinutes(s.getUTCMinutes()-i);return s};f.prototype._setAriaRole=function(e){this._ariaRole=e;return this};f.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell"};f.prototype._updateItemARIASelected=function(e,t){var a=this._getAriaRole();if(a==="gridcell"){e.attr("aria-selected",t)}return this};function d(){var e=this._getDate();var t=this._oFormatYyyyMMddHHmm.format(e.getJSDate(),true);var i=0;var r=this.$("times").get(0);var s=this.$("times").children(".sapUiCalItem");for(var n=0;n<s.length;n++){var o=jQuery(s[n]);if(o.attr("data-sap-time")===t){i=n;break}}if(!this._oItemNavigation){this._oItemNavigation=new a;this._oItemNavigation.attachEvent(a.Events.AfterFocus,m,this);this._oItemNavigation.attachEvent(a.Events.FocusAgain,v,this);this._oItemNavigation.attachEvent(a.Events.BorderReached,_,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true)}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(s);this._oItemNavigation.setFocusedIndex(i);this._oItemNavigation.setPageSize(s.length)}function m(e){var t=e.getParameter("index");var a=e.getParameter("event");if(!a){return}var s=this._getDate();var n=new r(s.getTime());var o=this._oItemNavigation.getItemDomRefs();var l=jQuery(o[t]);n=new r(this._oFormatYyyyMMddHHmm.parse(l.attr("data-sap-time"),true).getTime());this._oUTCDate=n;this.fireFocus({date:i._createLocalDate(n,true),notVisible:false});if(a.type=="mousedown"){y.call(this,a,n,t)}}function v(e){var t=e.getParameter("index");var a=e.getParameter("event");if(!a){return}if(a.type=="mousedown"){var i=this._getDate();y.call(this,a,i,t)}}function _(e){var t=e.getParameter("event");var a=this.getItems();var s=this.getIntervalMinutes();var n=this._getDate();var o=new r(n.getTime());if(t.type){switch(t.type){case"sapnext":case"sapnextmodifiers":o.setUTCMinutes(o.getUTCMinutes()+s);break;case"sapprevious":case"sappreviousmodifiers":o.setUTCMinutes(o.getUTCMinutes()-s);break;case"sappagedown":o.setUTCMinutes(o.getUTCMinutes()+s*a);break;case"sappageup":o.setUTCMinutes(o.getUTCMinutes()-s*a);break;default:break}this.fireFocus({date:i._createLocalDate(o,true),notVisible:true})}}function y(e,t,a){if(e.button){return}var i=C.call(this,t);if(i){this._bMousedownChange=true}if(this._bMouseMove){M.call(this,true);this._bMoveChange=false}else if(this.getIntervalSelection()&&this.$().is(":visible")){b.call(this,true)}e.preventDefault();e.setMark("cancelAutoClose")}function D(e,t){i._checkJSDateObject(e);var a=e.getFullYear();i._checkYearInValidRange(a);var r=true;if(!u(this.getDate(),e)){var s=i._createUniversalUTCDate(e,undefined,true);s=this._getIntervalStart(s);r=this.checkDateFocusable(e);if(!this._bNoRangeCheck&&!r){throw new Error("Date must be in visible date range; "+this)}this.setProperty("date",e);this._oUTCDate=s}if(this.getDomRef()){if(r){T.call(this,this._oUTCDate,t)}else{this.setDate(e)}}}function T(e,t){var a=this._oFormatYyyyMMddHHmm.format(e.getJSDate(),true);var i=this._oItemNavigation.getItemDomRefs();var r;for(var s=0;s<i.length;s++){r=jQuery(i[s]);if(r.attr("data-sap-time")==a){if(document.activeElement!=i[s]){if(t){this._oItemNavigation.setFocusedIndex(s)}else{this._oItemNavigation.focusItem(s)}}break}}}function C(e,t){if(!this._checkTimeEnabled(e)){return false}var a=this.getSelectedDates();var r;var s=0;var n=this.getParent();var o=this;var l;if(n&&n.getSelectedDates){o=n}if(this.getSingleSelection()){if(a.length>0){r=a[0];l=r.getStartDate();if(l){l=i._createUniversalUTCDate(l,undefined,true);l=this._getIntervalStart(l)}}else{r=new c;o.addAggregation("selectedDates",r)}if(this.getIntervalSelection()&&(!r.getEndDate()||t)&&l){var g;if(e.getTime()<l.getTime()){g=l;l=e;if(!t){r.setProperty("startDate",i._createLocalDate(p.getInstance(l.getTime()),true));r.setProperty("endDate",i._createLocalDate(p.getInstance(g.getTime()),true))}}else if(e.getTime()>=l.getTime()){g=e;if(!t){r.setProperty("endDate",i._createLocalDate(p.getInstance(g.getTime()),true))}}}else{r.setProperty("startDate",i._createLocalDate(p.getInstance(e.getTime()),true));r.setProperty("endDate",undefined)}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection")}else{var u=this._checkDateSelected(e);if(u>0){for(s=0;s<a.length;s++){l=a[s].getStartDate();if(l){l=i._createUniversalUTCDate(l,undefined,true);l=this._getIntervalStart(l);if(e.getTime()==l.getTime()){o.removeAggregation("selectedDates",s);break}}}}else{r=new c({startDate:i._createLocalDate(p.getInstance(e.getTime()),true)});o.addAggregation("selectedDates",r)}}}return true}function I(){if(this._bMouseMove){M.call(this,true)}this.fireSelect()}function b(){jQuery(window.document).on("mousemove",this._mouseMoveProxy);this._bMouseMove=true}function M(){jQuery(window.document).off("mousemove",this._mouseMoveProxy);this._bMouseMove=undefined}function S(e){var t;if(e.toUpperCase().indexOf("K")>-1){t=e.indexOf("k")>-1?"k":"K"}else{t=e.indexOf("h")>-1?"h":"H"}return t}return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/TimesRowRenderer", ["sap/ui/unified/calendar/CalendarUtils","sap/ui/core/format/TimezoneUtil","sap/ui/core/Core","sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarLegendRenderer","sap/ui/core/date/UI5Date","sap/ui/unified/library","sap/base/Log"],function(e,t,a,r,i,s,n,l){"use strict";var o=n.CalendarDayType;var d={apiVersion:2};d.render=function(e,t){var a=t._getStartDate();var r=t.getTooltip_AsString();var i=t.getId();var s={value:i+"-Descr",append:true};e.openStart("div",t);e.class("sapUiCalTimesRow");e.class("sapUiCalRow");if(r){e.attr("title",r)}if(t._getShowHeader()){s.value=s.value+" "+i+"-Head"}e.accessibilityState(t,{role:"grid",readonly:"true",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:s});e.openEnd();e.openStart("span",i+"-Descr");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_DIALOG"));e.close("span");if(t.getIntervalSelection()){e.openStart("span",i+"-Start");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_START_TIME"));e.close("span");e.openStart("span",i+"-End");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_END_TIME"));e.close("span")}this.renderRow(e,t,a);e.close("div")};d.renderRow=function(e,t,a){var r=t.getId();this.renderHeader(e,t,a);e.openStart("div",r+"-times");e.class("sapUiCalItems");e.attr("role","row");e.openEnd();this.renderTimes(e,t,a);e.close("div")};d.renderHeader=function(e,t,a){if(t._getShowHeader()){var r=t._getLocaleData();var i=t.getId();e.openStart("div",i+"-Head");e.openEnd();this.renderHeaderLine(e,t,r,a);e.close("div")}};d.renderHeaderLine=function(e,t,a,r){var i=t._getFormatDate();var s=t.getId();var n=t.getItems();var l=t._getIntervalStart(r);var o=t.getIntervalMinutes();var d="";var c=0;var p=[];var m=0;for(m=0;m<n;m++){c=i.format(l,true);if(p.length>0&&p[p.length-1].sDay==c){p[p.length-1].iItems++}else{p.push({sDay:c,iItems:1})}l.setUTCMinutes(l.getUTCMinutes()+o)}for(m=0;m<p.length;m++){var g=p[m];d=100/n*g.iItems+"%";e.openStart("div",s+"-Head"+m);e.class("sapUiCalHeadText");e.style("width",d);e.openEnd();e.text(g.sDay);e.close("div")}};d.renderTimes=function(e,t,a){var r=this.getHelper(t,a);var i=t.getItems();var s=100/i+"%";var n=t._getIntervalStart(a);var l="";var o="";for(var d=0;d<i;d++){if(r.oFormatTimeAmPm){o=r.oFormatTimeAmPm.format(n,true);if(l==o){o=""}else{l=o}}this.renderTime(e,t,n,r,s,o);n.setUTCMinutes(n.getUTCMinutes()+r.iMinutes)}};d.getHelper=function(t,a){var r={};r.sLocale=t._getLocale();r.oLocaleData=t._getLocaleData();r.oNow=e._createUniversalUTCDate(s.getInstance(),undefined,true);r.sCurrentTime=t._rb.getText("CALENDAR_CURRENT_TIME");r.sId=t.getId();r.oFormatLong=t._getFormatLong();r.oFormatTime=t._getFormatTime();r.oFormatTimeAmPm=t._oFormatTimeAmPm;r.iMinutes=t.getIntervalMinutes();var i=t.getLegend();if(i){var n=sap.ui.getCore().byId(i);if(n){if(!(n instanceof sap.ui.unified.CalendarLegend)){throw new Error(n+" is not an sap.ui.unified.CalendarLegend. "+t)}r.oLegend=n}else{l.warning("CalendarLegend "+i+" does not exist!",t)}}return r};d.renderTime=function(e,t,a,s,n,l){var d=t._getAriaRole();var c={role:d,selected:d!=="gridcell"?null:false,label:"",describedby:""};var p=t._oFormatYyyyMMddHHmm.format(a.getJSDate(),true);var m=t._checkDateSelected(a);var g=t._getDateType(a);var u=t._checkTimeEnabled(a);e.openStart("div",s.sId+"-"+p);e.class("sapUiCalItem");if(n){e.style("width",n)}var v=new r(a.getTime());v.setUTCMinutes(v.getUTCMinutes()+s.iMinutes);if(a.getTime()<=s.oNow.getTime()&&v.getTime()>s.oNow.getTime()){e.class("sapUiCalItemNow");c["label"]=s.sCurrentTime+" "}if(m>0){e.class("sapUiCalItemSel");if(d==="gridcell"){c["selected"]=true}}if(m==2){e.class("sapUiCalItemSelStart");c["describedby"]=c["describedby"]+" "+s.sId+"-Start"}else if(m==3){e.class("sapUiCalItemSelEnd");c["describedby"]=c["describedby"]+" "+s.sId+"-End"}else if(m==4){e.class("sapUiCalItemSelBetween")}else if(m==5){e.class("sapUiCalItemSelStart");e.class("sapUiCalItemSelEnd");c["describedby"]=c["describedby"]+" "+s.sId+"-Start";c["describedby"]=c["describedby"]+" "+s.sId+"-End"}if(g&&g.type!=o.None){e.class("sapUiCalItem"+g.type);if(g.tooltip){e.attr("title",g.tooltip)}}if(!u){e.class("sapUiCalItemDsbl");c["disabled"]=true}e.attr("tabindex","-1");e.attr("data-sap-time",p);c["label"]=c["label"]+s.oFormatLong.format(a,true);if(g&&g.type!=o.None){i.addCalendarTypeAccInfo(c,g.type,s.oLegend)}e.accessibilityState(null,c);e.openEnd();if(g&&g.type!=o.None){e.openStart("div");e.class("sapUiCalSpecialDate");if(g.color){e.style("background-color",g.color)}e.openEnd();e.close("div")}e.openStart("span");e.class("sapUiCalItemText");e.openEnd();e.text(s.oFormatTime.format(a,true));if(l){e.openStart("span");e.class("sapUiCalItemTextAmPm");e.openEnd();e.text(l);e.close("span")}e.close("span");e.close("div")};return d},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/YearPicker", ["sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/DateRange","sap/ui/unified/library","sap/ui/core/format/DateFormat","sap/ui/core/library","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/date/UI5Date","./YearPickerRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,a,r,i,s,o,n,l,h,d,p,g,y,jQuery,c){"use strict";var u=l.CalendarType;var m=e.extend("sap.ui.unified.calendar.YearPicker",{metadata:{library:"sap.ui.unified",properties:{year:{type:"int",group:"Data",defaultValue:2e3,deprecated:true},years:{type:"int",group:"Appearance",defaultValue:20},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},columns:{type:"int",group:"Appearance",defaultValue:4},date:{type:"object",group:"Data"},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},_middleDate:{type:"object",group:"Data",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"}},events:{select:{},pageChange:{}}},renderer:g});m.prototype.init=function(){var e=p.getInstance();e.setFullYear(2e3);this.setProperty("date",e);this._oFormatYyyymmdd=n.getInstance({pattern:"yyyyMMdd",calendarType:u.Gregorian});this._oMinDate=r._minDate(this._getPrimaryCalendarType());this._oMaxDate=r._maxDate(this._getPrimaryCalendarType())};m.prototype.onBeforeRendering=function(){this._oYearFormat=n.getDateInstance({format:"y",calendarType:this._getPrimaryCalendarType()})};m.prototype.onAfterRendering=function(){f.call(this);this.focus()};m.prototype.exit=function(){if(this._aMPSelectedDates&&this._aMPSelectedDates.length){this._aMPSelectedDates.forEach(function(e){e.destroy()});this._aMPSelectedDates=undefined}};m.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._iSelectedIndex]};m.prototype.setYear=function(e){this.setProperty("year",e);e=this.getProperty("year");var t=new i(e,0,1,this._getPrimaryCalendarType()),a=this._getSelectedDates()[0],r=this.getAggregation("selectedDates");if(!a||this.getIntervalSelection()){return this}if(!this._oSelectedDatesControlOrigin){if(!r||!r.length){this.addAggregation("selectedDates",a)}!this.getIntervalSelection()&&a.setStartDate(t.toLocalJSDate())}this.setDate(t.toLocalJSDate());return this};m.prototype.setDate=function(e){var t=r._maxDate(this.getProperty("primaryCalendarType")).getYear(),a,s,o,n;e&&r._checkJSDateObject(e);s=e.getFullYear();r._checkYearInValidRange(s);a=i.fromLocalJSDate(e,this._getPrimaryCalendarType());a.setMonth(0,1);this.setProperty("date",e);this.setProperty("year",a.getYear());this._oDate=a;o=this.getYears();n=Math.floor(o/2);if(e.getFullYear()<n){this._iSelectedIndex=e.getFullYear()-1}else if(e.getFullYear()>t-n){this._iSelectedIndex=t+o-e.getFullYear()-1}else{this._iSelectedIndex=n}this.setProperty("_middleDate",a);return this};m.prototype._getDate=function(){if(!this._oDate){var e=this.getDate().getFullYear();this._oDate=new i(e,0,1,this._getPrimaryCalendarType())}return this._oDate};m.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||c.getCalendarType()};m.prototype._setSelectedDatesControlOrigin=function(e){this._oSelectedDatesControlOrigin=e};m.prototype.getSelectedDates=function(){if(this._oSelectedDatesControlOrigin){return this._oSelectedDatesControlOrigin.getSelectedDates()}return this.getAggregation("selectedDates")};m.prototype._getSelectedDates=function(){var e=this.getSelectedDates();if(e){return e}else if(!this._aMPSelectedDates||!this._aMPSelectedDates.length){this._aMPSelectedDates=[new s];this._aMPSelectedDates[0].setStartDate(this._getDate().toLocalJSDate());return this._aMPSelectedDates}else{return this._aMPSelectedDates}};m.prototype.setPrimaryCalendarType=function(e){this.setProperty("primaryCalendarType",e);this._oYearFormat=n.getDateInstance({format:"y",calendarType:e});if(this._oDate){this._oDate=new i(this._oDate,e);this._oDate.setMonth(0,1)}this._oMinDate=new i(this._oMinDate,e);this._oMaxDate=new i(this._oMaxDate,e);if(this._getSecondaryCalendarType()){this.setColumns(2);this.setYears(8)}return this};m.prototype.nextPage=function(){this._updatePage(true,this._oItemNavigation.getFocusedIndex());return this};m.prototype.previousPage=function(){this._updatePage(false,this._oItemNavigation.getFocusedIndex());return this};m.prototype.onsapspace=function(e){e.preventDefault()};m.prototype.onsapselect=function(e){var t=this._oItemNavigation.getFocusedIndex();var a=this._selectYear(t);if(a){this.fireSelect()}};m.prototype.onmouseover=function(e){var t=e.target,a=this._getSelectedDates()[0],r,s,o;if(!a){return}if(a.getStartDate()){r=i.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());r.setMonth(0,1)}if(t.classList.contains("sapUiCalItem")){o=t.getAttribute("data-sap-year-start");s=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(o),this._getPrimaryCalendarType());if(this._isSelectionInProgress()){this._markInterval(r,s)}}};m.prototype.onmousedown=function(e){this._oMousedownPosition={clientX:e.clientX,clientY:e.clientY}};m.prototype.onmouseup=function(e){var a=e.target,r=this._getSelectedDates()[0],s,o,n,l,h=this._oItemNavigation.getItemDomRefs();if(this._bMousedownChange){this._bMousedownChange=false;if(this.getIntervalSelection()&&a.classList.contains("sapUiCalItem")&&r){o=a.getAttribute("data-sap-year-start");l=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(o),this._getPrimaryCalendarType());n=i.fromLocalJSDate(r.getStartDate(),this._getPrimaryCalendarType());n.setMonth(0,1);if(!l.isSame(n)&&!r.getEndDate()){s=h.index(a);this._selectYear.call(this,s);this._oItemNavigation.focusItem(s)}}this.fireSelect()}else if(t.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,e.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,e.clientY,10)){s=this._oItemNavigation.getFocusedIndex();if(!h[s].classList.contains("sapUiCalItemDsbl")){this._selectYear(s);this.fireSelect()}}};m.prototype._markInterval=function(e,t){var a=this._oItemNavigation.getItemDomRefs(),s,o,n;if(e.isAfter(t)){t=[e,e=t][0]}for(n=0;n<a.length;++n){o=a[n].getAttribute("data-sap-year-start");s=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(o),this._getPrimaryCalendarType());if(this._bMousedownChange){if((s.isSame(e)||s.isSame(t))&&!r._isOutside(s,this._oMinDate,this._oMaxDate)){jQuery(a[n]).addClass("sapUiCalItemSel")}else{jQuery(a[n]).removeClass("sapUiCalItemSel")}}if(r._isBetween(s,e,t)&&r._isBetween(s,this._oMinDate,this._oMaxDate)){jQuery(a[n]).addClass("sapUiCalItemSelBetween")}else{jQuery(a[n]).removeClass("sapUiCalItemSelBetween")}}};m.prototype.getFirstRenderedDate=function(){var e;if(this.getDomRef()){var t=this._oItemNavigation.getItemDomRefs();e=this._oFormatYyyymmdd.parse(jQuery(t[0]).attr("data-sap-year-start"))}return e};m.prototype._isValueInThreshold=function(e,t,a){var r=e-a,i=e+a;return t>=r&&t<=i};m.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);if(this._getSecondaryCalendarType()){this.setColumns(2);this.setYears(8)}return this};m.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};m.prototype._getDisplayedSecondaryDates=function(e){var t=this.getSecondaryCalendarType(),a=new i(e,e.getCalendarType()),r=new i(e,e.getCalendarType());a.setMonth(0,1);a=new i(a,t);r.setYear(r.getYear()+1);r.setMonth(0,1);r.setDate(r.getDate()-1);r=new i(r,t);return{start:a,end:r}};m.prototype._getLocale=function(){var e=this._oSelectedDatesControlOrigin;if(e&&e._getLocale){return e._getLocale()}else if(!this._sLocale){this._sLocale=c.getFormatSettings().getFormatLocale().toString()}return this._sLocale};m.prototype._getLocaleData=function(){var e=this._oSelectedDatesControlOrigin;if(e&&e._getLocaleData){return e._getLocaleData()}else if(!this._oLocaleData){var t=this._getLocale();var a=new h(t);this._oLocaleData=d.getInstance(a)}return this._oLocaleData};m.prototype._checkFirstDate=function(e){var t=this.getYears(),a=new i(this._oMaxDate,this._getPrimaryCalendarType());if(!a.isSame(r._maxDate(this._getPrimaryCalendarType()))){return e}a.setYear(a.getYear()-t+1);if(e.isAfter(a)&&e.getYear()!=a.getYear()){e=new i(a,this._getPrimaryCalendarType());e.setMonth(0,1)}else if(e.isBefore(this._oMinDate)&&e.getYear()!=this._oMinDate.getYear()){e=new i(this._oMinDate,this._getPrimaryCalendarType());e.setMonth(0,1)}return e};m.prototype._checkDateEnabled=function(e){var t=true;if(e.isAfter(this._oMaxDate)&&e.getYear()!=this._oMaxDate.getYear()||e.isBefore(this._oMinDate)&&e.getYear()!=this._oMinDate.getYear()){t=false}return t};m.prototype._updatePage=function(e,t,a){var r=this._oItemNavigation.getItemDomRefs();var s=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(jQuery(r[0]).attr("data-sap-year-start")),this._getPrimaryCalendarType());var o=this.getYears();if(e){var n=new i(this._oMaxDate,this._getPrimaryCalendarType());n.setYear(n.getYear()-o+1);if(s.isBefore(n)){s.setYear(s.getYear()+o);if(s.isAfter(n)){t=t+(s.getYear()-n.getYear());if(t>o-1){t=o-1}s=new i(this._oMaxDate,this._getPrimaryCalendarType());this._oDate.setMonth(0,1)}}else{return}}else{if(s.isAfter(this._oMinDate)){s.setYear(s.getYear()-o);if(s.isBefore(this._oMinDate)){t=t-(this._oMinDate.getYear()-s.getYear());if(t<0){t=0}s=new i(this._oMinDate,this._getPrimaryCalendarType())}}else{return}}s.setYear(s.getYear()+Math.floor(o/2));this._iSelectedIndex=t;this.setProperty("_middleDate",s);if(a){this.firePageChange()}};m.prototype._selectYear=function(e){var t=this._oItemNavigation.getItemDomRefs(),a=jQuery(t[e]),r=a.attr("data-sap-year-start"),s=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(r),this._getPrimaryCalendarType()),o=this._getSelectedDates()[0],n=this.getAggregation("selectedDates"),l;if(a.hasClass("sapUiCalItemDsbl")){return false}if(!this._isSelectionInProgress()){var h=true}this.setProperty("year",s.getYear(),h);this.setProperty("date",s.toLocalJSDate(),h);if(!o){return true}if(!this._oSelectedDatesControlOrigin){if(!n||!n.length){this.addAggregation("selectedDates",o)}!this.getIntervalSelection()&&o.setStartDate(s.toLocalJSDate(),h)}if(this.getIntervalSelection()){if(!o.getStartDate()){o.setStartDate(s.toLocalJSDate(),h)}else if(!o.getEndDate()){l=i.fromLocalJSDate(o.getStartDate(),this._getPrimaryCalendarType());if(s.isBefore(l)){o.setEndDate(l.toLocalJSDate(),h);o.setStartDate(s.toLocalJSDate(),h)}else{o.setEndDate(s.toLocalJSDate(),h)}}else{o.setStartDate(s.toLocalJSDate(),h);o.setEndDate(undefined,h)}}if(h){for(var d=0;d<t.length;d++){a=jQuery(t[d]);r=a.attr("data-sap-year-start");var p=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(r),this._getPrimaryCalendarType());var g=this._fnShouldApplySelection(p);var y=this._fnShouldApplySelectionBetween(p);if(g){a.addClass("sapUiCalItemSel");a.removeClass("sapUiCalItemSelBetween");a.attr("aria-selected","true")}if(y){a.addClass("sapUiCalItemSelBetween");a.attr("aria-selected","true")}if(!g&&!y){a.removeClass("sapUiCalItemSel");a.removeClass("sapUiCalItemSelBetween");a.attr("aria-selected","false")}}}return true};m.prototype._isSelectionInProgress=function(){var e=this._getSelectedDates()[0];if(!e){return false}return this.getIntervalSelection()&&e.getStartDate()&&!e.getEndDate()};function f(){var e=this.getDate()?i.fromLocalJSDate(this.getDate(),this._getPrimaryCalendarType()):this._getDate(),t=this.getDomRef(),s=this.$().find(".sapUiCalItem"),o,n,l,h;for(h=0;h<s.length;++h){n=s[h].getAttribute("data-sap-year-start");l=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(n),this._getPrimaryCalendarType());if(l.isSame(e)){o=h;break}}if(!this._oItemNavigation){this._oItemNavigation=new a;this._oItemNavigation.attachEvent(a.Events.AfterFocus,_,this);this._oItemNavigation.attachEvent(a.Events.FocusAgain,D,this);this._oItemNavigation.attachEvent(a.Events.BorderReached,S,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]})}this._oItemNavigation.setRootDomRef(t);this._oItemNavigation.setItemDomRefs(s);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this.getColumns(),true);if(r._isBetween(e,this._oMinDate,this._oMaxDate,true)){this._oItemNavigation.setFocusedIndex(o)}this._oItemNavigation.setPageSize(s.length)}function _(e){var t=e.getParameter("index"),a=e.getParameter("event"),r=this._oItemNavigation.aItemDomRefs[t],s=this._getSelectedDates()[0],o,n,l;if(!a){return}if(a.type==="mousedown"){this._handleMousedown(a,t)}else if(a.type==="sapnext"||a.type==="sapprevious"){if(!s){return}if(s.getStartDate()){o=i.fromLocalJSDate(s.getStartDate(),this._getPrimaryCalendarType());o.setMonth(0,1)}l=r.getAttribute("data-sap-year-start");n=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(l),this._getPrimaryCalendarType());if(this._isSelectionInProgress()){this._markInterval(o,n)}}}function D(e){_.call(this,e)}m.prototype._handleMousedown=function(e,a){if(e.button||t.support.touch&&!t.system.combi){return}var r=this._selectYear(a);if(r){this._bMousedownChange=true}e.preventDefault();e.setMark("cancelAutoClose")};function S(e){var t=e.getParameter("event"),a=this._oItemNavigation.getFocusedIndex(),r=this.getYears(),s=this.getColumns(),o=this._getSelectedDates()[0],n=this._oItemNavigation.getItemDomRefs(),l,h,d;if(o&&o.getStartDate()){l=i.fromLocalJSDate(o.getStartDate(),this._getPrimaryCalendarType());l.setMonth(0,1)}if(t.type){if(s===0){s=r}switch(t.type){case"sapnext":case"sapnextmodifiers":if(t.keyCode===y.ARROW_DOWN&&s<r){d=n[a-r+s].getAttribute("data-sap-year-start");h=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(true,a-r+s,true);this._iSelectedIndex=a-r+s}else{d=n[0].getAttribute("data-sap-year-start");h=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(true,0,true)}break;case"sapprevious":case"sappreviousmodifiers":if(t.keyCode===y.ARROW_UP&&s<r){d=n[r-s+a].getAttribute("data-sap-year-start");h=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(false,r-s+a,true);this._iSelectedIndex=r-s+a}else{d=n[r-1].getAttribute("data-sap-year-start");h=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(false,r-1,true)}break;case"sappagedown":d=n[a].getAttribute("data-sap-year-start");h=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(true,a,true);break;case"sappageup":d=n[a].getAttribute("data-sap-year-start");h=i.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(false,a,true);break;default:break}}this._isSelectionInProgress()&&this._markInterval(l,h)}m.prototype._fnShouldApplySelection=function(e){var t=this._getSelectedDates()[0],a,r;if(!t){return false}a=t.getStartDate();r=t.getEndDate();if(a){a=i.fromLocalJSDate(a,this._getPrimaryCalendarType());a.setMonth(0,1)}if(this.getIntervalSelection()&&a&&r){r=i.fromLocalJSDate(r,this._getPrimaryCalendarType());r.setMonth(0,1);if(e.isSame(a)||e.isSame(r)){return true}}else if(a&&e.isSame(a)){return true}return false};m.prototype._fnShouldApplySelectionBetween=function(e){var t=this._getSelectedDates()[0],a,s;if(!t){return false}a=t.getStartDate();s=t.getEndDate();if(this.getIntervalSelection()&&a&&s){a=i.fromLocalJSDate(a,this._getPrimaryCalendarType());a.setMonth(0,1);s=i.fromLocalJSDate(s,this._getPrimaryCalendarType());s.setMonth(0,1);if(r._isBetween(e,a,s)){return true}}return false};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/YearPickerRenderer", ["sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/CalendarUtils","sap/ui/core/date/UniversalDate","sap/ui/core/format/DateFormat","sap/ui/core/InvisibleText"],function(e,t,a,r,i){"use strict";var l={apiVersion:2};l.render=function(e,t){var a=t.getTooltip_AsString();e.openStart("div",t);e.class("sapUiCalYearPicker");if(t._getSecondaryCalendarType()){e.class("sapUiCalMonthSecType")}if(a){e.attr("title",a)}e.accessibilityState(t,this.getAccessibilityState(t));e.openEnd();this.renderCells(e,t);e.close("div")};l.getAccessibilityState=function(e){return{role:"grid",readonly:"true",multiselectable:e.getIntervalSelection(),roledescription:sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("YEAR_PICKER"),describedby:e._bCalendar?i.getStaticId("sap.ui.unified","CALENDAR_YEAR_RANGE_PICKER_OPEN_HINT"):""}};l.renderCells=function(i,l){var s=l.getProperty("_middleDate")?l.getProperty("_middleDate"):l._getDate(),n=new e(s,l.getPrimaryCalendarType()),d=t._minDate(l.getProperty("primaryCalendarType")).getYear(),o=t._maxDate(l.getProperty("primaryCalendarType")).getYear(),c=l.getYears(),p=l.getId(),y=l.getColumns(),u=l._getSecondaryCalendarType(),g="",f=false,C=l._getLocaleData(),S,m,_,D,T,b;n.setYear(n.getYear()-Math.floor(c/2));if(n.getYear()<d){n.setYear(d)}else if(n.getYear()+c>o){n.setYear(o-c+1)}if(y>0){g=100/y+"%"}else{g=100/c+"%"}for(b=0;b<c;b++){T=l._oFormatYyyymmdd.format(n.toUTCJSDate(),true);D={role:"gridcell"};f=l._checkDateEnabled(n);if(y>0&&b%y==0){i.openStart("div");i.accessibilityState(null,{role:"row"});i.openEnd()}i.openStart("div",p+"-y"+T);i.class("sapUiCalItem");m=l._fnShouldApplySelection(n);_=l._fnShouldApplySelectionBetween(n);if(m){i.class("sapUiCalItemSel");D["selected"]=true}if(_){i.class("sapUiCalItemSelBetween");D["selected"]=true}if(!m&&!_){D["selected"]=false}if(!f){i.class("sapUiCalItemDsbl");D["disabled"]=true}S=l._oYearFormat.format(a.getInstance(n.toUTCJSDate(),n.getCalendarType()),true);D["label"]=S;if(u){var Y=l._getDisplayedSecondaryDates(n),v=r.getDateInstance({format:"y",calendarType:l.getSecondaryCalendarType()}),I,U;if(Y.start.getYear()===Y.end.getYear()){I=v.format(Y.start.toUTCJSDate(),true)}else{U=C.getIntervalPattern();I=U.replace(/\{0\}/,v.format(Y.start.toUTCJSDate()),true).replace(/\{1\}/,v.format(Y.end.toUTCJSDate(),true))}D["label"]=D["label"]+" "+I}i.attr("tabindex","-1");i.attr("data-sap-year-start",T);i.style("width",g);i.accessibilityState(null,D);i.openEnd();i.text(S);if(u){i.openStart("div",p+"-y"+T+"-secondary");i.class("sapUiCalItemSecText");i.openEnd();i.text(I);i.close("div")}i.close("div");n.setYear(n.getYear()+1);if(y>0&&(b+1)%y==0){i.close("div")}}};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/YearRangePicker", ["./YearPicker","./YearRangePickerRenderer","./CalendarDate","./CalendarUtils","sap/ui/thirdparty/jquery"],function(e,t,a,r,jQuery){"use strict";var i=e.extend("sap.ui.unified.calendar.YearRangePicker",{metadata:{library:"sap.ui.unified",properties:{years:{type:"int",group:"Appearance",defaultValue:9},columns:{type:"int",group:"Appearance",defaultValue:3},rangeSize:{type:"int",group:"Appearance",defaultValue:20}}},renderer:t});i.prototype.setDate=function(e){var t,i,s,n,o;e&&r._checkJSDateObject(e);i=e.getFullYear();r._checkYearInValidRange(i);t=a.fromLocalJSDate(e,this._getPrimaryCalendarType());t.setMonth(0,1);this.setProperty("date",e);this.setProperty("year",t.getYear());this._oDate=t;s=this.getYears();o=Math.floor(s/2);n=new a(this._oDate,this._getPrimaryCalendarType());n=this._checkFirstDate(n);this._iSelectedIndex=o;this.setProperty("_middleDate",n);return this};i.prototype._checkFirstDate=function(e){var t=this.getYears();var i=new a(this._oMaxDate,this._getPrimaryCalendarType());if(!i.isSame(r._maxDate(this._getPrimaryCalendarType()))){return e}i.setYear(i.getYear()-Math.floor(t/2)*this.getRangeSize()+1-Math.floor(this.getRangeSize()/2));if(e.isAfter(i)&&e.getYear()!=i.getYear()){e=new a(i,this._getPrimaryCalendarType());e.setMonth(0,1)}else if(e.isBefore(this._oMinDate)&&e.getYear()!=this._oMinDate.getYear()){e=new a(this._oMinDate,this._getPrimaryCalendarType());e.setMonth(0,1)}return e};i.prototype._updatePage=function(e,t,r){var i=this._oItemNavigation.getItemDomRefs(),s=a.fromLocalJSDate(this._oFormatYyyymmdd.parse(jQuery(i[0]).attr("data-sap-year-start")),this._getPrimaryCalendarType()),n=this.getYears(),o=this.getRangeSize();if(e){var h=new a(this._oMaxDate,this._getPrimaryCalendarType());h.setYear(h.getYear()-n*o+1);if(s.isBefore(h)){s.setYear(s.getYear()+n*o+Math.floor(o/2)+Math.floor(n/2)*o);s=this._checkFirstDate(s)}else{return}}else{if(s.isAfter(this._oMinDate)){s.setYear(s.getYear()-n*o);if(s.isBefore(this._oMinDate)){s=new a(this._oMinDate,this._getPrimaryCalendarType())}s.setYear(s.getYear()+Math.floor(n/2)*o+Math.floor(o/2));s=this._checkFirstDate(s)}else{return}}this._iSelectedIndex=t;this.setProperty("_middleDate",s);if(r){this.firePageChange()}};i.prototype._checkDateEnabled=function(e,t){if(r._isBetween(this._oMinDate,e,t,true)||r._isBetween(this._oMaxDate,e,t,true)||this._oMinDate.isBefore(e)&&this._oMaxDate.isAfter(t)){return true}return false};i.prototype._selectYear=function(e){var t=this._oItemNavigation.getItemDomRefs(),r=jQuery(t[e]),i=r.attr("data-sap-year-start"),s=a.fromLocalJSDate(this._oFormatYyyymmdd.parse(i),this._getPrimaryCalendarType());if(r.hasClass("sapUiCalItemDsbl")){return false}this.setProperty("date",s.toLocalJSDate());this.setProperty("year",s.getYear());return true};i.prototype._getDisplayedSecondaryDates=function(e){var t=this.getSecondaryCalendarType(),r=new a(e,e.getCalendarType()),i=new a(e,e.getCalendarType());r.setMonth(0,1);r=new a(r,t);i.setYear(i.getYear()+this.getRangeSize());i.setMonth(0,1);i.setDate(i.getDate()-1);i=new a(i,t);return{start:r,end:i}};i.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);if(this._getSecondaryCalendarType()){this.setColumns(2);this.setYears(8);this.setRangeSize(8)}return this};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/calendar/YearRangePickerRenderer", ["sap/ui/core/Renderer","./YearPickerRenderer","./CalendarDate","sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/ui/unified/calendar/CalendarUtils"],function(e,t,a,r,i,l){"use strict";var n=e.extend(t);n.apiVersion=2;n.getAccessibilityState=function(){return{role:"grid",readonly:"true",multiselectable:false,roledescription:sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("YEAR_RANGE_PICKER")}};n.renderCells=function(e,t){var n=t.getProperty("_middleDate")?t.getProperty("_middleDate"):t._getDate(),o=new a(n,t.getPrimaryCalendarType()),s=new a(o,t.getPrimaryCalendarType()),d=l._minDate(t.getProperty("primaryCalendarType")).getYear(),g=l._maxDate(t.getProperty("primaryCalendarType")).getYear(),c,p="",y="",u="",f=t.getId(),m=t.getColumns(),C=t.getYears(),Y=t._getSecondaryCalendarType(),S=t._getLocaleData(),D=S.getIntervalPattern(),T="",_,b,v;s.setYear(s.getYear()-Math.floor(t.getRangeSize()/2));s.setYear(s.getYear()-Math.floor(C/2)*t.getRangeSize());if(s.getYear()<d){s.setYear(d)}else if(s.getYear()>g-C){s.setYear(g-Math.floor(C)*t.getRangeSize()+1)}c=new a(s,t.getPrimaryCalendarType());c.setYear(c.getYear()+t.getRangeSize()-1);if(m>0){T=100/m+"%"}else{T=100/C+"%"}for(v=0;v<C;v++){b=t._oFormatYyyymmdd.format(s.toUTCJSDate(),true);_={role:"gridcell"};if(m>0&&v%m==0){e.openStart("div");e.accessibilityState(null,{role:"row"});e.openEnd()}e.openStart("div",f+"-y"+b);e.class("sapUiCalItem");if(!t._checkDateEnabled(s,c)){e.class("sapUiCalItemDsbl");_["disabled"]=true}p=t._oYearFormat.format(i.getInstance(s.toUTCJSDate(),s.getCalendarType()),true);y=t._oYearFormat.format(i.getInstance(c.toUTCJSDate(),c.getCalendarType()),true);u=D.replace(/\{0\}/,p).replace(/\{1\}/,y);_["label"]=u;if(Y){var R=t._getDisplayedSecondaryDates(s),U=r.getDateInstance({format:"y",calendarType:t.getSecondaryCalendarType()}),I;if(R.start.getYear()===R.end.getYear()){I=U.format(R.start.toUTCJSDate(),true)}else{I=D.replace(/\{0\}/,U.format(R.start.toUTCJSDate(),true)).replace(/\{1\}/,U.format(R.end.toUTCJSDate(),true))}_["label"]=_["label"]+" "+I}e.attr("tabindex","-1");e.attr("data-sap-year-start",b);e.style("width",T);e.accessibilityState(null,_);e.openEnd();if(l._isBetween(t._oDate,s,c,true)){t._iSelectedIndex=v}e.text(u);if(Y){e.openStart("div",f+"-y"+b+"-secondary");e.class("sapUiCalItemSecText");e.openEnd();e.text(I);e.close("div")}e.close("div");if(m>0&&(v+1)%m==0){e.close("div")}s.setYear(c.getYear()+1);c.setYear(c.getYear()+t.getRangeSize())}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/unified/library", ["sap/ui/core/Core","sap/ui/base/Object","./ColorPickerDisplayMode","./FileUploaderHttpRequestMethod","sap/ui/core/library"],function(e,i,n,a){"use strict";var t=sap.ui.getCore().initLibrary({name:"sap.ui.unified",version:"1.120.10",dependencies:["sap.ui.core"],designtime:"sap/ui/unified/designtime/library.designtime",types:["sap.ui.unified.CalendarAppointmentVisualization","sap.ui.unified.CalendarDayType","sap.ui.unified.CalendarIntervalType","sap.ui.unifief.CalendarAppointmentHeight","sap.ui.unifief.CalendarAppointmentRoundWidth","sap.ui.unified.ColorPickerDisplayMode","sap.ui.unified.ColorPickerMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.FileUploaderHttpRequestMethod","sap.ui.unified.StandardCalendarLegendItem"],interfaces:["sap.ui.unified.IProcessableBlobs"],controls:["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.calendar.YearRangePicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.ColorPickerPopover","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],elements:["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],extensions:{"sap.ui.support":{publicRules:true}}});t.CalendarDayType={None:"None",NonWorking:"NonWorking",Type01:"Type01",Type02:"Type02",Type03:"Type03",Type04:"Type04",Type05:"Type05",Type06:"Type06",Type07:"Type07",Type08:"Type08",Type09:"Type09",Type10:"Type10",Type11:"Type11",Type12:"Type12",Type13:"Type13",Type14:"Type14",Type15:"Type15",Type16:"Type16",Type17:"Type17",Type18:"Type18",Type19:"Type19",Type20:"Type20"};t.StandardCalendarLegendItem={Today:"Today",WorkingDay:"WorkingDay",NonWorkingDay:"NonWorkingDay",Selected:"Selected"};t.CalendarIntervalType={Hour:"Hour",Day:"Day",Month:"Month",Week:"Week",OneMonth:"One Month"};t.CalendarAppointmentHeight={HalfSize:"HalfSize",Regular:"Regular",Large:"Large",Automatic:"Automatic"};t.CalendarAppointmentRoundWidth={HalfColumn:"HalfColumn",None:"None"};t.GroupAppointmentsMode={Collapsed:"Collapsed",Expanded:"Expanded"};t.FileUploaderHttpRequestMethod=a;t.CalendarAppointmentVisualization={Standard:"Standard",Filled:"Filled"};t.ContentSwitcherAnimation={None:"None",Fade:"Fade",ZoomIn:"ZoomIn",ZoomOut:"ZoomOut",Rotate:"Rotate",SlideRight:"SlideRight",SlideOver:"SlideOver"};t.ColorPickerMode={HSV:"HSV",HSL:"HSL"};t.ColorPickerDisplayMode=n;t._ContentRenderer=i.extend("sap.ui.unified._ContentRenderer",{constructor:function(e,n,a,t){i.apply(this);this._id=n;this._cntnt=a;this._ctrl=e;this._rm=sap.ui.getCore().createRenderManager();this._cb=t||function(){}},destroy:function(){this._rm.destroy();delete this._rm;delete this._id;delete this._cntnt;delete this._cb;delete this._ctrl;if(this._rerenderTimer){clearTimeout(this._rerenderTimer);delete this._rerenderTimer}i.prototype.destroy.apply(this,arguments)},render:function(){if(!this._rm){return}if(this._rerenderTimer){clearTimeout(this._rerenderTimer)}this._rerenderTimer=setTimeout(function(){var e=document.getElementById(this._id);if(e){if(typeof this._cntnt==="string"){var i=this._ctrl.getAggregation(this._cntnt,[]);for(var n=0;n<i.length;n++){this._rm.renderControl(i[n])}}else{this._cntnt(this._rm)}this._rm.flush(e)}this._cb(!!e)}.bind(this),0)}});t._iNumberOfOpenedShellOverlays=0;t.calendar=t.calendar||{};return t});
sap.ui.require.preload({
	"sap/ui/unified/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.unified","type":"library","embeds":[],"applicationVersion":{"version":"1.120.10"},"title":"Unified controls intended for both, mobile and desktop scenarios","description":"Unified controls intended for both, mobile and desktop scenarios","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.10"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.calendar.YearRangePicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.ColorPickerPopover","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],"elements":["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],"types":["sap.ui.unified.CalendarAppointmentVisualization","sap.ui.unified.CalendarDayType","sap.ui.unified.CalendarIntervalType","sap.ui.unifief.CalendarAppointmentHeight","sap.ui.unifief.CalendarAppointmentRoundWidth","sap.ui.unified.ColorPickerDisplayMode","sap.ui.unified.ColorPickerMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.FileUploaderHttpRequestMethod","sap.ui.unified.StandardCalendarLegendItem"],"interfaces":["sap.ui.unified.IProcessableBlobs"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
