/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/EventProvider","sap/ui/commons/Button","sap/ui/commons/Dialog","sap/ui/core/theming/Parameters","./ShellColorPicker","sap/ui/commons/library","sap/ui/core/HTML","sap/ui/core/Popup","sap/ui/commons/Tab","sap/ui/core/Item","sap/ui/Device","sap/base/security/encodeXML","sap/ui/core/Configuration"],function(jQuery,e,t,i,o,s,n,a,r,g,l,h,d,p){"use strict";var c=r.Dock;var m=e.extend("sap.ui.ux3.ShellPersonalization",{constructor:function(t){e.apply(this);this.shell=t;this.oSettings={}}});m.prototype.initializeSettings=function(e){this.oSettings=Object.assign({},e);if(this.shell.getDomRef()){this.applySettings(e)}};m.M_EVENTS={personalizationChange:"personalizationChange"};m.prototype.attachPersonalizationChange=function(e,t){this.attachEvent(m.M_EVENTS.personalizationChange,e,t)};m.prototype.detachPersonalizationChange=function(e,t){this.detachEvent(m.M_EVENTS.personalizationChange,e,t)};m.prototype.firePersonalizationChange=function(e){this.fireEvent(m.M_EVENTS.personalizationChange,e)};m.ORIGINAL_SETTINGS={bByDStyle:false,sBgColor:"rgb(17,17,17)",sBgCssImg:null,sBgImgSrc:null,sBgImgPos:"tile",fBgImgOpacity:1,fSidebarOpacity:1,sLineColor:"rgb(239,170,0)",sLogoImageSrc:null,sLogoAlign:"left",bUseLogoSize:false};m.TRANSPARENT_1x1=sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif");m.IMAGE_FOLDER_PATH=sap.ui.require.toUrl("sap/ui/ux3/themes/"+p.getTheme()+"/img/shell/");m.getOriginalSettings=function(){if(!m._bOriginalSettingsInitialized){m._bOriginalSettingsInitialized=true;var e,t,i=Object.assign({sapUiUx3ShellGradientTop:"#000000",sapUiUx3ShellGradientBottom:"#000000"},o.get({name:["sapUiUx3ShellGradientTop","sapUiUx3ShellGradientBottom"],callback:function(e){this._calcGradient(e["sapUiUx3ShellGradientTop"],e["sapUiUx3ShellGradientBottom"]);this.invalidate()}.bind(this)}));e=i["sapUiUx3ShellGradientTop"];t=i["sapUiUx3ShellGradientBottom"];this._calcGradient(e,t)}return m.ORIGINAL_SETTINGS};m.prototype._calcGradient=function(e,t){if(h.browser.firefox){m.ORIGINAL_SETTINGS.sBgCssImg="-moz-linear-gradient(top, "+e+" 0, "+t+" 108px, "+t+")"}else if(h.browser.webkit){m.ORIGINAL_SETTINGS.sBgCssImg="-webkit-linear-gradient(top, "+e+" 0, "+t+" 108px, "+t+")"}};m.prototype.hasChanges=function(){var e=0;for(var t in this.oSettings){e++}return e>0};m.prototype.applySettings=function(e){var t=Object.assign({},m.getOriginalSettings(),e);this.applyByDStyle(t.bByDStyle);this.applyBgColor(t.sBgColor);this.applyBgImage(t.sBgCssImg,t.sBgImgSrc);this.applyBgImageOpacity(t.fBgImgOpacity);if(t.sHeaderImageSrc){this.applyHeaderImage(t.sHeaderImageSrc)}else{this.shell.getDomRef("hdr").style.backgroundImage=""}this.applySidebarOpacity(t.fSidebarOpacity);this.applyBgColor(t.sBgColor);this.applyLineColor(t.sLineColor);this.applyLogoImage(t.sLogoImageSrc);this.applyLogoAlign(t.sLogoAlign);this.applyUseLogoSize(t.bUseLogoSize)};m.prototype.openDialog=function(){if(this.oDialog&&this._getDialog().isOpen()){return}this.oTransientSettings=Object.assign({},this.oSettings);this._getDialog().open();this._bindDragAndDrop("bg");this._bindDragAndDrop("hdr");this._bindDragAndDrop("logo")};m.prototype.getTransientSettingsWithDefaults=function(){return Object.assign({},m.getOriginalSettings(),this.oTransientSettings)};m.prototype._bindDragAndDrop=function(e){if(window.FileReader){var t=this.shell.getId()+"-p13n_";jQuery(document.getElementById(t+e+"ImageImg")).on("dragover",jQuery.proxy(this._handleDragover,this)).on("dragend",jQuery.proxy(this._handleDragend,this)).on("drop",jQuery.proxy(this._handleDrop,this));jQuery(document.getElementById(t+e+"ImageHolder")).on("dragover",jQuery.proxy(this._handleDragover,this)).on("dragend",jQuery.proxy(this._handleDragend,this)).on("drop",jQuery.proxy(this._handleDrop,this))}};m.prototype._unbindDragAndDrop=function(e){if(window.FileReader){var t=this.shell.getId()+"-p13n_";jQuery(document.getElementById(t+"hdrImageImg")).off("dragover",this._handleDragover).off("dragend",this._handleDragend).off("drop",this._handleDrop);jQuery(document.getElementById(t+"hdrImageHolder")).off("dragover",this._handleDragover).off("dragend",this._handleDragend).off("drop",this._handleDrop)}};m.prototype._getDialog=function(){if(!this.oDialog){var e=this.shell.getId()+"-p13n_";var t=Object.assign({},m.getOriginalSettings(),this.oSettings);var i=sap.ui.commons;var o=this;var n=new i.Dialog({title:"Shell Personalization",width:"544px",height:"560px",showCloseButton:false,resizable:false,closed:[function(){this._unbindDragAndDrop("bg");this._unbindDragAndDrop("hdr");this._unbindDragAndDrop("logo");this.oTransientSettings=null},this]}).addStyleClass("sapUiUx3ShellP13n");var r=new i.TabStrip({width:"100%",height:"100%",select:jQuery.proxy(function(e){var t=sap.ui.getCore().byId(e.getParameter("id"));if(t){var i=e.getParameter("index");t.setSelectedIndex(i);var o=this;if(i==0){window.setTimeout(function(){o.shell.$("bgColor").css("background-color",o.getTransientSettingsWithDefaults().sBgColor)},1);window.setTimeout(jQuery.proxy(function(){this._bindDragAndDrop("bg")},this),0)}else if(i==1){window.setTimeout(function(){o.shell.$("lineColor").css("background-color",o.getTransientSettingsWithDefaults().sLineColor)},1);window.setTimeout(jQuery.proxy(function(){this._bindDragAndDrop("hdr")},this),0)}else if(i==2){window.setTimeout(jQuery.proxy(function(){this._bindDragAndDrop("logo")},this),0)}}},this)});this.oBgImgHtml=new a(e+"bgImageHolder",{preferDOM:true,content:"<div id='"+e+"bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+e+"bgImageImg' src='"+(this.oTransientSettings.sBackgroundImageSrc?d(this.oTransientSettings.sBackgroundImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>"});this.oBgImgOpacitySlider=new i.Slider({value:this.oTransientSettings.fBgImgOpacity!==undefined?100-this.oTransientSettings.fBgImgOpacity*100:100-m.getOriginalSettings().fBgImgOpacity*100,liveChange:jQuery.proxy(this._handleBgImageOpacitySliderChange,this)});this.oSidebarOpacitySlider=new i.Slider({value:this.oTransientSettings.fSidebarOpacity!==undefined?100-this.oTransientSettings.fSidebarOpacity*100:100-m.getOriginalSettings().fSidebarOpacity*100,liveChange:jQuery.proxy(this._handleSidebarOpacitySliderChange,this)});this.oBgColorPicker=new s(e+"bgColorPicker");this.oBgColorPicker.attachLiveChange(function(e){o._handleBgColorChange(e)});var h=new i.Button({text:"Change..."});var o=this;h.attachPress(function(){if(!o.oBgColorPicker.isOpen()){o.oBgColorPicker.open(s.parseCssRgbString(o.getTransientSettingsWithDefaults().sBgColor),c.BeginTop,c.BeginBottom,o.shell.getDomRef("bgColor"))}});this.oBgPreviewHtml=new a({preferDom:true,content:"<div id='"+this.shell.getId()+"-bgColor' style='background-color:"+d(t.sBgColor)+"' class='sapUiUx3ShellColorPickerPreview'></div>"});var p=(new g).setText("Background").addContent(new i.layout.MatrixLayout({layoutFixed:false}).createRow(new i.Label({text:"Background Image:"}),this.oBgImgHtml).createRow(new i.Label({text:"Image Transparency:"}),this.oBgImgOpacitySlider).createRow(new i.Label({text:"Background Color:"}),(new i.layout.MatrixLayoutCell).addContent(this.oBgPreviewHtml).addContent(h)).createRow(null).createRow(new i.Label({text:"Sidebar Transparency:"}),this.oSidebarOpacitySlider));r.addTab(p);this.oByDStyleCb=new i.CheckBox({text:"ByDesign-style Header Bar",checked:this.oTransientSettings.bByDStyle,change:jQuery.proxy(this._handleByDStyleChange,this)});this.oHdrImgHtml=new a(e+"hdrImageHolder",{preferDOM:true,content:"<div id='"+e+"hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+e+"hdrImageImg' src='"+(this.oTransientSettings.sHeaderImageSrc?d(this.oTransientSettings.sHeaderImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>"});this.oLineColorPicker=new s(e+"lineColorPicker");this.oLineColorPicker.attachLiveChange(function(e){o._handleLineColorChange(e)});var u=new i.Button({text:"Change..."});var o=this;u.attachPress(function(){if(!o.oLineColorPicker.isOpen()){o.oLineColorPicker.open(s.parseCssRgbString(o.getTransientSettingsWithDefaults().sLineColor),c.BeginTop,c.BeginBottom,o.shell.getDomRef("lineColor"))}});this.oLinePreviewHtml=new a({preferDom:true,content:"<div id='"+this.shell.getId()+"-lineColor' style='background-color:"+d(t.sLineColor)+"' class='sapUiUx3ShellColorPickerPreview'></div>"});var S=(new g).setText("Header Bar").addContent(new i.layout.MatrixLayout({layoutFixed:false}).createRow(new i.Label({text:"Line Color (ByD-style only):"}),(new i.layout.MatrixLayoutCell).addContent(this.oLinePreviewHtml).addContent(u)).createRow(null).createRow(new i.Label({text:"Header Image:"}),this.oHdrImgHtml));r.addTab(S);this.oLogoImgHtml=new a(e+"logoImageHolder",{preferDOM:true,content:"<div id='"+e+"logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+e+"logoImageImg' src='"+(this.oTransientSettings.sLogoImageSrc?d(this.oTransientSettings.sLogoImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>"});this.oLogoRbg=(new i.RadioButtonGroup).addItem(new l({text:"Left",key:"left"})).addItem(new l({text:"Center",key:"center"})).attachSelect(this._handleLogoAlignChange,this);this.oUseLogoSizeCb=new i.CheckBox({text:"Use original image size",checked:this.oTransientSettings.bUseLogoSize,change:jQuery.proxy(this._handleUseLogoSizeChange,this)});var y=(new g).setText("Logo").addContent(new i.layout.MatrixLayout({layoutFixed:false}).createRow(new i.Label({text:"Logo Image:"}),this.oLogoImgHtml).createRow(new i.Label({text:"Position:"}),this.oLogoRbg).createRow(this.oUseLogoSizeCb));r.addTab(y);n.addContent(r);var o=this;n.addButton(new i.Button({text:"Reset All",press:function(){o.applySettings(Object.assign({},m.getOriginalSettings()));o.oSettings={};o.oTransientSettings={};o.updateDialog();o._bindDragAndDrop("bg");o._bindDragAndDrop("hdr");o._bindDragAndDrop("logo");o.firePersonalizationChange({settings:{}})}}));n.addButton(new i.Button({text:"OK",press:function(){o.oSettings=Object.assign({},o.oTransientSettings);o.firePersonalizationChange({settings:o.oSettings});n.close()}}));n.addButton(new i.Button({text:"Cancel",press:function(){n.close()}}));this.oDialog=n}return this.oDialog};m.prototype.updateDialog=function(){var e=Object.assign({},m.getOriginalSettings(),this.oSettings);var t=this.shell.getId()+"-p13n_";this.oBgImgHtml.setContent("<div id='"+t+"bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+t+"bgImageImg' src='"+(e.sBackgroundImageSrc?d(e.sBackgroundImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>");this.oBgImgOpacitySlider.setValue(100-e.fBgImgOpacity*100);this.oSidebarOpacitySlider.setValue(100-e.fSidebarOpacity*100);this.oByDStyleCb.setChecked(e.bByDStyle);this.oHdrImgHtml.setContent("<div id='"+t+"hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+t+"hdrImageImg' src='"+(e.sHeaderImageSrc?d(e.sHeaderImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>");this.oLogoRbg.setSelectedIndex(e.sLogoAlign=="center"?1:0);this.oUseLogoSizeCb.setChecked(e.bUseLogoSize);this.oLogoImgHtml.setContent("<div id='"+t+"logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+t+"logoImageImg' src='"+(e.sLogoImageSrc?d(e.sLogoImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>")};m.prototype._handleByDStyleChange=function(e){var t=e.getParameter("checked");this.oTransientSettings.bByDStyle=t;this.applyByDStyle(t)};m.prototype.applyByDStyle=function(e){this.shell.$().toggleClass("sapUiUx3ShellByD",e)};m.prototype._handleBgColorChange=function(e){var t=e.getParameter("cssColor");this.oTransientSettings.sBgColor=t;this.applyBgColor(t)};m.prototype.applyBgColor=function(e){this.shell.$("bg").css("background-color",e);this.shell.$("bgColor").css("background-color",e)};m.prototype._handleBackgroundImageChange=function(e,t){var i=true;if(t){if(i){this.oSettings.sBgCssImg="url("+e+")";this.oSettings.sBgImgSrc=null}else{this.oSettings.sBgCssImg=null;this.oSettings.sBgImgSrc=e}this.applyBgImage(this.oSettings.sBgCssImg,this.oSettings.sBgImgSrc);this.firePersonalizationChange({settings:this.oSettings})}else{if(i){this.oTransientSettings.sBgCssImg="url("+e+")";this.oTransientSettings.sBgImgSrc=null}else{this.oTransientSettings.sBgCssImg=null;this.oTransientSettings.sBgImgSrc=e}this.applyBgImage(this.oTransientSettings.sBgCssImg,this.oTransientSettings.sBgImgSrc)}};m.prototype.applyBgImage=function(e,t){e=e?e:"";t=t?t:m.TRANSPARENT_1x1;var i=this.shell.getDomRef("bgImg");i.style.backgroundImage=e;i.src=t};m.prototype._handleHeaderImageChange=function(e,t){if(t){this.oSettings.sHeaderImageSrc=e;this.firePersonalizationChange({settings:this.oSettings})}else{this.oTransientSettings.sHeaderImageSrc=e}this.applyHeaderImage(e)};m.prototype.applyHeaderImage=function(e){this.shell.$("hdr").css("background-image","url("+e+")");if(this.oDialog&&this.oDialog.isOpen()){this.shell.$("p13n_hdrImageImg").attr("src",e)}};m.prototype._handleLineColorChange=function(e){var t=e.getParameter("cssColor");this.oTransientSettings.sLineColor=t;this.applyLineColor(t)};m.prototype.applyLineColor=function(e){this.shell.$("hdr").find("hr").css("background-color",e);this.shell.$("lineColor").css("background-color",e)};m.prototype._handleBgImageOpacitySliderChange=function(e){var t=(100-e.getParameter("value"))/100;this.oTransientSettings.fBgImgOpacity=t;this.applyBgImageOpacity(t)};m.prototype.applyBgImageOpacity=function(e){this.shell.$("bgImg").css("opacity",e)};m.prototype._handleSidebarOpacitySliderChange=function(e){var t=(100-e.getParameter("value"))/100;this.oTransientSettings.fSidebarOpacity=t;this.applySidebarOpacity(t)};m.prototype.applySidebarOpacity=function(e){this.shell.$("tp").css("opacity",e);this.shell.$("paneBar").children(":nth-child(2)").css("opacity",e)};m.prototype._handleLogoImageChange=function(e,t){if(t){this.oSettings.sLogoImageSrc=e;this.firePersonalizationChange({settings:this.oSettings})}else{this.oTransientSettings.sLogoImageSrc=e}this.applyLogoImage(e)};m.prototype.applyLogoImage=function(e){if(!e){e=this.shell.getAppIcon();if(!e){e=m.TRANSPARENT_1x1}}this.shell.$("logoImg").attr("src",e);this.shell.$("p13n_logoImageImg").attr("src",e)};m.prototype._handleLogoAlignChange=function(e){var t=e.getParameter("selectedIndex");var i=["left","center"][t];this.oTransientSettings.sLogoAlign=i;this.applyLogoAlign(i)};m.prototype.applyLogoAlign=function(e){var t=e;if(p.getRTL()&&t=="right"){t="left"}this.shell.$("hdr").css("text-align",t)};m.prototype._handleUseLogoSizeChange=function(e){var t=e.getParameter("checked");this.oTransientSettings.bUseLogoSize=t;this.applyUseLogoSize(t)};m.prototype.applyUseLogoSize=function(e){this.shell.$("hdr").toggleClass("sapUiUx3ShellHeaderFlex",e);this.shell.$("hdrImg").toggleClass("sapUiUx3ShellHeaderImgFlex",e)};m.prototype._handleDragover=function(e){var t=e.target.id;if(!this._dragOverBlinking){var i=jQuery(document.getElementById(t));i.css("opacity","0.5");this._dragOverBlinking=true;var o=this;window.setTimeout(function(){i.css("opacity","1");window.setTimeout(function(){o._dragOverBlinking=null},250)},250)}return false};m.prototype._handleDragend=function(e){return false};m.prototype._handleDrop=function(e){var t=e.target.id;e.preventDefault();var i=e.originalEvent;var o=i.dataTransfer.files[0];if(o){var s=new window.FileReader;s.onload=jQuery.proxy(function(e){var i=e.target.result;if(t==this.shell.getId()+"-p13n_bgImageImg"||t==this.shell.getId()+"-p13n_bgImageHolder"){this._handleBackgroundImageChange(i)}else if(t==this.shell.getId()+"-p13n_hdrImageImg"||t==this.shell.getId()+"-p13n_hdrImageHolder"){this._handleHeaderImageChange(i)}else if(t==this.shell.getId()+"-p13n_logoImageImg"||t==this.shell.getId()+"-p13n_logoImageHolder"){this._handleLogoImageChange(i)}s=null},this);s.readAsDataURL(o)}};return m});
//# sourceMappingURL=ShellPersonalization.js.map