/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/IntervalTrigger","sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/ui/core/library","sap/m/Text"],function(e,t,a,i,s,r,o){"use strict";var n=6e4;var p=r.TextAlign;var m=e.extend("sap.f.cards.BaseHeader",{metadata:{library:"sap.f",abstract:true,properties:{dataTimestamp:{type:"string",defaultValue:""},statusVisible:{type:"boolean",defaultValue:true},dataTimestampUpdating:{type:"boolean",defaultValue:false,visibility:"hidden"},focusable:{type:"boolean",defaultValue:true,visibility:"hidden"},useTileLayout:{type:"boolean",group:"Appearance",visibility:"hidden"}},aggregations:{_dataTimestamp:{type:"sap.m.Text",multiple:false,visibility:"hidden"},toolbar:{type:"sap.ui.core.Control",multiple:false},_error:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},bannerLines:{type:"sap.m.Text",group:"Appearance",multiple:true}}}});m.prototype.init=function(){this._oRb=t.getLibraryResourceBundle("sap.f");this._oToolbarDelegate={onfocusin:this._onToolbarFocusin,onfocusout:this._onToolbarFocusout}};m.prototype.exit=function(){this._removeTimestampListener();if(this._oToolbarDelegate){this._oToolbarDelegate=null}this._oRb=null};m.prototype.onBeforeRendering=function(){var e=this.getToolbar(),t=this.getBannerLines();if(e){e.addStyleClass("sapFCardHeaderToolbar");e.removeEventDelegate(this._oToolbarDelegate,this)}if(t){t.forEach(e=>{e.setTextAlign(p.End)})}};m.prototype.onAfterRendering=function(){var e=this.getToolbar();if(e){e.addEventDelegate(this._oToolbarDelegate,this)}};m.prototype.getFocusDomRef=function(){return this.getDomRef("focusable")};m.prototype.ontap=function(e){if(this.isInteractive()&&!this._isInsideToolbar(e.target)){this.firePress()}};m.prototype.onsapselect=function(e){if(this.isInteractive()&&!this._isInsideToolbar(e.target)){this.firePress()}};m.prototype._onToolbarFocusin=function(){var e=this.getDomRef();if(e){this.getDomRef().classList.add("sapFCardHeaderToolbarFocused")}};m.prototype._onToolbarFocusout=function(){var e=this.getDomRef();if(e){this.getDomRef().classList.remove("sapFCardHeaderToolbarFocused")}};m.prototype.setDataTimestamp=function(e){var t=this.getDataTimestamp();if(t&&!e){this.destroyAggregation("_dataTimestamp");this._removeTimestampListener()}this.setProperty("dataTimestamp",e);if(e){this._updateDataTimestamp();this._addTimestampListener()}return this};m.prototype.setDataTimestampUpdating=function(e){var t=this._createDataTimestamp();this.setProperty("dataTimestampUpdating",e);if(e){t.setText("updating...");t.addStyleClass("sapFCardDataTimestampUpdating");this._removeTimestampListener()}else{t.removeStyleClass("sapFCardDataTimestampUpdating")}return this};m.prototype._createDataTimestamp=function(){var e=this.getAggregation("_dataTimestamp");if(!e){e=new o({wrapping:false,textAlign:"End"});e.addStyleClass("sapFCardDataTimestamp");this.setAggregation("_dataTimestamp",e)}return e};m.prototype._updateDataTimestamp=function(){var e=this._createDataTimestamp(),t=this.getDataTimestamp(),a,r,o;if(!t){e.setText("");return}a=i.getDateTimeInstance({relative:true});r=new s(t);o=a.format(r);if(r.getTime()+59e3>Date.now()){o="now"}e.setText(o);e.removeStyleClass("sapFCardDataTimestampUpdating")};m.prototype._addTimestampListener=function(){m.getTimestampIntervalTrigger().addListener(this._updateDataTimestamp,this);this._bHasTimestampListener=true};m.prototype._removeTimestampListener=function(){if(!this._bHasTimestampListener){return}m.getTimestampIntervalTrigger().removeListener(this._updateDataTimestamp,this);this._bHasTimestampListener=false};m.getTimestampIntervalTrigger=function(){if(!m._oTimestampIntervalTrigger){m._oTimestampIntervalTrigger=new a(n)}return m._oTimestampIntervalTrigger};m.prototype.getTitleAriaRole=function(){return"heading"};m.prototype.getFocusableElementAriaRole=function(){return this.hasListeners("press")?"button":"group"};m.prototype.getAriaHeadingLevel=function(){return"3"};m.prototype.getAriaRoleDescription=function(){return this.hasListeners("press")?this._oRb.getText("ARIA_ROLEDESCRIPTION_INTERACTIVE_CARD_HEADER"):this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER")};m.prototype._getBannerLinesIds=function(){return this.getBannerLines().map(e=>e.getId()).join(" ")};m.prototype._isInsideGridContainer=function(){var e=this.getParent();if(!e){return false}e=e.getParent();if(!e){return false}return e.isA("sap.f.GridContainer")};m.prototype.isInteractive=function(){return this.hasListeners("press")};m.prototype._isInsideToolbar=function(e){var t=this.getToolbar();return t&&t.getDomRef()&&t.getDomRef().contains(e)};return m});
//# sourceMappingURL=BaseHeader.js.map