/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/OverflowToolbarLayoutData","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/dom/units/Rem","sap/m/library"],function(t,o,e,r,a){"use strict";var i=a.OverflowToolbarPriority;var n=12;var s=function(t){this._oControl=t;this._oDelegate={onAfterRendering:this.onAfterRendering,onBeforeRendering:this.onBeforeRendering};this._oControl.addDelegate(this._oDelegate,false,this);this.sCurrentRange="";this._bAttachedManagedSearchHandler=false;this._oControl._iResizeHandlerId=e.register(this._oControl,this._handleResize.bind(this));this._iMinSearchWidth=r.toPx(n)};s.prototype.onAfterRendering=function(){var t=o.media.getCurrentRange("StdExt",this._oControl.$().outerWidth(true)).name==="Phone";this._oButton=this._oControl._oMegaMenu&&this._oControl._oMegaMenu.getAggregation("_button");this._oDomRef=this._oControl.getDomRef();this.bIsMegaMenuConfigured=this._oControl._oTitleControl&&this._oControl._oTitleControl===this._oControl._oMegaMenu;if(this._oControl._oManagedSearch&&!this._bAttachedManagedSearchHandler){this._oControl._oManagedSearch.attachEvent("_updateVisualState",this._switchOpenStateOnSearch,this);this._bAttachedManagedSearchHandler=true}if(t){this._transformTitleControlMobile()}this._handleResize()};s.prototype.exit=function(){if(this._oControl._iResizeHandlerId){e.deregister(this._oControl._iResizeHandlerId);this._oControl._iResizeHandlerId=null}};s.prototype._handleResize=function(){if(!this._oDomRef){return}var t=this._oControl.$(),e=t.outerWidth(),r=o.media.getCurrentRange("StdExt",e),a;this.sCurrentRange=r.name;if(r){a=this.sCurrentRange==="Phone";t.toggleClass("sapFShellBarSizeLargeDesktop",this.sCurrentRange==="LargeDesktop");t.toggleClass("sapFShellBarSizeDesktop",this.sCurrentRange==="Desktop");t.toggleClass("sapFShellBarSizeTablet",this.sCurrentRange==="Tablet");t.toggleClass("sapFShellBarSizePhone",a)}if(this._oControl._oManagedSearch&&this._oControl._oManagedSearch.getIsOpen()){setTimeout(this._adaptSearch.bind(this),100)}else{this._oControl._bSearchPlaceHolder=false}if(this._iPreviousWidth===e){return}this._iPreviousWidth=e;if(!this._oControl._oNavButton&&!this._oControl._oMenuButton&&!this._oControl._oHomeIcon&&!this._oControl._oMegaMenu&&!this._oControl._oSecondTitle&&!this._oControl._oManagedSearch&&!this._oControl._oCopilot){return}if(a&&!this.bWasInPhoneRange){this._transformToPhoneState()}else if(!a&&this.bWasInPhoneRange){this._transformToRegularState()}};s.prototype._switchOpenStateOnSearch=function(){var t=this._oControl._oManagedSearch;if(!t){return}if(this.bWasInPhoneRange){this._transformToPhoneState()}else{this._transformToRegularState()}this._oControl.toggleStyleClass("sapFShellBarSearchIsOpen",t.getIsOpen())};s.prototype._transformToPhoneState=function(){var o=this._oControl._oManagedSearch,e=this._oControl._getOverflowToolbar().getContent(),r=this._oControl._oToolbarSpacer;if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(false)}this._transformTitleControlMobile();if(!this._bControlsLayoutDataCached){this._cacheControlsLayoutData();this._bControlsLayoutDataCached=true}e.forEach(function(o){if(o===r){return}o.setLayoutData(new t({priority:i.AlwaysOverflow}))});this.bWasInPhoneRange=true;if(o){o.setPhoneMode(true);if(o.getIsOpen()){this._toggleAllControlsExceptSearch(true);this._bSearchWasOpen=true}else if(this._bSearchWasOpen){this._toggleAllControlsExceptSearch(false);this._bSearchWasOpen=false}}this._oControl.invalidate()};s.prototype._transformToRegularState=function(){var t=this._oControl._oManagedSearch;this._toggleAllControlsExceptSearch(false);if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(true)}if(this._oControl._oHomeIcon){if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setText(this._oControl._sTitle).setIcon("")}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setText(this._oControl._sTitle)}if(this.bIsMegaMenuConfigured){this._oControl._oHomeIcon.setVisible(true)}}if(this._bControlsLayoutDataCached){this._restoreControlsLayoutData();this._bControlsLayoutDataCached=false}this.bWasInPhoneRange=false;if(t){t.setPhoneMode(false);this._oControl._bSearchPlaceHolder=false}this._oControl.invalidate()};s.prototype._transformTitleControlMobile=function(){var t;if(!this._oControl._oHomeIcon){return this.bIsMegaMenuConfigured?this._oControl._oMegaMenu.setText(this._oControl.getTitle()).setIcon(""):false}t=this.bIsMegaMenuConfigured&&this._oControl._oHomeIcon.getVisible()||!this.bIsMegaMenuConfigured&&!this._oControl._oHomeIcon.getVisible();if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setText("").setIcon(this._oControl.getHomeIcon())}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setText("")}if(t){this._oControl._oHomeIcon.setVisible(!this.bIsMegaMenuConfigured);this._oControl.invalidate()}};s.prototype._adaptSearch=function(){var t=this._oControl._oManagedSearch,o;if(!t||this.sCurrentRange==="Phone"){return}o=t.$().width();if(this._oControl._bSearchPlaceHolder){if(o>=this._iMinSearchWidth){this._oControl._bSearchPlaceHolder=false;this._toggleAllControlsExceptSearch(false)}}else if(o<this._iMinSearchWidth){this._oControl._bSearchPlaceHolder=true;this._toggleAllControlsExceptSearch(true)}else if(t.hasStyleClass("sapFShellBarSearchOpenTick")){t.removeStyleClass("sapFShellBarSearchOpenTick");this._adaptSearch()}return this};s.prototype._toggleAllControlsExceptSearch=function(t){var o=this._oControl._oManagedSearch;this._oControl.toggleStyleClass("sapFShellBarFullSearch",t);o&&o.toggleStyleClass("sapFShellBarSearchFullWidth",t)};s.prototype._cacheControlsLayoutData=function(){var t=this._oControl._getOverflowToolbar().getContent();this._oCachedLayoutData={};t.forEach(function(t){this._oCachedLayoutData[t.getId()]=t.getLayoutData()},this)};s.prototype._restoreControlsLayoutData=function(){var t=this._oControl._getOverflowToolbar().getContent();t.forEach(function(t){var o=this._oCachedLayoutData[t.getId()];if(o){t.setLayoutData(o)}},this)};return s});
//# sourceMappingURL=ResponsiveHandler.js.map