/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/library","./library","./ListItemBase","./ColumnListItemRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(t,e,i,o,n,jQuery){"use strict";var s=i.ListType;var r=e.VerticalAlign;var p=o.extend("sap.m.ColumnListItem",{metadata:{interfaces:["sap.m.ITableItem"],library:"sap.m",properties:{vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:r.Inherit}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell",bindable:"bindable"}}},renderer:n});var a=t.extend("sap.m.TablePopin",{ontap:function(t){if(t.isMarked()||o.detectTextSelection(this.getDomRef())){return t.stopImmediatePropagation(true)}if(t.srcControl===this||!jQuery(t.target).is(":sapFocusable")){this.getParent().focus()}}});p.prototype.TagName="tr";p.prototype.init=function(){o.prototype.init.call(this);this._bNeedsTypeColumn=false;this._aClonedHeaders=[]};p.prototype.onBeforeRendering=function(){o.prototype.onBeforeRendering.call(this);this.aAriaOwns=[];if(this._oPopin&&this._oDomRef){this.$Popin().off()}};p.prototype.onAfterRendering=function(){if(this._oPopin){this.$().attr("aria-owns",this.aAriaOwns.join(" "));this.isActionable(true)&&this.$Popin().on("mouseenter mouseleave",function(t){this.previousSibling.classList.toggle("sapMPopinHovered",t.type=="mouseenter")})}o.prototype.onAfterRendering.call(this);this._checkTypeColumn()};p.prototype.exit=function(){o.prototype.exit.call(this);this._checkTypeColumn(false);this._destroyClonedHeaders();if(this._oPopin){this._oPopin.destroy(true);this._oPopin=null}};p.prototype.setVisible=function(t){o.prototype.setVisible.call(this,t);if(!t&&this.hasPopin()){this.removePopin()}return this};p.prototype.getTable=function(){var t=this.getParent();if(t&&t.isA("sap.m.Table")){return t}};p.prototype.getPopin=function(){if(!this._oPopin){this._oPopin=new a({id:this.getId()+"-sub"}).addDelegate({ontouchstart:this.ontouchstart,ontouchmove:this.ontouchmove,ontap:this.ontap,ontouchend:this.ontouchend,ontouchcancel:this.ontouchcancel,onsapup:this.onsapup,onsapdown:this.onsapdown,oncontextmenu:this.oncontextmenu,onkeydown:this.onkeydown},this).setParent(this,null,true)}return this._oPopin};p.prototype.$Popin=function(){return this.$("sub")};p.prototype.hasPopin=function(){return this._oPopin};p.prototype.removePopin=function(){this._oPopin&&this.$Popin().remove()};p.prototype.getTabbables=function(t){const e=t?this.$().find(".sapMListTblCell"):this.$();return e.add(this.$Popin()).find(":sapTabbable")};p.prototype.getDropAreaRect=function(){var t=null;var e=this.getDomRef();var i=e.getBoundingClientRect().toJSON();if(this._oPopin&&(t=this.getDomRef("sub"))){var o=t.getBoundingClientRect();i.bottom=o.bottom;i.height+=o.height}return i};p.prototype.getAccessibilityType=function(t){return t.getText("ACC_CTR_TYPE_ROW")};p.prototype.getContentAnnouncement=function(t){var e=this.getTable();if(!e){return}var i=[],n=this.getCells(),s=e.getRenderedColumns();s.forEach(function(t){var e=n[t.getInitialOrder()];if(!e){return}var s=t.getHeader();if(s&&s.getVisible()){i.push(o.getAccessibilityText(s)+" "+o.getAccessibilityText(e,true))}else{i.push(o.getAccessibilityText(e,true))}});return i.filter(Boolean).join(" . ").trim()};p.prototype.updateSelectedDOM=function(t,e){o.prototype.updateSelectedDOM.apply(this,arguments);e.find(".sapMTblCellFocusable").attr("aria-selected",t);if(this.hasPopin()){this.$("subcont").attr("aria-selected",t)}};p.prototype.onfocusin=function(t){if(t.isMarked()){return}if(t.srcControl===this){this.$().children(".sapMListTblCellDup").find(":sapTabbable").attr("tabindex",-1)}o.prototype.onfocusin.apply(this,arguments)};p.prototype.onsapenter=p.prototype.onsapspace=function(t){if(t.isMarked()){return}var e=t.target.id;var i="on"+t.type;if(e==this.getId()+"-ModeCell"){t.target=this.getDomRef();i=this.getMode()=="Delete"?"onsapdelete":"onsapspace"}else if(e==this.getId()+"-TypeCell"){t.target=this.getDomRef();if(this.getType()=="Navigation"){i="onsapenter"}else{t.code="KeyE";t.ctrlKey=true;i="onkeydown"}}o.prototype[i].call(this,t)};p.prototype.setType=function(t){o.prototype.setType.call(this,t);this._checkTypeColumn();return this};p.prototype.setParent=function(){o.prototype.setParent.apply(this,arguments);this._checkTypeColumn();return this};p.prototype._checkTypeColumn=function(t){if(!this.getParent()){return}if(t==undefined){t=this._needsTypeColumn()}if(this._bNeedsTypeColumn!=t){this._bNeedsTypeColumn=t;this.informList("TypeColumnChange",t)}};p.prototype._needsTypeColumn=function(){var t=this.getType();return this.getVisible()&&(t==s.Detail||t==s.Navigation||t==s.DetailAndActive)};p.prototype._addClonedHeader=function(t){return this._aClonedHeaders.push(t)};p.prototype._destroyClonedHeaders=function(){if(this._aClonedHeaders.length){this._aClonedHeaders.forEach(function(t){t.destroy("KeepDom")});this._aClonedHeaders=[]}};p.prototype._activeHandlingInheritor=function(){this._toggleActiveClass(true)};p.prototype._inactiveHandlingInheritor=function(){this._toggleActiveClass(false)};p.prototype._toggleActiveClass=function(t){if(this.hasPopin()){this.$Popin().toggleClass("sapMLIBActive",t)}};return p});
//# sourceMappingURL=ColumnListItem.js.map