/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Element'], function(Element) {
	"use strict";

	/**
	 * Constructor for the element.
	 * @param {string} [sId] id for the new element.
	 * @param {string} [mSettings] initial settings for the new element.
	 *
	 * @class
	 * The <code>ColumnPopoverItem</code> is used for sorting, filter and grouping behaviours in ColumnHeaderPopover control.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.120.10
	 *
	 * @constructor
	 * @since 1.63
	 * @private
	 * @alias sap.m.ColumnPopoverItem
	 */
	var ColumnPopoverItem = Element.extend("sap.m.ColumnPopoverItem", /** @lends sap.m.ColumnPopoverItem.prototype */
		{
			metadata: {
				library: "sap.m",
				properties: {
					visible: {type: "boolean", group: "Misc", defaultValue: true}
				}
			}
		});
		ColumnPopoverItem.prototype._createButton = function() {
			throw new Error('Abstract function _create Button must be implemented in your Item (that extends this abstract object).');
		};
	return ColumnPopoverItem;
});