/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/core/Element","./InputBase","./DateTimeField","./Button","./ResponsivePopover","sap/ui/core/date/UniversalDate","./library","sap/ui/core/Control","sap/ui/core/library","./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","./InstanceManager","sap/ui/unified/Calendar","sap/ui/unified/DateRange","sap/ui/unified/DateTypeRange","sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/ui/core/LabelEnablement","sap/ui/unified/library","sap/ui/core/Configuration","sap/ui/unified/calendar/CalendarUtils","sap/ui/core/date/UI5Date","sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/Core","sap/ui/dom/jquery/cursorPos"],function(jQuery,e,t,a,i,s,n,o,r,p,l,u,h,d,g,c,f,_,y,D,m,C,v,T,P,b,V,S,M){"use strict";var I=l.CalendarType;var w=sap.ui.getCore().getLibraryResourceBundle("sap.m");var E=i.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showFooter:{type:"boolean",group:"Misc",defaultValue:false},showCurrentDateButton:{type:"boolean",group:"Behavior",defaultValue:false},hideInput:{type:"boolean",group:"Misc",defaultValue:false},calendarWeekNumbering:{type:"sap.ui.core.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}},afterValueHelpOpen:{},afterValueHelpClose:{}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}},renderer:u});E.prototype.init=function(){i.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=V.getInstance(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=V.getInstance(9999,11,31,23,59,59,999);var t=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,decorative:!e.support.touch||e.system.desktop?true:false,useIconTooltip:false,alt:w.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;t.addEventDelegate({onmousedown:function(e){this._bShouldClosePicker=!!this.isOpen()}},this);t.attachPress(function(){this.toggleOpen(this._bShouldClosePicker)},this)};E.prototype.isValidValue=function(){return this._bValid};E.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen()};E.prototype.toggleOpen=function(e){if(this.getEditable()&&this.getEnabled()){if(e){F.call(this)}else{R.call(this)}}};E.prototype.getIconSrc=function(){return c.getIconURI("appointment-2")};E.prototype.exit=function(){a.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close()}delete this._oPopup}if(this._getCalendar()){if(this._oCalendarAfterRenderDelegate){this._getCalendar().removeDelegate(this._oCalendarAfterRenderDelegate)}this._getCalendar().destroy();delete this._getCalendar()}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar)}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined};E.prototype.invalidate=function(e){if(!e||e!=this._getCalendar()){p.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(k.bind(this),0)}};E.prototype.onBeforeRendering=function(){i.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var e=this._getValueHelpIcon();if(e){e.setProperty("visible",this.getEditable())}};E.prototype.setDisplayFormat=function(e){this.setProperty("displayFormat",e);if(this._oCalendar){this._oCalendar.removeDelegate(this._oCalendarAfterRenderDelegate);this._oCalendar.destroy();this._oCalendar=null;this._createPopupContent()}return this};E.prototype.setWidth=function(e){return a.prototype.setWidth.call(this,e||"100%")};E.prototype.getWidth=function(e){return this.getProperty("width")||"100%"};E.prototype.applyFocusInfo=function(t){this._bFocusNoPopup=true;if(!e.support.touch||e.system.desktop){a.prototype.applyFocusInfo.apply(this,arguments)}};E.prototype.onfocusin=function(e){if(!jQuery(e.target).hasClass("sapUiIcon")){i.prototype.onfocusin.apply(this,arguments)}this._bFocusNoPopup=undefined};E.prototype.onsapshow=function(e){this.toggleOpen(this.isOpen());e.preventDefault()};E.prototype.onsaphide=E.prototype.onsapshow;E.prototype.onsapescape=function(e){var t=this.getLastValue(),a=this._parseValue(this._getInputValue(),true),i=this._formatValue(a,true);if(i!==t){e.setMarked();e.preventDefault();this.updateDomValue(t);this.onValueRevertedByEscape(t,i)}};E.prototype.onsappageup=function(e){var t=this._getCalendarConstructor().getMetadata().getName();e.preventDefault();if(t!="sap.ui.unified.Calendar"){return}this._increaseDate(1,"day")};E.prototype.onsappageupmodifiers=function(e){var t=this._getCalendarConstructor().getMetadata().getName();e.preventDefault();if(!e.ctrlKey&&e.shiftKey){if(t=="sap.ui.unified.internal.CustomYearPicker"){return}this._increaseDate(1,"month")}else{this._increaseDate(1,"year")}};E.prototype.onsappagedown=function(e){var t=this._getCalendarConstructor().getMetadata().getName();e.preventDefault();if(t!="sap.ui.unified.Calendar"){return}this._increaseDate(-1,"day")};E.prototype.onsappagedownmodifiers=function(e){var t=this._getCalendarConstructor().getMetadata().getName();e.preventDefault();if(!e.ctrlKey&&e.shiftKey){if(t=="sap.ui.unified.internal.CustomYearPicker"){return}this._increaseDate(-1,"month")}else{this._increaseDate(-1,"year")}};E.prototype.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return}var t=this._getFormatter(true);var a=String.fromCharCode(e.charCode);if(a&&t.sAllowedCharacters&&t.sAllowedCharacters.indexOf(a)<0){e.preventDefault()}};E.prototype._getValueHelpIcon=function(){var e=this.getAggregation("_endIcon");return e&&e[0]};E.prototype._dateValidation=function(e){this._bValid=true;if(e&&(e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime())){this._bValid=false;d(this._bValid,"Date must be in valid range")}this.setProperty("dateValue",e);return e};E.prototype.setMinDate=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript or UI5Date date object; "+this)}if(h(this.getMinDate(),e)){return this}if(e){var t=e.getFullYear();if(t<1||t>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this)}this._oMinDate=V.getInstance(e.getTime());var a=this.getDateValue();if(a&&a.getTime()<e.getTime()){this._bValid=false;this._bOutOfAllowedRange=true;g.warning("DateValue not in valid date range",this)}}else{this._oMinDate=V.getInstance(1,0,1);this._oMinDate.setFullYear(1)}this.setProperty("minDate",e);if(this._getCalendar()){this._getCalendar().setMinDate(e)}this._oMinDate.setHours(0,0,0,0);return this};E.prototype.setMaxDate=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript or UI5Date date object; "+this)}if(h(this.getMaxDate(),e)){return this}if(e){var t=e.getFullYear();if(t<1||t>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this)}this._oMaxDate=V.getInstance(e.getTime());var a=this.getDateValue();if(a&&a.getTime()>e.getTime()){this._bValid=false;this._bOutOfAllowedRange=true;g.warning("DateValue not in valid date",this)}}else{this._oMaxDate=V.getInstance(9999,11,31,23,59,59,999)}this.setProperty("maxDate",e);if(this._getCalendar()){this._getCalendar().setMaxDate(e)}this._oMaxDate.setHours(23,59,59,999);return this};E.prototype.setCurrentDateButton=function(e){var t=this._getCalendar();t&&t.setCurrentDateButton(e);return this.setProperty("showCurrentDateButton",e)};E.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){g.warning("minDate > MaxDate -> dates switched",this);var e=V.getInstance(this._oMinDate.getTime());var t=V.getInstance(this._oMaxDate.getTime());e.setHours(23,59,59,999);t.setHours(0,0,0,0);this._oMinDate=V.getInstance(t.getTime());this._oMaxDate=V.getInstance(e.getTime());this.setProperty("minDate",t,true);this.setProperty("maxDate",e,true);if(this._getCalendar()){this._getCalendar().setMinDate(t);this._getCalendar().setMaxDate(e)}}var a=this.getDateValue();if(a&&(a.getTime()<this._oMinDate.getTime()||a.getTime()>this._oMaxDate.getTime())){this._bValid=false;g.error("dateValue "+a.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this)}};E.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType")};E.prototype._handleDateValidation=function(e){this._bValid=true;if(!e||e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){this._bValid=false;g.warning("Value can not be converted to a valid date",this)}var t=this._formatValue(e,true);if(t!==this.getValue()){this.setLastValue(t)}this.setProperty("value",t);this.setProperty("dateValue",e)};E.prototype.setDisplayFormatType=function(e){if(e){var t=false;for(var a in I){if(a==e){t=true;break}}if(!t){throw new Error(e+" is not a valid calendar type"+this)}}this.setProperty("displayFormatType",e,true);this.setDisplayFormat(this.getDisplayFormat());return this};E.prototype.setSecondaryCalendarType=function(e){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",e,true);if(this._getCalendar()){this._getCalendar().setSecondaryCalendarType(e)}return this};E.prototype.setShowFooter=function(e){var t=this._oPopup,a=this._getCalendar();this.setProperty("showFooter",e);if(!t||!a){return this}t._getButtonFooter().setVisible(e);return this};E.prototype.addSpecialDate=function(e){B.call(this,e);this.addAggregation("specialDates",e,true);k.call(this);return this};E.prototype.insertSpecialDate=function(e,t){B.call(this,e);this.insertAggregation("specialDates",e,t,true);k.call(this);return this};E.prototype.removeSpecialDate=function(e){var t=this.removeAggregation("specialDates",e,true);k.call(this);return t};E.prototype.removeAllSpecialDates=function(){var e=this.removeAllAggregation("specialDates",true);k.call(this);return e};E.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);k.call(this);return this};E.prototype.setLegend=function(e){this.setAssociation("legend",e,true);var t=this.getLegend();if(t){var a=sap.ui.require("sap/ui/unified/CalendarLegend");e=sap.ui.getCore().byId(t);if(e&&!(typeof a=="function"&&e instanceof a)){throw new Error(e+" is not an sap.ui.unified.CalendarLegend. "+this)}}if(this._getCalendar()){this._getCalendar().setLegend(t)}return this};E.prototype.onChange=function(e){if(!this.getEditable()||!this.getEnabled()){return}var t=this._$input.val(),a=this._formatValue(this.getDateValue()),i;if(t==a&&this._bValid){return}if(this.getShowFooter()&&this._oPopup&&!t){this._oPopup.getBeginButton().setEnabled(false)}this._bValid=true;if(t!=""){i=this._parseValue(t,true);if(!i||i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime()){this._bValid=false;i=undefined}else{t=this._formatValue(i)}}if(this.getDomRef()&&this._$input.val()!==t){this._$input.val(t);this._curpos=this._$input.cursorPos()}if(i){t=this._formatValue(i,true)}if(this.getLastValue()!==t||i&&this.getDateValue()&&i.getFullYear()!==this.getDateValue().getFullYear()){this.setLastValue(t);this.setProperty("value",t,true);var s=this.getValue();if(this._bValid&&t==s){this.setProperty("dateValue",i,true)}t=s;if(this.isOpen()){if(this._bValid){i=this.getDateValue()}this._getCalendar().focusDate(i);var n=this._oDateRange.getStartDate();if(!n&&i||n&&i&&n.getTime()!=i.getTime()){this._oDateRange.setStartDate(V.getInstance(i.getTime()))}else if(n&&!i){this._oDateRange.setStartDate(undefined)}}this.fireChangeEvent(t,{valid:this._bValid})}};E.prototype.updateDomValue=function(e){if(this.isActive()&&this._$input.val()!==e){this._bCheckDomValue=true;e=typeof e=="undefined"?this._$input.val():e.toString();this._curpos=this._$input.cursorPos();var t=this._parseValue(e,true);e=this._formatValue(t);if(this._bPreferUserInteraction){this.handleInputValueConcurrency(e)}else{this._$input.val(e);if(document.activeElement===this._$input[0]){this._$input.cursorPos(this._curpos)}}}return this};function R(e){this._createPopup();this._createPopupContent();var t;var a=this.getBinding("value");if(a&&a.oType&&a.oType.oOutputFormat){t=a.oType.oOutputFormat.oFormatOptions.calendarType}else if(a&&a.oType&&a.oType.oFormat){t=a.oType.oFormat.oFormatOptions.calendarType}if(!t){t=this.getDisplayFormatType()}if(t){this._getCalendar().setPrimaryCalendarType(t)}var i=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(i!=this._$input.val()){this.onChange()}this._fillDateRange();this._openPopup(e);this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar()),afterPopupOpened:true})}E.prototype._createPopup=function(){var a="";if(!this._oPopup){this._oPopup=new n(this.getId()+"-RP",{showCloseButton:false,showArrow:false,showHeader:false,placement:r.PlacementType.VerticalPreferredBottom,contentWidth:this.$().closest(".sapUiSizeCompact").length>0?"18rem":"21rem",beginButton:new s({type:r.ButtonType.Emphasized,text:w.getText("DATEPICKER_SELECTION_CONFIRM"),press:this._handleOKButton.bind(this)}),afterOpen:x.bind(this),afterClose:O.bind(this)}).addStyleClass("sapMRPCalendar");if(this.getShowFooter()){this._oPopup.addStyleClass("sapMLandscapePadding")}this._oPopup._getPopup().setAutoClose(true);if(e.system.phone){a=v.getReferencingLabels(this).concat(this.getAriaLabelledBy()).reduce(function(e,a){var i=t.registry.get(a);return e+" "+(i.getText?i.getText():"")},"").trim();this._oPopup.setTitle(a);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true)}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.setEndButton(new s({text:w.getText("DATEPICKER_SELECTION_CANCEL"),press:this._handleCancelButton.bind(this)}))}this.setAggregation("_popup",this._oPopup,true)}};E.prototype._openPopup=function(e){if(!this._oPopup){return}if(!e){e=this.getDomRef()}this._oPopup._getPopup().setExtraContent([e]);this._oPopup.openBy(e||this)};E.prototype.openBy=function(e){R.call(this,e)};E.prototype._getVisibleDatesRange=function(e){var t=e._getVisibleDays();return new y({startDate:t[0].toLocalJSDate(),endDate:t[t.length-1].toLocalJSDate()})};E.prototype._createPopupContent=function(){var e=this._getCalendarConstructor();if(!this._getCalendar()){this._oCalendar=new e(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),calendarWeekNumbering:this.getCalendarWeekNumbering(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar())})}.bind(this)});this._oCalendar.setShowCurrentDateButton(this.getShowCurrentDateButton());this._oDateRange=new y;this._getCalendar().addSelectedDate(this._oDateRange);this._getCalendar()._setSpecialDatesControlOrigin(this);this._getCalendar().attachCancel(F,this);if(this.$().closest(".sapUiSizeCompact").length>0){this._getCalendar().addStyleClass("sapUiSizeCompact")}if(this._bSecondaryCalendarTypeSet){this._getCalendar().setSecondaryCalendarType(this.getSecondaryCalendarType())}if(this._bOnlyCalendar){this._getCalendar().attachSelect(this._handleCalendarSelect,this);this._getCalendar().attachEvent("_renderMonth",A,this);this._oPopup._getButtonFooter().setVisible(this.getShowFooter());this._getCalendar()._bSkipCancelButtonRendering=true;if(!this._oPopup.getContent().length){var t=this._getValueStateHeader();this._oPopup.addContent(this._getValueStateHeader());t.setPopup(this._oPopup._oControl)}this._oPopup.addContent(this._getCalendar());if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false)}}this._attachAfterRenderingDelegate()}};E.prototype._attachAfterRenderingDelegate=function(){this._oCalendarAfterRenderDelegate={onAfterRendering:function(){var e=this._oPopup&&this._oPopup._getPopup();e&&e._oLastPosition&&e._applyPosition(e._oLastPosition);if(this._oPopup.isOpen()){this._oCalendar.focus()}}.bind(this)};this._oCalendar.addDelegate(this._oCalendarAfterRenderDelegate)};E.prototype._getCalendarConstructor=function(){var e=this._getFormatter(true).aFormatArray.map(function(e){return e.type.toLowerCase()}),t=e.indexOf("day")>=0,a=e.indexOf("month")>=0||e.indexOf("monthstandalone")>=0,i=e.indexOf("year")>=0;if(t&&a&&i){return _}else if(a&&i){return m}else if(i){return C}else{g.warning("Not valid date pattern! Default Calendar constructor function is returned",this);return _}};E.prototype._fillDateRange=function(){var e=this.getDateValue();if(e&&e.getTime()>=this._oMinDate.getTime()&&e.getTime()<=this._oMaxDate.getTime()){this._getCalendar().focusDate(V.getInstance(e.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=e.getTime()){this._oDateRange.setStartDate(V.getInstance(e.getTime()))}}else{var t=this.getInitialFocusedDateValue();var a=t?t:V.getInstance();if(a.getTime()<this._oMinDate.getTime()){a=this._oMinDate}else if(a.getTime()>this._oMaxDate.getTime()){a=this._oMaxDate}this._getCalendar().focusDate(a);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined)}}};E.prototype.getAccessibilityInfo=function(){var e=this.getRenderer();var t=a.prototype.getAccessibilityInfo.apply(this,arguments);var i=this.getValue()||"";var s=this.getRequired()?M.getLibraryResourceBundle("sap.m").getText("ELEMENT_REQUIRED"):"";if(this._bValid){var n=this.getDateValue();if(n){i=this._formatValue(n)}}t.type=w.getText("ACC_CTR_TYPE_DATEINPUT");t.description=[i||this._getPlaceholder(),e.getLabelledByAnnouncement(this),e.getDescribedByAnnouncement(this),s].join(" ").trim();return t};E.prototype._selectDate=function(){var t=this.getDateValue(),a=this._getSelectedDate(),i="";if(!h(a,t)){this.setDateValue(V.getInstance(a.getTime()));i=this.getValue();this.fireChangeEvent(i,{valid:true});this._focusInput()}else if(!this._bValid){i=this._formatValue(a);if(i!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(i);this.setLastValue(i)}i=this._formatValue(a,true);this.setProperty("value",i,true);this.fireChangeEvent(i,{valid:true});this._focusInput()}}else if(e.system.desktop||!e.support.touch){this.focus()}this._oPopup.close()};E.prototype._handleCalendarSelect=function(){if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(true);return}this._selectDate()};E.prototype._getTimezone=function(e){return P.getTimezone()};E.prototype._focusInput=function(){if(this.getDomRef()&&(e.system.desktop||!e.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos)}return this};E.prototype._getCalendar=function(){return this._oCalendar};E.prototype._getSelectedDate=function(){var e=this._getCalendar().getSelectedDates(),t;if(e.length>0){t=e[0].getStartDate()}return t};E.prototype._handleOKButton=function(){this._selectDate()};E.prototype._handleCancelButton=function(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false)}this._oPopup.close()};function F(t){if(this.isOpen()){this._oPopup.close();if(e.system.desktop||!e.support.touch){this.focus()}}}E.prototype._increaseDate=function(e,t){var a=this.getDateValue();var i=this._$input.cursorPos();if(a&&this.getEditable()&&this.getEnabled()){var s;var n=this.getBinding("value");if(n&&n.oType&&n.oType.oOutputFormat){s=n.oType.oOutputFormat.oFormatOptions.calendarType}else if(n&&n.oType&&n.oType.oFormat){s=n.oType.oFormat.oFormatOptions.calendarType}if(!s){s=this.getDisplayFormatType()}var r=o.getInstance(V.getInstance(a.getTime()),s);a=o.getInstance(V.getInstance(a.getTime()),s);switch(t){case"day":r.setDate(r.getDate()+e);break;case"month":r.setMonth(r.getMonth()+e);var p=(a.getMonth()+e)%12;if(p<0){p=12+p}while(r.getMonth()!=p){r.setDate(r.getDate()-1)}break;case"year":r.setFullYear(r.getFullYear()+e);while(r.getMonth()!=a.getMonth()){r.setDate(r.getDate()-1)}break;default:break}if(r.getTime()<this._oMinDate.getTime()){r=new o(this._oMinDate.getTime())}else if(r.getTime()>this._oMaxDate.getTime()){r=new o(this._oMaxDate.getTime())}if(!h(this.getDateValue(),r.getJSDate())){this.setDateValue(V.getInstance(r.getTime()));this._curpos=i;this._$input.cursorPos(this._curpos);var l=this.getValue();this.fireChangeEvent(l,{valid:true})}}};E.prototype._getSpecialDates=function(){var e=this.getSpecialDates();for(var t=0;t<e.length;t++){var a=e[t].getSecondaryType()===T.CalendarDayType.NonWorking&&e[t].getType()!==T.CalendarDayType.NonWorking;if(a){var i=new D;i.setType(e[t].getSecondaryType());i.setStartDate(e[t].getStartDate());if(e[t].getEndDate()){i.setEndDate(e[t].getEndDate())}e.push(i)}}return e};function x(){this.addStyleClass(a.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._getCalendar().$("-Month0-days").find(".sapUiCalItem").length;f.addPopoverInstance(this._oPopup);this._oCalendar.focus();this.fireAfterValueHelpOpen()}function O(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false)}this.removeStyleClass(a.ICON_PRESSED_CSS_CLASS);this._getCalendar()._closePickers();f.removePopoverInstance(this._oPopup);this.fireAfterValueHelpClose()}function A(e){var t=e.getParameter("days"),a=this._oPopup._getPopup();if(t>this._renderedDays){this._renderedDays=t;a._applyPosition(a._oLastPosition)}}function B(e){var t=sap.ui.require("sap/ui/unified/DateTypeRange");if(e&&!(t&&e instanceof t)){throw new Error(e+'is not valid for aggregation "specialDates" of '+this)}}function k(){if(this.isOpen()){this._getCalendar()._bDateRangeChanged=false;this._getCalendar().invalidate()}}return E});
//# sourceMappingURL=DatePicker.js.map