/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/m/Text","sap/m/Title","sap/m/FormattedText","sap/m/Illustration","sap/base/Log","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/library","sap/ui/core/ResizeHandler","sap/ui/thirdparty/jquery","./IllustratedMessageRenderer"],function(e,t,i,s,a,l,o,r,n,u,jQuery,p){"use strict";var d=e.IllustratedMessageSize;var T=e.IllustratedMessageType;var g=n.TextAlign;var I=n.TitleLevel;var h=o.extend("sap.m.IllustratedMessage",{metadata:{library:"sap.m",properties:{description:{type:"string",group:"Misc",defaultValue:""},enableDefaultTitleAndDescription:{type:"boolean",group:"Appearance",defaultValue:true},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false},enableVerticalResponsiveness:{type:"boolean",group:"Appearance",defaultValue:false},illustrationSize:{type:"sap.m.IllustratedMessageSize",group:"Appearance",defaultValue:d.Auto},illustrationType:{type:"string",group:"Appearance",defaultValue:T.NoSearchResults},title:{type:"string",group:"Misc",defaultValue:""},ariaTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:I.Auto}},aggregations:{additionalContent:{type:"sap.m.Button",multiple:true},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_illustration:{type:"sap.m.Illustration",visibility:"hidden",multiple:false},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_title:{type:"sap.m.Title",multiple:false,visibility:"hidden"}},associations:{illustrationAriaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"illustrationAriaLabelledBy"}},dnd:{draggable:false,droppable:true}},renderer:p});h.ORIGINAL_TEXTS={UnableToLoad:"UnableToLoad",UnableToUpload:"UnableToUpload",NoActivities:"NoActivities",BeforeSearch:"BeforeSearch",NoSearchResults:"NoSearchResults",NoEntries:"NoEntries",NoData:"NoData",NoNotifications:"NoNotifications",BalloonSky:"BalloonSky",SuccessScreen:"SuccessScreen",NoMail:"NoMail",NoSavedItems:"NoSavedItems",NoTasks:"NoTasks",UploadToCloud:"UploadToCloud",NoDimensionsSet:"NoDimensionsSet",AddDimensions:"AddDimensions"};h.FALLBACK_TEXTS={ReloadScreen:h.ORIGINAL_TEXTS.UnableToLoad,Connection:h.ORIGINAL_TEXTS.UnableToLoad,ErrorScreen:h.ORIGINAL_TEXTS.UnableToUpload,EmptyCalendar:h.ORIGINAL_TEXTS.NoActivities,SearchEarth:h.ORIGINAL_TEXTS.BeforeSearch,SearchFolder:h.ORIGINAL_TEXTS.NoSearchResults,EmptyList:h.ORIGINAL_TEXTS.NoEntries,Tent:h.ORIGINAL_TEXTS.NoData,SleepingBell:h.ORIGINAL_TEXTS.NoNotifications,SimpleBalloon:h.ORIGINAL_TEXTS.BalloonSky,SimpleBell:h.ORIGINAL_TEXTS.NoNotifications,SimpleCalendar:h.ORIGINAL_TEXTS.NoActivities,SimpleCheckMark:h.ORIGINAL_TEXTS.SuccessScreen,SimpleConnection:h.ORIGINAL_TEXTS.UnableToLoad,SimpleEmptyDoc:h.ORIGINAL_TEXTS.NoData,SimpleEmptyList:h.ORIGINAL_TEXTS.NoEntries,SimpleError:h.ORIGINAL_TEXTS.UnableToUpload,SimpleMagnifier:h.ORIGINAL_TEXTS.BeforeSearch,SimpleMail:h.ORIGINAL_TEXTS.NoMail,SimpleNoSavedItems:h.ORIGINAL_TEXTS.NoSavedItems,SimpleNotFoundMagnifier:h.ORIGINAL_TEXTS.NoSearchResults,SimpleReload:h.ORIGINAL_TEXTS.UnableToLoad,SimpleTask:h.ORIGINAL_TEXTS.NoTasks,SuccessBalloon:h.ORIGINAL_TEXTS.BalloonSky,SuccessCheckMark:h.ORIGINAL_TEXTS.SuccessScreen,SuccessHighFive:h.ORIGINAL_TEXTS.BalloonSky};h.PREPENDS={DESCRIPTION:"IllustratedMessage_DESCRIPTION_",TITLE:"IllustratedMessage_TITLE_"};h.BREAK_POINTS={DIALOG:679,SPOT:319,DOT:259,BASE:159};h.BREAK_POINTS_HEIGHT={DIALOG:451,SPOT:296,DOT:154,BASE:87};h.MEDIA={BASE:"sapMIllustratedMessage-Base",DOT:"sapMIllustratedMessage-Dot",SPOT:"sapMIllustratedMessage-Spot",DIALOG:"sapMIllustratedMessage-Dialog",SCENE:"sapMIllustratedMessage-Scene"};h.RESIZE_HANDLER_ID={CONTENT:"_sContentResizeHandlerId"};h.prototype.init=function(){this._sLastKnownMedia=null;this._updateInternalIllustrationSetAndType(this.getIllustrationType());r.getEventBus().subscribe("sapMIllusPool-assetLdgFailed",this._handleMissingAsset.bind(this))};h.prototype.onBeforeRendering=function(){this._detachResizeHandlers()};h.prototype.onAfterRendering=function(){this._updateDomSize();this._attachResizeHandlers();this._preventWidowWords(this._getTitle().getDomRef());this._preventWidowWords(this._getDescription().getDomRef());this._setDefaultIllustrationLabel()};h.prototype.exit=function(){this._detachResizeHandlers()};h.prototype.setIllustrationType=function(e){if(this.getIllustrationType()===e){return this}if(typeof e==="string"){this._updateInternalIllustrationSetAndType(e)}return this.setProperty("illustrationType",e)};h.prototype._setDefaultIllustrationLabel=function(e){var t=this.getAssociation("ariaLabelledBy"),i=this._getTitle().sId;if(!t||!t.length){this.addIllustrationAriaLabelledBy(i)}};h.prototype._getDefaultDescription=function(){return this._findDefaultText(h.PREPENDS.DESCRIPTION)};h.prototype._getDefaultTitle=function(){return this._findDefaultText(h.PREPENDS.TITLE)};h.prototype._findDefaultText=function(e){var t=this._getResourceBundle();return t.getText(e+this._sIllustrationType,undefined,true)||t.getText(e+this._sIllustrationType.substr(0,this._sIllustrationType.indexOf("_v")),undefined,true)||t.getText(e+h.FALLBACK_TEXTS[this._sIllustrationType],undefined,true)};h.prototype._shouldRenderTitle=function(){return this._getTitle().getText().length!==0};h.prototype._shouldRenderDescription=function(){var e=this._getDescription();if(this.getEnableFormattedText()){return e.getHtmlText().length!==0}else{return e.getText().length!==0}};h.prototype._getDescription=function(){return this.getEnableFormattedText()?this._getFormattedText():this._getText()};h.prototype._getFormattedText=function(){var e=this.getDescription(),t=this.getAggregation("_formattedText");if(!t){t=new s({textAlign:g.Center});this.setAggregation("_formattedText",t)}if(!e&&this.getEnableDefaultTitleAndDescription()){t.setHtmlText(this._getDefaultDescription())}else{t.setHtmlText(e)}return t};h.prototype._getIllustration=function(){var e=this.getAggregation("_illustration");if(!e){e=new a;this.setAggregation("_illustration",e)}return e};h.prototype._getResourceBundle=function(){return r.getLibraryResourceBundle("sap.m")};h.prototype._getText=function(){var e=this.getDescription(),i=this.getAggregation("_text");if(!i){i=new t({textAlign:g.Center});this.setAggregation("_text",i)}if(!e&&this.getEnableDefaultTitleAndDescription()){i.setText(this._getDefaultDescription())}else{i.setText(e)}return i};h.prototype._getTitle=function(){var e=this.getTitle(),t=this.getAggregation("_title");if(!t){t=new i({wrapping:true});this.setAggregation("_title",t)}if(!e&&this.getEnableDefaultTitleAndDescription()){t.setText(this._getDefaultTitle())}else{t.setText(e)}return t};h.prototype._preventWidowWords=function(e){var t,i,s=window.HTMLElement;if(!(s&&e instanceof s)){return}t=jQuery(e);i=t.html();i=i.replace(/ ([^ ]*)$/,"&nbsp;$1");t.html(i)};h.prototype._updateDomSize=function(){var e=this.getDomRef(),t,i;if(e){t=this.getIllustrationSize();if(t===d.Auto){this._updateMedia(e.getBoundingClientRect().width,e.getBoundingClientRect().height)}else{i=h.MEDIA[t.toUpperCase()];this._updateSymbol(i);this._updateMediaStyle(i)}}};h.prototype._updateInternalIllustrationSetAndType=function(e){var t=e.split("-");this._sIllustrationSet=t[0];this._sIllustrationType=t[1]};h.prototype._onResize=function(e){var t=e.size.width,i=e.size.height;this._updateMedia(t,i)};h.prototype._updateMedia=function(e,t){var i=this.getEnableVerticalResponsiveness(),s;if(!e&&!t){return}if(e<=h.BREAK_POINTS.BASE||t<=h.BREAK_POINTS_HEIGHT.BASE&&i){s=h.MEDIA.BASE}else if(e<=h.BREAK_POINTS.DOT||t<=h.BREAK_POINTS_HEIGHT.DOT&&i){s=h.MEDIA.DOT}else if(e<=h.BREAK_POINTS.SPOT||t<=h.BREAK_POINTS_HEIGHT.SPOT&&i){s=h.MEDIA.SPOT}else if(e<=h.BREAK_POINTS.DIALOG||t<=h.BREAK_POINTS_HEIGHT.DIALOG&&i){s=h.MEDIA.DIALOG}else{s=h.MEDIA.SCENE}this._updateSymbol(s);this._updateMediaStyle(s)};h.prototype._updateMediaStyle=function(e){if(this._sLastKnownMedia!==e){this._sLastKnownMedia=e}else{return}Object.keys(h.MEDIA).forEach(function(t){var i=e===h.MEDIA[t];this.toggleStyleClass(h.MEDIA[t],i)},this)};h.prototype._updateSymbol=function(e){if(e===h.MEDIA.BASE){return}var t=e.substring(e.indexOf("-")+1);this._getIllustration().setSet(this._sIllustrationSet,true).setMedia(t,true).setType(this._sIllustrationType)};h.prototype._getFallbackMedia=function(){var e=this._sLastKnownMedia,t=Object.values(h.MEDIA),i=t.indexOf(e);if(i>-1&&i<t.length-1){return t[i+1]}else{return t[t.length-1]}};h.prototype._handleMissingAsset=function(){var e,t=Object.values(h.MEDIA),i="";if(this._sLastKnownMedia!==t[t.length-1]){e=this._getIllustration();i=this._getFallbackMedia();e.setMedia(i.substring(i.indexOf("-")+1));l.warning(this._sLastKnownMedia+" is unavailable, retrying with larger size...",this)}else{l.warning("No larger fallback asset available, no SVG will be displayed.",this)}};h.prototype._attachResizeHandlers=function(){var e=this.getIllustrationSize();if(this.getDomRef()&&e===d.Auto){this._registerResizeHandler(h.RESIZE_HANDLER_ID.CONTENT,this,this._onResize.bind(this))}};h.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(h.RESIZE_HANDLER_ID.CONTENT)};h.prototype._registerResizeHandler=function(e,t,i){if(!this[e]){this[e]=u.register(t,i)}};h.prototype._deRegisterResizeHandler=function(e){if(this[e]){u.deregister(this[e]);this[e]=null}};h.prototype.getAccessibilityReferences=function(){return{title:this._getTitle().getId(),description:this._getDescription().getId()}};h.prototype.getAccessibilityInfo=function(){var e=this._getTitle().getText(),t=this._getDescription().getText(),i=this.getAdditionalContent();return{type:this._getResourceBundle().getText("ACC_CTR_ILLUSTRATED_MESSAGE"),description:e+". "+t,focusable:!!i.length,children:i}};h.prototype.addIllustrationAriaLabelledBy=function(e){var t=this.getAssociation("ariaLabelledBy"),i=this._getTitle().sId,s=this._getIllustration();this.addAssociation("ariaLabelledBy",e,true);if(t&&t.includes(i)){this.removeIllustrationAriaLabelledBy(i)}s.addAriaLabelledBy(e);return this};h.prototype.removeIllustrationAriaLabelledBy=function(e){this.removeAssociation("ariaLabelledBy",e,true);var t=this._getIllustration();t.removeAriaLabelledBy(e);this._setDefaultIllustrationLabel();return this};h.prototype.removeAllAriaLabelledBy=function(e){this.removeAssociation("ariaLabelledBy",e,true);var t=this._getIllustration();t.removeAllAriaLabelledBy(e);this._setDefaultIllustrationLabel();return this};h.prototype.setAriaTitleLevel=function(e){this.setProperty("ariaTitleLevel",e,true);this._getTitle().setLevel(e);return this};return h});
//# sourceMappingURL=IllustratedMessage.js.map