/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/base/DataType","sap/base/security/URLListValidator","./ImageRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeCSS","sap/ui/Device","sap/ui/core/library"],function(t,e,i,r,o,a,jQuery,s,n,p){"use strict";var h=t.ImageMode;var u=p.aria.HasPopup;var g=e.extend("sap.m.Image",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Image.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null},densityAware:{type:"boolean",group:"Misc",defaultValue:false},activeSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},mode:{type:"sap.m.ImageMode",group:"Misc",defaultValue:"Image"},backgroundSize:{type:"string",group:"Appearance",defaultValue:"cover"},backgroundPosition:{type:"string",group:"Appearance",defaultValue:"initial"},backgroundRepeat:{type:"string",group:"Appearance",defaultValue:"no-repeat"},lazyLoading:{type:"boolean",defaultValue:false},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:u.None}},aggregations:{detailBox:{type:"sap.m.LightBox",multiple:false,bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDetails:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDetails"}},events:{tap:{},press:{},load:{},error:{}},dnd:{draggable:true,droppable:false}},renderer:o});g._currentDevicePixelRatio=function(){var t=window.devicePixelRatio===undefined?1:window.devicePixelRatio;if(t<=1){t=1}else{t*=2;t=Math.round(t);t/=2}if(t>2){t=2}return t}();g.prototype.init=function(){this._oSvgCachedData={}};g.prototype.onload=function(t){var e,i;if(!this._defaultEventTriggered){this._defaultEventTriggered=true}this._bVersion2Tried=false;var r=this.$(),o=r[0];if(this.getMode()===h.Background){r.css("background-image",'url("'+s(this._oImage.src)+'")')}if(!this._isWidthOrHeightSet()){if(this._iLoadImageDensity>1){e=Math.round(o.getBoundingClientRect().width);i=Math.round(o.getBoundingClientRect().height);if(e===o.naturalWidth&&i===o.naturalHeight){r.width(e/this._iLoadImageDensity)}}}r.removeClass("sapMNoImg");this.fireLoad()};g.prototype.onerror=function(t){if(!this._defaultEventTriggered){this._defaultEventTriggered=true}var e=this.$(),i=this.getMode(),r=i===h.Image?this._getDomImg().attr("src"):this._oImage.src,o=g._currentDevicePixelRatio,a=this._isActiveState?this.getActiveSrc():this.getSrc();e.addClass("sapMNoImg");if(!r||this._iLoadImageDensity===1){if(this.getAlt()&&!this.getDecorative()){e.removeClass("sapMNoImg")}this.fireError();return}if(o===2||o<1){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(a,1))}else if(o===1.5){if(this._bVersion2Tried){setTimeout(jQuery.proxy(function(){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(a,1))},this),0)}else{setTimeout(jQuery.proxy(function(){this._iLoadImageDensity=2;this._updateDomSrc(this._generateSrcByDensity(a,2));this._bVersion2Tried=true},this),0)}}};g.prototype.setDetailBox=function(t){var e=this.getDetailBox();if(t){if(t===e){return this}if(e){this.detachPress(this._fnLightBoxOpen,e)}this._fnLightBoxOpen=t.open;this.attachPress(this._fnLightBoxOpen,t)}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,e);this._fnLightBoxOpen=null}return this.setAggregation("detailBox",t)};g.prototype.setSrc=function(t){var e=this.getSrc(),i=this.setProperty("src",t);if(t&&e!==this.getSrc()&&this.getMode()===h.InlineSvg){t.endsWith("svg")&&this._loadSvg()}return i};g.prototype.clone=function(){var t=e.prototype.clone.apply(this,arguments),i=t.getDetailBox();if(i){t.detachPress(this._fnLightBoxOpen,this.getDetailBox());t._fnLightBoxOpen=i.open;t.attachPress(t._fnLightBoxOpen,i)}return t};g.prototype.onBeforeRendering=function(){this._defaultEventTriggered=false;if(this.getMode()==h.Image){var t=this.getDetailBox()?this.$().find(".sapMImg"):this.$();t.off("load").off("error")}if(this.getMode()===h.InlineSvg){this._loadSvg()}};g.prototype.onAfterRendering=function(){var t=this.getDetailBox()?this.$().find(".sapMImg"):this.$(),e=this.getMode(),i;if(e===h.Image){t.on("load",jQuery.proxy(this.onload,this));t.on("error",jQuery.proxy(this.onerror,this));i=t[0]}if(e===h.Background){i=this._oImage}if(i&&i.complete&&!this._defaultEventTriggered){if(n.browser.firefox&&this.getSrc().indexOf(".svg")>-1){return}if(i.naturalWidth>0){this.onload({})}else{this.onerror({})}}};g.prototype.exit=function(){if(this._oImage){jQuery(this._oImage).off("load",this.onload).off("error",this.onerror);this._oImage=null}else{this.$().off("load",this.onload).off("error",this.onerror)}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null}this._oSvgCachedData=null};g.prototype.ontouchstart=function(t){if(t.srcControl.mEventRegistry["press"]||t.srcControl.mEventRegistry["tap"]){t.setMarked()}if(t.targetTouches.length===1&&this.getActiveSrc()){this._updateDomSrc(this._getDensityAwareActiveSrc());this._isActiveState=true}};g.prototype.ontouchend=function(t){if(t.targetTouches.length===0&&this.getActiveSrc()){this._isActiveState=false;this._updateDomSrc(this._getDensityAwareSrc());this.$().removeClass("sapMNoImg")}};g.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);e.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button")}return this};g.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);e.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation")}else{this.$().removeAttr("role")}}return this};g.prototype.ontap=function(t){this.fireTap({});this.firePress({})};g.prototype.onkeyup=function(t){if(t.which===a.SPACE||t.which===a.ENTER){this.firePress({});t.stopPropagation()}};g.prototype.onsapspace=function(t){t.preventDefault()};g.prototype._loadSvg=function(){var t=this,e=this.getSrc(),i;if(!this._oSvgCachedData[e]){t._oSvgCachedData[e]={};jQuery.get(this.getSrc(),function(r){i=jQuery(r).find("svg")[0];if(i){sap.ui.require(["sap/m/_thirdparty/purify"],function(r){t._oSvgCachedData[e].oSvgDomRef=r.sanitize(i,{RETURN_DOM:true});t.invalidate()})}}).done(function(){t.fireLoad()}).fail(function(){t.fireError()})}};g.prototype._getSvgCachedData=function(){var t=this.getSrc();if(this._oSvgCachedData[t]&&typeof this._oSvgCachedData[t].oSvgDomRef==="object"){return this._oSvgCachedData[t].oSvgDomRef}};g.prototype._isHrefValid=function(t){return r.validate(t)};g.prototype._updateDomSrc=function(t){var e=this.$(),i=this.getMode();if(e.length){if(i===h.Image){this._getDomImg().attr("src",t)}else{e.addClass("sapMNoImg");jQuery(this._oImage).attr("src",t)}}};g.prototype._getDomImg=function(){var t=this.$();return this.getDetailBox()?t.children("img"):t};g.prototype._preLoadImage=function(t){if(this.getMode()!==h.Background){return}var e=jQuery(this._oImage);if(!this._oImage){this._oImage=new window.Image;e=jQuery(this._oImage);e.on("load",jQuery.proxy(this.onload,this)).on("error",jQuery.proxy(this.onerror,this))}this._oImage.src=t};g.prototype._isWidthOrHeightSet=function(){return this.getWidth()&&this.getWidth()!==""||this.getHeight()&&this.getHeight()!==""};g.prototype._getDensityAwareSrc=function(){var t=this.getSrc(),e=this.getDensityAware(),i=e?g._currentDevicePixelRatio:1;this._iLoadImageDensity=i;return this._generateSrcByDensity(t,i)};g.prototype._getDensityAwareActiveSrc=function(){var t=this.getActiveSrc(),e=this.getDensityAware(),i=e?g._currentDevicePixelRatio:1;this._iLoadImageDensity=i;return this._generateSrcByDensity(t,i)};g.prototype._generateSrcByDensity=function(t,e){if(!t){return""}if(this._isDataUri(t)){this._iLoadImageDensity=1;return t}if(e===1){return t}var i=t.lastIndexOf("."),r=t.lastIndexOf("/"),o=t.substring(0,i),a=t.substring(i);if(i===-1||r>i){return t+"@"+e}o=o+"@"+e;return o+a};g.prototype._isDataUri=function(t){return t?t.indexOf("data:")===0:false};g.prototype._isValidBackgroundSizeValue=function(t){t=l(t);return c(t.split(" "),["auto","cover","contain","initial"])||i.getType("sap.ui.core.CSSSizeShortHand").isValid(t)};g.prototype._isValidBackgroundPositionValue=function(t){t=l(t);return c(t.split(" "),["left","right","top","center","bottom","initial"])||i.getType("sap.ui.core.CSSSizeShortHand").isValid(t)};g.prototype.getAccessibilityInfo=function(){var t=this.hasListeners("press");if(this.getDecorative()&&!this.getUseMap()&&!t){return null}return{role:t?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(t?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||"",focusable:t}};g.prototype.getFocusDomRef=function(){return this.getDomRef("inner")||this.getDomRef()};g.prototype.getFormDoNotAdjustWidth=function(){return true};function c(t,e){function i(t){return e.indexOf(t)<0}return t&&e&&!t.some(i)}function l(t){var e=/\s+/g;return t==null?"":String(t).trim().replace(e," ")}return g});
//# sourceMappingURL=Image.js.map