/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Renderer","sap/ui/core/library","sap/ui/core/ValueStateSupport","sap/ui/Device","sap/ui/core/Configuration","sap/ui/core/Lib"],function(e,t,n,a,i,s){"use strict";var r=t.TextDirection;var l=t.ValueState;var d={apiVersion:2};d.render=function(t,n){var s=n.getValueState(),d=n.getTextDirection(),o=e.getTextAlign(n.getTextAlign(),d),u=i.getAccessibility(),c=n.getAggregation("_beginIcon")||[],g=n.getAggregation("_endIcon")||[],p,f;t.openStart("div",n);this.addOuterStyles(t,n);this.addControlWidth(t,n);t.class("sapMInputBase");this.addPaddingClass(t,n);this.addCursorClass(t,n);this.addOuterClasses(t,n);if(!n.getEnabled()){t.class("sapMInputBaseDisabled")}if(!n.getEditable()){t.class("sapMInputBaseReadonly")}if(s!==l.None&&n.getEditable()&&n.getEnabled()){t.class("sapMInputBaseState")}if(c.length){p=c.filter(function(e){return e.getVisible()});p.length&&t.class("sapMInputBaseHasBeginIcons")}if(g.length){f=g.filter(function(e){return e.getVisible()});f.length&&t.class("sapMInputBaseHasEndIcons")}this.writeOuterAttributes(t,n);var b=n.getTooltip_AsString();if(b){t.attr("title",b)}t.openEnd();t.openStart("div",n.getId()+"-content");t.class("sapMInputBaseContentWrapper");if(!n.getEnabled()){t.class("sapMInputBaseDisabledWrapper")}else if(!n.getEditable()){t.class("sapMInputBaseReadonlyWrapper")}if(s!==l.None&&n.getEditable()&&n.getEnabled()){this.addValueStateClasses(t,n)}this.addWrapperStyles(t,n);t.openEnd();if(c.length){this.writeIcons(t,c)}this.prependInnerContent(t,n);this.openInputTag(t,n);if(n.getName()){t.attr("name",n.getName())}if(!n.bShowLabelAsPlaceholder&&n._getPlaceholder()){t.attr("placeholder",n._getPlaceholder())}if(n.getMaxLength&&n.getMaxLength()>0){t.attr("maxlength",n.getMaxLength())}if(!n.getEnabled()){t.attr("disabled","disabled")}else if(!n.getEditable()){t.attr("readonly","readonly")}if(d!=r.Inherit){t.attr("dir",d.toLowerCase())}this.writeInnerValue(t,n);if(u){this.writeAccessibilityState(t,n)}if(a.browser.mozilla){if(b){t.attr("x-moz-errormessage",b)}else{t.attr("x-moz-errormessage"," ")}}this.writeInnerAttributes(t,n);t.class("sapMInputBaseInner");this.addInnerClasses(t,n);t.style("text-align",o);this.addInnerStyles(t,n);this.endInputTag(t,n);this.writeInnerContent(t,n);this.closeInputTag(t,n);this.writeAdditionalContent(t,n);if(g.length){this.writeIcons(t,g)}t.close("div");this.writeDecorations(t,n);if(u){this.renderAriaLabelledBy(t,n);this.renderAriaDescribedBy(t,n);this.renderValueStateAccDom(t,n)}t.close("div")};d.getAriaRole=function(e){return"textbox"};d.getAriaLabelledBy=function(e){if(this.getLabelledByAnnouncement(e)){return e.getId()+"-labelledby"}};d.getLabelledByAnnouncement=function(e){return""};d.renderAriaLabelledBy=function(e,t){var n=this.getLabelledByAnnouncement(t);if(n){e.openStart("span",t.getId()+"-labelledby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(n.trim()).close("span")}};d.getAriaDescribedBy=function(e){if(this.getDescribedByAnnouncement(e)){return e.getId()+"-describedby"}};d.getDescribedByAnnouncement=function(e){return""};d.renderAriaDescribedBy=function(e,t){var n=this.getDescribedByAnnouncement(t);if(n){e.openStart("span",t.getId()+"-describedby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(n.trim()).close("span")}};d.renderValueStateAccDom=function(e,t){var a=t.getValueState();if(a===l.None||!t.getEditable()||!t.getEnabled()){return}var i=t.getAggregation("_invisibleFormattedValueStateText");var r;r=s.getResourceBundleFor("sap.m").getText("INPUTBASE_VALUE_STATE_"+a.toUpperCase());e.openStart("div",t.getValueStateMessageId()+"-sr").class("sapUiPseudoInvisibleText");e.openEnd().text(r).text(" ");if(i){e.renderControl(i)}else{e.text(t.getValueStateText()||n.getAdditionalText(t))}e.close("div")};d.getAccessibilityState=function(e){var t=this.getAriaLabelledBy(e),n=this.getAriaDescribedBy(e),a=this.getAriaRole(e),i=e.getValueStateMessageId()+"-sr",s={};if(a){s.role=a}if(e.getValueState()===l.Error&&e.getEditable()&&e.getEnabled()){s.invalid=true;s.errormessage=i}else if(e.getValueState()!==l.None&&e.getEditable()&&e.getEnabled()){n=n?i+" "+n:i}if(t){s.labelledby={value:t.trim(),append:true}}if(n){s.describedby={value:n.trim(),append:true}}s.disabled=null;s.readonly=null;return s};d.writeAccessibilityState=function(e,t){e.accessibilityState(t,this.getAccessibilityState(t))};d.openInputTag=function(e,t){e.voidStart("input",t.getId()+"-"+this.getInnerSuffix())};d.endInputTag=function(e,t){e.voidEnd()};d.writeInnerValue=function(e,t){e.attr("value",t.getValue())};d.addCursorClass=function(e,t){};d.addPaddingClass=function(e,t){e.class("sapMInputBaseHeightMargin")};d.addOuterStyles=function(e,t){};d.addControlWidth=function(e,t){if(!t.getProperty("width")){e.class("sapMInputBaseNoWidth")}e.style("width",t.getWidth())};d.addOuterClasses=function(e,t){};d.writeOuterAttributes=function(e,t){};d.addInnerStyles=function(e,t){};d.addWrapperStyles=function(e,t){e.style("width","100%")};d.addInnerClasses=function(e,t){};d.writeInnerAttributes=function(e,t){};d.prependInnerContent=function(e,t){};d.writeInnerContent=function(e,t){};d.writeAdditionalContent=function(e,t){};d.writeIcons=function(e,t){e.openStart("div").attr("tabindex","-1").class("sapMInputBaseIconContainer").openEnd();t.forEach(e.renderControl,e);e.close("div")};d.writeDecorations=function(e,t){};d.closeInputTag=function(e,t){};d.addPlaceholderStyles=function(e,t){};d.addPlaceholderClasses=function(e,t){};d.addValueStateClasses=function(e,t){e.class("sapMInputBaseContentWrapperState");e.class("sapMInputBaseContentWrapper"+t.getValueState())};d.getInnerSuffix=function(){return"inner"};return d},true);
//# sourceMappingURL=InputBaseRenderer.js.map