/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Dialog","./library","sap/ui/core/EnabledPropagator","./DialogRenderer","sap/ui/core/library","sap/ui/Device","./Bar","./Button","./Title","sap/m/OverflowToolbarLayoutData","sap/ui/base/ManagedObjectObserver","sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isEmptyObject"],function(e,t,i,s,a,n,o,r,l,u,g,jQuery,h,p){"use strict";var c=t.OverflowToolbarPriority;var d=t.ListType;var f=t.P13nPanelType;var _=t.ListMode;var v=a.MessageType;var m=t.ButtonType;var b=t.BackgroundDesign;var y;var I;var T={apiVersion:2,render:function(e,t){s.render.apply(this,arguments);var i=t._getVisiblePanelID();var a=t.getVisiblePanel();if(i&&a){e.openStart("div",i);e.openEnd();e.renderControl(a);e.close("div")}}};var N=e.extend("sap.m.P13nDialog",{metadata:{deprecated:true,library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},renderer:T});i.apply(N.prototype,[true]);N.prototype.init=function(t){this.addStyleClass("sapMP13nDialog");e.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._mValidationListener={};this._createDialog();this._bTabBarUsed=true;this._mVisibleNavigationItems={};this._bNavigationControlsPromiseResolved=false;this._oNavigationControlsPromise=this._requestRequiredNavigationControls();this._oObserver=new g(P.bind(this));this._oObserver.observe(this,{properties:["showReset","showResetEnabled"],aggregations:["panels"]})};N.prototype.setShowResetEnabled=function(e){return this.setProperty("showResetEnabled",e,true)};N.prototype._createDialog=function(){if(n.system.phone){var e=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new o(this.getId()+"-phoneHeader",{contentLeft:new r(this.getId()+"-backToList",{visible:false,type:m.Back,press:function(){e._backToList()}}),contentMiddle:new l(this.getId()+"-phoneTitle",{text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H2"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton())}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton())}};N.prototype._showValidationDialog=function(e,t,i){var s=[];var a=[];this._prepareMessages(t,i,s,a);var n=this;return new Promise(function(t){sap.ui.require(["sap/m/MessageBox"],function(i){var o="";if(a.length){a.forEach(function(e,t,i){o=(i.length>1?"• ":"")+e.messageText+"\n"+o});i.show(o,{icon:i.Icon.ERROR,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE_ERROR"),actions:[i.Action.CLOSE],styleClass:n.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""})}else if(s.length){s.forEach(function(e,t,i){o=(i.length>1?"• ":"")+e.messageText+"\n"+o});o=o+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE_QUESTION");i.show(o,{icon:i.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),emphasizedAction:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),i.Action.IGNORE],onClose:function(t){if(t===i.Action.IGNORE){e()}},styleClass:n.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""})}t()})})};N.prototype._prepareMessages=function(e,t,i,s){if(!e.length&&!t.length){return}e.forEach(function(e){switch(e){case f.filter:t.push({messageType:v.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")});break;case f.columns:t.push({messageType:v.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")});break;default:h.error("Panel type '"+e+"' is not supported jet.")}});var a=t.filter(function(e,t,i){for(var s=++t;s<i.length;s++){if(e.messageText===i[s].messageText){return false}}return true});a.forEach(function(e){if(e.messageType===v.Warning){i.push(e)}else if(e.messageType===v.Error){s.push(e)}})};N.prototype._mapPanelToNavigationItem=function(e){if(!e){return null}return n.system.phone?new I(e.getId()+"-navItem",{type:d.Navigation,title:e.getTitle()}):new I(e.getId()+"-navItem",{text:e.getTitle()})};N.prototype._switchPanel=function(e){var t=this._getPanelByNavigationItem(e);this.setVerticalScrolling(t.getVerticalScrolling());if(n.system.phone){var i=this._getNavigationControl();if(i){i.setVisible(false);t.beforeNavigationTo();t.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(t.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true)}}else{this.getPanels().forEach(function(e){if(e===t){e.beforeNavigationTo();e.setVisible(true)}else{e.setVisible(false)}},this)}this.invalidate();this.rerender()};N.prototype._backToList=function(){var e=this._getNavigationControl();if(e){e.setVisible(true);var t=this.getVisiblePanel();t.setVisible(false);this._updateDialogTitle();this.getCustomHeader().getContentLeft()[0].setVisible(false)}};N.prototype.getVisiblePanel=function(){var e=null;this.getPanels().some(function(t){if(t.getVisible()){e=t;return true}});return e};N.prototype._getVisiblePanelID=function(){var e=this.getVisiblePanel();if(e){return this.getId()+"-panel_"+e.getId()}return null};N.prototype._getPanelByNavigationItem=function(e){for(var t=0,i=this.getPanels(),s=i.length;t<s;t++){if(this._getNavigationItemByPanel(i[t])===e){return i[t]}}return null};N.prototype._getNavigationItemByPanel=function(e){return e?e.data("sapMP13nDialogNavigationItem"):null};N.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);var t=jQuery(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&t){var s=jQuery(document.getElementById(i));s.appendTo(jQuery(t))}};N.prototype._updateDialogTitle=function(){var e=this.getVisiblePanel();var t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");if(!this._isNavigationControlExpected()&&e){switch(e.getType()){case f.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case f.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case f.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case f.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case f.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=e.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS")}}if(n.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t)}else{this.setTitle(t)}};N.prototype._registerValidationListener=function(e,t){if(this.getPanels().indexOf(e)&&t&&this._mValidationListener[e.getType()]===undefined){this._mValidationListener[e.getType()]=t}};N.prototype._callValidationExecutor=function(){var e=this.getValidationExecutor();if(e&&!p(this._mValidationListener)){var t=this;e(this._getPayloadOfPanels()).then(function(e){var i=t._distributeValidationResult(e);for(var s in t._mValidationListener){var a=t._mValidationListener[s];a(i[s]||[])}})}};N.prototype._distributeValidationResult=function(e){var t={};e.forEach(function(e){e.panelTypes.forEach(function(i){if(t[i]===undefined){t[i]=[]}t[i].push({columnKey:e.columnKey,messageType:e.messageType,messageText:e.messageText})})});return t};N.prototype._createOKButton=function(){var e=this;return new r(this.getId()+"-ok",{type:m.Emphasized,text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new u({priority:c.NeverOverflow}),press:function(){e.setBusy(true);var t=e._getPayloadOfPanels();var i=function(){e.setBusy(false);e.fireOk({payload:t})};var s=[];var a=function(){e.getPanels().forEach(function(e){if(s.indexOf(e.getType())>-1){e.onAfterNavigationFrom()}});i()};e.getPanels().forEach(function(e){if(!e.onBeforeNavigationFrom()){s.push(e.getType())}});var n=[];var o=e.getValidationExecutor();if(o){o(t).then(function(t){if(s.length||t.length){e.setBusy(false);e._showValidationDialog(a,s,t)}else{i()}})}else{if(s.length||n.length){e.setBusy(false);e._showValidationDialog(a,s,n)}else{i()}}}})};N.prototype._createCancelButton=function(){var e=this;return new r(this.getId()+"-cancel",{text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new u({priority:c.NeverOverflow}),press:function(){e.fireCancel()}})};N.prototype._createResetButton=function(){var e=this;return new r(this.getId()+"-reset",{text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new u({priority:c.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){sap.ui.getCore().byId(e.getId()+"-ok").focus();e.setShowResetEnabled(false);var t={};e.getPanels().forEach(function(e){t[e.getType()]=e.getResetPayload()});e.fireReset({payload:t})}})};N.prototype._getPayloadOfPanels=function(){var e={};this.getPanels().forEach(function(t){e[t.getType()]=t.getOkPayload()});return e};N.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;this._bTabBarUsed=false;this._mValidationListener={};this._mVisibleNavigationItems={};this._oNavigationControlsPromise=null};N.prototype._isInstanceOf=function(e,t){var i=sap.ui.require(t);return e&&typeof i==="function"&&e instanceof i};function P(e){if(this._isInstanceOf(e.object,"sap/m/P13nDialog")){var t;switch(e.name){case"panels":var i=e.child?[e.child]:e.children;i.forEach(function(t){switch(e.mutation){case"insert":this._mVisibleNavigationItems[t.sId]=t.getVisible();t.setVisible(false);t.beforeNavigationTo();this._oObserver.observe(t,{properties:["title"]});t.setValidationExecutor(jQuery.proxy(this._callValidationExecutor,this));t.setValidationListener(jQuery.proxy(this._registerValidationListener,this));break;case"remove":delete this._mVisibleNavigationItems[t.sId];this._oObserver.unobserve(t);t.setValidationExecutor();t.setValidationListener();break;default:h.error("Mutation '"+e.mutation+"' is not supported jet.")}},this);if(this._bNavigationControlsPromiseResolved){this._updateDialog()}else{this._oNavigationControlsPromise.then(function(){this._updateDialog()}.bind(this))}break;case"showReset":t=this.getButtons();if(t.length>1){t[2].setVisible(e.current)}break;case"showResetEnabled":t=this.getButtons();if(t.length>1){t[2].setEnabled(e.current);t[2].invalidate()}break;default:h.error("The property or aggregation '"+e.name+"' has not been registered.")}}else if(this._isInstanceOf(e.object,"sap/m/P13nPanel")){if(e.name==="title"){var s=this._getNavigationItemByPanel(e.object);if(s){if(n.system.phone){s.setTitle(e.current)}else{s.setText(e.current)}}}}}N.prototype._isNavigationControlExpected=function(){return this._getCountOfVisibleNavigationItems()>1};N.prototype._getCountOfVisibleNavigationItems=function(){var e=0;for(var t in this._mVisibleNavigationItems){e=this._mVisibleNavigationItems[t]?e+1:e}return e};N.prototype._isNavigationControlExists=function(){return n.system.phone?this.getContent().length>0:!!this.getSubHeader()&&this.getSubHeader().getContentLeft().length>0};N.prototype._getNavigationControl=function(){if(!this._isNavigationControlExists()){this._createNavigationControl()}return n.system.phone?this.getContent()[0]:this.getSubHeader().getContentLeft()[0]};N.prototype._setVisibleOfNavigationControl=function(e){if(!this._isNavigationControlExists()){return}return n.system.phone?this.getContent()[0].setVisible(e):this.getSubHeader().setVisible(e)};N.prototype._createNavigationControl=function(){if(n.system.phone){this.addContent(new y(this.getId()+"-navigationItems",{mode:_.None,itemPress:function(e){this._switchPanel(e.getParameter("listItem"))}.bind(this)}))}else{this.setSubHeader(new o(this.getId()+"-navigationBar",{contentLeft:new y(this.getId()+"-navigationItems",{backgroundDesign:b.Transparent,expandable:false,select:function(e){this._switchPanel(e.getParameter("item"))}.bind(this)})}))}return this._getNavigationControl()};N.prototype._updateDialog=function(){var e=this._getNavigationControl();e.destroyItems();var t=this._determineInitialVisiblePanel();this.getPanels().forEach(function(i){var s=this._mapPanelToNavigationItem(i);i.data("sapMP13nDialogNavigationItem",s);e.addItem(s);var a=n.system.phone?this._mVisibleNavigationItems[i.sId]&&this._getCountOfVisibleNavigationItems()===1:this._mVisibleNavigationItems[i.sId]&&t===i.sId;i.setVisible(a);if(a){this.setVerticalScrolling(i.getVerticalScrolling())}s.setVisible(this._mVisibleNavigationItems[i.sId]);if(a&&e.setSelectedItem){e.setSelectedItem(s)}}.bind(this));this._updateDialogTitle();this._setVisibleOfNavigationControl(this._isNavigationControlExpected())};N.prototype._determineInitialVisiblePanel=function(){if(this.getInitialVisiblePanelType()){for(var e=0;e<this.getPanels().length;e++){if(this.getPanels()[e].getType()==this.getInitialVisiblePanelType()){return this.getPanels()[e].sId}}}var t;this.getPanels().some(function(e){if(this._mVisibleNavigationItems[e.sId]){t=e.sId;return true}}.bind(this));return t};N.prototype._requestRequiredNavigationControls=function(){var e=n.system.phone?"sap/m/List":"sap/m/IconTabBar";var t=n.system.phone?"sap/m/StandardListItem":"sap/m/IconTabFilter";y=sap.ui.require(e);I=sap.ui.require(t);if(y&&I){this._bNavigationControlsPromiseResolved=true;return Promise.resolve()}if(!this._oNavigationControlsPromise){this._oNavigationControlsPromise=new Promise(function(i){sap.ui.require([e,t],function(e,t){y=e;I=t;this._bNavigationControlsPromiseResolved=true;return i()}.bind(this))}.bind(this))}return this._oNavigationControlsPromise};return N});
//# sourceMappingURL=P13nDialog.js.map