/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Theming","./library","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/IconPool","./Suggest","sap/ui/Device","./SearchFieldRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/core/Lib","sap/ui/dom/jquery/cursorPos"],function(e,t,s,i,o,n,r,u,a,jQuery,g){"use strict";var l=s.extend("sap.m.SearchField",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.f.IShellBar","sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},maxLength:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Misc",defaultValue:null},showMagnifier:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},showRefreshButton:{type:"boolean",group:"Behavior",defaultValue:false},refreshButtonTooltip:{type:"string",group:"Misc",defaultValue:null},showSearchButton:{type:"boolean",group:"Behavior",defaultValue:true},enableSuggestions:{type:"boolean",group:"Behavior",defaultValue:false},selectOnFocus:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"suggestionItems",designtime:"sap/m/designtime/SearchField.designtime",aggregations:{suggestionItems:{type:"sap.m.SuggestionItem",multiple:true,singularName:"suggestionItem"}},events:{search:{parameters:{query:{type:"string"},suggestionItem:{type:"sap.m.SuggestionItem"},refreshButtonPressed:{type:"boolean"},clearButtonPressed:{type:"boolean"},searchButtonPressed:{type:"boolean"},escPressed:{type:"boolean"}}},change:{parameters:{value:{type:"string"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}},renderer:u});i.call(l.prototype);o.insertFontFaceStyle();l.prototype.init=function(){this._lastValue=""};l.prototype.getFocusDomRef=function(){return this.getInputElement()};l.prototype.getFocusInfo=function(){var e=s.prototype.getFocusInfo.call(this),t=this.getDomRef("I");if(t){jQuery.extend(e,{cursorPos:jQuery(t).cursorPos()})}return e};l.prototype.applyFocusInfo=function(e){s.prototype.applyFocusInfo.call(this,e);if("cursorPos"in e){this.$("I").cursorPos(e.cursorPos)}return this};l.prototype.getWidth=function(){return this.getProperty("width")||"100%"};l.prototype.getInputElement=function(){return this.getDomRef("I")};l.prototype.onBeforeRendering=function(){this._unregisterEventListeners();d(this)};l.prototype.onAfterRendering=function(){this._lastValue=this.getValue();var e=this.getInputElement();this._resetElement=this.getDomRef("reset");jQuery(e).on("input",this.onInput.bind(this)).on("search",this.onSearch.bind(this)).on("change",this.onChange.bind(this)).on("focus",this.onFocus.bind(this)).on("blur",this.onBlur.bind(this));jQuery(this.getDomRef("F")).on("click",this.onFormClick.bind(this)).on("submit",function(e){e.preventDefault()});if(r.system.desktop||r.system.combi){this.$().on("touchstart mousedown",this.onButtonPress.bind(this));if(r.browser.firefox){this.$().find(".sapMSFB").on("mouseup mouseout",function(e){jQuery(e.target).removeClass("sapMSFBA")})}}};l.prototype.onThemeChanged=function(){if(this._oSuggest){this._oSuggest.setPopoverMinWidth()}};l.prototype.clear=function(e){var t=e&&e.value||"";var s=!!(e&&e.clearButton);if(!this.getInputElement()||this.getValue()===t){return}this._updateValue(t);d(this);this.fireLiveChange({newValue:t});this._fireChangeEvent();var i={query:t,refreshButtonPressed:false,clearButtonPressed:s,searchButtonPressed:false};if(!s){i.escPressed=true}this.fireSearch(i)};l.prototype.exit=function(){this._unregisterEventListeners();if(this._oSuggest){this._oSuggest.destroy(true);this._oSuggest=null}};l.prototype.onButtonPress=function(e){if(e.originalEvent.button===2){return}var t=this.getInputElement();if(document.activeElement===t&&e.target!==t){e.preventDefault()}if(r.browser.firefox){var s=jQuery(e.target);if(s.hasClass("sapMSFB")){s.addClass("sapMSFBA")}}};l.prototype.ontouchstart=function(e){this._oTouchStartTarget=e.target};l.prototype.ontouchend=function(e){if(e.originalEvent.button===2){return}var t=e.target,s=true,i=this.getInputElement();if(this._oTouchStartTarget){s=this._oTouchStartTarget===t;this._oTouchStartTarget=null}if(t.id==this.getId()+"-reset"&&s){h(this);this._bSuggestionSuppressed=true;var o=!this.getValue();var n=document.activeElement;if((r.system.desktop||o||/(INPUT|TEXTAREA)/i.test(n.tagName)||n===this._resetElement)&&n!==i){i.focus()}this.clear({clearButton:true})}else if(t.id==this.getId()+"-search"&&s){h(this);if(r.system.desktop&&!this.getShowRefreshButton()&&document.activeElement!==i){i.focus()}var u=!!(this.getShowRefreshButton()&&!this.hasStyleClass("sapMFocus"));this._fireChangeEvent();this.fireSearch({query:this.getValue(),refreshButtonPressed:u,clearButtonPressed:false,searchButtonPressed:!u})}else{this.onmouseup(e)}};l.prototype.onmouseup=function(e){if(r.system.phone&&this.getEnabled()&&e.target.tagName=="INPUT"&&document.activeElement===e.target&&!c(this)){this.onFocus(e)}};l.prototype.onFormClick=function(e){if(this.getEnabled()&&e.target.tagName=="FORM"){this.getInputElement().focus()}};l.prototype.onSearch=function(e){var t=this.getInputElement().value;this._updateValue(t);this._fireChangeEvent();this.fireSearch({query:t,refreshButtonPressed:false,clearButtonPressed:false,searchButtonPressed:false});if(!r.system.desktop){this._blur()}};l.prototype._blur=function(){var e=this;window.setTimeout(function(){var t=e.getInputElement();if(t){t.blur()}},13)};l.prototype.onChange=function(e){this._fireChangeEvent()};l.prototype.onsapfocusleave=function(e){this._fireChangeEvent()};l.prototype._fireChangeEvent=function(){var e=this.getInputElement().value;if(this._lastValue===e){return}this._lastValue=e;this.fireChange({value:e})};l.prototype.onInput=function(){var e=this.getInputElement().value;this._updateValue(e);this.fireLiveChange({newValue:e});if(this.getEnableSuggestions()){if(this._iSuggestDelay){clearTimeout(this._iSuggestDelay)}this._iSuggestDelay=setTimeout(function(){this.fireSuggest({suggestValue:e});d(this);this._iSuggestDelay=null}.bind(this),400)}};l.prototype.onkeydown=function(e){var t;var s;var i;switch(e.which){case a.F5:case a.ENTER:this.$("search").toggleClass("sapMSFBA",true);e.stopPropagation();e.preventDefault();if(c(this)){h(this);if((t=this._oSuggest.getSelected())>=0){s=this.getSuggestionItems()[t];this._updateValue(s.getSuggestionText())}}this._fireChangeEvent();this.fireSearch({query:this.getValue(),suggestionItem:s,refreshButtonPressed:this.getShowRefreshButton()&&e.which===a.F5,clearButtonPressed:false,searchButtonPressed:false});break;case a.ESCAPE:if(c(this)){h(this);e.setMarked()}else{i=this.getValue();if(i===this._sOriginalValue){this._sOriginalValue=""}this.clear({value:this._sOriginalValue});if(i!==this.getValue()){e.setMarked()}}e.preventDefault();break}};l.prototype.onkeyup=function(e){if(e.which===a.F5||e.which===a.ENTER){this.$("search").toggleClass("sapMSFBA",false)}};l.prototype.onFocus=function(e){this.addStyleClass("sapMFocus");this._sOriginalValue=this.getValue();if(this.getEnableSuggestions()){if(!this._bSuggestionSuppressed){this.fireSuggest({suggestValue:this.getValue()})}else{this._bSuggestionSuppressed=false}}};l.prototype.onBlur=function(e){this.removeStyleClass("sapMFocus");if(this._bSuggestionSuppressed){this._bSuggestionSuppressed=false}};l.prototype._updateValue=function(e){e=e||"";var t=this.getInputElement();if(t){if(t.value!==e){t.value=e}var s=this.$();if(s.hasClass("sapMSFVal")==!e){s.toggleClass("sapMSFVal",!!e)}}this.setProperty("value",e,true);return this};l.prototype._unregisterEventListeners=function(){var e=this.getInputElement();if(e){this.$().find(".sapMSFB").off();this.$().off();jQuery(this.getDomRef("F")).off();jQuery(e).off()}};l.prototype.onsapshow=function(e){if(this.getEnableSuggestions()){if(c(this)){h(this)}else{this.fireSuggest({suggestValue:this.getValue()})}}};l.prototype.onsaphide=function(e){this.suggest(false)};function p(e,t,s,i){var o;if(c(e)){o=e._oSuggest.setSelected(s,i);if(o>=0){e._updateValue(e.getSuggestionItems()[o].getSuggestionText())}t.preventDefault()}}l.prototype.onsapdown=function(e){p(this,e,1,true)};l.prototype.onsapup=function(e){p(this,e,-1,true)};l.prototype.onsaphome=function(e){p(this,e,0,false)};l.prototype.onsapend=function(e){var t=this.getSuggestionItems().length-1;p(this,e,t,false)};l.prototype.onsappagedown=function(e){p(this,e,10,true)};l.prototype.onsappageup=function(e){p(this,e,-10,true)};l.prototype._applySuggestionAcc=function(){var e="",t=this.getSuggestionItems().length,s=g.getResourceBundleFor("sap.m");if(t===1){e=s.getText("INPUT_SUGGESTIONS_ONE_HIT")}else if(t>1){e=s.getText("INPUT_SUGGESTIONS_MORE_HITS",t)}else{e=s.getText("INPUT_SUGGESTIONS_NO_HIT")}this.$("SuggDescr").text(e)};l.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("F")};l.prototype._getToolbarInteractive=function(){return true};function h(e){e._oSuggest&&e._oSuggest.close()}function f(e){if(e.getEnableSuggestions()){if(!e._oSuggest){e._oSuggest=new n(e)}e._oSuggest.open()}}function c(e){return e._oSuggest&&e._oSuggest.isOpen()}l.prototype.suggest=function(e){if(this.getEnableSuggestions()){e=e===undefined||!!e;if(e&&(this.getSuggestionItems().length||r.system.phone)){f(this)}else{h(this)}}return this};function d(e){e._oSuggest&&e._oSuggest.update()}return l});
//# sourceMappingURL=SearchField.js.map