/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ListBase","./library","sap/ui/model/ClientTreeBindingAdapter","sap/ui/model/TreeBindingCompatibilityAdapter","./TreeRenderer","sap/base/Log","sap/base/assert","sap/ui/model/controlhelper/TreeBindingProxy"],function(e,t,i,o,r,n,s,p){"use strict";var a=e.extend("sap.m.Tree",{metadata:{library:"sap.m",events:{toggleOpenState:{parameters:{itemIndex:{type:"int"},itemContext:{type:"object"},expanded:{type:"boolean"}}}}},renderer:r});a.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oProxy=new p(this,"items")};a.prototype.isTreeBinding=function(e){return e=="items"};a.prototype.getBinding=function(t){t=t||"items";var r=e.prototype.getBinding.call(this,t);if(r&&t==="items"&&!r.getLength){if(r.isA("sap.ui.model.odata.v2.ODataTreeBinding")){r.applyAdapterInterface()}else if(r.isA("sap.ui.model.ClientTreeBinding")){i.apply(r)}else if(r.isA("sap.ui.model.odata.ODataTreeBinding")){o(r,this)}else{n.error("TreeBinding is not supported for the "+this)}}return r};a.prototype.updateAggregation=function(t){if(t!="items"){return e.prototype.updateAggregation.apply(this,arguments)}var i=this.getBindingInfo("items"),o=i.factory,r;function n(e,t){var r=e.getItems()||[],n,s;if(r.length>t.length){for(var p=t.length;p<r.length;p++){e.removeItem(r[p]);r[p].destroy("KeepDom")}}for(var p=0;p<t.length;p++){n=t[p];s=r[p];if(s){s.setBindingContext(n,i.model)}else{s=o(e.getId()+"-"+p,n);s.setBindingContext(n,i.model);e.addItem(s)}}}r=this._oProxy.getContexts(0);if(!i.template){this.destroyItems()}n(this,r)};a.prototype.validateAggregation=function(t,i,o){var r=e.prototype.validateAggregation.apply(this,arguments);if(t==="items"&&!i.isA("sap.m.TreeItemBase")){throw new Error(i+" is not a valid items aggregation of "+this+". Items aggregation in Tree control only supports TreeItemBase-based objects, e.g. StandardTreeItem.")}return r};a.prototype.invalidate=function(){e.prototype.invalidate.apply(this,arguments);this._bInvalidated=true};a.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);this._bInvalidated=false};a.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oProxy=null};a.prototype._updateDeepestLevel=function(e){if(e.getLevel()+1>this.getDeepestLevel()){this._iDeepestLevel=e.getLevel()+1}};a.prototype.onItemExpanderPressed=function(e,t){var i=this.indexOfItem(e);var o=this.getBindingInfo("items");var r=e&&e.getBindingContext(o.model);if(o&&r){var n=e.getExpanded();var s;this._updateDeepestLevel(e);if(t==undefined){this._oProxy.toggleExpandedState(i)}else if(t){this._oProxy.expand(i)}else{this._oProxy.collapse(i)}s=this._oProxy.isExpanded(i);if(n!==s&&!e.isLeaf()){this.fireToggleOpenState({itemIndex:i,itemContext:r,expanded:s})}}};a.prototype.setGrowing=function(e){n.error("Growing feature of "+this+" is not supported!");return this};a.prototype.setGrowingThreshold=function(e){n.error("GrowingThreshold of "+this+" is not supported!");return this};a.prototype.setGrowingTriggerText=function(e){n.error("GrowingTriggerText of "+this+" is not supported!");return this};a.prototype.setGrowingScrollToLoad=function(e){n.error("GrowingScrollToLoad of "+this+" is not supported!");return this};a.prototype.setGrowingDirection=function(e){n.error("GrowingDirection of "+this+" is not supported!");return this};a.prototype.expandToLevel=function(e){this._oProxy.expandToLevel(e);return this};a.prototype.getNumberOfExpandedLevel=function(){return this.getBinding("items").getNumberOfExpandedLevels()};a.prototype.getDeepestLevel=function(){if(this._iDeepestLevel===undefined){this._iDeepestLevel=this.getNumberOfExpandedLevel()}return this._iDeepestLevel};a.prototype.collapseAll=function(){this._oProxy.collapseAll();return this};a.prototype._sortHelper=function(e){var t=[];if(typeof e==="number"){t.push(e)}else if(Array.isArray(e)){t=e.sort().reverse()}return t};a.prototype._removeLeaf=function(e){var t=null,i,o=[];for(var r=0;r<e.length;r++){i=e[r];t=this.getItems()[i];if(t&&!t.isLeaf()){o.push(i)}}return o};a.prototype._preExpand=function(e){var t=this._sortHelper(e);t=this._removeLeaf(t);return t};a.prototype._getDeepestLevelFromIndexArray=function(e){var t;e.forEach(e=>{if(t==undefined||this.getItems()[e].getLevel()>t.getLevel()){t=this.getItems()[e]}});return t};a.prototype.expand=function(e){var t=e.constructor==Array?this._getDeepestLevelFromIndexArray(e):this.getItems()[e];this._updateDeepestLevel(t);this._oProxy.expand(e);return this};a.prototype.collapse=function(e){this._oProxy.collapse(e);return this};a.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TREE")};a.prototype.getAccessbilityPosition=function(e){var t=this.indexOfItem(e);return{setSize:this._oProxy.getSiblingCount(t),posInset:this._oProxy.getPositionInParent(t)+1}};a.prototype.onItemLongDragOver=function(e){var t=this.indexOfItem(e),i=this.getBindingInfo("items"),o=e&&e.getBindingContext(i.model);if(e){this._updateDeepestLevel(e);if(!e.isLeaf()){this._oProxy.expand(t);this.fireToggleOpenState({itemIndex:t,itemContext:o,expanded:this._oProxy.isExpanded(t)})}}};a.prototype.isGrouped=function(){return false};a.prototype.getAriaRole=function(){return"tree"};a.prototype.setLastGroupHeader=function(){};return a});
//# sourceMappingURL=Tree.js.map