/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PluginBase","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/InvisibleText","sap/ui/Device","sap/m/ColumnPopoverActionItem","sap/m/table/columnmenu/QuickAction","sap/m/Button","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Aria"],function(e,t,i,n,o,s,a,r,jQuery){"use strict";var l=e.extend("sap.m.plugins.ColumnResizer",{metadata:{library:"sap.m",properties:{},events:{columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.core.Element"},width:{type:"sap.ui.core.CSSSize"}}}}}});var u={};var h=false;var d="sapMPluginsColumnResizer";var c=t.getConfiguration().getRTL();var f=c?"right":"left";var p=c?"left":"right";var m=c?-1:1;l.getPlugin=e.getPlugin;l.prototype.init=function(){this._iHoveredColumnIndex=-1;this._aPositions=[];this._oHandle=null};l.prototype.onActivate=function(e){e.addEventDelegate(this,this);if(e.isActive()){this.onAfterRendering()}};l.prototype.onDeactivate=function(e){e.removeEventDelegate(this,this);this.onBeforeRendering();this._oHandle=null};l.prototype.onBeforeRendering=function(){if(this._$Container){this._$Container.removeClass(d+"Container").off("."+d);this._$Container.find(this.getConfig("resizable")).removeClass(d+"Resizable");this._updateAriaDescribedBy("remove")}};l.prototype.onAfterRendering=function(){this._$Container=this.getControl().$(this.getConfig("container"));o.system.desktop&&this._$Container.on("mousemove."+d,this._onmousemove.bind(this));this._$Container.addClass(d+"Container").on("mouseleave."+d,this._onmouseleave.bind(this));this._aResizables=this._$Container.find(this.getConfig("resizable")).addClass(d+"Resizable").get();this._updateAriaDescribedBy("add");this._invalidatePositions()};l.prototype._updateAriaDescribedBy=function(e){this._aResizables.forEach(function(t){var o=i.closestTo(t,true);var s=o&&o.getFocusDomRef();jQuery(s)[e+"AriaDescribedBy"](n.getStaticId("sap.m","COLUMNRESIZER_RESIZABLE"))})};l.prototype.ontouchstart=function(e){if(this.getConfig("allowTouchResizing")&&jQuery(e.target).closest(this._aResizables)[0]){this._onmousemove(e)}else if(this._iHoveredColumnIndex==-1&&this._oHandle&&this._oHandle.style[f]){this._onmousemove(e);if(this._iHoveredColumnIndex==-1){this._oHandle.style[f]="";this._oAlternateHandle.style[f]=""}}h=this._iHoveredColumnIndex>-1;if(!h){return}this._startResizeSession(this._iHoveredColumnIndex);u.iTouchStartX=e.targetTouches[0].clientX;u.fHandleX=parseFloat(this._oHandle.style[f]);this._$Container.addClass(d+"Resizing");jQuery(document).on("touchend."+d+" mouseup."+d,this._ontouchend.bind(this))};l.prototype.ontouchmove=function(e){if(!h){return}this._setSessionDistanceX(e.targetTouches[0].clientX-u.iTouchStartX);this._oHandle.style[f]=u.fHandleX+u.iDistanceX+"px"};l.prototype._onmousemove=function(e){if(h||this.getControl().getBusy()||this.getControl().getBlocked()){return}this._setPositions();var t=e.targetTouches?e.targetTouches[0].clientX:e.clientX;var i=this._getHoveredColumnIndex(t);this._displayHandle(i)};l.prototype._onmouseleave=function(){this._invalidatePositions();this.onsapescape()};l.prototype._ontouchend=function(){this._setColumnWidth();this._cancelResizing(true)};l.prototype.onsapescape=function(){if(h){this._cancelResizing()}};l.prototype.onsaprightmodifiers=function(e){this._onLeftRightModifiersKeyDown(e,16)};l.prototype.onsapleftmodifiers=function(e){this._onLeftRightModifiersKeyDown(e,-16)};l.prototype.ondblclick=function(e){var t=e.clientX,i=this._getHoveredColumnIndex(t);if(i==-1){return}this._startResizeSession(i);this._setSessionDistanceX(this._calculateAutoColumnDistanceX());this._setColumnWidth();this._endResizeSession()};l.prototype._getHoveredColumnIndex=function(e){return this._aPositions.findIndex(function(t){return Math.abs(t-e)<=(this._oAlternateHandle||l._isInTouchMode()?20:3)},this)};l.prototype._calculateAutoColumnDistanceX=function(){var e=this.getConfig("columnRelatedCells",this._$Container,u.oCurrentColumn.getId());if(!e||!e.length){return}var t=jQuery("<div></div>").addClass(d+"SizeDetector").addClass(this.getConfig("cellPaddingStyleClass"));var i=e.children().clone().removeAttr("id");this.getConfig("additionalColumnWidth",e,i);this._$Container.append(t);var n=Math.round(t.append(i)[0].getBoundingClientRect().width);var o=c?u.fCurrentColumnWidth-n:n-u.fCurrentColumnWidth;t.remove();return o};l.prototype._invalidatePositions=function(){window.setTimeout(function(){this._bPositionsInvalid=true}.bind(this))};l.prototype._displayHandle=function(e,t){if(this._iHoveredColumnIndex==e){return}if(!this._oHandle){this._oHandle=document.createElement("div");this._oHandle.className=d+"Handle";this._oHandle.onmouseleave=function(){this.style[f]=""};if(t||l._isInTouchMode()){var i=document.createElement("div");i.className=d+"HandleCircle";i.style.top=this._aResizables[e].offsetHeight-8+"px";this._oHandle.appendChild(i);this._oAlternateHandle=this._oHandle.cloneNode(true)}}if(this._$Container[0]!==this._oHandle.parentNode){this._$Container.append(this._oHandle);if(t){this._$Container.append(this._oAlternateHandle)}}this._oHandle.style[f]=e>-1?(this._aPositions[e]-this._fContainerX)*m+"px":"";if(t){this._oAlternateHandle.style[f]=--e>-1?(this._aPositions[e]-this._fContainerX)*m+"px":""}else{if(this._oAlternateHandle){this._oAlternateHandle.style[f]=""}this._iHoveredColumnIndex=e}};l.prototype._cancelResizing=function(e){this._$Container.removeClass(d+"Resizing");if(u.iDistanceX||!e){this._oHandle.style[f]=""}else{setTimeout(function(){this._oHandle.style[f]=""}.bind(this),300)}this._iHoveredColumnIndex=-1;jQuery(document).off("."+d);this._endResizeSession();h=false};l.prototype._getColumnMinWidth=function(e){return e?48:0};l.prototype._startResizeSession=function(e){u.$CurrentColumn=jQuery(this._aResizables[e]);u.oCurrentColumn=i.closestTo(u.$CurrentColumn[0],true);u.fCurrentColumnWidth=u.$CurrentColumn.width();u.iMaxDecrease=this._getColumnMinWidth(u.oCurrentColumn)-u.fCurrentColumnWidth;u.iEmptySpace=this.getConfig("emptySpace",this.getControl());if(u.iEmptySpace!=-1){u.$NextColumn=jQuery(this._aResizables[e+1]);u.oNextColumn=i.closestTo(u.$NextColumn[0],true);u.fNextColumnWidth=u.$NextColumn.width()||0;u.iMaxIncrease=u.iEmptySpace+u.fNextColumnWidth-this._getColumnMinWidth(u.oNextColumn)}else{u.iMaxIncrease=window.innerWidth}if(c){u.iMaxDecrease=this._getColumnMinWidth(u.oNextColumn)-u.fNextColumnWidth;if(u.iEmptySpace!=-1){u.iMaxIncrease=u.iEmptySpace+u.fCurrentColumnWidth-this._getColumnMinWidth(u.oCurrentColumn)}}};l.prototype._setSessionDistanceX=function(e){u.iDistanceX=(e>0?Math.min(e,u.iMaxIncrease):Math.max(e,u.iMaxDecrease))*m};l.prototype._setColumnWidth=function(){if(!u.iDistanceX){return}var e=u.fCurrentColumnWidth+u.iDistanceX+"px";if(!this._fireColumnResize(u.oCurrentColumn,e)){return}u.oCurrentColumn.setWidth(e);if(u.oNextColumn&&(u.iEmptySpace<3||u.iDistanceX>u.iEmptySpace)){e=u.fNextColumnWidth-u.iDistanceX+u.iEmptySpace+"px";if(this._fireColumnResize(u.oNextColumn,e)){u.oNextColumn.setWidth(e)}}this.getConfig("fixAutoWidthColumns")&&this._aResizables.forEach(function(e){var t=jQuery(e),n=i.closestTo(e,true),o=n.getWidth();if(o&&o.toLowerCase()!="auto"){return}o=t.css("width");if(o&&this._fireColumnResize(n,o)){n.setWidth(o)}},this)};l.prototype._fireColumnResize=function(e,t){return this.fireColumnResize({column:e,width:t})};l.prototype._onLeftRightModifiersKeyDown=function(e,t){if(!e.shiftKey||e.ctrlKey||e.metaKey||e.altKey||l.detectTextSelection(e.target)){return}var i=jQuery(e.target).closest(this._aResizables)[0],n=this._aResizables.indexOf(i);if(n===-1){return}this._startResizeSession(n);this._setSessionDistanceX(t);this._setColumnWidth();this._endResizeSession();e.stopImmediatePropagation(true)};l.detectTextSelection=function(e){var t=window.getSelection(),i=t.toString().replace("/n","");return i&&(e!==t.focusNode&&e.contains(t.focusNode))};l.prototype._endResizeSession=function(){u={}};l.prototype._setPositions=function(){if(!this._bPositionsInvalid){return this._aPositions}this._bPositionsInvalid=false;this._fContainerX=this._$Container[0].getBoundingClientRect()[f];this._aPositions=this._aResizables.map(function(e,t,i){return e.getBoundingClientRect()[p]-(++t==i.length?1.25*m:0)},this)};l.prototype.startResizing=function(e){var t=this._aResizables.indexOf(e);this._setPositions();this._displayHandle(t,true)};l.prototype.getColumnResizeQuickAction=function(e,i){if(!e||!l._isInTouchMode()){return}return new a({content:new r({text:t.getLibraryResourceBundle("sap.m").getText("table.COLUMNMENU_RESIZE"),press:function(){i.close();this.startResizing(e.getDomRef())}.bind(this)})})};l.prototype.getColumnResizeButton=function(e){if(!e||!l._isInTouchMode()){return}return new s({text:t.getLibraryResourceBundle("sap.m").getText("COLUMNRESIZER_RESIZE_BUTTON"),icon:"sap-icon://resize-horizontal",press:this.startResizing.bind(this,e.getDomRef())})};l._isInTouchMode=function(){return window.matchMedia("(hover:none)").matches};e.setConfigs({"sap.m.Table":{container:"listUl",resizable:".sapMListTblHeaderCell",cellPaddingStyleClass:"sapMListTblCell",fixAutoWidthColumns:true,onActivate:function(e){this._vOrigFixedLayout=e.getFixedLayout();if(!e.bActiveHeaders){this.allowTouchResizing=l._isInTouchMode()}e.setFixedLayout("Strict")},onDeactivate:function(e){e.setFixedLayout(this._vOrigFixedLayout);if(this._vOrigFixedLayout=="Strict"){e.invalidate()}delete this._vOrigFixedLayout;delete this.allowTouchResizing},emptySpace:function(e){var t=e.getDomRef("tblHeadDummyCell");return t?t.clientWidth:0},columnRelatedCells:function(e,t){return e.find(".sapMListTblCell[data-sap-ui-column='"+t+"']")},additionalColumnWidth:function(e,t){var i=e[0];if(!i.hasAttribute("aria-sort")||i.getAttribute("aria-sort")==="none"){return}var n=t[0];var o=window.getComputedStyle(i.firstChild,":after");n.style.marginLeft=Math.round(parseInt(o.getPropertyValue("width")))+"px"}}},l);return l});
//# sourceMappingURL=ColumnResizer.js.map