/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PluginBase","sap/ui/core/Core","sap/ui/core/util/PasteHelper"],function(e,t,a){"use strict";var r=e.extend("sap.m.plugins.PasteProvider",{metadata:{library:"sap.m",associations:{pasteFor:{type:"sap.ui.core.Control",multiple:false}},events:{paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"},text:{type:"string"}}}}}});var n=null;var s=null;var o="[data-sap-ui-pasteregion]";r.prototype.onActivate=function(e){e.attachEvent(this.getConfig("pressEvent"),this._onPress,this)};r.prototype.onDeactivate=function(e){e.detachEvent(this.getConfig("pressEvent"),this._onPress,this)};r.prototype._onPress=function(){if(n){n.close()}s=this;var e=navigator.clipboard;if(e&&e.readText){e.readText().then(function(e){i(e);s=null},u)}else{u()}};function i(e){var t=a.getClipboardText(e);if(!t){return}var r={text:t};Object.defineProperty(r,"data",{get:a.getPastedDataAs2DArray.bind(a,t)});if(!s.firePaste(r)){return}var n=l();if(!n){return}var o=new ClipboardEvent("paste",{clipboardData:new DataTransfer,bubbles:true});o.clipboardData.setData("text",t);n.dispatchEvent(o)}function l(){var e=t.byId(s.getPasteFor());var a=e&&e.getDomRef();if(!a){return}if(a.matches(o)){return a}else{return a.querySelector(o)||a}}function p(e){var t=l();t&&t.classList.toggle("sapMPluginsPasteProviderHighlight",e)}function u(){var e=s.getControl();if(n){return n.openBy(e)}sap.ui.require(["sap/ui/Device","sap/ui/core/HTML","sap/ui/core/Icon","sap/m/Popover"],function(a,r,o,l){var u,c=t.getLibraryResourceBundle("sap.m");var f=a.system.desktop&&!a.os.ios&&!a.os.android;if(f){var v=c.getText("PASTEPROVIDER_SHORTCUT_"+(a.os.name=="mac"?"MAC":"WIN"));u=c.getText("PASTEPROVIDER_DESKTOP_MSG",'<span class="sapMPluginsPasteProviderShortCut">'+v+"</span>")}else{u=c.getText("PASTEPROVIDER_MOBILE_MSG")}var g=new r({content:'<div contenteditable="true" class="sapMPluginsPasteProviderMessage">'+u+"</div>",preferDOM:false});n=new l({title:c.getText("PASTEPROVIDER_TITLE"),showArrow:f,horizontalScrolling:false,verticalScrolling:false,placement:"Auto",content:g,initialFocus:g.getId(),beginButton:new o({src:"sap-icon://message-information"}),beforeOpen:function(){p(true)},beforeClose:function(){p(false);s=null}});n.addEventDelegate({onpaste:function(e){e.preventDefault();i(e.originalEvent);n.close()},onkeypress:function(e){e.preventDefault()}});n.openBy(e)})}e.setConfigs({"sap.m.Button":{pressEvent:"press",onActivate:function(e){if(!e.getText()&&!e.getIcon()&&!e.getTooltip_AsString()){var a=t.getLibraryResourceBundle("sap.m").getText("PASTEPROVIDER_PASTE");e.setTooltip(a);if(e.isA("sap.m.OverflowToolbarButton")){e.setText(a)}e.setIcon("sap-icon://paste")}}}},r);return r});
//# sourceMappingURL=PasteProvider.js.map