/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./RoadMapRenderer","sap/ui/core/ResizeHandler","sap/ui/Device"],function(jQuery,e,t,i,s,r){"use strict";var n=t.extend("sap.ui.commons.RoadMap",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{numberOfVisibleSteps:{type:"int",group:"Misc",defaultValue:null},firstVisibleStep:{type:"string",group:"Misc",defaultValue:null},selectedStep:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"}},defaultAggregation:"steps",aggregations:{steps:{type:"sap.ui.commons.RoadMapStep",multiple:true,singularName:"step"}},events:{stepSelected:{parameters:{stepId:{type:"string"}}},stepExpanded:{parameters:{stepId:{type:"string"}}}}}});(function(){n.prototype.init=function(){this.iStepWidth=-1;this.sCurrentFocusedStepRefId=null};n.prototype.exit=function(){if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};n.prototype.setNumberOfVisibleSteps=function(e){var t=this.getDomRef()?true:false;this.setProperty("numberOfVisibleSteps",e,t);if(t){i.updateScrollArea(this,true)}return this};n.prototype.setFirstVisibleStep=function(e){var t=this.getDomRef()?true:false;if(t){if(e){var s=sap.ui.getCore().byId(e);if(s&&s.getParent()&&(s.getParent()===this||s.getParent().getParent()===this)&&s.getVisible()){this.setProperty("firstVisibleStep",e,true);i.updateScrollArea(this)}}else{this.setProperty("firstVisibleStep","",true);i.updateScrollArea(this)}}else{this.setProperty("firstVisibleStep",e)}return this};n.prototype.setWidth=function(e){var t=this.getDomRef()?true:false;this.setProperty("width",e,t);if(t){i.setRoadMapWidth(this,e);i.updateScrollArea(this,true)}return this};n.prototype.setSelectedStep=function(e){var t=this.getDomRef()?true:false;if(t){if(e){var s=sap.ui.getCore().byId(e);if(s&&s.getParent()&&(s.getParent()===this||s.getParent().getParent()===this)&&s.getEnabled()&&s.getVisible()){i.selectStepWithId(this,e);this.setProperty("selectedStep",e,true)}}else{i.selectStepWithId(this,"");this.setProperty("selectedStep","",true)}}else{this.setProperty("selectedStep",e)}return this};n.prototype.onThemeChanged=function(e){this.iStepWidth=-1;if(this.getDomRef()){this.invalidate()}};n.prototype.doBeforeRendering=function(){var e=false;var t=false;var i=this.getSteps();for(var r=0;r<i.length;r++){var n=i[r];if(n.getSubSteps().length==0||!n.getEnabled()){n.setProperty("expanded",false,true)}if(!n.getEnabled()&&!n.getVisible()&&this.getSelectedStep()==n.getId()){this.setProperty("selectedStep","",true)}else if(n.getEnabled()&&n.getVisible()&&this.getSelectedStep()==n.getId()){e=true}if(n.getVisible()&&this.getFirstVisibleStep()==n.getId()){t=true}var o=n.getSubSteps();for(var p=0;p<o.length;p++){var a=o[p];a.setProperty("expanded",false,true);if(!a.getEnabled()&&!a.getVisible()&&this.getSelectedStep()==a.getId()){this.setProperty("selectedStep","",true)}else if(a.getEnabled()&&a.getVisible()&&this.getSelectedStep()==a.getId()){e=true}if(a.getVisible()&&this.getFirstVisibleStep()==a.getId()){t=true}}}if(!e){this.setProperty("selectedStep","",true)}if(!t){this.setProperty("firstVisibleStep","",true)}if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};n.prototype.onAfterRendering=function(){var e=this.getSteps();if(this.iStepWidth==-1&&e.length>0){var t=e[0].$();this.iStepWidth=t.outerWidth()}for(var r=0;r<e.length;r++){var n=e[r];i.addEllipses(n);var o=n.getSubSteps();for(var p=0;p<o.length;p++){i.addEllipses(o[p])}}i.updateScrollArea(this);this.sResizeListenerId=s.register(this.getDomRef(),jQuery.proxy(this.onresize,this))};n.prototype.onresize=function(e){var t=function(){if(this.getDomRef()){i.updateScrollArea(this,true);p(this,"prev");this.sResizeInProgress=null}}.bind(this);if(r.browser.firefox){t()}else{if(!this.sResizeInProgress){this.sResizeInProgress=setTimeout(t,300)}}};n.prototype.onclick=function(t){e(this,t)};n.prototype.onsapselect=function(t){e(this,t)};n.prototype.onfocusin=function(e){var t=jQuery(e.target);var s=t.attr("id");if(s&&s.endsWith("-box")){this.sCurrentFocusedStepRefId=s.slice(0,-4)}else if(s&&(s.endsWith("-Start")||s.endsWith("-End"))){}else{this.sCurrentFocusedStepRefId=i.getFirstVisibleRef(this).attr("id");p(this)}this.$().attr("tabindex","-1")};n.prototype.onfocusout=function(e){this.$().attr("tabindex","0")};n.prototype.onsapprevious=function(e){o(e,this,"prev")};n.prototype.onsapnext=function(e){o(e,this,"next")};n.prototype.onsaphome=function(e){o(e,this,"first")};n.prototype.onsapend=function(e){o(e,this,"last")};var e=function(e,i){i.stopPropagation();i.preventDefault();var s=jQuery(i.target);var r=s.attr("id");if(!r){return}var n=r.lastIndexOf("-expandend");if(n!=-1){var o=sap.ui.getCore().byId(r.substring(0,n));if(o&&e.indexOfStep(o)>=0){o.handleSelect(i,true);return}}if(r==e.getId()+"-Start"){if(s.hasClass("sapUiRoadMapStartScroll")){t(e,"prev",true)}else{p(e)}}else if(r==e.getId()+"-End"){if(s.hasClass("sapUiRoadMapEndScroll")){t(e,"next",true)}else{p(e)}}};var t=function(e,t,s){i.scrollToNextStep(e,t,function(i){var r=i.lastIndexOf("-expandend");if(r!=-1){i=i.substring(0,r)}e.setProperty("firstVisibleStep",i,true);if(s){p(e,t)}})};var o=function(e,s,r){if(e){e.stopPropagation();e.preventDefault()}if(!s.sCurrentFocusedStepRefId){return}var n=r+"All";var o=false;if(r=="first"){n="prevAll";o=true}else if(r=="last"){n="nextAll";o=true}var p=jQuery(document.getElementById(s.sCurrentFocusedStepRefId));var a=p[n](":visible");var l=jQuery(a.get(o?a.length-1:0)).attr("id");if(l){if(!i.isVisibleRef(s,l)){t(s,r)}document.getElementById(l+"-box").focus()}};var p=function(e,t){if(!e.sCurrentFocusedStepRefId){return}if(t&&!i.isVisibleRef(e,e.sCurrentFocusedStepRefId)){o(null,e,t)}else{document.getElementById(e.sCurrentFocusedStepRefId+"-box").focus()}}})();return n});
//# sourceMappingURL=RoadMap.js.map