/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","./SplitterRenderer","sap/ui/core/library","sap/ui/core/Configuration"],function(jQuery,t,e,i,s,r,o,n,a){"use strict";var h=n.Orientation;var p=e.extend("sap.ui.commons.Splitter",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{splitterOrientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:h.Vertical},splitterPosition:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:"50%"},minSizeFirstPane:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:"0%"},minSizeSecondPane:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:"0%"},width:{type:"sap.ui.commons.SplitterSize",group:"Behavior",defaultValue:"100%"},height:{type:"sap.ui.commons.SplitterSize",group:"Behavior",defaultValue:"100%"},showScrollBars:{type:"boolean",group:"Behavior",defaultValue:true},splitterBarVisible:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{firstPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"firstPaneContent"},secondPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondPaneContent"}}}});p.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}if(this.sSpecialResizeListenerId){s.deregister(this.sSpecialResizeListenerId);this.sSpecialResizeListenerId=null}};p.prototype.onAfterRendering=function(){this._recalculateInternals();this.sResizeListenerId=s.register(this.splitterDIV,jQuery.proxy(this.onresize,this))};p.prototype._recalculateInternals=function(){this.splitterDIV=this.getDomRef();this.splitterBar=document.getElementById(this.getId()+"_SB");this.firstPane=document.getElementById(this.getId()+"_firstPane");this.secondPane=document.getElementById(this.getId()+"_secondPane");this.minSizeFP=this.getMinSizeFirstPane();this.minSizeSP=this.getMinSizeSecondPane();this.minSizeFP=this.minSizeFP.substring(0,this.minSizeFP.length-1);this.minSizeFP=parseFloat(this.minSizeFP);this.minSizeSP=this.minSizeSP.substring(0,this.minSizeSP.length-1);this.minSizeSP=parseFloat(this.minSizeSP);this.spOrientation=this.getSplitterOrientation();this.sBarPosition=this.getSplitterPosition();this.sBarPosition=this.sBarPosition.substring(0,this.sBarPosition.length-1);this.sBarPosition=parseFloat(this.sBarPosition);if(a.getTheme()=="sap_hcb"){this.sbSize=6}else{this.sbSize=4}this.resizeSplitterElements();var t=jQuery(this.splitterBar).height();if(this.spOrientation==h.Vertical){if(t<=0||t>jQuery(this.splitterDIV).height()){this.fixHeight()}}else{if(t<=0||t!=this.sbSize){this.fixHeight()}}};p.prototype.onresize=function(t){this.resizeSplitterElements()};p.prototype.resizeSplitterElements=function(){var t,e,i,s,r,o;if(this.spOrientation==h.Vertical){i=jQuery(this.splitterDIV).width();if(i==0){i=100}t=this.sbSize*100/i;if(this.sBarPosition>=100||this.sBarPosition+t>100){this.sBarPosition=100-t;r=0}else{r=100-t-this.sBarPosition}jQuery(this.firstPane).css("width",this.sBarPosition+"%");jQuery(this.splitterBar).css("width",t+"%");jQuery(this.secondPane).css("width",r+"%")}else{s=jQuery(this.splitterDIV).height();if(s==0){s=100}e=this.sbSize*100/s;if(this.sBarPosition>=100||this.sBarPosition+e>100){this.sBarPosition=100-e;o=0}else{o=100-e-this.sBarPosition}jQuery(this.firstPane).css("height",this.sBarPosition+"%");jQuery(this.splitterBar).css("height",e+"%");jQuery(this.secondPane).css("height",o+"%")}this.setProperty("splitterPosition",this.sBarPosition+"%",true);if(jQuery(this.splitterDIV).height()==0&&!this.splitterDIV.style.height){jQuery(this.splitterDIV).css("height","100px");jQuery(this.splitterBar).css("height","100px")}};p.prototype.setSplitterPosition=function(t){if(this.getDomRef()){this.setProperty("splitterPosition",t,true);this._recalculateInternals()}else{this.setProperty("splitterPosition",t)}return this};p.prototype.setSplitterBarVisible=function(t){if(this.getDomRef()){this.setProperty("splitterBarVisible",t,true);var e=this.getSplitterOrientation()===h.Vertical?"sapUiVertical":"sapUiHorizontal";if(t){jQuery(document.getElementById(this.getId()+"_SB")).removeClass(e+"SplitterBarHidden").addClass(e+"SplitterBar")}else{jQuery(document.getElementById(this.getId()+"_SB")).removeClass(e+"SplitterBar").addClass(e+"SplitterBarHidden")}}else{this.setProperty("splitterBarVisible",t)}return this};p.prototype.fixHeight=function(){var t=jQuery(this.splitterDIV.parentNode).height();var e=jQuery(this.splitterDIV).height();if(t>e){e=t;var i=this.getHeight();if(i&&i.toLowerCase().indexOf("px")!=-1){e=parseInt(i)}if(i&&i.toLowerCase().indexOf("%")!=-1){var r=parseInt(i);if(r<100){e=jQuery(this.splitterDIV).height()}}if(e<=0){e=t}}jQuery(this.splitterDIV).css("height",e+"px");if(this.spOrientation==h.Vertical){jQuery(this.splitterBar).css("height",e+"px")}var o=this.splitterDIV.parentNode;if(o){var n=jQuery.proxy(this.onresizespecial,this);this.sSpecialResizeListenerId=s.register(o,n)}};p.prototype.exit=function(){if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}if(this.sSpecialResizeListenerId){s.deregister(this.sSpecialResizeListenerId);this.sSpecialResizeListenerId=null}};p.prototype.onresizespecial=function(t){var e=jQuery(this.splitterDIV);var i=e.height();e.css("height","0px");var s=this.getDomRef();if(s&&window.getComputedStyle){window.getComputedStyle(s)}var r=jQuery(t.target).height();var o=e.height();if(o!=r){e.css("height",r+"px");if(this.spOrientation==h.Vertical){jQuery(this.splitterBar).css("height",r+"px")}}if(r<=0){e.css("height",i+"px");if(this.spOrientation==h.Vertical){jQuery(this.splitterBar).css("height",i+"px")}}};p.prototype.onmousedown=function(t){if(t.target!=this.splitterBar){return}var e=jQuery(document.body);e.on("selectstart",jQuery.proxy(this.splitterSelectStart,this));var s=jQuery(this.splitterBar).offset();var r=jQuery(this.splitterBar).height();var o=jQuery(this.splitterBar).width();var n;if(this.spOrientation==h.Vertical){n="sapUiVSBGhost"}else{n="sapUiHSBGhost"}var a=i.getLastZIndex()+5;if(a<20){a=20}jQuery(document.body).append('<div id="'+this.getId()+'_ghost" class="'+n+'" style =" height:'+r+"px; width:"+o+"px; left:"+s.left+"px; top:"+s.top+"px;z-index:"+a+'"></div>');jQuery(document.body).append('<div id="'+this.getId()+'_overlay" style ="left: 0px;'+" right: 0px; bottom: 0px; top: 0px; position:fixed; z-index:"+a+'" ></div>');jQuery(document).on("mouseup",jQuery.proxy(this.onGhostMouseRelease,this));jQuery(document).on("mousemove",jQuery.proxy(this.onGhostMouseMove,this));jQuery(this.splitterBar).trigger("focus");t.preventDefault();t.stopPropagation()};p.prototype.splitterSelectStart=function(t){t.preventDefault();t.stopPropagation();return false};p.prototype.onGhostMouseRelease=function(t){var e,i,s;var r=document.getElementById(this.getId()+"_ghost");var o=a.getRTL();if(this.spOrientation==h.Vertical){if(!o){e=t.pageX-jQuery(this.firstPane).offset().left;s=jQuery(this.splitterDIV).width();e=e*100/s}else{e=t.pageX-jQuery(this.secondPane).offset().left;s=jQuery(this.splitterDIV).width();e=(s-e)*100/s}}else{e=t.pageY-jQuery(this.firstPane).offset().top;i=jQuery(this.splitterDIV).height();e=e*100/i}if(e<this.minSizeFP){e=this.minSizeFP}else if(100-e<this.minSizeSP){e=100-this.minSizeSP}this.sBarPosition=e;this.resizeSplitterElements();jQuery(r).remove();jQuery(document.getElementById(this.getId()+"_overlay")).remove();var n=jQuery(document.body);n.off("selectstart",this.splitterSelectStart);jQuery(document).off("mouseup",this.onGhostMouseRelease);jQuery(document).off("mousemove",this.onGhostMouseMove)};p.prototype.onGhostMouseMove=function(t){var e=document.getElementById(this.getId()+"_ghost");var i;var s;var r=a.getRTL();var o=jQuery(this.firstPane).offset().left;var n=jQuery(this.splitterDIV).width();var p=jQuery(this.secondPane).offset().left;if(this.getSplitterOrientation()==h.Vertical){if(!r){s=o+n*this.minSizeFP/100;i=o+n*(100-this.minSizeSP)/100;if(t.pageX>s&&t.pageX<i){jQuery(e).css("left",t.pageX+"px")}}else{s=p+n*this.minSizeSP/100;i=p+n*(100-this.minSizeFP)/100;if(t.pageX>s&&t.pageX<i){jQuery(e).css("left",t.pageX+"px")}}}else{var l=jQuery(this.splitterDIV).height();s=jQuery(this.firstPane).offset().top+l*this.minSizeFP/100;i=jQuery(this.secondPane).offset().top+jQuery(this.secondPane).height()-l*this.minSizeSP/100;if(t.pageY>s&&t.pageY<i){jQuery(e).css("top",t.pageY+"px")}}};p.prototype.getCtrlKey=function(t){return!!(t.ctrlKey||t.metaKey)};p.prototype.checkModifierKey=function(t,e,i,s){return t.shiftKey==s&&t.altKey==i&&this.getCtrlKey(t)==e};p.prototype.onsaphome=function(t){if(t.target==this.splitterBar){this.sBarPosition=this.minSizeFP;this.resizeSplitterElements();t.preventDefault();t.stopPropagation()}};p.prototype.onsapend=function(t){if(t.target==this.splitterBar){this.sBarPosition=100-this.minSizeSP;this.resizeSplitterElements();t.preventDefault();t.stopPropagation()}};p.prototype.onArrowKeys=function(t,e){var i,s,r,o,n;if(this.spOrientation==h.Vertical){i=jQuery(this.splitterDIV).width();o=jQuery(this.firstPane).width();o=o*100/i;r=10*100/i}else{s=jQuery(this.splitterDIV).height();o=jQuery(this.firstPane).height();o=o*100/s;r=10*100/s}if(e=="false"){n=o-r}else if(e=="true"){n=o+r}if(n<this.minSizeFP){n=this.minSizeFP}else if(100-n<this.minSizeSP){n=100-this.minSizeSP}this.sBarPosition=n;this.resizeSplitterElements()};p.prototype.onsapupmodifiers=function(t){if(this.checkModifierKey(t,false,false,true)){if(t.target==this.splitterBar){if(this.spOrientation==h.Horizontal){this.onArrowKeys(t,"false")}else{this.onsapleftmodifiers(t)}}t.preventDefault();t.stopPropagation()}};p.prototype.onsapdownmodifiers=function(t){if(this.checkModifierKey(t,false,false,true)){if(t.target==this.splitterBar){if(this.spOrientation==h.Horizontal){this.onArrowKeys(t,"true")}else{this.onsaprightmodifiers(t)}}t.preventDefault();t.stopPropagation()}};p.prototype.onsapleftmodifiers=function(t){if(this.checkModifierKey(t,false,false,true)){if(t.target==this.splitterBar){if(this.spOrientation==h.Vertical){var e=a.getRTL();if(e){this.onArrowKeys(t,"true")}else{this.onArrowKeys(t,"false")}}else{this.onsapupmodifiers(t)}}t.preventDefault();t.stopPropagation()}};p.prototype.onsaprightmodifiers=function(t){if(this.checkModifierKey(t,false,false,true)){if(t.target==this.splitterBar){if(this.spOrientation==h.Vertical){var e=a.getRTL();if(e){this.onArrowKeys(t,"false")}else{this.onArrowKeys(t,"true")}}else{this.onsapdownmodifiers(t)}}t.preventDefault();t.stopPropagation()}};p.prototype.ondragstart=function(t){if(t.target!=this.splitterBar){return}t.preventDefault();t.stopPropagation()};p.prototype.getText=function(t,e){var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(i){return i.getText(t,e)}return t};return p});
//# sourceMappingURL=Splitter.js.map