/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/core/ValueStateSupport","./TextFieldRenderer","sap/ui/core/library","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/selectText"],function(jQuery,e,t,i,r,a,s,o,n){"use strict";var u=a.AccessibleRole;var p=a.Design;var l=a.ImeMode;var h=a.TextAlign;var d=a.ValueState;var f=a.TextDirection;var g=t.extend("sap.ui.commons.TextField",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{value:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:f.Inherit},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},required:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxLength:{type:"int",group:"Behavior",defaultValue:0},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:d.None},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:h.Begin},imeMode:{type:"sap.ui.core.ImeMode",group:"Behavior",defaultValue:l.Auto},design:{type:"sap.ui.core.Design",group:"Appearance",defaultValue:p.Standard},helpId:{type:"string",group:"Behavior",defaultValue:""},accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:u.Textbox},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Appearance",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{newValue:{type:"string"}}},liveChange:{parameters:{liveValue:{type:"string"}}}}}});g.prototype.init=function(){};g.prototype.onfocusin=function(e){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onfocus){this.getRenderer().onfocus(this)}};g.prototype.onsapfocusleave=function(e){this._doOnEscape(e);this._checkChange(e);if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur){this.getRenderer().onblur(this)}var t=jQuery(this.getFocusDomRef());if(t.data("sap.InNavArea")===false){t.data("sap.InNavArea",true)}};g.prototype.onsapenter=function(e){this._checkChange(e)};g.prototype._checkChange=function(e){var t=this.getInputDomRef(),i=t&&t.value,r=this.getValue();if(this.getEditable()&&this.getEnabled()&&r!=i){this.setProperty("value",i,true);this.fireChange({newValue:i})}};g.prototype.onselectstart=function(e){if(!this.getEnabled()){e.preventDefault();e.stopPropagation()}};g.prototype._checkCursorPosForNav=function(e,t){var i=n.getRTL();var r=t?i:!i;var a=jQuery(this.getInputDomRef());var s=a.cursorPos();var o=a.val().length;if(i){s=o-s}if(!r&&s!=o||r&&s!=0){e.stopPropagation()}};g.prototype.onsapnext=function(e){if(e.keyCode!=o.ARROW_DOWN){if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")&&e.keyCode!=o.END){e.preventDefault();return}this._checkCursorPosForNav(e,true)}};g.prototype.onsapprevious=function(e){if(e.keyCode!=o.ARROW_UP){if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")&&e.keyCode!=o.HOME){e.preventDefault();return}this._checkCursorPosForNav(e,false)}};g.prototype.onsapnextmodifiers=g.prototype.onsapnext;g.prototype.onsappreviousmodifiers=g.prototype.onsapprevious;g.prototype.onsapend=g.prototype.onsapnext;g.prototype.onsaphome=g.prototype.onsapprevious;g.prototype.onsapexpand=function(e){var t=jQuery(this.getFocusDomRef()).data("sap.InNavArea");if(t||t===false){e.stopPropagation();return}};g.prototype.onsapcollapse=g.prototype.onsapexpand;g.prototype.onsapescape=function(e){var t=this.getProperty("value");this._bEsc=true;this._sValue=t;var i=this.getInputDomRef();if(i&&i.value!==t&&!this._propagateEsc){e.stopPropagation()}if(!s.browser.firefox){this._doOnEscape(e)}};g.prototype.onkeydown=function(e){if(e.which==o.Z&&e.ctrlKey&&!e.altKey){e.preventDefault()}};g.prototype.onkeypress=function(e){this._doOnEscape(e);var t=e.which;if(t>0&&t!==o.ESCAPE){var i=jQuery(this.getFocusDomRef());if(i.data("sap.InNavArea")){i.data("sap.InNavArea",false)}}};g.prototype._doOnEscape=function(e){if(this._bEsc){var t=this.getInputDomRef();if(t){if(t.value!==this._sValue){jQuery(t).val(this._sValue)}var i=jQuery(this.getFocusDomRef());if(i.data("sap.InNavArea")===false){i.data("sap.InNavArea",true)}}this._fireLiveChange(e);this._bEsc=undefined;this._sValue=undefined}};g.prototype.onkeyup=function(e){if(e.keyCode==o.F2){var t=jQuery(this.getFocusDomRef());if(t.data("sap.InNavArea")){t.data("sap.InNavArea",false)}else if(t.data("sap.InNavArea")===false){t.data("sap.InNavArea",true)}}};g.prototype.oninput=function(e){this._fireLiveChange(e)};g.prototype._fireLiveChange=function(e){if(this.getEnabled()&&this.getEditable()){var t=jQuery(this.getInputDomRef()).val();this.fireLiveChange({liveValue:t})}};g.prototype.setValueState=function(e){var t=this.getValueState();this.setProperty("valueState",e,true);e=this.getValueState();if(t==e){return this}if(!this.getDomRef()){return this}if(this.getRenderer().setValueState){this.getRenderer().setValueState(this,t,e)}if(this.delayedCallId){clearTimeout(this.delayedCallId);this.delayedCallId=null}if(d.Success==e){this.delayedCallId=setTimeout(function(){this.removeValidVisualization()}.bind(this),3e3)}return this};g.prototype.removeValidVisualization=function(){if(this.getRenderer().removeValidVisualization){this.getRenderer().removeValidVisualization(this)}};g.prototype.setEditable=function(e){var t=this.getEditable();this.setProperty("editable",e,true);e=this.getEditable();if(t!=e){if(this.getDomRef()&&this.getRenderer().setEditable){this.getRenderer().setEditable(this,e)}}return this};g.prototype.setEnabled=function(e){var t=this.getEnabled();this.setProperty("enabled",e,true);e=this.getEnabled();if(t!=e){if(this.getDomRef()&&this.getRenderer().setEnabled){this.getRenderer().setEnabled(this,e)}}return this};g.prototype.setRequired=function(e){var t=this.getRequired();this.setProperty("required",e,true);e=this.getRequired();if(t!=e){if(this.getDomRef()){if(this.getRenderer().setRequired){this.getRenderer().setRequired(this,e)}}this.fireEvent("requiredChanged",{required:e})}return this};g.prototype.setDesign=function(e){var t=this.getDesign();this.setProperty("design",e,true);e=this.getDesign();if(t!=e){if(this.getDomRef()){if(this.getRenderer().setDesign){this.getRenderer().setDesign(this,e)}}}return this};g.prototype.setValue=function(e){var t=e;if(t&&t.length>this.getMaxLength()&&this.getMaxLength()>0){t=t.substring(0,this.getMaxLength())}this.setProperty("value",t,true);t=this.getValue();var i=this.getInputDomRef();if(i&&i.value!==t){if(!s.support.input.placeholder){if(t){this.$().removeClass("sapUiTfPlace");i.value=t}else if(document.activeElement!==i){this.$().addClass("sapUiTfPlace");var r=this.getPlaceholder();if(this.getRenderer().convertPlaceholder){r=this.getRenderer().convertPlaceholder(this)}i.value=r}else{i.value=""}}else{i.value=t}this._sRenderedValue=t}return this};g.prototype.setTooltip=function(e){this._refreshTooltipBaseDelegate(e);this.setAggregation("tooltip",e,true);var t=this.getInputDomRef();if(t){var r=i.enrichTooltip(this,this.getTooltip_AsString());jQuery(t).attr("title",r||"");if(this._getRenderOuter()){jQuery(this.getDomRef()).attr("title",r||"")}}return this};g.prototype.getInputDomRef=function(){if(!this._getRenderOuter()){return this.getDomRef()||null}else{return this.getDomRef("input")||null}};g.prototype.applyFocusInfo=function(e){this.focus();this._restoreUnsavedUserInput(e.userinput);return this};g.prototype.getFocusInfo=function(){return{id:this.getId(),userinput:this._getUnsavedUserInputInfo()}};g.prototype.getLiveValue=function(){var e=this.getInputDomRef();if(e){return jQuery(e).val()}else{return this.getValue()}};g.prototype.ondrop=function(e){if(s.browser.firefox){this.focus()}};g.prototype._getRenderOuter=function(){if(this.bRenderOuter==undefined){var e=this.getRenderer();if(e.renderOuterAttributes||e.renderOuterContentBefore||e.renderOuterContent){this.bRenderOuter=true}else{this.bRenderOuter=false}}return this.bRenderOuter};g.prototype.getIdForLabel=function(){if(!this._getRenderOuter()){return this.getId()}else{return this.getId()+"-input"}};g.prototype.getFocusDomRef=function(){return this.getInputDomRef()};g.prototype._getUnsavedUserInputInfo=function(){var e=this.$();if(e.length&&e.hasClass("sapUiTfFoc")&&!e.hasClass("sapUiTfPlace")&&this.getEnabled()&&this.getEditable()){var t=jQuery(this.getInputDomRef());var i=t.val();var r=this.getValue();var a=0;var s=0;if(typeof t.get(0).selectionStart==="number"){a=t.get(0).selectionStart;s=t.get(0).selectionEnd}return{userinput:i,value:r,cursorPos:t.cursorPos(),selStart:a,selEnd:s}}return null};g.prototype._restoreUnsavedUserInput=function(e){if(e&&this.getEnabled()&&this.getEditable()&&this.getValue()==e.value){var t=e.userinput;if(t&&t.length>this.getMaxLength()&&this.getMaxLength()>0){t=t.substring(0,this.getMaxLength())}var i=jQuery(this.getInputDomRef());if(t!=e.value){i.val(t)}i.cursorPos(e.cursorPos);if(e.selStart!=e.selEnd){i.selectText(e.selStart,e.selEnd)}}};g.prototype.getAccessibilityInfo=function(){return{role:"textbox",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_INPUT"),description:this.getValue()||"",focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()}};return g});
//# sourceMappingURL=TextField.js.map