/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/date/UniversalDate","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/base/assert","sap/ui/core/Configuration"],function(e,t,r,a,n){"use strict";function u(t){a(t instanceof e,"method accepts only instances of UniversalDate");return t.createDate(t.constructor,[t.getJSDate()])}var s={};s.getRange=function(e,t,r,a){if(a===undefined){a=true}if(isNaN(e)){throw new TypeError("duration is NaN, but is "+e)}e=Math.trunc(e);var n=s.resetStartTime(r==undefined?null:r),i;if(a){switch(t){case"MINUTE":case"HOUR":n=s.createNewUniversalDate();break;case"DAY":break;case"WEEK":n=s.getWeekStartDate(n);break;case"MONTH":n=s.getMonthStartDate(n);break;case"QUARTER":n=s.getQuarterStartDate(n);break;case"YEAR":n=s.getYearStartDate(n);break;default:throw new TypeError("invalid unit "+t)}}switch(t){case"MINUTE":i=u(n);i.setMinutes(n.getMinutes()+e);break;case"HOUR":i=u(n);i.setHours(n.getHours()+e);break;case"DAY":if(e>0){n.setDate(n.getDate()+1)}i=u(n);e=e==0?1:e;i.setDate(n.getDate()+e);break;case"WEEK":if(e>0){n.setDate(n.getDate()+7)}i=u(n);e=e==0?1:e;i.setDate(n.getDate()+e*7);break;case"MONTH":if(e>0){n.setMonth(n.getMonth()+1)}i=u(n);e=e==0?1:e;i.setMonth(n.getMonth()+e);break;case"QUARTER":if(e>0){n.setMonth(n.getMonth()+3)}i=u(n);e=e==0?1:e;i.setMonth(n.getMonth()+e*3);break;case"YEAR":if(e>0){n.setFullYear(n.getFullYear()+1)}i=u(n);e=e==0?1:e;i.setFullYear(n.getFullYear()+e);break;default:throw new TypeError("invalid unit "+t)}if(i.getTime()<n.getTime()){i=[n,n=i][0]}if(t==="HOUR"||t==="MINUTE"){return[n,i]}i.setDate(i.getDate()-1);return[s.resetStartTime(n),s.resetEndTime(i)]};s.getWeekStartDate=function(e,a){var i=a?new t(a):n.getFormatSettings().getFormatLocale(),g=r.getInstance(i),o=g.getFirstDayOfWeek();e=e?u(e):u(s.createNewUniversalDate());e.setDate(e.getDate()-e.getDay()+o);return s.resetStartTime(e)};s.getWeekLastDate=function(e,t){var r=s.getWeekStartDate(e,t);r.setDate(r.getDate()+6);return s.resetStartTime(r)};s.getMonthStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setDate(1);return s.resetStartTime(e)};s.getMonthEndDate=function(e){var t=s.getMonthStartDate(e);t.setMonth(t.getMonth()+1);t.setDate(0);return s.resetStartTime(t)};s.getQuarterStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setMonth(3*Math.floor(e.getMonth()/3));e.setDate(1);return s.resetStartTime(e)};s.getQuarterEndDate=function(e){var t=s.getQuarterStartDate(e);t.setMonth(t.getMonth()+3);t.setDate(0);return s.resetStartTime(t)};s.getYearStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setMonth(0);e.setDate(1);return s.resetStartTime(e)};s.getYearEndDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setFullYear(e.getFullYear()+1);e.setMonth(0);e.setDate(0);return s.resetStartTime(e)};s.resetStartTime=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setHours(0,0,0,0);return e};s.resetEndTime=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setHours(23,59,59,999);return e};s.createNewUniversalDate=function(){return new e};s._getDateFromWeekStartByDayOffset=function(t,r){var a=n.getCalendarType(),u=n.getFormatSettings().getFormatLocale(),i=s.createNewUniversalDate(),g=i.getWeek(u,t),o=e.getFirstDateOfWeek(a,g.year,g.week,u,t);if(r===undefined){r=0}return new e(o.year,o.month,o.day+r,0,0,0)};s.ranges={lastDays:function(e){return s.getRange(-e,"DAY")},lastMinutes:function(e){return s.getRange(-e,"MINUTE")},lastHours:function(e){return s.getRange(-e,"HOUR")},yesterday:function(){return s.getRange(-1,"DAY")},today:function(){return s.getRange(0,"DAY")},tomorrow:function(){return s.getRange(1,"DAY")},nextMinutes:function(e){return s.getRange(e,"MINUTE")},nextHours:function(e){return s.getRange(e,"HOUR")},nextDays:function(e){return s.getRange(e,"DAY")},lastWeeks:function(e,t){var r;if(t){r=s._getDateFromWeekStartByDayOffset(t);return s.getRange(-e,"WEEK",r,false)}return s.getRange(-e,"WEEK")},lastWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(-1,"WEEK",t,false)}return s.getRange(-1,"WEEK")},currentWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(0,"WEEK",t,false)}return s.getRange(0,"WEEK")},firstDayOfWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return[s.resetStartTime(t),s.resetEndTime(t)]}var r=s.getWeekStartDate();return[r,s.resetEndTime(r)]},lastDayOfWeek:function(e){var t,r;if(e){r=6;t=s._getDateFromWeekStartByDayOffset(e,r);return[t,s.resetEndTime(t)]}var a=s.getWeekLastDate();return[a,s.resetEndTime(a)]},nextWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(1,"WEEK",t,false)}return s.getRange(1,"WEEK")},nextWeeks:function(e,t){var r;if(t){r=s._getDateFromWeekStartByDayOffset(t);return s.getRange(e,"WEEK",r,false)}return s.getRange(e,"WEEK")},lastMonths:function(e){return s.getRange(-e,"MONTH")},lastMonth:function(){return s.getRange(-1,"MONTH")},currentMonth:function(){return s.getRange(0,"MONTH")},firstDayOfMonth:function(){var e=s.getMonthStartDate();return[e,s.resetEndTime(e)]},lastDayOfMonth:function(){var e=s.getMonthEndDate();return[e,s.resetEndTime(e)]},nextMonth:function(){return s.getRange(1,"MONTH")},nextMonths:function(e){return s.getRange(e,"MONTH")},lastQuarters:function(e){return s.getRange(-e,"QUARTER")},lastQuarter:function(){return s.getRange(-1,"QUARTER")},firstDayOfQuarter:function(){var e=s.getQuarterStartDate();return[e,s.resetEndTime(e)]},lastDayOfQuarter:function(){var e=s.getQuarterEndDate();return[e,s.resetEndTime(e)]},currentQuarter:function(){return s.getRange(0,"QUARTER")},nextQuarter:function(){return s.getRange(1,"QUARTER")},nextQuarters:function(e){return s.getRange(e,"QUARTER")},quarter:function(e){if(e<=2){return s.getRange(e-1,"QUARTER",s.getYearStartDate())}else{var t=s.getRange(e-2,"QUARTER",s.getYearStartDate());var r=t[1];r.setMilliseconds(1e3);return s.getRange(0,"QUARTER",r)}},lastYears:function(e){return s.getRange(-e,"YEAR")},lastYear:function(){return s.getRange(-1,"YEAR")},firstDayOfYear:function(){var e=s.getYearStartDate();return[e,s.resetEndTime(e)]},lastDayOfYear:function(){var e=s.getYearEndDate();return[e,s.resetEndTime(e)]},currentYear:function(){return s.getRange(0,"YEAR")},nextYear:function(){return s.getRange(1,"YEAR")},nextYears:function(e){return s.getRange(e,"YEAR")},yearToDate:function(){var e=s.createNewUniversalDate();return[s.getYearStartDate(e),s.resetEndTime(e)]},dateToYear:function(){var e=s.createNewUniversalDate();return[s.resetStartTime(e),s.resetEndTime(s.getYearEndDate(e))]}};return s});
//# sourceMappingURL=UniversalDateUtils.js.map