/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/Supportability","sap/base/Log","sap/base/assert","sap/base/util/extend","sap/ui/core/Configuration"],function(e,r,t,i,n,a,o,s){"use strict";var u=e.extend("sap.ui.core.format.NumberFormat",{constructor:function(e){throw new Error}});var c=/\s/g,l=/\d/,g=/^(-?)0+(\d)/,f=/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6\u0020\xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000]/,m=/0+(\.0+)?/,p=/^0+$/;var d=function(e,r,t){var i=E(e);return new RegExp("^\\d+"+"(?:"+i+"?"+"\\d{"+r+"}"+")*"+""+i+"?"+"\\d{"+t+"}"+"$")};var h={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var C={FLOOR:"FLOOR",CEILING:"CEILING",TOWARDS_ZERO:"TOWARDS_ZERO",AWAY_FROM_ZERO:"AWAY_FROM_ZERO",HALF_FLOOR:"HALF_FLOOR",HALF_CEILING:"HALF_CEILING",HALF_TOWARDS_ZERO:"HALF_TOWARDS_ZERO",HALF_AWAY_FROM_ZERO:"HALF_AWAY_FROM_ZERO"};var y={};y[C.FLOOR]=Math.floor;y[C.CEILING]=Math.ceil;y[C.TOWARDS_ZERO]=function(e){return e>0?Math.floor(e):Math.ceil(e)};y[C.AWAY_FROM_ZERO]=function(e){return e>0?Math.ceil(e):Math.floor(e)};y[C.HALF_TOWARDS_ZERO]=function(e){return e>0?Math.ceil(e-.5):Math.floor(e+.5)};y[C.HALF_AWAY_FROM_ZERO]=function(e){return e>0?Math.floor(e+.5):Math.ceil(e-.5)};y[C.HALF_FLOOR]=function(e){return Math.ceil(e-.5)};y[C.HALF_CEILING]=Math.round;u.RoundingMode=C;u.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,strictGroupingValidation:false,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:h.INTEGER,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};u.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:h.FLOAT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};u.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:h.PERCENT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};u.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:h.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:"standard",style:"standard",showNumber:true,customCurrencies:undefined,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};u.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:h.UNIT,showMeasure:true,style:"standard",showNumber:true,customUnits:undefined,allowedUnits:undefined,parseAsString:false,preserveDecimals:false,roundingMode:u.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};u.getInstance=function(e,r){return this.getFloatInstance(e,r)};u.getFloatInstance=function(e,r){var t=this.createInstance(e,r),i=this.getLocaleFormatOptions(t.oLocaleData,h.FLOAT);t.oFormatOptions=o({},this.oDefaultFloatFormat,i,t.oOriginalFormatOptions);return t};u.getIntegerInstance=function(e,r){var t=this.createInstance(e,r),i=this.getLocaleFormatOptions(t.oLocaleData,h.INTEGER);t.oFormatOptions=o({},this.oDefaultIntegerFormat,i,t.oOriginalFormatOptions);return t};u.getCurrencyInstance=function(e,r){var t=this.createInstance(e,r);var i=t.oOriginalFormatOptions&&t.oOriginalFormatOptions.currencyContext;var n=O(t.oOriginalFormatOptions);if(n){i=i||this.oDefaultCurrencyFormat.style;i="sap-"+i}var a=this.getLocaleFormatOptions(t.oLocaleData,h.CURRENCY,i);t.oFormatOptions=o({},this.oDefaultCurrencyFormat,a,t.oOriginalFormatOptions);t.oFormatOptions.trailingCurrencyCode=n;t._defineCustomCurrencySymbols();return t};u.getUnitInstance=function(e,r){var t=this.createInstance(e,r),i=this.getLocaleFormatOptions(t.oLocaleData,h.UNIT);t.oFormatOptions=o({},this.oDefaultUnitFormat,i,t.oOriginalFormatOptions);return t};u.getPercentInstance=function(e,r){var t=this.createInstance(e,r),i=this.getLocaleFormatOptions(t.oLocaleData,h.PERCENT);t.oFormatOptions=o({},this.oDefaultPercentFormat,i,t.oOriginalFormatOptions);return t};u.createInstance=function(e,i){var n=Object.create(this.prototype),o;if(e instanceof r){i=e;e=undefined}if(!i){i=s.getFormatSettings().getFormatLocale()}n.oLocale=i;n.oLocaleData=t.getInstance(i);n.oOriginalFormatOptions=e;if(e){if(e.pattern){o=this.parseNumberPattern(e.pattern);Object.keys(o).forEach(function(r){e[r]=o[r]})}if(e.emptyString!==undefined){a(e.emptyString===""||e.emptyString===0||e.emptyString===null||e.emptyString!==e.emptyString,"The format option 'emptyString' must be either '', 0, null, or NaN")}}return n};u.getDefaultUnitPattern=function(e){return"{0} "+e};u.getLocaleFormatOptions=function(e,r,t){var i,n;switch(r){case h.PERCENT:n=e.getPercentPattern();break;case h.CURRENCY:n=e.getCurrencyPattern(t);break;case h.UNIT:n=e.getDecimalPattern();break;default:n=e.getDecimalPattern()}i=this.parseNumberPattern(n);i.plusSign=e.getNumberSymbol("plusSign");i.minusSign=e.getNumberSymbol("minusSign");i.decimalSeparator=e.getNumberSymbol("decimal");i.groupingSeparator=e.getNumberSymbol("group");i.percentSign=e.getNumberSymbol("percentSign");i.pattern=n;switch(r){case h.UNIT:case h.FLOAT:case h.PERCENT:i.minFractionDigits=0;i.maxFractionDigits=99;break;case h.INTEGER:i.minFractionDigits=0;i.maxFractionDigits=0;i.groupingEnabled=false;break;case h.CURRENCY:i.minFractionDigits=undefined;i.maxFractionDigits=undefined;break}return i};u.parseNumberPattern=function(e){var r=0,t=0,i=0,n=false,a=0,o=0,s=e.indexOf(";"),u={Integer:0,Fraction:1},c=u.Integer;if(s!==-1){e=e.substring(0,s)}for(var l=0;l<e.length;l++){var g=e[l];switch(g){case",":if(n){a=o;o=0}n=true;break;case".":c=u.Fraction;break;case"0":if(c===u.Integer){r++;if(n){o++}}else{t++;i++}break;case"#":if(c===u.Integer){if(n){o++}}else{i++}break}}if(!a){a=o;o=0}return{minIntegerDigits:r,minFractionDigits:t,maxFractionDigits:i,groupingEnabled:n,groupingSize:a,groupingBaseSize:o}};u.prototype._defineCustomCurrencySymbols=function(){var e=this.oFormatOptions;var r=this.oLocaleData.getCurrencySymbols();var t=function(e,r){var t=[];var i;for(var a in e){i=e[a];if(t.indexOf(i)===-1){t.push(i)}else if(i!==undefined){r[i]=true;n.error("Symbol '"+i+"' is defined multiple times in custom currencies.",undefined,"NumberFormat")}}};if(e.customCurrencies&&typeof e.customCurrencies==="object"){this.mKnownCurrencySymbols={};this.mKnownCurrencyCodes={};Object.keys(e.customCurrencies).forEach(function(t){if(e.customCurrencies[t].symbol){this.mKnownCurrencySymbols[t]=e.customCurrencies[t].symbol}else{var i=e.customCurrencies[t].isoCode;if(i){this.mKnownCurrencySymbols[t]=r[i]}}this.mKnownCurrencyCodes[t]=t}.bind(this))}else{this.mKnownCurrencySymbols=r;this.mKnownCurrencyCodes=this.oLocaleData.getCustomCurrencyCodes()}this.mDuplicatedSymbols={};t(this.mKnownCurrencySymbols,this.mDuplicatedSymbols)};function S(e,r){if(e.indexOf(".")>=0&&!v(e)&&e.endsWith("0")){var t=e.length-e.lastIndexOf(".")-1;var i=t-r;if(i>0){while(e.endsWith("0")&&i-- >0){e=e.substring(0,e.length-1)}if(e.endsWith(".")){e=e.substring(0,e.length-1)}}}return e}function b(e,r){var t=r.groupingSize,i=r.groupingBaseSize||t,n=e.length,a=Math.max(n-i,0)%t||t,o=e.slice(0,a);while(n-a>=i){o+=r.groupingSeparator;o+=e.slice(a,a+t);a+=t}o+=e.slice(a,n);return o}u.prototype.format=function(e,r){if(Array.isArray(e)){r=e[1];e=e[0]}var i="",a="",o="",s="",c="",l="",g=e<0,f=-1,m=Object.assign({},this.oFormatOptions),p=this.oOriginalFormatOptions,d=m.type===h.CURRENCY&&r==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",C,y,D,O,v,N,E=e===undefined||e===null;if(m.groupingEnabled&&m.groupingSize<=0){n.error("Grouping requires the 'groupingSize' format option to be a positive number, but it is '"+m.groupingSize+"' instead.");return""}if(m.showNumber&&(e===m.emptyString||isNaN(e)&&isNaN(m.emptyString))){return""}if(r!==undefined&&r!==null&&typeof r!=="string"&&!(r instanceof String)){return""}if(!m.showNumber&&!r){return""}if(E&&(!r||!m.showMeasure||m.showNumber)){return""}if(r&&m.customCurrencies&&!m.customCurrencies[r]){n.error("Currency '"+r+"' is unknown.");return""}if(!m.showNumber&&!m.showMeasure){return""}if(r&&m.type===h.UNIT){if(m.customUnits&&typeof m.customUnits==="object"){v=m.customUnits[r]}else{N=this.oLocaleData.getUnitFromMapping(r)||r;v=this.oLocaleData.getUnitFormat(N)}if(m.showMeasure){var A=!m.allowedUnits||m.allowedUnits.indexOf(r)>=0;if(!A){return""}}if(!v&&!m.showNumber){return this._addOriginInfo(r)}m.decimals=v&&(typeof v.decimals==="number"&&v.decimals>=0)?v.decimals:m.decimals;m.precision=v&&(typeof v.precision==="number"&&v.precision>=0)?v.precision:m.precision}if(m.type==h.CURRENCY){if(r&&m.trailingCurrencyCode){if(!this.mKnownCurrencyCodes[r]&&!/(^[A-Z]{3}$)/.test(r)){m.trailingCurrencyCode=false;m.pattern=this.oLocaleData.getCurrencyPattern(m.currencyContext)}}if(!m.showNumber){if(!m.currencyCode){var w;if(m.customCurrencies&&typeof m.customCurrencies==="object"){w=this.mKnownCurrencySymbols[r]}else{w=this.oLocaleData.getCurrencySymbol(r)}if(w&&w!==r){r=w}}return r}if(m.customCurrencies&&m.customCurrencies[r]){m.decimals=m.customCurrencies[r].decimals!==undefined?m.customCurrencies[r].decimals:m.decimals}}if(m.decimals!==undefined){m.minFractionDigits=m.decimals;m.maxFractionDigits=m.decimals}if(m.shortLimit===undefined||Math.abs(e)>=m.shortLimit){D=m.shortRefNumber===undefined?e:m.shortRefNumber;y=F(D,m,this.oLocaleData,d);if(y&&y.formatString!="0"){e=e/y.magnitude;if(m.shortDecimals!==undefined){m.minFractionDigits=m.shortDecimals;m.maxFractionDigits=m.shortDecimals}else{if(p.minFractionDigits===undefined&&p.maxFractionDigits===undefined&&p.decimals===undefined&&p.precision===undefined&&p.pattern===undefined){m.precision=2;m.minFractionDigits=0;m.maxFractionDigits=99}if(p.maxFractionDigits===undefined&&p.decimals===undefined){m.maxFractionDigits=99}}m.roundingMode=u.RoundingMode.HALF_AWAY_FROM_ZERO}}if((y||!m.ignorePrecision)&&m.precision!==undefined){m.maxFractionDigits=Math.min(m.maxFractionDigits,I(e,m.precision));m.minFractionDigits=Math.min(m.minFractionDigits,m.maxFractionDigits)}if(m.type==h.PERCENT){e=u._shiftDecimalPoint(e,2)}if(m.type==h.CURRENCY){var _=this.oLocaleData.getCurrencyDigits(r);if(m.customCurrencies&&m.customCurrencies[r]&&m.customCurrencies[r].decimals!==undefined){_=m.customCurrencies[r].decimals}if(m.maxFractionDigits===undefined){m.maxFractionDigits=_}if(m.minFractionDigits===undefined){m.minFractionDigits=_}}if(typeof e==="number"&&!m.preserveDecimals){e=R(e,m.maxFractionDigits,m.roundingMode)}if(e==0){g=false}if(m.preserveDecimals&&(typeof e==="string"||e instanceof String)){e=S(e,m.maxFractionDigits)}if(!E){c=t.convertToDecimal(e)}if(c=="NaN"){return c}if(g){c=c.substr(1)}f=c.indexOf(".");if(f>-1){i=c.substr(0,f);a=c.substr(f+1)}else{i=c}if(i.length<m.minIntegerDigits){i=i.padStart(m.minIntegerDigits,"0")}else if(i.length>m.maxIntegerDigits){i="".padStart(m.maxIntegerDigits,"?")}if(a.length<m.minFractionDigits){a=a.padEnd(m.minFractionDigits,"0")}else if(a.length>m.maxFractionDigits&&!m.preserveDecimals){a=a.substr(0,m.maxFractionDigits)}if(m.type===h.UNIT&&!m.showNumber){if(v){O=this._getPluralCategory(i,a,y);l=v["unitPattern-count-"+O];if(!l){l=v["unitPattern-count-other"]}if(!l){return this._addOriginInfo(r)}if(O!=="other"&&l.indexOf("{0}")===-1){l=v["unitPattern-count-other"];if(!l){return this._addOriginInfo(r)}}if(l.indexOf("{0}")===-1){n.warning("Cannot separate the number from the unit because unitPattern-count-other '"+l+"' does not include the number placeholder '{0}' for unit '"+r+"'")}else{return this._addOriginInfo(l.replace("{0}","").trim())}}}if(m.groupingEnabled){o=b(i,m)}else{o=i}if(g){s=m.minusSign}s+=o;if(a){s+=m.decimalSeparator+a}if(y&&y.formatString&&m.showScale&&m.type!==h.CURRENCY){O=this._getPluralCategory(i,a);y.formatString=this.oLocaleData.getDecimalFormat(m.style,y.key,O);s=y.formatString.replace(y.valueSubString,s);s=s.replace(/'.'/g,".")}if(m.type===h.CURRENCY){l=m.pattern;if(y&&y.formatString&&m.showScale){var M;if(m.trailingCurrencyCode){M="sap-short"}else{M="short"}O=this._getPluralCategory(i,a);if(d){l=L(M,y.key,O)}else{l=this.oLocaleData.getCurrencyFormat(M,y.key,O)}l=l.replace(/'.'/g,".")}C=l.split(";");if(C.length===2){l=g?C[1]:C[0];if(g){s=s.substring(m.minusSign.length)}}if(!m.currencyCode){var w;if(m.customCurrencies&&typeof m.customCurrencies==="object"){w=this.mKnownCurrencySymbols[r]}else{w=this.oLocaleData.getCurrencySymbol(r)}if(w&&w!==r){r=w}}s=this._composeCurrencyResult(l,s,r,{showMeasure:m.showMeasure,negative:g,minusSign:m.minusSign})}if(m.type===h.PERCENT){l=m.pattern;s=l.replace(/[0#.,]+/,s);s=s.replace(/%/,m.percentSign)}if(m.showMeasure&&r&&m.type===h.UNIT){O=this._getPluralCategory(i,a,y);if(v){l=v["unitPattern-count-"+O];if(!l){l=v["unitPattern-count-other"]}if(!l){l=u.getDefaultUnitPattern(r)}}else{l=u.getDefaultUnitPattern(r)}s=l.replace("{0}",s)}return this._addOriginInfo(s)};u.prototype._getPluralCategory=function(e,r,t){var i=e;if(r){i+="."+r}if(t){i+="c"+t.magnitude.toExponential().slice(2)}return this.oLocaleData.getPluralCategory(i)};u.prototype._addOriginInfo=function(e){if(i.collectOriginInfo()){e=new String(e);e.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()}}return e};u.prototype._composeCurrencyResult=function(e,r,t,i){var n=i.minusSign;e=e.replace(/[0#.,]+/,r);if(i.showMeasure&&t){var a="¤",o={"[:digit:]":l,"[[:^S:]&[:^Z:]]":f},s=e.indexOf(a),u=s<e.length/2?"after":"before",c=this.oLocaleData.getCurrencySpacing(u),g=u==="after"?t.charAt(t.length-1):t.charAt(0),m,p=o[c.currencyMatch],d=o[c.surroundingMatch],h;e=e.replace(a,t);m=u==="after"?e.charAt(s+t.length):e.charAt(s-1);if(p&&p.test(g)&&d&&d.test(m)){if(u==="after"){h=s+t.length}else{h=s}e=e.slice(0,h)+c.insertBetween+e.slice(h)}else if(i.negative&&u==="after"){n="\ufeff"+i.minusSign}}else{e=e.replace(/\s*\u00a4\s*/,"")}if(i.negative){e=e.replace(/-/,n)}return e};u.prototype.parse=function(e){var r=this.oFormatOptions,t=r.plusSign+this.oLocaleData.getLenientNumberSymbols("plusSign"),i=r.minusSign+this.oLocaleData.getLenientNumberSymbols("minusSign"),o=E(t+i),s=E(r.groupingSeparator),l=E(r.decimalSeparator),g="^\\s*(["+o+"]?(?:[0-9"+s+"]+|[0-9"+s+"]*"+l+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",f="^\\s*(["+o+"]?[0-9"+s+"]+)\\s*$",m=new RegExp(s,"g"),p=new RegExp(l,"g"),d=this.oLocaleData.getNumberSymbol("percentSign"),C=r.type===h.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",y,S,b,F,O=0,L,R;if(e===""){if(!r.showNumber){return null}R=r.emptyString;if(r.parseAsString&&(r.emptyString===0||isNaN(r.emptyString))){R=r.emptyString+""}if(r.type===h.CURRENCY||r.type===h.UNIT){return[R,undefined]}else{return R}}if(typeof e!=="string"&&!(e instanceof String)){return null}if(r.groupingSeparator===r.decimalSeparator){n.error("The grouping and decimal separator both have the same value '"+r.groupingSeparator+"'. "+"They must be different from each other such that values can be parsed correctly.")}F=r.type===h.PERCENT?r.pattern:this.oLocaleData.getPercentPattern();if(F.charAt(0)==="%"){g=g.slice(0,1)+"%?"+g.slice(1)}else if(F.charAt(F.length-1)==="%"){g=g.slice(0,g.length-1)+"%?"+g.slice(g.length-1)}var I;if(r.type===h.UNIT&&r.showMeasure){var w;if(r.customUnits&&typeof r.customUnits==="object"){w=r.customUnits}else{w=this.oLocaleData.getUnitFormats()}a(w,"Unit patterns cannot be loaded");if(r.allowedUnits){var M={};for(var x=0;x<r.allowedUnits.length;x++){var U=r.allowedUnits[x];M[U]=w[U]}w=M}var P=A(w,e,r.showNumber,this.oLocaleData.sCLDRLocaleId);var T=false;I=P.cldrCode;if(I.length===1){b=I[0];if(!r.showNumber){return[undefined,b]}}else if(I.length===0){if(r.unitOptional){P.numberValue=e}else{return null}}else{a(I.length===1,"Ambiguous unit ["+I.join(", ")+"] for input: '"+e+"'");b=undefined;T=true}if(r.strictParsing){if(T){return null}}e=P.numberValue||e}var k;if(r.type===h.CURRENCY&&r.showMeasure){k=_({value:e,currencySymbols:this.mKnownCurrencySymbols,customCurrencyCodes:this.mKnownCurrencyCodes,duplicatedSymbols:this.mDuplicatedSymbols,customCurrenciesAvailable:!!r.customCurrencies});if(!k){return null}if(r.strictParsing){if(!k.currencyCode||k.duplicatedSymbolFound){return null}}e=k.numberValue;b=k.currencyCode;if(r.customCurrencies&&b===null){return null}if(!r.showNumber){if(e){return null}return[undefined,b]}}e=e.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");e=e.replace(c,"");L=D(e,this.oLocaleData,C);if(L){e=L.number}var W=v(e);if(r.isInteger&&!L&&!W){y=new RegExp(f)}else{y=new RegExp(g)}if(!y.test(e)){return r.type===h.CURRENCY||r.type===h.UNIT?null:NaN}var Y=e.length;for(var z=0;z<Y;z++){var Z=e[z];if(t.includes(Z)){e=e.replace(Z,"+");break}else if(i.includes(Z)){e=e.replace(Z,"-");break}}e=e.replace(/^\+/,"");if(!r.isInteger&&e.indexOf(d)!==-1){S=true;e=e.replace(d,"")}var G=e;e=e.replace(m,"");if(L){e=e.replace(p,".");e=u._shiftDecimalPoint(e,Math.round(Math.log(L.factor)/Math.LN10))}if(r.isInteger){var H;if(W){e=e.replace(p,".");H=N(e);if(H===undefined){return NaN}}else{H=parseInt(e)}O=r.parseAsString?e:H}else{e=e.replace(p,".");O=r.parseAsString?e:parseFloat(e);if(S){O=u._shiftDecimalPoint(O,-2)}}var V=this._checkGrouping(G,r,W);if(!V){return r.type===h.CURRENCY||r.type===h.UNIT?null:NaN}if(r.parseAsString&&!S){O=u._shiftDecimalPoint(e,0)}if(r.type===h.CURRENCY||r.type===h.UNIT){return[O,b]}return O};u.prototype.getScale=function(){if(this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long"||this.oFormatOptions.shortRefNumber===undefined){return}var e=F(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),r;if(e&&e.formatString){r=e.formatString.replace(m,"").replace(/'.'/g,".").trim();if(r){return r}}};u._shiftDecimalPoint=function(e,r){if(typeof r!=="number"){return NaN}var t="";var i=e.toString().toLowerCase().split("e");if(typeof e==="number"){r=i[1]?+i[1]+r:r;return+(i[0]+"e"+r)}else if(typeof e==="string"){if(parseFloat(e)===0&&r>=0){return e.replace(g,"$1$2")}var n=i[0].charAt(0);t=n==="-"?n:"";if(t){i[0]=i[0].slice(1)}e=i[0];var a=e.indexOf("."),o,s,u;if(a===-1){e=e+".";a=e.length-1}if(i[1]){a+=+i[1]}o=a+r;if(o<=0){e=e.padStart(e.length-o+1,"0");o=1}else if(o>=e.length-1){e=e.padEnd(o+1,"0");o=e.length-1}e=e.replace(".","");s=e.substring(0,o);u=e.substring(o);s=s.replace(g,"$1$2");return t+s+(u?"."+u:"")}else{return null}};function F(e,r,t,i){var n,a,o,s,u=r.style,c=r.precision!==undefined?r.precision:2;if(u!="short"&&u!="long"){return undefined}for(var l=0;l<15;l++){a=Math.pow(10,l);if(R(Math.abs(e)/a,c-1)<10){break}}o=a.toString();if(r.type===h.CURRENCY){if(r.trailingCurrencyCode){u="sap-short"}if(i){s=L(u,o,"other",true)}else{s=t.getCurrencyFormat(u,o,"other")}}else{s=t.getDecimalFormat(u,o,"other")}if(!s||s=="0"){return undefined}else{n={};n.key=o;n.formatString=s;var g=s.match(m);if(g){n.valueSubString=g[0];var f=n.valueSubString.indexOf(".");if(f==-1){n.decimals=0;n.magnitude=a*Math.pow(10,1-n.valueSubString.length)}else{n.decimals=n.valueSubString.length-f-1;n.magnitude=a*Math.pow(10,1-f)}}else{return undefined}}return n}function D(e,r,t){var i,n=1,a=10,o=r.getPluralCategories(),s,u={number:undefined,factor:n},c=function(t,a,o,c){if(c){s=L(o,a.toString(),t,true)}else{s=r.getDecimalFormat(o,a.toString(),t)}if(s){s=s.replace(/[\s\u00a0\u200F]/g,"");s=s.replace(/'.'/g,".");var l=s.match(m);if(l){var g=l[0];var f=s.replace(g,"");if(!f){return}var p=e.indexOf(f);if(p>=0){i=e.replace(f,"");i=i.replace(/\u200F/g,"");n=a;n*=Math.pow(10,1-g.length);if(u.number===undefined||i.length<u.number.length){u.number=i;u.factor=n}}}}};["long","short"].forEach(function(e){a=10;while(a<1e15){for(var r=0;r<o.length;r++){var t=o[r];c(t,a,e)}a=a*10}});if(t&&!i){a=10;while(a<1e15){for(var l=0;l<o.length;l++){var g=o[l];c(g,a,"short",true)}a=a*10}}if(!i){return}return u}function O(e){var r=s.getFormatSettings().getTrailingCurrencyCode();if(e){if(e.trailingCurrencyCode!==undefined){r=e.trailingCurrencyCode}if(e.pattern){r=false}if(e.currencyCode===false){r=false}}return r}function L(e,r,t,i){var n,a={short:{"1000-one":"¤0000","1000-other":"¤0000","10000-one":"¤00000","10000-other":"¤00000","100000-one":"¤0 Lk","100000-other":"¤0 Lk","1000000-one":"¤00 Lk","1000000-other":"¤00 Lk","10000000-one":"¤0 Cr","10000000-other":"¤0 Cr","100000000-one":"¤00 Cr","100000000-other":"¤00 Cr","1000000000-one":"¤000 Cr","1000000000-other":"¤000 Cr","10000000000-one":"¤0000 Cr","10000000000-other":"¤0000 Cr","100000000000-one":"¤00000 Cr","100000000000-other":"¤00000 Cr","1000000000000-one":"¤0 Lk Cr","1000000000000-other":"¤0 Lk Cr","10000000000000-one":"¤00 Lk Cr","10000000000000-other":"¤00 Lk Cr","100000000000000-one":"¤0 Cr Cr","100000000000000-other":"¤0 Cr Cr"},"sap-short":{"1000-one":"0000 ¤","1000-other":"0000 ¤","10000-one":"00000 ¤","10000-other":"00000 ¤","100000-one":"0 Lk ¤","100000-other":"0 Lk ¤","1000000-one":"00 Lk ¤","1000000-other":"00 Lk ¤","10000000-one":"0 Cr ¤","10000000-other":"0 Cr ¤","100000000-one":"00 Cr ¤","100000000-other":"00 Cr ¤","1000000000-one":"000 Cr ¤","1000000000-other":"000 Cr ¤","10000000000-one":"0000 Cr ¤","10000000000-other":"0000 Cr ¤","100000000000-one":"00000 Cr ¤","100000000000-other":"00000 Cr ¤","1000000000000-one":"0 Lk Cr ¤","1000000000000-other":"0 Lk Cr ¤","10000000000000-one":"00 Lk Cr ¤","10000000000000-other":"00 Lk Cr ¤","100000000000000-one":"0 Cr Cr ¤","100000000000000-other":"0 Cr Cr ¤"}},o={short:{"1000-one":"0000","1000-other":"0000","10000-one":"00000","10000-other":"00000","100000-one":"0 Lk","100000-other":"0 Lk","1000000-one":"00 Lk","1000000-other":"00 Lk","10000000-one":"0 Cr","10000000-other":"0 Cr","100000000-one":"00 Cr","100000000-other":"00 Cr","1000000000-one":"000 Cr","1000000000-other":"000 Cr","10000000000-one":"0000 Cr","10000000000-other":"0000 Cr","100000000000-one":"00000 Cr","100000000000-other":"00000 Cr","1000000000000-one":"0 Lk Cr","1000000000000-other":"0 Lk Cr","10000000000000-one":"00 Lk Cr","10000000000000-other":"00 Lk Cr","100000000000000-one":"0 Cr Cr","100000000000000-other":"0 Cr Cr"}};o["sap-short"]=o["short"];var s=i?o:a;var u=s[e];if(!u){u=s["short"]}if(t!=="one"){t="other"}n=u[r+"-"+t];return n}u.prototype._checkGrouping=function(e,r,t){if(r.groupingSeparator&&e.includes(r.groupingSeparator)){e=e.replace(/^-/,"");e=e.replace(/^0+(\d)/,"$1");if(e.startsWith("0")||e.startsWith(r.groupingSeparator)){return false}if(t){e=e.replace(/[eE].*/,"")}var i=e.includes(r.decimalSeparator);if(r.decimalSeparator===r.groupingSeparator){i=false}else if(i){e=e.split(r.decimalSeparator)[0]}var n=e.split(r.groupingSeparator).length===2;if(n&&!i){var a=e.length-e.lastIndexOf(r.groupingSeparator);var o=r.groupingBaseSize||r.groupingSize;if(a!==o+r.groupingSeparator.length){return false}}if(r.strictGroupingValidation){if(!this._rGrouping){this._rGrouping=d(r.groupingSeparator,r.groupingSize,r.groupingBaseSize||r.groupingSize)}if(!this._rGrouping.test(e)){return false}}}return true};function v(e){return e.indexOf("e")>0||e.indexOf("E")>0}function N(e){var r=u._shiftDecimalPoint(e,0);if(r.indexOf(".")>0&&!p.test(r.split(".")[1])){return undefined}var t=parseFloat(r);var i=""+t;if(v(i)){i=u._shiftDecimalPoint(i,0)}var n=parseInt(i);if(n!==t){return undefined}return n}function R(e,r,t){if(typeof e!=="number"){return NaN}t=t||u.RoundingMode.HALF_AWAY_FROM_ZERO;r=parseInt(r);var i=""+e;if(!v(i)){var n=i.indexOf(".");if(n<0){return e}if(i.substring(n+1).length<=r){return e}}if(typeof t==="function"){e=t(e,r)}else{if(t.match(/^[a-z_]+$/)){t=t.toUpperCase()}if(!r){return y[t](e)}e=u._shiftDecimalPoint(y[t](u._shiftDecimalPoint(e,r)),-r)}return e}function E(e){return e.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1")}function I(e,r){var t=Math.floor(Math.log(Math.abs(e))/Math.LN10);return Math.max(0,r-t-1)}function A(e,r,t,i){var n,a,o,s,u,c,l,g,f,m,p,d={numberValue:undefined,cldrCode:[]},h=[],C=true,y=true,S=Number.POSITIVE_INFINITY,b=true,F=r.toLocaleLowerCase(i);for(f in e){for(a in e[f]){if(!a.startsWith("unitPattern")){continue}m=e[f][a];s=m.indexOf("{0}");n=s>-1;if(n&&!t){m=m.replace("{0}","").trim();n=false}o=undefined;C=true;if(n){l=m.substring(0,s);g=l.toLocaleLowerCase(i);u=m.substring(s+"{0}".length);c=u.toLocaleLowerCase(i);if(r.startsWith(l)&&r.endsWith(u)){o=r.substring(l.length,r.length-u.length)}else if(F.startsWith(g)&&F.endsWith(c)){C=false;o=r.substring(g.length,F.length-c.length)}if(o){if(o.length<S){S=o.length;b=C;d.numberValue=o;d.cldrCode=[f]}else if(o.length===S&&d.cldrCode.indexOf(f)===-1){if(C&&!b){d.numberValue=o;d.cldrCode=[f];b=true}else if(C||!b){d.cldrCode.push(f)}}}}else{p=m.toLocaleLowerCase(i);if(m===r||p===F){if(t){if(a.endsWith("-zero")){o="0"}else if(a.endsWith("-one")){o="1"}else if(a.endsWith("-two")){o="2"}if(m===r){d.numberValue=o;d.cldrCode=[f];return d}else if(!d.cldrCode.includes(f)){y=false;d.numberValue=o;d.cldrCode.push(f)}}else if(d.cldrCode.indexOf(f)===-1){if(m===r){d.cldrCode.push(f)}else if(!h.includes(f)){h.push(f)}}}}}}if((!b||!y)&&d.cldrCode.length>1){d.numberValue=undefined}if(!t&&!d.cldrCode.length){d.cldrCode=h}return d}function w(e,r,t){var i,n,a,o,u,l,g,f,m=false,p=false,d="";for(n in r){a=r[n];if(!a){continue}a=a.replace(c," ");if(e.indexOf(a)>=0&&d.length<=a.length){i=n;m=false;p=true;d=a;g=a}else if(t){l=s.getLanguageTag();o=a.toLocaleUpperCase(l);u=e.toLocaleUpperCase(l).indexOf(o);if(u>=0){if(d.length===a.length&&!p){m=true}else if(d.length<a.length){f=e.substring(u,u+a.length);if(f.toLocaleUpperCase(l)===o){i=n;m=false;p=false;d=a;g=f}}}}}if(m||!i){return{}}return{code:i,recognizedCurrency:g,symbol:d}}function _(e){var r,t=e.value.replace(c," ");var i=w(t,e.currencySymbols);if(!i.code){i=w(t,e.customCurrencyCodes,true);if(!i.code&&!e.customCurrenciesAvailable){r=t.match(/(^[A-Z]{3}|[A-Z]{3}$)/i);i.code=r&&r[0].toLocaleUpperCase(s.getLanguageTag());i.recognizedCurrency=r&&r[0]}}if(i.code){var a=i.recognizedCurrency.length-1;var o=i.recognizedCurrency.charAt(a);var u;var l=/[\-\s]+/;if(/\d$/.test(o)){if(t.startsWith(i.recognizedCurrency)){u=a+1;if(!l.test(t.charAt(u))){return undefined}}}else if(/^\d/.test(i.recognizedCurrency)){if(t.endsWith(i.recognizedCurrency)){u=t.indexOf(i.recognizedCurrency)-1;if(!l.test(t.charAt(u))){return undefined}}}t=t.replace(i.recognizedCurrency,"")}var g=false;if(e.duplicatedSymbols&&e.duplicatedSymbols[i.symbol]){i.code=undefined;g=true;n.error("The parsed currency symbol '"+i.symbol+"' is defined multiple "+"times in custom currencies.Therefore the result is not distinct.")}return{numberValue:t,currencyCode:i.code||undefined,duplicatedSymbolFound:g}}return u});
//# sourceMappingURL=NumberFormat.js.map