/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./MessageType","sap/base/Log","sap/base/util/uid","sap/ui/base/Object"],function(t,e,s,r){"use strict";const i={[t.Error]:0,[t.Warning]:1,[t.Success]:2,[t.Information]:3,[t.None]:4};var o=r.extend("sap.ui.core.message.Message",{constructor:function(e){r.apply(this,arguments);e=e||{};this.id=e.id?e.id:s();this.message=e.message;this.description=e.description;this.descriptionUrl=e.descriptionUrl;this.additionalText=e.additionalText;this.setType(e.type||t.None);this.code=e.code;this.aTargets=[];if(e.target!==undefined){this.aTargets=Array.isArray(e.target)?e.target.slice():[e.target]}Object.defineProperty(this,"target",{get:this.getTarget,set:this.setTarget,enumerable:true});this.processor=e.processor;this.persistent=e.persistent||false;this.technical=e.technical||false;this.technicalDetails=e.technicalDetails;this.references=e.references||{};this.validation=!!e.validation;this.date=e.date||Date.now();this.controlIds=[];if(Array.isArray(e.fullTarget)){this.aFullTargets=e.fullTarget.length?e.fullTarget.slice():[""]}else{this.aFullTargets=[e.fullTarget||""]}Object.defineProperty(this,"fullTarget",{get:function(){return this.aFullTargets[0]},set:function(t){this.aFullTargets[0]=t},enumerable:true})}});o.prototype.getId=function(){return this.id};o.prototype.setMessage=function(t){this.message=t};o.prototype.getMessage=function(){return this.message};o.prototype.getControlId=function(){return this.controlIds[this.controlIds.length-1]};o.prototype.addControlId=function(t){if(this.controlIds.indexOf(t)==-1){this.controlIds=this.controlIds.slice();this.controlIds.push(t)}};o.prototype.removeControlId=function(t){var e=this.controlIds.indexOf(t);if(e!=-1){this.controlIds=this.controlIds.slice();this.controlIds.splice(e,1)}};o.prototype.getControlIds=function(){return this.controlIds};o.prototype.setDescription=function(t){this.description=t};o.prototype.getDescription=function(){return this.description};o.prototype.setAdditionalText=function(t){this.additionalText=t};o.prototype.getAdditionalText=function(){return this.additionalText};o.prototype.getDescriptionUrl=function(){return this.descriptionUrl};o.prototype.setDescriptionUrl=function(t){this.descriptionUrl=t};o.prototype.setType=function(s){if(s in t){this.type=s}else{e.error("[FUTURE FATAL] MessageType must be of type sap/ui/core/message/MessageType")}};o.prototype.getType=function(){return this.type};o.prototype.setTarget=function(t){this.aTargets[0]=t};o.prototype.getTarget=function(){return this.aTargets[0]};o.prototype.setTargets=function(t){this.aTargets=t.slice()};o.prototype.getTargets=function(){return this.aTargets.slice()};o.prototype.setMessageProcessor=function(t){if(r.isObjectA(t,"sap.ui.core.message.MessageProcessor")){this.processor=t}else{e.error("[FUTURE FATAL] oMessageProcessor must be an instance of 'sap.ui.core.message.MessageProcessor'")}};o.prototype.getMessageProcessor=function(){return this.processor};o.prototype.setCode=function(t){this.code=t};o.prototype.getCode=function(){return this.code};o.prototype.setPersistent=function(t){this.persistent=t};o.prototype.getPersistent=function(){return this.persistent};o.prototype.setTechnical=function(t){this.technical=t};o.prototype.getTechnical=function(){return this.technical};o.prototype.setTechnicalDetails=function(t){this.technicalDetails=t};o.prototype.getTechnicalDetails=function(){return this.technicalDetails};o.prototype.addReference=function(t,e){if(!t){return}if(!this.references[t]){this.references[t]={properties:{}}}if(!this.references[t].properties[e]){this.references[t].properties[e]=true}};o.prototype.removeReference=function(t,e){if(!t){return}if(t in this.references){if(!e){delete this.references[t]}else if(this.references[t].properties[e]){delete this.references[t].properties[e]}}};o.prototype.setDate=function(t){this.date=t};o.prototype.getDate=function(){return this.date};o.compare=function(t,e){return i[t.type]-i[e.type]};return o});
//# sourceMappingURL=Message.js.map