/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/EventBus","sap/base/util/isPlainObject","sap/base/Log"],function(e,t,i){"use strict";var n;var r="______UI5______";var s=e.extend("sap.ui.core.postmessage.Bus",{constructor:function(){if(n){return n}n=this;e.apply(this,arguments);this._aAcceptedOrigins=[window.location.origin];this._aDeclinedOrigins=[];this._oPendingProcess=null;this._aEventQueue=[];this._receiver=this._receiver.bind(this);window.addEventListener("message",this._receiver)}});s.event={CONNECT:"______CONNECT______",READY:"______READY______",ACCEPTED:"______ACCEPTED______",DECLINED:"______DECLINED______"};s.prototype.destroy=function(){window.removeEventListener("message",this._receiver);this._aEventQueue=[];e.prototype.destroy.apply(this,arguments);n=undefined;this.bIsDestroyed=true};s.getInstance=function(){if(!n){n=new s}return n};s.prototype.publish=function(e){var t=e.target;var i=e.origin;var n=e.channelId;var o=e.eventId;var a=e.data;if(o===s.event.READY){if(!t){if(window.opener&&window.opener!==window){t=window.opener}else if(window.parent!==window){t=window.parent}else{return}}if(!i){i="*"}}if(typeof window==="undefined"||!(t!=null&&t===t.window)||t===window){throw TypeError("Target must be a window object and has to differ from current window")}if(typeof i!=="string"){throw TypeError("Origin must be a string")}if(typeof n!=="string"){throw TypeError("ChannelId must be a string")}if(typeof o!=="string"){throw TypeError("EventId must be a string")}if(![s.event.READY,s.event.ACCEPTED,s.event.DECLINED].includes(o)&&i!=="*"&&!this._aAcceptedOrigins.includes(i)){this._aAcceptedOrigins.push(i)}var c={origin:i,channelId:n,eventId:o,data:a};c[r]=true;t.postMessage(c,i)};s.prototype._callListener=function(e,t,i,n,r){e.call(t,r)};s.prototype._getText=function(e,t){return sap.ui.getCore().getLibraryResourceBundle(true).then(function(i){return i.getText(e,t)})};s.prototype._receiver=function(e){var i=e.data;if(!t(i)||!i.hasOwnProperty(r)){return}if(this._oPendingProcess){this._aEventQueue.push(e)}else{this._oPendingProcess=this._processEvent(e)}};s.prototype._processEvent=function(e){return new Promise(function(t,i){var n=e.data;var r=e.origin;if(this._aDeclinedOrigins.includes(r)){t();return}switch(n.eventId){case s.event.CONNECT:{if(typeof n.data!=="string"){this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:s.event.DECLINED});t()}else if(this._aAcceptedOrigins.includes(r)){this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:s.event.ACCEPTED});t()}else{sap.ui.require(["sap/ui/core/postmessage/confirmationDialog"],function(i){this._getText("PostMessage.Message",[n.data,r]).then(function(e){return i(e)}).then(function(){this.addAcceptedOrigin(r);this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:s.event.ACCEPTED})}.bind(this),function(){this.addDeclinedOrigin(r);this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:s.event.DECLINED})}.bind(this)).then(t)}.bind(this),i)}break}case s.event.ACCEPTED:case s.event.DECLINED:case s.event.READY:{e.data.data=undefined;this._emitMessage(e);t();break}default:{if(this._aAcceptedOrigins.includes(r)){this._emitMessage(e)}t()}}}.bind(this)).catch(function(e){var t;var n;if(typeof e==="string"){t=e}else if(e instanceof Error){t=e.message;n=e.stack}else{t="Some unexpected error happened during post message processing"}i.error(t,n,"sap.ui.core.postmessage.Bus")}).then(function(){this._oPendingProcess=this._aEventQueue.length>0?this._processEvent(this._aEventQueue.shift()):null}.bind(this))};s.prototype._emitMessage=function(t){var i=t.data.channelId;var n=t.data.eventId;e.prototype.publish.call(this,i,n,{originalEvent:t,channelId:i,eventId:n,source:t.source,origin:t.origin,data:t.data.data})};s.prototype.getAcceptedOrigins=function(){return this._aAcceptedOrigins.slice()};s.prototype.setAcceptedOrigins=function(e){if(!Array.isArray(e)){throw new TypeError("Expected an array, but got "+typeof e)}this._aAcceptedOrigins=e.slice()};s.prototype.addAcceptedOrigin=function(e){if(typeof e!=="string"){throw new TypeError("Expected a string, but got "+typeof e)}if(!this._aAcceptedOrigins.includes(e)){this._aAcceptedOrigins.push(e)}};s.prototype.resetAcceptedOrigins=function(){this.setAcceptedOrigins([])};s.prototype.getDeclinedOrigins=function(){return this._aDeclinedOrigins.slice()};s.prototype.setDeclinedOrigins=function(e){if(!Array.isArray(e)){throw new TypeError("Expected an array, but got "+typeof e)}this._aDeclinedOrigins=e.slice()};s.prototype.addDeclinedOrigin=function(e){if(typeof e!=="string"){throw new TypeError("Expected a string, but got "+typeof e)}if(!this._aDeclinedOrigins.includes(e)){this._aDeclinedOrigins.push(e)}};s.prototype.resetDeclinedOrigins=function(){this.setDeclinedOrigins([])};return s});
//# sourceMappingURL=Bus.js.map