/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject"],function(t){"use strict";var a=t.extend("sap.ui.core.support.controls.TimelineOverview",{metadata:{library:"sap.ui.core"}});a.prototype.setInteractions=function(t){this.interactions=JSON.parse(JSON.stringify(t));if(!t||!t.length){return}this.actualStartTime=t[0].start;this.actualEndTime=t[t.length-1].end;this.timeRange=this.actualEndTime-this.actualStartTime;this.maxDuration=0;this.stepCount=60;var a=this;this.interactions.forEach(function(t){t.start=parseFloat((t.start-a.actualStartTime).toFixed(2));t.end=parseFloat((t.end-a.actualStartTime).toFixed(2));t.calculatedDuration=t.end-t.start;if(t.calculatedDuration>a.maxDuration){a.maxDuration=t.calculatedDuration}})};a.prototype.render=function(t){t.openStart("div","sapUiInteractionTimelineOverview").openEnd();t.openStart("ol",this.getId()).class("InteractionTimeline").openEnd();var a,e=this.interactions;if(!e||!e.length){return}var i=this._getTimelineOverviewData(e);var n=this;i.forEach(function(t){if(t.totalDuration>n.maxDuration){n.maxDuration=t.totalDuration}});for(var r=0;r<i.length;r++){a=i[r];this.renderInteractionStep(t,a,r)}t.close("ol");t.close("div")};a.prototype.renderInteractionStep=function(t,a,e){var i=69,n=Math.ceil(a.totalDuration/this.maxDuration*i);t.openStart("li").openEnd();t.openStart("div").class("bars-wrapper").attr("title","Duration: "+a.totalDuration+"ms").openEnd();t.openStart("div").class("duration").style("height",n+"%;");if(n>0){t.style("min-height","1px")}t.openEnd();var r=a.interactions,o=100;r.forEach(function(e,i){o=a.totalDuration===0?100:Math.ceil(e.calculatedDuration/a.totalDuration*100);t.openStart("div").class("requestType").style("height",o+"%").style("min-height","1px").openEnd().close("div");if(i!==r.length-1){t.openStart("div").style("min-height","1px").openEnd().close("div")}});t.close("div");t.close("div");var s=e+1;var l=s%10===0?"sapUiInteractionTimelineStepRightBold":"sapUiInteractionTimelineStepRight";if(s%2===0){t.openStart("div").class(l).openEnd().close("div")}if(s%10===0&&s!==this.stepCount){t.openStart("div").class("sapUiInteractionTimelineTimeLbl").openEnd().text(Math.round(e*this.timeRange/this.stepCount/10)/100+"s").close("div")}t.close("li")};a.prototype._getTimelineOverviewData=function(t){var a=this.stepCount;var e=this.timeRange/a;var i=[],n={interactions:[]},r=true;for(var o=0;o<a;o++){var s=e*o;var l=s+e;var c=this._filterByTime({start:s,end:l},t);var u={interactions:c,totalDuration:0};c.forEach(function(t){u.totalDuration+=t.calculatedDuration});r=c.length>0&&n.interactions.length>0&&c[0].start===n.interactions[0].start;if(r){u.interactions=[];u.totalDuration=0}i.push(u);n=u}return i};a.prototype._filterByTime=function(t,a){return a.filter(function(a){return!(a.end<=t.start||a.start>=t.end)}).map(function(a){var e=Math.max(t.start-a.start,0);var i=Math.max(a.start+a.duration-t.end,0);a.duration=a.duration-e-i;a.start=Math.max(a.start,t.start);a.end=Math.min(a.end,t.end);return a})};return a});
//# sourceMappingURL=TimelineOverview.js.map