/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/ui/core/support/Plugin","sap/ui/core/util/serializer/ViewSerializer","sap/ui/core/util/File","sap/ui/thirdparty/jszip","sap/ui/base/DataType","sap/ui/core/Component","sap/ui/core/Element","sap/ui/core/ElementMetadata","sap/ui/core/UIArea","sap/ui/core/UIAreaRegistry","sap/ui/core/mvc/View","sap/ui/core/mvc/XMLView","sap/ui/model/Binding","sap/ui/model/CompositeBinding","sap/base/util/each","sap/base/util/isEmptyObject","sap/base/util/ObjectPath","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/ui/dom/jquery/selectText","sap/ui/dom/jquery/cursorPos"],function(t,e,o,n,r,i,a,s,p,l,d,c,u,g,f,h,v,S,b,m){"use strict";var E=e.extend("sap.ui.core.support.plugins.ControlTree",{constructor:function(o){e.apply(this,["sapUiSupportControlTree","Control Tree",o]);if(this.runsAsToolPlugin()){this._aEventIds=["sapUiSupportSelectorSelect",this.getId()+"ReceiveControlTree",this.getId()+"ReceiveControlTreeExport",this.getId()+"ReceiveControlTreeExportError",this.getId()+"TriggerRequestProperties",this.getId()+"ReceiveProperties",this.getId()+"ReceiveBindingInfos",this.getId()+"ReceiveMethods",this.getId()+"ReceivePropertiesMethods"];this._breakpointId="sapUiSupportBreakpoint";this._tab={properties:"Properties",bindinginfos:"BindingInfos",breakpoints:"Breakpoints",exports:"Export"};this._currentTab=this._tab.properties}else{this._aEventIds=[this.getId()+"RequestControlTree",this.getId()+"RequestControlTreeSerialize",this.getId()+"RequestProperties",this.getId()+"RequestBindingInfos",this.getId()+"ChangeProperty",this.getId()+"RefreshBinding"];this.oCore=t}}});E.prototype.init=function(t){e.prototype.init.apply(this,arguments);if(this.runsAsToolPlugin()){C.call(this,t)}else{T.call(this,t)}};function C(t){b(document).on("click","li img.sapUiControlTreeIcon",this._onIconClick.bind(this)).on("click","li.sapUiControlTreeElement div",this._onNodeClick.bind(this)).on("click","li.sapUiControlTreeLink div",this._onControlTreeLinkClick.bind(this)).on("click","#sapUiSupportControlTabProperties",this._onPropertiesTab.bind(this)).on("click","#sapUiSupportControlTabBindingInfos",this._onBindingInfosTab.bind(this)).on("click","#sapUiSupportControlTabBreakpoints",this._onMethodsTab.bind(this)).on("click","#sapUiSupportControlTabExport",this._onExportTab.bind(this)).on("change","[data-sap-ui-name]",this._onPropertyChange.bind(this)).on("change","[data-sap-ui-method]",this._onPropertyBreakpointChange.bind(this)).on("keyup",'.sapUiSupportControlMethods input[type="text"]',this._autoComplete.bind(this)).on("blur",'.sapUiSupportControlMethods input[type="text"]',this._updateSelectOptions.bind(this)).on("change",".sapUiSupportControlMethods select",this._selectOptionsChanged.bind(this)).on("click","#sapUiSupportControlAddBreakPoint",this._onAddBreakpointClicked.bind(this)).on("click","#sapUiSupportControlExportToXml",this._onExportToXmlClicked.bind(this)).on("click","#sapUiSupportControlExportToHtml",this._onExportToHtmlClicked.bind(this)).on("click","#sapUiSupportControlActiveBreakpoints img.remove-breakpoint",this._onRemoveBreakpointClicked.bind(this)).on("click","#sapUiSupportControlPropertiesArea a.control-tree",this._onNavToControl.bind(this)).on("click","#sapUiSupportControlPropertiesArea img.sapUiSupportRefreshBinding",this._onRefreshBinding.bind(this));this.renderContentAreas()}E.prototype.exit=function(t){e.prototype.exit.apply(this,arguments);this.oCore=null;if(this.runsAsToolPlugin()){b(document).off("click","li img.sapUiControlTreeIcon").off("click","li div").off("click","li.sapUiControlTreeLink").off("click","#sapUiSupportControlTabProperties").off("click","#sapUiSupportControlTabBindings").off("click","#sapUiSupportControlTabBreakpoints").off("click","#sapUiSupportControlTabExport").off("change","[data-sap-ui-name]").off("change","[data-sap-ui-method]").off("keyup",'.sapUiSupportControlMethods input[type="text"]').off("blur",".sapUiSupportControlMethods select").off("change",".sapUiSupportControlMethods select").off("click","#sapUiSupportControlAddBreakPoint").off("click","#sapUiSupportControlExportToXml").off("click","#sapUiSupportControlExportToHtml").off("click","#sapUiSupportControlActiveBreakpoints img.remove-breakpoint").off("click","#sapUiSupportControlPropertiesArea a.control-tree").off("click","#sapUiSupportControlPropertiesArea img.sapUiSupportRefreshBinding")}};function y(t){if(t==null){return""}t=String(t);return t.slice(1+t.lastIndexOf("."))}E.prototype.renderContentAreas=function(){var e=t.createRenderManager();e.openStart("div").class("sapUiSupportControlTreeTitle").openEnd().text("You can find a control in this tree by clicking it in the application UI while pressing the Ctrl+Alt+Shift keys.").close("div");e.openStart("div","sapUiSupportControlTreeArea").openEnd();e.openStart("ul").class("sapUiSupportControlTreeList").openEnd().close("ul");e.close("div");e.openStart("div","sapUiSupportControlTabs").class("sapUiSupportControlTabsHidden").openEnd();e.openStart("button","sapUiSupportControlTabProperties").class("sapUiSupportBtn").class("sapUiSupportTab").class("sapUiSupportTabLeft").openEnd().text("Properties").close("button");e.openStart("button","sapUiSupportControlTabBindingInfos").class("sapUiSupportBtn").class("sapUiSupportTab").openEnd().text("Binding Infos").close("button");e.openStart("button","sapUiSupportControlTabBreakpoints").class("sapUiSupportBtn").class("sapUiSupportTab").openEnd().text("Breakpoints").close("button");e.openStart("button","sapUiSupportControlTabExport").class("sapUiSupportBtn").class("sapUiSupportTab").class("sapUiSupportTabRight").openEnd().text("Export").close("button");e.close("div");e.openStart("div","sapUiSupportControlPropertiesArea").openEnd().close("div");e.flush(this.dom());e.destroy()};E.prototype.renderControlTree=function(e){var o=t.createRenderManager();function n(t,e){var r=e.aggregation.length>0||e.association.length>0;o.openStart("li","sap-debug-controltree-"+e.id).class("sapUiControlTreeElement").openEnd();var i=r?"minus":"space";o.voidStart("img").class("sapUiControlTreeIcon").attr("src","../../debug/images/"+i+".gif").voidEnd();if(e.isAssociation){o.voidStart("img").attr("title","Association").class("sapUiControlTreeIcon").attr("src","../../debug/images/link.gif").voidEnd()}var a=y(e.type);o.openStart("div").openEnd();o.openStart("span").class("name").attr("title",e.type).openEnd().text(a+" - "+e.id).close("span");o.openStart("span").class("sapUiSupportControlTreeBreakpointCount").class("sapUiSupportItemHidden").attr("title","Number of active breakpoints / methods").openEnd().close("span");o.close("div");if(e.aggregation.length>0){o.openStart("ul").openEnd();h(e.aggregation,n);o.close("ul")}if(e.association.length>0){o.openStart("ul").openEnd();h(e.association,function(t,e){if(e.isAssociationLink){var r=y(e.type);o.openStart("li").attr("data-sap-ui-controlid",e.id).class("sapUiControlTreeLink").openEnd();o.voidStart("img").class("sapUiControlTreeIcon").attr("align","middle").attr("src","../../debug/images/space.gif").voidEnd();o.voidStart("img").class("sapUiControlTreeIcon").attr("align","middle").attr("src","../../debug/images/link.gif").voidEnd();o.openStart("div").openEnd();o.openStart("span").attr("title","Association '"+e.name+"' to '"+e.id+"' with type '"+e.type).openEnd();o.text(r+" - "+e.id+" ("+e.name+")");o.close("span");o.close("div");o.close("li")}else{n(0,e)}});o.close("ul")}o.close("li")}h(e,n);o.flush(this.dom("#sapUiSupportControlTreeArea > ul.sapUiSupportControlTreeList"));o.destroy()};E.prototype.renderPropertiesTab=function(e,o){var n=t.createRenderManager();n.openStart("ul").class("sapUiSupportControlTreeList").attr("data-sap-ui-controlid",o).openEnd();h(e,function(t,e){n.openStart("li").openEnd();n.openStart("span").openEnd().openStart("label").class("sapUiSupportLabel").openEnd().text("BaseType").close("label").text(" ").openStart("code").openEnd().text(e.control).close("code").close("span");if(e.properties.length>0||e.aggregations.length>0){n.openStart("div").class("get").attr("title","Activate debugger for get-method").openEnd().text("G").close("div");n.openStart("div").class("set").attr("title","Activate debugger for set-method").openEnd().text("S").close("div");n.openStart("div").class("sapUiSupportControlProperties").openEnd();n.openStart("table").openEnd();n.openStart("colgroup").openEnd();n.voidStart("col").attr("width","50%").voidEnd();n.voidStart("col").attr("width","50%").voidEnd();n.close("colgroup");h(e.properties,function(t,e){n.openStart("tr").openEnd();n.openStart("td").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text(e.name);if(e.isBound){n.voidStart("img").attr("title","Value is bound (see Binding Infos)").attr("src","../../debug/images/link.gif").voidEnd()}n.close("label");n.close("td");n.openStart("td").openEnd();if(e.type==="boolean"){n.voidStart("input").attr("type","checkbox");n.attr("data-sap-ui-name",e.name);if(e.value==true){n.attr("checked","checked")}n.voidEnd()}else if(e.enumValues){n.openStart("div").openEnd();n.openStart("select");n.attr("data-sap-ui-name",e.name).openEnd();h(e.enumValues,function(t,o){n.openStart("option");if(t===e.value){n.attr("selected","selected")}n.openEnd();n.text(t);n.close("option")});n.close("select");n.close("div")}else{n.openStart("div").openEnd();n.voidStart("input").attr("type","text");n.attr("data-sap-ui-name",e.name);if(e.value){n.attr("value",e.value)}n.voidEnd();n.close("div")}n.close("td");n.openStart("td").openEnd();n.voidStart("input").attr("type","checkbox").attr("data-sap-ui-method",e._sGetter).attr("title","Activate debugger for '"+e._sGetter+"'");if(e.bp_sGetter){n.attr("checked","checked")}n.voidEnd();n.close("td");n.openStart("td").openEnd();n.voidStart("input").attr("type","checkbox").attr("data-sap-ui-method",e._sMutator).attr("title","Activate debugger for '"+e._sMutator+"'");if(e.bp_sMutator){n.attr("checked","checked")}n.voidEnd();n.close("td");n.close("tr")});h(e.aggregations,function(t,e){n.openStart("tr").openEnd();n.openStart("td").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text(e.name).close("label");n.close("td");n.openStart("td").openEnd();n.text(e.value);n.close("td");n.openStart("td").openEnd();n.voidStart("input").attr("type","checkbox").attr("data-sap-ui-method",e._sGetter).attr("title","Activate debugger for '"+e._sGetter+"'");if(e.bp_sGetter){n.attr("checked","checked")}n.voidEnd();n.close("td");n.openStart("td").openEnd();n.voidStart("input").attr("type","checkbox").attr("data-sap-ui-method",e._sMutator).attr("title","Activate debugger for '"+e._sMutator+"'");if(e.bp_sMutator){n.attr("checked","checked")}n.voidEnd();n.close("td");n.close("tr")});n.close("table").close("div")}n.close("li")});n.close("ul");n.flush(this.dom("#sapUiSupportControlPropertiesArea"));n.destroy();this.dom("#sapUiSupportControlTabs").classList.remove("sapUiSupportControlTabsHidden");this.selectTab(this._tab.properties)};E.prototype.renderBindingsTab=function(e,o){var n=t.createRenderManager();if(e.contexts.length>0){n.openStart("h2").openEnd().text("Contexts").close("h2");n.openStart("ul").class("sapUiSupportControlTreeList").attr("data-sap-ui-controlid",o).openEnd();h(e.contexts,function(t,e){n.openStart("li").openEnd();n.openStart("span").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Model Name: "+e.modelName).close("label");n.close("span");n.openStart("div").class("sapUiSupportControlProperties").openEnd();n.openStart("table").openEnd().openStart("colgroup").openEnd().voidStart("col").attr("width","15%").voidEnd().voidStart("col").attr("width","35%").voidEnd().voidStart("col").attr("width","50%").voidEnd().close("colgroup");n.openStart("tbody").openEnd();n.openStart("tr").openEnd();n.openStart("td").attr("colspan","2").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Path").close("label");n.close("td");n.openStart("td").openEnd();n.openStart("div").openEnd();n.openStart("span");if(e.invalidPath){n.class("sapUiSupportModelPathInvalid")}else if(e.unverifiedPath){n.class("sapUiSupportModelPathUnverified")}n.openEnd().text(e.path);if(e.invalidPath){n.text(" (invalid)")}else if(e.unverifiedPath){n.text(" (unverified)")}n.close("span");n.close("div");n.close("td");n.close("tr");if(e.location){n.openStart("tr").openEnd();n.openStart("td").attr("colspan","2").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Inherited from").close("label");n.close("td");n.openStart("td").openEnd();n.openStart("div").openEnd();n.openStart("a").class("control-tree").class("sapUiSupportLink").attr("title",e.location.name).attr("data-sap-ui-control-id",e.location.id).attr("href","#").openEnd().text(y(e.location.name)).text(" ("+e.location.id+")").close("a").close("div");n.close("td");n.close("tr")}n.close("tbody").close("table").close("div").close("li")});n.close("ul")}if(e.bindings.length>0){n.openStart("h2").openEnd().text("Bindings").close("h2");n.openStart("ul").class("sapUiSupportControlTreeList").attr("data-sap-ui-controlid",o).openEnd();h(e.bindings,function(t,e){n.openStart("li").attr("data-sap-ui-binding-name",e.name).openEnd();n.openStart("span").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text(e.name).close("label");n.voidStart("img").class("sapUiSupportRefreshBinding").attr("title","Refresh Binding").attr("src","../../debug/images/refresh.gif").voidEnd();n.close("span");h(e.bindings,function(t,o){n.openStart("div").class("sapUiSupportControlProperties").openEnd();n.openStart("table").openEnd().openStart("colgroup").openEnd().voidStart("col").attr("width","15%").voidEnd().voidStart("col").attr("width","35%").voidEnd().voidStart("col").attr("width","50%").voidEnd().close("colgroup");n.openStart("tbody").openEnd();n.openStart("tr").openEnd();n.openStart("td").attr("colspan","2").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Path").close("label");n.close("td");n.openStart("td").openEnd();n.openStart("div").openEnd().openStart("span");if(o.invalidPath){n.class("sapUiSupportModelPathInvalid")}else if(o.unverifiedPath){n.class("sapUiSupportModelPathUnverified")}n.openEnd().text(o.path);if(o.invalidPath){n.text(" (invalid)")}else if(o.unverifiedPath){n.text(" (unverified)")}n.close("span").close("div");n.close("td");n.close("tr");n.openStart("tr").openEnd();n.openStart("td").attr("colspan","2").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Absolute Path").close("label");n.close("td");n.openStart("td").openEnd();if(typeof o.absolutePath!=="undefined"){n.openStart("div").openEnd().text(o.absolutePath).close("div")}else{n.openStart("div").openEnd().text("No binding").close("div")}n.close("td");n.close("tr");n.openStart("tr").openEnd();n.openStart("td").attr("colspan","2").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Relative").close("label");n.close("td");n.openStart("td").openEnd();if(typeof o.isRelative!=="undefined"){n.openStart("div").openEnd().text(o.isRelative).close("div")}else{n.openStart("div").openEnd().text("No binding").close("div")}n.close("td");n.close("tr");n.openStart("tr").openEnd();n.openStart("td").attr("colspan","2").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Binding Type").close("label");n.close("td");n.openStart("td").openEnd();if(!e.type){n.openStart("div").openEnd().text("No binding").close("div")}else{n.openStart("div").attr("title",e.type).openEnd().text(y(e.type)).close("div")}n.close("td");n.close("tr");if(o.mode){n.openStart("tr").openEnd().openStart("td").attr("colspan","2").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Binding Mode").close("label");n.close("td");n.openStart("td").openEnd();n.openStart("div").openEnd().text(e.mode).close("div");n.close("td").close("tr")}n.openStart("tr").openEnd();n.openStart("td").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Model").close("label");n.close("td");n.openStart("td").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Name").close("label");n.close("td");n.openStart("td").openEnd();if(o.model&&o.model.name){n.openStart("div").openEnd().text(o.model.name).close("div")}else{n.openStart("div").openEnd().text("No binding").close("div")}n.close("td");n.close("tr");n.openStart("tr").openEnd();n.openStart("td").openEnd().close("td");n.openStart("td").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Type").close("label");n.close("td");n.openStart("td").openEnd();if(o.model&&o.model.type){n.openStart("div").openEnd().openStart("span").attr("title",o.model.type).openEnd().text(y(o.model.type)).close("span").close("div")}else{n.openStart("div").openEnd().openStart("span").openEnd().text("No binding").close("span").close("div")}n.close("td");n.close("tr");n.openStart("tr").openEnd();n.openStart("td").openEnd().close("td");n.openStart("td").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Default Binding Mode").close("label");n.close("td");n.openStart("td").openEnd();if(o.model&&o.model.bindingMode){n.openStart("div").openEnd().openStart("span").openEnd().text(o.model.bindingMode).close("span").close("div")}else{n.openStart("div").openEnd().openStart("span").openEnd().text("No binding").close("span").close("div")}n.close("td");n.close("tr");n.openStart("tr").openEnd();n.openStart("td").openEnd().close("td");n.openStart("td").openEnd();n.openStart("label").class("sapUiSupportLabel").openEnd().text("Location").close("label");n.close("td");n.openStart("td").openEnd();if(o.model&&o.model.location&&o.model.location.type){if(o.model.location.type==="control"){n.openStart("div").openEnd();n.openStart("a").class("control-tree").class("sapUiSupportLink").attr("title",o.model.location.name).attr("data-sap-ui-control-id",o.model.location.id).attr("href","#").openEnd().text(y(o.model.location.name)).text(" ("+o.model.location.id+")").close("a");n.close("div")}else{n.openStart("div").openEnd().openStart("span").attr("title","Core").openEnd().text("Core").close("span").close("div")}}else{n.openStart("div").openEnd().openStart("span").openEnd().text("No binding").close("span").close("div")}n.close("td");n.close("tr");n.close("tbody").close("table").close("div")});n.close("li")});n.close("ul")}n.flush(this.dom("#sapUiSupportControlPropertiesArea"));n.destroy()};E.prototype.renderBreakpointsTab=function(e,o){var n=t.createRenderManager();n.openStart("div").class("sapUiSupportControlMethods").attr("data-sap-ui-controlid",o).openEnd();n.openStart("select","sapUiSupportControlMethodsSelect").class("sapUiSupportAutocomplete").class("sapUiSupportSelect").openEnd();n.openStart("option").openEnd().close("option");h(e,function(t,e){if(!e.active){n.openStart("option").openEnd().text("oValue.name").close("option")}});n.close("select");n.voidStart("input").class("sapUiSupportControlBreakpointInput").class("sapUiSupportAutocomplete").attr("type","text").voidEnd();n.openStart("button","sapUiSupportControlAddBreakPoint").class("sapUiSupportRoundedButton").openEnd().text("Add breakpoint").close("button");n.voidStart("hr").class("no-border").voidEnd();n.openStart("ul","sapUiSupportControlActiveBreakpoints").class("sapUiSupportList").class("sapUiSupportBreakpointList").openEnd();h(e,function(t,e){if(!e.active){return}n.openStart("li").openEnd().openStart("span").openEnd().text(e.name).close("span").voidStart("img").class("remove-breakpoint").attr("src","../../debug/images/delete.gif").voidEnd().close("li")});n.close("ul").close("div");n.flush(this.dom("#sapUiSupportControlPropertiesArea"));n.destroy();this.selectTab(this._tab.breakpoints);this.dom(".sapUiSupportControlBreakpointInput").focus()};E.prototype.renderExportTab=function(){var e=t.createRenderManager();e.openStart("button","sapUiSupportControlExportToXml").class("sapUiSupportRoundedButton").class("sapUiSupportExportButton").openEnd().text("Export To XML").close("button");e.voidStart("br").voidEnd();e.voidStart("br").voidEnd();e.openStart("button","sapUiSupportControlExportToHtml").class("sapUiSupportRoundedButton").class("sapUiSupportExportButton").openEnd().text("Export To HTML").close("button");e.flush(this.dom("#sapUiSupportControlPropertiesArea"));e.destroy();this.selectTab(this._tab.exports)};E.prototype.requestProperties=function(t){this._oStub.sendEvent(this._breakpointId+"RequestInstanceMethods",{controlId:t,callback:this.getId()+"ReceivePropertiesMethods"})};E.prototype.updateBreakpointCount=function(t,e){var o=b("#sap-debug-controltree-"+t+" > div span.sapUiSupportControlTreeBreakpointCount");if(e.active>0){o.text(e.active+" / "+e.all).toggleClass("sapUiSupportItemHidden",false)}else{o.text("").toggleClass("sapUiSupportItemHidden",true)}};E.prototype.onsapUiSupportControlTreeTriggerRequestProperties=function(t){this.requestProperties(t.getParameter("controlId"))};E.prototype.onsapUiSupportControlTreeReceivePropertiesMethods=function(t){var e=t.getParameter("controlId");this._oStub.sendEvent(this.getId()+"RequestProperties",{id:e,breakpointMethods:t.getParameter("methods")});this.updateBreakpointCount(e,JSON.parse(t.getParameter("breakpointCount")))};E.prototype.onsapUiSupportControlTreeReceiveControlTree=function(t){this.renderControlTree(JSON.parse(t.getParameter("controlTree")))};E.prototype.onsapUiSupportControlTreeReceiveControlTreeExportError=function(t){var e=t.getParameter("errorMessage");this._drawAlert(e)};E.prototype._drawAlert=function(t){alert("ERROR: The selected element cannot not be exported.\nPlease choose an other one.\n\nReason:\n"+t)};E.prototype.onsapUiSupportControlTreeReceiveControlTreeExport=function(t){var e;var o=JSON.parse(t.getParameter("serializedViews"));var i=t.getParameter("sType");if(!v(o)){e=new r;for(var a in o){var s=o[a];e.file(a.replace(/\./g,"/")+".view."+i.toLowerCase(),s)}}if(e){var p=e.generate({type:"blob"});n.save(p,i.toUpperCase()+"Export","zip","application/zip")}};E.prototype.onsapUiSupportSelectorSelect=function(t){this.selectControl(t.getParameter("id"))};E.prototype.onsapUiSupportControlTreeReceiveProperties=function(t){this.renderPropertiesTab(JSON.parse(t.getParameter("properties")),t.getParameter("id"))};E.prototype.onsapUiSupportControlTreeReceiveBindingInfos=function(t){this.renderBindingsTab(JSON.parse(t.getParameter("bindinginfos")),t.getParameter("id"))};E.prototype.onsapUiSupportControlTreeReceiveMethods=function(t){var e=t.getParameter("controlId");this.renderBreakpointsTab(JSON.parse(t.getParameter("methods")),e);this.updateBreakpointCount(e,JSON.parse(t.getParameter("breakpointCount")))};E.prototype._onNodeClick=function(t){var e=b(t.target);var o=e.closest("li");if(o.hasClass("sapUiControlTreeElement")){b(".sapUiControlTreeElement > div").removeClass("sapUiSupportControlTreeSelected");o.children("div").addClass("sapUiSupportControlTreeSelected");this._oStub.sendEvent("sapUiSupportSelectorHighlight",{id:o.attr("id").substring("sap-debug-controltree-".length)});var n=o.attr("id").substring("sap-debug-controltree-".length);if(e.hasClass("sapUiSupportControlTreeBreakpointCount")){this._currentTab=this._tab.breakpoints}this.onAfterControlSelected(n)}t.stopPropagation()};E.prototype._onIconClick=function(t){var e=b(t.target);if(e.parent().attr("data-sap-ui-collapsed")){e.attr("src",e.attr("src").replace("plus","minus")).parent().removeAttr("data-sap-ui-collapsed");e.siblings("ul").toggleClass("sapUiSupportItemHidden",false)}else{e.attr("src",e.attr("src").replace("minus","plus")).parent().attr("data-sap-ui-collapsed","true");e.siblings("ul").toggleClass("sapUiSupportItemHidden",true)}if(t.stopPropagation){t.stopPropagation()}};E.prototype._onControlTreeLinkClick=function(t){this.selectControl(b(t.target).closest("li").attr("data-sap-ui-controlid"))};E.prototype._onPropertiesTab=function(t){if(this.selectTab(this._tab.properties)){this.requestProperties(this.getSelectedControlId())}};E.prototype._onBindingInfosTab=function(t){if(this.selectTab(this._tab.bindinginfos)){this._oStub.sendEvent(this.getId()+"RequestBindingInfos",{id:this.getSelectedControlId()})}};E.prototype._onMethodsTab=function(t){if(this.selectTab(this._tab.breakpoints)){this._oStub.sendEvent(this._breakpointId+"RequestInstanceMethods",{controlId:this.getSelectedControlId(),callback:this.getId()+"ReceiveMethods"})}};E.prototype._onExportTab=function(t){if(this.selectTab(this._tab.exports)){this.renderExportTab()}};E.prototype._autoComplete=function(t){if(t.keyCode==m.ENTER){this._updateSelectOptions(t);this._onAddBreakpointClicked()}if(t.keyCode>=m.ARROW_LEFT&&t.keyCode<=m.ARROW_DOWN){return}var e=b(t.target),o=e.prev("select"),n=e.val();if(n==""){return}var r=o.find("option").map(function(){return b(this).val()}).get();var i;for(var a=0;a<r.length;a++){i=r[a];if(i.toUpperCase().indexOf(n.toUpperCase())==0){var s=e.cursorPos();if(t.keyCode==m.BACKSPACE){s--}e.val(i);e.selectText(s,i.length);break}}return};E.prototype._updateSelectOptions=function(t){var e=t.target;if(e.tagName=="INPUT"){var o=e.value;e=e.previousSibling;var n=e.options;for(var r=0;r<n.length;r++){var i=n[r].value||n[r].text;if(i.toUpperCase()==o.toUpperCase()){e.selectedIndex=r;break}}}var a=e.selectedIndex;var s=e.options[a].value||e.options[a].text;if(e.nextSibling&&e.nextSibling.tagName=="INPUT"){e.nextSibling.value=s}};E.prototype._onAddBreakpointClicked=function(t){var e=this.dom("#sapUiSupportControlMethodsSelect");this._oStub.sendEvent(this._breakpointId+"ChangeInstanceBreakpoint",{controlId:e.closest("[data-sap-ui-controlid]").dataset.sapUiControlid,methodName:e.value,active:true,callback:this.getId()+"ReceiveMethods"})};E.prototype._onExportToXmlClicked=function(t){this._startSerializing("XML")};E.prototype._onExportToHtmlClicked=function(t){this._startSerializing("HTML")};E.prototype._startSerializing=function(t){var e=this.getSelectedControlId();if(e){this._oStub.sendEvent(this.getId()+"RequestControlTreeSerialize",{controlID:e,sType:t})}else{this._drawAlert("Nothing to export. Please select an item in the control tree.")}};E.prototype._onRemoveBreakpointClicked=function(t){var e=b(t.target);this._oStub.sendEvent(this._breakpointId+"ChangeInstanceBreakpoint",{controlId:e.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid"),methodName:e.siblings("span").text(),active:false,callback:this.getId()+"ReceiveMethods"})};E.prototype._selectOptionsChanged=function(t){var e=t.target;var o=e.nextSibling;o.value=e.options[e.selectedIndex].value};E.prototype._onPropertyChange=function(t){var e=t.target;var o=b(e);var n=o.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid");var r=o.val();if(o.attr("type")==="checkbox"){r=""+o.is(":checked")}this._oStub.sendEvent(this.getId()+"ChangeProperty",{id:n,name:o.attr("data-sap-ui-name"),value:r})};E.prototype._onPropertyBreakpointChange=function(t){var e=b(t.target);this._oStub.sendEvent(this._breakpointId+"ChangeInstanceBreakpoint",{controlId:e.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid"),methodName:e.attr("data-sap-ui-method"),active:e.is(":checked"),callback:this.getId()+"TriggerRequestProperties"})};E.prototype._onNavToControl=function(t){var e=b(t.target);var o=e.attr("data-sap-ui-control-id");if(o!==this.getSelectedControlId()){this.selectControl(o)}};E.prototype._onRefreshBinding=function(t){var e=b(t.target);var o=e.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid");var n=e.closest("[data-sap-ui-binding-name]").attr("data-sap-ui-binding-name");this._oStub.sendEvent(this.getId()+"RefreshBinding",{id:o,name:n})};E.prototype.selectTab=function(t){var e=this.dom("#sapUiSupportControlTab"+t);if(e.classList.contains("active")){return false}this.$().find("#sapUiSupportControlTabs button").removeClass("active");e.classList.add("active");this._currentTab=t;return true};E.prototype.getSelectedControlId=function(){var t=this.$().find(".sapUiSupportControlTreeSelected");if(t.length===0){return undefined}else{return t.parent().attr("id").substring("sap-debug-controltree-".length)}};E.prototype.selectControl=function(t){if(!t){return}b(".sapUiControlTreeElement > div").removeClass("sapUiSupportControlTreeSelected");var e=this;b(document.getElementById("sap-debug-controltree-"+t)).parents("[data-sap-ui-collapsed]").each(function(t,o){e._onIconClick({target:b(o).find("img:first").get(0)})});var o=b(document.getElementById("sap-debug-controltree-"+t)).children("div").addClass("sapUiSupportControlTreeSelected").position();var n=this.$().find("#sapUiSupportControlTreeArea").scrollTop();this.$().find("#sapUiSupportControlTreeArea").scrollTop(n+o.top);this.onAfterControlSelected(t)};E.prototype.onAfterControlSelected=function(t){if(this._currentTab==this._tab.properties){this.requestProperties(t)}else if(this._currentTab==this._tab.breakpoints){this._oStub.sendEvent(this._breakpointId+"RequestInstanceMethods",{controlId:t,callback:this.getId()+"ReceiveMethods"})}else if(this._currentTab==this._tab.bindinginfos){this._oStub.sendEvent(this.getId()+"RequestBindingInfos",{id:this.getSelectedControlId()})}};function T(t){this.onsapUiSupportControlTreeRequestControlTree()}E.prototype.onsapUiSupportControlTreeRequestControlTree=function(t){this._oStub.sendEvent(this.getId()+"ReceiveControlTree",{controlTree:JSON.stringify(this.getControlTree())})};E.prototype.onsapUiSupportControlTreeRequestControlTreeSerialize=function(t){var e=s.getElementById(t.getParameter("controlID"));var n=t.getParameter("sType");var r;var i;var a=n+"ViewExported";u.create({definition:document}).then(function(s){s.setViewName(a);s._controllerName=n+"ViewController";try{if(e){if(e instanceof c){r=new o(e,window,"sap.m")}else{s.addContent(e.clone());r=new o(s,window,"sap.m")}if(n&&n!=="XML"){i=r.serializeToHTML()}if(!(n&&n!=="XML")){i=r.serializeToXML()}}else{var p=d.get(t.getParameter("controlID"));var l=p.getContent();for(var u=0;u<l.length;u++){s.addContent(l[u])}r=new o(s,window,"sap.m");if(n&&n!=="XML"){i=r.serializeToHTML()}if(!(n&&n!=="XML")){i=r.serializeToXML()}for(var u=0;u<l.length;u++){p.addContent(l[u])}}if(r){this._oStub.sendEvent(this.getId()+"ReceiveControlTreeExport",{serializedViews:JSON.stringify(i),sType:n})}}catch(t){this._oStub.sendEvent(this.getId()+"ReceiveControlTreeExportError",{errorMessage:t.message})}}.bind(this))};E.prototype.onsapUiSupportControlTreeRequestProperties=function(t){var e=JSON.parse(t.getParameter("breakpointMethods"));var o=this.getControlProperties(t.getParameter("id"),e);this._oStub.sendEvent(this.getId()+"ReceiveProperties",{id:t.getParameter("id"),properties:JSON.stringify(o)})};E.prototype.onsapUiSupportControlTreeChangeProperty=function(t){var e=t.getParameter("id");var o=s.getElementById(e);if(o){var n=t.getParameter("name");var r=t.getParameter("value");var a=o.getMetadata().getProperty(n);if(a&&a.type){var p=i.getType(a.type);if(p instanceof i){var l=p.parseValue(r);if(p.isValid(l)&&l!=="(null)"){o[a._sMutator](l)}}else if(p){if(p[r]){o[a._sMutator](r)}}}}};E.prototype.onsapUiSupportControlTreeRequestBindingInfos=function(t){var e=t.getParameter("id");this._oStub.sendEvent(this.getId()+"ReceiveBindingInfos",{id:e,bindinginfos:JSON.stringify(this.getControlBindingInfos(e))})};E.prototype.onsapUiSupportControlTreeRefreshBinding=function(t){var e=t.getParameter("id");var o=t.getParameter("name");this.refreshBinding(e,o);this._oStub.sendEvent(this.getId()+"ReceiveBindingInfos",{id:e,bindinginfos:JSON.stringify(this.getControlBindingInfos(e))})};E.prototype.getControlTree=function(){var t=[],e={};function o(t){var n={id:t.getId(),type:"",aggregation:[],association:[]};e[n.id]=n.id;if(t instanceof l){n.library="sap.ui.core";n.type="sap.ui.core.UIArea";h(t.getContent(),function(t,e){var r=o(e);n.aggregation.push(r)})}else{n.library=t.getMetadata().getLibraryName();n.type=t.getMetadata().getName();if(t.mAggregations){for(var r in t.mAggregations){var i=t.mAggregations[r];if(i){var a=Array.isArray(i)?i:[i];h(a,function(t,e){if(e instanceof s){var r=o(e);n.aggregation.push(r)}})}}}if(t.mAssociations){var p=t.getMetadata().getAllAssociations();for(var d in t.mAssociations){var c=t.mAssociations[d];var u=p[d]?p[d].type:null;if(c&&u){var g=Array.isArray(c)?c:[c];h(g,function(t,e){n.association.push({id:e,type:u,name:d,isAssociationLink:true})})}}}}return n}h(d.all(),function(e,n){var r=o(n);t.push(r)});function n(t,r){for(var i=0;i<r.association.length;i++){var p=r.association[i];if(!e[p.id]){var l=S.get(p.type||"");if(!(typeof l==="function")){continue}var d=l.getMetadata().getStereotype(),c=null;switch(d){case"element":case"control":c=s.getElementById(p.id);break;case"component":c=a.getComponentById(p.id);break;default:break}if(d==="template"){var u=sap.ui.requireSync("sap/ui/core/tmpl/Template");c=u.byId(p.id)}if(!c){continue}r.association[i]=o(c);r.association[i].isAssociation=true;n(0,r.association[i])}}h(r.aggregation,n)}h(t,n);return t};E.prototype.getControlProperties=function(t,e){var o=/^((boolean|string|int|float)(\[\])?)$/;var n=[];var r=s.getElementById(t);if(!r&&d.get(t)){n.push({control:"sap.ui.core.UIArea",properties:[],aggregations:[]})}else if(r){var a=r.getMetadata();while(a instanceof p){var l={control:a.getName(),properties:[],aggregations:[]};var c=a.getProperties();h(c,function(t,o){var n={};h(o,function(t,r){if(t.substring(0,1)!=="_"||(t=="_sGetter"||t=="_sMutator")){n[t]=r}if(t=="_sGetter"||t=="_sMutator"){n["bp"+t]=e.filter(function(t){return t.name===r&&t.active}).length===1}var a=i.getType(o.type);if(a&&a.isEnumType()){n["enumValues"]=a.getEnumValues()}});n.value=r.getProperty(t);n.isBound=!!r.mBindingInfos[t];l.properties.push(n)});var u=a.getAggregations();h(u,function(t,n){if(n.altTypes&&n.altTypes[0]&&o.test(n.altTypes[0])&&typeof r.getAggregation(t)!=="object"){var i={};h(n,function(t,o){if(t.substring(0,1)!=="_"||(t=="_sGetter"||t=="_sMutator")){i[t]=o}if(t=="_sGetter"||t=="_sMutator"){i["bp"+t]=e.filter(function(t){return t.name===o&&t.active}).length===1}});i.value=r.getAggregation(t);l.aggregations.push(i)}});n.push(l);a=a.getParent()}}return n};E.prototype.getControlBindingInfos=function(t){var e={bindings:[],contexts:[]};var o=s.getElementById(t);if(!o){return e}var n=o.mBindingInfos;var r=this;for(var i in n){if(n.hasOwnProperty(i)){var a=n[i];var p=[];var l,d=[];if(Array.isArray(a.parts)){l=a.parts}else{l=[a]}if(a.binding instanceof f){d=a.binding.getBindings()}else if(a.binding instanceof g){d=[a.binding]}h(l,function(t,e){var n={};n.invalidPath=true;n.path=e.path;n.mode=e.mode;n.model={name:e.model};if(d.length>t&&d[t]){var i=d[t],a=i.getModel(),s=i.getPath(),l;if(a){l=a.resolve(s,i.getContext());if(a.isA("sap.ui.model.odata.v4.ODataModel")){n.unverifiedPath=true;n.invalidPath=false}else{if(a.getProperty(l)!==undefined&&a.getProperty(l)!==null){n.invalidPath=false}else if(a.getProperty(s)!==undefined&&a.getProperty(s)!==null){n.invalidPath=false;l=s}}}n.absolutePath=typeof l==="undefined"?"Unresolvable":l;n.isRelative=i.isRelative();n.model=r.getBindingModelInfo(i,o)}p.push(n)});e.bindings.push({name:i,type:a.binding?a.binding.getMetadata().getName():undefined,bindings:p})}}function c(t,e){var o={modelName:e==="undefined"?"none (default)":e,path:t.getPath()};if(t.getModel().isA("sap.ui.model.odata.v4.ODataModel")){o.unverifiedPath=true}else{if(t.getObject()==null){o.invalidPath=true}}return o}var u=o.oBindingContexts;for(var v in u){if(u.hasOwnProperty(v)){e.contexts.push(c(u[v],v))}}var u=o.oPropagatedProperties.oBindingContexts;for(var v in u){if(u.hasOwnProperty(v)&&!o.oBindingContexts[v]){var S=c(u[v],v);var b=o;do{if(b.oBindingContexts[v]==u[v]){S.location={id:b.getId(),name:b.getMetadata().getName()};break}}while(b=b.getParent());e.contexts.push(S)}}return e};E.prototype.getBindingModelInfo=function(t,e){var o={};var n=t.getModel();function r(t){for(var e in t){if(t.hasOwnProperty(e)){if(t[e]===n){return e}}}return null}o.name=r(e.oModels)||r(e.oPropagatedProperties.oModels);if(o.name){var i=e;do{if(i.oModels[o.name]===n){o.location={type:"control",id:i.getId(),name:i.getMetadata().getName()};break}}while(i=i.getParent());if(!o.location){var a=null;if(o.name==="undefined"){a=this.oCore.getModel()}else{a=this.oCore.getModel(o.name)}if(a){o.location={type:"core"}}}}o.type=n.getMetadata().getName();o.bindingMode=n.getDefaultBindingMode();o.name=o.name==="undefined"?"none (default)":o.name;return o};E.prototype.refreshBinding=function(t,e){var o=s.getElementById(t);var n=o.mBindingInfos[e];if(!o||!n){return}var r=n.binding;if(!r){return}if(r instanceof f){var i=r.getBindings();for(var a=0;a<i.length;a++){i[a].refresh()}}else{r.refresh()}};return E});
//# sourceMappingURL=ControlTree.js.map