/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../Plugin","../Support","../ToolsAPI","sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/each","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/security/encodeXML","sap/ui/VersionInfo"],function(e,t,o,jQuery,r,i,a,n,s,u){"use strict";var c=e.extend("sap.ui.core.support.plugins.TechInfo",{constructor:function(t){e.apply(this,["sapUiSupportTechInfo","Technical Information",t]);this._aEventIds=this.runsAsToolPlugin()?[this.getId()+"Data",this.getId()+"FinishedE2ETrace"]:[this.getId()+"SetReboot",this.getId()+"Refresh",this.getId()+"StartE2ETrace"];if(this.runsAsToolPlugin()){this.e2eLogLevel="medium";this.e2eTraceStarted=false}}});c.prototype.onsapUiSupportTechInfoData=function(e){var t=e.getParameter("data");u.load().then(function(e){return{productName:e.name,versionInfoEncoded:"<a href='"+sap.ui.require.toUrl("sap-ui-version.json")+"'"+" target='_blank' class='sapUiSupportLink' title='Open Version Info'>"+l(e.version)+"</a>"+h(e.buildTimestamp,e.scmRevision)}},function(){return{productName:"SAPUI5",versionInfoEncoded:"not available"}}).then(function(e){this._createTechInfoUI(t,e)}.bind(this))};c.prototype._createTechInfoUI=function(e,o){var r=this;e.modules.sort();this.e2eTraceStarted=e["e2e-trace"].isStarted;var n=["<div class='sapUiSupportToolbar'>","<button id='",r.getId(),"-Refresh' class='sapUiSupportRoundedButton'>Refresh</button>","<div><div class='sapUiSupportTechInfoCntnt'>","<table border='0' cellpadding='3' class='infoTable'>"];d(n,true,true,o.productName,function(e){e.push(o.versionInfoEncoded)});if(!/openui5/i.test(o.productName)){d(n,true,true,"OpenUI5 Version",function(t){t.push(l(e.version)+h(e.build,e.change))})}d(n,true,true,"Loaded jQuery Version",function(t){return e.jquery});d(n,true,true,"User Agent",function(t){return e.useragent+(e.docmode?", Document Mode '"+e.docmode+"'":"")});d(n,true,true,"Debug Sources",function(t){t.push(e.debug?"ON":"OFF","<a href='#' id='",r.getId(),"-tggleDbgSrc' class='sapUiSupportLink'>Toggle</a>")});d(n,true,true,"Application",e.appurl);f(n,true,true,"Configuration (bootstrap)",e.bootconfig);f(n,true,true,"Configuration (computed)",e.config);if(!a(e.libraries)){f(n,true,true,"Libraries",e.libraries)}f(n,true,true,"Loaded Libraries",e.loadedLibraries);d(n,true,true,"Loaded Modules",function(t){i(e.modules,function(o,r){if(r.indexOf("sap.ui.core.support")<0){t.push("<span>",l(r),"</span>");if(o<e.modules.length-1){t.push(", ")}}})});f(n,true,true,"URI Parameters",e.uriparams);d(n,true,true,"E2E Trace",function(t){t.push("<label class='sapUiSupportLabel'>Trace Level:</label>","<select id='",r.getId(),"-logLevelE2ETrace' class='sapUiSupportTxtFld sapUiSupportSelect'>","<option value='low'"+(r.e2eLogLevel==="low"?" selected":"")+">LOW</option>","<option value='medium'"+(r.e2eLogLevel==="medium"?" selected":"")+">MEDIUM</option>","<option value='high'"+(r.e2eLogLevel==="hight"?" selected":"")+">HIGH</option>","</select>");t.push("<button id='"+r.getId()+"-startE2ETrace' class='sapUiSupportRoundedButton "+(e["e2e-trace"].isStarted?" active":"")+"'>"+(e["e2e-trace"].isStarted?"Running...":"Start")+"</button>");t.push("<div class='sapUiSupportTechInfoXMLOutput'>");t.push("<label class='sapUiSupportLabel'>XML Output:</label>");t.push("<textarea id='"+r.getId()+"-outputE2ETrace'></textarea>");t.push("</div>")});n.push("</table></div>");this.$().html(n.join(""));this.$("tggleDbgSrc").on("click",function(t){t.preventDefault();this.confirmReload(function(){this._oStub.sendEvent(this._oStub.getMetadata().getClass().EventType.RELOAD_WITH_PARAMETER,{parameterName:"sap-ui-debug",parameterValue:!e.debug})}.bind(this))}.bind(this));this.$("Refresh").on("click",function(e){e.preventDefault();t.getStub().sendEvent(r.getId()+"Refresh",{})});this.$("outputE2ETrace").on("click",function(){this.focus();this.select()});this.$("startE2ETrace").on("click",function(){if(!r.e2eTraceStarted){r.e2eLogLevel=r.$("logLevelE2ETrace").val();r.$("startE2ETrace").addClass("active").text("Running...");r.$("outputE2ETrace").text("");t.getStub().sendEvent(r.getId()+"StartE2ETrace",{level:r.e2eLogLevel});r.e2eTraceStarted=true}});document.title="UI5 Diagnostics - "+e.title};c.prototype.onsapUiSupportTechInfoSetReboot=function(e){window.localStorage.setItem("sap-ui-reboot-URL",e.getParameter("rebootUrl"))};c.prototype.onsapUiSupportTechInfoStartE2ETrace=function(e){var o=this,i=e.getParameter("level");sap.ui.require(["sap/ui/core/support/trace/E2eTraceLib"],function(e){e.start(i,function(e){t.getStub().sendEvent(o.getId()+"FinishedE2ETrace",{trace:e})})},function(e){r.error("Could not load module 'sap/ui/core/support/trace/E2eTraceLib':",e)})};c.prototype.onsapUiSupportTechInfoFinishedE2ETrace=function(e){this.$("startE2ETrace").removeClass("active").text("Start");this.$("outputE2ETrace").text(e.getParameter("trace"));this.e2eTraceStarted=false};c.prototype.onsapUiSupportTechInfoRefresh=function(e){p(this)};c.prototype.init=function(t){e.prototype.init.apply(this,arguments);if(!this.runsAsToolPlugin()){p(this);return}this.$().html("No Information available")};function p(e){var r=o.getFrameworkInformation();var i={version:r.commonInformation.version,build:r.commonInformation.buildTime,change:r.commonInformation.lastChange,jquery:r.commonInformation.jquery,useragent:r.commonInformation.userAgent,docmode:r.commonInformation.documentMode,debug:r.commonInformation.debugMode,bootconfig:r.configurationBootstrap,config:r.configurationComputed,libraries:r.libraries,loadedLibraries:r.loadedLibraries,modules:r.loadedModules,uriparams:r.URLParameters,appurl:r.commonInformation.applicationHREF,title:r.commonInformation.documentTitle,statistics:r.commonInformation.statistics};var a=sap.ui.require("sap/ui/core/support/trace/E2eTraceLib");i["e2e-trace"]={isStarted:a?a.isStarted():false};t.getStub().sendEvent(e.getId()+"Data",{data:i})}function l(e){return e==null?"":s(String(e))}function d(e,t,o,r,i){e.push("<tr><td ",t?"align='right' ":"","valign='top'>","<label class='sapUiSupportLabel'>",l(r),"</label></td><td",o?" class='sapUiSupportTechInfoBorder'":"",">");var a=i;if(typeof i==="function"){a=i(e)}e.push(l(a));e.push("</td></tr>")}function f(e,t,o,r,i){d(e,t,o,r,function(e){e.push("<table border='0' cellspacing='0' cellpadding='3'>");jQuery.each(i,function(t,o){var r="";if(o){if(typeof o==="string"||typeof o==="string"||typeof o==="boolean"){r=o}else if(Array.isArray(o)||n(o)){r=JSON.stringify(o)}}d(e,false,false,t,""+r)});e.push("</table>")})}function h(e,t){var o=[];if(e){var r=/^(\d{4})(\d{2})(\d{2})-?(\d{2})(\d{2})$/.exec(e);if(r){e=r[1]+"-"+r[2]+"-"+r[3]+"T"+r[4]+":"+r[5]}o.push("built at "+l(e))}if(t){o.push("last change "+l(t))}return o.length===0?"":" ("+o.join(", ")+")"}return c});
//# sourceMappingURL=TechInfo.js.map